<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'question', language 'lo', version '4.0'.
 *
 * @package     question
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'ການປະຕິບັດ';
$string['addanotherhint'] = 'ເພີ່ມຄຳໃບ້ອື່ນ';
$string['addcategory'] = 'ເພີ່ມປະເພດ';
$string['addmorechoiceblanks'] = 'ບ່ອນຫວ່າງສຳລັບ {ບໍ່ມີ} ທາງເລືອກເພີ່ມເຕີມ';
$string['adminreport'] = 'ລາຍງານບັນຫາທີ່ເປັນໄປໄດ້ໃນຖານຂໍ້ມູນຄຳຖາມຂອງທ່ານ.';
$string['advancedsearchoptions'] = 'ທາງເລືອກການຄົ້ນຫາ';
$string['alltries'] = 'ຄວາມພະຍາຍາມທັງໝົດ';
$string['answer'] = 'ຄຳຕອບ';
$string['answers'] = 'ຄຳຕອບ';
$string['answersaved'] = 'ບັນທຶກຄຳຕອບແລ້ວ';
$string['attemptfinished'] = 'ສຳເລັດຄວາມພະຍາຍາມແລ້ວ';
$string['attemptfinishedsubmitting'] = 'ພະຍາຍາມສົ່ງສຳເລັດແລ້ວ: {$a}';
$string['attemptoptions'] = 'ທາງເລືອກການສົ່ງ';
$string['availableq'] = 'ມີໃຫ້ຫຼືບໍ';
$string['badbase'] = 'ພື້ນຖານບໍ່ດີມາກ່ອນ **:{$a}**';
$string['behaviour'] = 'ການປະພຶດ';
$string['behaviourbeingused'] = 'ການປະພຶດກຳລັງຖືກໃຊ້:';
$string['broken'] = 'ນີ້ແມ່ນ "ລິ້ງໃຊ້ການບໍ່ໄດ້", ມັນຊີ້ໄປຫາໄຟລ໌ທີ່ບໍ່ມີ.';
$string['byandon'] = 'ໂດຍ <em>{$a->user}</em> ໃນ <em>{$a->time}</em>';
$string['cannotcopybackup'] = 'ບໍ່ສາມາດສຳເນົາໄຟລ໌ສຳຮອງໄດ້';
$string['cannotcreate'] = 'ບໍ່ສາມາດສ້າງລາຍການໃໝ່ໃນຕາຕະລາງ question_attempts';
$string['cannotcreatepath'] = 'ບໍ່ສາມາດສ້າງເສັ້ນທາງ: {$a}';
$string['cannotdeletebehaviourinuse'] = 'ທ່ານບໍ່ສາມາດລຶບພຶດຕິກໍາ \'{$a}\' ໄດ້. ມັນຖືກໃຊ້ໂດຍການພະຍາຍາມຖາມ.';
$string['cannotdeletecate'] = 'ທ່ານບໍ່ສາມາດລຶບປະເພດນັ້ນອອກໄດ້, ມັນເປັນປະເພດເລີ່ມຕົ້ນສຳລັບບໍລິບົດນີ້.';
$string['cannotdeleteneededbehaviour'] = 'ບໍ່ສາມາດລຶບພຶດຕິກໍາຄໍາຖາມ \'{$a}\' ໄດ້. ມີພຶດຕິກໍາອື່ນຕິດຕັ້ງທີ່ອີງໃສ່ມັນ.';
$string['cannotdeleteqtypeinuse'] = 'ທ່ານບໍ່ສາມາດລຶບປະເພດຄຳຖາມ \'{$a}\' ໄດ້. ມີຄໍາຖາມປະເພດນີ້ຢູ່ໃນທະນາຄານຄໍາຖາມ.';
$string['cannotdeleteqtypeneeded'] = 'ທ່ານບໍ່ສາມາດລຶບປະເພດຄຳຖາມ \'{$a}\' ໄດ້. ມີປະເພດຄໍາຖາມອື່ນຕິດຕັ້ງທີ່ອີງໃສ່ມັນ.';
$string['cannotdeletetopcat'] = 'ປະເພດເທິງສຸດສາມາດຖືກລຶບ';
$string['cannotedittopcat'] = 'ປະເພດເທິງສຸດສາມາດຖືກແກ້ໄຂ';
$string['cannotenable'] = 'ປະເພດຄຳຖາມ {$a} ບໍ່ສາມາດສ້າງໄດ້ໂດຍກົງ.';
$string['cannotenablebehaviour'] = 'ພຶດຕິກໍາຄໍາຖາມ {$a} ບໍ່ສາມາດຖືກນໍາໃຊ້ໂດຍກົງ. ມັນແມ່ນສໍາລັບການນໍາໃຊ້ພາຍໃນເທົ່ານັ້ນ.';
$string['cannotfindcate'] = 'ບໍ່ສາມາດຊອກຫາປະເພດບັນທຶກ';
$string['cannotfindquestionfile'] = 'ບໍ່ສາມາດຊອກຫາໄຟລ໌ຂໍ້ມູນຄຳຖາມໃນ zip';
$string['cannotgetdsfordependent'] = 'ບໍ່ສາມາດເອົາຊຸດຂໍ້ມູນສະເພາະສໍາລັບຄໍາຖາມທີ່ຂຶ້ນກັບຊຸດຂໍ້ມູນໄດ້! (ຄໍາຖາມ: {$ a->id}, datasetitem: {$a->item})';
$string['cannotgetdsforquestion'] = 'ບໍ່ສາມາດເອົາຊຸດຂໍ້ມູນສະເພາະສໍາລັບຄໍາຖາມທີ່ຄໍານວນໄດ້! (ຄໍາຖາມ: {$a})';
$string['cannothidequestion'] = 'ບໍ່ສາມາດເຊື່ອງຄຳຖາມໄດ້';
$string['cannotimportformat'] = 'ຂໍອະໄພ, ການນຳເຂົ້າຮູບແບບນີ້ຍັງບໍ່ທັນຖືກຈັດຕັ້ງປະຕິບັດ!';
$string['cannotinsertquestion'] = 'ບໍ່ສາມາດໃສ່ຄຳຖາມໃໝ່ໄດ້!';
$string['cannotinsertquestioncatecontext'] = 'ບໍ່ສາມາດແຊກປະເພດຄຳຖາມໃສ່ປະເພດ {$a->cat} ບໍລິບົດຜິດກົດໝາຍ {$a->ctx}';
$string['cannotloadquestion'] = 'ບໍ່ສາມາດໂຫຼດຄຳຖາມ';
$string['cannotmovequestion'] = 'ທ່ານບໍ່ສາມາດໃຊ້ສະຄຣິບນີ້ ເພື່ອຍ້າຍຄໍາຖາມທີ່ມີໄຟລ໌ເຊື່ອມໂຍງກັບເຂົາເຈົ້າຈາກພື້ນທີ່ທີ່ແຕກຕ່າງ.';
$string['cannotopenforwriting'] = 'ບໍ່ສາມາດເປີດການຂຽນ : {$a}';
$string['cannotpreview'] = 'ທ່ານບໍ່ສາມາດເບິ່ງຄຳຖາມເຫຼົ່ານີ້ໄດ້!';
$string['cannotread'] = 'ບໍ່ສາມາດອ່ານໄຟລ໌ທີ່ນຳເຂົ້າ (ຫຼື ໄຟລ໌ທີ່ເປົ່າຫວ່າງ)';
$string['cannotregradedifferentqtype'] = 'ບໍ່ສາມາດໃຫ້ຄະແນນຄືນໃໝ່ກັບຄຳຖາມໃນປະເພດທີ່ແຕກຕ່າງກັນໄດ້.';
$string['cannotretrieveqcat'] = 'ບໍ່ສາມາດດຶງປະເພດຄຳຖາມ';
$string['cannotunhidequestion'] = 'ຢຸດເຊົາເຊື່ອງຄຳຖາມບໍ່ສຳເລັດ.';
$string['cannotunzip'] = 'ບໍ່ສາມາດຂະຫຍາຍໄຟລ໌.';
$string['cannotwriteto'] = 'ບໍ່ສາມາດຂຽນຂຽນຄຳຖາມທີ່ນຳເຂົ້າຫາ {$a}';
$string['categories'] = 'ບັນດາປະເພດ';
$string['category'] = 'ປະເພດ';
$string['categorycurrent'] = 'ປະເພດປະຈຸບັນ';
$string['categorycurrentuse'] = 'ໃຊ້ປະເພດນີ້';
$string['categorydoesnotexist'] = 'ບໍ່ມີປະເພດນີ້';
$string['categoryinfo'] = 'ຂໍ້ມູນປະເພດ';
$string['categorymove'] = 'ປະເພດ \'{$a->name}\' ມີ {$a->count} ຄຳຖາມ (ບາງຄຳຖາມອາດຈະເປັນຄຳຖາມເຊື່ອງໄວ້ ຫຼື ຄຳຖາມສຸ່ມທີ່ຍັງໃຊ້ຢູ່ໃນແບບທົດສອບ). ກະລຸນາເລືອກປະເພດອື່ນເພື່ອຍ້າຍພວກມັນໄປຫາ.';
$string['categorymoveto'] = 'ບັນທຶກໃນປະເພດ';
$string['categorynamecantbeblank'] = 'ຊື່ປະເພດບໍ່ສາມາເຫວ່າງເປົ່າ';
$string['categorynamewithcount'] = '{$a->name} ({$a->questioncount})';
$string['categorynamewithidnumber'] = '{$a->name} [{$a->idnumber}]';
$string['categorynamewithidnumberandcount'] = '{$a->name} [{$a->idnumber}] ({$a->questioncount})';
$string['changeoptions'] = 'ທາງເລືອກການປ່ຽນແປງ';
$string['changepublishstatuscat'] = '<a href="{$a->caturl}">ປະເພດ "{$a->name}"</a> ໃນລາຍວິຊາ "{$a->coursename}" ຈະມີການປ່ຽນແປງສະຖານະການແບ່ງປັນຈາກ {$a->changefrom} ເປັນ {$a->changeto}.';
$string['check'] = 'ກວດສອບ';
$string['chooseqtypetoadd'] = 'ເລືອກປະເພດຄຳຖາມເພື່ອເພີ່ມ';
$string['clearwrongparts'] = 'ລົບລ້າງການຕອບໂຕ້ທີ່ບໍ່ຖືກຕ້ອງ';
$string['clickflag'] = 'ໝາຍທຸງຄຳຖາມ';
$string['clicktoflag'] = 'ໝາຍທຸງຄຳຖາມນີ້ສຳລັບການອ້າງອີງໃນອານາຄົດ';
$string['clicktounflag'] = 'ລຶບໝາຍທຸງ';
$string['clickunflag'] = 'ລຶບໝາຍທຸງ';
$string['closepreview'] = 'ປິດໜ້າຕ່າງ';
$string['combinedfeedback'] = 'ລວມຄຳຕິຊົມແລ້ວ';
$string['comment'] = 'ຄຳເຫັນ';
$string['commented'] = 'ໃຫ້ຄຳເຫັນແລ້ວ: {$a}';
$string['commentormark'] = 'ໃຫ້ຄຳເຫັນ ຫຼື ລົບລ້າງການໝາຍ';
$string['comments'] = 'ບັນດາຄຳເຫັນ';
$string['commentx'] = 'ຄຳເຫັນ: {$a}';
$string['complete'] = 'ສຳເລັດ';
$string['contexterror'] = 'ທ່ານບໍ່ຄວນມາຮອດບ່ອນນີ້ ຖ້າທ່ານບໍ່ຍ້າຍປະເພດໄປຫາສະພາບການອື່ນ.';
$string['copy'] = 'ສຳເນົາຈາກ {$a} ແລະ ປ່ຽນລິ້ງ.';
$string['correct'] = 'ຖືກຕ້ອງ';
$string['correctfeedback'] = 'ສຳລັບການໂຕ້ຕອບທີ່ຖືກຕ້ອງໃດໜຶ່ງ';
$string['correctfeedbackdefault'] = 'ຄຳຕອບຂອງທ່ານແມ່ນຖືກຕ້ອງ';
$string['created'] = 'ສ້າງແລ້ວ';
$string['createdby'] = 'ສ້າງໂດຍ';
$string['createdmodifiedheader'] = 'ສ້າງແລ້ວ / ບັນທຶກຫຼ້າສຸດ';
$string['createnewquestion'] = 'ສ້າງຄຳຖາມໃໝ່ແລ້ວ...';
$string['cwrqpfs'] = 'ຄໍາຖາມສຸ່ມເລືອກຄໍາຖາມຈາກປະເພດຍ່ອຍ.';
$string['cwrqpfsinfo'] = '<p> ໃນລະຫວ່າງການຍົກລະດັບເປັນ Moodle 1.9 ພວກເຮົາຈະແຍກປະເພດຄໍາຖາມອອກເປັນສະພາບການທີ່ແຕກຕ່າງກັນ. ບາງປະເພດຄຳຖາມ ແລະ ຄຳຖາມຢູ່ໃນເວັບໄຊທ໌ຂອງທ່ານຈະຕ້ອງມີການແບ່ງປັນຂອງເຂົາເຈົ້າໃນສະຖານະພາບມີການປ່ຽນແປງ. ສິ່ງນີ້ແມ່ນມີຄວາມຈໍາເປັນໃນກໍລະນີທີ່ຫາຍາກທີ່ຄໍາຖາມແບບສຸ່ມໜຶ່ງ ຫຼື ຫຼາຍຄໍາຖາມໄດ້ຖືກຕັ້ງຂຶ້ນເພື່ອເລືອກຈາກການປະສົມຂອງ
ປະເພດທີ່ແບ່ງປັນ ແລະ ບໍ່ໄດ້ແບ່ງປັນ (ຄືກັບກໍລະນີຢູ່ໃນເວັບໄຊທ໌ນີ້). ສິ່ງນີ້ເກີດຂຶ້ນເມື່ອມີການຕັ້ງຄຳຖາມ \'ສຸ່ມ\' ເພື່ອເລືອກ
ຈາກປະເພດຍ່ອຍ ແລະ ໜຶ່ງ ຫຼື ຫຼາຍປະເພດຍ່ອຍມີສະຖານະການແບ່ງປັນທີ່ແຕກຕ່າງກັນໄປຫາປະເພດຫຼັກຄໍາຖາມແບບສຸ່ມຖືກສ້າງຂຶ້ນ.</p>
<p>ປະເພດຄຳຖາມຕໍ່ໄປນີ້, ຈາກທີ່ຄຳຖາມ \'ສຸ່ມ\' ຢູ່ໃນປະເພດຫຼັກເລືອກຄຳຖາມຈາກ,
ສະຖານະການແບ່ງປັນຂອງເຂົາເຈົ້າຈະຖືກປ່ຽນເປັນສະຖານະການແບ່ງປັນຄືກັນກັບປະເພດທີ່ມີຄໍາຖາມ \'ສຸ່ມ\' ຢູ່ໃນ
ໃນການຍົກລະດັບເປັນ Moodle 1.9. ປະເພດຕໍ່ໄປນີ້ຈະມີການປ່ຽນແປງສະຖານະການແບ່ງປັນຂອງເຂົາເຈົ້າ. ຄໍາຖາມທີ່ມີຜົນກະທົບຈະສືບຕໍ່ເຮັດວຽກຢູ່ໃນແບບທົດສອບທັງໝົດທີ່ມີຢູ່ຈົນກວ່າທ່ານຈະເອົາພວກມັນອອກຈາກແບບທົດສອບເຫຼົ່ານີ້.</p>';
$string['cwrqpfsnoprob'] = 'ບໍ່ມີປະເພດຄຳຖາມຢູ່ໃນເວັບໄຊທ໌ຂອງທ່ານໄດ້ຮັບຜົນກະທົບຈາກບັນຫາ \'ການສຸ່ມເລືອກຄຳຖາມຈາກປະເພດຍ່ອຍ\'.';
$string['decimalplacesingrades'] = 'ຕຳແໜ່ງທົດສະນິຍົມໃນຄະແນນ';
$string['defaultfor'] = 'ຄ່າເລີ່ມຕົ້ນສຳລັບ {$a}';
$string['defaultinfofor'] = 'ປະເພດເລີ່ມຕົ້ນສໍາລັບຄໍາຖາມທີ່ແບ່ງປັນຢູ່ໃນບໍລິບົດ \'{$a}\'.';
$string['defaultmark'] = 'ການໝາຍຄ່າເລີ່ມຕົ້ນ';
$string['defaultmarkmustbepositive'] = 'ເຄື່ອງໝາຍເລີ່ມຕົ້ນຕ້ອງເປັນຄ່າບວກ.';
$string['deletecoursecategorywithquestions'] = 'ມີຄໍາຖາມຢູ່ໃນທະນາຄານຄໍາຖາມທີ່ກ່ຽວຂ້ອງກັບປະເພດລາຍວິຊານີ້. ຖ້າທ່ານດຳເນີນການຕໍ່, ພວກມັນຈະຖືກລຶບອອກ. ທ່ານອາດຈະຕ້ອງການຍ້າຍພວກມັນກ່ອນ, ໂດຍໃຊ້ການໂຕ້ຕອບຂອງທະນາຄານຄຳຖາມ.';
$string['deletequestioncheck'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການລຶບ \'{$a}\'?';
$string['deletequestionscheck'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການລຶບຄໍາຖາມຕໍ່ໄປນີ້ອອກ? <br /><br />{$ a}';
$string['deletingbehaviour'] = 'ກຳລັງລຶບພຶດຕິກຳຄຳຖາມ \'{$a}\'';
$string['deletingqtype'] = 'ກຳລັງລຶບປະເພດຄຳຖາມ \'{$a}\'';
$string['didnotmatchanyanswer'] = '[ບໍ່ກົງກັບຄໍາຕອບໃດ]';
$string['disabled'] = 'ປິດໃຊ້ງານ';
$string['displayoptions'] = 'ທາງເລືອກການສະແດງ';
$string['disterror'] = 'ການແຈກຍາຍ {$a} ເກີດບັນຫາ';
$string['donothing'] = 'ຢ່າສຳເນົາ ຫຼື ຍ້າຍໄຟລ໌ ຫຼື ປ່ຽນລິ້ງ.';
$string['editcategories'] = 'ແກ້ໄຂປະເພດ';
$string['editcategories_help'] = 'ແທນທີ່ຈະຮັກສາທຸກຢ່າງໄວ້ໃນບັນຊີໃຫຍ່, ຄໍາຖາມອາດຈະຖືກຈັດເປັນປະເພດ ແລະ ປະເພດຍ່ອຍ.

ແຕ່ລະປະເພດມີບໍລິບົດເຊິ່ງກໍານົດວ່າຄໍາຖາມຢູ່ໃນປະເພດໃດສາມາດໃຊ້ໄດ້:

* ສະພາບການເຄື່ອນໄຫວ - ຄໍາຖາມມີຢູ່ໃນໂມດູນກິດຈະກໍາເທົ່ານັ້ນ
* ສະພາບລາຍວິຊາ - ຄໍາຖາມທີ່ມີຢູ່ໃນທຸກຊຸດກິດຈະກໍາຢູ່ໃນລາຍວິຊາ
* ສະພາບປະເພດລາຍວິຊາ - ຄໍາຖາມທີ່ມີຢູ່ໃນທຸກຊຸດກິດຈະກໍາ ແລະ ລາຍວິຊາຢູ່ໃນປະເພດລາຍວິຊາ
* ສະພາບຂອງລະບົບ - ຄຳຖາມມີຢູ່ໃນທຸກວິຊາ ແລະ ກິດຈະກຳ ຢູ່ໃນເວັບໄຊທ໌

ປະເພດຕ່າງໆຍັງຖືກໃຊ້ສຳລັບຄຳຖາມແບບສຸ່ມ, ເນື່ອງຈາກຄຳຖາມຖືກເລືອກຈາກປະເພດສະເພາະ.';
$string['editcategories_link'] = 'question/category';
$string['editcategory'] = 'ແກ້ໄຂປະເພດ';
$string['editingcategory'] = 'ກຳລັງແກ້ໄຂປະເພດ';
$string['editingquestion'] = 'ກຳລັງແກ້ໄຂຄຳຖາມ';
$string['editquestion'] = 'ແກ້ໄຂຄຳຖາມ';
$string['editquestions'] = 'ແກ້ໄຂຄຳຖາມ';
$string['editthiscategory'] = 'ແກ້ໄຂປະເພດນີ້';
$string['emptyxml'] = 'ຂໍ້ຜິດພາດບໍ່ຮູ້ຈັກ - imsmanifest.xml ຫວ່າງເປົ່າ';
$string['enabled'] = 'ເປີດໃຊ້ງານ';
$string['erroraccessingcontext'] = 'ບໍ່ສາມາດເຂົ້າຫາບໍລິບົດ';
$string['errordeletingquestionsfromcategory'] = 'ການລຶບຄຳຖາມຈາກປະເພດຜິດພາດ {$a}.';
$string['errorduringpost'] = 'ເກີດຄວາມຜິດພາດໃນລະຫວ່າງການປະມວນຜົນພາຍຫຼັງ!';
$string['errorduringpre'] = 'ເກີດຄວາມຜິດພາດໃນລະຫວ່າງການປະມວນຜົນລ່ວງໜ້າ!';
$string['errorduringproc'] = 'ເກີດຄວາມຜິດພາດໃນລະຫວ່າງການປະມວນຜົນ!';
$string['errorduringregrade'] = 'ບໍ່ສາມາດຈັດລໍາດັບຄໍາຖາມ {$a->qid} ຄືນໄດ້, ໄປຫາລັດ {$a->stateid}.';
$string['errorfilecannotbecopied'] = 'ຜິດພາດ: ບໍ່ສາມາດສຳເນົາໄຟລ໌ {$a}.';
$string['errorfilecannotbemoved'] = 'ຜິດພາດ: ບໍ່ສາມາດຍ້າຍໄຟລ໌ {$a}.';
$string['errorfileschanged'] = 'ຜິດພາດ: ໄຟລ໌ທີ່ເຊື່ອມຕໍ່ຫາຈາກຄຳຖາມໄດ້ມີການປ່ຽນແປງຕັ້ງແຕ່ການສະແດງແບບຟອມ.';
$string['erroritemappearsmorethanoncewithdifferentweight'] = 'ຄຳຖາມ ({$a}) ປາກົດຫຼາຍກວ່າໜຶ່ງຄັ້ງໂດຍມີນໍ້າໜັກແຕກຕ່າງກັນໃນຕຳແໜ່ງທີ່ແຕກຕ່າງຂອງການທົດສອບ. ປະຈຸບັນສິ່ງນີ້ບໍ່ໄດ້ຮັບການສະໜັບສະໜູນຈາກລາຍງານສະຖິຕິ ແລະ ອາດຈະເຮັດໃຫ້ສະຖິຕິສໍາລັບຄໍາຖາມນີ້ບໍ່ໜ້າເຊື່ອຖືໄດ້.';
$string['errormanualgradeoutofrange'] = 'ຄະແນນ {$a->grade} ບໍ່ຢູ່ລະຫວ່າງ 0 ຫາ {$a->maxgrade} ສຳລັບຄຳຖາມ {$a->name}. ຄະແນນ ແລະ ຄຳເຫັນບໍ່ໄດ້ຖືກບັນທຶກໄວ້.';
$string['errormovingquestions'] = 'ເກີດຄວາມຜິດພາດໃນຂະນະຍ້າຍຄຳຖາມດ້ວຍລະຫັດປະຈຳຕົວ {$a}.';
$string['errorpostprocess'] = 'ເກີດຄວາມຜິດພາດໃນລະຫວ່າງການປະມວນຜົນພາຍຫຼັງ!';
$string['errorpreprocess'] = 'ເກີດຄວາມຜິດພາດໃນລະຫວ່າງການປະມວນຜົນລ່ວງໜ້າ!';
$string['errorprocess'] = 'ເກີດຄວາມຜິດພາດໃນລະຫວ່າງການປະມວນຜົນ!';
$string['errorprocessingresponses'] = 'ເກີດຄວາມຜິດພາດຂຶ້ນໃນຂະນະທີ່ກໍາລັງປະມວນຜົນຄໍາຕອບຂອງທ່ານ ({$a}). ຄລິກສືບຕໍ່ເພື່ອກັບຄືນຫາໜ້າທີ່ທ່ານຢູ່ ແລະ ລອງໃໝ່ອີກ.';
$string['errorsavingcomment'] = 'ເກີດຄວາມຜິດພາດໃນການບັນທຶກຄຳເຫັນສຳລັບຄຳຖາມ {$a->name} ໃນຖານຂໍ້ມູນ.';
$string['errorsavingflags'] = 'ຜິດພາດໃນການບັນທຶກສະຖານະໝາຍທຸງ';
$string['errorupdatingattempt'] = 'ຜິດພາດໃນການປັບປຸງຄວາມພະຍາຍາມ {$a->id} ໃນຖານຂໍ້ມູນ.';
$string['eventquestioncategorycreated'] = 'ສ້າງປະເພດຄຳຖາມແລ້ວ';
$string['eventquestioncategorydeleted'] = 'ລຶບປະເພດຄຳຖາມແລ້ວ';
$string['eventquestioncategorymoved'] = 'ຍ້າຍປະເພດຄຳຖາມແລ້ວ';
$string['eventquestioncategoryupdated'] = 'ປັບປຸງປະເພດຄຳຖາມແລ້ວ';
$string['eventquestioncategoryviewed'] = 'ເບິ່ງປະເພດຄຳຖາມແລ້ວ';
$string['eventquestioncreated'] = 'ສ້າງຄຳຖາມແລ້ວ';
$string['eventquestiondeleted'] = 'ລຶບຄຳຖາມແລ້ວ';
$string['eventquestionmoved'] = 'ຍ້າຍຄຳຖາມແລ້ວ';
$string['eventquestionsexported'] = 'ສົ່ງອອກຄຳຖາມແລ້ວ';
$string['eventquestionsimported'] = 'ນຳເຂົ້າຄຳຖາມແລ້ວ';
$string['eventquestionupdated'] = 'ປັບປຸງຄຳຖາມແລ້ວ';
$string['eventquestionviewed'] = 'ເບິ່ງຄຳຖາມແລ້ວ';
$string['export'] = 'ສົ່ງອອກ';
$string['exportasxml'] = 'ສົ່ງອອກເປັນ Moodle XML';
$string['exportcategory'] = 'ປະເພດການສົ່ງອອກ';
$string['exportcategory_help'] = 'ການຕັ້ງຄ່ານີ້ກຳນົດປະເພດຈາກຄຳຖາມທີ່ຖືກສົ່ງອອກໄປ.

ຮູບແບບການນຳເຂົ້າບາງອັນເຊັ່ນ: GIFT ແລະ Moodle XML, ອະນຸຍາດຂໍ້ມູນປະເພດ ແລະ ບໍລິບົດໃຫ້ຖືກລວມເຂົ້າໃນໄຟລ໌ການສົ່ງອອກ, ເຮັດໃຫ້ພວກມັນສາມາດສ້າງໃໝ່ໄດ້ (ເປັນທາງເລືອກ) ໃນການນໍາເຂົ້າ. ຖ້າຕ້ອງການ, ໝາຍຖືກໃສ່ກ່ອງທີ່ເໝາະສົມ.';
$string['exporterror'] = 'ຄວາມຜິດພາດເກີດຂຶ້ນໃນລະຫວ່າງການສົ່ງອອກ!';
$string['exportfilename'] = 'ຄຳຖາມ';
$string['exportnameformat'] = '%Y%m%d-%H%M';
$string['exportonequestion'] = 'ດາວໂຫຼດຄຳຖາມນີ້ໃນຮູບແບບ Moodle XML';
$string['exportquestions'] = 'ສົ່ງອອກຄຳຖາມໄປຫາໄຟລ໌';
$string['exportquestions_help'] = 'ໜ້າທີ່ນີ້ເຮັດໃຫ້ສາມາດສົ່ງອອກປະເພດທີ່ຄົບຖ້ວນ (ແລະ ປະເພດຍ່ອຍໃດໜຶ່ງ) ຂອງຄຳຖາມທີ່ຈະຍື່ນ. ກະລຸນາຮັບຊາບວ່າ, ຂຶ້ນກັບຮູບແບບໄຟລ໌ທີ່ເລືອກ, ບາງຂໍ້ມູນຄໍາຖາມ ແລະ ບາງປະເພດຄໍາຖາມອາດຈະບໍ່ຖືກສົ່ງອອກ.';
$string['exportquestions_link'] = 'question/export';
$string['feedback'] = 'ຄຳຕິຊົມ';
$string['filecantmovefrom'] = 'ບໍ່ສາມາດຍ້າຍໄຟລ໌ຄຳຖາມໄດ້ເພາະວ່າທ່ານບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ລຶບໄຟລ໌ອອກຈາກບ່ອນທີ່ທ່ານກຳລັງພະຍາຍາມຍ້າຍຄຳຖາມຈາກ.';
$string['filecantmoveto'] = 'ບໍ່ສາມາດຍ້າຍ ຫຼື ສຳເນົາໄຟລ໌ຄຳຖາມໄດ້ເພາະວ່າທ່ານບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ເພີ່ມໄຟລ໌ໃສ່ບ່ອນທີ່ເຈົ້າກຳລັງພະຍາຍາມຍ້າຍຄຳຖາມໄປຫາ.';
$string['fileformat'] = 'ຮູບແບບໄຟລ໌';
$string['filesareacourse'] = 'ພື້ນທີ່ໄຟລ໌ລາຍວິຊາ';
$string['filesareasite'] = 'ພື້ນທີ່ໄຟລ໌ເວັບໄຊທ໌';
$string['filestomove'] = 'ຍ້າຍ / ສຳເນົາໄຟລ໌ໄປຫາ {$a} ບໍ?';
$string['fillincorrect'] = 'ຕື່ມການໂຕ້ຕອບໃຫ້ຖືກຕ້ອງ';
$string['filterbytags'] = 'ຕົວກັ່ນຕອງໂດຍແທັກ...';
$string['firsttry'] = 'ທົດລອງຄັ້ງທຳອິດ';
$string['flagged'] = 'ໝາຍທຸງແລ້ວ';
$string['flagthisquestion'] = 'ໝາຍທຸງຄຳຖາມນີ້';
$string['formquestionnotinids'] = 'ແບບຟອມປະກອບມີຄໍາຖາມທີ່ບໍ່ຢູ່ໃນ questionids';
$string['fractionsnomax'] = 'ໜຶ່ງໃນຄຳຕອບຄວນມີຄະແນນ 100% ສະນັ້ນມັນເປັນໄປໄດ້ທີ່ຈະໄດ້ຄະແນນເຕັມສຳລັບຄຳຖາມນີ້.';
$string['generalfeedback'] = 'ຄຳຕິຊົມທົ່ວໄປ';
$string['generalfeedback_help'] = 'ຄຳຕິຊົມທົ່ວໄປແມ່ນສະແດງໃຫ້ນັກຮຽນເຫັນຫຼັງຈາກເຂົາເຈົ້າຕອບຄຳຖາມແລ້ວ. ຕ່າງຈາກຄຳຕິຊົມສະເພາະ, ເຊິ່ງຂຶ້ນກັບປະເພດຄຳຖາມ ແລະ ຄຳຕອບຂອງນັກຮຽນໃຫ້, ຂໍ້ຄວາມຄຳຕິຊົມທົ່ວໄປອັນດຽວກັນແມ່ນສະແດງໃຫ້ນັກຮຽນທຸກຄົນເຫັນ.

ທ່ານສາມາດໃຊ້ຄໍາຄິດເຫັນທົ່ວໄປເພື່ອໃຫ້ຄໍາຕອບແກ່ນັກຮຽນໄດ້ຢ່າງເຕັມທີ່ ແລະ ບາງທີອາດເປັນຕົວເຊື່ອມຕໍ່ຫາຂໍ້ມູນເພີ່ມເຕີມທີ່ເຂົາເຈົ້າສາມາດໃຊ້ໄດ້ ຖ້າເຂົາເຈົ້າບໍ່ເຂົ້າໃຈຄໍາຖາມ.';
$string['getcategoryfromfile'] = 'ເອົາປະເພດຈາກໄຟລ໌';
$string['getcontextfromfile'] = 'ເອົາບໍລິບົດຈາກໄຟລ໌';
$string['hintn'] = 'ຄຳໃບ້ {no}';
$string['hintnoptions'] = 'ທາງເລືອກຄຳໃບ້ {no}';
$string['hinttext'] = 'ຄຳໃບ້';
$string['howquestionsbehave'] = 'ຄຳຖາມປະພຶດຕົວແນວໃດ';
$string['howquestionsbehave_help'] = 'ນັກຮຽນສາມາດພົວພັນກັບຄໍາຖາມຢູ່ໃນແບບທົດສອບດ້ວຍວິທີທີ່ແຕກຕ່າງ. ຕົວຢ່າງ, ທ່ານອາດຈະຕ້ອງການໃຫ້ນັກຮຽນຂຽນຄໍາຕອບໃຫ້ກັບແຕ່ລະຄໍາຖາມ ແລະ ຈາກນັ້ນສົ່ງຄໍາຖາມທັງໝົດ, ກ່ອນທີ່ຈະມີອັນໃດໃຫ້ຄະແນນ ຫຼື ເຂົາເຈົ້າໄດ້ຮັບຄໍາຕິຊົມ. ນັ້ນຈະເປັນໂໝດ \'ຄໍາຕິຊົມເຍື້ອນເວລາ\'.

ອີກທາງເລືອກໜຶ່ງ, ທ່ານອາດຈະຕ້ອງການໃຫ້ນັກຮຽນສົ່ງຄໍາຖາມແຕ່ລະອັນຍ້ອນວ່າເຂົາເຈົ້າໄປພ້ອມກັນເພື່ອໃຫ້ໄດ້ຮັບຄໍາຕິຊົມທັນທີ ແລະ ຖ້າເຂົາເຈົ້າບໍ່ຕອບຖືກຕ້ອງໃນທັນທີ, ໃຫ້ມີການພະຍາຍາມອີກເທື່ອໜຶ່ງເພື່ອໃຫ້ໄດ້ຄະແນນໜ້ອຍລົງ. ນັ້ນຈະເປັນໂໝດ \'ການໂຕ້ຕອບກັບຄວາມພະຍາຍາມຫຼາຍອັນ\'.

ສິ່ງເຫຼົ່ານັ້ນອາດຈະເປັນສອງຮູບແບບພຶດຕິກຳທີ່ໃຊ້ຫຼາຍທີ່ສຸດ.';
$string['howquestionsbehave_link'] = 'question/behaviour';
$string['idnumber'] = 'ໝາຍເລກລະຫັດປະຈຳຕົວ';
$string['idnumber_help'] = 'ຖ້າໃຊ້, ໝາຍເລກລະຫັດປະຈຳຕົວຈະຕ້ອງບໍ່ຊໍ້າກັນພາຍໃນແຕ່ລະປະເພດຄໍາຖາມ. ມັນສະໜອງວິທີອື່ນໃນການລະບຸຄໍາຖາມທີ່ບາງຄັ້ງມີປະໂຫຍດ, ແຕ່ໂດຍປົກກະຕິແລ້ວສາມາດປະຫວ່າງໄວ້ໄດ້.';
$string['ignorebroken'] = 'ບໍ່ສົນໃຈລິ້ງໃຊ້ບໍ່ໄດ້';
$string['import'] = 'ນຳເຂົ້າ';
$string['importcategory'] = 'ນຳເຂົ້າປະເພດ';
$string['importcategory_help'] = 'ການຕັ້ງຄ່ານີ້ກໍານົດປະເພດທີ່ຄໍາຖາມທີ່ນໍາເຂົ້າຈະໄປ.

ຮູບແບບການນຳເຂົ້າສະເພາະ, ເຊັ່ນ: GIFT ແລະ Moodle XML, ອາດຈະລວມມີຂໍ້ມູນປະເພດ ແລະ ບໍລິບົດຢູ່ໃນໄຟລ໌ການນໍາເຂົ້າ. ເພື່ອໃຊ້ຂໍ້ມູນນີ້, ແທນທີ່ຈະເປັນປະເພດທີ່ເລືອກ, ກ່ອງໝາຍຖືກທີ່ເໝາະສົມຄວນຖືກໝາຍຖືກ. ຖ້າບໍ່ມີປະເພດທີ່ລະບຸໄວ້ໃນໄຟລ໌ນຳເຂົ້າ, ພວກມັນຈະຖືກສ້າງຂຶ້ນ.';
$string['importerror'] = 'ເກີດຄວາມຜິດພາດຂຶ້ນໃນລະຫວ່າງການປະມວນຜົນການນໍາເຂົ້າ';
$string['importerrorquestion'] = 'ເກີດຄວາມຜິດພາດໃນການນຳເຂົ້າຄຳຖາມ';
$string['importfromcoursefiles'] = '... ຫຼື ເລືອກໄຟລ໌ລາຍວິຊາເພື່ອນໍາເຂົ້າ.';
$string['importfromupload'] = 'ເລືອກໄຟລ໌ເພື່ອອັບໂຫຼດ ...';
$string['importingquestions'] = 'ກຳລັງນຳເຂົ້າຄຳຖາມ {$a} ຈາກໄຟລ໌';
$string['importparseerror'] = 'ພົບການວິເຄາະໄຟລ໌ນຳເຂົ້າຜິດພາດ. ບໍ່ມີຄຳຖາມຖືກນຳເຂົ້າມາ. ເພື່ອນໍາເຂົ້າຄໍາຖາມທີ່ດີໃຫ້ລອງອີກຄັ້ງການຕັ້ງ \'ຢຸດຢູ່ເທິງຄວາມຜິດພາດ\' ເປັນ \'ບໍ່\'';
$string['importquestions'] = 'ນຳເຂົ້າຄຳຖາມຈາກໄຟລ໌';
$string['importquestions_help'] = 'ການໃຊ້ງານນີ້ເຮັດໃຫ້ມີຄໍາຖາມໃນຮູບແບບທີ່ຫຼາກຫຼາຍທີ່ຈະນໍາເຂົ້າຜ່ານໄຟລ໌ຂໍ້ຄວາມ. ກະລຸນາຮັບຊາບວ່າໄຟລ໌ຕ້ອງໃຊ້ການເຂົ້າລະຫັດ UTF-8.';
$string['importquestions_link'] = 'question/import';
$string['importwrongfileencoding'] = 'ໄຟລ໌ທີ່ທ່ານໄດ້ເລືອກບໍ່ໄດ້ໃຊ້ການເຂົ້າລະຫັດຕົວໜັງສື UFT-8. ໄຟລ໌ {$a} ຕ້ອງນຳໃຊ້ UFT-8.';
$string['importwrongfiletype'] = 'ປະເພດຂອງໄຟລ໌ທີ່ທ່ານເລືອກ ({$a->actualtype}) ບໍ່ກົງກັບປະເພດທີ່ຄາດໄວ້ໂດຍຮູບແບບການນໍາເຂົ້ານີ້ ({$a->expectedtype}).';
$string['impossiblechar'] = 'ກວດພົບຕົວອັກສອນທີ່ເປັນໄປບໍ່ໄດ້ {$a} ເປັນຕົວອັກສອນວົງເລັບ';
$string['includesubcategories'] = 'ຍັງສະແດງຄຳຖາມຈາກປະເພດຍ່ອຍ';
$string['incorrect'] = 'ບໍ່ຖືກຕ້ອງ';
$string['incorrectfeedback'] = 'ສຳລັບການໂຕ້ຕອບທີ່ບໍ່ຖືກຕ້ອງໃດໜຶ່ງ';
$string['incorrectfeedbackdefault'] = 'ຄຳຕອບຂອງທ່ານບໍ່ຖືກຕ້ອງ';
$string['information'] = 'ຂໍ້ມູນ';
$string['invalidanswer'] = 'ຄຳຕອບບໍ່ສົມບູນ';
$string['invalidarg'] = 'ບໍ່ມີອາກິວເມັນທີ່ສະໜອງໃຫ້ຖືກຕ້ອງ ຫຼື ການຕັ້ງຄ່າເຊີບເວີບໍ່ຖືກຕ້ອງ';
$string['invalidcategoryidforparent'] = 'ລະຫັດປະຈຳຕົວປະເພດບໍ່ຖືກຕ້ອງສຳລັບຕົວຫຼັກ!';
$string['invalidcategoryidtomove'] = 'ລະຫັດປະຈຳຕົວປະເພດບໍ່ຖືກຕ້ອງເພື່ອຍ້າຍ!';
$string['invalidconfirm'] = 'ສະຕຣິງການຢືນຢັນບໍ່ຖືກຕ້ອງ';
$string['invalidcontextinhasanyquestions'] = 'ບໍລິບົດບໍ່ຖືກຕ້ອງຖືກສົ່ງໄປຫາ question_context_has_any_questions.';
$string['invalidgrade'] = 'ຄະແນນ ({$a}) ບໍ່ກົງກັບຕົວເລືອກຄະແນນ - ຂ້າມຄຳຖາມໄປແລ້ວ.';
$string['invalidpenalty'] = 'ການລົງໂທດບໍ່ຖືກຕ້ອງ';
$string['invalidwizardpage'] = 'ບໍ່ຖືກຕ້ອງ ຫຼື ບໍ່ມີໜ້າຕົວຊ່ວຍກໍານົດໄວ້!';
$string['lastmodifiedby'] = 'ດັດແກ້ຫຼ້າສຸດໂດຍ';
$string['lasttry'] = 'ການພະຍາຍາມລ້າສຸດ';
$string['linkedfiledoesntexist'] = 'ບໍ່ມີໄຟລ໌ {$a} ທີ່ເຊື່ອມໂຍງແລ້ວ';
$string['makechildof'] = 'ສ້າງລູກ \'{$a}\'';
$string['makecopy'] = 'ເຮັດສຳເນົາ';
$string['maketoplevelitem'] = 'ຍ້າຍຂື້ນໄປລະດັບເທິງສຸດ';
$string['manualgradeinvalidformat'] = 'ນີ້ບໍ່ແມ່ນໝາຍເລກທີ່ຖືກຕ້ອງ.';
$string['manualgradeoutofrange'] = 'ຄະແນນນີ້ຢູ່ຂ້າງນອກໄລຍະທີ່ຖືກຕ້ອງ';
$string['manuallygraded'] = 'ໃຫ້ຄະແນນດ້ວຍຕົນເອງ {$a->mark} ພ້ອມຄໍາເຫັນ: {$a->ຄໍາເຫັນ}';
$string['mark'] = 'ໝາຍ';
$string['markedoutof'] = 'ໝາຍດ້ວຍ';
$string['markedoutofmax'] = 'ໝາຍດ້ວຍ {$a}';
$string['markoutofmax'] = 'ໝາຍ {$a->mark} ດ້ວຍ {$a->max}';
$string['marks'] = 'ໝາຍ';
$string['matchgrades'] = 'ໝາຍຄະແນນ';
$string['matchgrades_help'] = 'ຄະແນນທີ່ນຳເຂົ້າມາຕ້ອງກົງກັບໜຶ່ງໃນບັນຊີລາຍຊື່ຄົງທີ່ຂອງຍົກລະດັບທີ່ຖືກຕ້ອງ - 100, 90, 80, 75, 70, 66.666, 60, 50, 40, 33.333, 30, 25, 20, 16.666, 14.2857, 12.5, 11.111, 10, 5 , 0 (ຍັງມີຄ່າລົບ). ຖ້າບໍ່, ມີສອງທາງເລືອກ:

* ຜິດພາດຖ້າຄະແນນບໍ່ມີໃນລາຍການ - ຖ້າຄໍາຖາມມີຄະແນນອັນໃດທີ່ບໍ່ພົບຢູ່ໃນລາຍການ, ຂໍ້ຜິດພາດຈະຖືກສະແດງ ແລະ ຄໍາຖາມນັ້ນຈະບໍ່ຖືກນໍາເຂົ້າມາ.
* ຄະແນນທີ່ຢູ່ໃກ້ທີ່ສຸດຖ້າບໍ່ມີໃນລາຍການ - ຖ້າພົບວ່າຄະແນນບໍ່ກົງກັບຄ່າໃນລາຍການ, ຄະແນນຈະຖືກປ່ຽນເປັນຄ່າທີ່ກົງກັນທີ່ສຸດຢູ່ໃນລາຍການ';
$string['matchgradeserror'] = 'ຜິດພາດຖ້າບໍ່ມີລາຍການຄະແນນ';
$string['matchgradesnearest'] = 'ຄະແນນທີ່ຢູ່ໃກ້ທີ່ສຸດຖ້າບໍ່ມີໃນລາຍການ';
$string['missingcourseorcmid'] = 'ຕ້ອງການໃຫ້ courseid ຫຼື cmid ໃຫ້ກັບ print_question.';
$string['missingcourseorcmidtolink'] = 'ຕ້ອງການໃຫ້ courseid ຫຼື cmid ໃຫ້ກັບ get_question_edit_link.';
$string['missingimportantcode'] = 'ປະເພດຄຳຖາມນີ້ຂາດລະຫັດທີ່ສຳຄັນ: {$a}.';
$string['missingoption'] = 'ຄໍາຖາມ cloze {$a} ຂາດຫາຍສູນເສຍຕົວເລືອກຂອງມັນ';
$string['modified'] = 'ການບັນທຶກຄັ້ງສຸດທ້າຍ';
$string['move'] = 'ຍ້າຍຈາກ {$a} ແລະ ປ່ຽນລິ້ງ.';
$string['movecategory'] = 'ຍ້າຍປະເພດ';
$string['movedquestionsandcategories'] = 'ຍ້າຍຄຳຖາມ ແລະ ປະເພດຄຳຖາມຈາກ {$a->oldplace} ໄປ {$a->newplace}.';
$string['movelinksonly'] = 'ພຽງແຕ່ປ່ຽນບ່ອນທີ່ເຊື່ອມຕໍ່ໄປຫາ, ຢ່າຍ້າຍ ຫຼື ສຳເນົາໄຟລ໌.';
$string['moveq'] = 'ຍ້າຍຄຳຖາມ';
$string['moveqtoanothercontext'] = 'ຍ້າຍຄໍາຖາມໄປຫາບໍລິບົດອື່ນ.';
$string['moveto'] = 'ຍ້າຍໄປຫາ';
$string['movingcategory'] = 'ກຳລັງຍ້າຍປະເພດ';
$string['movingcategoryandfiles'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການຍ້າຍປະເພດ {$a->name} ແລະ ປະເພດຍ່ອຍທັງໝົດຕາມບໍລິບົດ "{$a->contextto}"?<br /> ພວກເຮົາໄດ້ກວດພົບ {$a->urlcount} ໄຟລ໌ທີ່ໄດ້ເຊື່ອມໂຍງມາຈາກຄຳຖາມໃນ {$a->fromareaname}, ເຈົ້າຕ້ອງການສຳເນົາ ຫຼື ຍ້າຍສິ່ງເຫຼົ່ານີ້ໄປໃສ່ {$a->toareaname} ບໍ?';
$string['movingcategorynofiles'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການຍ້າຍປະເພດ "{$a->name}" ແລະ ປະເພດຍ່ອຍທັງໝົດໄປໃສ່ບໍລິບົດຂອງ "{$a->contextto}" ບໍ?';
$string['movingquestions'] = 'ກຳລັງຍ້າຍຄຳຖາມ ແລະ ໄຟລ໌ໃດໜຶ່ງ';
$string['movingquestionsandfiles'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການຍ້າຍຄຳຖາມ {$a->questions} ໄປຫາບໍລິບົດສຳລັບ <strong>"{$a->tocontext}"</strong>?<br />ພວກເຮົາໄດ້ພົບ <strong>{$a->urlcount} files</strong> ເຊື່ອມຕໍ່ຈາກຄໍາຖາມເຫຼົ່ານີ້ຢູ່ໃນ {$a->fromareaname}, ທ່ານຕ້ອງການສຳເນົາ ຫຼື ຍ້າຍສິ່ງເຫຼົ່ານີ້ໄປໃສ່ {$a->toareaname} ບໍ?';
$string['movingquestionsnofiles'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການຍ້າຍຄຳຖາມ {$a->questions} ໄປຫາບໍລິບົດສຳລັບ <strong>"{$a->tocontext}"</strong>?<br /> ບໍ່ມີ <strong>ໄຟລ໌</strong> ເຊື່ອມຕໍ່ຈາກຄໍາຖາມເຫຼົ່ານີ້ຢູ່ໃນ {$a->fromareaname}.';
$string['needtochoosecat'] = 'ທ່ານຈໍາເປັນຕ້ອງເລືອກປະເພດເພື່ອຍ້າຍຄໍາຖາມນີ້ໄປຫາ ຫຼື ກົດ \'ຍົກເລີກ\'.';
$string['nocate'] = 'ບໍ່ມີປະເພດດັ່ງກ່າວ {$a}!';
$string['nopermissionadd'] = 'ທ່ານບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ເພີ່ມຄຳຖາມໃສ່ບ່ອນນີ້.';
$string['nopermissionmove'] = 'ທ່ານບໍ່ໄດ້ຮັບອະນຸຍາດຍ້າຍຄຳຖາມຈາກບ່ອນນີ້. ທ່ານຕ້ອງບັນທຶກຄຳຖາມໄວ້ໃນປະເພດນີ້ ຫຼື ບັນທຶກມັນເປັນຄຳຖາມໃໝ່.';
$string['noprobs'] = 'ບໍ່ພົບບັນຫາຢູ່ໃນຖານຂໍ້ມູນຄຳຖາມຂອງທ່ານ.';
$string['noquestionbanks'] = 'ບໍ່ພົບປລັກອິນທະນາຄານຄຳຖາມ.';
$string['noquestions'] = 'ບໍ່ພົບຄຳຖາມທີ່ສາມາດສົ່ງອອກໄດ້. ກວດສອບໃຫ້ແນ່ໃຈວ່າ ທ່ານໄດ້ເລືອກປະເພດເພື່ອສົ່ງອອກທີ່ມີ ຄຳຖາມ.';
$string['noquestionsinfile'] = 'ບໍ່ມີຄໍາຖາມຢູ່ໃນໄຟລ໌ນໍາເຂົ້າ';
$string['noresponse'] = '[ບໍ່ມີການໂຕ້ຕອບ]';
$string['notagfiltersapplied'] = 'ບໍ່ໄດ້ນຳໃຊ້ຕົວກັ່ນຕອງແທັກ';
$string['notanswered'] = 'ບໍ່ໄດ້ຕອບຄຳຖາມ';
$string['notchanged'] = 'ບໍ່ໄດ້ປ່ຽນແປງຕັ້ງແຕ່ການພະຍາມຄັ້ງສຸດທ້າຍ';
$string['notenoughanswers'] = 'ຄຳຖາມປະເພດນີ້ຕ້ອງການຢ່າງໜ້ອຍ {$a} ຄໍາຕອບ';
$string['notenoughdatatoeditaquestion'] = 'ບໍ່ໄດ້ລະບຸທັງລະຫັດປະຈຳຕົວຄຳຖາມ ຫຼື ປະເພດລະຫັດປະຈຳຕົວ ແລະ ປະເພດຄຳຖາມ.';
$string['notenoughdatatomovequestions'] = 'ທ່ານຈຳເປັນຕ້ອງໃຫ້ລະຫັດປະຈຳຕົວຄຳຖາມຂອງຄຳ ຖາມທີ່ທ່ານຕ້ອງການຍ້າຍ.';
$string['notflagged'] = 'ບໍ່ໄດ້ໝາຍທຸງ';
$string['notgraded'] = 'ບໍ່ໄດ້ໃຫ້ຄະແນນ';
$string['notshown'] = 'ບໍ່ໄດ້ສະແດງ';
$string['notyetanswered'] = 'ບໍ່ໄດ້ຕອບຄຳຖາມເທື່ອ';
$string['notyourpreview'] = 'ຕົວຢ່າງນີ້ບໍ່ແມ່ນຂອງທ່ານ';
$string['novirtualquestiontype'] = 'ບໍ່ມີປະເພດຄໍາຖາມສະເໝືອນຈິງສໍາລັບປະເພດຄໍາຖາມ {$a}';
$string['numqas'] = 'ຈຳນວນຄຳຖາມທີ່ພະຍາຍາມ';
$string['numquestions'] = 'ຈຳນວນຄຳຖາມ';
$string['numquestionsandhidden'] = '{$a->numquestions} (+{$a->numhidden} ເຊື່ອງໄວ້ +{$a->numdraft} ຮ່າງ)';
$string['options'] = 'ທາງເລືອກ';
$string['page-question-category'] = 'ໜ້າປະເພດຄຳຖາມ';
$string['page-question-edit'] = 'ໜ້າການແກ້ໄຂຄຳຖາມ';
$string['page-question-export'] = 'ໜ້າການສົ່ງອອກຄຳຖາມ';
$string['page-question-import'] = 'ໜ້າການນຳເຂົ້າຄຳຖາມ';
$string['page-question-x'] = 'ໜ້າຄຳຖາມໃດໜຶ່ງ';
$string['parent'] = 'ຫຼັກ';
$string['parentcategory'] = 'ປະເພດຫຼັກ';
$string['parentcategory_help'] = 'ປະເພດຫຼັກແມ່ນໜຶ່ງໃນປະເພດໃໝ່ທີ່ຈະຖືກວາງໄວ້. "ອັນດັບສູງສຸດ" ໝາຍຄວາມວ່າປະເພດນີ້ບໍ່ມີຢູ່ໃນປະເພດອື່ນ. ບໍລິບົດປະເພດແມ່ນສະແດງໃນປະເພດຕົວໜາ. ຈະຕ້ອງມີຢ່າງໜ້ອຍໜຶ່ງ ປະເພດໃນແຕ່ລະບໍລິບົດ.';
$string['parentcategory_link'] = 'question/category';
$string['parenthesisinproperclose'] = 'ວົງເລັບກ່ອນ ** ບໍ່ຖືກປິດຢ່າງຖືກຕ້ອງໃນ {$ a} **';
$string['parenthesisinproperstart'] = 'ວົງເລັບກ່ອນ ** ບໍ່ໄດ້ເລີ່ມຢ່າງຖືກຕ້ອງໃນ {$ a} **';
$string['parsingquestions'] = 'ວິເຄາະຄຳຖາມຈາກໄຟລ໌ນຳເຂົ້າ.';
$string['partiallycorrect'] = 'ຖືກຕ້ອງບາງສ່ວນ';
$string['partiallycorrectfeedback'] = 'ສຳລັບຄຳຕອບທີ່ຖືກຕ້ອງບາງສ່ວນ';
$string['partiallycorrectfeedbackdefault'] = 'ຄຳຕອບຂອງທ່ານແມ່ນຖືກຕ້ອງບາງສ່ວນ.';
$string['penaltyfactor'] = 'ປັດໃຈການລົງໂທດ';
$string['penaltyfactor_help'] = 'ການຕັ້ງຄ່ານີ້ກໍານົດວ່າສ່ວນໃດຂອງຄະແນນທີ່ບັນລຸໄດ້ຖືກຫັກອອກສໍາລັບແຕ່ລະຄໍາຕອບທີ່ຜິດ. ມັນສາມາດໃຊ້ໄດ້ສະເພາະຖ້າແບບທົດສອບຖືກດໍາເນີນຢູ່ໃນຮູບແບບການປັບຕົວ.

ປັດໃຈການລົງໂທດຄວນເປັນຕົວເລກລະຫວ່າງ 0 ແລະ 1. ປັດໃຈການລົງໂທດ 1 ໝາຍຄວາມວ່ານັກຮຽນຈະຕ້ອງໄດ້ຄໍາຕອບທີ່ຖືກຕ້ອງໃນຄໍາຕອບທໍາອິດຂອງລາວເພື່ອໃຫ້ໄດ້ແຕ້ມທັງໝົດ. ປັດໃຈການລົງໂທດ 0 ໝາຍຄວາມວ່ານັກຮຽນສາມາດທົດລອງໄດ້ຫຼາຍເທົ່າທີ່ລາວມັກ ແລະ ຍັງໄດ້ຄະແນນເຕັມ.';
$string['penaltyforeachincorrecttry'] = 'ການລົງໂທດສໍາລັບການພະຍາຍາມທີ່ບໍ່ຖືກຕ້ອງແຕ່ລະຄັ້ງ';
$string['penaltyforeachincorrecttry_help'] = 'ເມື່ອຄໍາຖາມຖືກດໍາເນີນການໂດຍໃຊ້ພຶດຕິກໍາ \'ໂຕ້ຕອບກັບການພະຍາຍາມຫຼາຍອັນ\' ຫຼື \'ໂໝດການປັບຕົວ\', ເພື່ອໃຫ້ນັກຮຽນມີຄວາມພະຍາຍາມຫຼາຍຄັ້ງເພື່ອໃຫ້ຄໍາຖາມຖືກຕ້ອງ, ຈາກນັ້ນທາງເລືອກນີ້ຄວບຄຸມວ່າເຂົາເຈົ້າຈະຖືກລົງໂທດຫຼາຍປານໃດຕໍ່ກັບການພະຍາຍາມທີ່ບໍ່ຖືກຕ້ອງ.

ການລົງໂທດແມ່ນອັດຕາສ່ວນຂອງຄະແນນຄໍາຖາມທັງໝົດ, ສະນັ້ນຖ້າຄໍາຖາມມີມູນຄ່າສາມເຄື່ອງໝາຍ, ແລະ ການລົງໂທດແມ່ນ 0.3333333, ຈາກນັ້ນນັກຮຽນຈະໄດ້ຄະແນນ 3 ຖ້າເຂົາເຈົ້າໄດ້ຄໍາຖາມທີ່ຖືກຕ້ອງເປັນຄັ້ງທໍາອິດ, 2 ຖ້າເຂົາເຈົ້າໄດ້ຄໍາຕອບທີສອງຖືກຕ້ອງ, ແລະ 1 ໃນນັ້ນແມ່ນຖືກຕ້ອງໃນການພະຍາຍາມເທື່ອທີສາມ.

ສໍາລັບບາງຄໍາຖາມທີ່ມີຫຼາຍພາກສ່ວນ, ເຫດຜົນການໃຫ້ຄະແນນນີ້ແມ່ນໄດ້ນໍາໃຊ້ແຍກກັນກັບແຕ່ລະພາກສ່ວນຂອງຄໍາຖາມ. ລາຍລະອຽດແມ່ນຂຶ້ນກັບປະເພດຄໍາຖາມ ແລະ ສາມາດສັບສົນໄດ້, ແຕ່ຫຼັກການແມ່ນໃຫ້ນັກຮຽນໄດ້ແຕ້ມຕໍ່ກັບຄວາມຮູ້ທີ່ເຂົາເຈົ້າໄດ້ສະແດງອອກເປັນທໍາເທົ່າທີ່ຈະເປັນໄປໄດ້.';
$string['permissionedit'] = 'ແກ້ໄຂຄຳຖາມນີ້';
$string['permissionmove'] = 'ຍ້າຍຄຳຖາມນີ້';
$string['permissionsaveasnew'] = 'ບັນທຶກສິ່ງນີເປັນຄຳຖາມໃໝ່';
$string['permissionto'] = 'ທ່ານໄດ້ຮັບອະນຸຍາດເພື່ອ:';
$string['previewquestion'] = 'ເບິ່ງຕົວຢ່າງຄຳຖາມ: {$a}';
$string['privacy:metadata:database:question'] = 'ລາຍລະອຽດກ່ຽວກັບຄຳຖາມສະເພາະ.';
$string['privacy:metadata:database:question:createdby'] = 'ບຸກຄົນຜູ້ສ້າງຄຳຖາມ.';
$string['privacy:metadata:database:question:generalfeedback'] = 'ຄຳຕິຊົມທົ່ວໄປສຳລັບຄຳຖາມນີ້.';
$string['privacy:metadata:database:question:modifiedby'] = 'ບຸກຄົນຜູ້ທີ່ປັບປຸງຄຳຖາມຄັ້ງສຸດທ້າຍ.';
$string['privacy:metadata:database:question:name'] = 'ຊື່ຂອງຄໍາຖາມ.';
$string['privacy:metadata:database:question:questiontext'] = 'ຂໍ້ຄວາມຄຳຖາມ.';
$string['privacy:metadata:database:question:timecreated'] = 'ວັນທີ ແລະ ເວລາທີ່ຄໍາຖາມນີ້ຖືກສ້າງຂຶ້ນ.';
$string['privacy:metadata:database:question:timemodified'] = 'ວັນທີ ແລະ ເວລາທີ່ຄໍາຖາມນີ້ໄດ້ຖືກປັບປຸງ.';
$string['privacy:metadata:database:question_attempt_step_data'] = 'ຂັ້ນຕອນຄວາມພະຍາຍາມຖາມຄຳຖາມອາດຈະມີຂໍ້ມູນເພີ່ມເຕີມສະເພາະເຈາະຈົງກັບຂັ້ນຕອນນັ້ນ. ຂໍ້ມູນຖືກເກັບໄວ້ໃນຕາຕະລາງ step_data.';
$string['privacy:metadata:database:question_attempt_step_data:name'] = 'ຊື່ຂອງລາຍການຂໍ້ມູນ.';
$string['privacy:metadata:database:question_attempt_step_data:value'] = 'ຄ່າຂອງລາຍການຂໍ້ມູນ.';
$string['privacy:metadata:database:question_attempt_steps'] = 'ຄວາມພະຍາຍາມຖາມແຕ່ລະອັນມີຂັ້ນຕອນຫຼາຍອັນເພື່ອຊີ້ບອກໄລຍະທີ່ແຕກຕ່າງກັນຈາກຈຸດເລີ່ມຕົ້ນຈົນເຖິງການໝາຍໃນການເຮັດ. ຕາຕະລາງນີ້ເກັບຮັກສາຂໍ້ມູນສໍາລັບແຕ່ລະຂັ້ນຕອນເຫຼົ່ານີ້.';
$string['privacy:metadata:database:question_attempt_steps:fraction'] = 'ຄະແນນທີ່ໄດ້ລາງວັນຕໍ່ກັບຄວາມພະຍາຍາມຖາມຄໍາຖາມນີ້ໄດ້ປັບຂະ ໜາດອອກເປັນ 1.';
$string['privacy:metadata:database:question_attempt_steps:state'] = 'ສະຖານະຂອງຄວາມພະຍາຍາມຖາມຄຳຖາມໃນຂັ້ນຕອນສຸດທ້າຍຂອງການຫັນປ່ຽນຂັ້ນຕອນ.';
$string['privacy:metadata:database:question_attempt_steps:timecreated'] = 'ວັນທີ ແລະ ເວລາທີ່ການຫັນປ່ຽນຂັ້ນຕອນນີ້ໄດ້ເລີ່ມຂຶ້ນ.';
$string['privacy:metadata:database:question_attempt_steps:userid'] = 'ຜູ້ໃຊ້ທີ່ປະຕິບັດການຫັນປ່ຽນຂັ້ນຕອນ.';
$string['privacy:metadata:database:question_attempts'] = 'ຂໍ້ມູນກ່ຽວກັບຄວາມພະຍາຍາມຢູ່ໃນຄໍາຖາມສະເພາະ.';
$string['privacy:metadata:database:question_attempts:flagged'] = 'ຕົວຊີ້ບອກວ່າຜູ້ໃຊ້ໄດ້ໝາຍທຸງຄໍາຖາມນີ້ພາຍໃນຄວາມພະຍາຍາມ.';
$string['privacy:metadata:database:question_attempts:responsesummary'] = 'ສະຫຼຸບການໂຕ້ຕອບຄຳຖາມ';
$string['privacy:metadata:database:question_attempts:timemodified'] = 'ເວລາທີ່ຄວາມພະຍາຍາມຄຳຖາມໄດ້ປັບປຸງ.';
$string['privacy:metadata:database:question_bank_entries'] = 'ລາຍລະອຽດກ່ຽວກັບການປ້ອນເຂົ້າທະນາຄານຄຳຖາມສະເພາະ.';
$string['privacy:metadata:database:question_bank_entries:ownerid'] = 'ບຸກຄົນທີ່ເປັນເຈົ້າຂອງການປ້ອນເຂົ້າທະນາຄານຄຳຖາມ.';
$string['privacy:metadata:link:qbehaviour'] = 'ລະບົບຍ່ອຍຄຳຖາມໃຊ້ປະເພດປລັກອິນພຶດຕິກຳຄຳຖາມ.';
$string['privacy:metadata:link:qformat'] = 'ລະບົບຍ່ອຍຂອງຄໍາຖາມໃຊ້ປະເພດປລັກອິນຄໍາຖາມຮູບແບບ ສຳລັບຈຸດປະສົງຂອງການນໍາເຂົ້າ/ສົ່ງອອກ ຄໍາຖາມໃນຮູບແບບຕ່າງໆ.';
$string['privacy:metadata:link:qtype'] = 'ລະບົບຍ່ອຍຄຳຖາມໂຕ້ຕອບກັບປະເພດປລັກອິນປະເພດຄຳຖາມ ເຊິ່ງປະກອບດ້ວຍຄຳຖາມປະເພດຕ່າງໆ.';
$string['published'] = 'ແບ່ງປັນແລ້ວ';
$string['qbanknotfound'] = 'ປລັກອິນທະນາຄານຄຳຖາມ \'{$a}\' ບໍ່ມີຢູ່ ຫຼື ບໍ່ຖືກຮັບຮູ້.';
$string['qtypeveryshort'] = 'T';
$string['questionaffected'] = '<a href="{$a->qurl}">ຄຳຖາມ "{$a->name}" ({$a->qtype})</a> ຢູ່ໃນປະເພດຄຳຖາມນີ້ແຕ່ຍັງຖືກໃຊ້ຢູ່ໃນ <a href="{$a->qurl}">ແບບທົດສອບ "{$a->quizname}"</a> ໃນລາຍວິຊາອື່ນ "{$a->coursename}".';
$string['questionbank'] = 'ທະນາຄານຄຳຖາມ';
$string['questionbanknavigation'] = 'ການນຳທາງຂັ້ນສາມຂອງທະນາຄານຄຳຖາມ';
$string['questionbehaviouradminsetting'] = 'ການຕັ້ງຄ່າພຶດຕິກຳຄຳຖາມ';
$string['questionbehavioursdisabled'] = 'ປິດໃຊ້ງານພຶດຕິກຳຄຳຖາມ';
$string['questionbehavioursdisabledexplained'] = 'ໃສ່ລາຍການພຶດຕິກໍາທີ່ແຍກກັນດ້ວຍໝາຍຈຸດທີ່ທ່ານບໍ່ຕ້ອງການປາກົດຢູ່ໃນເມນູເລື່ອນລົງ.';
$string['questionbehavioursorder'] = 'ຄຳສັ່ງພຶດຕິກຳຄຳຖາມ';
$string['questionbehavioursorderexplained'] = 'ໃສ່ລາຍການພຶດຕິກໍາທີ່ແຍກກັນດ້ວຍໝາຍຈຸດຕາມລໍາດັບທີ່ທ່ານຕ້ອງການໃຫ້ພວກມັນປາກົດຢູ່ໃນເມນູເລື່ອນລົງ.';
$string['questioncategories'] = 'ປະເພດຄຳຖາມ';
$string['questioncategory'] = 'ປະເພດຄຳຖາມ';
$string['questioncatsfor'] = 'ປະເພດຄຳຖາມສຳລັບ \'{$a}\'';
$string['questiondoesnotexist'] = 'ບໍ່ມີຄຳຖາມ';
$string['questionformtagheader'] = '{$a} ແທັກ';
$string['questionidmismatch'] = 'ລະຫັດປະຈຳຕົວຄຳຖາມບໍ່ກົງກັນ';
$string['questionloaderror'] = 'ບໍ່ສາມາດໂຫຼດຕົວເລືອກຄຳຖາມ.';
$string['questionname'] = 'ຊື່ຄຳຖາມ';
$string['questionnamecopy'] = '{$a} (ສຳເນົາ)';
$string['questionno'] = 'ຄຳຖາມ {$a}';
$string['questionpreviewdefaults'] = 'ຄ່າເລີ່ມຕົ້ນເບິ່ງຕົວຢ່າງຄຳຖາມ';
$string['questionpreviewdefaults_desc'] = 'ຄ່າເລີ່ມຕົ້ນເຫຼົ່ານີ້ຖືກໃຊ້ເມື່ອຜູ້ໃຊ້ເບິ່ງຕົວຢ່າງຄໍາຖາມທໍາອິດຢູ່ໃນທະນາຄານຄໍາຖາມ. ເມື່ອຜູ້ໃຊ້ໄດ້ສະແດງຕົວຢ່າງຄໍາຖາມ, ຄວາມມັກສ່ວນຕົວຂອງເຂົາເຈົ້າຈະຖືກເກັບໄວ້ເປັນຄວາມມັກຂອງຜູ້ໃຊ້.';
$string['questions'] = 'ຄຳຖາມ';
$string['questionsaveerror'] = 'ເກີດມີຄວາມຜິດພາດໃນການບັນທຶກຄຳຖາມ - ({$a})';
$string['questionsinuse'] = '(*ຄຳຖາມທີ່ໝາຍດ້ວຍເຄື່ອງໝາຍດາວແມ່ນໃຊ້ຢູ່ບ່ອນໃດບ່ອນໜຶ່ງ, ຕົວຢ່າງໃນແບບທົດສອບ. ດັ່ງນັ້ນ, ຖ້າທ່ານດຳເນີນການຕໍ່ໄປ, ຄຳຖາມເຫຼົ່ານີ້ຈະບໍ່ຖືກລຶບອອກໄປແທ້, ພວກມັນຈະຖືກເຊື່ອງໄວ້ເທົ່ານັ້ນ).';
$string['questionsmovedto'] = 'ຄຳຖາມທີ່ຍັງໃຊ້ຢູ່ໄດ້ຍ້າຍໄປ "{$a}" ຢູ່ໃນປະເພດລາຍວິຊາຫຼັກ.';
$string['questionsrescuedfrom'] = 'ຄຳຖາມບັນທຶກຈາກບໍລິບັດ {$a}.';
$string['questionsrescuedfrominfo'] = 'ຄຳຖາມເຫຼົ່ານີ້ (ບາງອັນທີ່ອາດຈະຖືກເຊື່ອງໄວ້) ໄດ້ຖືກບັນທຶກໄວ້ໃນເວລາທີ່ບໍລິບົດ {$a} ຖືກລຶບໄປເພາະວ່າພວກມັນຍັງຖືກໃຊ້ໂດຍບາງຄຳຖາມ ຫຼື ກິດຈະກຳອື່ນຢູ່.';
$string['questiontags'] = 'ແທັກຄຳຖາມ';
$string['questiontext'] = 'ຂໍ້ຄວາມຄຳຖາມ';
$string['questiontype'] = 'ປະເພດຄຳຖາມ';
$string['questionuse'] = 'ນຳໃຊ້ຄຳຖາມໃນກິດຈະກຳນີ້';
$string['questionvariant'] = 'ຮູບແບບຄຳຖາມ';
$string['questionx'] = 'ຄຳຖາມ {$a}';
$string['requiresgrading'] = 'ຕ້ອງການມີການໃຫ້ຄະແນນ';
$string['responsehistory'] = 'ປະຫວັດການໂຕ້ຕອບ';
$string['restart'] = 'ເລີ່ມຕົ້ນອີກຄັ້ງ';
$string['restartwiththeseoptions'] = 'ເລີ່ມຕົ້ນອີກຄັ້ງກັບຄຳຖາມນີ້';
$string['restoremultipletopcats'] = 'ໄຟລ໌ສໍາຮອງມີຫຼາຍກວ່າໜຶ່ງປະເພດຄໍາຖາມລະດັບສູງສຸດສໍາລັບບໍລິບົດ {$a}.';
$string['reviewresponse'] = 'ທົບທວນການໂຕ້ຕອບ';
$string['rightanswer'] = 'ຄຳຕອບທີ່ຖືກຕ້ອງ';
$string['rightanswer_help'] = 'ບົດສະຫຼຸບທີ່ສ້າງຂຶ້ນໂດຍອັດຕະໂນມັດຂອງຄຳຕອບທີ່ຖືກຕ້ອງ. ສິ່ງນີ້ສາມາດຈໍາກັດໄດ້, ສະນັ້ນທ່ານອາດຈະພິຈາລະນາອະທິບາຍຄໍາຕອບທີ່ຖືກຕ້ອງຢູ່ໃນຄໍາຕິຊົມທົ່ວໄປສໍາລັບຄໍາຖາມ, ແລະ ປິດຕົວເລືອກນີ້.';
$string['save'] = 'ບັຍທຶກ';
$string['savechangesandcontinueediting'] = 'ບັນທຶກການປ່ຽນແປງ ແລະ ສືບຕໍ່ການແກ້ໄຂ';
$string['saved'] = 'ບັນທຶກແລ້ວ: {$a}';
$string['saveflags'] = 'ບັນທຶກສະຖານະຂອງທຸງ';
$string['selectacategory'] = 'ເລືອກປະເພດ:';
$string['selectaqtypefordescription'] = 'ເລືອກປະເພດຄຳຖາມເພື່ອເບິ່ງລາຍລະອຽດຂອງມັນ.';
$string['selectcategoryabove'] = 'ເລືອກປະເພດຂ້າງເທິງ';
$string['selectquestionsforbulk'] = 'ເລືອກຄຳຖາມສຳລັບການປະຕິບັດຊຸດ';
$string['settingsformultipletries'] = 'ພະຍາຍາມຫຼາຍເທື່ອ';
$string['shareincontext'] = 'ແບ່ງປັນໃຈບໍລິບັດສຳລັບ {$a}';
$string['showhidden'] = 'ຍັງສະແດງຄຳຖາມເກົ່າອີກດ້ວຍ';
$string['showmarkandmax'] = 'ສະແດງເຄື່ອງໝາຍ ແລະ ສູງສຸດ';
$string['showmaxmarkonly'] = 'ສະແດງເຄື່ອງໝາຍສູງສຸດເທົ່ານັ້ນ';
$string['shown'] = 'ສະແດງແລ້ວ';
$string['shownumpartscorrect'] = 'ສະແດງຈຳນວນການໂຕ້ຕອບທີ່ຖືກຕ້ອງ';
$string['shownumpartscorrectwhenfinished'] = 'ສະແດງຈໍານວນຄໍາຕອບທີ່ຖືກຕ້ອງເມື່ອຄໍາຖາມສໍາເລັດແລ້ວ';
$string['showquestiontext'] = 'ສະແດງຂໍ້ຄວາມຄຳຖາມໃນລາຍການຄຳຖາມ';
$string['specificfeedback'] = 'ຄຳຕິຊົມສະເພາະເຈາະຈົງ';
$string['specificfeedback_help'] = 'ຄຳຕິຊົມທີ່ຂຶ້ນກັບວ່ານັກຮຽນຕອບຄຳຖາມໃດ.';
$string['started'] = 'ເລີ່ມຕົ້ນແລ້ວ';
$string['state'] = 'ສະຖານະ';
$string['step'] = 'ຂັ້ນຕອນ';
$string['steps'] = 'ບັນດາຂັ້ນຕອນ';
$string['stoponerror'] = 'ຢຸດຢູ່ຄວາມຜິດພາດ';
$string['stoponerror_help'] = 'ການຕັ້ງຄ່ານີ້ຕັດສິນກໍານົດວ່າຂະບວນການນໍາເຂົ້າຢຸດຢູ່ບໍເມື່ອກວດພົບຄວາມຜິດພາດ, ສົ່ງຜົນໃຫ້ບໍ່ມີຄໍາຖາມນໍາເຂົ້າມາ, ຫຼື ວ່າຄໍາຖາມທີ່ມີຂໍ້ຜິດພາດຖືກລະເລີຍ ແລະ ຄໍາຖາມທີ່ຖືກຕ້ອງໃດຖືກນໍາເຂົ້າແລ້ວ.';
$string['submissionoutofsequence'] = 'ເຂົ້າເຖິງບໍ່ໄດ້ຕາມລຳດັບ. ກະລຸນາຢ່າຄລິກປຸ່ມກັບຄືນໃນເວລາເຮັດວຽກກ່ຽວກັບຄຳຖາມຕອບ.';
$string['submissionoutofsequencefriendlymessage'] = 'ທ່ານໄດ້ປ້ອນຂໍ້ມູນຢູ່ນອກລໍາດັບປົກກະຕິ. ສິ່ງນີ້ສາມາດເກີດຂຶ້ນໄດ້ຖ້າທ່ານໃຊ້ປຸ່ມກັບຄືນ ຫຼື ສົ່ງຕໍ່ຂອງບຣາວເຊີຂອງທ່ານ; ກະລຸນາຢ່າໃຊ້ສິ່ງເຫຼົ່ານີ້ໃນລະຫວ່າງການທົດສອບ. ມັນຍັງສາມາດເກີດຂຶ້ນໄດ້ຖ້າທ່ານຄລິກໃສ່ອັນໃດອັນໜຶ່ງໃນຂະນະທີ່ໜ້າເວັບກໍາລັງໂຫຼດ. ຄລິກ <strong>ສືບຕໍ່</strong> ເພື່ອສືບຕໍ່ຄືນໃໝ່.';
$string['submit'] = 'ສົ່ງ';
$string['submitandfinish'] = 'ສົ່ງ ແລະ ສຳເລັດ';
$string['submitted'] = 'ສົ່ງ: {$a}';
$string['tagarea_question'] = 'ບັນດາຄຳຖາມ';
$string['technicalinfo'] = 'ຂໍ້ມູນທາງເຕັກນິກ';
$string['technicalinfo_help'] = 'ຂໍ້ມູນທາງເທັກນິກນີ້ອາດຈະເປັນປະໂຫຍດພຽງແຕ່ ສຳລັບນັກພັດທະນາທີ່ເຮັດວຽກກ່ຽວກັບປະເພດ ຄຳຖາມໃໝ່. ມັນອາດຈະເປັນປະໂຫຍດເມື່ອພະຍາຍາມວິເຄາະບັນຫາກັບຄໍາຖາມຕ່າງໆ.';
$string['technicalinfomaxfraction'] = 'ເສດສ່ວນຂັ້ນສູງ: {$a}';
$string['technicalinfominfraction'] = 'ເສດສ່ວນຂັ້ນຕໍ່າ: {$a}';
$string['technicalinfoquestionsummary'] = 'ສະຫຼຸບຄຳຖາມ: {$a}';
$string['technicalinforesponsesummary'] = 'ສະຫຼຸບການໂຕ້ຕອບ: {$a}';
$string['technicalinforightsummary'] = 'ສະຫຼຸບຄຳຖາມທີ່ຖືກຕ້ອງ: {$a}';
$string['technicalinfostate'] = 'ຄຳຖາມລະບຸ: {$a}';
$string['technicalinfovariant'] = 'ຮູບແບບຄຳຖາມ: {$a}';
$string['tofilecategory'] = 'ຂຽນປະເພດໃສ່ໄຟລ໌';
$string['tofilecontext'] = 'ຂຽນບໍລິບົດໃສ່ໄຟລ໌';
$string['topfor'] = 'ເທິງສຸດສຳລັບ {$a}';
$string['uninstallbehaviour'] = 'ຖອນການຕິດຕັ້ງພຶດຕິກຳຄຳຖາມ.';
$string['uninstallqtype'] = 'ຖອນການຕິດຕັ້ງປະເພດຄຳຖາມນີ້.';
$string['unknown'] = 'ບໍ່ຮູ້ຈັກ';
$string['unknownbehaviour'] = 'ພຶດຕິກຳບໍ່ຮູ້ຈັກ: {$a}.';
$string['unknownorunhandledtype'] = 'ປະເພດຄຳຖາມບໍ່ຮູ້ຈັກ ຫຼື ບໍ່ສາມາດຈັດການໄດ້: {$a}';
$string['unknownquestion'] = 'ຄຳຖາມທີ່ບໍ່ຮູ້ຈັກ: {$a}.';
$string['unknownquestioncatregory'] = 'ໝວດຄຳຖາມທີ່ບໍ່ຮູ້ຈັກ: {$a}.';
$string['unknownquestiontype'] = 'ປະເພດຄຳຖາມທີ່ບໍ່ຮູ້ຈັກ: {$a}.';
$string['unknowntolerance'] = 'ປະເພດຄວາມທົນທານທີ່ບໍ່ຮູ້ຈັກ {$a}';
$string['unpublished'] = 'ບໍ່ໄດ້ແບ່ງປັນ';
$string['unusedcategorydeleted'] = 'ປະເພດນີ້ຖືກລຶບໄປແລ້ວເພາະວ່າ, ຫຼັງຈາກການລຶບລາຍວິຊາ, ຄໍາຖາມຂອງມັນບໍ່ໄດ້ຖືກນໍາໃຊ້ອີກຕໍ່ໄປ.';
$string['updatedisplayoptions'] = 'ປັບປຸງທາງເລືອກສະແດງ';
$string['upgradeproblemcategoryloop'] = 'ກວດພົບບັນຫາເມື່ອຍົກລະດັບປະເພດຄຳຖາມ. ມີວົງວຽນຢູ່ໃນໝວດຕົ້ນໄມ້. ລະຫັດປະຈຳຕົວປະເພດທີ່ໄດ້ຮັບຜົນກະທົບແມ່ນ {$a}.';
$string['upgradeproblemcouldnotupdatecategory'] = 'ບໍ່ສາມາດປັບປຸງປະເພດຄໍາຖາມ {$ a->name} ({$ a->id}).';
$string['upgradeproblemunknowncategory'] = 'ກວດພົບບັນຫາເມື່ອອັບຍົກລະດັບປະເພດຄຳຖາມ. ປະເພດ {$ a->id} ໝາຍເຖິງພໍ່ແມ່ {$a->parent}, ເຊິ່ງບໍ່ມີຢູ່. ການປ່ຽນແປງຫຼັກເພື່ອແກ້ໄຂບັນຫາ.';
$string['whethercorrect'] = 'ຖືກຕ້ອງຫຼືບໍ່';
$string['whethercorrect_help'] = 'ສິ່ງນີ້ກວມເອົາທັງຄໍາອະທິບາຍຕົວໜັງສື \'ຖືກຕ້ອງ\', \'ຖືກຕ້ອງບາງສ່ວນ\' ຫຼື \'ບໍ່ຖືກຕ້ອງ\', ແລະ ການເນັ້ນສີທີ່ສະແດງເຖິງຂໍ້ມູນດຽວກັນ.';
$string['whichtries'] = 'ຄວາມພະຍາຍາມໃດ';
$string['withselected'] = 'ດ້ວຍການເລືອກ';
$string['wrongprefix'] = 'ການຈັດຮູບແບບຊື່ນຳໜ້າທີ່ບໍ່ຖືກຕ້ອງ {$a}';
$string['xoutofmax'] = '{$a->mark} ຈາກທັງໝົດ {$a->max}';
$string['yougotnright'] = 'ທ່ານໄດ້ເລືອກ {$a->num} ຢ່າງຖືກຕ້ອງ.';
$string['youmustselectaqtype'] = 'ທ່ານຕ້ອງເລືອກປະເພດຄຳຖາມ';
$string['yourfileshoulddownload'] = 'ໄຟລ໌ສົ່ງອອກຂອງທ່ານຄວນເລີ່ມດາວໂຫຼດໄວໆນີ້. ຖ້າບໍ່, ກະລຸນາ <a href="{$a}">ຄລິກບ່ອນນີ້</a>.';
