<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'lo', version '4.0'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'ການປະຕິບັດ';
$string['activate'] = 'ເປີດໃຊ້ການເຂົ້າເຖິງ';
$string['activatesuccess'] = 'ເປີດນຳໃຊ້ການເຂົ້າເຖິງປ້າຍສຳເລັດແລ້ວ.';
$string['addalignment'] = 'ເພີ່ມທັກສະ ຫຼື ມາດຕະຖານພາຍນອກ';
$string['addbackpack'] = 'ເພີ່ມຊຸດກ່ອນໜ້າ';
$string['addbadge'] = 'ເພີ່ມປ້າຍ';
$string['addbadge_help'] = 'ເລືອກປ້າຍທັງໝົດທີ່ຄວນເພີ່ມໃສ່ຄວາມຕ້ອງການປ້າຍນີ້. ກົດປຸ່ມ CTRL ຄ້າງໄວ້ເພື່ອເລືອກຫຼາຍລາຍການ.';
$string['addbadgecriteria'] = 'ເພີ່ມເກນປ້າຍ';
$string['addcohort'] = 'ເພີ່ມກຸ່ມ';
$string['addcohort_help'] = 'ເລືອກກຸ່ມທັງໝົດທີ່ຄວນຈະເພີ່ມໃສ່ຄວາມຕ້ອງການປ້າຍນີ້. ກົດປຸ່ມ CTRL ຄ້າງໄວ້ເພື່ອເລືອກຫຼາຍລາຍການ.';
$string['addcompetency'] = 'ເພີ່ມຄວາມສາມາດ';
$string['addcompetency_help'] = 'ເລືອກຄວາມສາມາດທັງໝົດທີ່ຄວນຈະຖືກເພີ່ມເຂົ້າໃນຄວາມຕ້ອງການປ້າຍນີ້. ກົດປຸ່ມ CTRL ຄ້າງໄວ້ເພື່ອເລືອກຫຼາຍລາຍການ.';
$string['addcourse'] = 'ເພີ່ມວິຊາ';
$string['addcourse_help'] = 'ເລືອກວິຊາທັງໝົດທີ່ຄວນເພີ່ມເຂົ້າໃສ່ຄວາມຕ້ອງການປ້າຍນີ້. ກົດປຸ່ມ CTRL ຄ້າງໄວ້ເພື່ອເລືອກຫຼາຍລາຍການ.';
$string['addcriteria'] = 'ເພີ່ມມາດຖານ';
$string['addcriteriatext'] = 'ເພື່ອເລີ່ມເພີ່ມເງື່ອນໄຂ, ກະລຸນາເລືອກໜຶ່ງໃນຕົວເລືອກຈາກເມນູເລື່ອນລົງ.';
$string['addedtobackpack'] = 'ເພີ່ມປ້າຍໃສ່ຊຸດກ່ອນໜ້າແລ້ວ';
$string['addrelated'] = 'ເພີ່ມປ້າຍທີ່ກ່ຽວຂ້ອງ';
$string['addtobackpack'] = 'ຕື່ມໃສ່ຊຸດກ່ອນໜ້າ';
$string['adminonly'] = 'ໜ້ານີ້ຖືກຈຳກັດສະເພາະຜູ້ຄວບຄຸມເວັບໄຊທ໌.';
$string['after'] = 'ຫຼັງຈາກວັນທີອອກໃຫ້.';
$string['aggregationmethod'] = 'ວິທີການລວມ';
$string['alignment'] = 'ການຈັດຕໍາແໜ່ງ';
$string['all'] = 'ທັງໝົດ';
$string['allmethod'] = 'ທຸກເງື່ອນໄຂທີ່ເລືອກແມ່ນບັນລຸໄດ້';
$string['allmethodactivity'] = 'ກິດຈະກໍາທັງໝົດທີ່ເລືອກແມ່ນສົມບູນ';
$string['allmethodbadges'] = 'ປ້າຍທັງໝົດທີ່ເລືອກໄດ້ຮັບແລ້ວ';
$string['allmethodcohort'] = 'ສະມາຊິກໃນກຸ່ມທັງໝົດທີ່ເລືອກ';
$string['allmethodcompetencies'] = 'ຄວາມສາມາດທັງໝົດທີ່ໄດ້ຄັດເລືອກແມ່ນໄດ້ເຮັດສຳເລັດແລ້ວ';
$string['allmethodcourseset'] = 'ວິຊາທັງໝົດທີ່ເລືອກແມ່ນສົມບູນ';
$string['allmethodmanual'] = 'ໜ້າທີ່ທີ່ເລືອກທັງໝົດໃຫ້ລາງວັນປ້າຍ';
$string['allmethodprofile'] = 'ຊ່ອງຂໍ້ມູນໂປຼໄຟລ໌ທີ່ເລືອກທັງໝົດຖືກເຮັດສຳເລັດແລ້ວ';
$string['allowcoursebadges'] = 'ເປີດໃຊ້ປ້າຍລາຍວິຊາ';
$string['allowcoursebadges_desc'] = 'ອະນຸຍາດໃຫ້ສ້າງປ້າຍ ແລະ ໃຫ້ລາງວັນໃນບໍລິບົດລາຍວິຊາ.';
$string['allowexternalbackpack'] = 'ການເຊື່ອມຕໍ່ຊຸດກ່ອນໜ້າພາຍນອກ';
$string['allowexternalbackpack_desc'] = 'ຖ້າເປີດໃຊ້, ຜູ້ໃຊ້ສາມາດເຊື່ອມຕໍ່ກັບຊຸດກ່ອນໜ້າພາຍນອກ ແລະ ແລກປ່ຽນປ້າຍຂອງເຂົາເຈົ້າຈາກບ່ອນນີ້. ຜູ້ໃຊ້ອາດຈະເລືອກທີ່ຈະສະແດງການຮວບຮວມປ້າຍສາທາລະນະຈາກຊຸດກ່ອນໜ້າພາຍນອກຂອງເຂົາເຈົ້າຢູ່ໃນໜ້າໂປຼໄຟລ໌ຂອງເຂົາເຈົ້າຢູ່ໃນເວັບໄຊທ໌ນີ້. ແນະນໍາໃຫ້ປະການປິດຕົວເລືອກນີ້ໄວ້ຖ້າເວັບໄຊທ໌ຂອງທ່ານບໍ່ສາມາດເຂົ້າເຖິງໄດ້ຈາກອິນເຕີເນັດ.';
$string['any'] = 'ອັນໃດໜຶ່ງ';
$string['anymethod'] = 'ທຸກເງື່ອນໄຂທີ່ເລືອກແມ່ນບັນລຸໄດ້';
$string['anymethodactivity'] = 'ກິດຈະກຳໃດໜຶ່ງທີ່ເລືອກໄວ້ແມ່ນແລ້ວສົມບູນ';
$string['anymethodbadges'] = 'ປ້າຍໃດໜຶ່ງທີ່ເລືອກແມ່ນໄດ້ຮັບແລ້ວ';
$string['anymethodcohort'] = 'ການເປັນສະມາຊິກຢູ່ໃນກຸ່ມໃດໜຶ່ງທີ່ເລືອກ';
$string['anymethodcompetencies'] = 'ຄວາມສາມາດໃດໜຶ່ງທີ່ເລືອກໄດ້ຖືກເຮັດສຳເລັດ';
$string['anymethodcourseset'] = 'ວິຊາໃດໜຶ່ງທີ່ເລືອກແມ່ນສົມບູນ';
$string['anymethodmanual'] = 'ໜ້າທີ່ໃດໜຶ່ງທີ່ເລືອກໃຫ້ລາງວັນປ້າຍ';
$string['anymethodprofile'] = 'ຊ່ອງຂໍ້ມູນໂປຼໄຟລ໌ໃດໜຶ່ງທີ່ເລືອກໄດ້ຖືກເຮັດສຳເລັດ';
$string['apiversion'] = 'ສະບັບ API ທີ່ຮອງຮັບ';
$string['archivebadge'] = 'ທ່ານຕ້ອງການລຶບປ້າຍ \'{$a}\', ແຕ່ຮັກສາປ້າຍທີ່ອອກແລ້ວທີ່ມີຢູ່ແລ້ວຫຼືບໍ່?';
$string['archiveconfirm'] = 'ລຶບ ແລະ ຮັກສາປ້າຍທີ່ອອກແລ້ວ';
$string['archivehelp'] = '<p>ຕົວເລືອກນີ້ໝາຍຄວາມວ່າປ້າຍຈະຖືກໝາຍເປັນ "ກະສຽນແລ້ວ" ແລະ ຈະບໍ່ປາກົດຢູ່ໃນລາຍການປ້າຍອີກຕໍ່ໄປ. ຜູ້ໃຊ້ຈະບໍ່ສາມາດໄດ້ຮັບປ້າຍນີ້ອີກຕໍ່ໄປ, ຢ່າງໃດກໍ່ຕາມ, ຜູ້ຮັບປ້າຍທີ່ມີຢູ່ແລ້ວຈະຍັງສາມາດສະແດງປ້າຍນີ້ຢູ່ໃນໜ້າໂປຼໄຟລ໌ ຂອງເຂົາເຈົ້າ ແລະ ຍູ້ມັນໃສ່ຊຸດກ່ອນໜ້າພາຍນອກຂອງເຂົາເຈົ້າ. </p>
<p>ຖ້າທ່ານຕ້ອງການໃຫ້ຜູ້ໃຊ້ຂອງທ່ານຮັກສາການເຂົ້າເຖິງປ້າຍທີ່ໄດ້ຮັບໄວ້, ມັນເປັນສິ່ງສໍາຄັນທີ່ຈະເລືອກຕົວເລືອກນີ້ແທນການລຶບປ້າຍອອກທັງໝົດ.</p>';
$string['attachment'] = 'ຕິດປ້າຍໃສ່ກັບຂໍ້ຄວາມ';
$string['attachment_help'] = 'ຖ້າເປີດໃຊ້ງານແລ້ວ, ປ້າຍທີ່ອອກໃຫ້ຈະຖືກແນບໃສ່ກັບອີເມລຂອງຜູ້ຮັບເພື່ອດາວໂຫຼດ. (ເອກະສານແນບຕ້ອງຖືກເປີດໃຊ້ຢູ່ໃນການບໍລິຫານເວັບໄຊທ໌ / ເຊີບເວີ / ອີເມລ / ການຕັ້ງຄ່າຈົດໝາຍຂາອອກເພື່ອໃຊ້ຕົວເລືອກນີ້.)';
$string['award'] = 'ປ້າຍລາງວັນ';
$string['awardedto'] = 'ໃຫ້ລາງວັນແກ່ {$a}';
$string['awardedtoyou'] = 'ອອກແລ້ວໃຫ້ຂ້ອຍ';
$string['awardoncron'] = 'ເປີດນຳໃຊ້ການເຂົ້າເຖິງປ້າຍແລ້ວ. ມີຜູ້ໃຊ້ຫຼາຍເກີນໄປສາມາດໄດ້ຮັບປ້າຍນີ້ໃນທັນທີ. ເພື່ອຮັບປະກັນການປະຕິບັດເວັບໄຊທ໌, ການດໍາເນີນການນີ້ຈະໃຊ້ບາງເວລາເພື່ອປະມວນຜົນ.';
$string['awards'] = 'ຜູ້ຮັບ';
$string['backpackapiurl'] = 'ຊຸດກ່ອນໜ້າ API URL';
$string['backpackavailability'] = 'ການຢັ້ງຢືນປ້າຍພາຍນອກ';
$string['backpackavailability_help'] = 'ເພື່ອໃຫ້ຜູ້ຮັບປ້າຍສາມາດພິສູດໄດ້ວ່າເຂົາເຈົ້າໄດ້ຮັບປ້າຍຂອງເຂົາເຈົ້າຈາກທ່ານ, ການບໍລິການຊຸດກ່ອນໜ້າພາຍນອກຄວນຈະສາມາດເຂົ້າຫາເວັບໄຊທ໌ຂອງທ່ານ ແລະ ກວດພິສູດປ້າຍທີ່ອອກແລ້ວຈາກມັນໄດ້. ປະຈຸບັນເວັບໄຊທ໌ຂອງທ່ານບໍ່ສາມາດເຂົ້າເຖິງໄດ້, ນັ້ນໝາຍຄວາມວ່າ ປ້າຍທີ່ທ່ານໄດ້ອອກໄປແລ້ວ ຫຼື ຈະອອກໃຫ້ໃນອະນາຄົດບໍ່ສາມາດກວດສອບໄດ້.

**ເປັນຫຍັງຂ້ອຍຈິ່ງເຫັນຂໍ້ຄວາມນີ້?**

ມັນອາດຈະແມ່ນວ່າໄຟວໍຂອງທ່ານປ້ອງກັນການເຂົ້າຫາຈາກຜູ້ໃຊ້ທີ່ຢູ່ນອກເຄືອຂ່າຍຂອງທ່ານ, ເວັບໄຊທ໌ຂອງທ່ານໄດ້ຮັບການປົກປ້ອງດ້ວຍລະຫັດຜ່ານ, ຫຼື ທ່ານກໍາລັງແລ່ນເວັບໄຊທ໌ຢູ່ໃນຄອມພິວເຕີທີ່ບໍ່ມີຢູ່ຈາກອິນເຕີເນັດ (ເຊັ່ນ: ເຄື່ອງພັດທະນາທ້ອງຖິ່ນ).

**ນີ້ແມ່ນບັນຫາບໍ?**

ທ່ານຄວນແກ້ໄຂບັນຫານີ້ຢູ່ບ່ອນຜະລິດບ່ອນທີ່ທ່ານວາງແຜນທີ່ຈະອອກປ້າຍ, ຖ້າບໍ່ດັ່ງນັ້ນຜູ້ຮັບຈະບໍ່ສາມາດພິສູດໄດ້ວ່າເຂົາເຈົ້າໄດ້ຮັບປ້າຍຈາກທ່ານ. ຖ້າເວັບໄຊທ໌ຂອງທ່ານຍັງບໍ່ທັນເປີດຕົວ, ທ່ານສາມາດສ້າງ ແລະ ອອກປ້າຍການທົດສອບໄດ້, ຕາບໃດທີ່ເວັບໄຊທ໌ເຂົ້າຫາໄດ້ກ່ອນທີ່ທ່ານຈະເປີດຕົວ.

**ຈະເກີດຫຍັງຂຶ້ນຖ້າຂ້ອຍບໍ່ສາມາດເຮັດໃຫ້ເວັບໄຊທ໌ທັງໝົດຂອງຂ້ອຍສາມາດເຂົ້າເຖິງໄດ້ໂດຍສາທາລະນະ?**

URL ດຽວທີ່ຕ້ອງການສຳລັບການກວດສອບແມ່ນ [your-site-url]/badges/assertion.php ສະນັ້ນຖ້າທ່ານສາມາດດັດແປງໄຟວໍຂອງທ່ານເພື່ອອະນຸຍາດໃຫ້ເຂົ້າເຖິງໄຟລ໌ນັ້ນຈາກພາຍນອກໄດ້, ການຢັ້ງຢືນປ້າຍຈະຍັງເຮັດວຽກຢູ່.';
$string['backpackbadgessettings'] = 'ປ່ຽນການຕັ້ງຄ່າຊຸດກ່ອນໜ້າ';
$string['backpackbadgessummary'] = 'ເຈົ້າມີປ້າຍ {$a->totalbadges} ທີ່ສະແດງຈາກຄັງສະສົມ {$a->totalcollections}.';
$string['backpackcannotsendverification'] = 'ບໍ່ສາມາດສົ່ງອີເມລຢືນຢັນໄດ້';
$string['backpackconnected'] = 'ຊຸດກ່ອນໜ້າແມ່ນເຊື່ອມຕໍ່ແລ້ວ';
$string['backpackconnection'] = 'ການເຊື່ອມຕໍ່ຊຸດກ່ອນໜ້າ';
$string['backpackconnection_help'] = 'ການເຊື່ອມຕໍ່ກັບຊຸດກ່ອນໜ້າເຮັດໃຫ້ທ່ານສາມາດແລກປ່ຽນປ້າຍຂອງທ່ານຈາກເວັບໄຊທ໌ນີ້, ແລະ ສະແດງການເກັບກໍາປ້າຍສາທາລະນະຈາກຊຸດກ່ອນໜ້າຂອງທ່ານຢູ່ໃນໜ້າໂປຼໄຟລ໌ຂອງທ່ານຢູ່ໃນເວັບໄຊທ໌ນີ້.';
$string['backpackconnectioncancelattempt'] = 'ເຊື່ອມຕໍ່ໂດຍໃຊ້ທີ່ຢູ່ອີເມລອື່ນ';
$string['backpackconnectionconnect'] = 'ເຊື່ອມຕໍ່ກັບຊຸດກ່ອນໜ້າ';
$string['backpackconnectionnottested'] = 'ບໍ່ສາມາດທົດສອບການເຊື່ອມຕໍ່ກັບຊຸດກ່ອນໜ້ານີ້ໄດ້ເພາະວ່າມີສະເພາະຊຸດກ່ອນໜ້າ Open Badges v2.0 ຮອງຮັບມັນ.';
$string['backpackconnectionok'] = 'ສ້າງການເຊື່ອມຕໍ່ຊຸດກ່ອນໜ້າສຳເລັດແລ້ວ';
$string['backpackconnectionresendemail'] = 'ສົ່ງອີເມວຢືນຢັນອີກຄັ້ງ';
$string['backpackconnectionunexpectedmessage'] = 'ຊຸດກ່ອນໜ້າໄດ້ຄືນຄວາມຜິດພາດ: "{$ a}".';
$string['backpackconnectionunexpectedresult'] = 'ເກີດບັນຫາໃນການເຊື່ອມຕໍ່ກັບຊຸດກ່ອນໜ້າຂອງທ່ານ. ກະລຸນາກວດເບິ່ງຂໍ້ມູນຮັບຮອງ ແລະ ລອງໃໝ່ອີກ.';
$string['backpackdetails'] = 'ການຕັ້ງຄ່າຊຸດກ່ອນໜ້າ';
$string['backpackdisconnected'] = 'ຢຸດການເຊື່ອມຕໍ່ຊຸດກ່ອນໜ້າ';
$string['backpackemail'] = 'ທີ່ຢູ່ອີເມລ';
$string['backpackemail_help'] = 'ທີ່ຢູ່ອີເມລທີ່ເຊື່ອມໂຍງກັບຊຸດກ່ອນໜ້າຂອງທ່ານ. ໃນຂະນະທີ່ທ່ານເຊື່ອມຕໍ່ຢູ່, ປ້າຍໃດໜຶ່ງທີ່ໄດ້ຮັບຢູ່ໃນເວັບໄຊທ໌ນີ້ຈະຖືກເຊື່ອມໂຍງກັບທີ່ຢູ່ອີເມລນີ້.';
$string['backpackemailverificationpending'] = 'ລໍຖ້າການກວດສອບ';
$string['backpackemailverifyemailbody'] = 'ສະບາຍດີ,

ໄດ້ມີການຮ້ອງຂໍການເຊື່ອມຕໍ່ໃໝ່ກັບຊຸດກ່ອນໜ້າປ້າຍຂອງທ່ານຈາກ \'{$a->sitename}\' ໂດຍໃຊ້ທີ່ຢູ່ອີເມລຂອງທ່ານ.

ເພື່ອຢືນຢັນ ແລະ ເປີດນຳໃຊ້ການເຊື່ອມຕໍ່ກັບຊຸດກ່ອນໜ້າທາງຂອງທ່ານ, ກະລຸນາໄປທີ່

{$a->link}

ຢູ່ໃນໂປຼແກຼມຈົດໝາຍສ່ວນໃຫຍ່, ສິ່ງນີ້ຄວນປະກົດເປັນລິ້ງສີຟ້າທີ່ທ່ານສາມາດຄລິກໃສ່ໄດ້. ຖ້າສິ່ງນັ້ນບໍ່ເຮັດວຽກ, ຈາກນັ້ນຕັດ ແລະ ວາງທີ່ຢູ່ໃສ່ໃນແຖວທີ່ຢູ່ຢູ່ເທິງສຸດຂອງຕົວທ່ອງເວັບຂອງທ່ານ.

ຖ້າທ່ານຕ້ອງການຄວາມຊ່ວຍເຫຼືອ, ກະລຸນາຕິດຕໍ່ຫາຜູ້ຄວບຄຸມເວັບໄຊທ໌,
{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: ການຢືນຢັນອີເມລຊຸດກ່ອນໜ້າປ້າຍ';
$string['backpackemailverifypending'] = 'ການຢືນຢັນອີເມລໄດ້ຖືກສົ່ງໄປຫາ <strong>{$a}</strong>. ຄລິກທີ່ລິ້ງການຢືນຢັນໃນອີເມລເພື່ອເປີດໃຊ້ການເຊື່ອມຕໍ່ ຊຸດກ່ອນໜ້າ ຂອງທ່ານ.';
$string['backpackemailverifysuccess'] = 'ຂອບໃຈສໍາລັບການຢືນຢັນທີ່ຢູ່ອີເມລຂອງທ່ານ. ດຽວນີ້ທ່ານເຊື່ອມຕໍ່ກັບຊຸດກ່ອນໜ້າຂອງທ່ານແລ້ວ.';
$string['backpackemailverifytokenmismatch'] = 'ໂທເຄັນໃນລິ້ງທີ່ທ່ານຄລິກເຂົ້າໄປນັ້ນບໍ່ກົງກັບໂທເຄັນທີ່ເກັບໄວ້. ກວດໃຫ້ແນ່ໃຈວ່າ ທ່ານໄດ້ຄລິກໃສ່ການເຊື່ອມຕໍ່ໃນອີເມລລ້າສຸດທີ່ທ່ານໄດ້ຮັບ.';
$string['backpackexporterror'] = 'ບໍ່ສາມາດສົ່ງປ້າຍອອກໄປໃສ່ຊຸດກ່ອນໜ້າໄດ້';
$string['backpackimport'] = 'ການຕັ້ງຄ່າການນຳເຂົ້າປ້າຍ';
$string['backpackimport_help'] = 'ຫຼັງຈາກການເຊື່ອມຕໍ່ຊຸດກ່ອນໜ້າໄດ້ຖືກສ້າງຕັ້ງຂຶ້ນຢ່າງສໍາເລັດຜົນ, ປ້າຍຈາກຊຸດກ່ອນໜ້າຂອງທ່ານສາມາດຖືກສະແດງຢູ່ໃນໜ້າປ້າຍ ແລະ ໜ້າໂປຼໄຟລຂອງທ່ານ.

ຢູ່ໃນພື້ນທີ່ນີ້, ທ່ານສາມາດເລືອກຄັງສະສົມປ້າຍຈາກຊຸດກ່ອນໜ້າຂອງທ່ານທີ່ທ່ານຢາກສະແດງໃນໂປຼໄຟລ໌ຂອງທ່ານ.';
$string['backpackneedsupdate'] = 'ຊຸດກ່ອນໜ້າທີ່ເຊື່ອມຕໍ່ກັບໂປຼໄຟລ໌ນີ້ບໍ່ກົງກັບຊຸດກ່ອນໜ້າສໍາລັບເວັບໄຊທ໌. ທ່ານຈຳເປັນຕ້ອງຕັດການເຊື່ອມຕໍ່ ແລະ ເຊື່ອມຕໍ່ກັບຄືນສູ່ຊຸດກ່ອນໜ້າ.';
$string['backpackprovider'] = 'ຜູ້ສະໜອງຊຸດກ່ອນໜ້າ';
$string['backpacksettings'] = 'ການຕັ້ງຄ່າຊຸດກ່ອນໜ້າ';
$string['backpackweburl'] = 'URL ຊຸດກ່ອນໜ້າ';
$string['badgedetails'] = 'ລາຍລະອຽດປ້າຍ';
$string['badgeimage'] = 'ຮູບພາບ';
$string['badgeimage_help'] = 'ຮູບພາບຄວນມີຂະໜາດຢ່າງໜ້ອຍ 300 x 300 ພິກເຊວ. ມັນຈະຖືກສະແດງເປັນ 300 x 300 ພິກເຊວຢູ່ໃນໜ້າປ້າຍ ແລະ 100 x 100 ພິກເຊວຢູ່ໃນໜ້າໂປຼໄຟລ໌ຂອງຜູ້ໃຊ້.';
$string['badgeprivacysetting'] = 'ການຕັ້ງຄ່າຄວາມເປັນສ່ວນຕົວປ້າຍ';
$string['badgeprivacysetting_help'] = 'ປ້າຍທີ່ທ່ານໄດ້ຮັບສາມາດສະແດງຢູ່ໃນໜ້າໂປຼໄຟລ໌ບັນຊີຂອງທ່ານ. ການຕັ້ງຄ່ານີ້ອະນຸຍາດໃຫ້ທ່ານຕັ້ງການເບິ່ງເຫັນປ້າຍທີ່ຫາກໍ່ໄດ້ຮັບໃໝ່ອັດຕະໂນມັດ.

ທ່ານຍັງສາມາດຄວບຄຸມການຕັ້ງຄ່າຄວາມເປັນສ່ວນຕົວປ້າຍບຸກຄົນຢູ່ໃນໜ້າປ້າຍຂອງທ່ານໄດ້.';
$string['badgeprivacysetting_str'] = 'ສະແດງປ້າຍອັດຕະໂນມັດທີ່ຂ້ອຍໄດ້ຮັບໃນໜ້າໂປຼໄຟລ໌ຂອງຂ້ອຍ';
$string['badges'] = 'ປ້າຍ';
$string['badgesalt'] = 'ເກືອສຳລັບແຮສທີ່ຢູ່ອີເມວຂອງຜູ້ຮັບ';
$string['badgesalt_desc'] = 'ການໃຊ້ແຮສອະນຸຍາດໃຫ້ການບໍລິການຊຸດກ່ອນໜ້າຢືນຢັນຜູ້ຮັບປ້າຍໂດຍບໍ່ຕ້ອງເປີດເຜີຍທີ່ຢູ່ອີເມວຂອງເຂົາເຈົ້າ. ການຕັ້ງຄ່ານີ້ຄວນໃຊ້ຕົວເລກ ແລະ ຕົວອັກສອນເທົ່ານັ້ນ.

ໝາຍເຫດ: ສໍາລັບຈຸດປະສົງການຢືນຢັນຜູ້ຮັບ, ກະລຸນາຫຼີກເວັ້ນການປ່ຽນແປງການຕັ້ງຄ່ານີ້ເມື່ອທ່ານເລີ່ມອອກປ້າຍ.';
$string['badgesdisabled'] = 'ບໍ່ໄດ້ເປີດໃຊ້ປ້າຍຢູ່ໃນເວັບໄຊທ໌ນີ້.';
$string['badgesearned'] = 'ຈຳນວນປ້າຍທີ່ໄດ້ຮັບ: {$a}';
$string['badgesettings'] = 'ການຕັ້ງຄ່າປ້າຍ';
$string['badgestatus_0'] = 'ບໍ່ມີໃຫ້ຜູ້ໃຊ້';
$string['badgestatus_1'] = 'ມີໃຫ້ຜູ້ໃຊ້';
$string['badgestatus_2'] = 'ບໍ່ມີໃຫ້ຜູ້ໃຊ້';
$string['badgestatus_3'] = 'ມີໃຫ້ຜູ້ໃຊ້';
$string['badgestatus_4'] = 'ເກັບເຂົ້າແຟ້ມແລ້ວ';
$string['badgestoearn'] = 'ຈຳນວນປ້າຍທີ່ມີຢູ່: {$a}';
$string['badgesview'] = 'ປ້າຍລາຍວິຊາ';
$string['badgeurl'] = 'ລິ້ງປ້າຍທີ່ອອກແລ້ວ';
$string['balignment'] = 'ການຈັດຕຳແໜ່ງ ({$a})';
$string['bawards'] = 'ຜູ້ຮັບ ({$a})';
$string['bcriteria'] = 'ມາດຖານ';
$string['bdetails'] = 'ແກ້ໄຂລາຍລະອຽດ';
$string['bendorsement'] = 'ການຮັບຮອງ';
$string['bmessage'] = 'ຂໍ້ຄວາມ';
$string['boverview'] = 'ພາບລວມ';
$string['brelated'] = 'ປ້າຍທີ່ກ່ຽວຂ້ອງ ({$a})';
$string['bydate'] = 'ສຳເລັດໂດຍ';
$string['claim'] = 'ອ້າງສິດ';
$string['claimcomment'] = 'ການຮັບຮອງຄຳຄິດເຫັນ';
$string['claimid'] = 'ອ້າງສິດ URL';
$string['clearsettings'] = 'ລຶບລ້າງການຕັ້ງຄ່າ';
$string['completioninfo'] = 'ປ້າຍນີ້ອອກໃຫ້ສໍາເລັດ:';
$string['completionnotenabled'] = 'ລາຍວິຊານີ້ບໍ່ໄດ້ຖືກເປີດໃຊ້ສໍາລັບວິຊານີ້, ສະນັ້ນມັນບໍ່ສາມາດຖືກລວມເຂົ້າໃນເງື່ອນໄຂປ້າຍ. ການສຳເລັດວິຊາອາດຈະຖືກເປີດນຳໃຊ້ໃນການຕັ້ງຄ່າວິຊາ.';
$string['configenablebadges'] = 'ຖ້າເປີດໃຊ້ງານ, ຄຸນສົມບັດນີ້ສາມາດເຮັດໃຫ້ທ່ານສ້າງປ້າຍ ແລະ ມອບລາງວັນໃຫ້ກັບຜູ້ໃຊ້ເວັບໄຊທ໌.';
$string['configuremessage'] = 'ຂໍ້ຄວາມປ້າຍ';
$string['connect'] = 'ເຊື່ອມຕໍ່';
$string['connected'] = 'ເຊື່ອມຕໍ່ແລ້ວ';
$string['connecting'] = 'ກຳລັງເຊື່ອມຕໍ່';
$string['contact'] = 'ຕິດຕໍ່';
$string['contact_help'] = 'ທີ່ຢູ່ອີເມວທີ່ເຊື່ອມໂຍງກັບຜູ້ອອກປ້າຍ.';
$string['copyof'] = 'ສຳເນົາຂອງ {$a}';
$string['course'] = 'ລາຍວິຊາ: {$a}';
$string['coursebadges'] = 'ປ້າຍ';
$string['coursebadgesdisabled'] = 'ບໍ່ໄດ້ເປີດໃຊ້ປ້າຍລາຍວິຊາຢູ່ໃນເວັບໄຊທ໌ນີ້.';
$string['coursebadgetitle'] = 'ປ້າຍຫຼັກສູດ {$a}';
$string['coursecompletion'] = 'ຜູ້ໃຊ້ຕ້ອງສໍາເລັດລາຍວິຊານີ້.';
$string['create'] = 'ປ້າຍໃໝ່';
$string['createbutton'] = 'ສ້າງປ້າຍ';
$string['creatorbody'] = '<p>{$a->user} ໄດ້ສໍາເລັດຄວາມຕ້ອງການປ້າຍທັງໝົດ ແລະ ໄດ້ຮັບລາງວັນປ້າຍດັ່ງກ່າວແລ້ວ. ເບິ່ງປ້າຍທີ່ອອກໃຫ້ແລ້ວທີ່ {$a->link} </p>';
$string['creatorsubject'] = '\'{$a}\' ໄດ້ຮັບລາງວັນແລ້ວ!';
$string['criteria_0'] = 'ປ້າຍນີ້ແມ່ນໄດ້ຮັບລາງວັນເມື່ອ...';
$string['criteria_1'] = 'ກິດຈະກໍາສໍາເລັດ';
$string['criteria_1_help'] = 'ອະນຸຍາດໃຫ້ປ້າຍເປັນລາງວັນໃຫ້ກັບຜູ້ໃຊ້ໂດຍອີງຕາມການສໍາເລັດຂອງກິດຈະກໍາພາຍໃນຫຼັກສູດ.';
$string['criteria_2'] = 'ບັນຫາຄູ່ມືຕາມບົດບາດ';
$string['criteria_2_help'] = 'ອະນຸຍາດໃຫ້ປ້າຍໄດ້ຮັບລາງວັນດ້ວຍຕົນເອງໂດຍຜູ້ໃຊ້ທີ່ມີບົດບາດສະເພາະພາຍໃນເວັບໄຊທຼ ຫຼື ລາຍວິຊາ.';
$string['criteria_3'] = 'ການມີສ່ວນຮ່ວມຂອງສັງຄົມ';
$string['criteria_3_help'] = 'ສັງຄົມ';
$string['criteria_4'] = 'ລາຍວິຊາສຳເລັດ';
$string['criteria_4_help'] = 'ອະນຸຍາດໃຫ້ປ້າຍເປັນລາງວັນໃຫ້ຜູ້ໃຊ້ທີ່ຮຽນຈົບຫຼັກສູດແລ້ວ. ມາດຖານນີ້ສາມາດມີຕົວກໍານົດການເພີ່ມເຕີມເຊັ່ນ: ຄະແນນຕ່ຳສຸດທີ່ ແລະ ວັນທີຂອງການສໍາເລັດລາຍວິຊາ.';
$string['criteria_5'] = 'ສໍາເລັດຊຸດວິຊາ';
$string['criteria_5_help'] = 'ອະນຸຍາດໃຫ້ປ້າຍເປັນລາງວັນໃຫ້ກັບຜູ້ໃຊ້ທີ່ໄດ້ສໍາເລັດຊຸດວິຊາແລ້ວ. ແຕ່ລະຫຼັກສູດສາມາດມີຕົວກໍານົດການເພີ່ມເຕີມເຊັ່ນ: ຊັ້ນຕ່ຳສຸດ ແລະ ວັນທີຂອງການສໍາເລັດລາຍວິຊາ.';
$string['criteria_6'] = 'ໂປຼໄຟລ໌ສຳເລັດ';
$string['criteria_6_help'] = 'ອະນຸຍາດໃຫ້ປ້າຍເປັນລາງວັນໃຫ້ກັບຜູ້ໃຊ້ສໍາລັບການສຳເລັດບາງບ່ອນຢູ່ໃນໂປຼໄຟລ໌ຂອງເຂົາເຈົ້າ. ທ່ານສາມາດເລືອກຈາກຊ່ອງຂໍ້ມູນໂປຼໄຟລ໌ມາດຕະຖານ ແລະ ກໍານົດເອງທີ່ມີໃຫ້ກັບຜູ້ໃຊ້.';
$string['criteria_7'] = 'ປ້າຍທີ່ໄດ້ຮັບລາງວັນ';
$string['criteria_7_help'] = 'ອະນຸຍາດໃຫ້ປ້າຍເປັນລາງວັນໃຫ້ກັບຜູ້ໃຊ້ໂດຍອີງຕາມປ້າຍອື່ນທີ່ເຂົາເຈົ້າໄດ້ຮັບ.';
$string['criteria_8'] = 'ກຸ່ມສະມາຊິກ';
$string['criteria_8_help'] = 'ອະນຸຍາດໃຫ້ລາງວັນໃຫ້ຜູ້ໃຊ້ອີງຕາມການເປັນສະມາຊິກກຸ່ມ.';
$string['criteria_9'] = 'ຄວາມສາມາດ';
$string['criteria_9_help'] = 'ອະນຸຍາດໃຫ້ປ້າຍເປັນລາງວັນໃຫ້ກັບຜູ້ໃຊ້ໂດຍອີງຕາມຄວາມສາມາດທີ່ເຂົາເຈົ້າໄດ້ເຮັດສໍາເລັດ.';
$string['criteria_descr'] = 'ຜູ້ໃຊ້ຈະໄດ້ຮັບເຄື່ອງໝາຍນີ້ເມື່ອເຂົາເຈົ້າເຮັດຕາມຂໍ້ກໍານົດຕໍ່ໄປນີ້:';
$string['criteria_descr_0'] = 'ຕື່ມຂໍ້ມູນ <strong>{$a}</strong> ໃຫ້ຄົບຕາມທີ່ໄດ້ກໍານົດໄວ້.';
$string['criteria_descr_1'] = '<strong>{$ a}</strong> ກິດຈະກໍາທີ່ສໍາເລັດແລ້ວມີດັ່ງຕໍ່ໄປນີ້:';
$string['criteria_descr_2'] = 'ປ້າຍນີ້ຈະຕ້ອງໄດ້ຮັບລາງວັນໂດຍຜູ້ໃຊ້ດ້ວຍ <strong>{$a}</strong> ຂອງໜ້າທີ່ຕໍ່ໄປນີ້:';
$string['criteria_descr_4'] = 'ຜູ້ໃຊ້ຕ້ອງສໍາເລັດລາຍວິຊາ';
$string['criteria_descr_5'] = '<strong>{$a}</strong> ຂອງລາຍວິຊາທີ່ຕ້ອງຮຽນໃຫ້ຈົບມີດັ່ງນີ້:';
$string['criteria_descr_6'] = '<strong>{$a}</strong> ຂອງຊ່ອງໂປຼໄຟລ໌ຜູ້ໃຊ້ທີ່ຕ້ອງໄດ້ເຮັດໃຫ້ສໍາເລັດມີດັ່ງນີ້:';
$string['criteria_descr_7'] = '<strong>{$a}</strong> ຂອງປ້າຍທີ່ຕ້ອງໄດ້ຮັບມີດັ່ງຕໍ່ໄປນີ້:';
$string['criteria_descr_8'] = 'ຕ້ອງເປັນສະມາຊິກໃນ <strong>{$a}</strong> ຂອງກຸ່ມຕໍ່ໄປນີ້:';
$string['criteria_descr_9'] = '<strong>{$ a}</strong> ຂອງຄວາມສາມາດທີ່ຕ້ອງໄດ້ສໍາເລັດມີດັ່ງຕໍ່ໄປນີ້:';
$string['criteria_descr_bydate'] = 'ໂດຍ <em>{$a}</em>';
$string['criteria_descr_grade'] = 'ກັບຄະແນນຕ່ຳສຸດຂອງ <em>{$a}</em>';
$string['criteria_descr_short0'] = 'ເຮັດສຳເລັດ <strong>{$a}</strong> ຂອງ:';
$string['criteria_descr_short1'] = 'ເຮັດສຳເລັດ <strong>{$a}</strong> ຂອງ:';
$string['criteria_descr_short2'] = 'ໄດ້ຮັບລາງວັນໂດຍ <strong>{$a}</strong> ຈາກ:';
$string['criteria_descr_short4'] = 'ເຮັດສຳເລັດລາຍວິຊາ';
$string['criteria_descr_short5'] = 'ເຮັດສຳເລັດ <strong>{$a}</strong> ຂອງ:';
$string['criteria_descr_short6'] = 'ເຮັດສຳເລັດ <strong>{$a}</strong> ຂອງ:';
$string['criteria_descr_short7'] = 'ເຮັດສຳເລັດ <strong>{$a}</strong> ຂອງ:';
$string['criteria_descr_short8'] = 'ການເປັນສະມາຊິກກຸ່ມໃນ <strong>{$a}</strong> ຂອງ:';
$string['criteria_descr_short9'] = 'ເຮັດສຳເລັດ <strong>{$a}</strong> ຂອງ:';
$string['criteria_descr_single_1'] = 'ບັນດາກິດຈະກໍາທີ່ຕ້ອງເຮັດໃຫ້ສໍາເລັດມີດັ່ງຕໍ່ໄປນີ້:';
$string['criteria_descr_single_2'] = 'ປ້າຍນີ້ຈະຕ້ອງໄດ້ຮັບລາງວັນໂດຍຜູ້ໃຊ້ທີ່ມີໜ້າທີ່ດັ່ງຕໍ່ໄປນີ້:';
$string['criteria_descr_single_4'] = 'ຜູ້ໃຊ້ຕ້ອງສໍາເລັດລາຍວິຊາ';
$string['criteria_descr_single_5'] = 'ຕ້ອງໄດ້ສໍາເລັດລາຍວິຊາດັ່ງຕໍ່ໄປນີ້:';
$string['criteria_descr_single_6'] = 'ຊ່ອງຂໍ້ມູນໂປຼໄຟລ໌ຜູ້ໃຊ້ຕໍ່ໄປນີ້ຕ້ອງເຮັດໃຫ້ສໍາເລັດ:';
$string['criteria_descr_single_7'] = 'ປ້າຍທີ່ຕ້ອງໄດ້ຮັບມີດັ່ງນີ້:';
$string['criteria_descr_single_8'] = 'ຕ້ອງເປັນສະມາຊິກໃນກຸ່ມຕໍ່ໄປນີ້:';
$string['criteria_descr_single_9'] = 'ບັນດາຄວາມສາມາດທີ່ຕ້ອງໄດ້ສໍາເລັດມີດັ່ງຕໍ່ໄປນີ້:';
$string['criteria_descr_single_short1'] = 'ສຳເລັດ:';
$string['criteria_descr_single_short2'] = 'ໃຫ້ລາງວັນໂດຍ:';
$string['criteria_descr_single_short4'] = 'ສຳເລັດວິຊາ';
$string['criteria_descr_single_short5'] = 'ສຳເລັດ:';
$string['criteria_descr_single_short6'] = 'ສຳເລັດ:';
$string['criteria_descr_single_short7'] = 'ສຳເລັດ:';
$string['criteria_descr_single_short8'] = 'ສະມາຊິກໃນ:';
$string['criteria_descr_single_short9'] = 'ສຳເລັດ:';
$string['criteriacreated'] = 'ສ້າງເກນປ້າຍສຳເລັດແລ້ວ';
$string['criteriadeleted'] = 'ລຶບເກນປ້າຍສຳເລັດແລ້ວ';
$string['criteriasummary'] = 'ສະຫຼຸບມາດຖານ';
$string['criteriaupdated'] = 'ອັບເດດເກນປ້າຍສຳເລັດແລ້ວ';
$string['criterror'] = 'ບັນຫາຕົວກໍານົດການໃນປະຈຸບັນ';
$string['criterror_help'] = 'ຊ່ອງຂໍ້ມູນນີ້ສະແດງໃຫ້ເຫັນຕົວກໍານົດການທັງໝົດທີ່ໄດ້ຖືກເພີ່ມໃສ່ໃນເບື້ອງຕົ້ນໃສ່ກັບຄວາມຕ້ອງການປ້າຍນີ້ແຕ່ບໍ່ສາມາດໃຊ້ໄດ້ອີກຕໍ່ໄປ. ມັນໄດ້ຖືກແນະນໍາໃຫ້ທ່ານຍົກເລີກການກວດກາຕົວກໍານົດດັ່ງກ່າວເພື່ອໃຫ້ແນ່ໃຈວ່າຜູ້ໃຊ້ສາມາດໄດ້ຮັບປ້າຍນີ້ໃນອະນາຄົດ.';
$string['currentimage'] = 'ຮູບພາບໃນປະຈຸບັນ';
$string['currentstatus'] = 'ສະຖານະປະຈຸບັນ:';
$string['dateawarded'] = 'ວັນທີ່ອອກໃຫ້';
$string['dateearned'] = 'ວັນທີ: {$a}';
$string['day'] = 'ມື້';
$string['deactivate'] = 'ປິດໃຊ້ງານການເຂົ້າເຖິງ';
$string['deactivatesuccess'] = 'ການເຂົ້າເຖິງປ້າຍຖືກປິດການນຳໃຊ້ສຳເລັດ.';
$string['defaultissuercontact'] = 'ທີ່ຢູ່ອີເມລຜູ້ອອກປ້າຍ';
$string['defaultissuercontact_desc'] = 'ທີ່ຢູ່ອີເມລທີ່ເຊື່ອມໂຍງກັບຜູ້ອອກປ້າຍ. ສໍາລັບກະເປົາສະພາຍ Open Badges v2.0, ສິ່ງນີ້ຈະໃຊ້ສໍາລັບການກວດສອບຄວາມຖືກຕ້ອງເມື່ອເຜີຍແຜ່ປ້າຍໃສ່ຊຸດກ່ອນໜ້າ.';
$string['defaultissuername'] = 'ຊື່ຜູ້ອອກປ້າຍ';
$string['defaultissuername_desc'] = 'ຊື່ຂອງຕົວແທນ ຫຼື ຜູ້ມີອຳນາດອອກໃຫ້.';
$string['defaultissuerpassword'] = 'ລະຫັດຜ່ານຜູ້ອອກປ້າຍ';
$string['defaultissuerpassword_help'] = 'ບັນຊີແມ່ນຕ້ອງການຢູ່ໃນເວັບໄຊທ໌ກະເປົາສະພາຍທີ່ມີທີ່ຢູ່ອີເມລຕາມທີ່ລະບຸໄວ້ຢູ່ໃນການຕັ້ງທີ່ຢູ່ອີເມລຂອງຜູ້ອອກປ້າຍໃນການຕັ້ງຄ່າການບໍລິຫານເວັບໄຊທ໌ / ປ້າຍ / ການຕັ້ງຄ່າປ້າຍ. ລະຫັດຜ່ານສຳລັບບັນຊີຄວນຈະຖືກປ້ອນໃສ່ທີ່ນີ້.';
$string['delbadge'] = 'ທ່ານຕ້ອງການລຶບປ້າຍ \'{$a}\' ແລະ ລຶບປ້າຍທີ່ອອກໃຫ້ແລ້ວທັງໝົດອອກຫຼືບໍ?';
$string['delconfirm'] = 'ລຶບ ແລະ ເອົາປ້າຍທີ່ອອກແລ້ວອອກ';
$string['delcritconfirm'] = 'ທ່ານແນ່ໃຈບໍວ່າ ທ່ານຕ້ອງການລຶບເກນນີ້?';
$string['deletehelp'] = '<p>ການລຶບປ້າຍອອກໝາຍຄວາມວ່າ ການບັນທຶກຂໍ້ມູນ ແລະ ເກນທັງໝົດຂອງມັນຈະຖືກລຶບອອກຖາວອນ. ຜູ້ໃຊ້ທີ່ໄດ້ຮັບປ້າຍນີ້ຈະບໍ່ສາມາດເຂົ້າຫາມັນ ແລະ ສະແດງມັນຢູ່ໃນໜ້າໂປຼໄຟລ໌ຂອງເຂົາເຈົ້າໄດ້.</p>
<p>ໝາຍເຫດ: ຜູ້ໃຊ້ທີ່ໄດ້ຮັບປ້າຍນີ້ ແລະ ໄດ້ຍູ້ມັນໃສ່ຊຸດກ່ອນໜ້າພາຍນອກຂອງເຂົາເຈົ້າແລ້ວ, ຈະຍັງມີປ້າຍນີ້ຢູ່ໃນຊຸດກ່ອນໜ້າພາຍນອກຂອງເຂົາເຈົ້າຢູ່. ຢ່າງໃດກໍ່ຕາມ, ເຂົາເຈົ້າຈະບໍ່ສາມາດເຂົ້າຫາເງື່ອນໄຂ ແລະ ໜ້າຫຼັກຖານທີ່ເຊື່ອມຕໍ່ກັບຄືນຫາເວັບໄຊທ໌ນີ້ໄດ້.</p>';
$string['delexternalbackpack'] = 'ລຶບຊຸດກ່ອນໜ້າເວັບໄຊທ໌';
$string['delexternalbackpackconfirm'] = 'ລຶບຊຸດກ່ອນໜ້າເວັບໄຊທ໌ \'{$a}\' ບໍ?';
$string['delparamconfirm'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການລຶບພາລາມິເຕີນີ້ອອກ?';
$string['description'] = 'ລາຍລະອຽດ';
$string['disconnect'] = 'ຢຸດການເຊື່ອມຕໍ່';
$string['donotaward'] = 'ປະຈຸບັນ, ປ້າຍນີ້ບໍ່ມີການນຳໃຊ້, ສະນັ້ນ ມັນບໍ່ສາມາດມອບລາງວັນໃຫ້ກັບຜູ້ໃຊ້ໄດ້. ຖ້າເຈົ້າຕ້ອງການໃຫ້ລາງວັນປ້າຍນີ້, ກະລຸນາຕັ້ງສະຖານະຂອງມັນໃຫ້ເປີດນຳໃຊ້.';
$string['editsettings'] = 'ແກ້ໄຂການຕັ້ງຄ່າ';
$string['enablebadges'] = 'ເປີດໃຊ້ງານປ້າຍ';
$string['endorsement'] = 'ການຮັບຮອງ';
$string['error:backpackdatainvalid'] = 'ຂໍ້ມູນຄືນຈາກຊຸດກ່ອນໜ້າແມ່ນບໍ່ຖືກຕ້ອງ.';
$string['error:backpackemailnotfound'] = 'ອີເມລ \'{$ a}\' ບໍ່ກ່ຽວຂ້ອງກັບຊຸດກ່ອນໜ້າ. ເຈົ້າຕ້ອງ <a href="http://backpack.openbadges.org">ສ້າງຊຸດກ່ອນໜ້າ</a> ສໍາລັບບັນຊີນັ້ນ ຫຼື ເຂົ້າສູ່ລະບົບດ້ວຍທີ່ຢູ່ອີເມວອື່ນ.';
$string['error:backpacknotavailable'] = 'ເວັບໄຊທ໌ຂອງທ່ານບໍ່ສາມາດເຂົ້າເຖິງໄດ້ຈາກອິນເຕີເນັດ, ສະນັ້ນ ປ້າຍໃດທີ່ອອກມາຈາກເວັບໄຊທ໌ນີ້ ບໍ່ສາມາດກວດສອບໄດ້ໂດຍການບໍລິການຊຸດກ່ອນໜ້າພາຍນອກ.';
$string['error:backpackproblem'] = 'ເກີດບັນຫາໃນການເຊື່ອມຕໍ່ຫາຜູ້ໃຫ້ບໍລິການຊຸດກ່ອນໜ້າຂອງທ່ານ. ກະລຸນາລອງໃໝ່ພາຍຫຼັງ.';
$string['error:badgeawardnotfound'] = 'ບໍ່ສາມາດຢືນຢັນປ້າຍທີ່ໄດ້ຮັບລາງວັນນີ້ໄດ້. ປ້າຍນີ້ອາດຈະຖືກຖອດຖອນແລ້ວ.';
$string['error:badgenotfound'] = 'ບໍ່ພົບປ້າຍ';
$string['error:cannotact'] = 'ບໍ່ສາມາດເປີດນຳໃຊ້ປ້າຍໄດ້.';
$string['error:cannotawardbadge'] = 'ບໍ່ສາມາດມອບປ້າຍໃຫ້ຜູ້ໃຊ້ໄດ້.';
$string['error:cannotdeletecriterion'] = 'ບໍ່ສາມາດລຶບເກນນີ້ໄດ້.';
$string['error:cannotrevokebadge'] = 'ບໍ່ສາມາດຖອນປ້າຍຈາກຜູ້ໃຊ້ໄດ້.';
$string['error:clone'] = 'ບໍ່ສາມາດສໍາເນົາປ້າຍໄດ້.';
$string['error:connectionunknownreason'] = 'ການເຊື່ອມຕໍ່ບໍ່ປະສົບຜົນສຳເລັດແຕ່ບໍ່ໄດ້ໃຫ້ເຫດຜົນ.';
$string['error:duplicatename'] = 'ປ້າຍທີ່ມີຊື່ດັ່ງກ່າວມີຢູ່ແລ້ວໃນລະບົບ.';
$string['error:externalbadgedoesntexist'] = 'ບໍ່ພົບປ້າຍ';
$string['error:guestuseraccess'] = 'ປະຈຸບັນທ່ານກຳລັງໃຊ້ການເຂົ້າຫາໂດຍແຂກ. ເພື່ອເບິ່ງປ້າຍທ່ານຕ້ອງເຂົ້າສູ່ລະບົບດ້ວຍບັນຊີຜູ້ໃຊ້ຂອງທ່ານ.';
$string['error:invalidcriteriatype'] = 'ປະເພດເກນບໍ່ຖືກຕ້ອງ.';
$string['error:invalidexpiredate'] = 'ວັນໝົດອາຍຸຈະຕ້ອງຢູ່ໃນອະນາຄົດ.';
$string['error:invalidexpireperiod'] = 'ໄລຍະເວລາໝົດອາຍຸບໍ່ສາມາດເປັນລົບ ຫຼື ເທົ່າກັບ 0 ໄດ້.';
$string['error:invalidparambadge'] = 'ບໍ່ມີປ້າຍ.';
$string['error:invalidparamcohort'] = 'ບໍ່ມີກຸ່ມ.';
$string['error:noactivities'] = 'ບໍ່ມີກິດຈະກໍາໃດໜຶ່ງທີ່ເປີດໃຊ້ເກນການສໍາເລັດຢູ່ໃນລາຍວິຊານີ້.';
$string['error:nobadges'] = 'ປະຈຸບັນບໍ່ມີປ້າຍທີ່ມີການເປີດໃຫ້ເຂົ້າຫາໄດ້ຖືກເພີ່ມເຂົ້າເປັນເກນ. ປ້າຍເວັບໄຊທ໌ສາມາດມີປ້າຍເວັບໄຊທ໌ອື່ນເທົ່ານັ້ນຕາມເກນ. ປ້າຍລາຍວິຊາສາມມາດມີປ້າຍລາຍວິຊາອື່ນ ຫຼື ປ້າຍເວັບໄຊທ໌ຕາມເກນ.';
$string['error:nocohorts'] = 'ບໍ່ມີກຸ່ມ';
$string['error:nocourses'] = 'ການສຳເລັດລາຍວິຊາບໍ່ໄດ້ຖືກເປີດໃຊ້ສໍາລັບວິຊາໃດໜຶ່ງຢູ່ໃນເວັບໄຊທ໌ນີ້, ສະນັ້ນ ບໍ່ມີອັນໃດສາມາດສະແດງໄດ້. ການສຳເລັດລາຍວິຊາອາດຈະຖືກເປີດນຳໃຊ້ໃນການຕັ້ງຄ່າລາຍວິຊາ.';
$string['error:nogroupslink'] = '<p>ສະແດງສະເພາະຄັງສະສົມສາທາລະນະ. <a href="{$a}" target="_blank" rel="nofollow">ເບິ່ງຊຸດກ່ອນໜ້າຂອງທ່ານ</a> ເພື່ອສ້າງຄັງສະສົມສາທາລະນະ.</p>';
$string['error:nogroupssummary'] = '<p>ບໍ່ມີການສະສົມປ້າຍສາທາລະນະຢູ່ໃນຊຸດກ່ອນໜ້າຂອງທ່ານ.</p>';
$string['error:nopermissiontoview'] = 'ທ່ານບໍ່ມີສິດອະນຸຍາດໃຫ້ເບິ່ງຜູ້ຮັບປ້າຍ';
$string['error:nosuchbadge'] = 'ບໍ່ມີປ້າຍທີ່ມີ ID {$a}.';
$string['error:nosuchcohort'] = 'ຄຳເຕືອນ: ກຸ່ມນີ້ບໍ່ມີອີກແລ້ວ.';
$string['error:nosuchcourse'] = 'ຄຳເຕືອນ: ກຸ່ມນີ້ບໍ່ມີອີກແລ້ວ.';
$string['error:nosuchfield'] = 'ຄຳເຕືອນ: ຊ່ອງຂໍ້ມູນໂປຼໄຟລ໌ຜູ້ໃຊ້ນີ້ບໍ່ມີອີກແລ້ວ.';
$string['error:nosuchmod'] = 'ຄຳເຕືອນ: ກິດຈະກຳນີ້ບໍ່ມີອີກແລ້ວ.';
$string['error:nosuchrole'] = 'ຄຳເຕືອນ: ບໍ່ມີໜ້າທີ່ນີ້ອີກຕໍ່ໄປ.';
$string['error:nosuchuser'] = 'ຜູ້ໃຊ້ທີ່ມີທີ່ຢູ່ອີເມລນີ້ ບໍ່ມີບັນຊີກັບຜູ້ໃຫ້ບໍລິການຊຸດກ່ອນໜ້າໃນປະຈຸບັນ.';
$string['error:notifycoursedate'] = 'ຄໍາເຕືອນ: ປ້າຍທີ່ກ່ຽວຂ້ອງກັບລາຍວິຊາ ແລະ ການສໍາເລັດກິດຈະກໍາຈະບໍ່ອອກໃຫ້ຈົນກ່ວາວັນທີເລີ່ມລາຍວິຊາ.';
$string['error:parameter'] = 'ຄຳເຕືອນ: ຄວນເລືອກພາຣາມິເຕີຢ່າງໜ້ອຍໜຶ່ງຕົວເພື່ອຮັບປະກັນຂັ້ນຕອນການອອກປ້າຍທີ່ຖືກຕ້ອງ.';
$string['error:relatedbadgedoesntexist'] = 'ບໍ່ມີປ້າຍສາທາລະນະກັບຕົວລະບຸນີ້';
$string['error:requesterror'] = 'ການຮ້ອງຂໍການເຊື່ອມຕໍ່ບໍ່ສໍາເລັດ (ລະຫັດຜິດພາດ {$a}).';
$string['error:requesttimeout'] = 'ການຮ້ອງຂໍການເຊື່ອມຕໍ່ໝົດເວລາກ່ອນທີ່ມັນຈະສາມາດສໍາເລັດໄດ້.';
$string['error:save'] = 'ບໍ່ສາມາດບັນທຶກປ້າຍໄດ້.';
$string['error:userdeleted'] = '{$a->user} (ຜູ້ໃຊ້ນີ້ບໍ່ມີຢູ່ໃນ {$a->site} ອີກຕໍ່ໄປ))';
$string['eventbadgearchived'] = 'ຈັດເກັບປ້າຍເຂົ້າແຟ້ມແລ້ວ';
$string['eventbadgeawarded'] = 'ໄດ້ຮັບລາງວັນປ້າຍແລ້ວ';
$string['eventbadgecreated'] = 'ສ້າງປ້າຍແລ້ວ';
$string['eventbadgecriteriacreated'] = 'ສ້າງເກນປ້າຍແລ້ວ';
$string['eventbadgecriteriadeleted'] = 'ລຶບເກນປ້າຍແລ້ວ';
$string['eventbadgecriteriaupdated'] = 'ປັບປຸງເກນປ້າຍແລ້ວ';
$string['eventbadgedeleted'] = 'ລຶບປ້າຍແລ້ວ';
$string['eventbadgedisabled'] = 'ປິດໃຊ້ງານປ້າຍແລ້ວ';
$string['eventbadgeduplicated'] = 'ປ້າຍຊ້ຳກັນ';
$string['eventbadgeenabled'] = 'ເປີດໃຊ້ງານປ້າຍ';
$string['eventbadgelistingviewed'] = 'ເບິ່ງລາຍການປ້າຍແລ້ວ';
$string['eventbadgerevoked'] = 'ຖອນປ້າຍແລ້ວ';
$string['eventbadgeupdated'] = 'ປັບປຸງປ້າຍແລ້ວ';
$string['eventbadgeviewed'] = 'ເບິ່ງປ້າຍແລ້ວ';
$string['evidence'] = 'ຫຼັກຖານ';
$string['existingrecipients'] = 'ຜູ້ຮັບປ້າຍທີ່ມີຢູ່';
$string['existsinbackpack'] = 'ມີປ້າຍຢູ່ໃນກະເປົາແລ້ວ';
$string['expired'] = 'ໝົດອາຍຸແລ້ວ';
$string['expiredate'] = 'ປ້າຍນີ້ໝົດອາຍຸໃນວັນທີ {$a}.';
$string['expireddate'] = 'ປ້າຍນີ້ໝົດອາຍຸໃນວັນທີ {$a}.';
$string['expiredin'] = 'ໝົດອາຍຸ {$a}';
$string['expireperiod'] = 'ປ້າຍນີ້ໝົດອາຍຸ {$a} ມື້ຫຼັງຈາກອອກໃຫ້.';
$string['expireperiodh'] = 'ປ້າຍນີ້ໝົດອາຍຸ {$a} ຊົ່ວໂມງ ຫຼັງຈາກອອກໃຫ້.';
$string['expireperiodm'] = 'ປ້າຍນີ້ໝົດອາຍຸ {$a} ນາທີ ຫຼັງຈາກອອກໃຫ້.';
$string['expireperiods'] = 'ປ້າຍນີ້ໝົດອາຍຸ {$a} ວິນາທີ ຫຼັງຈາກອອກໃຫ້.';
$string['expiresin'] = 'ໝົດອາຍຸ {$a}';
$string['expirydate'] = 'ວັນໝົດອາຍຸ';
$string['expirydate_help'] = 'ທາງເລືອກໜຶ່ງ, ປ້າຍສາມາດໝົດອາຍຸໃນວັນທີສະເພາະໃດ ໜຶ່ງ, ຫຼື ວັນທີສາມາດຄິດໄລ່ໄດ້ໂດຍອີງຕາມວັນທີທີ່ປ້າຍດັ່ງກ່າວອອກໃຫ້ຜູ້ໃຊ້.';
$string['externalbadges'] = 'ປ້າຍຂອງຂ້ອຍຈາກເວັບໄຊທ໌ອື່ນໆ';
$string['externalbadges_help'] = 'ພື້ນທີ່ນີ້ສະແດງປ້າຍຈາກກະຊຸດກ່ອນໜ້າພາຍນອກຂອງທ່ານ.';
$string['externalbadgesp'] = 'ປ້າຍຈາກເວັບໄຊທ໌ອື່ນ:';
$string['externalconnectto'] = 'ເພື່ອສະແດງປ້າຍພາຍນອກທ່ານຈະຕ້ອງ <a href="{$a}">ເຊື່ອມຕໍ່ກັບຊຸດກ່ອນໜ້າ</a>.';
$string['fixed'] = 'ວັນທີທີ່ກໍານົດ';
$string['hidden'] = 'ເຊື່ອງໄວ້';
$string['hiddenbadge'] = 'ໂຊກບໍ່ດີ, ເຈົ້າຂອງປ້າຍບໍ່ໄດ້ໃຫ້ຂໍ້ມູນນີ້.';
$string['hostedurl'] = 'URL ພາຍນອກ';
$string['hostedurldescription'] = 'URL ພາຍນອກບ່ອນທີ່ປ້າຍເປັນເຈົ້າພາບ';
$string['imageauthoremail'] = 'ອີເມລຂອງຜູ້ຂຽນຮູບພາບ';
$string['imageauthoremail_help'] = 'ຖ້າລະບຸ, ທີ່ຢູ່ອີເມລຂອງຜູ້ຂຽນຮູບປ້າຍແມ່ນສະແດງຢູ່ໃນໜ້າປ້າຍ.';
$string['imageauthorname'] = 'ຊື່ຜູ້ຂຽນຮູບພາບ';
$string['imageauthorname_help'] = 'ຖ້າລະບຸ, ຊື່ຂອງຜູ້ຂຽນຮູບປ້າຍຈະສະແດງຢູ່ໃນໜ້າປ້າຍ.';
$string['imageauthorurl'] = 'URL ຂອງຜູ້ຂຽນຮູບພາບ';
$string['imageauthorurl_help'] = 'ຖ້າມີການລະບຸ, ການເຊື່ອມຕໍ່ຫາເວັບໄຊທ໌ຂອງເຈົ້າຂອງຮູບພາບປ້າຍຖືກສະແດງຢູ່ໃນໜ້າປ້າຍ. URL ຄວນມີຄຳນຳໜ້າ http:// ຫຼື https://.';
$string['imagecaption'] = 'ຄຳບັນຍາຍຮູບພາບ';
$string['imagecaption_help'] = 'ຖ້າລະບຸ, ຄຳບັນຍາຍຮູບພາບຈະສະແດງຢູ່ໃນໜ້າປ້າຍ.';
$string['includeauthdetails'] = 'ລວມລາຍລະອຽດການກວດສອບຄວາມຖືກຕ້ອງກັບຊຸດກ່ອນໜ້າ';
$string['invalidurl'] = 'URL ບໍ່ຖືກຕ້ອງ';
$string['issuancedetails'] = 'ປ້າຍໝົດອາຍຸ';
$string['issuedbadge'] = 'ອອກຂໍ້ມູນປ້າຍແລ້ວ';
$string['issuedby'] = 'ອອກໃຫ້ໂດຍ {$a}';
$string['issuedon'] = 'ອອກ {$a}';
$string['issuerdetails'] = 'ລາຍລະອຽດຜູ້ອອກໃຫ້';
$string['issueremail'] = 'ອີເມລ';
$string['issueremail_help'] = 'ທີ່ຢູ່ອີເມລຕິດຕໍ່ຂອງອົງການທີ່ອອກໃບຮັບຮອງ.';
$string['issuername'] = 'ຊື່ຜູ້ອອກໃຫ້';
$string['issuername_endorsement'] = 'ຊື່ຜູ້ຮັບຮອງ';
$string['issuername_endorsement_help'] = 'ຊື່ຂອງຜູ້ຮັບຮອງ.';
$string['issuername_help'] = 'ຊື່ຂອງຕົວແທນ ຫຼື ຜູ້ມີອຳນາດອອກໃຫ້.';
$string['issuerurl'] = 'ຜູ້ອອກ URL';
$string['issuerurl_help'] = 'ເວັບໄຊທ໌ຂອງອົງການທີ່ອອກໃບຮັບຮອງ. URL ຄວນມີຄຳນຳໜ້າ http:// ຫຼື https://.';
$string['language'] = 'ພາສາ';
$string['language_help'] = 'ພາສາທີ່ໃຊ້ຢູ່ໃນໜ້າປ້າຍ.';
$string['listbackpacks'] = 'ລາຍຊື່ຂອງຊຸດກ່ອນໜ້າ';
$string['localbadges'] = 'ປ້າຍຂອງຂ້ອຍຈາກເວັບໄຊທ໌ {$a}';
$string['localbadgesh'] = 'ບັນດາປ້າຍຂອງຂ້ອຍຈາກເວັບໄຊທ໌';
$string['localbadgesh_help'] = 'ປ້າຍທັງໝົດທີ່ໄດ້ຮັບພາຍໃນເວັບໄຊທ໌ນີ້ໂດຍການຮຽນສຳເລັດວິຊາ, ກິດຈະກໍາວິຊາ, ແລະ ຂໍ້ກໍານົດອື່ນໆ.

ທ່ານສາມາດຈັດການປ້າຍຂອງທ່ານໄດ້ທີ່ນີ້ໂດຍການເຮັດໃຫ້ພວກມັນເປັນສາທາລະນະ ຫຼື ເປັນສ່ວນຕົວສໍາລັບໜ້າໂປຼໄຟລ໌ຂອງທ່ານ.

ທ່ານສາມາດດາວໂຫຼດປ້າຍທັງໝົດຂອງທ່ານ ຫຼື ແຕ່ລະປ້າຍແຍກກັນ ແລະ ບັນທຶກໄວ້ໃນຄອມພິວເຕີຂອງທ່ານ. ປ້າຍດາວໂຫຼດແລ້ວສາມາດຖືກເພີ່ມໃສ່ການບໍລິການຊຸດກ່ອນໜ້າພາຍນອກຂອງທ່ານ.';
$string['localbadgesp'] = 'ບັນດາປ້າຍຈາກ {$a}:';
$string['localconnectto'] = 'ເພື່ອແບ່ງປັນປ້າຍເຫຼົ່ານີ້ຢູ່ນອກເວັບໄຊທ໌ນີ້, ທ່ານຈໍາເປັນຕ້ອງ <a href="{$a}">ເຊື່ອມຕໍ່ກັບຊຸດກ່ອນໜ້າ</a>.';
$string['makeprivate'] = 'ເຮັດເປັນສ່ວນຕົວ';
$string['makepublic'] = 'ເຮັດເປັນສາທາລະນະ';
$string['managebackpacks'] = 'ຈັດການຊຸດກ່ອນໜ້າ';
$string['managebadges'] = 'ຈັດການປ້າຍ';
$string['message'] = 'ຈັດການໜ່ວຍງານ';
$string['messagebody'] = '<p>ທ່ານໄດ້ຮັບລາງວັນປ້າຍ "%badgename%"!</p>
<p>ຂໍ້ມູນເພີ່ມເຕີມກ່ຽວກັບປ້າຍນີ້ສາມາດພົບໄດ້ຢູ່ໃນໜ້າຂໍ້ມູນປ້າຍ %badgelink%.</p>
<p>ທ່ານສາມາດຈັດການ ແລະ ດາວໂຫຼດປ້າຍໄດ້ຈາກໜ້າ {$a}ຂອງທ່ານ.</p>';
$string['messagesubject'] = 'ຊົມເຊີຍ! ທ່ານຫາກໍ່ໄດ້ຮັບປ້າຍ!';
$string['method'] = 'ມາດຖານນີ້ສົມບູນເມື່ອ...';
$string['mingrade'] = 'ຕ້ອງມີຄະແນນຕໍ່າສຸດ';
$string['month'] = 'ເດືອນ';
$string['moredetails'] = 'ລາຍລະອຽດເພີ່ມຕື່ມ';
$string['mybackpack'] = 'ການຕັ້ງຄ່າຊຸດກ່ອນໜ້າຂອງຂ້ອຍ';
$string['mybadges'] = 'ປ້າຍຂອງຂ້ອຍ';
$string['never'] = 'ບໍ່ເຄີຍ';
$string['newbackpack'] = 'ເພີ່ມຊຸດກ່ອນໜ້າໃໝ່';
$string['newbadge'] = 'ເພີ່ມປ້າຍໃໝ່';
$string['newimage'] = 'ຮູບພາບໃໝ່';
$string['noalignment'] = 'ປ້າຍນີ້ບໍ່ມີທັກສະ ຫຼື ມາດຕະຖານພາຍນອກທີ່ລະບຸໄວ້.';
$string['noawards'] = 'ປ້າຍນີ້ຍັງບໍ່ທັນໄດ້ຮັບເທື່ອ.';
$string['nobackpack'] = 'ບໍ່ມີບໍລິການຊຸດກ່ອນໜ້າເຊື່ອມຕໍ່ກັບບັນຊີນີ້.<br/>';
$string['nobackpackbadgessummary'] = 'ບໍ່ມີປ້າຍໃນຄັງສະສົມທີ່ທ່ານເລືອກໄວ້.';
$string['nobackpackcollectionssummary'] = 'ບໍ່ໄດ້ເລືອກຄັງສະສົມປ້າຍ.';
$string['nobackpacks'] = 'ບໍ່ມີຊຸດກ່ອນໜ້າໃຫ້';
$string['nobadges'] = 'ບໍ່ມີປ້າຍໃຫ້ຜູ້ໃຊ້ຮັບເອົາ.';
$string['nocompetencies'] = 'ບໍ່ໄດ້ເລືອກຄວາມສາມາດ.';
$string['nocriteria'] = 'ຍັງບໍ່ໄດ້ຕັ້ງເກນສຳລັບປ້າຍນີ້ເທື່ອ.';
$string['noendorsement'] = 'ປ້າຍນີ້ບໍ່ມີການຮັບຮອງ.';
$string['noexpiry'] = 'ປ້າຍນີ້ບໍ່ມີວັນໝົດອາຍຸ.';
$string['noparamstoadd'] = 'ບໍ່ມີຕົວກໍານົດການເພີ່ມເຕີມທີ່ມີຢູ່ເພື່ອເພີ່ມຄວາມຕ້ອງການປ້າຍນີ້.';
$string['norelated'] = 'ປ້າຍນີ້ບໍ່ມີປ້າຍທີ່ກ່ຽວຂ້ອງໃດໆ.';
$string['notacceptedrole'] = 'ການມອບໝາຍໜ້າທີ່ປັດຈຸບັນຂອງທ່ານ ບໍ່ໄດ້ຢູ່ໃນໜ້າທີ່ທີ່ສາມາດອອກປ້າຍນີ້ດ້ວຍຕົນເອງໄດ້.<br/>
ຖ້າທ່ານຢາກເຫັນຜູ້ໃຊ້ທີ່ໄດ້ຮັບປ້າຍນີ້ແລ້ວ, ເຈົ້າສາມາດເຂົ້າໄປທີ່ໜ້າ {$a}.';
$string['notconnected'] = 'ບໍ່ໄດ້ເຊື່ອມຕໍ່';
$string['notealignment'] = 'ທັກສະ ຫຼື ມາດຕະຖານພາຍນອກ, ເຊິ່ງປ້າຍດັ່ງກ່າວສອດຄ່ອງກັບ, ອາດຈະຖືກລະບຸໄວ້. ທັກສະ ຫຼື ມາດຕະຖານພາຍນອກໃດໜຶ່ງແມ່ນສະແດງຢູ່ໃນໜ້າປ້າຍ.';
$string['noteendorsement'] = 'ການຮັບຮອງຈາກພາກສ່ວນທີສາມອາດຈະຖືກໃຊ້ເພື່ອເພີ່ມມູນຄ່າໃຫ້ກັບປ້າຍ. ຕົວຢ່າງ: ປ້າຍທີ່ອອກໃຫ້ໂດຍຄູສອນອາດຈະໄດ້ຮັບການຮັບຮອງຈາກໂຮງຮຽນ, ຫຼື ປ້າຍທີ່ອອກໃຫ້ໂດຍໜ່ວຍງານມອບລາງວັນໃນທ້ອງຖິ່ນອາດຈະຖືກຮັບຮອງໂດຍອົງການໃຫ້ລາງວັນແຫ່ງຊາດ.';
$string['noterelated'] = 'ປ້າຍທີ່ມີການເຊື່ອມຕໍ່ອາດຈະຖືກໝາຍວ່າກ່ຽວຂ້ອງກັນ. ຕົວຢ່າງ: ປ້າຍທີ່ມີມາດຖານດຽວກັນ ເຊິ່ງສະແດງເປັນພາສາຕ່າງກັນອາດຈະຖືກໝາຍວ່າກ່ຽວຂ້ອງກັນ. ປ້າຍທີ່ກ່ຽວຂ້ອງແມ່ນສະແດງຢູ່ໃນໜ້າປ້າຍ.';
$string['nothingtoadd'] = 'ບໍ່ມີມາດຖານທີ່ສາມາດເພີ່ມໄດ້.';
$string['notification'] = 'ແຈ້ງເຕືອນຜູ້ສ້າງປ້າຍ';
$string['notification_help'] = 'ການຕັ້ງຄ່ານີ້ຈັດການການແຈ້ງເຕືອນທີ່ສົ່ງຫາຜູ້ສ້າງປ້າຍເພື່ອແຈ້ງໃຫ້ເຂົາເຈົ້າຮູ້ວ່າໄດ້ອອກປ້າຍແລ້ວ.

ຕົວເລືອກຕໍ່ໄປນີ້ມີໃຫ້:

* **ບໍ່ເຄີຍ** - ຢ່າສົ່ງການແຈ້ງເຕືອນ.

* **ທຸກເວລາ** - ສົ່ງການແຈ້ງເຕືອນທຸກຄັ້ງທີ່ມີການມອບປ້າຍນີ້.

* **ປະຈໍາວັນ** - ສົ່ງການແຈ້ງເຕືອນມື້ລະເທື່ອ.

* **ປະຈໍາອາທິດ** - ສົ່ງການແຈ້ງເຕືອນໜຶ່ງຄັ້ງຕໍ່ອາທິດ.

* **ລາຍເດືອນ** - ສົ່ງການແຈ້ງເຕືອນເດືອນລະຄັ້ງ.';
$string['notifydaily'] = 'ປະຈຳວັນ';
$string['notifyevery'] = 'ທຸກເວລາ';
$string['notifymonthly'] = 'ປະຈຳເດືອນ';
$string['notifyweekly'] = 'ປະຈຳອາທິດ';
$string['numawards'] = 'ປ້າຍນີ້ໄດ້ອອກໃຫ້ກັບຜູ້ໃຊ້ <a href="{$a->link}">{$a->count}</a> user(s) ແລ້ວ.';
$string['numawardstat'] = 'ປ້າຍນີ້ໄດ້ອອກໃຫ້ກັບຜູ້ໃຊ້ {$a} ແລ້ວ.';
$string['oauth2issuer'] = 'ບໍລິການ OAuth 2';
$string['openbadgesv1'] = 'Open Badges v1.0';
$string['openbadgesv2'] = 'Open Badges v2.0';
$string['openbadgesv2p1'] = 'Open Badges v2.1';
$string['othernavigation'] = 'ການນຳທາງອື່ນໆ ...';
$string['overallcrit'] = 'ຂອງມາດຖານທີ່ເລືອກແມ່ນສົມບູນ.';
$string['potentialrecipients'] = 'ຜູ້ຮັບປ້າຍທີ່ເປັນໄປໄດ້';
$string['preferences'] = 'ການຕັ້ງຄ່າປ້າຍ';
$string['privacy:metadata:backpack'] = 'ບັນທຶກສະຖິຕິຂອງຊຸດກ່ອນໜ້າຂອງຜູ້ໃຊ້';
$string['privacy:metadata:backpack:backpackuid'] = 'ຕົວລະບຸສະເພາະຊຸດກ່ອນໜ້າ';
$string['privacy:metadata:backpack:email'] = 'ອີເມວທີ່ເຊື່ອມໂຍງກັບຊຸດກ່ອນໜ້າ';
$string['privacy:metadata:backpack:externalbackpackid'] = 'ລະຫັດປະຈຳຕົວຂອງຊຸດກ່ອນໜ້າ';
$string['privacy:metadata:backpack:userid'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ທີ່ມີຊຸດກ່ອນໜ້າຢູ່';
$string['privacy:metadata:backpackoauth2'] = 'ຂໍ້ມູນ OAuth 2 ເມື່ອຜູ້ໃຊ້ເຊື່ອມຕໍ່ກັບຊຸດກ່ອນໜ້າພາຍນອກ';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'ລະຫັດປະຈຳຕົວການບໍລິການ OAuth 2';
$string['privacy:metadata:backpackoauth2:scope'] = 'ລາຍການຂອບເຂດຂອງການເຊື່ອມຕໍ່ຊຸດກ່ອນໜ້າ';
$string['privacy:metadata:backpackoauth2:token'] = 'ໂທເຄັນການເຊື່ອມຕໍ່ຊຸດກ່ອນໜ້າ';
$string['privacy:metadata:backpackoauth2:userid'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ເຊື່ອມຕໍ່ກັບຊຸດກ່ອນໜ້າ';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ຖືກແກ້ໄຂການເຊື່ອມຕໍ່';
$string['privacy:metadata:badge'] = 'ຄັງສະສົມປ້າຍ';
$string['privacy:metadata:badge:timecreated'] = 'ເວລາທີ່ສ້າງປ້າຍ';
$string['privacy:metadata:badge:timemodified'] = 'ເວລາທີ່ປ້າຍໄດ້ຖືກດັດແກ້ຫຼ້າສຸດ';
$string['privacy:metadata:badge:usercreated'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ທີ່ສ້າງປ້າຍ';
$string['privacy:metadata:badge:usermodified'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ທີ່ແກ້ໄຂປ້າຍ';
$string['privacy:metadata:criteriamet'] = 'ຄັງສະສົມເກນທີ່ໄດ້ບັນລຸ';
$string['privacy:metadata:criteriamet:datemet'] = 'ວັນທີເມື່ອຄົບເກນ';
$string['privacy:metadata:criteriamet:userid'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ທີ່ມີເກນຄົບກໍານົດ';
$string['privacy:metadata:external:backpacks'] = 'ຂໍ້ມູນຖືກແບ່ງປັນເມື່ອຜູ້ໃຊ້ສົ່ງປ້າຍຂອງເຂົາເຈົ້າໃສ່ໃນຊຸດກ່ອນໜ້າພາຍນອກ';
$string['privacy:metadata:external:backpacks:badge'] = 'ຊື່ຂອງປ້າຍ';
$string['privacy:metadata:external:backpacks:description'] = 'ລາຍລະອຽດຂອງປ້າຍ';
$string['privacy:metadata:external:backpacks:image'] = 'ຮູບພາບຂອງປ້າຍ';
$string['privacy:metadata:external:backpacks:issuer'] = 'ບາງຂໍ້ມູນກ່ຽວກັບຜູ້ອອກໃຫ້';
$string['privacy:metadata:external:backpacks:url'] = 'URL Moodle ບ່ອນທີ່ສາມາດເຫັນຂໍ້ມູນປ້າຍທີ່ອອກໃຫ້';
$string['privacy:metadata:issued'] = 'ໄດ້ຮັບລາງວັນບັນທຶກປ້າຍແລ້ວ';
$string['privacy:metadata:issued:dateexpire'] = 'ວັນທີທີ່ປ້າຍໝົດອາຍຸ';
$string['privacy:metadata:issued:dateissued'] = 'ວັນທີຂອງລາງວັນ';
$string['privacy:metadata:issued:userid'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ທີ່ໄດ້ຮັບລາງວັນປ້າຍ';
$string['privacy:metadata:manualaward'] = 'ບັນທຶກຂອງລາງວັນດ້ວຍຕົນເອງ';
$string['privacy:metadata:manualaward:datemet'] = 'ວັນທີທີ່ຜູ້ໃຊ້ໄດ້ຮັບລາງວັນປ້າຍ';
$string['privacy:metadata:manualaward:issuerid'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ໃຫ້ລາງວັນປ້າຍ';
$string['privacy:metadata:manualaward:issuerrole'] = 'ໜ້າທີ່ຂອງຜູ້ໃຊ້ໃຫ້ລາງວັນປ້າຍ';
$string['privacy:metadata:manualaward:recipientid'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້ທີ່ໄດ້ຮັບລາງວັນປ້າຍດ້ວຍຕົນເອງ';
$string['recipientdetails'] = 'ລາຍລະອຽດຜູ້ຮັບ';
$string['recipientidentificationproblem'] = 'ບໍ່ສາມາດຊອກຫາຜູ້ຮັບປ້າຍນີ້ໃນບັນດາຜູ້ໃຊ້ທີ່ມີຢູ່ແລ້ວໄດ້.';
$string['recipients'] = 'ບັນດາຜູ້ຮັບປ້າຍ';
$string['recipientvalidationproblem'] = 'ຜູ້ໃຊ້ບໍ່ສາມາດຢືນຢັນໄດ້ວ່າເປັນຜູ້ຮັບປ້າຍນີ້.';
$string['relatedbages'] = 'ປ້າຍທີ່ກ່ຽວຂ້ອງ';
$string['relative'] = 'ວັນທີ່ສຳພັນ';
$string['requiredbadge'] = 'ຢ່າງໜ້ອຍຄວນເພີ່ມປ້າຍ 1 ອັນໃສ່ກັບເກນປ້າຍ.';
$string['requiredcohort'] = 'ຢ່າງໜ້ອຍໜຶ່ງກຸ່ມຄວນຈະຖືກເພີ່ມເຂົ້າໄປໃນເກນຂອງກຸ່ມ.';
$string['requiredcompetency'] = 'ຄວນເພີ່ມຄວາມສາມາດຢ່າງໜ້ອຍໜຶ່ງຢ່າງໃສ່ກັບເກນຄວາມສາມາດ.';
$string['requiredcourse'] = 'ຢ່າງໜ້ອຍຕ້ອງເພີ່ມລາຍວິຊາເຂົ້າໃສ່ຫຼັກເກນຊຸດວິຊາ.';
$string['reviewbadge'] = 'ການປ່ຽນແປງການເຂົ້າເຖິງປ້າຍ';
$string['reviewconfirm'] = '<p>ສິ່ງນີ້ຈະເຮັດໃຫ້ຜູ້ໃຊ້ເຫັນເຄື່ອງໝາຍຂອງທ່ານ ແລະ ອະນຸຍາດໃຫ້ເຂົາເຈົ້າເລີ່ມໄດ້ຮັບມັນ.</p>

<p>ມັນເປັນໄປໄດ້ວ່າຜູ້ໃຊ້ບາງຄົນມີມາດຕະຖານຢູ່ໃນປ້າຍນີ້ແລ້ວ ແລະ ຈະຖືກອອກປ້າຍນີ້ທັນທີຫຼັງຈາກທີ່ທ່ານເປີດນຳໃຊ້ມັນ.</p>

<p>ເມື່ອອອກປ້າຍແລ້ວມັນຈະຖືກ <strong>ລັອກ</strong> - ການຕັ້ງຄ່າບາງອັນລວມທັງເກນ ແລະ ການຕັ້ງຄ່າໝົດອາຍຸບໍ່ສາມາດປ່ຽນແປງໄດ້ອີກຕໍ່ໄປ.</p>

<p>ທ່ານແນ່ໃຈບໍ່ວ່າ ທ່ານຕ້ອງການເປີດນຳໃຊ້ການເຂົ້າເຖິງປ້າຍ \'{$a}\'?</p>';
$string['revoke'] = 'ຖອນປ້າຍ';
$string['save'] = 'ບັນທຶກ';
$string['searchname'] = 'ຄົ້ນຫາດ້ວຍຊື່';
$string['selectaward'] = 'ກະລຸນາເລືອກໜ້າທີ່ທີ່ທ່ານຕ້ອງການໃຊ້ເພື່ອໃຫ້ລາງວັນປ້າຍນີ້:';
$string['selectgroup_end'] = 'ສະແດງສະເພາະຄັງສະສົມສາທາລະນະ. <a href="{$a}">ເຂົ້າໄປເບິ່ງຊຸດກ່ອນໜ້າຂອງທ່ານ</a> ເພື່ອສ້າງຄັງສະສົມສາທາລະນະຫຼາຍຂຶ້ນ.';
$string['selectgroup_start'] = 'ເລືອກຄັງສະສົມຈາກຊຸດກ່ອນໜ້າຂອງທ່ານເພື່ອສະແດງຢູ່ໃນເວັບໄຊນີ້:';
$string['selecting'] = 'ດ້ວຍປ້າຍທີ່ເລືອກ...';
$string['setup'] = 'ຕັ້ງຄ່າການເຊື່ອມຕໍ່';
$string['sitebackpack'] = 'ຊຸດກ່ອນໜ້າພາຍນອກທີ່ໃຊ້ໄດ້';
$string['sitebackpack_help'] = 'ຊຸດກ່ອນໜ້າພາຍນອກທີ່ຜູ້ໃຊ້ສາມາດເຊື່ອມຕໍ່ຫາໄດ້ຈາກບ່ອນນີ້. ກະລຸນາຮັບຊາບວ່າການປ່ຽນການຕັ້ງຄ່ານີ້ ຫຼັງຈາກທີ່ຜູ້ໃຊ້ໄດ້ເຊື່ອມຕໍ່ຊຸດກ່ອນໜ້າຂອງເຂົາເຈົ້າຈະຕ້ອງໃຫ້ຜູ້ໃຊ້ແຕ່ລະຄົນໄປຫາໜ້າການຕັ້ງຄ່າຊຸດກ່ອນໜ້າຂອງເຂົາເຈົ້າ ແລະ ຕັດການເຊື່ອມຕໍ່ຈາກນັ້ນເຊື່ອມຕໍ່ຄືນໃໝ່.';
$string['sitebackpackdeleted'] = 'ຊຸດກ່ອນໜ້າເວັບໄຊທ໌ຖືກລຶບອອກແລ້ວ.';
$string['sitebackpacknotdeleted'] = 'ບໍ່ສາມາດລຶບຊຸດກ່ອນໜ້ານີ້ອອກໄດ້ເນື່ອງຈາກປະຈຸບັນມັນເປັນຄ່າເລີ່ມຕົ້ນຂອງເວັບໄຊທ໌.';
$string['sitebackpackverify'] = 'ການເຊື່ອມຕໍ່ຊຸດກ່ອນໜ້າ';
$string['sitebackpackwarning'] = 'ບໍ່ສາມາດເຊື່ອມຕໍ່ກັບຊຸດກ່ອນໜ້າ. <br/><br/>ກວດເບິ່ງວ່າການຕັ້ງຄ່າຜູ້ເບິ່ງແຍງລະບົບ "ທີ່ຢູ່ອີເມລຜູ້ອອກໃຫ້" ເປັນອີເມລທີ່ຖືກຕ້ອງສໍາລັບບັນຊີຢູ່ໃນເວັບໄຊທ໌ຊຸດກ່ອນໜ້າ. <br/><br/>ກວດເບິ່ງວ່າ "ລະຫັດຜູ້ອອກປ້າຍ" ຢູ່ໃນ <a href="{$a->url}">ໜ້າການຕັ້ງຄ່າຊຸດກ່ອນໜ້າເວັບໄຊທ໌</a>, ແມ່ນລະຫັດຜ່ານທີ່ຖືກຕ້ອງສໍາລັບບັນຊີຢູ່ໃນເວັບໄຊທ໌ຊຸດກ່ອນໜ້າ. <br/><br/>ຊຸດກ່ອນໜ້າຄືນມາ: "{$a->warning}"';
$string['sitebadges'] = 'ປ້າຍເວັບໄຊທ໌';
$string['sitebadges_help'] = 'ປ້າຍເວັບໄຊທ໌ສາມາດມອບໃຫ້ຜູ້ໃຊ້ສໍາລັບກິດຈະກໍາທີ່ກ່ຽວຂ້ອງກັບເວັບໄຊທ໌ເທົ່ານັ້ນ. ສິ່ງເຫຼົ່ານີ້ລວມມີການຈົບຊຸດວິຊາ ຫຼື ບາງສ່ວນຂອງໂປຼໄຟລ໌ຜູ້ໃຊ້ໃຫ້ສຳເລັດ. ປ້າຍເວັບໄຊທ໌ຍັງສາມາດອອກດ້ວຍຕົນເອງໂດຍຜູ້ໃຊ້ໜຶ່ງຫາຜູ້ອື່ນ.

ປ້າຍສໍາລັບກິດຈະກໍາທີ່ກ່ຽວຂ້ອງກັບລາຍວິຊາຕ້ອງໄດ້ສ້າງຢູ່ໃນລະດັບລາຍວິຊາ. ປ້າຍຫຼັກສູດສາມາດເບິ່ງໄດ້ພາຍໃຕ້ການບໍລິຫານລາຍວິຊາ > ປ້າຍ.';
$string['sitebadgetitle'] = 'ປ້າຍເວັບໄຊທ໌ {$a}';
$string['status'] = 'ສະຖານະປ້າຍ';
$string['status_help'] = 'ສະຖານະຂອງປ້າຍກໍານົດພຶດຕິກໍາຂອງມັນຢູ່ໃນລະບົບ:

***ມີ ** - ໝາຍຄວາມວ່າ ປ້າຍນີ້ສາມາດໄດ້ຮັບໂດຍຜູ້ໃຊ້. ໃນຂະນະທີ່ມີປ້າຍໃຫ້ກັບຜູ້ໃຊ້, ແຕ່ເກນຂອງມັນບໍ່ສາມາດຖືກດັດແກ້ໄດ້.

***ບໍ່ມີ ** - ໝາຍຄວາມວ່າ ປ້າຍນີ້ບໍ່ມີໃຫ້ກັບຜູ້ໃຊ້ ແລະ ບໍ່ສາມາດຫາໄດ້ ຫຼື ອອກໃຫ້ດ້ວຍຕົນເອງ. ຖ້າປ້າຍດັ່ງກ່າວບໍ່ເຄີຍອອກມາກ່ອນ, ມາດຖານຂອງມັນສາມາດປ່ຽນແປງໄດ້.

ເມື່ອປ້າຍໄດ້ຖືກອອກໃຫ້ຜູ້ໃຊ້ຢ່າງໜ້ອຍໜຶ່ງຄົນ, ມັນຈະກາຍເປັນ **ຖືກລັອກ** ໂດຍອັດຕະໂນມັດ. ປ້າຍຜູ້ໃຊ້ທີ່ລັອກແລ້ວຍັງສາມາດໄດ້ຮັບໂດຍຜູ້ໃຊ້, ແຕ່ວ່າເກນຂອງເຂົາເຈົ້າບໍ່ສາມາດປ່ຽນແປງໄດ້ອີກ. ຖ້າທ່ານຕ້ອງການແກ້ໄຂລາຍລະອຽດ ຫຼື ເງື່ອນໄຂຂອງປ້າຍທີ່ຖືກລັອກ, ທ່ານສາມາດເຮັດຊໍ້າປ້າຍນີ້ ແລະ ເຮັດການປ່ຽນແປງທັງໝົດທີ່ຕ້ອງການໄດ້.

*ເປັນຫຍັງພວກເຮົາຈຶ່ງລັອກປ້າຍ?*

ພວກເຮົາຕ້ອງການໃຫ້ແນ່ໃຈວ່າຜູ້ໃຊ້ທຸກຄົນປະຕິບັດຕາມຂໍ້ກໍານົດອັນດຽວກັນເພື່ອຮັບປ້າຍ. ປະຈຸບັນ, ບໍ່ສາມາດຖອນປ້າຍໄດ້. ຖ້າພວກເຮົາອະນຸຍາດໃຫ້ມີການແກ້ໄຂຄວາມຕ້ອງການປ້າຍຕະຫຼອດເວລາ, ສ່ວນຫຼາຍແລ້ວພວກເຮົາຈະລົງທ້າຍທີ່ຜູ້ໃຊ້ມີປ້າຍອັນດຽວກັນເພື່ອຕອບສະໜອງຄວາມຕ້ອງການທີ່ແຕກຕ່າງກັນໝົດ.';
$string['statusmessage_0'] = 'ປ້າຍນີ້ບໍ່ມີໃຫ້ກັບຜູ້ໃຊ້ໃນຂະນະນີ້. ເປີດນຳໃຊ້ການເຂົ້າເຖິງ ຖ້າທ່ານຕ້ອງການໃຫ້ຜູ້ໃຊ້ໄດ້ຮັບປ້າຍນີ້.';
$string['statusmessage_1'] = 'ປະຈຸບັນປ້າຍນີ້ມີໃຫ້ກັບຜູ້ໃຊ້ແລ້ວ. ປິດການເຂົ້າເຖິງເພື່ອເຮັດການປ່ຽນແປງໃດໜຶ່ງ.';
$string['statusmessage_2'] = 'ປ້າຍນີ້ບໍ່ມີໃຫ້ກັບຜູ້ໃຊ້ໃນປະຈຸບັນ ແລະ ເກນຂອງມັນຖືກລັອກໄວ້. ເປີດນຳໃຊ້ການເຂົ້າເຖິງຖ້າທ່ານຕ້ອງການໃຫ້ຜູ້ໃຊ້ໄດ້ຮັບປ້າຍນີ້.';
$string['statusmessage_3'] = 'ປ້າຍນີ້ສາມາດໃຊ້ໄດ້ກັບຜູ້ໃຊ້ໃນປະຈຸບັນ ແລະ ເກນຂອງມັນຖືກລັອກໄວ້.';
$string['statusmessage_4'] = 'ປ້າຍນີ້ຖືກເກັບໄວ້ໃນຂະນະນີ້.';
$string['subject'] = 'ຫົວຂໍ້ຂໍ້ຄວາມ';
$string['targetcode'] = 'ລະຫັດ';
$string['targetcode_help'] = 'ຕົວລະບຸສະຕຣິງທີ່ເປັນເອກະລັກສຳລັບການອ້າງອີງເຖິງທັກສະ ຫຼື ມາດຕະຖານພາຍນອກພາຍໃນກອບວຽກຂອງມັນ.';
$string['targetdescription'] = 'ລາຍລະອຽດ';
$string['targetdescription_help'] = 'ຄຳອະທິບາຍສັ້ນຂອງທັກສະ ຫຼື ມາດຕະຖານພາຍນອກ.';
$string['targetframework'] = 'ກອບວຽກ';
$string['targetframework_help'] = 'ຊື່ຂອງທັກສະພາຍນອກ ຫຼື ກອບວຽກມາດຕະຖານ.';
$string['targetname'] = 'ຊື່';
$string['targetname_help'] = 'ທັກສະ ຫຼື ມາດຕະຖານພາຍນອກທີ່ປ້າຍຖືກຈັດເຂົ້າກັບ.';
$string['targeturl'] = 'URL';
$string['targeturl_help'] = 'ການເຊື່ອມຕໍ່ຫາໜ້າທີ່ອະທິບາຍທັກສະ ຫຼື ມາດຕະຖານພາຍນອກ. URL ຄວນມີ ຄຳນຳໜ້າ http:// ຫຼື https://.';
$string['testbackpack'] = 'ທົດສອບຊຸດກ່ອໜ້າ \'{$a}\'';
$string['testsettings'] = 'ທົດສອບການຕັ້ງຄ່າ';
$string['type'] = 'ປະເພດ';
$string['variablesubstitution'] = 'ການແທນທີ່ຕົວປ່ຽນໃນຂໍ້ຄວາມ.';
$string['variablesubstitution_help'] = 'ໃນຂໍ້ຄວາມປ້າຍ, ຕົວແປທີ່ແນ່ນອນສາມາດຖືກໃສ່ເຂົ້າໄປໃນຫົວຂໍ້ ແລະ/ຫຼື ເນື້ອໃນຂອງຂໍ້ຄວາມດັ່ງນັ້ນພວກມັນຈະຖືກແທນທີ່ດ້ວຍຄ່າທີ່ແທ້ຈິງເມື່ອຂໍ້ຄວາມຖືກສົ່ງໄປ. ຕົວແປຄວນຖືກໃສ່ເຂົ້າໄປໃນຂໍ້ຄວາມຢ່າງແນ່ນອນດັ່ງທີ່ພວກມັນສະແດງຢູ່ຂ້າງລຸ່ມ. ຕົວແປຕໍ່ໄປນີ້ສາມາດໃຊ້ໄດ້:

%badgename%
: ສິ່ງນີ້ຈະຖືກແທນທີ່ດ້ວຍຊື່ເຕັມຂອງປ້າຍ.

%username%
: ສິ່ງນີ້ຈະຖືກປ່ຽນແທນດ້ວຍຊື່ເຕັມຂອງຜູ້ຮັບ.

%badgelink%
: ສິ່ງນີ້ຈະຖືກແທນທີ່ດ້ວຍ URL ສາທາລະນະດ້ວຍຂໍ້ມູນກ່ຽວກັບປ້າຍທີ່ອອກໃຫ້.';
$string['version'] = 'ສະບັບ';
$string['version_help'] = 'ຊ່ອງຂໍ້ມູນສະບັບອາດຈະຖືກໃຊ້ເພື່ອຕິດຕາມການພັດທະນາຂອງປ້າຍ. ຖ້າລະບຸ, ສະບັບຈະຖືກສະແດງຢູ່ໃນໜ້າປ້າຍ.';
$string['viewbadge'] = 'ເບິ່ງປ້າຍທີ່ອອກໃຫ້';
$string['visible'] = 'ເບິ່ງເຫັນໄດ້';
$string['warnexpired'] = '(ປ້າຍນີ້ໝົດອາຍຸແລ້ວ!)';
$string['year'] = 'ປີ';
