<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_union', language 'de', version '4.0'.
 *
 * @package     theme_boost_union
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitybrandingtab'] = 'Aktivitätsfarben';
$string['activityiconcoloradministrationsetting'] = 'Icon-Farbe für Administration';
$string['activityiconcoloradministrationsetting_desc'] = 'Die Icon-Hintergrundsfarbe für Aktivitäten vom Typ Administration';
$string['activityiconcolorassessmentsetting'] = 'Icon-Farbe für Beurteilung';
$string['activityiconcolorassessmentsetting_desc'] = 'Icon-Hintergrundsfarbe für Aktivitäten vom Typ Beurteilung';
$string['activityiconcolorcollaborationsetting'] = 'Icon-Farbe für Kollaboration';
$string['activityiconcolorcollaborationsetting_desc'] = 'Icon-Hintergrundsfarbe für Aktivitäten vom Typ Kollaboration';
$string['activityiconcolorcommunicationsetting'] = 'Icon-Farbe für Kommunikation';
$string['activityiconcolorcommunicationsetting_desc'] = 'Icon-Hintergrundsfarbe für Aktivitäten vom Typ Kommunikation';
$string['activityiconcolorcontentsetting'] = 'Icon-Farbe für Inhalt';
$string['activityiconcolorcontentsetting_desc'] = 'Icon-Hintergrundsfarbe für Materialien vom Typ Inhalt';
$string['activityiconcolorinterfacesetting'] = 'Icon-Farbe für Interface';
$string['activityiconcolorinterfacesetting_desc'] = 'Icon-Hintergrundsfarbe für Aktivitäten vom Typ Interface';
$string['activityiconcolorsheading'] = 'Icon-Farben für Aktivitäten';
$string['activitynavigation'] = 'Aktivitätsnavigation';
$string['activitynavigationsetting'] = 'Elemente der Aktivitätsnavigation';
$string['activitynavigationsetting_desc'] = 'Mit dieser Option werden die Elemente zum Springen zur vorherigen und nächsten Aktivität oder Ressource sowie das Pulldown-Menü zum Springen zu einer bestimmten Aktivität oder Ressource angezeigt. Diese UI-Elemente gab es bei Boost im Moodle-Core bis 3.11, aber sie wurden in 4.0 entfernt. Mit Boost Union können Sie sie zurückholen.';
$string['activitypurposeadministration'] = 'Administration';
$string['activitypurposeassessment'] = 'Bewertung';
$string['activitypurposecollaboration'] = 'Kollaboration';
$string['activitypurposecommunication'] = 'Kommunikation';
$string['activitypurposecontent'] = 'Inhalt';
$string['activitypurposeheading'] = 'Zweck des Aktivitätssymbols';
$string['activitypurposeheading_desc'] = 'Mit diesen Einstellungen können Sie die Hintergrundfarbe des Aktivitätssymbols überschreiben, die durch den Zweck der Aktivität definiert wird (was eine fest codierte Eigenschaft in jeder Aktivität ist).';
$string['activitypurposeheadingtechnote'] = 'Technischer Hinweis: Aufgrund der Art und Weise, wie Moodle Core die Aktivitätszwecke und ihre Farben implementiert, werden die Aktivitätszwecke nur mit CSS von Boost Union überschrieben. Derzeit sollten alle Bereiche im Moodle-Kern abgedeckt sein, in denen farbige Aktivitätssymbole angezeigt werden. Wenn Sie einen Bereich oder ein Drittanbieter-Plugin entdecken, das weiterhin die unveränderten Aktivitätszweckfarben anzeigt, melden Sie es bitte auf {$a}.';
$string['activitypurposeinterface'] = 'Interface';
$string['activitypurposeother'] = 'Andere';
$string['additionalresourcesfileurlpersistent'] = 'URL (gleichbleibend)';
$string['additionalresourcesfileurlrevisioned'] = 'URL (revisioniert)';
$string['additionalresourcesheading'] = 'Zusätzliche Ressourcen';
$string['additionalresourceslistsetting'] = 'Liste von zusätzlichen Ressourcen';
$string['additionalresourceslistsetting_desc'] = 'Liste der Dateien, die in den Dateibereich "Zusätzliche Ressourcen" hochgeladen wurden. Die angegebenen URLs können Sie verwenden, um die Dateien in zusätzlichem HTML, in nutzerdefiniertem CSS oder in der Fußnote zu verlinken. Dies ist hilfreich, wenn Sie Dateien verwenden möchten, aber keine Dateien hochladen können.';
$string['additionalresourcessetting'] = 'Zusätzliche Ressourcen';
$string['additionalresourcessetting_desc'] = 'Mit dieser Einstellung können Sie zusätzliche Ressourcen zum Design hochladen. Der Vorteil dieses Dateibereichs besteht darin, dass die Dateien ausgeliefert werden, ohne dass jemand angemeldet sein muss. An dieser Stelle sollten Sie nur unkritische Dateien hinzufügen, auf die jeder ohne Anmeldung zugreifen darf. Sobald Sie mindestens eine Datei in diesen Dateibereich hochgeladen und die Einstellungen gespeichert haben, sehen Sie eine Liste mit URLs, die auf die jeweiligen Dateien verweisen.';
$string['backgroundimagesetting'] = 'Hintergrundbild';
$string['backgroundimagesetting_desc'] = 'Hier können Sie ein nutzerdefiniertes Bild hochladen, das als Hintergrund der Website angezeigt wird. Das Hintergrundbild, das Sie hier hochladen, überschreibt das Hintergrundbild in Ihren voreingestellten Designdateien.';
$string['backgroundimagesheading'] = 'Hintergrundbilder';
$string['backtotop'] = 'Nach oben';
$string['backtotopbuttonsetting'] = 'Taste "Nach oben"';
$string['backtotopbuttonsetting_desc'] = 'Mit dieser Einstellung erscheint eine Taste "Nach oben" in der unteren rechten Ecke der Seite, sobald Nutzer/innen die Seite nach unten scrollen. Eine solche Taste gab es bereits für das Design Boost im Moodle-Core bis Moodle 3.11, sie wurde aber in 4.0 entfernt. Im Design Boost Union können Sie diese Taste zurückholen.';
$string['blockregionfooterwidth'] = 'Breite der Blockregion im Fußbereich';
$string['blockregionfooterwidth_desc'] = 'Mit dieser Einstellung können Sie die Breite der Blockregion im Fußbereich festlegen. Sie können zwischen voller Breite, Kursinhaltsbreite und Heldenbreite wählen.';
$string['blockregionoutsidebottomwidth'] = 'Breite der Blockregion \'Außen (unten)\'';
$string['blockregionoutsidebottomwidth_desc'] = 'Mit dieser Einstellung können Sie die Breite der Blockregion \'Außen (unten)\' festlegen, die unterhalb des Hauptinhalts angezeigt wird. Sie können die volle Breite auswählen, aber auch die Breite des Kursinhalts oder eine ideale Breite.';
$string['blockregionoutsideleftwidth'] = 'Breite der Blockregion \'Außen (links)\'';
$string['blockregionoutsideleftwidth_desc'] = 'Mit dieser Einstellung können Sie die Breite der Blockregion \'Außen (links)\' festlegen, die links neben dem Hauptinhalt angezeigt wird. Boost Union verwendet standardmäßig eine Breite von 300px. Sie können aber auch andere Werte einstellen, wie z.B. 200px, 10% oder 10vw.';
$string['blockregionoutsiderightwidth'] = 'Breite der Blockregion \'Außen (rechts)\'';
$string['blockregionoutsiderightwidth_desc'] = 'Mit dieser Einstellung können Sie die Breite der Blockregion \'Außen (rechts)\' festlegen, die rechts neben dem Hauptinhalt angezeigt wird. Boost Union verwendet standardmäßig eine Breite von 300px. Sie können aber auch andere Werte einstellen, wie z.B. 200px, 10% oder 10vw.';
$string['blockregionoutsidetopwidth'] = 'Breite der Blockregion \'Außen (oben)\'';
$string['blockregionoutsidetopwidth_desc'] = 'Mit dieser Einstellung können Sie die Breite der Blockregion \'Außen (oben)\' festlegen, der ganz oben auf der Seite angezeigt wird. Sie können die volle Breite auswählen, aber auch die Breite des Kursinhalts oder eine ideale Breite.';
$string['blockregionsforlayout'] = 'Zusätzliche Blockregionen für das Layout \'{$a}\'';
$string['blockregionsforlayout_desc'] = 'Mit dieser Einstellung können Sie zusätzliche Blockregionen für das Layout \'{$a}\' aktivieren.';
$string['blockregionsheading'] = 'Zusätzliche Blockregionen';
$string['blockregionsheading_desc'] = '<p>Boost Union bietet eine große Anzahl zusätzlicher Blockregionen, in denen Blöcke über die gesamte Moodle-Seite hinzugefügt und angezeigt werden können: </p>
<ul><li>Die Blockregionen <em>Außen</em> werden auf allen vier Seiten der Moodle-Seite platziert. Sie können verwendet werden, um Blöcke anzuzeigen, die die gezeigte Moodle-Seite begleiten, aber nicht direkt zum Hauptinhalt gehören.</li>
<li>Die Blockregion <em>Kopfbereich</em> wird zwischen der Region Außen (oben) und dem Hauptinhalt platziert. Dies kann verwendet werden, um einen Block als Kurskopfinformationen anzuzeigen.</li>
<li>Die Blockbereiche <em>Inhaltsbereich</em> werden direkt über und unter dem Hauptinhalt im Hauptinhaltsbereich platziert. Sie können verwendet werden, um dem Kursinhaltsfluss zusätzliche Blöcke hinzuzufügen.</li>
<li>Die Blockregionen <em>Fußbereich</em> befinden sich am unteren Rand der Seite zwischen der Region Außen (unten) und der Fußzeile. Sie haben drei Fußbereiche zur Verfügung, um bei Bedarf Spalten zu erstellen. </li>
<li> Die Blockregionen <em>Off-Canvas</em> sind irgendwie etwas Besonderes, da sie als Overlay über der Moodle-Seite schweben. Die Region wird mit dem 9-Punkte-Symbol auf der rechten Seite der Navigationsleiste geöffnet. Sie haben drei Regionen für Off-Canvas, um bei Bedarf Spalten zu erstellen. </li></ul>
<p>Beachten Sie bitte: </p>
<ul><li>Standardmäßig sind alle zusätzlichen Blockregionen deaktiviert. Aktivieren Sie entsprechend Ihren Anforderungen die jeweiligen Blockregionen auf den jeweiligen Seitenlayouts . Versuchen Sie, dabei so fokussiert wie möglich zu sein - zu viele Blockregionen könnten Nutzer/innen erschlagen.</li>
<li>Sobald eine zusätzliche Blockregion aktiviert ist, wird sie für alle authentifizierten Nutzer/innen sichtbar und kann von Trainer/innen und Manager/innen bearbeitet werden (abhängig davon, ob die jeweilige Person die Moodle-Seite bearbeiten darf). Aber es gibt aber auch die Rechte theme/boost_union:viewregion* und theme/boost_union:viewregion*, mit denen Sie die Verwendung jeder Blockregion optimieren können. </li>
<li>Die Blockregionen Außen (links), Außen (rechts), Inhalt (oben), Inhalt (unten) und Kopfbereich sind nicht für alle Seitenlayouts verfügbar. </li></ul>';
$string['blockregionsheading_experimental'] = 'Beachten Sie bitte: Die Blockregionen \'Außen (links)\' und \'Außen (rechts)\' funktionieren mit dem aktuellen Implementationsstand zwar vollständig, müssen aber für mittelbreite Bildschirme als experimentell gelten. Vor diesem Hintergrund sollten Sie die Blockregionen mit Vorsicht verwenden. Das Problem wird mit einem zukünftigen Release behoben.';
$string['blocksgeneralheading'] = 'Allgemeine Blöcke';
$string['blockstab'] = 'Blöcke';
$string['boost_union:configure'] = 'Nicht-Administrator/innen können das Design konfigurieren.';
$string['boost_union:editregioncontentlower'] = 'Um die Blockregion \'Inhalt (unten)\' bearbeiten zu können';
$string['boost_union:editregioncontentupper'] = 'Um die Blockregion \'Inhalt (oben)\' bearbeiten zu können';
$string['boost_union:editregionfootercenter'] = 'Um die Blockregion \'Fußbereich (mittig)\' bearbeiten zu können';
$string['boost_union:editregionfooterleft'] = 'Um die Blockregion \'Fußbereich (links)\' bearbeiten zu können';
$string['boost_union:editregionfooterright'] = 'Um die Blockregion \'Fußbereich (rechts)\' bearbeiten zu können';
$string['boost_union:editregionheader'] = 'Um die Blockregion \'Kopfbereich\' bearbeiten zu können';
$string['boost_union:editregionoffcanvascenter'] = 'Um die Blockregion \'Off-Canvas (mittig)\' bearbeiten zu können';
$string['boost_union:editregionoffcanvasleft'] = 'Um die Blockregion \'Off-Canvas (links)\' bearbeiten zu können';
$string['boost_union:editregionoffcanvasright'] = 'Um die Blockregion \'Off-Canvas (rechts)\' bearbeiten zu können';
$string['boost_union:editregionoutsidebottom'] = 'Um den Blockbereich \'Außen (unten)\' bearbeiten zu können';
$string['boost_union:editregionoutsideleft'] = 'Um den Blockbereich \'Außen (links)\' bearbeiten zu können';
$string['boost_union:editregionoutsideright'] = 'Um den Blockbereich \'Außen (rechts)\' bearbeiten zu können';
$string['boost_union:editregionoutsidetop'] = 'Um den Blockbereich \'Außen (oben)\' bearbeiten zu können';
$string['boost_union:viewhintcourseselfenrol'] = 'Hinweis zur uneingeschränkten Selbsteinschreibung in einem sichtbaren Kurs anzeigen';
$string['boost_union:viewhintinhiddencourse'] = 'Hinweis in einem verborgenen Kurs anzeigen';
$string['boost_union:viewregioncontentlower'] = 'Um den Blockbereich \'Inhalt (unten)\' sehen zu können';
$string['boost_union:viewregioncontentupper'] = 'Um den Blockbereich \'Inhalt (oben)\' sehen zu können';
$string['boost_union:viewregionfootercenter'] = 'Um den Blockbereich \'Fußbereich (mittig)\' sehen zu können';
$string['boost_union:viewregionfooterleft'] = 'Um den Blockbereich \'Fußbereich (links)\' sehen zu können';
$string['boost_union:viewregionfooterright'] = 'Um den Blockbereich \'Fußbereich (rechts)\' sehen zu können';
$string['boost_union:viewregionheader'] = 'Um den Blockbereich \'Kopfbereich\' sehen zu können';
$string['boost_union:viewregionoffcanvascenter'] = 'Um die Blockregion \'Off-Canvas (mittig)\' sehen zu können';
$string['boost_union:viewregionoffcanvasleft'] = 'Um die Blockregion \'Off-Canvas (links)\' sehen zu können';
$string['boost_union:viewregionoffcanvasright'] = 'Um die Blockregion \'Off-Canvas (rechts)\' sehen zu können';
$string['boost_union:viewregionoutsidebottom'] = 'Um den Blockbereich \'Außen (unten)\' sehen zu können';
$string['boost_union:viewregionoutsideleft'] = 'Um den Blockbereich \'Außen (links)\' sehen zu können';
$string['boost_union:viewregionoutsideright'] = 'Um den Blockbereich \'Außen (rechts)\' sehen zu können';
$string['boost_union:viewregionoutsidetop'] = 'Um den Blockbereich \'Außen (oben)\' sehen zu können';
$string['bootstrapcolordangersetting'] = 'Bootstrap-Farbe für Gefahr';
$string['bootstrapcolordangersetting_desc'] = 'Bootstrap-Farbe für Gefahr';
$string['bootstrapcolorinfosetting'] = 'Bootstrap-Farbe für Info';
$string['bootstrapcolorinfosetting_desc'] = 'Bootstrap-Farbe für Info';
$string['bootstrapcolorsheading'] = 'Bootstrap-Farben';
$string['bootstrapcolorsuccesssetting'] = 'Bootstrap-Farbe für Erfolg';
$string['bootstrapcolorsuccesssetting_desc'] = 'Bootstrap-Farbe für Erfolg';
$string['bootstrapcolorwarningsetting'] = 'Bootstrap-Farbe für Warnung';
$string['bootstrapcolorwarningsetting_desc'] = 'Bootstrap-Farbe für Warnung';
$string['bootstrapdangercolor'] = 'Farbe Gefahr';
$string['bootstrapdarkcolor'] = 'Farbe dunkel';
$string['bootstrapinfocolor'] = 'Farbe Info';
$string['bootstraplightcolor'] = 'Farbe hell';
$string['bootstrapnone'] = 'Keine Bootstrap-Farbe';
$string['bootstrapprimarycolor'] = 'Farbe Primär';
$string['bootstrapsecondarycolor'] = 'Farbe Sekundär';
$string['bootstrapsuccesscolor'] = 'Farbe Erfolg';
$string['bootstrapwarningcolor'] = 'Farbe Warnung';
$string['brandcolorsheading'] = 'Markenfarben';
$string['breadcrumbsheading'] = 'Breadcrumb-Navigation';
$string['cachedef_flavours'] = 'Variationen, die für eine bestimmte Seitenkategorie-ID der aktuellen Person gelten';
$string['cachedef_fontawesome'] = 'FontAwesome-Dateien, die in den Boost Union-Einstellungen hochgeladen sind';
$string['categorybreadcrumbs'] = 'Kursbereich-Breadcrumbs in Kurskopfzeile anzeigen';
$string['categorybreadcrumbs_desc'] = 'Standardmäßig werden die Kursbereich-Breadcrumbs nicht auf Kursseiten in der Kurskopfzeile angezeigt. Mit dieser Einstellung können Sie die Kursbereich-Breadcrumbs in der Kurskopfzeile über dem Kursnamen anzeigen.<br/><br/>
Beachten Sie bitte: Die Option "Nichts ändern" ändert nichts an den Breadcrumbs der Kursbereiche, wie sie vom Moodle Core dargestellt werden. Wohingegen die Option „Nein“ dafür sorgt, dass Kursbereich-Breadcrumbs überhaupt nicht angezeigt werden. Dies könnte ein Unterschied sein, da Boost im Moodle Core tatsächlich Kursbereich-Breadcrumbs anzeigen könnte, die auf tiefer verschachtelten Kursbereichsebenen beginnen (was die Entwickler von Boost Union als Fehler einschätzen).';
$string['choosereadme'] = 'Das Design "Boost Union" ist eine Erweiterung für das Design "Boost" und wird von  Moodle an Hochschulen e.V. bereitgestellt.';
$string['closeoffcanvas'] = 'Off-Canvas schließen';
$string['configtitle'] = 'Boost Union';
$string['configtitlecontent'] = 'Inhalt';
$string['configtitlefeel'] = 'Bedienelemente';
$string['configtitleflavours'] = 'Variationen';
$string['configtitlefunctionality'] = 'Funktionalität';
$string['configtitlelook'] = 'Erscheinungsbild';
$string['contactcontentsetting'] = 'Inhalt der Kontaktseite';
$string['contactcontentsetting_desc'] = 'In dieser Einstellung können Sie Textinhalte hinzufügen, die auf einer Kontaktseite angezeigt werden. Diese Kontaktseite ist nicht mit dem "Kontakt zum Website-Support" von Moodle identisch.';
$string['contactdisabled'] = 'Die Kontaktseite ist für diese Website deaktiviert. Hier wird nichts angezeigt.';
$string['contactheading'] = 'Kontakt';
$string['contactlinkpositionboth'] = 'Link zur Kontaktseite in der Fußzeile und dem Fußzeilensymbol (Fragezeichen) hinzufügen';
$string['contactlinkpositionfooter'] = 'Link zur Kontaktseite dem Fußzeilensymbol (Fragezeichen) hinzufügen';
$string['contactlinkpositionfootnote'] = 'Link zur Kontaktseite in der Fußzeile hinzufügen';
$string['contactlinkpositionnone'] = 'Link zur Kontaktseite nicht automatisch hinzufügen';
$string['contactlinkpositionsetting'] = 'Linkposition für Kontaktseite';
$string['contactlinkpositionsetting_desc'] = 'In dieser Einstellung können Sie konfigurieren, ob in Moodle automatisch ein Link zur Kontaktseite hinzugefügt wird. Wenn Sie nicht automatisch einen Link anzeigen möchten, können Sie auch überall manuell einen Link zu {$a->url} hinzufügen.';
$string['contactpagetitledefault'] = 'Kontakt';
$string['contactpagetitlesetting'] = 'Titel der Kontaktseite';
$string['contactpagetitlesetting_desc'] = 'In dieser Einstellung können Sie den Titel der Kontaktseite festlegen. Dieser Text wird auch als Linktext zur Kontaktseite verwendet, wenn Sie die \'Linkposition für Kontaktseite\' entsprechend konfigurieren.';
$string['contentwidthheading'] = 'Inhaltsbreite';
$string['coursecontentmaxwidthsetting'] = 'Maximale Breite von Kursinhalten';
$string['coursecontentmaxwidthsetting_desc'] = 'Mit dieser Einstellung können Sie die Inhaltsbreite von Moodle ohne manuelle SCSS-Änderungen überschreiben. Diese Breite wird als Seitenbreite von Kursseiten und in mehreren Aktivitäten verwendet. Standardmäßig verwendet Moodle bei Kursinhalten eine maximale Breite von 830px. Sie können andere pixelbasierte Breite wie 1200px eingeben, aber auch einen prozentualen Wert wie 100% oder eine Breite des Darstellungsbereichs wie 90vw.';
$string['courseheaderheading'] = 'Kursüberschrift';
$string['courseheaderimageenabled'] = 'Kursbild in der Kopfzeile anzeigen';
$string['courseheaderimageenabled_desc'] = 'Wenn die Einstellung aktiviert ist, wird das Kursbild (das in den Kurseinstellungen eines Kurses hochgeladen werden kann) in der Kopfzeile eines Kurses angezeigt. Die Kursbilder werden dort zusätzlich zur Seite "Meine Kurse" angezeigt, wo sie immer angezeigt werden.';
$string['courseheaderimagefallback'] = 'Kursbild in der Kopfzeile als Fallback';
$string['courseheaderimagefallback_desc'] = 'Wenn Sie in dieser Einstellung ein Bild hochladen, wird es als Fallback verwendet und in der Kurskopfzeile angezeigt, wenn in den Einstellungen eines Kurses kein Kursbild hochgeladen wurde. Wenn Sie hier kein Bild hochladen, wird ein Kurskopfbild nur dann in einem bestimmten Kurs angezeigt, wenn in den Kurseinstellungen dieses Kurses ein Kursbild hochgeladen wurde.';
$string['courseheaderimageheight'] = 'Höhe des Kursbildes in der Kopfzeile';
$string['courseheaderimageheight_desc'] = 'Mit dieser Einstellung legen Sie die Höhe des angezeigten Kopfbildes fest.';
$string['courseheaderimagelayout'] = 'Layout des Kursbildes in der Kopfzeile';
$string['courseheaderimagelayout_desc'] = 'Mit dieser Einstellung legen Sie das Layout des angezeigten Kopfbildes und des Kurstitels fest.';
$string['courseheaderimagelayoutheadingabove'] = 'Kurstitel über dem Kursbild';
$string['courseheaderimagelayoutstackeddark'] = 'Kurstitel überdeckend auf den Kursbild (weiße Schrift für dunkle Hintergrundbilder)';
$string['courseheaderimagelayoutstackedlight'] = 'Kurstitel überdeckend auf den Kursbild (schwarze Schrift für dunkle Hintergrundbilder)';
$string['courseheaderimageposition'] = 'Bildposition für Kursüberschrift';
$string['courseheaderimageposition_desc'] = 'Mit dieser Einstellung steuern Sie die Position des Kursbildes innerhalb des Kursheader-Containers. Der erste Wert ist die horizontale Position, der zweite Wert ist die vertikale Position.';
$string['courserelatedhintsheading'] = 'Kursbezogene Hinweise';
$string['coursestab'] = 'Kurse';
$string['coursetab'] = 'Kurs';
$string['cssh5pheading'] = 'Raw CSS für H5P';
$string['cssh5psetting'] = 'Raw CSS für H5P';
$string['cssh5psetting_desc'] = 'Verwenden Sie dieses Feld, um CSS-Code bereitzustellen, der auf die Präsentation von H5P-Inhalten durch mod_h5p und mod_hvp angewendet wird. Überprüfen Sie bitte die H5P-Inhaltstypen, um die erforderlichen CSS-Selektoren zu finden.';
$string['customfontsfileurlpersistent'] = 'URL (gleichbleibend)';
$string['customfontsfileurlrevisioned'] = 'URL (revisioniert)';
$string['customfontsheading'] = 'Nutzerdefinierte Schriftarten';
$string['customfontslistsetting'] = 'Liste von nutzerdefinierten Schriftarten';
$string['customfontslistsetting_desc'] = 'Liste der Schriftarten, die Sie in den Dateibereich "Nutzerdefinierte Schriftarten" hochgeladen haben. Die anzeigten CSS-Snippets können verwendet werden, um die Schriftarten zum nutzerdefinierten SCSS hinzuzufügen. Beachten Sie bitte, dass Sie sich um alle Parameter (font-format, font-family, font-style, font-weight) selber kümmern müssen. Boost Union ist noch nicht in der Lage ist, die Schriftdateien zu analysieren.';
$string['customfontssetting'] = 'Nutzerdefinierte Schriftarten';
$string['customfontssetting_desc'] = 'Mit dieser Einstellung können Sie nutzerdefinierte Schriftarten zum Design hochladen. Der Vorteil von Schriftarten in diesem Dateibereich besteht darin, dass diese Schriftarten überall auf der Website verwendet werden können, ohne dass jemand angemeldet ist. Sobald Sie mindestens eine Schriftart in diesen Dateibereich hochgeladen und die Einstellungen gespeichert haben, wird eine Liste mit CSS-Snippets gezeigt, um die jeweilige Schriftart im nutzerdefinierten SCSS einzubinden.';
$string['dontchange'] = 'Nichts ändern';
$string['emailbrandinghtmldemobody'] = '<p>E-Mail-Text beginnt hier.</p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p><p>Id donec ultrices tincidunt arcu nicht sodales. Id volutpat lacus laoreet non curabitur gravida arcu.</p><p>Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.</p><p>E-Mail-Text endet hier.</p>';
$string['emailbrandinghtmlheading'] = 'HTML-E-Mail-Vorschau';
$string['emailbrandinghtmlintro'] = 'Dies ist eine Vorschau einer HTML-E-Mail, basierend auf Präfixen und Suffixen für das Erscheinungsbild, die derzeit im Sprachpaket festgelegt sind.';
$string['emailbrandinghtmlnopreview'] = 'Bisher wurden die HTML-E-Mails innerhalb dieser Funktion nicht angepasst. E-Mails werden normal erstellt und versendet.';
$string['emailbrandinginstruction'] = 'Wie geht das?';
$string['emailbrandinginstruction0'] = 'Mit dieser Boost Union-Funktion können Sie das Erscheinungsbild auf alle E-Mails anwenden, die Moodle versendet.';
$string['emailbrandinginstructionli1'] = 'Gehen Sie zur <a href="{$a->url}" target="_blank">Seite mit den Sprachanpassungen</a>, um das Sprachpaket <em>{$a->lang}</em> zur Bearbeitung zu öffnen.';
$string['emailbrandinginstructionli2'] = 'Suchen und ändern Sie diese Zeichenfolgen im Paket <code>theme_boost_union language</code>:';
$string['emailbrandinginstructionli2li1'] = '<code>templateemailhtmlprefix</code>: Dieses Snippet wird <em>am Anfang / vor dem Text</em> aller <em>HTML-E-Mails</em> eingefügt, die Moodle versendet.';
$string['emailbrandinginstructionli2li2'] = '<code>templateemailhtmlsuffix</code>: Dieses Snippet wird <em>am Ende / nach dem Body</em> aller <em>HTML-E-Mails</em> eingefügt, die Moodle versendet.';
$string['emailbrandinginstructionli2li3'] = '<code>templateemailtextprefix</code>: Dieses Snippet wird <em>am Anfang / vor dem Hauptteil</em> aller <em>Klartext-E-Mails</em> eingefügt, die Moodle versendet.';
$string['emailbrandinginstructionli2li4'] = '<code>templateemailtextsuffix</code>: Dieses Snippet wird <em>am Ende / nach dem Hauptteil</em> aller <em>Klartext-E-Mails</em> eingefügt, die Moodle versendet.';
$string['emailbrandinginstructionli3'] = 'Speichern Sie die Änderungen am Sprachpaket.';
$string['emailbrandinginstructionli4'] = 'Kommen Sie auf diese Seite zurück und sehen Sie sich die E-Mail-Vorschau unten an.';
$string['emailbrandingintroheading'] = 'Einführung';
$string['emailbrandingintronote'] = 'Beachten Sie, dass diese erweiterte Funktion einige Workarounds verwendet, um das E-Mail-Erscheinungsbild zu beeinflussen. Befolgen Sie bitte die Anweisungen genau.';
$string['emailbrandingpitfalls'] = 'Tücken';
$string['emailbrandingpitfalls0'] = 'Bei der Verwendung dieser Funktion gibt es einige Tücken, die Sie beachten sollten:';
$string['emailbrandingpitfallsli1'] = 'Es ist zwingend erforderlich, dass Sie die Sprachpaketzeichenfolgen der <em>aktuellen Standardsprache</em> dieser Website ändern. Auch wenn Sie mehrere Sprachpakete installiert haben, wirken sich nur Änderungen in der Standardsprache aus.';
$string['emailbrandingpitfallsli2'] = 'Es ist nicht möglich, die Sprache des Empfängers zu respektieren. Daher sollten Sie in Ihren Textelementen für das E-Mail-Erscheinungsbild sprachunabhängige Begriffe verwenden.';
$string['emailbrandingpitfallsli3'] = 'Wenn Sie in Zukunft jemals die Standardsprache der Website ändern, müssen Sie die geänderten Sprachpaketzeichenfolgen in das neue Standardsprachpaket migrieren.';
$string['emailbrandingpitfallsli4'] = 'In Klartext-E-Mails wird nach dem Präfix automatisch ein Zeilenumbruch und eine Leerzeile und vor dem Suffix-Snippet automatisch eine Leerzeile eingefügt. Damit soll sichergestellt werden, dass Suffix und Präfix nicht direkt am E-Mail-Text hängen.';
$string['emailbrandingpitfallsli5'] = 'In HTML-E-Mails werden das Präfix und das Suffix direkt vor und über dem E-Mail-Body hinzugefügt. Dies soll sicherstellen, dass Sie problemlos mit HTML-Tags arbeiten können, Sie müssen jedoch alle Abstände um den Text herum selbst handhaben.';
$string['emailbrandingpitfallsli6'] = 'In HTML-E-Mails können Sie problemlos ein HTML-Tag im Präfix-Snippet öffnen und das Tag im Suffix-Snippet schließen. Denken Sie nur daran, gültiges HTML in der resultierenden E-Mail zu erstellen.';
$string['emailbrandingtab'] = 'E-Mails';
$string['emailbrandingtextdemobody'] = 'Der E-Mail-Text beginnt hier.

Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.

Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.

Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.

Der E-Mail-Text endet hier.';
$string['emailbrandingtextheading'] = 'Klartext-E-Mail-Vorschau';
$string['emailbrandingtextintro'] = 'Dies ist eine Vorschau auf eine Klartext-E-Mail,  basierend auf Präfixen und Suffixen für das Erscheinungsbild, die derzeit im Sprachpaket festgelegt sind.';
$string['emailbrandingtextnopreview'] = 'Bisher wurden die Klartext-E-Mails in diesem Feature nicht angepasst. E-Mails werden normal erstellt und versendet.';
$string['enablecontactsetting'] = 'Kontaktseite aktivieren';
$string['enablehelpsetting'] = 'Hilfeseite aktivieren';
$string['enableimprintsetting'] = 'Impressum aktivieren';
$string['enablemaintenancesetting'] = 'Wartungsinfos aktivieren';
$string['error:infobannerdismissnonotdismissible'] = 'Das angegebene Infobanner ist nicht ausblendbar.';
$string['error:infobannerdismissnonotvalid'] = 'Die angegebene Infobanner-Nummer ist ungültig.';
$string['faviconheading'] = 'Favicon';
$string['faviconsetting'] = 'Favicon';
$string['faviconsetting_desc'] = 'Hier können Sie ein nutzerdefiniertes Bild (im Format .ico- oder .png) hochladen, welches im Browser als Favicon Ihrer Moodle-Website angezeigt wird. Wenn kein nutzerdefiniertes Favicon hochgeladen ist, wird das standardmäßige Moodle-Favicon angezeigt.';
$string['flavoursappliesto'] = 'Verwendung';
$string['flavoursapplytocategories'] = 'Für Kursbereiche verwenden';
$string['flavoursapplytocategories_help'] = 'Hier legen Sie fest, ob diese Variation auf Kursbereiche angewendet werden soll.';
$string['flavoursapplytocategories_ids'] = 'Kursbereiche';
$string['flavoursapplytocategories_ids_help'] = 'Hier legen Sie bestimmte Kursbereiche fest, für die diese Variation verwendet werden soll. Sobald sich eine Moodle-Seite innerhalb eines der konfigurierten Kursbereiche befindet, wird die Variation verwendet.';
$string['flavoursapplytocohorts'] = 'Für globale Gruppen verwenden';
$string['flavoursapplytocohorts_help'] = 'Hier legen Sie fest, ob diese Variation für globale Gruppen verwendet werden soll.';
$string['flavoursapplytocohorts_ids'] = 'Globale Gruppen';
$string['flavoursapplytocohorts_ids_help'] = 'Hier legen Sie bestimmte globale Gruppen fest, für die diese Variation verwendet werden soll. Wenn eine Person Mitglied einer der konfigurierten globalen Gruppen ist, wird die Variation verwendet.<br /><br />Beachten Sie bitte, dass eine Person nicht mehreren globalen Gruppen gleichzeitig angehören muss.<br /><br />Beachten Sie bitte auch, dass beim derzeitigen Stand der Umsetzung die globalen Gruppen für die Kursbereiche so behandelt werden, als wären sie globalen Gruppen für das gesamte System.';
$string['flavoursbackgroundimage'] = 'Hintergrundbild';
$string['flavoursbackgroundimage_help'] = 'Mit dieser Einstellung überschreibt die Variation das Hintergrundbild, das in den Einstellungen von Boost Union konfiguriert ist.';
$string['flavoursbacktooverview'] = 'Zurück zur Variationsübersicht';
$string['flavourscreateflavour'] = 'Variation anlegen';
$string['flavourscustomcss'] = 'Nutzerdefiniertes CSS';
$string['flavourscustomcss_help'] = 'Mit dieser Einstellung können Sie ein nutzerdefiniertes CSS für die Variation festlegen. Es wird an den CSS-Code angehängt, sobald die Variation angewendet wird. Beachten Sie bitte, dass diese Einstellung beim derzeitigen Stand der Umsetzung nur die Verwendung von nutzerdefiniertem CSS zulässt, nicht von SCSS.';
$string['flavoursdelete'] = 'Löschen';
$string['flavoursdeleteconfirmation'] = 'Möchten Sie die Variation <em>{$a}</em> wirklich löschen?';
$string['flavoursdeleteflavour'] = 'Variation löschen';
$string['flavoursdescription'] = 'Beschreibung';
$string['flavoursdescription_help'] = 'Die Beschreibung der Variation wird nur intern verwendet, damit Sie ein bestimmtes Erscheinungsbild in der Liste identifizieren können.';
$string['flavoursedit'] = 'Bearbeiten';
$string['flavourseditflavour'] = 'Variation bearbeiten';
$string['flavoursfavicon'] = 'Favicon';
$string['flavoursfavicon_help'] = 'Mit dieser Einstellung überschreibt die Variation das Favicon, das in den Einstellungen von Boost Union konfiguriert ist.';
$string['flavoursflavours'] = 'Variationen';
$string['flavoursgeneralsettings'] = 'Allgemeine Einstellungen';
$string['flavoursincludesubcategories'] = 'Unterbereiche einbeziehen';
$string['flavoursincludesubcategories_help'] = 'Wenn diese Option aktiviert ist, wird die Variation auch auf die Unterbereiche der ausgewählten Kursbereiche angewendet.';
$string['flavourslogo'] = 'Logo';
$string['flavourslogo_help'] = 'Mit dieser Einstellung wird das Logo aus dem Bereich "Erscheinungsbild" von Boost Union durch die Variation überschrieben.';
$string['flavourslogocompact'] = 'Kompaktes Logo';
$string['flavourslogocompact_help'] = 'Mit dieser Einstellung wird das kompakte Logo aus dem Bereich "Erscheinungsbild" von Boost Union durch die Variation überschrieben.';
$string['flavoursnothingtodisplay'] = 'Es wurden noch keine Variationen erstellt. Erstellen Sie bitte Ihre erste Variation, um die Dinge in Gang zu bringen.';
$string['flavoursnotificationcreated'] = 'Die Variation wurde erfolgreich angelegt.';
$string['flavoursnotificationdeleted'] = 'Die Variation wurde erfolgreich gelöscht.';
$string['flavoursnotificationedited'] = 'Die Variation wurde erfolgreich bearbeitet.';
$string['flavoursoverview_desc'] = '<p>Die Variationen von Boost Union bieten die Möglichkeit, bestimmte Look&Feel-Einstellungen in bestimmten Kontexten zu überschreiben. Auf dieser Seite können Sie Variationen erstellen und verwalten.</p><p>Innerhalb einer Variation legen Sie fest, ob sie auf bestimmte Kurskategorien oder bestimmte globale Gruppen angewendet werden soll. Anschließend prüft Boost Union beim Rendern, ob eine Variation zutrifft. Beachten Sie bitte, dass für jedes Rendering nur die erste passende Variation aus der Liste angewendet wird und alle übrigen Variationen ignoriert werden. Daher ist die Reihenfolge der Variationen auf dieser Seite entscheidend.</p><p>Beachten Sie bitte auch, dass nach jeder Änderung, die Sie an einer Variation vornehmen, der Design-Cache gelöscht wird. Dies ist notwendig, um sicherzustellen, dass alle Assets ordnungsgemäß und aktuell an den Browser gesendet werden.</p>';
$string['flavourspreview'] = 'Vorschau';
$string['flavourspreviewblindtext'] = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Nunc id cursus metus aliquam eleifend mi in nulla. Felis imperdiet proin fermentum leo vel orci porta. Sed nisi lacus sed viverra tellus in hac habitasse. Vivamus arcu felis bibendum ut. Nisi porta lorem mollis aliquam ut porttitor. Odio euismod lacinia at quis risus sed vulputate odio. Sed felis eget velit aliquet sagittis id consectetur purus. Nec ullamcorper sit amet risus nullam eget. Pellentesque sit amet porttitor eget dolor. Cursus mattis molestie a iaculis at erat pellentesque.';
$string['flavourspreviewflavour'] = 'Variationsvorschau';
$string['flavourstitle'] = 'Titel';
$string['flavourstitle_help'] = 'Der Titel der Variation wird nur intern verwendet, damit Sie eine bestimmte Variation in der Liste dokumentieren können.';
$string['fontawesomecheck-fa6free-fallback-description'] = 'Neuere FontAwesome-Versionen werden verwendet, um ältere Symbolkennungen neueren zuzuordnen oder sogar einige Symbole zu entfernen. Wenn Sie auf der linken Seite ein solides Kartensymbol sehen, zeigt Ihre FontAwesome 6-Version die neu zugeordneten Symbole von FontAwesome 4 korrekt an.';
$string['fontawesomecheck-fa6free-fallback-title'] = 'FontAwesome 4 Fallback';
$string['fontawesomecheck-fa6free-filter-description'] = 'Da Sie das FontAwesome-Filter-Plugin installiert haben, sollten Sie sicher sein, dass der Filter auch die neuen FontAwesome 6-Symbole korrekt verarbeitet. Wenn Sie auf der linken Seite ein Benutzersymbol sehen, funktioniert der Filter ordnungsgemäß mit den Symbolen der FontAwesome 6-Version.';
$string['fontawesomecheck-fa6free-filter-title'] = 'FontAwesome-Filter';
$string['fontawesomecheck-fa6free-general-description'] = 'Wenn Sie auf der linken Seite ein Häkchen-Symbol sehen, funktioniert FontAwesome im Allgemeinen auf Ihrer Website.';
$string['fontawesomecheck-fa6free-general-title'] = 'Allgemeine Funktionalität';
$string['fontawesomecheck-fa6free-newstuff-description'] = 'Neuere FontAwesome-Versionen werden im Vergleich zum Iconset von FontAwesome 4 mit zusätzlichen Symbolen ausgeliefert. Wenn Sie auf der linken Seite ein Virensymbol sehen, zeigt Ihre FontAwesome 6-Version ordnungsgemäß neue Symbole an, die neu in FontAwesome 6 sind.';
$string['fontawesomecheck-fa6free-newstuff-title'] = 'FontAwesome 6 Symbole';
$string['fontawesomecheckssetting'] = 'FontAwesome-Prüfungen';
$string['fontawesomecheckssetting_desc'] = 'Hier können Sie visuell überprüfen, ob die FontAwesome-Dateien hochgeladen und ordnungsgemäß zur Moodle-Seite hinzugefügt wurden. Wenn eine der Prüfungen fehlschlägt, kontrollieren Sie bitte, ob alle obligatorischen Dateien korrekt hochgeladen wurden.';
$string['fontawesomefilessetting'] = 'FontAwesome-Dateien';
$string['fontawesomefilessetting_desc'] = 'Mit dieser Einstellung können Sie neuere FontAwesome-Dateien in Moodle hochladen. Sie müssen die FontAwesome-Dateien aufgrund von Lizenzbeschränkungen selbst hochladen. Gehen Sie einfach zu <a href="https://fontawesome.com"> fontawesome.com </a>, laden Sie das FontAwesome-Paket herunter und laden Sie die Dateien hier wieder hoch.';
$string['fontawesomefilesstructurenote'] = 'Beachten Sie bitte, dass die Dateien mit der richtigen Ordnerstruktur und mit den richtigen Dateinamen hochgeladen werden müssen. Erstellen Sie zuerst das Verzeichnisse <em>css</em> und <em>webfonts</em> in der Dateiauswahl, laden Sie dann die  Datei <em>fa-solid-900.woff2 </em> in das Verzeichnis <em>webfonts</em> und speichern Sie "Einstellungen". Danach wird eine Dateiliste angezeigt, in der Sie die richtigen Dateien identifizieren und in diese Verzeichnisse hochladen können.';
$string['fontawesomeheading'] = 'FontAwesome';
$string['fontawesomelistfileinfo-fa6free-css-brands.min.css'] = 'Dies ist eine zusätzliche CSS-Datei, die die Schriftart für FontAwesome-Markensymbole zur Moodle-Seite hinzufügt.';
$string['fontawesomelistfileinfo-fa6free-css-fontawesome.min.css'] = 'Dies ist die Haupt-CSS -Datei, die alle verfügbaren FontAwesome-Glyphen zur Moodle-Seite hinzufügt.';
$string['fontawesomelistfileinfo-fa6free-css-regular.min.css'] = 'Dies ist eine zusätzliche CSS-Datei, die die Schriftart für reguläre Symbole zur Moodle-Seite hinzufügt.';
$string['fontawesomelistfileinfo-fa6free-css-solid.min.css'] = 'Dies ist eine zusätzliche CSS-Datei, die die Schriftart für FontAwesome solide Symbole zur Moodle-Seite hinzufügt.';
$string['fontawesomelistfileinfo-fa6free-css-v4-font-face.min.css'] = 'Dies ist die CSS-Datei, mit der sichergestellt wird, dass die Fontawesome-4-Symbole in Moodle weiterhin korrekt angezeigt werden.';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-brands-400.ttf'] = 'Dies ist die Schriftart für FontAwesome-Markensymbole (im TTF-Format).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-brands-400.woff2'] = 'Dies ist die Schriftart für FontAwesome-Marken-Symbole (im WOFF2-Format).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-regular-400.ttf'] = 'Dies ist die Schriftart für reguläre FontAwesome-Symbole (im TTF-Format).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-regular-400.woff2'] = 'Dies ist die Schriftart für reguläre FontAwesome-Symbole (im WOFF2-Format).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-solid-900.ttf'] = 'Dies ist die Schriftart für solide FontAwesome-Symbole (im TTF-Format).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-solid-900.woff2'] = 'Dies ist die Schriftart für solide FontAwesome-Symbole (im WOFF2-Format).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-v4compatibility.ttf'] = 'Dies ist die Schriftart für die FontAwesome-4-Kompatibilität (im TTF-Format).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-v4compatibility.woff2'] = 'Dies ist die Schriftart für die FontAwesome-4-Kompatibilität (im WOFF2-Format).';
$string['fontawesomelistmandatorymissing'] = 'Dies ist eine obligatorische Datei für FontAwesome, aber sie wurde nicht richtig hochgeladen. Korrigieren Sie bitte den Fehler.';
$string['fontawesomelistmandatoryuploaded'] = 'Dies ist eine obligatorische Datei für FontaWesome, um arbeitsfähig zu sein, und sie wurde ordnungsgemäß hochgeladen.';
$string['fontawesomelistnote'] = 'Beachten Sie bitte, dass beim Hochladen alle obligatorischen Dateien hochgeladen werden müssen. Andernfalls können die FontAwesome-Symbole auf der Moodle-Seite als beschädigt angezeigt werden. Um dies zu beheben, müssen Sie alle obligatorischen Dateien hochladen oder alle Dateien wieder entfernen.';
$string['fontawesomelistoptionalmissing'] = 'Dies ist eine optionale Datei, um den FontAwesome-Symbolsatz zu verbessern, aber sie wurde nicht hochgeladen. Das geht gut, solange sie nicht gebraucht wird.';
$string['fontawesomelistoptionaluploaded'] = 'Dies ist eine optionale Datei, um den FontAwesome-Symbolsatz zu verbessern. Die Datei wurde ordnungsgemäß hochgeladen.';
$string['fontawesomelistsetting'] = 'FontAwesome-Dateiliste';
$string['fontawesomelistsetting_desc'] = 'Dies ist die Liste der FontAwesome-Dateien, die Sie oben in FontAwesome-Dateibereich hochgeladen haben. Es sind alle FontAwesome-Dateien aufgeführt, die für die konfigurierte FontAwesome-Version gültig sind. Weitere Dateien werden ignoriert, Wenn sie hochgeladen wurden, ohne benötigt zu werden. Die FontAwesome-Dateien werden automatisch zu den Moodle-Seiten hinzugefügt und haben einen direkten Effekt, sobald Sie diese Einstellung speichern.';
$string['fontawesomeversionfa6free'] = 'Auf FontAwesome 6 Free aktualisieren';
$string['fontawesomeversionnone'] = 'FontAwesome 4 behalten (wie im Moodle Core bereitgestellt)';
$string['fontawesomeversionsetting'] = 'FontAwesome-Version';
$string['fontawesomeversionsetting_desc'] = 'Der Moodle Core stellt FontAwesome-4-Symbole bereit, aber FontAwesome hat sich weiterentwickelt. Wenn Sie neuere FontAwesome-Symbole verwenden möchten, können Sie dies hier einstellen. Wenn Sie eine andere Version als FontAwesome 4 auswählen, werden zusätzliche Optionen angezeigt, wo Sie neuere FontAwesome-Versionen hochladen können.';
$string['footertab'] = 'Fußbereich';
$string['footnoteheading'] = 'Fußbereich';
$string['footnotesetting'] = 'Fußzeile';
$string['footnotesetting_desc'] = 'Alles, was Sie in diesem Textbereich hinzufügen, wird in der Fußzeile am Ende einer Seite angezeigt. Dieser Text steht in der Fußzeile (nicht in der schwebenden Fußzeile) auf jeder Seite, die die Layouts "drawers", "columns2" oder "login" verwendet. Inhalte können das Urheberrecht, die Nutzungsbedingungen oder der Name Ihrer Organisation sein. <br/>Um die Fußnote wieder zu entfernen, leeren Sie einfach diesen Textbereich.';
$string['githubissueslink'] = '<a href="https://github.com/moodle-an-hochschulen/moodle-theme_boost_union/issues">Github Issues</a>';
$string['h5pcontentmaxwidthsetting'] = 'Maximale Breite von H5P-Inhalten';
$string['h5pcontentmaxwidthsetting_desc'] = 'Mit dieser Einstellung können Sie die Breite von H5P-Inhalten ohne manuelle SCSS-Änderungen überschreiben. Diese Breite wird für den H5P-Editor im Inhaltsspeicher verwendet. Der Wert wird <em>nicht</em> für die Breite der H5P-Aktivität verwendet. Standardmäßig verwendet Moodle eine maximale Breite des H5P-Inhaltsspeichers von 960px. Sie können andere pixelbasierte Breite wie 1200px eingeben, aber auch einen prozentualen Wert wie 100% oder eine Breite des Darstellungsbereichs wie 90vw.';
$string['h5ptab'] = 'H5P';
$string['helpcontentsetting'] = 'Inhalt der Hilfeseite';
$string['helpcontentsetting_desc'] = 'In dieser Einstellung können Sie formatierte Textinhalte hinzufügen, die auf einer Hilfeseite angezeigt werden.';
$string['helpdisabled'] = 'Die Hilfeseite ist für diese Website deaktiviert. Hier wird nichts angezeigt.';
$string['helpheading'] = 'Hilfe';
$string['helplinkpositionboth'] = 'Link zur Hilfeseite in der Fußzeile und dem Fußzeilensymbol (Fragezeichen) hinzufügen';
$string['helplinkpositionfooter'] = 'Link zur Hilfeseite dem Fußzeilensymbol (Fragezeichen) hinzufügen';
$string['helplinkpositionfootnote'] = 'Link zur Hilfeseite in der Fußzeile hinzufügen';
$string['helplinkpositionnone'] = 'Link zur Hilfeseite nicht automatisch anzeigen';
$string['helplinkpositionsetting'] = 'Linkposition zur Hilfeseite';
$string['helplinkpositionsetting_desc'] = 'In dieser Einstellung können Sie konfigurieren, ob automatisch ein Link zur Hilfeseite hinzugefügt werden soll. Wenn Sie nicht automatisch einen Link anzeigen möchten, können Sie von überall manuell einen Link zu {$a->url} hinzufügen.';
$string['helppagetitledefault'] = 'Hilfe';
$string['helppagetitlesetting'] = 'Titel der Hilfeseite';
$string['helppagetitlesetting_desc'] = 'In dieser Einstellung können Sie den Titel der Hilfeseite festlegen. Dieser Text wird auch als Linktext zur Hilfeseite verwendet, wenn Sie die \'Linkposition Hilfeseite\' entsprechend konfigurieren.';
$string['hidenodesprimarynavigationsetting'] = 'Knoten in der Primärnavigation verbergen';
$string['hidenodesprimarynavigationsetting_desc'] = 'Mit dieser Einstellung können Sie einen oder mehrere Knoten aus der Primärnavigation ausblenden.';
$string['imprintcontentsetting'] = 'Impressum Inhalt';
$string['imprintcontentsetting_desc'] = 'In dieser Einstellung können Sie formatierte Textinhalte hinzufügen, die im Impressum angezeigt werden.';
$string['imprintdisabled'] = 'Das Impressum ist für diese Website deaktiviert. Hier wird nichts angezeigt.';
$string['imprintheading'] = 'Impressum';
$string['imprintlinkpositionboth'] = 'Link zum Impressum in der Fußnote und zum Fußzeilensymbol (Fragezeichen) hinzufügen';
$string['imprintlinkpositionfooter'] = 'Link zum Impressum zum Fußzeilensymbol (Fragezeichen) hinzufügen';
$string['imprintlinkpositionfootnote'] = 'Link zum Impressum in der Fußnote hinzufügen';
$string['imprintlinkpositionnone'] = 'Link zum Impressum nicht automatisch anzeigen';
$string['imprintlinkpositionsetting'] = 'Linkposition für Impressum';
$string['imprintlinkpositionsetting_desc'] = 'In dieser Einstellung können Sie festlegen, ob der Moodle-Seite automatisch ein Link zum Impressum hinzugefügt werden soll. Wenn Sie nicht automatisch einen Link anzeigen möchten, können Sie von überall in Moodle manuell einen Link zu {$a->url} hinzufügen.';
$string['imprintpagetitledefault'] = 'Impressum';
$string['imprintpagetitlesetting'] = 'Impressum Überschrift';
$string['imprintpagetitlesetting_desc'] = 'In dieser Einstellung können Sie den Titel des Impressums festlegen. Dieser Text wird auch als Linktext zum Impressum verwendet, wenn Sie die \'Linkposition für Impressum\' entsprechend konfigurieren.';
$string['infobannerbsclasssetting'] = 'Infobanner {$a->no} Bootstrap Class';
$string['infobannerbsclasssetting_desc'] = 'Mit dieser Einstellung können Sie den Bootstrap-Stil auswählen, mit dem Infobanner {$a->no} angezeigt werden soll. Wenn Sie die Option „Keine Bootstrap-Farbe“ wählen, wird das Infobanner ohne eine bestimmte Bootstrap-Farbe ausgegeben, was Ihnen die Freiheit gibt, das Banner im Texteditor selbst zu gestalten.';
$string['infobannerclose'] = 'Schließen';
$string['infobannercontentsetting'] = 'Infobanner {$a->no} Inhalt';
$string['infobannercontentsetting_desc'] = 'Tragen Sie hier die Informationen ein, die innerhalb des Infobanners {$a->no} angezeigt werden sollen.';
$string['infobannerdismissconfirm'] = 'Möchten Sie wirklich die Sichtbarkeit des Infobanners {$a->no} zurücksetzen und möchten Sie es allen Personen erneut anzeigen?';
$string['infobannerdismissfail'] = 'Das Zurücksetzen der Sichtbarkeit des Infobanners {$a->no} ist für mindestens eine Person fehlgeschlagen.';
$string['infobannerdismissiblesetting'] = 'Infobanner {$a->no} ausblendbar';
$string['infobannerdismissiblesetting_desc'] = 'Mit dieser Einstellung können Sie das Infobanner {$a->no} ausblendbar machen. Klickt eine Person auf die Taste X im Infobanner, wird das Banner für diese Person dauerhaft ausgeblendet. Die Sichtbarkeit wird nicht automatisch zurückgesetzt, auch wenn Sie den Inhalt des Infobanners ändern. Wenn Sie die Sichtbarkeit des Infobanners zurücksetzen möchten, klicken Sie unten auf die Taste "Sichtbarkeit zurücksetzen".';
$string['infobannerdismissreset'] = 'Sichtbarkeit für ausgeblendetes Infobanners zurücksetzen';
$string['infobannerdismissresetbutton'] = 'Sichtbarkeit für Infobanner {$a->no} zurücksetzen';
$string['infobannerdismisssuccess'] = 'Die Sichtbarkeit für Infobanner {$a->no} wurde zurückgesetzt.';
$string['infobannerenabledsetting'] = 'Infobanner {$a->no} aktivieren';
$string['infobannerenabledsetting_desc'] = 'Mit dieser Einstellung können Sie das Infobanner {$a->no} aktivieren.';
$string['infobannerendsetting'] = 'Infobanner {$a->no} Endzeit';
$string['infobannerendsetting_desc'] = 'Mit dieser Einstellung können Sie festlegen, bis wann Infobanner {$a->no} angezeigt werden soll. Die konfigurierte Zeit wird als Serverzeit interpretiert, nicht als Nutzerzeit.';
$string['infobannerheading'] = 'Infobanner {$a->no}';
$string['infobannermodeperpetual'] = 'Dauerhaft';
$string['infobannermodesetting'] = 'Infobanner {$a->no} Anzeigemodus';
$string['infobannermodesetting_desc'] = 'Mit dieser Einstellung können Sie festlegen, ob Infobanner {$a->no} ein dauerhaft angezeigtes Banner oder ein zeitgesteuertes Banner soll. Für die Zeitsteuerung muss das Zeitintervall konfiguriert werden.';
$string['infobannermodetimebased'] = 'Zeitgesteuert';
$string['infobannerordersetting'] = 'Infobanner {$a->no} Reihenfolge';
$string['infobannerordersetting_desc'] = 'Mit dieser Einstellung legen Sie die Position für das Infobanner {$a->no} fest. Standardmäßig sind die Infobanner von oben nach unten angeordnet, wie Sie sie auf dieser Einstellungsseite hier sehen. Mit dieser Einstellung können Sie die Reihenfolge ändern. Wenn Sie mehreren Infobannern dieselbe Position zuweisen, werden diese erneut gemäß der Reihenfolge auf dieser Einstellungsseite geordnet.';
$string['infobannerpageloginpage'] = 'Anmeldeseite';
$string['infobannerpagessetting'] = 'Seitenlayouts zur Anzeige von Infobanner {$a->no} auf';
$string['infobannerpagessetting_desc'] = 'Mit dieser Einstellung können Sie die Seitenlayouts auswählen, auf denen Infobanner {$a->no} angezeigt werden soll.';
$string['infobannerstartsetting'] = 'Infobanner {$a->no} Startzeit';
$string['infobannerstartsetting_desc'] = 'Mit dieser Einstellung können Sie festlegen, ab wann Infobanner {$a->no} angezeigt werden soll. Die konfigurierte Zeit wird als Serverzeit interpretiert, nicht als Nutzerzeit.';
$string['infobannertab'] = 'Infobanner';
$string['javascriptdisabledhint'] = 'Hinweis zu JavaScript';
$string['javascriptdisabledhint_desc'] = 'Mit dieser Einstellung erscheint oben in Moodle ein Hinweis, wenn JavaScript nicht aktiviert ist. Dies ist besonders hilfreich, da einige Moodle-Funktionen ohne JavaScript nicht funktionieren.';
$string['javascriptdisabledhinttext'] = 'JavaScript ist in Ihrem Browser deaktiviert.<br />Viele Funktionen in Moodle können nicht verwendet werden oder scheinen fehlerhaft zu sein.<br />Aktivieren Sie bitte JavaScript, um Moodle in vollem Umfang nutzen zu können.';
$string['javascriptheading'] = 'JavaScript';
$string['linkstab'] = 'Links';
$string['loginbackgroundimage'] = 'Hintergrundbilder für die Anmeldeseite';
$string['loginbackgroundimage_desc'] = 'Bilder, die als Hintergrund auf der Anmeldeseite gezeigt werden. Jeweils eins der Bilder wird zufällig ausgewählt und als Hintergrund angezeigt, wenn Nutzer/innen die Anmeldeseite besuchen. Stellen Sie bitte sicher, dass Sie ausschließlich Ascii-Zeichen im Dateinamen verwenden, wenn Sie Text für Anmeldehintergrundbilder anzeigen möchten.';
$string['loginbackgroundimagesheading'] = 'Hintergrundbilder für die Anmeldeseite';
$string['loginbackgroundimagetextsetting'] = 'Text für Hintergrundbilder anzeigen';
$string['loginbackgroundimagetextsetting_desc'] = 'Mit dieser optionalen Einstellung können Sie Text hinzufügen, z.B. einen Urheberrechtshinweis zum jeweils hochgeladenen Hintergrundbild. Dieser Text erscheint oben in der Fußzeile der Anmeldeseite. Aus Platzgründen wird der Text jedoch nur auf größeren Bildschirmen angezeigt.<br />
Jede Zeile besteht aus der Dateikennung (das ist der Dateiname), dem anzuzeigenden Text und der Textfarbe, getrennt durch Pipe-Zeichen |. Jede Deklaration muss in eine neue Zeile geschrieben werden. <br />
Beispiel:<br />
background-image-1.jpg|Copyright: CC0|dark<br />
Als Textfarbe können Sie die Werte "dark" oder "light" verwenden.<br />
Sie können Texte für beliebig viele hochgeladene Hintergrundbilder einfügen. Die Texte werden nur mit dem jeweiligen Bild gezeigt, dessen Dateiname mit der angegebenen Dateikennung übereinstimmt.';
$string['loginformheading'] = 'Anmeldeformular';
$string['loginformpositionsetting'] = 'Position des Anmeldeformulars';
$string['loginformpositionsetting_center'] = 'Zentriert';
$string['loginformpositionsetting_desc'] = 'Mit dieser Einstellung können Sie das Anmeldeformular so optimieren, dass es zu einer großen Vielfalt von Hintergrundbildern passt. Standardmäßig ist das Anmeldeformular zentriert auf der Anmeldeseite. Alternativ können Sie es nach links oder rechts auf der Anmeldeseite bewegen, um andere Teile des Hintergrundbildes durchscheinen zu lassen. Sie können diese Einstellung auch ändern, wenn keine Hintergrundbilder hochgeladen sind.';
$string['loginformpositionsetting_left'] = 'Linksbündig';
$string['loginformpositionsetting_right'] = 'Rechtsbündig';
$string['loginformtransparencysetting'] = 'Transparenz des Anmeldeformulars';
$string['loginformtransparencysetting_desc'] = 'Mit dieser Einstellung können Sie das Anmeldeformular transparent machen, damit das Hintergrundbild besser durchscheint.';
$string['loginpagetab'] = 'Anmeldeseite';
$string['logocompactsetting'] = 'Kompaktes Logo';
$string['logocompactsetting_desc'] = 'Hier können Sie eine kompakte Version desselben Logos wie oben hochladen, z.B. ein Emblem, Schild oder Symbol. Dieses Bild wird insbesondere in der Navigationsleiste oben auf jeder Moodle-Seite verwendet. Das Bild sollte auch bei kleinen Größen klar erkennbar sein.';
$string['logosetting'] = 'Logo';
$string['logosetting_desc'] = 'Hier können Sie ein großformatiges Logo hochladen, das als Dekoration verwendet werden soll. Dieses Bild wird insbesondere auf der Anmeldeseite verwendet. Dieses Bild kann eine hohe Auflösung haben, da es für die Verwendung angepasst wird.';
$string['logosheading'] = 'Logos';
$string['logosheading_desc'] = 'Beachten Sie: Das Design "Boost Union" hat einen eigenen Logo-Upload und verwendet nicht das <a href="{$a}">Logo des Moodle-Core</a>.<br />Boost Union ermöglicht insbesondere, mehr Bilderformate hochzuladen als im Moodle-Core zugelassen.  Zusätzlich ermöglicht der Upload hier, die hochgeladenen Logos innerhalb der Varianten von Boost Union zu überschreiben.';
$string['maintenancecontentsetting'] = 'Inhalt der Wartungsinfo';
$string['maintenancecontentsetting_desc'] = 'In dieser Einstellung können Sie Textinhalte hinzufügen, die in einer Wartungsinfo angezeigt werden (die nicht mit dem integrierten "Wartungsseiten-Support" von Moodle identisch ist).';
$string['maintenancedisabled'] = 'Die Wartungsinfos sind für diese Website deaktiviert. Hier wird nichts angezeigt.';
$string['maintenanceheading'] = 'Wartung';
$string['maintenancelinkpositionboth'] = 'Link für Wartungsinfo in der Fußzeile und zum Fußzeilensymbol (Fragezeichen) hinzufügen';
$string['maintenancelinkpositionfooter'] = 'Link für Wartungsinfo zum Fußzeilensymbol (Fragezeichen) hinzufügen';
$string['maintenancelinkpositionfootnote'] = 'Link für Wartungsinfo in der Fußzeile hinzufügen';
$string['maintenancelinkpositionnone'] = 'Link für Wartungsinfo nicht automatisch anzeigen';
$string['maintenancelinkpositionsetting'] = 'Linkposition für Wartungsinfo';
$string['maintenancelinkpositionsetting_desc'] = 'In dieser Einstellung können Sie konfigurieren, ob automatisch ein Link für Wartungsinfo hinzugefügt werden soll. Wenn Sie nicht automatisch einen Link anzeigen möchten, können Sie überall manuell einen Link zu {$a->url} hinzufügen.';
$string['maintenancepagetitledefault'] = 'Wartung';
$string['maintenancepagetitlesetting'] = 'Titel der Wartungsinfo';
$string['maintenancepagetitlesetting_desc'] = 'In dieser Einstellung können Sie den Titel der Wartungsinfo festlegen. Dieser Text wird auch als Linktext zur Wartungsinfo verwendet, wenn Sie die \'Linkposition für Wartungsinfo\' entsprechend konfigurieren.';
$string['markexternallinkssetting'] = 'Externe Links markieren';
$string['markexternallinkssetting_desc'] = 'Diese Einstellung fügt ein Symbol "Externer Link" nach den jeweiligen Links hinzu, wenn sie zu einem Ziel außerhalb von Moodle führen.';
$string['misctab'] = 'Verschiedenes';
$string['mobileappearanceheading'] = 'Mobile Darstellung';
$string['mobilecss'] = 'Zusätzliches CSS für mobile App';
$string['mobilecss_desc'] = 'Mit dieser Einstellung können Sie nutzerdefinierten CSS-Code schreiben, um die Nutzeroberfläche der mobilen App anzupassen. Der CSS-Code wird nur zur Darstellung in der mobilen App hinzugefügt und nicht in der Webbrowser verwendet. Lesen Sie mehr über diese Funktion in der <a href="https://moodledev.io/general/app/customisation/remote-themes#how-do-remote-themes-work">Moodle-Entwicklerdokumentation</a>.';
$string['mobilecss_donotchange'] = 'Dieser Schritt ist erforderlich, um den CSS-Code an die mobile App zu senden. Ändern Sie die URL nicht, es sei denn, Sie möchten den CSS-Code wirklich wieder aus der Mobile-App entfernen.';
$string['mobilecss_overwrite'] = 'Sobald Sie CSS-Code hinzufügen und diese Einstellung speichern, wird die <a href="{$a->url}">Einstellung <em>mobilecssurl</em> im Moodle-Core</a> automatisch mit einer URL des Designs "Boost Union" überschrieben. Momentan ist die Einstellung auf <a href="{$a->value}">{$a->value}</a> gesetzt.';
$string['mobilecss_set'] = 'Sobald Sie CSS-Code hinzufügen und diese Einstellung speichern, wird die <a href="{$a->url}">Einstellung <em>mobilecssurl</em> im Moodle-Core</a> automatisch mit einer URL des Designs "Boost Union" überschrieben.';
$string['mobiletab'] = 'Mobile App';
$string['modiconactivity'] = 'Aktivität';
$string['modiconactivityunknown'] = 'Unbekannt';
$string['modicongtmoodle4'] = 'Icon für Moodle 4';
$string['modiconlistsetting'] = 'Liste von nutzerdefinierten Symboldateien';
$string['modiconlistsetting_desc'] = 'Dies ist die Liste der nutzerdefinierten Symboldateien, die Sie oben in den entsprechenden Dateibereich hochgeladen haben. Hier werden alle gültigen Symboldateien aufgelistet. Andere Dateien, die Sie möglicherweise ebenfalls hochgeladen haben, die aber keine gültigen Symboldateien sind, werden als beschädigte Dateien angezeigt.';
$string['modiconltmoodle311'] = 'Icon für Moodle 3';
$string['modiconnamefail'] = 'Diese Datei wurde im richtigen Verzeichnis für die Aktivität <em>{$a}</em> hochgeladen, aber der Dateiname ist ungültig. Ändern Sie bitte den Dateinamen entweder in <em>monologo.svg</em> / <em>monologo.png</em> (für Moodle 4-Symbole) oder in <em>icon.svg</em> / <em>icon .png</em> (für ältere Moodle 3-Symbole).';
$string['modiconnotexist'] = 'Diese Datei wurde an einem ungeeigneten Ort hochgeladen, da es nicht möglich ist, aus dem Dateipfad <em>{$a}</em> eine bestimmte Aktivität abzuleiten.';
$string['modiconsenablesetting'] = 'Nutzerdefinierte Symbole für Aktivitäten und Ressourcen aktivieren';
$string['modiconsenablesetting_desc'] = 'Mit dieser Einstellung können Sie die Symbole für Aktivitäten und Ressourcen ändern, die von Moodle auf den Kursseiten und in der Aktivitätsauswahl verwendet werden.';
$string['modiconserrorcreatingpath'] = 'Das Verzeichnis pix_plugins/mod konnte  im Verzeichnis moodledata nicht erstellt werden.<br />Die Fehlermeldung lautet: {$a}.';
$string['modiconsfiles'] = 'Nutzerdefinierte Symboldateien';
$string['modiconsfiles_desc'] = 'Hier können Sie nutzerdefinierte Symbole für alle oder auch nur bestimmte Aktivitäten hochladen, die in diesem Moodle installiert sind.';
$string['modiconsfileshowto'] = 'Um ein bestimmtes nutzerdefiniertes Aktivitätssymbol hochzuladen, erstellen Sie zunächst ein Verzeichnis mit dem internen Namen der Aktivität, z.B. <em>assign</em> für die Aktivität Aufgabe. In dieses Verzeichnis laden Sie das Symbol als SVG-Datei mit dem Namen monologo.svg und, wenn möglich, als Fallback-PNG-Datei mit dem Namen monologo.png hoch. Wenn Sie die farbigen Symbole für Moodle 3, die möglicherweise noch von älteren Plugins verwendet werden, anpassen möchten, können Sie diese auch als icon.svg- und icon.png-Dateien hochladen. Um optimale Ergebnisse zu erzielen, sollten Sie möglichst monochrome SVG-Symbole verwenden. Sobald Sie die Einstellung mit mindestens einer Symboldatei gespeichert haben, erscheint unten eine Dateiliste. Sie  können hiermit überprüfen, ob die nutzerdefinierten Symbole korrekt hochgeladen wurden.';
$string['modiconsfilestech'] = 'Technischer Hinweis: Nach dem Speichern der Einstellung wird die Verzeichnisstruktur mit den Symboldateien ins Verzeichnis moodledata/pix_plugins/mod kopiert. Hier sucht Moodle Core nach nutzerdefinierten Aktivitätssymbolen. Alle möglicherweise bereits an dieser Stelle  vorhandenen Symboldateien werden beim Speichern dieser Einstellung überschrieben.';
$string['modiconsheading'] = 'Aktivitätssymbole';
$string['modiconsuccess3x'] = 'Dieses Symbol wird für die Aktivität <em>{$a}</em> als Symbol für Moodle 3 verwendet.';
$string['modiconsuccess4x'] = 'Dieses Symbol wird für die Aktivität <em>{$a}</em> als Symbol für Moodle 4 verwendet.';
$string['modiconversion'] = 'Symbolversion';
$string['navbarcolorsetting'] = 'Farbe Navigationsleiste';
$string['navbarcolorsetting_dark'] = 'Dunkle Navigationsleiste mit heller Schrift';
$string['navbarcolorsetting_desc'] = 'Mit dieser Einstellung können Sie die Navigationsleiste von hell (Standard) auf dunkel oder farbig ändern.';
$string['navbarcolorsetting_light'] = 'Helle Navigationsleiste mit dunkler Schrift (wie Moodle-Standard)';
$string['navbarcolorsetting_primarydark'] = 'Navigationsleiste in Farbe Primär mit heller Schrift';
$string['navbarcolorsetting_primarylight'] = 'Navigationsleiste in Farbe Primär mit dunkler Schrift';
$string['navbarheading'] = 'Navigationsleiste';
$string['navigationheading'] = 'Navigation';
$string['navigationtab'] = 'Navigation';
$string['openoffcanvas'] = 'Off-Canvas öffnen';
$string['outsideregionsheading'] = 'Regionen außerhalb';
$string['outsideregionsheading_desc'] = 'Die Regionen außerhalb können nicht nur mit den genannten Layouteinstellungen aktiviert werden, sondern auch im Erscheinungsbild angepasst werden.';
$string['outsideregionsplacement'] = 'Horizontale Platzierung der Regionen außerhalb';
$string['outsideregionsplacement_desc'] = 'Mit dieser Einstellung können Sie steuern, ob die Blockregionen \'Außen (links)\' und \'Außen (rechts)\' auf größeren Bildschirmen nah am Hauptinhalt oder eher nah an den Fensterrändern platziert werden sollen.';
$string['outsideregionsplacementnearwindowedges'] = 'Blockregionen \'Außen (links)\' und \'Außen (rechts)\' nah am Fensterrand anzeigen';
$string['outsideregionsplacementnextmaincontent'] = 'Blockregionen \'Außen (links)\' und \'Außen (rechts)\' nah am Hauptinhalt anzeigen';
$string['outsideregionswidthcoursecontentwidth'] = 'Breite des Kursinhalts';
$string['outsideregionswidthfullwidth'] = 'Volle Breite';
$string['outsideregionswidthherowidth'] = 'Ideale Breite';
$string['pagetab'] = 'Seitenbreite';
$string['pagewidthheading'] = 'Seitenbreite';
$string['pluginname'] = 'Boost Union';
$string['presetheading'] = 'Designvorlagen';
$string['primarynavigationheading'] = 'Primäre Navigation';
$string['privacy:metadata'] = 'Das Design "Boost Union" speichert keine personenbezogenen Daten.';
$string['region-content-lower'] = 'Inhalt (unten)';
$string['region-content-upper'] = 'Inhalt (oben)';
$string['region-footer-center'] = 'Fußbereich (mittig)';
$string['region-footer-left'] = 'Fußbereich (links)';
$string['region-footer-right'] = 'Fußbereich (rechts)';
$string['region-header'] = 'Kopfbereich';
$string['region-none'] = 'Keine';
$string['region-offcanvas-center'] = 'Off-Canvas (mittig)';
$string['region-offcanvas-left'] = 'Off-Canvas (links)';
$string['region-offcanvas-right'] = 'Off-Canvas (rechts)';
$string['region-outside-bottom'] = 'Außen (unten)';
$string['region-outside-left'] = 'Außen (links)';
$string['region-outside-right'] = 'Außen (rechts)';
$string['region-outside-top'] = 'Außen (oben)';
$string['resourcescachecontrolnote'] = 'Beachten Sie bitte, dass die Dateien mit dem "Cache-Control-Header" an den Browser geliefert und dort im Cache gespeichert werden. Wenn Sie sicher sind, dass sich die Dateien nicht ändern, können Sie die gleichbleibenden URLs verwenden. Wenn Sie jedoch eine oder mehrere Dateien ändern und die Dateinamen beibehalten, sollten Sie lieber die revisionierten URLs verwenden. Zwar wird so jede Datei immer neu ausgeliefert, aber Sie verhindern veraltete Versionen im Browsercache.';
$string['resourcestab'] = 'Ressourcen';
$string['scrollspy'] = 'Scroll-Spion';
$string['scrollspysetting'] = 'Scroll-Spion';
$string['scrollspysetting_desc'] = 'Mit dieser Einstellung wird beim Ein- und Ausschalten des Bearbeitungsmodus die Bildlaufposition beibehalten, an der sich die Person beim Ausführen des Umschaltens befand.';
$string['scssheading'] = 'Raw SCSS';
$string['scsstab'] = 'SCSS';
$string['showhintcourseguestaccessgeneral'] = 'Sie betrachten diesen Kurs gerade als <strong>{$a->role}</strong>.';
$string['showhintcourseguestaccesslink'] = 'Um vollen Zugriff auf diesen Kurs zu erhalten, können Sie sich <a href="{$a->url}">selbst in diesen Kurs einschreiben</a>.';
$string['showhintcourseguestaccesssetting_desc'] = 'Mit dieser Einstellung wird ein Hinweis im Kopfbereich aktiviert, wenn Nutzer/innen einen Kurs über den Gastzugang betreten. Wenn der Kurs eine aktive Selbsteinschreibung anbietet, wird dem Gast außerdem ein Link zu dieser Einschreibemöglichkeit angezeigt.';
$string['showhintcoursehiddengeneral'] = 'Dieser Kurs ist zur Zeit <strong>verborgen</strong>. Solange der Kurs weiter verborgen ist, können ausschließlich eingeschriebene Trainer/innen darauf zugreifen.';
$string['showhintcoursehiddensetting'] = 'Hinweis in verborgenen Kursen anzeigen';
$string['showhintcoursehiddensetting_desc'] = 'Mit dieser Einstellung wird ein Hinweis im Kursheader angezeigt, solange der Kurs verborgen ist. Dies erlaubt die Erkennung des Sichtbarkeitsstatuses eines Kurses auf einen Blick, ohne die Kurseinstellungen öffnen zu müssen.';
$string['showhintcoursehiddensettingslink'] = 'Sie können die Sichtbarkeit in den <a href="{$a->url}">Kurseinstellungen</a> ändern.';
$string['showhintcourseselfenrolfrom'] = 'Die Einschreibung <strong>{$a->name}</strong> erlaubt eine unbeschränkte Selbsteinschreibung ab {$a->from}.';
$string['showhintcourseselfenrolfromuntil'] = 'Die Einschreibung <strong>{$a->name}</strong> erlaubt eine unbeschränkte Selbsteinschreibung ab {$a->from} bis {$a->until}.';
$string['showhintcourseselfenrolinstancecallforaction'] = 'Wenn Sie verhindern möchten, dass sich Nutzer/innen ungehindert in diesen Kurs einschreiben können, beschränken Sie dies bitte in den Einstellungen zur Selbsteinschreibung.';
$string['showhintcourseselfenrolsetting'] = 'Hinweis wegen Selbsteinschreibung ohne Einschreibeschlüssel anzeigen';
$string['showhintcourseselfenrolsetting_desc'] = 'Mit dieser Einstellung können Sie festlegen, dass ein Hinweis im Kurskopf erscheint, wenn ein Kurs sichtbar ist und eine Selbsteinschreibung ohne Einschreibeschlüssel aktuell möglich ist.';
$string['showhintcourseselfenrolsince'] = 'Die Einschreibung <strong>{$a->name}</strong> erlaubt aktuell eine unbeschränkte Selbsteinschreibung.';
$string['showhintcourseselfenrolsinceuntil'] = 'Die Einschreibung <strong>{$a->name}</strong> erlaubt eine unbeschränkte Selbsteinschreibung bis {$a->until}.';
$string['showhintcourseselfenrolstartcurrently'] = 'Dieser Kurs ist momentan für alle sichtbar und eine <strong>Selbsteinschreibung ohne Einschreibeschlüssel</strong> ist möglich.';
$string['showhintcourseselfenrolstartfuture'] = 'Dieser Kurs ist momentan für alle sichtbar und eine <strong>Selbsteinschreibung ohne Einschreibeschlüssel</strong> ist mit Startdatum konfiguriert.';
$string['showhintcourseselfenrolunlimited'] = 'Die Einschreibung <strong>{$a->name}</strong> erlaubt eine unbeschränkte Selbsteinschreibung auf unbestimmte Zeit.';
$string['showhintcourseselfenroluntil'] = 'Die Einschreibung <strong>{$a->name}</strong> erlaubt eine unbeschränkte Selbsteinschreibung bis {$a->until}.';
$string['showhintcoursguestaccesssetting'] = 'Hinweis bei Gastzugang anzeigen';
$string['showsitehomerighthandblockdraweronfirstloginsetting'] = 'Rechtsseitige Blockleiste beim ersten Login auf der Startseite anzeigen';
$string['showsitehomerighthandblockdraweronfirstloginsetting_desc'] = 'Mit dieser Einstellung wird die rechtsseitige Blockleiste auf der Startseite standardmäßig im ausgeklappten Zustand angezeigt. Dies gilt nur für Nutzer/innen, die sich zum ersten Mal anmelden, und überschreibt nicht den Toggle-Status von einzelnen Nutzer/innen.';
$string['showsitehomerighthandblockdraweronguestloginsetting'] = 'Rechtsseitige Blockleiste beim Gast-Login auf der Startseite anzeigen';
$string['showsitehomerighthandblockdraweronguestloginsetting_desc'] = 'Mit dieser Einstellung wird die rechtsseitige Blockleiste auf der Startseite standardmäßig im ausgeklappten Zustand angezeigt. Dies gilt nur für Nutzer/innen, die als Gast angemeldet sind.';
$string['showsitehomerighthandblockdraweronvisitsetting'] = 'Rechtsseitige Blockleiste auf der Startseite beim Besuch anzeigen';
$string['showsitehomerighthandblockdraweronvisitsetting_desc'] = 'Mit dieser Einstellung wird die rechtsseitige Blockleiste auf der Startseite standardmäßig im ausgeklappten Zustand angezeigt. Dies gilt nur für Nutzer/innen, die nicht angemeldet sind, und überschreibt nicht den Toggle-Status von einzelnen Nutzer/innen.';
$string['showswitchedroleincoursesetting'] = 'Hinweis bei Rollenwechsel anzeigen';
$string['showswitchedroleincoursesetting_desc'] = 'Mit dieser Einstellung wird ein Hinweis in der Kurskopfzeile angezeigt, wenn die Person die Rolle im Kurs gewechselt hat. Standardmäßig werden diese Informationen nur direkt neben dem Avatar im Nutzermenü angezeigt. Wenn Sie diese Option aktivieren, können Sie diese Information - zusammen mit einem Link zum Zurückschalten - auch innerhalb der Kursseite anzeigen.';
$string['sitebrandingtab'] = 'Farbe der Website';
$string['sitehomerighthandblockdrawerbehaviour'] = 'Rechtsseitige Blockleiste auf der Startseite';
$string['speciallinksmarkupheading'] = 'Spezielle Markierung von Links';
$string['staticpagestab'] = 'Statische Seiten';
$string['switchedroleto'] = 'Sie sehen den Kurs momentan in der Rolle: <strong>{$a->role}</strong>.';
$string['templateemailhtmlprefix'] = '';
$string['templateemailhtmlsuffix'] = '';
$string['templateemailtextprefix'] = '';
$string['templateemailtextsuffix'] = '';
$string['tilebackgroundimagepositionsetting'] = 'Hintergrundbildposition für Werbefeld {$a->no}';
$string['tilebackgroundimagepositionsetting_desc'] = 'Mit dieser Einstellung legen Sie die Position des Hintergrundbildes im Werbefeld {$a->no} fest. Der erste Wert ist die horizontale Position, der zweite Wert ist die vertikale Position.';
$string['tilebackgroundimagesetting'] = 'Hintergrundbild für Werbefeld {$a->no}';
$string['tilebackgroundimagesetting_desc'] = 'Hier können Sie ein Bild hochladen, das als Hintergrundbild hinter dem Inhalt im Werbefeld {$a->no} angezeigt wird. Stellen Sie bitte sicher, dass der Inhalt auf dem Hintergrundbild lesbar ist. Dies ist eine optionale Einstellung und das Werbefeld wird auch dann angezeigt, wenn Sie kein Hintergrundbild hochladen.';
$string['tilecolumnssetting'] = 'Anzahl von Werbefelder pro Zeile';
$string['tilecolumnssetting_desc'] = 'Hier legen Sie die Anzahl der Spalten pro Zeile für das Raster der Werbefelder fest. Beachten Sie, dass diese Spaltenanzahl nur für größere Bildschirme gilt. Auf kleineren Bildschirmen und mobilen Endgeräten werden die Spalten automatisch angepasst.';
$string['tilecontentsetting'] = 'Inhalt für Werbefeld {$a->no}';
$string['tilecontentsetting_desc'] = 'Hier geben Sie den Inhalt ein, der im Werbefeld {$a->no} angezeigt werden soll. Der Inhalt wird mittig im Bereich angezeigt. Dies ist eine optionale Einstellung und das Werbefeld wird auch dann angezeigt, wenn Sie keinen Inhalt eingeben.';
$string['tileenabledsetting'] = 'Werbefeld {$a->no} aktivieren';
$string['tileenabledsetting_desc'] = 'Mit dieser Einstellung können Sie das Werbefeld {$a->no} aktivieren.';
$string['tilefrontpagepositionsetting'] = 'Position der Werbefelder auf der Startseite';
$string['tilefrontpagepositionsetting_after'] = 'Nach dem Inhalt der Startseite';
$string['tilefrontpagepositionsetting_before'] = 'Vor dem Inhalt der Startseite';
$string['tilefrontpagepositionsetting_desc'] = 'Werbefelder werden nur auf der Startseite angezeigt. Sie können festlegen, ob die Werbefelder vor oder nach dem eigentlichen Inhalt der Startseite angezeigt werden sollen. Wenn Sie nur die Werbefelder anzeigen wollen und sonst nichts, können Sie alle anderen Inhalte der Startseite entfernen, indem Sie die <a href="{$a->url}">Einstellungen für die Startseite</a> ändern.';
$string['tileheading'] = 'Werbefeld {$a->no}';
$string['tileheightsetting'] = 'Höhe der Werbefelder';
$string['tileheightsetting_desc'] = 'Mit dieser Einstellung legen Sie die Höhe der Werbefelder fest. Die festgelegte Höhe ist die minimale Höhe. Wenn der Inhalt eines Feldes höher ist als die hier festgelegte Höhe, wird die gesamte Zeile der Werbefelder automatisch höher angezeigt.';
$string['tilelinksetting'] = 'URL für Werbefeld {$a->no}';
$string['tilelinksetting_desc'] = 'Hier können Sie eine URL festlegen, die Moodle intern oder extern ist und am Ende des Werbefeldes {$a->no} angezeigt wird. Dies ist eine optionale Einstellung und das Werbefeld wird auch dann angezeigt, wenn Sie keine URL festlegen.';
$string['tilelinktargetsetting'] = 'Linkziel für Werbefeld {$a->no}';
$string['tilelinktargetsetting_desc'] = 'Hier können Sie das Linkziel für die Linktaste festlegen, wenn eine URL im Werbefeld {$a->no} angegeben ist.';
$string['tilelinktargetsetting_newtab'] = 'Neuer Tab';
$string['tilelinktargetsetting_samewindow'] = 'Gleiches Fenster';
$string['tilelinktitlefallback'] = 'Link';
$string['tilelinktitlesetting'] = 'Linktitel für Werbefeld {$a->no}';
$string['tilelinktitlesetting_desc'] = 'Hier können Sie einen Linktitel festlegen, der auf der Linktaste gezeigt wird, wenn eine URL im Werbefeld {$a->no} angegeben ist. Beachten Sie, dass die Linktaste mit dem Wort "Link" beschriftet wird, falls Sie eine URL und keinen Linktitel festlegen.';
$string['tileordersetting'] = 'Rangfolge für Werbefeld {$a->no}';
$string['tileordersetting_desc'] = 'Mit dieser Einstellung legen Sie die Rangfolge für das Werbefeld {$a->no} fest. Standardmäßig werden die Werbefelder von oben nach unten und von links nach rechts angeordnet, wie Sie dies auf dieser Einstellungsseite hier sehen. Sie können aber auch eine andere Rangfolge zuzuweisen. Wenn Sie zwei oder mehr Werbebereichen dieselbe Rangfolge zuweisen, werden diese gemäß der Rangfolge auf dieser Einstellungsseite abgeordnet.';
$string['tilesgeneralheading'] = 'Werbefelder allgemein';
$string['tilestab'] = 'Werbefelder';
$string['tiletitlesetting'] = 'Titel für Werbefeld {$a->no}';
$string['tiletitlesetting_desc'] = 'Hier geben Sie den Titel ein, der im Werbefeld {$a->no} angezeigt wird. Dies ist eine optionale Einstellung und der Werbebereich wird auch dann angezeigt, wenn Sie keinen Titel festlegen.';
$string['upgradenotice_2022080922'] = 'Ab dieser Version verwendet das Design "Boost Union" ein eigenes Logo und eigene Einstellungen für das kompakte Logo. Diese Dateien aus dem Moodle-Kern werden nicht mehr benutzt.';
$string['upgradenotice_2022080922_copied'] = 'Ein vorhandenes <strong>{$a}</strong> aus dem Moodle-Core wurde während des Upgrades in die Einstellung "{$a}" von Boost Union kopiert. Überprüfen Sie bitte das Ergebnis sorgfältig.';
$string['upgradenotice_2022080922_logo'] = 'Logo';
$string['upgradenotice_2022080922_logocompact'] = 'kompaktes Logo';
$string['upgradenotice_2022080922_notcopied'] = 'Die Einstellung <strong>{$a}</strong> in Boost Union ist jetzt leer. Wenn Sie von nun an ein {$a} innerhalb von Boost Union verwenden möchten, laden Sie es einfach später in die Einstellung {$a} von Boost Union hoch.';
