<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'id', version '4.0'.
 *
 * @package     lesson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Akses kontrol';
$string['actionaftercorrectanswer'] = 'Aksi setelah jawaban benar';
$string['actionaftercorrectanswer_help'] = 'Setelah menjawab pertanyaan dengan benar, ada 3 pilihan untuk halaman berikut: * Normal - Ikuti jalur pelajaran * Tampilkan halaman yang tidak terlihat - Halaman ditampilkan dalam urutan acak tanpa ada halaman yang ditampilkan dua kali * Tampilkan halaman yang belum dijawab - Halaman ditampilkan dalam urutan acak, dengan halaman yang berisi pertanyaan yang belum terjawab ditampilkan lagi';
$string['actions'] = 'Aksi';
$string['activitylink'] = 'Tautan ke aktivitas selanjutnya';
$string['activitylink_help'] = 'Untuk menyediakan tautan di akhir pelajaran ke aktivitas lain dalam pelajaran, pilih aktivitas dari menu tarik-turun.';
$string['activitylinkname'] = 'Menuju {$a}';
$string['activityoverview'] = 'Pelajaran Anda telah jatuh tempo';
$string['addabranchtable'] = 'Tambahkan halaman konten';
$string['addanendofbranch'] = 'Tambahkan akhir cabang';
$string['addanewpage'] = 'Tambahkan halaman';
$string['addaquestionpage'] = 'Tambahkan halaman soal';
$string['addaquestionpagehere'] = 'Tambahkan halaman soal';
$string['addbranchtable'] = 'Tambahkan halaman konten';
$string['addcluster'] = 'Tambahkan klaster';
$string['addedabranchtable'] = 'Tambahkan halaman konten';
$string['addedanendofbranch'] = 'Tambahkan akhir cabang';
$string['addedaquestionpage'] = 'Halaman soal ditambahkan';
$string['addedcluster'] = 'Klaster ditambahkan';
$string['addedendofcluster'] = 'Tambahkan akhir klaster';
$string['addendofbranch'] = 'Tambahkan akhir cabang';
$string['addendofcluster'] = 'Tambahkan akhir klaster';
$string['addessay'] = 'Buat halaman soal essay';
$string['addmatching'] = 'Buat halaman soal mencocokkan';
$string['addmultichoice'] = 'Buat halaman soal pilihan ganda';
$string['addnewgroupoverride'] = 'Tambahkan penyampingan grup';
$string['addnewuseroverride'] = 'Tambahkan penyampingan pengguna';
$string['addnumerical'] = 'Buat halaman soal numerik';
$string['addpage'] = 'Tambahkan halaman';
$string['addshortanswer'] = 'Buat halaman soal jawaban singkat';
$string['addtruefalse'] = 'Buat halaman soal benar/salah';
$string['allotheranswers'] = 'Semua jawaban lainnya';
$string['allotheranswersjump'] = 'Semua lompatan jawaban lainnya';
$string['allotheranswersscore'] = 'Semua skor jawaban lainnya';
$string['allowofflineattempts'] = 'Izinkan pelajaran untuk dikerjakan secara luring menggunakan aplikasi seluler';
$string['allowofflineattempts_help'] = 'Jika diaktifkan, pengguna aplikasi seluler dapat mengunduh pelajaran dan mengerjakannya secara luring.
Semua jawaban yang mungkin dan jawaban yang benar akan diunduh juga.
Catatan: Pelajaran tidak dapat dicoba secara luring jika memiliki batas waktu.';
$string['anchortitle'] = 'Awal konten utama';
$string['and'] = 'DAN';
$string['answer'] = 'Jawaban';
$string['answeredcorrectly'] = 'dijawab benar.';
$string['answersfornumerical'] = 'Jawaban untuk soal numerik harus cocok dengan pasangan nilai minimum dan maksimum';
$string['arrangebuttonshorizontally'] = 'Atur tombol konten secara horizontal?';
$string['attempt'] = 'Upaya ke: {$a}';
$string['attemptheader'] = 'Upaya';
$string['attemptinfonograde'] = '{$a->timestart} ({$a->duration})';
$string['attemptinfowithgrade'] = '{$a->grade}% {$a->timestart} ({$a->duration})';
$string['attempts'] = 'Upaya';
$string['attemptsdeleted'] = 'Upaya terhapus';
$string['attemptsremaining'] = 'Anda dapat mengerjakan {$a} kali lagi';
$string['available'] = 'Tersedia dari';
$string['averagescore'] = 'Skor rata-rata';
$string['averagetime'] = 'Waktu rata-rata';
$string['branch'] = 'Konten';
$string['branchtable'] = 'Konten';
$string['cachedef_overrides'] = 'Informasi penyampingan pengguna dan grup';
$string['cancel'] = 'Batal';
$string['cannotfindanswer'] = 'Galat: tidak dapat menemukan jawaban';
$string['cannotfindattempt'] = 'Galat: tidak dapat menemukan upaya';
$string['cannotfindessay'] = 'Galat: tidak dapat menemukan essay';
$string['cannotfindfirstgrade'] = 'Galat: tidak dapat menemukan nilai';
$string['cannotfindfirstpage'] = 'Tidak dapat menemukan halaman pertama';
$string['cannotfindgrade'] = 'Galat: Tidak dapat menemukan penilaian';
$string['cannotfindnewestgrade'] = 'Galat: tidak dapat menemukan nilai terbaru';
$string['cannotfindnextpage'] = 'Cadangan pelajaran: Halaman berikutnya tidak ditemukan!';
$string['cannotfindpagerecord'] = 'Tambahkan akhir cabang: rekaman halaman tidak ditemukan';
$string['cannotfindpages'] = 'Tidak dapat menemukan halaman pelajaran';
$string['cannotfindpagetitle'] = 'Konfirmasi penghapusan: judul halaman tidak ditemukan';
$string['cannotfindpreattempt'] = 'Tidak dapat menemukan rekaman !';
$string['cannotfindrecords'] = 'Galat: tidak dapat menemukan rekaman pelajaran';
$string['cannotfindtimer'] = 'Galat: tidak dapat menemukan catatan';
$string['cannotfinduser'] = 'Galat: tidak dapat menemukan pengguna';
$string['canretake'] = '{$a} dapat mengambil kembali';
$string['casesensitive'] = 'Gunakan ekspresi reguler';
$string['casesensitive_help'] = 'Centang kotak untuk menggunakan ekspresi reguler untuk menganalisis jawaban.';
$string['checkbranchtable'] = 'Cek halaman konten';
$string['checkedthisone'] = 'Telah diperiksa';
$string['checknavigation'] = 'Periksa navigasi';
$string['checkquestion'] = 'Periksa soal';
$string['classstats'] = 'Statistik kelas';
$string['clicktodownload'] = 'Klik tautan berikut untuk mengunduh berkas.';
$string['closebeforeopen'] = 'Tidak dapat memperbarui pelajaran. Anda telah menentukan tanggal tutup sebelum tanggal buka.';
$string['cluster'] = 'Klaster';
$string['clusterjump'] = 'Soal yang belum dilihat klaster';
$string['clustertitle'] = 'Klaster';
$string['collapsed'] = 'Diciutkan';
$string['comments'] = 'Komentar Anda';
$string['completed'] = 'Selesai';
$string['completederror'] = 'Selesaikan pelajaran';
$string['completethefollowingconditions'] = 'Anda harus berada dalam kondisi berikut dalam pelajaran <b>{$a}</b> sebelum Anda dapat lanjut.';
$string['completiondetail:reachend'] = 'Ikuti aktivitas sampai akhir';
$string['completiondetail:timespent'] = 'Gunakan setidaknya {$a} untuk aktivitas ini';
$string['completionendreached'] = 'Perlu akhir tercapai';
$string['completionendreached_desc'] = 'Siswa harus mencapai halaman akhir pelajaran untuk menyelesaikan aktivitas ini';
$string['completiontimespent'] = 'Siswa harus melakukan aktivitas ini setidaknya untuk';
$string['completiontimespentdesc'] = 'Siswa harus melakukan aktivitas ini setidaknya {$a}';
$string['completiontimespentgroup'] = 'Memerlukan waktu yang dihabiskan';
$string['conditionsfordependency'] = 'Kondisi untuk dependensi';
$string['configintro'] = 'Nilai yang ditetapkan di sini menentukan nilai bawaan yang digunakan dalam formulir setelan saat membuat aktivitas pelajaran baru. Setelan yang ditetapkan sebagai lanjutan hanya ditampilkan ketika tautan \'Tampilkan lebih banyak ...\' diklik.';
$string['configmaxanswers'] = 'Jumlah jawaban maksimum bawaan per halaman';
$string['configmediaclose'] = 'Menampilkan tombol tutup sebagai bagian dari sembulan yang dihasilkan untuk berkas media yang ditautkan';
$string['configmediaheight'] = 'Mengatur ketinggian sembulan yang ditampilkan untuk file media yang ditautkan';
$string['configmediawidth'] = 'Mengatur lebar sembulan yang ditampilkan untuk berkas media yang ditautkan';
$string['configpassword_desc'] = 'Apakah kata sandi diperlukan untuk mengakses pelajaran.';
$string['configslideshowbgcolor'] = 'Warna latar belakang untuk tayangan salindia jika diaktifkan';
$string['configslideshowheight'] = 'Setel ketinggian tayangan salindia jika diaktifkan';
$string['configslideshowwidth'] = 'Setel lebar tayangan salindia jika diaktifkan';
$string['configtimelimit_desc'] = 'Jika batas waktu ditetapkan, peringatan ditampilkan di awal pelajaran dan ada penghitung waktu mundur. Jika diatur ke nol, maka tidak ada batasan waktu.';
$string['confirmdelete'] = 'Hapus halaman';
$string['confirmdeletionofthispage'] = 'Konfirmasikan penghapusan dari halaman ini';
$string['congratulations'] = 'Selamat - Akhir dari pelajaran telah sampai';
$string['continue'] = 'Lanjutkan';
$string['continuetoanswer'] = 'Lanjutkan untuk mengubah jawaban.';
$string['continuetonextpage'] = 'Lanjutkan ke halaman berikutnya.';
$string['correctanswerjump'] = 'Selanjutnya jika benar';
$string['correctanswerscore'] = 'Nilai jawaban yang benar';
$string['correctresponse'] = 'Jawaban';
$string['createaquestionpage'] = 'Buat halaman pertanyaan';
$string['credit'] = 'Kredit';
$string['customscoring'] = 'Penilaian tersuai';
$string['customscoring_help'] = 'Jika diaktifkan, maka setiap jawaban dapat diberikan nilai poin numerik (positif atau negatif).';
$string['deadline'] = 'Batas Waktu';
$string['defaultessayresponse'] = 'Essai Anda akan dinilai oleh pengajar.';
$string['deleteallattempts'] = 'Hapus semua upaya pengerjaan pelajaran';
$string['deletedefaults'] = 'Hapus {$a} x kursus bawaan';
$string['deletedpage'] = 'Halaman yang terhapus';
$string['deletepagenamed'] = 'Hapus halaman: {$a}';
$string['deleting'] = 'Menghapus';
$string['deletingpage'] = 'Mengahpus halaman: {$a}';
$string['dependencyon'] = 'Bergantung pada';
$string['dependencyon_help'] = 'Setelan ini memungkinkan akses ke pelajaran ini bergantung pada kinerja siswa dalam pelajaran lain dalam pelajaran yang sama. Kombinasi waktu yang dihabiskan, diselesaikan atau "nilai lebih baik dari" dapat digunakan.';
$string['description'] = 'Deskripsi';
$string['deselectallattempts'] = 'Batalkan pilihan semua pengerjaan';
$string['detailedstats'] = 'Statistik terperinci';
$string['didnotanswerquestion'] = 'Tidak menjawab pertanyaan ini.';
$string['didnotreceivecredit'] = 'Tidak menerima kredit';
$string['disabled'] = 'Dinonaktifkan';
$string['displaydefaultfeedback'] = 'Gunakan umpan balik bawaan';
$string['displaydefaultfeedback_help'] = 'Jika diaktifkan, saat respons tidak ditemukan untuk soal tertentu, jawaban bawaan "Itu jawaban yang benar" atau "Itu jawaban yang salah" akan ditampilkan.';
$string['displayinleftmenu'] = 'Tampilkan di menu?';
$string['displayleftif'] = 'Nilai minimum untuk menampilkan menu';
$string['displayleftif_help'] = 'Setelan ini menentukan apakah seorang siswa harus memperoleh nilai tertentu sebelum melihat menu pelajaran. Ini memaksa siswa untuk mengikuti seluruh pelajaran pada upaya pertama mereka, kemudian setelah mendapatkan nilai yang diperlukan, mereka dapat menggunakan menu untuk diulas.';
$string['displayleftmenu'] = 'Tampilkan menu';
$string['displayleftmenu_help'] = 'Jika diaktifkan, menu yang memungkinkan pengguna untuk menavigasi daftar halaman akan ditampilkan.';
$string['displayofgrade'] = 'Tampilan peringkat (hanya untuk siswa)';
$string['displayreview'] = 'Berikan opsi untuk mencoba pertanyaan lagi';
$string['displayreview_help'] = 'Jika diaktifkan, ketika pertanyaan dijawab dengan salah, siswa diberikan pilihan untuk mencobanya lagi tanpa kredit poin, atau melanjutkan pelajaran. Jika siswa mengklik untuk melanjutkan ke pertanyaan lain maka jawaban yang dipilih (salah) akan diikuti. Secara bawaan, lompatan jawaban yang salah diatur ke "halaman ini" dan memiliki skor 0, jadi Anda disarankan untuk mengatur lompatan jawaban yang salah ke halaman yang berbeda untuk menghindari kebingungan dengan siswa Anda.';
$string['displayscorewithessays'] = '<p>Anda memperoleh {$a->score} dari {$a->tempmaxgrade} untuk pertanyaan yang dinilai secara otomatis.</p>
<p>Pertanyaan esai {$a->essayquestions} Anda akan dinilai dan ditambahkan ke skor akhir Anda di kemudian hari.</p>
<p>Nilai Anda saat ini tanpa pertanyaan esai adalah {$a->score} dari {$a->grade}.</p>';
$string['displayscorewithoutessays'] = 'Nilai Anda adalah {$a->score} (dari {$a->grade}).';
$string['duplicatepagenamed'] = 'Duplikat halaman: {$a}';
$string['edit'] = 'Edit';
$string['editbranchtable'] = 'Mengedit halaman konten';
$string['editcluster'] = 'Mengedit klaster';
$string['editendofbranch'] = 'Mengedit akhir halaman cabang';
$string['editendofcluster'] = 'Mengedit akhir halaman klaster';
$string['editessay'] = 'Mengedit halaman soal Esai';
$string['editinglesson'] = 'Mengedit pelajaran';
$string['editingquestionpage'] = 'Mengedit halaman pertanyaan {$a}';
$string['editlesson'] = 'Edit pelajaran';
$string['editlessonsettings'] = 'Edit setelan pelajaran';
$string['editmatching'] = 'Mengedit halaman soal mencocokkan';
$string['editmultichoice'] = 'Mengedit halaman soal pilihan ganda';
$string['editnumerical'] = 'Mengedit halaman soal numerik';
$string['editoverride'] = 'Edit penyampingan';
$string['editpage'] = 'Edit konten halaman';
$string['editpagecontent'] = 'Edit konten halaman';
$string['editquestion'] = 'Mengedit halaman soal';
$string['editshortanswer'] = 'Mengedit halaman soal jawaban singkat';
$string['edittruefalse'] = 'Mengedit halaman soal Benar/salah';
$string['email'] = 'Surel';
$string['emailallgradedessays'] = 'Kirim pemberitahuan penilaian esai';
$string['emailgradedessays'] = 'Kirim pemberitahuan penilaian esai';
$string['emailsuccess'] = 'Notifikasi berhasil dikirim';
$string['emptypassword'] = 'Kata sandi tidak boleh kosong';
$string['enabled'] = 'Diaktifkan';
$string['endofbranch'] = 'Akhir cabang';
$string['endofcluster'] = 'Akhir klaster';
$string['endofclustertitle'] = 'Akhir klaster';
$string['endoflesson'] = 'Akhir pelajaran';
$string['enteredthis'] = 'memasukkan ini.';
$string['enterpassword'] = 'Harap masukkan kata sandi:';
$string['eolstudentoutoftime'] = 'Perhatian: Waktu Anda untuk pelajaran ini telah habis. Jawaban Anda selanjutnya tidak akan dihitung.';
$string['eolstudentoutoftimenoanswers'] = 'Anda tidak menjawab soal apapun. Nilai Anda 0 untuk pelajaran ini.';
$string['essay'] = 'Essai';
$string['essayemailmessage2'] = '<p>Permintaan esai: {$a->question}</p><p>Tanggapan Anda: <em>{$a->response}</em></p><p>Komentar siswa: <em> {$a->comment}</em></p><p>Anda telah menerima {$a->earned} dari {$a->outof} untuk pertanyaan esai ini.</p><p>Anda nilai untuk pelajaran {$a->lesson} telah diubah menjadi {$a->newgrade}%.</p>';
$string['essayemailmessagesmall'] = '<p>Anda telah menerima {$a->earned} dari {$a->outof} untuk pertanyaan esai ini.</p><p>Nilai Anda untuk pelajaran {$a->lesson} telah diubah menjadi {$a->newgrade}%.</p>';
$string['essayemailsubject'] = 'Nilai tersedia untuk pertanyaan pelajaran';
$string['essaynotgradedyet'] = 'Essai belum dinilai';
$string['essayresponses'] = 'Tanggapan essay';
$string['essays'] = 'Essai';
$string['essayscore'] = 'Nilai essai';
$string['eventcontentpageviewed'] = 'Melihat konten halaman';
$string['eventessayassessed'] = 'Menilai Essay';
$string['eventessayattemptviewed'] = 'Melihat pengerjaan essay';
$string['eventhighscoreadded'] = 'Pelajaran skor tinggi ditambahkan';
$string['eventhighscoresviewed'] = 'Pelajaran skor tinggi dilihat';
$string['eventlessonended'] = 'Mengakhiri pelajaran';
$string['eventlessonrestarted'] = 'Memulai ulang pelajaran';
$string['eventlessonresumed'] = 'Melanjutkan pelajaran';
$string['eventlessonstarted'] = 'Mulai pelajaran';
$string['eventoverridecreated'] = 'Membuat penyampingan pelajaran';
$string['eventoverridedeleted'] = 'Menghapus penyampingan pelajaran';
$string['eventoverrideupdated'] = 'Memperbarui penyampingan pelajaran';
$string['eventpagecreated'] = 'Membuat halaman';
$string['eventpagedeleted'] = 'Menghapus halaman';
$string['eventpagemoved'] = 'Memindah halaman';
$string['eventpageupdated'] = 'Memperbarui halaman';
$string['eventquestionanswered'] = 'Menjawab pertanyaan';
$string['eventquestionviewed'] = 'Melihat pertanyaan';
$string['false'] = 'Salah';
$string['fileformat'] = 'Format berkas';
$string['finalwrong'] = 'Tidak terlalu.';
$string['finish'] = 'Selesai';
$string['firstanswershould'] = 'Jawaban pertama harus melompat ke halaman "Benar"';
$string['firstwrong'] = 'Anda telah menjawab salah. Apakah Anda ingin mengerjakan pertanyaan itu lagi? (Jika sekarang Anda menjawab pertanyaan dengan benar, itu tidak akan dihitung dalam skor akhir Anda.)';
$string['flowcontrol'] = 'Kontrol Aliran';
$string['fractionsaddwrong'] = 'Nilai positif yang Anda pilih tidak berjumlah 100%<br />Sebaliknya, nilainya berjumlah {$a}%<br />Apakah Anda ingin kembali dan memperbaiki pertanyaan ini?';
$string['fractionsnomax'] = 'Salah satu jawaban harus 100%, sehingga<br />mungkin mendapatkan nilai penuh untuk pertanyaan ini.<br />Apakah Anda ingin kembali dan memperbaiki pertanyaan ini?';
$string['full'] = 'Diperluas';
$string['general'] = 'Umum';
$string['gotoendoflesson'] = 'Menuju akhir pelajaran';
$string['grade'] = 'Nilai';
$string['gradebetterthan'] = 'Nilai yang lebih baik dari (&#37;)';
$string['gradebetterthanerror'] = 'Mendapatkan nilai yang lebih baik dari {$a} persen';
$string['graded'] = 'Telah dinilai';
$string['gradeessay'] = 'Pertanyaan essai yang dinilai({$a->notgradedcount} tidak dinilai dan {$a->notsentcount} tidak dikirim)';
$string['gradeis'] = 'Nilainya adalah {$a}';
$string['gradeoptions'] = 'Opsi nilai';
$string['groupoverrides'] = 'Penyampingan grup';
$string['groupoverridesdeleted'] = 'Penyampingan grup dihapus';
$string['groupsnone'] = 'Tidak ada grup dalam pelajaran ini';
$string['handlingofretakes'] = 'Penanganan pengambilan ulang';
$string['handlingofretakes_help'] = 'Jika pengerjaan ulang diizinkan, setelan ini menentukan apakah nilai pelajaran adalah rata-rata atau maksimum dari semua upaya.';
$string['havenotgradedyet'] = 'Belum dinilai.';
$string['here'] = 'di sini';
$string['highscore'] = 'Skor tertinggi';
$string['hightime'] = 'Waktu terlama';
$string['importcount'] = 'Mengimpor {$a} pertanyaan';
$string['importquestions'] = 'Impor Pertanyaan';
$string['importquestions_help'] = 'Fitur ini memungkinkan pertanyaan dalam berbagai format untuk diimpor melalui berkas teks.';
$string['inactiveoverridehelp'] = '* Penyampingan ini tidak aktif karena akses pengguna ke aktivitas dibatasi. Hal ini dapat terjadi karena penetapan grup atau peran, pembatasan akses lainnya, atau aktivitas disembunyikan.';
$string['indicator:cognitivedepth'] = 'Pelajaran kognitif';
$string['indicator:cognitivedepth_help'] = 'Indikator ini didasarkan pada kedalaman kognitif yang dicapai siswa dalam suatu aktivitas Pelajaran.';
$string['indicator:cognitivedepthdef'] = 'Pelajaran kognitif';
$string['indicator:cognitivedepthdef_help'] = 'Peserta telah mencapai persentase keterlibatan kognitif ini yang ditawarkan oleh aktivitas Pelajaran selama interval analisis ini (Tingkat = Tidak ada tampilan, Lihat, Ajukan, Lihat umpan balik, Komentari umpan balik, Ajukan ulang setelah melihat umpan balik)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Pelajaran sosial';
$string['indicator:socialbreadth_help'] = 'Indikator ini didasarkan pada keluasan sosial yang dicapai siswa dalam suatu aktivitas Pelajaran.';
$string['indicator:socialbreadthdef'] = 'Pelajaran sosial';
$string['indicator:socialbreadthdef_help'] = 'Peserta telah mencapai persentase keterlibatan sosial yang ditawarkan oleh aktivitas Pelajaran selama interval analisis ini (Tingkat = Tidak ada partisipasi, Peserta sendiri, Peserta dengan orang lain)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insertedpage'] = 'Sisipkan halaman';
$string['invalidfile'] = 'Berkas tidak valid';
$string['invalidid'] = 'Tidak ada ID modul pelajaran atau ID pelajaran yang dilewatkan';
$string['invalidlessonid'] = 'ID pelajaran salah';
$string['invalidoverrideid'] = 'ID penyampingan tidak valid';
$string['invalidpageid'] = 'ID halaman tidak valid';
$string['jump'] = 'Lompatan';
$string['jumps'] = 'Lompatan';
$string['jumps_help'] = 'Setiap jawaban (untuk pertanyaan) atau deskripsi (untuk halaman konten) memiliki lompatan yang sesuai. Lompatan dapat bersifat relatif, seperti halaman ini atau halaman berikutnya, atau absolut, yang menentukan salah satu halaman dalam pelajaran.';
$string['jumpsto'] = 'Lompat ke <em>{$a}</em>';
$string['leftduringtimed'] = 'Anda telah pergi sebelum waktu pelajaran usai.<br />Klik pada Melanjutkan untuk mengulangi pelajaran.';
$string['leftduringtimednoretake'] = 'Anda telah pergi sebelum waktu pelajaran usai dan Anda<br />tidak dibolehkan untuk lanjut atau mengambil ulang pelajaran.';
$string['leftduringtimedsession'] = 'Anda telah pergi selama pelajaran waktunya.';
$string['lesson:addinstance'] = 'Tambahkan pelajaran baru';
$string['lesson:edit'] = 'Edit aktivitas pelajaran';
$string['lesson:grade'] = 'Soal esai pelajaran kelas';
$string['lesson:manage'] = 'Atur aktivitas pelajaran';
$string['lesson:manageoverrides'] = 'Kelola penggantian pelajaran';
$string['lesson:view'] = 'Lihat aktivitas pelajaran';
$string['lesson:viewreports'] = 'Lihat laporan pelajaran';
$string['lessonbeingpreviewed'] = 'Pelajaran saat ini sedang dipratinjau.';
$string['lessonclosed'] = 'Pelajaran ini telah ditutup pada {$a}.';
$string['lessoncloses'] = 'Pelajaran ditutup';
$string['lessoneventcloses'] = '{$a} berakhir';
$string['lessoneventopens'] = '{$a} buka';
$string['lessonformating'] = 'Memformat pelajaran';
$string['lessonmenu'] = 'Menu pelajaran';
$string['lessonnotready'] = 'Pelajaran ini belum siap. Hubungi {$a} Anda.';
$string['lessonnotready2'] = 'Pelajaran ini belum siap untuk diambil.';
$string['lessonopen'] = 'Pelajaran ini akan dibuka pada {$a}.';
$string['lessonopens'] = 'Pelajaran dibuka';
$string['lessonpagelinkingbroken'] = 'Halaman pertama tidak ditemukan. Penautan halaman pelajaran pasti rusak. Silakan hubungi admin.';
$string['lessonstats'] = 'Statistik pelajaran';
$string['linkedmedia'] = 'Media yang terhubung';
$string['loginfail'] = 'Login gagal, coba lagi...';
$string['lowscore'] = 'Skor terendah';
$string['lowtime'] = 'Daftar waktu terendah';
$string['manualgrading'] = 'Nilai esai';
$string['matchesanswer'] = 'Cocokkan dengan jawaban';
$string['matching'] = 'Mencocokkan';
$string['matchingpair'] = 'Memasangkan {$a}';
$string['maxgrade'] = 'Nilai maksimum';
$string['maxgrade_help'] = 'Setelan ini menentukan nilai maksimum untuk pelajaran. Jika diatur ke 0, pelajaran tidak muncul di halaman nilai.';
$string['maximumnumberofanswersbranches'] = 'Jumlah jawaban maksimum';
$string['maximumnumberofanswersbranches_help'] = 'Setelan ini menentukan jumlah maksimum jawaban yang dapat digunakan dalam pelajaran. Jika hanya pertanyaan benar/salah yang digunakan, dapat diatur ke 2. Setelan dapat diubah kapan saja, karena hanya memengaruhi apa yang dilihat pengajar, bukan data.';
$string['maximumnumberofattempts'] = 'Jumlah maksimum upaya per pertanyaan';
$string['maximumnumberofattempts_help'] = 'Setelan ini menentukan jumlah maksimum upaya yang diizinkan untuk setiap pertanyaan. Jika dijawab salah berulang kali, ketika maksimum tercapai, halaman pelajaran berikutnya ditampilkan.';
$string['maximumnumberofattemptsreached'] = 'Upaya pengerjaaan telah maksimum  - Lanjutkan ke halaman berikutnya';
$string['mediaclose'] = 'Tampilkan tombol tutup';
$string['mediafile'] = 'Media terkait';
$string['mediafile_help'] = 'Berkas media dapat diunggah untuk digunakan dalam pelajaran. Tautan \'Klik di sini untuk melihat\' kemudian akan ditampilkan dalam blok yang disebut \'Media yang ditautkan\' di setiap halaman pelajaran.';
$string['mediafilepopup'] = 'Klik di sini untuk melihat';
$string['mediaheight'] = 'Tinggi jendela sembulan';
$string['mediawidth'] = 'Lebar jendela sembulan';
$string['messageprovider:graded_essay'] = 'Pemberitahuan penilaian esai pelajaran';
$string['minimumnumberofquestions'] = 'Jumllah minimum soal';
$string['minimumnumberofquestions_help'] = 'Setelan ini menentukan jumlah soal minimum yang akan digunakan untuk menghitung nilai aktivitas.';
$string['missingname'] = 'Masukkan nama panggilan';
$string['modattempts'] = 'Izinkan siswa untuk mengulas';
$string['modattempts_help'] = 'Jika diaktifkan, siswa dapat menavigasi pelajaran lagi dari awal.';
$string['modattemptsnoteacher'] = 'Siswa hanya boleh meninjau pekerjaan siswa.';
$string['modulename'] = 'Pelajaran';
$string['modulename_help'] = 'Modul aktivitas pelajaran memungkinkan seorang pengajar untuk menyampaikan konten dan / atau kegiatan praktik dengan cara yang menarik dan fleksibel. Seorang pengajar dapat menggunakan pelajaran tersebut untuk membuat serangkaian halaman konten atau kegiatan instruksional yang menawarkan berbagai jalur atau pilihan bagi siswa. Dalam kedua kasus tersebut, pengajar dapat memilih untuk meningkatkan keterlibatan dan memastikan pemahaman dengan memasukkan berbagai pertanyaan, seperti pilihan ganda, pencocokan dan jawaban singkat. Bergantung pada pilihan jawaban siswa dan bagaimana pengajar mengembangkan pelajaran, siswa dapat maju ke halaman berikutnya, dibawa kembali ke halaman sebelumnya atau diarahkan ke jalur yang berbeda sama sekali.

Sebuah pelajaran dapat dinilai, dengan nilai yang tercatat dalam buku nilai.

Pelajaran yang dapat digunakan

* Untuk belajar mandiri dari topik baru
* Untuk skenario atau simulasi / latihan pengambilan keputusan
* Untuk revisi yang berbeda, dengan serangkaian pertanyaan revisi yang berbeda tergantung jawaban yang diberikan pada pertanyaan awal.';
$string['modulename_link'] = 'mod/lesson/view';
$string['modulenameplural'] = 'Pelajaran';
$string['move'] = 'Pindah halaman';
$string['movedpage'] = 'Halaman yang dipindahkan';
$string['movepagehere'] = 'Pindahkan halaman ke sini';
$string['movepagenamed'] = 'Pindah halaman: {$a}';
$string['moving'] = 'Memindahkan halaman: {$a}';
$string['multianswer'] = 'Multi Jawaban';
$string['multianswer_help'] = 'Centang kotak jika lebih dari satu jawaban yang benar.';
$string['multichoice'] = 'Banyak pilihan';
$string['multipleanswer'] = 'Jawaban ganda';
$string['nameapproved'] = 'Nama disetujui';
$string['namereject'] = 'Maaf, nama Anda telah ditolak oleh filter. <br /> Silakan coba nama lain.';
$string['new'] = 'baru';
$string['nextpage'] = 'Halaman selanjutnya';
$string['noanswer'] = 'Satu atau lebih pertanyaan tidak memiliki jawaban yang diberikan. Silakan kembali dan kirimkan jawaban.';
$string['noattemptrecordsfound'] = 'Tidak menemukan rekaman pengerjaan : Tidak ada nilai diberikan';
$string['nobranchtablefound'] = 'Tidak ditemukan halaman konten';
$string['noclose'] = 'Tidak ada tanggal tutup';
$string['nocommentyet'] = 'Belum ada komentar.';
$string['nocoursemods'] = 'Tidak ada aktivitas yang ditemukan';
$string['nocredit'] = 'Tidak ada kredit';
$string['nodeadline'] = 'Tidak ada tenggat waktu';
$string['noessayquestionsfound'] = 'Tidak ada soal essai yang ditemukan di pelajaran ini';
$string['nohighscores'] = 'Tidak ada daftar nilai tertinggi';
$string['nolessonattempts'] = 'Belum ada upaya yang dilakukan pada pelajaran kali ini.';
$string['nolessonattemptsgroup'] = 'Tidak ada upaya yang dilakukan oleh {$a} anggota grup pada pelajaran ini.';
$string['none'] = 'Tidak ada';
$string['nooneansweredcorrectly'] = 'Belum ada yang menjawab dengan benar';
$string['nooneansweredthisquestion'] = 'Belum ada yang menjawab soal ini.';
$string['noonecheckedthis'] = 'Belum ada yang memeriksa ini.';
$string['nooneenteredthis'] = 'Belum ada yang memasuki ini.';
$string['noonehasanswered'] = 'Belum ada yang menjawab essai sampai sekarang';
$string['noonehasansweredgroup'] = 'Belum ada seorang pun di {$a} yang menjawab pertanyaan esai.';
$string['noopen'] = 'Tidak ada tanggal buka';
$string['nooverridecreated'] = 'Tidak ada penyampingan yang dibuat.';
$string['nooverridedata'] = 'Anda harus mengganti setidaknya salah satu setelan pelajaran.';
$string['noretake'] = 'Anda tidak diperbolehkan untuk mengambila lagi pelajaran ini.';
$string['normal'] = 'Normal - Ikuti Jalur Pelajaran';
$string['notcompleted'] = 'Tidak selesai';
$string['notcompletedwithdate'] = 'Tidak selesai ({$a})';
$string['notdefined'] = 'Tidak terdefinisi';
$string['notenoughsubquestions'] = 'Tidak cukup sub-pertanyaan yang telah ditentukan!';
$string['notenoughtimespent'] = 'Anda menyelesaikan pelajaran ini dalam {$a->timespent}, yang kurang dari waktu yang dibutuhkan {$a->timerequired}. Anda mungkin perlu mengerjakan pelajaran lagi.';
$string['notgraded'] = 'Tidak dinilai';
$string['notitle'] = 'Tidak ada judul';
$string['notyetcompleted'] = 'Pelajaran sudah dimulai, tapi belum selesai';
$string['numberofcorrectanswers'] = 'Jumlah jawaban yang benar: {$a}';
$string['numberofcorrectanswersheader'] = 'Jumlah jawaban yang benar';
$string['numberofcorrectmatches'] = 'Jumlah jawaban yang cocok: {$a}';
$string['numberofpagestoshow'] = 'Jumlah halaman untuk ditampilkan';
$string['numberofpagestoshow_help'] = 'Setelan ini menentukan jumlah halaman yang ditampilkan dalam pelajaran. Ini hanya berlaku untuk pelajaran dengan halaman yang ditampilkan dalam urutan acak (ketika "Tindakan setelah jawaban yang benar" diatur ke "Tampilkan halaman yang tidak terlihat" atau "Tampilkan halaman yang belum dijawab"). Jika disetel ke nol, maka semua halaman akan ditampilkan.';
$string['numberofpagesviewed'] = 'Jumlah soal yang dijawab: {$a}';
$string['numberofpagesviewedheader'] = 'Jumlah pertanyaan yang dijawab';
$string['numberofpagesviewednotice'] = 'Jumlah pertanyaan yang telah dijawab: {$a->nquestions}; (Anda seharusnya menjawab paling tidak: {$a->minquestions})';
$string['numerical'] = 'Numerik';
$string['numericanswer'] = 'Jawaban numerik';
$string['numericanswer_help'] = 'Anda dapat menentukan satu angka, atau rentang angka dengan menggunakan titik dua. Misalnya 2:5 berarti setiap jawaban antara 2 dan 5 dan termasuk 2 dan 5 adalah benar.';
$string['offlinedatamessage'] = 'Anda telah mengerjakan upaya ini menggunakan perangkat seluler. Data terakhir disimpan ke situs ini {$a} yang lalu. Harap periksa bahwa Anda tidak memiliki pekerjaan yang belum disimpan.';
$string['ongoing'] = 'Tampilkan skor yang akan datang';
$string['ongoing_help'] = 'Jika diaktifkan, setiap halaman akan menampilkan poin siswa saat ini yang diperoleh dari total yang mungkin sejauh ini.';
$string['ongoingcustom'] = 'Anda telah mendapat {$a->score} poin dari {$a->currenthigh} poin sejauh ini.';
$string['ongoingnormal'] = 'Anda telah menjawab {$a->correct} soal benar dari {$a->viewed} kali percobaan.';
$string['onpostperpage'] = 'Hanya satu kiriman per kelas';
$string['openafterclose'] = 'Anda telah menentukan tanggal buka setelah tanggal tutup';
$string['options'] = 'Opsi';
$string['or'] = 'ATAU';
$string['ordered'] = 'Urutan';
$string['other'] = 'Lainnya';
$string['outof'] = 'Keluar dari {$a}';
$string['override'] = 'Penyampingan';
$string['overridedeletegroupsure'] = 'Anda yakin ingin menghapus penyampingan untuk grup {$a}?';
$string['overridedeleteusersure'] = 'Apakah Anda yakin ingin menghapus penyampingan untuk pengguna {$a}?';
$string['overridegroup'] = 'Penyampingan grup';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'Penyampingan';
$string['overrideuser'] = 'Penyampingan pengguna';
$string['overrideusereventname'] = '{$a->lesson} - Penyampingan';
$string['overview'] = 'Ikhtisar';
$string['overview_help'] = 'Pelajaran terdiri dari sejumlah halaman dan opsional halaman konten. Sebuah halaman berisi beberapa konten dan biasanya diakhiri dengan sebuah pertanyaan. Terkait dengan setiap jawaban atas pertanyaan adalah melompat. Lompatan dapat bersifat relatif, seperti halaman ini atau halaman berikutnya, atau absolut, yang menentukan salah satu halaman dalam pelajaran. Halaman konten adalah halaman yang berisi sekumpulan tautan ke halaman lain dalam pelajaran, misalnya Daftar Isi.';
$string['page'] = 'Halaman: {$a}';
$string['page-mod-lesson-edit'] = 'Edit halaman pelajaran';
$string['page-mod-lesson-view'] = 'Lihat atau pratinjau halaman pelajaran';
$string['page-mod-lesson-x'] = 'Setiap halaman pelajaran';
$string['pageanswers'] = 'Halaman jawaban';
$string['pagecontents'] = 'Isi Halaman';
$string['pageresponses'] = 'Tanggapan halaman';
$string['pages'] = 'Halaman';
$string['pagetitle'] = 'Judul halaman';
$string['password'] = 'Kata sandi';
$string['passwordprotectedlesson'] = '{$a} adalah pelajaran yang membutuhkan kata sandi.';
$string['pleasecheckoneanswer'] = 'Harap memberi tanda pada satu jawaban';
$string['pleasecheckoneormoreanswers'] = 'Harap memberi tanda pada satu atau lebih jawaban';
$string['pleaseenteryouranswerinthebox'] = 'Harap ketikkan jawaban Anda di dalam kotak';
$string['pleasematchtheabovepairs'] = 'Harap pasangkan dengan yang di atas';
$string['pluginadministration'] = 'Administrasi pelajaran';
$string['pluginname'] = 'Pelajaran';
$string['pointsearned'] = 'Poin yang diperoleh';
$string['postprocesserror'] = 'Galat selama pasca-pemrosesan!';
$string['postsuccess'] = 'Berhasil dikirim';
$string['practice'] = 'Latihan';
$string['practice_help'] = 'Pelajaran praktik tidak terlihat pada buku nilai.';
$string['preprocesserror'] = 'Galat selama pra-pemrosesan!';
$string['prerequisiteisobsolete'] = 'Pilihan prasyarat pelajaran harus dihapus karena karena kedaluwarsa. Harap gunakan batasan akses.';
$string['prerequisitelesson'] = 'Prasyarat pelajaran';
$string['preview'] = 'Pratinjau';
$string['previewlesson'] = 'Pratayang {$a}';
$string['previewpagenamed'] = 'Pratinjau halaman: {$a}';
$string['previouspage'] = 'Halaman sebelumnya';
$string['privacy:metadata:attempts'] = 'Rekaman halaman pengerjaan';
$string['privacy:metadata:attempts:answerid'] = 'ID jawaban';
$string['privacy:metadata:attempts:correct'] = 'Apakah upaya itu benar';
$string['privacy:metadata:attempts:pageid'] = 'ID halaman';
$string['privacy:metadata:attempts:retry'] = 'Jumlah upaya';
$string['privacy:metadata:attempts:timeseen'] = 'Waktu ketika upaya itu dilakukan';
$string['privacy:metadata:attempts:useranswer'] = 'Detail mengenai jawaban pengguna';
$string['privacy:metadata:attempts:userid'] = 'ID pengguna';
$string['privacy:metadata:branch'] = 'Rekaman halaman yang dilihat';
$string['privacy:metadata:branch:flag'] = 'Apakah halaman berikutnya dihitung secara acak';
$string['privacy:metadata:branch:nextpageid'] = 'ID halaman berikutnya';
$string['privacy:metadata:branch:pageid'] = 'ID halaman';
$string['privacy:metadata:branch:retry'] = 'Jumlah upaya';
$string['privacy:metadata:branch:timeseen'] = 'Waktu ketika halaman dilihat';
$string['privacy:metadata:branch:userid'] = 'ID pengguna';
$string['privacy:metadata:grades'] = 'Catatan nilai untuk tiap pelajaran';
$string['privacy:metadata:grades:completed'] = 'Tanggal nilai diberikan';
$string['privacy:metadata:grades:grade'] = 'Nilai yang diberikan';
$string['privacy:metadata:grades:userid'] = 'ID pengguna';
$string['privacy:metadata:overrides'] = 'Rekaman penyampingan per pelajaran';
$string['privacy:metadata:overrides:available'] = 'Waktu ketika pelajaran dikerjakan';
$string['privacy:metadata:overrides:deadline'] = 'Batas waktu untuk menyelesaikan pelajaran.';
$string['privacy:metadata:overrides:maxattempts'] = 'Jumlah maksimum mengerjakan';
$string['privacy:metadata:overrides:password'] = 'Kata sandi untuk mengakses pelajaran';
$string['privacy:metadata:overrides:retake'] = 'Apakah diizinkan mengerjakan kembali';
$string['privacy:metadata:overrides:review'] = 'Apakah mencoba pertanyaan lagi diperbolehkan
';
$string['privacy:metadata:overrides:timelimit'] = 'Batas waktu untuk menyelesaikan pelajaran, dalam hitungan detik.';
$string['privacy:metadata:overrides:userid'] = 'ID pengguna';
$string['privacy:metadata:timer'] = 'Rekaman upaya pengerjaan pelajaran';
$string['privacy:metadata:timer:completed'] = 'Apakah upaya pengerjaan selesai?';
$string['privacy:metadata:timer:lessontime'] = 'Momen terakhir saat kami merekam aktivitas';
$string['privacy:metadata:timer:starttime'] = 'Tanggal mulai mengerjakan';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'Momen terakhir saat kami merekam aktivitas dari aplikasi seluler';
$string['privacy:metadata:timer:userid'] = 'ID pengguna';
$string['privacy:metadata:userpref:lessonview'] = 'Mode tampilan yang disukai saat mengedit pelajaran';
$string['privacy:path:essayanswers'] = 'Jawaban esai';
$string['privacy:path:essayresponses'] = 'Tanggapan esai';
$string['privacy:path:pages'] = 'Halaman';
$string['processerror'] = 'Galat selama pemrosesan!';
$string['progressbar'] = 'Bilah kemajuan';
$string['progressbar_help'] = 'Jika diaktifkan, bilah ditampilkan di bagian bawah halaman pelajaran yang menunjukkan perkiraan persentase penyelesaian.';
$string['progressbarteacherwarning'] = 'Bilah kemajuan tidak diperlihatkan untuk {$a}';
$string['progressbarteacherwarning2'] = 'Anda tidak akan melihat bilah kemajuan karena Anda dapat mengedit pelajaran ini';
$string['progresscompleted'] = 'Anda telah menyelesaikan {$a}% dari pelajaran';
$string['qtype'] = 'Tipe Halaman';
$string['question'] = 'Soal';
$string['questionoption'] = 'Pilih soal';
$string['questiontype'] = 'Jenis soal';
$string['randombranch'] = 'Halaman konten acak';
$string['randompageinbranch'] = 'Soal acak dalam percabangan';
$string['rank'] = 'Peringkat';
$string['rawgrade'] = 'Nilai buruk';
$string['receivedcredit'] = 'Kredit yang diterima';
$string['redisplaypage'] = 'Tampil ulang halaman';
$string['removeallgroupoverrides'] = 'Hapus semua penyampingan grup';
$string['removealluseroverrides'] = 'Hapus semua penyampingan pengguna';
$string['report'] = 'Laporan';
$string['reports'] = 'Laporan';
$string['response'] = 'Tanggapan';
$string['retakesallowed'] = 'Pengambilan ulang diperbolehkan';
$string['retakesallowed_help'] = 'Jika diaktifkan, siswa dapat mengerjakan pelajaran lebih dari sekali.';
$string['returnto'] = 'Kembali ke {$a}';
$string['returntocourse'] = 'Kembali ke pelajaran';
$string['reverttodefaults'] = 'Kembali ke pelajaran bawaan';
$string['review'] = 'Ulasan';
$string['reviewlesson'] = 'Ulas pelajaran';
$string['reviewquestionback'] = 'Ya, saya ingin mencoba lagi';
$string['reviewquestioncontinue'] = 'Tidak, saya hanya ingin lanjut ke soal berikutnya';
$string['sanitycheckfailed'] = 'Pemeriksaan kesehatan gugur: Upaya ini telah dihapus';
$string['save'] = 'Simpan';
$string['savechanges'] = 'Simpan perubahan';
$string['savechangesandeol'] = 'Simpan semua perubahan dan akhiri pelajaran.';
$string['saveoverrideandstay'] = 'Simpan dan masukkan penyampingan lain
';
$string['savepage'] = 'Simpan halaman';
$string['score'] = 'Skor';
$string['score_help'] = 'Skor hanya digunakan ketika penilaian kustom diaktifkan. Setiap jawaban kemudian dapat diberikan nilai poin numerik (positif atau negatif).';
$string['scores'] = 'Skor';
$string['search:activity'] = 'Pelajaran - informasi aktivitas';
$string['secondpluswrong'] = 'Belum tepat. Mau coba lagi?';
$string['selectallattempts'] = 'Pilih semua upaya';
$string['selectaqtype'] = 'Pilih jenis soal';
$string['sent'] = 'Terkirim';
$string['shortanswer'] = 'Jawaban pendek';
$string['showanunansweredpage'] = 'Tampilkan halaman yang tidak terjawab';
$string['showanunseenpage'] = 'Tampilkan halaman yang tidak terlihat';
$string['singleanswer'] = 'Jawaban Tunggal';
$string['skip'] = 'Lewati navigasi';
$string['slideshow'] = 'Salindia';
$string['slideshow_help'] = 'Jika diaktifkan, pelajaran ditampilkan sebagai tayangan salindia, dengan lebar dan tinggi tetap.';
$string['slideshowbgcolor'] = 'Warna latar belakang salindia';
$string['slideshowheight'] = 'Tinggi salindia';
$string['slideshowwidth'] = 'Lebar salindia';
$string['startlesson'] = 'Mulai pelajaran';
$string['studentattemptlesson'] = 'Percobaan {$a->firstname} {$a->lastname} nomor {$a->attempt}';
$string['studentname'] = 'Nama {$a}';
$string['studentoneminwarning'] = 'Peringatan: Anda memiliki 1 menit atau kurang untuk menyelesaikan pelajaran ini.';
$string['studentoutoftimeforreview'] = 'Perhatian: Anda kehabisan waktu untuk mengulas pelajaran ini';
$string['studentresponse'] = 'Tanggapan dari {$a}';
$string['submit'] = 'Serahkan';
$string['submitname'] = 'Masukkan nama';
$string['teacherjumpwarning'] = 'Lompatan {$a->cluster} atau lompatan {$a->unseen} sedang dipakai dalam pelajaran ini. Lompatan Halaman Selanjutnya akan digunakan otomatis. Masuk sebagai siswa untuk mengetesnya';
$string['teacherongoingwarning'] = 'Skor yang sedang berlangsung hanya ditampilkan untuk siswa. Masuk sebagai siswa untuk menguji skor yang sedang berlangsung.';
$string['teachertimerwarning'] = 'Timer hanya bekerja untuk siswa. Tes timer dengan log in sebagai siswa.';
$string['thatsthecorrectanswer'] = 'Itu adalah jawaban yang benar';
$string['thatsthewronganswer'] = 'Itu adalah jawaban yang salah';
$string['thefollowingpagesjumptothispage'] = 'Halaman berikut akan menuju ke halaman ini';
$string['thispage'] = 'Halaman ini';
$string['timeisup'] = 'Waktu berakhir';
$string['timelimit'] = 'Waktu pengerjaan';
$string['timelimit_help'] = 'Jika diaktifkan, peringatan tentang batas waktu ditampilkan di awal pelajaran dan penghitung waktu mundur ditampilkan. Setiap jawaban yang diberikan setelah waktu berlalu tidak dinilai.';
$string['timelimitwarning'] = 'Anda memiliki {$a} untuk menyelesaikan pelajaran.';
$string['timeremaining'] = 'Waktu tersisa';
$string['timespenterror'] = 'Ikuti pelajaran ini sekurangnya {$a} menit';
$string['timespentminutes'] = 'Waktu yang digunakan (menit)';
$string['timetaken'] = 'Waktu yang dibutuhkan';
$string['totalpagesviewedheader'] = 'Jumlah halaman yang dilihat';
$string['true'] = 'Benar';
$string['truefalse'] = 'Benar/Salah';
$string['unabledtosavefile'] = 'Berkas yang Anda unggah tidak dapat disimpan';
$string['unknownqtypesnotimported'] = '{$a} pertanyaan dengan jenis pertanyaan yang tidak didukung tidak diimpor';
$string['unseenpageinbranch'] = 'Soal tak terlihat dalam halaman konten';
$string['unsupportedqtype'] = 'Tipe pertanyaan yang tidak terdukung ({$a})!';
$string['updatedpage'] = 'Halaman yang diperbaharui';
$string['updatefailed'] = 'Gagal dalam memerbaharui';
$string['updatepagenamed'] = 'Perbarui laman: {$a}';
$string['usemaximum'] = 'Gunakan nilai maksimum';
$string['usemean'] = 'Gunakan nilai rata-rata';
$string['usepassword'] = 'Pelajaran yang membutuhkan kata sandi';
$string['usepassword_help'] = 'Jika diaktifkan, kata sandi diperlukan untuk mengakses pelajaran.';
$string['useroverrides'] = 'Penyampingan pengguna';
$string['useroverridesdeleted'] = 'Penyampingan pengguna dihapus';
$string['usersnone'] = 'Tidak ada siswa yang memiliki akses ke pelajaran ini';
$string['viewessayanswers'] = 'Lihat jawaban esai';
$string['viewgrades'] = 'Lihat nilai';
$string['viewreports'] = 'Lihat {$a->attempts} upaya {$a->student} yang selesai';
$string['viewreports2'] = 'Lihat {$a} upaya yang diselesaikan';
$string['warning'] = 'Peringatan';
$string['welldone'] = 'Bagus!';
$string['whatdofirst'] = 'Apa yang ingin Anda lakukan untuk pertama kali?';
$string['withselectedattempts'] = 'Dengan upaya terpilih...';
$string['wronganswerjump'] = 'Selanjutnya jika salah';
$string['wronganswerscore'] = 'Nilai jawaban yang salah';
$string['wrongresponse'] = 'Tanggapan salah';
$string['youhaveseen'] = 'Anda telah melihat lebih dari satu halaman dari pelajaran ini.<br />Anda ingin mulai dari halaman terakhir yang Anda lihat?';
$string['youranswer'] = 'Jawaban Anda';
$string['yourcurrentgradeis'] = 'Nilai Anda saat ini adalah {$a}';
$string['yourcurrentgradeisoutof'] = 'Nilai Anda adalah {$a->grade} dari total {$a->total}';
$string['youshouldview'] = 'Anda seharusnya menjawab setidaknya: {$a}';
