<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'studentquiz', language 'sr_cr', version '4.0'.
 *
 * @package     studentquiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abort_button'] = 'Обустави';
$string['add_comment'] = 'Додајте коментар';
$string['add_reply'] = 'Додајте одговор';
$string['addprivatecomment'] = 'Додајте приватни коментар (ови коментари су само између полазника и предавача)';
$string['addprivatecomment_help'] = 'Ови коментари су стриктно између аутора питања и особе која администрира активност. Овај низ порука је више за администратора активности како би он могао да да повратне информације ако и када се промени статус питања.';
$string['addpubliccomment'] = 'Додајте јавни коментар';
$string['after_answering_end_date'] = 'Овај СтуденТест је затворен за давање одговара {$a}.';
$string['after_submission_end_date'] = 'Овај СтуденТест је затворен за слање питања {$a}.';
$string['anonymous_user_name'] = 'Анонимни Корисник #{$a}';
$string['answeringndbeforestart'] = 'Рок за давање одговора се не може поставити тако да буде пре датума од ког је могуће давање одговора';
$string['api_state_change_error_content'] = 'Ово питање се не може обрисати јер је одобрено.';
$string['api_state_change_error_title'] = 'Грешка приликом брисања питања';
$string['api_state_change_success_content'] = 'Статус/видљивост питања је успешно промењена';
$string['api_state_change_success_title'] = 'Успешно';
$string['approve'] = 'Одобри';
$string['approve_toggle'] = 'Не/Одобри';
$string['approved'] = '✓';
$string['approved_column_name'] = 'Одобрено';
$string['approved_veryshort'] = 'A';
$string['approveselectedscheck'] = 'Да ли сте сигурни да желите да не/одобрите следећа питања?<br /><br />{$a}';
$string['average_column_name'] = 'Просек';
$string['back_to_course_button'] = 'Врати се на курс';
$string['before_answering_end_date'] = 'Овај СтуденТест се затвара за давање одговара дана {$a}.';
$string['before_answering_start_date'] = 'Отворено за давање одговора од {$a}.';
$string['before_submission_end_date'] = 'Овај СтуденТест се затвара за слање питања дана {$a}.';
$string['before_submission_start_date'] = 'Отворено за слање питања од {$a}.';
$string['cachedef_permissionssync'] = 'Праћење синхронизације овлашћења за СтуденТест';
$string['cannotcapturecommenthistory'] = 'Није могуће снимити запис историје коментара';
$string['changecurrentstate'] = 'Промени статус из <b>{$a}</b> у:';
$string['changestateto'] = 'Промените статус(е) у:';
$string['collapseall'] = 'Скупи све коментаре';
$string['collapsecomment'] = 'Скупи коментар';
$string['comment'] = 'Коментар';
$string['comment_author'] = 'Аутор';
$string['comment_cannot_update'] = 'Није могуће ажурирати коментар';
$string['comment_column_name'] = 'Коментари';
$string['comment_error'] = 'Напишите коментар';
$string['comment_error_unsaved'] = 'Желите ли прво да сачувате овај коментар?';
$string['comment_help'] = 'Напишите коментар';
$string['comment_help_help'] = 'Напишите коментар на питање.';
$string['comment_veryshort'] = 'C';
$string['commentcolumnexplainprivate'] = 'Број приватних коментара. Плава позадина значи да имате најмање један непрочитани коментар.';
$string['commentcolumnexplainpublic'] = 'Број јавних коментара. Плава позадина значи да имате најмање један непрочитани коментар.';
$string['commenthistory'] = 'Историја коментара';
$string['commentplural'] = 'Коментари';
$string['confirmdeletecomment'] = 'Да ли сте сигурни да желите да oбришете овај коментар?';
$string['createnewquestion'] = 'Креирај ново питање';
$string['createnewquestionfirst'] = 'Креирај прво питање';
$string['creator_anonym_fullname'] = 'Анонимни Полазник';
$string['current_of_total'] = '{$a->current} од {$a->total}';
$string['current_state'] = 'Тренутни статус';
$string['daily'] = 'дневно';
$string['delete'] = 'Обриши';
$string['deletecomment'] = 'Обриши коментар';
$string['deleted'] = 'Обрисано';
$string['deletedbyauthor'] = 'Овај пост је обрисан дана {$a}.';
$string['deletedbyuser'] = 'Овај пост је обрисао/ла <a href="{$a->profileurl}" >{$a->fullname}</a> дана {$a->date}.';
$string['deletedcomment'] = 'Обрисани пост.';
$string['deleteorphanedquestions'] = 'Брисање напуштених питања';
$string['deleteorphanedquestionserrormdlquestion'] = '<font color="red">грешка</font>: није могуће обрисати из табеле mdl_question. Питање се вероватно негде друго користи.
<br><font color="red">грешка</font>: брисање из mdl_studentquiz* табела је прескочено.<br>';
$string['deleteorphanedquestionserrorstudentquiz'] = '<font color="red">грешка</font>: није могуће обрисати из mdl_studentquiz* табела.<br>';
$string['deleteorphanedquestionsfullmessage'] = 'Питања која су неодобрена/означена за брисање:
<ul>{$a->fullmessage}</ul>';
$string['deleteorphanedquestionsnonefound'] = '<b>није пронађено ниједно</b>';
$string['deleteorphanedquestionsquestioninfo'] = '<li><b>{$a->name}</b> (Questiontype: {$a->qtype}, ID: {$a->questionid})</li>';
$string['deleteorphanedquestionssmallmessage'] = 'СтуденТест: Задатак за брисање напуштених питања је покренут';
$string['deleteorphanedquestionssubject'] = 'СтуденТест';
$string['deleteorphanedquestionssuccessmdlquestion'] = '<font color="green">успешно</font>: обрисано из табеле mdl_question<br>';
$string['deleteorphanedquestionssuccessstudentquiz'] = '<font color="green">успешно</font>: обрисано из табела mdl_studentquiz*<br>';
$string['describe_already_deleted'] = 'Овај коментар је већ обрисан.';
$string['describe_not_creator'] = 'Ово није ваш коментар.';
$string['describe_out_of_time_delete'] = 'Време за брисање овог коментара је истекло';
$string['describe_out_of_time_edit'] = 'Време за уређивање овог коментара је истекло';
$string['descriptioncofstate'] = 'Питање подешено на \'{$a->state}\'';
$string['descriptionofstatenew'] = 'Питање је сачувано (\'Радна верзија\')';
$string['descriptionofvisibility'] = 'Видљивост питања је подешена на \'{$a->visibility}\'';
$string['difficulty_all_column_name'] = 'Тежина за све полазнике';
$string['difficulty_level_column_name'] = 'Тежина';
$string['difficulty_title'] = 'Трака тежине';
$string['editcomment'] = 'Уреди коментар';
$string['editedcomment_last_edit'] = 'Последњи пут уређено:';
$string['editedcommenthistory'] = 'Уредио/ла {$a->lastesteditedcommentauthorname} у {$a->lastededitedcommenttime}';
$string['editedcommenthistorylinktext'] = 'Историја';
$string['editedcommenthistorywithuserlink'] = 'Уредио/ла <a href="{$a->lastesteditedcommentauthorprofileurl}">{$a->lastesteditedcommentauthorname}</a> дана {$a->lastededitedcommenttime}';
$string['editorplaceholder'] = 'Унесите свој коментар овде...';
$string['emailautomationnote'] = 'Имајте на уму да је ово аутоматска системска порука – ова адреса е-поште се не надгледа.';
$string['emailcommentaddedbody'] = 'Драги/га {$a->recepientname},

Ваше питање \'{$a->questionname}\' у активности СтуденТест \'{$a->modulename}\' на курсу \'{$a->coursename}\' је коментарисао/ла \'{$a->actorname}\' у \'{$a->timestamp}\'.

Коментар гласи: \'{$a->commenttext}\'

Ово питање можете прегледати на: {$a->questionurl}.';
$string['emailcommentaddedsmall'] = 'Ваше питање \'{$a->questionname}\' је прокоментарисао/ла {$a->actorname}.';
$string['emailcommentaddedsubject'] = 'Послат је коментар на питање: {$a->questionname}';
$string['emailcommentdeletedbody'] = 'Драги/га {$a->recepientname},

Коментар послат \'{$a->commenttime}\' на ваше питање \'{$a->questionname}\' у активности СтуденТест \'{$a->modulename}\' на курсу\' {$a->coursename}\' обрисао/ла је \'{$a->actorname}\' у \'{$a->timestamp}\'.

Коментар је гласио: \'{$a->commenttext}\'

Ово питање можете прегледати на: {$a->questionurl}.';
$string['emailcommentdeletedsmall'] = 'Коментар на ваше питање \'{$a->questionname}\' обрисао/ла је {$a->actorname}.';
$string['emailcommentdeletedsubject'] = 'Обрисан је коментар на питање: {$a->questionname}';
$string['emaildigestbody'] = 'Ово је ваш {$a->digesttype} сажетак обавештења за активност СтуденТест  <b>{$a->modulename}</b>, доступан овде:';
$string['emaildigestbody_section_content'] = 'Ваше питање <b>{$a->questionname}</b> <b>{$a->actorname}</b> је <b>{$a->actiontype}</b>';
$string['emaildigestbody_section_title'] = 'Обавештење {$a->seq}, {$a->timestamp}';
$string['emaildigestsubject'] = 'СтудентТест - сажетак обавештења';
$string['emailminecommentdeletedbody'] = 'Драги/га {$a->recepientname},

Ваш коментар послат \'{$a->commenttime}\' на питање \'{$a->questionname}\' у активности СтуденТест \'{$a->modulename}\' на курсу\' {$a->coursename}\' обрисао/ла је \'{$a->actorname}\' у \'{$a->timestamp}\'.

Коментар је гласио: \'{$a->commenttext}\'

Ово питање можете прегледати на: {$a->questionurl}.';
$string['emailminecommentdeletedsmall'] = 'Ваш коментар на питање \'{$a->questionname}\' је обрисао/ла {$a->actorname}.';
$string['emailminecommentdeletedsubject'] = 'Обрисан je коментар на питање: {$a->questionname}';
$string['emailnoityfyreviewablequestion_section_content'] = 'Корисник <b>{$a->actorname<b> је статус питања <b>"{$a->questionname}"</b> променио у "<b>На рецензији</b>"';
$string['emailnoityfyreviewablequestionsinglebody'] = '<b>{$a->courseshortname}</b> активност СтуденТест (<b>"{$a->modulename}"</b>): корисник <b>{$a->actorname, {$a->timestamp}<b> је статус питања <b>"{$a->questionname}"</b> променио у "<b>На рецензији</b>"';
$string['emailsalutation'] = 'Драги/a {$a},';
$string['emailsinglebody'] = 'Ваше питање <b>{$a->questionname}</b>у активности СтуденТест <b>{$a->modulename}</b> на курсу <b>{$a->coursename}</b> корисник <b>{$a->actorname} је {$a->eventname} у <b>{$a->timestamp}</b>.';
$string['emailsinglebody_reviewlink'] = 'Ово питање можете прегледати на:';
$string['error_form_validation'] = '{$a}';
$string['error_permission'] = 'Жао нам је, али морате да будете део групе да бисте видели ову страницу.';
$string['error_sendalert'] = 'Дошло је до грешке при слању извештаја на {$a}.
Извештај није могао да се пошаље.';
$string['expandall'] = 'Прошири све коментаре';
$string['expandcomment'] = 'Прошири коментар';
$string['filter'] = 'Филтер';
$string['filter_advanced_element'] = '{$a} (Напредни елемент)';
$string['filter_comment_label_date'] = 'Датум';
$string['filter_comment_label_forename'] = 'Име';
$string['filter_comment_label_sort_by'] = 'Сортирај према:';
$string['filter_comment_label_sort_toggle'] = 'Сортирај према {$a->field} {$a->type}';
$string['filter_comment_label_surname'] = 'Презиме';
$string['filter_ishigher'] = 'је веће';
$string['filter_islower'] = 'је мање';
$string['filter_label_approved'] = 'Одобрена питања';
$string['filter_label_comment'] = 'Коментари';
$string['filter_label_createdate'] = 'Креирање';
$string['filter_label_difficulty_level'] = 'Тежина';
$string['filter_label_fast_filters'] = 'Брзи филтер за питања';
$string['filter_label_myattempts'] = 'Моји покушаји';
$string['filter_label_mydifficulty'] = 'Моја тежина';
$string['filter_label_mylastattempt'] = 'Мој последњи покушај';
$string['filter_label_myrate'] = 'Моја оцена';
$string['filter_label_onlyapproved'] = 'Одобрена';
$string['filter_label_onlyapproved_help'] = 'Питања која је одобрио ваш предавач';
$string['filter_label_onlydifficult'] = 'Тешка за све';
$string['filter_label_onlydifficult_help'] = 'Питање са просечном тежином већом од {$a}%';
$string['filter_label_onlydifficultforme'] = 'Тешка за мене';
$string['filter_label_onlydifficultforme_help'] = 'Питање са мојом тежином већом од {$a}%';
$string['filter_label_onlygood'] = 'Добра';
$string['filter_label_onlygood_help'] = 'Питање са просечном оценом од најмање {$a} звездице/ца';
$string['filter_label_onlymine'] = 'Моја';
$string['filter_label_onlymine_help'] = 'Питања која сте ви креирали.';
$string['filter_label_onlynew'] = 'Без одговора/Нова';
$string['filter_label_onlynew_help'] = 'Питања на која никада раније нисте одговорили';
$string['filter_label_question'] = 'Наслов питања';
$string['filter_label_question_creation_item'] = '{$a->creationtext} {$a->rowtext} {$a->inputtext}';
$string['filter_label_question_creation_item_inputtext'] = '{$a->inputtext} {$a->inputtype}';
$string['filter_label_questiontext'] = 'Садржај питања';
$string['filter_label_rates'] = 'Оцена';
$string['filter_label_show_mine'] = 'Моја питања';
$string['filter_label_tags'] = 'Ознака';
$string['finish_button'] = 'Заврши';
$string['hidden'] = 'Сакривено';
$string['history'] = 'Историја';
$string['includingunread'] = '(укључујући непрочитане)';
$string['invalidcomment'] = 'неисправанкоментар';
$string['invalidemail'] = 'Ова адреса е-поште није исправна. Унесите једну адресу е-поште.';
$string['lastattempt_right'] = '✓';
$string['lastattempt_right_label'] = 'Последњи покушај је тачан';
$string['lastattempt_wrong'] = '✗';
$string['lastattempt_wrong_label'] = 'Последњи покушај је погрешан';
$string['latest_column_name'] = 'Најновија';
$string['manager_anonym_fullname'] = 'Анонимни менаџер';
$string['message'] = 'Порука';
$string['messageprovider:commentadded'] = 'Слање обавештења о додатом коментару';
$string['messageprovider:commentdeleted'] = 'Слање обавештења о обрисаном коментару';
$string['messageprovider:deleteorphanedquestions'] = 'Слање обавештења о обрисаном питању';
$string['messageprovider:minecommentdeleted'] = 'Слање обавештења о мом обрисаном коментару';
$string['messageprovider:questionchanged'] = 'Слање обавештења о догађају везаним за питање';
$string['migrate_already_done'] = 'Ништа није урађено јер је ова активност већ мигрирана!';
$string['migrate_ask'] = 'Брзина модула СтуденТест је побољшана са верзијом 3.2.1, али се овај скуп питања и даље базира на претходној верзији.
Питања и тестови ће се брже учитавати уколико ова питања мигрирате  на нову верзију. Видећете много брже учитавање како питања тако и тестова; ништа друго се неће променити.';
$string['migrate_studentquiz'] = 'Мигрирајте питања креирана старом верзијом СтуденТеста  (пре верзије 3.2.1), на бржу верзију са агрегираним вредностима';
$string['migrate_studentquiz_short'] = 'Убрзајте овај скуп питања';
$string['migrated_successful'] = 'Ова активност је успешно мигрирана!';
$string['mine_column_name'] = 'Moja';
$string['missingparam'] = 'Oбавезан параметар недостаје или је погрешан';
$string['moderator'] = 'Модератор';
$string['modulename'] = 'СтуденТест';
$string['modulename_help'] = 'Активност \'СтуденТест\' омогућава да полазници сами креирају питања и додају их у банку питања. Полазници, такође, могу да филтрирају питања према различитим критеријумима, као и да филтрирана питања користе за вежбање. Предавачи могу да сакрију идентитет полазника који су креирали питања.<br><br> У оквиру ове активности полазници могу да освоје поене како за креирање нових питања, тако и за решавање тестова са питањима који креирали сви полазници. Поени се приказују на ранг листи.';
$string['modulename_link'] = 'mod/studentquiz/view';
$string['modulenameplural'] = 'СтуденТестови';
$string['more'] = 'Више';
$string['myattempts_column_name'] = 'Моји покушаји';
$string['mydifficulty_column_name'] = 'Моја тежина';
$string['mylastattempt_column_name'] = 'Мој последњи покушај';
$string['myrate_column_name'] = 'Моја оцена';
$string['nav_export'] = 'Извоз';
$string['nav_import'] = 'Увоз';
$string['nav_question_no'] = 'Питање {$a->current} од {$a->total}';
$string['needtoallowatleastoneqtype'] = 'Морате да дозволите бар један тип питања';
$string['next_button'] = 'Следеће';
$string['no_comment'] = 'n.a.';
$string['no_comments'] = 'Нема коментара';
$string['no_difficulty_level'] = 'n.a.';
$string['no_myattempts'] = 'n.a.';
$string['no_mylastattempt'] = 'n.a.';
$string['no_mylastattempt_label'] = 'Није било покушаја да се одговори на питање';
$string['no_questions_add'] = 'У овом СтуденТесту нема питања. Слободно додајте питања.';
$string['no_questions_filter'] = 'Ниједно од питања се не поклапа са критеријумима вашег филтера. Ресетујте филтер како бисте видели сва питања.';
$string['no_questions_selected_message'] = 'Изаберите бар једно питање како бисте започели тест.';
$string['no_rates'] = 'n.a.';
$string['no_tags'] = 'n.a.';
$string['nocommenthistoryexist'] = 'За овај коментар још увек не постоји историја коментара.';
$string['nofurtherprivatecomments'] = 'Када је питање \'Одобрено\' нису дозвољени даљи приватни коментари';
$string['noquestionsselectedtodoaction'] = 'Изаберите једно или више питања пре него што изаберете ову акцију.';
$string['not_approved'] = '✗';
$string['notshowratingcomment'] = 'Оцењивање и јавно коментарисање нису доступни за ваше питање док је оно у режиму рецензије.';
$string['num_questions'] = '{$a} питања';
$string['number_column_name'] = 'Број';
$string['numberreply'] = '{$a} одговора';
$string['onlyrootcommentcanreply'] = 'Може се послати одговор само на коментар првог нивоа';
$string['pagesize'] = 'Величина странице:';
$string['pagesize_invalid_input'] = 'Грешка: наведена величина странице мора да буде исправна нумеричка вредност.';
$string['pin'] = 'Фиксирај питање';
$string['please_enrole_message'] = 'Упишите се на овај курс како бисте видели свој лични напредак';
$string['pluginadministration'] = 'Администрација СтуденТеста';
$string['pluginname'] = 'СтуденТест';
$string['previous_button'] = 'Претходно';
$string['privacy:metadata:mod_studentquiz_comment_sort'] = 'Параметар корисника за тип филтера коментара.';
$string['privacy:metadata:mod_studentquiz_question_active_tab'] = 'Корисничка подешавања за тренутно активну картицу на страницама са питањима.';
$string['privacy:metadata:studentquiz_attempt'] = 'Представља покушај корисника да одговоре на скуп питања.';
$string['privacy:metadata:studentquiz_attempt:categoryid'] = 'ID ознака категорије.';
$string['privacy:metadata:studentquiz_attempt:questionusageid'] = 'ID ознака употребе питања.';
$string['privacy:metadata:studentquiz_attempt:studentquizid'] = 'ID ознака СтуденТеста.';
$string['privacy:metadata:studentquiz_attempt:userid'] = 'ID ознака корисника.';
$string['privacy:metadata:studentquiz_comment'] = 'Сачувајте коментаре за питања.';
$string['privacy:metadata:studentquiz_comment:comment'] = 'Коментар на питање.';
$string['privacy:metadata:studentquiz_comment:created'] = 'Време креирања коментара';
$string['privacy:metadata:studentquiz_comment:deleted'] = 'Време брисања коментара';
$string['privacy:metadata:studentquiz_comment:deleteuserid'] = 'ID ознака корисника који је обрисао коментар';
$string['privacy:metadata:studentquiz_comment:edited'] = 'Време уређивања коментара';
$string['privacy:metadata:studentquiz_comment:edituserid'] = 'ID ознака корисника који је уредио коментар';
$string['privacy:metadata:studentquiz_comment:parentid'] = 'ID ознака надређеног коментара. 0: коментар највишег нивоа.';
$string['privacy:metadata:studentquiz_comment:status'] = 'Статус коментара';
$string['privacy:metadata:studentquiz_comment:studentquizquestionid'] = 'ID ознака питања полазника (studentquizquestion).';
$string['privacy:metadata:studentquiz_comment:timemodified'] = 'Време измене коментара';
$string['privacy:metadata:studentquiz_comment:type'] = 'Врста коментара';
$string['privacy:metadata:studentquiz_comment:userid'] = 'ID ознака корисника';
$string['privacy:metadata:studentquiz_comment:usermodified'] = 'ID ознака корисника који је изменио коментар';
$string['privacy:metadata:studentquiz_comment_history'] = 'Сачувајте историје коментара';
$string['privacy:metadata:studentquiz_comment_history:action'] = 'Тип историје 0 - Креирај | 1 - Уреди | 2 - Избриши';
$string['privacy:metadata:studentquiz_comment_history:commentid'] = 'ID ознака коментара';
$string['privacy:metadata:studentquiz_comment_history:content'] = 'Садржај историје коментара';
$string['privacy:metadata:studentquiz_comment_history:timemodified'] = 'Измењено време коментара';
$string['privacy:metadata:studentquiz_comment_history:userid'] = 'ID ознака корисника који је уредио коментар';
$string['privacy:metadata:studentquiz_notification'] = 'Обавештење на чекању';
$string['privacy:metadata:studentquiz_notification:content'] = 'Садржај обавештења';
$string['privacy:metadata:studentquiz_notification:recipientid'] = 'ID ознака примаоца';
$string['privacy:metadata:studentquiz_notification:status'] = 'Статус обавештења';
$string['privacy:metadata:studentquiz_notification:studentquizid'] = 'ID ознака СтуденТеста.';
$string['privacy:metadata:studentquiz_notification:timetosend'] = 'Време за слање обавештења';
$string['privacy:metadata:studentquiz_progress'] = 'Сачувајте информације о напретку полазника за ово питање.';
$string['privacy:metadata:studentquiz_progress:attempts'] = 'Број покушаја за одговор на ово питање.';
$string['privacy:metadata:studentquiz_progress:correctattempts'] = 'Број тачних одговора.';
$string['privacy:metadata:studentquiz_progress:lastanswercorrect'] = '0: последњи одговор је био погрешан или недефинисан, 1: последњи одговор је био тачан.';
$string['privacy:metadata:studentquiz_progress:lastreadprivatecomment'] = 'Време када је корисник последњи пут прочитао приватне коментаре';
$string['privacy:metadata:studentquiz_progress:lastreadpubliccomment'] = 'Време када је корисник последњи пут прочитао јавне коментаре';
$string['privacy:metadata:studentquiz_progress:studentquizid'] = 'ID ознака СтуденТеста.';
$string['privacy:metadata:studentquiz_progress:studentquizquestionid'] = 'ID ознака питања полазника (studentquizquestion).';
$string['privacy:metadata:studentquiz_progress:userid'] = 'ID ознака корисника.';
$string['privacy:metadata:studentquiz_question'] = 'Сачувајте својства везана за питања';
$string['privacy:metadata:studentquiz_question:groupid'] = 'ID ознака групе којој питање припада';
$string['privacy:metadata:studentquiz_question:hidden'] = 'Својство да ли је питање сaкривено или не';
$string['privacy:metadata:studentquiz_question:pinned'] = 'Својство да ли је питање фиксирано или не';
$string['privacy:metadata:studentquiz_question:state'] = 'Својство да ли је питање одобрено, неодобрено, ново или промењено';
$string['privacy:metadata:studentquiz_question:studentquizid'] = 'ID ознака СтуденТеста.';
$string['privacy:metadata:studentquiz_rate'] = 'Сачувајте оцене за питања.';
$string['privacy:metadata:studentquiz_rate:rate'] = 'Оцена за питање.';
$string['privacy:metadata:studentquiz_rate:studentquizquestionid'] = 'ID ознака питања полазника (studentquizquestion).';
$string['privacy:metadata:studentquiz_rate:userid'] = 'ID ознака корисника.';
$string['privacy:metadata:studentquiz_state_history:state'] = 'Својство да ли је питање одобрено, неодобрено, ново или промењено';
$string['privacy:metadata:studentquiz_state_history:studentquizquestionid'] = 'ID ознака питања полазника (studentquizquestion).';
$string['privacy:metadata:studentquiz_state_history:timecreated'] = 'Време креирања';
$string['privacy:metadata:studentquiz_state_history:userid'] = 'ID ознака корисника.';
$string['private'] = 'Приватно';
$string['privatecomments'] = 'Приватни коментари';
$string['progress_bar_caption'] = 'Ваш напредак у овој активности СтуденТест';
$string['public'] = 'Јавно';
$string['publiccomments'] = 'Јавни коментари';
$string['questionchangedlowercase'] = 'промењено';
$string['questionsinuse'] = '(* Питања означена звездицом већ се користе у неким тестовима.)';
$string['ranking_block_title'] = 'Рангирање';
$string['ranking_block_title_anonymised'] = 'Рангирање (анонимизовано)';
$string['rate_all_column_name'] = 'Оцена свих полазника';
$string['rate_column_name'] = 'Оцена';
$string['rate_error'] = 'Молим вас оцените';
$string['rate_help'] = 'Оцените ово питање';
$string['rate_help_help'] = 'Оцените ово питање.<br />1 звездица је веома лоше, а 5 звездица је веома добро';
$string['rate_multi_stars_desc'] = 'Број изабраних звездица: {$a}';
$string['rate_one_star_desc'] = 'Изабрана 1 звездица';
$string['rate_points'] = 'Поени';
$string['rate_title'] = 'Процена';
$string['ratingbar_title'] = 'Трака процене';
$string['remove_comment'] = 'Уклони';
$string['remove_comment_label'] = 'Уклони коментар';
$string['replies'] = 'Одговори';
$string['reply'] = 'Одговори';
$string['replycomment'] = 'Одговори';
$string['report_comment_condition1'] = 'Увредљив је';
$string['report_comment_condition2'] = 'Узнемиријући је';
$string['report_comment_condition3'] = 'Садржи непристојан садржај као што је порнографија';
$string['report_comment_condition4'] = 'Погрдан је и клеветнички';
$string['report_comment_condition5'] = 'Крши ауторска права';
$string['report_comment_condition6'] = 'Против је правила из неког другог разлога';
$string['report_comment_condition_more'] = 'Остале информације (опционо)';
$string['report_comment_emailappendix'] = 'Примили сте ову е-поруку зато што је ваша адреса е-поште подешена у СтуденТесту за пријављивање неприхватљивих коментара.';
$string['report_comment_emailpreface'] = 'Коментар је пријавио/ла {$a->fullname} ({$a->username},
{$a->email}).';
$string['report_comment_emailsubject'] = 'Пријава коментара {$a->commentid}: {$a->coursename} {$a->studentquizname}';
$string['report_comment_feedback'] = 'Ваш извештај је успешно послат. Неко од одговорних ће испитати овај проблем.';
$string['report_comment_info'] = 'Функција \'Пријава коментара\' може да пошаље овај коментар надлежним особама које ће пријаву испитати. <strong>Користите ову функцију само ако мислите да коментар крши правила</strong>.';
$string['report_comment_invalid'] = 'Морате навести разлог због ког пријављујете овај коментар.';
$string['report_comment_invalid_checkbox'] = 'Морате означити бар једно поље.';
$string['report_comment_link_text'] = 'Прегледајте овде';
$string['report_comment_not_available'] = 'Функција за пријаву коментара није доступна.';
$string['report_comment_pagename'] = 'Пријавите коментар као неприхватљив';
$string['report_comment_reasons'] = 'Разлози за пријаву коментара:';
$string['report_comment_reporter_detail'] = '{$a->fullname} ({$a->username}; {$a->email}; {$a->ip})';
$string['report_comment_reporter_info'] = '<strong>Подаци о кориснику који пријављује коментар</strong>:';
$string['report_comment_submit'] = 'Пошаљите пријаву';
$string['reportcomment'] = 'Пријава';
$string['reportcomment_title'] = 'Пријави коментар као неприхватљив';
$string['reportquiz_admin_title'] = 'Статистика полазника';
$string['reportquiz_stats_all_last_attempt_correct'] = 'Просек последњих тачних одговора свих полазника';
$string['reportquiz_stats_all_last_attempt_incorrect'] = 'Просек последњих нетачних одговора свих полазника';
$string['reportquiz_stats_all_percentage_correct_answers'] = 'Проценат тачних одговора свих полазника';
$string['reportquiz_stats_all_percentage_correct_answers_help'] = 'Збир тачних одговора / збир свих одговора.';
$string['reportquiz_stats_all_progress'] = 'Просечан напредак свих полазника';
$string['reportquiz_stats_all_progress_help'] = 'Просечан напредак свих полазника базиран на свим учесницима на курсу.';
$string['reportquiz_stats_all_question_attempts_correct'] = 'Просек тачних одговора свих полазника';
$string['reportquiz_stats_all_question_attempts_incorrect'] = 'Просек нетачних одговора свих полазника';
$string['reportquiz_stats_all_questions_answered'] = 'Просек свих одговора свих полазника';
$string['reportquiz_stats_all_questions_answered_help'] = 'Просечан број одговора свих учесника на курсу.';
$string['reportquiz_stats_all_questions_approved'] = 'Број одобрених питања';
$string['reportquiz_stats_all_questions_approved_help'] = 'Предавачи могу одобрити питања како би потврдили његову тачност. Ово је број свих одобрених питања унутар овог СтуденТеста.';
$string['reportquiz_stats_all_questions_created'] = 'Број питања у овом СтуденТесту';
$string['reportquiz_stats_all_questions_created_help'] = 'Број питања који су креирали сви полазници';
$string['reportquiz_stats_all_rates_average'] = 'Просечна оцена свих питања';
$string['reportquiz_stats_all_rates_average_help'] = 'Оцена сваког питања је просек звездица које је питање добило од свих полазника. Пример: сви полазници на курсу креирали су 4 питања. Ако су полазници оценили питање А са 3 звездице, питање Б са 4 звездице, питање Ц са 2 звездице и питање Д са 5 звездица, онда је просечна оцена свих питања 3,5.';
$string['reportquiz_stats_own_last_attempt_correct'] = 'Број ваших последњих тачних одговора';
$string['reportquiz_stats_own_last_attempt_incorrect'] = 'Број ваших последњих нетачних одговора';
$string['reportquiz_stats_own_percentage_correct_answers'] = 'Проценат ваших тачних одговора';
$string['reportquiz_stats_own_percentage_correct_answers_help'] = 'Проценат свих ваших тачних одговора из скупа свих ваших одговора у овом СтуденТесту. Делимично тачни одговори се рачунају као погрешни одговори.';
$string['reportquiz_stats_own_progress'] = 'Лични напредак';
$string['reportquiz_stats_own_progress_help'] = 'Проценат ваших последњих тачних одговора из скупа свих питања унутар овог СтуденТеста. Делимично тачни одговори се рачунају као погрешни одговори.';
$string['reportquiz_stats_own_question_attempts_correct'] = 'Укупан број ваших тачних одговора';
$string['reportquiz_stats_own_question_attempts_incorrect'] = 'Укупан број ваших нетачних одговора';
$string['reportquiz_stats_own_questions_answered'] = 'Укупан број свих ваших одговора';
$string['reportquiz_stats_own_questions_answered_help'] = 'Број свих ваших одговора у оквиру овог СтуденТеста.';
$string['reportquiz_stats_own_questions_approved'] = 'Број ваших одобрених питања';
$string['reportquiz_stats_own_questions_approved_help'] = 'Предавачи могу одобрити питања како би потврдили његову тачност. Ово је број ваших одобрених питања унутар овог СтуденТеста.';
$string['reportquiz_stats_own_questions_created'] = 'Број питања која сте послали';
$string['reportquiz_stats_own_questions_created_help'] = 'Број питања која сте послали у овај СтуденТест.';
$string['reportquiz_stats_own_rates_average'] = 'Ваш просек добијених оцена';
$string['reportquiz_stats_own_rates_average_help'] = 'Оцена сваког питања је просек звездица које је питање добило од свих полазника. Пример: креирали сте питања А и Б. Ако су сви полазници оценила ваше питање А са 3 звездице, а ваше питање Б са 4 звездице, онда је ваша просечна оцене 3,5.';
$string['reportquiz_stats_title'] = 'Статистика';
$string['reportquiz_total_attempt'] = 'Број покушаја корисника да реши тест';
$string['reportquiz_total_obtained_marks'] = 'Укупна оцена';
$string['reportquiz_total_questions_answered'] = 'Укупно одговора';
$string['reportquiz_total_questions_right'] = 'Укупно тачних одговора';
$string['reportquiz_total_questions_wrong'] = 'Погрешни одговори';
$string['reportquiz_total_users'] = 'Број учесника';
$string['reportrank_table_column_approvedquestions'] = 'Поени за одобрена питања';
$string['reportrank_table_column_communitystatus'] = 'Статистика свих полазника';
$string['reportrank_table_column_correctanswers'] = 'Тачни одговори';
$string['reportrank_table_column_countquestions'] = 'Поени за објављена питања';
$string['reportrank_table_column_description'] = 'Опис';
$string['reportrank_table_column_factor'] = 'Фактор';
$string['reportrank_table_column_fullname'] = 'Презиме';
$string['reportrank_table_column_incorrectanswers'] = 'Нетачни одговори';
$string['reportrank_table_column_lastcorrectanswers'] = 'Поени за најновије тачне покушаје';
$string['reportrank_table_column_lastincorrectanswers'] = 'Поени за најновије погрешне покушаје';
$string['reportrank_table_column_points'] = 'Поени';
$string['reportrank_table_column_progress'] = 'Лични напредак';
$string['reportrank_table_column_quantifier_name'] = 'Име';
$string['reportrank_table_column_rank'] = 'Ранг';
$string['reportrank_table_column_summeanrates'] = 'Добијени поени за звездице';
$string['reportrank_table_column_total_points'] = 'Укупно поена';
$string['reportrank_table_column_value'] = 'Вредност';
$string['reportrank_table_column_yourstatus'] = 'Лична статистика';
$string['reportrank_table_quantifier_caption'] = 'Како се израчунавају ваши поени';
$string['reportrank_table_title'] = 'Рангирање полазника - 10 најбољих';
$string['reportrank_table_title_for_manager'] = 'Рангирање полазника';
$string['reportrank_title'] = 'Рангирање';
$string['review_button'] = 'Прегледај';
$string['savechanges'] = 'Сачувај промене';
$string['scheduled_task_send_digest_notification'] = 'Пошаљите резиме обавештења';
$string['setting_question_publishing'] = 'Објављивање питања';
$string['setting_question_publishing_automatic'] = 'Аутоматски објави нова питања';
$string['setting_question_publishing_help'] = 'Објављена питања се појављују у групи питања како би их други полазници могли да одговарају на њих. На располагању сам две опције: или дозволите аутоматско објављивање свих питања или захтевајте одобрење пре објављивања.<br>Имајте на уму да се ово подешавање примењује искључиво на новокреирана питања.';
$string['setting_question_publishing_require_approval'] = 'Захтевајте одобрење пре објављивања';
$string['settings_allowallqtypes'] = 'Дозволи све типове питања';
$string['settings_allowedqtypes'] = 'Дозвољени типови питања';
$string['settings_allowedqtypes_help'] = 'Ограничите дозвољене типове питања на оне које сте изабрали';
$string['settings_allowedrolestoshow'] = 'Изузмите улоге које се могу мењати у свакој активности';
$string['settings_allowedrolestoshow_help'] = 'Ово се односи на претходно подешавање. Нису све улоге у систему релевантне за СтуденТест, тако да можете да користите ово подешавање како бисте смањили број улога наведених у обрасцу за подешавања активности. Овде изабране улоге ће се појавити на обрасцу за сваку активност, тако да предавач може да промени подешавања. Улоге које овде нису изабране биће искључене из извештаја у зависности од тога да ли су претходно стандардно искључене.';
$string['settings_anonymous'] = 'Сакривач идентитета полазника';
$string['settings_anonymous_help'] = 'Полазници не могу да виде имена једни другима.';
$string['settings_anonymous_label'] = 'Учините полазнике анонимним';
$string['settings_approvedquantifier'] = 'Фактор за одобрена питања';
$string['settings_approvedquantifier_help'] = 'Поени за свако одобрено питање';
$string['settings_approvedquantifier_label'] = 'Поени за свако одобрено питање';
$string['settings_availability_close_answering_from'] = 'Затворено за давање одговора од';
$string['settings_availability_close_submission_from'] = 'Затворено за слање питања од';
$string['settings_availability_open_answering_from'] = 'Отворено за давање одговора од';
$string['settings_availability_open_submission_from'] = 'Отворено за слање питања од';
$string['settings_comment_editor_toolbar'] = 'Конфигурација траке са алаткама у едитору коментара';
$string['settings_comment_editor_toolbar_des'] = 'Овде се може конфигурисати списак додатака и њихов редослед';
$string['settings_commentdeletionperiod'] = 'Период за уређивање/брисања коментара (минути)';
$string['settings_commentdeletionperiod_help'] = 'Подесите временски период (у минутама) у којем ће дугме Уреди/Oбриши бити доступно полазницима како би могли да уреде/обришу свој коментар (или одговор на коментар) након што он буде објављен. Дозвољене су вредности између 0-60 минута. Ако је период за брисање подешен на 0, полазници не могу да уређују/бришу своје коментаре. Имајте на уму да ће наставници и администратори увек моћи да уређују/бришу коментаре полазника, као и да виде садржај сваког обрисаног коментара.';
$string['settings_email_digest_first_day'] = 'Први дан у седмици?';
$string['settings_email_digest_first_day_help'] = 'Ако сте изабрали седмични сажетак, ова опција вам омогућава да дефинишете први дан седмодневног периода (са почетком у 00h:00m:00s тог дана). Ово је посебно корисно ако активност, на пример, почиње средином недеље.';
$string['settings_email_digest_type'] = 'Тип сажетка који се шаље е-поштом';
$string['settings_email_digest_type_daily_digest'] = 'Дневни сажетак';
$string['settings_email_digest_type_help'] = 'СтуденТест има различита обавештења која можете да омогућите, као што је обавештавање полазника, аутора питања о промени статуса (нпр. предавач је одобрио неко од послатих питања). Можете да користите ово подешавање како бисте одредили колико често ће се слати ова обавештења. Е-порука са сажетком ће се слати само када постоји бар једно обавештење у подешеном временском периоду';
$string['settings_email_digest_type_no_digest'] = 'Без сажетка (једна е-порука за сваку акцију)';
$string['settings_email_digest_type_weekly_digest'] = 'Седмични сажетак';
$string['settings_excluderoles'] = 'Стандардне улоге које треба искључити из рангирања';
$string['settings_excluderoles_help'] = 'У сваком СтуденТесту, предавач може да контролише које су улоге искључене из рангирања. Списак улога, који је овде подешен, представља подразумевани списак који се користи за сваки новокреирани СтуденТест';
$string['settings_excluderoles_label'] = 'Улоге које треба искључити у рангирању';
$string['settings_forcecommenting'] = 'Приморајте кориснике да шаљу коментаре';
$string['settings_forcecommenting_help'] = 'Приморајте кориснике да шаљу коментаре приликом покушаја давања одговора на питање';
$string['settings_forcerating'] = 'Приморајте кориснике да оцењују питања';
$string['settings_forcerating_help'] = 'Приморајте кориснике да оцењују питања приликом покушаја давања одговора на њих';
$string['settings_lastcorrectanswerquantifier'] = 'Фактор за последње тачне одговоре';
$string['settings_lastcorrectanswerquantifier_help'] = 'Поени за сваки тачан одговор на последњем покушају';
$string['settings_lastcorrectanswerquantifier_label'] = 'Поени за последње тачне одговоре';
$string['settings_lastincorrectanswerquantifier'] = 'Фактор за последње погрешне одговоре';
$string['settings_lastincorrectanswerquantifier_help'] = 'Поени за сваки погрешан или делимично погрешан одговор на последњем покушају';
$string['settings_lastincorrectanswerquantifier_label'] = 'Поени за последње погрешне одговоре';
$string['settings_notification'] = 'Подешавања обавештења';
$string['settings_privatecomment'] = 'Објашњење приватног коментара';
$string['settings_privatecomment_help'] = 'Овде можете изменити текст објашњења, у зависности од тога како ваша организација користи дискусије између полазника и саветника/предавача/особе која администрира активности.';
$string['settings_privatecommenting'] = 'Омогући приватно коментарисање';
$string['settings_privatecommenting_help'] = 'Ток приватне дискусије, који је доступан када је питање на рецензији (све док се питање не одобри), омогућава дискусију између аутора питања и онога ко администрира активност. Ако је режим СтуденТеста подешен на \'Аутоматски објави нова питања\', онда аутор питања не мора нужно да икада види ову дискусију. Међутим, дискусија остаје доступна онима који администрирају активност без обзира, ко би могао да је искористити како би објаснио зашто је сакрио или избрисао питање. Стандардно, приватно коментарисање је дефинисано у подешавањима додатка на нивоу сервера.';
$string['settings_questionquantifier'] = 'Фактор за објављена питања';
$string['settings_questionquantifier_help'] = 'Поени за свако објављено питање';
$string['settings_questionquantifier_label'] = 'Поени за свако објављено питање';
$string['settings_ratequantifier'] = 'Фактор оцене';
$string['settings_ratequantifier_help'] = 'Поени за сваку добијену звездицу.';
$string['settings_ratequantifier_label'] = 'Мултипликатор за просечан звездица добијених за питање';
$string['settings_removeqbehavior'] = 'Уклони додатак за понашање питања СтуденТест';
$string['settings_removeqbehavior_help'] = 'Ова информација би требало да се појави само једном током ажурирања. Обавештавамо вас да смо открили да је инсталиран наш додатак за понашање питања СтуденТест. Овај додатак више није потребан и стога покушавамо да га аутоматски уклонимо. Ако и даље видите ово подешавање, ручно деинсталирајте додатак за понашање питања СтуденТест <a href="{$a}">овде</a>.';
$string['settings_removeqbehavior_label'] = 'Уклони додатак за понашање питања СтуденТест';
$string['settings_reportingemail'] = 'Адреса е-пошта за пријављивање увредљивих коментара';
$string['settings_reportingemail_help'] = 'Ако је ова адреса е-поште наведена, она ће се појавити као линк за Пријаву поред сваког коментара. Корисници ће моћи да кликну на линк како би пријавили увредљиве коментаре. Информација о томе биће послате на ову адресу.

Ако се поље за адресу е-поште остави празно, линк за Пријаву неће бити приказан (осим ако на нивоу сајта није подешена адреса за пријаву).

Могуће је додати више адреса е-поште, само је потребно оне буду одвојене тачком и зарезом.';
$string['settings_section_description_default'] = 'Ове вредности дефинишу подразумеване вредности приликом креирања нове активности СтуденТеста.';
$string['settings_section_header_comment_rating'] = 'Подешавање коментара и оцена';
$string['settings_section_header_commenting'] = 'Подешавања коментара';
$string['settings_section_header_question'] = 'Подешавања питања';
$string['settings_section_header_ranking'] = 'Подешавања рангирања';
$string['settings_showprivatecomment'] = 'Омогући дискусију унутар приватних коментара';
$string['settings_showprivatecomment_help'] = 'Ова опција омогућава напредну дискусију између полазника и предавача (називи улога се могу разликовати у зависности од организације) док је питање на рецензији.';
$string['settingsdeleteorphaned'] = 'Обришите напуштена питања';
$string['settingsdeleteorphaned_help'] = 'Активира планирани задатак који ће се покретати сваки дан како би се обрисала сва напуштена/неодобрена питања из базе података.';
$string['settingsdeleteorphanedtime1y'] = '1 година';
$string['settingsdeleteorphanedtime2y'] = '2 године';
$string['settingsdeleteorphanedtime3y'] = '3 године';
$string['settingsdeleteorphanedtime6m'] = '6 месеци';
$string['settingsdeleteorphanedtimelimit'] = 'Временски оквир за брисање напуштених питања';
$string['settingsdeleteorphanedtimelimit_help'] = 'Подесите временски оквир за брисање напуштених/неодобрених питања. Питања која су старија биће обрисана.';
$string['show_less'] = 'Прикажи мање';
$string['show_more'] = 'Прикажи више';
$string['slot_of_slot'] = 'Питање {$a->slot}  од {$a->slots} у овом скупу';
$string['start_quiz_button'] = 'Започни тест';
$string['state_approved'] = 'Одобрено';
$string['state_approvedlowercase'] = 'одобрено';
$string['state_approvedplural'] = 'Одобрено';
$string['state_change_tooltip_approved'] = 'Питање је одобрено. Кликните овде како бисте променили статус овог питања';
$string['state_change_tooltip_changed'] = 'Питање је промењено. Кликните овде како бисте променили статус овог питања';
$string['state_change_tooltip_disapproved'] = 'Питање није одобрено. Кликните овде како бисте променили статус овог питања';
$string['state_change_tooltip_new'] = 'Питање је ново. Кликните овде како бисте променили статус овог питања';
$string['state_change_tooltip_reviewable'] = 'Питање је на рецензији. Кликните овде како бисте променили статус овог питања';
$string['state_changed'] = 'Промењено';
$string['state_changedlowercase'] = 'промењено';
$string['state_changedplural'] = 'Промењено';
$string['state_column_name'] = 'Статус';
$string['state_column_name_veryshort'] = 'S';
$string['state_deleted'] = 'Обрисано';
$string['state_deletedlowercase'] = 'обрисано';
$string['state_deletedplural'] = 'Обрисано';
$string['state_disapproved'] = 'Неодобрено';
$string['state_disapprovedlowercase'] = 'неодобрено';
$string['state_disapprovedplural'] = 'Неодобрено';
$string['state_hidden'] = 'Сакривено';
$string['state_hiddenlowercase'] = 'сакривено';
$string['state_hiddenplural'] = 'Сакривено';
$string['state_new'] = 'Ново';
$string['state_newplural'] = 'Ново';
$string['state_pinned'] = 'Фиксирано';
$string['state_pinnedplural'] = 'Фиксирано';
$string['state_reviewable'] = 'На рецензији';
$string['state_reviewablelowercase'] = 'на_рецензији';
$string['state_reviewableplural'] = 'На рецензији';
$string['state_shown'] = 'Приказано';
$string['state_shownlowercase'] = 'приказано';
$string['state_shownplural'] = 'Приказано';
$string['state_toggle'] = 'Промени статус';
$string['statehistory'] = 'Историја статуса';
$string['statistic_block_approvals'] = 'Одобрена питања';
$string['statistic_block_created'] = 'Креирана питања';
$string['statistic_block_disapprovals'] = 'Неодобрена питања';
$string['statistic_block_new_changed'] = 'Нова/промењена питања';
$string['statistic_block_progress_available'] = 'Доступна питања';
$string['statistic_block_progress_last_attempt_correct'] = 'Последњи покушај је тачан';
$string['statistic_block_progress_last_attempt_incorrect'] = 'Последњи покушај је погрешан';
$string['statistic_block_progress_never'] = 'Питања на које никад није одговорено';
$string['statistic_block_title'] = 'Мој напредак';
$string['studentquiz'] = 'студентест';
$string['studentquiz:addinstance'] = 'Додавање нове инстанце СтуденТеста';
$string['studentquiz:cancommentprivately'] = 'Слање приватних коментара на сва питања';
$string['studentquiz:canselfcommentprivately'] = 'Слање приватних коментара на сопствена питања';
$string['studentquiz:canselfratecomment'] = 'Оцењивање и слање јавних коментара на сопствена питања која су послата на рецензију';
$string['studentquiz:changestate'] = 'Подешавање статуса питања на СтуденТесту';
$string['studentquiz:emailnotifyapproved'] = 'Обавештење о одобреном питању';
$string['studentquiz:emailnotifychanged'] = 'Слање обавештења о промењеном питању';
$string['studentquiz:emailnotifycommentadded'] = 'Слање обавештења о додатом коментару';
$string['studentquiz:emailnotifycommentdeleted'] = 'Слање обавештења о обрисаном коментару';
$string['studentquiz:emailnotifyquestion'] = 'Корисник добија обавештење путем е-поште о промени статуса његових питања';
$string['studentquiz:emailnotifyreviewablequestion'] = 'Корисник добија обавештење путем е-поште када полазник промени статус свог питања тако што га шаље на рецензију';
$string['studentquiz:manage'] = 'Уређивање и брисање питања на СтуденТесту';
$string['studentquiz:organize'] = 'Премештање питања у категорије на СтуденТесту';
$string['studentquiz:pinquestion'] = 'Фиксирање питања на СтуденТесту';
$string['studentquiz:preview'] = 'Рецензија питања';
$string['studentquiz:previewothers'] = 'Рецензија питања других на СтуденТесту';
$string['studentquiz:submit'] = 'Креирање питања на СтуденТесту';
$string['studentquiz:systemnotifytaskdeleteorphanedquestions'] = 'Слање обавештење о обрисаним напуштеним питањима';
$string['studentquiz:unhideanonymous'] = 'Преглед правих имена чак и када је активна анонимизација учесника';
$string['studentquiz:view'] = 'Преглед и коришћење питања на СтуденТесту';
$string['studentquizname'] = 'Назив СтуденТеста';
$string['studentquizname_help'] = 'Назив ове активности СтуденТест';
$string['submissionendbeforestart'] = 'Рок за слање питања се не може поставити тако да буде пре датума од ког је могуће слање питања';
$string['tags'] = 'Ознаке';
$string['unapprove'] = 'Поништи одобрење';
$string['unpin'] = 'Уклони фиксирање са питања';
$string['visiblegroupnotyetsupport'] = '\'Видљиве групе\' још увек нису подржане. Изаберите други групни режим.';
$string['weekly'] = 'седмично';
