<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'el', version '4.0'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Έχετε επερχόμενες συνόδους BigBlueButtonBN';
$string['bbbduetimeoverstartingtime'] = 'Η ημερομηνία παράδοσης για αυτή την δραστηριότητα πρέπει να είναι μετά την ημερομηνία έναρξης';
$string['bbbdurationwarning'] = 'Η μέγιστη διάρκεια αυτής της Τηλεσυνάντησης είναι %duration% λεπτά.';
$string['bbbrecordallfromstartwarning'] = 'Η Τηλεσυνάντηση καταγράφεται από την έναρξη της.';
$string['bbbrecordwarning'] = 'Αυτή η Τηλεσυνάντηση μπορεί να καταγράφεται.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Προσθήκη νέας αίθουσας/δραστηριότητας BigBlueButtonBN';
$string['bigbluebuttonbn:join'] = 'Είσοδος σε μια τηλεσυνάντηση BigBlueButtonBN';
$string['bigbluebuttonbn:managerecordings'] = 'Διαχείριση εγγραφών (ήχου/βίντεο) BigBlueButtonBN';
$string['bigbluebuttonbn:view'] = 'Εμφάνιση αίθουσας/δραστηριότητας';
$string['calendarstarts'] = '{$a} χρονοπρογραμματίστηκε για';
$string['completionattendance'] = 'Ο μαθητής πρέπει να παρακολουθήσει την συνάντηση για:';
$string['completionattendancegroup'] = 'Απαιτείται παρακολούθηση';
$string['completionattendancegroup_help'] = 'Απαιτείται συμμετοχή στη συνάντηση για (n) λεπτά για ολοκλήρωση';
$string['completionengagementchats'] = 'Γεγονότα γραπτής συνομιλίας';
$string['completionengagementemojis'] = 'Εμότζι';
$string['completionengagementgroup'] = 'Απαιτεί συμμετοχή';
$string['completionengagementgroup_help'] = 'Η ενεργή συμμετοχή κατά την σύνοδο, απαιτείται για την ολοκλήρωση';
$string['completionengagementpollvotes'] = 'Ψήφοι δημοσκόπησης';
$string['completionengagementraisehand'] = 'Γεγονότα σηκώματος χεριού';
$string['completionengagementtalks'] = 'Γεγονότα ομιλίας';
$string['completionupdatestate'] = 'Κατάσταση ενημέρωσης ολοκλήρωσης';
$string['completionvalidatestate'] = 'Επικύρωση ολοκλήρωσης';
$string['completionvalidatestatetriggered'] = 'Η επικύρωση ολοκλήρωσης έχει προκληθεί.';
$string['config_default_messages'] = 'Προεπιλεγμένα μηνύματα';
$string['config_default_messages_description'] = 'Ορισμός προεπιλεγμένων μηνυμάτων για δραστηριότητες';
$string['config_disablecam_default'] = 'Η απενεργοποίηση κάμερας θα είναι ενεργοποιημένη από προεπιλογή';
$string['config_disablecam_default_description'] = 'Αν ενεργοποιηθεί, οι κάμερες θα είναι απενεργοποιημένες.';
$string['config_disablecam_editable'] = 'Η απενεργοποίηση της κάμερας μπορεί να αλλάξει';
$string['config_disablecam_editable_description'] = 'Η απενεργοποίηση της κάμερας από προεπιλογή μπορεί να τροποποιηθεί κατά την προσθήκη ή την ενημέρωση του στιγμιοτύπου.';
$string['config_disablemic_default'] = 'Η απενεργοποίηση μικροφώνου θα είναι ενεργοποιημένη από προεπιλογή';
$string['config_disablemic_default_description'] = 'Εάν ενεργοποιηθεί, τα μικρόφωνα θα απενεργοποιηθούν.';
$string['config_disablemic_editable'] = 'Η απενεργοποίηση του μικροφώνου μπορεί να αλλάξει';
$string['config_disablemic_editable_description'] = 'Η απενεργοποίηση του μικροφώνου από προεπιλογή μπορεί να τροποποιηθεί κατά την προσθήκη ή την ενημέρωση του στιγμιοτύπου.';
$string['config_disablenote_default'] = 'Απενεργοποίηση της αυτόματης ενεργοποίησης κοινόχρηστων σημειώσεων από προεπιλογή';
$string['config_disablenote_default_description'] = 'Εάν ενεργοποιηθεί, τότε οι κοινόχρηστες σημειώσεις θα απενεργοποιηθούν.';
$string['config_disablenote_editable'] = 'Απενεργοποίηση της δυνατότητας τροποποίησης κοινόχρηστων σημειώσεων';
$string['config_disablenote_editable_description'] = 'Απενεργοποίηση της δυνατότητας τροποποίησης κοινόχρηστων σημειώσεων από προεπιλογή κατά την προσθήκη ή ενημέρωση του στιγμιοτύπου.';
$string['config_disableprivatechat_default'] = 'Απενεργοποίηση ενεργοποίησης ιδιωτικής γραπτής συνομιλίας από προεπιλογή';
$string['config_disableprivatechat_default_description'] = 'Αν ενεργοποιηθεί, η ιδιωτική γραπτή συνομιλία θα απενεργοποιηθεί.';
$string['config_disableprivatechat_editable'] = 'Η απενεργοποίηση ιδιωτικής γραπτής συνομιλίας μπορεί να τροποποιηθεί';
$string['config_disableprivatechat_editable_description'] = 'Η απενεργοποίηση ιδιωτικής γραπτής συνομιλίας από προεπιλογή μπορεί να τροποποιηθεί κατά την προσθήκη ή ενημέρωση του στιγμιοτύπου.';
$string['config_disablepublicchat_default'] = 'Η απενεργοποίηση δημόσιας γραπτής συνομιλίας θα είναι ενεργοποιημένη από προεπιλογή';
$string['config_disablepublicchat_default_description'] = 'Εάν ενεργοποιηθεί, η δημόσια γραπτή συνομιλία θα απενεργοποιηθεί.';
$string['config_disablepublicchat_editable'] = 'Η απενεργοποίηση της δημόσιας γραπτής συνομιλίας μπορεί να τροποποιηθεί';
$string['config_disablepublicchat_editable_description'] = 'Η απενεργοποίηση της δημόσιας γραπτής συνομιλίας μπορεί να τροποποιηθεί κατά την προσθήκη ή ενημέρωση του στιγμιοτύπου';
$string['config_experimental_features'] = 'Ρυθμίσεις για πειραματικά χαρακτηριστικά';
$string['config_experimental_features_description'] = 'Διαμόρφωση/Ρυθμίσεις για πειραματικά χαρακτηριστικά.';
$string['config_extended_capabilities'] = 'Ρυθμίσεις για προχωρημένες δυνατότητες';
$string['config_extended_capabilities_description'] = 'Ρυθμίσεις για προχωρημένες δυνατότητες όταν τις προσφέρει ο εξυπηρετητής BigBlueButton.';
$string['config_general'] = 'Γενικές ρυθμίσεις';
$string['config_general_description'] = 'Αυτές οι ρυθμίσεις χρησιμοποιούνται <b>πάντα</b>';
$string['config_hideuserlist_default'] = 'Απόκρυψη λίστας χρηστών ενεργοποιημένη από προεπιλογή';
$string['config_hideuserlist_default_description'] = 'Εάν ενεργοποιηθεί, τότε η λίστα χρηστών συνόδου θα είναι σε απόκρυψη.';
$string['config_hideuserlist_editable'] = 'Η απόκρυψη λίστας χρηστών μπορεί να τροποποιηθεί';
$string['config_hideuserlist_editable_description'] = 'Η απόκρυψη λίστας χρηστών από προεπιλογή μπορεί να τροποποιηθεί κατά την προσθήκη ή ενημέρωση του στιγμιοτύπου.';
$string['config_importrecordings'] = 'Ρυθμίσεις για το χαρακτηριστικό «Εισαγωγή εγγραφών»';
$string['config_importrecordings_description'] = 'Αυτές οι ρυθμίσεις είναι για συγκεκριμένα χαρακτηριστικά';
$string['config_importrecordings_enabled'] = 'Εισαγωγή εγγραφών ενεργοποιημένη';
$string['config_importrecordings_enabled_description'] = 'Όταν αυτό και το χαρακτηριστικό/δυνατότητα για εγγραφή είναι ενεργά, τότε είναι δυνατό να γίνει εισαγωγή εγγραφών από διαφορετικά μαθήματα σε μια δραστηριότητα.';
$string['config_importrecordings_from_deleted_enabled'] = 'Εισαγωγή εγγραφών από διαγραμμένες δραστηριότητες ενεργοποιημένη';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Όταν αυτό και το χαρακτηριστικό/δυνατότητα για εισαγωγή εγγραφών είναι ενεργά, τότε είναι εφικτή η εισαγωγή εγγραφών από δραστηριότητες που δεν βρίσκονται πλεόν στο μάθημα.';
$string['config_lockonjoin_default'] = 'Αγνόηση κλειδώματος κατά την ένταξη ενεργοποιημένο από προεπιλογή';
$string['config_lockonjoin_default_description'] = 'Εάν ενεργοποιηθεί, τότε οι ρυθμίσεις κλειδώματος θα αγνοούνται. Οι ρυθμίσεις κλειδώματος πρέπει να είναι ενεργοποιημένες για να εφαρμόζεται αυτό.';
$string['config_lockonjoin_editable'] = 'Η αγνόηση κλειδώματος κατά την ένταξη μπορεί να τροποποιηθεί';
$string['config_lockonjoin_editable_description'] = 'Η αγνόηση κλειδώματος κατά την ένταξη από προεπιλογή μπορεί να τροποποιηθεί κατά την προσθήκη ή ενημέρωση του στιγμιοτύπου.';
$string['config_locksettings'] = 'Διαμόρφωση των ρυθμίσεων κλειδώματος';
$string['config_locksettings_description'] = 'Αυτές οι ρυθμίσεις ενεργοποιούν ή απενεργοποιούν επιλογές στην διεπαφή χρήστη (UI) για ρυθμίσεις κλειδώματος και επίσης ορίζουν προεπιλεγμένες τιμές για αυτές τις επιλογές.';
$string['config_meetingevents_enabled'] = 'Καταχώρηση ζωντανών γεγονότων';
$string['config_meetingevents_enabled_description'] = 'Ενεργοποίηση του πρόσθετου για αποδοχή και επεξεργασία ζωντανών γεγονότων μετά τη λήξη της συνόδου. (Πρέπει να είναι ενεργοποιημένο για «Ολοκλήρωση δραστηριότητας» και θα λειτουργεί μόνο εάν ο εξυπηρετητής BigBlueButton είναι σε θέση να επεξεργάζεται σενάρια post_events)';
$string['config_muteonstart'] = 'Ρυθμίσεις για το χαρακτηριστικό/δυνατότητα «Σίγαση κατά την έναρξη»';
$string['config_muteonstart_default'] = 'Ενεργοποίηση του χαρακτηριστικού/δυνατότητας «Σίγαση κατά την έναρξη» από προεπιλογή';
$string['config_muteonstart_default_description'] = 'Εάν ενεργοποιηθεί θα ισχύει για τη σύνοδο «Σίγαση κατά την έναρξη».';
$string['config_muteonstart_description'] = 'Αυτές οι ρυθμίσεις ενεργοποιούν ή απενεργοποιούν επιλογές στην διεπαφή χρήστη (UI) και επίσης ορίζουν προεπιλεγμένες τιμές για αυτές τις επιλογές.';
$string['config_muteonstart_editable'] = 'Η δυνατότητα «Σίγαση κατά την έναρξη» μπορεί να τροποποιηθεί';
$string['config_muteonstart_editable_description'] = 'Η σίγαση κατά την έναρξη από προεπιλογή, μπορεί να τροποποιηθεί κατά την προσθήκη ή ενημέρωση του στιγμιοτύπου.';
$string['config_participant'] = 'Διαμόρφωση συμμετέχοντα';
$string['config_participant_description'] = 'Αυτές οι ρυθμίσεις ορίζουν τον ρόλο από προεπιλογή των συμμετεχόντων σε μια διάσκεψη.';
$string['config_participant_moderator_default'] = 'Συντονιστής από προεπιλογή';
$string['config_participant_moderator_default_description'] = 'Αυτός ο κανόνας χρησιμοποιείται από προεπιλογή κατά την προσθήκη μιας νέας αίθουσας.';
$string['config_presentation_default'] = 'Προεπιλεγμένο αρχείο για τη λειτουργία «Παρουσίαση προ-ανεβάσματος»';
$string['config_presentation_default_description'] = 'Αυτή η ρύθμιση επιτρέπει την επιλογή ενός αρχείου που θα χρησιμοποιείται ως προεπιλογή σε όλα τα στιγμιότυπα BBB εάν είναι ενεργοποιημένη η λειτουργία «Παρουσίαση προ-ανεβάσματος».';
$string['config_preuploadpresentation'] = 'Διαμόρφωση για τη λειτουργία «Παρουσίαση προ-ανεβάσματος»';
$string['config_preuploadpresentation_description'] = 'Αυτές οι ρυθμίσεις ενεργοποιούν ή απενεργοποιούν επιλογές στη διεπαφή χρήστη και καθορίζουν επίσης προεπιλεγμένες τιμές για αυτές τις επιλογές. Το χαρακτηριστικό λειτουργεί μόνο εάν ο εξυπηρετητής Moodle είναι προσβάσιμος στο BigBlueButton.';
$string['config_preuploadpresentation_editable'] = 'Επεξεργασιμότητα παρουσίασης προ φόρτωσης';
$string['config_preuploadpresentation_editable_description'] = 'Η δυνατότητα παρουσίασης προ φόρτωσης επιτρέπει επεξεργασία στο περιβάλλον χρήστη όταν η αίθουσα ή η διάσκεψη προστίθεται ή ενημερώνεται.';
$string['config_recording'] = 'Ρυθμίσεις για την λειτουργία «Εγγραφή συνάντησης»';
$string['config_recording_all_from_start_default'] = 'Εγγραφή όλων από την αρχή';
$string['config_recording_all_from_start_default_description'] = 'Αν επιλεγεί, η συνάντηση θα καταγραφεί από την αρχή';
$string['config_recording_all_from_start_editable'] = 'Η δυνατότητα καταγραφής όλων από την αρχή μπορεί να τροποποιηθεί';
$string['config_recording_all_from_start_editable_description'] = 'Αν επιλεγεί, η διεπαφή θα περιλαμβάνει επιλογή για ενεργοποίηση και απενεργοποίηση της δυνατότητας καταγραφής όλων από την αρχή.';
$string['config_recording_default'] = 'Η δυνατότητα καταγραφής θα είναι ενεργοποιημένη από προεπιλογή';
$string['config_recording_default_description'] = 'Εάν ενεργοποιηθεί, οι σύνοδοι που δημιουργούνται στο BigBlueButton θα έχουν δυνατότητες εγγραφής.';
$string['config_recording_description'] = 'Αυτές οι ρυθμίσεις είναι για συγκεκριμένα χαρακτηριστικά';
$string['config_recording_editable'] = 'Η δυνατότητα καταγραφής μπορεί να τροποποιηθεί';
$string['config_recording_editable_description'] = 'Εάν ελεγχθεί, η διεπαφή περιλαμβάνει μια επιλογή για ενεργοποίηση και απενεργοποίηση της δυνατότητας εγγραφής.';
$string['config_recording_hide_button_default'] = 'Απόκρυψη πλήκτρου εγγραφής';
$string['config_recording_hide_button_default_description'] = 'Εάν επιλεγεί, το πλήκτρο για εγγραφή θα είναι σε απόκρυψη';
$string['config_recording_hide_button_editable'] = 'Η δυνατότητα απόκρυψης του κουμπιού μπορεί να τροποποιηθεί';
$string['config_recording_hide_button_editable_description'] = 'Εάν ενεργοποιηθεί, τότε η διεπαφή συμπεριλαμβάνει μια επιλογή για ενεργοποίηση και απενεργοποίηση της λειτουργίας απόκρυψης του πλήκτρου εγγραφής ήχου/βίντεο.';
$string['config_recordingready_enabled'] = 'Αποστολή ενημερώσεων όταν μια καταγραφή είναι έτοιμη';
$string['config_recordingready_enabled_description'] = 'Ενεργοποίηση του πρόσθετου για αποστολή ειδοποιήσεων όταν η εγγραφή είναι έτοιμη. (Θα λειτουργήσει μόνο εάν το σενάριο post_publish_recording_ready_callback είναι ενεργοποιημένο στον εξυπηρετητή BigBlueButton)';
$string['config_recordings'] = 'Ρυθμίσεις για την λειτουργία «Εμφάνιση εγγραφών ήχου/βίντεο»';
$string['config_recordings_asc_sort'] = 'Ταξινόμηση των καταγραφών σε αύξουσα σειρά.';
$string['config_recordings_asc_sort_description'] = 'Από προεπιλογή οι εγγραφές εμφανίζονται με φθίνουσα σειρά. Αν επιλεγεί, θα ταξινομούνται σε αύξουσα σειρά.';
$string['config_recordings_deleted_default'] = 'Εισαγωγή εγγραφών από διαγραμμένες δραστηριότητες ενεργοποιημένη από προεπιλογή';
$string['config_recordings_deleted_default_description'] = 'Εάν ενεργοποιηθεί, ο πίνακας εγγραφών θα περιλαμβάνει τις εγγραφές ήχου/βίντεο που ανήκουν σε διαγραμμένες δραστηριότητες, εάν υπάρχουν.';
$string['config_recordings_deleted_editable'] = 'Η δυνατότητα συμπερίληψης εγγραφών από διαγραμμένες δραστηριότητες μπορεί να τροποποιηθεί';
$string['config_recordings_deleted_editable_description'] = 'Η συμπερίληψη εγγραφών από διαγραμμένες δραστηριότητες από προεπιλογή μπορεί να τροποποιηθεί κατά την προσθήκη ή την ενημέρωση του στιγμιοτύπου.';
$string['config_recordings_description'] = 'Αυτές οι ρυθμίσεις είναι για συγκεκριμένα χαρακτηριστικά';
$string['config_recordings_general'] = 'Εμφάνιση ρυθμίσεων εγγραφών';
$string['config_recordings_general_description'] = 'Αυτές οι ρυθμίσεις χρησιμοποιούνται μόνο όταν εμφανίζονται εγγραφές';
$string['config_recordings_imported_default'] = 'Εμφάνιση μόνο των εισαχθέντων συνδέσμων, από προεπιλογή';
$string['config_recordings_imported_default_description'] = 'Εάν ενεργοποιηθεί, ο πίνακας εγγραφών θα περιλαμβάνει μόνο τους εισαχθέντες συνδέσμους προς εγγραφές.';
$string['config_recordings_imported_editable'] = 'Η λειτουργία εμφάνισης μόνο εισαχθέντων συνδέσμων, μπορεί να τροποποιηθεί';
$string['config_recordings_imported_editable_description'] = 'Η επιλογή «Εμφάνιση μόνο των εισαχθέντων συνδέσμων, από προεπιλογή» μπορεί να τροποποιηθεί κατά την προσθήκη ή την ενημέρωση του στιγμιοτύπου.';
$string['config_recordings_preview_default'] = 'Η προεπισκόπηση είναι ενεργοποιημένη από προεπιλογή';
$string['config_recordings_preview_default_description'] = 'Αν ενεργοποιηθεί, τότε ο πίνακας θα περιλαμβάνει προεπισκόπηση της παρουσίασης.';
$string['config_recordings_preview_editable'] = 'Η δυνατότητα προεπισκόπησης μπορεί να τροποποιηθεί';
$string['config_recordings_preview_editable_description'] = 'Η δυνατότητα προεπισκόπησης μπορεί να τροποποιηθεί κατά την προσθήκη ή την ενημέρωση του στιγμιοτύπου.';
$string['config_scheduled'] = 'Ρυθμίσεις για «Χρονοπρογραμματισμένες συνόδους»';
$string['config_scheduled_description'] = 'Αυτές οι ρυθμίσεις ορίζουν κάποιες επιλογές από την προεπιλεγμένη συμπεριφορά για τις προγραμματισμένες συνόδους.';
$string['config_scheduled_pre_opening'] = 'Προσβάσιμο πριν την ώρα έναρξης (λεπτά)';
$string['config_scheduled_pre_opening_description'] = 'Ο χρόνος σε λεπτά για να είναι προσβάσιμη η σύνοδος πριν από την ώρα έναρξης των προγραμμάτων.';
$string['config_server_url'] = 'Διεύθυνση URL εξυπηρετητή BigBlueButton';
$string['config_server_url_description'] = 'Η διεύθυνση URL του εξυπηρετητή BigBlueButton πρέπει να τελειώνει σε /bigbluebutton/. (Αυτή η προεπιλεγμένη διεύθυνση είναι για έναν εξυπηρετητή BigBlueButton που παρέχεται από την εταιρία Blindside Networks και που μπορεί να χρησιμοποιηθεί για δοκιμές.)';
$string['config_shared_secret'] = 'Κοινόχρηστο μυστικό BigBlueButton';
$string['config_shared_secret_description'] = 'Το «αλάτι» ασφαλείας (εμπλουτισμός κωδικού) του εξυπηρετητή σας BigBlueButton. (Αυτό το προεπιλεγμένο «αλάτι» είναι για έναν εξυπηρετητή BigBlueButton που παρέχεται από την εταιρία Blindside Networks και που μπορεί να χρησιμοποιηθεί για δοκιμές.)';
$string['config_uidelegation_enabled'] = 'Η αποστολή UI (διεπαφής χρήστη) ενεργοποιήθηκε';
$string['config_uidelegation_enabled_description'] = 'Αυτές οι ρυθμίσεις ενεργοποιούν ή απενεργοποιούν την αποστολή UI (διεπαφή χρήστη) στον εξυπηρετητή BigBlueButton';
$string['config_userlimit'] = 'Ρυθμίσεις για το χαρακτηριστικό «Όριο χρηστών»';
$string['config_userlimit_default'] = 'Το Όριο χρηστών είναι ενεργοποιημένο από προεπιλογή';
$string['config_userlimit_default_description'] = 'Ο αριθμός των χρηστών που επιτρέπονται σε μια σύνοδο από προεπιλογή όταν δημιουργείται μια νέα αίθουσα ή διάσκεψη. Αν ο αριθμός είναι ορισμένος σε 0, δεν θα υπάρχει κανένα όριο.';
$string['config_userlimit_description'] = 'Αυτές οι ρυθμίσεις ενεργοποιούν ή απενεργοποιούν επιλογές στην διεπαφή χρήστη και επίσης ορίζουν προεπιλεγμένες τιμές για αυτές τις επιλογές.';
$string['config_userlimit_editable'] = 'Ο χαρακτηριστικό ορίου χρηστών μπορεί να τροποποιηθεί';
$string['config_userlimit_editable_description'] = 'Το προεπιλεμένο όριο χρηστών μπορεί να τροποποιηθεί κατά την προσθήκη ή την ενημέρωση της αίθουσας ή της διάσκεψης.';
$string['config_voicebridge'] = 'Ρυθμίσεις για το χαρακτηριστικό «Γέφυρα φωνής»';
$string['config_voicebridge_description'] = 'Αυτές οι ρυθμίσεις ενεργοποιούν ή απενεργοποιούν επιλογές στην διεπαφή χρήστη (UI) και επίσης ορίζουν προεπιλεγμένες τιμές για αυτές τις επιλογές.';
$string['config_voicebridge_editable'] = 'Η διάσκεψη γέφυρας φωνής μπορεί να τροποποιηθεί';
$string['config_voicebridge_editable_description'] = 'Ο αριθμός γέφυρας φωνής της διάσκεψης μπορεί να αντιστοιχιστεί μόνιμα σε μια διάσκεψη αίθουσας. Όταν εκχωρηθεί, ο αριθμός δεν μπορεί να χρησιμοποιηθεί από οποιαδήποτε άλλη αίθουσα ή συνέδριο';
$string['config_waitformoderator'] = 'Ρυθμίσεις για το χαρακτηριστικό «Αναμονή για συντονιστή»';
$string['config_waitformoderator_cache_ttl'] = 'Αναμονή για την κρυφή μνήμη TTL (δευτερόλεπτα) του συντονιστή';
$string['config_waitformoderator_cache_ttl_description'] = 'Για να υποστηρίξει ένα μεγάλο φορτίο πελατών, αυτό το πρόσθετο χρησιμοποιεί μια κρυφή μνήμη. Αυτή η παράμετρος καθορίζει το χρόνο διατήρησης της κρυφής μνήμης πριν αποσταλεί το επόμενο αίτημα στον εξυπηρετητή BigBlueButton.';
$string['config_waitformoderator_default'] = 'Αναμονή για συντονιστή ενεργοποιημένη από προεπιλογή';
$string['config_waitformoderator_default_description'] = 'Η αναμονή για συντονιστή θα είναι ενεργοποιημένη από προεπιλογή κατά την προσθήκη μιας νέας αίθουσας ή διάσκεψης.';
$string['config_waitformoderator_description'] = 'Αυτές οι ρυθμίσεις είναι για συγκεκριμένα χαρακτηριστικά';
$string['config_waitformoderator_editable'] = 'Η επιλογή αναμονής για συντονιστή θα μπορεί να τροποποιηθεί';
$string['config_waitformoderator_editable_description'] = 'Η προεπιλεγμένη αναμονή για συντονιστή θα μπορεί να τροποποιηθεί κατά την προσθήκη ή ενημέρωση της αίθουσας ή της διάσκεψης.';
$string['config_waitformoderator_ping_interval'] = 'Αναμονή για ping (χρονομέτρηση απόκρισης) συντονιστή (δευτερόλεπτα)';
$string['config_waitformoderator_ping_interval_description'] = 'Όταν είναι ενεργοποιημένη η δυνατότητα αναμονής για συντονιστή, ο πελάτης κάνει ping (χρονομέτρηση απόκρισης) για την κατάσταση της συνόδου κάθε [αριθμός] δευτερόλεπτα. Αυτή η παράμετρος καθορίζει το διάστημα για αιτήματα που υποβάλλονται στον εξυπηρετητή Moodle';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'Το BigBlueButton κάνει χρήση του config.php με μια καθολική μεταβλητή που έχει απαρχαιωθεί. Παρακαλούμε, μετατρέψτε το αρχείο, καθώς δεν θα υποστηρίζεται σε μελλοντικές εκδόσεις';
$string['config_warning_curl_not_installed'] = 'Αυτή η δυνατότητα απαιτεί το πρόσθετο CURL της PHP να είναι εγκατεστημένο και ενεργοποιημένο. Οι ρυθμίσεις θα είναι προσβάσιμες μόνο εάν πληρούται αυτή η προϋπόθεση.';
$string['config_welcome_default'] = 'Προεπιλεγμένο μήνυμα καλωσορίσματος';
$string['config_welcome_default_description'] = 'Αντικαθιστά το προεπιλεγμένο μήνυμα που έχει οριστεί για τον εξυπηρετητή BigBlueButton. Το μήνυμα μπορεί να περιλαμβάνει λέξεις-κλειδιά (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%) τα οποία θα αντικατασταθούν αυτόματα, καθώς και ετικέτες html όπως <b>...</b> ή <i></i>';
$string['config_welcome_editable'] = 'Το προεπιλεγμένο μήνυμα καλωσορίσματος είναι τροποποιήσιμο από διδάσκοντες';
$string['config_welcome_editable_description'] = 'Το μήνυμα καλωσορίσματος μπορεί να τροποποιηθεί κατά την προσθήκη ή την ενημέρωση του στιγμιοτύπου';
$string['ends_at'] = 'Τελειώνει';
$string['event_activity_created'] = 'Η δραστηριότητα δημιουργήθηκε';
$string['event_activity_deleted'] = 'Η δραστηριότητα διαγράφηκε';
$string['event_activity_updated'] = 'Η δραστηριότητα ενημερώθηκε';
$string['event_live_session'] = 'Ζωντανό γεγονός συνόδου';
$string['event_meeting_created'] = 'Η συνάντηση δημιουργήθηκε';
$string['event_meeting_ended'] = 'Η συνάντηση BigBlueButtonBN έληξε απότομα';
$string['event_meeting_joined'] = 'Έγινε ένταξη στη σύσκεψη BigBlueButtonBN';
$string['event_meeting_left'] = 'Αποχώρηση από τη συνάντηση';
$string['event_recording_deleted'] = 'Η εγγραφή διαγράφηκε';
$string['event_recording_edited'] = 'Η εγγραφή τροποποιήθηκε';
$string['event_recording_imported'] = 'Η εγγραφή εισήχθη';
$string['event_recording_protected'] = 'Η εγγραφή προστατεύεται';
$string['event_recording_published'] = 'Η ηχογράφηση δημοσιεύθηκε';
$string['event_recording_unprotected'] = 'Η εγγραφή δεν προστατεύεται πλέον';
$string['event_recording_unpublished'] = 'Η ηχογράφηση δεν δημοσιεύεται πλέον';
$string['event_recording_viewed'] = 'Η εγγραφή εμφανίστηκε';
$string['general_error_not_allowed_to_create_instances'] = 'Ο χρήστης δεν επιτρέπεται να δημιουργεί οποιονδήποτε τύπο στιγμιοτύπων.';
$string['general_error_unable_connect'] = 'Αδυναμία σύνδεσης. Παρακαλούμε, ελέγξτε τη διεύθυνση URL του εξυπηρετητή BigBlueButton ΚΑΙ ελέγξτε εάν εκτελείται ο εξυπηρετητής BigBlueButton.';
$string['index_confirm_end'] = 'Θέλετε να τερματίσετε την εικονική συνάντηση τάξης;';
$string['index_disabled'] = 'απενεργοποιημένο';
$string['index_enabled'] = 'ενεργοποιημένο';
$string['index_ending'] = 'Τερματισμός της εικονικής τάξης... Παρακαλούμε, περιμένετε';
$string['index_error_bbtn'] = 'Το αναγνωριστικό {$a} του BigBlueButton είναι μη έγκυρο';
$string['index_error_checksum'] = 'Παρουσιάστηκε ένα σφάλμα αθροίσματος ελέγχου. Βεβαιωθείτε ότι πληκτρολογήσατε το σωστό αλάτι (εμπλουτισμό κωδικού).';
$string['index_error_forciblyended'] = 'Δεν είναι δυνατή η ένταξη σε αυτή τη σύσκεψη επειδή έχει τερματιστεί χειροκίνητα.';
$string['index_error_noinstances'] = 'Δεν υπάρχει κανένα στιγμιότυπο του BigBlueButtonBN';
$string['index_error_unable_display'] = 'Δεν είναι δυνατή η εμφάνιση των συναντήσεων. Παρακαλούμε ελέγξτε τη διεύθυνση URL του εξυπηρετητή BigBlueButton ΚΑΙ ελέγξτε αν ο εξυπηρετητής λειτουργεί.';
$string['index_heading'] = 'Αίθουσες BigBlueButton';
$string['index_heading_actions'] = 'Ενέργειες';
$string['index_heading_group'] = 'Ομάδα';
$string['index_heading_moderator'] = 'Συντονιστές';
$string['index_heading_name'] = 'Αίθουσα';
$string['index_heading_recording'] = 'Εγγραφή ήχου/βίντεο';
$string['index_heading_users'] = 'Χρήστες';
$string['index_heading_viewer'] = 'Θεατές';
$string['indicator:cognitivedepth'] = 'Βάθος κατανόησης BigBlueButton';
$string['indicator:cognitivedepth_help'] = 'Αυτός ο δείκτης βασίζεται στο βάθος κατανόησης που επιτεύχθηκε από τον μαθητή σε μια δραστηριότητα BigBlueButton.';
$string['indicator:socialbreadth'] = 'Κοινωνικό εύρος BigBlueButton';
$string['indicator:socialbreadth_help'] = 'Αυτός ο δείκτης βασίζεται στο κοινωνικό εύρος που επιτεύχθηκε από τον μαθητή σε μια δραστηριότητα BigBlueButton.';
$string['instance_type_default'] = 'Αίθουσα/Δραστηριότητα με εγγραφές ήχου/βίντεο';
$string['instance_type_recording_only'] = 'Μόνο εγγραφές';
$string['instance_type_room_only'] = 'Αίθουσα/Δραστηριότητα μόνο';
$string['minute'] = 'λεπτό';
$string['minutes'] = 'λεπτά';
$string['mod_form_block_general'] = 'Γενικές ρυθμίσεις';
$string['mod_form_block_participants'] = 'Ρόλος που ανατίθεται κατά τη διάρκεια της συνόδου';
$string['mod_form_block_presentation'] = 'Περιεχόμενο παρουσίασης';
$string['mod_form_block_presentation_default'] = 'Προεπιλεγμένο περιεχόμενο παρουσίασης';
$string['mod_form_block_record'] = 'Ρυθμίσεις εγγραφής ήχου/βίντεο';
$string['mod_form_block_recordings'] = 'Προβολή για εγγραφή ήχου/βίντεο';
$string['mod_form_block_room'] = 'Ρυθμίσεις για Δραστηριότητα/Αίθουσα';
$string['mod_form_block_schedule'] = 'Χρονοπρόγραμμα για την σύνοδο';
$string['mod_form_field_closingtime'] = 'Κλείσιμο ένταξης';
$string['mod_form_field_conference_name'] = 'Όνομα της διάσκεψης';
$string['mod_form_field_disablecam'] = 'Απενεργοποίηση καμερών';
$string['mod_form_field_disablemic'] = 'Απενεργοποίηση μικροφώνων';
$string['mod_form_field_disablenote'] = 'Απενεργοποίηση κοινόχρηστων σημειώσεων';
$string['mod_form_field_disableprivatechat'] = 'Απενεργοποίηση ιδιωτικής γραπτής συνομιλίας';
$string['mod_form_field_disablepublicchat'] = 'Απενεργοποίηση δημόσιας γραπτής συνομιλίας';
$string['mod_form_field_duration'] = 'Διάρκεια';
$string['mod_form_field_duration_help'] = 'Ο καθορισμός της διάρκειας μιας συνάντησης θα καθορίσει το μέγιστο χρόνο διατήρησης ζωντανής της σύσκεψης πριν από τη λήξη της εγγραφής ήχου/βίντεο.';
$string['mod_form_field_hideuserlist'] = 'Απόκρυψη λίστας χρηστών';
$string['mod_form_field_instanceprofiles'] = 'Τύπος στιγμιοτύπου';
$string['mod_form_field_instanceprofiles_help'] = 'Επιλέξτε τον τύπο για αυτό το στιγμιότυπο BigBlueButton.';
$string['mod_form_field_intro'] = 'Περιγραφή';
$string['mod_form_field_intro_help'] = 'Μια σύντομη περιγραφή για την αίθουσα ή την διάσκεψη.';
$string['mod_form_field_lockonjoin'] = 'Αγνόηση ρυθμίσεων κλειδώματος';
$string['mod_form_field_muteonstart'] = 'Σίγαση στην έναρξη';
$string['mod_form_field_name'] = 'Όνομα εικονικής τάξης';
$string['mod_form_field_nosettings'] = 'Καμία ρύθμιση δεν μπορεί να τροποποιηθεί';
$string['mod_form_field_openingtime'] = 'Άνοιγμα ένταξης';
$string['mod_form_field_participant_add'] = 'Προσθήκη ανάθεσης';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Συντονιστής';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Θεατής';
$string['mod_form_field_participant_list'] = 'Λίστα ανάθεσης';
$string['mod_form_field_participant_list_action_add'] = 'Προσθήκη';
$string['mod_form_field_participant_list_action_remove'] = 'Διαγραφή';
$string['mod_form_field_participant_list_text_as'] = 'εντάσεται στη σύνοδο ως';
$string['mod_form_field_participant_list_type_all'] = 'Όλοι οι εγγεγραμμένοι χρήστες';
$string['mod_form_field_participant_list_type_owner'] = 'Ιδιοκτήτης';
$string['mod_form_field_participant_list_type_role'] = 'Ρόλος';
$string['mod_form_field_participant_list_type_user'] = 'Χρήστης';
$string['mod_form_field_record'] = 'Μπορεί να γίνει εγγραφή της συνόδου';
$string['mod_form_field_recordallfromstart'] = 'Εγγραφή όλων από την αρχή';
$string['mod_form_field_recordhidebutton'] = 'Απόκρυψη πλήκτρου εγγραφής';
$string['mod_form_field_recordings_deleted'] = 'Συμπερίληψη εγγραφών από διαγραμμένες δραστηριότητες';
$string['mod_form_field_recordings_html'] = 'Εμφάνιση του πίνακα σε απλή HTML';
$string['mod_form_field_recordings_imported'] = 'Εμφάνιση μόνο των εισαχθέντων συνδέσμων';
$string['mod_form_field_recordings_preview'] = 'Εμφάνιση προεπισκόπησης εγγραφής';
$string['mod_form_field_room_name'] = 'Όνομα αίθουσας';
$string['mod_form_field_userlimit'] = 'Όριο χρηστών';
$string['mod_form_field_userlimit_help'] = 'Μέγιστο όριο χρηστών που επιτρέπεται σε μια σύσκεψη. Αν το όριο έχει οριστεί σε 0, ο αριθμός των χρηστών θα είναι απεριόριστος.';
$string['mod_form_field_voicebridge'] = 'Γέφυρα φωνής [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Σφάλμα μορφότυπου. Θα πρέπει να εισαγάγετε έναν αριθμό μεταξύ 1 και 9999.';
$string['mod_form_field_voicebridge_help'] = 'Αριθμός φωνητικής διάσκεψης που εισάγουν οι συμμετέχοντες για να συμμετάσχουν στη φωνητική διάσκεψη όταν χρησιμοποιούν dial-in (αριθμό κλήσης). Πρέπει να πληκτρολογήσετε έναν αριθμό μεταξύ 1 και 9999. Εάν η τιμή είναι 0, ο στατικός αριθμός φωνητικής γέφυρας (voicebridge) θα αγνοηθεί και θα δημιουργηθεί ένας τυχαίος αριθμός από το BigBlueButton. Το ψηφίο 7 θα προηγείται των τεσσάρων ψηφίων που πληκτρολογούνται.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Μη μοναδική τιμή. Αυτός ο αριθμός χρησιμοποιείται από μια άλλη αίθουσα ή διάσκεψη.';
$string['mod_form_field_wait'] = 'Αναμονή για συντονιστή';
$string['mod_form_field_wait_help'] = 'Οι θεατές πρέπει να περιμένουν μέχρι να μπει ένας συντονιστής πριν να μπουν';
$string['mod_form_field_welcome'] = 'Μήνυμα καλωσορίσματος';
$string['mod_form_field_welcome_default'] = '<br>Καλώς ορίσατε στο <b>%%CONFNAME%%</b>!<br><br>Για βοήθεια σχετικά με τη χρήση του BigBlueButton δείτε αυτά τα (σύντομα) <a href="event:http://www.bigbluebutton.org/content/videos"><u>βίντεο εκμάθησης</u></a>.<br><br>Για να συμμετάσχετε στη γέφυρα ήχου, κάντε κλικ στο εικονίδιο του τηλεφώνου (επάνω κέντρο).<b>Παρακαλούμε, χρησιμοποιήστε ένα ακουστικό για να αποφύγετε τη δημιουργία θορύβου στο παρασκήνιο για άλλους.</b>';
$string['mod_form_field_welcome_help'] = 'Αντικαθιστά το προεπιλεγμένο μήνυμα που έχει οριστεί για τον εξυπηρετητή BigBlueButton. Το μήνυμα μπορεί να περιλαμβάνει λέξεις-κλειδιά (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%) τα οποία θα αντικατασταθούν αυτόματα, καθώς και ετικέτες html όπως <b>...</b> ή <i></i>';
$string['mod_form_locksettings'] = 'Κλείδωμα ρυθμίσεων';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'Το άρθρωμα BigBlueButton (σύστημα τηλεδιάσκεψης/ιστοδιάσκεψης «Μεγάλο Μπλε Πλήκτρο» από την εταιρία Blindside Networks) σας επιτρέπει να δημιουργείτε μέσα από τις συνδέσεις του Moodle συνδέσμους προς αίθουσες διδασκαλίας εντός σύνδεσης σε πραγματικό χρόνο χρησιμοποιώντας το BigBlueButton, ένα σύστημα ανοιχτού κώδικα διασκέψεων μέσω ιστού για εξ αποστάσεως εκπαίδευση.

Χρησιμοποιώντας το BigBlueButton μπορείτε να καθορίσετε τον τίτλο, την περιγραφή, την καταχώρηση ημερολογίου (που δίνει ένα εύρος ημερομηνιών για ένταξη στη σύνοδο), τις ομάδες και τις λεπτομέρειες σχετικά με την εγγραφή της συνόδου εντός σύνδεσης.';
$string['modulename_link'] = '';
$string['modulenameplural'] = 'BigBlueButton';
$string['pluginadministration'] = 'Διαχείριση BigBlueButton';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'Για τη δημιουργία και την ένταξη σε συνόδους BigBlueButton, χρειάζεται ανταλλαγή δεδομένων με τον εξυπηρετητή.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'Το πλήρες όνομα του χρήστη που αποκτά πρόσβαση στον εξυπηρετητή BigBlueButton.';
$string['privacy:metadata:bigbluebutton:userid'] = 'Το αναγνωριστικό χρήστη του χρήστη που αποκτά πρόσβαση στον εξυπηρετητή BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Αποθηκεύει τις ρυθμίσεις για την τάξη ή τη δραστηριότητα, που καθορίζουν τις δυνατότητες και τη γενική συμπεριφορά της συνόδου BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Μια λίστα κανόνων που καθορίζουν το ρόλο που θα έχουν οι χρήστες στη ζωντανή συνάντηση. Μπορεί να αποθηκευτεί ένα αναγνωριστικό χρήστη καθώς μπορούν να εκχωρηθούν δικαιώματα ανά ρόλο ή χρήστη.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Αποθηκεύει γεγονότα που προκλήθηκαν κατά την χρήση του πρόσθετου.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Ο τύπος του γεγονότος που προκλήθηκε από τον χρήστη.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'Το αναγνωριστικό συνάντησης στην οποία ο χρήστης είχε πρόσβαση.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Μπορεί να περιλαμβάνει επιπλέον πληροφορίες σχετικά με τη συνάντηση ή την εγγραφή ήχου/βίντεο που επηρεάζεται από την εκδήλωση.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Ο χρόνος στον οποίο οι καταγραφές δημιουργήθηκαν.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'Το αναγνωριστικό χρήστη του χρήστη που προκάλεσε το γεγονός.';
$string['removedevents'] = 'Διαγραμμένα γεγονότα';
$string['removedlogs'] = 'Διαγραμμένες προσαρμοσμένες καταγραφές';
$string['removedrecordings'] = 'Διαγραμμένες εγγραφές ήχου/βίντεο';
$string['removedtags'] = 'Διαγραμμένες ετικέτες';
$string['resetevents'] = 'Διαγραμμένα γεγονότα';
$string['resetlogs'] = 'Διαγραφή προσαρμοσμένων καταγραφών';
$string['resetlogs_help'] = 'Διαγραφή των καταγραφών θα προκαλέσει απώλεια των μέσων πρόσβασης (αναφορών) στις εγγραφές ήχου/βίντεο';
$string['resetrecordings'] = 'Διαγραφή εγγραφών ήχου/βίντεο';
$string['resetrecordings_help'] = 'Διαγραφή των εγγραφών ήχου/βίντεο θα τις κάνει μη προσβάσιμες από οπουδήποτε και δεν μπορεί να αναρεθεί';
$string['resettags'] = 'Διαγραφή ετικετών';
$string['search:activity'] = 'BigBlueButton - πληροφορίες δραστηριότητας';
$string['search:tags'] = 'BigBlueButton - πληροφορίες ετικετών';
$string['sendnotification'] = 'Αποστολή ειδοποίησης';
$string['started_at'] = 'Ξεκίνησε';
$string['starts_at'] = 'Ξεκινά';
$string['view_conference_action_end'] = 'Τέλος συνόδου';
$string['view_conference_action_join'] = 'Ένταξη στη σύνοδο';
$string['view_error_action_not_completed'] = 'Η ενέργεια δεν μπορούσε να ολοκληρωθεί';
$string['view_error_bigbluebutton'] = 'Το BigBlueButton αποκρίθηκε με σφάλματα. {$a}';
$string['view_error_create'] = 'Ο εξυπηρετητής BigBlueButton απάντησε με ένα μήνυμα σφάλματος, δεν είναι δυνατή η δημιουργία της συνάντησης.';
$string['view_error_current_state_not_found'] = 'Η τρέχουσα κατάσταση δεν βρέθηκε. Η εγγραφή ήχου/βίντεο μπορεί να έχει διαγραφεί ή ο εξυπηρετητής BigBlueButton δεν είναι συμβατός με την ενέργεια που εκτελέστηκε.';
$string['view_error_import_no_courses'] = 'Δεν υπάρχουν μαθήματα για να ερευνηθούν για εγγραφές ήχου/βίντεο';
$string['view_error_import_no_recordings'] = 'Δεν υπάρχουν εγγραφές σε αυτό το μάθημα προς εισαγωγή';
$string['view_error_invalid_session'] = 'Η σύνοδος έχει λήξει. Μεταβείτε στην κύρια σελίδα της δραστηριότητας.';
$string['view_error_max_concurrent'] = 'Έχει συμπληρωθεί ο επιτρεπόμενος αριθμός ταυτόχρονων συναντήσεων.';
$string['view_error_meeting_not_running'] = 'Κάτι δεν πήγε καλά. Η συνάντηση δεν λαμβάνει χώρα.';
$string['view_error_no_group'] = 'Δεν έχουν διαμορφωθεί ακόμα ομάδες. Παρακαλούμε ρυθμίστε τις ομάδες πριν προσπαθήσετε να ενταχθείτε στη σύσκεψη.';
$string['view_error_no_group_student'] = 'Δεν έχετε εγγραφεί σε μια ομάδα. Παρακαλούμε, επικοινωνήστε με τον Διδάσκοντα ή τον Διαχειριστή σας.';
$string['view_error_no_group_teacher'] = 'Δεν υπάρχει καμία διαμορφωμένη ομάδα ακόμη. Παρακαλούμε, ρυθμίστε ομάδες ή επικοινωνήστε με τον Διαχειριστή.';
$string['view_error_unable_join'] = 'Δεν είναι δυνατή η ένταξή σας στη συνάντηση. Παρακαλούμε ελέγξτε τη διεύθυνση URL του εξυπηρετητή BigBlueButton ΚΑΙ ελέγξτε αν ο εξυπηρετητής BigBlueButton εκτελείται.';
$string['view_error_unable_join_student'] = 'Δεν είναι δυνατή η σύνδεση με τον εξυπηρετητή BigBlueButton. Παρακαλούμε, επικοινωνήστε με τον διδάσκοντά σας ή το διαχειριστή.';
$string['view_error_unable_join_teacher'] = 'Δεν είναι δυνατή η σύνδεση με τον εξυπηρετητή BigBlueButton. Παρακαλούμε, επικοινωνήστε με τον διαχειριστή.';
$string['view_error_url_missing_parameters'] = 'Λείπουν παράμετροι από αυτή τη διεύθυνση URL';
$string['view_error_userlimit_reached'] = 'Ο αριθμός των χρηστών που επιτρέπεται σε μια συνάντηση έχει συμπληρωθεί.';
$string['view_groups_nogroups_warning'] = 'Η αίθουσα ρυθμίστηκε για χρήση ομάδων, αλλά το μάθημα δεν έχει καθορισμένες ομάδες.';
$string['view_groups_notenrolled_warning'] = 'Η αίθουσα ρυθμίστηκε για χρήση ομάδων, αλλά δεν έχετε εγγραφεί σε καμία από αυτές.';
$string['view_groups_selection'] = 'Επιλέξτε την ομάδα στην οποία θέλετε να ενταχθείτε και επιβεβαιώστε την ενέργεια';
$string['view_groups_selection_join'] = 'Ένταξη';
$string['view_groups_selection_warning'] = 'Υπάρχει αίθουσα διασκέψεων για κάθε ομάδα και έχετε πρόσβαση σε περισσότερες από μία. Φροντίστε να επιλέξετε τη σωστή.';
$string['view_login_moderator'] = 'Σύνδεση ως συντονιστής...';
$string['view_login_viewer'] = 'Σύνδεση ως θεατής...';
$string['view_message_and'] = 'και';
$string['view_message_conference_has_ended'] = 'Η διάσκεψη αυτή έχει τελειώσει.';
$string['view_message_conference_in_progress'] = 'Αυτή η διάσκεψη είναι σε εξέλιξη.';
$string['view_message_conference_not_started'] = 'Αυτή η διάσκεψη δεν έχει ξεκινήσει ακόμα.';
$string['view_message_conference_room_ready'] = 'Αυτή η αίθουσα διάσκεψης είναι έτοιμη. Μπορείτε να ενταχθείτε τώρα στην σύνοδο.';
$string['view_message_conference_wait_for_moderator'] = 'Αναμονή για να ενταχθεί ένας συντονιστής.';
$string['view_message_finished'] = 'Η δραστηριότητα αυτή έχει τελειώσει.';
$string['view_message_has_joined'] = 'έχει ενταχθεί';
$string['view_message_have_joined'] = 'έχουν ενταχθεί';
$string['view_message_hour'] = 'ώρα';
$string['view_message_hours'] = 'ώρες';
$string['view_message_importrecordings_disabled'] = 'Η δυνατότητα για συνδέσμους εισαγωγής εγγραφής ήχου/βίντεο είναι απενεργοποιημένη σε αυτόν τον εξυπηρετητή.';
$string['view_message_minute'] = 'λεπτό';
$string['view_message_minutes'] = 'λεπτά';
$string['view_message_moderator'] = 'συντονιστής';
$string['view_message_moderators'] = 'συντονιστές';
$string['view_message_norecordings'] = 'Δεν υπάρχει καμία εγγραφή ήχου/βίντεο.';
$string['view_message_notavailableyet'] = 'Αυτή η σύνοδος δεν είναι ακόμη διαθέσιμη.';
$string['view_message_recordings_disabled'] = 'Οι εγγραφές ήχου/βίντεο απενεργοποιήθηκαν σε αυτόν τον εξυπηρετητή. Τα στιγμιότυπα BigBlueButton για εγγραφές ήχου/βίντεο μόνο δεν μπορούν να χρησιμοποιηθούν.';
$string['view_message_room_closed'] = 'Αυτή η αίθουσα έχει κλείσει.';
$string['view_message_room_open'] = 'Αυτή η αίθουσα είναι ανοιχτή.';
$string['view_message_room_ready'] = 'Αυτή η αίθουσα είναι έτοιμη.';
$string['view_message_session_for'] = 'την σύνοδο για';
$string['view_message_session_has_user'] = 'Υπάρχει';
$string['view_message_session_has_users'] = 'Υπάρχουν';
$string['view_message_session_no_users'] = 'Δεν υπάρχουν χρήστες σε αυτή τη σύνοδο';
$string['view_message_session_running_for'] = 'Αυτή η σύνοδος τρέχει εδώ και';
$string['view_message_session_started_at'] = 'Αυτή η σύνοδος ξεκίνησε στις';
$string['view_message_tab_close'] = 'Αυτή η καρτέλα/παράθυρο πρέπει να κλείσει χειροκίνητα';
$string['view_message_times'] = 'φορές';
$string['view_message_user'] = 'χρήστης';
$string['view_message_users'] = 'χρήστες';
$string['view_message_viewer'] = 'θεατής';
$string['view_message_viewers'] = 'θεατές';
$string['view_mobile_message_groups_not_supported'] = 'Αυτό το στιγμιότυπο είναι ενεργοποιημένο για να λειτουργήσει με ομάδες, αλλά η εφαρμογή για κινητά δεν το υποστηρίζει. Παρακαλούμε, ανοίξτε το σε (επιτραπέζιο) Η/Υ εάν θέλετε να χρησιμοποιήσετε την υποστήριξη ομάδας.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Έχετε υπερβεί τα 45 δευτερόλεπτα σε αυτή τη σελίδα. Παρακαλούμε, ξαναφορτώστε τη σελίδα για να ενταχθείτε σωστά στη διάσκεψη.';
$string['view_noguests'] = 'Το BigBlueButton δεν είναι ανοιχτό για επισκέπτες';
$string['view_nojoin'] = 'Δεν είστε σε έναν ρόλο που επιτρέπεται να ενταχθεί σε αυτήν την σύνοδο.';
$string['view_recording'] = 'εγγραφή ήχου/βίντεο';
$string['view_recording_actionbar'] = 'Γραμμή εργαλείων';
$string['view_recording_activity'] = 'Δραστηριότητα';
$string['view_recording_button_import'] = 'Εισαγωγή συνδέσμων εγγραφών ήχου/βίντεο';
$string['view_recording_button_return'] = 'Επιστροφή';
$string['view_recording_course'] = 'Μάθημα';
$string['view_recording_date'] = 'Ημερομηνία';
$string['view_recording_delete_confirmation'] = 'Σίγουρα θέλετε να διαγράψετε αυτήν την {$a};';
$string['view_recording_delete_confirmation_warning_p'] = 'Αυτή η ηχογράφηση έχει {$a} συνδέσμους συσχετισμένους που έχουν εισαχθεί σε διαφορετικά μαθήματα ή δραστηριότητες. Εάν διαγραφεί η ηχογράφηση, θα αφαιρεθούν επίσης αυτοί οι σύνδεσμοι.';
$string['view_recording_delete_confirmation_warning_s'] = 'Αυτή η ηχογράφηση έχει {$a} σύνδεσμο συσχετισμένο που έχει εισαχθεί σε διαφορετικό μάθημα ή δραστηριότητα. Εάν η ηχογράφηση διαγραφεί, θα διαγραφεί επίσης και ο σύνδεσμος αυτός.';
$string['view_recording_description'] = 'Περιγραφή';
$string['view_recording_duration'] = 'Διάρκεια';
$string['view_recording_duration_min'] = 'λεπτά';
$string['view_recording_format_errror_unreachable'] = 'Δεν είναι δυνατή η πρόσβαση στη διεύθυνση URL για αυτόν τον μορφότυπο εγγραφής.';
$string['view_recording_format_notes'] = 'Σημειώσεις';
$string['view_recording_format_podcast'] = 'Podcast (Διαδικτυακή εκπομπή σειράς αρχείων)';
$string['view_recording_format_presentation'] = 'Παρουσίαση';
$string['view_recording_format_screenshare'] = 'Διαμοιρασμός οθόνης';
$string['view_recording_format_statistics'] = 'Στατιστικά';
$string['view_recording_format_video'] = 'Βίντεο';
$string['view_recording_import_confirmation'] = 'Σίγουρα να εισαχθεί αυτή η εγγραφή ήχου/βίντεο;';
$string['view_recording_length'] = 'Μήκος';
$string['view_recording_link'] = 'εισαχθείς σύνδεσμος';
$string['view_recording_link_warning'] = 'Αυτός είναι ένας σύνδεσμος που δείχνει σε μια εγγραφή ήχου/βίντεο που δημιουργήθηκε σε ένα διαφορετικό μάθημα ή δραστηριότητα';
$string['view_recording_list_action_delete'] = 'Διαγραφή';
$string['view_recording_list_action_edit'] = 'Ενημέρωση';
$string['view_recording_list_action_play'] = 'Αναπαραγωγή';
$string['view_recording_list_action_process'] = 'Επεξεργασία...';
$string['view_recording_list_action_protect'] = 'Προστασία...';
$string['view_recording_list_action_publish'] = 'Δημοσίευση';
$string['view_recording_list_action_unprotect'] = 'Λήψη προστασίας';
$string['view_recording_list_action_unpublish'] = 'Παύση δημοσίευσης';
$string['view_recording_list_action_update'] = 'Ενημέρωση';
$string['view_recording_list_actionbar'] = 'Γραμμή εργαλείων';
$string['view_recording_list_actionbar_delete'] = 'Διαγραφή';
$string['view_recording_list_actionbar_edit'] = 'Επεξεργασία';
$string['view_recording_list_actionbar_hide'] = 'Απόκρυψη';
$string['view_recording_list_actionbar_import'] = 'Εισαγωγή';
$string['view_recording_list_actionbar_protect'] = 'Να γίνει ιδιωτικό';
$string['view_recording_list_actionbar_publish'] = 'Δημοσίευση';
$string['view_recording_list_actionbar_show'] = 'Εμφάνιση';
$string['view_recording_list_actionbar_unprotect'] = 'Δημοσίευση';
$string['view_recording_list_actionbar_unpublish'] = 'Παύση δημοσίευσης';
$string['view_recording_list_activity'] = 'Δραστηριότητα';
$string['view_recording_list_course'] = 'Μάθημα';
$string['view_recording_list_date'] = 'Ημερομηνία';
$string['view_recording_list_description'] = 'Περιγραφή';
$string['view_recording_list_duration'] = 'Διάρκεια';
$string['view_recording_list_recording'] = 'Εγγραφή ήχου/βίντεο';
$string['view_recording_meeting'] = 'Συνάντηση';
$string['view_recording_modal_button'] = 'Εφαρμογή';
$string['view_recording_modal_title'] = 'Ορισμός τιμών για εγγραφή';
$string['view_recording_name'] = 'Όνομα';
$string['view_recording_playback'] = 'Αναπαραγωγή';
$string['view_recording_preview'] = 'Προεπισκόπηση';
$string['view_recording_preview_help'] = 'Αιωρήστε τον δείκτη του ποντικιού πάνω σε μια εικόνα για προβολή της σε πλήρες μέγεθος';
$string['view_recording_publish_link_deleted'] = 'Δεν είναι δυνατή η εκ νέου δημοσίευση αυτού του συνδέσμου επειδή η πραγματική εγγραφή δεν υπάρχει στον τρέχοντα εξυπηρετητή BigBlueButton. Ο σύνδεσμος πρέπει να καταργηθεί.';
$string['view_recording_publish_link_not_published'] = 'Δεν είναι δυνατή η εκ νέου δημοσίευση αυτού του συνδέσμου επειδή η πραγματική εγγραφή δεν έχει δημοσιευτεί';
$string['view_recording_recording'] = 'Εγγραφή';
$string['view_recording_tags'] = 'Ετικέτες';
$string['view_recording_unprotect_link_deleted'] = 'Δεν είναι δυνατή η αφαίρεση προστασίας αυτού του συνδέσμου επειδή η πραγματική εγγραφή δεν υπάρχει στον τρέχοντα εξυπηρετητή BigBlueButton. Ο σύνδεσμος πρέπει να καταργηθεί.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Δεν είναι δυνατή η αφαίρεση προστασίας αυτού του συνδέσμου, επειδή η πραγματική εγγραφή προστατεύεται';
$string['view_recording_unpublish_confirmation'] = 'Σίγουρα να καταργηθεί αυτή η εγγραφή {$a};';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Αυτή η ηχογράφηση έχει {$a} συνδέσμους συσχετισμένους που έχουν εισαχθεί σε διαφορετικά μαθήματα ή δραστηριότητες. Εάν η εγγραφή πάψει να είναι δημοσιευμένη, θα πάψουν επίσης να είναι δημοσιευμένοι και οι σύνδεσμοι.';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Αυτή η ηχογράφηση έχει {$a} σύνδεσμο συσχετισμένο που έχει εισαχθεί σε διαφορετικό μάθημα ή δραστηριότητα. Εάν η εγγραφή πάψει να είναι δημοσιευμένη, θα πάψει επίσης να είναι δημοσιευμένος και ο σύνδεσμος αυτός.';
$string['view_recording_yui_first'] = 'Πρώτο';
$string['view_recording_yui_go'] = 'Μετάβαση';
$string['view_recording_yui_last'] = 'Τελευταία';
$string['view_recording_yui_next'] = 'Επόμενη';
$string['view_recording_yui_page'] = 'Σελίδα';
$string['view_recording_yui_prev'] = 'Προηγούμενη';
$string['view_recording_yui_rows'] = 'Γραμμές';
$string['view_recording_yui_show_all'] = 'Εμφάνιση όλων';
$string['view_room'] = 'Εμφάνιση αίθουσας';
$string['view_section_title_presentation'] = 'Αρχείο παρουσίασης';
$string['view_section_title_recordings'] = 'Εγγραφές';
$string['view_warning_default_server'] = 'Αυτός ο εξυπηρετητής Moodle κάνει χρήση του δοκιμαστικού εξυπηρετητή BigBlueButton που έρχεται προ-ρυθμισμένος ως προεπιλογή. Θα πρέπει να αντικατασταθεί για παραγωγικό περιβάλλον.';
