<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'no', version '4.0'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.block_myoverview.browseallcourses'] = 'Bla gjennom alle kurs';
$string['addon.block_myoverview.nocoursesenrolled'] = 'Du er ikke påmeldt noen kurs ennå.';
$string['addon.block_myoverview.nocoursesenrolleddescription'] = 'Bla gjennom alle tilgjengelige kurs nedenfor og begynn å lære.';
$string['addon.block_myoverview.noresult'] = 'Søket ditt samsvarte ikke med noen kurs.';
$string['addon.block_myoverview.noresultdescription'] = 'Prøv å justere filtrene dine eller bla gjennom alle kursene nedenfor.';
$string['addon.blog.errorloadentries'] = 'Feil ved innlasting av blogginnlegg.';
$string['addon.blog.showonlyyourentries'] = 'Vis bare dine innlegg';
$string['addon.calendar.calendarevent'] = 'Kalenderhendelse';
$string['addon.calendar.calendarevents'] = 'Kalenderhendelser';
$string['addon.calendar.calendarreminders'] = 'Kalenderpåminnelse';
$string['addon.calendar.currentmonth'] = 'Gjeldende måned';
$string['addon.calendar.defaultnotificationtime'] = 'Standard varslingstid';
$string['addon.calendar.errorloadevent'] = 'Feil ved lasting av hendelse';
$string['addon.calendar.errorloadevents'] = 'Feil ved lasting av hendelser';
$string['addon.calendar.noevents'] = 'Det er ingen hendelser';
$string['addon.calendar.reminders'] = 'Påminnelser';
$string['addon.calendar.setnewreminder'] = 'Angi ny påminnelse';
$string['addon.calendar.timebefore'] = '{{value}} {{units}} før';
$string['addon.competency.errornocompetenciesfound'] = 'Ingen kompetansemål funnet';
$string['addon.competency.nocompetencies'] = 'Ingen kompetansemål';
$string['addon.coursecompletion.complete'] = 'Fullfør';
$string['addon.coursecompletion.couldnotloadreport'] = 'Kunne ikke laste kursets fullføringssrapport. Prøv igjen senere.';
$string['addon.enrol_self.confirmselfenrol'] = 'Er du sikker på at du vil melde deg på dette kurset?';
$string['addon.enrol_self.errorselfenrol'] = 'En feil oppstod under egenpåmeldingen';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Konfigurer enheter';
$string['addon.messageoutput_airnotifier.pushdisabledwarning'] = 'Brukerne dine mottar ingen varsler fra dette nettstedet på sine mobile enheter. Aktiver mobilvarsler på siden for varslingsinnstillinger.';
$string['addon.messages.contactlistempty'] = 'Kontaktlisten er tom';
$string['addon.messages.contactname'] = 'Navn på kontakt';
$string['addon.messages.deletemessage'] = 'Slett melding';
$string['addon.messages.deletemessageconfirmation'] = 'Er du sikker på at du vil slette denne meldingen? Den blir bare slettet fra meldingsloggen din og kan fremdeles vises av brukeren som sendte eller mottok meldingen.';
$string['addon.messages.errordeletemessage'] = 'Feil ved sletting av melding';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Feil ved henting av kontakter fra server';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Feil ved henting av diskusjoner fra server';
$string['addon.messages.errorwhileretrievingmessages'] = 'Feil ved henting av meldinger fra server';
$string['addon.messages.errorwhileretrievingusers'] = 'Feil under henting av brukere fra serveren.';
$string['addon.messages.messagenotsent'] = 'Meldingen ble ikke sendt. Prøv igjen senere';
$string['addon.messages.newmessages'] = 'Nye meldinger';
$string['addon.messages.nousersfound'] = 'Ingen brukere funnet';
$string['addon.messages.showdeletemessages'] = 'Vis slettede meldinger';
$string['addon.messages.type_blocked'] = 'Blokkert';
$string['addon.messages.type_offline'] = 'Offline';
$string['addon.messages.type_online'] = 'Online';
$string['addon.messages.type_search'] = 'Søkeresultat';
$string['addon.messages.type_strangers'] = 'Andre';
$string['addon.messages.useentertosenddescdesktop'] = 'Hvis deaktivert, kan du bruke Ctrl+Enter for å sende meldingen.';
$string['addon.messages.useentertosenddescmac'] = 'Hvis deaktivert, kan du bruke Ctrl+Enter for å sende meldingen.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Kunne ikke sende meldingen(e) til samtale {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Kunne ikke sende melding(er) til {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Vennligst godta innsendingserklæringen.';
$string['addon.mod_assign.allowsubmissionsanddescriptionfromdatesummary'] = 'Oppgavedetaljene og innleveringsskjemaet vil være tilgjengelig fra <strong>{{$a}}</strong>';
$string['addon.mod_assign.allowsubmissionsfromdatesummary'] = 'Denne oppgaven godtar innleveringer fra <strong>{{$a}}</strong>';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Du kan ikke legge til eller redigere en innsending i appen fordi innsendingserklæringen ikke kunne hentes fra nettstedet.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Noen karaktermetoder er ikke støttet av appen og kan ikke endres';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Du kan ikke foreta en innlevering i appen fordi innsendingserklæringen ikke kunne hentes fra nettstedet.';
$string['addon.mod_assign.duedateno'] = 'Ingen forfallsdato';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Du kan ikke legge til eller endre bidrag i appen fordi noen plugins ikke støtter redigering:';
$string['addon.mod_assign.errorshowinginformation'] = 'Innleveringsinformasjonen kan ikke vises.';
$string['addon.mod_assign.feedbacknotsupported'] = 'Denne tilbakemeldingen er ikke støttet av appen og vil derfor kunne mangle informasjon.';
$string['addon.mod_assign.gradenotsynced'] = 'Karakter ikke synkronisert';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Deltakere som ikke har innlevert noe vises ikke.';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'Det er {{count}} utkast.';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'Det er {{count}} deltakere.';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'Det er {{count}} innleveringer som trenger karakter.';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'Det er {{count}} innleverte oppgaver.';
$string['addon.mod_assign.numberofteamscountdescription'] = 'Det er {{count}} team.';
$string['addon.mod_assign.submissionnotsupported'] = 'Denne innsendingen støttes ikke av appen og inneholder kanskje ikke all informasjonen.';
$string['addon.mod_assign.syncblockedusercomponent'] = 'brukerkarakter';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'Karakteren på innleveringen ble endret på portalen.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'Brukerinnleveringen ble endret på portalen.';
$string['addon.mod_chat.confirmloss'] = 'Er du sikker? Chathistorikk kan gå tapt.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Feil under tilkobling til chatten.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Feil under henting av chattedata.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Feil under henting av chat-brukere.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Feil ved henting av melding fra server.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Melding kunne ikke sendes.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Du må være på nett for å sende meldinger.';
$string['addon.mod_chat.nosessionsfound'] = 'Ingen økter funnet';
$string['addon.mod_chat.showincompletesessions'] = 'Vis ufullstendige økter';
$string['addon.mod_choice.errorgetchoice'] = 'Feil ved henting av gallup-data.';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% av brukerne velger dette alternativet: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Det siste svaret ditt må synkroniseres før det inkluderes i resultatene.';
$string['addon.mod_data.edittagsnotsupported'] = 'Beklager, redigering av tagger støttes ikke av appen.';
$string['addon.mod_data.errorapproving'] = 'Feil ved godkjenning eller underkjenning av oppføring.';
$string['addon.mod_data.errordeleting'] = 'Feil ved sletting av oppføring';
$string['addon.mod_data.gettinglocation'] = 'Henter plassering';
$string['addon.mod_data.locationnotenabled'] = 'Plassering er ikke aktivert';
$string['addon.mod_data.locationpermissiondenied'] = 'Tillatelse til å få tilgang til posisjonen din er avslått.';
$string['addon.mod_data.mylocation'] = 'Min posisjon';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Beklager, men søk via tagger støttes ikke i appen.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Tilbakemelding med CAPTCHA kan ikke fullføres offline, eller hvis den ikke er konfigurert, eller hvis serveren er nede.';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = 'Det er {{count}} innsendte svar.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Denne tilbakemeldingen er lagret for å bli sendt inn senere.';
$string['addon.mod_feedback.questionscountdescription'] = 'Det er {{count}} spørsmål.';
$string['addon.mod_folder.emptyfilelist'] = 'Det er ingen filer å vise.';
$string['addon.mod_forum.errorgetforum'] = 'Feil ved henting av forumdata';
$string['addon.mod_forum.errorgetgroups'] = 'Feil ved henting av gruppeinnstillinger.';
$string['addon.mod_forum.errorloadingsortingorder'] = 'Forum ikke tilgjengelig i denne sorteringsrekkefølgen';
$string['addon.mod_forum.errorloadingsortingorderdetails'] = 'Prøv å endre sorteringsrekkefølgen eller gå online for å se dette forumet.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Kunne ikke opprette nye diskusjoner i alle grupper';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Det er foreløpig ingen diskusjonsemner i dette forumet.';
$string['addon.mod_forum.group'] = 'Gruppe';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} diskusjoner';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} svar';
$string['addon.mod_forum.postingroup'] = 'Poster i gruppen "{{groupname}}".';
$string['addon.mod_forum.refreshposts'] = 'Oppdater innlegg';
$string['addon.mod_glossary.browsemode'] = 'Bla i oppføringer';
$string['addon.mod_glossary.byalphabet'] = 'Alfabetisk';
$string['addon.mod_glossary.byauthor'] = 'Gruppér etter forfatter';
$string['addon.mod_glossary.bycategory'] = 'Gruppér etter kategori';
$string['addon.mod_glossary.bynewestfirst'] = 'Nyeste først';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Nylig oppdatert';
$string['addon.mod_glossary.bysearch'] = 'Søk';
$string['addon.mod_glossary.cannoteditentry'] = 'Kan ikke redigere oppføring';
$string['addon.mod_glossary.entriestobesynced'] = 'Oppføringer som skal synkroniseres';
$string['addon.mod_glossary.entrypendingapproval'] = 'Denne oppføringen venter på godkjenning';
$string['addon.mod_glossary.errordeleting'] = 'Feil ved sletting av oppføring';
$string['addon.mod_glossary.errorloadingentries'] = 'Feil ved lasting av oppføringer.';
$string['addon.mod_glossary.errorloadingentry'] = 'Feil ved lasting av oppføringen.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Feil ved lasting av ordliste';
$string['addon.mod_glossary.noentriesfound'] = 'Ingen oppføringer funnet';
$string['addon.mod_glossary.searchquery'] = 'Søkeord';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Last ned H5P-fil';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Feil ved henting av H5P aktivitetsdata';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'H5P-pakken er ikke lastet ned. Du må laste den ned først for å kunne bruke den.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'H5P-pakken er endret siden forrige nedlasting. Du må laste den ned på nytt for å kunne bruke den.';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'Du må være online for å vise H5P-pakken.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Vis forsøk {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Vis beskrivelse';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Denne leksjonen inneholder et hopp til en tilfeldig innholdsside. Det kan ikke forsøkes i appen før den er startet i en nettleser.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Dette forsøket kan ikke lenger vurderes fordi et annet forsøk er fullført.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Dette forsøket ble avsluttet uten nett.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Et offline-forsøk ble synkronisert. Vil du se gjennom det?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Forsøket ble avsluttet på portalen.';
$string['addon.mod_lti.errorgetlti'] = 'Feil ved henting av moduldata.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'Startadressen er ikke gyldig.';
$string['addon.mod_lti.launchactivity'] = 'Start aktiviteten';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Feil ved lasting av sideinnholdet.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Du kan prøve denne quizen i appen, men du må sende inn forsøket i nettleseren av følgende årsaker:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Dette quizforsøket kan ikke sendes inn av følgende grunner:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Dette forsøket har ikke blitt synkronisert siden {{$a}}. Hvis du har fortsatt dette forsøket på en annen enhet siden den gang, kan du miste data.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Det oppstod en feil under lagring av svarene. Er du sikker på at du vil forlate quizen?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Denne quizen kan ikke forsøkes i appen fordi spørsmålstypen ikke støttes av appen:';
$string['addon.mod_quiz.errordownloading'] = 'Feil ved nedlasting av nødvendige data.';
$string['addon.mod_quiz.errorgetattempt'] = 'Feil ved innhenting av forsøksdata.';
$string['addon.mod_quiz.errorgetquestions'] = 'Feil ved henting av spørsmål.';
$string['addon.mod_quiz.errorgetquiz'] = 'Feil ved henting av Quiz-data.';
$string['addon.mod_quiz.errorparsequestions'] = 'Det oppstod en feil under lesing av spørsmålene. Vennligst prøv denne quizen i en nettleser i stedet.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Denne quizen kan ikke forsøkes i appen fordi den bare inneholder spørsmåltyper som ikke støttes av appen:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Denne quizen kan ikke forsøkes i appen fordi den har tilgangsregler som ikke støttes av appen:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Det oppstod en feil under lagring av forsøksdataene.';
$string['addon.mod_quiz.finishnotsynced'] = 'Fullført, men ikke synkronisert';
$string['addon.mod_quiz.opentoc'] = 'Åpne navigasjonsvindu';
$string['addon.mod_quiz.warningattemptfinished'] = 'Frakoblet forsøk kastes ettersom det var fullført på portalen eller ikke ble funnet.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Noen offline svar ble kastet fordi spørsmålene ble endret online.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Forsøk ble ufullstendig fordi noen offline svar ble vraket. Gjennomgå svarene dine, og send deretter forsøket på nytt.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Denne quizen inneholder spørsmålstyper som ikke støttes av appen:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Feil under innlasting av innholdet.';
$string['addon.mod_resource.openthefile'] = 'Åpne';
$string['addon.mod_resource.resourcestatusoutdated'] = 'Denne filen har endret seg siden du sist åpnet den.';
$string['addon.mod_resource.resourcestatusoutdatedconfirm'] = 'Det er en nyere versjon av denne filen. For å se den må du koble enheten til internett.';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Karakteren kunne ikke beregnes.';
$string['addon.mod_scorm.dataattemptshown'] = 'Disse dataene tilhører forsøksnummeret {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Det oppsto en feil under opprettelsen av et nytt offline forsøk. Vennligst prøv på nytt.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Feil ved nedlasting av SCORM: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Feil ved henting av SCORM-data.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Beklager, applikasjonen støtter bare SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Nedlastingen av SCORM-pakker er deaktivert. Kontakt nettstedsadministratoren.';
$string['addon.mod_scorm.errornovalidsco'] = 'Denne SCORM-pakken har ikke en synlig SCO å laste inn.';
$string['addon.mod_scorm.errorpackagefile'] = 'Beklager, applikasjonen støtter bare ZIP-pakker.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Det oppsto en feil under synkroniseringen. Vennligst prøv på nytt.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Dette forsøket har data som ikke er synkronisert.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Dette forsøket kan ikke sendes fordi du overskred maksimalt antall forsøk.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Denne SCORM-pakken lastes ikke ned. Den lastes ned automatisk når du åpner den.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Denne SCORM-pakken er endret siden forrige nedlasting. Den lastes ned automatisk når du åpner den.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Noen frakoblede data fra forsøk {{number}} er forkastet fordi de ikke kunne telles som et nytt forsøk.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Noen forsøk kunne ikke synkroniseres med portalen fordi det siste online-forsøket ennå ikke er fullført. Fullfør på portalen først.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Beklager, det oppsto et problem med å sende undersøkelsen. Vennligst prøv på nytt.';
$string['addon.mod_survey.errorgetsurvey'] = 'Feil ved henting av undersøkelsesdata.';
$string['addon.mod_survey.results'] = 'Resultater';
$string['addon.mod_url.accessurl'] = 'Åpne URL';
$string['addon.mod_url.pointingtourl'] = 'URL som ressursen peker til.';
$string['addon.mod_wiki.errorloadingpage'] = 'En feil oppstod under lasting av siden.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Denne Wikien har ikke noe innhold ennå.';
$string['addon.mod_wiki.gowikihome'] = 'Gå til Wikiens førsteside';
$string['addon.mod_wiki.subwiki'] = 'Sub-Wiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Tittel kan ikke være blank';
$string['addon.mod_wiki.viewpage'] = 'Vis side';
$string['addon.mod_wiki.wikipage'] = 'Wikiside';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Vurderingsstrategi {{$a}} støttes ikke';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Du må skrive inn en tittel';
$string['addon.mod_workshop.warningassessmentmodified'] = 'Innleveringen er endret på portalen.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'Vurderingen ble endret på portalen.';
$string['addon.notes.warningnotenotsent'] = 'Kunne ikke legge til eller slette notat(er). {{error}}';
$string['addon.notifications.allownotifications'] = 'Tillat varslinger';
$string['addon.notifications.errorgetnotifications'] = 'Feil ved henting av varsler.';
$string['addon.notifications.notifications'] = 'Varsler';
$string['addon.notifications.playsound'] = 'Spill lyd';
$string['addon.notifications.therearentnotificationsyet'] = 'Det er ingen varsler.';
$string['addon.notifications.typeofnotification'] = 'Varslingstype';
$string['addon.privatefiles.couldnotloadfiles'] = 'Listen over filer kunne ikke lastes.';
$string['addon.privatefiles.emptyfilelist'] = 'Det er ingen filer å vise.';
$string['addon.privatefiles.erroruploadnotworking'] = 'Dessverre er det for øyeblikket ikke mulig å laste opp filer til nettstedet ditt.';
$string['addon.storagemanager.confirmdeleteallsitedata'] = 'Vil du slette alle nedlastede data fra portalen?';
$string['addon.storagemanager.confirmdeletecourses'] = 'Vil du slette alle nedlastede data fra alle kurs?';
$string['addon.storagemanager.confirmdeletedatafrom'] = 'Vil du slette alle nedlastede data fra \'{{name}}\'?';
$string['addon.storagemanager.coursedownloads'] = 'Kursnedlastinger';
$string['addon.storagemanager.courseinfo'] = 'Last ned kursinnhold for å fungere offline. Aktiviteten din synkroniseres automatisk når enheten er tilbake på nett.';
$string['addon.storagemanager.deleteallsitedata'] = 'Slett alle nedlastede data fra nettstedet';
$string['addon.storagemanager.deleteallsitedatainfo'] = 'Dette vil slette alle nedlastede data fra \'{{name}}\', inkludert alle nedlastede kurs og data som lar deg jobbe offline.';
$string['addon.storagemanager.deletecourses'] = 'Slett nedlastede data fra alle kurs';
$string['addon.storagemanager.deletedata'] = 'Slett nedlastede data';
$string['addon.storagemanager.deletedatafrom'] = 'Slett alle nedlastede data fra \'{{name}}\'';
$string['addon.storagemanager.downloadedcourses'] = 'Nedlastede kurs';
$string['addon.storagemanager.downloads'] = 'Nedlastinger';
$string['addon.storagemanager.errordeletedownloadeddata'] = 'Feil ved sletting av nedlastede data';
$string['addon.storagemanager.managedownloads'] = 'Administrere nedlastinger';
$string['addon.storagemanager.totaldownloads'] = 'Totalt nedlastet';
$string['addon.storagemanager.totalspaceusage'] = 'Total diskplass benyttet';
$string['appstoredescription'] = 'Denne offisielle mobilapplikasjonen for Moodle vil BARE virke hvis Moodle-siden er satt opp for å tillate det. Ta kontakt med din Moodleadministrator hvis du har problemer med å koble til.

Hvis Moodle-sidener riktig konfigurert kan du bruke appen til å:

- Bla igjennom kursinnhold, til og med når du er offline.
- Få varsler om meldinger og andre hendelser
- Raskt finne og kontakte andre på kurset
- Laste opp bilder, lyd, videoer og andre filer fra mobilen din
- Se karakterer
- og mer!

Se http://docs.moodle.org/en/Mobile_app for nyeste informasjon.

Vi setter stor pris på gode tilbakemeldinger om funksjonalitet så langt, og dine forslag til hva annet du ønsker at appen skal kunne gjøre.

Appen krever følgende tillatelser:
Lydopptak - For opptak og opplasting av lyd til Moodle
Lese og endre innholdet på minnekortet ditt - Innhold lastes ned til minnekortet slik at du har tilgang når du ikke er på nett
Tilgang til nettverk - For å kunne koble til Moodle-siden og sjekke om du er tilkoblet eller ikke, og for å kunne koble over til "offline mode"
Kjøre ved oppstart - For å sikre at du får varsler når appen kjører i bakgrunnen
Forhindre dvaleomdus - Foer å sikre at du alltid kan motta varsler';
$string['assets.mimetypes.application/vnd.apple.keynote'] = 'Apple Keynote presentasjon';
$string['assets.mimetypes.application/vnd.apple.numbers'] = 'Apple Numbers regneark';
$string['assets.mimetypes.application/vnd.apple.pages'] = 'Apple Pages dokument';
$string['assets.mimetypes.application/vnd.google-apps.audio'] = 'Google Drive audio';
$string['assets.mimetypes.application/vnd.google-apps.document'] = 'Google Docs';
$string['assets.mimetypes.application/vnd.google-apps.drawing'] = 'Google Drawing';
$string['assets.mimetypes.application/vnd.google-apps.file'] = 'Google Drive fil';
$string['assets.mimetypes.application/vnd.google-apps.folder'] = 'Google Drive mappe';
$string['assets.mimetypes.application/vnd.google-apps.form'] = 'Google Skjema';
$string['assets.mimetypes.application/vnd.google-apps.fusiontable'] = 'Google Fusion tabeller';
$string['assets.mimetypes.application/vnd.google-apps.presentation'] = 'Goodle Presentasjoner';
$string['assets.mimetypes.application/vnd.google-apps.script'] = 'Google Apps Scripts';
$string['assets.mimetypes.application/vnd.google-apps.site'] = 'Google portaler';
$string['assets.mimetypes.application/vnd.google-apps.spreadsheet'] = 'Google Regneark';
$string['assets.mimetypes.application/vnd.google-apps.video'] = 'Google Drive video';
$string['core.ajaxendpointnotfound'] = 'AJAX-endepunkt ikke funnet. Dette kan skje hvis Moodle-nettstedet er for gammelt, eller det blokkerer tilgang til dette endepunktet. Moodle-appen støtter bare Moodle-systemer {{$a}} og senere.';
$string['core.browser'] = 'Nettleser';
$string['core.calculating'] = 'Beregner';
$string['core.cannotconnect'] = 'Kan ikke koble til portalen';
$string['core.cannotdownloadfiles'] = 'Nedlasting av filer er deaktivert. Kontakt portaladministratoren.';
$string['core.cannotinstallapk'] = 'Kan ikke installere .apk-filer';
$string['core.cannotinstallapkinfo'] = 'Av sikkerhetsgrunner kan du ikke installere ukjente apper på enheten din fra denne appen. Hvis du fortsatt vil fortsette med installasjonen, må du åpne den i en nettleser.';
$string['core.cannotlogoutpageblocks'] = 'Lagre eller forkast endringene før du fortsetter.';
$string['core.cannotopeninapp'] = 'Denne filen fungerer kanskje ikke som forventet på denne enheten. Vil du åpne den uansett?';
$string['core.cannotopeninappdownload'] = 'Denne filen fungerer kanskje ikke som forventet på denne enheten. Vil du laste den ned uansett?';
$string['core.captureaudio'] = 'Ta opp lyd';
$string['core.capturedimage'] = 'Bilde tatt.';
$string['core.captureimage'] = 'Ta bilde';
$string['core.capturevideo'] = 'Ta opp video';
$string['core.certificaterror'] = 'Sertifikatet til dette nettstedet kan ikke stoles på av enheten din: {{details}}';
$string['core.clearsearch'] = 'Nullstill søk';
$string['core.clearstoreddata'] = 'Fjern lagring {{$a}}';
$string['core.clicktoseefull'] = 'Klikk for å se hele innholdet.';
$string['core.comments.commentsnotworking'] = 'Kommentarer kan ikke hentes';
$string['core.comments.warningcommentsnotsent'] = 'Kunne ikke synkronisere kommentarer.  {{error}}';
$string['core.confirmcanceledit'] = 'Er du sikker på at du vil forlate siden? Du vil miste alle endringer.';
$string['core.confirmleaveunknownchanges'] = 'Er du sikker på at du vil forlate denne siden? Hvis du har endringer som ikke er lagret, vil de gå tapt.';
$string['core.confirmloss'] = 'Er du sikker? Du vil miste alle endringer.';
$string['core.confirmopeninbrowser'] = 'Vil du åpne den i en nettleser?';
$string['core.connectionlost'] = 'Tilkoblingen til nettstedet ble brutt';
$string['core.contactsupport'] = 'Kontakt Support';
$string['core.contenteditingsynced'] = 'Innholdet du redigerer er synkronisert.';
$string['core.contentlinks.chooseaccount'] = 'Velg konto';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Velg en konto å åpne lenken med';
$string['core.contentlinks.confirmurlothersite'] = 'Denne lenken tilhører et annet nettsted. Vil du åpne den?';
$string['core.contentlinks.errornoactions'] = 'Fant ikke en handling å utføre med denne lenken.';
$string['core.contentlinks.errornosites'] = 'Fant ikke noe nettsted for å håndtere denne lenken.';
$string['core.contentlinks.errorredirectothersite'] = 'Viderekoblings-URL-en kan ikke peke til et annet nettsted.';
$string['core.copiedtoclipboard'] = 'Tekst kopiert til utklippstavlen';
$string['core.copytoclipboard'] = 'Kopier til utklippstavlen';
$string['core.course.activitydisabled'] = 'Organisasjonen din har deaktivert denne aktiviteten i mobilappen.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Organisasjonen din installerte en modul som ikke støttes ennå.';
$string['core.course.allsections'] = 'Alle seksjoner';
$string['core.course.aria:sectionprogress'] = 'Seksjonsfremgang:';
$string['core.course.availablespace'] = 'Du har for øyeblikket omtrent {{available}} ledig plass.';
$string['core.course.cannotdeletewhiledownloading'] = 'Filer kan ikke slettes mens aktiviteten lastes ned. Vent til nedlastingen er ferdig.';
$string['core.course.confirmdownload'] = 'Du er i ferd med å laste ned {{size}}. {{availableSpace}} Er du sikker på at du vil fortsette?';
$string['core.course.confirmdownloadunknownsize'] = 'Det var ikke mulig å beregne størrelsen på nedlastingen. {{availableSpace}} Er du sikker på at du vil fortsette?';
$string['core.course.confirmdownloadzerosize'] = 'Du er i ferd med å begynne å laste ned. {{availableSpace}} Er du sikker på at du vil fortsette?';
$string['core.course.confirmlimiteddownload'] = 'Du er for øyeblikket ikke koblet til Wi-Fi.';
$string['core.course.confirmpartialdownloadsize'] = 'Du er i ferd med å laste ned <strong> minst </strong> {{size}}. {{availableSpace}} Er du sikker på at du vil fortsette?';
$string['core.course.couldnotloadsectioncontent'] = 'Kunne ikke laste inn seksjonsinnholdet. Prøv igjen senere.';
$string['core.course.couldnotloadsections'] = 'Kunne ikke laste seksjonene. Prøv igjen senere.';
$string['core.course.downloadcoursesprogressdescription'] = 'Laster ned kurs: lastet ned {{count}} av {{total}}.';
$string['core.course.downloadsectionprogressdescription'] = 'Nedlastingsseksjon: lastet ned {{count}} av {{total}}.';
$string['core.course.errordownloadingcourse'] = 'Feil ved nedlasting av kurs.';
$string['core.course.errordownloadingsection'] = 'Feil ved nedlasting av seksjonen.';
$string['core.course.errorgetmodule'] = 'Feil ved henting av aktivitetsdata.';
$string['core.course.insufficientavailablequota'] = 'Enheten din kunne ikke tildele plass til å lagre denne nedlastingen. Det kan være holdt igjen plass til app- og systemoppdateringer. Frigjør litt lagringsplass først.';
$string['core.course.insufficientavailablespace'] = 'Du prøver å laste ned {{size}}. Dette gir enheten din ikke nok plass til å fungere normalt. Frigjør litt lagringsplass først.';
$string['core.course.lastaccessedactivity'] = 'Sist tilgang til aktivitet';
$string['core.course.manualcompletionnotsynced'] = 'Manuell fullføring er ikke synkronisert.';
$string['core.course.modulenotfound'] = 'Finner ikke ressurs eller aktivitet, sørg for at du er online og at den fortsatt er tilgjengelig.';
$string['core.course.nextactivity'] = 'Neste aktivitet';
$string['core.course.nextactivitynotfound'] = 'Neste aktivitet ble ikke funnet. Det er mulig at den har blitt skjult eller slettet.';
$string['core.course.nocontentavailable'] = 'Ikke noe innhold tilgjengelig for øyeblikket.';
$string['core.course.previousactivity'] = 'Forrige aktivitet';
$string['core.course.previousactivitynotfound'] = 'Finner ikke forrige aktivitet. Det er mulig at den har blitt skjult eller slettet.';
$string['core.course.refreshcourse'] = 'Oppfrisk kurs';
$string['core.course.useactivityonbrowser'] = 'Du kan fortsatt bruke den ved hjelp av enhetens nettleser.';
$string['core.course.warningmanualcompletionmodified'] = 'Den manuelle fullføringen av en aktivitet ble endret på portalen.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Noen frakoblede manuelle gjennomføringer av kurset \'{{name}}\' er slettet. {{error}}';
$string['core.coursenogroups'] = 'Du er ikke medlem av noen gruppe på dette kurset.';
$string['core.courses.browserenrolinstructions'] = 'Vi tar deg til enhetens nettleser. Når du har fullført registreringen, kan du komme tilbake til denne appen.';
$string['core.courses.cannotretrievemorecategories'] = 'Kategorier dypere enn nivå {{$a}} kan ikke hentes.';
$string['core.courses.completeenrolmentbrowser'] = 'Fullfør påmeldingen i nettleseren';
$string['core.courses.confirmselfenrol'] = 'Er du sikker på at du vil melde deg på dette kurset?';
$string['core.courses.downloadcourses'] = 'Last ned alle kurs';
$string['core.courses.enrolme'] = 'Meld meg på';
$string['core.courses.errorloadcategories'] = 'Det oppsto en feil under innlasting av kategorier.';
$string['core.courses.errorloadcourses'] = 'Det oppsto en feil under innlasting av kurs.';
$string['core.courses.errorloadplugins'] = 'Moduler som kreves av dette kurset kunne ikke lastes inn riktig. Last inn appen på nytt for å prøve igjen.';
$string['core.courses.errorsearching'] = 'Det oppsto en feil under søket.';
$string['core.courses.errorselfenrol'] = 'Det oppstod en feil under egenpåmeldingen.';
$string['core.courses.filtermycourses'] = 'Filtrér mine kurs';
$string['core.courses.notenrollable'] = 'Du kan ikke melde deg på selv i dette kurset.';
$string['core.courses.otherenrolments'] = 'Andre påmeldinger';
$string['core.courses.password'] = 'Påmeldingsnøkkel';
$string['core.courses.refreshcourses'] = 'Frisk opp kurs';
$string['core.courses.searchcoursesadvice'] = 'Du kan bruke kurssøk-knappen for å finne kurs du kan få tilgang til som gjest eller hvor kan melde deg selv på kurs som tillater det.';
$string['core.courses.selfenrolment'] = 'Egenpåmelding';
$string['core.courses.showonlyenrolled'] = 'Vis bare mine kurs';
$string['core.courses.totalcoursesearchresults'] = 'Totalt antall kurs: {{$a}}';
$string['core.currentdevice'] = 'Gjeldende enhet';
$string['core.datastoredoffline'] = 'Data lagret på enheten fordi de ikke kunne sendes. Det sendes automatisk senere.';
$string['core.deletedoffline'] = 'Slettet offline';
$string['core.deleting'] = 'Sletter';
$string['core.desktop'] = 'Skrivebordet';
$string['core.dfdaymonthyear'] = 'MM-DD-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Kast';
$string['core.dismiss'] = 'Avvis';
$string['core.dontshowagain'] = 'Ikke vis igjen.';
$string['core.downloaded'] = 'Nedlastet';
$string['core.downloading'] = 'Laster ned';
$string['core.editor.hidetoolbar'] = 'Skjul verktøylinje';
$string['core.editor.toggle'] = 'Bytt editor';
$string['core.emptysplit'] = 'Denne siden vises tom hvis venstre panel er tomt eller lastes inn.';
$string['core.endingtime'] = 'Slutttid: {{$a}}';
$string['core.errorchangecompletion'] = 'Det oppsto en feil under endring av fullføringsstatus. Vennligst prøv på nytt.';
$string['core.errorcode'] = 'Feilkode: {{errorCode}}';
$string['core.errordeletefile'] = 'Feil ved sletting av filen. Vennligst prøv på nytt.';
$string['core.errordetailshide'] = 'Skjul feildetaljer';
$string['core.errordetailsshow'] = 'Vis feildetaljer';
$string['core.errordownloading'] = 'Feil ved nedlasting av filen.';
$string['core.errordownloadingsomefiles'] = 'Feil ved nedlasting av filer. Noen filer kan mangle.';
$string['core.errorfileexistssamename'] = 'En fil med dette navnet eksisterer allerede.';
$string['core.errorinvalidform'] = 'Skjemaet inneholder ugyldige data. Kontroller at alle obligatoriske felt er fylt ut og at dataene er gyldige.';
$string['core.errorinvalidresponse'] = 'Uventet svar for nettjenesten {{method}}.';
$string['core.errorloadingcontent'] = 'Feil ved lasting av innhold.';
$string['core.errorofflinedisabled'] = 'Frakoblet surfing er deaktivert på portalen din. Du må være koblet til internett for å bruke appen.';
$string['core.erroropenfiledownloading'] = 'Feil ved åpning av fil: du må vente til nedlastingen er fullført.';
$string['core.erroropenfilenoapp'] = 'Feil ved åpning av fil: ingen app funnet for å åpne denne typen fil.';
$string['core.erroropenfilenoextension'] = 'Feil ved åpning av fil: Filen har ikke filtype.';
$string['core.erroropenpopup'] = 'Denne aktiviteten prøver å åpne en popup. Dette støttes ikke i appen.';
$string['core.errorrenamefile'] = 'Feil under navneendring til filen. Vennligst prøv på nytt.';
$string['core.errorsitesupport'] = 'Kontakt kundestøtte hvis problemet vedvarer.';
$string['core.errorsomedatanotdownloaded'] = 'Hvis du lastet ned denne aktiviteten, må du merke deg at noen data ikke lastes ned under nedlastingsprosessen av hensyn til ytelse og databruk.';
$string['core.errorsomethingwrong'] = 'Noe gikk galt. Vennligst prøv på nytt.';
$string['core.errorsync'] = 'Det oppsto en feil under synkroniseringen. Vennligst prøv på nytt.';
$string['core.errorsyncblocked'] = 'Denne {{$a}} kan ikke synkroniseres akkurat nå på grunn av en pågående prosess. Prøv igjen senere. Hvis problemet vedvarer, kan du prøve å starte appen på nytt.';
$string['core.errorurlschemeinvalidscheme'] = 'Denne URL-adressen er ment å brukes i en annen app: {{$a}}.';
$string['core.errorurlschemeinvalidsite'] = 'URL-en til dette nettstedet kan ikke åpnes i denne appen.';
$string['core.filenameexist'] = 'Filnavnet eksisterer allerede: {{$a}}';
$string['core.fileuploader.audio'] = 'Lyd';
$string['core.fileuploader.camera'] = 'Kamera';
$string['core.fileuploader.confirmuploadfile'] = 'Du er i ferd med å laste opp {{size}}. Er du sikker på at du vil fortsette?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Det var ikke mulig å beregne størrelsen på opplastingen. Er du sikker på at du vil fortsette?';
$string['core.fileuploader.discardrecording'] = 'Kast opptaket';
$string['core.fileuploader.errorcapturingaudio'] = 'Feil ved opptak av lyd.';
$string['core.fileuploader.errorcapturingimage'] = 'Feil ved opptak av bilde.';
$string['core.fileuploader.errorcapturingvideo'] = 'Feil ved opptak av video.';
$string['core.fileuploader.errorgettingimagealbum'] = 'Feil ved henting av bilde fra album.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Du må være på nett for å kunne laste opp filer.';
$string['core.fileuploader.errornoapp'] = 'Du har ikke installert en app for å utføre denne handlingen.';
$string['core.fileuploader.errorreadingfile'] = 'Feil ved lesing av fil.';
$string['core.fileuploader.errorwhileuploading'] = 'Det oppstod en feil under filopplastingen.';
$string['core.fileuploader.file'] = 'Fil';
$string['core.fileuploader.fileuploaded'] = 'Filen ble lastet opp.';
$string['core.fileuploader.maxbytesfile'] = 'Filen {{$a.file}} er for stor. Maksimal størrelse du kan laste opp er {{$a.size}}.';
$string['core.fileuploader.microphonepermissiondenied'] = 'Tillatelse til å få tilgang til mikrofonen er nektet.';
$string['core.fileuploader.microphonepermissionrestricted'] = 'Mikrofontilgang er begrenset.';
$string['core.fileuploader.pauserecording'] = 'Pause opptaket';
$string['core.fileuploader.photoalbums'] = 'Fotoalbum';
$string['core.fileuploader.readingfile'] = 'Leser fil';
$string['core.fileuploader.readingfileperc'] = 'Leser fil: {{$a}}%';
$string['core.fileuploader.resumerecording'] = 'Fortsett opptaket';
$string['core.fileuploader.selectafile'] = 'Velg en fil';
$string['core.fileuploader.startrecordinginstructions'] = 'Tap for å starte opptaket';
$string['core.fileuploader.uploadafile'] = 'Last opp en fil';
$string['core.fileuploader.uploading'] = 'Laster opp';
$string['core.fileuploader.uploadingperc'] = 'Laster opp:  {{$a}}%';
$string['core.fileuploader.video'] = 'Video';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.goto'] = 'Gå til {{$a}}';
$string['core.h5p.errorgetemail'] = 'Feil ved innhenting av brukerens e-post. Kontroller tilkoblingen din, og prøv på nytt.';
$string['core.h5p.offlinedisabled'] = 'Portalen tillater ikke nedlasting av H5P-pakker.';
$string['core.h5p.play'] = 'Spill av H5P';
$string['core.hasdatatosync'] = 'Denne {{$a}} har frakoblede data som skal synkroniseres.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.iframehelp'] = 'Fungerer ikke dette innholdet?';
$string['core.image'] = 'Bilde';
$string['core.imageviewer'] = 'Bildeviser';
$string['core.ioscookieshelp'] = 'Innebygd innhold kan kreve informasjonskapsler for å fungere. Gå til appens iOS-innstillinger, aktiver "Tillat sporing på tvers av nettsteder" og prøv igjen.';
$string['core.lastdownloaded'] = 'Sist lastet ned';
$string['core.lastsync'] = 'Sist synkronisert';
$string['core.loadmore'] = 'Last mer';
$string['core.login.authenticating'] = 'Autentiserer';
$string['core.login.changepasswordbutton'] = 'Endre passord';
$string['core.login.changepasswordhelp'] = 'Hvis du har problemer med å endre passordet ditt, prøv igjen senere eller kontakt skolen eller læringsleverandøren din.';
$string['core.login.changepasswordinstructions'] = 'Du kan ikke endre passordet ditt i appen. Klikk på følgende knapp for å åpne siden i en nettleser for å endre passordet ditt. Ta hensyn til at du må lukke nettleseren etter å ha endret passordet, da du ikke blir omdirigert til appen.';
$string['core.login.changepasswordlogoutinstructions'] = 'Hvis du ønsker å bytte portal eller logge av, kan du klikke på følgende knapp:';
$string['core.login.changepasswordreconnectinstructions'] = 'Hvis du ikke endret passordet ditt på riktig måte, blir du bedt om å gjøre det igjen.';
$string['core.login.changepasswordsupportsubject'] = 'Trenger hjelp til å endre passordet mitt';
$string['core.login.confirmdeletesite'] = 'Er du sikker på at du vil slette kontoen på portalen {{sitename}}?';
$string['core.login.connect'] = 'Koble!';
$string['core.login.connecttomoodle'] = 'Koble til Moodle';
$string['core.login.connecttomoodleapp'] = 'Du prøver å koble til et vanlig Moodle-portal. Last ned den offisielle Moodle-appen for å få tilgang til denne portalen.';
$string['core.login.connecttoworkplaceapp'] = 'Du prøver å koble til en Moodle Workplace-portal. Last ned Moodle Workplace-appen for å få tilgang til denne portalen.';
$string['core.login.contactyouradministrator'] = 'Kontakt portaladministratoren din for ytterligere hjelp.';
$string['core.login.contactyouradministratorissue'] = 'Be portaladministratoren din om å sjekke følgende problem: {{$a}}';
$string['core.login.credentialsdescription'] = 'Vennligst oppgi brukernavn og passord for å logge inn.';
$string['core.login.credentialshelp'] = 'Hvis du har problemer med å logge på, prøv igjen senere eller kontakt din skole eller læringsleverandør.';
$string['core.login.credentialssupportsubject'] = 'Trenger hjelp til å logge inn';
$string['core.login.emailconfirmsentnoemail'] = '<p>En e-post skal ha blitt sendt til adressen din.</p><p>Den inneholder enkle instruksjoner for å fullføre registreringen.</p>';
$string['core.login.emailnotmatch'] = 'E-poster stemmer ikke overens';
$string['core.login.erroraccesscontrolalloworigin'] = 'Kryssopprinnelsessamtalen du prøver å utføre har blitt avvist. Vennligst sjekk https://moodledev.io/general/app/development/setup/app-in-browser';
$string['core.login.errordeletesite'] = 'Det oppstod en feil under sletting av kontoen. Vær så snill, prøv på nytt.';
$string['core.login.errorexampleurl'] = 'URL-adressen https://campus.example.edu er bare et eksempel-URL, det er ikke et ekte nettsted. <strong>Bruk nettadressen til skolens eller organisasjonens portal.</strong>';
$string['core.login.errorqrnoscheme'] = 'Denne URL-en er ikke gyldig.';
$string['core.login.errorupdatesite'] = 'Det oppstod en feil under oppdatering av portalens token.';
$string['core.login.exceededloginattempts'] = 'Trenger du hjelp til å logge inn? Prøv {{recoverPassword}} eller kontakt brukerstøtten for nettstedet ditt.';
$string['core.login.exceededloginattemptsrecoverpassword'] = 'tilbakestiller passordet ditt';
$string['core.login.exceededloginattemptssupportsubject'] = 'Jeg kan ikke logge inn';
$string['core.login.exceededloginattemptswithoutpassword'] = 'Trenger du hjelp til å logge inn? Prøv å kontakte portalens Support.';
$string['core.login.exceededloginattemptswithoutsupport'] = 'Trenger du hjelp til å logge inn? Prøv {{recoverPassword}}.';
$string['core.login.exceededpasswordresetattempts'] = 'Det ser ut til at du har problemer med å få tilgang til kontoen din. Du kan kontakte skolen eller læreleverandøren din eller prøve igjen senere.';
$string['core.login.exceededpasswordresetattemptssupportsubject'] = 'Jeg kan ikke resette passordet mitt';
$string['core.login.faqcannotconnectanswer'] = 'Vennligst kontakt din portaladministrator';
$string['core.login.faqcannotconnectquestion'] = 'Jeg har skrevet min portaladresse korrekt, men kan fremdeles ikke koble til.';
$string['core.login.faqcannotfindmysiteanswer'] = 'Har du skrevet navnet riktig? Det er også mulig at portalen din ikke er inkludert i vår katalogen for offentlige nettsteder. Hvis du fortsatt ikke finner den, vennligst skriv inn nettadressen din i stedet.';
$string['core.login.faqcannotfindmysitequestion'] = 'Jeg kan ikke finne portalen min.';
$string['core.login.faqcantloginanswer'] = '<p>Når du har koblet til Moodle-siden din, bør du kunne logge på med ditt vanlige brukernavn og passord.</p><br><p>Hvis du har glemt brukernavnet eller passordet ditt, velg alternativet <strong >Har du glemt brukernavnet eller passordet ditt?</strong>. Hvis du fortsatt har problemer med å logge på eller ikke kan se noen alternativer for å hente brukernavnet eller passordet ditt, vennligst ta kontakt med personen som tar seg av Moodle i skolen eller læreorganisasjonen din.</p>';
$string['core.login.faqcantloginquestion'] = 'Jeg kan ikke logge inn.';
$string['core.login.faqmore'] = 'Sjekk ut <a href="https://docs.moodle.org/en/Moodle_app_FAQ#toc" target="_blank">vanlige spørsmål</a> for flere svar.';
$string['core.login.faqsetupsiteanswer'] = 'Gå til {{$link}} for å sjekke de forskjellige alternativene du har for å lage din egen Moodle-portal.';
$string['core.login.faqsetupsitelinktitle'] = 'Kom i gang.';
$string['core.login.faqsetupsitequestion'] = 'Jeg ønsker å sette opp min egen Moodle-portal.';
$string['core.login.faqtestappanswer'] = 'For å teste appen på et Moodle Demo-nettsted, skriv "lærer" eller "student" i "Ditt nettsted" -feltet og klikk på "Koble til portalen din" -knappen.';
$string['core.login.faqtestappquestion'] = 'Jeg ønsker bare å teste appen, hva kan jeg gjøre?';
$string['core.login.faqwhatisurlanswer'] = '<p>Hvis du ikke finner nettstedet ditt ved navn, prøv å søke etter Moodle-nettstedets URL-adresse (eller nettadresse) i stedet.</p><p>Slik finner du nettstedets adresse:</p><ol>< li>Åpne en nettleser og gå til Moodle-nettstedets påloggingsside.</li><li>Øverst på siden, i adressefeltet, vil du se URL-adressen til Moodle-nettstedet ditt, f.eks. "campus.example.edu".<br>{{$image}}</li><li>Kopier nettadressen (ikke kopier /påloggingen eller det som kommer etter), lim den inn i <strong>nettstedet ditt< /strong> i appen, og trykk deretter på <strong>Koble til nettstedet ditt</strong></li><li>Nå kan du logge på nettstedet ditt med brukernavnet og passordet ditt.</li></ol>< p>Hvis du prøvde å søke etter URL-adresse og fortsatt ikke finner Moodle-nettstedet ditt, vennligst ta kontakt med personen som tar seg av Moodle i skolen eller læreorganisasjonen din.</p>';
$string['core.login.faqwhatisurlquestion'] = 'Hva er min portal-adresse? Hvordan kan jeg finne URL-en til min portal?';
$string['core.login.faqwhereisqrcode'] = 'Hvor kan jeg finne QR-koden?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p> Hvis organisasjonen din har aktivert den, finner du en QR-kode på nettstedet nederst på brukerprofilsiden din. </p> {{$image}}';
$string['core.login.findyoursite'] = 'Finn din portal';
$string['core.login.helpmelogin'] = '<p> Det er mange tusen Moodle-portaler rundt om i verden. Denne appen kan bare koble til Moodle-portaler som har aktivert tilgang til mobilapper spesifikt. </p> <p> Hvis du ikke kan koble til Moodle-portalen ditt, må du kontakte nettstedsadministratoren din og be dem om å lese <a href = "http://docs.moodle.org/en/Mobile_app" target = "_blank"> http://docs.moodle.org/en/Mobile_app </a> </p> <p> For å teste appen i en Moodle-demo-portal, skriv <i> lærer </i> eller <i> student </i> i <i> Portaladresse </i> -feltet og klikk på <b> Koble til-knappen </b>. </p >';
$string['core.login.invalidaccount'] = 'Vennligst sjekk påloggingsdetaljene dine og prøv igjen.';
$string['core.login.invalidmoodleversion'] = 'Versjonen av denne Moodle-siden er for gammel. Moodle-appen fungerer med nettsteder som bruker {{$a}} eller nyere.';
$string['core.login.invalidsite'] = 'Portalens URL er ikke gyldig.';
$string['core.login.invalidtime'] = 'Tiden er ikke gyldig';
$string['core.login.invalidvaluemax'] = 'Maksimumsverdien er {{$a}}';
$string['core.login.invalidvaluemin'] = 'Minimumsverdien er {{$a}}';
$string['core.login.loggedoutssodescription'] = 'Du må autentisere på nytt. Du må logge inn på siden i et nettleservindu.';
$string['core.login.loginbutton'] = 'Logg inn';
$string['core.login.logininsiterequired'] = 'Du må logge inn på siden i et nettleservindu.';
$string['core.login.mobileservicesnotenabled'] = 'Mobiltjenester er ikke aktivert på portalen.';
$string['core.login.notloggedin'] = 'Du må være innlogget.';
$string['core.login.onboardingcreatemanagecourses'] = 'Opprett og administrér dine kurs';
$string['core.login.onboardingenrolmanagestudents'] = 'Meld på og administrér dine studenter';
$string['core.login.onboardinggetstarted'] = 'Kom i gang med Moodle';
$string['core.login.onboardingialreadyhaveasite'] = 'Jeg har allerede en Moodle-portal';
$string['core.login.onboardingimalearner'] = 'Jeg er en lærende';
$string['core.login.onboardingimaneducator'] = 'Jeg er pedagog';
$string['core.login.onboardingineedasite'] = 'Jeg trenger en Moodle-portal';
$string['core.login.onboardingprovidefeedback'] = 'Gi rettidig tilbakemelding';
$string['core.login.onboardingtoconnect'] = 'For å koble til Moodle-appen trenger du en Moodle-portal';
$string['core.login.onboardingwelcome'] = 'Velkommen til Moodle-appen!';
$string['core.login.or'] = 'Eller';
$string['core.login.passwordrequired'] = 'Passord påkrevet';
$string['core.login.policyacceptmandatory'] = 'Jeg forstår og godtar de obligatoriske retningslinjene for nettstedet';
$string['core.login.recaptchachallengeimage'] = 'reCAPTCHA utfordringsbilde';
$string['core.login.recaptchaexpired'] = 'Bekreftelsen har utløpt. Svar på sikkerhetsspørsmålet igjen.';
$string['core.login.recaptchaincorrect'] = 'Svaret på sikkerhetsspørsmålet er feil.';
$string['core.login.reconnect'] = 'Koble til på nytt';
$string['core.login.reconnecthelp'] = 'Hvis du har problemer med å koble til igjen, prøv igjen senere eller kontakt skolen eller læringsleverandøren din.';
$string['core.login.reconnectssodescription'] = 'Økten din har utløpt. Logg på igjen i et nettleservindu for å fortsette.';
$string['core.login.reconnectsupportsubject'] = 'Trenger hjelp til å koble til igjen';
$string['core.login.reconnecttosite'] = 'Koble til portalen på nytt';
$string['core.login.removeaccount'] = 'Fjern konto';
$string['core.login.searchby'] = 'Søk med:';
$string['core.login.selectsite'] = 'Vennligst velg din konto:';
$string['core.login.signupplugindisabled'] = '{{$a}} er ikke aktivert.';
$string['core.login.signuprequiredfieldnotsupported'] = 'Registreringsskjemaet inneholder et obligatorisk tilpasset felt som ikke støttes i appen. Opprett kontoen din ved hjelp av en nettleser.';
$string['core.login.siteaddress'] = 'Din portal';
$string['core.login.siteaddressplaceholder'] = 'https://campus.example.edu';
$string['core.login.sitebadgedescription'] = 'Det er {{count}} uleste varsler.';
$string['core.login.sitehasredirect'] = 'Portalen din inneholder minst én HTTP-viderekobling. Appen kan ikke følge viderekoblinger, dette kan være problemet som hindrer appen i å koble til portalen din.';
$string['core.login.siteinmaintenance'] = 'Portalen din er i vedlikeholdsmodus';
$string['core.login.sitenotallowed'] = 'Denne portalen er ikke lenger tilgjengelig.';
$string['core.login.sitepolicynotagreederror'] = 'Portalregler er ikke akseptert.';
$string['core.login.siteurl'] = 'Portal URL';
$string['core.login.siteurlrequired'] = 'Portalens URL kreves, dvs. <i>https://campus.example.edu</i>';
$string['core.login.stillcantconnect'] = 'Kan du fortsatt ikke koble til?';
$string['core.login.toggleremove'] = 'Rediger kontoliste';
$string['core.login.usernamerequired'] = 'Brukernavn påkrevet';
$string['core.login.visitchangepassword'] = 'Vil du besøke portalen for å endre passordet?';
$string['core.login.webservicesnotenabled'] = 'Webtjenester er ikke aktivert på portalen.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Du kan fortsatt koble til portalen ved å skrive inn brukernavn og passord.';
$string['core.login.yourenteredsite'] = 'Koble til din portal';
$string['core.lostconnection'] = 'Økten din har utløpt. Logg på igjen for å fortsette.';
$string['core.mainmenu.switchaccount'] = 'Bytt konto';
$string['core.mainmenu.usermenutourdescription'] = 'Stedet for å sjekke karakterene dine, endre preferansene dine eller bytte konto.';
$string['core.mainmenu.usermenutourtitle'] = 'Undersøk ditt personlige område';
$string['core.needhelp'] = 'Trenger du hjelp?';
$string['core.networkerroriframemsg'] = 'Dette innholdet er ikke tilgjengelig offline. Koble til Internett og prøv igjen.';
$string['core.networkerrormsg'] = 'Det oppsto et problem med å koble til portalen. Kontroller tilkoblingen og prøv igjen.';
$string['core.nooptionavailable'] = 'Ingen alternativ tilgjengelig';
$string['core.nopasswordchangeforced'] = 'Du kan ikke fortsette uten å endre passordet ditt.';
$string['core.nopermissionerror'] = 'Beklager, men du har for øyeblikket ikke tillatelse til å gjøre det';
$string['core.notapplicable'] = 'n/a';
$string['core.notdownloadable'] = 'Ikke nedlastbar';
$string['core.notsent'] = 'Ikke sendt';
$string['core.nummore'] = '{{$a}} mer';
$string['core.openfile'] = 'Åpne fil';
$string['core.openfullimage'] = 'Klikk her for å vise bildet i full størrelse';
$string['core.openinbrowser'] = 'Åpne i nettleser';
$string['core.openinbrowserdescription'] = 'Du vil bli sendt til en nettleser';
$string['core.openmodinbrowser'] = 'Åpne {{$a}} i nettleseren';
$string['core.opensecurityquestion'] = 'Åpne sikkerhetsspørsmål';
$string['core.opensettings'] = 'Åpne innstillinger';
$string['core.openwith'] = 'Åpne med...';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.play'] = 'Spill av';
$string['core.pulltorefresh'] = 'Trekk for å oppdatere';
$string['core.qrscanner'] = 'QR scanner';
$string['core.question.cannotdeterminestatus'] = 'Kan ikke avgjøre status';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'Portalen din støtter ikke vedlegg av filer til svar ennå.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'Nettstedet ditt støtter ikke redigering av innebygde filer ennå.';
$string['core.question.errorquestionnotsupported'] = 'Denne spørsmålstypen støttes ikke av appen: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Trykk for å velge og trykk deretter for å slippe.';
$string['core.question.questionmessage'] = 'Spørsmål {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Du vil bli omdirigert til nettstedet.';
$string['core.reminders.atthetime'] = 'På tidspunktet for arrangementet';
$string['core.reminders.custom'] = 'Egendefinert...';
$string['core.reminders.customreminder'] = 'Egendefinert påminnelse';
$string['core.reminders.delete'] = 'Slett påminnelse';
$string['core.reminders.reminderset'] = 'Påminnelse satt for {{$a}}';
$string['core.reminders.reminderunset'] = 'Påminnelse slettet';
$string['core.reminders.setareminder'] = 'Angi en påminnelse';
$string['core.reminders.setareminderfor'] = 'Angi en påminnelse for «{{title}}» ({{label}})';
$string['core.reminders.setreminder'] = 'Angi påminnelse';
$string['core.reminders.timebefore'] = '{{value}} {{units}} før';
$string['core.reminders.value'] = 'Verdi';
$string['core.removefiles'] = 'Fjern filer {{$a}}';
$string['core.reportbuilder.filtersapplied'] = 'Det kan være filtre brukt på denne visningen. For å redigere filtre eller endre sorteringsrekkefølgen, <a href="{{$a}}">åpne denne rapporten i nettleseren din.</a>';
$string['core.reportbuilder.hidecolumns'] = 'Skjul kolonner';
$string['core.reportbuilder.showcolumns'] = 'Vis kolonner';
$string['core.requireduserdatamissing'] = 'Denne brukeren mangler noen nødvendige profildata. Vennligst skriv inn dataene på portalen din og prøv igjen.<br>{{$a}}';
$string['core.resume'] = 'Gjenoppta';
$string['core.retry'] = 'Prøv igjen';
$string['core.scanqr'] = 'Scan QR-lode';
$string['core.scrollbackward'] = 'Rull bakover';
$string['core.scrollforward'] = 'Rull forover';
$string['core.search.allcategories'] = 'Alle kategorier';
$string['core.search.empty'] = 'Hva leter du etter?';
$string['core.search.filtercategories'] = 'Filtrér resultater på';
$string['core.search.filtercourses'] = 'Søk i';
$string['core.search.noresults'] = 'Ingen resultater for «{{$a}}»';
$string['core.search.noresultshelp'] = 'Se etter skrivefeil eller prøv å bruke andre søkeord';
$string['core.search.resultby'] = 'Ved {{$a}}';
$string['core.searching'] = 'Søker';
$string['core.serverconnection'] = 'Feil ved tilkobling til serveren: {{details}}';
$string['core.settings.about'] = 'Om';
$string['core.settings.appsettings'] = 'App-innstillinger';
$string['core.settings.appversion'] = 'App-versjon';
$string['core.settings.cannotsyncloggedout'] = 'Denne siden kan ikke synkroniseres fordi du har logget ut. Vennligst prøv igjen når du er logget på portalen igjen.';
$string['core.settings.cannotsyncoffline'] = 'Synkronisering av portal mislyktes fordi enheten din ikke er koblet til internett.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Enheten din er ikke koblet til Wi-Fi. Koble til et Wi-Fi-nettverk eller slå av Datasparing i appinnstillingene.';
$string['core.settings.changelanguage'] = 'Bytt til  {{$a}}';
$string['core.settings.changelanguagealert'] = 'Endring av språk vil restarte appen.';
$string['core.settings.colorscheme'] = 'Fargeskjema';
$string['core.settings.colorscheme-dark'] = 'Mørkt';
$string['core.settings.colorscheme-light'] = 'Lyst';
$string['core.settings.colorscheme-system'] = 'Systemstandard';
$string['core.settings.colorscheme-system-notice'] = 'Systemstandardmodus vil avhenge av enhetens støtte.';
$string['core.settings.compilationinfo'] = 'Kompileringsinformasjon';
$string['core.settings.connecttosync'] = 'Enheten din er frakoblet. Koble til internett for å synkronisere portaler.';
$string['core.settings.connectwifitosync'] = 'Koble til et Wi-Fi-nettverk eller slå av Datasparing for å synkronisere portaler.';
$string['core.settings.copyinfo'] = 'Kopier enhetsinformasjon på utklippstavlen';
$string['core.settings.cordovadevicemodel'] = 'Cordova enhetsmodell';
$string['core.settings.cordovadeviceosversion'] = 'Cordova enhetsversjon';
$string['core.settings.cordovadeviceplatform'] = 'Cordova enhetsplattform';
$string['core.settings.cordovadeviceuuid'] = 'Cordova enhets-UUID';
$string['core.settings.cordovaversion'] = 'Cordova-versjon';
$string['core.settings.debugdisplaydescription'] = 'Hvis aktivert, vil feilmodaler vise mer data om feilen hvis mulig.';
$string['core.settings.developeroptions'] = 'Utvikler-alternativer';
$string['core.settings.deviceinfo'] = 'Enhets-info';
$string['core.settings.deviceos'] = 'Enhets-OS';
$string['core.settings.displayformat'] = 'Visningsformat';
$string['core.settings.enableanalytics'] = 'Aktiver analyser';
$string['core.settings.enableanalyticsdescription'] = 'Hvis aktivert, vil appen samle inn anonym databruk.';
$string['core.settings.enabledownloadsection'] = 'Aktiver nedlastingsseksjoner';
$string['core.settings.enablefirebaseanalytics'] = 'Aktivér Firebase analyser';
$string['core.settings.enablefirebaseanalyticsdescription'] = 'Hvis aktivert, vil appen samle inn anonym databruk.';
$string['core.settings.enablerichtexteditor'] = 'Aktivér teksteditor';
$string['core.settings.enablerichtexteditordescription'] = 'Hvis aktivert, vil et tekstredigeringsprogram være tilgjengelig når du legger inn innhold.';
$string['core.settings.enablesyncwifi'] = 'Tillat synkronisering kun når du er på Wi-Fi';
$string['core.settings.encryptedpushsupported'] = 'Krypterte push-varsler støttes';
$string['core.settings.entriesincache'] = '{{$a}} oppføringer i hurtigbufferen';
$string['core.settings.errorsyncsite'] = 'Feil ved synkronisering av portaldata. Kontroller Internett-tilkoblingen din og prøv igjen.';
$string['core.settings.estimatedfreespace'] = 'Estimert ledig plass';
$string['core.settings.filesystemroot'] = 'Filsystemrot';
$string['core.settings.fontsize'] = 'Tekststørrelse';
$string['core.settings.forcedsetting'] = 'Denne innstillingen har blitt tvunget av portalens konfigurasjon.';
$string['core.settings.helpusimprove'] = 'Hjelp oss å forbedre denne appen';
$string['core.settings.ioscookies'] = 'Sporing på tvers av nettsteder';
$string['core.settings.ioscookiesdescription'] = 'Innebygd innhold fra nettstedet kan kreve informasjonskapsler på tvers av nettsteder for å fungere. For å aktivere det, gå til appens iOS-innstillinger og aktiver "Tillat sporing på tvers av nettsteder".';
$string['core.settings.legaldisclaimer'] = 'Juridisk ansvarsfraskrivelse';
$string['core.settings.localnotifavailable'] = 'Lokale varsler tilgjengelig';
$string['core.settings.locationhref'] = 'Nettvisnings-URL';
$string['core.settings.logintosync'] = 'Logg inn for å synkronisere';
$string['core.settings.navigatorlanguage'] = 'Navigator språk';
$string['core.settings.navigatoruseragent'] = 'Navigator userAgent';
$string['core.settings.networkstatus'] = 'Internett-tilkoblingsstatus';
$string['core.settings.opensourcelicenses'] = 'Åpen kildekode-lisens';
$string['core.settings.privacypolicy'] = 'Personvernerklæring';
$string['core.settings.publisher'] = 'Utgiver';
$string['core.settings.pushid'] = 'Push-varslings-ID';
$string['core.settings.reportinbackground'] = 'Rapportér feil automatisk';
$string['core.settings.screen'] = 'Skjerminformasjon';
$string['core.settings.showdownloadoptions'] = 'Vis nedlastingsalternativer';
$string['core.settings.siteinfo'] = 'Portal-info';
$string['core.settings.sitesyncfailed'] = 'Portalsynkronisering feilet';
$string['core.settings.spaceusage'] = 'Diskbruk';
$string['core.settings.syncdatasaver'] = 'Datasparing: Synkroniser bare når du er på Wi-Fi';
$string['core.settings.synchronization'] = 'Synkronisering';
$string['core.settings.synchronizenow'] = 'Synkronisér nå';
$string['core.settings.synchronizenowhelp'] = 'Synkronisering av et nettsted vil sende ventende endringer og all offline aktivitet som er lagret på enheten, og vil synkronisere noen data som meldinger og varsler.';
$string['core.settings.syncsettings'] = 'Synkroniseringsalternativer';
$string['core.settings.wificonnection'] = 'Wi-Fi-tilkobling';
$string['core.settings.youradev'] = 'Du er nå en utvikler';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Velg en konto du vil lagre filen i.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Det finnes allerede en fil med dette navnet. Vil du erstatte den eksisterende filen eller gi den nytt navn til "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Det er ingen portaler lagret. Legg til en portal før du deler en fil med appen.';
$string['core.sharedfiles.nosharedfiles'] = 'Det er ingen delte filer lagret på denne siden.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Du har ingen filer å laste opp her. Hvis du vil laste opp en fil fra en annen app, finner du filen og klikker på "Åpne i"-knappen.';
$string['core.sharedfiles.rename'] = 'Endre navn';
$string['core.sharedfiles.replace'] = 'Erstatt';
$string['core.sharedfiles.sharedfiles'] = 'Delte filer';
$string['core.sharedfiles.successstorefile'] = 'Filen er lagret. Velg filen du vil laste opp til dine private filer eller bruke i en aktivitet.';
$string['core.sitenotfound'] = 'Portal ikke funnet';
$string['core.sitenotfoundhelp'] = 'Vi finner ikke portalen du anga. Se etter skrivefeil eller prøv igjen senere. Hvis du fortsetter å se denne meldingen, kontakt skolen eller læringsleverandøren din.';
$string['core.siteunavailablehelp'] = 'Portalen "{{site}}" er ikke tilgjengelig akkurat nå. Vennligst prøv igjen senere eller kontakt din skole eller læringsleverandør.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Beklager...';
$string['core.start'] = 'Start';
$string['core.startingtime'] = 'Starttid:  {{$a}}';
$string['core.storingfiles'] = 'Lagrer filer';
$string['core.swipenavigationtourdescription'] = 'Sveip til venstre og høyre for å navigere rundt.';
$string['core.tablet'] = 'Tablet';
$string['core.tag.errorareanotsupported'] = 'Dette tagområdet støttes ikke av appen.';
$string['core.tag.tagareabadgedescription'] = 'Det er {{count}} elementer.';
$string['core.tag.warningareasnotsupported'] = 'Noen av merkeområdene vises ikke fordi de ikke støttes av appen.';
$string['core.thereisdatatosync'] = 'Det er offline {{$a}} som skal synkroniseres.';
$string['core.toggledelete'] = 'Veksle på sletteknapper';
$string['core.tryagain'] = 'Prøv igjen';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Uh oh!';
$string['core.unexpectederror'] = 'Uventet feil. Lukk og åpne programmet på nytt, og prøv igjen.';
$string['core.unicodenotsupported'] = 'Noen emojier støttes ikke på dette nettstedet. Slike tegn vil bli fjernet når meldingen sendes.';
$string['core.unicodenotsupportedcleanerror'] = 'Tom tekst ble funnet under rensing av Unicode-tegn.';
$string['core.unknown'] = 'Ukjent';
$string['core.unzipping'] = 'Pakker ut';
$string['core.updaterequired'] = 'Appoppdatering kreves';
$string['core.updaterequireddesc'] = 'Oppdater appen din til versjon {{$a}}';
$string['core.user.completeprofile'] = 'Fullfør profilen';
$string['core.user.completeprofilehelp'] = 'Hvis du har problemer med å fullføre profilen din, prøv igjen senere eller kontakt din skole eller læringsleverandør.';
$string['core.user.completeprofilenotice'] = 'Før du fortsetter, fyll ut de obligatoriske feltene i brukerprofilen din.';
$string['core.user.completeprofilereconnectinstructions'] = 'Hvis du ikke har fullført profilen din riktig, blir du bedt om å gjøre det igjen.';
$string['core.user.completeprofilesupportsubject'] = 'Trenger hjelp for å fullføre min profil';
$string['core.user.completeyourprofile'] = 'Fullfør din profil';
$string['core.user.contact'] = 'Kontakt';
$string['core.user.detailsnotavailable'] = 'Detaljene til denne brukeren er ikke tilgjengelige for deg.';
$string['core.user.errorloaduser'] = 'Feil ved innlasting av bruker.';
$string['core.user.sendemail'] = 'E-post';
$string['core.user.support'] = 'Kontakt portal-Support';
$string['core.user.supportsubject'] = '[App] {{subject}}';
$string['core.user.userwithid'] = 'Bruker med ID {{id}}';
$string['core.usernologin'] = 'Autentisering er trukket tilbake for denne kontoen';
$string['core.viewcode'] = 'Vis kode';
$string['core.vieweditor'] = 'Vis editor';
$string['core.viewembeddedcontent'] = 'Se innebygd innhold';
$string['core.wanttochangesite'] = 'Vil du bytte portal eller logge av?';
$string['core.warningofflinedatadeleted'] = 'Frakoblede endringer av {{component}} \'{{name}}\' har blitt forkastet. {{feil}}';
$string['core.warningofflinedatadeletedreason'] = 'Nyere endringer i denne aktiviteten er gjort fra en annen enhet.';
$string['core.warnopeninbrowser'] = '<p>Du er i ferd med å forlate appen for å åpne følgende URL i enhetens nettleser. Vil du fortsette?</p>
<p><b>{{url}}</b></p>';
$string['core.whoissiteadmin'] = '"Site Administrators" er personene som administrerer Moodle på din skole/universitet/bedrift eller lærende organisasjon. Hvis du ikke vet hvordan du kan kontakte dem, vennligst kontakt dine lærere/trenere.';
$string['core.whyisthishappening'] = 'Hvorfor skjer dette?';
$string['core.wsfunctionnotavailable'] = 'Webtjenestefunksjonen er ikke tilgjengelig.';
$string['core.youreoffline'] = 'Enheten din er offline';
$string['core.youreonline'] = 'Enheten din er tilbake på nett';
$string['core.zoomin'] = 'Zoom inn';
$string['core.zoomout'] = 'Zoom ut';
$string['freemium.autologoutclosingtheapp'] = 'Umiddelbart etter at du har forlatt appen';
$string['freemium.autologoutcustomtime'] = 'Egendefinert tid etter at du har forlatt appen';
$string['freemium.autologoutdefault'] = 'Standard';
$string['freemium.autologouttitle'] = 'Logg ut automatisk fra denne enheten';
$string['freemium.biometriclogin'] = 'Biometrisk innlogging';
$string['freemium.biometriclogindescription'] = 'Legg fingeren din på fingeravtrykksleseren.';
$string['freemium.biometricloginenablefaceid'] = 'Aktiver FaceID';
$string['freemium.biometricloginenablefingerprint'] = 'Aktiver fingeravtrykk';
$string['freemium.biometricloginenabletouchid'] = 'Aktiver TouchID';
$string['freemium.biometricloginloginwithfaceid'] = 'Logg inn med FaceID';
$string['freemium.biometricloginloginwithfingerprint'] = 'Logg inn med fingeravtrykk';
$string['freemium.biometricloginloginwithtouchid'] = 'Logg inn med TouchID';
$string['freemium.biometricloginskip'] = 'Hopp over for nå';
$string['freemium.biometricloginsuccessfullyenabled'] = '{{ biometricMethod }} aktivert.';
$string['freemium.biometricloginturnoff'] = 'Du kan slå denne funksjonen på og av når som helst under innstillinger.';
$string['freemium.biometriclogintypefaceid'] = 'FaceID';
$string['freemium.biometriclogintypefingerprint'] = 'Fingeravtrykk';
$string['freemium.biometriclogintypetouchid'] = 'TouchID';
$string['freemium.biometricloginwithfingerorface'] = 'Bruk biometrisk pålogging med fingeravtrykket eller ansiktet ditt.';
$string['freemium.change'] = 'Endre';
$string['freemium.coursesbatchdownloaddisabled'] = 'Nedlasting av kurs i batch er ikke aktivert for dette nettstedet.';
$string['freemium.coursesdownloadlimitreached'] = 'Nedlastingsgrensen for kurs er nådd! Du kan bare laste ned {{limit}} kurs, kontakt administratoren din for å øke denne grensen eller fjerne noen nedlastede kurs fra enheten din.';
$string['freemium.downloadmainapplicationrequired'] = 'Du kan bare koble til dette nettstedet ved å bruke den dedikerte appen.';
$string['freemium.downloadmainapplicationsuggestion'] = 'Nettstedet du prøver å koble til har en dedikert app som du kanskje vil prøve.';
$string['freemium.feature_autologout'] = 'Auto utlogging';
$string['freemium.feature_biometriclogin'] = 'Biometrisk innlogging';
$string['freemium.feature_coursesdownload'] = 'Nedlastede kurs';
$string['freemium.feature_multimediapushnotifications'] = 'Multimedia push-varsler';
$string['freemium.feature_pushnotificationsdevices'] = 'Push-varslingsenheter';
$string['freemium.feature_qrlogin'] = 'Autentiser med en QR-kode';
$string['freemium.feature_remotethemes'] = 'Eksterne temaer';
$string['freemium.feature_sitelogo'] = 'Portallogo';
$string['freemium.notallowed'] = 'Ikke tillatt';
$string['freemium.nottoday'] = 'Ikke i dag';
$string['freemium.qrlogindisabled'] = 'Autentisering i appen ved hjelp av en QR-kode er ikke aktivert for nettstedet:<br><br>{{url}}';
$string['freemium.qrloginexpiredkey'] = 'QR-koden er utløpt. Oppdater siden med QR-koden og skann den på nytt.';
$string['freemium.qrloginipmismatch'] = 'Enheten du bruker til å koble til ser ikke ut til å være i samme nettverk som enheten som viser QR-koden. Sørg for at begge enhetene er koblet til samme nettverk (f.eks. samme WiFi-nettverk).<br><br>Hvis feilen vedvarer, vennligst kontakt portaladministratoren.';
$string['freemium.ratetheapp'] = 'Liker du appen vår?';
$string['freemium.ratetheapp_feedbackko'] = 'Fortell oss hva som gikk galt';
$string['freemium.ratetheapp_feedbackmessage'] = 'Tilbakemeldingen din vil være anonym';
$string['freemium.ratetheapp_feedbackok'] = 'Send tilbakemelding';
$string['freemium.ratetheapp_feedbackplaceholder'] = 'Skriv noe her';
$string['freemium.ratetheapp_feedbacksent'] = 'Takk! Tilbakemeldingen din ble sendt.';
$string['freemium.ratetheapp_sendtostore'] = 'Kan du ta deg tid til å vurdere appen vår? Det vil hjelpe oss å forbedre appen.';
$string['freemium.remindmelater'] = 'Påminn meg senere';
$string['freemium.settingsoptions_autologout'] = 'Auto utlogging';
$string['freemium.settingsoptionsfacial'] = 'Aktivér ansiktsgjenkjenning';
$string['freemium.settingsoptionsfingerprint'] = 'Aktivér fingeravtrykk-innlogging';
$string['freemium.subscription'] = 'Portalabonnement';
$string['freemium.subscriptiondetails'] = 'Abonnementsdetaljer';
$string['freemium.subscriptionfeature_exceeded_customlanguagestrings'] = '{{ overflowCount }} egendefinerte språkstrenger blir ignorert';
$string['freemium.subscriptionfeature_exceeded_custommenuitems'] = '{{ overflowCount }} tilpassede menyelementer blir ignorert';
$string['freemium.subscriptionfeature_exceeded_disabledfeatures'] = '{{ overflowCount }} konfigurerte deaktiverte funksjoner er fortsatt aktivert';
$string['freemium.subscriptionfeature_exceeded_remotethemes'] = 'Det egendefinerte temaet ditt blir ikke brukt';
$string['freemium.subscriptionfeature_exceeded_sitelogo'] = 'Portallogoen din blir ikke brukt';
$string['freemium.subscriptionfeature_limited'] = 'Begrenset til {{ limit }}';
$string['freemium.subscriptionfeature_unlimited'] = 'Ubegrenset';
$string['freemium.subscriptionplan'] = 'Abonnementsplan';
$string['freemium.subscriptionplan_bma'] = 'BMA';
$string['freemium.subscriptionplan_expired'] = 'utløpt';
$string['freemium.subscriptionplan_free'] = 'Gratis';
$string['freemium.subscriptionplan_premium'] = 'Premium';
$string['freemium.subscriptionplan_pro'] = 'Pro';
$string['freemium.subscriptionplan_upgrade'] = 'Oppgrader planen din';
$string['freemium.subscriptionplan_validuntil'] = 'gyldig til {{ date }}';
$string['freemium.subscriptionplandescription'] = 'Abonnementsplaner angir hvilken begrensning som gjelder for dette nettstedet.';
$string['freemium.subscriptionplanlearnmore'] = 'Lær mer';
$string['freemium.upsell_renewexpired'] = 'Abonnementet ditt er utløpt';
$string['freemium.upsell_renewexpiring'] = 'Abonnementet ditt utløper om {{ days }} dager';
$string['freemium.upsell_renewtitle'] = 'Forny abonnementet ditt';
$string['freemium.upsell_upgradefreeaccept'] = 'Oppgradér';
$string['freemium.upsell_upgradefreemessage'] = 'Du har for øyeblikket gratisplanen, oppgrader for å låse opp flere funksjoner.';
$string['freemium.upsell_upgradefreepostpone'] = 'Senere';
$string['freemium.upsell_upgradefreetitle'] = 'Oppgradér din plan';
$string['pluginname'] = 'Moodle App språkstrenger';
$string['privacy_metadata'] = 'Denne plugin lagrer ingen brukerdata.';
