<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_oauth2', language 'no', version '4.0'.
 *
 * @package     auth_oauth2
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accountexists'] = 'Dette brukernavnet er allerede i bruk av en annen konto på denne portalen. Dersom det er din konto, logg inn på vanlig måte med brukernavn og passord og legg den til som en koblet konto via dine preferanser.';
$string['alreadylinked'] = 'Denne eksterne kontoen er allerede koblet med en brukerkontoo på denne portalen.';
$string['auth_oauth2description'] = 'OAuth 2 standardbasert autentisering';
$string['auth_oauth2settings'] = 'OAuth 2 autentiseringsinnstillinger';
$string['confirmaccountemail'] = 'Hei {$a->fullname},

En forespørsel om at det opprettes en brukerkonto på \'{$a->sitename}\' er mottatt fra din epostadresse.

Gå til denne nettadressen for å bekrefte kontoen:

{$a->link}

Enkelte e-postlesere vil av sikkerhetshensyn gjøre lenken ovenfor uklikkbar. Da må du kopiere adressen og lime den inn i adressefeltet i nettlesseren din.

OBS! Bekreft ved å klikke på denne lenken straks du har fått eposten. Går det for lang tid vil bekreftelsesprosessen automatisk bli annulert og du må begynne på nytt.

Hvis du trenger hjelp, ta kontakt med portalens administrator:
{$a->admin}';
$string['confirmaccountemailsubject'] = '{$a}: kontobekreftelse';
$string['confirmationinvalid'] = 'Bekreftelseslenken er enten ugyldig eller utgått. Vennligst start prøv å logg inn på nytt for å få tilsendt en ny epost med en gydlig bekreftelseslenke.';
$string['confirmationpending'] = 'Denne brukerkontoen venter på epostbekreftelse';
$string['confirmlinkedloginemail'] = 'Hei {$a->fullname},

En forespørsel om å lenke {$a->issuername} brukerkontoen {$a->linkedemail} til din konto på \'{$a->sitename}\' er mottatt fra din epostadresse.

Gå til denne nettadressen for å bekrefte denne koblingen:

{$a->link}

Enkelte e-postlesere vil av sikkerhetshensyn gjøre lenken ovenfor uklikkbar. Da må du kopiere adressen og lime den inn i adressefeltet i nettlesseren din.

Hvis du trenger hjelp, ta kontakt med portalens administrator:
{$a->admin}';
$string['confirmlinkedloginemailsubject'] = '{$a}: bekreftelse på kontokobling';
$string['createaccountswarning'] = 'Denne autentiseringsmodulen tillater brukere å opprette kontoer på din portalen. Det kan hende at du ønske å aktivere innstillingen "authpreventaccountcreation" dersom du bruker denne modulen.';
$string['createnewlinkedlogin'] = 'Koble til ny konto ({$a})';
$string['emailconfirmlink'] = 'Koble sammen dine kontoer';
$string['emailconfirmlinksent'] = '<p>Det ble funnet en eksisterende, men ulenket konto med denne epostadressen.</p>
<p>Kontoene må lenkes før du kan logge inn.</p>
<p>En epost skal ha blitt sendt til følgende adresse: <b>{$a}</b>.</p>
<p>Den inneholde enkle instruksjoner på hvordan du kan lenke kontoene dine.</p>
<p>Dersom du opplever noen vanskeligheter, vennligst ta kontakt med en portaladministrator.</p>';
$string['emailpasswordchangeinfo'] = 'Hei {$a->firstname},

Noen (sannsynligvis deg) har bedt om et nytt passord for kontoen din på \'{$a->sitename}\'.

Passordet ditt kan imidlertidig ikke tilbakestilles siden du bruker en oauth-konto til innlogging.

Derfor kan du bare logge inn som tidligere.
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = 'Informasjon for passordbytte';
$string['info'] = 'Ekstern konto';
$string['issuer'] = 'OAuth 2 tjeneste';
$string['issuernologin'] = 'Denne utgiveren kan ikke brukes til innlogging';
$string['linkedlogins'] = 'Koblede kontoer';
$string['linkedloginshelp'] = 'Hjelp med kontokoblinger';
$string['loginerror_authenticationfailed'] = 'Autentiseringsprosessen feilet.';
$string['loginerror_cannotcreateaccounts'] = 'Kunne ikke finne noen konto med din epostadresse.';
$string['loginerror_invaliddomain'] = 'Den epostadressen er ikke tillatt på denne portalen.';
$string['loginerror_nouserinfo'] = 'Ingen brukerinformasjon ble returnert. OAuth2-tjenesten kan være feilkonfigurert.';
$string['loginerror_userincomplete'] = 'Brukerinformasjonen som ble returnert inneholdt ikke et brukernavn og epostadresse. OAuth2-tjenesten kan være feilkonfigurert.';
$string['noissuersavailable'] = 'Ingen av de konfigurerte OAuth 2 tjenestene tillater deg å koble ulike innloggingsmetoder til samme konto.';
$string['notenabled'] = 'Beklager, OAuth2 autentisering er ikke aktivert';
$string['notloggedindebug'] = 'Innloggingsforsøket feilet. Årsak: {$a}';
$string['notwhileloggedinas'] = 'Kontokoblinger kan ikke administreres når du er logget inn som en annen bruker.';
$string['oauth2:managelinkedlogins'] = 'Administrer kontokoblinger';
$string['plugindescription'] = 'Denne autentiseringsmodulen viser en liste med konfigurerte identitetstilbydere på innloggingssiden. Ved å velge en identitetstilbyder vil brukere kunne logge inn med informasjonen knyttet til denne OAuth 2 tilbyderen.';
$string['pluginname'] = 'OAuth 2';
$string['privacy:metadata:auth_oauth2'] = 'OAuth2 autentisering';
$string['privacy:metadata:auth_oauth2:authsubsystem'] = 'Denne modulen er koblet til undersystemet for autentisering.';
$string['privacy:metadata:auth_oauth2:confirmtoken'] = 'Bekreftelsestoken.';
$string['privacy:metadata:auth_oauth2:confirmtokenexpires'] = 'Tidsstempelet for når bekreftelsestokenen utløper.';
$string['privacy:metadata:auth_oauth2:email'] = 'Den eksterne eposten som mappes til denne kontoen.';
$string['privacy:metadata:auth_oauth2:issuerid'] = 'IDen for OAuth2 tilbyderen for denne OAuth2 innloggingen.';
$string['privacy:metadata:auth_oauth2:tableexplanation'] = 'OAuth2 kontoer som er linket til brukerens Moodlekonto.';
$string['privacy:metadata:auth_oauth2:timecreated'] = 'Tidsstempelt for når brukerens konto ble lenket til OAuth2-innloggingen.';
$string['privacy:metadata:auth_oauth2:timemodified'] = 'Tidsstempelet for når opptaket ble endret.';
$string['privacy:metadata:auth_oauth2:userid'] = 'ID\'en til brukerkontoen som OAuth innlogging er lenket til.';
$string['privacy:metadata:auth_oauth2:usermodified'] = 'ID\'en til brukeren som redigerte denne kontoen.';
$string['privacy:metadata:auth_oauth2:username'] = 'Det eksterne bruknavnet som skal mappes mot denne kontoen.';
