<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_shoelace', language 'af', version '4.0'.
 *
 * @package     theme_shoelace
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alwaysdisplay'] = 'Vertoon altyd';
$string['antigravity'] = 'Terug na bo';
$string['asconfigintlower'] = '{$a->value} is minder as die onderste meetgrens van {$a->lower}';
$string['asconfigintnan'] = '{$a->value} is nie \'n getal nie';
$string['asconfigintupper'] = '{$a->value} is meer as die boonste meetgrens van {$a->upper}';
$string['backgroundcolour'] = 'Agtergrondkleur';
$string['backgroundcolourdesc'] = 'Stel die agtergrondkleur rondom die bladsy.';
$string['backgroundimage'] = 'Agtergrondprent';
$string['backgroundimagedesc'] = 'Stel die agtergrondprent rondom die bladsy.';
$string['backgroundimagestyle'] = 'Styl van agtergrondprent';
$string['backgroundimagestyledesc'] = 'Kies die styl van die agtergrondprent. Dit kan nodig wees dat jy die teks en bladsykleure verander om te pas wanneer \'Seamless\' gestel word.';
$string['backgroundtextcolour'] = 'Kleur van agtergrondteks';
$string['backgroundtextcolourdesc'] = 'Stel die kleur van die agtergrondteks rondom die bladsy.';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Shoelace</h2>
<p><img class="img-polaroid" src="shoelace/pix/screenshot.png" /></p>
</div>
<div class="well">
<h3>Inligting oor</h3>
<p>Shoelace is \'n gewysigde Moodle bootstrap-tema wat style en uitbeelders van sy moedertema erf.</p>
<h3>Moeders</h3>
<p>Hierdie tema is op die Bootstrap-tema gebaseer, wat geskep is vir Moodle 2.5 met behulp van:<br>
Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans.</p>
<h3>Temakrediete</h3>
<p>Outeur: G J Barnard<br>
Kontak: <a href="http://moodle.org/user/profile.php?id=442195">Moodle-profiel</a><br>
Webwerf: <a href="http://about.me/gjbarnard">about.me/gjbarnard</a>
</p>
<h3>Borgskappe</h3>
<p>Hierdie tema word gratis aan jou verskaf en as jy jou dankbaarheid vir die gebruik daarvan wil betoon, oorweeg asseblief \'n skenking deur:
<h4>PayPal</h4>
<p>Kontak my asseblief via my <a href="http://moodle.org/user/profile.php?id=442195" target="_blank">\'Moodle-profiel\'</a> vir besonderhede, aangesien ek as individu onder hul bepalings nie \'koop my nou\'-knoppies kan hê nie.</p>
<br>Borgskappe kan my in staat stel om jou van meer of beter funksies in \'n korter tydperk te verskaf.</p>
<h3>Rapporteer \'n fout:</h3>
<p><a href="https://github.com/gjb2048/moodle-theme_shoelace/issues">github.com/gjb2048/moodle-theme_shoelace/issues</a></p>
<h3>Meer inligting</h3>
<p><a href="shoelace/Readme.md">Hoe om hierdie tema te gebruik.</a></p>
</div></div>';
$string['columns1layout'] = 'Een kolom';
$string['columns2llayout'] = 'Twee kolomme links';
$string['columns2rlayout'] = 'Twee kolomme regs';
$string['columns3layout'] = 'Drie kolomme';
$string['columns3middlelayout'] = 'Drie kolomme met \'n middel';
$string['configtitle'] = 'Shoelace';
$string['customcss'] = 'Doelgemaakte CSS';
$string['customcssdesc'] = 'Watter CSS-reëls jy ook al by hierdie teksarea voeg, sal op elke bladsy weerspieël word, wat die doelmaak van hierdie tema vergemaklik.';
$string['displayafterlogin'] = 'Vertoon slegs ná intekening';
$string['displaybeforelogin'] = 'Vertoon slegs voor intekening';
$string['dontdisplay'] = 'Vertoon nooit';
$string['featureheading'] = 'Eienskappe';
$string['featureheadingdesc'] = 'Konfigureer die eienskapverstellings van Shoelace hier.';
$string['featureheadingsub'] = 'Eienskapverstellings';
$string['fontbasesize'] = 'Fontbasisgrootte';
$string['fontbasesizedesc'] = 'Sommige fonte vertoon te klein op die verstek grootte van 14 px. Gebruik hierdie verstelling om die basisfontgrootte tussen {$a->lower} en {$a->upper} beeldelemente te stel. Die basislynhoogte sal outomaties ses beeldelemente groter as dit wees.';
$string['fontfileeotbody'] = 'Liggaam EOT fontdokument';
$string['fontfileeotheading'] = 'Opskrif EOT fontdokument';
$string['fontfileotfbody'] = 'Liggaam OTF fontdokument';
$string['fontfileotfheading'] = 'Opskrif OTF fontdokument';
$string['fontfiles'] = 'Fontdokumente';
$string['fontfilesdesc'] = 'Laai jou fontdokument hier op.';
$string['fontfilesvgbody'] = 'Liggaam SVG fontdokument';
$string['fontfilesvgheading'] = 'Opskrif SVG fontdokument';
$string['fontfilettfbody'] = 'Liggaam TTF fontdokument';
$string['fontfilettfheading'] = 'Opskrif TTF fontdokument';
$string['fontfilewoffbody'] = 'Liggaam WOFF fontdokument';
$string['fontfilewoffheading'] = 'Opskrif WOFF fontdokument';
$string['fontfilewofftwobody'] = 'Liggaam WOFF2 fontdokument';
$string['fontfilewofftwoheading'] = 'Opskrif WOFF2 fontdokument';
$string['fontheadingdesc'] = 'Kies en voer die fonte in wat jy in jou Moodle-omgewing wil gebruik.';
$string['fontheadingsub'] = 'Fontverstellings';
$string['fontnamebody'] = 'Teksfont';
$string['fontnamebodydesc'] = 'Voer die presiese naam in van die font om vir alle ander teks te gebruik.';
$string['fontnameheading'] = 'Opskriffont';
$string['fontnameheadingdesc'] = 'Voer die presiese naam in van die font om vir opskrifte te gebruik.';
$string['fontselect'] = 'Fonttipekieser';
$string['fontselectdesc'] = 'Kies uit die lys beskikbare fontdefiniëringsmeganismes:<ul><li>\'Temafonte\' is waar die font reeds met die tema geïnstalleer is.</li><li>\'CDN-temafonte\' is waar die fonte wat deur die tema gespesifiseer is, per CDN (Content Delivery Network) gelewer word. As jy CDN-fonte gebruik, ondersoek hul onderskeie privaatheidsbeleide - kyk in templates/#cdnfonts.mustache.</li><li>\'Doelgemaakte fonte\' is waar jy die naam spesifiseer en die fontdokumente van die font oplaai. Let wel: <ul><li>Deur nie \'n fontnaam te spesifiseer nie, sal veroorsaak dat die temafont gebruik word.</li><li>As beide die opskrif- en liggaamfonte dieselfde is, spesifiseer die naam dan twee maal, maar laai slegs die fontdokument (van elke tipe wat jy het) by óf die opskrifafdeling, óf die liggaamafdeling op.</li></ul></li></ul>Berg asseblief om die opsies van jou keuse te vertoon.';
$string['fontsettings'] = 'Font';
$string['fonttypecustom'] = 'Doelgemaakte fonte';
$string['fonttypetheme'] = 'Temafonte';
$string['fonttypethemecdn'] = 'CDN-temafonte';
$string['footerdesc'] = 'Stel die onderskrifverstellings.';
$string['footerheading'] = 'Onderskrif';
$string['footersub'] = 'Onderskrifverstellings';
$string['footnote'] = 'Voetnoot';
$string['footnotedesc'] = 'Wat jy ook al by hierdie teksarea voeg, sal regdeur jou Moodle-werf in die onderskrif vertoon word.';
$string['four'] = 'Vier';
$string['frontpagedesc'] = 'Stel die voorbladverstellings.';
$string['frontpageheading'] = 'Voorblad';
$string['frontpagelayout'] = 'Voorbladuitleg';
$string['frontpagelayoutdesc'] = 'Uitleg van die voorblad.';
$string['frontpageslideshowdesc'] = 'Dit skep \'n dinamiese skyfievertoning van tot sestien skyfies vir jou om belangrike elemente van jou werf te bevorder. Die vertoning is responsief, waar prenthoogte volgens skermgrootte gestel word. Die aanbevole hoogte is 300 px. Die breedte word teen 100% gestel en dus sal die werklike hoogte kleiner wees as die breedte groter as die skermgrootte is. Teen kleiner skermgroottes word die hoogte dinamies verminder, sonder die nodigheid om aparte prente te verskaf. As verwysing: skermbreedte < 767 px = hoogte 165 px, breedte tussen 768 px en 979 px = hoogte 225 px, en breedte > 980 px = hoogte 300 px. As geen prent vir \'n skyfie gekies is nie, sal die verstek_skyfieprent in die pix-lêer gebruik word.';
$string['frontpageslideshowheading'] = 'Voorbladskyfievertoning';
$string['frontpageslideshowheadingsub'] = 'Dinamiese skyfievertoning vir die voorblad';
$string['frontpagesub'] = 'Voorbladverstellings';
$string['generalheading'] = 'Algemeen';
$string['generalheadingdesc'] = 'Konfigureer die algemene verstellings van Shoelace hier.';
$string['generalheadingsub'] = 'Algemene verstellings';
$string['gotobottom'] = 'Gaan na die onderkant van die bladsy.';
$string['hideonphone'] = 'Versteek skyfievertoning op mobiele toestelle.';
$string['hideonphonedesc'] = 'Kies of jy skyfievertoning op mobiele toestelle wil versper.';
$string['hideontablet'] = 'Versteek skyfievertoning op tablette.';
$string['hideontabletdesc'] = 'Kies of jy die skyfievertoning op tablette wil versper.';
$string['iconcolour'] = 'Ikoonkleur';
$string['iconcolour_desc'] = 'Die kleur van die ikone.';
$string['iconcoloursetting'] = 'Gebruik ikoonkleurverstelling';
$string['iconcoloursetting_desc'] = 'Gebruik die ikoonkleurverstelling vir die ikone. Die ikoonkleurfunksionaliteit is nuut. As jy probleme daarmee ervaar, skakel dit af en loop \'grunt svg\' op die Node.js-opdragaanpor. Sien asseblief \'Gruntfile.js\' vir volledige besonderhede.';
$string['invert'] = 'Keer navstafie om';
$string['invertdesc'] = 'Keer teks- en temakleur van die navstafie boaan die bladsy om.';
$string['layoutdesc'] = 'Stel die uitlegte vir die tema.';
$string['layoutheading'] = 'Uitleg';
$string['layoutsetting'] = '{$a->layout} uitleg';
$string['layoutsettingdesc'] = 'Kies die uitleg van die \'{$a->layout}\' uitleg.';
$string['layoutsub'] = 'Uitlegverstellings';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Laai assbelief jou doelgemaakte logo hier op as jy dit by die hofie wil voeg.<br>Stel die hoogte van die logo met die \'logohoogte\'-verstelling.';
$string['logoheight'] = 'Logohoogte';
$string['logoheightdesc'] = 'Logohoogte tussen {$a->lower} en {$a->upper} beeldelemente.';
$string['lookandfeeldesc'] = 'Stel die kleure van die tema.';
$string['lookandfeelheading'] = 'Voorkoms en gevoel';
$string['lookandfeelsub'] = 'Voorkoms-en-gevoel-verstellings';
$string['navbardesc'] = 'Stel die navstafieverstellings';
$string['navbarheading'] = 'Navstafie';
$string['navbarscroll'] = 'Vertoon/versteek die navstafie tydens rol';
$string['navbarscrolldesc'] = 'Rol af om die navstafie te versteek, rol meer as {$a->upamount} beeldelemente in \'n enkele beweging op of bereik amper die bokant om die navstafie te vertoon.';
$string['navbarscrollupamount'] = 'Navstafie rol-op hoeveelheid';
$string['navbarscrollupamountdesc'] = 'Hoeveelheid wat boontoe gerol moet word voordat die navstafie sal vertoon wanneer \'navstafierol\' \'Ja\' is, tussen {$a->lower} en {$a->upper} beeldelemente.';
$string['navbarsub'] = 'Navstafieverstellings';
$string['norendertemplatemethod'] = 'Kan nie templaat uitbeeld nie, uitbeeldermetode (\'{$a->callablemethod}\') nie gevind nie.';
$string['numberofslides'] = 'Aantal skyfies';
$string['numberofslidesdesc'] = 'Aantal skyfies op die glyer.';
$string['numfooterblocks'] = 'Maksimum aantal blokke per ry in die onderskrif';
$string['numfooterblocksdesc'] = 'Die maksimum blokke per ry in die onderskrif.';
$string['nummarketingblocks'] = 'Maksimum aantal blokke per ry in die voorbladbemarking (middel) area';
$string['nummarketingblocksdesc'] = 'Die maksimum blokke per ry in die voorbladbemarking (middel) area.';
$string['nummiddleblocks'] = 'Maksimum aantal blokke per ry in die middelarea';
$string['nummiddleblocksdesc'] = 'Die maksimum blokke per ry in die middelarea.';
$string['one'] = 'Een';
$string['pagecolour'] = 'Bladsykleur';
$string['pagecolourdesc'] = 'Stel die kleur van die bladsy. Dit word op modale en aftreklyste gebruik, so wanneer \'n agtergrondprent met \'Seamless\' gestel is, stel hierdie om met die tekskleur versoenbaar te wees.';
$string['pluginname'] = 'Shoelace';
$string['privacy:nop'] = 'Die Shoelace-tema berg baie verstellings wat verband hou met die konfigurasie daarvan. Geen van hierdie verstellings hou verband met \'n spesifieke gebruiker nie. Dit is jou verantwoordelikheid om te verseker dat geen gebruikerdata in enige van die vryeteksvelde ingevoer word nie. Deur \'n verstelling te stel, sal tot gevolg hê dat daardie aksie binne die kern-Moodle-logstelsel gelog word teen die gebruiker wat dit verander het; dit is buite beheer van die tema - sien asseblief die kernlogstelsel vir privaatheidsvoldoening hiervan. Wanneer prente opgelaai word, behoort jy te vermy om prente met vasgelegde liggingdata (EXIF GPS) of ander soortgelyke persoonlike data op te laai. Dit sal moontlik wees om enige ligging-/persoonlike data vanuit die prente te verkry. As jy CDN-fonte gebruik, ondersoek hul onderskeie privaatheidsbeleide - kyk in templates/#cdnfonts.mustache. Ondersoek asseblief die kode noukeurig om te verseker dat dit aan jou interpretasie van jou privaatheidswetgewing voldoen. Ek is nie \'n prokureur nie en my analise is op my interpretasie gebaseer. As jy enige twyfel ervaar, verwyder die tema onmiddellik.';
$string['readmore'] = 'Lees meer';
$string['region-footer'] = 'Onderskrif';
$string['region-middle'] = 'Middel';
$string['region-side-post'] = 'Regs';
$string['region-side-pre'] = 'Links';
$string['seamless'] = 'Naatloos';
$string['seamlessdesc'] = 'Ignoreer alle agtergrondverstellings en gebruik bladsy-/tekskleur saam met verwydering van rante/skadu\'s waar nodig. Skakel aan vir \'n duideliker voorkoms. As \'n \'agtergrondprent\' bygevoeg word, sal deursigtigheid soos geskik gebruik word.';
$string['slidebuttoncolor'] = 'Kleur van skyfieknoppie';
$string['slidebuttoncolordesc'] = 'Watter kleur die skyfie se navigasieknoppie moet wees.';
$string['slidebuttonhovercolor'] = 'Kleur van skyfieknoppiesweef';
$string['slidebuttonhovercolordesc'] = 'Watter kleur die skyfie se navigasieknoppiesweef moet wees.';
$string['slidecaption'] = 'Skyfiebyskrif';
$string['slidecaptionbackgroundcolor'] = 'Skyfiebyskrif se agtergrondkleur';
$string['slidecaptionbackgroundcolordesc'] = 'Watter kleur die skyfiebyskrif se agtergrondkleur moet wees.';
$string['slidecaptionbeside'] = 'Langs';
$string['slidecaptioncentred'] = 'Skyfiebyskrif gesentreer';
$string['slidecaptioncentreddesc'] = 'Of die skyfiebyskrif gesentreer moet wees.';
$string['slidecaptiondesc'] = 'Voer die byskrifteks in om vir die skyfie te gebruik';
$string['slidecaptionontop'] = 'Bo-op';
$string['slidecaptionoptions'] = 'Skyfiebyskrifopsies';
$string['slidecaptionoptionsdesc'] = 'Waar die byskrifte in verhouding tot die prent moet verskyn.';
$string['slidecaptiontextcolor'] = 'Skyfiebyskriftekskleur';
$string['slidecaptiontextcolordesc'] = 'Watter kleur die skyfiebyskrifteks moet wees.';
$string['slidecaptionunderneath'] = 'Onder';
$string['slideimage'] = 'Skyfieprent';
$string['slideimagedesc'] = 'Prent werk die beste as dit deursigtig is.';
$string['slideinterval'] = 'Skyfie-interval';
$string['slideintervaldesc'] = 'Skyfie-oorganginterval in millisekondes.';
$string['slideno'] = 'Skyfie {$a->slide}';
$string['slidenodesc'] = 'Voer die verstellings van skyfie {$a->slide} in.';
$string['slideshowabovemarketingpos'] = 'Skyfievertoning bokant die bemarkingsblokke';
$string['slideshowbelowmarketingpos'] = 'Skyfievertoning onder die bemarkingsblokke';
$string['slideshowmarketingpos'] = 'Posisie van skyfievertoning en bemarkingsblokke';
$string['slideshowmarketingposdesc'] = 'Stel die posisie van die skyfievertoning en bemarkingsblokke.';
$string['slidetitle'] = 'Skyfietitel';
$string['slidetitledesc'] = 'Voer \'n beskrywende titel vir jou skyfie in';
$string['slideurl'] = 'Skyfieskakel';
$string['slideurldesc'] = 'Voer die teikenbestemming van die skyfie se prentskakel in';
$string['slideurltarget'] = 'Skakelteiken';
$string['slideurltargetdesc'] = 'Kies hoe die skakel oopgemaak moet word';
$string['slideurltargetnew'] = 'Nuwe bladsy';
$string['slideurltargetparent'] = 'Moederraam';
$string['slideurltargetself'] = 'Huidige bladsy';
$string['stylefixed'] = 'Vasgestel';
$string['styleguide'] = 'Stylgids';
$string['styleguidedesc'] = 'Oorspronklike dokumentasiekode \'{$a->origcodelicenseurl}\' gelisensieer. Addisionele kode \'{$a->thiscodelicenseurl}\' gelisensieer, wat \'n \'{$a->compatible}\' lisensie is. Inhoud \'{$a->contentlicenseurl}\' gelisensieer. Die dokumentasie is vir Moodle-afvoer met bykomende FontAwesome-ikone, waar van toepassing, geformatteer. Addisionele CSS kan gevind word in die \'shoelace_admin_setting_styleguide.php\' onder die kommentaar \'// Beyond docs.css.\'. Die \'{$a->globalsettings}\' afdeling is verwyder.';
$string['styleguidesub'] = 'Bootstrap W2.3.2 Stylriglyn';
$string['stylestretch'] = 'Rek';
$string['styletiled'] = 'Teëls';
$string['syntaxhelpfive'] = 'word:';
$string['syntaxhelpfour'] = 'Byvoorbeeld:';
$string['syntaxhelpone'] = 'Wanneer enigiets (soos \'n etiket) met die tekswysiger gewysig word, omring jou kode met \'n \'pre\'-merker en voeg die class="brush: alias" by, waar \'alias\' een van die volgende is:';
$string['syntaxhelpseven'] = 'Meer inligting oor';
$string['syntaxhelpsix'] = 'As jy nie hierdie hulp op \'n kursus kan sien nie, vra die administrateur om \'Sintaksisbeligting\' vir die kursusse se kategorie te aktiveer.';
$string['syntaxhelpthree'] = 'Brush alias';
$string['syntaxhelptwo'] = 'Brush name';
$string['syntaxhighlight'] = 'Aktiveer sintaksisbeligting';
$string['syntaxhighlight_desc'] = 'Aktiveer sintaksisbeligting in kursusse. Indien \'Ja\', sal jy die verkose kategorieë met die \'sintaksisbeligtingkat\'-verstelling kan kies.';
$string['syntaxhighlightcat'] = 'Sintaksisbeligting kursuskategorieë';
$string['syntaxhighlightcatdesc'] = 'Sintaksisbeligting in kursusse binne die geselekteerde kategorieë. \'n Hulpknoppie wat \'n opspringer laat verskyn, sal by die onderskrif van kursusse binne die geselekteerde kategorieë vir kursuswysigers tydens wysiging gevoeg word.';
$string['syntaxhighlightpage'] = 'Sintaksisbeligting-hulp';
$string['textcolour'] = 'Tekskleur';
$string['textcolourdesc'] = 'Stel die kleur van die teks op die bladsy.';
$string['themecolour'] = 'Temakleur';
$string['themecolourdesc'] = 'Stel die kleur van die tema.';
$string['themetextcolour'] = 'Tematekskleur';
$string['themetextcolourdesc'] = 'Stel die kleur van die teks wanneer met die temakleur gebruik word.';
$string['three'] = 'Drie';
$string['toggleslideshow'] = 'Tokkel skyfievertoning se vertoon';
$string['toggleslideshowdesc'] = 'Kies of jy die skyfievertoning wil versteek of vertoon.';
$string['two'] = 'Twee';
