<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_musictheory', language 'pt', version '4.0'.
 *
 * @package     qtype_musictheory
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abmajor'] = 'Lá♭ Maior';
$string['abminor'] = 'lá♭ menor';
$string['acc_b'] = '♭';
$string['acc_bb'] = '♭♭';
$string['acc_n'] = '♮';
$string['acc_sharp'] = '♯';
$string['acc_x'] = 'x';
$string['alto'] = 'Dó na 3ª linha';
$string['altoclef'] = 'Clave de Dó na 3ª linha';
$string['anmajor'] = 'Lá Maior';
$string['anminor'] = 'lá menor';
$string['answerlbl'] = 'Resposta';
$string['asharpminor'] = 'lá♯ menor';
$string['aug10'] = '10ª Aumentada';
$string['aug11'] = '11ª Aumentada';
$string['aug12'] = '12ª Aumentada';
$string['aug13'] = '13ª Aumentada';
$string['aug2'] = '2ª Aumentada';
$string['aug3'] = '3ª Aumentada';
$string['aug4'] = '4ª Aumentada';
$string['aug5'] = '5ª Aumentada';
$string['aug6'] = '6ª Aumentada';
$string['aug6thfr'] = '7ª Francesa Aumentada';
$string['aug6thgr'] = '7ª Alemã Aumentada';
$string['aug6thit'] = '7ª Italiana Aumentada';
$string['aug7'] = '7ª Aumentada';
$string['aug8'] = '8ª Aumentada';
$string['aug9'] = '9ª Aumentada';
$string['augmented'] = 'Aumentada';
$string['bass'] = 'Fá';
$string['bassclef'] = 'Clave de Fá';
$string['bbmajor'] = 'Si♭ Maior';
$string['bbminor'] = 'si♭ menor';
$string['bnmajor'] = 'Si Maior';
$string['bnminor'] = 'si menor';
$string['cbmajor'] = 'Dó♭ Maior';
$string['chordquality'] = 'Classificação do acorde';
$string['chordquality-random'] = 'Classificação de acordes possíveis';
$string['chordquality_write_questionastext'] = 'Registo da resposta da classificação de acordes';
$string['chordquality_write_questionastext_help'] = '<p>Introduza uma lista de notas separadas por vírgula,
  sem espaços, usando a seguinte sintaxe:</p><p>[Uppercase letter name][Accidental
  ("n" = natural, "#" = sharp, "b" = flat, "x" = double-sharp, "bb" = double-flat)]4, ... </p>
 <p>Exemplo aleatório: <b>answer=>Dón4,Min4,Sol#4</b></p>';
$string['chordquality_write_questionasui'] = 'Registo da resposta da função harmónica';
$string['chordquality_write_questionasui_help'] = '<p>Introduza as notas carregando na pauta, depois de selecionar o tipo de alteração na barra da direita. Para apagar uma nota, carregue novamente nela.</p>';
$string['chordroot'] = 'Tónica do acorde';
$string['clef'] = 'Clave';
$string['clef-random'] = 'Claves possíveis';
$string['cnmajor'] = 'Dó maior';
$string['cnminor'] = 'dó menor';
$string['considerregister'] = 'Inclui o índice';
$string['considerregister_help'] = 'Indica se o índice da nota deve ser incluído como parte da resposta.';
$string['correctansweris'] = 'Resposta correta:';
$string['correctansweris_morethanone'] = 'Uma possível resposta correta é:';
$string['csharpmajor'] = 'Dó♯ Maior';
$string['csharpminor'] = 'dó♯ menor';
$string['dbmajor'] = 'Ré♭ Maior';
$string['dim10'] = '10ª Diminuta';
$string['dim11'] = '11ª Diminuta';
$string['dim12'] = '12ª Diminuta';
$string['dim13'] = '13ª Diminuta';
$string['dim2'] = '2ª Diminuta';
$string['dim3'] = '3ª Diminuta';
$string['dim4'] = '4ª Diminuta';
$string['dim5'] = '5ª Diminuta';
$string['dim6'] = '6ª Diminuta';
$string['dim7'] = '7ª Diminuta';
$string['dim8'] = '8ª Diminuta';
$string['dim9'] = '9ª Diminuta';
$string['diminished'] = 'Diminuta';
$string['dirasc'] = 'Acima da nota indicada';
$string['dirdesc'] = 'Abaixo da nota indicada';
$string['direction'] = 'Direção';
$string['displaykeysignature'] = 'Mostrar armação de clave';
$string['dnmajor'] = 'Ré Maior';
$string['dnminor'] = 'ré menor';
$string['dsharpminor'] = 'ré♯ menor';
$string['ebmajor'] = 'Mi♭ Maior';
$string['ebminor'] = 'mi♭ menor';
$string['emptykeysignature'] = 'Sem armação de clave';
$string['enmajor'] = 'Mi Maior';
$string['enminor'] = 'mi menor';
$string['fnmajor'] = 'Fá maior';
$string['fnminor'] = 'fá menor';
$string['fsharpmajor'] = 'Fá♯ Maior';
$string['fsharpminor'] = 'fá♯ menor';
$string['gbmajor'] = 'Sol♭ Maior';
$string['givennoteelementgroup'] = 'Nota indicada';
$string['gnmajor'] = 'Sol Maior';
$string['gnminor'] = 'sol menor';
$string['grandstaff'] = 'Pauta Dupla';
$string['gsharpminor'] = 'sol♯ menor';
$string['harmonicfunction_write_questionastext'] = 'Registo da resposta da função harmónica';
$string['harmonicfunction_write_questionastext_help'] = '<p>Introduza uma lista de notas separadas por vírgula,
  sem espaços, usando a seguinte sintaxe:</p><p>[Uppercase letter name][Accidental
  ("n" = natural, "#" = sharp, "b" = flat, "x" = double-sharp, "bb" = double-flat)]4, ... </p>
 <p>Exemplo aleatório: <b>answer=>Dón4,Min4,Sol#4</b></p>';
$string['harmonicfunction_write_questionasui'] = 'Registo da resposta da função harmónica';
$string['harmonicfunction_write_questionasui_help'] = '<p>Introduza as notas carregando na pauta, depois de selecionar o tipo de alteração na barra da direita. Para apagar uma nota, carregue novamente nela.</p>';
$string['harmonicfunctiontype-random'] = 'Possíveis funções harmónicas';
$string['hfidentifyresponsetypes'] = 'Possíveis funções harmónicas em resposta';
$string['hftype_aug6th'] = '6ª Aumentada';
$string['hftype_diatonictriad'] = 'Tríade diatónica';
$string['hftype_dom7th'] = 'Sétima da Dominante';
$string['hftype_extendeddom'] = 'Dominante Extendida';
$string['hftype_leadingtone7thfullydim'] = 'Sétima da Sensível (diminuto)';
$string['hftype_leadingtone7thhalfdim'] = 'Sétima da Sensível (meio-diminuto)';
$string['hftype_neapolitan'] = 'Napolitana';
$string['hftype_nondom7th'] = 'Acorde de sétima';
$string['hftype_secdom7th'] = 'Dominante secundária (sétima)';
$string['hftype_secdomtriad'] = 'Dominante secundária (tríade)';
$string['hftype_secltfullydim'] = 'Sensível secundária 7ª Diminuta';
$string['hftype_seclthalfdim'] = 'Sensível secundária 7ª Meio-diminuta';
$string['hftype_seclttriad'] = 'Sensível secundária tríade';
$string['hftype_secnondom7th'] = 'Acorde de sétima secundário';
$string['hftype_secnondomtriad'] = 'Acorde secundário';
$string['includealterations'] = 'Inclui alterações';
$string['includealterations_help'] = 'Indica se as alterações devem ser incluídas como parte da resposta';
$string['includestaticnote'] = 'Inclui a nota indicada';
$string['interval_write_questionastext'] = 'Registo da resposta de intervalo';
$string['interval_write_questionastext_help'] = '<p>Introduza a nota de resposta, sem espaços, utilizando a sintaxe seguinte:</p><p>[Uppercase letter name] [Accidental ("n" = natural, "#" = sharp,
 "b" = flat, "x" = double-sharp, "bb" = double-flat)] [Register (a digit between 1 and 6, following
 the scientific pitch notation)]</p><p>Exemplos:
 </p><ul><li><b>Gn5</b></li><li><b>A#4</b></li><li><b>Ebb3</b></li></ul>';
$string['interval_write_questionasui'] = 'Registo da resposta de intervalo';
$string['interval_write_questionasui_help'] = '<p>Introduza a nota carregando na pauta, depois de selecionar o tipo de alteração na barra da direita. Para apagar a nota, carregue novamente nela.</p>';
$string['javascriptrequired'] = 'Este texto será substituído por uma interface gráfica, que requer o Javascript ativo no teu browser.';
$string['keyboard_input_questionasui'] = 'Registo de resposta por teclado';
$string['keyboard_input_questionasui_help'] = '<p>Introduza notas carregando no teclado. Para apagar a nota, carregue nela novamente</p>';
$string['keymode'] = 'Tonalidade';
$string['keysignature_write_questionastext'] = 'Registo de resposta da armação de clave';
$string['keysignature_write_questionastext_help'] = '<p>Introduza uma lista de alterações separadas por vírgulas
 (entre 1 e 7 ), sem espaços, usando a seguinte notação:</p><p>[Nota com letra maiúscula]
 [Alteração ("#" = sustenido, "b" = bemol)] [ìndice (um número entre 2 e 5, seguindo a nomenclatura científica)], ... </p><p>Exemplo: <b>Lá#4,Fá#4,Sol#4</b></p>';
$string['keysignature_write_questionasui'] = 'Registo de resposta da armação de clave';
$string['keysignature_write_questionasui_help'] = '<p>Introduza alterações carregando na pauta, depois de selecionar o tipo de alteração na barra da direita. Para apagar uma alteração, carregue novamente nela.</p>';
$string['lbl_harmonicfunction'] = 'Função harmónica';
$string['maj10'] = '10ª Maior';
$string['maj13'] = '13ª Maior';
$string['maj2'] = '2ª Maior';
$string['maj3'] = '3ª Maior';
$string['maj6'] = '6* Maior';
$string['maj7'] = '7ª Maior';
$string['maj9'] = '9ª Maior';
$string['major'] = 'Maior';
$string['min10'] = '10ª menor';
$string['min13'] = '13ª menor';
$string['min2'] = '2ª menor';
$string['min3'] = '3ª menor';
$string['min6'] = '6ª menor';
$string['min7'] = '7ª menor';
$string['min9'] = '9ª menor';
$string['minor'] = 'menor';
$string['mode-random'] = 'Modos possíveis';
$string['musicqtype'] = 'Tipo de questão musical';
$string['musictheory_gradingstrategy'] = 'Estratégia de avaliação';
$string['musictheory_gradingstrategy_help'] = '<p>A estratégia de avaliação especifica como a questão será avaliada.</p>
 <p><b>Certo ou errado</b>: A resposta é comparada com a resposta correta. Se a resposta estiver correta, a cotação máxima será atribuída. Se a resposta for incorreta, será atribuído zero valores.</p>';
$string['musictheory_gradingstrategy_scale-write'] = 'Estratégia de avaliação';
$string['musictheory_gradingstrategy_scale-write_help'] = '<p>A estratégia de avaliação especifica como a questão será avaliada.</p>
 <p><b>Certo ou errado</b>: A resposta é comparada com a resposta correta. Se a resposta estiver correta, a cotação máxima será atribuída. Se a resposta for incorreta, será atribuído zero valores.</p><b>Cotação parcial para cada nota certa</b>:
 Uma estratégia de avaliação que divide a cotação de forma igual pelo número de notas que o aluno tem de introduzir, somando uma parcela por cada nota correta.</p>';
$string['musictheory_intervalelementgroup'] = 'Intervalo';
$string['musictheory_intervalelementgroup_help'] = 'Indica o tipo de intervalo.';
$string['musictheory_intervalelementgroup_random'] = 'Intervalos possíveis';
$string['nosectonic'] = '[Sem tónica secundária]';
$string['note_write_questionastext'] = 'Registo de resposta da nota';
$string['note_write_questionastext_help'] = '<p>Introduza a nota de resposta, sem espaços, usando a seguinte sintaxe:</p><p>[Nome com maíuscula] [Alteração ("n" = natural, "#" = sustenido,
 "b" = bemol, "x" = duplo sustenido, "bb" = duplo bemol] [Índice (um número entre 1 e 6, seguindo a nomenclatura científica)]</p><p>Exemplos:
 </p><ul><li><b>Soln5</b></li><li><b>Lá#4</b></li><li><b>Mibb3</b></li></ul>';
$string['note_write_questionasui'] = 'Registo de resposta da nota';
$string['note_write_questionasui_help'] = '<p>Introduza notas carregando na pauta, depois de selecionar o tipo de alteração na barra da direita. Para apagar uma nota, carregue novamente nela.</p>';
$string['notea'] = 'Lá';
$string['noteb'] = 'Si';
$string['notec'] = 'Dó';
$string['noted'] = 'Ré';
$string['notee'] = 'Mi';
$string['notef'] = 'Fá';
$string['noteg'] = 'Sol';
$string['notelbl'] = 'Nota';
$string['per11'] = '11ª Perfeita';
$string['per12'] = '12ª Perfeita';
$string['per4'] = '4ª Perfeita';
$string['per5'] = '5ª Perfeita';
$string['per8'] = '8ª Perfeita';
$string['perfect'] = 'Perfeita';
$string['pluginname'] = 'Teoria Musical';
$string['pluginname_help'] = 'Este tipo de questão permite a criação de diversos tipos de exercícios de teoria musical usando uma interface gráfica.';
$string['pluginname_link'] = 'question/type/musictheory';
$string['pluginnameadding'] = 'Adicionando uma pergunta de teoria musical';
$string['pluginnameediting'] = 'Editando uma pergunta de teoria musical';
$string['pluginnamesummary'] = 'Permite a criação de diversos tipos de exercícios de teoria musical.';
$string['possiblescalesinresponse'] = 'Tipos de escalas possíveis em resposta';
$string['qtype_chordquality-identify'] = 'Identificação de acordes';
$string['qtype_chordquality-identify-random'] = 'Identificação de acordes (aleatório)';
$string['qtype_chordquality-write'] = 'Formação de acordes';
$string['qtype_chordquality-write-random'] = 'Formação de acordes (aleatório)';
$string['qtype_harmonicfunction-identify'] = 'Identificação de funções harmónicas';
$string['qtype_harmonicfunction-identify-random'] = 'Identificação de funções harmónicas (aleatório)';
$string['qtype_harmonicfunction-write'] = 'Formação de funções harmónicas';
$string['qtype_harmonicfunction-write-random'] = 'Formação de funções harmónicas (aleatório)';
$string['qtype_interval-identify'] = 'Identificação de intervalos';
$string['qtype_interval-identify-random'] = 'Identificação de intervalos (aleatório)';
$string['qtype_interval-write'] = 'Formação de intervalos';
$string['qtype_interval-write-random'] = 'Formação de intervalos (aleatório)';
$string['qtype_keyboard-input'] = 'Introdução por teclado';
$string['qtype_keysignature-identify'] = 'Identificação de armações de claves';
$string['qtype_keysignature-identify-random'] = 'Identificação de armações de claves (aleatório)';
$string['qtype_keysignature-write'] = 'Formação de armações de claves';
$string['qtype_keysignature-write-random'] = 'Formação de armações de claves (aleatório)';
$string['qtype_musictheory_strategy_all_or_nothing'] = 'Certo ou errado';
$string['qtype_musictheory_strategy_chordqualitywrite_allornothing'] = 'Certo ou errado';
$string['qtype_musictheory_strategy_harmonicfunctionid_allornothing'] = 'Certo ou errado';
$string['qtype_musictheory_strategy_harmonicfunctionwrite_allornothing'] = 'Certo ou errado';
$string['qtype_musictheory_strategy_keyboard_allornothing'] = 'Certo ou errado';
$string['qtype_musictheory_strategy_note_allornothing'] = 'Certo ou errado';
$string['qtype_musictheory_strategy_scale_creditbynote'] = 'Cotação parcial para cada nota certa';
$string['qtype_note-identify'] = 'Identificação de notas';
$string['qtype_note-identify-random'] = 'Identificação de notas (aleatório)';
$string['qtype_note-write'] = 'Escrita de notas';
$string['qtype_note-write-random'] = 'Escrita de notas (aleatório';
$string['qtype_scale-identify'] = 'Identificação de escalas';
$string['qtype_scale-identify-random'] = 'Identificação de escalas (aleatório)';
$string['qtype_scale-write'] = 'Escrita de escalas';
$string['qtype_scale-write-random'] = 'Escrita de escalas (aleatório)';
$string['quality-random'] = 'Tipos possíveis';
$string['qualityaug'] = 'Aumentado';
$string['qualitydim'] = 'Diminuto';
$string['qualitymaj'] = 'Maior';
$string['qualitymin'] = 'menor';
$string['qualityper'] = 'Perfeito';
$string['questionoptions'] = 'Opões de resposta';
$string['questiontext'] = 'Texto da pergunta';
$string['questiontext_chordquality_identify'] = 'Identifique a tónica e o tipo do seguinte acorde';
$string['questiontext_chordquality_write'] = 'Forme o seguinte acorde';
$string['questiontext_harmonicfunction_identify'] = 'Identifique a seguinte função harmónica';
$string['questiontext_harmonicfunction_write'] = 'Forme a seguinte função harmónica';
$string['questiontext_help'] = 'Este campo não é obrigatório. Se for deixado em branco, o texto da pergunta apropriado para um determinado tipo de resposta será automaticamente apresentado nas atividades. Se introduzir texto neste campo, irá substituir o texto de pergunta gerado automaticamente.';
$string['questiontext_interval_identify'] = 'Identifique o seguinte intervalo';
$string['questiontext_interval_write_above'] = 'Forme o seguinte intervalo <b>acima</b> da nota indicada';
$string['questiontext_interval_write_below'] = 'Forme o seguinte intervalo <b>abaixo</b> da nota indicada';
$string['questiontext_keyboard_input'] = 'Introduza a nota seguinte com o teclado';
$string['questiontext_keysignature_identify_major'] = 'Determine a tonalidade Maior representada pela seguinte armação de clave';
$string['questiontext_keysignature_identify_minor'] = 'Determine a tonalidade menor representada pela seguinte armação de clave';
$string['questiontext_keysignature_write'] = 'Introduza a seguinte armação de clave';
$string['questiontext_note_identify'] = 'Identifique a seguinte nota';
$string['questiontext_note_write'] = 'Introduza a seguinte nota';
$string['questiontext_scale_identify'] = 'Identifique a escala seguinte';
$string['questiontext_scale_write'] = 'Escreva a seguinte escala de forma ascendente';
$string['questiontext_scale_write_melodic'] = 'Escreva a seguinte escala de forma ascendente e descendente';
$string['rootposition'] = '[tónica]';
$string['scale_write_questionastext'] = 'Registo de resposta de escala';
$string['scale_write_questionastext_help'] = '<p>Introduza uma lista de notas separadas por vírgula, incluíndo a tónica apresentada, sem espaços, usando a seguinte notação:</p><p>[Nota com letra maiúscula]
 [Alteração ("n" = natural, "#" = sustenido, "b" = bemol, "x" = duplo sustenido, "bb" = duplo bemol)] [ìndice (um número entre 2 e 6, seguindo a nomenclatura científica)], ... </p><p>Exemplo aleatório: <b>Tónica = Lán4 resposta=>Lán4,Sib4,Dó#5,Ré#5,Mi#5,Fá#5,Sol#5,Lán5</b></p>';
$string['scale_write_questionasui'] = 'Registo de resposta de escala';
$string['scale_write_questionasui_help'] = '<p>Introduza notas clicando na pauta, depois de selecionar o tipo de alteração na barra do lado direito. Para apagar uma nota, clique nela novamente.</p>
 <p>Nota que as alterações mantêm-se para as notas subsequentes.</p>';
$string['scaletype'] = 'Tipo de escala';
$string['scaletype-random'] = 'Tipos de escala possíveis';
$string['scaletype_harmonic'] = 'menor harmónica';
$string['scaletype_major'] = 'Maior';
$string['scaletype_melodic'] = 'menor melódica';
$string['scaletype_natural'] = 'menor natural';
$string['selectakey'] = 'Selecione uma tonalidade';
$string['selectanoption'] = 'Selecione';
$string['selectaquality'] = 'Selecione um tipo';
$string['selectasize'] = 'Selecione um tamanho';
$string['size-random'] = 'Tamanhos possíveis';
$string['size10'] = '10ª';
$string['size11'] = '11ª';
$string['size12'] = '12ª';
$string['size13'] = '13ª';
$string['size2'] = '2ª';
$string['size3'] = '3ª';
$string['size4'] = '4ª';
$string['size5'] = '5ª';
$string['size6'] = '6ª';
$string['size7'] = '7ª';
$string['size8'] = '8ª';
$string['size9'] = '9ª';
$string['tenor'] = 'Dó na 4ª linha';
$string['tenorclef'] = 'Clave de Dó na 4ª linha';
$string['tonic'] = 'Tónica';
$string['treble'] = 'Sol';
$string['trebleclef'] = 'Clave de Sol';
$string['updatemusicqtype'] = 'Atualizar opções';
$string['validation_harmonicfunctionnotsupported'] = 'Esta função harmónica não é suportada ou é inválida.';
$string['validation_harmonicfunctiontypenotselected'] = 'O tipo de função para a função harmónica especificada deve ser selecionada.';
$string['validation_interval_novalidcombo'] = 'Os tipos e tamanhos selecionados não produzem pelo menos um intervalo válido.';
$string['validation_intervaloutsidestaff'] = 'O índice da nota apresentada produz um intervalo que não cabe na pauta na clave indicada.';
$string['validation_invalidchordquality'] = 'O tipo de acorde não pode ser construído sobre a tónica especificada.';
$string['validation_invalidinterval_above'] = 'O intervalo não pode ser escrito acima da nota indicada.';
$string['validation_invalidinterval_below'] = 'O intervalo não pode ser escrito abaixo da nota indicada.';
$string['validation_noteoutsidekeyboard'] = 'Esta nota é fora do âmbito do teclado do piano.';
$string['validation_noteoutsidestaff'] = 'O índice da nota apresentada não cabe na pauta na clave indicada.';
$string['validation_possiblescaletypenotselected'] = 'O tipo de escala para o determinado tipo de escala deve ser selecionado.';
$string['validation_possiblescaletypesnotselected_random'] = 'Os possíveis tipos de escala na resposta devem incluir todos os tipos de escalas possíveis na pergunta.';
$string['validation_qualitymismatch'] = 'A combinação de intervalo e tipo é inválida.';
$string['validation_samestaticandgivennote'] = 'A nota indicada e a resposta não correspondem à mesma tecla no teclado.';
$string['validation_scale_invalidtonic'] = 'Tónica inválida para o determinado tipo de escala.';
$string['validation_scaleoutsidestaff'] = 'O índice da tónica indicada produz uma escala que não cabe na pauta na clave apresentada.';
$string['validationerror_chordquality_identify'] = 'Reposta incompleta. O nome, alteração ou tipo de acorde deve ser selecionado.';
$string['validationerror_empty'] = 'Nenhuma resposta foi providenciada.';
$string['validationerror_harmonicfunction_identify'] = 'Resposta incompleta. Todos os menus de lista devem ser selecionados.';
$string['validationerror_incompletechordquality'] = 'Resposta incompleta. Número de notas neste acorde';
$string['validationerror_incompleteharmonicfunction'] = 'Resposta incompleta. Número de notas nesta função harmónica';
$string['validationerror_interval_identify'] = 'Reposta incompleta. Tipo e tamanho devem ser selecionados.';
$string['validationerror_invalidsyntax'] = 'Sintaxe de resposta inválida.';
$string['validationerror_note_identify'] = 'Reposta incompleta. O nome, alteração e índice devem ser selecionados.';
$string['validationerror_note_identify_ltr_acc'] = 'Reposta incompleta. Nome e alteração devem ser selecionados.';
$string['validationerror_note_identify_ltr_reg'] = 'Reposta incompleta. Nome e índice devem ser selecionados.';
$string['validationerror_notewrite_twonotesingrandstaff'] = 'Duas notas foram introduzidas. Por favor, introduz apenas uma nota.';
$string['validationerror_scale_identify'] = 'Resposta incompleta. Todos os menus de lista devem ser selecionados.';
$string['validationerror_scale_incomplete'] = 'Resposta incompleta. O total de 8 notas é necessário, incluíndo a tónica apresentada.';
$string['validationerror_scale_incomplete_melodic'] = 'Resposta incompleta. O total de 15 notas é necessário, incluíndo a tónica apresentada.';
$string['validationerror_whitespace'] = 'Sintaxe de resposta inválida: remove todos os espaços da tua resposta.';
