<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_union', language 'es_mx', version '4.0'.
 *
 * @package     theme_boost_union
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitybrandingtab'] = 'Marcado personalizado de actividad';
$string['activityiconcoloradministrationsetting'] = 'Color del ícono de actividad para "Administración"';
$string['activityiconcoloradministrationsetting_desc'] = 'El color del ícono de actividad para "Administración"';
$string['activityiconcolorassessmentsetting'] = 'Color del ícono de actividad para "Evaluación"';
$string['activityiconcolorassessmentsetting_desc'] = 'El color del ícono de actividad para "Evaluación"';
$string['activityiconcolorcollaborationsetting'] = 'Color del ícono de actividad para "Colaboración"';
$string['activityiconcolorcollaborationsetting_desc'] = 'El color del ícono de actividad para "Colaboración"';
$string['activityiconcolorcommunicationsetting'] = 'Color del ícono de actividad para "Comunicación"';
$string['activityiconcolorcommunicationsetting_desc'] = 'El color del ícono de actividad para "Comunicación"';
$string['activityiconcolorcontentsetting'] = 'Color del ícono de actividad para "Contenido"';
$string['activityiconcolorcontentsetting_desc'] = 'El color del ícono de actividad para "Contenido"';
$string['activityiconcolorinterfacesetting'] = 'Color del ícono de actividad para "InterfazColor del ícono de actividad para "Evaluación""';
$string['activityiconcolorinterfacesetting_desc'] = 'El color del ícono de actividad para "Interfaz"';
$string['activityiconcolorsheading'] = 'Colores de ícono de actividad';
$string['activitynavigation'] = 'Navegación de actividad';
$string['activitynavigationsetting'] = 'Elementos de navegación de actividad';
$string['activitynavigationsetting_desc'] = 'Con esta configuración son mostrados los elementos para saltar a la actividad/recurso siguiente y anterior, y el menú desplegable para saltar a una actividad/recurso distinto. Los elementos de la interfaz del usuario similares a esto ya existían en Boost en el Moodle estándar hasta Moodle 3.11, pero fueron eliminados en 4.0. Con Boost Union, usted puede volver a tenerlos.';
$string['activitypurposeadministration'] = 'Administración';
$string['activitypurposeassessment'] = 'Evaluación';
$string['activitypurposecollaboration'] = 'Colaboración';
$string['activitypurposecommunication'] = 'Comunicación';
$string['activitypurposecontent'] = 'Contenido';
$string['activitypurposeheading'] = 'Propósitos de ícono de actividad';
$string['activitypurposeheading_desc'] = 'Con estas configuraciones, usted puede anular el color del fondo del ícono de actividad, el cual está definido por el propósito de la actividad (y que es una característica fijada del plugin en cada actividad).';
$string['activitypurposeinterface'] = 'Interfaz';
$string['activitypurposeother'] = 'Otro';
$string['additionalresourcesfileurlpersistent'] = 'URL (persistente)';
$string['additionalresourcesfileurlrevisioned'] = 'URL (revisada)';
$string['additionalresourcesheading'] = 'Recursos adicionales';
$string['additionalresourceslistsetting'] = 'Lista de recursos adicionales';
$string['additionalresourceslistsetting_desc'] = 'Esta es la lista de archivos que usted ha subido al área de archivos de recursos adicionales. Las URLS dadas pueden ser usadas para enlazar a estos archivos desde adentro de su CSS personalizado, desde la nota al pie, o desde lugares en donde usted necesite usar archivos subidos pero que no pueda subirlos.';
$string['additionalresourcessetting'] = 'Recursos adicionales';
$string['additionalresourcessetting_desc'] = 'Con esta configuración usted puede subir recursos adicionales al tema. La ventaja de subir archivos a esta área es que esos archivos pueden ser proporcionados sin una comprobación de que el usuario esté ingresado al sitio. Esto es también la razón por la cual usted solamente debería de añadir archivos que NO SON  críticos y a los cuales todos deberían de tener permitido acceder y que no necesitan estar protegidos con un ingreso válido al sitio. Tan pronto como usted haya subido al menos un archivo a esta área de archivos y haya guardado la configuración, aparecerá una lista debajo que le dará la URL que usted puede usar para referenciar un archivo particular.';
$string['backgroundimagesetting'] = 'Imagen del fondo';
$string['backgroundimagesetting_desc'] = 'Aquí puede usted subir una imagen personalizada para mostrar como fondo del sitio. La imagen del fondo que usted suba sobre-escribirá la imagen del fondo en los archivos de su pre-configuración del tema.';
$string['backgroundimagesheading'] = 'Imágenes del fondo general';
$string['backtotop'] = 'Regresar a Superior';
$string['backtotopbuttonsetting'] = 'Botón para Regresar a Superior';
$string['backtotopbuttonsetting_desc'] = 'Con esta configuración, aparecerá un botón para regresar a superior en la esquina inferior derecha de la página tan pronto como el usuario se desplace a la parte inferior de la página. Un botón como este ya existía en Boost en el Moodle estándar hasta Moodle 3.11, pero fue eliminado en Moodle 4.0. Con Boost Union usted puede tenerlo de regreso..';
$string['blockregionfooterwidth'] = 'Ancho de la región de bloque para región de \'Pie de página\'';
$string['blockregionfooterwidth_desc'] = 'Con esta configuración, usted puede configurar el ancho de la región del bloque \'Pie de página\'. Usted puede elegir entre ancho completo, ancho del contenido del curo y ancho heroico.';
$string['blockregionoutsidebottomwidth'] = 'Ancho de región de bloque \'Afuera (inferior)\'';
$string['blockregionoutsidebottomwidth_desc'] = 'Con esta configuración usted puede configurar el ancho de la región del bloque \'Afuera (fondo) que es mostrado debajo del contenido principal. Usted puede elegir entre ancho completo, contenido del curo y ancho heroico.';
$string['blockregionoutsideleftwidth'] = 'Ancho de región de bloque \'Afuera (izquierda)\'';
$string['blockregionoutsideleftwidth_desc'] = 'Con esta configuración usted puede configurar el ancho de la región del bloque \'Afuera (izquierda) que es mostrada en el lado izquierdo del área principal de contenido. Boost Union usa un ancho de 300px. Usted puede escribir otros valores en pixeles como por ejemplo 200px. pero también puede ingresar un valor basado en porcentaje como 10% o un valor de ancho del punto de vista como 10vw.';
$string['blockregionoutsiderightwidth'] = 'Ancho de región de bloque \'Afuera (derecha)\'';
$string['blockregionoutsiderightwidth_desc'] = 'Con esta configuración usted puede configurar el ancho de la región del bloque \'Afuera (derecha) que es mostrada en el lado derecho del área principal de contenido. Boost Union usa un ancho de 300px. Usted puede escribir otros valores en pixeles como por ejemplo 200px. pero también puede ingresar un valor basado en porcentaje como 10% o un valor de ancho del punto de vista como 10vw.';
$string['blockregionoutsidetopwidth'] = 'Ancho de región de bloque \'Afuera (superior)\'';
$string['blockregionoutsidetopwidth_desc'] = 'Con esta configuración usted puede configurar el ancho de la región del bloque \'Afuera (superior) que es mostrada en la parte más superior de la página. Usted puede elegir entre ancho completo, contenido del curo y ancho heroico.';
$string['blockregionsforlayout'] = 'Regiones de bloque adicionales para el diseño \'{$a}\'';
$string['blockregionsforlayout_desc'] = 'Con esta configuración, usted puede habilitar regiones de bloque adicionales para el diseño \'{$a}\'.';
$string['blockregionsheading'] = 'Regiones de bloque adicionales';
$string['blocksgeneralheading'] = 'Bloques generales';
$string['blockstab'] = 'Bloques';
$string['boost_union:configure'] = 'Poder configura el tema como no-admin';
$string['boost_union:editregioncontentlower'] = 'Poder editar la región del bloque del Contenido (inferior)';
$string['boost_union:editregioncontentupper'] = 'Poder editar la región del bloque del Contenido (superior)';
$string['boost_union:editregionfootercenter'] = 'Poder editar la región del bloque del Pie de página (centro)';
$string['boost_union:editregionfooterleft'] = 'Poder editar la región del bloque del Pie de página (izquierda)';
$string['boost_union:editregionfooterright'] = 'Poder editar la región del bloque del Pie de página (derecha)';
$string['boost_union:editregionheader'] = 'Poder editar la región del bloque del Encabezado';
$string['boost_union:editregionoffcanvascenter'] = 'Poder editar la región del bloque de Afuera-del-lienzo (centro)';
$string['boost_union:editregionoffcanvasleft'] = 'Poder editar la región del bloque de Afuera-del-lienzo (izquierda)';
$string['boost_union:editregionoffcanvasright'] = 'Poder editar la región del bloque de Afuera-del-lienzo (derecha)';
$string['boost_union:editregionoutsidebottom'] = 'Poder editar la región del bloque del Afuera (inferior)';
$string['boost_union:editregionoutsideleft'] = 'Poder editar la región del bloque del Afuera (izquierda)';
$string['boost_union:editregionoutsideright'] = 'Poder editar la región del bloque del Afuera (derecha)';
$string['boost_union:editregionoutsidetop'] = 'Poder editar la región del bloque del Afuera (superior)';
$string['boost_union:viewhintcourseselfenrol'] = 'Poder ver una pista para auto inscripción irrestricta en un curso visible.';
$string['boost_union:viewhintinhiddencourse'] = 'Poder ver una pista en un curso oculto.';
$string['boost_union:viewregioncontentlower'] = 'Poder ver la región del bloque del Contenido (inferior)';
$string['boost_union:viewregioncontentupper'] = 'Poder ver la región del bloque del Contenido (superior)';
$string['boost_union:viewregionfootercenter'] = 'Poder ver la región del bloque del Pie de página (centro)';
$string['boost_union:viewregionfooterleft'] = 'Poder ver la región del bloque del Pie de página (izquierda)';
$string['boost_union:viewregionfooterright'] = 'Poder ver la región del bloque del Pie de página (derecha)';
$string['boost_union:viewregionheader'] = 'Poder ver la región del bloque del Encabezado';
$string['boost_union:viewregionoffcanvascenter'] = 'Poder ver la región del bloque de Fuera-del-lienzo (centro)';
$string['boost_union:viewregionoffcanvasleft'] = 'Poder ver la región del bloque de Fuera-del-lienzo (izquierda)';
$string['boost_union:viewregionoffcanvasright'] = 'Poder ver la región del bloque de Fuera-del-lienzo (derecha)';
$string['boost_union:viewregionoutsidebottom'] = 'Poder ver la región del bloque de Afuera (inferior)';
$string['boost_union:viewregionoutsideleft'] = 'Poder ver la región del bloque de Afuera (izquierda)';
$string['boost_union:viewregionoutsideright'] = 'Poder ver la región del bloque de Afuera (derecha)';
$string['boost_union:viewregionoutsidetop'] = 'Poder ver la región del bloque de Afuera (superior)';
$string['bootstrapcolordangersetting'] = 'Color Bootstrap para "Peligro"';
$string['bootstrapcolordangersetting_desc'] = 'El color Bootstrap para "Peligro"';
$string['bootstrapcolorinfosetting'] = 'Color Bootstrap para "Info"';
$string['bootstrapcolorinfosetting_desc'] = 'El color Bootstrap para "Info"';
$string['bootstrapcolorsheading'] = 'Colores Bootstrap';
$string['bootstrapcolorsuccesssetting'] = 'Color Bootstrap para "Éxito"';
$string['bootstrapcolorsuccesssetting_desc'] = 'El color Bootstrap para "Éxito"';
$string['bootstrapcolorwarningsetting'] = 'Color Bootstrap para "Advertencia"';
$string['bootstrapcolorwarningsetting_desc'] = 'El color Bootstrap para "Advertencia"';
$string['bootstrapdangercolor'] = 'Color de peligro';
$string['bootstrapdarkcolor'] = 'Color oscuro';
$string['bootstrapinfocolor'] = 'Color de información';
$string['bootstraplightcolor'] = 'Color claro';
$string['bootstrapnone'] = 'Sin color Bootstrap';
$string['bootstrapprimarycolor'] = 'Color primario';
$string['bootstrapsecondarycolor'] = 'Color secundario';
$string['bootstrapsuccesscolor'] = 'Color de éxito';
$string['bootstrapwarningcolor'] = 'Color de advertencia';
$string['brandcolorsheading'] = 'Color de la marca';
$string['breadcrumbsheading'] = 'Camino de migajas';
$string['cachedef_flavours'] = 'Sabores que aplican a una ID de categoría de página dad para el usuario actual';
$string['cachedef_fontawesome'] = 'Archivos FontAwesome (que son subidos en las configuraciones de Boost Union)';
$string['categorybreadcrumbs'] = 'Mostrar el camino de migajas de categoría en el encabezado del curso';
$string['choosereadme'] = 'El tema Boost Union es un tema mejorado hijo de Boost proporcionado por Moodle an Hochschulen e.V.';
$string['closeoffcanvas'] = 'Cerrar cajón Off-canvas';
$string['configtitle'] = 'Boost Union';
$string['configtitlecontent'] = 'Contenido';
$string['configtitlefeel'] = 'Sensación';
$string['configtitleflavours'] = 'Sabores';
$string['configtitlefunctionality'] = 'Funcionalidad';
$string['configtitlelook'] = 'Aspecto';
$string['contactcontentsetting'] = 'Contenido de página de contacto';
$string['contactcontentsetting_desc'] = 'En esta configuración, usted puede añadir contenido de texto enriquecido que será mostrado en una página para contacto (que no es la misma que la página incluida en Moodle de "Ponerse en contacto con soporte del sitio").';
$string['contactdisabled'] = 'La página de contacto está deshabilitada para este sitio. Aquí no hay nada para ver.';
$string['contactheading'] = 'Contacto';
$string['contactlinkpositionboth'] = 'Añadir un enlace a la página de contacto a la nota al pie y al ícono del pie de página (signo de interrogación)';
$string['contactlinkpositionfooter'] = 'Añadir un enlace a la página de contacto al ícono del pie de página (signo de interrogación)';
$string['contactlinkpositionfootnote'] = 'Añadir un enlace a la página de contacto de la nota al pie';
$string['contactlinkpositionnone'] = 'No mostrar automáticamente un enlace a la página de contacto';
$string['contactlinkpositionsetting'] = 'Posición del enlace de página de contacto';
$string['contactlinkpositionsetting_desc'] = 'En esta configuración usted puede configurar si es que debería ser añadido automáticamente o no un enlace a la página de contacto a la página de Moodle. Si usted no quiere mostrar automáticamente un enlace, usted puede añadir manualmente un enlace a {$a->url} desde cualquier lugar en Moodle.';
$string['contactpagetitledefault'] = 'Contacto';
$string['contactpagetitlesetting'] = 'Título de página de contacto';
$string['contactpagetitlesetting_desc'] = 'En esta configuración usted puede definir el título de la página de contacto. Este texto será usado como texto de enlace hacia la página de contacto también si usted configura apropiadamente \'Posición de enlace de página de contacto\'.';
$string['contentwidthheading'] = 'Ancho del contenido';
$string['coursecontentmaxwidthsetting'] = 'Ancho máximo de contenido del curso';
$string['coursecontentmaxwidthsetting_desc'] = 'Con esta configuración, usted puede anular el ancho del contenido del curso de Moodle sin modificaciones manuales de SCSS. Este ancho es usado como el ancho de la página de las páginas de curso y dentro de ciertas actividades. de forma predeterminada, Moodle usa un ancho máximo de contenido del curso de 830 px. Usted puede ingresar ya sea valores en pixeles como 1200px, pero también puede ingresar un valor basado en porcentaje como 100%, o un valor de ancho del portal de vista como 90vw.';
$string['courseheaderheading'] = 'Encabezado  del curso';
$string['courseheaderimageenabled'] = 'Mostrar la imagen del curso en el encabezado del curso';
$string['courseheaderimageenabled_desc'] = 'Cuando se habilita, la imagen del curso (la cual puede ser subida en las configuraciones del curso) es mostrada en el encabezado de un curso. Las imágenes del curso son mostradas allí adicionalmente a la página de \'Mis cursos\' donde siempre  son mostradas.';
$string['courseheaderimagefallback'] = 'Imagen de reserva del encabezado del curso';
$string['courseheaderimagefallback_desc'] = 'Si usted sube una imagen en esta configuración, es usada como imagen en caso de necesidad y es mostrada en el encabezado del curso cuando no se ha subido una imagen del curso en las configuraciones de un curso en particular. Si usted no sube una imagen aquí, una imagen del encabezado del curso solamente es mostrada en un curso particular si una imagen de curso es subida en estas configuraciones de este curso en particular.';
$string['courseheaderimageheight'] = 'Altura de imagen del encabezado del curso';
$string['courseheaderimageheight_desc'] = 'Con esta configuración usted controla la altura de la imagen del encabezado del curso presentado.';
$string['courseheaderimagelayout'] = 'Diseño de imagen de encabezado del curso';
$string['courseheaderimagelayout_desc'] = 'Con esta configuración, usted controla el diseño de la imagen del encabezado del curso y el título del curso.';
$string['courseheaderimagelayoutheadingabove'] = 'Título del curso arriba de la imagen del curso';
$string['courseheaderimagelayoutstackeddark'] = 'Título del curso apilado sobre la imagen del curso (color blanco de font para imágenes de fondo oscuras)';
$string['courseheaderimagelayoutstackedlight'] = 'Titulo del curso apilado sobre la imagen del curso (color negro del font para imágenes claras del fondo)';
$string['courseheaderimageposition'] = 'Posición de la imagen del encabezado del curso';
$string['courseheaderimageposition_desc'] = 'Con esta configuración, usted controla la posición de la imagen del encabezado del curso dentro del contenedor de la imagen del encabezado del curso. El primer valor es la posición horizontal, el segundo valor es la posición vertical.';
$string['courserelatedhintsheading'] = 'Pistas relacionadas con el curso';
$string['coursestab'] = 'Cursos';
$string['coursetab'] = 'Curso';
$string['cssh5pheading'] = 'CSS crudo para H5P';
$string['cssh5psetting'] = 'CSS crudo para H5P';
$string['cssh5psetting_desc'] = 'Use este campo para proporcionar código CSS que será aplicado a la presentación de contenido H5P por mod_h5p y mod_hvp. Por favor inspeccione los tipos de contenido H5P para encontrar los selectores CSS necesarios.ectors.';
$string['customfontsfileurlpersistent'] = 'URL (persistente)';
$string['customfontsfileurlrevisioned'] = 'URL (revisada)';
$string['customfontsheading'] = 'Fonts personalizados';
$string['customfontslistsetting'] = 'Lista de fonts personalizados';
$string['customfontssetting'] = 'Fonts personalizados';
$string['dontchange'] = 'No cambiar nada';
$string['emailbrandinghtmldemobody'] = '<p>E-Mail inicia aquí.</p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p><p>Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.</p><p>Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.</p><p>Aquí termina E-Mail body.</p>';
$string['emailbrandinghtmlheading'] = 'Previsualización de E-mail HTML';
$string['emailbrandinghtmlintro'] = 'Esta es una pre-visualización de un E-mail HTML  basado en los prefijos y sufijos del marcado personalizado que están actualmente configurados en el paquete de idioma.';
$string['emailbrandinghtmlnopreview'] = 'Hasta ahora, los E-mails en HTML no han sido personalizados dentro de esta característica. Los E-mails serán compuestos y enviados normalmente.';
$string['emailbrandinginstruction'] = 'Cómo';
$string['emailbrandinginstruction0'] = 'Con esta característica de Boost Union usted puede aplicar personalización de su marca a todos los E-mails que Moodle esté enviando.';
$string['emailbrandinginstructionli1'] = 'Vaya a la <a href="{$a->url}" target="_blank">página de configuraciones de la personalización del idioma</a> para abrir el paquete del idioma <em>{$a->lang}</em> para editarlo.';
$string['emailbrandinginstructionli2'] = 'Busque y modifique estas cadenas de caracteres en el paquete <code>theme_boost_union language</code> :';
$string['emailbrandinginstructionli2li1'] = '<code>templateemailhtmlprefix</code>: Este cachito será añadido <em>al principio / antes del body</em> de todos los <em>E-mails en HTML</em> que Moodle esté enviando.';
$string['emailbrandinginstructionli2li2'] = '<code>templateemailhtmlsuffix</code>: Este cachito será añadido <em>al final de / después del body</em> de todos los <em>E-mails HTML</em> que Moodle esté enviando.';
$string['emailbrandinginstructionli2li3'] = '<code>templateemailtextprefix</code>: Este cachito será añadido <em>al principio de / antes del body</em> de todos los <em>E-mails en texto simple</em> que Moodle esté enviando.';
$string['emailbrandinginstructionli2li4'] = '<code>templateemailtextsuffix</code>: Este cachito será añadido <em>al final de / después del body</em> de todos los <em>E-mails en texto simple</em> que Moodle esté enviando.';
$string['emailbrandinginstructionli3'] = 'Guardar los cambios al paquete de idioma';
$string['emailbrandinginstructionli4'] = 'Regrese a esta página y échele un ojo a las vistas previas de E-mail debajo.';
$string['emailbrandingintroheading'] = 'Introducción';
$string['emailbrandingintronote'] = 'Por favor tenga en cuenta: Esta es una funcionalidad avanzada que usa algunos trucos para proporcionar opciones de marcado personalizado del E-mail. Por favor siga las instrucciones de cerca.';
$string['emailbrandingpitfalls'] = 'Riesgos';
$string['emailbrandingpitfalls0'] = 'Usando esta característica, hay algunas desventajas que usted debería de conocer:';
$string['emailbrandingpitfallsli1'] = 'Es necesario que usted modifique las cadenas de texto del idioma del <em>idioma predeterminado actual</em> de este sitio. Aun y cuando usted tuviera varios paquetes de idioma instalados, solamente tendrán un efecto los cambios al idioma predeterminado.';
$string['emailbrandingpitfallsli2'] = 'El respetar el idioma del destinatario no es posible. Así pues, usted debería de usar términos agnósticos del idioma dentro de sus textos de marcado personalizado de "snippets" (fragmentitos de código) del E-mail.';
$string['emailbrandingpitfallsli3'] = 'Si usted alguna vez cambia el idioma predeterminado del sitio en el futuro, usted tendrá que migrar las cadenas de texto del paquete de idioma modificadas al nuevo paquete de idioma predeterminado.';
$string['emailbrandingtab'] = 'Marcado personalizado de E-mail';
$string['emailbrandingtextdemobody'] = 'Aquí principia el body del E-mail.

Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.

Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.

Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.

El body del E-mail termina aquí.';
$string['emailbrandingtextheading'] = 'Previsualización de E-mail texto simple';
$string['emailbrandingtextintro'] = 'Esta es una vista previa de un E-mail a texto simple basado en los prefijos y sufijos del marcado personalizado que actualmente están configurados en el paquete de idioma.';
$string['emailbrandingtextnopreview'] = 'Hasta ahora, los E-mails en texto simple no han sido personalizados dentro de esta característica. Los E-mails serán compuestos y enviados normalmente.';
$string['enablecontactsetting'] = 'Habilitar página de contacto';
$string['enablehelpsetting'] = 'Habilitar página de ayuda';
$string['enableimprintsetting'] = 'Habilitar imprimir';
$string['enablemaintenancesetting'] = 'Página de información de mantenimiento habilitado';
$string['error:infobannerdismissnonotdismissible'] = 'El banner de información dado no es descartable';
$string['error:infobannerdismissnonotvalid'] = 'El número del banner de información dado no es válido';
$string['faviconheading'] = 'Favicon';
$string['faviconsetting'] = 'Favicon';
$string['faviconsetting_desc'] = 'Aquí puede usted subir una imagen personalizada (formato .ico o .png) que el navegador mostrará como el favicon (ícono favorito) de su sitio web Moodle. Si no sube un favicon personalizado, será usado un favicon estándar de Moodle.';
$string['flavoursappliesto'] = 'Aplica a';
$string['flavoursapplytocategories'] = 'Aplicar a categorías de curso';
$string['flavoursapplytocategories_help'] = 'Aquí usted define si es que este sabor debería de ser aplicado a categorías de curso.';
$string['flavoursapplytocategories_ids'] = 'Categorías de curso';
$string['flavoursapplytocategories_ids_help'] = 'Aquí usted define una o más categorías particulares de curso a las que debería aplicarse este sabor. Tan pronto como la página renderizada de Moodle sea localizada adentro de una de las categorías configuradas, el sabor será aplicado.';
$string['flavoursapplytocohorts'] = 'Aplicar a cohortes';
$string['flavoursapplytocohorts_help'] = 'Aquí usted define si es que este sabor debería de ser aplicado a cohortes';
$string['flavoursapplytocohorts_ids'] = 'Cohortes';
$string['flavoursbackgroundimage'] = 'Imagen del fondo';
$string['flavoursbackgroundimage_help'] = 'Con esta configuración el sabor sobre-escribirá la imagen del fondo que está configurada en las configuraciones de aspecto de Boost Union.';
$string['flavoursbacktooverview'] = 'Regresar a vista general de sabor';
$string['flavourscreateflavour'] = 'Crear sabor';
$string['flavourscustomcss'] = 'CSS personalizado';
$string['flavoursdelete'] = 'Eliminar';
$string['flavoursdeleteconfirmation'] = '¿Realmente desea eliminar el sabor <em>{$a}</em>?';
$string['flavoursdeleteflavour'] = 'Eliminar sabor';
$string['flavoursdescription'] = 'Descripción';
$string['flavoursdescription_help'] = 'La descripción del sabor es solamente usada internamente para permitirle identificar un sabor particular en la lista de sabores.';
$string['flavoursedit'] = 'Editar';
$string['flavourseditflavour'] = 'Editar sabor';
$string['flavoursfavicon'] = 'Favicon';
$string['flavoursfavicon_help'] = 'Con esta configuración el sabor sobre-escribirá al favicon que está configurado en las configuraciones de aspecto de Boost Union.';
$string['flavoursflavours'] = 'Sabores';
$string['flavoursgeneralsettings'] = 'Configuraciones generales';
$string['flavoursincludesubcategories'] = 'Incluir subcategorías';
$string['flavoursincludesubcategories_help'] = 'Si se activa, el sabor también será aplicado a las subcategorías de las categorías elegidas.';
$string['flavourslogo'] = 'Logo';
$string['flavourslogo_help'] = 'Con esta configuración el sabor sobre-escribirá al logo que está configurado en las configuraciones de aspecto de Boost Union.';
$string['flavourslogocompact'] = 'Logo cvompacto';
$string['flavourslogocompact_help'] = 'Con esta configuración el sabor sobre-escribirá al logo que está configurado en las configuraciones de aspecto de Boost Union.';
$string['flavoursnothingtodisplay'] = 'No hay ningún sabor creado aun. Por favor cree su primer sabor para hacer que las cosas funcionen.';
$string['flavoursnotificationcreated'] = 'El sabor fue creado exitosamente';
$string['flavoursnotificationdeleted'] = 'El sabor fue eliminado exitosamente';
$string['flavoursnotificationedited'] = 'El sabor fue editado exitosamente';
$string['flavourspreview'] = 'Vista previa';
$string['flavourspreviewblindtext'] = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Nunc id cursus metus aliquam eleifend mi in nulla. Felis imperdiet proin fermentum leo vel orci porta. Sed nisi lacus sed viverra tellus in hac habitasse. Vivamus arcu felis bibendum ut. Nisi porta lorem mollis aliquam ut porttitor. Odio euismod lacinia at quis risus sed vulputate odio. Sed felis eget velit aliquet sagittis id consectetur purus. Nec ullamcorper sit amet risus nullam eget. Pellentesque sit amet porttitor eget dolor. Cursus mattis molestie a iaculis at erat pellentesque.';
$string['flavourspreviewflavour'] = 'Previsualizar sabor';
$string['flavourstitle'] = 'Título';
$string['flavourstitle_help'] = 'El título del sabor solamente es usado internamente para permitirle documentar un sabor particular en la lista de sabores.';
$string['fontawesomecheck-fa6free-filter-title'] = 'Filtro FontAwesome';
$string['fontawesomecheck-fa6free-general-description'] = 'Si usted ve el ícono de una palomita al lado izquierdo, FontAwesome esta generalmente funcionando en su sitio.';
$string['fontawesomecheck-fa6free-general-title'] = 'Funcionalidad general';
$string['fontawesomecheck-fa6free-newstuff-title'] = 'Íconos de FontAwesome 6';
$string['fontawesomecheckssetting'] = 'Comprobaciones FontAwesome';
$string['fontawesomefilessetting'] = 'Archivos FontAwesome';
$string['fontawesomeheading'] = 'FontAwesome';
$string['fontawesomelistfileinfo-fa6free-css-brands.min.css'] = 'Este es un archivo CSS adicional que añade el font para íconos de marca de FontAwesome a la página Moodle.';
$string['fontawesomelistfileinfo-fa6free-css-fontawesome.min.css'] = 'Este es el archivo CSS principal que añade todos los glifos de FontAwesome a la página Moodle.';
$string['fontawesomelistfileinfo-fa6free-css-regular.min.css'] = 'Este es un archivo CSS adicional que añade el font para íconos regulares de FontAwesome a la página Moodle.';
$string['fontawesomelistfileinfo-fa6free-css-solid.min.css'] = 'Este es un archivo CSS adicional que añade el font para íconos sólidos de FontAwesome a la página Moodle.';
$string['fontawesomelistfileinfo-fa6free-css-v4-font-face.min.css'] = 'Este es un archivo CSS adicional que se asegura que los íconos de FontAwesome 4 en Moodle todavía sean mostrados correctamente.';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-brands-400.ttf'] = 'Este es el archivo del font para los íconos del marcado de FontAwesome (en el formato TTF).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-brands-400.woff2'] = 'Este es el archivo del font para los íconos del marcado de FontAwesome (en el formato WOFF2).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-regular-400.ttf'] = 'Este es el archivo del font para los íconos regulares de FontAwesome (en el formato TTF).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-regular-400.woff2'] = 'Este es el archivo del font para los íconos regulares de FontAwesome (en el formato WOFF2).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-solid-900.ttf'] = 'Este es el archivo del font para los íconos sólidos de FontAwesome (en el formato TTF).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-solid-900.woff2'] = 'Este es el archivo del font para los íconos sólidos de FontAwesome (en el formato WOFF2).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-v4compatibility.ttf'] = 'Este es el archivo del font para la compatibilidad con FontAwesome 4 (en el formato TTF).';
$string['fontawesomelistfileinfo-fa6free-webfonts-fa-v4compatibility.woff2'] = 'Este es el archivo del font para la compatibilidad con FontAwesome 4 (en el formato WOFF2).';
$string['fontawesomelistmandatorymissing'] = 'Es un archivo indispensable para que funcione FontAwesome, pero No fue subido apropiadamente. Por favor intente subirlo apropiadamente.';
$string['fontawesomelistmandatoryuploaded'] = 'Es un archivo indispensable para que funcione FontAwesome y fue subido apropiadamente.';
$string['fontawesomelistnote'] = 'Por favor tenga en cuenta que si usted sube solamente una fracción de los archivos obligatorios, los íconos de FontAwesome pueden aparecer como rotos en la página de Moodle. Esto no puede arreglarse hasta que usted suba todos los archivos obligatorios o quite de nuevo todos los archivos.';
$string['fontawesomelistoptionalmissing'] = 'Este es un archivo opcional para mejorar el conjunto de íconos de FontAwesome, pero no fue subido. Está bien siempre y cuando usted no los necesite.';
$string['fontawesomelistoptionaluploaded'] = 'Este es un archivo opcional para mejorar el conjunto de íconos de FontAwesome y fue subido apropiadamente.';
$string['fontawesomelistsetting'] = 'Lista de archivos de FontAwesome';
$string['fontawesomeversionfa6free'] = 'Actualizar a FontAwesome 6 Libre';
$string['fontawesomeversionnone'] = 'Conservar FontAwesome 4 (como se incluye con Moodle estándar)';
$string['fontawesomeversionsetting'] = 'Versión de FontAwesome';
$string['fontawesomeversionsetting_desc'] = 'Moodle estándar viene con íconos de FontAwesome 4, que están bien, pero FontAwesome ya ha evolucionado desde entonces. Si usted quiere usar íconos más recientes de FontAwesome, usted puede hacerlo con esta configuración. Tan pronto como usted elija otra versión diferente de FontAwesome 4, aparecerán configuraciones adicionales en donde usted puede subir versiones más recientes de FontAwesome.';
$string['footertab'] = 'Pie de página';
$string['footnoteheading'] = 'Nota al pie';
$string['footnotesetting'] = 'Nota al pie';
$string['footnotesetting_desc'] = 'Todo lo que usted escriba en esta área de texto será mostrado al final de una página, en el pie de página( no en el pie de página flotante) de todas las páginas que usen el diseño de "cajones", "columnas2" o"ingreso". El contenido en esta área podría ser, por ejemplo, para Copyright (Derechos Reservados), los términos de uso, o el nombre de su organización. <br/> Si usted quiere quitar de nuevo el pie de página, simplemente vacíe el área de texto.a.';
$string['githubissueslink'] = '<a href="https://github.com/moodle-an-hochschulen/moodle-theme_boost_union/issues">Github issues</a>';
$string['h5pcontentmaxwidthsetting'] = 'Ancho máximo de banco de contenido H5P';
$string['h5ptab'] = 'H5P';
$string['helpcontentsetting'] = 'Contenido de página de ayuda';
$string['helpcontentsetting_desc'] = 'En esta configuración usted puede añadir contenido de texto enriquecido que será mostrado en una página de ayuda.';
$string['helpdisabled'] = 'La página de ayuda está deshabilitada en este sitio. No hay nada para ver aquí.';
$string['helpheading'] = 'Ayuda';
$string['helplinkpositionboth'] = 'Añadir un enlace a la página de ayuda en la nota al pie y en ícono (interrogación) del pie de página';
$string['helplinkpositionfooter'] = 'Añadir un enlace a la página de ayuda en el ícono (interrogación) del pie de página';
$string['helplinkpositionfootnote'] = 'Añadir un enlace a la página de ayuda en la nota al pie';
$string['helplinkpositionnone'] = 'No mostrar automáticamente un enlace hacia la página de ayuda';
$string['helplinkpositionsetting'] = 'Posición del enlace hacia página de ayuda';
$string['helplinkpositionsetting_desc'] = 'En esta configuración usted puede configurar si es que un enlace hacia la página de ayuda debería ser añadido automáticamente a la página de Moodle. Si usted no quiere mostrar un enlace automáticamente, usted puede añadir manualmente un enlace hacia {$a->url} desde cualquier lugar en Moodle.';
$string['helppagetitledefault'] = 'Ayuda';
$string['helppagetitlesetting'] = 'Título de la página de ayuda';
$string['helppagetitlesetting_desc'] = 'En esta configuración usted puede definir el título de la página de ayuda. Este texto será usado como texto del enlace a la página de ayuda además si usted configura apropiadamente \'Posición de enlace a página de ayuda\'.';
$string['hidenodesprimarynavigationsetting'] = 'Ocultar nodos en la navegación primaria';
$string['hidenodesprimarynavigationsetting_desc'] = 'Con esta configuración usted puede ocultar uno o varios nodos de la navegación primaria.';
$string['imprintcontentsetting'] = 'Imprimir contenido';
$string['imprintcontentsetting_desc'] = 'En esta configuración usted puede añadir contenido de texto enriquecido que será mostrado en la página para imprimir.';
$string['imprintdisabled'] = 'La página para imprimir está deshabilitada para este sitio. No hay nada para ver aquí.';
$string['imprintheading'] = 'Imprimir';
$string['imprintlinkpositionboth'] = 'Añadir un enlace a la página para imprimir a la nota al pie y al ícono (caracter de interrogación) del pie de página';
$string['imprintlinkpositionfooter'] = 'Añadir un enlace a la página para imprimir al ícono (caracter de interrogación) del pie de página';
$string['imprintlinkpositionfootnote'] = 'Añadir un enlace a la página para imprimir a la nota al pie';
$string['imprintlinkpositionnone'] = 'No mostrar automáticamente un enlace a la página para imprimir';
$string['imprintlinkpositionsetting'] = 'Posición de enlace para Imprimir';
$string['imprintlinkpositionsetting_desc'] = 'en esta configuración usted puede configurar si debería o no ser añadido automáticamente un enlace a la página para imprimir a la página Moodle. Si usted no quiere mostrar un enlace automáticamente, usted puede añadir manualmente un enlace a {$a->url} desde cualquier lugar en Moodle.';
$string['imprintpagetitledefault'] = 'Imprimir';
$string['imprintpagetitlesetting'] = 'Título de página imprimir';
$string['imprintpagetitlesetting_desc'] = 'En esta configuración usted puede definir el título de la página para imprimir. Este texto será usado como el texto del enlace a la pagina de imprimir además si usted configura apropiadamente \'Posición de enlace para imprimir\'.';
$string['infobannerbsclasssetting'] = 'Banner de información no. {$a->no} Bootstrap class';
$string['infobannerclose'] = 'Cerrar';
$string['infobannercontentsetting'] = 'Banner de información {$a->no} contenido';
$string['infobannercontentsetting_desc'] = 'Aquí, usted escribe la información que será mostrada dentro del banner de información {$a->no}.';
$string['infobannerdismissconfirm'] = '¿Realmente quiere reiniciar la visibilidad del banner de información {$a->no} y desea volver a mostrarlo para todos los usuarios que lo hayan descartado?';
$string['infobannerdismissfail'] = 'El reinicio de la visibilidad del banner de información {$a->no} ha fallado para al menos un usuario.';
$string['infobannerdismissiblesetting'] = 'Banner de información {$a->no} descartable';
$string['infobannerdismissiblesetting_desc'] = 'Con esta configuración, usted puede hacer descartable el banner de información {$a->no}. Si el usuario hace clic en el botón-x en el banner de información, el banner será ocultado al usuario permanentemente. La visibilidad no es reiniciada automáticamente, aunque usted cambie el contenido del banner de información. Si usted quiere reiniciar la visibilidad del banner de información, haga clic en el botón inferior de \'Reiniciar visibilidad0';
$string['infobannerdismissreset'] = 'Reiniciar visibilidad de banner de información descartado';
$string['infobannerdismissresetbutton'] = 'Reiniciar visibilidad de banner de información {$a->no}';
$string['infobannerdismisssuccess'] = 'La visibilidad del banner de información {$a->no} ha sido reiniciada';
$string['infobannerenabledsetting'] = 'Habilitar banner de información {$a->no}';
$string['infobannerenabledsetting_desc'] = 'Con esta configuración usted puede habilitar el banner de información {$a->no}.';
$string['infobannerendsetting'] = 'Banner de información {$a->no} hora de término';
$string['infobannerendsetting_desc'] = 'Con esta configuración usted puede definir hasta cuando será mostrado el banner de información {$a->no} . La hora configurada es interpretada como la hora del servidor, no la hora del usuario.';
$string['infobannerheading'] = 'Banner de información {$a->no}';
$string['infobannermodeperpetual'] = 'Perpetuo';
$string['infobannermodesetting'] = 'Banner de información {$a->no} modo de visualización';
$string['infobannermodesetting_desc'] = 'Con esta configuración usted puede definir si es que el banner de información {$a->no} debería ser un banner perpetuo (que es mostrado siempre) o un banner controlado por tiempo (que es mostrado solamente dentro del intervalo de tiempo configurado).';
$string['infobannermodetimebased'] = 'Controlado por tiempo';
$string['infobannerordersetting'] = 'Banner de información {$a->no} posición de ordenamiento';
$string['infobannerpageloginpage'] = 'Página para ingreso';
$string['infobannerpagessetting'] = 'Diseño de la página a mostrar banner de información {$a->no}';
$string['infobannerpagessetting_desc'] = 'Con esta configuración, usted puede seleccionar los diseños de página en las cuales el banner de información {$a->no}debería ser mostrado.';
$string['infobannerstartsetting'] = 'Banner de información {$a->no} hora de inicio';
$string['infobannerstartsetting_desc'] = 'Con esta configuración usted puede definir desde cuando será mostrado el banner de información {$a->no} . La hora configurada es interpretada como la hora del servidor, no la hora del usuario.';
$string['infobannertab'] = 'Banner de información';
$string['javascriptdisabledhint'] = 'Pista para JavaScript deshabilitado';
$string['javascriptdisabledhint_desc'] = 'Con esta configuración, aparecerá una pista en la parte superior de la página de Moodle si JavaScript no está habilitado. Esto es particularmente útil porque varias características de Moodle no funcionan sin JavaScript.';
$string['javascriptdisabledhinttext'] = 'JavaScript está deshabilitado en su navegador.<br />Muchas características de Moodle no se podrán usar o aparecerán rotas.<br />Por favor habilite JavaScript para poder tener la experiencia Moodle completa.';
$string['javascriptheading'] = 'JavaScript';
$string['linkstab'] = 'Enlaces';
$string['loginbackgroundimage'] = 'Imágenes del fondo de página de ingreso';
$string['loginbackgroundimage_desc'] = 'Las imágenes a mostrar como un fondo de la página para ingresar al sitio. Una de estas imágenes será seleccionada al azar y será mostrada cuando el usuario visite la página para ingresar al sitio. Por favor asegúrese de que no use caracteres NO-ASCII (eñes, letras acentuadas...) en el nombre del archivo si usted quiere mostrar texto para imágenes del fondo para página de ingreso.';
$string['loginbackgroundimagesheading'] = 'Imágenes del fondo de la página de ingreso';
$string['loginbackgroundimagetextsetting'] = 'Mostrar texto para imágenes de fondo de página de ingreso';
$string['loginbackgroundimagetextsetting_desc'] = 'Con esta configuración opcional usted puede añadir texto, como por ejemplo un aviso de Derechos Reservados (C)  a sus imágenes de fondo subidas. Este texto aparecerá en la parte superior del pie de página en la página para ingresar al sitio. Sin embargo, por razones del uso de espacio de pantalla, solamente es mostrado en los tamaños de pantalla más grandes.
.<br/>
Cada línea consiste del identificador del archivo (el nombre del archivo), el texto que debería ser mostrado y el color del texto, separados por un caracter de barra vertical | . Cada declaración necesita estar escrita en una nueva línea. <br/>
Por ejemplo:<br/>
background-image-1.jpg|Copyright: CC0|dark<br/>
Como color del texto, usted puede usar los valores "dark" (oscuro) o "light" (claro).<br />
Usted puede declarar textos para una cantidad arbitraria de sus imágenes de fondo para página de ingreso subidas. Los textos serán añadidos solamente a aquellas imágenes que coincidan sus nombres de archivos con el identificador declarado en esa configuración.';
$string['loginformheading'] = 'Formato para ingresar';
$string['loginformpositionsetting'] = 'Posición del formato para ingresar';
$string['loginformpositionsetting_center'] = 'Centrado';
$string['loginformpositionsetting_left'] = 'Alineado a la izquierda';
$string['loginformpositionsetting_right'] = 'Alineado a la derecha';
$string['loginformtransparencysetting'] = 'Transparencia de formato para ingreso';
$string['loginformtransparencysetting_desc'] = 'Con esta configuración, usted puede hacer el formato para ingreso al sitio ligeramente transparente para permitir que la imagen del fondo luzca aun más.';
$string['loginpagetab'] = 'Página de ingreso';
$string['logocompactsetting'] = 'Logo compacto';
$string['logocompactsetting_desc'] = 'Aquí usted puede subir una versión compacta del mismo logo de arriba, como por ejemplo un emblema, escudo o ícono. Esta imagen es especialmente usada en la barra de navegación en la parte superior de cada página de Moodle. La imagen debería ser clara aun en tamaños pequeños.';
$string['logosetting'] = 'Logo';
$string['logosetting_desc'] = 'Aquí puede usted subir un logo completo a ser usado como decoración. Esta imagen es especialmente usada en la página para ingresar al sitio. Esta imagen puede ser de bastante alta resolución porque será reducida en escala para su uso.';
$string['logosheading'] = 'Logos';
$string['logosheading_desc'] = 'Por favor tome en cuenta: Boost Union tiene su propio logo subido y no usa el logo de la <a href="{$a}">configuración del logo de Moodle</a>.<br />Boost Union especialmente le permite subir más formatos de imágenes que lo que permite el Moodle estándar y le permite sobre-escribir los logos subidos dentro de sus sabores.';
$string['maintenancecontentsetting'] = 'Contenido de página de información de mantenimiento';
$string['maintenancecontentsetting_desc'] = 'En esta configuración usted puede añadir contenido de texto enriquecido que será mostrado en la página para información de mantenimiento (que no es la misma que la página estándar de mantenimiento de Moodle).';
$string['maintenancedisabled'] = 'La página de información de mantenimiento está deshabilitada para este sitio. No hay nada que ver aquí.';
$string['maintenanceheading'] = 'Mantenimiento';
$string['maintenancelinkpositionboth'] = 'Añadir un enlace a la página de información de mantenimiento a la nota al pie y al ícono (signo interrogación) del pie de página.';
$string['maintenancelinkpositionfooter'] = 'Añadir un enlace a la página de información de mantenimiento al ícono (signo interrogación) del pie de página.';
$string['maintenancelinkpositionfootnote'] = 'Añadir un enlace a la página de información de mantenimiento a la nota al pie';
$string['maintenancelinkpositionnone'] = 'No mostrar automáticamente un enlace a la página de información de mantenimiento';
$string['maintenancelinkpositionsetting'] = 'Posición del enlace hacia página de información de Mantenimiento';
$string['maintenancelinkpositionsetting_desc'] = 'En esta configuración usted puede configurar si es que un enlace hacia la página de información de mantenimiento debería ser añadido automáticamente a la página de Moodle. Si usted no quiere mostrar un enlace automáticamente, usted puede añadir manualmente un enlace hacia {$a->url} desde cualquier lugar en Moodle.';
$string['maintenancepagetitledefault'] = 'Mantenimiento';
$string['maintenancepagetitlesetting'] = 'Título de página de información de mantenimiento';
$string['maintenancepagetitlesetting_desc'] = 'En esta configuración usted puede definir el título de la página de información sobre Mantenimiento. Este texto será usado como texto del enlace hacia la página de información de mantenimiento además si usted configura apropiadamente \'Posición de enlace de página de información de mantenimiento\'.';
$string['markexternallinkssetting'] = 'Marcar enlaces externos';
$string['markexternallinkssetting_desc'] = 'Añadir un ícono de \'enlace externo\' después de enlaces externos (que lleva al usuario a un destino fuera de Moodle).';
$string['misctab'] = 'Misceláneos';
$string['mobileappearanceheading'] = 'Apariencia en Mobile';
$string['mobilecss'] = 'CSS adicional para App Mobile';
$string['mobilecss_donotchange'] = 'Este paso es necesario para mover el código CSS a la App Mobile. No cambie  la URL a menos que usted realmente quiera quitar el código CSS de la App Mobile de nuevo.';
$string['mobiletab'] = 'App Mobile';
$string['modiconactivity'] = 'Actividad';
$string['modiconactivityunknown'] = 'Desconocido';
$string['modicongtmoodle4'] = 'Ícono de Moodle 4';
$string['modiconlistsetting'] = 'Lista de archivos de íconos personlizados';
$string['modiconltmoodle311'] = 'Ícono antiguo de Moodle 3';
$string['modiconnotexist'] = 'este archivo fue subido a una localización inapropiada ya que es imposible deducir una actividad particular desde la ruta del archivo <em>{$a}</em>.';
$string['modiconsenablesetting'] = 'Habilitar íconos personalizados para actividades y recursos';
$string['modiconsenablesetting_desc'] = 'Con esta configuración, usted puede modificar los íconos para actividades y recursos que son usados por Moodle en las páginas del curso y en el Selector de actividad.';
$string['modiconserrorcreatingpath'] = 'No se pudo crear la carpeta pix_plugins/mod folder could en su directorio Moodledata.<br />El mensaje de la excepción fue:{$a}.';
$string['modiconsfiles'] = 'Archivos de íconos personalizados';
$string['modiconsfiles_desc'] = 'Aquí puede usted subir íconos personalizados para todos o solamente algunos módulos de actividad instalados en esta instancia Moodle.';
$string['modiconsheading'] = 'Íconos de actividad';
$string['modiconsuccess3x'] = 'Este ícono será usado para la actividad de <em>{$a}</em> como ícono antiguo de Moodle 3.';
$string['modiconsuccess4x'] = 'Este ícono será usado para la actividad de <em>{$a}</em> como ícono de Moodle 4.';
$string['modiconversion'] = 'Versión de ícono';
$string['navbarcolorsetting'] = 'Color de Barra de Navegación';
$string['navbarcolorsetting_dark'] = 'Barra de Navegación oscura con color claro de font';
$string['navbarcolorsetting_desc'] = 'Con esta configuración usted puede cambiar el color de la Barra de Navegación del predeterminado de Barra de Navegación clara hacia una oscura o coloreada.';
$string['navbarcolorsetting_light'] = 'Barra de Navegación clara con color oscuro de font (sin cambios tal como es presentada por Moodle original)';
$string['navbarcolorsetting_primarydark'] = 'Barra de Navegación de color primario con color claro del font';
$string['navbarcolorsetting_primarylight'] = 'Barra de Navegación de color primario con color oscuro del font';
$string['navbarheading'] = 'Barra de Navegación';
$string['navigationheading'] = 'Navegación';
$string['navigationtab'] = 'Navegación';
$string['openoffcanvas'] = 'Abrir cajón Fuera-del-lienzo';
$string['outsideregionsheading'] = 'Regiones de afuera';
$string['outsideregionsheading_desc'] = 'Las regiones de afuera no solamente pueden ser habilitadas con las configuraciones del diseño de arriba, su apariencia también puede ppersonalizarse.';
$string['outsideregionsplacement'] = 'Colocación horizontal de regiones afuera';
$string['outsideregionsplacement_desc'] = 'Con esta configuración, usted puede controlar si, en pantallas más grandes, las regiones de bloque \'Afuera (izquierda)\' y \'Afuera (derecha)\' deberían ser colocadas cerca del área del contenido principal o cerca de los bordes de la ventana.';
$string['outsideregionsplacementnearwindowedges'] = 'Mostrar regiones \'Afuera (izquierda)\' y \'Afuera (derecha)\' cerca de los bordes de la ventana.';
$string['outsideregionsplacementnextmaincontent'] = 'Mostrar regiones \'Afuera (izquierda)\' y \'Afuera (derecha)\' junto al área del contenido principal';
$string['outsideregionswidthcoursecontentwidth'] = 'Ancho del contenido del curso';
$string['outsideregionswidthfullwidth'] = 'Ancho completo';
$string['outsideregionswidthherowidth'] = 'Ancho heroe';
$string['pagetab'] = 'Página';
$string['pagewidthheading'] = 'Ancho de página';
$string['pluginname'] = 'Boost Union';
$string['presetheading'] = 'Pre-configuraciones del tema';
$string['primarynavigationheading'] = 'Navegación primaria';
$string['privacy:metadata'] = 'El tema Boost Union no almacena ninguna información personal de ningún usuario.';
$string['region-content-lower'] = 'Contenido (inferior)';
$string['region-content-upper'] = 'Contenido (superior)';
$string['region-footer-center'] = 'Pie de página (centro)';
$string['region-footer-left'] = 'Pie de página (izquierdo)';
$string['region-footer-right'] = 'Pie de página (derecho)';
$string['region-header'] = 'Encabezado';
$string['region-none'] = 'Ninguno';
$string['region-offcanvas-center'] = 'Afuera-del-lienzo (centro)';
$string['region-offcanvas-left'] = 'Afuera-del-lienzo (izquierda)';
$string['region-offcanvas-right'] = 'Afuera-del-lienzo (derecha)';
$string['region-outside-bottom'] = 'Afuera (abajo)';
$string['region-outside-left'] = 'Afuera (izquierda)';
$string['region-outside-right'] = 'Afuera (derecho)';
$string['region-outside-top'] = 'Afuera (superior)';
$string['resourcestab'] = 'Recursos';
$string['scrollspysetting_desc'] = 'Con esta configuración, al activar y desactivar el modo de edición, la posición del cursor donde el usuario estaba cuando estaba haciendo el cambio es preservada.';
$string['scssheading'] = 'SCSS crudo';
$string['scsstab'] = 'SCSS';
$string['showhintcourseguestaccessgeneral'] = 'Usted actualmente está viendo este curso como <strong>{$a->role}</strong>.';
$string['showhintcourseguestaccesslink'] = 'Para tener acceso completo al curso, usted puede <a href="{$a->url}">auto inscribirse a este curso</a>.';
$string['showhintcourseguestaccesssetting_desc'] = 'Con esta configuración aparecerá una pista en el encabezado del curso siempre que un usuario esté accediendo al curso con la característica de acceso de invitados. Si elcurso proporciona una auto inscripción activa, también se presentará al usuario  un enlace hacia esa página.';
$string['showhintcoursehiddengeneral'] = 'Este curso actualmente está <strong>oculto</strong>. Solamente los profesores inscritos pueden acceder a este curso cuando está oculto.';
$string['showhintcoursehiddensetting'] = 'Mostrar pista en cursos ocultos';
$string['showhintcoursehiddensetting_desc'] = 'Con esta configuración aparecerá una pista en el encabezado del curso mientras la visibilidad del curso esté oculta. Esto ayuda a identificar el estado de visibilidad de un curso de un vistazo sin la necesidad de buscar en las configuraciones del curso.';
$string['showhintcoursehiddensettingslink'] = 'Usted puede cambiar la visibilidad en las <a href="{$a->url}">configuraciones del curso</a>.';
$string['showhintcourseselfenrolfrom'] = 'La instancia de inscripción <strong>{$a->name}</strong> permite la auto inscripción sin restricciones desde {$a->from} en adelante.';
$string['showhintcourseselfenrolfromuntil'] = 'La instancia de inscripción <strong>{$a->name}</strong> permite la auto inscripción sin restricciones desde {$a->from} hasta {$a->until}.';
$string['showhintcourseselfenrolinstancecallforaction'] = 'Si usted no quiere que cualquier usuario Moodle tenga acceso a este curso libremente, por favor restrinja las configuraciones de auto inscripción.';
$string['showhintcourseselfenrolsetting'] = 'Mostrar pista para auto inscripción sin clave de inscripción';
$string['showhintcourseselfenrolsetting_desc'] = 'Con esta configuración aparecerá una pista en el encabezado del curso si el curso fuera visible y actualmente fuera posible la inscripción sin clave de inscripción.';
$string['showhintcourseselfenrolsince'] = 'La <strong>{$a->name}</strong> instancia de inscripción permite actualmente la auto inscripción sin restricciones.';
$string['showhintcourseselfenrolsinceuntil'] = 'La instancia de inscripción <strong>{$a->name}</strong> permite la auto inscripción sin restricciones hasta {$a->until}.';
$string['showhintcourseselfenrolstartcurrently'] = 'Este curso actualmente es visible para todos y es posible la  <strong>auto inscripción sin una clave de inscripción</strong>';
$string['showhintcourseselfenrolstartfuture'] = 'Este curso actualmente es visible para todos y está planeado que sea posible la <strong>auto inscripción sin una clave de inscripción</strong>.';
$string['showhintcourseselfenrolunlimited'] = 'La instancia de inscripción <strong>{$a->name}</strong> permite la auto inscripción sin restricciones indefinidamente.';
$string['showhintcourseselfenroluntil'] = 'La instancia de inscripción <strong>{$a->name}</strong> permite la auto inscripción sin restricciones hasta {$a->until}.';
$string['showhintcoursguestaccesssetting'] = 'Mostrar pista para acceso de invitado';
$string['showsitehomerighthandblockdraweronfirstloginsetting'] = 'Mostrar cajón de bloque del lado derecho de la página inicial del sitio al primer ingreso.';
$string['showsitehomerighthandblockdraweronguestloginsetting'] = 'Mostrar cajón de bloque del lado derecho de la página inicial del sitio en ingreso de invitado.';
$string['showsitehomerighthandblockdraweronvisitsetting'] = 'Mostrar cajón de bloque a la derecha de la página inicial del sitio al visitarla';
$string['showswitchedroleincoursesetting'] = 'Mostrar pista para rol cambiado';
$string['showswitchedroleincoursesetting_desc'] = 'Con esta configuración aparecerá una pista en el encabezado del curso si el usuario ha cambiado su rol en el curso. de forma predeterminada, esta información solamente es mostrada junto al avatar del usuario en el menú del usuario. Al habilitar esta opción, usted puede mostrar esta información junto con un enlace para regresar a su rol - dentro de la página del curso también.';
$string['sitebrandingtab'] = 'Marcado personalizado del sitio';
$string['sitehomerighthandblockdrawerbehaviour'] = 'Cajón del bloque a la derecha de la página inicial del sitio';
$string['speciallinksmarkupheading'] = 'Marcado especial de enlaces';
$string['staticpagestab'] = 'Páginas estáticas';
$string['switchedroleto'] = 'Usted actualmente está viendo este curso con el rol de: <strong>{$a->role}</strong>';
$string['tilebackgroundimagepositionsetting'] = 'Posición de imagen del fondo de mosaico de anuncio {$a->no}';
$string['tilebackgroundimagepositionsetting_desc'] = 'Con esta configuración usted controla la posición de la imagen del fondo dentro del contenedor del mosaico de anuncio {$a->no}. el primer valor es la posición horizontal y el segundo valor es la posición vertical.';
$string['tilebackgroundimagesetting'] = 'Imagen del fondo de mosaico de anuncio {$a->no}';
$string['tilebackgroundimagesetting_desc'] = 'Aquí puede usted subir una imagen que será mostrada como imagen del fondo detrás del contenido del mosaico de anuncio {$a->no}. Por favor asegúrese o verifique que el contenido aun es legible sobre de la imagen del fondo. Esta es una configuración opcional, el mosaico de anuncio funcionará aun y cuando usted no suba ninguna imagen de fondo.';
$string['tilecolumnssetting'] = 'Número de columnas de mosaico de anuncios por fila';
$string['tilecontentsetting'] = 'Mosaico de anuncio {$a->no} contenido';
$string['tilecontentsetting_desc'] = 'Aquí usted configura el contenido que será mostrado en el mosaico de anuncio {$a->no}. el contenido es mostrado a la mitad del mosaico. esta es una configuración adicional, el mosaico de anuncio será mostrado aun cuando usted no configure ningún contenido.';
$string['tileenabledsetting'] = 'Habilitar mosaico de anuncio {$a->no}';
$string['tileenabledsetting_desc'] = 'Con esta configuración, usted puede habilitar el mosaico de anuncio {$a->no}.';
$string['tilefrontpagepositionsetting'] = 'Posición de los mosaicos de anuncio en la página inicial del sitio';
$string['tilefrontpagepositionsetting_after'] = 'Después del contenido de la página inicial del sitio';
$string['tilefrontpagepositionsetting_before'] = 'Antes del contenido de la página inicial del sitio';
$string['tilefrontpagepositionsetting_desc'] = 'Los mosaicos de anuncios son mostrados solamente en la página inicial del sitio. Con esta configuración usted controla si los mosaicos de anuncios son mostrados antes del contenido del la página inicial del sitio o después del contenido de la página inicial del sitio. Si usted quiere mostrar solamente  los mosaicos de anuncios en la página inicial del sitio y nada más, todos los contenidos de la página inicial pueden ser eliminados al cambiar las <a href="{$a->url}">configuraciones de la página inicial del sitio</a>.';
$string['tileheading'] = 'Mosaico de anuncio {$a->no}';
$string['tileheightsetting'] = 'Altura de mosaico de anuncio';
$string['tileheightsetting_desc'] = 'Con esta configuración usted puede controlar la altura de los mosaicos de anuncio. La altura configurada es la altura mínima de cada mosaico. Si el contenido del mosaico es más alto que esta altura configurada, toda la fila de mosaicos será hecha más alta automáticamente cuanto como sea necesario.';
$string['tilelinksetting'] = 'Mosaico de anuncio {$a->no} URL del enlace';
$string['tilelinksetting_desc'] = 'Aquí puede usted configurar una URL (interna o externa) que será ofrecida como un botón de enlace al final del mosaico de anuncio {$a->no}. Esta es una configuración opcional, el mosaico del anuncio funcionará aun cuando usted no haya configurado ninguna URL de enlace..';
$string['tilelinktargetsetting'] = 'Mosaico de anuncio  {$a->no} destino del enlace';
$string['tilelinktargetsetting_desc'] = 'Aquí puede usted configurar el destino del enlace que es configurado para el botón del enlace tan pronto como usted configure una URL de enlace en el mosaico de anuncio {$a->no}.';
$string['tilelinktargetsetting_newtab'] = 'Nueva pestaña';
$string['tilelinktargetsetting_samewindow'] = 'Misma ventana';
$string['tilelinktitlefallback'] = 'Enlace';
$string['tilelinktitlesetting'] = 'Mosaico de anuncio {$a->no} título del enlace';
$string['tilelinktitlesetting_desc'] = 'Aquí usted puede configurar un título del enlace que será usado como etiqueta del botón del enlace tan pronto como usted configure una URL del enlace en el mosaico de anuncio {$a->no}. Por favor tenga en cuenta que si usted configura una URL del enlace pero no configura un título del enlace, el botón del enlace será etiquetado simplemente con \'Enlace\'';
$string['tileordersetting'] = 'Mosaico de anuncio {$a->no} posición de orden';
$string['tilesgeneralheading'] = 'Generalidades de mosaicos de anuncio';
$string['tilestab'] = 'Mosaicos de anuncio';
$string['tiletitlesetting'] = 'Título de mosaico de anuncio {$a->no}';
$string['tiletitlesetting_desc'] = 'Aquí usted escribe el título que debería ser mostrado en el mosaico de anuncio {$a->no}. . Esta es una configuración opcional, el mosaico de anuncio será mostrado aun cuando usted no le ponga un título.';
$string['upgradenotice_2022080922'] = 'A partir de esta versión, Boost Union tiene sus propias configuraciones de logo y logo compacto y no usa más esos archivos de las configuraciones de Moodle estándar.';
$string['upgradenotice_2022080922_copied'] = 'El <strong>{$a}</strong> existente de las configuraciones del Moodle estándar ha sido copiado a la configuración de {$a} de Boost Union durante esta actualización. Por favor revise dos veces el resultado.';
$string['upgradenotice_2022080922_logo'] = 'logo';
$string['upgradenotice_2022080922_logocompact'] = 'logo compacto';
$string['upgradenotice_2022080922_notcopied'] = 'La configuración de <strong>{$a}</strong> dentro de Boost Union ahora está vacía. Si usted quiere usar un/una {$a} dentro de Boost Union de ahora en adelante, simplemente súbalo a la configuración de {$a} de Boost Union más tarde.';
