<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'oublog', language 'es_mx', version '4.0'.
 *
 * @package     oublog
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Lo siento, Usted';
$string['accordion_closed'] = 'Cerrado';
$string['accordion_open'] = 'Abierto';
$string['activeblogs'] = 'Activo';
$string['addcomment'] = 'Añadir comentario';
$string['addlink'] = 'Añadir enlace';
$string['addpost'] = 'Añadir publicación';
$string['advancedoptions'] = 'Opciones avanzadas';
$string['afterendcomment'] = 'Usted no puede comentar acerca de publicaciones en este momento. Los comentarios terminaron en {$a}.';
$string['afterendcommentcapable'] = 'Los estudiantes pudieron comentar sobre publicaciones hasta {$a}.
<br/> Usted tiene acceso a comentar después de este tiempo.';
$string['afterendpost'] = 'Usted no puede crear publicaciones en este momento. La creación de publicaciones terminó en {$a}.';
$string['afterendpostcapable'] = 'Los estudiantes pudieron crear sus propias publicaciones hasta {$a}.
<br/> Usted tiene acceso a crear publicaciones después de este tiempo.';
$string['allowcomments'] = 'Permitir comentarios';
$string['allowcomments_help'] = '&lsquo;Si, de usuarios identificados&rsquo; permte comentarios de usuarios que tengan acceso al blog.

&lsquo;Si, de todos&rsquo; permite comentarios de usuarios y del público en general. Usted recibirá correos para aprobar o rechazar coemntarios de usuarios que no estén identificados.

&lsquo;No&rsquo; impide a todos hacer comentarios en esta publicación.';
$string['allowcommentsmax'] = 'Permitir comentarios (si eligió publicar)';
$string['allowimport'] = 'Habilitar importación de publicaciones';
$string['allowimport_help'] = 'Permitirle a cualquier usuario importar páginas desde otras actividades de blog a las que tenga acceso.';
$string['allowimport_invalid'] = 'Las publicaciones solamente pueden importarse  cuando la actividad se configura al modo individual.';
$string['alpha'] = 'A a la Z';
$string['atom'] = 'Atom';
$string['atomfeed'] = 'canal Atom';
$string['attachments'] = 'Anexos';
$string['attachments_help'] = 'Opcionalmente Usted puede anexar uno o más archivos a una publicación en blog. Si añade una imagen, se mostrará después del mensaje.';
$string['beforeendcomment'] = 'Usted solamente puede comentar sobre publicaciones hasta {$a}.';
$string['beforeendcommentcapable'] = 'Los estudiantes pueden comentar sobre publicaciones hasta {$a}.
<br/> Usted tiene acceso a comentar después de este tiempo.';
$string['beforeendpost'] = 'Usted solamente puede crear publicaciones hasta {$a}.';
$string['beforeendpostcapable'] = 'Los estudiantes pueden crear sus propias publicaciones hasta {$a}.
<br/> Usted tiene acceso a crear publicaciones después de este tiempo.';
$string['beforestartcomment'] = 'Usted no puede comentar sobre publicacioens en este momento. El comentar está disponible a partir de {$a}.';
$string['beforestartcommentcapable'] = 'Los estudiantes no pueden comentar en publicaciones hasta {$a}.
<br/> Usted tiene acceso a comentar antes de este tiempo.';
$string['beforestartpost'] = 'Usted no puede crear publicaciones en este momento. La creación de publicaciones está disponible a partir de {$a}.';
$string['beforestartpostcapable'] = 'Los estudiantes no pueden crear sus propias publicaciones hasta {$a}.
<br/> Usted tiene acceso a crear publicaciones antes de este tiempo.';
$string['blogfeed'] = '{$a}  canales';
$string['bloginfo'] = 'Información del blog';
$string['blogname'] = 'Nombre del blog';
$string['blogoptions'] = 'Opciones del blog';
$string['blogsummary'] = 'Resumen del blog';
$string['cancel'] = 'Cancelar';
$string['comment'] = 'Añada su comentario';
$string['commentalert'] = 'Reportar comentario';
$string['commentdated'] = 'Fechada';
$string['commentfrom'] = 'Comentar permitido solamente a partir de';
$string['commentonby'] = 'Comentado en <u>{$a->title}</u> {$a->date} por <u>{$a->author}</u>';
$string['commentonbyusers'] = 'Comentario <u>{$a->commenttitle}</u> en publicación <u>{$a->posttitle}</u> <br> por <u>{$a->author}</u>';
$string['commentposts'] = 'Publicaciones más comentadas';
$string['commentposts_info_alltime'] = 'Publicaciones con el mayor número de comentarios';
$string['commentposts_info_thismonth'] = 'Publicaciones con el mayor número de comentarios añadidos en el mes anterior';
$string['commentposts_info_thisyear'] = 'Publicaciones con el mayor número de comentarios añadidos en el año anterior';
$string['comments'] = 'Comentarios';
$string['comments_info_alltime'] = '{$a}s con el mayor número de comentarios';
$string['comments_info_thismonth'] = '{$a}s con el mayor número de comentarios añadidos en el mes anterior';
$string['comments_info_thisyear'] = '{$a}s con el mayor número de comentarios añadidos en el año anterior';
$string['commentsby'] = 'Comentarios por {$a}';
$string['commentsfeed'] = 'Comentarios solamente';
$string['commentsnotallowed'] = 'Comentarios no están permitidos';
$string['commentuntil'] = 'Comentar permitido solamente hasta';
$string['completioncomments'] = 'El usuario debe hacer comentarios en publicaciones del blog';
$string['completioncommentsgroup'] = 'Requerir comentarios';
$string['completioncommentsgroup_help'] = 'Si habilita esta opción, el blog será marcado como completo para un estudiante en cuanto hayan dejado el número especificado de comentarios.';
$string['completionposts'] = 'Los usuarios deben hacer publicaciones al blog:';
$string['completionpostsgroup'] = 'Requerir publicaciones';
$string['completionpostsgroup_help'] = 'Si habilita esta opción, el blog será marcado como completo para un estudiante en cuanto hayan hecho el número especificado de publicaciones.';
$string['computingguide'] = 'Guía a los blogs OU';
$string['computingguideurl'] = 'URL de guía de cómputo';
$string['computingguideurlexplained'] = 'Escriba la URL para la guía de cómputo de blogs OU';
$string['configmaxattachments'] = 'Número máximo de anexos permitidos por publicación de blog.';
$string['configmaxbytes'] = 'Tamaño máximo para todos los anexos del blog en el sitio. (sujeto a límites del curso y otras configuraciones locales)';
$string['configremoteserver'] = 'Dirección de la raíz (Root address = wwwroot) del servidor remoto a usar para importación de publicaciones.
Los blogs en este servidor se mostrarán adicionalmente a los que estén en el sitio local al importar las publicaciones.';
$string['configremotetoken'] = 'Token (ficha) del usuario del servicio web para oublog en servidor remoto para importación.';
$string['confirmdeletecomment'] = '¿Está Usted seguro de querer borar este comentario?';
$string['confirmdeletelink'] = '¿Está Usted seguro de querer borar este enlace?';
$string['confirmdeletepost'] = '¿Está Usted seguro de querer eliminar esta publicación de blog?';
$string['contribution'] = 'Participación';
$string['contribution_all'] = 'Participación - Todo el tiempo';
$string['contribution_from'] = 'Participación - De {$a}';
$string['contribution_fromto'] = 'Participación - De {$a->start} a {$a->end}';
$string['contribution_to'] = 'Participación - A {$a}';
$string['copytoself'] = 'Mandarse a sí mismo una copia';
$string['couldnotaddcomment'] = 'No se pudo añadir comentario';
$string['couldnotaddlink'] = 'No se pudo añadir enlace';
$string['defaultpersonalblogname'] = '{$a->displayname} de {$a->name}';
$string['delete'] = 'Borrar';
$string['deleteandemail'] = 'Eliminar y Email';
$string['deletedblogpost'] = 'Publicación sin título';
$string['deletedby'] = 'Borrado por {$a->fullname}, {$a->timedeleted}';
$string['deleteemailpostbutton'] = 'Eliminar y Email';
$string['deleteemailpostdescription'] = 'Seleccionar para eliminar la publicación o eliminar y enviar una notificación Email personalizable.';
$string['deleteglobalblog'] = 'Usted no puede borrar el blog global';
$string['details'] = 'Detalles';
$string['discovery'] = '{$a} uso';
$string['displayname'] = 'Nombre alterno de la actividad (vacío usará valor por defecto)';
$string['displayname_default'] = 'blog';
$string['displayname_help'] = 'Configurar un nombre alterno del tipo de actividad dentro de la interfaz.

El dejarlo vacío significará que se usará el valor por defecto (\'blog\').

El nombre alterno deberá de empezar con una letra minúscula, la cual se verá como MAYÚSCULA cuando fuera necesario.';
$string['displayperiod'] = 'Selector de Participación Fecha Desde - Fecha Hasta';
$string['displayperiod_help'] = '<p>Por defecto se seleccionan todas las entradas.</p>
<p>Usted puede seleccionar  \'Desde\' una cierta fecha hasta las entradas de hoy.</p>
<p>Usted puede seleccionar  \'Desde\' una cierta fecha \'Hasta\' otra fecha específica.</p>
<p>O Usted puede seleccionar desde la primera entrada \'Hasta\' cierta fecha</p>';
$string['displayversion'] = 'Versión de OU blog: <strong>{$a}</strong>';
$string['downloadas'] = 'Descargó datos como';
$string['downloadcsv'] = 'Archivo de texto de valores separados por comas';
$string['edit'] = 'Editar';
$string['editlink'] = 'Editar enlace';
$string['editonsummary'] = 'Editado {$a->editdate}';
$string['editpost'] = 'Actualizar publicación blog';
$string['editsummary'] = 'Editado por {$a->editby}, {$a->editdate}';
$string['emailcontenthtml'] = 'Esta es unanotificación para informarle que su publicación {$a->activityname} con los detalles siguientes ha sido eliminada por \'{$a->firstname} {$a->lastname}\':<br />
<br />
Asunto: {$a->subject}<br />
{$a->activityname}: {$a->blog}<br />
Curso: {$a->course}<br />
<br />
<a href={$a->deleteurl} title="view deleted post">Vea la publicación eliminada</a>';
$string['emailerror'] = 'Hubo un error al enviar el Email';
$string['emailmessage'] = 'Mensaje';
$string['end'] = 'Para';
$string['error_alreadyapproved'] = 'El comentario ya fue aprobado o rechazado';
$string['error_grouppubliccomments'] = 'Usted no puede permitir comentarios públicos cuando el blog está en modo de grupo';
$string['error_moderatednotallowed'] = 'Los comentarios moderados ya no están permitidos en este blog o publicación de blog';
$string['error_noconfirm'] = 'Escriba el texto en negritas de arriba, exactamente como aparece, en esta caja.';
$string['error_toomanycomments'] = 'Usted ha hecho demasiados comentarios al blog en la última hora desde esta direción de internet. Por favor espere un rato y vuelva a intentarlo.';
$string['error_unspecified'] = 'El sistema no puede completar su solicitud debido a que ocurrió un error ({$a})';
$string['error_wrongkey'] = 'Clave de comentario incorrecta';
$string['event:commentapproved'] = 'Comentario aprobado';
$string['event:commentcreated'] = 'Comentario creado';
$string['event:commentdeleted'] = 'Comentario eliminado';
$string['event:participationviewed'] = 'Participación vista';
$string['event:postcreated'] = 'Publicación creada';
$string['event:postdeleted'] = 'Publicación eliminada';
$string['event:postimported'] = 'Publicación importada';
$string['event:postupdated'] = 'Publicación actualizada';
$string['event:postviewed'] = 'Publicación vista';
$string['event:savefailed'] = 'Falla de sesión al guardar publicación';
$string['event:siteentriesviewed'] = 'Entradas del sitio vistas';
$string['export:description'] = 'Usted puede exportar publicaciones de blog individual desde su contenido de módulo en línea usando los enlaces inferiores.
De forma alterna, seleccione varias publicaciones, el tipo de exportación, y haga click en \'Exportar\' para descargarlas todas a la vez.';
$string['export:header'] = 'Exportar';
$string['export:header_author'] = 'Autor';
$string['export:header_date_posted'] = 'Fecha de publicación';
$string['export:header_tags'] = 'Marcas';
$string['export:header_title'] = 'Título';
$string['export:title'] = 'Exportar';
$string['export:type'] = 'Tipo de exportación';
$string['exportedpost'] = 'Publicación de blog exportada';
$string['exportpostscomments'] = 'todas las publicaciones visibles actualmente y sus comentarios.';
$string['exportuntitledpost'] = 'Una publicación sin-título';
$string['externaldashboardadd'] = 'Añadir blog al tablero';
$string['externaldashboardremove'] = 'Remover blog del tablero';
$string['extra_emails'] = 'Dirección Email de otros destinatarios';
$string['extra_emails_help'] = 'Escriba una o más direcciones Email separadas por espacios o punto-y-coma';
$string['extranavolderposts'] = 'Publicaciones anteriores: {$a->from}-{$a->to}';
$string['extranavtag'] = 'Filtro: {$a}';
$string['feedhelp'] = 'Canales';
$string['feedhelp_help'] = 'Si utiliza canales Usted puede añadir estos enlaces Atom o RSS para mantenerse actualizado con las publicaciones.
La mayoría de los lectores de canales soportan Atom y RSS.

Si los comentarios están habilitados, también existen canales para ‘Comentarios solamente’.';
$string['feeds'] = 'Canales';
$string['feedsnotenabled'] = 'Los canales no están habilitados';
$string['filter'] = 'Filtro:';
$string['filter-tooltip'] = 'Clic para quitar marca de filtro';
$string['foruser'] = 'para {$a}';
$string['globalblogmissing'] = 'Falta el blog global';
$string['globalusageexclude'] = 'Excluir de estadísticas de uso global';
$string['globalusageexclude_desc'] = 'Lista separada por comas de IDs de usuarios para excluir usuarios de la lista de estadísticas de mayor uso para blog global';
$string['gradesupdated'] = 'Calificaciones actualizadas';
$string['grading'] = 'Calificando';
$string['grading_help'] = 'Si Usted selecciona esta opción, se añadirá una calificación para este blog al Libro de calificaciones del curso y se calculará automáticamente. Déjelo vacío para un blog no-evaluado o para uno que Usted planea valorar manualmente.';
$string['grading_invalid'] = 'Las publicaciones solamente pueden ser calificadas cuando está configurado el tipo de calificación o el tipo de valoración.';
$string['group'] = 'Grupo';
$string['guestblog'] = 'Si Usted tiene una cuenta en el sistema, por favor, <a href=\'{$a}\'>ingrese para tener acceso completo</a>.';
$string['import'] = 'importar';
$string['import_notallowed'] = 'La importación de publicaciones está deshabilitada para este  {$a}.';
$string['import_step0_blog'] = 'Importar blog';
$string['import_step0_inst'] = 'A partir de la lista de blogs inferior, Usted puede importar el blog completo o importar publicaciones seleccionadas.';
$string['import_step0_nonefound'] = 'Usted no tiene acceso a ninguna actividad de la que pueda importar publicaciones.';
$string['import_step0_numposts'] = '({$a} publicaciones)';
$string['import_step0_selected_posts'] = 'Importar publicaciones seleccionadas';
$string['import_step1_addtag'] = 'Filtrar por marca - {$a}';
$string['import_step1_all'] = 'Seleccionar todo';
$string['import_step1_from'] = 'Importar todo';
$string['import_step1_include_label'] = 'Importar publicaciones - {$a}';
$string['import_step1_inst'] = 'Seleccionar publicaciones a importar:';
$string['import_step1_none'] = 'Seleccionar nada';
$string['import_step1_removetag'] = 'Remover filtro de marca - {$a}';
$string['import_step1_submit'] = 'Importar';
$string['import_step1_table_include'] = 'Incluir en importación';
$string['import_step1_table_posted'] = 'Fecha de publicación';
$string['import_step1_table_tags'] = 'Etiquetas';
$string['import_step1_table_title'] = 'Título';
$string['import_step2_cancel_submit'] = 'No importar publicaciones duplicadas';
$string['import_step2_conflicts'] = '{$a} publicación(es) han sido importadas antes. Si Usted desea importar de nuevo las publicaciones seleccione \'importar publicaciones duplicadas\' y otra copia será añadida a su blog.';
$string['import_step2_conflicts_submit'] = 'Importar publicaciones duplicadas';
$string['import_step2_inst'] = 'Importar publicaciones:';
$string['import_step2_none'] = 'Sin publicaciones seleccionadas para importar';
$string['import_step2_prog'] = 'Importación en progreso';
$string['import_step2_total'] = '{$a} publicación(es) importada(s) exitosamente';
$string['includepost'] = 'Incluir publicación';
$string['individualblogs'] = 'Blogs individuales';
$string['individualblogs_help'] = '<p><strong>No (blog juntos o en grupo)</strong>: <em>Los blogs individuales no se usan</em> – No hay blogs individuales configurados, todos son parte de una comunidad mayor (dependiendo de la configuración de \'modo Grupo\').</p> <p><strong>Blogs individuales separados</strong>: <em>Blogs Individuales se usan de forma privada</em> – Los usuarios individuales solamente pueden publicar-a y ver en sus propios blogs, a menos que tengan permiso ("viewindividual") para ver otros blogs individuales.</p> <p><strong>Blogs individuales visibles</strong>: <em>Los blogs individuales se usan públicamente</em> – los usuarios individuales solamente pueden publicar en sus propios blogs, pero pueden ver las publicaciones de otros blogs individuales</p>';
$string['info'] = 'Participación dentro del período seleccionado.';
$string['introonpost'] = 'Mostrar introducción al publicar';
$string['invalidblog'] = 'ID de blog inválida';
$string['invalidblogdetails'] = 'No se pueden encontrar detalles sobre la publicación blog {$a}';
$string['invalidblogtags'] = 'Marcas de blog inválidas';
$string['invalidcomment'] = 'ID de comentario inválida';
$string['invalidedit'] = 'ID de edición inválida';
$string['invalidformat'] = 'El formato debe ser Atom o RSS';
$string['invalidlink'] = 'ID de enlace inválido';
$string['invalidpost'] = 'ID de publicación inválida';
$string['invalidpostid'] = 'Postid inválida';
$string['invalidvisbilitylevel'] = 'Nivel de visibilidad inválido {$a}';
$string['invalidvisibility'] = 'Nivel de visibilidad inválido';
$string['lastcomment'] = '(último comentario por {$a->fullname}, {$a->timeposted})';
$string['lastmodified'] = 'Última publicación: {$a}';
$string['limits'] = 'Período de tiempo de contribución';
$string['links'] = 'Enlaces relacionados';
$string['logincomments'] = 'Si, de usuarios identificados';
$string['maxattachments'] = 'Número máximo de anexos';
$string['maxattachments_help'] = 'Esta configuración especifica el número máximo de archivos que pueden ser anexados a una publicación de blog.';
$string['maxattachmentsize'] = 'Tamaño máximo de anexo';
$string['maxattachmentsize_help'] = 'Esta configuración especifica el tamaño máximo del archivo/imagen que puede ser usado en una publicación de blog.';
$string['maxvisibility'] = 'Visibilidad máxima';
$string['maxvisibility_help'] = '<p><em>En un blog personal:</em> <strong>Visible solamente para el propietario del blog (privado)</strong> – nadie más puede ver esta publicación.</p> <p><em>En un blog de curso:</em> <strong>Visible a los participantes de este curso</strong> – para ver la publicación Usted requiere que le hayan dado acceso al blog, usualmente al inscribirse al curso que lo contiene.</p> <p><strong>Visible para todos los identificados en el sistema</strong> – todos los que estén identificados pueden ver esta publicaci´n, aún cuando no estén inscritos en un curso específico.</p> <p><strong>Visible para todo el  mundo</strong> – cualquier usuario de internet puede ver este blog si les da la dirección.</p> <p>Esta opción existe en todo el blog y también para publicaciones individuales. Si la opción se configura para todo el blog, esto se vuelve un máximo. Por ejemplo: si todo el blog se pusiera al primer nivel, Usted no podrá cambiar el nivel de una publicación individual en absoluto.</p>';
$string['maybehiddenposts'] = 'Este  {$a->name} contiene publicaciones que solamente son visibles para usuarios ingresados al sitio, o donde solamente pueden comentar usuarios ingresados al sitio. Si Usted tiene cuenta en el sistema, por favor <a href=\'{$a}\'>ingrese al sitio para tener acceso completo</a>.';
$string['message'] = 'Mensaje';
$string['moderated_addedcomment'] = 'Gracias por añadir su comentario, que ha sido recibido exitosamente. Su comentario no aparecerá hasta que haya sido aprobado por el autor de esta publicación.';
$string['moderated_approve'] = 'Aprobar este comentario';
$string['moderated_authorname'] = 'Su nombre';
$string['moderated_awaiting'] = 'Comentarios que esperan aprobación';
$string['moderated_awaitingnote'] = 'Estos comentarios no son visibles para otros usuarios a menos que Usted los apruebe. Considere que el sistema no conoce la identidad de las personas que comentaron y que los comentarios pudieran tener enlaces que, de seguirse, pudieran <strong>dañar seriamente su computadora</strong>. Si tiene dudas, por favor rechace los comentarios <strong>sin seguir ningun enlace dentro de ellos</strong>.';
$string['moderated_confirm'] = 'Confirmación';
$string['moderated_confirminfo'] = 'Por favor esciba <strong>si</strong> debajo para confirmar que Usted es una persona.';
$string['moderated_confirmvalue'] = 'si';
$string['moderated_emailhtml'] = '<p>(Este es un correo generado automáticamente. Por favor no responda.)</p> <p>Alguien ha añadido un comentario a su publicación del blog: {$a->postlink}</p> <p>Usted necesita <strong>aprobar el comentariot</strong> antes de que este aparezca publicado.</p> <p>El sistema no conoce la identidad de quien hizo el comentario y los comentarios pudieran contener enlaces que, en caso de seguirse, pudieran <strong>dañar seriamente su computadora</strong>. Si tiene dudas, por favor rechace los comentarios <strong>sin seguir ningun enlace dentro de ellos</strong>.</p> <p>Si Usted aprueba el comentario, Usted asume la responsabilidad por publicarlo. Asegúrese de que no contenga nada que vaya contra las reglas.</p> <hr/> <p>Nombre dado: {$a->commenter}</p> <hr/> <h3>{$a->commenttitle}</h3> {$a->comment} <hr/> <ul class=\'oublog-approvereject\'> <li><a href=\'{$a->approvelink}\'>{$a->approvetext}</a></li> <li><a href=\'{$a->rejectlink}\'>{$a->rejecttext}</a></li> </ul> <p> Usted también podría ignorar este correo y el comentario será borrado automáticamente en 30 días.. </p> <p> Si Usted recibe demasiados de estos correos, Usted puede restringir los comentarios para que solamente los hagan los usuarios identificados . </p> <ul class=\'oublog-restrict\'> <li><a href=\'{$a->restrictpostlink}\'>{$a->restrictposttext}</a></li> <li><a href=\'{$a->restrictbloglink}\'>{$a->restrictblogtext}</a></li> </ul>';
$string['moderated_emailsubject'] = 'Comentario esperando aprobación en: {$a->blog} ({$a->commenter})';
$string['moderated_emailtext'] = 'Este es un correo generado automáticamente. Por favor no responda.

Alguien ha añadido un comentario a su publicación del blog: {$a->postlink}

Usted necesita aprobar el comentariot antes de que este aparezca publicado.

El sistema no conoce la identidad de quien hizo el comentario y los comentarios pudieran contener enlaces que, en caso de seguirse, pudieran dañar seriamente su computadora.
Si tiene dudas, por favor rechace los comentarios sin seguir ningun enlace dentro de ellos.

Si Usted aprueba el comentario, Usted asume la responsabilidad por publicarlo. Asegúrese de que no contenga nada que vaya contra las reglas.

-----------------------------------------------------------------------
Nombre dado: {$a->commenter}
----------------------------------------------------------------------- {$a->commenttitle}
 {$a->comment}
-----------------------------------------------------------------------

* {$a->approvetext}: {$a->approvelink}

* {$a->rejecttext}: {$a->rejectlink}

Usted también podría ignorar este correo y el comentario será borrado automáticamente en 30 días.

Si Usted recibe demasiados de estos correos, Usted puede restringir los comentarios para que solamente los hagan los usuarios identificados.

* {$a->restrictposttext}: {$a->restrictpostlink}

* {$a->restrictblogtext}: {$a->restrictbloglink}';
$string['moderated_info'] = 'Debido a que Usted no está identificado, su comentario solamente aparecerá después de que sea aprobado Si Usted tiene cuenta en el sistema, por favor <a href=\'{$a}\'>regístrese para tener acceso completo</a>.';
$string['moderated_postername'] = 'usando el nombre <strong>{$a}</strong>';
$string['moderated_reject'] = 'Rechazar este comentario';
$string['moderated_rejectedon'] = 'Rechazado {$a}:';
$string['moderated_restrictblog'] = 'Restringir los comentarios en todas sus publicaciones de este blog';
$string['moderated_restrictblog_info'] = '¿Le gustaría restringir los comentarios en todas sus publicaciones de este blog, de forma tal que solamente las personas identificadas en el sistema puedan añadir comentarios?';
$string['moderated_restrictpage'] = 'Retringir comentarios';
$string['moderated_restrictpost'] = 'Retringir comentarios en esta publicación';
$string['moderated_restrictpost_info'] = '¿Le gustaría restringir los comentarios en esta publicación, de forma tal que solamente las personas identificadas en el sistema puedan añadir comentarios?';
$string['moderated_submitted'] = 'Esperando moderación';
$string['moderated_typicaltime'] = 'En el pasado, esto generalmente ha tomado {$a}.';
$string['modulename'] = 'blog OU';
$string['modulename_help'] = 'Esto permite la creación de blogs adentro de un módulo (los cuales están separados del sistema de blogs del núcleo de Moodle). Usted puede tener múltiples blogs en los módulos (todos en el módulo publican dentro del mismo blog), blogs de grupo, o blogs individuales. La actividad de blog puede renombrarse para reflejar su propósito, como por ejemplo, Bitácora de Aprendizaje';
$string['modulenameplural'] = 'blogs OU';
$string['mostcomments'] = 'Más comentarios';
$string['mostposts'] = 'Más publicaciones';
$string['mustprovidepost'] = 'Debe proporcionar postid';
$string['myparticipation'] = 'Resumen de Mi participación';
$string['ncomments'] = '{$a} comentarios';
$string['newblogposts'] = 'Nuevas publicaciones del blog';
$string['newcomment'] = 'Nuevo comentario';
$string['newerposts'] = 'Publicaciones más nuevas';
$string['newpost'] = 'Nueva publicación  {$a}';
$string['no'] = 'No';
$string['no_blogtogetheroringroups'] = 'No (blog junto o en grupos)';
$string['noblogposts'] = 'Sin publicaciones del blog';
$string['nocomments'] = 'Comentarios no permitidos';
$string['nograde'] = 'Sin calificación (valor por defecto)';
$string['noposts'] = 'No hay publicaciones visibles en este {$a}.';
$string['nopostsnotags'] = 'No hay publicaciones visibles en este {$a->blog}, para esta marca {$a->tag}.';
$string['notaddpost'] = 'No se pudo añadir publicación';
$string['notaddpostnogroup'] = 'No se puede añadir publicación con no-grupo';
$string['nousercommentpartsfound'] = 'Sin comentarios añadidos en este período.';
$string['nousercomments'] = 'No se hicieron comentarios.';
$string['nousercommentsfound'] = 'Sin comentarios hechos en este período.';
$string['nousergrade'] = 'Calificaación del usuario no disponible';
$string['nouserpostpartsfound'] = 'Sin publicaciones hechas en este período.';
$string['nouserposts'] = 'No se hicieron publicaciones.';
$string['nouserpostsfound'] = 'Sin publicaciones durante este período.';
$string['npending'] = '{$a} comentarios esperan aprobación';
$string['npendingafter'] = '{$a} esperando aprobación';
$string['numbercomments'] = '{$a} comentarios';
$string['numbercommentsmore'] = 'Y {$a} comentarios más';
$string['numberofposts'] = 'Número de publicaciones por página';
$string['numberofposts_help'] = 'Configurar el Número de publicaciones por página a mostrar en un blog.';
$string['numberposts'] = '{$a} publicaciones';
$string['numberpostsmore'] = 'Y {$a} publicaciones más';
$string['numberviews'] = '{$a} vistas';
$string['numposts'] = '{$a} publicaciones';
$string['official'] = 'Configurar';
$string['olderposts'] = 'Publicaciones anteriores';
$string['onecomment'] = '{$a} comentario';
$string['onepending'] = '{$a} comentarios esperando aprobación';
$string['onependingafter'] = ', {$a} esperando aprobación';
$string['onlyworkspersonal'] = 'Solamente trabajos para blogs personales';
$string['order'] = 'Orden:';
$string['order_help'] = 'Usted puede elegir el orden el que se muestran la lista de marcas usadas, ya sea en orden alfabético, o por el número de publicaciones en las que se usa. Selccione los dos enlaces para alternar entre métodos para ordenamiento,; esta elección es recordada y será usada en vistas subsecuentes.';
$string['oublog'] = 'blog OU';
$string['oublog:addinstance'] = 'Añadir un nuevo blog OU';
$string['oublog:audit'] = 'Ver publicaciones borradas y versiones anteriores';
$string['oublog:comment'] = 'Comentar sobre una publicación';
$string['oublog:contributepersonal'] = 'Publicar y comentar en en blogs personales';
$string['oublog:exportownpost'] = 'Exportar sus propias publicaciones';
$string['oublog:exportpost'] = 'Exportar publicaciones';
$string['oublog:exportposts'] = 'Exportar publicaciones';
$string['oublog:grade'] = 'Calificar participación de usuario en blog OU';
$string['oublog:ignorecommentperiod'] = 'Ignorar período de tiempo de comentar';
$string['oublog:ignorepostperiod'] = 'Ignorar período de tiempo de publicar';
$string['oublog:managecomments'] = 'Administrar comentarios';
$string['oublog:managelinks'] = 'Administrar enlaces';
$string['oublog:manageposts'] = 'Administrar publicaciones';
$string['oublog:post'] = 'Crear una nueva publicación';
$string['oublog:rate'] = 'Puede valorar publicaciones.';
$string['oublog:view'] = 'Ver publicaciones';
$string['oublog:viewallratings'] = 'Ver todas las valoraciones crudas dadas por individuos';
$string['oublog:viewanyrating'] = 'Ver todas las valoraciones que cualquiera recibió';
$string['oublog:viewindividual'] = 'Ver blogs individuales';
$string['oublog:viewparticipation'] = 'Ver participación de usuario en blog OU';
$string['oublog:viewpersonal'] = 'Ver publicaciones en blogs personales';
$string['oublog:viewprivate'] = 'Ver publicaciones privadas en blogs personales';
$string['oublog:viewrating'] = 'Ver el total de valoraciones que Usted recibió';
$string['oublog_managealerts'] = 'Gestionar alertas de publicación/comentario reportadas';
$string['oublogallpostslogin'] = 'Forzar ingreso en todas las páginas de publicación';
$string['oublogallpostslogin_desc'] = 'Habilitar el forzar ingreso a la página de entradas del siti blog. Cuando se habilita, solamente los usuarios que hayan ingresado al sitio verán el enlace hacia esta página.';
$string['oublogcrontask'] = 'Trabajos de mantenimiento de OU blog';
$string['oublogintro'] = 'Introducción';
$string['overviewnumentrylog'] = 'entradas desde la última identificacón';
$string['overviewnumentrylog1'] = 'entrada desde la última identificacón';
$string['overviewnumentryvw'] = 'entradas desde la última vez que se vió';
$string['overviewnumentryvw1'] = 'entrada desde la última vez que se vió';
$string['participation'] = 'Participación';
$string['participation_all'] = 'Participación - Todo el tiempo';
$string['participation_from'] = 'Participación - Desde {$a}';
$string['participation_fromto'] = 'Participación - Desde {$a->start} Hasta {$a->end}';
$string['participation_to'] = 'Participación - Hasta {$a}';
$string['participationbyuser'] = 'Participación por usuario';
$string['permalink'] = 'Enlace-permanente';
$string['personalblognotsetup'] = 'Blogs personales no configurados';
$string['personalblogtitle'] = 'Blog personal';
$string['pluginadministration'] = 'Administración Blog OU';
$string['pluginname'] = 'OU Blog';
$string['postalert'] = 'Reportar publicación';
$string['postauthor'] = 'Autor publicación';
$string['postdate'] = 'Fecha publicción';
$string['postdetail'] = 'Detalle de publicación';
$string['postedby'] = 'por {$a}';
$string['postedbymoderated'] = 'por {$a->commenter} (aprobada por {$a->approver}, {$a->approvedate})';
$string['postedbymoderatedaudit'] = 'por {$a->commenter} [{$a->ip}] (aprobada por {$a->approver}, {$a->approvedate})';
$string['postfrom'] = 'Publicar permitido solamente a partir de';
$string['postinfoblock'] = '<u>{$a->posttitle}</u> <br> <u>{$a->postdate}</u> <br> <u>{$a->sourcelink}</u>';
$string['postmessage'] = 'Publicar';
$string['posts'] = 'Publicaciones';
$string['posts_info_alltime'] = '{$a}s con el mayor número de publicaciones';
$string['posts_info_thismonth'] = '{$a}s con el mayor número de publicaciones en el último mes';
$string['posts_info_thisyear'] = '{$a}s con el mayor número de publicaciones en el último año';
$string['postsby'] = 'Publicaciones por {$a}';
$string['posttime'] = 'Hora de publicación';
$string['posttitle'] = 'Título de publicación';
$string['postuntil'] = 'Publicar permitido solamente hasta';
$string['predefinedtags'] = 'Marcas pre-definidas';
$string['predefinedtags_help'] = 'Darle a los usuarios marcas para elegir al escribir una marca en una publicación. Las marcas deberán estar separadas por comas.';
$string['privacy:metadata:core_rating'] = 'Las valoraciones añadidas a entradas del blog son almacenadas usando el sistema de core_rating';
$string['privacy:metadata:oublog_comments'] = 'Comentarios a una publicación de OU blog.';
$string['privacy:metadata:oublog_comments:authorip'] = 'Para comentarios moderados: direccción IP del autor (necesaria)';
$string['privacy:metadata:oublog_comments:authorname'] = 'Para comentarios moderados: nombre del autor (necesario)';
$string['privacy:metadata:oublog_comments:message'] = 'El detalle del comentario';
$string['privacy:metadata:oublog_comments:title'] = 'El título del comentario.';
$string['privacy:metadata:oublog_comments:userid'] = 'La ID del usuario del originador del comentario.';
$string['privacy:metadata:oublog_comments_moderated'] = 'Comentarios de publicación en Blog OU para moderación.';
$string['privacy:metadata:oublog_comments_moderated:authorip'] = 'Dirección IP del autor (necesaria)';
$string['privacy:metadata:oublog_comments_moderated:authorname'] = 'Nombre del autor (necesario)';
$string['privacy:metadata:oublog_comments_moderated:message'] = 'El detalle del comentario.';
$string['privacy:metadata:oublog_comments_moderated:postid'] = 'La id de la publicación en donde está el comentario.';
$string['privacy:metadata:oublog_comments_moderated:title'] = 'El título del comentario.';
$string['privacy:metadata:oublog_edits'] = 'Ediciones de blog OU (contiene versiones anteriores de publicaciones en blog OU).';
$string['privacy:metadata:oublog_edits:oldmessage'] = 'El contenido anterior de la publicación en Blog OU.';
$string['privacy:metadata:oublog_edits:oldtitle'] = 'El título anterior de la publicación en Blog OU.';
$string['privacy:metadata:oublog_edits:userid'] = 'La ID del usuario del editor de publicación en Blog OU.';
$string['privacy:metadata:oublog_instances'] = 'Instancias de un Blog OU personal.';
$string['privacy:metadata:oublog_instances:name'] = 'El nombre de la instancia de Blog OU.';
$string['privacy:metadata:oublog_instances:summary'] = 'Resumen de la instancia de Blog OU.';
$string['privacy:metadata:oublog_instances:userid'] = 'La ID del usuario del propietario de la instancia de blog OU';
$string['privacy:metadata:oublog_posts'] = 'Publicaciones en un Blog OU';
$string['privacy:metadata:oublog_posts:deletedby'] = 'El usuario que eliminó esta publicación en blog (si fue eliminada).';
$string['privacy:metadata:oublog_posts:lasteditedby'] = 'El último usuario que editó la publicación en blog OU ()si fue editada).';
$string['privacy:metadata:oublog_posts:message'] = 'El texto de la publicación en Blog OU.';
$string['privacy:metadata:oublog_posts:title'] = 'El título de la pulicación en Blog OU.';
$string['privacy:metadata:oublog_taginstances'] = 'Instancias de marcas en blog OU';
$string['privacy:metadata:oublog_taginstances:oubloginstancesid'] = 'La instancia de blog OU con la cual está asociada la marca.';
$string['privacy:metadata:oublog_taginstances:postid'] = 'La publicación de blog OU con la cual está asociada la marca.';
$string['privacy:metadata:oublog_taginstances:tagid'] = 'El identificador actual de la marca.';
$string['privacy:metadata:oublog_tags'] = 'Marcas asociadas con publicaciones en Blog OU.';
$string['privacy:metadata:oublog_tags:tag'] = 'La marca de publicación en Blog OU.';
$string['privacy:metadata:preference:mod_oublog_commentformfilter'] = 'Si es que se muestran o no estadísticas de todo/mes/año para comentarios.';
$string['privacy:metadata:preference:mod_oublog_commentpostformfilter'] = 'Si es que se muestran o no estadísticas de todo/mes/año para publicaciones más comentadas.';
$string['privacy:metadata:preference:mod_oublog_hidestatsform_comment'] = 'Si es que se ocultan estadísticas para comentarios.';
$string['privacy:metadata:preference:mod_oublog_hidestatsform_commentpost'] = 'Si es que se ocultan estadísticas para las publicaciones más comentadas.';
$string['privacy:metadata:preference:mod_oublog_hidestatsform_post'] = 'Si es que se ocultan estadísticas para publicaciones.';
$string['privacy:metadata:preference:mod_oublog_hidestatsform_visit'] = 'Si es que se ocultan estadísticas para visitas.';
$string['privacy:metadata:preference:mod_oublog_postformfilter'] = 'Si es que se muestran o no estadísticas de todo/mes/año para publicaciones.';
$string['privacy:metadata:preference:mod_oublog_visitformfilter'] = 'Si es que se muestran o no estadísticas de todo/mes/año para visitantes.';
$string['privacy:metadata:preference:oublog_accordion_allposts_open'] = 'Cual panel es visible dentro de la visualización de estadísticas (página para ver todas las publicaciones).';
$string['privacy:metadata:preference:oublog_accordion_view_open'] = 'Cual panel es visible dentro de la visualización de estadísticas (página para ver blog normal).';
$string['privacy:metadata:preference:oublog_tagorder'] = 'El orden que Usted ha elegido para mostrar las marcas.';
$string['privacy_commentnumber'] = 'Comentario {$a}';
$string['privacy_commentplaceholder'] = '(Comentario eliminado a  solicitud del usuario)';
$string['privacy_editnumber'] = 'Editar {$a}';
$string['privacy_somebodyelse'] = 'Alguien más';
$string['privacy_you'] = 'Usted';
$string['publiccomments'] = 'Si, por todos (aunque no estén identificados)';
$string['publiccomments_info'] = 'Si alguien añade un comentario cuando no estén identificados, Usted recibirá un correo electrónico y puede aprobar o rechazar el coemntario. Esto es necesario para prevenir el spam.';
$string['re'] = 'Re: {$a}';
$string['recentcomments'] = 'Comentarios recientes';
$string['recentposts'] = 'Publicaciones recientes';
$string['remoteserver'] = 'Importar desde servidor remoto';
$string['remotetoken'] = 'Importar token de servidor remoto';
$string['removeblogs'] = 'Quitar todas las entradas del blog';
$string['reportingemail'] = 'Direcciones Email para reportes';
$string['reportingemail_help'] = 'Esta configuración especifica las direcciones Email de aquellos que serán informados sobre asuntos/problemas con publicaciones o comentarios dentro de OUBlog. Estas direcciones deberán escribirse como una lista separada por comas.';
$string['restricttags'] = 'Opciones de marcas';
$string['restricttags_default'] = 'Añadir marcas por defecto';
$string['restricttags_help'] = 'Si Usted selecciona esta opción, Usted puede restringir el ingreso de marcas a solamente aquellas que estén pre-definidas a nivel de actividad, o exigir que se ingrese al menos una marca en una publicación.';
$string['restricttags_req'] = 'Debe ingresar marcas';
$string['restricttags_req_set'] = 'Solamente debe ingresar marcas pre-definidas';
$string['restricttags_set'] = 'Permitir solamente marcas pre-definidas';
$string['restricttagslist'] = 'Usted solamente puede escribir las marcas \'Configuradas\': {$a}';
$string['restricttagsvalidation'] = 'Solamente las marcas \'Configuradas\' están permitidas para escribirse';
$string['rss'] = 'RSS';
$string['rssfeed'] = 'Canal RSS';
$string['savefailnetwork'] = '<p>Desafortunadamente, sus cambios no pudieron guardarse por ahora. Esto se debe a un error en la red; el sitio web está temporalmente no-disponible o Usted ha salido del sitio. </p>
<p>Se ha deshabilitado el guardar en este blog. Para conservar los cambios que hizo, Usted debe de copiar el contenido editado del blog, acceder a la página para editar nuevamente y después pegar sus cambios.</p>';
$string['savefailtitle'] = 'La publicación no pudo guardarse';
$string['savegrades'] = 'Guardar calificaciones';
$string['search:activity'] = 'OU blog - información de actividad';
$string['search:comments'] = 'OU blog - comentarios a la publicación';
$string['search:post'] = 'OU blog - publicaciones';
$string['searchblogs'] = 'Buscar';
$string['searchblogs_help'] = 'Escriba su término a buscar y presione ENTER o haga click en el botón.

Para buscar frases exactas use comillas dobles "...".

Para excluir un apalabra inserte un guión medio - inmediatamente antes de la palabra.

Ejemplo: la búsqueda de <tt>picasso -escultura "primeros trabajos"</tt> regresará resultados para ‘picasso’ o la frase de ‘primeros trabajos’ pero excluirá los ítems que contengan  ‘escultura’.';
$string['searchthisblog'] = 'Buscar este {$a}';
$string['sendanddelete'] = 'Enviar y eliminar';
$string['separateindividual'] = 'Individuos separados';
$string['separateindividualblogs'] = 'Separar blogs individuales';
$string['share'] = 'Compartir publicación';
$string['sharedblog'] = 'Blog compartido';
$string['sharedblog_error'] = 'Error - no hay disponibles blogs con esa ID';
$string['sharedblog_existed'] = 'Este es un número ID de un blog hijo';
$string['sharedblog_help'] = '<p><strong>Blog compartido</strong></p>
<p>Esta opción le permite a la instancia de blog actuar como un blog \'hijo\' y mostrar el contenido de un blog \'paterno\'.</p>
<p>Por favor ingrese el valor del campo IDNumber del blog \'paterno\' cuyo contenido usted quiere que muestre este blog</p>';
$string['sharedblog_invalid'] = 'Sin número ID coincidente';
$string['sharedblog_invalid_morethan1'] = 'Más de 1 número ID coincidente';
$string['sharedblog_mastered'] = 'Este blog ya es un blog paterno';
$string['siteentries'] = 'Ver entradas al sitio';
$string['start'] = 'De';
$string['statblockon'] = 'Mostrar estadísticas extra sobre uso del blog';
$string['statblockon_help'] = 'Habilitar que se muestren estadísticas extra en el \'bloque\' de uso del Blog.
Solamente Blogs de los tipos Personal (global), Visible Individual y Visible Grupo.';
$string['strftimerecent'] = '%d %B %y, %H:%M';
$string['subscribefeed'] = 'Suscribirse al cana (requiere software apropiado) para recibir notficación cundo este {$a} sea actualizado';
$string['summary'] = 'Resumen';
$string['tags'] = 'Marcas';
$string['tags_help'] = 'Las marcas son etiquetas que le ayudan a encontrar y categorizar publicaciones.';
$string['tagsfield'] = 'Marcas (separadas por comas)';
$string['tagshowless'] = 'Mostrar menos ...';
$string['tagshowmore'] = 'Mostrar más ...';
$string['tagupdatefailed'] = 'Falló al actualizar marcas';
$string['teachergrading'] = 'El profesor califica estudiantes';
$string['timefilter_alltime'] = 'Todo el tiempo';
$string['timefilter_close'] = 'Ocultar opciones';
$string['timefilter_label'] = 'Período de tiempo';
$string['timefilter_open'] = 'Mostrar opciones';
$string['timefilter_submit'] = 'Actualizar';
$string['timefilter_thismonth'] = 'Mes anterior';
$string['timefilter_thisyear'] = 'Año anterior';
$string['timestartenderror'] = 'La fecha de fin de la selección no puede ser anterior a la fecha de inicio';
$string['title'] = 'Título';
$string['tweet'] = 'Tweet';
$string['unsupportedbrowser'] = '<p>Su navegador no puede mostrar canales Atom o RSS directamente.</p> <p>Los canales son más útiles en programas independientes de cómputo o sitios web. Si Usted desea usar estos canales en alguno de esos programas, copie y pegue la dirección desde la barra de direcciones de su navegador web.</p>';
$string['untitledcomment'] = 'Comentario sin título';
$string['untitledpost'] = 'Publicación sin-título';
$string['url'] = 'Dirección de internet completa';
$string['use'] = 'La-más-usada';
$string['usergrade'] = 'Calificación del usuario';
$string['userparticipation'] = 'Participación del usuario';
$string['userrating'] = 'Usar valoraciones';
$string['usersparticipation'] = 'Participación de todos los usuarios';
$string['viewallparticipation'] = 'Ver toda la participación';
$string['viewallusers'] = 'Ver todos los usuarios';
$string['viewallusersingroup'] = 'Ver todos los usuarios del grupo';
$string['viewblogdetails'] = 'Ver detalles del blog';
$string['viewblogposts'] = 'Regresar al blog';
$string['viewedit'] = 'Ver edición';
$string['viewmyparticipation'] = 'Ver mi participación';
$string['views'] = 'Visitas totales a este  {$a}:';
$string['visibility'] = '¿Quién puede ver esto?';
$string['visibility_help'] = '<p><strong>Visible para participantes en este curso</strong> – para ver la publicación Usted debe haber recibido previamente acceso a este blog, usualmente al inscribirse en el curso que contiene el blog.</p>

<p><strong>Visible para todos los identificados en el sistema</strong> – todos los que estén identificados en el sistema pueden ver la publicación, aún si no estuvieran inscritos en algún curso específico.</p> <p><strong>Visible para todo el mundo</strong> – cualquier usuario de internet puede ver la publicación si Usted le proporciona la dirección del blog.</p>';
$string['visibleblogusers'] = 'Visible solamente a miembros de este blog';
$string['visiblecourseusers'] = 'Visible a participantes de este curso';
$string['visibleindividual'] = 'Individuos visibles';
$string['visibleindividualblogs'] = 'Visible blogs individuales';
$string['visibleloggedinusers'] = 'Visible a todos los identificados en el sistema';
$string['visiblepublic'] = 'Visible a todo el mundo';
$string['visibleyou'] = 'Visible solamente al propietario del blog (privado)';
$string['visits'] = 'Más visitado';
$string['visits_info_active'] = 'Activo {$a}s (contiene una publicación en el mes anterior) con el mayor número de visitas';
$string['visits_info_alltime'] = '{$a}s con el mayor número de visitas';
$string['yes'] = 'Si';
