<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'journal', language 'es_mx', version '4.0'.
 *
 * @package     journal
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Acceso denegado';
$string['alwaysopen'] = 'Siempre abierto';
$string['blankentry'] = 'Entrada vacía';
$string['couldnotupdatejournal'] = 'No se pudo actualizar su Diario';
$string['countnotinsertjournalentry'] = 'No se pudo insertar una nueva entrada de Diario';
$string['crontask'] = 'Procesamiento en segundo plano para módulo Journal';
$string['dateasc'] = 'Fecha ascendiente';
$string['datedesc'] = 'Fecha descendiente';
$string['daysavailable'] = 'Días disponibles';
$string['deadline'] = 'Días Abierto';
$string['editingended'] = 'El período de edición ha terminado';
$string['editingends'] = 'El período de edición termina';
$string['entries'] = 'Entradas';
$string['entry'] = 'Entrada';
$string['evententriesviewed'] = 'Entradas de Diario vistas';
$string['evententrycreated'] = 'Entrada de Diario creada';
$string['evententryupdated'] = 'Entradas de Diario actualizadas';
$string['eventfeedbackupdated'] = 'Retralimentación de Diario actualizada';
$string['eventjournalcreated'] = 'Diario creado';
$string['eventjournaldeleted'] = 'Diario eliminado';
$string['eventjournalviewed'] = 'Diario visto';
$string['failedupdate'] = 'No se pudo actualizar la retroalimentación del Diario para {$a}';
$string['feedbackupdated'] = 'Retroalimentación actualizada para {$a} entradas';
$string['feedbackupdatedforuser'] = 'Retroalimentación actualizada para {$a}';
$string['firstnameasc'] = 'Nombre Ascendiente';
$string['firstnamedesc'] = 'Nombre Descendidente';
$string['gradeingradebook'] = 'Calificación actual en libro de calificaciones';
$string['incorrectcmid'] = 'ID del módulo de curso es incorrecta';
$string['incorrectcourseid'] = 'ID del curso es incorrecta';
$string['incorrectcoursesectionid'] = 'La sección seleccionada del curso es incrrecta';
$string['incorrectjournalentry'] = 'La entrada seleccionada del Diario es incorrecta';
$string['incorrectjournalid'] = 'La ID seleccionada del Diario es incorrecta';
$string['incorrectuserid'] = 'La ID seleccionada del usuario es incorrecta';
$string['journal:addentries'] = 'Añadir entradas a Diario';
$string['journal:addinstance'] = 'Añadir un nuevo Diario';
$string['journal:manageentries'] = 'Gestionar entradas de Diario';
$string['journalmail'] = '{$a->teacher} ha publicado una retroalimentación en su entrada de Diario para \'{$a->journal}\'

Usted puede verla adjunta a su entrada de Diario:

{$a->url}';
$string['journalmailhtml'] = '{$a->teacher} ha publicado retroalimentación en su entrada de Diario para  \'<i>{$a->journal}</i>\'<br /><br /> Usted puede verla adjunta a su  <a href="{$a->url}">entrada de Diario</a>.';
$string['journalname'] = 'Nombre de Diario';
$string['journalquestion'] = 'Pregunta de Diario';
$string['lastnameasc'] = 'Apellido(s) Ascendientes';
$string['lastnamedesc'] = 'Apellido(s) Descendientes';
$string['mailsubject'] = 'Retroalimentación de Diario';
$string['modulename'] = 'Diario (Journal)';
$string['modulename_help'] = 'La actividad de Diario (journal) les permite a los profesores obtener retroalimentación de estudiantes sobre un tópico/tema específico';
$string['modulename_link'] = 'mod/journal/view';
$string['modulenameplural'] = 'Diarios';
$string['needsregrade'] = 'La entrada ha cambiado desde que se guardó la última retroalimentación.';
$string['newjournalentries'] = 'Nuevas entradas de Diario';
$string['nodatachanged'] = 'No se cambió ningún dato';
$string['nodeadline'] = 'Siempre abierta';
$string['noentriesmanagers'] = 'No hay profesores';
$string['noentry'] = 'Sin entradas';
$string['noratinggiven'] = 'Sin valuaciones dadas';
$string['notopenuntil'] = 'El Diario  no estará abierto sino hasta después de';
$string['notstarted'] = 'Usted aún no ha empezado este Diario';
$string['overallrating'] = 'Valuación general';
$string['pluginadministration'] = 'Administración del módulo Diario';
$string['pluginname'] = 'Diario (Journal(';
$string['privacy:metadata:journal_entries'] = 'Un registro de entrada de Journal';
$string['privacy:metadata:journal_entries:entrycomment'] = 'El comentario recibido por un usuario a Journal';
$string['privacy:metadata:journal_entries:modified'] = 'La hora de inicio de las entradas de Journal.';
$string['privacy:metadata:journal_entries:rating'] = 'La valoración recibida por usuario a Journal';
$string['privacy:metadata:journal_entries:teacher'] = 'El profesor que ha dado retroalimentación al usuario en Journal';
$string['privacy:metadata:journal_entries:text'] = 'El texto escrito por el usuario';
$string['privacy:metadata:journal_entries:userid'] = 'La ID del usuario';
$string['rate'] = 'Valorar';
$string['removeentries'] = 'Remover todas las entradas';
$string['removemessages'] = 'Quitar todas las entradas de Diario';
$string['saveallfeedback'] = 'Guardar todas mis retroalimentaciones';
$string['savefeedback'] = 'Guardar retroalimentación';
$string['search:activity'] = 'journal - información de actividad';
$string['search:entry'] = 'journal - entradas';
$string['showoverview'] = 'Mostrar vista general de Diariosen mi Moodle';
$string['showrecentactivity'] = 'Mostrar actividad reciente';
$string['startoredit'] = 'Iniciar o editar mi entrada de Diario';
$string['userswhocompletedthejournal'] = 'Usuarios que completaron el Diario';
$string['userswhodidnotcompletedthejournal'] = 'Usuarios que NO completaron el Diario';
$string['viewallentries'] = 'Ver {$a} entradas de Diario';
$string['viewentries'] = 'Ver entradas';
