<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'es_mx', version '4.0'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'PORHACER';
$string['activityisscheduledfordeletion'] = 'Eliminación de actividad en progreso...';
$string['agedigitalconsentmapinvalidage'] = '"{$a}" no es un valor válido para edad.';
$string['agedigitalconsentmapinvalidcomma'] = '"{$a}" tiene más o menos de una coma separadora.';
$string['agedigitalconsentmapinvalidcountry'] = '"{$a}" no es un valor válido para país.';
$string['agedigitalconsentmapinvaliddefault'] = 'El valor predeterminado  de (*) falta.';
$string['agelocationverificationdisabled'] = 'Verificación de ubicación y edad deshabilitadas';
$string['alreadyloggedin'] = 'Usted ya ha iniciado sesión como {$a}; es necesario cerrar la sesión antes de volver a iniciar sesión como un usuario diferente.';
$string['authnotexisting'] = 'El plugin de autorización no existe';
$string['backupcontainexternal'] = 'Este archivo de respaldo contiene Hosts de la Red Moodle (Moodle Network Hosts) externos que no están configurados localmente';
$string['backuptablefail'] = 'NO se han podido armar con éxito las tablas de respaldos';
$string['blockcannotconfig'] = 'Este bloque no admite configuración global';
$string['blockcannotinistantiate'] = 'Problema al instanciar el objeto de bloque';
$string['blockcannotread'] = 'No se pudieron leer los datos para blockid={$a}';
$string['blockdoesnotexist'] = 'Este bloque no existe';
$string['blockdoesnotexistonpage'] = 'Este bloque (id={$a->instanceid}) no existe en esta página ({$a->url}).';
$string['blocknameconflict'] = 'Conflicto de nombres: el bloque {$a->name} tiene el mismo nombre que el bloque: {$a->conflict}';
$string['callbackrejectcomment'] = 'Retrollamada de comentario rechazó este comentario.';
$string['cannotaddcoursemodule'] = 'No se pudo agregar un módulo de curso nuevo';
$string['cannotaddcoursemoduletosection'] = 'No se pudo agregar el módulo de curso nuevo a esa sección';
$string['cannotaddmodule'] = 'No se pudo agregar el módulo {$a} a la lista de módulos.';
$string['cannotaddnewmodule'] = 'No se pudo agregar un nuevo módulo de {$a}';
$string['cannotaddrss'] = 'No tiene permiso para agregar canales RSS';
$string['cannotaddthisblocktype'] = 'No puede agregar un bloque {$a} a esta página.';
$string['cannotassignrole'] = 'No se puede asignar rol en el curso';
$string['cannotassignrolehere'] = 'Usted no tiene permitido asignar este rol (id = {$a->roleid}) en este contexto ({$a->context})';
$string['cannotassignselfasparent'] = '¡No se puede asignar uno mismo como padre!';
$string['cannotcallscript'] = 'Usted no puede llamar este script de esa forma';
$string['cannotcallusgetselecteduser'] = 'Usted no puede llamar user_selector::get_selected_user si multi selección es verdadero.';
$string['cannotcreatebackupdir'] = 'No se puede crear el directorio backupdata. El administrador del sitio necesita modificar los permisos de archivo';
$string['cannotcreatecategory'] = 'La categoría no fue insertada';
$string['cannotcreatedboninstall'] = '<p>No puede crearse la BasedeDatos.</p> <p>La BasedeDatos especificada no existe y el usuario dado no tiene permiso para crear la BasedeDatos.</p> <p>El administrador del sitio debería verificar la configuración de la BasedeDatos.</p>';
$string['cannotcreategroup'] = 'Error al crear el grupo';
$string['cannotcreatelangbase'] = 'Error: No se pudo crear el directorio base de idioma';
$string['cannotcreatelangdir'] = 'No se puede crear el directorio de idioma.';
$string['cannotcreateorfindstructs'] = 'Error al encontrar o crear estructuras de la sección de este curso';
$string['cannotcreatepopupwin'] = 'Elemento no definido (no se pudo crear ventana desplegable)';
$string['cannotcreatesitedir'] = 'No se pudo crear el directorio del sitio. El administrador necesita arreglar los permisos de archivos.';
$string['cannotcreatetempdir'] = 'No se puede crear el directorio temp.';
$string['cannotcreateuploaddir'] = 'No se pudo crear directorio de subida. El administrador necesita arreglar los permisos de archivos.';
$string['cannotcustomisefiltersblockuser'] = 'Usted no puede personalizar filtros de ajustes en contextos de usuario o de bloque.';
$string['cannotdeletebackupids'] = 'No se pudieron eliminar ids de respaldos anteriores';
$string['cannotdeletecategorycourse'] = 'El curso \'{$a}\' no pudo ser eliminado.';
$string['cannotdeletecategoryquestions'] = 'No se pudo eliminar las preguntas de la categoría \'{$a}';
$string['cannotdeletecourse'] = 'Usted no tiene permiso para eliminar este curso';
$string['cannotdeletecustomfield'] = 'Error al eliminar datos de campos personalizados';
$string['cannotdeletedir'] = 'No se puede eliminar ({$a})';
$string['cannotdeletefile'] = 'No se puede eliminar este archivo';
$string['cannotdeleterole'] = 'No puede ser eliminado, debido a {$a}';
$string['cannotdeleterolewithid'] = 'No puede eliminar el rol con ID {$a}';
$string['cannotdeletethisrole'] = 'No se puede eliminar este rol porque es utilizado por el sistema, o porque es el último rol con capacidades de administrador.';
$string['cannotdisableformat'] = 'El formato predeterminado no puede ser deshabilitado.';
$string['cannotdownloadcomponents'] = 'No se puede descargar componentes';
$string['cannotdownloadlanguageupdatelist'] = 'No se puede descargar la lista de actualizaciones del idioma desde download.moodle.org';
$string['cannotdownloadzipfile'] = 'No se puede descargar el archivo ZIP';
$string['cannoteditcomment'] = 'Este comentario no es suyo: no lo puede editar';
$string['cannoteditcommentexpired'] = 'Usted no puede editar esto. ¡El tiempo ha expirado!';
$string['cannoteditpostorblog'] = 'Usted no puede publicar o editar los blogs';
$string['cannoteditsiteform'] = 'Usted no puede modificar el curso del sitio usando esta forma';
$string['cannotedituserpreferences'] = 'No pueden editarse las preferencias de este usuario';
$string['cannotedityourprofile'] = 'Lo sentimos, no puede editar su perfil propio';
$string['cannotexecduringupgrade'] = 'No puede ejecutarse durante la actualización';
$string['cannotfindcategory'] = 'No puedo encontrar el registro de la categoría de la base de datos con ID - {$a}';
$string['cannotfindcomponent'] = 'No se puede encontrar el componente.';
$string['cannotfindcontext'] = 'No se puede encontrar el contexto';
$string['cannotfindcourse'] = 'No se puede encontrar el curso';
$string['cannotfinddocs'] = 'No se pueden encontrar "{$a}" archivos de documentos de idioma';
$string['cannotfindgradeitem'] = 'No se puede encontrar grade_item';
$string['cannotfindgroup'] = 'No se puede encontrar el grupo';
$string['cannotfindhelp'] = 'No se pueden encontrar "{$a}" archivos de ayuda de idioma';
$string['cannotfindinfo'] = 'No se puede encontrar información para: "{$a}"';
$string['cannotfindlang'] = 'No se puede encontrar el paquete de idioma "{$a}"!';
$string['cannotfindteacher'] = 'No se puede encontrar al profesor';
$string['cannotfinduser'] = 'No se puede encontrar el usuario con nombre "{$a}"';
$string['cannotgeoplugin'] = 'No se puede conectar al servidor de geoPlugin en https://www.geoplugin.com, por favor revise la configuración del proxy, o mejor aún, instale el archivo de datos de  MaxMind GeoLite City';
$string['cannotgetblock'] = 'No se pudo recuperar bloques de la base de datos';
$string['cannotgetcats'] = 'No se pudo obtener el registro de la categoría';
$string['cannotgetdata'] = 'No se pudo obtener información';
$string['cannotgradeuser'] = 'No se pudo calificar este usuario';
$string['cannothaveparentcate'] = 'La categoría del curso no pueden tener una categoría padre!';
$string['cannotimport'] = 'Error de importación';
$string['cannotimportformat'] = 'Lo sentimos, la importación de este formato aún no está implementado!';
$string['cannotimportgrade'] = 'Error al importar calificaciones';
$string['cannotinsertgrade'] = '¡ No se puede insertar el elemento de calificación sin el id de curso !';
$string['cannotinsertrate'] = 'No se puede insertar una nueva evaluación ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'No se pudo insertar el ID del nuevo registro {$a}';
$string['cannotmailconfirm'] = 'Error al enviar el correo electrónico de confirmación de cambio de contraseña';
$string['cannotmanualctrack'] = 'La actividad no prevé seguimiento manual de finalización';
$string['cannotmapfield'] = 'Colisión del mapeo detectada - dos campos se mapean al mismo elemento de calificación {$a}';
$string['cannotmarktopic'] = 'No se pudo marcar ese tópico/tema para este curso';
$string['cannotmigratedatacomments'] = 'No se pueden migrar los comentarios del módulo de datos';
$string['cannotmodulename'] = 'No puedo obtener el nombre del módulo del constructor de navegación';
$string['cannotmoduletype'] = 'No puedo obtener el tipo del módulo del constructor de navegación';
$string['cannotmovecategory'] = 'No puede moverse categoría';
$string['cannotmovecourses'] = 'No se pueden mover cursos desde la categoría en la que están hacia otra categoría.';
$string['cannotmoverolewithid'] = 'No puedo mover el rol con ID {$a}';
$string['cannotopencsv'] = 'No se puede abrir el archivo CVS';
$string['cannotopenfile'] = 'No se puede abrir el archivo ({$a})';
$string['cannotopenforwrit'] = 'No se puede abrir para escritura: {$a}';
$string['cannotopentemplate'] = 'No se puede abrir el archivo de la plantilla ({$a})';
$string['cannotopenzip'] = 'No se puede abrir el archivo zip. probablemente por un error en la extensión zip en un sistema operativo de 64 bits';
$string['cannotoverridebaserole'] = 'No se pueden anular las capacidades del rol base';
$string['cannotoverriderolehere'] = 'Usted no tiene permitido anular este rol (id = {$a->roleid}) en este contexto ({$a->context})';
$string['cannotreadfile'] = 'No se puede leer el archivo ({$a})';
$string['cannotreadtmpfile'] = 'Error al leer el archivo temporal';
$string['cannotreaduploadfile'] = 'No se puede leer el archivo que ha subido';
$string['cannotremovefrommeta'] = 'No se puede eliminar el curso seleccionado de este meta curso!';
$string['cannotreprocessgrades'] = 'No se pudo re-procesar calificaciones para esta actividad {$a}';
$string['cannotresetguestpwd'] = 'No se puede restablecer la contraseña de invitado';
$string['cannotresetmail'] = 'Error al restablecer la contraseña y enviársela por correo.';
$string['cannotresetthisrole'] = 'No se puede restablecer este rol';
$string['cannotrestore'] = 'Ha ocurrido un error y la restauración no se pudo completar!';
$string['cannotrestoreadminorcreator'] = 'Usted necesita ser un usuario creador o  administrador para restaurar a un curso nuevo!';
$string['cannotrestoreadminoredit'] = 'Usted necesita ser un usuario profesor o  administrador para restaurar en el curso seleccionado!';
$string['cannotsaveagreement'] = 'No se puede guardar su acuerdo';
$string['cannotsaveblock'] = 'Error al salvar la configuración del bloque';
$string['cannotsavecomment'] = 'No se puede salvar el comentario';
$string['cannotsavedata'] = 'No se puede salvar la información';
$string['cannotsavefile'] = 'No se puede salvar el archivo "{$a}"!';
$string['cannotsavemd5file'] = 'No se puede guardar el archivo md5';
$string['cannotsavezipfile'] = 'No se puede guardar el archivo ZIP';
$string['cannotservefile'] = 'No se puede servir el archivo por causa de un problema de configuración del servidor.';
$string['cannotsetparentforcatoritem'] = 'No se puede establecer el padre para la categoría o elemento del curso!';
$string['cannotsetpassword'] = 'No se puede establecer la contraseña del usuario!';
$string['cannotsetprefgrade'] = 'No se puede establecer la preferencia para la vista de agregación a {$a} para esta categoría de calificación';
$string['cannotsettheme'] = '¡No se puede establecer el tema!';
$string['cannotsetupblock'] = '¡Las tablas de los bloques NO se pudieron establecer de forma exitosa!';
$string['cannotsetupcapformod'] = 'No se pueden establecer las capacidades para {$a}';
$string['cannotsetupcapforplugin'] = 'No se pueden establecer las capacidades para {$a}';
$string['cannotshowhidecoursesincategory'] = 'No se puede mostrar/ocultar los cursos en la categoría {$a}';
$string['cannotsignup'] = 'Usted no puede crear una cuenta nueva porque ya ha iniciado sesión como {$a}.';
$string['cannotswitcheditmodeon'] = 'No se pudo activar modo de edición';
$string['cannotunassigncap'] = 'No se puede revocar la asignación de la capacidad obsoleta {$a->cap} del rol {$a->role}';
$string['cannotunassignrolefrom'] = 'No se puede revocar la asignación de este usuario del Id de rol: {$a}';
$string['cannotunzipfile'] = 'No se puede descomprimir el archivo';
$string['cannotupdatemod'] = 'No se puede actualizar {$a}';
$string['cannotupdatepasswordonextauth'] = 'No se pudo actualizar la contraseña mediante autenticación externa: {$a}. Vea llas bitácoras del servidor para más detalles.';
$string['cannotupdateprofile'] = 'Error al actualizar el registro de usuario';
$string['cannotupdaterecord'] = 'No se puede actualizar el ID de registro {$a}';
$string['cannotupdaterss'] = 'No se puede actualizar RSS';
$string['cannotupdatesubcourse'] = 'No se puede actualizar un curso hijo!';
$string['cannotupdateusermsgpref'] = 'No se puede actualizar las preferencias de mensajes del usuario';
$string['cannotupdateuseronexauth'] = 'No se pudo actualizar los datos de usuario mediante autenticación externa: {$a}. Vea las bitácoras del servidor para más detalles';
$string['cannotuploadfile'] = 'Error al procesar el archivo subido';
$string['cannotuseadmin'] = 'Usted necesita ser un usuario administrador para usar esta página';
$string['cannotuseadminadminorteacher'] = 'Usted necesita ser un usuario profesor o administrador para usar esta página';
$string['cannotusepage'] = 'Sólo profesores y administradores pueden usar esta página';
$string['cannotusepage2'] = 'Lo sentimos, Usted no puede usar esta página';
$string['cannotviewcategory'] = 'Usted no tiene permiso para ver esta lista de cursos.';
$string['cannotviewprofile'] = 'No puede ver el perfil de este usuario';
$string['cannotviewreport'] = 'Usted no puede ver este reporte';
$string['cannotwritefile'] = 'No se puede escribir en el archivo ({$a})';
$string['categoryerror'] = 'Error de Categoría';
$string['categoryidnumbertaken'] = 'El número ID ya está siendo usado por otra categoría';
$string['categorynamerequired'] = 'Se requiere el nombre de la categoría';
$string['categorytoolong'] = 'Nombre de categoría demasiado largo';
$string['commentmisconf'] = 'ID del comentario está mal configurado';
$string['componentisuptodate'] = 'El componente está actualizado';
$string['confirmationnotenabled'] = 'La confirmación de usuario no está habilitada en este sitio';
$string['confirmsesskeybad'] = 'Lo sentimos, pero su clave de sesión no ha podido ser confirmada para llevar a cabo esta acción. Esta característica de seguridad previene contra la ejecución en su nombre (accidental o maliciosa) de funciones importantes. Por favor, asegúrese de que realmente deseaba ejecutar esta función.';
$string['contenttypenotfound'] = 'El tipo de banco de contenido \'{$a}\' no existe o no es reconocido.';
$string['contentvisibilitynotfound'] = 'La visibilidad del contenido con valor \'{$a}\' no existe o no es reconocida.';
$string['couldnotassignrole'] = 'Al intentar asignarle un rol, ha ocurrido un error grave no especificado';
$string['couldnotupdatenoexistinguser'] = 'No se puede actualizar el usuario - el usuario no existe';
$string['couldnotverifyagedigitalconsent'] = 'Ocurrió un error al tratar de verificar la edad de consentimiento digital.<br />Por favor contacte al administrador.';
$string['countriesphpempty'] = 'Error: El archivo countries.php en el paquete de idioma {$a} está vacío o no existe.';
$string['coursedoesnotbelongtocategory'] = 'El curso no pertenece a esta categoría';
$string['courseformatnotfound'] = 'El formato del curso \'{a}\' no existe o no es reconocido.';
$string['coursegroupunknown'] = 'No se ha especificado el curso correspondiente al grupo {$a}';
$string['courseidnotfound'] = 'La ID del curso no existe.';
$string['courseidnumbertaken'] = 'El número ID ya está siendo usado para otro curso ({$a})';
$string['coursemisconf'] = 'El curso está mal configurado';
$string['courserequestdisabled'] = 'Lo sentimos, pero solicitar cursos ha sido deshabilitado por el administrador.';
$string['csvcolumnduplicates'] = 'Detectadas columnas duplicadas';
$string['csvemptyfile'] = 'El archivo CVS está vacío';
$string['csvfewcolumns'] = 'No hay suficientes columnas; por favor, verifique la configuración del separador';
$string['csvfileerror'] = 'Algo está mal con el formato del archivo CSV. Por favor compruebe que coincidan el número de encabezados y de columnas, y que el separador y la codificación del archivo sean correctas. {$a}';
$string['csvinvalidcols'] = '<b>Archivo CSV invalido:

</b> La primera línea debe incluir "Campos de Cabecera" y el archivo debe ser de tipo<br />

"Campos expandidos/Separados por comas"<br />o<br />

 "Campos expandidos con Código de Resultado CAVV/Separados por comas"';
$string['csvinvalidcolsnum'] = 'Archivo CSV invalido - cada línea debe incluir 49 o 70 campos';
$string['csvloaderror'] = 'Ocurrió un error durante la carga del archivo CSV: {$a}';
$string['csvnodata'] = 'Archivo CSV inválido - El archivo CSV tiene encabezados pero no contiene ningún dato.';
$string['csvweirdcolumns'] = 'Formato de archivo CSV no válido: el número de columnas no es constante.';
$string['dbconnectionfailed'] = '<p>Error:La conexión con la base de datos falló</p>
<p>Es posible que la base de datos esté sobrecargada o no funcione correctamente. </p>
<p>El administrador del sitio debe comprobar que los detalles de la base de datos han sido correctamente especificados en config.php </p>{$a}';
$string['dbdriverproblem'] = '<p>Error: Se ha detectado un problema en el controlador de la base de datos</p>
<p>El administrador del sitio debe comprobar la configuración del servidor</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'Se ha detectado un serio problema en la sesión de la base de datos. <br /> <br /> Por favor notifique al administrador del servidor.';
$string['dbsessionhandlerproblem'] = 'El configurar una sesión en la base de datos ha fallado. Por favor notifique al administrador del servidor.';
$string['dbsessionmysqlpacketsize'] = 'Se ha detectado un serio problema en la sesión. Por favor notifique al administrador del sitio. Este problema es muy probablemente causado por un valor pequeño en la opción max_allowed_packet de la configuración de MySQL.';
$string['dbupdatefailed'] = 'Fallo en la actualización de la base de datos.';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" no puede ser modificado.
Dependencia encontrada con {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'Error de ejecución DDL sql';
$string['ddlfieldalreadyexists'] = 'El campo "{$a}" ya existe';
$string['ddlfieldnotexist'] = 'El campo"{$a->fieldname}" no existe en la tabla "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'La tabla "{$a}" ya existe';
$string['ddltablenotexist'] = 'La tabla "{$a}"no existe';
$string['ddlunknownerror'] = 'Error desconocido en la biblioteca DDL';
$string['ddlxmlfileerror'] = 'Se encontró errores en los archivos de la base de datos XML';
$string['ddsequenceerror'] = 'Definición incorrecta de la tabla "{$a}"; sólo puede haber una columna automática y debe definirse como una clave.';
$string['destinationcmnotexit'] = 'El módulo del curso destino no existe';
$string['detectedbrokenplugin'] = 'El plugin "{$a}" es defectuoso o no actualizado: lo sentimos, no se puede continuar.';
$string['dmlexceptiononinstall'] = '<p>Ocurrió un error en la BasedeDatos[{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'Error al analizar consulta SQL';
$string['dmlreadexception'] = 'Error al leer de la base de datos';
$string['dmltransactionexception'] = 'Error en la transacción con la base de datos';
$string['dmlwriteexception'] = 'Error al escribir a la base de datos';
$string['downgradedcore'] = '¡ERROR! El código que está usando es MÁS ANTIGUO que la versión que construyó estas bases de datos.';
$string['downloadedfilecheckfailed'] = 'Ha fallado la comprobación del archivo descargado';
$string['duplicatefieldname'] = 'Se ha detectado un nombre duplicado del campo "{$a}"';
$string['duplicatenosupport'] = 'La actividad de
\'{$a->modname}\' no se pudo duplicar debido a que el módulo  {$a->modtype} no soporta respaldo y restauración.';
$string['duplicateparaminsql'] = 'ERROR: parámetro duplicado en la consulta';
$string['duplicaterolename'] = 'Ya hay un rol con ese nombre!';
$string['duplicateroleshortname'] = 'Ya hay un rol con ese nombre corto!';
$string['duplicateusername'] = 'Nombre de usuario duplicado: registro pasado por alto';
$string['emailfail'] = 'Enviar el correo electrónico falló';
$string['encryption_decryptfailed'] = 'Falló desencriptación';
$string['encryption_encryptfailed'] = 'Falló encriptación';
$string['encryption_invalidkey'] = 'Clave inválida';
$string['encryption_keyalreadyexists'] = 'La clave ya existe';
$string['encryption_nokey'] = 'Clave no encontrada';
$string['encryption_wrongmethod'] = 'Los datos no coinciden con un método de encriptación soportado';
$string['enddatebeforestartdate'] = 'La fecha de terminación del curso debe ser posterior a la fecha de inicio.';
$string['error'] = 'Ocurrió un error';
$string['error_question_answers_missing_in_db'] = 'No se encontró ninguna respuesta que coincidiera con "{$a->answer}" en la tabla de la BasedeDatos de  question_answers. Esto ocurrió al restaurar la pregunta con id {$a->filequestionid} en el archivo del respaldo, que ha sido aparejado con la pregunta existente con id {$a->dbquestionid} en la BasedeDatos.';
$string['errorcleaningdirectory'] = 'Error al limpiar el directorio  "{$a}"';
$string['errorcopyingfiles'] = 'Error al copiar archivos';
$string['errorcreatingdirectory'] = 'Error al crear el directorio  "{$a}"';
$string['errorcreatingfile'] = 'Error al crear el archivo  "{$a}"';
$string['errorcreatingrole'] = 'Error al crear el rol';
$string['errorfetchingrssfeed'] = 'Error al obtener el canal RSS.';
$string['erroronline'] = 'Error en la línea {$a}';
$string['erroroutput'] = 'Salida de error, por lo que se deshabilita redireccionamiento automático.';
$string['errorparsingxml'] = 'Error al analizar XML: {$a->errorstring} en la línea {$a->errorline}, carácter {$a->errorchar}';
$string['errorprocessingarchive'] = 'Error al procesar el archivo del archivo';
$string['errorreadingfile'] = 'Error al leer el archivo  "{$a}"';
$string['errorsavingrequest'] = 'Se produjo un error al intentar salvar su petición.';
$string['errorsettinguserpref'] = 'Error al ajustar las preferencias de usuario';
$string['errorunzippingfiles'] = 'Error al descomprimir archivos';
$string['expiredkey'] = 'Clave expirada';
$string['externalauthpassworderror'] = 'Contraseña no vacía para autenticación externa';
$string['externalfilenolocation'] = 'El archivo externo no tiene una ruta para localizarlo';
$string['failtoloadblocks'] = 'Uno o más bloques están registrados en la base de datos, ¡pero falló la carga de todos!';
$string['fieldrequired'] = '"{$a}" es un campo requerido';
$string['fileexists'] = 'El archivo ya existe';
$string['filemismatch'] = 'Discrepancia de nombres de archivos no básicos. ElL archivo "{$a->current}" debe ser {$a->file}';
$string['filenotfound'] = 'Lo sentimos, el archivo solicitado no se encuentra';
$string['filenotreadable'] = 'El archivo no es legible';
$string['filterdoesnothavelocalconfig'] = 'El filtro {$a} no permite configuración local';
$string['filternotactive'] = 'El filtro {$a} no se encuentra activo';
$string['filternotenabled'] = 'El filtro no está habilitado';
$string['filternotinstalled'] = 'El filtro {$a} no se encuentra instalado';
$string['forumblockingtoomanyposts'] = 'Usted ha excedido el umbral de tiempo para enviar mensajes a este foro.';
$string['functionalityremoved'] = 'Usted está intentando acceder a funcionalidad que ha sido eliminada.';
$string['generalexceptionmessage'] = 'Excepción - {$a}';
$string['gradecantregrade'] = 'Ocurrió un error durante el cálculo de la calificación: {$a}';
$string['gradepubdisable'] = 'Publicación de calificaciones deshabilitada';
$string['gradesneedregrading'] = 'Necesitan re-calcularse las calificaciones del curso';
$string['groupalready'] = 'El usuario ya pertence al grupo {$a}';
$string['groupexistforcourse'] = 'En este curso ya hay un grupo "{$a}".';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Grupo "{$a->name}" con un idnumber de "{$a->idnumber}" ya existe para este curso';
$string['grouphasidnumber'] = 'El Grupo "{$a}" tiene un idnumber y este pudo haber sido creado automáticamente por un sistema externo. Usted no tiene permiso para remover este grupo.';
$string['groupinghasidnumber'] = 'El Agrupamiento "{$a}" tiene un idnumber y este pudo haber sido creado automáticamente por un sistema externo. Usted no tiene permiso para remover este grupo.';
$string['groupingnotaddederror'] = 'El agrupamiento "{$a}" NO se añadió';
$string['groupnotaddederror'] = 'No se ha agregado el grupo "{$a}".';
$string['groupnotaddedtogroupingerror'] = 'El grupo "{$a->groupname}" NO se añadió al agrupamiento "{$a->groupingname}"';
$string['groupunknown'] = 'El grupo {$a} no está asociado al curso especificado';
$string['groupusernotmember'] = 'El usuario no es miembro de este grupo';
$string['guestcantaccessprofiles'] = 'Los invitados no pueden acceder a perfiles de usuario. Inicie sesión con una cuenta completa de usuario para continuar.';
$string['guestnocomment'] = 'A los invitados no se les permite publicar comentarios!';
$string['guestnoeditprofile'] = 'Los usuarios invitados no pueden editar su perfil';
$string['guestnoeditprofileother'] = 'No se puede editar el perfil de los usuarios invitados';
$string['guestnorate'] = 'A los invitados no se les permite evaluar entradas';
$string['guestsarenotallowed'] = 'Los usuarios invitados no tienen permitido hacer esto';
$string['hackdetected'] = 'Ataque de intrusión detectado!';
$string['hashpoolproblem'] = 'Contenido incorrecto del archivo de los \'hash pool\' {$a}.';
$string['headersent'] = 'Las cabeceras ya han sido enviadas';
$string['idnumbertaken'] = 'Este número de ID ya esta en uso';
$string['idnumbertoolong'] = 'Número ID es demasiado largo';
$string['importformatnotimplement'] = 'Lo sentimos, la importación de este formato aún no está implementada!';
$string['incorrectext'] = 'El archivo tiene una extensión incorrecta';
$string['inplaceeditableerror'] = 'Error al llamar al procesador de actualización';
$string['installproblem'] = 'Generalmente no es posible recuperarse de los errores encontrados durante la instalación; es posible que tenga que crear una nueva base de datos o usar un prefijo de base de datos diferente si desea volver a intentar hacer la instalación.';
$string['internalauthpassworderror'] = 'Política de contraseña ausente o no válida para autenticación interna';
$string['invalidaccess'] = 'Esta página no se ha accedido correctamente';
$string['invalidaccessparameter'] = 'Parámetro de acceso invalido';
$string['invalidaction'] = 'Parámetro de acción invalido';
$string['invalidactivityid'] = 'ID de actividad no válido';
$string['invalidadminsettingname'] = 'Configuración de admin ({$a}) no válida';
$string['invalidargorconf'] = 'No hay argumentos válidos suministrados o la configuración del servidor es incorrecta';
$string['invalidarguments'] = 'No hay argumentos válidos suministrados';
$string['invalidblockinstance'] = 'Instancia de bloque no válida para: {$a}';
$string['invalidbulkenrolop'] = 'Se ha solicitado una petición de alta masiva inválida';
$string['invalidcategory'] = 'Categoría incorrecta!';
$string['invalidcategoryid'] = '¡ ID de categoría incorrecta !';
$string['invalidcomment'] = 'El comentario es incorrecto';
$string['invalidcommentarea'] = 'Ára de comentarios inválida';
$string['invalidcommentid'] = 'ID de comentarios inválido';
$string['invalidcommentitemid'] = 'ID de elemento de comentario inválido';
$string['invalidcommentparam'] = 'Parámetros de comentario inválidos';
$string['invalidcomponent'] = 'Componente del nombre inválido';
$string['invalidconfirmdata'] = 'La confirmación de los datos no es válida';
$string['invalidcontentid'] = 'ID de contenido inválida';
$string['invalidcontext'] = 'Contexto no válido';
$string['invalidcountrycode'] = 'Código de país inválido: {$a}';
$string['invalidcourse'] = 'Curso no válido';
$string['invalidcourseformat'] = 'Formato de curso inválido';
$string['invalidcourseid'] = 'Está intentando usar una ID de curso no válida';
$string['invalidcourselevel'] = 'Nivel de contexto incorrecto';
$string['invalidcoursemodule'] = 'ID de módulo de curso no válida';
$string['invalidcoursenameshort'] = 'El nombre corto del curso no es válido';
$string['invaliddata'] = 'La información suministrada es inválida';
$string['invaliddatarootpermissions'] = 'Se han detectado permisos no válidos al tratar de crear un  directorio. Active la depuración (debugging) para más detalles.';
$string['invaliddevicetype'] = 'Tipo de dispositivo inválido';
$string['invalidelementid'] = '¡ El ID del elemento es incorrecto !';
$string['invalidentry'] = 'Esta no es una entrada válida!';
$string['invalidevent'] = 'Evento inválido';
$string['invalidfieldname'] = '"{$a}" no es un nombre válido';
$string['invalidfiletype'] = '"{$a}" no es un tipo de archivo válido';
$string['invalidformatpara'] = 'Formato incorrecto para el parámetro de selección';
$string['invalidformdata'] = 'Formato de datos incorrecto';
$string['invalidfunction'] = 'Función incorrecta';
$string['invalidgradeitemid'] = 'ID del elemento de calificación incorrecto';
$string['invalidgroupid'] = 'ID de grupo especificado incorrecto';
$string['invalidipformat'] = 'Formato de dirección IP no válido';
$string['invaliditemid'] = 'ID del elemento incorrecto';
$string['invalidkey'] = 'Clave incorrecta';
$string['invalidlanguagecode'] = 'Código de idioma inválido: {$a}';
$string['invalidlegacy'] = 'Definición del rol antiguo incorrecto para el tipo: {$a}';
$string['invalidmd5'] = 'La variable de verificación MD5 es incorrecta no es valida - trate nuevamente';
$string['invalidmode'] = 'Módulo no válido ({$a})';
$string['invalidmodule'] = 'Módulo no válido';
$string['invalidmoduleid'] = 'Id de Módulo no válido: {$a}';
$string['invalidmodulename'] = 'Nombre de Módulo no válido: {$a}';
$string['invalidnum'] = 'Valor numérico no válido';
$string['invalidnumkey'] = 'La matriz $conditions no puede contener llaves numéricas. ¡Por favor, corrija el código!';
$string['invalidoutcome'] = 'ID de resultado incorrecto';
$string['invalidpagesize'] = 'Tamaño de página incorrecto';
$string['invalidpasswordpolicy'] = 'Directiva de contraseñas errónea';
$string['invalidpaymentmethod'] = 'Método de pago incorrecto: {$a}';
$string['invalidpersistenterror'] = 'Error: {$a}';
$string['invalidqueryparam'] = 'ERROR: Número incorrecto de parámetros de consulta. Se esperaban {$a->expected}, se tienen {$a->actual}.';
$string['invalidratingarea'] = 'Ärea de valuación (rating) inválida';
$string['invalidrecord'] = 'No se puede encontrar registro de datos en la tabla {$a} de la base de datos.';
$string['invalidrecordunknown'] = 'No se puede encontrar registro de datos en la base de datos.';
$string['invalidrequest'] = 'Petición no válida';
$string['invalidrole'] = 'Rol no válido';
$string['invalidroleid'] = 'ID de rol no válido';
$string['invalidscaleid'] = 'ID de escala incorrecto';
$string['invalidsection'] = 'El módulo de registro del curso contiene una sección invalida';
$string['invalidsesskey'] = 'Su sesión muy probablemente ha caducado. Por favor inicie sesión nuevamente.';
$string['invalidshortname'] = 'Nombre corto de curso no valido';
$string['invalidsourcefield'] = 'El campo de orígen del archivo borrador es inválido';
$string['invalidstatedetected'] = 'Algo ha salido mal: {$a}. Esto normalmente no debería suceder nunca.';
$string['invalidurl'] = 'URL no válida';
$string['invaliduser'] = 'Usuario no válido';
$string['invaliduserdata'] = 'Datos de usuario inválido: {$a}';
$string['invaliduserfield'] = 'Campo de usuario no válido: {$a}';
$string['invaliduserid'] = 'ID de usuario no válido';
$string['invalidusername'] = 'El nombre de usuario dado contiene caracteres inválidos';
$string['invalidusernameblank'] = 'El nombre de usuario no puede estar vacío';
$string['invalidxmlfile'] = '"{$a}" no es un archivo XML válido';
$string['iplookupfailed'] = 'No se encuentra información geo sobre esta dirección de IP {$a}.';
$string['iplookupprivate'] = 'No se puede mostrar la búsqueda de dirección IP privada';
$string['ipmismatch'] = 'Discrepancia de dirección IP del cliente';
$string['listcantmovedown'] = 'No se pudo bajar el elemento, porque es el último de sus iguales.';
$string['listcantmoveleft'] = 'No se ha podido mover a la izquierda el elemento, no tiene padre.';
$string['listcantmoveright'] = 'No se ha podido mover a la derecha el elemento. Póngalo debajo de otro compañero y luego podrá pasarlo a la derecha.';
$string['listcantmoveup'] = 'No se pudo subir el elemento, porque es el primero de sus iguales.';
$string['listnochildren'] = 'No se han encontrado hijos del elemento.';
$string['listnoitem'] = 'Ítem no encontrado.';
$string['listnopeers'] = 'No se han encontrado iguales del elemento.';
$string['listupdatefail'] = 'Operación de BD fallida al editar la jerarquía de listas.';
$string['logfilenotavailable'] = 'Bitácoras no disponibles';
$string['loginasnoenrol'] = 'No puede usar inscribirse o des-inscribirse (darse de baja)  cuando está en una sesión "Ingresar como" a un curso';
$string['loginasonecourse'] = 'No puede entrar a este curso.<br /> Debe terminar la sesión "Ingresar como" antes de entrar a cualquier otro curso.';
$string['maxareabytes'] = 'El archivo es mayor que el espacio restante en esta área.';
$string['maxbytesfile'] = 'El archivo {$a->file} es demasiado grande. El tamaño máximo que Usted puede subir es de {$a->size}.';
$string['maxdraftitemids'] = 'Sus subidas de archivos están limitadas temporalmente después que Usted subió un gran volumen de archivos. Por favor espere y después inténtelo nuevamente.';
$string['messageundeliveredbynotificationsettings'] = 'Este mensaje no pudo enviarse porque los mensajes personales entre usuarios (en las configuraciones de Notificación) han sido deshabilitados por un administrador del sitio';
$string['messagingdisable'] = 'El envío de mensajes esta deshabilitado en este sitio';
$string['mimetexisnotexist'] = 'Su sistema no está configurado para ejecutar mimeTeX. Usted necesita obtener el código fuente en C desde  <a href="https://www.forkosh.com/mimetex.zip">https://www.forkosh.com/mimetex.zip</a> compilarlo y colocar el ejecutable dentro de su directorio moodle/filter/tex/ .';
$string['mimetexnotexecutable'] = 'MimeTeX personalizado no es ejecutable!';
$string['missing_moodle_backup_xml_file'] = 'Al respaldo le falta el archivo XML: {$a}';
$string['missingfield'] = 'Falta el campo "{$a}"';
$string['missingkeyinsql'] = 'ERROR: falta el parámetro "{$a}" en su consulta';
$string['missingparam'] = 'Un parámetro necesario ({$a}) faltaba';
$string['missingparameter'] = 'Parámetro faltante';
$string['missingrequiredfield'] = 'Falta algún campo necesario';
$string['missinguseranditemid'] = 'Falta el userid y el itemid';
$string['missingvarname'] = '¡Un nombre de variable necesario está faltando!';
$string['mixedtypesqlparam'] = 'Error: Tipos mezclados de parámetros de consulta SQL';
$string['mnetdisable'] = 'MNET esta deshabilitado';
$string['mnetlocal'] = 'Los usuarios MNET remotos no pueden iniciar sesión localmente';
$string['moduledisable'] = 'Este módulo ({$a}) ha sido deshabilitado para este curso en particular';
$string['moduledoesnotexist'] = 'Este módulo no existe';
$string['moduleinstancedoesnotexist'] = 'La instancia de este módulo no existe';
$string['modulemissingcode'] = 'El módulo {$a} carece del código necesario para llevar a cabo esta función';
$string['movecatcontentstoroot'] = 'No se permite mover el contenido de la categoría a la raíz. ¡Usted debe mover los contenidos hacia una categoría existente!';
$string['movecatcontentstoselected'] = 'Algunos de los contenidos de categoría no se pueden mover adentro de la categoría seleccionada.';
$string['movecategorynotpossible'] = 'Usted no puede mover la categoría \'{$a}\' dentro de la categoría seleccionada.';
$string['movecategoryownparent'] = 'Usted no puede hacer que la categoría \'{$a}\' sea padre de ella misma.';
$string['movecategoryparentconflict'] = 'Usted no puede hacer que la categoría \'{$a}\' sea una subcategoría de una de sus propias subcategorías.';
$string['mssqlrcsmodemissing'] = 'La BasedeDatos no está usando el modo esperado de  READ_COMMITTED_SNAPSHOT, lo que puede conducir a resultados erróneos, especialmente bajo escenarios de alta concurrencia. Por favor, habilítelo para un comportamiento correcto. Usted puede encontrar más información en la documentación en idioma inglés en  <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP">Installing MSSQL for PHP</a>.';
$string['multiplerecordsfound'] = 'Múltiples registros encontrados, sólo un registro se esperaba.';
$string['multiplerestorenotallow'] = 'Múltiples ejecuciones de restaurar no son permitidas!';
$string['mustbeloggedin'] = 'Usted debe haber iniciado sesión en el sitio para poder hacer esto';
$string['mustbeteacher'] = 'Sólo los profesores pueden ver esta página';
$string['myisamproblem'] = 'Las tablas de la base de datos están utilizando el motor MyISAM: se recomienda usar un motor compatible con ACID que permita transacción completa, tal como InnoDB.';
$string['needcopy'] = 'Debe copiar algo primero!';
$string['needcoursecategroyid'] = 'O bien un ID de curso o de una categoría debe de especificarse';
$string['needphpext'] = 'Usted necesita añadir soporte {$a} a su instalación de PHP';
$string['noadmins'] = '¡No administradores!';
$string['noblocks'] = 'No se encontraron bloques!';
$string['nocapabilitytousethisservice'] = 'El usuario no tiene la capacidad necesaria para usar este servicio';
$string['nocategorydelete'] = '¡La categoría \'{$a}\' no puede eliminarse!';
$string['nocontext'] = 'Lo sentimos, ese curso no es un contexto válido';
$string['nodata'] = 'No hay datos';
$string['noexistingcategory'] = 'No existe la categoría';
$string['nofile'] = 'El archivo no ha sido especificado';
$string['nofiltersenabled'] = 'No hay filtros habilitados';
$string['nofolder'] = 'El directorio solicitado no existe';
$string['noformdesc'] = 'No se encontró el archivo de descripción del formato formslib para esta actividad.';
$string['noguest'] = 'No se permiten invitados aquí!';
$string['noinstances'] = 'En este curso no hay instancias de {$a}.';
$string['nologinas'] = 'Usted no está autorizado a \'iniciar sesión como\' ese usuario';
$string['nonmeaningfulcontent'] = 'El contenido no tiene sentido';
$string['noparticipants'] = 'No se encontraron participantes en este curso';
$string['noparticipatorycms'] = 'Lo sentimos, no dispone de módulos de participación en cursos sobre los que informar';
$string['nopermissions'] = 'Lo sentimos, pero Usted actualmente no tiene permisos para hacer eso ({$a})';
$string['nopermissiontoaccesspage'] = 'Usted no tiene permiso para acceder a esta página.';
$string['nopermissiontocomment'] = 'No puede añadir comentarios';
$string['nopermissiontodelentry'] = '¡No puede eliminar este comentario!';
$string['nopermissiontoeditcomment'] = 'No puede editar comentarios de otras personas!';
$string['nopermissiontohide'] = 'No tiene permiso para ocultar!';
$string['nopermissiontoimportact'] = 'Usted no tiene los permisos necesarios para importar actividades a este curso';
$string['nopermissiontolock'] = 'No tiene permiso para bloquear!';
$string['nopermissiontomanagegroup'] = 'Usted no tiene los permisos necesarios para gestionar grupos';
$string['nopermissiontorate'] = '¡La valuación (rating) de elementos no está permitida!';
$string['nopermissiontoshow'] = 'No tiene permiso para ver esto!';
$string['nopermissiontounlock'] = 'No tiene permiso para desbloquear!';
$string['nopermissiontoupdatecalendar'] = 'Lo sentimos, pero Usted no tiene permisos para actualizar el evento del calendario.';
$string['nopermissiontoviewcalendar'] = 'Lo sentimos, pero no tienes permiso para ver el evento del calendario.';
$string['nopermissiontoviewgrades'] = 'No se pueden ver las calificaciones.';
$string['nopermissiontoviewletergrade'] = 'Le faltan permisos para revisar las calificaciones con letra';
$string['nopermissiontoviewpage'] = 'No está autorizado a ver esta página';
$string['nosite'] = 'No se puede encontrar un curso de nivel superior!';
$string['nositeid'] = 'No existe ID del sitio';
$string['nostartdatenoenddate'] = 'Solamente puede configurarse una fecha de terminación del curso si también se ha configurado una fecha de inicio.';
$string['nostatstodisplay'] = 'Lo sentimos, no hay datos disponibles para mostrar';
$string['notallowedtoupdateprefremotely'] = 'No está autorizado para actualizar esta preferencia de usuario de forma remota';
$string['notavailable'] = 'No disponible en este momento';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Usted no es un miembro de este grupo en este curso';
$string['notownerofkey'] = 'Usted no es el propietario de esta clave';
$string['nousers'] = 'No existe ese usuario!';
$string['oauth1accesstoken'] = 'Error de OAuth 1.0. No obtuvimos la ficha (token) para acceso.';
$string['oauth1requesttoken'] = 'Error de OAuth 1.0. No obtuvimos la ficha (toke)n para acceso - el proveedor de servicios podría estar tirado temporalmente.';
$string['oauth2refreshtokenerror'] = 'No se pudo refrescar token  OAuth 2. Estado HTTP para endpoint remoto: {$a}';
$string['oauth2refreshtokentaskerror'] = 'No se pudo refrescar token  OAuth 2 para uno o más emisores. Vea la salida del trabajo para los detalles.';
$string['oauth2upgradetokenerror'] = 'No se pudo actualizar token  OAuth 2.Estado HTTP para endpoint remoto: {$a}';
$string['onlyadmins'] = 'Sólo los administradores pueden hacer eso';
$string['onlyeditingteachers'] = 'Sólo los profesores con permiso de edición pueden hacer eso';
$string['onlyeditown'] = 'Sólo puede editar su propia información';
$string['orderidnotfound'] = 'ID de la orden {$a} no se encuentra';
$string['pagenotexist'] = '<p>Ha ocurrido un error inusual al intentar ver una página que no existe:</p>{$a}';
$string['pagenotexisttitle'] = 'Error 404: Archivo no encontrado';
$string['pathdoesnotstartslash'] = 'No hay argumentos válidos suministrados, la ruta no comienza con diagonal!';
$string['pleasereport'] = 'Si tiene tiempo, por favor háganos saber qué estaba intentando hacer cuando tuvo lugar el error:';
$string['pluginrequirementsnotmet'] = 'No se ha podido instalar el plugin "{$a->pluginname}" ({$a->pluginversion}). Necesita una nueva versión de Moodle (actualmente usted está usando {$a->currentmoodle}, y necesita {$a->requiremoodle}).';
$string['pluginunsupported'] = 'El plugin "{$a->pluginname}" {$a->pluginversion} no soporta esta versión de Moodle {$a->moodleversion}. Busque información del plugin para encontrar versiones soportadas';
$string['prefixcannotbeempty'] = '<p>Error: El prefijo de la tabla de la base de datos no puede estar vacío ({$a})</p>
<p>El administrador del sitio debe arreglar este problema.</p>';
$string['prefixtoolong'] = '<p>Error: El prefijo de la tabla de la base de datos es demasiado largo ({$a->dbfamily})</p> <p>El administrador del sitio debe arreglar este problema. La longitud máxima para los prefijos de tabla en {$a->dbfamily} es de {$a->maxlength} caracteres. </p>';
$string['privatefilesupload'] = 'Ya no se permite subir archivos directamente al área de archivos privados del usuario. Suba los archivos a un área de borrador y después mueva los archivos con core_user::add_user_private_files';
$string['processingstops'] = 'El procesamiento acaba aquí. Se pasan por alto los demás registros.';
$string['protected_cc_not_supported'] = 'Los cartuchos protegidos no están soportados.';
$string['querystringcannotbeempty'] = 'La cadena de búsqueda no puede estar vacía.';
$string['redirecterrordetected'] = 'Detectada redirección no admitida: ejecución del script terminada';
$string['refoundto'] = 'Puede ser reembolsado a {$a}';
$string['refoundtoorigi'] = 'Reembolsado a la cantidad original: {$a}';
$string['registrationdisabled'] = 'El registro está deshabilitado en este sitio';
$string['remotedownloaderror'] = '<p>Falló la descarga del componente a su servidor. Por favor verifique los ajustes del proxy, la extensión PHP cURL.está altamente recomendada.</p>
<p>Debe descargar el archivo <a href="{$a->url}">{$a->url}</a>  manualmente, copiarlo a "{$a->dest}" en su servidor y descomprimirlo allí.</p>';
$string['remotedownloadnotallowed'] = 'La descarga de componentes a su servidor (allow_url_fopen) está deshabilitada.<br /><br />Usted debe descargar manualmente el archivo <a href="{$a->url}">{$a->url}</a>, copiarlo a "{$a->dest}" en su servidor y descomprimirlo allí.';
$string['reportnotavailable'] = 'Este tipo de reporte sólo está disponible para el curso del sitio';
$string['requirecorrectaccess'] = 'URL o puerto inválido';
$string['requireloginerror'] = 'Curso o actividad no accesible.';
$string['restore_path_element_missingmethod'] = 'No se encuentra el método de restauración {$a}. Debe ser definido por un programador.';
$string['restore_path_element_noobject'] = 'El objeto de restauración {$a} no es un objeto.';
$string['restorechecksumfailed'] = 'Ha ocurrido algún problema con la información de restauración almacenada en su sesión. Por favor, compruebe los límites del tamaño de la memoria PHP/paquete DB. Restauración detenida.';
$string['restrictedcontextexception'] = 'Lo sentimos, la ejecución de una función externa viola la restricción del contexto.';
$string['restricteduser'] = 'Lo sentimos, su cuenta "{$a}" no puede hacer esto';
$string['reverseproxyabused'] = 'El proxy inverso esta habilitado, por lo que el servidor no se puede acceder directamente. <br /> Por favor, póngase en contacto con el administrador del servidor.';
$string['rpcerror'] = '¡Ups! Su comunicación con MNET ha fallado. Éste es el mensaje de error para pasarle a su administrador: {$a}';
$string['scheduledbackupsdisabled'] = 'Los respaldos programadas han sido deshabilitados por el administrador del sitio';
$string['secretalreadyused'] = 'El enlace de confirmación de cambio de contraseña ya ha sido utilizado, la contraseña no se ha cambiado';
$string['sectionnotexist'] = 'Esta sección no existe';
$string['sendmessage'] = 'Enviar mensaje';
$string['sendmessagesent'] = 'Gracias por su retroalimentación acerca de:<br>{$a}';
$string['serverconnection'] = 'Error al conectarse al servidor';
$string['servicedonotexist'] = 'El servicio no existe';
$string['sessioncookiesdisable'] = 'Uso incorrecto de <b>require_key_login()</b> - las \'cookies\' de sesión deben estar deshabilitadas.';
$string['sessiondiskfull'] = 'La partición de sesiones está llena. No es posible iniciar sesión en este momento. Por favor notifique al administrador del servidor.';
$string['sessionerroruser'] = 'Su sesión ha excedido el tiempo límite. Por favor, inicie sesión de nuevo.';
$string['sessionerroruser2'] = 'Se ha detectado un error del servidor que afecta a su sesión de ingreso. Por favor, inicie sesión de nuevo o reinicie su navegador.';
$string['sessionexpired'] = 'La sesión expiró';
$string['sessionhandlerproblem'] = 'El manejador de la sesión está mal configurado';
$string['sessionipnomatch'] = 'Lo sentimos, pero su número IP parece haber cambiado desde su primer inicio de sesión. Esta norma de seguridad previene que los crackers roben su identidad mientras usted está dentro de este sitio. Los usuarios normales no deberían ver este mensaje, así que por favor pida ayuda al administrador del sitio.';
$string['sessionipnomatch2'] = 'Lo sentimos, pero su dirección IP, parece haber cambiado desde la primera vez que inició su sesión. Esta característica de seguridad impide a los \'crackers\' el robar su identidad mientras está conectado a este sitio. Usted puede ver este error si utiliza redes inalámbricas o si está en itinerancia (roaming) entre redes diferentes. Por favor, pregunte al administrador del sitio para obtener más ayuda. </p>
<p> Si desea continuar por favor presione la tecla F5 para refrescar esta página.';
$string['sessionwaiterr'] = 'Tiempo de espera para el bloqueo de sesión.<br />Espere a que finalice su solicitud actual y vuelva a intentarlo más tarde.';
$string['shortnametaken'] = 'El nombre corto ya está siendo utilizado por otro curso ({$a})';
$string['sitepolicynotagreed'] = 'No ha aceptado la política del sitio: <a href="{$a}">Haga clic aquí para abrir la política del sitio.</a>';
$string['socksnotsupported'] = 'El proxy SOCKS5 no se admite en PHP4';
$string['spellcheckernotconf'] = 'El corrector ortográfico no está configurado';
$string['sslonlyaccess'] = 'Por razones de seguridad sólo se permiten las conexiones https, lo siento.';
$string['statscatchupmode'] = 'La estadística está en este momento en modo \'catchup\'. Hasta el momento se ha(n) procesado {$a->daysdone} día(s) y {$a->dayspending} están pendientes de procesamiento. Por favor, vuelva a comprobarlo más tarde.';
$string['statsdisable'] = 'Las estadísticas no están habilitadas';
$string['statsnodata'] = 'No hay datos disponibles para esa combinación de curso y período de tiempo';
$string['storedfilecannotcreatefile'] = 'No se puede crear archivo de almacén (pool) de archivos locales. Por favor verifique los permisos en dataroot y el espacio de disco disponible.';
$string['storedfilecannotcreatefiledirs'] = 'No se puede crear directorios \'pool\' de archivos locales. Por favor verifique los permisos en dataroot.';
$string['storedfilecannotread'] = 'No se puede leer el archivo, ya sea porque el archivo no existe o porque hay un problema de permisos';
$string['storedfilecannotreadfile'] = 'No se puede leer el archivo \'{$a}\'. Ya sea porque el archivo no existe o porque hay un problema de permiso.';
$string['storedfilenotcreated'] = 'No se puede crear el archivo  {$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}';
$string['storedfileproblem'] = 'Excepción desconocida relacionada con los archivos locales ({$a})';
$string['tagdisabled'] = 'Las marcas están deshabilitadas';
$string['tagnotfound'] = 'No se ha encontrado la marca especificada en la base de datos';
$string['targetdatabasenotempty'] = 'La base de datos destino no está vacía. La transferencia ha sido cancelada por razones de seguridad.';
$string['textconditionsnotallowed'] = 'No se permiten comparaciones de las condiciones de columna de texto. Por favor, use sql_compare_text () en la consulta.';
$string['themenotinstall'] = '¡Este tema no está instalado!';
$string['tokengenerationfailed'] = 'No se puede generar una nueva ficha (token).';
$string['transactionvoid'] = 'La transacción no puede ser anulada porque ya ha sido anulada';
$string['unenrolerror'] = 'Se produjo un error al intentar des-inscribir (dar de baja)  a esta persona';
$string['unicodeupgradeerror'] = 'Lo sentimos, su base de datos aún no está en Unicode, y esta versión de Moodle no puede migrar su base de datos a Unicode. Por favor, actualícese a Moodle 1.7.x y lleve a cabo la migración Unicode desde la página de Administración. Una vez que lo haya hecho, podrá migrar a Moodle {$a}';
$string['unknowaction'] = 'Acción desconocida';
$string['unknowcategory'] = 'Categoría desconocida!';
$string['unknowcontext'] = 'Este es un contexto desconocido ({$a}) en get_child_contexts!';
$string['unknowformat'] = 'Formato desconocido ({$a})';
$string['unknownbackupexporterror'] = 'Error desconocido al preparar la información para importar';
$string['unknownblockregion'] = 'La región bloqueada \'{$a}\' no es reconocida en esta página.';
$string['unknowncontext'] = 'Este es un contexto desconocido.';
$string['unknowncourse'] = 'No existe un curso llamado "{$a}"';
$string['unknowncourseidnumber'] = 'ID del Curso "{$a}" desconocido';
$string['unknowncourserequest'] = 'Solicitud de curso desconocida';
$string['unknowncoursesection'] = 'Sección de curso desconocida en el curso "{$a}"';
$string['unknownevent'] = 'Evento desconocido';
$string['unknownfiletype'] = 'Error: tipo de filtro desconocido';
$string['unknowngroup'] = 'Grupo "{$a}" desconocido';
$string['unknownhelp'] = 'Tópico/Tema de ayuda {$a} desconocido';
$string['unknownjsinrequirejs'] = 'No se puede encontrar la biblioteca de JavaScript {$a}';
$string['unknownmodulename'] = 'Nombre de módulo desconocido para el formato';
$string['unknownrole'] = 'Rol desconocido "{$a}"';
$string['unknownsortcolumn'] = 'Columna de ordenación desconocida {$a}';
$string['unknownuseraction'] = 'Lo sentimos, no podemos entender esta acción del usuario.';
$string['unknownuserselector'] = 'Selector de usuario desconocido';
$string['unknoworder'] = 'Orden desconocido';
$string['unknowparamtype'] = 'Tipo de parámetro {$a} desconocido';
$string['unknowquestiontype'] = 'Tipo de pregunta {$a} no soportado';
$string['unknowuploadaction'] = 'Error: acción de subir ({$a}) desconocida';
$string['unspecifycourseid'] = 'Debe especificar Id de curso, nombre corto o Número de Id';
$string['unsupportedevent'] = 'Tipo de evento no soportado';
$string['unsupportedstate'] = 'Estado de finalización no soportado';
$string['unsupportedwebserver'] = 'Lo sentimos, el software del servidor Web ({$a}) no es compatible.';
$string['upgraderequires19'] = 'Error: Una nueva versión de Moodle se ha instalado en el servidor, por desgracia la actualización desde la versión anterior no está soportada. <br /> Por favor, actualice primero a la versión liberada 1.9.x más reciente. Usted también puede regresar a la versión anterior mediante la reinstalación de los archivos originales';
$string['upgraderunning'] = 'El sitio está siendo actualizado, por favor trate más tarde.';
$string['urlnotdefinerss'] = 'URL no definida para el canal RSS';
$string['useradmineditadmin'] = 'Sólo los administradores pueden modificar las cuentas de otros administradoresw';
$string['useradminodelete'] = 'Las cuentas de los administradores no pueden ser eliminadas';
$string['userautherror'] = 'Conector de autorización desconocido';
$string['userauthunsupported'] = 'Conector de autorización no admitido aquí';
$string['useremailduplicate'] = 'Dirección duplicada';
$string['usermustbemnet'] = 'Los usuarios en la lista de control de acceso MNET deben ser usuarios MNET remotos';
$string['usernamelowercase'] = 'El nombre de usuario debe estar en minúsculas';
$string['usernotaddederror'] = 'No se agregó el usuario - error desconocido';
$string['usernotaddedregistered'] = 'Usuario no añadido - ya estaba registrado';
$string['usernotavailable'] = 'Usted no puede acceder a los detalles de este usuario';
$string['usernotdeletedadmin'] = 'Usuario no eliminado porque no se pueden eliminar las cuentas de los administradores.';
$string['usernotdeleteddeleted'] = 'Este usuario ya ha sido eliminado.';
$string['usernotdeletederror'] = 'Usuario no eliminado: error';
$string['usernotdeletedmissing'] = 'Usuario no eliminado: no se encontró el nombre de usuario .';
$string['usernotdeletedoff'] = 'Usuario no eliminado: eliminación no permitida.';
$string['usernotfullysetup'] = 'Usuario no cnfigurado completamente';
$string['usernotincourse'] = 'Este usuario no está en este curso!';
$string['usernotrenamedadmin'] = 'No se pueden renombrar las cuentas del administrador.';
$string['usernotrenamedexists'] = 'Usuario no renombrado: el nuevo nombre de usuario ya está en uso.';
$string['usernotrenamedmissing'] = 'Usuario no renombrado: no se ha podido encontrar el nombre de usuario anterior.';
$string['usernotrenamedoff'] = 'Usuario no renombrado: operación no permitida.';
$string['usernotupdatedadmin'] = 'No se pueden actualizar las cuentas del administrador.';
$string['usernotupdatederror'] = 'Usuario no actualizado: error';
$string['usernotupdatednotexists'] = 'Usuario no actualizado: no existe.';
$string['userquotalimit'] = 'Usted ha alcanzado su límite de cuota de archivos.';
$string['userselectortoomany'] = 'user_selector tiene más de un usuario seleccionado, a pesar de que la opción de selección múltiple (multiselect) es falso.';
$string['verifyagedigitalconsentnotpossible'] = 'Lo sentimos, en este momento no es posible la verificación dl consentimiento de edad digital.';
$string['wrongcall'] = 'El script está siendo llamado incorrectamente';
$string['wrongcontextid'] = 'El ID de contexto es incorrecto (no lo encuentro)';
$string['wrongdestpath'] = 'Ruta de destino errónea.';
$string['wrongroleid'] = '¡ ID de rol incorrecto !';
$string['wrongsourcebase'] = 'Base de fuente de URL errónea.';
$string['wrongusernamepassword'] = 'Nombre de usuario/contraseña erróneo';
$string['wrongzipfilename'] = 'Nombre de archivo ZIP erróneo.';
$string['wscouldnotcreateecoursenopermission'] = 'WS - No se pudo crear un curso - No tiene permiso';
$string['wwwrootmismatch'] = 'Acceso incorrecto detectado, a este servidor se le puede acceder solamente a través de la dirección "{$a}"; lo siento. <br /> Por favor notifique al administrador del servidor.';
$string['wwwrootslash'] = '$CFG->wwwroot detectado incorrectamente en el archivo config.php, ya que no debe contener diagonales invertidas (). <br /> Por favor notifique al administrador del servidor.';
$string['xmldberror'] = 'Error XMLDB';
$string['youcannotdeletecategory'] = 'No puede eliminar la categoría \'{$a}\', porque no puede eliminar el contenido, ni puede moverlo a otro lugar.';
