<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'sr_lt', version '4.0'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Akcija';
$string['activityoverview'] = 'Približava se rok za popunjavanje upitnika';
$string['additionalinfo'] = 'Dodatne informacije';
$string['additionalinfo_help'] = 'Tekst koji će biti prikazan na vrhu prve stranice upitnika (tj. uputstvo, dodatne informacije itd.)';
$string['addnewquestion'] = 'Dodavanje pitanja tipa: {$a}';
$string['addnewsection'] = 'Dodaj novu sekciju';
$string['addquestion'] = 'Dodaj pitanje...';
$string['addquestions'] = 'Dodaj pitanja';
$string['addquestiontosection'] = 'Dodaj pitanje u sekciju';
$string['addselqtype'] = 'Dodaj izabrani tip pitanja';
$string['alignment'] = 'Poravnanje radio dugmadi';
$string['alignment_help'] = 'Izaberite poravnanje dugmadi: vertikalno (podrazumevano) ili horizontalno.';
$string['alignment_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['all'] = 'Sve';
$string['alreadyfilled'] = 'Već ste popunili ovaj upitnik {$a}. Hvala.';
$string['andaveragevalues'] = 'i prosečne vrednosti';
$string['anonymous'] = 'Anonimno';
$string['answer'] = 'Odgovor';
$string['answergiven'] = 'Ovaj odgovor je dat';
$string['answernotgiven'] = 'Ovaj odgovor nije dat';
$string['answerquestions'] = 'Odgovorite na pitanja...';
$string['answers'] = 'Odgovori';
$string['attempted'] = 'Ovaj upitnik je predat.';
$string['attemptstillinprogress'] = 'U toku. Sačuvano dana:';
$string['autonumbering'] = 'Automatsko numerisanje';
$string['autonumbering_help'] = 'Automatsko numerisanje pitanja i stranica. Možda ćete želeti da isključite automatsko numerisanje za upitnike sa uslovnim grananjem.';
$string['autonumberno'] = 'Ne numerisati pitanja ili stranice';
$string['autonumberpages'] = 'Automatsko numerisanje stranica';
$string['autonumberpagesandquestions'] = 'Automatsko numerisanje stranica i pitanja';
$string['autonumberquestions'] = 'Automatsko numerisanje pitanja';
$string['average'] = 'Prosek';
$string['averageposition'] = 'Prosečna pozicija';
$string['averagerank'] = 'Prosečan rang';
$string['bodytext'] = 'Tekst';
$string['boxesnbexact'] = 'tačno {$a} polje/a.';
$string['boxesnbmax'] = 'najviše {$a} polje/a.';
$string['boxesnbmin'] = 'najmanje {$a} polje/a.';
$string['boxesnbreq'] = 'Za ovo pitanje morate da obeležite';
$string['by'] = 'od';
$string['cannotviewpublicresponses'] = 'Ne možete da vidite odgovore na ovaj javni upitnik.';
$string['chart:bipolar'] = 'Dvostrane linije';
$string['chart:hbar'] = 'Horizontalne linije';
$string['chart:radar'] = 'Radar';
$string['chart:rose'] = 'Rozeta';
$string['chart:type'] = 'Tip grafikona';
$string['chart:type_help'] = 'Izaberite tip grafikona koji želite da koristite za ove povratne informacije';
$string['chart:vprogress'] = 'Vertikalna traka napredovanja';
$string['checkallradiobuttons'] = 'Molimo potvrdite <strong>{$a}</strong> radio dugme/ta';
$string['checkboxes'] = 'Polja za potvrdu';
$string['checkboxes_help'] = 'Unesite u svaki red po jednu opciju kako bi korisnik izabrao jedan ili više odgovora.';
$string['checkboxes_link'] = 'mod/questionnaire/questions#Check_Boxes';
$string['checkbreaksadded'] = 'Novi prelom/i stranice umetnut/i na poziciji/ama:';
$string['checkbreaksok'] = 'Svi zahtevani prelomi stranica su prisutni!';
$string['checkbreaksremoved'] = 'Uklonjeno dodatnih preloma stranica: {$a}';
$string['checknotstarted'] = 'Izbor nije počeo';
$string['checkstarted'] = 'Izbor počeo';
$string['clicktoswitch'] = '(pritisni za promenu)';
$string['closed'] = 'Upitnik je zatvoren dana {$a}. Hvala.';
$string['closedate'] = 'Koristi datum zatvaranja';
$string['closeson'] = 'Upitnik se zatvara {$a}';
$string['completionsubmit'] = 'Polaznik mora da preda ovaj upitnik kako bi ga završio';
$string['condition'] = 'Uslov';
$string['confalts'] = '- ILI - <br />Stranica za potvrdu';
$string['configmaxsections'] = 'Maksimalan broj sekcija sa povratnim informacijama';
$string['configusergraph'] = 'Prikaži grafikone za "Test ličnosti"';
$string['configusergraphlong'] = 'Upotrebite <a href="http://www.rgraph.net/">Rgraph</a> biblioteku za prikaz grafikona "Test ličnosti"';
$string['confirmdelallresp'] = 'Da li ste sigurni da želite da obrišete SVE odgovore u ovom upitniku?';
$string['confirmdelchildren'] = 'Ako izbrišete ovo pitanje, njegovo/a podređena pitanje/a biće takođe obrisana:';
$string['confirmdeletesection'] = 'Da li ste sigurni da želite da obrišete sekciju sa povrtnim informacijama "{$a}"?';
$string['confirmdelgroupresp'] = 'Da li ste sigurni da želite da obrišete SVE odgovore grupe {$a}?';
$string['confirmdelquestion'] = 'Da li ste sigurni da želite da obrišete pitanje na poziciji {$a}?';
$string['confirmdelquestionresps'] = 'Ovo će takođe obrisati {$a} odgovor/a  koji su već dati na to pitanje.';
$string['confirmdelresp'] = 'Da li ste sigurni da želite da obrišete odgovore koje je poslao/la &nbsp;{$a}&nbsp;?';
$string['confirmremovequestion'] = 'Da li ste sigurni da želite ukloniti pitanje "{$a->qname}" iz sekcije "{$a->sname}"?';
$string['confpage'] = 'Tekst naslova';
$string['confpage_help'] = 'Naslov (napisan podebljanim slovima) i tekst stranice za "Potvrdu" se prikazuje nakon što korisnik popuni ovaj upitnik. (URL adresa, ako postoji, ima prednost u odnosu na tekst potvrde.) Ako ostavite ovo polje prazno, po završetku upitnika, biće prikazana standardna poruka (Hvala vam što ste popunili ovaj upitnik).';
$string['confpagedesc'] = 'Naslov (napisan podebljanim slovima) i tekst stranice za &quot;Potvrdu&quot; se prikazuje nakon što korisnik popuni ovaj upitnik. (URL adresa, ako postoji, ima prednost u odnosu na tekst potvrde.)';
$string['contentoptions'] = 'Opcije za sadržaj';
$string['couldnotcreatenewsurvey'] = 'Nije moguće napraviti novi upitnik!';
$string['couldnotdelresp'] = 'Nije moguće obrisati odgovor';
$string['createcontent'] = 'Definiši novi sadržaj';
$string['createcontent_help'] = 'Izaberite jednu od opcija. \'Kreiraj novi\' \'je podrazumevana opcija.';
$string['createcontent_link'] = 'mod/questionnaire/mod#Content_Options';
$string['createnew'] = 'Kreiraj novi';
$string['crontask'] = 'Čišćenje upitnika';
$string['date'] = 'Datum';
$string['date_help'] = 'Koristite ovaj tip pitanje ako očekujete da odgovor bude ispravno formatiran datum.';
$string['date_link'] = 'mod/questionnaire/questions#Date';
$string['dateformatting'] = 'Koristite format dan/mesec/godina, npr. za mart 14., 1945:&nbsp; <strong>14/3/1945</strong>';
$string['deleteallresponses'] = 'Obriši SVE odgovore';
$string['deletecurrentquestion'] = 'Obriši pitanje {$a}';
$string['deletedallgroupresp'] = 'Obrisani SVI odgovori u grupi {$a}';
$string['deletedallresp'] = 'Obrisani SVI odgovori';
$string['deletedisabled'] = 'Ova stavka ne može biti obrisana';
$string['deletedresp'] = 'Obrisani odgovor';
$string['deleteresp'] = 'Obriši ovaj odgovor';
$string['deletesection'] = 'Obriši ovu sekciju';
$string['deletingresp'] = 'Brisanje odgovora';
$string['dependencies'] = 'Zavisnosti';
$string['dependquestion'] = 'Nadređeno pitanje';
$string['dependquestion_help'] = 'Možete da izaberete nadređeno pitanje i odgovor za ovo pitanje. Podređeno pitanje biće prikazano polazniku samo ako su prethodno izabrani nadređeno pitanje i nadređeni odgovor.';
$string['dependquestion_link'] = 'mod/questionnaire/questions#Parent_Question';
$string['didnotrespondtoquestion'] = 'Bez odgovora na pitanje';
$string['directwarnings'] = 'Direktne zavisnosti od ovog pitanja će biti uklonjene. Ovo će uticati na:';
$string['displaymethod'] = 'Metod prikaza nije definisan za pitanje.';
$string['download'] = 'Preuzmi';
$string['downloadtextformat'] = 'Preuzmi kao CSV datoteku';
$string['downloadtextformat_help'] = 'Ova funkcija vam omogućava da sačuvate sve odgovore na upitnik kao tekstualnu datoteku (CSV).
Ova datoteka zatim može biti uvezena u program za tabelarno prikazivanje podataka (npr. MS Excel ili Open Office Calc) ili statistički paket, za dalju obradu podataka.';
$string['downloadtextformat_link'] = 'mod/questionnaire/report#Download_in_text_format';
$string['dropdown'] = 'Padajući meni';
$string['dropdown_help'] = 'Ne postoji stvarna prednost u korišćenju padajućeg menija u odnosu na radio dugmad, osim što padajući meni štedi prostor na ekranu.';
$string['dropdown_link'] = 'mod/questionnaire/questions#Dropdown_Box';
$string['edit'] = 'Uredi';
$string['editingfeedback'] = 'Uređivanje podešavanja za povratne informacije';
$string['editingquestionnaire'] = 'Uređivanje podešavanja upitnika';
$string['editquestion'] = 'Uređivanje {$a} pitanja';
$string['email'] = 'E-pošta';
$string['errnewname'] = 'Nažalost, naziv je već u upotrebi. Izaberite novi naziv.';
$string['erroropening'] = 'Greška prilikom otvaranja upitnika';
$string['errortable'] = 'Greška. Sistemska tabela je oštećena.';
$string['essaybox'] = 'Polje za esej';
$string['essaybox_help'] = 'Ovaj tip pitanja prikazuje obično polje za unos teksta sa **x**  stubaca (širina polja za unos) i **y** redova (broj linija teksta).
 
Ukoliko ostavite oba podešavanja na podrazumevanih **0** (ili ih sami podesite na tu vrednost), onda će biti prikazan HTML editor standardne visine i širine (ako je dostupan u kontekstu kursa/korisnika i u korisničkom profilu).';
$string['event_all_responses_deleted'] = 'Svi odgovori obrisani';
$string['event_all_responses_saved_as_text'] = 'Svi odgovori sačuvani kao tekst';
$string['event_all_responses_viewed'] = 'Izveštaj sa svim odgovorima prikazan';
$string['event_individual_responses_viewed'] = 'Izveštaj sa pojedinačnim odgovorima prikazan';
$string['event_non_respondents_viewed'] = 'Prikazani ispitanici koji nisu odgovorili';
$string['event_previewed'] = 'Upitnik prikazan';
$string['event_question_created'] = 'Pitanje kreirano';
$string['event_question_deleted'] = 'Pitanje obrisano';
$string['event_response_deleted'] = 'Pojedinačni odgovor obrisan';
$string['event_resumed'] = 'Pokušaj nastavljen';
$string['event_saved'] = 'Odgovori sačuvani';
$string['event_submitted'] = 'Odgovori predati';
$string['feedback'] = 'Povratne informacije';
$string['feedback_help'] = 'Povratne informacije - Pomoć';
$string['feedback_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Messages';
$string['feedbackaddmorefeedbacks'] = 'Dodaj {no} polja za povratne informacije';
$string['feedbackbysection'] = 'Sekcije sa povratnim informacijama';
$string['feedbackdefaultlabel'] = '[Nova sekcija]';
$string['feedbackeditingglobal'] = 'Uređivanje opštih povratnih informacija upitnika';
$string['feedbackeditingmessages'] = 'Uređivanje poruka sa povratnim informacijama upitnika';
$string['feedbackeditingsections'] = 'Uređivanje sekcija sa povratnim informacijama upitnika';
$string['feedbackeditmessages'] = 'Sačuvajte podešavanja sekcija i uredite poruke sa povratnim informacijama';
$string['feedbackeditsections'] = 'Sačuvajte podešavanja i uredite sekcije povratnih informacija';
$string['feedbackerrorboundaryformat'] = 'Granice rezultata povratnih informacija moraju biti ili procenat ili broj. Vrednost koju ste uneli za granicu {$a} nije prepoznata.';
$string['feedbackerrorboundaryoutofrange'] = 'Granice rezultata povratnih informacija moraju biti između 0% i 100%. Vrednost koju ste uneli za granicu {$a} je van opsega.';
$string['feedbackerrorjunkinboundary'] = 'Morate da popunite polja za granice rezultata povratnih informacija bez ikakvih praznina.';
$string['feedbackerrorjunkinfeedback'] = 'Morate da popunite polja povratnih informacija bez ikakvih praznina.';
$string['feedbackerrororder'] = 'Granice rezultata povratnih informacija moraju biti poređane, od najvećeg. Vrednost koju ste uneli za granicu {$a} je van niza.';
$string['feedbackglobal'] = 'Opšte povratne informacije';
$string['feedbackglobalheading'] = 'Naslov opštih povratnih informacija';
$string['feedbackglobalmessages'] = 'Poruke sa opštim povratnim informacijama';
$string['feedbackhdr'] = 'Povratne informacije';
$string['feedbackheading'] = 'Naslov povratnih informacija';
$string['feedbackheading_help'] = 'U polju naslova povratnih informacija možete da koristite dve promenljive: $scorepercent i $oppositescorepercent.';
$string['feedbackmessages'] = 'Poruke sa povratnim informacijama za sekciju {$a}';
$string['feedbacknextsection'] = 'Sledeća sekcija {$a}';
$string['feedbacknone'] = 'Nema poruka povratnih informacija';
$string['feedbacknotes'] = 'Beleške povratnih informacija';
$string['feedbacknotes_help'] = 'Tekst koji je ovde unet biće prikazan ispitanicima na kraju njihovog izveštaja sa povratnim informacijama.';
$string['feedbackoptions'] = 'Opcije povratnih informacija';
$string['feedbackoptions_help'] = 'Opcije za povratne informacije su dostupne ako vaš upitnik sadrži sledeće tipove pitanje i podešavanja pitanja:
Radio dugmad, Padajuće meni, Da/Ne ili Skala procene (normalna ili Ozgudova skala). Ta pitanja moraju biti podešena kao obavezna, njihovo polje \'Naziv pitanja\' NE sme biti prazno, a polja \'Mogući odgovori\' moraju da sadrže odgovarajuću vrednost.';
$string['feedbackoptions_link'] = 'mod/questionnaire/personality_test';
$string['feedbackremovequestionfromsection'] = 'Ovo pitanje je deo sekcije sa povratnim informacijama [{$a}]';
$string['feedbackremovesection'] = 'Uklanjanje ovog pitanja potpuno će ukloniti sekciju povratnih informacija [{$a}]';
$string['feedbackreport'] = 'Izveštaj sa povratnim informacijama';
$string['feedbackscore'] = 'Rezultat povratnih informacija';
$string['feedbackscoreboundary'] = 'Granica rezultata povratni informacija';
$string['feedbackscores'] = 'Prikaz rezultata';
$string['feedbackscores_help'] = 'Prikaz tabele rezultata povratnih informacija';
$string['feedbacksection'] = 'Sekcija';
$string['feedbacksectionheading'] = 'Naslov sekcije sa povratnim informacijama {$a}';
$string['feedbacksectionheadingmissing'] = 'Morate da unesete naslov sekcije sa povratnim informacijama!';
$string['feedbacksectionheadingtext'] = 'Naslov';
$string['feedbacksectionlabel'] = 'Natpis';
$string['feedbacksectionlabel_help'] = 'Ovaj natpis će biti korišćen u grafikonima/dijagramima. Treba da bude što kraći!';
$string['feedbacksectionquestions'] = 'Pitanja sekcije sa povratnim informacijama {$a}';
$string['feedbacksections'] = 'Sekcije povratnih informacija: {$a}';
$string['feedbacksectionsselect'] = 'Sekcije';
$string['feedbacksectionsselect_help'] = 'Postavite vaša pitanja unutar ovih sekcija';
$string['feedbacksectionsselect_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Sections_2';
$string['feedbacksettingssaved'] = 'Podešavanja povratnih informacija su sačuvana';
$string['feedbacktype'] = 'Tip povratne informacije';
$string['field'] = 'Pitanje {$a}';
$string['fieldlength'] = 'Dužina polja za unos';
$string['fieldlength_help'] = 'Za pitanje tipa **Polje za unos teksta**, unesite vrednosti za **Dužina polja za unos** i **Maksimalna dužina teksta** za tekst koji treba da unese ispitanik.
 
Podrazumevane vrednosti su 20 znakova za dužinu polja za unos i 25 znakova za maksimalnu dužinu unetog teksta.';
$string['finished'] = 'Odgovorili ste na sva pitanja u ovom upitniku!';
$string['firstrespondent'] = 'Prvi ispitanik';
$string['formateditor'] = 'HTML editor teksta';
$string['formatplain'] = 'Običan tekst';
$string['grade'] = 'Ocena za popunjeni upitnik';
$string['gradesdeleted'] = 'Ocene upitnika obrisane';
$string['headingtext'] = 'Tekst naslova';
$string['horizontal'] = 'Horizontalno';
$string['id'] = 'ID';
$string['includechoicecodes'] = 'Uključi kôdove odgovora';
$string['includechoicetext'] = 'Uključi tekst odgovora';
$string['includeincomplete'] = 'Uključite nepotpune odgovore';
$string['incorrectcourseid'] = 'ID oznaka kursa je neispravna';
$string['incorrectmodule'] = 'ID oznaka modula kursa je neispravna';
$string['incorrectquestionnaire'] = 'Upitnik je neispravan';
$string['indirectwarnings'] = 'Ovaj spisak prikazuje indirektna zavisna pitanja i preostale zavisnosti za direktna zavisna pitanja:';
$string['invalidresponse'] = 'Naveden je neispravan odgovor';
$string['invalidresponserecord'] = 'Naveden je neispravan zapis odgovora';
$string['invalidsectionid'] = 'Navedena je neispravna sekcija sa povratnim informacijama.';
$string['invalidsurveyid'] = 'Neispravna ID oznaka upitnika';
$string['kindofratescale'] = 'Tip skale procene';
$string['kindofratescale_help'] = 'Pogledajte Moodle dokumentaciju ispod';
$string['kindofratescale_link'] = 'mod/questionnaire/questions#Type_of_rate_scale';
$string['lastrespondent'] = 'Poslednji ispitanik';
$string['length'] = 'Dužina';
$string['managequestions'] = 'Upravljanje pitanjima';
$string['managequestions_help'] = 'U sekciji \'Upravljanje pitanjima\' na stranici \'Uređivanje pitanja\', možete sprovesti niz operacija sa pitanjima upitnika.';
$string['managequestions_link'] = 'mod/questionnaire/questions#Manage_questions';
$string['mandatory'] = 'Obavezno - sve ove zavisnosti moraju biti ispunjene.';
$string['maxdigitsallowed'] = 'Maksimalan broj dozvoljenih cifara';
$string['maxdigitsallowed_help'] = 'Koristite podešavanje \'Maksimalno dozvoljenih cifara\' kako biste ograničili broj znakova koji se može uneti u odgovoru na \'Brojčano pitanje\'. Imajte u vidu da se decimalna tačka takođe računa kao jedan znak.';
$string['maxdigitsallowed_link'] = 'mod/questionnaire/questions#Numeric';
$string['maxforcedresponses'] = 'Maksimalan broj obaveznih odgovora';
$string['maxforcedresponses_help'] = 'Koristite ove parametre kako biste primorali ispitanike da označe najmanje **Min.** odnosno najviše **Max.** polja za potvrdu . Da biste ih primorali da označe tačan broj polja za potvrdu, podesite **Min.** i **Max.** na istu vrednost. Ako je poželjna samo najmanja ili najveća vrednost, onda ostavite onu drugu vrednost na podrazumevanih **0**. Ako podesite **Min.** ili **Max.** na vrednosti različite od podrazumevanih **0**,  onda će ispitanicima, ukoliko ne ispune vaš zahtev, biti prikazana poruka sa upozorenjem. Očigledno, neophodno je da svaki zahtev jasno stavite do znanja ispitanicima bilo u opštim uputstvima na početku vašeg upitnika, bilo u tekstu odgovarajućeg pitanja.';
$string['maxtextlength'] = 'Maksimalna dužina teksta';
$string['maxtextlength_help'] = 'Za pitanje tipa "Polje za unos teksta", unesite vrednosti za \'Dužina polja za unos\' i \'Maksimalna dužina teksta\' za tekst koji treba da unese ispitanik. Podrazumevane vrednosti su 20 znakova za dužinu polja za unos i 25 znakova za maksimalnu dužinu unetog teksta.';
$string['messageprovider:message'] = 'Podsetnik za upitnik';
$string['messageprovider:notification'] = 'Predaja upitnika';
$string['minforcedresponses'] = 'Minimalan broj obaveznih odgovora';
$string['minforcedresponses_help'] = 'Koristite ove parametre kako biste primorali ispitanika da označi najmanje **Min.** odnosno najviše **Max.** polja za potvrdu . Da biste ih primorali da označe tačan broj polja za potvrdu, podesite **Min.** i **Max.** na istu vrednost. Ako je poželjna samo najmanja ili najveća vrednost, onda ostavite onu drugu vrednost na podrazumevanih **0**. Ako podesite **Min.** ili **Max.** na vrednosti različite od podrazumevanih **0**, onda će ispitaniku, ukoliko ne ispuni vaš zahtev, biti prikazana poruka sa upozorenjem. Očigledno, neophodno je da svaki zahtev jasno stavite do znanja ispitanicima bilo u opštim uputstvima na početku vašeg upitnika, bilo u tekstu odgovarajućeg pitanja.';
$string['misconfigured'] = 'Kurs je pogrešno konfigurisan';
$string['missingname'] = 'Pitanje {$a} ne može biti upotrebljeno u ovoj sekciji zato što nema naziv.';
$string['missingnameandrequired'] = 'Pitanje {$a} ne može biti upotrebljeno u ovoj sekciji zato što nema naziv i nije potrebno.';
$string['missingquestion'] = 'Greška, molimo vas da odgovorite na obavezno pitanje';
$string['missingquestions'] = 'Greška, molimo vas da odgovorite na obavezno pitanje:';
$string['missingrequired'] = 'Pitanje {$a} se ne može koristiti u ovoj sekciji sa povratnim informacijama zato što nije obavezno.';
$string['modulename'] = 'Upitnik (Questionnaire)';
$string['modulename_help'] = 'Modul Upitnik (Questionnaire) vam omogućava da napravite upitnik korišćenjem različitih tipova pitanje, radi prikupljanja podataka od strane korisnika.';
$string['modulename_link'] = 'mod/questionnaire/view';
$string['modulenameplural'] = 'Upitnici (Questionnaires)';
$string['movedisabled'] = 'Ova stavka ne može da se pomera';
$string['myresponses'] = 'Svi vaši odgovori';
$string['myresponsetitle'] = 'Vaši odgovori: {$a}';
$string['myresults'] = 'Vaši rezultati';
$string['name'] = 'Naziv';
$string['navigate'] = 'Dozvoli pitanja sa grananjem';
$string['navigate_help'] = 'Omogućite da pitanja tipa "Da/Ne" i "Radio dugmad" imaju podređena pitanja u zavisnosti od izabranog odgovora u vašem upitniku.';
$string['navigate_link'] = 'mod/questionnaire/conditional_branching';
$string['navigatetosection'] = 'Idi na sekciju sa povratnim informacijama';
$string['next'] = 'Sledeće';
$string['nextpage'] = 'Sledeća stranica';
$string['nlines'] = 'Broj redova: {$a}';
$string['noanswer'] = 'Nema odgovora';
$string['noattempts'] = 'Nije bilo pokušaja popunjavanja ova upitnika.';
$string['nodata'] = 'Podaci nisu poslati';
$string['noduplicates'] = 'Nema duplih odgovora';
$string['noduplicateschoiceserror'] = 'Morate uneti najmanje dva moguća odgovora za opciju "Nema duplih odgovora"!';
$string['non_respondents'] = 'Korisnici koji još uvek nisu predali svoje odgovore na ovaj upitnik';
$string['noneinuse'] = 'Ovaj upitnik ne sadrži nijedno pitanje.';
$string['nopublicsurveys'] = 'Nema javnih upitnika';
$string['noresponsedata'] = 'Nema odgovora na ovo pitanje.';
$string['noresponses'] = 'Nema odgovora';
$string['normal'] = 'Normalno';
$string['not_started'] = 'nije započeto';
$string['notanumber'] = '<strong>{$a}</strong> nije prihvatljiv format broja.';
$string['notapplicable'] = 'N/A';
$string['notapplicablecolumn'] = 'N/A kolona';
$string['notavail'] = 'Ovaj upitnik nije dostupan. Pitajte svog predavača da ga obriše.';
$string['noteligible'] = 'Nemate pravo da odgovarate na ovaj upitnik.';
$string['notemplatesurveys'] = 'Nema šablona upitnika.';
$string['notenoughscaleitems'] = 'Morate uneti najmanje 2 stavke skale!';
$string['notificationfull'] = 'Kompletno popunjen upitnik';
$string['notifications'] = 'Pošalji obaveštenja o predatim upitnicima';
$string['notifications_help'] = 'Obavestite korisnike sa ulogama koje imaju sposobnost "mod/questionnaire:submissionnotification" kada je upitnik predat.';
$string['notifications_link'] = 'mod/questionnaire/mod#Submission_Notifications';
$string['notificationsimple'] = 'Samo obaveštenje';
$string['notopen'] = 'Ovaj upitnik neće biti dostupan do {$a}.';
$string['notrequired'] = 'Odgovor nije obavezan';
$string['notset'] = 'nije podešeno';
$string['nousersselected'] = 'Korisnik nije izabran';
$string['num'] = '#';
$string['numattemptsmade'] = '{$a} pokušaj/a popunjavanja ovog upitnika';
$string['numberfloat'] = 'Broj koji ste uneli <strong>{$a->number}</strong> je zaokružen na<strong>{$a->precision}</strong> decimalno/a mesto/a.';
$string['numberofdecimaldigits'] = 'Broj decimalnih cifara';
$string['numberofdecimaldigits_help'] = 'Koristite **Broj decimalnih cifara** kako biste odredili format Prosečne vrednosti koji se izračunava i prikazuje na stranici "Izveštaj o upitniku"';
$string['numberofdecimaldigits_link'] = 'mod/questionnaire/questions#Numeric';
$string['numberscaleitems'] = 'Broj stavki skale';
$string['numberscaleitems_help'] = 'Broj stavki skale je *broj stavki* koji će se koristiti u vašoj skali procene. Normalno, možete da koristite vrednost od 3 do 5. Podrazumevana vrednost: **5**.';
$string['numeric'] = 'Numerička vrednost';
$string['numeric_help'] = 'Koristite ovaj tip pitanje ako očekujete da odgovor bude ispravno formatiran broj.';
$string['of'] = 'od';
$string['opendate'] = 'Koristi datum otvaranja';
$string['option'] = 'opcija {$a}';
$string['optional'] = 'Opciono - mora se ispuniti barem jedna od ovih zavisnosti.';
$string['optionalname'] = 'Naziv pitanja';
$string['optionalname_help'] = 'Naziv pitanja se koristi samo kada izvozite odgovore u CSV/Excel format.
Ako ne planirate da izvozite odgovore u CSV, onda uopšte ne morate da brinete o nazivu pitanja. Ako planirate redovan izvoz podataka iz upitnika u CSV, onda su vam na raspolaganju dve opcije za davanje naziva pitanja.';
$string['optionalname_link'] = 'mod/questionnaire/questions#Question_Name';
$string['or'] = '- ILI -';
$string['order_ascending'] = 'Rastući redosled';
$string['order_default'] = 'Pogledaj podrazumevani redosled';
$string['order_descending'] = 'Opadajući redosled';
$string['orderresponses'] = 'Redosled odgovora';
$string['orderresponses_help'] = 'Prilikom prikazivanja svih odgovora, oni se mogu poređati prema učestalosti kojom se javljaju (kolona
 sa prosecima), za sledeća 4 tipa pitanja,:

* jedan odgovor - radio dugme
* jedan odgovor - padajući meni
* višestruki odgovor - polja za potvrdu
* skala procene (uključujući Likertovu skalu)

Kada dođete na stranicu sa svim odgovorima, oni su standardno poređani onim redosledom kako ih je uneo kreator upitnika. Vi ih možete poređati rastućim ili opadajućim redosledom.';
$string['orderresponses_link'] = 'mod/questionnaire/report#Order_Responses';
$string['osgood'] = 'Ozgudova (Osgood) semantička skala';
$string['other'] = 'Ostalo:';
$string['otherempty'] = 'Ako označite ovu opciju onda morate da unesete tekst odgovora u polje za tekst!';
$string['overviewnumresplog'] = 'odgovori';
$string['overviewnumresplog1'] = 'odgovor';
$string['overviewnumrespvw'] = 'odgovori';
$string['overviewnumrespvw1'] = 'odgovor';
$string['owner'] = 'Vlasnik';
$string['page'] = 'Stranica';
$string['pageof'] = 'Stranica {$a->page} od {$a->totpages}';
$string['parent'] = 'Nadređeno';
$string['participant'] = 'Učesnik';
$string['pleasecomplete'] = 'Molim vas popunite ovaj izbor.';
$string['pluginadministration'] = 'Administracija upitnika';
$string['pluginname'] = 'Upitnik (Questionnaire)';
$string['position'] = 'pozicija';
$string['possibleanswers'] = 'Mogući odgovori';
$string['posteddata'] = 'Dobijena je stranica sa sledećim podacima:';
$string['preview_label'] = 'Pregled';
$string['preview_questionnaire'] = '- Pregled upitnika';
$string['previewing'] = 'Pregled upitnika';
$string['previous'] = 'Prethodno';
$string['previouspage'] = 'Prethodna stranica';
$string['print'] = 'Štampaj ovaj odgovor';
$string['printblank'] = 'Štampaj nepopunjen upitnik';
$string['printblanktooltip'] = 'Otvora prozor prilagođen za štampanja sa nepopunjenim upitnikom';
$string['printtooltip'] = 'Otvora prozor prilagođen za štampanja sa trenutnim odgovorom';
$string['privacy:metadata:questionnaire_resp_multiple'] = 'Odgovor na pitanje tipa "Višestruki odgovor".';
$string['privacy:metadata:questionnaire_resp_multiple:choice_id'] = 'ID oznaka zapisa izbora za ovaj odgovor.';
$string['privacy:metadata:questionnaire_resp_multiple:question_id'] = 'ID oznaka zapisa pitanja za ovaj odgovor.';
$string['privacy:metadata:questionnaire_resp_multiple:response_id'] = 'ID oznaka zapisa odgovora za ovaj odgovor.';
$string['privacy:metadata:questionnaire_resp_single'] = 'Odgovor na pitanje tipa "Jedan odgovor".';
$string['privacy:metadata:questionnaire_resp_single:choice_id'] = 'ID oznaka zapisa izbora za ovaj odgovor.';
$string['privacy:metadata:questionnaire_resp_single:question_id'] = 'ID oznaka zapisa pitanja za ovaj odgovor.';
$string['privacy:metadata:questionnaire_resp_single:response_id'] = 'ID oznaka zapisa odgovora za ovaj odgovor.';
$string['privacy:metadata:questionnaire_response'] = 'Odgovor koji je u toku ili je predat';
$string['privacy:metadata:questionnaire_response:complete'] = 'Status završetka odgovora.';
$string['privacy:metadata:questionnaire_response:grade'] = 'Ocena za ovaj odgovor.';
$string['privacy:metadata:questionnaire_response:questionnaireid'] = 'ID oznaka zapisa upitnika za ovaj odgovor.';
$string['privacy:metadata:questionnaire_response:submitted'] = 'Vremenska oznaka kada je poslednji put sačuvan ovaj odgovor .';
$string['privacy:metadata:questionnaire_response:userid'] = 'ID oznaka korisnika za ovaj odgovor.';
$string['privacy:metadata:questionnaire_response_bool'] = 'Odgovor na pitanje tipa "Da/Ne"';
$string['privacy:metadata:questionnaire_response_bool:choice_id'] = 'Konkretan odgovor na pitanje tipa "Da/Ne"';
$string['privacy:metadata:questionnaire_response_bool:question_id'] = 'ID oznaka zapisa pitanja za ovaj odgovor.';
$string['privacy:metadata:questionnaire_response_bool:response_id'] = 'ID oznaka zapisa odgovora za ovaj odgovor.';
$string['privacy:metadata:questionnaire_response_date'] = 'Odgovor na pitanje tipa "Datum"';
$string['privacy:metadata:questionnaire_response_date:question_id'] = 'ID oznaka zapisa pitanja za ovaj odgovor.';
$string['privacy:metadata:questionnaire_response_date:response'] = 'Konkretan odgovor na pitanje tipa "Datum"';
$string['privacy:metadata:questionnaire_response_date:response_id'] = 'ID oznaka zapisa odgovora za ovaj odgovor.';
$string['privacy:metadata:questionnaire_response_other'] = 'Tekst odgovora kada je izabrana opcija \'drugo\'.';
$string['privacy:metadata:questionnaire_response_other:choice_id'] = 'ID oznaka zapisa izbora za ovaj odgovor.';
$string['privacy:metadata:questionnaire_response_other:question_id'] = 'ID oznaka zapisa pitanja za ovaj odgovor.';
$string['privacy:metadata:questionnaire_response_other:response'] = 'Konkretan tekstualan odgovor kada je izabrana opcija \'drugo\'.';
$string['privacy:metadata:questionnaire_response_other:response_id'] = 'ID oznaka zapisa odgovora za ovaj odgovor.';
$string['privacy:metadata:questionnaire_response_rank'] = 'Odgovor na pitanje tipa "Skala procene"';
$string['privacy:metadata:questionnaire_response_rank:choice_id'] = 'ID oznaka zapisa izbora za ovaj odgovor.';
$string['privacy:metadata:questionnaire_response_rank:question_id'] = 'ID oznaka zapisa pitanja za ovaj odgovor.';
$string['privacy:metadata:questionnaire_response_rank:rankvalue'] = 'Konkretan odgovor na pitanje tipa "Skala procene"';
$string['privacy:metadata:questionnaire_response_rank:response_id'] = 'ID oznaka zapisa odgovora za ovaj odgovor.';
$string['privacy:metadata:questionnaire_response_text'] = 'Odgovor na pitanje tipa "Polje za unos teksta"';
$string['privacy:metadata:questionnaire_response_text:question_id'] = 'ID oznaka zapisa pitanja za ovaj odgovor.';
$string['privacy:metadata:questionnaire_response_text:response'] = 'Konkretan odgovor na pitanje tipa "Polje za unos teksta"';
$string['privacy:metadata:questionnaire_response_text:response_id'] = 'ID oznaka zapisa odgovora za ovaj odgovor.';
$string['private'] = 'Privatni';
$string['public'] = 'Javni';
$string['publiccopy'] = 'Kopija:';
$string['publicoriginal'] = 'Original:';
$string['qtype'] = 'Tip';
$string['qtype_help'] = 'Izaberite da li će korisnicima biti dozvoljeno da odgovaraju samo jedanput, dnevno, nedeljno, mesečno ili neograničeni broj puta.';
$string['qtypedaily'] = 'odgovori dnevno';
$string['qtypemonthly'] = 'odgovori mesečno';
$string['qtypeonce'] = 'odgovori jedanput';
$string['qtypeunlimited'] = 'odgovori više puta';
$string['qtypeweekly'] = 'odgovori nedeljno';
$string['questionnaire:addinstance'] = 'Dodavanje novog upitnika';
$string['questionnaire:copysurveys'] = 'Kopiranje šablona i privatnih upitnika';
$string['questionnaire:createpublic'] = 'Kreiranje javnih upitnika';
$string['questionnaire:createtemplates'] = 'Kreiranje šablona upitnika';
$string['questionnaire:deleteresponses'] = 'Brisanje bilo kog odgovora';
$string['questionnaire:downloadresponses'] = 'Preuzimanje odgovore kao CSV datoteke';
$string['questionnaire:editquestions'] = 'Kreiranje i uređivanje pitanja upitnika';
$string['questionnaire:manage'] = 'Kreiranje i uređivanje upitnika';
$string['questionnaire:message'] = 'Pošalji poruku korisnicima koji nisu popunili upitnik';
$string['questionnaire:preview'] = 'Pregled upitnika';
$string['questionnaire:printblank'] = 'Štampanje nepopunjenog upitnika';
$string['questionnaire:readallresponseanytime'] = 'Čitanje svih odgovora u bilo kom trenutku';
$string['questionnaire:readallresponses'] = 'Čitanje rezimea odgovora';
$string['questionnaire:readownresponses'] = 'Čitanje svojih odgovora';
$string['questionnaire:submissionnotification'] = 'Prijem obaveštenja za svaki predati upitnik';
$string['questionnaire:submit'] = 'Završetak i predaja upitnika';
$string['questionnaire:view'] = 'Pregled upitnik';
$string['questionnaire:viewsingleresponse'] = 'Pregled završenih pojedinačnih odgovora';
$string['questionnaireadministration'] = 'Administracija upitnika';
$string['questionnairecloses'] = 'Upitnik se zatvara';
$string['questionnaireopens'] = 'Upitnik se otvara';
$string['questionnairereport'] = 'Izveštaj o upitniku';
$string['questionnum'] = 'Pitanje #';
$string['questions'] = 'Pitanja';
$string['questionsinsection'] = 'Pitanja u ovoj sekciji:';
$string['questiontypes'] = 'Tipovi pitanja';
$string['questiontypes_help'] = 'Pogledajte Moodle dokumentaciju ispod';
$string['questiontypes_link'] = 'mod/questionnaire/questions#Question_Types';
$string['radiobuttons'] = 'Radio dugmad';
$string['radiobuttons_help'] = 'Kod ovog tipa pitanja ispitanik mora da izabere jedan od ponuđenih odovora.';
$string['radiobuttons_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['rank'] = 'Rang';
$string['ratescale'] = 'Skala procene (skala 1 ..5)';
$string['ratescale_help'] = 'Pogledajte Moodle dokumentaciju ispod';
$string['ratescale_link'] = 'mod/questionnaire/questions#Rate_.28scale_1..5.29';
$string['realm'] = 'Tip upitnika';
$string['realm_help'] = '* **Postoje tri tipa upitnika:**
* Privatni - pripada samo kursu u okviru kojeg je kreiran.
* Šablon - moguće je kopirati ga i uređivati.
* Javni - moguće je deliti ga između kurseva.';
$string['realm_link'] = 'mod/questionnaire/qsettings#Questionnaire_Type';
$string['redirecturl'] = 'URL  adresa na koju se korisnici preusmeravaju nakon što završe ovaj upitnik.';
$string['remove'] = 'Obriši';
$string['removeallquestionnaireattempts'] = 'Obriši sve odgovore u upitniku';
$string['removenotinuse'] = 'Ovaj upitnik zavisi od javnog upitnika koji je obrisan. Takav upitnik ne može više da se koristi i treba ga obrisati.';
$string['required'] = 'Obavezno je odgovoriti';
$string['required_help'] = 'Ako izaberete **Da** odgovor na ovo pitanje biće obavezan tj. ispitanik neće moći da preda upitnik sve dok ne odgovori na ovo pitanje.';
$string['required_link'] = 'mod/questionnaire/questions#Response_Required';
$string['requiredparameter'] = 'Nedostaje neophodan parametar';
$string['reset'] = 'Resetuj';
$string['respeligiblerepl'] = '(zamenjeno izmenom uloga)';
$string['respondent'] = 'Ispitanik';
$string['respondenteligibleall'] = 'svi';
$string['respondenteligiblestudents'] = 'samo polaznici';
$string['respondenteligibleteachers'] = 'samo predavači';
$string['respondents'] = 'Ispitanici';
$string['respondenttype'] = 'Tip ispitanika';
$string['respondenttype_help'] = 'Možete da prikažete puna imena vaših korisnika, zajedno sa njihovim odgovorom, tako što će te ovo podesiti na "puno ime".
Možete, takođe, da sakrijete identitet korisnika, tako što će te ovo podesiti na "anonimno".';
$string['respondenttype_link'] = 'mod/questionnaire/mod#Respondent_Type';
$string['respondenttypeanonymous'] = 'anonimno';
$string['respondenttypefullname'] = 'puno ime';
$string['response'] = 'Odgovor';
$string['responsefieldlines'] = 'Veličina polja za unos';
$string['responseformat'] = 'Format odgovora';
$string['responseoptions'] = 'Opcije odgovora';
$string['responses'] = 'Odgovori';
$string['responseview'] = 'Studenti mogu da vide SVE odgovore';
$string['responseview_help'] = 'Možete da odredite ko može da vide odgovore svih ispitanika (opšte statističke tabele)';
$string['responseview_link'] = 'mod/questionnaire/mod#Response_viewing';
$string['responseviewstudentsalways'] = 'Uvek';
$string['responseviewstudentsnever'] = 'Nikad';
$string['responseviewstudentswhenanswered'] = 'Nakon predaje popunjenog upitnika';
$string['responseviewstudentswhenclosed'] = 'Nakon što je upitnik zatvoren';
$string['restrictedtoteacher'] = 'Ove funkcije su ograničene samo na predavače sa uređivačkim pravima!';
$string['resume'] = 'Sačuvaj/Nastavi odgovore';
$string['resume_help'] = 'Podešavanje ove opcije dozvoljava korisnicima da sačuvaju svoje odgovore na upitnika pre nego što ga predaju.
Korisnici mogu da ostave upitnik nezavršen, i da kasnije nastave sa odgovaranjem na preostali deo upitnika.';
$string['resume_link'] = 'mod/questionnaire/mod#Save/Resume_answers';
$string['resumesurvey'] = 'Nastavi popunjavanje upitnika';
$string['return'] = 'Povratak';
$string['save'] = 'Sačuvaj';
$string['saveasnew'] = 'Sačuvaj kao novo pitanje';
$string['savedbutnotsubmitted'] = 'Ovaj upitnik će biti sačuvan ali ne i predat.';
$string['savedprogress'] = 'Odgovori koje ste do sada dali su sačuvana. Možete se vratiti u bilo kom trenutku da završite ovaj upitnik.';
$string['saveeditedquestion'] = 'Sačuvaj pitanje {$a}';
$string['savesettings'] = 'Sačuvaj podešavanja';
$string['search:activity'] = 'Upitnik (Questionnaire) - informacije o aktivnosti';
$string['search:question'] = 'Upitnik (Questionnaire) - pitanja';
$string['section'] = 'Opis';
$string['sectionbreak'] = '----- Prelom stranice -----';
$string['sectionbreak_help'] = '----- Prelom stranice -----';
$string['sectionsnotset'] = 'Morate odabrato najmenje JEDNO pitenje po sekciji! <br />Sekcija(e) koje nisu izabrane: {$a}';
$string['sectiontext'] = 'Natpis';
$string['sectiontext_help'] = 'Ovo nije pitanje već (kratak) tekst koji će biti prikazan kao uvod u seriju pitanja.';
$string['selecttheme'] = 'Izaberite temu (css) koja će se koristiti sa ovim upitnikom.';
$string['send'] = 'Pošalji';
$string['send_message'] = 'Pošalji poruku izabranim korisnicima';
$string['send_message_to'] = 'Pošalji poruku:';
$string['sendemail'] = 'Pošalji e-poruku';
$string['sendemail_help'] = 'Pošalji kopiju svakog ispunjenog upitnika na navedenu adresu ili adrese. Možete navesti više od jedne adrese, tako što ćete ih razdvojiti zarezima. Ostavite prazno ako ne želite da šaljete kopije e-poštom.';
$string['set'] = 'podesi';
$string['settings'] = 'Podešavanja';
$string['settingssaved'] = 'Podešavanja su sačuvana';
$string['show_nonrespondents'] = 'Ispitanici koji nisu odgovorili.';
$string['started'] = 'započeto';
$string['strfdate'] = '%d/%m/%Y';
$string['strfdateformatcsv'] = 'd/m/Y H:i:s';
$string['strictdateformatting'] = 'Koristite format godina-mesec-dan, npr. za 4. mart 1945:&nbsp; <strong>1945-03-04</strong>';
$string['subject'] = 'Predmet';
$string['submissionnotificationhtmlanon'] = 'Postoji novi <a href="{$a->submissionurl}">odgovor</a> na upitnik "{$a->name}".';
$string['submissionnotificationhtmluser'] = '<a href="{$a->profileurl}">{$a->username}</a> predao/la je <a href="{$a->submissionurl}">odgovore</a> na upitnik  "{$a->name}" na kursu "{$a->coursename}".';
$string['submissionnotificationsubject'] = 'Predaja novopopunjenog upitnika';
$string['submissionnotificationtextanon'] = 'Postoji novi odgovor ({$a->submissionurl}) na upitnik "{$a->name}".';
$string['submissionnotificationtextuser'] = '{$a->username} ({$a->profileurl}) predao/la je odgovore ({$a->submissionurl}) na upitnik "{$a->name}" na kursu "{$a->coursename}".';
$string['submitoptions'] = 'Opcije za predaju';
$string['submitpreview'] = 'Pregled predatog upitnika';
$string['submitpreviewcorrect'] = 'Ovaj predati upitnik biće prihvaćen kao ispravno popunjen.';
$string['submitsurvey'] = 'Predaj upitnik';
$string['submitted'] = 'Predato dana:';
$string['subtitle'] = 'Podnaslov';
$string['subtitle_help'] = 'Podnaslov ovog upitnika. Pojavljuje se ispod naslova samo na prvoj strani.';
$string['summary'] = 'Rezime';
$string['surveynotexists'] = 'upitnik ne postoji.';
$string['surveyowner'] = 'Morate da budete vlasnik upitnika kako biste izveli ovu operaciju.';
$string['surveyresponse'] = 'Odgovor iz upitnika';
$string['template'] = 'Šablon';
$string['templatenotviewable'] = 'Šabloni upitnika nisu vidljivi.';
$string['text'] = 'Tekst pitanja';
$string['textareacolumns'] = 'Kolone polja za unos teksta';
$string['textareacolumns_help'] = 'Ovaj tip pitanja prikazuje obično polje za unos teksta sa **x**  *kolona* (*širina* polja za unos) i **y** *redova* (broj *linija* teksta).
Ukoliko ostavite oba podešavanja na podrazumevanih **0** (ili ih sami podesite na tu vrednost), onda će biti prikazan HTML editor standardne visine i širine (ako je dostupan u kontekstu kursa/korisnika i u korisničkom profilu).';
$string['textarearows'] = 'Redovi polja za unos teksta';
$string['textbox'] = 'Polje za unos teksta';
$string['textbox_help'] = 'Za pitanje tipa "Polje za unos teksta", upišite dužinu polja za unos i maksimalnu dužinu teksta koji ispitanik treba da unese.
Podrazumevane vrednosti su 20 znakova za širinu polja za unos i 25 znakova za maksimalnu dužinu unetog teksta.';
$string['textdownloadoptions'] = 'Opcije za preuzimanje CSV datoteke';
$string['thank_head'] = 'Hvala što ste popunili ovaj upitnik.';
$string['theme'] = 'Tema';
$string['thismonth'] = 'ovog meseca';
$string['thisresponse'] = 'Ovaj odgovor';
$string['thisweek'] = 'ove sedmice';
$string['thousands'] = 'Nemojte koristiti znak za razdvajanje hiljada.';
$string['title'] = 'Naslov';
$string['title_help'] = 'Naslov upitnika koji će se pojaviti na vrhu svake stranice. Standardno, naslov odgovara nazivu upitnika, ali možete da ga promeniti prema sopstvenom nahođenju.';
$string['today'] = 'danas';
$string['total'] = 'Ukupno';
$string['totalofnumbers'] = 'Ukupan broj unetih brojeva';
$string['totalresponses'] = 'Ukupan broj odgovora na pitanje';
$string['type'] = 'Tip pitanja';
$string['undefinedquestiontype'] = 'Nedefinisan tip pitanja!';
$string['unknown'] = 'Nepoznato';
$string['unknownaction'] = 'Navedena je nepoznata akcija upitnika...';
$string['url'] = 'URL adresa za potvrdu';
$string['url_help'] = 'URL adresa na koju će korisnik biti preusmeren nakon što završi upitnik';
$string['useprivate'] = 'Kopiraj postojeći';
$string['usepublic'] = 'Koristi javni';
$string['usetemplate'] = 'Koristi šablon';
$string['vertical'] = 'Vertikalno';
$string['view'] = 'Pregled';
$string['viewallresponses'] = 'Pregled svih odgovora';
$string['viewallresponses_help'] = 'Ako je upitnik podešen na **Grupni režim**:*Vidljive grupe*, ili na *Odvojene grupe*, i ako trenutni korisnik ima mogućnost *moodle/site:accessallgroups* (u tekućem kontekstu), kao i ako su grupe definisane u tekućem kursu, onda će korisnik imati pristup padajućem meniju sa grupama. Ovaj meni omogućava korisnicima da "filtriraju" odgovore na upitnik prema grupama.
Ako je **Grupni režim** podešen na *Odvojene grupe*, onda će korisnici koji imaju mogućnost *moodle/site:accessallgroups* (obično studenti, predavači bez uređivačkih prava itd.) moći da vide samo odgovore grupe(a) kojima pripadaju.';
$string['viewallresponses_link'] = 'Viewing_Questionnaire_responses#Group_filtering';
$string['viewbyresponse'] = 'Pregled po odgovorima';
$string['viewindividualresponse'] = 'Pojedinačni odgovori';
$string['viewindividualresponse_help'] = 'Klikni na imena ispitanika sa donje liste za pregled njihovih pojedinačnih odgovora.';
$string['viewresponses'] = 'Svi odgovori ({$a})';
$string['viewyourresponses'] = 'Vaši odgovori - pregled {$a}';
$string['warning'] = 'Upozorenje, došlo je do greške.';
$string['wronganswers'] = 'Nešto nije u redu sa vašim odgovorima (vidi ispod)';
$string['wrongdateformat'] = 'Uneti datum: <strong>{$a}</strong> ne odgovara formatu koji je prikazan u primeru.';
$string['wrongdaterange'] = 'GREŠKA! Godina mora da bude podešena u rasponu između 1902. i 2037.';
$string['wrongformat'] = 'Nešto nije u redu sa vašim odgovorom na pitanje:&nbsp;';
$string['wrongformats'] = 'Nešto nije u redu sa vašim odgovorima na pitanja:&nbsp;';
$string['yesno'] = 'Da/Ne';
$string['yesno_help'] = 'Jednostavno Da/Ne pitanje';
$string['yourresponse'] = 'Vaš odgovor';
$string['yourresponses'] = 'Vaši odgovori';
