<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'zh_cn', version '4.0'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptdpa'] = '我理解并接受数据处理协议';
$string['activityoverview'] = '您有即将到来的BigBlueButton会话';
$string['bbbduetimeoverstartingtime'] = '到期时间必须晚于开始时间';
$string['bbbdurationwarning'] = '此会话的最长持续时间为%duration%分钟。';
$string['bbbrecordallfromstartwarning'] = '此会话从一开始就被记录下来。';
$string['bbbrecordwarning'] = '这个会话可能会被录下来。';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = '添加一个新的 BigBlueButton 空间';
$string['bigbluebuttonbn:addinstancewithmeeting'] = '创建实时会话实例';
$string['bigbluebuttonbn:addinstancewithrecording'] = '使用录制创建实例';
$string['bigbluebuttonbn:deleterecordings'] = '删除录制';
$string['bigbluebuttonbn:importrecordings'] = '导入录制';
$string['bigbluebuttonbn:join'] = '加入 BigBlueButton 空间';
$string['bigbluebuttonbn:managerecordings'] = '管理bigbluebuttonbn记录';
$string['bigbluebuttonbn:protectrecordings'] = '保护录制';
$string['bigbluebuttonbn:publishrecordings'] = '发布录制';
$string['bigbluebuttonbn:unprotectrecordings'] = '取消对录制的保护';
$string['bigbluebuttonbn:unpublishrecordings'] = '取消发布录制';
$string['bigbluebuttonbn:view'] = '查看 BigBlueButton 空间';
$string['bigbluebuttondisablednotification'] = 'BigBlueButton 活动模块已被禁用，任何现有的 BigBlueButton 课程活动目前都无法访问。 在重新启用此插件之前，请确保您已阅读并接受与 Blindside Networks Inc 签订的<a href="{$a}" target="_blank">数据处理协议</a>';
$string['bigbluebuttondisablednotification_subject'] = 'BigBlueButton 活动模块已禁用。';
$string['cachedef_currentfetch'] = '列出最近获取的任何记录的数据。';
$string['cachedef_recordings'] = '记录元数据';
$string['cachedef_serverinfo'] = '远程服务器信息';
$string['cachedef_validatedurls'] = '已验证URL检查的缓存';
$string['calendarstarts'] = '{$a}计划于';
$string['cannotperformaction'] = '无法对此录制执行操作{$a}';
$string['completionattendance'] = '学生必须参加以下课程：';
$string['completionattendance_desc'] = '学生必须进入房间并在课程中至少停留{$a}分钟';
$string['completionattendance_event_desc'] = '学生已进入房间并在课程中至少停留了{$a}分钟';
$string['completionattendancegroup'] = '要求出席';
$string['completionattendancegroup_help'] = '完成会议需要参加（n）分钟。';
$string['completionengagement_desc'] = '学生必须在会议期间参与活动';
$string['completionengagementchats'] = '聊天室';
$string['completionengagementchats_desc'] = '学生必须参与 {$a} 聊天室才能完成。';
$string['completionengagementchats_event_desc'] = '已提出 {$a} 个聊天';
$string['completionengagementemojis'] = '标签图标';
$string['completionengagementemojis_desc'] = '学生必须将 {$a} 表情符号发送到投票中才能完成。';
$string['completionengagementemojis_event_desc'] = '已提出 {$a} 个表情符号';
$string['completionengagementgroup'] = '要求参与';
$string['completionengagementgroup_help'] = '在会议期间，必须积极参与才能完成。';
$string['completionengagementpollvotes'] = '投票';
$string['completionengagementpollvotes_desc'] = '学生必须参与投票 {$a} 次才能完成。';
$string['completionengagementpollvotes_event_desc'] = '已进行{$a}次投票';
$string['completionengagementraisehand'] = '需要举手';
$string['completionengagementraisehand_desc'] = '学生必须举手 {$a} 次才能完成。';
$string['completionengagementraisehand_event_desc'] = '已举手{$a}次';
$string['completionengagementtalks'] = '讨论';
$string['completionengagementtalks_desc'] = '学生必须讨论 {$a} 次才能完成';
$string['completionengagementtalks_event_desc'] = '已提出 {$a} 个讨论';
$string['completionupdatestate'] = '完成更新状态';
$string['completionvalidatestate'] = '完成验证';
$string['completionvalidatestatetriggered'] = '已经触发完成验证。';
$string['completionview'] = '需要查看';
$string['completionview_desc'] = '学生必须加入房间或播放录音才能完成。';
$string['completionview_event_desc'] = '已查看房间页面。';
$string['config_default_messages'] = '默认消息';
$string['config_default_messages_description'] = '设置活动消息的默认值';
$string['config_disablecam_default'] = '禁用默认启用的网络摄像头';
$string['config_disablecam_default_description'] = '如果摄像头已经启用则会被禁用。';
$string['config_disablecam_editable'] = '可以编辑禁用网络摄像头';
$string['config_disablecam_editable_description'] = '默认情况下禁用网络摄像头，可以在添加或更新实例时进行编辑。';
$string['config_disablemic_default'] = '禁用默认启用的麦克风';
$string['config_disablemic_default_description'] = '如果启用，麦克风将被禁用。';
$string['config_disablemic_editable'] = '禁用麦克风可以编辑';
$string['config_disablemic_editable_description'] = '默认情况下禁用麦克风，可以在添加或更新实例时进行编辑。';
$string['config_disablenote_default'] = '禁用默认启用的共享笔记';
$string['config_disablenote_default_description'] = '如果启用，共享笔记将被禁用。';
$string['config_disablenote_editable'] = '禁用可以编辑的共享笔记';
$string['config_disablenote_editable_description'] = '默认情况下禁用共享笔记，可以在添加或更新实例时进行编辑。';
$string['config_disableprivatechat_default'] = '禁用默认启用的私人聊天';
$string['config_disableprivatechat_default_description'] = '如果启用，私人聊天将被禁用。';
$string['config_disableprivatechat_editable'] = '禁用可编辑的私人聊天';
$string['config_disableprivatechat_editable_description'] = '默认情况下禁用私人聊天，可以在添加或更新实例时进行编辑。';
$string['config_disablepublicchat_default'] = '禁用默认启用的公共聊天';
$string['config_disablepublicchat_default_description'] = '如果启用，将禁用公共聊天。';
$string['config_disablepublicchat_editable'] = '禁用公共聊天可以编辑';
$string['config_disablepublicchat_editable_description'] = '默认情况下禁用公共聊天，可以在添加或更新实例时进行编辑。';
$string['config_dpa_note'] = '注意：为了履行您的数据保护义务，在使用此插件的服务提供商之前，您可能需要确保您已阅读并接受服务提供商的数据处理协议。 对于 Blindside Networks Inc. 提供的默认免费 BigBlueButton 服务，请阅读并接受以下<a href="{$a}" target="_blank">数据处理协议</a>.<br/> 请咨询您自己的隐私专家以获取建议。';
$string['config_experimental_features'] = '实验功能';
$string['config_experimental_features_description'] = '实验功能的配置。';
$string['config_extended_capabilities'] = '扩展功能';
$string['config_extended_capabilities_description'] = 'BigBlueButton服务器提供扩展功能时的配置。';
$string['config_general'] = '常规设置';
$string['config_general_description'] = '始终使用这些设置。';
$string['config_hideuserlist_default'] = '默认启用隐藏用户列表';
$string['config_hideuserlist_default_description'] = '如果启用，会话用户列表将隐藏。';
$string['config_hideuserlist_editable'] = '隐藏用户列表可编辑';
$string['config_hideuserlist_editable_description'] = '默认情况下，可以在添加或更新实例时编辑隐藏用户列表。';
$string['config_importrecordings'] = '导入录制内容';
$string['config_importrecordings_description'] = '这些设置是特定功能。';
$string['config_importrecordings_enabled'] = '启用导入录制内容';
$string['config_importrecordings_enabled_description'] = '启用此功能和录制功能后，可以将不同课程的录制内容导入到活动中';
$string['config_importrecordings_from_deleted_enabled'] = '启用从已删除的活动中导入录制内容';
$string['config_importrecordings_from_deleted_enabled_description'] = '当这个功能和导入录制功能被启用时，就可以从不再是课程的活动中导入录制内容';
$string['config_lockonjoin_default'] = '默认情况下启用锁定加入';
$string['config_lockonjoin_default_description'] = '如果启用，配置锁定的设置将在用户加入时应用到用户。锁定配置必须被启用才能应用。';
$string['config_lockonjoin_editable'] = '锁定加入可以编辑';
$string['config_lockonjoin_editable_description'] = '默认情况下，加入的锁可以在添加或更新实例时进行编辑。';
$string['config_locksettings'] = '锁定设置的配置';
$string['config_locksettings_description'] = '这些设置在用户界面中启用或禁用了锁定设置的选项，并定义了这些选项的默认值。';
$string['config_meetingevents_enabled'] = '注册实时会话';
$string['config_meetingevents_enabled_description'] = '如果启用，将在会话结束后处理实时会话。此功能是活动完成所必需的，并且仅在BigBlueButton服务器能够处理 post_events脚本时才有效。';
$string['config_muteonstart'] = '启动时静音';
$string['config_muteonstart_default'] = '默认启用启动时静音';
$string['config_muteonstart_default_description'] = '如果启用，会话将在启动时静音。';
$string['config_muteonstart_description'] = '这些设置启用或禁用UI中的选项，并定义这些选项的默认值。';
$string['config_muteonstart_editable'] = '启动时静音可编辑';
$string['config_muteonstart_editable_description'] = '默认情况下，可以在添加或更新实例时编辑启动时静音。';
$string['config_participant'] = '参与者';
$string['config_participant_description'] = '这些设置定义参与者的默认角色。';
$string['config_participant_moderator_default'] = '调解人';
$string['config_participant_moderator_default_description'] = '默认情况下，添加新房间时使用此规则。';
$string['config_presentation_default'] = '默认演示文件';
$string['config_presentation_default_description'] = '可以提供一个文件供所有房间使用。';
$string['config_preuploadpresentation'] = '预上传演示文稿';
$string['config_preuploadpresentation_description'] = '这些设置启用或禁用用户界面中的选项，并定义这些选项的默认值。仅当 BigBlueButton可以访问Moodle服务器时，该功能才有效。';
$string['config_preuploadpresentation_editable'] = '预上传演示文稿可编辑';
$string['config_preuploadpresentation_editable_description'] = '添加或更新房间或会议时，可在用户界面中编辑预上传演示功能。';
$string['config_recording'] = '录制';
$string['config_recording_all_from_start_default'] = '从头开始录制';
$string['config_recording_all_from_start_default_description'] = '添加新的 BigBlueButton 房间时，是否应默认启用“从头开始录制”设置？';
$string['config_recording_all_from_start_editable'] = '从头开始录制可编辑';
$string['config_recording_all_from_start_editable_description'] = 'BigBlueButton活动设置中的“从头开始录制”是否可以编辑？';
$string['config_recording_default'] = '默认启用录制';
$string['config_recording_default_description'] = '添加新的 BigBlueButton 房间时，是否应该默认启用“会话可以录制”设置？';
$string['config_recording_description'] = '这些设置是特定功能。';
$string['config_recording_editable'] = '会话可录制可编辑';
$string['config_recording_editable_description'] = '是否应该在BigBlueButton活动设置中编辑“会话可以录制”？';
$string['config_recording_hide_button_default'] = '隐藏录制按钮';
$string['config_recording_hide_button_default_description'] = '如果选中，录制按钮将隐藏';
$string['config_recording_hide_button_editable'] = '隐藏录制按钮可编辑';
$string['config_recording_hide_button_editable_description'] = '在BigBlueButton活动设置中，"隐藏录制按钮"应该是可编辑的吗？';
$string['config_recording_protect_editable'] = '可以编辑受保护的录制状态';
$string['config_recording_protect_editable_description'] = '如果选中，该界面包括一个用于保护/取消保护录制内容的选项。';
$string['config_recording_refresh_period'] = '录制刷新周期（秒）';
$string['config_recording_refresh_period_description'] = '应该多久查询一次BigBlueButton服务器以刷新远程信息以进行录制？';
$string['config_recordingready_enabled'] = '发送录制可用通知';
$string['config_recordingready_enabled_description'] = '如果启用，当录制链接可用时，就会发出通知。此功能需要在BigBlueButton服务器上启用脚本post_publish_recording_ready_callback。';
$string['config_recordings'] = '显示录制内容';
$string['config_recordings_asc_sort'] = '按升序排列录制内容。';
$string['config_recordings_asc_sort_description'] = '默认情况下，录制内容按降序显示。选中后，它们将按升序排序。';
$string['config_recordings_deleted_default'] = '包括默认启用的已删除活动的录制内容';
$string['config_recordings_deleted_default_description'] = '如果启用，记录表将包括后来被删除的任何活动的录制内容。';
$string['config_recordings_deleted_editable'] = '包括被删除的活动功能的录制内容可以被编辑。';
$string['config_recordings_deleted_editable_description'] = '默认情况下，包括已删除活动的录制内容，可以在添加或更新实例时进行编辑。';
$string['config_recordings_description'] = '这些设置是特定功能';
$string['config_recordings_general'] = '显示录制设置';
$string['config_recordings_general_description'] = '这些设置仅在显示录制时使用';
$string['config_recordings_imported_default'] = '默认情况下，只显示导入的链接';
$string['config_recordings_imported_default_description'] = '如果启用，录制表将只包括导入的录制链接。';
$string['config_recordings_imported_editable'] = '仅显示可编辑的导入链接功能';
$string['config_recordings_imported_editable_description'] = '默认情况下仅显示导入的链接，可以在添加或更新实例时进行编辑。';
$string['config_recordings_preview_default'] = '默认情况下启用预览';
$string['config_recordings_preview_default_description'] = '如果启用，该表将包含演示文稿的预览。';
$string['config_recordings_preview_editable'] = '预览功能可以被编辑。';
$string['config_recordings_preview_editable_description'] = '预览功能可以在添加或更新实例时进行编辑。';
$string['config_scheduled'] = '预定的会议';
$string['config_scheduled_description'] = '这些设置定义了预定会议的默认行为。';
$string['config_scheduled_pre_opening'] = '在开放时间之前可以进入';
$string['config_scheduled_pre_opening_description'] = '在预定开放时间之前，房间开放的时间（分钟）。';
$string['config_server_url'] = 'BigBlueButton服务器URL';
$string['config_server_url_description'] = '默认凭据适用于Blindside Networks提供的<a href=""https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/"" target=""_blank"">免费为Moodle提供的BigBlueButton服务（在新窗口打开）</a>限制如下：
<ol>
<li>每节课的最长时长为 60 分钟</li>
<li>每个会话的最大并发用户数为 25</li>
<li>录制内容将在七 (7) 天后过期且不可下载</li>
<li>只有管理员可以看到学生的网络摄像头。</li>
</ol>';
$string['config_shared_secret'] = 'BigBlueButton共享密码';
$string['config_shared_secret_description'] = '你的BigBlueButton服务器的安全密钥。默认的密钥是由Blindside Networks提供的免费BigBlueButton服务。';
$string['config_uidelegation_enabled'] = '启用了UI授权';
$string['config_uidelegation_enabled_description'] = '这些设置启用或禁用对BigBlueButton服务器的UI授权。';
$string['config_userlimit'] = '用户限制';
$string['config_userlimit_default'] = '默认启用用户限制';
$string['config_userlimit_default_description'] = '添加新房间时，会话中默认允许的用户数。 设置为 0 以允许无限数量的用户。';
$string['config_userlimit_description'] = '这些设置可以启用或禁用用户界面中的选项，也可以定义这些选项的默认值。';
$string['config_userlimit_editable'] = '用户限制功能可以编辑';
$string['config_userlimit_editable_description'] = '默认情况下，用户限制值可以在房间或会议被添加或更新时进行编辑。';
$string['config_voicebridge'] = '语音桥';
$string['config_voicebridge_description'] = '这些设置可以启用或禁用用户界面中的选项，也可以定义这些选项的默认值。';
$string['config_voicebridge_editable'] = '会议语音桥可编辑';
$string['config_voicebridge_editable_description'] = '一个会议语音桥号码可以永久地分配给一个房间。指定后，该号码不能用于任何其他房间。';
$string['config_waitformoderator'] = '等待主持人';
$string['config_waitformoderator_cache_ttl'] = '等待主持人缓存 TTL（秒）';
$string['config_waitformoderator_cache_ttl_description'] = '为了支持大量客户端，该插件使用缓存。此参数定义了在下一个请求被发送到BigBlueButton服务器之前，缓存将被保留的时间。';
$string['config_waitformoderator_default'] = '等待支持人默认启用';
$string['config_waitformoderator_default_description'] = '在添加一个新的BigBlueButton房间时，是否应该默认启用“等待主持人”的设置？';
$string['config_waitformoderator_description'] = '这些设置是特定功能';
$string['config_waitformoderator_editable'] = '等待主持人编辑';
$string['config_waitformoderator_editable_description'] = 'BigBlueButton 活动设置中的“等待主持人”是否可以编辑？';
$string['config_waitformoderator_ping_interval'] = '等待主持人ping（秒）';
$string['config_waitformoderator_ping_interval_description'] = '服务器应该多久ping一次以检查主持人是否已进入房间？';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButton使用了config.php中的全局变量，该变量已被废弃。请转换该文件，因为在未来的版本中它将不被支持。';
$string['config_warning_curl_not_installed'] = '此功能需要安装并启用php的CURL扩展。只有满足此条件，才能访问设置。';
$string['config_welcome_default'] = '默认欢迎信息';
$string['config_welcome_default_description'] = '与会者进入房间时会显示欢迎消息。 如果该字段留空，则会显示在 BigBlueButton 服务器上设置的消息。';
$string['config_welcome_editable'] = '默认欢迎消息可由教师编辑';
$string['config_welcome_editable_description'] = '添加或更新实例时，可以编辑欢迎消息';
$string['enablingbigbluebutton'] = '启用BigBlueButton活动';
$string['enablingbigbluebuttondpainfo'] = '为了履行您的数据保护义务，在启用此插件之前，您必须确认您已阅读并接受<a href=""{$a}"" target=""_blank"">Blindside Networks 数据处理协议</a>。请咨询您自己的私人专家以获取建议。';
$string['end_session_confirm'] = '确定要结束会话吗？';
$string['end_session_confirm_title'] = '真的结束会话吗？';
$string['end_session_notification'] = '会话已结束。';
$string['ends_at'] = '结束';
$string['event_activity_created'] = '已创建活动';
$string['event_activity_deleted'] = '活动已删除';
$string['event_activity_updated'] = '活动已更新';
$string['event_live_session'] = '实时会话活动';
$string['event_meeting_created'] = '已创建会议';
$string['event_meeting_ended'] = '会议被迫结束';
$string['event_meeting_joined'] = '加入会议';
$string['event_meeting_left'] = '离开会议';
$string['event_recording_deleted'] = '已删除录制内容';
$string['event_recording_edited'] = '录制内容已编辑';
$string['event_recording_imported'] = '已导入录制内容';
$string['event_recording_protected'] = '录制内容受保护';
$string['event_recording_published'] = '录制内容已发布';
$string['event_recording_unprotected'] = '录制内容未受保护';
$string['event_recording_unpublished'] = '录制内容未发布';
$string['event_recording_viewed'] = '已查看录制内容';
$string['event_unknown'] = '未知事件';
$string['general_error_cannot_create_meeting'] = '无法创建会话';
$string['general_error_cannot_get_recordings'] = '无法获取录制内容';
$string['general_error_no_answer'] = '无响应。请检查 BigBlueButton 服务器的网址，并检查 BigBlueButton服务器是否正在运行。';
$string['general_error_not_allowed_to_create_instances'] = '不允许用户创建任何类型的实例。';
$string['general_error_not_found'] = '未找到实体：{$a}。';
$string['general_error_unable_connect'] = '无法连接。请检查BigBlueButton服务器的网址，并检查BigBlueButton服务器是否正在运行。';
$string['index_confirm_end'] = '是否要结束会话？';
$string['index_disabled'] = '禁用';
$string['index_enabled'] = '启用';
$string['index_ending'] = '会议结束...请稍候';
$string['index_error_bbtn'] = 'BigBlueButton ID {$a} 不正确';
$string['index_error_checksum'] = '发生校验错误。请检查您输入的密码是否正确。';
$string['index_error_forciblyended'] = '无法加入会话，因为它已被手动结束。';
$string['index_error_noinstances'] = '没有BigBlueButton房间的实例。';
$string['index_error_unable_display'] = '无法显示会话。请检查BigBlueButton服务器的网址，并检查BigBlueButton服务器是否正在运行。';
$string['index_heading'] = 'BigBlueButton房间';
$string['index_heading_actions'] = '行动';
$string['index_heading_group'] = '组';
$string['index_heading_moderator'] = '主持人';
$string['index_heading_name'] = '房间';
$string['index_heading_recording'] = '录制';
$string['index_heading_users'] = '用户';
$string['index_heading_viewer'] = '观众';
$string['indicator:cognitivedepth'] = 'BigBlueButton的认知';
$string['indicator:cognitivedepth_help'] = '这个指标是基于学生在BigBlueButton活动中达到的认知深度。';
$string['indicator:socialbreadth'] = 'BigBlueButton社交';
$string['indicator:socialbreadth_help'] = '这个指标是基于学生在BigBlueButton活动中达到的社会广度。';
$string['instance_type_default'] = '有录制内容的房间';
$string['instance_type_recording_only'] = '仅录制内容';
$string['instance_type_room_only'] = '仅房间';
$string['instanceprofilewithoutrecordings'] = '此实例简介文件无法显示录制内容';
$string['messageprovider:instance_updated'] = 'BigBlueButton会话已更新';
$string['messageprovider:recording_ready'] = 'BigBlueButton录制可用';
$string['minute'] = '分钟';
$string['minutes'] = '分钟';
$string['mod_form_block_general'] = '一般的';
$string['mod_form_block_participants'] = '在实时会话期间分配的角色';
$string['mod_form_block_presentation'] = '演示内容';
$string['mod_form_block_presentation_default'] = '演示文稿默认内容';
$string['mod_form_block_record'] = '录制设置';
$string['mod_form_block_recordings'] = '录制视图';
$string['mod_form_block_room'] = '房间设置';
$string['mod_form_block_schedule'] = '会话计时';
$string['mod_form_field_closingtime'] = '关闭';
$string['mod_form_field_conference_name'] = '会话名称';
$string['mod_form_field_disablecam'] = '禁用网络摄像头';
$string['mod_form_field_disablemic'] = '禁用麦克风';
$string['mod_form_field_disablenote'] = '禁用共享笔记';
$string['mod_form_field_disableprivatechat'] = '禁用私人聊天';
$string['mod_form_field_disablepublicchat'] = '禁用公共聊天';
$string['mod_form_field_duration'] = '期间';
$string['mod_form_field_duration_help'] = '设置会议持续时间将确定会议在录制完成之前保持活动的最长时间';
$string['mod_form_field_hideuserlist'] = '隐藏用户列表';
$string['mod_form_field_instanceprofiles'] = '实例类型';
$string['mod_form_field_instanceprofiles_help'] = '如果要录制会话，请选择“有录制的房间”，否则选择“仅限房间”。 录制会话后，如果没有更多会话，请选择“仅录制内容”。';
$string['mod_form_field_intro'] = '描述';
$string['mod_form_field_intro_help'] = '房间的简短描述。';
$string['mod_form_field_lockonjoin'] = '加入时锁定设置';
$string['mod_form_field_muteonstart'] = '启动时静音';
$string['mod_form_field_name'] = '房间名称';
$string['mod_form_field_nosettings'] = '无法编辑任何设置';
$string['mod_form_field_openingtime'] = '打开';
$string['mod_form_field_participant_add'] = '添加受让人';
$string['mod_form_field_participant_bbb_role_moderator'] = '主持人';
$string['mod_form_field_participant_bbb_role_viewer'] = '观众';
$string['mod_form_field_participant_list'] = '受让人';
$string['mod_form_field_participant_list_action_add'] = '添加';
$string['mod_form_field_participant_list_action_remove'] = '移除';
$string['mod_form_field_participant_list_text_as'] = '加入会话作为';
$string['mod_form_field_participant_list_type_all'] = '已注册的所有用户';
$string['mod_form_field_participant_list_type_owner'] = '所有者';
$string['mod_form_field_participant_list_type_role'] = '角色';
$string['mod_form_field_participant_list_type_user'] = '用户';
$string['mod_form_field_record'] = '可以记录会话。';
$string['mod_form_field_recordallfromstart'] = '从头开始记录';
$string['mod_form_field_recordhidebutton'] = '隐藏录制按钮';
$string['mod_form_field_recordings_deleted'] = '包括已删除活动的录音';
$string['mod_form_field_recordings_html'] = '以普通HTML显示表格';
$string['mod_form_field_recordings_imported'] = '仅显示导入的链接';
$string['mod_form_field_recordings_preview'] = '显示录制预览';
$string['mod_form_field_room_name'] = '房间名称';
$string['mod_form_field_userlimit'] = '用户限制';
$string['mod_form_field_userlimit_help'] = '会话中允许的最大用户数。设置为0以允许无限数量的用户。';
$string['mod_form_field_voicebridge'] = '语音桥[####]';
$string['mod_form_field_voicebridge_format_error'] = '格式错误。 您应该输入一个介于 1 和 9999 之间的数字。';
$string['mod_form_field_voicebridge_help'] = '一个介于1和9999之间的数字，参与者在使用拨入时输入该数字以加入语音会话。如果该值为0，则静态语音桥号将被忽略，BigBlueButton将生成一个随机数。数字7将作为键入的四位数字的前缀。';
$string['mod_form_field_voicebridge_notunique_error'] = '不是唯一值。 这个号码正在被另一个房间使用。';
$string['mod_form_field_wait'] = '等待主持人';
$string['mod_form_field_wait_help'] = '参与者是否需要等待主持人才能进入房间？';
$string['mod_form_field_welcome'] = '欢迎信息';
$string['mod_form_field_welcome_default'] = '欢迎使用%%CONFNAME%%。';
$string['mod_form_field_welcome_help'] = '当参与者进入房间时，会显示欢迎信息。如果该字段留空，则会显示“站点管理”中设置的默认消息。';
$string['mod_form_locksettings'] = '锁定设置';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = '"BigBlueButton是一个为在线学习设计的开源网络会议系统，它支持实时共享音频、视频、聊天、幻灯片、屏幕共享、多用户白板、分组室、投票和表情。

使用BigBlueButton，您可以为在线课堂、虚拟办公时间或与远程学生的小组协作等课程创建一个房间。可以录制会话以供以后播放。"';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButton';
$string['new_bigblubuttonbn_activities'] = 'BigBlueButton活动';
$string['nosuchinstance'] = '没有ID为{$a->ID}的实例{$a->entity}';
$string['notification_instance_created_intro'] = '<a href="{$a->link}">{$a->name}</a> BigBlueButton 房间已创建。';
$string['notification_instance_created_small'] = '一个名为{$a->name}的新的BigBlueButton房间已经创建。';
$string['notification_instance_created_subject'] = '一个新的BigBlueButton房间已经创建。';
$string['notification_instance_description'] = '描述';
$string['notification_instance_end_date'] = '结束日期';
$string['notification_instance_name'] = '标题';
$string['notification_instance_start_date'] = '开始日期';
$string['notification_instance_updated_intro'] = 'BigBlueButton 房间<a href="{$a->link}">{$a->name}</a> 已更新。';
$string['notification_instance_updated_small'] = '{$a->name} BigBlueButton 会话已更新';
$string['notification_instance_updated_subject'] = '您的 BigBlueButton 房间已更新';
$string['notification_recording_ready_html'] = '在BigBlueButton房间<a href="{$a->link}">{$a->name}</a>中的会话，现在有一个录制内容。';
$string['notification_recording_ready_plain'] = '在BigBlueButton房间{$a->name}的会话，现在有一个录制内容。请到{$a->link}去访问录制链接。';
$string['notification_recording_ready_small'] = 'BigBlueButton房间{$a->name}有一个录制内容。';
$string['notification_recording_ready_subject'] = '有录制内容';
$string['pluginadministration'] = 'BigBlueButton管理';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = '为了创建和加入BigBlueButton会话，需要与服务器交换用户数据。';
$string['privacy:metadata:bigbluebutton:fullname'] = '访问BigBlueButton服务器的用户的全名。';
$string['privacy:metadata:bigbluebutton:userid'] = '访问BigBlueButton服务器的用户ID。';
$string['privacy:metadata:bigbluebuttonbn'] = 'BigBlueButton会话配置';
$string['privacy:metadata:bigbluebuttonbn:participants'] = '定义用户在BigBlueButton会话中的角色的规则列表。可以存储用户ID，因为可以按角色或按用户授予权限。';
$string['privacy:metadata:bigbluebuttonbn_logs'] = '存储使用该插件时触发的事件。';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = '由用户触发的事件的类型。';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = '用户可以访问的会话ID。';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = '与会话或录制相关的其他信息。';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = '创建日志的时间';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = '触发事件的用户的用户 ID。';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = '存储关于录制内容的元数据。';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = '上次更改录制的用户的用户ID。';
$string['recordings_from_deleted_activities'] = '已删除活动的录制内容';
$string['recordingurlnotfound'] = '录制URL无效。';
$string['removedevents'] = '已删除的事件';
$string['removedlogs'] = '已删除自定义日志';
$string['removedrecordings'] = '已删除的录制内容';
$string['removedtags'] = '已删除的标签';
$string['report_join_info'] = '已加入房间{$a}次';
$string['report_play_recording_info'] = '已播放录制内容{$a}次';
$string['report_room_view'] = '已查看房间页面';
$string['resetevents'] = '删除事件';
$string['resetlogs'] = '删除自定义日志';
$string['resetlogs_help'] = '删除日志将导致失去对录制内容的引用。';
$string['resetrecordings'] = '删除录制内容';
$string['resetrecordings_help'] = '删除录制内容将使它们无法从任何地方访问。此操作无法撤消！';
$string['resettags'] = '删除标签';
$string['search:activity'] = 'BigBlueButton - 活动信息';
$string['search:tags'] = 'BigBlueButton - 标签信息';
$string['sendnotification'] = '发送通知';
$string['settings'] = 'BigBlueButton 设置';
$string['started_at'] = '开始';
$string['starts_at'] = '开始';
$string['taskname:check_pending_recordings'] = '获取待处理的录制内容';
$string['userlimitreached'] = '已达到会话中允许的用户数。';
$string['view_conference_action_end'] = '结束会话';
$string['view_conference_action_join'] = '加入会话';
$string['view_error_action_not_completed'] = '无法完成操作';
$string['view_error_bigbluebutton'] = 'BigBlueButton回应了错误。{$a}';
$string['view_error_create'] = 'BigBlueButton 服务器响应一条错误消息。 无法创建房间。';
$string['view_error_current_state_not_found'] = '未找到当前状态。录制内容可能已被删除，或者BigBlueButton服务器与执行的操作不兼容。';
$string['view_error_import_no_courses'] = '没有课程可以查询录制内容。';
$string['view_error_import_no_recordings'] = '本课程中没有录制内容可供导入。';
$string['view_error_invalid_session'] = '会话已过期。回到活动页面。';
$string['view_error_max_concurrent'] = '已达到允许的并发会话数。';
$string['view_error_meeting_not_running'] = '出问题了; 会话未运行。';
$string['view_error_no_group'] = '没有组。在尝试加入会话之前，您需要创建一些组。';
$string['view_error_no_group_student'] = '您尚未被添加到组中。 请联系您的老师。';
$string['view_error_no_group_teacher'] = '没有组。 您需要创建一些组。';
$string['view_error_unable_join'] = '无法进入房间。 请检查 BigBlueButton 服务器的 URL 并检查 BigBlueButton 服务器是否正在运行。';
$string['view_error_unable_join_student'] = '无法连接到 BigBlueButton 服务器。';
$string['view_error_unable_join_teacher'] = '无法连接到 BigBlueButton 服务器。 请联系管理员。';
$string['view_error_url_missing_parameters'] = '此URL中缺少一些参数';
$string['view_error_userlimit_reached'] = '已达到会话中允许的用户数。';
$string['view_groups_nogroups_warning'] = '房间被配置为使用小组，但课程没有定义小组。';
$string['view_groups_notenrolled_warning'] = '房间被配置为使用群组，但您不是群组的成员。';
$string['view_groups_selection'] = '选择要加入的组，并确认该操作';
$string['view_groups_selection_join'] = '加入';
$string['view_groups_selection_warning'] = '每个小组都有一个房间，您可以访问多个房间。请确保选择正确的选项。';
$string['view_login_moderator'] = '以主持人身份登录...';
$string['view_login_viewer'] = '以浏览者身份登录...';
$string['view_message_and'] = '和';
$string['view_message_conference_has_ended'] = '会话已结束。';
$string['view_message_conference_in_progress'] = '会话正在进行中。';
$string['view_message_conference_not_started'] = '会话尚未开始。';
$string['view_message_conference_room_ready'] = '这个房间准备好了。 您现在可以加入会议。';
$string['view_message_conference_wait_for_moderator'] = '等待主持人加入。';
$string['view_message_finished'] = '本次活动结束。';
$string['view_message_has_joined'] = '已经加入';
$string['view_message_have_joined'] = '已经加入';
$string['view_message_hour'] = '小时';
$string['view_message_hours'] = '小时';
$string['view_message_importrecordings_disabled'] = '服务器上禁用了导入录制链接。';
$string['view_message_minute'] = '分钟';
$string['view_message_minutes'] = '分钟';
$string['view_message_moderator'] = '主持人';
$string['view_message_moderators'] = '主持人';
$string['view_message_norecordings'] = '没有可用的录制内容。';
$string['view_message_notavailableyet'] = '此会话尚不可用。';
$string['view_message_recordings_disabled'] = '录制内容在服务器上被禁用。 不能使用“仅限录制”类型的 BigBlueButton 活动。';
$string['view_message_room_closed'] = '这个房间是封闭的。';
$string['view_message_room_open'] = '这个房间是开放的。';
$string['view_message_room_ready'] = '这个房间准备好了。';
$string['view_message_session_for'] = '会话为';
$string['view_message_session_has_user'] = '有';
$string['view_message_session_has_users'] = '有';
$string['view_message_session_no_users'] = '此会话中没有用户';
$string['view_message_session_running_for'] = '此会话已运行';
$string['view_message_session_started_at'] = '本次会话开始于';
$string['view_message_tab_close'] = '此选项卡/窗口必须手动关闭';
$string['view_message_times'] = '次';
$string['view_message_user'] = '用户';
$string['view_message_users'] = '用户';
$string['view_message_viewer'] = '浏览者';
$string['view_message_viewers'] = '浏览者';
$string['view_mobile_message_groups_not_supported'] = '此实例已启用，可与群组一起使用，但移动应用程序尚不支持它。请使用网页版。';
$string['view_mobile_message_reload_page_creation_time_meeting'] = '您在此页面上的时间超过了 45 秒。 请刷新页面以加入会话。';
$string['view_noguests'] = 'BigBlueButton 房间不对访客开放。';
$string['view_nojoin'] = '您没有可以加入此会话的角色。';
$string['view_recording'] = '录制';
$string['view_recording_actionbar'] = '工具栏';
$string['view_recording_activity'] = '活动';
$string['view_recording_button_import'] = '导入录制链接';
$string['view_recording_button_return'] = '回去';
$string['view_recording_course'] = '课程';
$string['view_recording_date'] = '日期';
$string['view_recording_delete_confirmation'] = '您确定要删除 {$a} 吗？';
$string['view_recording_delete_confirmation_warning_p'] = '此录制具有关联的{$a}链接，这些链接已导入到不同的课程或活动中。如果录制内容被删除，这些链接也将被删除。';
$string['view_recording_delete_confirmation_warning_s'] = '此录制具有关联的{$a}链接，该链接已导入到其他课程或活动中。如果录制内容被删除，此链接也将被删除。';
$string['view_recording_description'] = '描述';
$string['view_recording_description_edithint'] = '可以添加描述以帮助识别录制。';
$string['view_recording_description_editlabel'] = '编辑描述';
$string['view_recording_duration'] = '期间';
$string['view_recording_duration_min'] = '分钟';
$string['view_recording_format_errror_unreachable'] = '此录制格式的 URL 无法访问。';
$string['view_recording_format_notes'] = '笔记';
$string['view_recording_format_podcast'] = '播客';
$string['view_recording_format_presentation'] = '演示';
$string['view_recording_format_screenshare'] = '屏幕共享';
$string['view_recording_format_statistics'] = '统计数据';
$string['view_recording_format_video'] = '视频';
$string['view_recording_import_confirmation'] = '您确定要导入此录制吗？';
$string['view_recording_length'] = '长度';
$string['view_recording_link_warning'] = '这是指向在不同课程或活动中创建的录制的链接。';
$string['view_recording_list_action_delete'] = '删除';
$string['view_recording_list_action_edit'] = '正在更新';
$string['view_recording_list_action_play'] = '播放';
$string['view_recording_list_action_process'] = '加工';
$string['view_recording_list_action_protect'] = '保护';
$string['view_recording_list_action_publish'] = '发布';
$string['view_recording_list_action_unprotect'] = '解除保护';
$string['view_recording_list_action_unpublish'] = '取消发布';
$string['view_recording_list_action_update'] = '更新';
$string['view_recording_list_actionbar'] = '工具栏';
$string['view_recording_list_actionbar_delete'] = '删除';
$string['view_recording_list_actionbar_edit'] = '编辑';
$string['view_recording_list_actionbar_hide'] = '隐藏';
$string['view_recording_list_actionbar_import'] = '输入';
$string['view_recording_list_actionbar_protect'] = '将其设为私有';
$string['view_recording_list_actionbar_publish'] = '发布';
$string['view_recording_list_actionbar_show'] = '展示';
$string['view_recording_list_actionbar_unprotect'] = '公开';
$string['view_recording_list_actionbar_unpublish'] = '取消发布';
$string['view_recording_list_activity'] = '活动';
$string['view_recording_list_course'] = '课程';
$string['view_recording_list_date'] = '日期';
$string['view_recording_list_description'] = '描述';
$string['view_recording_list_duration'] = '期间';
$string['view_recording_list_recording'] = '录制';
$string['view_recording_meeting'] = '会议';
$string['view_recording_modal_button'] = '申请';
$string['view_recording_modal_title'] = '设置录制的数值';
$string['view_recording_name'] = '名称';
$string['view_recording_name_edithint'] = '可以添加名称以帮助识别录制内容。';
$string['view_recording_name_editlabel'] = '编辑名称';
$string['view_recording_playback'] = '回放';
$string['view_recording_preview'] = '预习';
$string['view_recording_preview_help'] = '将鼠标悬停在图像上以全尺寸查看';
$string['view_recording_protect_confirmation'] = '您确定要保护此{$a}吗？';
$string['view_recording_protect_confirmation_warning_p'] = '这个录制有{$a}个链接，这些链接被导入到不同的课程或活动中。如果该录制受到保护，它也会影响到导入的链接。';
$string['view_recording_protect_confirmation_warning_s'] = '此录制有{$a}个链接，该链接被导入到不同的课程或活动中。如果该录制受到保护，它也会影响到导入的链接。';
$string['view_recording_publish_confirmation'] = '您确定要发布此 {$a} 吗？';
$string['view_recording_publish_confirmation_warning_p'] = '此录制有{$a}个链接，这些链接被导入到不同的课程或活动中。如果该录制被公布，这些链接也将被公布。';
$string['view_recording_publish_confirmation_warning_s'] = '此录制具有关联的 {$a} 链接，该链接已导入到不同的课程或活动中。 如果录制被发布，这个链接也将被发布。';
$string['view_recording_publish_link_deleted'] = '此链接无法重新发布，因为 BigBlueButton 服务器上不存在原始记录。 链接应该被删除。';
$string['view_recording_publish_link_not_published'] = '此链接无法重新发布，因为原始录制未发布。';
$string['view_recording_recording'] = '录制';
$string['view_recording_select_course'] = '首先在下拉菜单中选择一门课程';
$string['view_recording_tags'] = '标签';
$string['view_recording_unprotect_confirmation'] = '您确定要取消保护此 {$a} 吗？';
$string['view_recording_unprotect_confirmation_warning_p'] = '此录制具有关联的 {$a} 链接，这些链接已导入到不同的课程或活动中。 如果录制不受保护，它也会影响导入的链接。';
$string['view_recording_unprotect_confirmation_warning_s'] = '此录制具有关联的 {$a} 链接，该链接已导入到不同的课程或活动中。 如果录制不受保护，它也会影响导入的链接。';
$string['view_recording_unprotect_link_deleted'] = '此链接无法取消保护，因为 BigBlueButton 服务器上不存在原始录制。链接应该被删除。';
$string['view_recording_unprotect_link_not_unprotected'] = '此链接无法取消保护，因为原始录制受到保护。';
$string['view_recording_unpublish_confirmation'] = '您确定要取消发布此 {$a} 吗？';
$string['view_recording_unpublish_confirmation_warning_p'] = '此录制具有关联的 {$a} 链接，这些链接已导入到不同的课程或活动中。 如果录制未发布，这些链接也将被取消发布。';
$string['view_recording_unpublish_confirmation_warning_s'] = '此录制具有关联的 {$a} 链接，该链接已导入到不同的课程或活动中。 如果录制未发布，此链接也将被取消发布。';
$string['view_recording_yui_first'] = '首先';
$string['view_recording_yui_go'] = '进行';
$string['view_recording_yui_last'] = '最后的';
$string['view_recording_yui_next'] = '下一个';
$string['view_recording_yui_page'] = '网页';
$string['view_recording_yui_prev'] = '以前的';
$string['view_recording_yui_rows'] = '排';
$string['view_recording_yui_show_all'] = '全部显示';
$string['view_room'] = '查看房间';
$string['view_section_title_presentation'] = '演示文稿文件';
$string['view_section_title_recordings'] = '录制内容';
$string['view_warning_default_server'] = '本网站正在使用Blindside Networks提供的<a href=""https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/"" target=""_blank"">免费的BigBlueButton服务（在新窗口中打开）</a>，限制如下：
<ol>
<li>每节课的最长时长为 60 分钟</li>
<li>每个会话的最大并发用户数为 25</li>
<li>录音将在七 (7) 天后过期且不可下载</li>
<li>只有管理员可以看到学生的网络摄像头。</li>
</ol>';
$string['waitformoderator'] = '等待主持人加入。';
