<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'glossary', language 'el', version '4.0'.
 *
 * @package     glossary
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcategory'] = 'Προσθήκη κατηγορίας';
$string['addcomment'] = 'Προσθήκη σχολίου';
$string['addentry'] = 'Προσθήκη νέας εγγραφής';
$string['addingcomment'] = 'Προσθήκη ενός σχολίου';
$string['alias'] = 'Λέξη κλειδί';
$string['aliases'] = 'Λέξη/-εις κλειδιά';
$string['aliases_help'] = 'Κάθε καταχώρηση γλωσσαρίου μπορεί να έχει μια συσχετισμένη λίστα λέξεων-κλειδιών (ή ψευδωνύμων). Εάν η καταχώρηση συνδέεται αυτόματα, τότε όλες οι λέξεις-κλειδιά θα συνδέονται αυτόματα. Εισαγάγετε κάθε λέξη-κλειδί σε μια νέα γραμμή (και όχι χωρισμένες με κόμματα).';
$string['allcategories'] = 'Όλες οι κατηγορίες';
$string['allentries'] = 'ΟΛΑ';
$string['allowcomments'] = 'Να επιτρέπονται τα σχόλια στις εγγραφές';
$string['allowcomments_help'] = 'Αν ενεργοποιηθεί, όλοι οι συμμετέχοντες με δικαίωμα να δημιουργήσουν σχόλια θα μπορούν να προσθέσουν σχόλια σε καταχωρήσεις γλωσσαρίου.';
$string['allowduplicatedentries'] = 'Επιτρέπονται διπλότυπες εγγραφές';
$string['allowduplicatedentries_help'] = 'Αν ενεργοποιηθεί, πολλές καταχωρήσεις μπορούν να έχουν το ίδιο όνομα έννοιας.';
$string['allowprintview'] = 'Να επιτρέπεται η προεπισκόπηση εκτύπωσης';
$string['allowprintview_help'] = 'Αν ενεργοποιηθεί, στους μαθητές παρέχεται ένας σύνδεσμος προς μια φιλική προς τους εκτυπωτές έκδοση του γλωσσαρίου. Ο σύνδεσμος είναι πάντοτε διαθέσιμος στους διδάσκοντες.';
$string['andmorenewentries'] = 'και {$a} περισσότερες νέες καταχωρήσεις.';
$string['answer'] = 'Απάντηση';
$string['approvaldisplayformat'] = 'Μορφότυπος εμφάνισης έγκρισης';
$string['approvaldisplayformat_help'] = 'Όταν εγκρίνονται στοιχεία γλωσσαρίου ίσως επιθυμείτε να χρησιμοποιήσετε ένα διαφορετικό μορφότυπο εμφάνισης.';
$string['approve'] = 'Έγκριση';
$string['areaattachment'] = 'Συνημμένα';
$string['areaentry'] = 'Ορισμοί';
$string['areyousuredelete'] = 'Σίγουρα θέλετε να διαγράψετε αυτήν την εγγραφή;';
$string['areyousuredeletecomment'] = 'Σίγουρα θέλετε να διαγράψετε αυτό το σχόλιο;';
$string['areyousureexport'] = 'Σίγουρα θέλετε να εξάγετε αυτήν την εγγραφή στο';
$string['ascending'] = '(αύξουσα)';
$string['attachment'] = 'Συνημμένο';
$string['attachment_help'] = 'Μπορείτε προαιρετικά να επισυνάψετε ένα ή περισσότερα αρχεία σε μία καταχώρηση γλωσσαρίου.';
$string['author'] = 'συγγραφέας';
$string['authorview'] = 'Περιήγηση κατά συγγραφέα';
$string['back'] = 'Επιστροφή';
$string['cachedef_concepts'] = 'Συνδέσεις έννοιας';
$string['cantinsertcat'] = 'Αδυναμία εισαγωγής κατηγορίας';
$string['cantinsertrec'] = 'Αδυναμία εισαγωγής εγγραφής';
$string['cantinsertrel'] = 'Αδυναμία εισαγωγής σχέσης κατηγορίας-εγγραφής';
$string['casesensitive'] = 'Αυτή η εγγραφή είναι ευαίσθητη σε μικρά/κεφαλαία';
$string['casesensitive_help'] = 'Αυτή η ρύθμιση καθορίζει εάν η διάκριση πεζών/κεφαλαίων γραμμάτων είναι απαραίτητη στην αυτόματη δημιουργία συνδέσμων σε κάθε καταχώρηση γλωσσαρίου.';
$string['cat'] = 'κατηγ.';
$string['categories'] = 'Κατηγορίες';
$string['category'] = 'Κατηγορία';
$string['categorydeleted'] = 'Διαγράφηκε η κατηγορία';
$string['categoryview'] = 'Περιήγηση κατά κατηγορία';
$string['changeto'] = 'αλλαγή σε {$a}';
$string['cnfallowcomments'] = 'Ορίστε εάν ένα γλωσσάριο θα δέχεται σχόλια στις εγγραφές, από προεπιλογή';
$string['cnfallowdupentries'] = 'Ορίστε εάν ένα γλωσσάριο θα επιτρέπει τις διπλές εγγραφές, από προεπιλογή';
$string['cnfapprovalstatus'] = 'Ορίστε την προεπιλεγμένη κατάσταση αποδοχής μιας καταχώρησης που αναρτήθηκε από ένα μαθητή.';
$string['cnfcasesensitive'] = 'Ορίστε εάν κατά την σύνδεση μιας καταχώρησης θα γίνεται διάκριση πεζών/κεφαλαίων από προεπιλογή.';
$string['cnfdefaulthook'] = 'Επιλέξτε την προεπιλεγμένη επιλογή για προβολή όταν εμφανίζεται το γλωσσάριο για πρώτη φορά';
$string['cnfdefaultmode'] = 'Επιλέξτε το προεπιλεγμένο πλαίσιο για προβολή όταν εμφανίζεται το γλωσσάριο για πρώτη φορά';
$string['cnffullmatch'] = 'Ορίστε εάν κατά την σύνδεση μιας καταχώρησης θα γίνεται διάκριση πεζών/κεφαλαίων από προεπιλογή.';
$string['cnflinkentry'] = 'Ορίστε εάν σε μια καταχώρηση θα γίνεται σύνδεση αυτόματα από προεπιλογή.';
$string['cnflinkglossaries'] = 'Ορίστε εάν σε ένα γλωσσάριο θα γίνεται σύνδεση αυτόματα από προεπιλογή.';
$string['cnfrelatedview'] = 'Επιλέξτε τη μορφή εμφάνισης που θα χρησιμοποιείται για αυτόματο σύνδεσμο και προβολή εγγραφής.';
$string['cnfshowgroup'] = 'Προσδιορίστε εάν θα εμφανίζεται ο διαχωριστής της ομάδας.';
$string['cnfsortkey'] = 'Επιλέξτε το προεπιλεγμένο κλειδί ταξινόμησης.';
$string['cnfsortorder'] = 'Επιλέξτε την προεπιλεγμένη σειρά ταξινόμησης.';
$string['cnfstudentcanpost'] = 'Ορίστε εάν οι μαθητές από προεπιλογή θα μπορούν ή όχι να κάνουν αναρτήσεις';
$string['cnftabs'] = 'Επιλέξτε ορατές καρτέλες για αυτό τον μορφότυπο γλωσσαρίου';
$string['comment'] = 'Σχόλιο';
$string['commentdeleted'] = 'Το σχόλιο διαγράφηκε.';
$string['comments'] = 'Σχόλια';
$string['commentson'] = 'Σχόλια για';
$string['commentupdated'] = 'Το σχόλιο ενημερώθηκε.';
$string['completiondetail:entries'] = 'Κάντε καταχωρήσεις: {$a}';
$string['completionentries'] = 'Ο μαθητής πρέπει να δημιουργήσει καταχωρήσεις:';
$string['completionentriesdesc'] = 'Ο μαθητής πρέπει να δημιουργήσει τουλάχιστον {$a} καταχωρήσεις(η)';
$string['completionentriesgroup'] = 'Απαιτούνται καταχωρήσεις';
$string['concept'] = 'Έννοια';
$string['concepts'] = 'Έννοιες';
$string['configenablerssfeeds'] = 'Αυτός ο διακόπτης θα ενεργοποιήσει τη δυνατότητα τροφοδοσιών RSS για όλα τα γλωσσάρια. Εξακολουθεί να απαιτείται η ενεργοποίηση των τροφοδοσιών στις ρυθμίσεις κάθε γλωσσαρίου ξεχωριστά.';
$string['current'] = 'Ταξινομημένα προς το παρόν {$a}';
$string['currentglossary'] = 'Τρέχον γλωσσάριο';
$string['date'] = 'ημερομηνία';
$string['dateview'] = 'Περιήγηση κατά ημερομηνία';
$string['defaultapproval'] = 'Αποδοχή από προεπιλογή';
$string['defaultapproval_help'] = 'Αν οριστεί σε όχι, οι καταχωρήσεις απαιτούν έγκριση από διδάσκοντα πριν να γίνουν ορατές από όλους.';
$string['defaulthook'] = 'Προεπιλεγμένο άγκιστρο';
$string['defaultmode'] = 'Προεπιλεγμένη κατάσταση';
$string['defaultsortkey'] = 'Προεπιλεγμένο κλειδί ταξινόμησης';
$string['defaultsortorder'] = 'Προεπιλεγμένη σειρά ταξινόμησης';
$string['definition'] = 'Ορισμός';
$string['definitions'] = 'Ορισμοί';
$string['deletecategory'] = 'Διαγραφή κατηγορίας';
$string['deleteentry'] = 'Διαγραφή εγγραφής';
$string['deleteentrya'] = 'Διαγραφή καταχώρησης: {$a}';
$string['deletenotenrolled'] = 'Διαγραφή των καταχωρήσεων από χρήστες που δεν έχουν εγγραφεί στο μάθημα';
$string['deletingcomment'] = 'Διαγραφή σχολίου';
$string['deletingnoneemptycategory'] = 'Διαγράφοντας αυτήν την κατηγορία δεν θα διαγραφούν οι εγγραφές που περιέχει- θα επισημανθούν ως μη κατηγοριοποιημένες.';
$string['descending'] = 'φθίνουσα';
$string['destination'] = 'Προορισμός των καταχωρήσεων που εισάγονται';
$string['destination_help'] = 'Οι καταχωρήσεις μπορούν είτε να εισαχθούν μαζικά και να προστεθούν στο τρέχον γλωσσάριο ή σε ένα νέο γλωσσάριο, στην οποία περίπτωση ένα νέο γλωσσάριο θα δημιουργηθεί με βάση τις πληροφορίες στο XML αρχείο.';
$string['disapprove'] = 'Αναίρεση έγκρισης';
$string['displayformat'] = 'Μορφή προβολής';
$string['displayformat_help'] = 'Υπάρχουν 7 μορφότυποι εμφάνισης:

* Απλό, στυλ λεξικού - Δεν εμφανίζονται συγγραφείς και τα συνημμένα εμφανίζονται ως σύνδεσμοι.
* Συνεχής χωρίς συγγραφέα - Οι εγγραφές εμφανίζονται το ένα μετά το άλλο χωρίς διαχωρισμό εκτός από τα εικονίδια επεξεργασίας.
* Πλήρης με τον συγγραφέα - Μορφότυπος εμφάνισης σαν φόρουμ, που εμφανίζει τα στοιχεία του συγγραφέα και τα συνημμένα εμφανίζονται ως σύνδεσμοι.
* Πλήρης χωρίς συγγραφέα - Μορφότυπος εμφάνισης σαν φόρουμ, χωρίς συγγραφείς και με συνημμένα που εμφανίζονται ως σύνδεσμοι.
* Εγκυκλοπαίδεια - Όπως ο «Πλήρης με τον συγγραφέα», αλλά οι συνημμένες εικόνες εμφανίζονται στην ίδια γραμμή.
* Λίστα με καταχωρήσεις - Οι έννοιες αναφέρονται ως σύνδεσμοι.
* Συχνές ερωτήσεις - Οι λέξεις QUESTION και ANSWER προσαρτώνται στην έννοια και τον ορισμό αντίστοιχα.';
$string['displayformatcontinuous'] = 'Συνεχής χωρίς συγγραφέα';
$string['displayformatdefault'] = 'Η προεπιλογή είναι ίδια με τον μορφότυπο εμφάνισης';
$string['displayformatdictionary'] = 'Απλό, στυλ λεξικού';
$string['displayformatencyclopedia'] = 'Εγκυκλοπαίδεια';
$string['displayformatentrylist'] = 'Λίστα εγγραφών';
$string['displayformatfaq'] = 'Συχνές Ερωτήσεις';
$string['displayformatfullwithauthor'] = 'Πλήρης με συγγραφέα';
$string['displayformatfullwithoutauthor'] = 'Πλήρης χωρίς συγγραφέα';
$string['displayformats'] = 'Μορφές προβολής';
$string['displayformatssetup'] = 'Ρύθμιση μορφότυπων προβολής';
$string['duplicatecategory'] = 'Διπλότυπη κατηγορία';
$string['duplicateentry'] = 'Διπλή καταχώρηση';
$string['editalways'] = 'Επιτρέπεται πάντα επεξεργασία';
$string['editalways_help'] = 'Αυτή η ρύθμιση καθορίζει εάν οι μαθητές θα μπορούν να τροποποιούν τις καταχωρήσεις τους πάντα ή μόνο εντός ενός ρυθμιζόμενου χρόνου επεξεργασίας (συνήθως 30 λεπτά).';
$string['editcategories'] = 'Τροποποίηση κατηγοριών';
$string['editcategory'] = 'Τροποποίηση κατηγορίας';
$string['editentry'] = 'Τροποποίηση καταχώρησης';
$string['editentrya'] = 'Τροποποίηση καταχώρησης: {$a}';
$string['editingcomment'] = 'Τροποποίηση σχολίου...';
$string['entbypage'] = 'Καταχωρήσεις ανά σελίδα';
$string['entries'] = 'Καταχωρήσεις';
$string['entrieswithoutcategory'] = 'Καταχωρήσεις χωρίς κατηγορία';
$string['entry'] = 'Καταχώρηση';
$string['entryalreadyexist'] = 'Η καταχώρηση υπάρχει ήδη';
$string['entryapproved'] = 'Αυτή η εγγραφή έχει εγκριθεί';
$string['entrydeleted'] = 'Η καταχώρηση διαγράφηκε';
$string['entryexported'] = 'Η καταχώρηση εξάχθηκε επιτυχώς';
$string['entryishidden'] = '(αυτή η καταχώρηση είναι προς το παρόν κρυμμένη)';
$string['entryleveldefaultsettings'] = 'Προεπιλεγμένες ρυθμίσεις επιπέδου καταχώρησης';
$string['entrylink'] = 'Σύνδεσμος καταχώρησης: {$a}';
$string['entrynotapproved'] = 'Η είσοδος δεν εγκρίθηκε';
$string['entrysaved'] = 'Αυτή η καταχώρηση αποθηκεύτηκε';
$string['entryupdated'] = 'Αυτή η καταχώρηση ενημερώθηκε';
$string['entryusedynalink'] = 'Σε αυτήν την καταχώρηση θα γίνεται σύνδεση αυτόματα.';
$string['entryusedynalink_help'] = 'Αν οι αυτόματοι σύνδεσμοι με το γλωσσάριο έχουν ενεργοποιηθεί σε όλο τον ιστότοπο από έναν διαχειριστή και αυτό το πλαίσιο επιλογής είναι επιλεγμένο, τότε η καταχώρηση θα συνδεθεί αυτόματα οπουδήποτε οι λέξεις και οι φράσεις των εννοιών εμφανίζονται και στο υπόλοιπο του μαθήματος.';
$string['errcannoteditothers'] = 'Δεν μπορείτε να επεξεργαστείτε τις καταχωρήσεις άλλων χρηστών.';
$string['errconceptalreadyexists'] = 'Αυτή η έννοια υπάρχει ήδη. Δεν επιτρέπονται διπλότυπα σε αυτό το γλωσσάριο.';
$string['errdeltimeexpired'] = 'Δεν μπορείτε να το διαγράψετε αυτό. Ο χρόνος έληξε!';
$string['erredittimeexpired'] = 'Ο χρόνος επεξεργασίας αυτής της καταχώρησης έληξε.';
$string['errorparsingxml'] = 'Παρουσιάστηκαν σφάλματα κατά την συντακτική ανάλυση αυτού του αρχείου. Σιγουρευτείτε ότι η σύνταξή του είναι έγκυρη στην XML.';
$string['eventcategorycreated'] = 'Η κατηγορία δημιουργήθηκε';
$string['eventcategorydeleted'] = 'Η κατηγορία διαγράφηκε';
$string['eventcategoryupdated'] = 'Η κατηγορία ενημερώθηκε';
$string['evententryapproved'] = 'Η καταχώρηση εγκρίθηκε';
$string['evententrycreated'] = 'Η καταχώρηση δημιουργήθηκε';
$string['evententrydeleted'] = 'Η καταχώρηση διαγράφηκε';
$string['evententrydisapproved'] = 'Η καταχώρηση δεν εγκρίθηκε';
$string['evententryupdated'] = 'Η καταχώρηση ενημερώθηκε';
$string['evententryviewed'] = 'Η καταχώρηση προβλήθηκε';
$string['explainaddentry'] = 'Προσθέστε μια νέα καταχώρηση στο τρέχον γλωσσάριο.<br /> Η έννοια και ο ορισμός είναι υποχρεωτικά πεδία.';
$string['explainall'] = 'Εμφανίζει όλες τις καταχωρήσεις σε μια σελίδα';
$string['explainalphabet'] = 'Περιήγηση στο γλωσσάριο χρησιμοποιώντας αυτό το ευρετήριο';
$string['explainexport'] = 'Πατήστε το κουμπί παρακάτω για να εξάγετε τις καταχωρήσεις γλωσσαρίου.<br />Μπορείτε να τις εισάγετε όποτε θελήσετε σε αυτό ή σε άλλο μάθημα. <p>Παρακαλούμε σημειώστε πως τα συνημμένα (π.χ. εικόνες) και οι συγγραφείς δεν εξάγονται.</p>';
$string['explainimport'] = 'Πρέπει να προσδιορίσετε το αρχείο εισαγωγής και να ορίσετε τα κριτήρια της διαδικασίας.<p>Υποβάλετε το αίτημά σας και εξετάστε τα αποτελέσματα.</p>';
$string['explainspecial'] = 'Εμφάνιση καταχωρήσεων που δεν ξεκινάνε με γράμμα';
$string['exportedentry'] = 'Εξαγόμενη καταχώρηση';
$string['exportentries'] = 'Εξαγωγή καταχωρήσεων';
$string['exportentriestoxml'] = 'Εξαγωγή καταχωρήσεων σε αρχείο XML';
$string['exportfile'] = 'Εξαγωγή καταχωρήσεων σε αυτό το αρχείο';
$string['exportglossary'] = 'Εξαγωγή γλωσσαρίου';
$string['exporttomainglossary'] = 'Εξαγωγή στο κύριο γλωσσάριο';
$string['filetoimport'] = 'Αρχείο προς εισαγωγή';
$string['filetoimport_help'] = 'Περιηγηθείτε και επιλέξτε το αρχείο XML στον υπολογιστή σας, το οποίο περιέχει τις καταχωρήσεις προς εισαγωγή.';
$string['fillfields'] = 'Η έννοια και ο ορισμός είναι υποχρεωτικά πεδία.';
$string['filtername'] = 'Αυτόματοι σύνδεσμοι για το γλωσσάριο';
$string['fullmatch'] = 'Ταίριασμα ολόκληρων λέξεων μόνο';
$string['fullmatch_help'] = 'Αυτή η ρύθμιση καθορίζει εάν μόνο ολόκληρες λέξεις θα συνδέονται. Για παράδειγμα, μια καταχώρηση με όνομα «και» δεν θα δημιουργήσει ένα σύνδεσμο μέσα στην λέξη «καιρός».';
$string['glossary:addinstance'] = 'Προσθήκη νέου γλωσσαρίου';
$string['glossary:approve'] = 'Αποδοχή και ανάκληση εγκεκριμένων καταχωρήσεων';
$string['glossary:comment'] = 'Δημιουργία σχολίων';
$string['glossary:export'] = 'Εξαγωγή καταχωρήσεων';
$string['glossary:exportentry'] = 'Εξαγωγή μίας μόνο καταχώρησης';
$string['glossary:exportownentry'] = 'Εξαγωγή μίας μόνο καταχώρησής σας';
$string['glossary:import'] = 'Εισαγωγή καταχωρήσεων';
$string['glossary:managecategories'] = 'Διαχείριση κατηγοριών';
$string['glossary:managecomments'] = 'Διαχείριση σχολίων';
$string['glossary:manageentries'] = 'Διαχείριση καταχωρήσεων';
$string['glossary:rate'] = 'Βαθμολόγηση καταχωρήσεων';
$string['glossary:view'] = 'Εμφάνιση γλωσσαρίου';
$string['glossary:viewallratings'] = 'Εμφάνιση όλων των πρώτων αξιολογήσεων που δόθηκαν ατομικά';
$string['glossary:viewanyrating'] = 'Εμφάνιση όλων των συνολικών αξιολογήσεων που έλαβε κάποιος';
$string['glossary:viewrating'] = 'Δείτε τη συνολική βαθμολογία που λάβατε';
$string['glossary:write'] = 'Δημιουργία νέων καταχωρήσεων';
$string['glossaryleveldefaultsettings'] = 'Προεπιλεγμένες ρυθμίσεις επιπέδου γλωσσαρίου';
$string['glossarytype'] = 'Τύπος γλωσσαρίου';
$string['glossarytype_help'] = 'Ένα κύριο γλωσσάριο είναι ένα γλωσσάριο στο οποίο μπορούν να εισάγονται καταχωρήσεις από δευτερεύοντα γλωσσάρια. Μπορεί να υπάρχει μόνο ένα κύριο γλωσσάριο σε ένα μάθημα. Αν δεν απαιτείται μαζική εισαγωγή καταχωρήσεων (από άλλο γλωσσάριο), τότε όλα τα γλωσσάρια στο μάθημα μπορούν να είναι δευτερεύοντα.';
$string['guestnoedit'] = 'Οι επισκέπτες δεν επιτρέπεται να επεξεργάζονται γλωσσάρια';
$string['importcategories'] = 'Εισαγωγή κατηγοριών';
$string['importedcategories'] = 'Εισαγόμενες κατηγορίες';
$string['importedentries'] = 'Εισαγόμενες καταχωρήσεις';
$string['importentries'] = 'Εισαγωγή καταχωρήσεων';
$string['importentriesfromxml'] = 'Εισαγωγή καταχωρήσεων από αρχείο XML';
$string['includegroupbreaks'] = 'Περιλαμβάνονται οι διαχωριστές ομάδων';
$string['indicator:cognitivedepth'] = 'Βάθος κατανόησης γλωσσαρίου';
$string['indicator:cognitivedepth_help'] = 'Αυτός ο δείκτης βασίζεται στο βάθος κατανόησης που επιτεύχθηκε από τον μαθητή σε μια δραστηριότητα γλωσσαρίου.';
$string['indicator:cognitivedepthdef'] = 'Βάθος κατανόησης γλωσσαρίου';
$string['indicator:cognitivedepthdef_help'] = 'Ο συμμετέχων έχει φτάσει αυτό το ποσοστό αφοσίωσης στο βάθος κατανόησης που προσφέρεται από τις δραστηριότητες Γλωσσαρίου κατά τη διάρκεια αυτού του διαστήματος ανάλυσης (Επίπεδα = Καμία εμφάνιση, Εμφάνιση, Υποβολή)';
$string['indicator:cognitivedepthdef_link'] = 'Δείκτες_μαθησιακής_αναλυτικής#Βάθος_κατανόησης';
$string['indicator:socialbreadth'] = 'Κοινωνικό εύρος γλωσσαρίου';
$string['indicator:socialbreadth_help'] = 'Αυτός ο δείκτης βασίζεται στο κοινωνικό εύρος που επιτεύχθηκε από τον μαθητή σε μια δραστηριότητα γλωσσαρίου.';
$string['indicator:socialbreadthdef'] = 'Κοινωνικό εύρος γλωσσαρίου';
$string['indicator:socialbreadthdef_help'] = 'Ο συμμετέχων έχει φτάσει αυτό το ποσοστό αφοσίωσης στο κοινωνικό εύρος που προσφέρεται από τις δραστηριότητες Γλωσσαρίου κατά τη διάρκεια αυτού του διαστήματος ανάλυσης (Επίπεδα = Καμία συμμετοχή, Συμμετέχων μόνος)';
$string['indicator:socialbreadthdef_link'] = 'Δείκτες_μαθησιακής_αναλυτικής#Κοινωνικό_εύρος';
$string['isglobal'] = 'Είναι αυτό το γλωσσάριο καθολικό;';
$string['isglobal_help'] = 'Ένα καθολικό γλωσσάριο έχει καταχωρήσεις με συνδέσμους από ολόκληρο τον ιστότοπο, παρά από το μάθημα μόνο στο οποίο περιλαμβάνεται. Μόνο διαχειριστές μπορούν να ορίσουν ένα γλωσσάριο ως καθολικό.';
$string['letter'] = 'γράμμα';
$string['linkcategory'] = 'Αυτόματοι σύνδεσμοι για αυτή την κατηγορία';
$string['linkcategory_help'] = 'Αν έχουν ενεργοποιηθεί οι αυτόματοι σύνδεσμοι γλωσσαρίου και αυτή η επιλογή είναι ενεργοποιημένη, τότε θα δημιουργείται αυτόματα σύνδεσμος και για το όνομα της κατηγορίας όπου αυτό εμφανίζεται στο υπόλοιπο του μαθήματος. Όταν ένας συμμετέχων ακολουθεί ένα σύνδεσμο ονόματος κατηγορίας, θα οδηγείται στην σελίδα «Περιήγηση κατά κατηγορία» του γλωσσαρίου.';
$string['linking'] = 'Αυτόματοι σύνδεσμοι';
$string['mainglossary'] = 'Κύριο γλωσσάριο';
$string['maxtimehaspassed'] = 'Συγγνώμη, αλλά ο μέγιστος χρόνος για την επεξεργασία αυτού του σχολίου ({$a}) έχει παρέλθει!';
$string['modulename'] = 'Γλωσσάριο';
$string['modulename_help'] = 'Το άρθρωμα δραστηριότητας γλωσσαρίου επιτρέπει στους συμμετέχοντες να δημιουργούν και να διατηρούν μια λίστα ορισμών, όπως ένα λεξικό, ή να συλλέγουν και να οργανώνουν πόρους ή πληροφορίες. Ένας διδάσκων μπορεί να επιτρέψει την επισύναψη αρχείων σε καταχωρήσεις γλωσσαρίου. Οι συνδεδεμένες εικόνες εμφανίζονται στην καταχώρηση. Οι χρήστες μπορούν να αναζητήσουν ή να περιηγηθούν στις καταχωρήσεις αλφαβητικά ή ανά κατηγορία, ημερομηνία ή συγγραφέα. Οι καταχωρήσεις μπορούν να εγκρίνονται από προεπιλογή ή να απαιτούν έγκριση από έναν διδάσκοντα προτού να είναι ορατές από όλους. Εάν είναι ενεργοποιημένο το φίλτρο αυτόματης δημιουργίας συνδέσμων γλωσσαρίου, οι καταχωρήσεις θα συνδέονται αυτόματα όπου οι λέξεις και/ή οι φράσεις της έννοιας εμφανίζονται μέσα στο μάθημα. Ένας διδάσκων μπορεί να επιτρέψει σχόλια στις καταχωρήσεις. Οι καταχωρήσεις μπορούν επίσης να αξιολογηθούν από διδάσκοντες ή μαθητές (αξιολόγηση από ομότιμους). Οι αξιολογήσεις μπορούν να συναθροιστούν για να σχηματίσουν έναν τελικό βαθμό που καταγράφεται στο βαθμολόγιο. Τα γλωσσάρια έχουν πολλές χρήσεις, όπως:

* Μια συνεργατική τράπεζα βασικών όρων
* Ένας χώρος «Γνωριμία μαζί σας» όπου οι νέοι μαθητές προσθέτουν το όνομά τους και τα προσωπικά τους στοιχεία
* Ένα βοήθημα «Χρήσιμες συμβουλές» με βέλτιστες πρακτικές σε ένα πρακτικό θέμα
* Μια κοινόχρηστη περιοχή για χρήσιμα βίντεο, εικόνες ή αρχεία ήχου
* Ένα βοήθημα για επανάληψη των γεγονότων που πρέπει να θυμόμαστε';
$string['modulename_link'] = '';
$string['modulenameplural'] = 'Γλωσσάρια';
$string['newentries'] = 'Νέες καταχωρήσεις γλωσσαρίου';
$string['newglossary'] = 'Νέο γλωσσάριο';
$string['newglossarycreated'] = 'Το νέο γλωσσάριο δημιουργήθηκε.';
$string['newglossaryentries'] = 'Νέες καταχωρήσεις γλωσσαρίου:';
$string['nocomment'] = 'Δε βρέθηκε σχόλιο';
$string['nocomments'] = '(Δε βρέθηκαν σχόλια για αυτή την καταχώρηση)';
$string['noconceptfound'] = 'Δε βρέθηκε η έννοια ή ο ορισμός.';
$string['noentries'] = 'Δε βρέθηκαν καταχωρήσεις σε αυτήν την ενότητα';
$string['noentry'] = 'Δε βρέθηκε καταχώρηση.';
$string['nopermissiontodelcomment'] = 'Δεν μπορείτε να διαγράψετε τα σχόλια άλλων χρηστών!';
$string['nopermissiontodelinglossary'] = 'Δεν μπορείτε να σχολιάσετε σε αυτό το γλωσσάριο!';
$string['nopermissiontoviewresult'] = 'Μπορείτε μόνο να δείτε τα αποτελέσματα για τις δικές σας καταχωρήσεις';
$string['notapproved'] = 'αυτή η καταχώρηση γλωσσαρίου δεν έχει εγκριθεί ακόμη.';
$string['notcategorised'] = 'Μη κατηγοριοποιημένο';
$string['numberofentries'] = 'Πλήθος καταχωρήσεων';
$string['onebyline'] = '(μια ανά γραμμή)';
$string['page-mod-glossary-edit'] = 'Σελίδα προσθήκης/επεξεργασίας καταχώρησης γλωσσαρίου';
$string['page-mod-glossary-view'] = 'Εμφάνιση σελίδας επεξεργασίας γλωσσαρίου';
$string['page-mod-glossary-x'] = 'Σελίδα αρθρώματος οποιουδήποτε γλωσσαρίου';
$string['pluginadministration'] = 'Διαχείριση γλωσσαρίων';
$string['pluginname'] = 'Γλωσσάριο';
$string['popupformat'] = 'Μορφότυπος αναδυόμενου παραθύρου';
$string['print'] = 'Εκτύπωση';
$string['printerfriendly'] = 'Έκδοση φιλική για τον εκτυπωτή';
$string['printviewnotallowed'] = 'Η προβολή εκτύπωσης δεν επιτρέπεται';
$string['privacy'] = 'Απόρρητο των αποτελεσμάτων';
$string['privacy:metadata:core_comments'] = 'Τα σχόλια που γίνονται στους ορισμούς του γλωσσαρίου αποθηκεύονται χρησιμοποιώντας το σύστημα core_comment';
$string['privacy:metadata:core_files'] = 'Τα αρχεία που συνδέονται με ορισμούς γλωσσαρίου αποθηκεύονται χρησιμοποιώντας το σύστημα core_files';
$string['privacy:metadata:core_rating'] = 'Οι αξιολογήσεις που προστίθενται στις καταχωρήσεις γλωσσαρίου αποθηκεύονται χρησιμοποιώντας το σύστημα core_rating';
$string['privacy:metadata:core_tag'] = 'Οι ετικέτες που προστίθενται στους ορισμούς γλωσσαρίου αποθηκεύονται χρησιμοποιώντας το σύστημα core_tag';
$string['privacy:metadata:glossary_entries'] = 'Πληροφορίες σχετικά με τις καταχωρήσεις του χρήστη για μια συγκεκριμένη δραστηριότητα γλωσσαρίου';
$string['privacy:metadata:glossary_entries:attachment'] = 'Το συνημμένο της καταχώρησης που πρόσθεσε ο χρήστης';
$string['privacy:metadata:glossary_entries:concept'] = 'Η έννοια της καταχώρησης που πρόσθεσε ο χρήστης';
$string['privacy:metadata:glossary_entries:definition'] = 'Ο ορισμός της καταχώρησης που πρόσθεσε ο χρήστης';
$string['privacy:metadata:glossary_entries:glossaryid'] = 'Το αναγνωριστικό της δραστηριότητας του γλωσσαρίου';
$string['privacy:metadata:glossary_entries:timemodified'] = 'Η χρονοσήμανση που δείχνει πότε η καταχώρηση γλωσσαρίου τροποποιήθηκε από τον χρήστη';
$string['privacy:metadata:glossary_entries:userid'] = 'Το αναγνωριστικό του χρήστη που προσθέτει αυτήν την καταχώρηση γλωσσαρίου';
$string['question'] = 'Ερώτηση';
$string['rejectedentries'] = 'Καταχωρήσεις που απορρίφθηκαν';
$string['rejectionrpt'] = 'Αναφορά απόρριψης';
$string['removeallglossarytags'] = 'Αφαίρεση όλων των ετικετών γλωσσαρίου';
$string['resetglossaries'] = 'Διαγραφή καταχωρήσεων από';
$string['resetglossariesall'] = 'Διαγραφή καταχωρήσεων από όλα τα γλωσσάρια';
$string['rssarticles'] = 'Αριθμός πρόσφατων άρθρων τροφοδοσίας RSS';
$string['rssarticles_help'] = 'Αυτή η ρύθμιση καθορίζει τον αριθμό των καταχωρήσεων εννοιών του γλωσσαρίου που θα συμπεριληφθούν στην RSS τροφοδοσία. Γενικά επιτρέπονται 5 με 20.';
$string['rsssubscriberss'] = 'Εμφάνιση της τροφοδοσίας RSS για «{$a}» έννοιες';
$string['rsstype'] = 'Τροφοδοσία RSS για αυτή τη δραστηριότητα';
$string['rsstype_help'] = 'Για να ενεργοποιήσετε την τροφοδοσία RSS για αυτήν τη δραστηριότητα, επιλέξτε είτε έννοιες με συγγραφέα ή έννοιες χωρίς συγγραφέα που θα συμπεριληφθούν στην τροφοδοσία.';
$string['search:activity'] = 'Πληροφορίες δραστηριότητας γλωσσαρίου';
$string['search:entry'] = 'Γλωσσάριο - καταχωρήσεις';
$string['searchindefinition'] = 'Αναζήτηση πλήρους κειμένου';
$string['secondaryglossary'] = 'Δευτερεύον γλωσσάριο';
$string['showall'] = 'Εμφάνιση συνδέσμου «ΟΛΑ»';
$string['showall_help'] = 'Εάν ενεργοποιηθεί, οι συμμετέχοντες μπορούν να περιηγηθούν σε όλες τις καταχωρήσεις ταυτόχρονα.';
$string['showalphabet'] = 'Εμφάνιση συνδέσμων αλφαβήτου';
$string['showalphabet_help'] = 'Αν ενεργοποιηθεί, οι συμμετέχοντες θα μπορούν να περιηγηθούν στο γλωσσάριο μέσω των γραμμάτων της αλφαβήτας.';
$string['showspecial'] = 'Εμφάνιση συνδέσμου «Ειδικά»';
$string['showspecial_help'] = 'Αν ενεργοποιηθεί, οι συμμετέχοντες θα μπορούν να περιηγούνται στο γλωσσάριο μέσω ειδικών χαρακτήρων, όπως @ και #.';
$string['sortby'] = 'Ταξινόμηση κατά';
$string['sortbycreation'] = 'Κατά ημερομηνία δημιουργίας';
$string['sortbylastupdate'] = 'Κατά τελευταία ενημέρωση';
$string['sortchronogically'] = 'Ταξινόμηση χρονολογικά';
$string['special'] = 'Ειδικά';
$string['standardview'] = 'Περιήγηση κατά αλφάβητο';
$string['studentcanpost'] = 'Οι μαθητές μπορούν να κάνουν καταχωρήσεις';
$string['tagarea_glossary_entries'] = 'Καταχωρήσεις γλωσσαρίου';
$string['tagsdeleted'] = 'Οι ετικέτες γλωσσαρίου διαγράφηκαν';
$string['totalentries'] = 'Συνολικές καταχωρήσεις';
$string['usedynalink'] = 'Αυτόματη δημιουργία συνδέσμων με τις καταχωρήσεις γλωσσαρίου';
$string['usedynalink_help'] = 'Αν η αυτόματη δημιουργία συνδέσμων με τις καταχωρήσεις γλωσσαρίου είναι ενεργοποιημένη σε όλο τον ιστότοπο από έναν διαχειριστή και αυτή η ρύθμιση είναι ενεργοποιημένη, τότε η φόρμα «Προσθήκη νέας καταχώρησης» περιλαμβάνει την επιλογή αυτόματης δημιουργίας συνδέσμων με την καταχώρηση οπουδήποτε οι λέξεις ή φράσεις της έννοιας εμφανίζονται σε όλο το υπόλοιπο του μαθήματος.';
$string['visibletabs'] = 'Ορατές καρτέλες';
$string['waitingapproval'] = 'Αναμένεται έγκριση';
$string['warningstudentcapost'] = '(Ισχύει μόνο εάν το γλωσσάριο δεν είναι το κύριο)';
$string['withauthor'] = 'Έννοιες με συγγραφέα';
$string['withoutauthor'] = 'Έννοιες χωρίς συγγραφέα';
$string['writtenby'] = 'από';
$string['youarenottheauthor'] = 'Δεν είσαστε ο συγγραφέας αυτού του σχολίου, άρα δε σας επιτρέπεται η επεξεργασία του.';
