<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_adaptable', language 'fr', version '4.0'.
 *
 * @package     theme_adaptable
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutme'] = 'À propos de moi';
$string['actingasrole'] = 'Vous agissez actuellement avec un rôle différent';
$string['activatetemplateoverride'] = 'Activer le remplacement de modèle pour « {$a} »';
$string['activatetemplateoverridedesc'] = 'Lorsqu\'elle est cochée, la valeur du paramètre « {$a->setting} » sera utilisée comme modèle « {$a->template} » si elle contient du texte.';
$string['activebreadcrumb'] = 'Couleur d\'arrière-plan du fil d\'ariane actif';
$string['activebreadcrumbdesc'] = 'Ce champ permet de définir la couleur d\'arrière-plan du fil d\'ariane actif.';
$string['activitiesheading'] = 'Activités';
$string['alertaccess'] = 'Visibilité de l\'alerte';
$string['alertaccessadmins'] = 'Visible pour les administrateurs';
$string['alertaccessdesc'] = 'Ce champ permet de définir les règles d\'accès pour la visibilité des alertes. Note : si vous utilisez « Ajouter une restriction pour le profil personnalisé », vous devez remplir le champ ci-dessous.';
$string['alertaccessglobal'] = 'Visible pour tout le monde';
$string['alertaccessprofile'] = 'Permet d\'ajouter une restriction pour le profil personnalisé';
$string['alertaccessusers'] = 'Visible pour les utilisateurs authentifiés';
$string['alertannounce'] = 'Annonces';
$string['alertannouncedesc'] = 'Afficher une annonce dans la fenêtre d\'alerte.';
$string['alertbackgroundcolorinfo'] = 'Info sur la couleur de fond';
$string['alertbackgroundcolorinfodesc'] = 'Couleur de fond des fenêtres d\'alerte de type Info.';
$string['alertbackgroundcolorsuccess'] = 'Couleur de fond de l\'annonce';
$string['alertbackgroundcolorsuccessdesc'] = 'Couleur de fond des fenêtres d\'alerte de type Annonce.';
$string['alertbackgroundcolorwarning'] = 'Couleur de fond des Avertissements';
$string['alertbackgroundcolorwarningdesc'] = 'Couleur de fond des fenêtres d\'alerte de type Avertissement.';
$string['alertbordercolorinfo'] = 'Info couleur de bordure';
$string['alertbordercolorinfodesc'] = 'Couleur de bordure des fenêtres d\'alerte de type Info.';
$string['alertbordercolorsuccess'] = 'Couleur de bordure des annonces';
$string['alertbordercolorsuccessdesc'] = 'Couleur de bordure des fenêtres d\'alerte de type Annonce.';
$string['alertbordercolorwarning'] = 'Couleur de bordure des Avertissements';
$string['alertbordercolorwarningdesc'] = 'Couleur de bordure des fenêtres d\'alerte de type Avertissement.';
$string['alertcolorinfo'] = 'Couleur des infos';
$string['alertcolorinfodesc'] = 'Couleur de l\'icône des fenêtres d\'alerte de type Info.';
$string['alertcolorsheading'] = 'Personnaliser le haut des fenêtres d\'alerte';
$string['alertcolorsheadingdesc'] = 'Définir les couleurs et icônes.';
$string['alertcolorsuccess'] = 'Couleur de l\'annonce';
$string['alertcolorsuccessdesc'] = 'Couleur de l\'icône des fenêtres d\'alerte de type Annonce.';
$string['alertcolorwarning'] = 'Couleurs des alertes';
$string['alertcolorwarningdesc'] = 'Couleur de l\'icône des fenêtres d\'alerte de type Avertissement.';
$string['alertcount'] = 'Nombre d\'alertes';
$string['alertcountdesc'] = 'Nombre d\'alertes à afficher';
$string['alertdesc'] = 'Saisir et personnaliser un texte à afficher comme alerte en haut du site. Il est possible de paramétrer plusieurs alertes pour cibler différents publics. Vous pouvez également afficher les alertes sur tout le site ou uniquement sur les pages d\'accueil.
<br /><br /><strong>Remarque :</strong> Il est maintenant possible d\'afficher des alertes dans les pages du cours pour avertir les enseignants que les cours sont cachés.';
$string['alertdisabled'] = 'Désactivé';
$string['alertdisabledesc'] = 'Désactiver cette alerte.';
$string['alerthiddencourse'] = 'Activer les alertes de cours';
$string['alerthiddencoursedesc'] = 'Afficher les alertes sur la page du cours.';
$string['alerthiddencoursetext-1'] = 'Ce cours est caché et n\'est pas accessible aux étudiants.';
$string['alerthiddencoursetext-2'] = 'Cliquez ici pour mettre à jour les paramètres';
$string['alerticoninfo'] = 'Icône d\'info';
$string['alerticoninfodesc'] = 'Définir <a href="https://fontawesome.com/icons">l\'icône de la Police Awesome</a> qui doit être utilisée dans les fenêtres d\'alerte de type Info. Entrer le nom de l\'icône sans son préfixe fa-.';
$string['alerticonsuccess'] = 'Icône d\'annonce';
$string['alerticonsuccessdesc'] = 'Définir <a href="https://fontawesome.com/icons">l\'icône de la Police Awesome</a> qui doit être utilisée dans les fenêtres d\'alerte de type Annonce. Entrer le nom de l\'icône sans son préfixe fa-.';
$string['alerticonwarning'] = 'Icône des Avertissements';
$string['alerticonwarningdesc'] = 'Définir <a href="https://fontawesome.com/icons">l\'icône de la Police Awesome</a> qui doit être utilisée dans les fenêtres d\'alerte de type Avertissement. Entrer le nom de l\'icône sans son préfixe fa-.';
$string['alertinfo'] = 'Info';
$string['alertinfodesc'] = 'Afficher une information dans la fenêtre d\'alerte.';
$string['alertkeyvalue'] = 'Code d\'alerte';
$string['alertkeyvalue_details'] = 'Code qui permet de distinguer cette alerte des alertes précédentes. Si vous le changez, tous les utilisateurs qui ont enlevé l\'alerte auparavant, la reverront. Si vous changez l\'alerte, changez ce code pour vous assurer que tous les utilisateurs la voient.';
$string['alertprofilefield'] = 'Champ pour le profil personnalisé Nom=Valeur (optionnel)';
$string['alertprofilefielddesc'] = 'Ajouter une règle d\'accès en créant un profil personnalisé. Exemple : « usertype=student »';
$string['alertsettings'] = 'Boîte d\'alerte {$a}';
$string['alertsettingscourse'] = 'Paramètres d\'alerte de cours';
$string['alertsettingsgeneral'] = 'Paramètres généraux des Alertes';
$string['alertsettingsheading'] = 'Personnaliser l\'alerte. Voir la configuration <a href="./../theme/adaptable/pix/layout.png" target="_blank">ici</a>';
$string['alerttext'] = 'Texte d\'alerte';
$string['alerttextdesc'] = 'Saisir le texte à afficher comme message d\'alerte';
$string['alerttype'] = 'Type de message d\'alerte';
$string['alerttypedesc'] = 'Indiquer le type d\'alerte : info (bleu), attention (jaune) ou annonces (vert).';
$string['alertwarning'] = 'Attention';
$string['alertwarningdesc'] = 'Afficher un avertissement dans la fenêtre d\'alerte.';
$string['analyticscount'] = 'Nombre de champs Analytics';
$string['analyticscountdesc'] = 'Nombre de champs Analytics à afficher dans la zone ci-dessous.';
$string['analyticsprofilefield'] = 'Champ pour le profil personnalisé. Nom=Valeur (optionnel)';
$string['analyticsprofilefielddesc'] = 'Ajouter une règle d\'accès en créant un profil personnalisé, exemple : « usertype=student »';
$string['analyticssettings'] = 'Analytics';
$string['analyticssettingsdesc'] = 'Vous pouvez configurer plusieurs codes pour Google Analytics et cibler des profils personnalisés. Vous pouvez aussi utiliser Matomo, un système de statistiques Open Source.';
$string['analyticssettingsheading'] = 'Configurer Google Analytics et/ou Matomo';
$string['analyticstext'] = 'ID Google Analytics';
$string['analyticstextdesc'] = 'Saisir l\'ID Google Analytics';
$string['anonymizega'] = 'Anonymiser l\'adresse IP de l\'utilisateur';
$string['anonymizegadesc'] = 'Anonymiser l\'adresse IP de l\'utilisateur envoyée à Google Analytics.';
$string['backcolor'] = 'Couleur d\'arrière-plan';
$string['backcolordesc'] = 'Ce champ permet de définir la couleur d\'arrière-plan.';
$string['bcustyle'] = 'Style BCU';
$string['beta'] = 'VERSION DE DÉVELOPPEMENT. NE PAS UTILISER SUR UN SITE EN PRODUCTION !!!';
$string['blockbackgroundcolor'] = 'Couleur d\'arrière-plan du bloc';
$string['blockbackgroundcolordesc'] = 'Ce champ permet de définir la couleur d\'arrière-plan pour tous les blocs';
$string['blockbordercolor'] = 'Couleur de bordure du bloc';
$string['blockbordercolordesc'] = 'Ce champ permet de définir la couleur de bordure du bloc';
$string['blockheaderbackgroundcolor'] = 'Couleur d\'arrière-plan pour l\'en-tête de bloc';
$string['blockheaderbackgroundcolordesc'] = 'Ce champ permet de définir la couleur d\'arrière-plan de l\'en-tête de tous les blocs.';
$string['blockheaderborderbottom'] = 'Épaisseur de la bordure du bas de l\'en-tête de bloc';
$string['blockheaderborderbottomdesc'] = 'Configurer l\'épaisseur de la bordure du bas des en-têtes de bloc.';
$string['blockheaderborderleft'] = 'Épaisseur de la bordure de gauche de l\'en-tête de bloc';
$string['blockheaderborderleftdesc'] = 'Configurer l\'épaisseur de la bordure de gauche des en-têtes de bloc.';
$string['blockheaderborderright'] = 'Épaisseur de la bordure de droite de l\'en-tête de bloc';
$string['blockheaderborderrightdesc'] = 'Configurer l\'épaisseur de la bordure de droite des en-têtes de bloc.';
$string['blockheaderbordertop'] = 'Épaisseur de la bordure du haut de l\'en-tête de bloc';
$string['blockheaderbordertopdesc'] = 'Configurer l\'épaisseur de la bordure du haut des en-têtes de bloc.';
$string['blockheaderbordertopstyle'] = 'Style de bordure de l\'en-tête de bloc';
$string['blockheaderbordertopstyledesc'] = 'Configurer le style de bordure des en-têtes de bloc.';
$string['blockheaderbottomradius'] = 'Rayon bas de l\'en-tête de bloc';
$string['blockheaderbottomradiusdesc'] = 'Configurer le rayon bas de l\'en-tête de bloc pour donner un effet arrondi.';
$string['blockheadercolor'] = 'Couleur de police de l\'en-tête de bloc';
$string['blockheadercolordesc'] = 'Ce champ permet de définir la couleur de police de l\'en-tête de bloc';
$string['blockheadertopradius'] = 'Rayon haut de l\'en-tête de bloc';
$string['blockheadertopradiusdesc'] = 'Configurer le rayon bas de l\'en-tête de bloc pour donner un effet arrondi.';
$string['blockicons'] = 'Icônes de bloc';
$string['blockiconsdesc'] = 'Activer pour afficher les icônes dans l\'en-tête du bloc';
$string['blockiconsheadersize'] = 'Taille de l\'icône des blocs d\'en-tête';
$string['blockiconsheadersizedesc'] = 'Définir la taille de l’icône de police utilisée dans l’en-tête des blocs Moodle. Sélectionner une valeur dans la liste.';
$string['blocklayoutbuilder'] = 'Zones de bloc de la page d\'accueil';
$string['blocklayoutbuilderdesc'] = 'CI-dessous vous pouvez déterminer la disposition des zones de bloc de la page d\'accueil.<br/> Pour ajouter du contenu dans ces zones, vous devez <strong>activer l\'édition sur la page d\'accueil de Moodle</strong>.
Vous pourrez ensuite glisser/déposer les blocs dans les zones créées.';
$string['blocklayoutlayoutcheck'] = 'Configurez la dispositions';
$string['blocklayoutlayoutcheckdesc'] = 'Utilisez l\'outil ci-dessous pour choisir le nombre de blocs à utiliser et voir la nouvelle disposition';
$string['blocklayoutlayoutcount1'] = 'Vous pouvez configurer un maximum de';
$string['blocklayoutlayoutcount2'] = 'zones de blocs. Vous en utilisez actuellement :';
$string['blocklayoutlayoutrow'] = 'Ligne de blocs';
$string['blocklayoutlayoutrowdesc'] = 'Ajouter / configurer la disposition de la ligne de blocs sur la page d\'accueil';
$string['blockmainborderbottom'] = 'Épaisseur de la bordure du bas du bloc principal';
$string['blockmainborderbottomdesc'] = 'Configurer l\'épaisseur de la bordure du bas du bloc principal.';
$string['blockmainborderleft'] = 'Épaisseur de la bordure gauche du bloc principal';
$string['blockmainborderleftdesc'] = 'Configurer l\'épaisseur de la bordure gauche du bloc principal.';
$string['blockmainborderright'] = 'Épaisseur de la bordure droite du bloc principal';
$string['blockmainborderrightdesc'] = 'Configurer l\'épaisseur de la bordure droite du bloc principal.';
$string['blockmainbordertop'] = 'Épaisseur de la bordure du haut du bloc principal';
$string['blockmainbordertopdesc'] = 'Configurer l\'épaisseur de la bordure du haut du bloc principal.';
$string['blockmainbordertopstyle'] = 'Style de bordure du bloc principal';
$string['blockmainbordertopstyledesc'] = 'Configurer le style de bordure du bloc principal.';
$string['blockmainbottomradius'] = 'Rayon bas du bloc principal';
$string['blockmainbottomradiusdesc'] = 'Paramétrer le rayon bas du bloc principal pour donner un effet courbe/arrondi.';
$string['blockmaintopradius'] = 'Rayon haut du bloc principal';
$string['blockmaintopradiusdesc'] = 'Paramétrer le rayon haut du bloc principal pour donner un effet courbe/arrondi.';
$string['blockregionbackground'] = 'Couleur d\'arrière-plan de la zone de blocs';
$string['blockregionbackgrounddesc'] = 'Couleur d\'arrière-plan de la zone de la page d\'accueil dans lequel se trouvent les blocs personnalisés.';
$string['blocksettings'] = 'Paramètres des blocs';
$string['blockside'] = 'Emplacement des blocs';
$string['blocksidedesc'] = 'Choisir si les blocs apparaissent à gauche ou à droite de la page.';
$string['breadcrumb'] = 'Fil d\'ariane';
$string['breadcrumbbackgroundcolor'] = 'Couleur d\'arrière-plan du fil d\'ariane';
$string['breadcrumbbackgroundcolordesc'] = 'Définissez la couleur d\'arrière-plan du fil d\'ariane';
$string['breadcrumbdisplay'] = 'Affichage du fil d\'ariane';
$string['breadcrumbdisplaydesc'] = 'Définissez l\'affichage de ce qui devrait être dans la zone de fil d\'Ariane d\'un cours.';
$string['breadcrumbhome'] = 'Accueil du fil d\'ariane';
$string['breadcrumbhomedesc'] = 'Définir l\'accueil du fil d\'Ariane sous forme d’icône ou de texte.';
$string['breadcrumbhomeicon'] = 'Icône';
$string['breadcrumbhometext'] = 'Texte';
$string['breadcrumbseparator'] = 'Séparateur du fil d\'ariane';
$string['breadcrumbseparatordesc'] = 'Définir <a href="https://fontawesome.com/icons">l\'icône de la Police Awesome</a> qui doit être utilisée comme séparateur dans le fil d’Ariane. Entrer le nom de l\'icône sans son préfixe fa-.';
$string['breadcrumbtextcolor'] = 'Couleur de texte du fil d\'ariane';
$string['breadcrumbtextcolordesc'] = 'Ce champ permet de définir la couleur de texte du fil d\'ariane.';
$string['breadcrumbtitle'] = 'Nom du cours dans le fil d\'ariane';
$string['breadcrumbtitledesc'] = 'Activez pour afficher le titre du cours dans le fil d\'ariane.';
$string['bs4all'] = 'Très petit - Très grand';
$string['bs4extralarge'] = 'Très grand uniquement';
$string['bs4large'] = 'Grand - Très grand';
$string['bs4medium'] = 'Moyen - Très grand';
$string['bs4none'] = 'Aucune';
$string['bs4small'] = 'Petit - Très grand';
$string['buttoncolor'] = 'Couleur de bouton';
$string['buttoncolorcancel'] = 'Couleur du bouton Annuler';
$string['buttoncolordesc'] = 'Couleur des principaux boutons utilisés à travers le site.';
$string['buttoncolordesccancel'] = 'Couleur d\'arrière-plan du bouton Annuler.<br />Taper transparent dans la zone pour un arrière-plan transparent.';
$string['buttoncolordescscnd'] = 'La couleur des boutons secondaires du site.';
$string['buttoncolorscnd'] = 'Couleur du bouton secondaire';
$string['buttondesc'] = 'Modifiez l\'apparence des boutons utilisés dans ce thème.';
$string['buttondropshadow'] = 'Décor d\'ombre portée au bas du bouton';
$string['buttondropshadowdesc'] = 'Affiche une ombre portée en bas du bouton.';
$string['buttonhovercolor'] = 'Couleur de bouton (lorsque survolé)';
$string['buttonhovercolorcancel'] = 'Couleur du bouton Annuler (lorsque survolé)';
$string['buttonhovercolordesc'] = 'Couleur prise par le bouton lorsqu\'il est survolé.';
$string['buttonhovercolordesccancel'] = 'Couleur d\'arrière-plan du bouton Annuler lorsque celui-ci est survolé.<br />Taper transparent dans la zone pour un arrière-plan transparent.';
$string['buttonhovercolordescscnd'] = 'La couleur du bouton secondaire lorsqu\'il est survolé.';
$string['buttonhovercolorscnd'] = 'Couleur du bouton secondaire (lorsque survolé)';
$string['buttonlogincolor'] = 'Couleur du bouton Connexion';
$string['buttonlogincolordesc'] = 'Couleur du bouton Connexion.';
$string['buttonloginheight'] = 'Configurer la hauteur du bouton Connexion.';
$string['buttonloginheightdesc'] = 'Valable seulement avec un formulaire de connexion dans l\'en-tête supérieur.';
$string['buttonloginhovercolor'] = 'Couleur du bouton Connexion au survol';
$string['buttonloginhovercolordesc'] = 'Couleur du bouton Connexion lorsqu\'il est survolé.';
$string['buttonloginmargintop'] = 'Configurer la marge haute du bouton Connexion';
$string['buttonloginmargintopdesc'] = 'Permettre de modifier l\'espacement / la position du bouton Connexion.';
$string['buttonloginpadding'] = 'Configurer la marge intérieure du bouton Connexion';
$string['buttonloginpaddingdesc'] = 'Chiffre plus élevé = bouton plus grand.';
$string['buttonlogintextcolor'] = 'Couleur de texte du bouton Connexion';
$string['buttonlogintextcolordesc'] = 'Couleur du texte du bouton Connexion';
$string['buttonradius'] = 'Configurer le rayon du bouton';
$string['buttonradiusdesc'] = 'Rayon élevé = boutons arrondis, rayon faible = boutons rectangulaires';
$string['buttonsettings'] = 'Boutons';
$string['buttonsettingsheading'] = 'Personnaliser les boutons du thème';
$string['buttontextcolor'] = 'Couleur de texte des boutons';
$string['buttontextcolorcancel'] = 'Couleur du texte du bouton Annuler';
$string['buttontextcolordesc'] = 'Couleur du texte des boutons';
$string['buttontextcolordesccancel'] = 'Couleur du texte des boutons d\'annulation.';
$string['buttontextcolordescscnd'] = 'Couleur du texte des boutons secondaires.';
$string['buttontextcolorscnd'] = 'Couleur du texte du bouton secondaire';
$string['categoryhavecustomheader'] = 'En-tête personnalisé de catégorie';
$string['categoryhavecustomheaderdesc'] = 'Sélectionnez les catégories de niveau supérieur qui auront un en-tête personnalisé. Pour en sélectionner plusieurs ou désélectionner une catégorie, utilisez la touche « Ctrl ». Enregistrer et actualiser la page pour la mettre à jour Remarque : les sous-catégories de la sélection hériteront des valeurs de réglage.';
$string['categoryheaderbgimage'] = 'Image d\'arrière-plan de la catégorie « {$a->name} » avec l\'ID « {$a->id} »';
$string['categoryheaderbgimagedesc'] = 'Définissez une image d\'arrière-plan pour la catégorie de niveau supérieur « {$a->name} » avec l\'ID « {$a->id} » dans l\'en-tête. La taille minimale est de 1600x180px (1900x180px recommandé). L\'image couvrira l\'en-tête complet.';
$string['categoryheaderbgimagedescchildren'] = 'Définissez une image d\'arrière-plan pour la catégorie de niveau supérieur « {$a->name} » avec l\'ID « {$a->id} »  et ses enfants « {$a->children} » dans l\'en-tête. La taille minimale est de 1600x180px (1900x180px recommandé). L\'image couvrira l\'en-tête complet.';
$string['categoryheadercustomcss'] = 'CSS personnalisé de la catégorie « {$a->name} » avec l\'ID « {$a->id} »';
$string['categoryheadercustomcssdesc'] = 'Définir le CSS personnalisé pour la catégorie de niveau supérieur « {$a->name} » avec l\'identifiant « {$a->id} ». Cela générera du CSS pour le sélecteur de thème préfixé par ".category-{$a->id}". Si le CSS ne semble pas être appliqué, vérifiez le fichier des logs de PHP.';
$string['categoryheadercustomcssdescchildren'] = 'Définir le CSS personnalisé pour la catégorie de niveau supérieur « {$a->name} » avec l\'identifiant « {$a->id} ». Cela générera du CSS pour le sélecteur de thème préfixé par ".category-{$a->id}". Si le CSS ne semble pas être appliqué, vérifiez le fichier des logs de PHP.';
$string['categoryheadercustomtitle'] = 'Titre personnalisé de la catégorie « {$a->name} » avec l\'ID « {$a->id} »';
$string['categoryheadercustomtitledesc'] = 'Définir le titre personnalisé pour la catégorie de niveau supérieur « {$a->name} » avec l\'identifiant « {$a->id} » dans l\'en-tête. Si ce champ est vide, ce qui a été configuré par les paramètres « sitetitle » et « sitetitletext » sur les pages hors cours ou sur les pages de cours lorsque « enableheading » est à « off » vous sera présenté. Lorsqu\'il est rempli sur des pages liées à des catégories autres que les cours, cela remplacera le titre du site. Lorsqu\'il est rempli sur les pages de cours, il apparaîtra au-dessus du titre tel qu\'établi par le paramètre « enableheading ». Mais sur les mobiles, tout « titre » n\'apparaîtra qu\'en fonction du paramètre « responsivecoursetitle ».';
$string['categoryheadercustomtitledescchildren'] = 'Définir le titre personnalisé pour la catégorie de niveau supérieur « {$a->name} » avec l\'identifiant « {$a->id} » et ses enfants « {$a->children} » dans l\'en-tête. Si ce champ est vide, ce qui a été configuré par les paramètres « sitetitle » et « sitetitletext » sur les pages hors cours ou sur les pages de cours lorsque « enableheading » est à « off » vous sera présenté. Lorsqu\'il est rempli sur des pages liées à des catégories autres que les cours, cela remplacera le titre du site. Lorsqu\'il est rempli sur les pages de cours, il apparaîtra au-dessus du titre tel qu\'établi par le paramètre « enableheading ». Mais sur les mobiles, tout « titre » n\'apparaîtra qu\'en fonction du paramètre « responsivecoursetitle ».';
$string['categoryheaderheader'] = 'Paramètres de la catégorie de niveau supérieur « {$a->name} » avec l\'ID « {$a->id} ».';
$string['categoryheaderheaderdesc'] = 'Définir les paramètres de la catégorie de niveau supérieur  « {$a->name} » avec l\'ID « {$a->id} ».';
$string['categoryheaderheaderdescchildren'] = 'Définir les paramètres de la catégorie de niveau supérieur  « {$a->name} » avec l\'ID « {$a->id} » et ses enfants « {$a->children} ».';
$string['categoryheaderlogo'] = 'logo personnalisé de la catégorie « {$a->name} » avec l\'ID « {$a->id} »';
$string['categoryheaderlogodesc'] = 'Définissez un logo pour la catégorie de niveau supérieur « {$a->name} » avec l\'ID « {$a->id} » dans l\'en-tête. La taille recommandée est de 200 pixels sur 80 pixels.';
$string['categoryheaderlogodescchildren'] = 'Définissez un logo pour la catégorie de niveau supérieur « {$a->name} » avec l\'ID « {$a->id} » et ses enfants « {$a->children} »  dans l\'en-tête. La taille recommandée est de 200 pixels sur 80 pixels.';
$string['categoryheaderssettings'] = 'En-têtes de catégorie';
$string['categoryheaderssettingsdesc'] = 'Définissez les paramètres des en-têtes d\'une catégorie.';
$string['categoryheaderssettingsheading'] = 'Modifiez l\'en-tête pour une ou plusieurs catégories de niveau supérieur et ci-dessous.';
$string['cdefaulticon'] = 'Icône par défaut de mes cours';
$string['cdefaulticondesc'] = 'L\'icône Font Awesome 4 sans le préfixe « fa- » à utiliser pour les cours lorsqu\'ils n\'ont pas déjà d\'icône. S\'il est vide, la valeur par défaut sera utilisée.';
$string['cfrozenicon'] = 'Icône de mes cours en lecture seule';
$string['cfrozenicondesc'] = 'L\'icône Font Awesome 4 sans le préfixe « fa- » à utiliser pour les cours en lecture seule. Si vide, celle par défaut sera utilisée.';
$string['chiddenicon'] = 'Icône de mes cours cachés';
$string['chiddenicondesc'] = 'L\'icône Font Awesome 4 sans le préfixe « fa- » à utiliser pour les cours cachés. Si vide, celle par défaut sera utilisée.';
$string['choosereadme'] = '<div class="clearfix">
<h2>Adaptable</h2>
<p><img class="img-polaroid" src="adaptable/pix/screenshot.png" /></p>
<h3>À propos</h3>
<p>Adaptable est un thème responsive en 2 colonnes très paramétrable et basé sur le thème populaire BCU. La version 2 et 3 utilise Boost en tant que thème de base et donc Bootstrap 4.</p>
<p>Ce thème est sous licence GPL (GNU General Public License) version 3. Vous trouverez un exemplaire complet de cette licence <a href="http://www.gnu.org/licenses/gpl-3.0.html" target="_blank">ici</a></p>
<br>
<h4>Modifiez-le ! - Améliorez-le ! - Partagez-le !</h4>
<br>
<p>Ce thème a été développé par :<br>
Gareth J Barnard (<a href="http://moodle.org/user/profile.php?id=442195" target="_blank">moodle.org/user/profile.php?id=442195</a>).
</p>
<p>Ce thème a été précédemment développé par :
<ul>
<li>Jeremy Hopkins (Coventry University).</li>
<li>Fernando Acedo (<a href="https://3-bits.com" target="_blank">3-bits.com</a>).</li>
<li>Manoj Solanki (Coventry University).</li>
</ul></p>
<h2> Autres crédits </ h2>
<p> Collaborateurs pour la version 2 :
<ul>
<li>Gareth J Barnard (<a href="http://moodle.org/user/profile.php?id=442195" target="_blank">moodle.org/user/profile.php?id=442195</a>).</li>
<li>Stuart Lamour.</li>
<li>Alistair Spark (University College London).</li>
</ul>
<p>et beaucoup d\'autres développeurs, testeurs, traducteurs et bénévoles (Voir <a href="adaptable/README.md" target="_blank">README.md</a>)</p>
<br>
<h3>Signalement de Bugs</h3>
<p>Vous pouvez signaler les bogues et les améliorations que vous souhaitez financer dans notre
« <a href="https://gitlab.com/jezhops/moodle-theme_adaptable/-/issues" target="_blank">dépôt</a> ».</p>
<br>
<h3>Support Technique</h3>
<p>Vous pouvez poser vos questions sur le forum Moodle :
<ul>
<li>Anglais : <a href="https://moodle.org/mod/forum/view.php?id=46" target="_blank">Themes forum</a>.</li>
</ul>
</div>';
$string['cneveraccessedicon'] = 'Icône de mes cours jamais consultés';
$string['cneveraccessedicondesc'] = 'L\'icône Font Awesome 4 sans le préfixe « fa- » à utiliser pour les cours auxquels l\'utilisateur est inscrit mais auquel il n\'y a pas accès. S\'il est vide, la valeur par défaut sera utilisée.';
$string['collapsedtopicscoloursenabled'] = 'Les sujets réduits permettent de basculer les paramètres de couleur d\'avant et d\'arrière plans';
$string['collapsedtopicscoloursenableddesc'] = 'Utilisez les paramètres de couleur de premier et d\'arrière-plan pour les rubriques réduites au lieu des paramètres « sectionheadingcolor » et « coursesectionheaderbg » d\'Adaptable.';
$string['colordesc'] = 'Vous pouvez choisir les couleurs que vous souhaitez utiliser dans tout le thème. Utilisez les codes HEX (hexadécimal) ou toute autre notation standard. Vous pouvez aussi utiliser les codes « transparent » et « inherited » (hériter) comme couleur.';
$string['colorsettings'] = 'Couleurs';
$string['colorsettingsheading'] = 'Ce champ permet de définir les couleurs principales utilisées dans le thème';
$string['configtabtitle'] = 'Réglages';
$string['configtitle'] = 'Adaptable';
$string['course'] = 'Cours';
$string['coursepageactivitybottomblockregionheading'] = 'Zone de bloc personnalisée du bas des activités du cours';
$string['coursepageactivitybottomblockregionheadingdesc'] = 'Une zone de bloc personnalisée qui apparaît après la fin des activités.';
$string['coursepageblockactivitybottomenabled'] = 'Activer la région du bloc inférieur de l\'activité du cours sur la page de cours';
$string['coursepageblockactivitybottomenableddesc'] = 'Activez cette région sur toutes les pages de cours';
$string['coursepageblocklayoutbuilder'] = 'Zones de bloc de la page des cours';
$string['coursepageblocklayoutbuilderdesc'] = 'Ci-dessous, vous pouvez créer votre propre mise en page pour les zones de blocs sur la page du cours.<br/>Pour ajouter du contenu dans ces zones, vous devez <strong> activer l\'édition sur la page de cours de Moodle </strong>.<br/>Ensuite, vous pourrez commencer à glisser/déposer des blocs dans les zones que vous créez !';
$string['coursepageblocklayoutlayoutbottomrow'] = 'Zone de bloc personnalisée du bas des pages du cours';
$string['coursepageblocklayoutlayoutbottomrowdesc'] = 'Ajouter/définir la disposition des lignes des zones de blocs sur les pages de cours.';
$string['coursepageblocklayoutlayouttoprow'] = 'Zone de bloc personnalisée du haut des pages du cours';
$string['coursepageblocklayoutlayouttoprowdesc'] = 'Ajouter/définir la mise en page pour la ligne de zone de bloc sur la page du cours.';
$string['coursepageblockregionsettings'] = 'Générateur de la zone de bloc de la page de cours';
$string['coursepageblocksenabled'] = 'Autoriser les zones de blocs personnalisées sur la page des cours';
$string['coursepageblocksenableddesc'] = 'Vous pouvez activer/désactiver les zones de blocs personnalisées (haut et bas) sur la page des cours. Vous pouvez glisser-déposer les blocs dans les zones que vous avez créées.';
$string['coursepageblocksliderenabled'] = 'Active la zone de bloc du diaporama sur la page des cours';
$string['coursepageblocksliderenableddesc'] = 'Active cette zone sur toutes les pages des cours.';
$string['coursepageheaderhidesitetitle'] = 'Cacher le nom du site sur les pages de cours';
$string['coursepageheaderhidesitetitledesc'] = 'Masquer le titre du site, le logo et la barre de recherche sur les pages du cours. Utilisez-le avec le paramètre de hauteur de l\'en-tête de la page pour afficher un en-tête plus petit sur les pages liées aux cours.';
$string['coursepagenewssliderblockregionheading'] = 'Zone de bloc des diaporamas d\'annonces personnalisées';
$string['coursepagenewssliderblockregionheadingdesc'] = 'Une zone personnalisée pour afficher le bloc contenant le diaporama d\'annonces, faisant partie du thème Adaptable. Cette zone apparaît au-dessus des activités de cours sur une page de cours. Pour ajouter ce bloc de diaporama, installez d\'abord le <strong> <a href="https://moodle.org/plugins/block_news_slider"> bloc d\'actualités du thème Adaptable </a> </strong> et configurez-le pour qu\'il apparaisse dans la zone « zone du diaporama de la page du cours » sur toutes les pages du cours.';
$string['coursepagesidebarinfooterenabled'] = 'Déplacer la barre latérale vers le pied de page sur la page du cours';
$string['coursepagesidebarinfooterenableddesc'] = 'Disposition large de la page de cours en déplaçant la barre latérale au pied de page.';
$string['coursepagesidebarinfooterenabledsection'] = 'Réglages communs';
$string['coursepagesidebarinfooterenabledsectiondesc'] = 'Réglages communs pour la plupart des formats de cours.';
$string['courses'] = 'Cours';
$string['coursesearch'] = 'Recherche de cours';
$string['coursesectionactivityassignbgcolor'] = 'Couleur de fond de l\'activité Devoir';
$string['coursesectionactivityassignbgcolordesc'] = 'Définir la couleur d\'arrière-plan de l\'activité Devoir. Taper <strong>transparent</strong> dans le champ pour le rendre transparent.';
$string['coursesectionactivityassignleftbordercolor'] = 'Couleur de la bordure gauche de l\'activité Devoir';
$string['coursesectionactivityassignleftbordercolordesc'] = 'Ce champ permet de définir la couleur de la bordure gauche.';
$string['coursesectionactivitybordercolor'] = 'Couleur de la bordure du bas des sections de cours';
$string['coursesectionactivitybordercolordesc'] = 'Ce champ permet de définir la couleur de la bordure basse des sections de cours';
$string['coursesectionactivityborderstyle'] = 'Style de la bordure du bas de la section du cours';
$string['coursesectionactivityborderstyledesc'] = 'Ce paramètre permet de définir le style de la bordure du bas de la section du cours.';
$string['coursesectionactivityborderwidth'] = 'Épaisseur de la bordure du bas des sections de cours';
$string['coursesectionactivityborderwidthdesc'] = 'Définissez la largeur de la bordure qui apparaît au bas d\'une activité de section de cours.';
$string['coursesectionactivitycolors'] = 'Options des sections de cours';
$string['coursesectionactivityforumbgcolor'] = 'Couleur de fond de l\'activité Forum';
$string['coursesectionactivityforumbgcolordesc'] = 'Définir la couleur d\'arrière-plan de l\'activité Forum. Taper <strong>transparent</strong> dans le champ pour le rendre transparent.';
$string['coursesectionactivityforumleftbordercolor'] = 'Couleur de la bordure gauche de l\'activité Forum';
$string['coursesectionactivityforumleftbordercolordesc'] = 'Ce champ permet de définir la couleur de la bordure gauche de l\'activité Forum.';
$string['coursesectionactivityheadingcolour'] = 'Couleur du titre de l\'activité de la section du cours';
$string['coursesectionactivityheadingcolourdesc'] = 'La couleur pour les activités cliquables affichées sur la page d\'accueil du cours.';
$string['coursesectionactivityiconsize'] = 'Taille de l\'icône d\'activité des sections du cours';
$string['coursesectionactivityiconsizedesc'] = 'Ce champ permet de définir la taille de l\'icône pour les activités/ressources (par exemple, la valeur de 16px le définira sur 16px x 16px).';
$string['coursesectionactivityleftborderwidth'] = 'Largeur de la bordure gauche de l\'activité de section de cours';
$string['coursesectionactivityleftborderwidthdesc'] = 'Définissez la largeur de la bordure qui apparaît à gauche d\'une activité de section de cours.';
$string['coursesectionactivitymarginbottom'] = 'Espacement des activités dans la marge inférieure.';
$string['coursesectionactivitymarginbottomdesc'] = 'Espacement entre les activités dans la marge inférieure.';
$string['coursesectionactivitymargintop'] = 'Espacement des activités dans la marge supérieure';
$string['coursesectionactivitymargintopdesc'] = 'Espacement entre les activités dans la marge supérieure.';
$string['coursesectionactivityquizbgcolor'] = 'Couleur de fond de l\'activité Test';
$string['coursesectionactivityquizbgcolordesc'] = 'Définir la couleur d\'arrière-plan de l\'activité Test. Taper <strong>transparent</strong> dans le champ pour le rendre transparent.';
$string['coursesectionactivityquizleftbordercolor'] = 'Couleur de la bordure gauche de l\'activité Questionnaire';
$string['coursesectionactivityquizleftbordercolordesc'] = 'Ce champ permet de définir la couleur de la bordure gauche de l\'activité Questionnaire';
$string['coursesectionbgcolor'] = 'Couleur de fond des sections de cours';
$string['coursesectionbgcolordesc'] = 'Ce champ permet de définir la couleur de fond des sections de cours';
$string['coursesectionbordercolor'] = 'Couleur de bordure des sections des cours';
$string['coursesectionbordercolordesc'] = 'Ce champ permet de définir la couleur de bordure des sections des cours.';
$string['coursesectionborderradius'] = 'Rayon des bordures des sections de cours';
$string['coursesectionborderradiusdesc'] = 'Configurer le rayon des bordures des sections de cours (coins arrondis)';
$string['coursesectionborderstyle'] = 'Style de bordure des sections de cours';
$string['coursesectionborderstyledesc'] = 'Configurer le style de bordure des sections de cours.';
$string['coursesectionborderwidth'] = 'Largeur de bordure des sections de cours';
$string['coursesectionborderwidthdesc'] = 'Configurer la largeur de bordure des sections de cours.';
$string['coursesectionheaderbg'] = 'Couleur d\'arrière-plan des en-têtes des sections de cours';
$string['coursesectionheaderbgdesc'] = 'Configurer la couleur d\'arrière-plan des en-têtes des sections de cours';
$string['coursesectionheaderbordercolor'] = 'Couleur de bordure des en-têtes des sections de cours';
$string['coursesectionheaderbordercolordesc'] = 'Ce champ permet de définir la couleur de bordure des en-têtes des sections de cours (seule la bordure du bas est utilisée puisque le conteneur extérieur a également une bordure)';
$string['coursesectionheaderborderradiusbottom'] = 'Rayon de la bordure du bas des en-têtes des sections de cours';
$string['coursesectionheaderborderradiusbottomdesc'] = 'Configurer la rayon de la bordure du bas des en-têtes des sections de cours (coins arrondis)';
$string['coursesectionheaderborderradiustop'] = 'Rayon de la bordure du haut des en-têtes des sections de cours';
$string['coursesectionheaderborderradiustopdesc'] = 'Configurer le rayon de la bordure du haut des en-têtes des sections de cours (coins arrondis).';
$string['coursesectionheaderborderstyle'] = 'Style de bordure des en-têtes des sections de cours';
$string['coursesectionheaderborderstyledesc'] = 'Configurer le style de bordure des en-têtes des sections de cours (seule la bordure du bas est utilisée puisque le conteneur extérieur a également une bordure).';
$string['coursesectionheaderborderwidth'] = 'Largeur de bordure des en-têtes des sections de cours';
$string['coursesectionheaderborderwidthdesc'] = 'Configurer la largeur de bordure des en-têtes des sections de cours (seule la bordure du bas est utilisée puisque le conteneur extérieur a également une bordure).';
$string['coursesections'] = 'Sections du cours';
$string['coursesettings'] = 'Formats de cours';
$string['coursesettingsdesc'] = 'Personnalisez les formats de cours Moodle les plus utilisés pour les adapter au thème principal.';
$string['coursesettingsheading'] = 'Paramètres des formats de cours';
$string['coursetitlefullname'] = 'Nom complet du cours';
$string['coursetitlemaxwidth'] = 'Largeur maximale du titre de cours';
$string['coursetitlemaxwidthdesc'] = 'Paramétrer le nombre maximal de caractères de la zone de titre de cours.';
$string['coursetitleshortname'] = 'Nom abrégé du cours / code';
$string['covbkcolor'] = 'Couleur d\'arrière-plan des titres des tuiles Coventry';
$string['covbkcolordesc'] = 'Ce champ permet de définir la couleur d\'arrière-plan des titres lorsque le rendu Tuiles Coventry est sélectionné.';
$string['coventrystyle'] = 'Style Coventry';
$string['covfontcolor'] = 'Couleur de police des titres des tuiles Coventry';
$string['covfontcolordesc'] = 'Ce champ permet de définir la couleur de police des titres lorsque le rendu Tuiles Coventry est sélectionné.';
$string['covhidebutton'] = 'Bouton de cours Tuiles Coventry';
$string['covhidebuttondesc'] = 'Cochez pour cacher le bouton du cours lorsque le rendu Tuiles Coventry est sélectionné.';
$string['currentcolor'] = 'Couleur de mise en valeur de la section de cours actuelle';
$string['currentcolordesc'] = 'Ce champ permet de définir la couleur de mise en valeur de la section de cours actuelle';
$string['customcoursesubtitle'] = 'Titre du cours personnalisé';
$string['customcoursesubtitledesc'] = 'Nom du champ personnalisé du profil utilisateur pour le titre du cours.';
$string['customcoursetitle'] = 'Titre du cours personnalisé';
$string['customcoursetitledesc'] = 'Nom du champ personnalisé du profil utilisateur pour le titre du cours.';
$string['customcss'] = 'CSS personnalisée';
$string['customcssdesc'] = 'Toute règle CSS ajoutée dans cette zone sera répercutée sur chaque page, facilitant la personnalisation de ce thème.';
$string['customcssjssettings'] = 'CSS et Javascript personnalisés';
$string['dangericoncolor'] = 'Couleur de l\'icône d\'avertissement';
$string['dangericoncolordesc'] = 'Définit la couleur de l\'icône d\'avertissement/danger principalement utilisée dans les champs obligatoires.';
$string['dashblocklayoutbuilder'] = 'Zones des blocs du tableau de bord';
$string['dashblocklayoutbuilderdesc'] = 'Ci-dessous, vous pouvez créer votre propre mise en page pour les zones de blocs dans le Tableau de bord.<br/>Pour ajouter du contenu à ces zones, vous devrez <strong> activer l\'édition, sur la page du tableau de bord de Moodle </strong>.<br/> Ensuite, vous pourrez faire glisser/déposer des blocs dans les zones que vous avez créées !';
$string['dashblocklayoutlayoutrow'] = 'Rangée de la zone du bloc du Tableau de bord';
$string['dashblocklayoutlayoutrowdesc'] = 'Ajoutez / définissez la disposition de la rangée du bloc région sur la page du tableau de bord';
$string['dashblocksabovecontent'] = 'Afficher le contenu principal ci-dessus';
$string['dashblocksbelowcontent'] = 'Afficher ci-dessous le contenu principal';
$string['dashblocksenabled'] = 'Activer la zone de bloc personnalisé sur la page du Tableau de bord';
$string['dashblocksenableddesc'] = 'Vous pouvez activer / désactiver les zones de blocs personnalisées dans le Tableau de bord. Vous pouvez ensuite glisser et déposer des blocs dans les zones que vous avez créées';
$string['dashblocksposition'] = 'Position de la région de bloc personnalisé';
$string['dashblockspositiondesc'] = 'Lorsque les zones de blocs personnalisées sont activées pour la page du tableau de bord, choisissez la position.';
$string['dashboardblockregionsettings'] = 'Générateur de zone de bloc de tableau de bord';
$string['dashed'] = 'Tiret';
$string['defaultzoom'] = 'Zoom par défaut';
$string['defaultzoomdesc'] = 'Taille d\'écran par défaut lorsque le zoom est désactivé ou que l\'utilisateur n\'a pas défini de préférence. Choisissez entre plein écran et largeur fixe.';
$string['deprecated'] = 'VERSION DE MOODLE OBSOLÈTE. NE PAS UTILISER LE THÈME ADAPTABLE SUR CE SITE !!!';
$string['dimmedtextcolor'] = 'Couleur du texte estompée';
$string['dimmedtextcolordesc'] = 'La classe CSS de texte estompé (dimmed_text) est utilisée par Moodle pour indiquer quand quelque chose est désactivé / non visible. Pour définir cette couleur dans le thème, utilisez le code html hexadécimal.';
$string['disablecustommenu'] = 'Désactiver le menu Moodle personnalisé';
$string['disablecustommenudesc'] = 'Désactiver les menus personnalisés Moodle dans la barre de navigation (';
$string['disabled'] = 'Désactivé';
$string['disablemenuscoursepages'] = 'Désactiver les menus sur les pages de cours';
$string['disablemenuscoursepagesdesc'] = 'Activer cette option limitera l\'affichage des menus aux pages de site, à la page d\'accueil, au tableau de bord etc; et ne les affichera pas dans les pages de cours';
$string['discardbuttontext'] = 'Effacer';
$string['displayeditingbuttontext'] = 'Éditer le texte du bouton';
$string['displayeditingbuttontextdesc'] = 'Afficher ou masquer le texte sur le bouton d\'édition. Remarque : s\'applique uniquement au bouton d\'édition du cours.';
$string['displaygrades'] = 'Afficher les notes';
$string['displaygradesdesc'] = 'Afficher l\'élément Notes dans le menu';
$string['displaylogin'] = 'Affichage connexion';
$string['displayloginbox'] = 'Menu de connexion';
$string['displayloginbutton'] = 'Bouton';
$string['displaylogindesc'] = 'Sélectionner comment s\'affiche la connexion dans l\'en-tête.';
$string['displayloginno'] = 'Pas de boîte de connexion';
$string['displayparticipants'] = 'Afficher les participants';
$string['displayparticipantsdesc'] = 'Afficher l\'item Participants dans le menu';
$string['dividingline'] = 'Ligne de séparation dans l\'en-tête';
$string['dividingline2'] = 'Ligne de séparation dans le pied de page';
$string['dividingline2desc'] = 'Couleur de la ligne de séparation du pied de page';
$string['dividinglinedesc'] = 'Couleur de la ligne de séparation de l\'en-tête';
$string['dotted'] = 'Pointillé';
$string['double'] = 'Double';
$string['editcognocourseupdate'] = 'Afficher la roue dentée / engrenage aux utilisateurs qui ne peuvent pas modifier de cours';
$string['editcognocourseupdatedesc'] = 'Afficher la roue dentée / engrenage aux utilisateurs qui ne disposent pas de la permission "moodle/course:update", c\'est-à-dire le rôle « Enseignant non éditeur ».';
$string['editfont'] = 'Couleur de police du bouton Editer et personnaliser cette page';
$string['editfontdesc'] = 'Configurer la couleur de police du bouton Editer et personnaliser cette page';
$string['edithorizontalpadding'] = 'Configurer l\'espacement horizontal des boutons d\'édition';
$string['editoffbk'] = 'Arrière-plan';
$string['editoffbkdesc'] = 'Configurer la couleur d\'arrière-plan du bouton Éditer et personnaliser cette page lorsqu\'il est désactivé';
$string['editonbk'] = 'Modifier et personnaliser l\'arrière-plan du bouton de la page';
$string['editonbkdesc'] = 'Configurer la couleur d\'arrière-plan du bouton Éditer et personnaliser ce bouton de page';
$string['editsettingsbutton'] = 'Modifier les paramètres et l\'affichage des boutons';
$string['editsettingsbuttondesc'] = 'Configurez ici ce qui doit apparaître dans la barre de navigation pour modifier les paramètres. Notez que ces options ne s\'appliquent pas aux pages pour lesquelles il n\'y a pas de paramètres associés, telles que la page de tableau de bord.';
$string['editsettingsbuttonshowbutton'] = 'Afficher le bouton d\'édition uniquement. Par exemple, Bouton « Activer la modification » sur la page du cours.';
$string['editsettingsbuttonshowcog'] = 'Afficher l’icône d\'édition des paramètres (icône d\'engrenage/roue dentée) uniquement.';
$string['editsettingsbuttonshowcogandbutton'] = 'Afficher les paramètres d\'édition icône et engrenage. Notez que cela prend plus de place dans la navigation.';
$string['emoticonsize'] = 'Tailles des emoticons';
$string['emoticonsizedesc'] = 'Définissez la hauteur et la largeur des emoticons de Moodle.';
$string['enableaccesstool'] = 'Outil d\'accessibilité';
$string['enableaccesstooldesc'] = 'Afficher un lien aux utilisateurs vers la page de préférences « Accessibilité ». Note : Requiert <a href="https://github.com/sharpchi/moodle-local_accessibilitytool" target="blank">Accessibility Tool Plugin</a>';
$string['enablealert'] = 'Activer la boîte d\'alerte {$a}';
$string['enablealertdesc'] = 'Activer la boîte d\'alerte {$a}.';
$string['enablealerts'] = 'Activer / désactiver les alertes';
$string['enablealertsdesc'] = 'Activer / désactiver les alertes sur le site, pas sur les cours, voir le paramètre "alerthiddencourse".';
$string['enablealertstriptags'] = 'Enlever automatiquement les balises HTML des alertes';
$string['enablealertstriptagsdesc'] = 'Activer pour nettoyer automatiquement les messages d\'alerte et désactiver pour utiliser du code HTML ou des liens dans les messages que vous devrez nettoyer manuellement en mode HTML.';
$string['enableanalytics'] = 'Activer Google Analytics';
$string['enableanalyticsdesc'] = 'Activer les paramètres de Google Analytics sur votre site.';
$string['enableavailablecourses'] = 'Afficher les « cours disponibles »';
$string['enableavailablecoursesdesc'] = 'Afficher le texte « Cours disponibles » sur la page d\'accueil';
$string['enablebadges'] = 'Badges';
$string['enablebadgesdesc'] = 'Affiche un lien vers les badges des utilisateurs';
$string['enableblog'] = 'Activez Mes blogs';
$string['enableblogdesc'] = 'Afficher un lien vers le blog des utilisateurs';
$string['enablecalendar'] = 'Calendrier utilisateur';
$string['enablecalendardesc'] = 'Afficher un lien vers les calendrier des utilisateurs';
$string['enablecompetencieslink'] = 'Lien Compétences';
$string['enablecompetencieslinkdesc'] = 'Afficher l\'option Compétences dans le menu « Cours actuel ». Note : « core_competency|enabled » doit être coché.';
$string['enablecoursesectionsdesc'] = 'Affichez un sous-menu dans le menu « Ce cours » contenant des liens vers chaque section affichée.';
$string['enabledtabbedprofileeditprofilelink'] = 'Activer le lien de modification du profil';
$string['enabledtabbedprofileeditprofilelinkdesc'] = 'Activez le lien de l\'onglet de modification du profil. Remarque : lorsque cette option est activée, elle s\'affiche uniquement si l\'utilisateur qui consulte a l\'autorisation de modifier le profil.';
$string['enabledtabbedprofileuserpreferenceslink'] = 'Activer le lien des préférences';
$string['enabledtabbedprofileuserpreferenceslinkdesc'] = 'Activez le lien des préférences du profil utilisateur dans les onglets.';
$string['enableeditprofile'] = 'Modifier le profil';
$string['enableeditprofiledesc'] = 'Afficher un lien pour modifier les profils utilisateurs';
$string['enableeventsdesc'] = 'Afficher un lien vers le calendrier';
$string['enablefeed'] = 'Mes feedback';
$string['enablefeeddesc'] = 'Affiche un lien vers la page « Mes feedback » - Note : cela nécessite le « <a href="https://moodle.org/plugins/report_myfeedback" target="blank">plugin My Feedback</a> ».';
$string['enablegrades'] = 'Notes';
$string['enablegradesdesc'] = 'Afficher un lien vers les notes des utilisateurs.';
$string['enableheading'] = 'Titre du cours dans l\'en-tête';
$string['enableheadingdesc'] = 'Activer ce mode pour afficher le titre du cours dans l\'en-tête lorsque l\'affichage du titre du site par défaut est activé.';
$string['enablehelp'] = 'Lien d\'aide « {$a->number} »';
$string['enablehelpdesc'] = 'Ajouter un lien d\'aide « {$a->number} » dans la barre de navigation';
$string['enablehomedesc'] = 'Afficher un lien sur la page d\'accueil';
$string['enablehomeredirect'] = 'Activer la redirection redirect=0';
$string['enablehomeredirectdesc'] = 'Activer redirect=0 sur l\'accueil. Utile sur les sites où « Mon Accueil » est la page d\'accueil par défaut. Cela évite aux utilisateurs qui cliquent sur le lien Accueil d\'être redirigés sur la page Mon Accueil/Tableau de bord.';
$string['enablemenus'] = 'Activer les menus';
$string['enablemenusdesc'] = 'Il est recommandé de laisser cette option désactivée si les menus ne sont pas utilisés pour des questions de performances';
$string['enablemy'] = 'Tableau de bord';
$string['enablemydesc'] = 'Afficher un lien vers la page Tableau de bord.';
$string['enablemyhomedesc'] = 'Afficher un lien vers {$a}.';
$string['enablemysitesdesc'] = 'Afficher une liste déroulante avec les cours des utilisateurs';
$string['enablemysitesrestriction'] = 'Restreindre le menu déroulant des cours utilisateurs à un champ personnalisé du profil';
$string['enablemysitesrestrictiondesc'] = 'Limiter le menu déroulant aux cours d\'un utilisateur avec le champ de profil personnalisé. Par exemple : usertype=staff.';
$string['enablenavbarwhenloggedout'] = 'Activer la barre de navigation lorsque vous êtes déconnecté';
$string['enablenavbarwhenloggedoutdesc'] = 'Affiche la barre de navigation même lorsque vous êtes déconnecté. Limité au menu Aide et Outils uniquement.';
$string['enablenote'] = 'Mes notifications';
$string['enablenotedesc'] = 'Afficher un lien vers la page de notifications de l\'utilisateur.';
$string['enableposts'] = 'Mes messages';
$string['enablepostsdesc'] = 'Afficher un lien vers la page Mes messages';
$string['enablepref'] = 'Mes préférences';
$string['enableprefdesc'] = 'Afficher un lien vers les pages de préférences de l\'utilisateur.';
$string['enableprivatefiles'] = 'Fichiers personnels';
$string['enableprivatefilesdesc'] = 'Afficher un lien vers les fichiers personnels de l\'utilisateur.';
$string['enableprofile'] = 'Profil de l\'utilisateur';
$string['enableprofiledesc'] = 'Afficher un lien vers le profil de l\'utilisateur.';
$string['enablesavecanceloverlay'] = 'Activer Enregistrer/Annuler la superposition sur les pages de paramètres';
$string['enablesavecanceloverlaydesc'] = 'Afficher l’incrustation d’un bouton Enregistrer/Annuler en haut d’une page de paramètres pour faciliter l’enregistrement des paramètres.';
$string['enableshowhideblocks'] = 'Activer Afficher/Masquer les blocs';
$string['enableshowhideblocksdesc'] = 'Autoriser les utilisateurs à afficher/masquer les blocs';
$string['enableshowhideblockstext'] = 'Afficher le texte des boutons Afficher Cacher';
$string['enableshowhideblockstextdesc'] = 'Affiche le texte à côté du bouton.';
$string['enabletabbedprofile'] = 'Activer les onglets sur le profil';
$string['enabletabbedprofiledesc'] = 'Activer l\'affichage des fonctionnalités en onglets sur le profil.';
$string['enablethiscoursedesc'] = 'Affiche un menu déroulant avec les activités du cours actuel.';
$string['enableticker'] = 'Activer le fil d\'informations sur la page d\'accueil ?';
$string['enabletickerc'] = 'Activer le fil d\'informations sur les pages internes ?';
$string['enabletickercdesc'] = 'Cocher pour activer le fil d\'informations sur les pages internes.';
$string['enabletickerdesc'] = 'Cocher pour activer le fil d\'informations sur la page d\'accueil';
$string['enabletickermy'] = 'Activer le fil d\'informations des nouvelles ?';
$string['enabletickermydesc'] = 'Cocher pour activer le fil d\'informations sur les pages Accueil / Tableau de bord.';
$string['enabletoolsmenus'] = 'Activer les menus Outils';
$string['enabletoolsmenusdesc'] = 'Il est recommandé de laisser cette option désactivée si les menus ne sont pas utilisés pour des questions de performances.';
$string['enablezoom'] = 'Activer le zoom';
$string['enablezoomdesc'] = 'Autoriser les utilisateurs à basculer entre le mode plein écran et largeur fixe.';
$string['enablezoomshowtext'] = 'Afficher le texte pour activer le zoom';
$string['enablezoomshowtextdesc'] = 'Affiche le texte à côté du bouton.';
$string['events'] = 'Événements';
$string['expandable'] = 'Extensible';
$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'Charger une favicon à utiliser sur le site';
$string['fontblockheadercolor'] = 'Couleur de la police de l\'en-tête des blocs';
$string['fontblockheadercolordesc'] = 'Définit la couleur de la police d\'en-tête des blocs Moodle, utilisez le code hexadécimal html. Notez que cela affecte également la couleur de l\'icône.';
$string['fontblockheadersize'] = 'Taille de la police de l\'en-tête des blocs';
$string['fontblockheadersizedesc'] = 'Définir la taille de la police utilisée dans l\'en-tête des blocs Moodle. Sélectionner une valeur dans la liste.';
$string['fontblockheaderweight'] = 'Poids de la police de l\'en-tête des Blocs';
$string['fontblockheaderweightdesc'] = 'Définir le poids de la police utilisée dans l\'en-tête des blocs Moodle. Sélectionner une valeur de 100 à 900 selon la police sélectionnée.';
$string['fontcolor'] = 'Couleur de police principale';
$string['fontcolordesc'] = 'Ce champ permet de définir la couleur de police du thème en utilisant le code HTML hexadécimal.';
$string['fontdefault'] = 'Défaut';
$string['fontdesc'] = 'Vous pouvez choisir la <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> que vous souhaitez utiliser dans le thème. Sélectionnez le sous-ensemble souhaité (latin toujours inclus) et saisissez l\'épaisseur de police ou la police ne sera pas affichée.';
$string['fontheadercolor'] = 'Couleur de police de l\'en-tête';
$string['fontheadercolordesc'] = 'Ce champ permet de définir la couleur de police des en-têtes du thème. Utiliser le code HTML hexadécimal.';
$string['fontheadername'] = 'Police d\'en-tête';
$string['fontheadernamedesc'] = 'Sélectionnez la police par défaut « sans-serif », ou la police <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> utilisée dans les en-têtes de bloc et les textes.';
$string['fontheaderweight'] = 'Épaisseur de la police des en-têtes';
$string['fontheaderweightdesc'] = 'Épaisseur de la police des en-têtes utilisée dans le site. Saisir une valeur entre 100 et 900 selon la police choisie.';
$string['fontname'] = 'Police principale';
$string['fontnamedesc'] = 'Sélectionner la police par défaut « sans-serif » ou la police <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> utilisée sur le site.';
$string['fontsettings'] = 'Polices';
$string['fontsettingsheading'] = 'Modifiez les polices utilisées dans le thème';
$string['fontsize'] = 'Taille de la police principale';
$string['fontsizedesc'] = 'Sélectionnez la taille de police par défaut (en pourcentage) utilisée sur l\'ensemble du site.';
$string['fontsubset'] = 'Sous-ensemble Google Fonts';
$string['fontsubsetdesc'] = 'Sélectionner un autre sous-ensemble de caractères que latin à appliquer à toutes les polices. Le sous-ensemble latin est déjà inclus par défaut.';
$string['fonttitlecolor'] = 'Couleur de la police du titre du site et des cours';
$string['fonttitlecolorcourse'] = 'Couleur de la police du titre des cours';
$string['fonttitlecolorcoursedesc'] = 'Ce champ permet de définir la couleur de police du titre des cours dans le thème, en utilisant le code HTML hexadécimal.';
$string['fonttitlecolordesc'] = 'Ce champ permet de définir la couleur de police du titre du site et du titre des cours dans le thème, en utilisant le code HTML hexadécimal.';
$string['fonttitlename'] = 'Police du titre des cours et du site';
$string['fonttitlenamedesc'] = 'Sélectionner la police par défaut « sans-serif » ou une police <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> utilisée pour le nom du site et des cours.';
$string['fonttitlesize'] = 'Taille de la police du titre du site et des cours';
$string['fonttitlesizedesc'] = 'Taille de police du titre du site et des cours utilisée dans le site. Sélectionner une valeur dans la liste.';
$string['fonttitleweight'] = 'Épaisseur de la police du titre du site et des cours';
$string['fonttitleweightdesc'] = 'Configurer l\'épaisseur de la police du titre du site et des cours. Saisir une valeur entre 100 et 900 selon la police choisie.';
$string['fontweight'] = 'Épaisseur de la police principale';
$string['fontweightdesc'] = 'Épaisseur de la police utilisée dans le site. Saisir une valeur entre 100 et 900 selon la police choisie.';
$string['footerbkcolor'] = 'Couleur d\'arrière-plan du pied de page';
$string['footerbkcolordesc'] = 'Ce champ permet de définir la couleur d\'arrière-plan du pied de page';
$string['footerblocksplacement'] = 'Emplacement des blocs de pied de page';
$string['footerblocksplacement1'] = 'Ensemble du site';
$string['footerblocksplacement2'] = 'Page d\'accueil uniquement';
$string['footerblocksplacement3'] = 'Jamais';
$string['footerblocksplacementdesc'] = 'Contrôler les endroits où les blocs du pied de page sont affichés. Par défaut sur l\'ensemble du site.';
$string['footercontent'] = 'Zone de contenu du pied de page';
$string['footercontentdesc'] = 'Ajouter du contenu à la zone du pied de page.';
$string['footerdesc'] = 'Ajouter un titre à la zone du pied de page.';
$string['footerheader'] = 'Titre de la zone du pied de page';
$string['footerlayoutrow'] = 'Paramétrage de la disposition du pied de page';
$string['footerlayoutrowdesc'] = 'Concevoir la disposition des blocs du pied de page';
$string['footerlinkcolor'] = 'Couleur des liens des blocs du pied de page';
$string['footerlinkcolordesc'] = 'Couleur des liens des blocs du pied de page';
$string['footersettings'] = 'Pied de page';
$string['footersettingsheading'] = 'Configurer le contenu qui apparait dans le pied de page. Voir la disposition <a href="./../theme/adaptable/pix/layout.png" target="_blank">ici</a>';
$string['footertextcolor'] = 'Couleur de texte du pied de page';
$string['footertextcolor2'] = 'Couleur de texte du pied de page inférieur';
$string['footertextcolor2desc'] = 'Couleur de texte du pied de page inférieur.';
$string['footertextcolordesc'] = 'Couleur de texte des zones du pied de page.';
$string['footnote'] = 'Note de bas de page';
$string['footnotedesc'] = 'Ajouter du texte au pied de page';
$string['forumbodybackgroundcolor'] = 'Couleur de fond du corps des messages du Forum';
$string['forumbodybackgroundcolordesc'] = 'Couleur de fond du corps des messages du Forum.';
$string['forumheaderbackgroundcolor'] = 'Couleur de fond de l\'en-tête des messages du Forum';
$string['forumheaderbackgroundcolordesc'] = 'Couleur de fond des messages du Forum.';
$string['frnt-footer'] = 'Les blocs situés dans cette zone seront uniquement visibles des administrateurs.';
$string['frontpagealertsettings'] = 'Boîte d\'alerte';
$string['frontpageblockregionsettings'] = 'Paramétrage des zones de blocs';
$string['frontpageblocksenabled'] = 'Activer les zones de blocs sur la page d\'accueil';
$string['frontpageblocksenableddesc'] = 'Vous pouvez activer / désactiver les régions de bloc personnalisées sur la page d\'accueil. Vous pouvez ensuite faire glisser et déposer des blocs dans les régions que vous avez créées.';
$string['frontpageblocksettings'] = 'Blocs Marketing';
$string['frontpagecoursesettings'] = 'Liste des cours de la page d\'accueil';
$string['frontpagedesc'] = 'Configurer la manière dont les cours sont affichés sur la page d\'accueil';
$string['frontpagemarketenabled'] = 'Activer les blocs Marketing';
$string['frontpagemarketenableddesc'] = 'Configurer les blocs Marketing sur la page d\'accueil.';
$string['frontpagemarketoption'] = 'Choisir le style pour les blocs Marketing';
$string['frontpagemarketoptiondesc'] = 'Vous pouvez appliquer différents styles aux blocs marketings. Remarque : le style BCU est conçu pour fonctionner avec des images en haut du bloc.';
$string['frontpagenumbertiles'] = 'Nombre de tuiles de cours par ligne';
$string['frontpagenumbertilesdesc'] = 'Nombre de tuiles de cours à afficher par ligne dans la liste des cours de la première page.';
$string['frontpagerenderer'] = 'Boîtes d\'affichage des cours sur la page d\'accueil';
$string['frontpagerendererdefaultimage'] = 'Image pour les cours par défaut';
$string['frontpagerendererdefaultimagedesc'] = 'L\'image par défaut utilisée lorsqu\'aucune image de cours n\'est trouvée, (valable uniquement pour le mode Tuiles avec superposition).';
$string['frontpagerendererdesc'] = 'Configure la manière dont les boîtes de cours sont affichées sur la page d\'accueil';
$string['frontpagerendereroption1'] = 'Tuiles';
$string['frontpagerendereroption2'] = 'Tuiles avec superposition';
$string['frontpagerendereroption3'] = 'Affichage Moodle par défaut';
$string['frontpagerendereroption4'] = 'Tuiles Coventry';
$string['frontpagesettingsheading'] = 'Présentation de la page d\'accueil';
$string['frontpageslidersettings'] = 'Diaporama de la page d\'accueil';
$string['frontpagetickersettings'] = 'Fil d\'informations de la page d\'accueil';
$string['frontpagetiles1'] = '1 tuile';
$string['frontpagetiles2'] = '2 tuiles';
$string['frontpagetiles3'] = '3 tuiles';
$string['frontpagetiles4'] = '4 tuiles';
$string['frontpagetiles6'] = '6 tuiles';
$string['frontpageuserblocksenabled'] = 'Activer la zone de blocs latérale sur la page d\'accueil pour les utilisateurs';
$string['frontpageuserblocksenableddesc'] = 'Vous pouvez activer / désactiver la zone de bloc des publications latérales sur la page d\'accueil pour les utilisateurs. Remarque : « Utilisateurs » signifie ici les utilisateurs invités et authentifiés. Les administrateurs verront toujours la zone.';
$string['fullscreen'] = 'Plein écran';
$string['fullscreenwidth'] = 'Largeur plein écran';
$string['fullscreenwidthdesc'] = 'Configurer la largeur maximum du thème lorsqu\'il est en mode plein écran / zoom.';
$string['future'] = 'Futur';
$string['gdprbutton'] = 'Bouton Résumé de la conservation des données';
$string['gdprbuttondesc'] = 'Afficher le bouton Résumé de la conservation des données dans le pied de page.';
$string['genericsettingsdescription'] = 'Ici, vous pouvez trouver différents paramètres pour ajouter votre propre code CSS et JavaScript au thème.';
$string['genericsettingsheading'] = 'Appliquer vos propres modifications';
$string['googleanalyticssettings'] = 'Google Analytics';
$string['googleanalyticssettingsdesc'] = 'Vous pouvez configurer plusieurs codes pour Google Analytics et les associer aux champs de profil utilisateur.';
$string['googleanalyticssettingsheading'] = 'Configurez Google Analytics pour votre site.';
$string['googlefonts'] = 'Polices Google';
$string['googlefontsdesc'] = 'Activez <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> pour les noms de police que vous indiquez, à l\'exception de « Défaut ». Lorsqu\'elle est « désactivée », vous avez la possibilité de fournir vous-même les polices via la modification CSS/thème ou de les avoir déjà installées sur les appareils des utilisateurs. Lorsqu\'elle est « activée », sélectionnez le sous-ensemble nécessaire (le latin est toujours inclus) et entrez le bon poids de police ou la police ne s\'affichera pas. <b>REMARQUE : Adaptable est sous licence GPLv3 et peut contenir des bogues, veuillez vérifier par vous-même que lorsqu\'elle est désactivée, les polices Google ne sont pas utilisées !</b>';
$string['headerbgimage'] = 'Image d\'arrière-plan';
$string['headerbgimagedesc'] = 'Définir une image d\'arrière-plan dans l\'en-tête. La taille minimale est 1600x180px (1900x180px recommandé). L\'image recouvre l\'en-tête complet. Vous pouvez ajouter une couleur dans la « Couleur de fond de l\'en-tête supérieur (Top) » ou utiliser <i> transparent </i> pour afficher l\'image d\'arrière-plan. Dans ce cas, modifier la couleur du texte pour l\'afficher correctement sur l\'image.';
$string['headerbkcolor'] = 'Couleur de fond de l\'en-tête supérieur';
$string['headerbkcolor2'] = 'Couleur de fond de l\'en-tête inférieur';
$string['headerbkcolor2desc'] = 'Définissez la couleur d\'arrière-plan de l\'en-tête inférieur. Notez que cela définit également la couleur de l’arrière-plan dans le style En-tête 2.';
$string['headerbkcolordesc'] = 'Ce champ permet de définir la couleur de fond de l\'en-tête supérieur (top).';
$string['headerdesc'] = 'Télécharger les favicon, logo, définir le formulaire de connexion dans l\'en-tête, réglez les titres dans l\'en-tête. <br /> Vous pouvez définir la taille et les styles de la police pour les titres dans la page de configuration des <a href="./../admin/settings.php?section=theme_adaptable_font">polices du thème</a>.';
$string['headernavbarhelpheading'] = 'Liens vers l\'aide et les options';
$string['headernavbarhelpheadingdesc'] = 'Options pour les liens du menu d\'aide';
$string['headernavbarmycoursesheading'] = 'Menu Mes cours';
$string['headernavbarmycoursesheadingdesc'] = 'Toutes les options du menu Mes cours (Mes sites) qui affiche la liste des cours de l\'utilisateur actuel';
$string['headernavbarthiscourseheading'] = 'Ce menu de cours';
$string['headernavbarthiscourseheadingdesc'] = 'Dans ce menu, l\'étudiant peut accéder directement à toutes les activités du cours, à la liste des participants et à ses notes.';
$string['headersearchandsocial'] = 'Chercher et réseaux sociaux dans l\'en-tête';
$string['headersearchandsocialdesc'] = 'Défini la position de la boîte de recherche et des icônes de réseaux sociaux dans l\'en-tête pour l\'en-tête de style 1.
Vous pouvez définir les icônes de réseaux sociaux depuis la page de paramètres <strong><a href="./../admin/settings.php?section=themesettingadaptable#theme_adaptable_social">Réseaux sociaux en en-tête</a> </strong>.';
$string['headersearchandsocialnone'] = 'Aucun';
$string['headersearchandsocialsearchheader'] = 'Chercher dans l\'en-tête';
$string['headersearchandsocialsearchmobilenav'] = 'Chercher dans l\'en-tête et sur la barre de navigation pour les mobiles';
$string['headersearchandsocialsearchnavbar'] = 'Chercher sur la barre de navigation';
$string['headersearchandsocialsearchnavbarsocialheader'] = 'Chercher sur la barre de navigation, réseaux sociaux dans l\'en-tête';
$string['headersearchandsocialsocialheader'] = 'Réseaux sociaux dans l\'en-tête';
$string['headersettings'] = 'En-tête';
$string['headersettingsheading'] = 'Personnaliser l\'en-tête de ce thème. Voir la mise en page <a href="./../theme/adaptable/pix/layout.png" target="_blank">ici</a>.';
$string['headerstyle'] = 'Style d\'en-tête';
$string['headerstyle1'] = 'En-tête 1 (en-tête d\'origine à 3 lignes)';
$string['headerstyle2'] = 'En-tête 2 (en-tête à 2 lignes)';
$string['headerstyledesc'] = 'Choisir le style de l\'en-tête. L\'en-tête 1 fait référence à l\'en-tête Adaptable d\'origine à 3 lignes. L\'en-tête 2 est un en-tête minimal de 2 lignes. Noter qu\'en cas d\'utilisation de l\'en-tête 2, le paramètre « Utiliser le champ de recherche ou les icônes sociales » utilisera toujours un champ de recherche.';
$string['headerstyleheading'] = 'Paramètres de style de l\'en-tête';
$string['headerstyleheadingdesc'] = 'Adaptable supporte deux types d\'en-têtes, l\'en-tête par défaut sur trois lignes et une autre plus récente et simple sur deux lignes.
Soyez conscient que vous <strong>ne pourrez plus</strong>, si vous passez à la nouvelle en-tête de deux lignes :<br />
<ol><li>Afficher les icônes des réseaux sociaux dans l\'en-tête</li><li>Afficher le logo du site sur téléphone</li></ol>';
$string['headertextcolor'] = 'Couleur du texte et des liens du bloc d\'en-tête supérieur';
$string['headertextcolordesc'] = 'Ce champ permet de définir la couleur du texte et des liens du bloc d\'en-tête supérieur (Top).';
$string['help'] = 'Aide';
$string['helplinkscount'] = 'Nombre de liens d\'aide';
$string['helplinkscountdesc'] = 'Définissez le nombre de liens d\'aide que vous souhaitez ajouter à la barre de navigation principale.';
$string['helplinktitle'] = 'Titre du lien d\'aide « {$a->number} »';
$string['helplinktitledesc'] = 'Le titre du lien d\'aide « {$a->number} » dans la barre de navigation. S\'il est vide, la valeur par défaut est « Help {$a->number} ».';
$string['helpprofilefield'] = 'Champ d\'aide « {$a->number} » du profil personnalisé (optionnel)';
$string['helpprofilefielddesc'] = 'Ajouter une règle d\'accès au lien d\'aide « {$a->number} » pour les champs de profil personnalisé, par ex : usertype=student.';
$string['helptarget'] = 'Cible de l\'aide';
$string['helptargetdesc'] = 'Voulez-vous que le lien d\'aide s\'ouvre dans une nouvelle fenêtre ?';
$string['helptitle'] = 'Aide {$a->number}';
$string['hiddencourses'] = 'Cours cachés';
$string['hiddenfromview'] = 'Masqué de la vue';
$string['hide'] = 'Cacher';
$string['hideblocks'] = 'Cacher les blocs';
$string['hidefootersocial'] = 'Afficher les icônes de réseaux sociaux';
$string['hidefootersocialdesc'] = 'Afficher les icônes de réseaux sociaux dans le pied de page sous les blocs.';
$string['hideinforum'] = 'Cacher l\'Aide et les Outils dans les forums';
$string['hideinforumdesc'] = 'Lorsque vous utilisez une largeur fixe et toutes les options du menu, la boîte de recherche du forum dépassera sur la ligne en dessous. L\'activation de cette option permet de masquer les outils et les éléments du menu d\'aide dans les forums, ce qui permet un affichage correct.';
$string['home'] = 'Accueil';
$string['homebk'] = 'Image de fond de la page d\'accueil';
$string['homebkdesc'] = 'Téléchargez l\'image qui s\'affichera en arrière-plan sur la page d\'accueil.';
$string['hvpcustomcss'] = 'CSS H5P personnalisé';
$string['hvpcustomcssdesc'] = 'CSS personnalisé pour le module H5P.';
$string['infobox'] = 'Fenêtre d\'info de la page d\'accueil';
$string['infobox2'] = 'Fenêtre d\'info secondaire de la page d\'accueil';
$string['infobox2desc'] = 'Fenêtre d\'info secondaire de la page d\'accueil (Voir le fichier <a href="./../theme/adaptable/README.txt" target="_blank">README</a> pour des informations et des conseils supplémentaires). <br><br><strong> Remarque : </strong> <i> Cet élément n\'est utilisé que pour la compatibilité avec BCU et sera supprimé dans les versions à venir.</i>';
$string['infoboxdesc'] = 'Bloc d\'info HTML de la page d\'accueil (Voir le fichier <a href="./../theme/adaptable/README.txt" target="_blank">README</a> pour des informations et des conseils supplémentaires).';
$string['infoboxfullscreen'] = 'Afficher la fenêtre d\'info en plein écran';
$string['infoboxfullscreendesc'] = 'Activer cette option affichera la fenêtre d\'info en plein écran';
$string['infoiconcolor'] = 'Couleur de l\'icône d\'Aide';
$string['infoiconcolordesc'] = 'Définissez la couleur de l\'icône info/aide utilisée par les info-bulles.';
$string['inprogress'] = 'En cours';
$string['introboxbackgroundcolor'] = 'Couleur d\'arrière-plan de la boîte d\'introduction';
$string['introboxbackgroundcolordesc'] = 'Couleur d\'arrière-plan de la boîte d\'introduction (description de l\'activité en surbrillance) utilisée dans les forums et autres activités';
$string['invalidcategorycss'] = 'CSS personnalisé de catégorie non valide pour la catégorie « {$a->topcatname} » avec l\'identifiant « {$a->topcatid} » : « {$a->css} ».';
$string['invalidcategorygeneratedcss'] = 'CSS personnalisé de catégorie non valide : « {$a->css} ».';
$string['jssection'] = 'Section Javascript';
$string['jssectiondesc'] = 'Ajouter du code Javascript à ce site.';
$string['jssectionrestricted'] = 'Section Javascript conditionnelle';
$string['jssectionrestricteddashboardonly'] = 'Inclure le Javascript uniquement sur la page du tableau de bord';
$string['jssectionrestricteddashboardonlydesc'] = 'Afficher le javascript uniquement sur la page du tableau de bord. Sinon, cela s\'affiche dans tout le site.';
$string['jssectionrestricteddesc'] = 'Ajoutez du code JavaScript au site de manière conditionnelle en fonction d\'un champ de profil personnalisé. Ce JavaScript n\'apparaîtra que si cette condition est remplie.';
$string['jssectionrestrictedprofilefield'] = 'Champ de profil personnalisé des sections JavaScript';
$string['jssectionrestrictedprofilefielddesc'] = 'Affichez le JavaScript ci-dessus UNIQUEMENT lorsque l\'utilisateur correspond à la valeur de ce champ de profil personnalisé, par exemple : faculty = fbl.';
$string['jumpto'] = 'Aller à…';
$string['landscape'] = 'Paysage';
$string['layoutaddcontent'] = 'Satisfait de votre mise en page ? Ajoutez maintenant du contenu à vos blocs :';
$string['layoutaddcontentdesc1'] = 'Vous avez configuré';
$string['layoutaddcontentdesc2'] = 'blocs marketing. Si vous êtes satisfait de cette disposition, ajoutez du contenu aux blocs ci-dessous. <br /> Sinon, utilisez le générateur de mise en page ci-dessus pour faire des changements.';
$string['layoutcheck'] = 'Vérifiez votre mise en page';
$string['layoutcheckdesc'] = 'Utilisez l\'outil ci-dessous pour vérifier le nombre de blocs que vous avez utilisé et avoir un aperçu de votre nouvelle mise en page.';
$string['layoutcount1'] = 'Vous pouvez définir un maximum de';
$string['layoutcount2'] = 'zones de blocs. Vous en utilisez actuellement :';
$string['layoutdesc'] = 'Définissez la mise en page par défaut que les utilisateurs voient.';
$string['layoutsettings'] = 'Mise en page';
$string['layoutsettingsheading'] = 'Contrôlez la présentation de la mise en page du site';
$string['leftblocks'] = 'Côté gauche';
$string['linkcolor'] = 'Couleur des liens';
$string['linkcolordesc'] = 'Ce champ permet de définir la couleur des liens dans le thème, utilisez le code hexadécimal HTML.';
$string['linkhover'] = 'Couleur de lien survolé';
$string['linkhoverdesc'] = 'Définissez la couleur des liens (survolés) dans le thème, utilisez le code hexadécimal HTML.';
$string['linksmenu'] = 'Menu des liens';
$string['loadingcolor'] = 'Couleur du chargement';
$string['loadingcolordesc'] = 'Couleur de la barre de chargement en haut de la page';
$string['loginbgimage'] = 'Image de fond';
$string['loginbgimagedesc'] = 'Ajoutez une image d\'arrière-plan à la page en taille réelle.';
$string['loginbgopacity'] = 'En-tête de page de connexion, barre de navigation, zone de connexion et opacité de l\'arrière-plan du pied de page lorsqu\'il existe une image d\'arrière-plan';
$string['loginbgopacitydesc'] = 'Opacité de l\'arrière-plan de connexion pour l\'en-tête, la barre de navigation, la zone de connexion et le pied de page lorsqu\'il y a une image d\'arrière-plan.';
$string['loginbgstyle'] = 'Style de fond de la page de connexion';
$string['loginbgstyledesc'] = 'Sélectionnez le style de l\'image téléchargée.';
$string['logindesc'] = 'Personnalisez la page de connexion en ajoutant un fond d’image et des textes, au-dessus et en dessous de la zone de connexion.';
$string['loginfooter'] = 'Pied de page à la connexion';
$string['loginfooterdesc'] = 'Afficher le pied de page à la connexion';
$string['loginheader'] = 'En-tête de la page à la connexion';
$string['loginheaderdesc'] = 'Afficher l\'en-tête de la page à la connexion.';
$string['loginplaceholder'] = 'Nom de l\'utilisateur';
$string['loginsettings'] = 'Page de connexion';
$string['loginsettingsheading'] = 'Personnalisez la page de connexion';
$string['logintextboxbottom'] = 'Zone de texte inférieure';
$string['logintextboxbottomdesc'] = 'Ajoutez un texte personnalisé sous la zone de connexion.';
$string['logintextboxtop'] = 'Zone de texte supérieure';
$string['logintextboxtopdesc'] = 'Ajoutez un texte personnalisé au-dessus de la zone de connexion.';
$string['logintextbutton'] = 'Connexion';
$string['logintextbuttonwhenoidc'] = 'Invité / Connexion manuelle';
$string['logintextmanualbutton'] = 'Tester la connexion au compte';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Téléchargez un logo à utiliser sur votre site. La taille recommandée est 200px x 80px.';
$string['maincolor'] = 'Couleur principale';
$string['maincolordesc'] = 'Couleur principale pour les blocs et pied de page.';
$string['maincoursepage'] = 'Page du cours principal';
$string['market'] = 'Bloc Marketing';
$string['marketblockbordercolor'] = 'Couleur de la bordure du bloc Marketing';
$string['marketblockbordercolordesc'] = 'Définir la couleur de la bordure du bloc Marketing.';
$string['marketblocksbackgroundcolor'] = 'Couleur de fond de la zone du bloc Marketing';
$string['marketblocksbackgroundcolordesc'] = 'Ce champ permet de définir la couleur de fond de la zone du bloc marketing.';
$string['marketdesc'] = 'Ajoutez du HTML dans le bloc Marketing (voir le fichier <a href="./../theme/adaptable/README.txt" target="_blank">README</a> pour des informations et des conseils supplémentaires).';
$string['marketingbuilderdesc'] = 'Utilisez l\'outil ci-dessous pour configurer vos blocs de marketing. Une fois définis, les paramètres du bloc apparaîtront plus loin dans la page.';
$string['marketingbuilderheading'] = 'Générateur de mise en page du bloc Marketing';
$string['marketingdesc'] = 'Vous pouvez utiliser deux styles différents de fenêtres d\'information pleine largeur. <br/>En plus, il existe un générateur de mise en page qui vous permet de décider du nombre de blocs dont vous avez besoin et de définir votre propre mise en page, voir le fichier <a href="./../theme/adaptable/README.txt" target="_blank">README</a> livré avec ce thème.';
$string['marketingsettings'] = 'Blocs Marketing';
$string['marketingsettingsheading'] = 'Personnalisez les blocs de marketing qui apparaissent sur la première page. Voir la mise en page <a href="./../theme/adaptable/pix/layout.png" target="_blank">ici</a>';
$string['marketlayoutrow'] = 'Ligne du bloc marketing';
$string['marketlayoutrowdesc'] = 'Ajoutez / définissez la disposition de la rangée du bloc Marketing sur la page d\'accueil';
$string['menubkcolor'] = 'Couleur de fond du menu principal';
$string['menubkcolordesc'] = 'Définir la couleur de fond du menu principal.';
$string['menubordercolor'] = 'Couleur de la bordure haute du menu principal';
$string['menubordercolordesc'] = 'Définir la couleur de la bordure haute du menu principal.';
$string['menufontcolor'] = 'Couleur de la police du menu principal';
$string['menufontcolordesc'] = 'Définir la couleur de la police du menu principal.';
$string['menufontpadding'] = 'Espacement des items de navigation';
$string['menufontpaddingdesc'] = 'Définissez l\'espacement des items dans la barre de navigation principale.';
$string['menufontsize'] = 'Taille de la police de la barre de navigation';
$string['menufontsizedesc'] = 'Définissez la taille de la police utilisée dans la barre de navigation principale.';
$string['menuhovercolor'] = 'Couleur de survol du menu principal';
$string['menuhovercolordesc'] = 'Définir la couleur de survol du menu principal.';
$string['menuoverrideprofilefield'] = 'Nom du champ de profil personnalisé';
$string['menuoverrideprofilefielddefault'] = 'Paramètres du menu du haut';
$string['menuoverrideprofilefielddesc'] = 'Nom du champ « liste », du profil personnalisé utilisé pour le remplacement par l\'utilisateur.';
$string['menusession'] = 'Stocker les infos d\'accès dans la session';
$string['menusessiondesc'] = 'Pour des raisons de performance, il est suggéré que cela soit activé. Vous voudrez peut-être le désactiver lors du test.';
$string['menusessionttl'] = 'Minutes pour stocker les règles d\'accès dans la session';
$string['menusessionttldesc'] = 'Nombre de minutes après lesquelles les règles d\'accès au menu sont actualisées dans la session des utilisateurs.';
$string['menusettings'] = 'Menus de l\'en-tête';
$string['menusettingsheading'] = 'Personnalisez les menus dans l\'en-tête supérieur de ce thème.';
$string['menusheading'] = 'Configurer la navigation pour les liens de menus dans l\'en-tête supérieur';
$string['menusheadingvisibility'] = 'Paramètres généraux pour la visibilité du menu principal (top)';
$string['menusheadingvisibilitydesc'] = 'Les paramètres suivants vous permettent de contrôler où apparaissent les menus et, en option, permettre aux utilisateurs de personnaliser leurs paramètres';
$string['menuslinkicon'] = 'Icône du menu Liens';
$string['menuslinkicondesc'] = 'Choisissez une icône personnalisée de la police font awesome.';
$string['menuslinkright'] = 'Affiche les liens de menus en haut à droite';
$string['menuslinkrightdesc'] = 'Si cette option est cochée, afficher le lien vers les menus en haut à côté du menu des message.';
$string['menustitledesc'] = 'Les menus d\'outils (navbar) et les menus supérieurs (en-tête supérieur) peuvent être restreints en fonction de champs de profil personnalisés (facultatif). Pour ajouter une restriction, entrer le nom du champ de profil et la valeur attendue. La structure du menu suit le format commun de Moodle :<br/><pre>
Moodle community|https://moodle.org
-Moodle free support|https://moodle.org/support
-Moodle development|https://moodle.org/development
--Moodle Docs|http://docs.moodle.org|Moodle Docs
--German Moodle Docs|http://docs.moodle.org/de|Documentation en Allemand|de
Moodle.com|http://moodle.com/
</pre>';
$string['menuuseroverride'] = 'Autoriser l\'utilisateur à modifier';
$string['menuuseroverridedesc'] = 'Ces paramètres peuvent être utilisés pour que les utilisateurs puissent contrôler l\'apparence des menus via un champ de profil personnalisé. Pour utiliser cette option, vous devrez créer un champ de profil personnalisé au format « liste » avec des valeurs dans l\'ordre correspondant :<br/>
<Pre> 1. Site (le premier élément de la liste sera pour la visibilité du menu sur l\'ensemble du site)
2. Pages d\'accueil uniquement (le deuxième élément de la liste définira la visibilité uniquement sur les sites / les pages d\'accueil)
3. Caché (la troisième valeur de la liste cachera les menus entièrement) </pre>
Vous ne devez PAS utiliser l\'option « Désactiver les menus sur les pages de cours » en conjonction avec les paramètres du champ de profil. Utilisez plutôt la valeur par défaut pour votre entrée « Pages d\'accueil uniquement » lors de la configuration de votre liste de champs de profil.

Remarque : Les utilisateurs devront se déconnecter de Moodle et s\'y reconnecter pour que les modifications prennent effet. Vous pouvez ajouter une note expliquant cela dans le champ de profil personnalisé.';
$string['messagepopupbackground'] = 'Couleur de fond des pop-up Messages';
$string['messagepopupbackgrounddesc'] = 'Définissez la couleur de fond des pop-up Messages.';
$string['messagepopupcolor'] = 'Couleur du texte des pop-up Messages';
$string['messagepopupcolordesc'] = 'Ce champ permet de définir la couleur du texte des en-têtes des pop-up Messages.';
$string['messagingbackgroundcolor'] = 'Couleur d\'arrière plan de la fenêtre principale des messages';
$string['messagingbackgroundcolordesc'] = 'Définit la couleur d\'arrière plan de la fenêtre principale des messages du Chat.';
$string['mobilemenubkcolor'] = 'Couleur de fond des menus mobile';
$string['mobilemenubkcolordesc'] = 'Définir la couleur de fond du menu principal sur les appareils mobiles (réduit).';
$string['mobileslidebartabbkcolor'] = 'Couleur d\'arrière-plan de l\'onglet';
$string['mobileslidebartabbkcolordesc'] = '.La couleur d\'arrière-plan de la barre latérale sur les appareils mobiles (réduite)';
$string['mobileslidebartabiconcolor'] = 'Couleur de l\'icône de l\'onglet';
$string['mobileslidebartabiconcolordesc'] = 'La couleur de l\'icône de la barre latérale sur les appareils mobiles (réduite).';
$string['moodledocs'] = 'Lien vers la doc Moodle';
$string['moodledocsdesc'] = 'Afficher le lien vers la doc Moodle dans le pied de page.';
$string['more'] = 'Plus';
$string['msgbadgecolor'] = 'Couleur de fond du message du badge';
$string['msgbadgecolordesc'] = 'Ce champ permet de définir la couleur d\'arrière-plan pour le badge / bulle de messages dans l\'en-tête (affiche le nombre de messages non lus)';
$string['myblogs'] = 'Mes blogs';
$string['mycoursesmenulimit'] = 'Limite du menu Mes cours';
$string['mycoursesmenulimitdesc'] = 'Ajuste le nombre maximum de cours qui apparaissent dans la liste déroulante Mes cours. 0 affichera tous les cours.';
$string['mysites'] = 'Mes cours';
$string['mysitesdisabled'] = 'Désactiver';
$string['mysitesexclude'] = 'Activer l\'exclusion des cours cachés';
$string['mysitesinclude'] = 'Activer l\'inclusion des cours cachés';
$string['mysitesmaxlength'] = 'Longueur maximale de Mes cours';
$string['mysitesmaxlengthdesc'] = 'Ajustez la longueur maximale des noms de cours dans la liste déroulante Mes cours pour optimiser votre police.';
$string['mysitesmenudisplay'] = 'Affichage du menu Mes Cours';
$string['mysitesmenudisplaydesc'] = 'Choisissez quel texte afficher pour un élément de menu et en survol.';
$string['mysitesmenudisplayfullnamefullnameonhover'] = 'Afficher le titre complet du cours et le titre complet en survol.';
$string['mysitesmenudisplayfullnamenohover'] = 'Afficher le titre complet du cours et pas de texte en survol.';
$string['mysitesmenudisplayshortcodefullnameonhover'] = 'Afficher le code court et le nom complet du cours en stationnaire.';
$string['mysitesmenudisplayshortcodenohover'] = 'Afficher le code court et aucun texte en survol.';
$string['mysitessortoverride'] = 'Activer le tri personnalisé pour Mes cours';
$string['mysitessortoverridedesc'] = 'Utilisez des champs de profil personnalisé ou des chaînes génériques (année, etc.) pour réduire les cours dans le sous-menu.';
$string['mysitessortoverridefield'] = 'Champs de profil personnalisé Mes Cours ou chaines';
$string['mysitessortoverridefielddesc'] = 'Liste délimitée par des virgules de champs ou de chaînes de profil pour vérifier les codes courts des cours.';
$string['mysitessortoverridelast'] = 'Date du dernier accédé ou de l\'inscription si jamais accédé';
$string['mysitessortoverridemyoverview'] = 'Utiliser la liste de mon aperçu';
$string['mysitessortoverrideoff'] = 'Afficher tous les cours inscrits en liste simple';
$string['mysitessortoverrideprofilefields'] = 'Afficher les cours trouvés dans les champs de profil dans la première liste, les autres dans le sous-menu';
$string['mysitessortoverrideprofilefieldscohort'] = 'Afficher les cours trouvés dans les champs de profil+cohortes dans la première liste, les autres dasn un sous menu';
$string['mysitessortoverridestrings'] = 'Afficher les chaînes contenant les inscriptions dans la première liste, les autres dans un sous-menu';
$string['navbarcachetime'] = 'Durée du cache de la barre de navigation';
$string['navbarcachetimedesc'] = 'Le nombre de minutes pendant lequel la barre de navigation est mise en cache.';
$string['navbardesc'] = 'Permet de contrôler tous les éléments qui apparaissent sur la barre de navigation.';
$string['navbardisplayicons'] = 'Icônes d\'affichage';
$string['navbardisplayiconsdesc'] = 'Afficher les icônes en regard des en-têtes du menu principal';
$string['navbardisplaysubmenuarrow'] = 'Afficher la flèche du sous-menu';
$string['navbardisplaysubmenuarrowdesc'] = 'Affiche la flèche du sous-menu (tournée vers le bas) lorsqu\'un en-tête de menu comporte des options de sous-menu.';
$string['navbardropdownborderradius'] = 'Rayon de la bordure du menu déroulant';
$string['navbardropdownborderradiusdesc'] = 'Contrôle le rayon de la bordure pour les menus déroulants (par exemple, des coins arrondis).';
$string['navbardropdownhovercolor'] = 'Couleur de survol du fond du menu déroulant';
$string['navbardropdownhovercolordesc'] = 'Couleur d\'arrière-plan du menu déroulant lorsque vous survolez des éléments de menu.';
$string['navbardropdowntextcolor'] = 'Couleur du texte du menu déroulant';
$string['navbardropdowntextcolordesc'] = 'Couleur du texte des éléments du menu déroulant.';
$string['navbardropdowntexthovercolor'] = 'Couleur de survol du texte du menu déroulant';
$string['navbardropdowntexthovercolordesc'] = 'Couleur du texte du menu déroulant lors du survol des éléments de menu.';
$string['navbardropdowntransitiontime'] = 'Durée de l\'effet de transition de la barre de navigation';
$string['navbardropdowntransitiontimedesc'] = 'Durée de l\'effet de transition de la barre de navigation en secondes. Fournit un effet d\'animation en fondu lors du survol d\'un menu comportant des sous-menus.';
$string['navbarlinksettingsdesc'] = 'Permet de contrôler les liens qui apparaissent sur la barre de navigation.';
$string['navbarlinksettingsheading'] = 'Personnaliser les liens de la barre de navigation';
$string['navbarlinkssettings'] = 'Liens de la barre de navigation';
$string['navbarmenusettings'] = 'Menu personnalisé de la barre de navigation';
$string['navbarmenusettingsdesc'] = 'Vous autorise à ajouter un menu à la barre de navigation.';
$string['navbarmenusettingsheading'] = 'Personnalisez le menu dans la barre de navigation. Voir la mise en page <a href="./../theme/adaptable/pix/layout.png" target="_blank">ici</a>.';
$string['navbarsettings'] = 'Paramètres de la barre de navigation';
$string['navbarsettingsheading'] = 'Personnaliser la barre de navigation';
$string['navbarstyles'] = 'Apparence de la barre de navigation';
$string['navbarstylesdesc'] = 'Permet de contrôler le style des éléments de la barre de navigation.';
$string['navbarstylesheading'] = 'Personnalisez le style de la barre de navigation';
$string['newmenu'] = 'Menu déroulant principal (top)';
$string['newmenu1trigger'] = 'Mot 1 d\'activation du menu déroulant principal';
$string['newmenu1triggerdesc'] = 'Définir un Mot 1 d\'activation du menu déroulant principal. La police d\'icône Awesome peut être utilisée.';
$string['newmenu2trigger'] = 'Mot 2 d\'activation du menu déroulant principal';
$string['newmenu2triggerdesc'] = 'Définir un Mot 2 d\'activation du menu déroulant principal. La police d\'icône Awesome peut être utilisée.';
$string['newmenudesc'] = 'Configurez les liens à afficher dans un menu d\'en-tête supérieur (top).';
$string['newmenufield'] = 'Champ de profil personnalisé Nom=valeur (optionnel)';
$string['newmenufielddesc'] = 'Ajouter la règle d\'accès à l\'aide du champ de profil personnalisé, par exemple : usertype = student.';
$string['newmenuheading'] = 'Menu principal (Top)';
$string['newmenurequirelogin'] = 'Nécessite d\'être connecté';
$string['newmenurequirelogindesc'] = 'Si activé, ce menu ne sera visible que pour les utilisateurs connectés.';
$string['newmenutitle'] = 'Titre du menu Top';
$string['newmenutitledefault'] = 'Menu';
$string['newmenutitledesc'] = 'Le titre de la liste déroulante qui apparaîtra dans l\'en-tête de votre site.';
$string['newstickercount'] = 'Nombre de nouvelles sections du fil d\'information';
$string['newstickercountdesc'] = 'Définir plusieurs sections du fil d\'information avec des règles d\'accès pour cibler différents publics.';
$string['nextactivity'] = 'Activité suivante';
$string['nextsection'] = 'Section suivante';
$string['noenrolments'] = 'Aucune inscription trouvée';
$string['none'] = 'Aucun';
$string['normal'] = 'Taille fixée';
$string['nostyle'] = 'Sans style';
$string['onetopicactivetabbackgroundcolor'] = 'Couleur d\'arrière-plan de l\'onglet actif';
$string['onetopicactivetabbackgroundcolordesc'] = 'La couleur d\'arrière-plan de l\'onglet actif d\'un cours « Sujet unique ».';
$string['onetopicactivetabtextcolor'] = 'Couleur du texte de l\'onglet actif';
$string['onetopicactivetabtextcolordesc'] = 'La couleur du texte de l\'onglet actif d\'un cours « Sujet unique ».';
$string['onetopicdesc'] = 'Personnalisez l\'apparence du format de cours à sujet unique « <a href="https://moodle.org/plugins/format_onetopic"></a> » (si utilisé sur votre site).';
$string['onetopicheading'] = 'Sujet unique';
$string['originaltemplatepreview'] = 'Aperçu du thème Original ou de remplacement';
$string['originaltemplatesource'] = 'Fichier source du thème Original ou de remplacement';
$string['overriddentemplate'] = 'Thème remplacé : {$a}';
$string['overriddentemplatedesc'] = 'S\'il est défini, le texte ici sera utilisé comme modèle « {$a} ». Pour garantir que l\'aperçu fonctionne, il doit y avoir l\'exemple de contexte standard au format JSON.';
$string['overriddentemplatenopreview'] = 'Aucun aperçu car le « JSON example » est absent';
$string['overriddentemplatepreview'] = 'Aperçu des paramètres remplacés';
$string['overridetemplate'] = 'Remplacer le modèle : {$a}';
$string['pageheaderalternative'] = 'En-tête';
$string['pageheaderheight'] = 'Hauteur de l\'en-tête de la page';
$string['pageheaderheightdesc'] = 'Définir la hauteur de la zone d\'en-tête principale (contenant le logo et les titres).';
$string['pageheaderlayout'] = 'Disposition de l\'en-tête de page';
$string['pageheaderlayoutdesc'] = 'La mise en page de l\'en-tête de page. N\'affecte que le style d\'en-tête un. Style d\'en-tête deux inchangé. Remarque : «Alternative» est sujet à changement sans préavis et est toujours en développement.';
$string['pageheaderlayouttwo'] = 'En-tête deux, mise en page de l\'en-tête de page';
$string['pageheaderlayouttwodesc'] = 'La disposition de l\'en-tête de page pour le style d\'en-tête deux.';
$string['pageheadernosearch'] = 'Aucune recherche';
$string['pageheaderoriginal'] = 'Original';
$string['passwordplaceholder'] = 'Mot de passe';
$string['past'] = 'Passé';
$string['pastcourses'] = 'Cours passés';
$string['people'] = 'Participants';
$string['piwikenabled'] = 'Activé';
$string['piwikenableddesc'] = 'Activer le suivi de Matomo pour Moodle.';
$string['piwikimagetrack'] = 'Suivi des images';
$string['piwikimagetrackdesc'] = 'Activer le suivi des images pour Moodle pour les navigateurs avec JavaScript désactivé.';
$string['piwiksettings'] = 'Matomo (anciennement Piwik) Analytics';
$string['piwiksettingsdesc'] = 'Générer une URL propre pour le suivi avancé.';
$string['piwiksettingsheading'] = 'Configuration Matomo';
$string['piwiksiteid'] = 'ID du site';
$string['piwiksiteiddesc'] = 'Entrez votre ID du site.';
$string['piwiksiteurl'] = 'URL de Matomo';
$string['piwiksiteurldesc'] = 'Entrer votre URL de Matomo Analytics sans http(s) ou slash à la fin (/).';
$string['piwiktrackadmin'] = 'Suivi des admins';
$string['piwiktrackadmindesc'] = 'Activer le suivi pour les administrateurs (non recommandé).';
$string['pluginname'] = 'Adaptable';
$string['portrait'] = 'Portrait';
$string['previousactivity'] = 'Activité précédente';
$string['previoussection'] = 'Section précédente';
$string['printbodyfontsize'] = 'Taille du corps de texte';
$string['printbodyfontsizedesc'] = 'Configurer la taille du corps de texte.';
$string['printlineheight'] = 'Hauteur de ligne';
$string['printlineheightdesc'] = 'Configurer la hauteur de ligne.';
$string['printmargin'] = 'Marges';
$string['printmargindesc'] = 'Configurer les marges extérieures.';
$string['printpageorientation'] = 'Orientation de la page';
$string['printpageorientationdesc'] = 'Configurer l\'orientation de la page à « Portrait » ou « Paysage ».';
$string['printsettings'] = 'Impression';
$string['printsettingsdesc'] = 'Configurer les paramètres d\'affichage lors de l\'impression d\'une page du site.';
$string['printsettingsheading'] = 'Paramètres d\'affichage d\'une impression';
$string['privacy:metadata'] = 'Adaptable n\'enregistre aucune donnée personnelle.';
$string['properties'] = 'Importer/exporter les paramètres';
$string['propertiesdesc'] = 'Dans cette section, vous pouvez importer / exporter les paramètres actuels du thème Adaptable (propriétés) au format JSON. Vous pouvez également afficher tous les paramètres actuels de cette plateforme Moodle.';
$string['propertiesexport'] = 'Exporte les propriétés dans une chaine JSON';
$string['propertiesproperty'] = 'Propriété';
$string['propertiesreturn'] = 'Retour';
$string['propertiessub'] = 'Paramètres actuels du thème';
$string['propertiesvalue'] = 'Valeur';
$string['putpropertiesadded'] = 'Ajouté :';
$string['putpropertieschanged'] = 'Modifié :';
$string['putpropertiesdesc'] = 'Collez la chaîne JSON et « Enregistrer les modifications ». Attention ! Ne valide pas les valeurs de réglage et vide tous les caches (« Purge all caches »).';
$string['putpropertiesfrom'] = 'depuis';
$string['putpropertiesheading'] = 'Importer les paramètres du thème';
$string['putpropertiesignorecti'] = '';
$string['putpropertiesignored'] = 'Ignoré :';
$string['putpropertiesname'] = 'Importer les propriétés';
$string['putpropertiesreportfiles'] = 'N\'oubliez pas de télécharger les fichiers suivants dans leurs paramètres :';
$string['putpropertiessettingsreport'] = 'Rapport de paramétrage :';
$string['putpropertiesunchanged'] = 'Inchangé :';
$string['putpropertiesvalue'] = '->';
$string['putpropertyour'] = 'Notre';
$string['putpropertyproperties'] = 'Propriétés';
$string['putpropertyreport'] = 'Rapport :';
$string['putpropertyversion'] = 'Version :';
$string['region-course-bottom-a'] = 'Zone 5 du bas de la page de cours';
$string['region-course-bottom-b'] = 'Zone 6 du bas de la page de cours';
$string['region-course-bottom-c'] = 'Zone 7 du bas de la page de cours';
$string['region-course-bottom-d'] = 'Zone 8 du bas de la page de cours';
$string['region-course-section-a'] = 'Zone inférieure de fin d\'activité de la page de cours';
$string['region-course-tab-one-a'] = 'Zone 1 de l\'onglet de la page du cours';
$string['region-course-tab-two-a'] = 'Zone 2 de l\'onglet de la page du cours';
$string['region-course-top-a'] = 'Zone 1 du haut de la page de cours';
$string['region-course-top-b'] = 'Zone 2 du haut de la page de cours';
$string['region-course-top-c'] = 'Zone 3 du haut de la page de cours';
$string['region-course-top-d'] = 'Zone 4 du haut de la page de cours';
$string['region-frnt-footer'] = 'Pied de page';
$string['region-frnt-market-a'] = 'Zone 1 de la page';
$string['region-frnt-market-b'] = 'Zone 2 de la page';
$string['region-frnt-market-c'] = 'Zone 3 de la page';
$string['region-frnt-market-d'] = 'Zone 4 de la page';
$string['region-frnt-market-e'] = 'Zone 5 de la page';
$string['region-frnt-market-f'] = 'Zone 6 de la page';
$string['region-frnt-market-g'] = 'Zone 7 de la page';
$string['region-frnt-market-h'] = 'Zone 8 de la page';
$string['region-frnt-market-i'] = 'Zone 9 de la page';
$string['region-frnt-market-j'] = 'Zone 10 de la page';
$string['region-frnt-market-k'] = 'Zone 11 de la page';
$string['region-frnt-market-l'] = 'Zone 12 de la page';
$string['region-frnt-market-m'] = 'Zone 13 de la page';
$string['region-frnt-market-n'] = 'Zone 14 de la page';
$string['region-frnt-market-o'] = 'Zone 15 de la page';
$string['region-frnt-market-p'] = 'Zone 16 de la page';
$string['region-frnt-market-q'] = 'Zone 17 de la page';
$string['region-frnt-market-r'] = 'Zone 18 de la page';
$string['region-frnt-market-s'] = 'Zone 19 de la page';
$string['region-frnt-market-t'] = 'Zone 20 de la page';
$string['region-my-tab-one-a'] = 'Zone 1 de l\'onglet de la page du tableau de bord';
$string['region-my-tab-two-a'] = 'Zone 2 de l\'onglet de la page du tableau de bord';
$string['region-news-slider-a'] = 'Emplacement du diaporama sur la page de cours';
$string['region-side-post'] = 'droite';
$string['region-side-pre'] = 'gauche';
$string['regionmaincolor'] = 'Couleur principale des zones';
$string['regionmaincolordesc'] = 'Ce champ permet de définir la couleur de fond des pages.';
$string['rendereroverlaycolor'] = 'Couleur de recouvrement';
$string['rendereroverlaycolordesc'] = 'Couleur du recouvrement, quand le rendu « tuiles w / recouvrement » est sélectionné.';
$string['rendereroverlayfontcolor'] = 'Couleur de recouvrement de la police';
$string['rendereroverlayfontcolordesc'] = 'Couleur de la police, quand on survole une zone de cours avec le rendu « tuiles w / recouvrement » sélectionné.';
$string['responsivebreadcrumb'] = 'Fil d\'Ariane';
$string['responsivebreadcrumbdesc'] = 'Sur quelles tailles d\'écran souhaitez-vous afficher le fil d\'Ariane ?';
$string['responsivecoursetitle'] = 'Nom du site / cours';
$string['responsivecoursetitledesc'] = 'Sur quelles tailles d\'écran souhaitez-vous afficher le nom du site / des cours ?';
$string['responsiveheader'] = 'En-tête principal';
$string['responsiveheaderdesc'] = 'Sur quelles tailles d\'écran souhaitez-vous afficher l\'en-tête principale ?<br/>
    Ce paramètre s\'applique uniquement si vous utilisez les 3 lignes par défaut de l\'en-tête.<br/>
    Enlever complètement l\'en-tête retirera également son contenu :<br/>
    <ul><li>Icônes des réseaux sociaux</li><li>Logo</li><li>Nom du site / cours</li></ul>';
$string['responsivelogo'] = 'Logo';
$string['responsivelogodesc'] = 'Sur quelles tailles d\'écran souhaitez-vous afficher le logo ?';
$string['responsivepagefooter'] = 'Pied de page';
$string['responsivepagefooterdesc'] = 'Sur quelles tailles d\'écran souhaitez-vous afficher le pied de page ?';
$string['responsivesectionnav'] = 'Navigation dans les activités / sections';
$string['responsivesectionnavdesc'] = 'Afficher / Masquer le <strong> texte </strong> pour la navigation dans les activités / sections « précédente » « suivante » sur les petits écrans.
        Par défaut, nous masquons ce texte sur des écrans plus petits afin que seules les icônes des liens <prev> <next> s\'affichent et pas le nom complet de la section / activité.';
$string['responsivesettings'] = 'Responsivité';
$string['responsivesettingsdesc'] = 'Vous pouvez contrôler ici le comportement réactif de votre site (quels éléments apparaissent sur des écrans de différentes tailles). <br/>
    Par défaut, la plupart des éléments non essentiels sont masqués sur les appareils mobiles, étant configurés pour n\'apparaître que sur des écrans plus grands. <br/>Vous pouvez faire apparaître des éléments sur des écrans plus petits en choisissant de les afficher sur « Très petits » ou « Petits écrans ». <br/>Pour mieux comprendre le fonctionnement de ces paramètres, veuillez consulter la documentation de Bootstrap 4 : <br/> <br/> https://getbootstrap.com/docs/4.5/utilities/display/ <br/> <br/>';
$string['responsivesettingsheading'] = 'Contrôler comment réagit le site selon des différentes tailles d\'écran';
$string['responsiveslider'] = 'Diaporama de la page d\'accueil';
$string['responsivesliderdesc'] = 'Sur quelles tailles d\'écran souhaitez-vous afficher le diaporama de la page d\'accueil ?';
$string['responsivesocial'] = 'Icônes des réseaux sociaux';
$string['responsivesocialdesc'] = 'Sur quelles tailles d\'écran souhaitez-vous afficher les icônes des réseaux sociaux ?';
$string['responsivesocialsize'] = 'Configurer la taille d\'icône des réseaux sociaux sur mobile';
$string['responsivesocialsizedesc'] = 'Pour un meilleur affichage, la taille doit être de 5px plus grande que la taille réelle désirée.';
$string['responsiveticker'] = 'Fil d\'informations';
$string['responsivetickerdesc'] = 'Sur quelles tailles d\'écran souhaitez-vous afficher le fil d\'informations ?';
$string['rightblocks'] = 'Côté droit';
$string['savebuttontext'] = 'Sauvegarder les modifications';
$string['searchboxpadding'] = 'Espacement de la zone recherche';
$string['searchboxpaddingdesc'] = 'Définir le remplissage au-dessus du champ de recherche (si utilisé au lieu d\'icônes sociales) par ex. 5px 10px 5px 10px (en haut, à droite, en bas, à gauche). <br> Vous pouvez définir des icônes sociales sous <a href="./../admin/settings.php?section=theme_adaptable_social">l\'en-tête social</a> de la page des paramètres</strong>.';
$string['sectionheadingcolor'] = 'Couleur du texte d\'en-tête des sections';
$string['sectionheadingcolordesc'] = 'Définir la couleur du texte d\'en-tête des sections.';
$string['sections'] = 'Sections';
$string['selectionbackground'] = 'Couleur de fond d\'un texte sélectionné';
$string['selectionbackgrounddesc'] = 'Définissez la couleur de fond quand un texte est sélectionné à l\'écran.';
$string['selectiontext'] = 'Couleur de sélection du texte';
$string['selectiontextdesc'] = 'Définissez la couleur du texte lorsqu\'il est sélectionné à l\'écran.';
$string['settingsalertbox'] = 'Boîte d\'alerte';
$string['settingsanalytics'] = 'Analytics';
$string['settingsblockicons'] = 'Icônes';
$string['settingsblocksgeneral'] = 'Général';
$string['settingsborders'] = 'Bordures';
$string['settingsbreadcrumbcolors'] = 'Couleurs du fil d\'ariane';
$string['settingscolors'] = 'Couleurs';
$string['settingscourses'] = 'Cours';
$string['settingsfonts'] = 'Polices';
$string['settingsfootercolors'] = 'Couleurs du pied de page';
$string['settingsforumheading'] = 'Forum';
$string['settingsheadercolors'] = 'Couleurs de l\'en-tête';
$string['settingsinfoboxcolors'] = 'Couleurs de la boîte d\'informations';
$string['settingsinformation'] = 'Information';
$string['settingsmaincolors'] = 'Couleurs principales';
$string['settingsmarketingcolors'] = 'Couleurs du bloc Marketing';
$string['settingsmessagescolors'] = 'Couleurs des messages pop-up';
$string['settingsmobilecolors'] = 'Couleurs Mobile';
$string['settingsnavbarcolors'] = 'Couleurs de la barre de navigation (navbar)';
$string['settingsoverlaycolors'] = 'Couleur de recouvrement des tuiles';
$string['settingssecondinfoboxcolors'] = 'Seconde couleur de la boîte d\'informations';
$string['settingstopicsweeks'] = 'Thèmes / Semaines';
$string['show'] = 'Afficher';
$string['showblocks'] = 'Afficher les blocs';
$string['showfooterblocks'] = 'Afficher les blocs de bas de page';
$string['showfooterblocksdesc'] = 'Afficher/cacher les 4 blocs paramétrables de bas de page.';
$string['shownavigationblockoncoursepage'] = 'Afficher le bloc de navigation sur la page de cours';
$string['shownavigationblockoncoursepagedesc'] = 'Configurer cette option pour afficher le bloc de navigation sur la page de cours.';
$string['showusername'] = 'Afficher le nom d\'utilisateur';
$string['showusernamedesc'] = 'Affiche le nom d\'utilisateur dans le menu utilisateur de la barre de navigation.';
$string['showyourprogress'] = 'Montrer l\'étiquette « Votre progression »';
$string['showyourprogressdesc'] = 'Afficher / masquer le libellé « Votre progression » en haut du contenu du cours. Cette étiquette est uniquement à des fins d\'information et peut être masquée.';
$string['side-post1'] = 'Barre latérale dans le pied de page';
$string['sidebaricon'] = 'Afficher / cacher la sidebar';
$string['sidebarnotlogged'] = 'Afficher la barre latérale lorsque vous n\'êtes pas connecté';
$string['sidebarnotloggeddesc'] = 'Afficher la barre latérale des blocs lorsque l\'utilisateur n\'est pas connecté.';
$string['sitelinkslabel'] = 'Liens du site';
$string['sitetitle'] = 'Afficher le nom du site';
$string['sitetitlecoursesdisabled'] = 'Désactivé - affiche uniquement les titres de cours dans les pages de cours';
$string['sitetitlecoursesenabled'] = 'Activé - affiche le titre du site et les titres des cours dans les pages du cours';
$string['sitetitlecustom'] = 'Utiliser un titre de site personnalisé (entrer (entrez dans la case "sitetitletext" ci-dessous)';
$string['sitetitledefault'] = 'Utilisez le titre du site Moodle (nom du site)';
$string['sitetitledesc'] = 'Affichez le titre du site Moodle par défaut à partir des <a href="./../admin/settings.php?section=frontpagesettings" target="_blank"> Paramètres de la page d\'accueil </a> ou saisissez un titre de site personnalisé dans la zone de texte en dessous.';
$string['sitetitleoff'] = 'Désactiver le titre du site';
$string['sitetitletext'] = 'Titre du site';
$string['sitetitletextdesc'] = 'Titre du site affiché dans l\'en-tête. Vous pouvez utiliser n\'importe quelle balise HTML et appliquer des styles en ligne. Il est recommandé d\'utiliser une balise HTML H1 autour du titre, au lieu de la balise P qui est ajoutée par défaut lorsque vous tapez quelque chose dans ce champ.';
$string['slider2h3bgcolor'] = 'Couleur de fond de la balise H3 du diaporama 2';
$string['slider2h3bgcolordesc'] = 'Ce champ permet de définir la couleur d\'arrière plan de la balise H3 du diaporama 2.';
$string['slider2h3color'] = 'Couleur du texte de la balise H3 du diaporama 2';
$string['slider2h3colordesc'] = 'Définir la couleur du texte de la balise H3 du diaporama 2.';
$string['slider2h4bgcolor'] = 'Couleur d\'arrière-plan de la balise H4 du diaporama 2';
$string['slider2h4bgcolordesc'] = 'Définir la couleur d\'arrière-plan pour la balise H4 du diaporama 2.';
$string['slider2h4color'] = 'Couleur du texte de la balise H4 du diaporama 2';
$string['slider2h4colordesc'] = 'Définir la couleur du texte de la balise H4 du diaporama 2.';
$string['slidercaption'] = 'Légende du diaporama';
$string['slidercaptiondesc'] = 'Ajouter une légende pour votre diapositive';
$string['slidercount'] = 'Compteur de diaporama';
$string['slidercountdesc'] = 'Sélectionner le nombre de diapositives que vous souhaitez ajouter <strong> puis cliquez sur Enregistrer </strong> pour sauvegarder les champs saisis.';
$string['sliderenabled'] = 'Activer le diaporama';
$string['sliderenableddesc'] = 'Activer le diaporama en haut de votre page d\'accueil.';
$string['sliderfullscreen'] = 'Diaporama plein écran';
$string['sliderfullscreendesc'] = 'Cocher cette case pour afficher le diaporama en plein écran (largeur 100%).';
$string['sliderh3color'] = 'Couleur de la balise H3 du diaporama 1';
$string['sliderh3colordesc'] = 'Définir la couleur de la balise H3 du diaporama 1.';
$string['sliderh4color'] = 'Couleur de la balise H4 du diaporama 1';
$string['sliderh4colordesc'] = 'Définir la couleur de la balise H4 du diaporama 1.';
$string['sliderimage'] = 'Image du diaporama';
$string['sliderimagedesc'] = 'Ajouter une image pour votre diapositive. La taille recommandée est 1600px x 400px ou plus.';
$string['slidermarginbottom'] = 'Marge sous le diaporama';
$string['slidermarginbottomdesc'] = 'Définissez la taille de la marge sous le diaporama.';
$string['slidermargintop'] = 'Marge au dessus du diaporama';
$string['slidermargintopdesc'] = 'Définissez la taille de la marge au dessus du diaporama.';
$string['slideroption2'] = 'Choisir le type de diaporama';
$string['slideroption2a'] = 'Couleur de fond de la flèche de l\'option style 2 du diaporama';
$string['slideroption2adesc'] = 'Définir la couleur de fond de la flèche de l\'option style 2 du diaporama';
$string['slideroption2color'] = 'Fond de la zone Soumettre du diaporama 2';
$string['slideroption2colordesc'] = 'Définir la couleur d\'arrière-plan pour le texte envoyé dans l\'option style du diaporama.';
$string['slideroption2desc'] = 'Choisir le type de diaporama, <strong> puis cliquer sur Enregistrer</strong> pour voir les paramètres de couleur du diaporama choisi.';
$string['slideroption2snippet'] = '<p>Exemple de texte en HTML pour les légendes de diaporama :</p>
<pre>
<div class="span6 col-sm-6">
<h3>fait main</h3><h4>Pixels et code pour la communauté Moodle.</h4>
<a href="#" class="submit">Veuillez soutenir notre thème !</a>
</pre>';
$string['slideroption2submitcolor'] = 'Texte du diaporama 2 envoyé';
$string['slideroption2submitcolordesc'] = 'Définir une couleur de fond pour le texte envoyé dans l\'option de couleur du style 2 du diaporama.';
$string['sliderstyle1'] = 'Style 1 du diaporama';
$string['sliderstyle2'] = 'Style 2 du diaporama';
$string['slidersubmitbgcolor'] = 'Couleur de fond du bouton Envoyer du diaporama 1';
$string['slidersubmitbgcolordesc'] = 'Choisir la couleur d\'arrière-plan du bouton « Envoyer » du diaporama 1';
$string['slidersubmitcolor'] = 'Texte du bouton Envoyer du diaporama 1';
$string['slidersubmitcolordesc'] = 'Définir la couleur du texte du bouton « Envoyer » du diaporama 1.';
$string['sliderurl'] = 'Lien URL de la diapositive';
$string['sliderurldesc'] = 'Ajoutez une URL vers laquelle votre diapositive se connecte lorsque vous cliquez dessus.';
$string['slideshowdesc'] = 'Téléchargez les images, ajoutez les liens et la description du carrousel sur la première page.';
$string['slideshowsettings'] = 'Diaporama';
$string['slideshowsettingsheading'] = 'Personnalisez le carrousel sur la première page. Voir la mise en page <a href="./../theme/adaptable/pix/layout.png" target="_blank">ici</a>';
$string['slight'] = 'Léger';
$string['socialheading'] = 'Paramètres des icônes de réseaux sociaux';
$string['socialicondesc'] = 'Définir l\'icône de la police Awesome, par exemple : fa-facebook.';
$string['socialiconlist'] = 'Liste des icônes de réseaux sociaux';
$string['socialiconlistdesc'] = 'Entrer une liste délimitée pour configurer les icônes / liens sociaux dont vous avez besoin en utilisant le format : url|title|icon.';
$string['socialpaddingside'] = 'Ajuster la marge intérieure du bord des icônes des réseaux sociaux';
$string['socialpaddingsidedesc'] = 'Ce sera l\'espace entre l\'icône et un autre élément ou l\'écart entre deux icônes. c\'est-à-dire que l\'espacement autour de l\'icône sera cette valeur divisée par deux. La valeur par défaut suit les directives de marque Instagram.';
$string['socialpaddingtop'] = 'Ajuster l\'espacement au-dessus des icônes des réseaux sociaux (modifie la position verticale)';
$string['socialpaddingtopdesc'] = 'Ce sera le minimum de 15 px (défini à l\'aide de la marge) plus cette valeur.';
$string['socialsearchicon'] = 'Recherche Moodle';
$string['socialsearchicondesc'] = 'Permet de mettre un lien de recherche aux côtés d\'icônes de réseau social (en utilisant la boîte de recherche désactivée sur le site du réseau social).';
$string['socialsettings'] = 'Réseaux sociaux en en-tête';
$string['socialsize'] = 'Définissez la taille de la police des icônes des réseaux sociaux';
$string['socialsizedesc'] = 'Pour une meilleure vue, la taille doit être supérieure de 5 pixels à la taille réelle souhaitée.';
$string['socialtarget'] = 'Cible d\'ouverture des liens vers les réseaux sociaux';
$string['socialtargetdesc'] = 'Comment s\'ouvriront les liens vers les réseaux sociaux (même ou nouvelle fenêtre).';
$string['socialtitledesc'] = 'Vous pouvez désactiver la zone de recherche du site et activer les icônes/liens vers les réseaux sociaux à la place.<br/>
Pour configurer les icônes, entrez une liste délimitée dans le champ « Liste des icônes réseaux sociaux » ci-dessous.<br/>
Cela devrait être dans le format :

url|title|icon

Par exemple :
<pre>
https://example.com/course/search.php|Search Moodle|fa-search
https://facebook.com/|Facebook|fa-facebook-square
https://twitter.com/|Twitter|fa-twitter-square
https://instagram.com|Instagram|fa-instagram
https://example.com|My Web|fa-globe
</pre>
Vous trouverez la liste complète des icônes de la police Awesome<a href="https://fontawesome.com/icons">ici</a>.';
$string['socialwall'] = 'Mur social';
$string['socialwallactionlinkcolor'] = 'Couleur de lien actif';
$string['socialwallactionlinkcolordesc'] = 'Couleur des liens du Mur social.';
$string['socialwallactionlinkhovercolor'] = 'Couleur de lien actif survolé';
$string['socialwallactionlinkhovercolordesc'] = 'Couleur des liens survolés du Mur social.';
$string['socialwallbackgroundcolor'] = 'Couleur de fond du mur social';
$string['socialwallbackgroundcolordesc'] = 'Définir la couleur de fond du Mur social.';
$string['socialwallbordercolor'] = 'Couleur de la bordure';
$string['socialwallbordercolordesc'] = 'Couleur de la bordure des sections du Mur social.';
$string['socialwallbordertopstyle'] = 'Style de la bordure';
$string['socialwallbordertopstyledesc'] = 'Style de la bordure des sections du Mur social.';
$string['socialwallborderwidth'] = 'Épaisseur de la bordure';
$string['socialwallborderwidthdesc'] = 'Épaisseur de la bordure des sections du Mur social.';
$string['socialwalldesc'] = 'Personnaliser l\'apparence du <a href="https://moodle.org/plugins/format_socialwall">Format du Mur social</a> (si utilisé sur votre site).';
$string['socialwallheading'] = 'Paramètres du Mur social';
$string['socialwallsectionradius'] = 'Rayon de la bordure';
$string['socialwallsectionradiusdesc'] = 'Rayon de la bordure des sections du Mur social.';
$string['solid'] = 'Compact';
$string['standard'] = 'Standard';
$string['standardscreenwidth'] = 'Largeur d\'écran standard.';
$string['standardscreenwidthdesc'] = 'Définissez la largeur de l\'écran lorsqu\'il est basculé en vue « standard » (voir également les paramètres enablezoom et defaultzoom associés).';
$string['standardview'] = 'Vue standard';
$string['static'] = 'Statique';
$string['stickynavbar'] = 'Barre de navigation fixée en haut';
$string['stickynavbardesc'] = 'Fixer la barre de navigation en haut de l\'écran lorsque la page défile vers le bas.';
$string['stylecover'] = 'Couverture';
$string['stylestretch'] = 'Étendue';
$string['tabbedlayoutcoursepage'] = 'Mise en page à onglets de la page du cours';
$string['tabbedlayoutcoursepagedesc'] = 'Utilisez une mise en page à onglets pour la page du cours. Cela affiche tout le contenu dans des onglets, avec le contenu du cours dans un seul onglet et vous permet de personnaliser le contenu dans d\'autres onglets. Utilisez ce paramètre pour configurer l\'ordre des onglets.';
$string['tabbedlayoutcoursepagelink'] = 'Lien vers la mise en page de cours avec onglet';
$string['tabbedlayoutcoursepagelinkdesc'] = 'Créez un lien vers la page du cours dans les onglets du cours.';
$string['tabbedlayoutcoursepagetabcolorselected'] = 'Couleur de l\'onglet sélectionné pour la page du cours';
$string['tabbedlayoutcoursepagetabcolorselecteddesc'] = 'Choisissez la couleur pour l\'onglet actuellement sélectionné.';
$string['tabbedlayoutcoursepagetabcolorunselected'] = 'Couleur de l\'onglet non sélectionnée pour la page du cours';
$string['tabbedlayoutcoursepagetabcolorunselecteddesc'] = 'Choisissez la couleur pour tout autre onglet.';
$string['tabbedlayoutcoursepagetabpersistencetime'] = 'Durée de persistance de l\'onglet page d\'accueil du cours';
$string['tabbedlayoutcoursepagetabpersistencetimedesc'] = 'L\'onglet de la page d\'accueil du cours persiste dans l\'onglet sélectionné lors de l\'actualisation pendant une période d\'inactivité. Définissez la période d\'inactivité ici. Par exemple, définissez la valeur sur 30 pour que le premier onglet soit sélectionné après 30 minutes d\'inactivité.';
$string['tabbedlayoutdashboard'] = 'Mise en page à onglets de la page du tableau de bord';
$string['tabbedlayoutdashboarddesc'] = 'Utilisez une disposition à onglets pour la page Tableau de bord. Cela affiche tout le contenu dans des onglets, avec le contenu du cours dans un seul onglet et vous permet de personnaliser le contenu dans d\'autres onglets. Utilisez ce paramètre pour configurer l\'ordre des onglets.';
$string['tabbedlayoutdashboardtab1condition'] = 'Restriction sur le champ de profil personnalisé de l\'onglet 1 (optionnel)';
$string['tabbedlayoutdashboardtab1conditiondesc'] = 'Ajouter une règle d\'accès pour afficher l\'onglet 1 à l\'aide d\'un champ de profil personnalisé, par exemple : showtab1=true.';
$string['tabbedlayoutdashboardtab2condition'] = 'Restriction sur le champ de profil personnalisé de l\'onglet 2 (optionnel)';
$string['tabbedlayoutdashboardtab2conditiondesc'] = 'Ajouter une règle d\'accès pour afficher l\'onglet 2 à l\'aide d\'un champ de profil personnalisé, par exemple : showtab2=true.';
$string['tabbedlayoutdashboardtabcolorselected'] = 'Couleur de l\'onglet sélectionné pour le tableau de bord';
$string['tabbedlayoutdashboardtabcolorselecteddesc'] = 'Choisissez la couleur pour l\'onglet actuellement sélectionné.';
$string['tabbedlayoutdashboardtabcolorunselected'] = 'Couleur de l\'onglet non sélectionné pour le tableau de bord';
$string['tabbedlayoutdashboardtabcolorunselecteddesc'] = 'Choisissez la couleur pour tout autre onglet.';
$string['tabbedlayoutheading'] = 'Disposition à onglets adaptables';
$string['tabbedlayouttablabelcourse'] = 'Le contenu des cours';
$string['tabbedlayouttablabelcourse1'] = 'Tab 1';
$string['tabbedlayouttablabelcourse2'] = 'Tab 2';
$string['tabbedlayouttablabeldashboard'] = 'Contenu du tableau de bord';
$string['tabbedlayouttablabeldashboard1'] = 'Tab 1';
$string['tabbedlayouttablabeldashboard2'] = 'Tab 2';
$string['targetnewwindow'] = 'Nouvelle fenêtre';
$string['targetsamewindow'] = 'Même fenêtre';
$string['templatesheading'] = 'Paramètres des modèles';
$string['templatesheadingdesc'] = 'Remplacer les modèles';
$string['templatessel'] = 'Modèles à remplacer';
$string['templatesseldesc'] = 'Sélectionnez les modèles à remplacer, puis chacun sera affiché sur sa propre page. S\'il n\'est pas sélectionné ici, le modèle ne sera pas remplacé même s\'il est activé. Pour n\'en sélectionner aucun, utilisez la touche « Ctrl ».';
$string['templatessettings'] = 'Modèles';
$string['themechanges'] = 'Changements';
$string['themereadme'] = 'Lisezmoi';
$string['themesupport'] = 'Support';
$string['thiscourse'] = 'Cours actuel';
$string['ticker'] = 'Annonces';
$string['tickerdefault'] = 'Aucun nouvel élément à afficher';
$string['tickerdesc'] = 'Ici, vous pouvez définir un lecteur de nouvelles sur la page d\'accueil de votre site Moodle.
Il s\'agit d\'une alternative moins intrusive qui prend très peu d\'espace.
Pour configurer votre lecteur, saisissez simplement une liste de paragraphes et incluez les hyperliens dont vous avez besoin dans ce texte.
 <strong>Note :</strong> Si votre lecteur ne se charge pas correctement, passez à la vue HTML et assurez-vous que vous n\'avez que des balises p :
 <pre>
 &lt;p&gt;Nouveauté un…&lt;/p&gt;
 &lt;p&gt;Nouveauté deux…&lt;/p&gt;
</pre>';
$string['tickerfullscreen'] = 'Largeur plein écran';
$string['tickersettings'] = 'Fil d\'informations';
$string['tickersettingsheading'] = 'Configurer le fil d\'informations sur la première page. Consultez la mise en page <a href="./../theme/adaptable/pix/layout.png" target="_blank"> ici </a>';
$string['tickertext'] = 'Texte du fil d\'informations';
$string['tickertextdesc'] = 'Ajoutez le texte du lecteur de nouvelles en format liste. Voir le fichier Readme pour plus d\'info.';
$string['tickertextprofilefield'] = 'Champ pour le profil personnalisé. Nom=Valeur (optionnel)';
$string['tickertextprofilefielddesc'] = 'Ajouter une règle d\'accès à l\'aide du champ de profil personnalisé, par exemple : usertype=student';
$string['tickerwidth'] = 'Largeur fixe';
$string['tickerwidthdesc'] = 'Vous pouvez utiliser ce paramètres pour fixer la largeur du fil d\'information des news à 100%.';
$string['tilesbordercolor'] = 'Couleur de la bordure du pavé « boite de cours »';
$string['tilesbordercolordesc'] = 'Définir la couleur de la bordure du pavé « boite de cours ».';
$string['tilescontactstitle'] = 'Afficher le rôle des contacts du cours';
$string['tilescontactstitledesc'] = 'Afficher/cacher le rôle des contacts du cours. S\'il n\'est pas affiché, une image sera affichée avant chaque contact.';
$string['tilesshowallcontacts'] = 'Afficher tous les contacts du cours';
$string['tilesshowallcontactsdesc'] = 'Afficher tous les contacts du cours ou un seul.';
$string['tilesshowcontacts'] = 'Afficher les contacts du cours';
$string['tilesshowcontactsdesc'] = 'Afficher/cacher les contacts du cours.';
$string['togglenavigation'] = 'Basculer la navigation';
$string['toolsmenu'] = 'Menu Outils déroulant';
$string['toolsmenu2'] = '2ème menu Outils';
$string['toolsmenu2desc'] = 'Vous pouvez configurer les liens à afficher dans un menu d\'outils. Chaque ligne comprend un texte de menu, une URL (facultatif), un titre d\'information (facultatif) et un code de langue ou une liste de codes séparés par des virgules (facultatif, pour afficher la ligne aux utilisateurs de la langue spécifiée uniquement), séparés par le caractère pipe. Vous pouvez spécifier une structure à l\'aide de traits d\'union. Par exemple :<br/><pre>
Moodle community|https://moodle.org
-Moodle free support|https://moodle.org/support
-Moodle development|https://moodle.org/development
--Moodle Docs|http://docs.moodle.org|Moodle Docs
--German Moodle Docs|http://docs.moodle.org/de|Documentation in German|de
Moodle.com|http://moodle.com/
</pre>';
$string['toolsmenudesc'] = 'Ajouter un menu déroulant à la barre de navigation principale.';
$string['toolsmenufield'] = 'Champ de profil personnalisé Nom=valeur (optionnel)';
$string['toolsmenufielddesc'] = 'Ajouter une règle d\'accès à l\'aide du champ de profil personnalisé, par exemple usertype=student';
$string['toolsmenuheading'] = 'Menu Outils';
$string['toolsmenuheadingdesc'] = 'Vous pouvez configurer les liens à afficher dans un menu d\'outils (dans la barre de navigation principale).
Le format est similaire à celui utilisé pour les menus personnalisés de Moodle, mais vous permet d\'ajouter des icônes (favicon) aux éléments de menu :
<pre>
&lt;span class=&quot;fa fa-video-camera&quot;&gt;&lt;/span&gt; Record Screen|http://google.co.uk|Record Screen
&lt;span class=&quot;fa fa-picture-o&quot;&gt;&lt;/span&gt; ThinkStock|http://google.co.uk|ThinkStock
&lt;span class=&quot;fa fa-clock-o&quot;&gt;&lt;/span&gt; Exam Clock|http://google.co.uk|Exam Clock
</pre><br />';
$string['toolsmenulabel'] = 'Menu Outils';
$string['toolsmenulabel2'] = 'Outils 2';
$string['toolsmenuscount'] = 'Nombre de menus Outils';
$string['toolsmenuscountdesc'] = 'Définir le nombre de menus d\'outils à ajouter à la barre de navigation principale.';
$string['toolsmenutitle'] = 'Titre du menu Outils';
$string['toolsmenutitledefault'] = 'Outils';
$string['toolsmenutitledesc'] = 'Ajouter le titre du menu à afficher dans la barre de navigation principale.';
$string['topicsweeks'] = 'Format du cours Thèmes/Semaines';
$string['topicsweeksdesc'] = 'Définir des styles pour le format de cours Thèmes/Semaines';
$string['topmenufontsize'] = 'Taille du texte du menu principal (Top)';
$string['topmenufontsizedesc'] = 'Ajuster la taille de la police des menus principal (Top).';
$string['topmenuscount'] = 'Nombre de menus du haut (top)';
$string['topmenuscountdesc'] = 'Définir le nombre de menus du haut (top) à ajouter à l\'en-tête du thème.';
$string['turngradereditingoff'] = 'Désactiver la modification des notes';
$string['turngradereditingon'] = 'Activer la modification des notes';
$string['usermenu'] = 'Menu utilisateur';
$string['usernameposition'] = 'Position du nom d\'utilisateur';
$string['usernamepositiondesc'] = 'Définissez la position de l\'utilisateur, « Gauche » ou « Droite ».';
$string['usernav'] = 'En-tête utilisateurs';
$string['usernavdesc'] = 'Permet de contrôler tous les éléments qui apparaissent dans la liste déroulante de navigation de l\'utilisateur.';
$string['usernavheading'] = 'Personnaliser le menu déroulant de navigation de l\'utilisateur';
$string['usernodescription'] = 'L\'utilisateur n\'a pas encore mis à jour sa description.';
$string['usernointerests'] = 'L\'utilisateur n\'a pas encore mis à jour ses centres d\'intérêt.';
$string['usersettings'] = 'Profil de l\'utilisateur';
$string['usersettingsdesc'] = 'Définir les paramètres du profil utilisateur.';
$string['usersettingsheading'] = 'Contrôler les aspects du profil utilisateur';
$string['versionalpha'] = 'Version Alpha - Contient sûrement des bogues. Il s\'agit d\'une version de développement pour les développeurs « uniquement » ! Ne pensez même pas à installer sur un serveur de production !';
$string['versionbeta'] = 'Version bêta - susceptible de contenir des bogues. Prêt à être testé par les administrateurs sur un serveur de test uniquement.';
$string['versioninfo'] = 'Publication {$a->release}, version {$a->version} sur Moodle {$a->moodle}';
$string['versionrc'] = 'Version candidate à la sortie - Peut contenir des bogues. Vérifiez complètement sur un serveur de test avant d\'envisager sur un serveur de production.';
$string['versionstable'] = 'Version stable - Peut contenir des bogues par manque de temps. Vérifiez sur un serveur de test avant d\'installer sur votre serveur de production, faites-le sérieusement ! Vous ne le regretterez pas et vous pourrez personnaliser jusqu\'à ce que vous soyez satisfait, puis utiliser la fonctionnalité « Importer/exporter les paramètres » pour transférer les valeurs de réglage, exclure les fichiers.';
$string['wide'] = 'Plein écran';
