<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'fr', version '4.0'.
 *
 * @package     data
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Action';
$string['add'] = 'Ajouter une fiche';
$string['addcomment'] = 'Ajouter un commentaire';
$string['addentries'] = 'Ajouter des fiches';
$string['addtemplate'] = 'Modèle de nouvelle fiche';
$string['advancedsearch'] = 'Recherche avancée';
$string['allowcomments'] = 'Autoriser les commentaires';
$string['alttext'] = 'Texte alternatif';
$string['approvalstatus'] = 'Statut d\'approbation';
$string['approve'] = 'Approuver';
$string['approved'] = 'Approuvé';
$string['areacontent'] = 'Champs';
$string['ascending'] = 'Ascendant';
$string['asearchtemplate'] = 'Modèle recherche avancée';
$string['atmaxentry'] = 'Vous avez ajouté le nombre maximum de fiches permises !';
$string['authorfirstname'] = 'Prénom auteur';
$string['authorlastname'] = 'Nom auteur';
$string['autogenallforms'] = 'Générer tous les modèles par défaut';
$string['autolinkurl'] = 'Lien automatique de l\'URL';
$string['availablefromdate'] = 'Disponible du';
$string['availabletags'] = 'Balises disponibles';
$string['availabletags_help'] = 'Les balises sont des paramètres du modèle, qui seront remplacés par des champs ou d\'autres éléments, par exemple une icône d\'édition, lorsque les fiches sont modifiées ou affichées.

Les champs ont le format [[nom_de_champ]]. Toutes les autres balises sont formatées ainsi ##une_balise##.

Seules les balises dans la liste des « Balises disponibles » peuvent être utilisées dans le modèle actuel.';
$string['availabletodate'] = 'Disponible jusqu\'au';
$string['availabletodatevalidation'] = 'La date de fin de disponibilité ne peut pas être antérieure à la date de début de disponibilité.';
$string['blank'] = 'Vide';
$string['buttons'] = 'Actions';
$string['bynameondate'] = 'par {$a->name}, le {$a->date}';
$string['calendarend'] = '{$a} se termine';
$string['calendarstart'] = '{$a} s\'ouvre';
$string['cancel'] = 'Annuler';
$string['cannotaccesspresentsother'] = 'Vous n\'avez pas les permissions requises pour accéder à des préréglages d\'autres utilisateurs';
$string['cannotadd'] = 'Impossible d\'ajouter des fiches !';
$string['cannotdeletepreset'] = 'Erreur lors de la suppression d\'un préréglage';
$string['cannotoverwritepreset'] = 'Erreur lors du remplacement du préréglage';
$string['cannotunziptopreset'] = 'Impossible de décompresser le dossier du préréglage';
$string['checkbox'] = 'Cases à cocher';
$string['chooseexportfields'] = 'Sélectionner les champs à exporter';
$string['chooseexportformat'] = 'Sélectionner le format d\'exportation désiré';
$string['chooseorupload'] = 'Sélectionner un fichier';
$string['closebeforeopen'] = 'Vous avez indiqué une date de fin antérieure à la date de début.';
$string['columns'] = 'colonnes';
$string['comment'] = 'Commentaire';
$string['commentdeleted'] = 'Commentaire supprimé';
$string['commentempty'] = 'Le commentaire était vide';
$string['comments'] = 'Commentaires';
$string['commentsaved'] = 'Commentaire enregistré';
$string['commentsn'] = '{$a} commentaire(s)';
$string['commentsoff'] = 'La fonctionnalité de commentaire n\'est pas activée';
$string['completiondetail:entries'] = 'Ajouter des fiches : {$a}';
$string['completionentries'] = 'Requiert des fiches';
$string['completionentriescount'] = 'Nombre de fiches';
$string['completionentriesdesc'] = 'Nombre minimale de fiches requises : {$a}';
$string['configenablerssfeeds'] = 'Cette option permet l\'activation des flux RSS pour toutes les bases de données. Il est en outre nécessaire d\'activer manuellement les flux RSS dans les réglages de chaque base de données.';
$string['confirmdeletefield'] = 'Vous êtes sur le point de supprimer ce champ. Voulez-vous vraiment continuer ?';
$string['confirmdeleterecord'] = 'Voulez-vous vraiment supprimer cette fiche ?';
$string['confirmdeleterecords'] = 'Voulez-vous vraiment supprimer ces enregistrements ?';
$string['csstemplate'] = 'CSS personnalisé';
$string['csvfailed'] = 'Impossible de lire les données du fichier CSV';
$string['csvfile'] = 'Fichier CSV';
$string['csvimport'] = 'Importation fichier CSV';
$string['csvimport_help'] = 'Des fiches peuvent être importées à partir d\'un fichier texte pur, dont la première ligne contient la liste des noms des champs. Les lignes suivantes contiendront les données à importer, une fiche par ligne.';
$string['csvwithselecteddelimiter'] = '<abbr title="Valeurs séparées par des virgules">CSV</abbr>';
$string['data:addinstance'] = 'Ajouter une base de données';
$string['data:approve'] = 'Approuver ou retirer l\'approbation de fiches';
$string['data:comment'] = 'Écrire des commentaires';
$string['data:exportallentries'] = 'Exporter toutes les fiches d\'une base de données';
$string['data:exportentry'] = 'Exporter des fiches de base de données';
$string['data:exportownentry'] = 'Exporter ses propres fiches de base de données';
$string['data:exportuserinfo'] = 'Exporter l\'information de l\'utilisateur';
$string['data:managecomments'] = 'Gérer les commentaires';
$string['data:manageentries'] = 'Gérer les fiches';
$string['data:managetemplates'] = 'Gérer les modèles';
$string['data:manageuserpresets'] = 'Gérer les préréglages';
$string['data:rate'] = 'Évaluer des fiches';
$string['data:readentry'] = 'Lire des fiches';
$string['data:view'] = 'Consulter une activité base de données';
$string['data:viewallratings'] = 'Voir toutes les évaluations brutes données par des participants';
$string['data:viewalluserpresets'] = 'Voir les préréglages de tous les utilisateurs';
$string['data:viewanyrating'] = 'Voir les évaluations globales reçues par les participants';
$string['data:viewentry'] = 'Consulter les fiches';
$string['data:viewrating'] = 'Voir sa propre évaluation globale reçue';
$string['data:writeentry'] = 'Ajouter des fiches';
$string['date'] = 'Date';
$string['dateentered'] = 'Date de saisie';
$string['defaultfielddelimiter'] = '(par défaut une virgule)';
$string['defaultfieldenclosure'] = '(par défaut vide)';
$string['defaultsortfield'] = 'Champ de tri par défaut';
$string['delcheck'] = 'Case à cocher pour suppression par lots';
$string['delete'] = 'Supprimer';
$string['deleteallentries'] = 'Supprimer toutes les fiches';
$string['deletecomment'] = 'Voulez-vous vraiment supprimer ce commentaire ?';
$string['deleted'] = 'supprimée';
$string['deleteentry'] = 'Supprimer une fiche';
$string['deletefield'] = 'Supprimer champ';
$string['deletenotenrolled'] = 'Supprimer les fiches des utilisateurs non inscrits';
$string['deletewarning'] = 'Voulez-vous vraiment supprimer ce préréglage ?';
$string['descending'] = 'Descendant';
$string['directorynotapreset'] = '{$a->directory} n\'est pas un préréglage. Fichiers manquants : {$a->missing_files}';
$string['disapprove'] = 'Retirer l\'approbation';
$string['download'] = 'Télécharger';
$string['edit'] = 'Modifier';
$string['editcomment'] = 'Modifier le commentaire';
$string['editentry'] = 'Modifier la fiche';
$string['editfield'] = 'Modifier champ';
$string['editordisable'] = 'Désactiver l\'éditeur';
$string['editorenable'] = 'Activer l\'éditeur';
$string['emptyadd'] = 'Le modèle d\'ajout est vide. Génération d\'un formulaire par défaut…';
$string['emptyaddform'] = 'Vous n\'avez rempli aucun champ !';
$string['enabletemplateeditorcheck'] = 'Voulez-vous vraiment activer l\'éditeur ? Ceci pourrait avoir pour conséquence des modifications non désirées lors de l\'enregistrement du modèle.';
$string['entries'] = 'Fiches';
$string['entrieslefttoadd'] = 'Vous devez ajouter encore {$a->entriesleft} fiches pour terminer cette activité';
$string['entrieslefttoaddtoview'] = 'Vous devez ajouter encore {$a->entrieslefttoview} fiches avant de pouvoir consulter les fiches des autres participants.';
$string['entry'] = 'Fiche';
$string['entrysaved'] = 'Votre fiche a été enregistrée';
$string['errormustbeteacher'] = 'Vous devez être enseignant pour afficher cette page !';
$string['errormustsupplyvalue'] = 'Veuillez renseigner une valeur.';
$string['errorpresetexists'] = 'Un préréglage de ce nom existe déjà';
$string['eventfieldcreated'] = 'Champ créé';
$string['eventfielddeleted'] = 'Champ supprimé';
$string['eventfieldupdated'] = 'Champ modifié';
$string['eventrecordcreated'] = 'Fiche créée';
$string['eventrecorddeleted'] = 'Fiche supprimée';
$string['eventrecordupdated'] = 'Fiche modifiée';
$string['eventtemplateupdated'] = 'Modèle modifié';
$string['eventtemplateviewed'] = 'Modèle consulté';
$string['example'] = 'Exemple de module Base de données';
$string['excel'] = 'Excel';
$string['expired'] = 'Cette activité est terminée depuis {$a} et n\'est plus disponible';
$string['export'] = 'Exporter';
$string['exportaszip'] = 'Exporter en zip';
$string['exportaszip_help'] = 'Cette fonctionnalité vous permet de télécharger sur votre propre ordinateur les modèles, que vous pourrez déposer ultérieurement dans d\'autres bases de données, à l\'aide de la commande « Importer d\'un fichier zip ».';
$string['exportedtozip'] = 'Exporté vers un zip temporaire…';
$string['exportentries'] = 'Exporter des fiches';
$string['exportformat'] = 'Format d\'exportation';
$string['exportoptions'] = 'Options d\'exportation';
$string['exportownentries'] = 'N\'exporter que vos propres fiches ? ({$a->mine}/{$a->all})';
$string['exportpreset'] = 'Exporter le préréglage';
$string['failedpresetdelete'] = 'Erreur lors de la suppression d\'un préréglage !';
$string['fieldadded'] = 'Champ ajouté';
$string['fieldallowautolink'] = 'Permettre les liens automatiques';
$string['fielddeleted'] = 'Champ supprimé';
$string['fielddelimiter'] = 'Séparateur de champ';
$string['fielddescription'] = 'Description du champ';
$string['fieldenclosure'] = 'Identificateur de texte';
$string['fieldheight'] = 'Hauteur';
$string['fieldheightlistview'] = 'Hauteur (en pixels) en vue liste';
$string['fieldheightsingleview'] = 'Hauteur (en pixels) en vue fiche unique';
$string['fieldids'] = 'Identifiants de champs';
$string['fieldmappings'] = 'Correspondance des champs';
$string['fieldmappings_help'] = 'Ce menu vous permet de conserver des données de la base de données existante. Pour préserver les données d\'un champ, vous devez faire correspondre ce champ à un nouveau champ, dans lequel apparaîtront les données. Les champs peuvent aussi être laissé vides, sans qu\'aucune donnée n\'y soit copiée. Les anciens champs n\'étant pas mis en correspondance avec un nouveau seront supprimés, et toutes les données qu\'ils contenaient seront perdues. Vous ne pouvez mettre en correspondance que des champs de même type. Les deux menus déroulants comporteront des champs différents. Veuillez en outre faire attention à ne pas mettre en correspondance un ancien champ avec plus d\'un nouveau.';
$string['fieldname'] = 'Nom du champ';
$string['fieldnametype'] = '{$a->name} ({$a->type})';
$string['fieldnotmatched'] = 'Les champs suivants de votre fichier n\'existent pas dans cette base de données : {$a}';
$string['fieldoptions'] = 'Options (une par ligne)';
$string['fields'] = 'Champs';
$string['fieldsnavigation'] = 'Navigation tertiaire des champs';
$string['fieldupdated'] = 'Champ modifié';
$string['fieldwidth'] = 'Largeur';
$string['fieldwidthlistview'] = 'Largeur (en pixels) en vue liste';
$string['fieldwidthsingleview'] = 'Largeur (en pixels) en vue fiche unique';
$string['file'] = 'Fichier';
$string['fileencoding'] = 'Encodage';
$string['filesnotgenerated'] = 'Les fichiers n\'ont pas tous été générés : {$a}';
$string['filtername'] = 'Liens automatiques des bases de données';
$string['footer'] = 'Pied de page';
$string['forcelinkname'] = 'Nom imposé pour le lien';
$string['foundnorecords'] = 'Aucune fiche trouvée (<a href="{$a->reseturl}">Réinitialiser les filtres</a>)';
$string['foundrecords'] = 'Fiches trouvées : {$a->num}/{$a->max} (<a href="{$a->reseturl}">Réinitialiser les filtres</a>)';
$string['fromfile'] = 'Importer d\'un fichier zip';
$string['fromfile_help'] = 'Utilisez cette fonctionnalité pour importer des préréglages que vous avez enregistrés auparavant sur votre propre ordinateur en les exportant.';
$string['generateerror'] = 'Erreur de génération de certains fichiers !';
$string['header'] = 'En-tête';
$string['headeraddtemplate'] = 'Définit l\'interface présentée lors de l\'ajout ou de la modification de fiches.';
$string['headerasearchtemplate'] = 'Définit l\'interface présentée pour la recherche avancée.';
$string['headercsstemplate'] = 'Ajouter des CSS personnalisées aux modèles.';
$string['headerjstemplate'] = 'Ajouter du Javascript personnalisé pout les modèles Liste, Simple et Ajouter une fiche.';
$string['headerlisttemplate'] = 'Définit l\'aspect de la vue liste.';
$string['headerrsstemplate'] = 'Définit l\'aspect des fiches dans les flux RSS.';
$string['headersingletemplate'] = 'Définit l\'aspect de la vue fiche unique.';
$string['importentries'] = 'Importer des fiches';
$string['importpreset'] = 'Importer un préréglage';
$string['importsuccess'] = 'Le préréglage a été mis en place correctement.';
$string['includeapproval'] = 'Inclure le statut d\'approbation';
$string['includetags'] = 'Inclure les tags';
$string['includetime'] = 'Inclure la date d\'ajout/de modification';
$string['includeuserdetails'] = 'Inclure les infos sur l\'utilisateur';
$string['indicator:cognitivedepth'] = 'Base de données : aspect cognitif';
$string['indicator:cognitivedepth_help'] = 'Cet indicateur est basé sur la profondeur cognitive atteinte par l\'étudiant dans une activité Base de données.';
$string['indicator:cognitivedepthdef'] = 'Base de données : aspect cognitif';
$string['indicator:cognitivedepthdef_help'] = 'Le participant a atteint durant cet intervalle d\'analyse ce pourcentage d\'engagement cognitif offert par les activités « Base de données » (niveaux : pas de vue, vue, envoi).';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Base de données : aspect social';
$string['indicator:socialbreadth_help'] = 'Cet indicateur se base sur l\'interaction sociale atteinte par l\'étudiant dans une activité Base de données.';
$string['indicator:socialbreadthdef'] = 'Base de données : aspect social';
$string['indicator:socialbreadthdef_help'] = 'Le participant a atteint durant cet intervalle d\'analyse ce pourcentage d\'engagement social offert par les activités « Base de données » (niveaux : pas de participation, participant seul).';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insufficiententries'] = 'autres fiches sont requises pour afficher cette base de données';
$string['intro'] = 'Description';
$string['invalidaccess'] = 'L\'accès à cette page n\'a pas été effectué correctement';
$string['invalidfieldid'] = 'L\'identifiant du champ est incorrect';
$string['invalidfieldname'] = 'Veuillez choisir un autre nom pour ce champ';
$string['invalidfieldtype'] = 'Le type de champ est incorrect';
$string['invalidid'] = 'Incorrect data ID';
$string['invalidpreset'] = '{$a} n\'est pas un préréglage.';
$string['invalidrecord'] = 'Fiche incorrecte';
$string['invalidurl'] = 'L\'URL que vous venez de saisir n\'est pas valide';
$string['jstemplate'] = 'Javascript personnalisé';
$string['latitude'] = 'Latitude';
$string['latlong'] = 'Coordonnées';
$string['latlongboth'] = 'La latitude et la longitude sont requises.';
$string['latlongdownloadallhint'] = 'Lien pour télécharger tous les éléments comme KML';
$string['latlongkmllabelling'] = 'Comment étiqueter des éléments dans les fichiers KML (Google Earth)';
$string['latlonglinkservicesdisplayed'] = 'Services liés à afficher';
$string['latlongotherfields'] = 'Autres champs';
$string['list'] = 'Affichage liste';
$string['listtemplate'] = 'Modèle liste';
$string['listview'] = 'Vue liste';
$string['longitude'] = 'Longitude';
$string['manageapproved'] = 'Permettre la modification des fiches approuvées';
$string['manageapproved_help'] = 'Permettre aux étudiants de modifier ou de supprimer leurs fiches après l\'approbation. Les fiches modifiées nécessiteront une nouvelle approbation.';
$string['managefields'] = 'Gérer les champs';
$string['mapexistingfield'] = 'Faire correspondre à {$a}';
$string['mapnewfield'] = 'Créer un nouveau champ';
$string['mappingwarning'] = 'Les anciens champs qui ne sont pas mis en correspondance avec un nouveau champ seront perdus, ainsi que toutes les données qu\'ils contiennent.';
$string['maxentries'] = 'Nombre maximal de fiches';
$string['maxentries_help'] = 'Le nombre maximum de fiches qu\'un participant peut remettre dans le cadre de cette activité.';
$string['maxsize'] = 'Taille maximale';
$string['menu'] = 'Menu déroulant';
$string['menuchoose'] = 'Sélectionner…';
$string['missingdata'] = 'Un identifiant de données ou un objet doit être fourni à la classe champ.';
$string['missingfield'] = 'Erreur de programmation : veuillez indiquer le champ et/ou les données lors de la définition d\'une classe.';
$string['missingfieldtype'] = 'Type de champ in trouvable pour {$a->name}';
$string['missingfieldtypeimport'] = 'Les champs suivants n\'ont pas été importés, car les types de champs correspondants ne sont pas installés :';
$string['missingfieldtypes'] = 'Les champs suivants n\'ont pas leur type de champ correspondant installé. Ils ne seront pas inclus dans le formulaire Ajouter une fiche.
Veuillez contrôler le modèle Ajouter une fiche  et retirer les noms de ces champs.';
$string['modulename'] = 'Base de données';
$string['modulename_help'] = 'Une base de données permet aux participants de créer, afficher et rechercher une collection de fiches.

La structure des fiches est définie à l\'aide de différents types de champs, par exemple un texte court, une liste déroulante, une zone de texte, une URL, une image ou un fichier.

Comme enseignant, vous pouvez commenter et évaluer les fiches. Vous pouvez également permettre aux étudiants d\'évaluer et de commenter les fiches (évaluation par les pairs). Les évaluations peuvent être combinées pour former une note finale, enregistrée dans le carnet de notes.

Si le filtre de liaison automatique de base de données est activé, les fiches d\'une base de données seront automatiquement liées aux mots ou phrases apparaissant dans le reste du cours.

Une activité de base de données peut être utilisée pour :

* construire de façon collaborative une collection de liens web, livres, recensions de livres ou d\'articles, références de revues, etc.
* afficher des photos, posters, sites web, poèmes, etc. créés par les étudiants, en vue d\'une présentation ou d\'une évaluation par les pairs.';
$string['modulename_link'] = 'mod/data/view';
$string['modulenameplural'] = 'Bases de données';
$string['more'] = 'Plus';
$string['moreurl'] = 'Plus d\'infos';
$string['movezipfailed'] = 'Impossible de déplacer le fichier zip';
$string['multientry'] = 'Fiche répétée';
$string['multimenu'] = 'Menu (sélection multiple)';
$string['multipletags'] = 'Plusieurs balises ont été trouvées ! Le modèle n\'a pas été enregistré';
$string['newentry'] = 'Nouvelle fiche';
$string['newfield'] = 'Créer un nouveau champ';
$string['newfield_help'] = 'Un champ permet de saisir des données. Chaque enregistrement d\'une activité base de données peut avoir plusieurs champs de divers types, par exemple un champ de type date, qui permet à l\'utilisateur de saisir une date à partir d\'un menu déroulant, un champ de type image, lui permettant de déposer un fichier image, ou un champ de type case à cocher, lui permettant de choisir une ou plusieurs options.

Chaque champ doit avoir un nom unique. La description est optionnelle.';
$string['noaccess'] = 'Vous n\'avez pas accès à cette page';
$string['nodefinedfields'] = 'Le nouveau préréglage ne comporte pas de champ !';
$string['nofieldcontent'] = 'Contenu du champ non trouvé';
$string['nofieldindatabase'] = 'Cette base de données ne contient encore aucun champ.';
$string['nolisttemplate'] = 'Le modèle liste n\'est pas encore défini';
$string['nomatch'] = 'Aucune fiche trouvée !';
$string['nomaximum'] = 'Pas de limite';
$string['norecords'] = 'Aucune fiche dans la base de données';
$string['nosingletemplate'] = 'Le modèle fiche n\'est pas encore défini';
$string['notapproved'] = 'La fiche n\'est pas encore approuvée.';
$string['notinjectivemap'] = 'N\'est pas une application injective';
$string['notopenyet'] = 'Cette activité n\'est pas disponible avant le {$a}';
$string['number'] = 'Nombre';
$string['numberrssarticles'] = 'Fiches dans le flux RSS';
$string['numnotapproved'] = 'En attente';
$string['numrecords'] = '{$a} fiches';
$string['ods'] = '<abbr title="Feuille de calcul OpenDocument">ODS</abbr> (OpenOffice)';
$string['openafterclose'] = 'Vous avez indiqué une date de début postérieure à la date de fin.';
$string['optionaldescription'] = 'Brève description (facultative)';
$string['optionalfilename'] = 'Nom affiché (facultatif)';
$string['other'] = 'Autre';
$string['overrwritedesc'] = 'Écraser le préréglage s\'il existe déjà';
$string['overwrite'] = 'Écraser';
$string['overwritesettings'] = 'Écraser les réglages actuels';
$string['page-mod-data-x'] = 'Toute page du module Base de données';
$string['pagesize'] = 'Fiches par page';
$string['participants'] = 'Participants';
$string['picture'] = 'Image';
$string['pleaseaddsome'] = 'Veuillez en créer maintenant ou <a href="{$a}">choisir un préréglage disponible</a>.';
$string['pluginadministration'] = 'Administration de la base de données';
$string['pluginname'] = 'Base de données';
$string['portfolionotfile'] = 'Exporter vers un portfolio plutôt que vers un fichier (CSV et LEAP2a seulement)';
$string['presetinfo'] = 'L\'enregistrement en tant que préréglage publiera ce modèle. D\'autres utilisateurs pourront l\'utiliser dans leurs bases de données.';
$string['presetnotselected'] = 'Aucun préréglage n\'a été sélectionné';
$string['presets'] = 'Préréglages';
$string['privacy:metadata:commentpurpose'] = 'Commentaires sur les fiches de base de données';
$string['privacy:metadata:data_content'] = 'Le contenu d\'un champ';
$string['privacy:metadata:data_content:content'] = 'Contenu';
$string['privacy:metadata:data_content:content1'] = 'Contenu additionnel 1';
$string['privacy:metadata:data_content:content2'] = 'Contenu additionnel 2';
$string['privacy:metadata:data_content:content3'] = 'Contenu additionnel 3';
$string['privacy:metadata:data_content:content4'] = 'Contenu additionnel 4';
$string['privacy:metadata:data_content:fieldid'] = 'Identifiant de la définition du champ';
$string['privacy:metadata:data_records'] = 'Les fiches de l\'activité base de données';
$string['privacy:metadata:data_records:approved'] = 'Statut d\'approbation';
$string['privacy:metadata:data_records:groupid'] = 'Groupe';
$string['privacy:metadata:data_records:timecreated'] = 'Date et heure de la création de la fiche';
$string['privacy:metadata:data_records:timemodified'] = 'Date et heure de la dernière modification de la fiche';
$string['privacy:metadata:data_records:userid'] = 'Utilisateur qui a créé la fiche';
$string['privacy:metadata:datafieldnpluginsummary'] = 'Champs de la base de données';
$string['privacy:metadata:filepurpose'] = 'Fichier annexé à la fiche de base de données';
$string['privacy:metadata:ratingpurpose'] = 'Évaluations des fiches de base de données';
$string['privacy:metadata:tagpurpose'] = 'Tags des fiches de base de données';
$string['radiobutton'] = 'Boutons radio';
$string['recordapproved'] = 'Fiche approuvée';
$string['recorddeleted'] = 'Fiche supprimée';
$string['recorddisapproved'] = 'Fiche désapprouvée';
$string['recordsnotsaved'] = 'Aucune fiche n\'a été importée. Veuillez vérifier le format du fichier déposé.';
$string['recordssaved'] = 'fiches importées';
$string['removealldatatags'] = 'Supprimer tous les tags de base de données';
$string['requireapproval'] = 'Approbation requise';
$string['requireapproval_help'] = 'Un enseignant doit approuver les fiches avant qu\'elles soient visibles pour tout le monde.';
$string['required'] = 'Requis';
$string['requiredentries'] = 'Fiches requises (anciennement)';
$string['requiredentries_help'] = 'Si ce réglage est activé, un message s\'affiche indiquant le nombre de fiches requis. Ce réglage n\'est pas en lien avec l\'achèvement de l\'activité.

Pour spécifier un nombre de fiches qu\'un participant a l\'obligation de créer dans cette activité pour qu\'elle soit considérée comme terminée, le nouveau réglage « Requiert des fiches » doit être utilisé. Pour retirer définitivement le présent réglage, fixez sa valeur à aucun et enregistrez les modifications.';
$string['requiredentriestoview'] = 'Fiches requises avant consultation';
$string['requiredentriestoview_help'] = 'Le nombre de fiches qu\'un participant doit ajouter avant de pouvoir consulter les fiches d\'autres étudiants.

Cette fonctionnalité n\'est pas compatible avec le filtre des liens automatiques des articles de base de données.';
$string['requiredentrieswarning'] = 'Ce réglage a été remplacé par un réglage « Requiert des fiches » dans l\'achèvement des activités';
$string['requiredfield'] = 'Champ requis';
$string['resetsettings'] = 'Réinitialiser les filtres';
$string['resettemplate'] = 'Réinitialiser le modèle';
$string['resizingimages'] = 'Génération des vignettes…';
$string['rows'] = 'rangées';
$string['rssglobaldisabled'] = 'Désactivé. Voir les paramètres de configuration du Moodle.';
$string['rsstemplate'] = 'Modèle RSS';
$string['rsstitletemplate'] = 'Modèle titre RSS';
$string['rsstype'] = 'Flux RSS de cette activité';
$string['save'] = 'Enregistrer';
$string['saveandadd'] = 'Enregistrer et ajouter une fiche';
$string['saveandview'] = 'Enregistrer et afficher';
$string['saveaspreset'] = 'Enregistrer en tant que préréglage';
$string['saveaspreset_help'] = 'La fonctionnalité d\'enregistrement comme préréglage publie le modèle actuel et tous ses champs en tant que préréglage, de sorte que tout le monde sur ce site pourra le voir et l\'utiliser (il vous sera possible de le supprimer de cette liste en tout temps).';
$string['saveaspresetmissingcapability'] = 'L\'utiliseur n\'a pas les permissions requises pour enregistrer la base de données comme préréglage.';
$string['savedataaspreset'] = 'Enregistrer tous les champs et modèles comme préréglage et publier comme préréglage sur ce site';
$string['savesettings'] = 'Enregistrer les réglages';
$string['savesuccess'] = 'Enregistrement réussi. Votre préréglage est maintenant disponible sur tout le site.';
$string['savetemplate'] = 'Enregistrer modèle';
$string['search'] = 'Recherche';
$string['search:activity'] = 'Base de données – information sur l\'activité';
$string['search:entry'] = 'Base de données – fiches';
$string['selectedrequired'] = 'Toute la sélection requise';
$string['selectexportoptions'] = 'Sélectionner les options d\'exportation';
$string['selectfields'] = 'Sélectionner les champs';
$string['showall'] = 'Afficher toutes les fiches';
$string['single'] = 'Affichage fiche';
$string['singletemplate'] = 'Modèle fiche';
$string['singleview'] = 'Vue fiche unique';
$string['subplugintype_datafield'] = 'Type de champ Base de données';
$string['subplugintype_datafield_plural'] = 'Types de champ Base de données';
$string['subplugintype_datapreset'] = 'Préréglage';
$string['subplugintype_datapreset_plural'] = 'Préréglages';
$string['tagarea_data_records'] = 'Fiches de données';
$string['tags'] = 'Tags';
$string['tagsdeleted'] = 'Les tags de base de données ont été supprimés.';
$string['teachersandstudents'] = '{$a->teachers} et {$a->students}';
$string['templates'] = 'Modèles';
$string['templatesaved'] = 'Modèle enregistré';
$string['templatesnavigation'] = 'Navigation tertiaire des modèles';
$string['text'] = 'Texte';
$string['textarea'] = 'Zone de texte';
$string['timeadded'] = 'Date ajout';
$string['timemodified'] = 'Date modification';
$string['todatabase'] = 'à cette base de données.';
$string['type'] = 'Type de champ';
$string['undefinedprocessactionmethod'] = 'Aucune méthode n\'est définie dans Data_Preset pour traiter l\'action « {$a} ».';
$string['unknown'] = 'Champ inconnu';
$string['unsupportedexport'] = '({$a->fieldtype}) ne peut pas être exporté.';
$string['unsupportedfields'] = 'Champs non supportés';
$string['unsupportedfieldslist'] = 'Les champs suivants ne peuvent pas être exportés :';
$string['updatefield'] = 'Modifier un champ existant';
$string['uploadfile'] = 'Déposer un fichier';
$string['uploadrecords'] = 'Importer des fiches à partir d\'un fichier';
$string['uploadrecords_help'] = 'Des fiches peuvent être déposées à partir d\'un fichier texte. Le format de ce fichier doit être le suivant :

* chaque ligne du fichier contient une fiche ;
* chaque fiche est constituée d\'une série de données séparées par le caractère de séparation sélectionné ;
* la première ligne du fichier comprend les noms des champs définissant le format du reste du fichier.  Le délimiteur de champ est un caractère qui entoure chaque champ d\'une fiche, par exemple les guillemets droits. Il peut être laissé vide.';
$string['uploadrecords_link'] = 'mod/data/import';
$string['url'] = 'URL';
$string['usedate'] = 'Inclure dans la recherche.';
$string['usepredefinedset'] = 'Utiliser un jeu prédifini';
$string['usepreset'] = 'Utiliser un préréglage';
$string['usestandard'] = 'Utiliser un préréglage';
$string['usestandard_help'] = 'Pour utiliser un préréglage disponible dans tout le site en tant que modèle de base de données, choisissez-le dans la liste (si vous avez ajouté un préréglage en utilisant la fonctionnalité « Enregistrer en tant que préréglage », vous pouvez aussi le supprimer).';
$string['viewfromdate'] = 'En lecture seule dès le';
$string['viewnavigation'] = 'Navigation tertiaire du mode consultation';
$string['viewtodate'] = 'En lecture seule jusqu\'au';
$string['viewtodatevalidation'] = 'La date de fin de mise en lecture seule ne peut pas être antérieure à la date de début de mise en lecture seule.';
$string['wrongdataid'] = 'ID de données fourni incorrect';
