<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'h5p', language 'ja', version '4.0'.
 *
 * @package     h5p
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = '操作';
$string['addedandupdatedpp'] = '{$a->%new} 件の新しいH5Pライブラリを追加および {$a->%old} 件の古いライブラリを更新しました。';
$string['addedandupdatedps'] = '{$a->%new} 件の新しいH5Pライブラリを追加および {$a->%old} 件の古いライブラリを更新しました。';
$string['addedandupdatedsp'] = '{$a->%new} 件の新しいH5Pライブラリを追加および {$a->%old} 件の古いライブラリを更新しました。';
$string['addedandupdatedss'] = '{$a->%new} 件の新しいH5Pライブラリを追加および {$a->%old} 件の古いライブラリを更新しました。';
$string['addednewlibraries'] = '{$a->%new} 件の新しいH5Pライブラリを追加しました。';
$string['addednewlibrary'] = '{$a->%new} 件の新しいH5Pライブラリを追加しました。';
$string['additionallicenseinfo'] = 'ライセンスに関する追加情報';
$string['atto_h5p'] = 'H5Pボタンを追加する';
$string['atto_h5p_description'] = 'AttoエディタにH5Pボタンを追加することによりユーザはURLの入力、コードの埋め込みまたはH5PファイルのアップロードによるH5Pコンテンツの挿入ができるようになります。';
$string['author'] = '作成者';
$string['authorcomments'] = '作成者コメント';
$string['authorcommentsdescription'] = 'コンテンツのエディタのコメントです (このテキストは著作権情報の一部としては公開されません)。';
$string['authorname'] = '作成者名';
$string['authorrole'] = '作成者ロール';
$string['by'] = 'by';
$string['cancellabel'] = 'キャンセル';
$string['ccattribution'] = '表示 (CC BY)';
$string['ccattributionnc'] = '表示-非営利 (CC BY-NC)';
$string['ccattributionncnd'] = '表示-非営利-改変禁止 (CC BY-NC-ND)';
$string['ccattributionncsa'] = '表示-非営利-継承 (CC BY-NC-SA)';
$string['ccattributionnd'] = '表示-改変禁止 (CC BY-ND)';
$string['ccattributionsa'] = '表示-継承 (CC BY-SA)';
$string['ccpdd'] = '著作権なし (CC0)';
$string['changedby'] = '変更';
$string['changedescription'] = '変更の説明';
$string['changelog'] = '変更ログ';
$string['changeplaceholder'] = '写真トリミング、テキスト変更等です。';
$string['close'] = '閉じる';
$string['confirmdialogbody'] = 'あなたが続けたい場合、確認してください。この操作は元に戻せません。';
$string['confirmdialogheader'] = '操作確認';
$string['confirmlabel'] = '確認';
$string['connectionLost'] = '接続が切断されました。結果は保存された後、接続復帰時に送信されます。';
$string['connectionReestablished'] = '接続が再確立されました。';
$string['contentCopied'] = 'コンテンツがクリップボードにコピーされます。';
$string['contentchanged'] = 'あなたが前回使用して以来、このコンテンツは変更されています。';
$string['contentinuse'] = 'このコンテンツは他の場所でも使用されている可能性があります。';
$string['contenttype'] = 'コンテンツタイプ';
$string['copyright'] = '使用権';
$string['copyrightinfo'] = '著作権情報';
$string['copyrightstring'] = '著作権';
$string['copyrighttitle'] = 'このコンテンツの著作権情報を表示します。';
$string['couldNotParseJSONFromZip'] = 'パッケージからJSONを構文解析できません: {$a->%fileName}';
$string['couldNotReadFileFromZip'] = 'パッケージからファイルを読み込めません: {$a->%fileName}';
$string['creativecommons'] = 'クリエイティブ・コモンズ';
$string['date'] = '日付';
$string['deletelibraryconfirm'] = '<p>本当にライブラリ「 {$a->name} 」からバージョン「 {$a->version} 」を削除してもよろしいですか? ライブラリおよびすべての使用が削除されます。</p><p>この処理は元に戻せません。</p>';
$string['deletelibraryversion'] = 'バージョンを削除する';
$string['deleting'] = 'ライブラリの削除';
$string['description'] = '説明';
$string['disablefullscreen'] = 'フルスクリーンを無効にする';
$string['download'] = 'ダウンロード';
$string['downloadtitle'] = 'このコンテンツをH5Pファイルとしてダウンロードします。';
$string['editcontent'] = 'H5Pコンテンツを編集する';
$string['editor'] = 'エディタ';
$string['embed'] = '埋め込み';
$string['embedtitle'] = 'このコンテンツの埋め込みコードを表示します。';
$string['error:emptycontentid'] = '指定されたURLが正しくないか、あなたはこのファイルを編集できません。';
$string['eventh5pdeleted'] = 'H5Pが削除されました。';
$string['eventh5pviewed'] = 'H5Pコンテンツが閲覧されました。';
$string['feature'] = '機能';
$string['fetchtypesfailure'] = '利用可能なH5Pコンテンツで取得できる情報はありません。H5Pリポジトリへの接続に失敗しました。';
$string['fileExceedsMaxSize'] = 'パッケージ内のファイルの1つが許可される最大ファイルサイズを超えました。 ({$a->%file} {$a->%used} > {$a->%max})';
$string['filter_displayh5p'] = 'H5Pフィルタを表示する';
$string['filter_displayh5p_description'] = 'URLを埋め込みH5Pコンテンツに変換するH5Pフィルタを表示します。';
$string['fullscreen'] = 'フルスクリーン';
$string['gpl'] = '一般公衆利用許諾書 v3';
$string['h5p'] = 'H5P';
$string['h5peditor'] = 'H5Pエディタ';
$string['h5pfilenotfound'] = 'H5Pファイルが見つかりませんでした。';
$string['h5pinvalidurl'] = '無効なH5PコンテンツURLです。';
$string['h5plibraryhandler'] = 'H5Pフレームワークハンドラ';
$string['h5plibraryhandler_help'] = 'H5Pコンテンツの表示に使用されるH5Pフレームワークです。最新バージョンをお勧めします。';
$string['h5pmanage'] = 'H5Pコンテンツタイプを管理する';
$string['h5poverview'] = 'H5P概要';
$string['h5ppackage'] = 'H5Pコンテンツタイプ';
$string['h5ppackage_help'] = 'H5Pコンテンツタイプはコンテンツを表示するために必要なライブラリすべてを含むH5PまたはZIP拡張子のファイルです。';
$string['h5pprivatefile'] = 'あなたには.h5pファイルへのアクセス権がないため、このH5Pコンテンツを表示できません。';
$string['h5psettings'] = 'H5P設定';
$string['h5ptitle'] = 'さらにコンテンツをチェックするにはH5P.orgにアクセスしてください。';
$string['hideadvanced'] = '拡張要素を隠す';
$string['installedcontentlibraries'] = 'インストール済みH5Pライブラリ';
$string['installedcontenttypes'] = 'インストール済みH5Pコンテンツタイプ';
$string['installedh5p'] = 'インストール済みH5Pライブラリ';
$string['invalidcontextid'] = 'H5Pファイルが見つかりませんでした (無効なcontextid)。';
$string['invalidfile'] = 'ファイル「 {$a->%filename} 」は許可されていません。次の拡張子のファイルのみ許可されます: {$a->%files-allowed}';
$string['invalidlanguagefile'] = 'ライブラリ {$a->%library} の言語ファイル {$a->%file} が有効ではありません。';
$string['invalidlanguagefile2'] = '無効な言語ファイル {$a->%languageFile} がライブラリ {$a->%name} にインクルードされました。';
$string['invalidlibrarydata'] = '{$a->%library} の {$a->%property} に無効なデータが提供されました。';
$string['invalidlibrarydataboolean'] = '{$a->%library} の {$a->%property} に無効なデータが提供されました。boolean型が要求されます。';
$string['invalidlibraryname'] = '無効なライブラリ名: {$a->%name}';
$string['invalidlibrarynamed'] = 'コンテンツで使用されているH5Pライブラリ {$a->%library} が有効ではありません。';
$string['invalidlibraryoption'] = '{$a->%library} の オプション {$a->%option} が不正です。';
$string['invalidlibraryproperty'] = '{$a->%library} のプロパティ {$a->%property} を読み込めません。';
$string['invalidmainjson'] = '有効なメインh5p.jsonファイルがありません。';
$string['invalidmultiselectoption'] = 'multi-selectで選択されたオプションが無効です。';
$string['invalidpackage'] = '無効なH5Pコンテンツタイプです。';
$string['invalidselectoption'] = 'selectで選択されたオプションが無効です。';
$string['invalidsemanticsjson'] = 'ライブラリ {$a->%name} に無効なsemantics.jsonファイルがインクルードされています。';
$string['invalidsemanticstype'] = 'H5P内部エラー: セマンティクスの不明なコンテンツタイプ「 {$a->@type} 」です。コンテンツを削除します!';
$string['invalidstring'] = 'セマンティクスのregexpによれば提供されたストリングが有効ではありません。(値: "{$a->%value}", regexp: "{$a->%regexp}")';
$string['librariesmanagerdescription'] = '<p>H5Pでは特定の範囲のコンテンツタイプを提供してユーザがインタラクティブなコンテンツを作成できるようにします。</p>
<p>あなたの信頼されるH5Pコンテンツタイプが使用されることを確実にするには次のどちらかが必要です。</p>
<ul>
<li>h5p.orgからH5Pコンテンツタイプをアップロードする</li>
<li>スケジュールタスク「利用可能なH5Pコンテンツをh5p.orgからダウンロードする」を有効にする</li>
</ul>
<p>ユーザはあなたのサイトにインストールされたH5Pコンテンツタイプのみ利用できることに留意してください。</p>';
$string['librarydirectoryerror'] = 'ライブラリディレクトリ名はmachineNameまたはmachineName-majorVersion.minorVersionに合致する必要があります (library.jsonから)。(ディレクトリ: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['license'] = 'ライセンス';
$string['licenseCC010'] = 'CC0 1.0 全世界 (CC0 1.0) パブリック・ドメイン提供';
$string['licenseCC010U'] = 'CC0 1.0 全世界';
$string['licenseCC10'] = '1.0 一般';
$string['licenseCC20'] = '２.0 一般';
$string['licenseCC25'] = '2.5 一般';
$string['licenseCC30'] = '3.0 非移植';
$string['licenseCC40'] = '4.0 国際';
$string['licenseGPL'] = '一般公衆利用許諾書';
$string['licenseV1'] = 'バージョン 1';
$string['licenseV2'] = 'バージョン 2';
$string['licenseV3'] = 'バージョン 3';
$string['licensee'] = 'ライセンス';
$string['licenseextras'] = '追加ライセンス';
$string['licenseversion'] = 'ライセンスバージョン';
$string['lockh5pdeploy'] = '配置されているためH5Pコンテンツにアクセスできません。後ほど再度お試しください。';
$string['mainlibrarydisabled'] = 'コンテンツタイプが無効にされているため、このファイルは表示できません。コンテンツタイプを有効にするにはあなたの管理者にご連絡ください。';
$string['missingcontentfolder'] = '有効なコンテンツフォルダがありません。';
$string['missingcoreversion'] = '最新バージョンのH5Pプラグインを必要とするため、システムはパッケージから {$a->%component} コンポーネントをインストールできませんでした。現在、このサイトではバージョン {$a->%current} が実行されています。必須バージョンは {$a->%required} またはそれ以上です。 アップグレード後の再試行をご検討ください。';
$string['missingdependency'] = '{$a->@lib} で必要な依存関係 {$a->@dep} がありません。';
$string['missinglibrary'] = '必要なライブラリ {$a->@library} がありません。';
$string['missinglibraryfile'] = 'ライブラリにファイル「 {$a->%file} 」がありません: {$a->%name}';
$string['missinglibraryjson'] = 'ライブラリ {$a->%name} の有効なJSONフォーマットのlibrary.jsonファイルが見つかりませんでした。';
$string['missinglibraryproperty'] = '{$a->%library} の必須プロパティ {$a->%property} がありません。';
$string['missingmbstring'] = 'PHP拡張モジュールmbstringが読み込まれていません。これはH5Pが正常に動作するため必要です。';
$string['missinguploadpermissions'] = 'あなたがアップロードしたファイル内にライブラリが存在する可能性はありますが、あなたは新しいライブラリのアップロードを許可されていないことに留意してください。あなたのサイト管理者にご連絡ください。';
$string['nocopyright'] = 'このコンテンツに利用できる著作権情報はありません。';
$string['noextension'] = 'あなたがアップロードしたファイルは有効なHTML5パッケージではありません (.h5pファイル拡張子がありません)。';
$string['noh5plibhandlerdefined'] = 'インストールされているH5Pフレームハンドラはありません。そのため、H5Pコンテンツを表示できません。';
$string['nojson'] = 'メインのh5p.jsonファイルが有効ではありません。';
$string['nopermissiontodeploy'] = 'H5Pコンテンツを配置するために必要なケイパビリティのないユーザがアップロードしたため、このファイルは表示できません。';
$string['nopermissiontoedit'] = 'あなたにはH5Pコンテンツを編集するためのパーミッションがありません。';
$string['notrustablefile'] = 'H5Pコンテンツタイプを更新できるケイパビリティのないユーザがアップロードしたため、このファイルは表示できません。コンテンツタイプのインストールを依頼するにはあなたの管理者にご連絡ください。';
$string['nounzip'] = 'あなたがアップロードしたファイルは有効なHTML5パッケージではありません (ファイルを展開できません)。';
$string['offlineDialogBody'] = '私たちはこのタスクのあなたの完了に関する情報を送信できませんでした。あなたのインターネット接続を確認してください。';
$string['offlineDialogHeader'] = 'あなたのサーバへの接続が切断されました。';
$string['offlineDialogRetryButtonLabel'] = 'リトライする';
$string['offlineDialogRetryMessage'] = 'リトライ :num....';
$string['offlineSuccessfulSubmit'] = '結果を正常に送信しました。';
$string['originator'] = 'オーガナイザ';
$string['pd'] = 'パブリック・ドメイン';
$string['pddl'] = 'パブリック・ドメインへの供与と認証';
$string['pdm'] = 'パブリック・ドメイン・マーク (PDM)';
$string['pluginname'] = 'H5Pパッケージ';
$string['privacy:metadata'] = 'H5Pサブシステムはいかなる個人データも保存しません。';
$string['resizescript'] = '埋め込みコンテンツを動的にサイズ変更したい場合、あなたのウェブサイトにこのスクリプトを組み込んでください:';
$string['resubmitScores'] = '保存された結果の送信を試みます。';
$string['reuse'] = '再利用';
$string['reuseContent'] = 'コンテンツを再利用する';
$string['reuseDescription'] = 'このコンテンツを再利用します。';
$string['showadvanced'] = '拡張要素を表示する';
$string['showless'] = '表示を減らす';
$string['showmore'] = 'さらに表示する';
$string['size'] = 'サイズ';
$string['source'] = 'ソース';
$string['startingover'] = 'あなたは再開します。';
$string['status'] = 'ステータス';
$string['sublevel'] = 'サブレベル';
$string['task_h5p'] = 'H5Pスケジュールタスク';
$string['task_h5p_description'] = 'h5p.orgから利用可能なH5PコンテンツをダウンロードするH5Pスケジュールタスクです。';
$string['thumbnail'] = 'サムネイル';
$string['title'] = 'タイトル';
$string['undisclosed'] = '未公開';
$string['unpackedFilesExceedsMaxSize'] = '展開されたファイルの合計サイズが許可される最大サイズを超えました。 ({$a->%used} > {$a->%max})';
$string['updatedlibraries'] = '{$a->%old} H5Pライブラリを更新しました。';
$string['updatedlibrary'] = '{$a->%old} H5Pライブラリを更新しました。';
$string['uploadlibraries'] = 'H5Pコンテンツタイプをアップロードする';
$string['uploadsuccess'] = 'H5Pコンテンツが正常にアップロードされました。';
$string['wrongversion'] = 'このコンテンツで使用されているH5Pライブラリ {$a->%machineName} のバージョンが有効ではありません。コンテンツに {$a->%contentLibrary} が含まれますが {$a->%semanticsLibrary} である必要があります。';
$string['year'] = '年';
$string['years'] = '年';
$string['yearsfrom'] = '年 (from)';
$string['yearsto'] = '年 (to)';
