<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'calendar', language 'sv', version '4.0'.
 *
 * @package     calendar
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityevent'] = 'Aktivitetshändelse';
$string['addevent'] = 'Lägg till händelser';
$string['advancedoptions'] = 'Avancerade alternativ';
$string['allday'] = 'Hela dagen';
$string['annually'] = 'Årligen';
$string['calendar'] = 'Kalender';
$string['calendarexporturl'] = 'Kalender-URL';
$string['calendarheading'] = '{$a} Kalender';
$string['calendarpreferences'] = 'Kalenderinställningar';
$string['calendartypes'] = 'Kalendertyper';
$string['calendarurl'] = 'Kalender-URL: {$a}';
$string['calendarurlcopiedtoclipboard'] = 'Kalender-URL kopierad till urklipp';
$string['category'] = 'Kategori';
$string['categoryevent'] = 'Kategorihändelse';
$string['categoryevents'] = 'Kategorihändelser';
$string['clickhide'] = 'klicka för att dölja';
$string['clickshow'] = 'klicka för att visa';
$string['colactions'] = 'Åtgärder';
$string['colcalendar'] = 'Kalender';
$string['collastupdated'] = 'Senast uppdaterad';
$string['colpoll'] = 'Uppdateringsintervall';
$string['commontasks'] = 'Alternativ';
$string['confirmeventdelete'] = 'Är du säker på att du vill ta bort händelsen "{$a}"?';
$string['confirmeventseriesdelete'] = 'Händelsen "{$a->name}" ingår i en serie av händelser. Vill du ta bort bara denna händelse, eller alla {$a->count} händelser i serien?';
$string['confirmsubscriptiondelete'] = 'Är du säker på att du vill ta bort prenumerationen på <strong>"{$a}"</strong>-kalendern?';
$string['copycalendarurl'] = 'Kopiera kalender-URL';
$string['copyurl'] = 'Kopiera URL';
$string['course'] = 'Kurs';
$string['coursecalendar'] = '{$a}-kalender';
$string['courseevent'] = 'Kurshändelse';
$string['courseevents'] = 'Kurshändelser';
$string['courses'] = 'Kurser';
$string['customexport'] = 'Anpassat intervall ({$a->timestart} - {$a->timeend})';
$string['daily'] = 'Dagligen';
$string['day'] = 'Dag';
$string['dayeventsmany'] = '{$a->num} händelser, {$a->day}';
$string['dayeventsnone'] = 'Inga händelser, {$a}';
$string['dayeventsone'] = '1 händelse, {$a}';
$string['daynext'] = 'Nästa dag';
$string['dayprev'] = 'Föregående dag';
$string['dayviewfor'] = 'Dagsvy för:';
$string['dayviewtitle'] = 'Dagsvy för: {$a}';
$string['daywithnoevents'] = 'Det finns inga händelser den här dagen.';
$string['default'] = 'Standard';
$string['deleteallevents'] = 'Ta bort alla händelser';
$string['deleteevent'] = 'Ta bort händelse';
$string['deleteevents'] = 'Ta bort händelser';
$string['deleteoneevent'] = 'Ta bort denna händelse';
$string['detailedmonthviewfor'] = 'Detaljerad månadsvy för:';
$string['detailedmonthviewtitle'] = 'Detaljerad månadsvy: {$a}';
$string['durationminutes'] = 'Varaktighet i minuter';
$string['durationnone'] = 'Utan varaktighet';
$string['durationuntil'] = 'Till';
$string['editevent'] = 'Redigerar händelse';
$string['erroraddingevent'] = 'Det gick inte att lägga till händelse';
$string['errorbadsubscription'] = 'Kalenderprenumeration hittades inte';
$string['errorbeforecoursestart'] = 'Det går inte att skriva in en händelse som ligger före kursens startdatum';
$string['errorcannotimport'] = 'Du kan inte skapa en kalenderprenumeration just nu';
$string['errorhasuntilandcount'] = 'UNTIL eller COUNT kan förekomma i en återkommande-regel, men de FÅR INTE förekomma samtidigt i samma regel.';
$string['errorinvalidbydayprefix'] = 'Heltalsvärden som föregår BYDAY-regler kan bara finnas för en MONTLY- eller YEARLY-upprepningsregel.';
$string['errorinvalidbydaysuffix'] = 'Giltiga värden för veckodagsdelen i BYDAY-regeln är MO, TU, WE, TH, FR, SA och SU';
$string['errorinvalidbyhour'] = 'Giltiga värden för BYHOUR-regeln är 0 till 23.';
$string['errorinvalidbyminute'] = 'Giltiga värden för BYMINUTE-regeln är 0 till 59.';
$string['errorinvalidbymonth'] = 'Giltiga värden för BYMONTH-regeln är 1 till 12.';
$string['errorinvalidbymonthday'] = 'Giltiga värden för BYMONTHDAY-regeln är 1 till 31 eller -31 till -1.';
$string['errorinvalidbysecond'] = 'Giltiga värden för BYSECOND-regeln är 0 till 59.';
$string['errorinvalidbysetpos'] = 'Giltiga värden för BYSETPOS-regeln är 1 till 366 eller -366 till -1.';
$string['errorinvalidbyweekno'] = 'Giltiga värden för BYWEEKNO-regeln är 1 till 53 eller -53 till -1.';
$string['errorinvalidbyyearday'] = 'Giltiga värden för BYYEARDAY-regeln är 1 till 366 eller -366 till -1.';
$string['errorinvaliddate'] = 'Ogiltigt datum';
$string['errorinvalidicalurl'] = 'Den angivna iCal webbadressen är ogiltig.';
$string['errorinvalidinterval'] = 'Värdet för <code>INTERVAL</code> måste vara ett positivt heltal.';
$string['errorinvalidminutes'] = 'Ange varaktighet i minuter genom att skriva in ett tal mellan 1 och 999.';
$string['errorinvalidrepeats'] = 'Ange antalet händelser genom att skriva in ett tal mellan 1 och 999.';
$string['errormustbeusedwithotherbyrule'] = 'BYSETPOS-regeln får endast användas tillsammans med en annan BYxxx-regeldel.';
$string['errornodescription'] = 'Beskrivning är obligatorisk';
$string['errornoeventname'] = 'Namn är obligatoriskt';
$string['errornonyearlyfreqwithbyweekno'] = 'BYWEEKNO-regeln är endast giltig för YEARLY-regler.';
$string['errorrequiredurlorfile'] = 'Det krävs antingen en webbadress eller en fil för att importera en kalender.';
$string['errorrrule'] = 'Upprepningsregeln verkar felaktig.';
$string['errorrruleday'] = 'Upprepningsregeln har en ogiltig dagparameter.';
$string['errorrrulefreq'] = 'Upprepningsregeln har en ogiltig frekvensparameter.';
$string['eventcalendareventcreated'] = 'Kalenderhändelse skapad';
$string['eventcalendareventdeleted'] = 'Kalenderhändelse borttagen';
$string['eventcalendareventupdated'] = 'Kalenderhändelse har uppdaterats';
$string['eventdate'] = 'Datum';
$string['eventdescription'] = 'Beskrivning';
$string['eventduration'] = 'Varaktighet';
$string['eventendtime'] = 'Sluttid';
$string['eventendtimewrapped'] = '{$a} (Sluttid)';
$string['eventinstanttime'] = 'Tid';
$string['eventkind'] = 'Händelsetyp';
$string['eventname'] = 'Namn';
$string['eventnameandcategory'] = '{$a->category}: {$a->name}';
$string['eventnameandcourse'] = '{$a->course}: {$a->name}';
$string['eventnone'] = 'Inga händelser';
$string['eventrepeat'] = 'Upprepningar';
$string['events'] = 'Händelser';
$string['eventsall'] = 'Alla händelser';
$string['eventsdeleted'] = '{$a} händelser togs bort';
$string['eventsfor'] = '{$a} händelser';
$string['eventsimported'] = '{$a} händelser importerades';
$string['eventskey'] = 'Förklaring';
$string['eventsource'] = 'Källa för händelser';
$string['eventspersonal'] = 'Mina händelser';
$string['eventsrelatedtocategories'] = 'Händelser relaterade till kategorier';
$string['eventsrelatedtocourses'] = 'Händelser kopplade till kurser';
$string['eventsrelatedtogroups'] = 'Händelser för grupper';
$string['eventsskipped'] = '{$a} händelser hoppades över';
$string['eventstarttime'] = 'Starttid';
$string['eventstoexport'] = 'Händelser att exportera';
$string['eventsubscriptioncreated'] = 'Kalenderprenumeration skapad';
$string['eventsubscriptiondeleted'] = 'Kalenderprenumeration borttagen';
$string['eventsubscriptioneditwarning'] = 'Denna kalenderhändelse ingår i en prenumeration. Alla ändringar som du gör i denna händelse kommer att försvinna om prenumerationen tas bort.';
$string['eventsubscriptionupdated'] = 'Kalenderprenumeration uppdaterad';
$string['eventsupdated'] = '{$a} händelser uppdaterades';
$string['eventtime'] = 'Tid';
$string['eventtype'] = 'Händelsetyp';
$string['eventtypecategory'] = 'kategori';
$string['eventtypecourse'] = 'kurs';
$string['eventtypegroup'] = 'grupp';
$string['eventtypemodule'] = 'modul';
$string['eventtypeother'] = 'övriga';
$string['eventtypesite'] = 'webbplats';
$string['eventtypeuser'] = 'användare';
$string['eventview'] = 'Händelsedetaljer';
$string['expired'] = 'Förfallen';
$string['explain_site_timeformat'] = 'Du kan välja att se tiden i antingen 12-timmars eller 24-timmarsformat för hela webbplatsen. Om du väljer det förvalda standardvärdet kommer formatet att styras automatiskt av det språk du använder på webbplatsen. Den här inställningen kan åsidosättas av enskilda användare.';
$string['export'] = 'Exportera';
$string['exportbutton'] = 'Exportera';
$string['exportcalendar'] = 'Exportera kalender';
$string['exporthelp'] = '<p>Den här kalender-URL:en innehåller en dynamisk länk för att importera händelser till andra kalendrar. Alla nya, ändrade eller borttagna händelser i källkalendern <strong>kommer</strong> återspeglas i de andra kalendrarna.</p>
<p>Kalenderexporten låter dig skapa en säkerhetskopia av händelser som kan importeras till andra kalendrar. Uppdateringar som görs i källkalendern <strong>kommer inte</strong> återspeglas i de andra kalendrarna.</p>';
$string['forcecalendartype'] = 'Tvinga kalender';
$string['fri'] = 'Fre';
$string['friday'] = 'Fredag';
$string['fullcalendar'] = 'Hela kalendern';
$string['generateurlbutton'] = 'Hämta URL till kalender';
$string['gotoactivity'] = 'Gå till aktivitet';
$string['gotocalendar'] = 'Gå till Kalender';
$string['group'] = 'Grupp';
$string['groupevent'] = 'Grupphändelse';
$string['groupevents'] = 'Grupphändelser';
$string['hideeventtype'] = 'Dölj {$a}händelser';
$string['hourly'] = 'Varje timme';
$string['importcalendar'] = 'Importera kalender';
$string['importcalendarexternal'] = 'Importera extern kalender?';
$string['importcalendarfrom'] = 'Importera från';
$string['importcalendarheading'] = 'Importera kalender...';
$string['importfromfile'] = 'Kalenderfil (.ics)';
$string['importfrominstructions'] = 'Bifoga antingen en webbadress till en annan kalender eller ladda upp en fil.';
$string['importfromurl'] = 'Kalender-webbadress';
$string['invalideventtype'] = 'Den händelsetyp du valt är ogiltig.';
$string['invalidtimedurationminutes'] = 'Varaktigheten i minuter du har angett är ogiltig. Ange tiden i minuter (större än 0) eller välj ingen varaktighet.';
$string['invalidtimedurationuntil'] = 'Datum och tid du valt för varaktighet till är före starttiden för händelsen. Vänligen korrigera detta innan du fortsätter.';
$string['iwanttoexport'] = 'Exportera';
$string['less'] = 'Mindre';
$string['managesubscriptions'] = 'Importera/exportera kalendrar';
$string['manyevents'] = '{$a} händelser';
$string['mon'] = 'Mån';
$string['monday'] = 'Måndag';
$string['monthly'] = 'Månadsvis';
$string['monthlyview'] = 'Månadsvy';
$string['monthnext'] = 'Nästa månad';
$string['monthprev'] = 'Föregående månad';
$string['monththis'] = 'Den här månaden';
$string['more'] = 'Mer';
$string['moreevents'] = '{$a} fler';
$string['namewithsource'] = '{$a->name} ({$a->source})';
$string['never'] = 'Aldrig';
$string['newevent'] = 'Ny händelse';
$string['nocalendarsubscriptions'] = 'Du prenumererar inte på några kalendrar ännu. Vill du {$a}';
$string['notitle'] = 'ingen titel';
$string['noupcomingevents'] = 'Det finns inga kommande händelser';
$string['oneevent'] = '1 händelse';
$string['pollinterval'] = 'Uppdateringsintervall';
$string['pollinterval_help'] = 'Hur ofta ska kalendern uppdateras med nya händelser.';
$string['pref_lookahead'] = 'Visa kommande händelser';
$string['pref_lookahead_help'] = 'Detta anger (maximalt) antal dagar i framtiden som en händelse måste starta för att visas som en kommande händelse. Händelser som startar efter detta antal dagar kommer aldrig att visas som kommande. OBS! Det <strong>finns ingen garanti</strong> att alla händelser som startar inom denna tidsram kommer att visas; om det finns fler än "Maximalt antal kommande händelser" kommer de överskjutande inte visas.';
$string['pref_maxevents'] = 'Maximalt antal kommande händelser';
$string['pref_maxevents_help'] = 'Detta ställer in det maximala antalet kommande händelser som kan visas. Om du väljer ett stort antal är det möjligt att kommande händelser kommer att ta upp mycket utrymme på din skärm.';
$string['pref_persistflt'] = 'Kom ihåg filterinställningar';
$string['pref_persistflt_help'] = 'Om detta är aktiverat så kommer Moodle ihåg dina senaste inställningar för händelsefiltret och återställer dem automatiskt varje gång du loggar in.';
$string['pref_startwday'] = 'Första dagen i veckan';
$string['pref_startwday_help'] = 'Kalenderveckor startar på den dag du väljer här.';
$string['pref_timeformat'] = 'Format för tidvisning';
$string['pref_timeformat_help'] = 'Du kan välja att se tider i antingen 12- eller 24-timmars format. Om du väljer "standard" så väljs formatet automatiskt beroende på vilket språk du använder på webbplatsen.';
$string['preferences'] = 'Inställningar';
$string['preferences_available'] = 'Dina personliga inställningar';
$string['preferredcalendar'] = 'Föredragen kalender';
$string['privacy:metadata:calendar:event'] = 'Kalenderkomponenten kan lagra användares händelsedetaljer i kärnsystemet.';
$string['privacy:metadata:calendar:event:description'] = 'Beskrivning av kalenderhändelsen';
$string['privacy:metadata:calendar:event:eventtype'] = 'Händelsetyp för kalenderhändelsen';
$string['privacy:metadata:calendar:event:name'] = 'Namn för kalenderhändelsen';
$string['privacy:metadata:calendar:event:timeduration'] = 'Varaktighet för kalenderhändelsen';
$string['privacy:metadata:calendar:event:timestart'] = 'Starttid för kalenderhändelsen';
$string['privacy:metadata:calendar:event_subscriptions'] = 'Kalenderkomponenten kan lagra användares kalenderprenumerationer i kärnsystemet.';
$string['privacy:metadata:calendar:event_subscriptions:eventtype'] = 'Händelsetyp för kalenderprenumerationen';
$string['privacy:metadata:calendar:event_subscriptions:name'] = 'Namn för kalenderprenumerationen';
$string['privacy:metadata:calendar:event_subscriptions:url'] = 'URL för kalenderprenumerationen';
$string['privacy:metadata:calendar:preferences:calendar_savedflt'] = 'Användarens konfigurerade kalender-händelsevisningstyp.';
$string['recentupcoming'] = 'Senaste och kommande 60 dagar';
$string['repeatedevents'] = 'Återkommande händelser';
$string['repeateditall'] = 'Tillämpa också ändringar på de andra {$a} återkommande händelserna i den här serien';
$string['repeateditthis'] = 'Tillämpa ändringar bara för den här händelsen';
$string['repeatevent'] = 'Upprepa denna händelse';
$string['repeatnone'] = 'Inga upprepningar';
$string['repeatweeksl'] = 'Upprepa veckovis, antal tillfällen att skapa:';
$string['repeatweeksr'] = 'händelser';
$string['requiresaction'] = '{$a} kräver åtgärd';
$string['sat'] = 'Lör';
$string['saturday'] = 'Lördag';
$string['showeventtype'] = 'Visa {$a}händelser';
$string['shown'] = 'visad';
$string['site'] = 'Webbplats';
$string['siteevent'] = 'Webbplatshändelse';
$string['siteevents'] = 'Webbplatshändelser';
$string['spanningevents'] = 'Händelser på gång';
$string['subscriptionname'] = 'Kalendernamn';
$string['subscriptionremoved'] = 'Kalenderprenumeration {$a} borttagen';
$string['subscriptions'] = 'Prenumerationer';
$string['subscriptionsource'] = 'Källa för händelse: {$a}';
$string['subscriptionupdated'] = 'Prenumerationen för \'{$a}\' uppdaterad';
$string['sun'] = 'Sön';
$string['sunday'] = 'Söndag';
$string['thu'] = 'Tor';
$string['thursday'] = 'Torsdag';
$string['timeformat_12'] = '12 timmar (fm/em)';
$string['timeformat_24'] = '24 timmar';
$string['timeperiod'] = 'Tidsperiod';
$string['today'] = 'Idag';
$string['todayplustitle'] = 'Idag {$a}';
$string['tomorrow'] = 'Imorgon';
$string['tt_deleteevent'] = 'Ta bort händelse';
$string['tt_editevent'] = 'Redigera händelse';
$string['tue'] = 'Tis';
$string['tuesday'] = 'Tisdag';
$string['typecategory'] = 'Kategorihändelse';
$string['typeclose'] = 'Stäng händelse';
$string['typecourse'] = 'Kurshändelse';
$string['typedue'] = 'Förfallen händelse';
$string['typegradingdue'] = 'Förfallen betygsättningshändelse';
$string['typegroup'] = 'Grupphändelse';
$string['typeopen'] = 'Öppen händelse';
$string['typesite'] = 'Webbplatshändelse';
$string['typeuser'] = 'Användarhändelse';
$string['upcomingevents'] = 'Kommande händelser';
$string['upcomingeventsfor'] = 'Kommande händelser för:';
$string['urlforical'] = 'URL för iCalendar-export, för att prenumerera på kalender';
$string['user'] = 'Användare';
$string['userevent'] = 'Användarhändelse';
$string['userevents'] = 'Användarhändelser';
$string['viewupcomingactivitiesdue'] = 'Visa aktiviteter som förfaller';
$string['wed'] = 'Ons';
$string['wednesday'] = 'Onsdag';
$string['weekly'] = 'Varje vecka';
$string['weeknext'] = 'Nästa vecka';
$string['weekthis'] = 'Den här veckan';
$string['when'] = 'När';
$string['whendate'] = 'När: {$a}';
$string['yesterday'] = 'Igår';
$string['youcandeleteallrepeats'] = 'Den här händelsen är del i en serie återkommande händelser. Du kan antingen ta bort bara den här händelsen eller alla {$a} händelser i serien på en gång.';
$string['yoursubscriptions'] = 'Importerade kalendrar';
