<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'id', version '4.0'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Aktivitas';
$string['addcategory'] = 'Tambahkan kategori';
$string['addcategoryerror'] = 'Tidak dapat menambahkan kategori.';
$string['addexceptionerror'] = 'Galat terjadi ketika menambahkan pengecualian untuk userid:gradeitem';
$string['addfeedback'] = 'Tambahkan umpan balik';
$string['addgradeletter'] = 'huruf nilai';
$string['addidnumbers'] = 'Tambahkan nomor ID';
$string['additem'] = 'Tambahkan item penilaian';
$string['additionalfeedback'] = 'Umpan balik tambahan';
$string['addoutcome'] = 'Tambahkan capaian';
$string['addoutcomeitem'] = 'Tambahkan item capaian';
$string['addscale'] = 'Tambahkan skala';
$string['adjustedweight'] = 'Bobot disesuaikan';
$string['aggregateextracreditmean'] = 'Rata-rata nilai (dengan kredit tambahan)';
$string['aggregatemax'] = 'Nilai tertinggi';
$string['aggregatemean'] = 'Nilai rata-rata';
$string['aggregatemedian'] = 'Nilai median';
$string['aggregatemin'] = 'Nilai  terendah';
$string['aggregatemode'] = 'Mode nilai';
$string['aggregatenotonlygraded'] = 'Sertakan nilai kosong';
$string['aggregateonlygraded'] = 'Kecualikan nilai kosong';
$string['aggregateonlygraded_help'] = 'Nilai kosong adalah nilai yang hilang dari buku nilai. Mungkin dari pengajuan tugas yang belum dibuat atau dari kuis yang belum dicoba dll. Setelan ini menentukan apakah nilai kosong tidak termasuk dalam agregasi atau dihitung sebagai nilai minimum, misalnya 0 untuk tugas dinilai antara 0 dan 100.';
$string['aggregateoutcomes'] = 'Sertakan capaian pada agregasi';
$string['aggregateoutcomes_help'] = 'Jika diaktifkan, capaian akan disertakan dalam agregasi. Ini dapat menghasilkan total kategori yang tidak terduga.';
$string['aggregatesonly'] = 'Ubah ke hanya agregat';
$string['aggregatesubcatsupgradedgrades'] = 'Catatan: Setelan agregasi "Agregasikan beserta subkategori" telah dihilangkan sebagai bagian dari peningkatan situs. Karena "Agregasikan beserta subkategori" digunakan sebelumnya dalam kursus ini, anda direkomendasikan untuk meninjau ulang perubahan ini pada buku nilai.';
$string['aggregatesum'] = 'Natural';
$string['aggregateweightedmean'] = 'Bobot rata-rata nilai';
$string['aggregateweightedmean2'] = 'Bobot rata-rata nilai sederhana';
$string['aggregation'] = 'Agregasi';
$string['aggregation_help'] = 'Agregasi menentukan bagaimana nilai-nilai dalam kategori dikombinasikan, seperti <br>
* Nilai Rata-rata - Penjumlahan dari semua nilai dibagi dengan jumlah nilai yang ada <br>
* Nilai Median - Nilai tengah ketika nilai-nilai disusun sesuai ukuran <br>
* Nilai Terendah <br>
* Nilai Tertinggi <br>
* Nilai Modus - Nilai yang paling sering muncul <br>
* Natural - Jumlah dari semua bilangan nilai diukur dengan bobotnya';
$string['aggregation_link'] = 'nilai/agregasi';
$string['aggregationcoef'] = 'Koefisien agregasi';
$string['aggregationcoefextra'] = 'Kredit ekstra';
$string['aggregationcoefextra_help'] = 'Jika agregasi "Natural\' atau \'Rata-rata tertimbang sederhana\' dan kotak centang kredit tambahan dicentang, nilai maksimum item nilai tidak ditambahkan ke nilai maksimum kategori. Ini akan menghasilkan kemungkinan pencapaian nilai maksimum dalam kategori tanpa nilai maksimum di semua item nilai. Jika administrator situs telah mengaktifkan nilai melebihi maksimum, mungkin ada nilai melebihi maksimum. Jika agregasinya adalah \'Rata-rata nilai (dengan kredit tambahan)\' dan kredit tambahan ditetapkan ke nilai yang lebih besar dari nol, kredit tambahan adalah faktor yang digunakan untuk mengalikan nilai sebelum menambahkannya ke total setelah penghitungan nilai berarti.';
$string['aggregationcoefextra_link'] = 'nilai/agregasi';
$string['aggregationcoefextrasum'] = 'Kredit ekstra';
$string['aggregationcoefextrasum_help'] = 'Jika kotak centang kredit ekstra dicentang, nilai maksimum item nilai tidak ditambahkan ke nilai maksimum kategori, yang menghasilkan kemungkinan mencapai nilai maksimum (atau nilai lebih dari maksimum jika diaktifkan oleh administrator situs) dalam kategori tanpa memiliki nilai maksimum di semua item nilai.';
$string['aggregationcoefextrasum_link'] = 'nilai/agregasi';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = 'Bobot kredit ekstra';
$string['aggregationcoefextraweight_help'] = 'Jika bobot kredit ekstra diatur pada bilangan lebih besar dari nol, nilai tersebut akan dipergunakan sebagai kredit ekstra ketika agregasi. Angka tersebut adalah faktor, yang dengannya nilai dikalikan sebelum menambahkannya ke jumlah untuk penghitungan rata-rata.';
$string['aggregationcoefextraweight_link'] = 'nilai/agregasi';
$string['aggregationcoefweight'] = 'Bobot Item';
$string['aggregationcoefweight_help'] = 'Bobot item digunakan dalam agregasi kategori untuk mempengaruhi pentingnya item dibandingkan dengan item nilai lain dalam kategori yang sama.';
$string['aggregationcoefweight_link'] = 'nilai/agregasi';
$string['aggregationhintdropped'] = '( Di drop )';
$string['aggregationhintexcluded'] = '( Dikecualikan )';
$string['aggregationhintextra'] = '( Kredit ekstra )';
$string['aggregationhintnovalue'] = '( Kosong )';
$string['aggregationofa'] = 'Agregasi dari {$a}';
$string['aggregationposition'] = 'Posisi agregasi';
$string['aggregationposition_help'] = 'Setelan ini menentukan apakah kolom total kategori dan pelajran ditampilkan pertama atau terakhir dalam laporan buku nilai.';
$string['aggregationsvisible'] = 'Tipe agregat tersedia';
$string['aggregationsvisiblehelp'] = 'Pilih semua tipe agregasi yang seharusnya tersedia. Tahan tombol Ctrl untuk memilih beberapa item.';
$string['allgrades'] = 'Semua nilai berdasarkan kategori';
$string['allstudents'] = 'Semua siswa';
$string['allusers'] = 'Semua pengguna';
$string['autosort'] = 'Urutkan otomatis';
$string['availableidnumbers'] = 'Nomor ID yang tersedia';
$string['average'] = 'Rata-rata';
$string['averagesdecimalpoints'] = 'Desimal pada kolom rata-rata';
$string['averagesdecimalpoints_help'] = 'Setelan ini menentukan jumlah desimal yang ditampilkan untuk setiap rata-rata atau mengetahui apakah setelan keseluruhan mengenai desimal untuk kategori atau item nilai telah digunakan atau belum (turunan).';
$string['averagesdisplaytype'] = 'Tipe tampilan kolom rata-rata';
$string['averagesdisplaytype_help'] = 'Setelan ini menentukan apakah rata-rata ditampilkan sebagai nilai riil, persentase atau huruf, atau untuk mengetahui apakah tipe tampilan untuk kategori atau item nilai telah digunakan atau belum (turunan).';
$string['backupwithoutgradebook'] = 'Tidak terdapat setelan buku nilai pada cadangan';
$string['badgrade'] = 'Nilai yang dimasukkan tidak benar';
$string['badlyformattedscale'] = 'Silakan masukkan daftar bilangan yang dipisahkan dengan koma (setidaknya diperlukan dua bilangan).';
$string['baduser'] = 'Pengguna yang dimasukkan tidak benar';
$string['bonuspoints'] = 'Poin bonus';
$string['bulkcheckboxes'] = 'Kotak pilihan massal';
$string['calculatedgrade'] = 'Nilai terhitung';
$string['calculation'] = 'Penghitungan';
$string['calculation_help'] = 'Penghitungan nilai adalah rumus yang digunakan untuk mementukan nilai. Rumus harus dimulai dengan tanda sama dengan (=) dan kemudian menggunakan tanda-tanda matematis umum, seperti max, min dan sum. Apabila diinginkan, item nilai lainnya dapat dimasukkan kedalam penghitungan dengan mengetikkan nomor-nomor ID nya dalam kurung siku lapis dua.';
$string['calculation_link'] = 'nilai/penghitungan';
$string['calculationadd'] = 'Tambahkan penghitungan';
$string['calculationedit'] = 'Sunting penghitungan';
$string['calculationsaved'] = 'Penghitungan disimpan';
$string['calculationview'] = 'Lihat penghitungan';
$string['cannotaccessgroup'] = 'Maaf, tidak dapat mengakses nilai dari grup yang dipilih.';
$string['categories'] = 'Kategori';
$string['category'] = 'Kategori';
$string['categoryedit'] = 'Edit kategori';
$string['categoryname'] = 'Nama kategori';
$string['categorytotal'] = 'Total kategori';
$string['categorytotalfull'] = 'Total {$a->category}';
$string['categorytotalname'] = 'Nama total kategori';
$string['changedefaults'] = 'Ubah setelan bawaan';
$string['changereportdefaults'] = 'Ubah laporan bawaan';
$string['chooseaction'] = 'Pilih aksi . . .';
$string['choosecategory'] = 'Pilih kategori';
$string['collapsecriterion'] = 'Ciutkan kriteria';
$string['combo'] = 'Tab dan menu tarik-turun';
$string['compact'] = 'Ringkas';
$string['componentcontrolsvisibility'] = 'Apakah item nilai ini disembunyikan dikendalikan oleh setelan aktivitas.';
$string['contract'] = 'Kategori kontrak';
$string['contributiontocoursetotal'] = 'Kontribusi pada total kursus';
$string['controls'] = 'Kontrol';
$string['courseavg'] = 'Rata-rata kursus';
$string['coursegradecategory'] = 'Kategori penilaian kursus';
$string['coursegradedisplaytype'] = 'Tipe tampilan nilai kursus';
$string['coursegradedisplayupdated'] = 'Tipe tampilan nilai kursus telah diperbarui';
$string['coursegradesettings'] = 'Setelan penilaian kursus';
$string['coursename'] = 'Nama kursus';
$string['coursescales'] = 'Skala kursus';
$string['coursesettings'] = 'Setelan kursus';
$string['coursesettingsexplanation'] = 'Setelan ini menentukan bagaimana buku nilai muncul untuk semua peserta dalam kursus.';
$string['coursesiamtaking'] = 'kursus yang saya ikuti';
$string['coursesiamteaching'] = 'Saya mengajar';
$string['coursetotal'] = 'Nilai akhir';
$string['createcategory'] = 'Buat kategori';
$string['createcategoryerror'] = 'Tidak dapat membuat kategori baru';
$string['creatinggradebooksettings'] = 'Membuat setelan buku nilai';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Agregasi induk saat ini';
$string['curveto'] = 'Lekukkan ke';
$string['decimalpoints'] = 'digit desimal keseluruhan';
$string['decimalpoints_help'] = 'Setelan ini menentukan jumlah desimal yang ditampilkan untuk setiap nilai. Hal ini tidak akan mempengaruhi penghitungan nilai yang dibuat dengan akurasi hingga 5 angka desimal.';
$string['default'] = 'Bawaan';
$string['defaultprev'] = 'Bawaan ({$a})';
$string['deletecategory'] = 'Hapus kategori';
$string['deletescale'] = 'Hapus skala';
$string['disablegradehistory'] = 'Nonaktifkan riwayat penilaian';
$string['disablegradehistory_help'] = 'Nonaktifkan pelacakan riwayat perubahan pada tabel yang berhubungan dengan nilai. Hal ini mungkin dapat sedikit mempercepat server dan menghemat ruang pada basis data.';
$string['displaylettergrade'] = 'Tampilkan nilai huruf';
$string['displaypercent'] = 'Tampilkan persentase';
$string['displaypoints'] = 'Tampilkan angka';
$string['displayweighted'] = 'Tampilkan nilai berbobot';
$string['dropdown'] = 'Menu tarik-turun';
$string['droplow'] = 'Drop yang terendah';
$string['droplow_help'] = 'Setelan ini memungkinkan sejumlah nilai terendah yang ditentukan untuk dikecualikan dari agregasi.';
$string['droplowestvalue'] = 'Atur drop bilangan nilai yang terendah';
$string['droplowestvalues'] = 'Drop {$a} bilangan terendah';
$string['dropped'] = 'Di-drop';
$string['dropxlowest'] = 'Drop X terendah';
$string['dropxlowestwarning'] = 'Catatan: Jika anda menggunakan drop x terendah, proses penilaian akan mengasumsikan bahwa semua item dalam kategori tersebut memiliki bilangan poin yang sama. Jika bilangan poin berbeda, hasil tidak akan dapat diperkirakan.';
$string['duplicatedgradeitem'] = '{$a} (salinan)';
$string['duplicatescale'] = 'Gandakan skala';
$string['edit'] = 'Edit';
$string['editcalculation'] = 'Edit perhitungan';
$string['editcalculationverbose'] = 'Edit perhitungan untuk {$a->category} {$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'Edit umpan balik';
$string['editgrade'] = 'Edit nilai';
$string['editgradeletters'] = 'Edit nilai huruf';
$string['editoutcome'] = 'Sunting capaian';
$string['editoutcomes'] = 'Sunting capaian';
$string['editscale'] = 'Edit skala';
$string['edittree'] = 'Setelan';
$string['editverbose'] = 'Edit {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'Aktifkan AJAX';
$string['enableajax_help'] = 'Menambahkan lapisan fungsionalitas AJAX ke laporan penilaian, menyederhanakan dan mempercepat operasi umum. Tergantung pada Javascript yang diaktifkan di tingkat peramban pengguna.';
$string['enableoutcomes'] = 'Aktifkan capaian';
$string['enableoutcomes_help'] = 'Jika diaktifkan, item penilaian dapat dinilai menggunakan satu atau lebih skala yang terkait dengan pernyataan capaian.';
$string['encoding'] = 'Pengodean';
$string['encoding_help'] = 'Pilih karakter pengodean yang digunakan untuk data. (Pengodean standar adalah UTF-8.) Apabila anda salah memilih pengodean, anda dapat mengetahuinya ketika mempratinjau data untuk diimpor.';
$string['errorcalculationbroken'] = 'Kemungkinan referensi sirkular atau rumus penghitungan yang rusak';
$string['errorcalculationnoequal'] = 'Rumus harus dimulai dengan tanda sama dengan (=1+2)';
$string['errorcalculationunknown'] = 'Rumus tidak benar';
$string['errorgradevaluenonnumeric'] = 'Non-angka untuk nilai rendah dan tinggi diterima';
$string['errornocalculationallowed'] = 'Kalkulasi tidak diizinkan untuk item ini';
$string['errornocategorisedid'] = 'Tidak bisa mendapatkan ID yang tak terkategorisasi!';
$string['errornocourse'] = 'Informasi kursus tidak didapatkan';
$string['errorreprintheadersnonnumeric'] = 'Bilangan non-angka untuk reprint-headers diterima';
$string['errorsavegrade'] = 'Maaf, tidak dapat menyimpan nilai.';
$string['errorsettinggrade'] = 'Galat saat menyimpan nilai "{$a->itemname}" untuk ID pengguna {$a->userid}';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Galat saat memperbarui setelan "Hanya agregat nilai tak kosong" pada ID kategori nilai {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Galat saat memperbarui setelan "Sertakan hasil dalam agregasi" dari ID kategori nilai {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'Galat saat memperbarui tipe agregasi pada ID kategori nilai {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'Galat saat memperbarui koefisien agregasi (bobot atau kredit ekstra) pada ID item nilai {$a->id}';
$string['eventgradedeleted'] = 'Nilai dihapus';
$string['eventgradeexported'] = 'Nilai diekspor';
$string['eventgradeitemcreated'] = 'Item nilai dibuat';
$string['eventgradeitemdeleted'] = 'Item nilai dihapus';
$string['eventgradeitemupdated'] = 'Item nilai diperbarui';
$string['eventgradelettercreated'] = 'Nilai huruf dibuat';
$string['eventgradeletterdeleted'] = 'Nilai huruf dihapus';
$string['eventgradeletterupdated'] = 'Memperbarui nilai huruf';
$string['eventgradeviewed'] = 'Melihat nilai pada buku nilai';
$string['eventscalecreated'] = 'Skala dibuat';
$string['eventscaledeleted'] = 'Skala dihapus';
$string['eventscaleupdated'] = 'Memperbarui skala';
$string['eventusergraded'] = 'Pengguna dinilai';
$string['excluded'] = 'Tidak disertakan';
$string['excluded_help'] = 'Apabila dipilih, nilai tidak akan dimasukkan ke agregasi manapun.';
$string['expand'] = 'Perluas kategori';
$string['expandcriterion'] = 'Perluas kriteria';
$string['export'] = 'Ekspor';
$string['exportalloutcomes'] = 'Ekspor semua capaian';
$string['exportfeedback'] = 'Masukkan umpan balik pada ekspor';
$string['exportfeedback_desc'] = 'Dapat disampingkan ketika ekspor.';
$string['exportformatoptions'] = 'Ekspor opsi format';
$string['exportonlyactive'] = 'Sertakan pengguna yang ditangguhkan';
$string['exportonlyactive_help'] = 'Hanya memasukkan siswa yang pendaftarannya aktif dan tidak ditangguhkan ke dalam ekspor';
$string['exportplugins'] = 'Ekspor pengaya';
$string['exportsettings'] = 'Ekspor setelan';
$string['exportto'] = 'Ekspor ke';
$string['externalurl'] = 'URL eksternal';
$string['externalurl_desc'] = 'Jika buku nilai eksternal digunakan, URL sebaiknya ditampilkan di sini.';
$string['extracreditvalue'] = 'Bilangan kredit ekstra untuk {$a}';
$string['extracreditwarning'] = 'Catatan: Mengatur semua item kategori ke kredit ekstra akan mengeluarkan item tersebut dari penghitungan nilai dengan efektif, karena tidak akan ada total poin.';
$string['fail'] = 'Gagal';
$string['feedback'] = 'Umpan balik';
$string['feedback_help'] = 'Memberikan izin untuk menulis komentar mengenai nilai.';
$string['feedbackadd'] = 'Tambahkan umpan balik';
$string['feedbackedit'] = 'Sunting umpan balik';
$string['feedbackfiles'] = 'Berkas umpan balik';
$string['feedbackforgradeitems'] = 'Umpan balik untuk {$a}';
$string['feedbackhistoryfiles'] = 'berkas riwayat umpan balik';
$string['feedbacks'] = 'Umpan balik';
$string['feedbacksaved'] = 'Umpan balik tersimpan';
$string['feedbackview'] = 'Lihat umpan balik';
$string['finalgrade'] = 'Nilai final';
$string['finalgrade_help'] = 'Jika kotak centang yang diganti dipilih, nilai dapat ditambahkan atau diubah.';
$string['fixedstudents'] = 'Kolom siswa statis';
$string['fixedstudents_help'] = 'Mengizinkan nilai untuk digulir secara horizontal tanpa mengabaikan kolom siswa, dengan menjadikannya statis.';
$string['forceimport'] = 'Paksa impor';
$string['forceimport_help'] = 'Paksa pengimporan nilai meskipun nilai tersebut telah diperbarui setelah berkas impor telah diekspor';
$string['forceoff'] = 'Paksa: Mati';
$string['forceon'] = 'Paksa: Hidup';
$string['forelementtypes'] = 'untuk yang dipilih {$a}';
$string['forstudents'] = 'Untuk siswa';
$string['full'] = 'Penuh';
$string['fullmode'] = 'Ubah ke tampilan penuh';
$string['generalsettings'] = 'Setelan umum';
$string['grade'] = 'Nilai';
$string['grade_help'] = 'Nilai yang akan diberikan kepada siswa atas pekerjaan mereka.';
$string['gradeadministration'] = 'Administrasi Nilai';
$string['gradealreadyupdated'] = 'Nilai {$a} belum diimpor karena nilai dalam file impor lebih lama dari pada laporan penilaian. Untuk tetap melanjutkan impor nilai, gunakan opsi impor paksa.';
$string['gradeanalysis'] = 'Analisis nilai';
$string['gradebook'] = 'Buku nilai';
$string['gradebookcalculationsfixbutton'] = 'Terima perubahan nilai dan perbaiki kesalahan penghitungan';
$string['gradebookcalculationsuptodate'] = 'Sirkulasi pada buku nilai sudah mutakhir. Anda mungkin perlu memuat ulang halaman ini untuk melihat perubahan.';
$string['gradebookcalculationswarning'] = 'Catatan: Beberapa galat terdeteksi ketika menghitung nilai-nilai yang ditampilkan pada buku nilai. Jika kursus anda belum dimulai atau masih berjalan, anda direkomendasikan untuk memperbaiki galat ini dengan menekan tombol di bawah ini, meskipun ini akan berakibat beberapa nilai akan berubah. Jika kursus anda telah selesai dan nilai telah dimasukkan, lebih baik anda mengabaikan galat ini. Versi terbaru adalah {$a->currentversion}; anda menggunakan versi buku nilai {$a->gradebookversion}. Anda dapat melihat daftar perubahan pada perubahan penghitungan buku nilai.';
$string['gradebookhiddenerror'] = 'Saat ini buku nilai disetel untuk disembunyikan dari siswa.';
$string['gradebookhistories'] = 'Riwayat penilaian';
$string['gradebooksetup'] = 'Setelan Buku nilaI';
$string['gradeboundary'] = 'Batasan nilai huruf';
$string['gradeboundary_help'] = 'Setelan ini menentukan persentase minimum di mana nilai akan diberi nilai huruf.';
$string['gradecategories'] = 'Kategori penilaian';
$string['gradecategory'] = 'Kategori penilaian';
$string['gradecategoryonmodform'] = 'Kategori penilaian';
$string['gradecategoryonmodform_help'] = 'Setelan ini mengatur kategori di mana nilai aktivitas ini akan ditempatkan dalam buku nilai.';
$string['gradecategorysettings'] = 'Setelan kategori penilaian';
$string['gradedisplay'] = 'Tampilkan nilai';
$string['gradedisplaytype'] = 'Tipe tampilan nilai';
$string['gradedisplaytype_help'] = 'Setelan ini menentukan bagaimana nilai ditampilkan pada laporan penilai dan pengguna * Riil - Nilai asli * Presentasi * Huruf dan kata yang digunakan untuk mereprentasikan rentang nilai';
$string['gradedon'] = 'Dinilai: {$a}';
$string['gradeexport'] = 'Ekspor nilai';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = 'Nilai ruas profil tersuai ekspor';
$string['gradeexportcustomprofilefields_desc'] = 'Sertakan bidang profil kustom ini dalam ekspor nilai, dipisahkan dengan koma.';
$string['gradeexportdecimalpoints'] = 'Digit desimal ekspor nilai';
$string['gradeexportdecimalpoints_desc'] = 'Jumlah digit desimal yang ditampilkan untuk ekspor. Dapat ditimpa ketika ekspor.';
$string['gradeexportdisplaytype'] = 'Tipe tampilan ekspor nilai';
$string['gradeexportdisplaytype_desc'] = 'Nilai dapat ditampilkan sebagai nilai riil, persentase (dengan merujuk pada nilai minimum dan maksimum) atau nilai huruf (A, B, C dll. . .) ketika ekspor. Dapat ditimpa saat ekspor.';
$string['gradeexportdisplaytypes'] = 'Tipe tampilan ekspor nilai';
$string['gradeexportuserprofilefields'] = 'Ruas profil pengguna untuk ekspor nilai';
$string['gradeexportuserprofilefields_desc'] = 'Masukkan ruas profil pengguna ini ke ekspor nilai dengan dibatasi koma.';
$string['gradeforstudent'] = '{$a->student}

{$a->item}{$a->feedback}';
$string['gradegrademinmax'] = 'Nilai minimum dan maksimum awal';
$string['gradehelp'] = 'Bantuan penilaian';
$string['gradehistorylifetime'] = 'Seluruh riwayat penilaian';
$string['gradehistorylifetime_help'] = 'Ini menentukan lamanya waktu Anda ingin menyimpan riwayat perubahan dalam tabel terkait nilai. Dianjurkan untuk menyimpannya selama mungkin. Jika Anda mengalami masalah kinerja atau memiliki ruang basis data terbatas, cobalah untuk mengatur nilai yang lebih rendah.';
$string['gradeimport'] = 'Impor nilai';
$string['gradeimportfailed'] = 'Pelaksanaan impor nilai gagal. Keterangan:';
$string['gradeitem'] = 'Item penilaian';
$string['gradeitemaddusers'] = 'Tidak disertakan dalam penilaian';
$string['gradeitemadvanced'] = 'Opsi item nilai lanjutan';
$string['gradeitemadvanced_help'] = 'Pilih semua elemen yang harus ditampilkan sebagai lanjutan ketika menyunting item nilai';
$string['gradeitemislocked'] = 'Aktivitas ini dikunci pada buku nilai. Perubahan yang dibuat pada nilai di aktivitas ini tidak akan disalin ke buku nilai hingga dibuka kembali.';
$string['gradeitemlocked'] = 'Penilaian terkunci';
$string['gradeitemmembersselected'] = 'Tidak disertakan dalam penilaian';
$string['gradeitemminmax'] = 'Nilai minimum dan maksimum seperti yang dispesifikasikan pada setelan item nilai';
$string['gradeitemnonmembers'] = 'Sertakan dalam penilaian';
$string['gradeitemremovemembers'] = 'Sertakan dalam penilaian';
$string['gradeitems'] = 'Item penilaian';
$string['gradeitemsettings'] = 'Setelan item penilaian';
$string['gradeitemsinc'] = 'Item penilaian yang dimasukkan';
$string['gradeletter'] = 'Huruf Nilai';
$string['gradeletter_help'] = 'Huruf nilai adalah huruf, A, B, C, ..., atau kata-kata seperti Luar Biasa, Sempurna, Lulus, ..., yang digunakan untuk merepresentasikan rentang nilai.';
$string['gradeletternote'] = 'Untuk menghapus huruf nilai, kosongkan tiga area teks untuk huruf tersebut dan tekan "kirim"';
$string['gradeletteroverridden'] = 'Nilai huruf pada setelan bawaan sekarang tertimpa';
$string['gradeletters'] = 'Huruf Nilai';
$string['gradelocked'] = 'Nilai dikunci';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Nilai maksimum';
$string['grademax_help'] = 'Setelan ini menentukan nilai maksimum ketika menggunakan tipe nilai bilangan. Nilai maksimum untuk sebuah item nilai berbasis aktivitas diatur pada halaman setelan aktivitas.';
$string['grademin'] = 'Nilai minimum';
$string['grademin_help'] = 'Setelan ini menentukan nilai minimum ketika menggunakan tipe nilai bilangan.';
$string['gradenotificationmessage'] = 'Anda mendapatkan umpan balik pada hasil pekerjaan "{$a}"';
$string['gradenotificationsubject'] = 'Anda telah dinilai';
$string['gradeoutcomeitem'] = 'Nilai item capaian';
$string['gradeoutcomes'] = 'Capaian';
$string['gradeoutcomescourses'] = 'Capaian Kursus';
$string['gradepass'] = 'Nilai Kelulusan';
$string['gradepass_help'] = 'Setelan ini menentukan nilai minimum yang diperlukan untuk lulus. Bilangan tersebut digunakan pada penyelesaian aktivitas dan kursus, dan pada buku nilai, nilai lulus akan disoroti warna hijau dan merah untuk nilai yang tidak lulus.';
$string['gradepassgreaterthangrade'] = 'Nilai untuk lulus tidak dapat lebih besar dari nilai maksimum yang dapat di raih {$a}';
$string['gradepointdefault'] = 'Poin nilai bawaan';
$string['gradepointdefault_help'] = 'Setelan ini menentukan nilai bawaan untuk poin nilai yang tersedia di item penilaian.';
$string['gradepointdefault_validateerror'] = 'Setelan ini harus berupa bilangan bulat antara 1 dan nilai maksimum.';
$string['gradepointmax'] = 'Poin nilai maksimum';
$string['gradepointmax_help'] = 'Setelan ini menentukan bilangan poin nilai maksimum yang tersedia pada sebuah aktivitas.';
$string['gradepointmax_validateerror'] = 'Setelan ini harus berupa bilangan bulat antara 1 dan 10000.';
$string['gradepreferences'] = 'Preferensi nilai';
$string['gradepreferenceshelp'] = 'Bantuan mengenai preferensi nilai';
$string['gradepublishing'] = 'Aktifkan penerbitan';
$string['gradepublishing_help'] = 'Publikasi Penilaian adalah cara mengimpor dan mengekspor nilai melalui URL tanpa masuk ke Moodle. Jika diaktifkan, administrator dan pengguna dengan izin untuk mempublikasikan nilai (secara bawaan, pengguna dengan peran manajer saja) disediakan dengan setelan penerbitan ekspor kelas di setiap buku nilai kursus.';
$string['gradepublishinglink'] = 'Unduh: {$a}';
$string['gradereport'] = 'Laporan nilai';
$string['graderreport'] = 'Laporan penilaian siswa';
$string['grades'] = 'Nilai';
$string['gradesforuser'] = 'Nilai untuk {$a->user}';
$string['gradesmoduledeletionpendingwarning'] = 'Peringatan: Penghapusan aktivitas sedang berlangsung! Beberapa nilai akan dihapus.';
$string['gradesmoduledeletionprefix'] = '[Penghapusan sedang berlangsung]';
$string['gradesonly'] = 'Ubah ke nilai saja';
$string['gradessettings'] = 'Setelan penilaian';
$string['gradetype'] = 'Tipe nilai';
$string['gradetype_help'] = 'Ada 4 tipe nilai:
* Tidak ada - Penilaian tidak dimungkinkan
* Bilangan - Sebuah bilangan numerik dengan maksimum dan minimum
* Skala - Sebuah item pada daftar
* Teks - Umpan balik saja Hanya tipe nilai bilangan dan skala saja yang dapat diagregasikan. Tipe nilai untuk item nilai berbasis aktivitas diatur pada halaman setelan aktivitas.';
$string['gradevaluetoobig'] = 'Salah satu bilangan nilai lebih besar daripada nilai maksimum yang diperbolehkan {$a}';
$string['gradeview'] = 'Lihat nilai';
$string['gradewasmodifiedduringediting'] = 'Nilai yang dimasukkan pada {$a->itemname} untuk {$a->username} telah diabaikan, karena telah diperbarui oleh orang lain.';
$string['gradeweighthelp'] = 'Bantuan mengenai bobot nilai';
$string['gradingmodulename'] = 'Penilaian ({$a})';
$string['groupavg'] = 'Rata-rata grup';
$string['hidden'] = 'Disembunyikan';
$string['hidden_help'] = 'Apabila dipilih, nilai akan disembunyikan dari siswa. Tanggal "sembunyikan hingga" dapat diisi apabila diinginkan, untuk memunculkan nilai setelah penilaian selesai.';
$string['hiddenasdate'] = 'Tampilkan tanggal nilai diberikan untuk nilai-nilai yang disembunyikan';
$string['hiddenasdate_help'] = 'Apabila pengguna tidak dapat melihat nilai-nilai yang disembunyikan, tampilkan tanggal pengiriman nilai daripada.';
$string['hiddenuntil'] = 'Disembunyikan hingga';
$string['hiddenuntildate'] = 'Disembunyikan hingga: {$a}';
$string['hideadvanced'] = 'Sembunyikan fitur lanjutan';
$string['hideaverages'] = 'Sembunyikan rata-rata';
$string['hidecalculations'] = 'Sembunyikan kalkulasi';
$string['hidecategory'] = 'Disembunyikan';
$string['hideeyecons'] = 'Sembunyikan ikon \'sembunyikan/tampilkan\'';
$string['hidefeedback'] = 'Sembunyikan umpan balik';
$string['hideforcedsettings'] = 'Sembunyikan setelan yang dipaksakan';
$string['hideforcedsettings_help'] = 'Jangan tampilkan setelan yang dipaksakan pada antarmuka pengguna penilaian.';
$string['hidegroups'] = 'Sembunyikan grup';
$string['hidelocks'] = 'Sembunyikan kunci';
$string['hidenooutcomes'] = 'Tampilkan capaian';
$string['hidequickfeedback'] = 'Sembunyikan umpan balik cepat';
$string['hideranges'] = 'Sembunyikan rentang';
$string['hidetotalifhiddenitems'] = 'Sembunyikan total jika berisi item tersembunyi';
$string['hidetotalifhiddenitems_help'] = 'Setelan ini menentukan apakah total yang berisi item nilai tersembunyi diperlihatkan kepada siswa atau diganti dengan tanda hubung (-). Jika ditampilkan, total dapat dihitung dengan mengecualikan atau termasuk item tersembunyi.

Jika item tersembunyi dikecualikan, total akan berbeda dengan total yang dilihat oleh pengajar di laporan penilai, karena pengajar selalu melihat total yang dihitung dari semua item, tersembunyi atau tidak disembunyikan. Jika item tersembunyi dimasukkan, siswa mungkin dapat menghitung item tersembunyi.';
$string['hidetotalshowexhiddenitems'] = 'Tampilkan total tanpa memasukkan item yang disembunyikan';
$string['hidetotalshowinchiddenitems'] = 'Tampilkan total dengan memasukkan item yang disembunyikan';
$string['hideverbose'] = 'Sembunyikan {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Susun berdasarkan nilai tinggi keatas';
$string['highgradedescending'] = 'Urut dari nilai tertinggi ke nilai terendah';
$string['highgradeletter'] = 'Tinggi';
$string['identifier'] = 'Identifikasi pengguna dengan';
$string['idnumbers'] = 'Nomor ID';
$string['ignore'] = 'Abaikan';
$string['import'] = 'Impor';
$string['importcsv'] = 'Impor CSV';
$string['importcsv_help'] = 'Nilai dapat diimpor melalui berkas CSV dengan format berikut: * Setiap garis berkas mengandung satu rekaman * Setiap rekaman adalah rangkaian data dipisahkan dengan koma atau dengan pemisah alternatif * Rekaman pertama mengandung daftar ruas nama yang mendefinasikan format seluruh berkas * Sebuah ruas nama yang berisi data identitas pengguna diperlukan, entah itu nama pengguna, nomor ID, atau alamat surel berkas dimana format yang  benar didapatkan dengan mengekspor beberapa nilai dahulu. Berkas tersebut kemudian dapat disunting dan disimpan sebagai berkas CSV.';
$string['importcsv_link'] = 'grade/import/csv/index';
$string['importcustom'] = 'Impor sebagai capaian kustom (hanya kursus ini)';
$string['importdata'] = 'Data';
$string['importdata_help'] = 'Nilai dapat ditempelkan langsung dari OpenDocument atau spreadsheet Excel dengan format sebagai berikut:

* Setidaknya satu kolom harus berisi data identitas pengguna - nama pengguna, alamat surel, atau nomor ID.
* Kolom lain harus memiliki judul untuk aktivitas atau item nilai yang ada.

Lembar sebar yang diformat dengan benar dapat diperoleh dengan mengekspor beberapa nilai terlebih dahulu. Lembar sebar kemudian dapat diedit untuk menambahkan lebih banyak nilai dan disimpan.

Pilih dan salin kolom yang ingin Anda impor dari spreadsheet, lalu tempelkan ke ruas ini.';
$string['importerror'] = 'Terjadi galat. Naskah ini tidak dipanggil dengan parameter yang benar.';
$string['importfailed'] = 'Impor gagal. Tidak ada data terimpor.';
$string['importfeedback'] = 'Impor umpan balik';
$string['importfile'] = 'Impor berkas';
$string['importfilemissing'] = 'Tidak ada berkas diterima, kembali ke form dan pastikan anda mengunggah berkas yang benar.';
$string['importfrom'] = 'Impor dari';
$string['importoutcomenofile'] = 'Berkas yang diunggah kosong atau korup. Silakan pastikan bahwa ini adalah berkas yang benar. Masalah terdeteksi pada garis {$a}; hal ini dipicu oleh garis-garis data tidak memiliki kolom sebanyak garis pertama (garis tajuk) atau jika berkas yang diimpor kehilangan tajuk yang diperlukan. Lihat pada berkas yang diekspor untuk contoh berkas dengan tajuk yang benar.';
$string['importoutcomes'] = 'Impor capaian';
$string['importoutcomes_help'] = 'Capaian dapat diimpor melalui berkas csv dengan format seperti untuk berkas csv hasil ekspor.';
$string['importoutcomes_link'] = 'grade/outcome';
$string['importoutcomesuccess'] = 'Capaian yang diimpor "{$a->name}" dengan ID # {$a->id}';
$string['importplugins'] = 'Impor pengaya';
$string['importpreview'] = 'Berkas yang diunggah kosong atau korup. Silakan pastikan bahwa ini adalah berkas yang benar. Masalah terdeteksi pada garis {$a}; hal ini dipicu oleh garis-garis data tidak memiliki kolom sebanyak garis pertama (garis tajuk) atau jika berkas yang diimpor kehilangan tajuk yang diperlukan. Lihat pada berkas yang diekspor untuk contoh berkas dengan tajuk yang benar.';
$string['importsettings'] = 'Setelan impor';
$string['importskippednomanagescale'] = 'Anda tidak memiliki izin untuk menambahkan skala baru, jadi capaian  "{$a}" dilewati karena diperlukan pembuatan skala baru';
$string['importskippedoutcome'] = 'Capaian dengan nama singkat "{$a}" sudah ada dalam konteks ini, capaian dalam berkas yang diimpor dilewati.';
$string['importstandard'] = 'Impor sebagai capaian bawaan';
$string['importsuccess'] = 'Impor nilai berhasil';
$string['importxml'] = 'Impor XML';
$string['includescalesinaggregation'] = 'Masukkan skala dalam agregasi';
$string['includescalesinaggregation_help'] = 'Anda dapat mengubah apakah skala akan disertakan sebagai angka di semua nilai gabungan di semua buku nilai di semua kursus. PERHATIAN: mengubah setelan ini akan memaksa semua nilai gabungan untuk dihitung ulang.';
$string['incorrectcourseid'] = 'ID Kursus salah';
$string['incorrectcustomscale'] = '(Skala tersuai salah, silakan ganti.)';
$string['incorrectminmax'] = 'Minimum harus lebih rendah dari maksimum';
$string['inherit'] = 'Turunan';
$string['intersectioninfo'] = 'Info Siswa/Nilai';
$string['invalidgradeexporteddate'] = 'Tanggal ekspor tidak benar karena sudah lebih dari satu tahun, masa depan atau karena format tanggal tidak benar.';
$string['item'] = 'Item';
$string['iteminfo'] = 'Info item';
$string['iteminfo_help'] = 'Setelan ini menyediakan ruang untuk memasukkan informasi item. Informasi hanya ditampilkan di sini.';
$string['itemname'] = 'Nama item';
$string['itemnamehelp'] = 'Nama item ini didorong oleh modul.';
$string['items'] = 'Item';
$string['itemsedit'] = 'Edit item penilaian';
$string['keephigh'] = 'Simpan yang tertinggi';
$string['keephigh_help'] = 'Apabila diaktifkan, opsi ini hanya akan menyimpan X nilai tertinggi, dengan X adalah bilangan yang dipilih pada opsi ini.';
$string['keephighestvalues'] = 'Simpan {$a} bilangan tertinggi';
$string['keymanager'] = 'Manajer kunci';
$string['lessthanmin'] = 'Nilai yang dimasukkan pada {$a->itemname} untuk {$a->username} di bawah bilangan minimum yang ditetapkan';
$string['letter'] = 'Huruf';
$string['lettergrade'] = 'Nilai huruf';
$string['lettergradenonnumber'] = 'Nilai rendah dan/atau tinggi bukan numerik';
$string['letterpercentage'] = 'Huruf (persentase)';
$string['letterreal'] = 'Huruf (riil)';
$string['letters'] = 'Nilai Huruf';
$string['linkedactivity'] = 'Aktivitas tertaut';
$string['linkedactivity_help'] = 'Setelan ini menentukan aktivitas yang ditautkan ke item capaian ini. Ini dapat digunakan untuk mengukur kinerja siswa pada kriteria yang tidak dinilai oleh penilaian aktivitas.';
$string['linktoactivity'] = 'Tautan ke aktivitas {$a->name} {$a->title}';
$string['lock'] = 'Kunci';
$string['locked'] = 'Terkunci';
$string['locked_help'] = 'Apabila dipilih, nilai tidak dapat lagi diperbarui oleh aktivitas terkait dengan otomatis.';
$string['locktime'] = 'Kunci setelah';
$string['locktimedate'] = 'Terkunci setelah: {$a}';
$string['lockverbose'] = 'Kunci {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Paling rendah';
$string['lowgradeletter'] = 'Rendah';
$string['manageoutcomes'] = 'Kelola capaian';
$string['manualitem'] = 'Item manual';
$string['mapfrom'] = 'Petakan dari';
$string['mapfrom_help'] = 'Pilih kolom pada lembar kerja yang berisikan data untuk mengidentifikasi pengguna, seperti nama pengguna, ID pengguna atau alamat surel.';
$string['mappings'] = 'Pemetaan item penilaian';
$string['mappings_help'] = 'Pilih item nilai yang cocok untuk mengimpor nilai ke dalamnya untuk setiap kolom pada lembar kerja.';
$string['mapto'] = 'Petakan ke';
$string['mapto_help'] = 'Pilih data pengindentifikasi yang sama dengan yang dipilih untuk \'Petakan dari\'.';
$string['max'] = 'Tertinggi';
$string['maxgrade'] = 'Nilai maksimum';
$string['meanall'] = 'Semua nilai';
$string['meangraded'] = 'Nilai tidak kosong';
$string['meanselection'] = 'Nilai dipilih untuk rata-rata kolom';
$string['meanselection_help'] = 'Setelan ini menentukan apakan sel tanpa nilai harus dimasukkan ketika menghitung rata-rata untuk setiap kategori item nilai.';
$string['median'] = 'Median';
$string['min'] = 'Terendah';
$string['minimum_show'] = 'Tampilkan nilai minimum';
$string['minimum_show_help'] = 'Nilai minimum digunakan pada penghitungan nilai dan bobot. Jika tidak ditampilkan, nilai minimum akan berubah ke nol sesuai setelan awal dan tidak dapat disunting.';
$string['minmaxtouse'] = 'Nilai minimum dan maksimum yang dipakai dalam penghitungan';
$string['minmaxtouse_desc'] = 'Setelan ini menentukan apakah akan menggunakan nilai minimum dan maksimum awal sejak nilai diberikan, atau nilai minimum dan maksimum seperti yang ditentukan dalam setelan untuk item nilai, saat menghitung nilai yang ditampilkan di buku nilai.';
$string['minmaxtouse_help'] = 'Setelan ini mengatur apakah nilai minimum dan maksimum awal dari ketika nilai diberikan atau sesuai yang dispesifikasikan pada setelan untuk item nilai ketika menghitung nilai yang ditampilkan pada buku nilai.';
$string['minmaxtouse_link'] = 'Grades_min_max';
$string['minmaxupgradedgrades'] = 'Catatan: Beberapa nilai telah dirubah untuk mengatasi masalah inkonsistensi pada buku nilai yang disebabkan oleh perubahan pada nilai minimum dan maksimum yang dipergunakan untuk menghitung nilai yang ditampilkan. Sebaiknya perubahan diperiksa kembali dan diterima.';
$string['minmaxupgradefixbutton'] = 'Atasi inkonsistensi';
$string['minmaxupgradewarning'] = 'Catatan: Sebuah inkonsistensi telah terdeteksi pada beberapa nilai karena perubahan dalam nilai minimum dan maksimum yang digunakan saat menghitung nilai yang ditampilkan di buku nilai. Direkomendasikan agar ketidakkonsistenan diselesaikan dengan mengklik tombol di bawah, meskipun ini akan mengakibatkan beberapa nilai berubah.';
$string['missingitemtypeoreid'] = 'Array key (itemtype atau eid) hilang dari param kedua dari grade_edit_tree_column_select::get_item_cell($item, $params)';
$string['missingscale'] = 'Skala harus dipilih';
$string['mode'] = 'Mode';
$string['modgrade'] = 'Nilai';
$string['modgrade_help'] = 'Pilih tipe penilaian yang digunakan untuk aktifitas ini. Jika "skala" dipilih, anda dapat memilih skala dari dropdown "skala". Apabila penilaian "poin" digunakan, anda dapat memasukkan nilai maksimum untuk aktivitas ini.';
$string['modgradecantchangegradetype'] = 'Anda tidak dapat mengganti tipe ini, karena nilai telah ada untuk item ini.';
$string['modgradecantchangegradetypemsg'] = 'Beberapa nilai telah diberikan, maka tipe penilaian tidak dapat diubah. Apabila anda ingin merubah nilai maksimum, anda harus memutuskan untuk menskala ulang nilai yang ada atau tidak terlebih dahulu.';
$string['modgradecantchangegradetyporscalemsg'] = 'Beberapa nilai telah diberikan, maka tipe penilaian dan skala tidak dapat diubah.';
$string['modgradecantchangeratingmaxgrade'] = 'Anda tidak dapat mengganti nilai maksimum ketika nilai untuk aktivitas dengan penilaian sudah ada .';
$string['modgradecantchangescale'] = 'Anda tidak dapat mengubah skala, karena sudah ada nilai untuk item ini.';
$string['modgradecategorycantchangegradetypemsg'] = 'Kategori ini memiliki item nilai yang tertimpa, maka beberapa nilai telah diberikan, sehingga tipe penilaian tidak dapat diubah. Apabila anda ingin merubah nilai maksimum, anda harus memutuskan untuk menskala ulang nilai yang ada atau tidak terlebih dahulu.';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'Kategori ini memiliki item nilai yang tertimpa, maka beberapa nilai telah diberikan, sehingga tipe penilaian dan skala tidak dapat diubah.';
$string['modgradecategoryrescalegrades'] = 'Ubah skala nilai yang diganti';
$string['modgradecategoryrescalegrades_help'] = 'Ketika mengubah nilai maksimum pada item buku nilai, anda harus menspesifikasikan apakah ini akan mengakibatkan persentase nilai yang ada berubah atau tidak.

Apabila diatur sebagai \'Ya\', seluruh nilai tertimpa yang ada akan diskala ulang, sehingga persentase nilai akan tetap sama.

Contohnya, apabila opsi ini diatur sebagai \'Ya\', mengubah nilai maksimum sebuah item dari 10 menjadi 20 akan menyebabkan nilai 6/10 (60%) diskala ulang menjadi 12/20 (60%). Dengan opsi ini diatur sebagai \'Tidak\', nilai akan berubah dari 6/10 (60%) menjadi 6/20 (30%), membutuhkan penyesuaian manual untuk setiap item nilai untuk memastikan skor yang benar.';
$string['modgradedonotmodify'] = 'Jangan mengubah nilai yang ada.';
$string['modgradeerrorbadpoint'] = 'Bilangan nilai tidak benar. Harus bilangan bulat antara 1 dan {$a}';
$string['modgradeerrorbadscale'] = 'Skala yang salah dipilih. Pastikan anda memilih skala dari pilihan di bawah ini.';
$string['modgrademaxgrade'] = 'Nilai maksimum';
$string['modgraderescalegrades'] = 'Skala ulang nilai yang ada';
$string['modgraderescalegrades_help'] = 'Apabila diatur sebagai \'Ya\', seluruh nilai yang ada akan diskala ulang, sehingga persentase nilai akan tetap sama.

Contohnya, apabila opsi ini diatur sebagai \'Ya\', mengubah nilai maksimum sebuah item dari 10 menjadi 20 akan menyebabkan nilai 6/10 (60%) diskala ulang menjadi 12/20 (60%). Dengan opsi ini diatur sebagai \'Tidak\', nilai akan berubah dari 6/10 (60%) menjadi 6/20 (30%), membutuhkan penyesuaian manual untuk setiap item nilai untuk memastikan skor yang benar.';
$string['modgradetype'] = 'Tipe';
$string['modgradetypenone'] = 'Tidak ada';
$string['modgradetypepoint'] = 'Poin';
$string['modgradetypescale'] = 'Skala';
$string['morethanmax'] = 'Nilai yang dimasukkan pada {$a->itemname} untuk {$a->username} lebih dari bilangan maksimal yang ditentukan';
$string['moveselectedto'] = 'Pindah item terpilih ke';
$string['movingelement'] = 'Memindahkan {$a}';
$string['multfactor'] = 'Pengganda';
$string['multfactor_help'] = 'Pengali adalah faktor di mana semua nilai untuk item nilai ini akan dikalikan, dengan nilai maksimum dari nilai maksimum. Misalnya, jika perkaliannya adalah 2 dan nilai maksimumnya adalah 100, maka semua nilai yang kurang dari 50 dikalikan dengan 2, dan semua nilai yang 50 ke atas diubah menjadi 100.';
$string['multfactorvalue'] = 'Bilangan pengganda untuk {$a}';
$string['mustchooserescaleyesorno'] = 'Anda harus memilih, apakah nilai akan diskala ulang atau tidak.';
$string['mygrades'] = 'Tautan nilai menu pengguna';
$string['mygrades_desc'] = 'Setelan ini mengizinkan opsi untuk menautkan ke buku nilai eksternal dari menu pengguna.';
$string['mypreferences'] = 'Preferensiku';
$string['myreportpreferences'] = 'Preferensi laporan saya';
$string['navmethod'] = 'Metode navigasi';
$string['neverdeletehistory'] = 'Jangan pernah hapus riwayat';
$string['newcategory'] = 'Kategori baru';
$string['newitem'] = 'Item penilaian baru';
$string['newoutcomeitem'] = 'Item capaian baru';
$string['no'] = 'Tidak';
$string['nocategories'] = 'Kategori nilai tidak dapat ditambahkan atau ditemukan pada kursus ini';
$string['nocategoryname'] = 'Tidak ada nama kategori yang diberikan.';
$string['nocategoryview'] = 'Tidak ada kategori untuk ditampilkan';
$string['nocourses'] = 'Belum ada  kursus';
$string['noexistingoutcomes'] = 'Belum ada capaian.';
$string['noexistingscales'] = 'Belum ada skala.';
$string['noforce'] = 'Jangan paksakan';
$string['nogradeletters'] = 'Nilai huruf belum diatur';
$string['nogradesreturned'] = 'Tidak ada nilai kembali';
$string['noidnumber'] = 'Tidak ada Nomor ID';
$string['nolettergrade'] = 'Tidak ada nilai huruf untuk';
$string['nomode'] = 'NA';
$string['nonnumericweight'] = 'Menerima bilangan tidak numerik untuk';
$string['nonunlockableverbose'] = 'Untuk membuka nilai ini, Anda perlu membuka kunci {$a->itemname}.';
$string['nonweightedpct'] = '% tidak dibobot';
$string['nooutcome'] = 'Tidak ada capaian';
$string['nooutcomes'] = 'Item capaian harus dikaitkan dengan capaian kursus, tetapi tidak ada hasil untuk kursus ini. Apakah Anda ingin menambahkan satu?';
$string['nopermissiontoresetweights'] = 'Tidak ada izin untuk mengatur ulang bobot';
$string['nopublish'] = 'Jangan terbitkan';
$string['noreports'] = 'Anda tidak terdaftar maupun mengajar pada kursus apapun di situs ini.';
$string['norolesdefined'] = 'Tidak ada aturan yang ditentukan dalam Administrasi > Penilaian > Setelan umum > Aturan Penilaian';
$string['noscales'] = 'Capaian harus dikaitkan dengan skala kursus atau skala global, tetapi tidak ada. Apakah Anda ingin menambahkan satu?';
$string['noselectedcategories'] = 'Tidak ada kategori dipilih.';
$string['noselecteditems'] = 'Tidak ada item terpilih.';
$string['notenrolled'] = 'Saat ini Anda tidak terdaftar pada kursus apa pun.';
$string['notteachererror'] = 'Anda harus merupakan seorang pengajar untuk menggunakan fitur ini.';
$string['nousersloaded'] = 'Tidak ada pengguna dimuat';
$string['nouserstograde'] = 'Tidak ada pengguna untuk dinilai';
$string['numberofgrades'] = 'Nomor nilai-nilai';
$string['onascaleof'] = 'Pada skala {$a->grademin} sampai {$a->grademax}';
$string['operations'] = 'Operasi';
$string['options'] = 'Opsi';
$string['others'] = 'Lainnya';
$string['outcome'] = 'Capaian';
$string['outcome_help'] = 'Setelan ini menentukan capaian yang akan diwakili oleh item nilai ini dalam buku nilai.';
$string['outcomeassigntocourse'] = 'Masukkan capaian lainnya pada kursus ini';
$string['outcomecategory'] = 'Buat capaian pada kategori';
$string['outcomecategorynew'] = 'Kategori bari';
$string['outcomeconfirmdelete'] = 'Anda yakin ingin menghapus capaian "{$a}"?';
$string['outcomecreate'] = 'Tambahkan capaian baru';
$string['outcomedelete'] = 'Hapus capaian';
$string['outcomefullname'] = 'Nama lengkap';
$string['outcomeitem'] = 'Item capaian';
$string['outcomeitemsedit'] = 'Edit item capaian';
$string['outcomereport'] = 'Laporan capaian';
$string['outcomes'] = 'Capaian';
$string['outcomescourse'] = 'Capaian yang digunakan pada kursus';
$string['outcomescoursecustom'] = 'Penyesuaian digunakan (tanpa penghapusan)';
$string['outcomescoursenotused'] = 'Standar tidak dipakai';
$string['outcomescourseused'] = 'Standar dipakai (tanpa penghapusan)';
$string['outcomescustom'] = 'Capaian kustom';
$string['outcomesdisabled'] = 'Capaian tidak diaktifkan';
$string['outcomeshortname'] = 'Nama singkat';
$string['outcomesstandard'] = 'Capaian standar';
$string['outcomesstandardavailable'] = 'Capaian standar yang tersedia';
$string['outcomestandard'] = 'Capaian standar';
$string['outcomestandard_help'] = 'Capaian standar tersedia di situs untuk semua kursus.';
$string['overallaverage'] = 'Rata-rata keseluruhan';
$string['overridden'] = 'Ditimpa';
$string['overridden_help'] = 'Jika dicentang, nilai tidak lagi dapat diubah dari dalam aktivitas terkait. Saat nilai diedit di laporan penilaian, kotak centang yang diganti dicentang secara otomatis. Namun mungkin tidak dicentang untuk mengizinkan nilai diubah melalui aktivitas terkait.';
$string['overriddennotice'] = 'Nilai akhir anda dari aktivitas ini telah disesuaikan secara manual.';
$string['overridecat'] = 'Izinkan kategori nilai ditimpa secara manual';
$string['overridecat_help'] = 'Menonaktifkan setelan ini akan membuat pengguna tidak dapat menimpa kategori nilai.';
$string['overridesitedefaultgradedisplaytype'] = 'Mengesampingkan setelan bawaan situs';
$string['overridesitedefaultgradedisplaytype_help'] = 'Apabila dipilih, nilai huruf dan batasan kursus dapat diatur, dapat berbeda dengan setelan bawaan situs.';
$string['overrideweightofa'] = 'Timpa bobot {$a}';
$string['parentcategory'] = 'Kategori induk';
$string['pass'] = 'Lulus';
$string['pctoftotalgrade'] = '% dari nilai total';
$string['percent'] = 'Persen';
$string['percentage'] = 'Persentase';
$string['percentageletter'] = 'Persentase (huruf)';
$string['percentagereal'] = 'Persentase (riil)';
$string['percentascending'] = 'Urut naik berdasarkan persen';
$string['percentdescending'] = 'Urut turun berdasarkan persen';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Pengimbangan';
$string['plusfactor_help'] = 'Pengimbang adalah bilangan nomor yang ditambahkan ke setiap nilai untuk item nilai setelah pengganda diaplikasikan.';
$string['plusfactorvalue'] = 'Bilangan offset untuk {$a}';
$string['points'] = 'Poin';
$string['pointsascending'] = 'Urut naik berdasarkan poin';
$string['pointsdescending'] = 'Urut turun berdasarkan poin';
$string['positionfirst'] = 'Pertama';
$string['positionlast'] = 'Terakhir';
$string['preferences'] = 'Preferensi';
$string['prefgeneral'] = 'Umum';
$string['prefletters'] = 'Nilai huruf dan batasannya';
$string['prefrows'] = 'Baris spesial';
$string['prefshow'] = 'Tampilkan/sembunyikan pengalihan';
$string['previewrows'] = 'Pratinjau baris';
$string['privacy:metadata:categorieshistory'] = 'Catatan versi kategori kelas sebelumnya';
$string['privacy:metadata:filepurpose'] = 'Berkas umpan balik disimpan di buku nilai untuk pengguna.';
$string['privacy:metadata:grade_import_newitem'] = 'Tabel sementara untuk menyimpan nama grade_item baru dari impor nilai';
$string['privacy:metadata:grade_import_newitem:importcode'] = 'Kode batch unik untuk mengidentifikasi satu batch impor';
$string['privacy:metadata:grade_import_newitem:importer'] = 'Pengguna mengimpor data';
$string['privacy:metadata:grade_import_newitem:itemname'] = 'Nama item nilai baru';
$string['privacy:metadata:grade_import_values'] = 'Tabel sementara untuk mengimpor nilai';
$string['privacy:metadata:grade_import_values:feedback'] = 'Umpan balik nilai';
$string['privacy:metadata:grade_import_values:finalgrade'] = 'Nilai mentah';
$string['privacy:metadata:grade_import_values:importcode'] = 'Kode batch unik untuk mengidentifikasi satu batch impor';
$string['privacy:metadata:grade_import_values:importer'] = 'Pengguna mengimpor data';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'Tandai jika hanya umpan balik yang diimpor';
$string['privacy:metadata:grade_import_values:userid'] = 'Pengguna yang nilainya diimpor';
$string['privacy:metadata:grades'] = 'Rekaman penilaian';
$string['privacy:metadata:grades:aggregationstatus'] = 'Status agregasi';
$string['privacy:metadata:grades:aggregationweight'] = 'Bobot agregasi';
$string['privacy:metadata:grades:feedback'] = 'Umpan balik';
$string['privacy:metadata:grades:finalgrade'] = 'Penilaian';
$string['privacy:metadata:grades:information'] = 'Informasi tambahan penilaian';
$string['privacy:metadata:grades:timemodified'] = 'Waktu ketika nilai terakhir diubah';
$string['privacy:metadata:grades:userid'] = 'IP pengguna yang merubah nilai';
$string['privacy:metadata:grades:usermodified'] = 'ID pengguna yang terakhir mengubah rekaman';
$string['privacy:metadata:gradeshistory'] = 'Rekaman dari nilai sebelumnya';
$string['privacy:metadata:history:loggeduser'] = 'ID pengguna yang masuk saat pembuatan versi terjadi';
$string['privacy:metadata:history:timemodified'] = 'Waktu ketika versi penilaianh terjadi';
$string['privacy:metadata:itemshistory'] = 'Catatan versi item nilai sebelumnya';
$string['privacy:metadata:outcomes'] = 'Catatan capaian';
$string['privacy:metadata:outcomes:timemodified'] = 'Waktu ketika rekaman itu dimodifikasi';
$string['privacy:metadata:outcomes:usermodified'] = 'Pengguna yang terakhir mengubah catatan';
$string['privacy:metadata:outcomeshistory'] = 'Catatan capaian versi sebelumnya';
$string['privacy:metadata:scale'] = 'Rekaman skala';
$string['privacy:metadata:scale:timemodified'] = 'Waktu ketika rekaman terakhir diubah';
$string['privacy:metadata:scale:userid'] = 'Pengguna yang terakhir mengubah rekaman';
$string['privacy:metadata:scalehistory'] = 'Rekaman skala versi sebelumnya';
$string['privacy:path:relatedtome'] = 'Terkait dengan saya';
$string['privacy:request:historyactiondelete'] = 'Hapus';
$string['privacy:request:historyactioninsert'] = 'Sisip';
$string['privacy:request:historyactionupdate'] = 'Perbarui';
$string['privacy:request:unknowndeletedgradeitem'] = 'Tidak diketahui (item nilai telah dihapus)';
$string['profilereport'] = 'Laporan profil pengguna';
$string['profilereport_help'] = 'Laporan nilai digunakan pada halaman profil pengguna';
$string['publishing'] = 'Menerbitkan';
$string['publishingoptions'] = 'Opsi penerbitan nilai';
$string['quickfeedback'] = 'Umpan balik cepat';
$string['quickgrading'] = 'Penilaian cepat';
$string['quickgrading_help'] = 'Jika diaktifkan, saat pengeditan diaktifkan, kotak input teks muncul untuk setiap nilai, memungkinkan banyak nilai untuk diedit pada waktu yang sama. Perubahan disimpan dan disorot ketika tombol perbarui diklik. Perhatikan bahwa saat nilai diedit dalam laporan penilaian, tanda yang diganti akan disetel, artinya nilai tidak dapat lagi diubah dari dalam aktivitas terkait.';
$string['range'] = 'Rentang';
$string['rangedecimals'] = 'Rentang poin desimal';
$string['rangedecimals_help'] = 'Jumlah poin desimal yang ditampilkan untuk rentang.';
$string['rangesdecimalpoints'] = 'Desimal yang ditampilkan dalam rentang';
$string['rangesdecimalpoints_help'] = 'Setelan ini menentukan jumlah poin desimal yang akan ditampilkan untuk setiap rentang atau apakah setelan poin desimal keseluruhan untuk kategori tersebut atau item nilai tersebut digunakan (diturunkan).';
$string['rangesdisplaytype'] = 'Tipe tampilan rentang';
$string['rangesdisplaytype_help'] = 'Setelan ini menentukan apakah rentang ditampilkan sebagai nilai riil, persentase atau huruf, atau apakah tipe tampilan untuk kategori atau item nilai digunakan (turunan).';
$string['rank'] = 'Tingkat';
$string['rawpct'] = '% mentah';
$string['real'] = 'Riil';
$string['realletter'] = 'Riil (huruf)';
$string['realpercentage'] = 'Riil (persentase)';
$string['recalculatinggrades'] = 'Menghitung ulang nilai';
$string['recovergradesdefault'] = 'Pulihkan setelan bawaan nilai';
$string['recovergradesdefault_help'] = 'Secara bawaan, pulihkan nilai lama saat mendaftarkan kembali pengguna dalam suatu kursus.';
$string['refreshpreview'] = 'Muat ulang pratinjau';
$string['regradeanyway'] = 'Nilai kembali bagaimanapun juga.';
$string['removeallcoursegrades'] = 'Hapus semua nilai';
$string['removeallcoursegrades_help'] = 'Apabila dipilih, seluruh item nilai yang ditambahkan secara manual ke buku nilai akan dihapus bersama dengan nilai dan data yang tertimpa, yang tidak dimasukkan (dikecualikan), disembunyikan, dan nilai yang terkunci. Hanya item nilai yang terkait dengan aktivitas yang tidak akan terhapus.';
$string['removeallcourseitems'] = 'Hapus semua item dan kategori';
$string['removeallcourseitems_help'] = 'Apabila dipilih, semua kategori dan item nilai yang ditambahkan secara manual ke buku nilai akan dihapus bersama dengan nilai dan data yang tertimpa, tidak dimasukkan (dikecualikan), disembunyikan dan nilai yang dikunci. Hanya item nilai yang berhubungan dengan aktivitas yang tidak akan terhapus.';
$string['report'] = 'Laporan';
$string['reportdefault'] = 'Laporan bawaan ({$a})';
$string['reportplugins'] = 'Pengaya laporan';
$string['reportsettings'] = 'Setelan laporan';
$string['reprintheaders'] = 'Cetak ulang tajuk';
$string['resetweights'] = 'Set ulang bobot dari {$a->itemname}';
$string['resetweightsshort'] = 'Set ulang bobot';
$string['respectingcurrentdata'] = 'Membiarkan setelan saat ini tidak berubah';
$string['rowpreviewnum'] = 'Pratinjau baris';
$string['rowpreviewnum_help'] = 'Data untuk diimpor dapat dipratinjau sebelum impor. Setelan ini menentukan berapa banyak baris yang ditampilkan pada pratinjau.';
$string['savechanges'] = 'Simpan perubahan';
$string['savepreferences'] = 'Simpan preferensi';
$string['scaleconfirmdelete'] = 'Apakah anda yakin untuk menghapus skala "{$a}"?';
$string['scaledpct'] = 'diskalakan %';
$string['seeallcoursegrades'] = 'Lihat nilai seluruh kursus';
$string['select'] = 'Pilih {$a}';
$string['selectalloroneuser'] = 'Pilih semua atau satu pengguna';
$string['selectauser'] = 'Pilih pengguna';
$string['selectdestination'] = 'Pilih tujuan dari {$a}';
$string['separator'] = 'Pemisah';
$string['separator_help'] = 'Pilih pemisah yang digunakan pada berkas CSV. (Biasanya adalah koma.)';
$string['sepcolon'] = 'Titik dua';
$string['sepcomma'] = 'Koma';
$string['sepsemicolon'] = 'Titik koma';
$string['septab'] = 'Tab';
$string['setcategories'] = 'Atur kategori';
$string['setcategorieserror'] = 'Anda harus mengatur kategori untuk kursus anda terlebih dahulu sebelum anda memberi bobot.';
$string['setgradeletters'] = 'Setel Nilai huruf';
$string['setpreferences'] = 'Atur preferensi';
$string['setting'] = 'Setelan';
$string['settings'] = 'Setelan';
$string['setup'] = 'Setel';
$string['setweights'] = 'Atur bobot';
$string['showactivityicons'] = 'Tampilkan ikon aktivitas';
$string['showactivityicons_help'] = 'Apabila diaktifkan, ikon aktivitas akan ditampilkan disebelah nama aktivitas.';
$string['showallhidden'] = 'Tampilkan yang tersembunyi';
$string['showallstudents'] = 'Tampilkan semua siswa';
$string['showanalysisicon'] = 'Tampilkan ikon analisis nilai';
$string['showanalysisicon_desc'] = 'Menampilkan ikon tampilkan analisis nilai sebagai bawaan. Apabila modul aktivitas dapat menampilkannya, ikon analisis nilai akan menautkan ke halaman dengan penjelasan yang lebih detail mengenai nilai dan bagaimana ia didapatkan.';
$string['showanalysisicon_help'] = 'Apabila modul aktivitas dapat menampilkannya, ikon analisis nilai akan menautkan ke halaman dengan penjelasan yang lebih detil mengenai nilai dan bagaimana ia didapatkan.';
$string['showaverage'] = 'Tampilkan rata-rata';
$string['showaverage_help'] = 'Apakah akan menampilkan kolom rata-rata. Perhatikan bahwa peserta mungkin dapat memperkirakan nilai orang lain jika rata-rata dihitung dari sejumlah kecil nilai. Untuk alasan kinerja, rata-rata merupakan perkiraan jika bergantung pada item tersembunyi.';
$string['showaverages'] = 'Tampilkan rata-rata kolom';
$string['showaverages_help'] = 'Apabila diaktifkan, laporan penilai akan berisi baris tambahan yang menampilkan rata-rata untuk setiap kategori dan item nilai.';
$string['showcalculations'] = 'Tampilkan kalkulasi';
$string['showcalculations_help'] = 'Apabila diaktifkan, ketika penyuntingan, ikon kalkulator akan ditampilkan untuk setiap item nilai dan kategori dengan indikator visual bahwa item nilai dikalkulasikan.';
$string['showcontributiontocoursetotal'] = 'Tampilkan kontribusi pada total kursus';
$string['showcontributiontocoursetotal_help'] = 'Menampilkan kolom persentase yang mengindikasikan berapa banyak kontribusi setiap item nilai pada persentase total kursus pengguna (setelah pembobotan diaplikasikan)';
$string['showeyecons'] = 'Tampilkan ikon \'tampilkan/sembunyikan\'';
$string['showeyecons_help'] = 'Jika diaktifkan, saat pengeditan diaktifkan, ikon tampilkan/sembunyikan ditampilkan untuk setiap nilai untuk mengontrol visibilitasnya kepada siswa.';
$string['showfeedback'] = 'Tampilkan umpan balik';
$string['showfeedback_help'] = 'Apakah akan menampilkan kolom untuk umpan balik.';
$string['showgrade'] = 'Tampilkan nilai';
$string['showgrade_help'] = 'Tampilkan kolom nilai?';
$string['showgroups'] = 'Tampilkan grup';
$string['showhiddenitems'] = 'Tampilkan item tersembunyi';
$string['showhiddenitems_help'] = 'Apakah item nilai tersembunyi disembunyikan seluruhnya atau jika nama item nilai tersembunyi dapat dilihat oleh siswa. * Tampilkan tersembunyi - Nama item nilai tersembunyi ditampilkan tetapi nilai siswa disembunyikan * Hanya disembunyikan sampai - Item nilai dengan set tanggal "sembunyikan sampai" disembunyikan sepenuhnya hingga tanggal yang ditetapkan, setelah itu seluruh item ditampilkan * Jangan tampilkan - Item nilai tersembunyi benar-benar tersembunyi';
$string['showhiddenuntilonly'] = 'Hanya disembunyikan hingga';
$string['showingaggregatesonly'] = 'Menampilkan agregat saja';
$string['showingfullmode'] = 'Menampilkan tampilan penuh';
$string['showinggradesonly'] = 'Menampilkan nilai saja';
$string['showlettergrade'] = 'Tampilkan nilai huruf';
$string['showlettergrade_help'] = 'Tampilkan kolom nilai huruf?';
$string['showlocks'] = 'Tampilkan kunci';
$string['showlocks_help'] = 'Jika diaktifkan, saat pengeditan diaktifkan, ikon kunci/buka kunci ditampilkan untuk setiap nilai untuk mengontrol apakah nilai dapat diperbarui secara otomatis oleh aktivitas terkait.';
$string['shownohidden'] = 'Jangan tampilkan';
$string['shownooutcomes'] = 'Sembunyikan capaian';
$string['shownumberofgrades'] = 'Tampilkan beberapa nilai pada rata-rata';
$string['shownumberofgrades_help'] = 'Apabila diaktifkan, jumlah nilai yang digunakan untuk menghitung rata-rata akan ditampilkan dalam tanda kurung setelah setiap rata-rata.';
$string['showonlyactiveenrol'] = 'Tampilkan hanya pendaftaran yang aktif';
$string['showonlyactiveenrol_help'] = 'Setelan ini menentukan, apakah hanya pengguna terdaftar aktif saja yang dapat terlihat di laporan buku nilai. Apabila diaktifkan, pengguna ditangguhkan tidak akan terlihat di buku nilai.';
$string['showpercentage'] = 'Tampilkan persen';
$string['showpercentage_help'] = 'Apakah akan menampilkan nilai persentase setiap item kelas.';
$string['showquickfeedback'] = 'Tunjukkan umpan balik cepat';
$string['showquickfeedback_help'] = 'Apabila diaktifkan, ketika penyuntingan dinyalakan, kotak masukan teks umpan balik dengan batas titik-titik akan muncul untuk tiap nilai, memungkinkan umpan balik untuk banyak nilai disunting pada waktu yang bersamaan. Perubahan akan disimpan dan disoroti ketika tombol perbarui ditekan. Perhatikan bahwa ketika umpan balik disunting ada laporan penilai, tanda tertimpa akan aktif, berarti bahwa umpan balik tidak dapat lagi diganti dalam aktivitas terkait.';
$string['showrange'] = 'Tampilkan rentang';
$string['showrange_help'] = 'Tampilkan kolom rentang?';
$string['showranges'] = 'Tampilkan rentang';
$string['showranges_help'] = 'Jika diaktifkan, laporan penilai akan berisi baris tambahan yang menampilkan rentang untuk setiap kategori dan item nilai.';
$string['showrank'] = 'Tampilkan peringkat';
$string['showrank_help'] = 'Apakah akan menunjukkan posisi siswa dalam kaitannya dengan kelas lainnya untuk setiap item nilai.';
$string['showuserimage'] = 'Tampilkan gambar profil pengguna';
$string['showuserimage_help'] = 'Apakah akan menampilkan gambar profil pengguna di samping nama dalam laporan penilai.';
$string['showverbose'] = 'Tampilkan {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Tampilkan pembobotan';
$string['showweight_help'] = 'Tampilkan kolom bobot nilai?';
$string['simpleview'] = 'Tampilan tunggal';
$string['singleview'] = 'Tampilan tunggal untuk {$a}';
$string['sitewide'] = 'Seluruh situs';
$string['sort'] = 'susun';
$string['sortasc'] = 'Susun keatas';
$string['sortbyfirstname'] = 'Urut nama depan';
$string['sortbylastname'] = 'Urut nama belakang';
$string['sortdesc'] = 'Susun kebawah';
$string['standarddeviation'] = 'Deviasi standar';
$string['stats'] = 'Statistik';
$string['statslink'] = 'Stat';
$string['student'] = 'Siswa';
$string['studentsperpage'] = 'Siswa per halaman';
$string['studentsperpage_help'] = 'Setelan ini menentukan jumlah peserta ajar ditampilkan tiap halaman pada laporan penilai.';
$string['studentsperpagereduced'] = 'Mengurangi maksimal siswa per halaman dari {$a->originalstudentsperpage} ke {$a->studentsperpage}. Pertimbangkan untuk meningkatkan setelan php max_input_vars dari {$a->maxinputvars}.';
$string['subcategory'] = 'Kategori normal';
$string['submissions'] = 'Penyerahan';
$string['submittedon'] = 'Dikirim: {$a}';
$string['sumofgradesupgradedgrades'] = 'Catatan: metode agregasi "Jumlah dari seluruh nilai" telah diubah menjadi "Natural" sebagai bagian dari peningkatan situs. Karena "Jumlah seluruh nilai" digunakan sebelumnya pada kursus ini. Anda direkomendasikan untuk meninjau ulang perubahan ini pada buku nilai.';
$string['switchtofullview'] = 'Ubah ke tampilan penuh';
$string['switchtosimpleview'] = 'Ubah ke tampilan sederhana';
$string['tabs'] = 'Tab';
$string['topcategory'] = 'Kategori super';
$string['total'] = 'Total';
$string['totalweight100'] = 'Total bobot sama dengan 100';
$string['totalweightnot100'] = 'Total bobot tidak sama dengan 100';
$string['turnfeedbackoff'] = 'Matikan umpan balik';
$string['turnfeedbackon'] = 'Nyalakan umpan balik';
$string['typenone'] = 'Tidak ada';
$string['typescale'] = 'Skala';
$string['typescale_help'] = 'Setelan ini menentukan skala yang digunakan ketika menggunakan tipe nilai skala. Skala untuk item nilai berbasis aktivitas diatur pada halaman setelan aktivitas.';
$string['typetext'] = 'Teks';
$string['typevalue'] = 'Bilangan';
$string['uncategorised'] = 'Tanpa kategori';
$string['unchangedgrade'] = 'Nilai tidak berubah';
$string['unenrolledusersinimport'] = 'Impor ini memasukkan nilai berikut untuk pengguna yang saat ini tidak terdaftar pada kursus ini: {$a}';
$string['unlimitedgrades'] = 'Nilai tidak terbatas';
$string['unlimitedgrades_help'] = 'Secara bawaan, nilai dibatasi oleh nilai maksimum dan minimum dari item nilai. Mengaktifkan setelan ini menghapus batas ini, dan memungkinkan nilai lebih dari 100% untuk dimasukkan langsung ke dalam buku nilai.';
$string['unlock'] = 'Buka';
$string['unlockverbose'] = 'Buka {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Tidak terpakai';
$string['updatedgradesonly'] = 'Ekspor nilai baru atau terbarui saja';
$string['upgradedgradeshidemessage'] = 'Hilangkan peringatan';
$string['upgradedminmaxrevertmessage'] = 'Kembalikan ke setelan awal';
$string['uploadgrades'] = 'Unggah nilai';
$string['useadvanced'] = 'Gunakan fitur-fitur lanjutan';
$string['usedcourses'] = 'Kursus yang digunakan';
$string['usedgradeitem'] = 'Item penilaian yang digunakan';
$string['usenooutcome'] = 'Jangan gunakan capaian';
$string['usenoscale'] = 'Jangan gunakan skala';
$string['usepercent'] = 'Gunakan persen';
$string['user'] = 'Pengguna';
$string['userenrolmentsuspended'] = 'Keanggotaan pengguna ditangguhkan';
$string['userfields_show'] = 'Tampilkan ruas pengguna';
$string['userfields_show_help'] = 'Tampilkan bidang pengguna tambahan seperti alamat surel pada laporan penilai. Bidang yang ditampilkan dikontrol oleh setelan situs howuseridentity';
$string['usergrade'] = 'Pengguna {$a->fullname} ({$a->useridnumber}) pada item {$a->gradeidnumber}';
$string['userid'] = 'ID pengguna';
$string['useridnumberwarning'] = 'Pengguna tanpa nomor ID tidak akan dimasukkan dalam ekspor karena mereka tidak dapat diimpor';
$string['usermappingerror'] = 'Setelan ini menentukan nilai minimum ketika menggunakan tipe nilai bilangan';
$string['usermappingerrorcurrentgroup'] = 'Pengguna bukan anggota grup.';
$string['usermappingerrormultipleusersfound'] = 'Kesalahan pemetaan pengguna: Beberapa pengguna ditemukan dengan {$a->field} dari "{$a->value}". Harap gunakan bidang pemetaan yang lebih unik.';
$string['usermappingerrorusernotfound'] = 'Galat pemetaan pengguna: Tidak dapat menemukan pengguna.';
$string['userpreferences'] = 'Preferensi pengguna';
$string['useweighted'] = 'Gunakan pembobotan';
$string['verbosescales'] = 'Skala verbose';
$string['verbosescales_help'] = 'Kala verbose menggunakan kata-kata daripada angka. Pilih \'Ya\' apabila anda ingin mengimpor skala numerik dan verbose. Pilih \'Tidak\' apabila hanya ingin mengimpor skala numerik.';
$string['viewbygroup'] = 'Grup';
$string['viewgrades'] = 'Lihat nilai';
$string['weight'] = 'Bobot';
$string['weight_help'] = 'Bilangan digunakan untuk menentukan bilangan relatif dari beberapa item nilai dalam kategori atau kursus.';
$string['weightcourse'] = 'Gunakan nilai berbobot untuk kursus';
$string['weightedascending'] = 'Urut naik berdasarkan persentasi pembobotan';
$string['weighteddescending'] = 'Urut turun berdasarkan persentasi pembobotan';
$string['weightedpct'] = '% pembobotan';
$string['weightedpctcontribution'] = 'Kontribusi % pembobotan';
$string['weightofa'] = 'Bobot dari {$a}';
$string['weightorextracredit'] = 'Bobot atau kredit ekstra';
$string['weightoverride'] = 'Penyesuaian bobot';
$string['weightoverride_help'] = 'Jangan pilih ini untuk mengatur ulang bobot item nilai ke bilangan yang telah dihitung secara otomatis. Memilih ini akan membuat bobot tidak dapat disesuaikan secara otomatis.';
$string['weights'] = 'Bobot';
$string['weightsadjusted'] = 'Bobot anda telah disesuaikan dengan total 100.';
$string['weightsedit'] = 'Sunting bobot dan kredit ekstra';
$string['weightuc'] = 'Bobot terhitung';
$string['writinggradebookinfo'] = 'Menulis setelan buku nilai';
$string['xml'] = 'XML';
$string['yes'] = 'Ya';
$string['yourgrade'] = 'Nilai anda';
