<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_fordson', language 'ar', version '4.0'.
 *
 * @package     theme_fordson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityiconsize'] = 'حجم الأيقونة النشطة';
$string['activityiconsize_desc'] = 'اضبط حجم الأيقونات النشطة المستخدمة في المقررات الدراسية.';
$string['activitylinkstitle'] = 'الأنشطة';
$string['activitylinkstitle_desc'] = 'عرض جميع الأنشطة في المادة';
$string['activitymenu'] = 'إظهار قائمة الأنشطة المجمّعة';
$string['activitymenu_desc'] = 'إظهار قوائم النشاط المجمعة في لوحات الطلاب والمعلمين. تعرض هذه القائمة قائمة مجمعة بكل الأنشطة للطالب والمعلم.';
$string['advancedsettings'] = 'إعدادات متقدة';
$string['alert'] = 'تنبيه الصفحة الرئيسية';
$string['alert_desc'] = 'هذه رسالة تنبيه خاصة ستظهر على الصفحة الرئيسية.';
$string['backgroundimage'] = 'صورة خلفية الصفحة الافتراضية';
$string['backgroundimage_desc'] = 'صورة خلفية للصفحات';
$string['backtotop'] = 'عودة إلى الأعلى وبسلاسة';
$string['badges'] = 'الشارات';
$string['badges_desc'] = 'مكافأة طلابك';
$string['blockdisplay'] = 'حظر خيارات عرض الموقع';
$string['blockdisplay_desc'] = 'إختر كيفية عرض الكتل على الصفحة الرئيسية وصفحات المقررات الدراسية. يضيف Fordson لوحة ذات 3 أعمدة قابلة للطي يمكن إخفاؤها من قبل المستخدم. إختر الخيار Boost الافتراضي لاستعمال عمود جانبي يميني واحد للكتل. يقوم الخيار Boost الافتراضي أيضاً بنقل الزر "إضافة كتلة" مرة أخرى إلى "درج التنقل" على يسار الصفحة. نوصي أيضاً باستعمال "Single Column Boost Default" عند استعمال أيّ من تخطيطات صفحة Boost من الإعدادات أعلاه.';
$string['blockdisplay_off'] = 'عمود واحد Boost الافتراضي';
$string['blockdisplay_on'] = 'ثلاثة أعمدة Fordson الافتراضي';
$string['blockwidthfordson'] = 'عرض عمود الكتل';
$string['blockwidthfordson_desc'] = 'ضبط عرض عمود الكتلة.';
$string['blog'] = 'رابط المدونة';
$string['blogdesc'] = 'أدخل رابط لمدونة مؤسستك. (أي http://dearbornschools.org)';
$string['bodybackground'] = 'لون خلفية مساحة النص';
$string['bodybackground_desc'] = 'اللون الرئيسي لاستخدامه في الخلفية.';
$string['brandColour'] = 'لون العلامة التجارية';
$string['brandColour_desc'] = 'لون علامتك التجارية الرئيسية';
$string['branddanger'] = 'خطر العلامة التجارية';
$string['branddanger_desc'] = 'لون العلامة التجارية لتنبيهات ولوحات الخطر، و ما إلى ذلك';
$string['brandemail'] = 'بريد الموقع';
$string['brandemaildesc'] = 'عنوان البريد الالكتروني للمؤسسة الذي يظهر في التذييل.';
$string['brandinfo'] = 'معلومات العلامة التجارية';
$string['brandinfo_desc'] = 'تنبيهات وأ لوان معلومات العلامة التجارية ، إلخ';
$string['brandorganization'] = 'اسم المنظمة';
$string['brandorganizationdesc'] = 'اسم المنظمة الذي يظهر في تذييل الصفحة.';
$string['brandphone'] = 'هاتف الموقع';
$string['brandphonedesc'] = 'رقم الهاتف الذي يظهر في التذييل.';
$string['brandprimary'] = 'العلامة التجارية الابتدائية';
$string['brandprimary_desc'] = 'لون علامتك التجارية الرئيسية';
$string['brandsuccess'] = 'نجاح العلامة التجارية';
$string['brandsuccess_desc'] = 'لون العلامة التجارية للتنبيهات الناجحة واللوحات الإيجابية والأزرار وما إلى ذلك';
$string['brandwarning'] = 'تحذير العلامة التجارية';
$string['brandwarning_desc'] = 'لون العلامة التجارية للتنبيهات واللوحات التحذيرية، إلخ.';
$string['brandwebsite'] = 'موقع المنظمة';
$string['brandwebsitedesc'] = 'عنوان الموقع الذي يظهر في التذييل للمؤسسة.';
$string['breadcrumbbkg'] = 'لون الخلفية المجزاءة';
$string['breadcrumbbkg_desc'] = 'لون الخلفية المجزاءة.';
$string['cardbkg'] = 'لون خلفية المحتوى';
$string['cardbkg_desc'] = 'لون خلفية المحتوى لكتلة محتوى المقرر.';
$string['catsicon'] = 'رمز الفئة';
$string['catsicon_desc'] = 'إختر أيقونة لتمثيل تصنيفات المقررات الدراسية.';
$string['choosereadme'] = 'مظهريوفر Fordson تجربة بصرية فريدة لمظهر Boost الافتراضي مع ميزات التخصيص مثل منتقي الألوان وتجربة الصفحة الرئيسية المحسّنة.';
$string['colours_desc'] = 'سيسمح لك منتقي الألوان بتخصيص شكل ومظهر العناصر الرئيسية في الصفحة. إذا كنت تستخدم تحضيرًا مسبقًا بخلاف الإعدادات الافتراضية، فستحتاج إلى إزالة أيّ ألوان مخصصة أدناه للحصول على أفضل النتائج، حيث إنها ستتجاوز التحضيرات المسبقة ذات النتائج غير المرغوب بها. بشكل عام، سيكون للتحضير المسبق ألوان افتراضية تريد رؤيتها هنا قبل تخصيصها.';
$string['colours_headingsub'] = 'إعدادات الألوان';
$string['colours_settings'] = 'الألوان';
$string['configtitle'] = 'Fordson';
$string['contentsettings'] = 'مجالات المحتوى';
$string['courseactivities'] = 'أنشطة المادة';
$string['courseblockpanelbtn'] = 'كتل المساق';
$string['courseblockpanelbtnclose'] = 'أغلق';
$string['courseboxheight'] = 'لون ارتفاع البلاطة';
$string['courseboxheight_desc'] = 'التحكم في ارتفاع بلاطة المقررات الدراسية في صفحة الواجهة وفي تصنيفات المقررات الدراسية.';
$string['courseeditingcog'] = 'إظهار قائمة إعدادات المادة الافتراضية';
$string['courseeditingcog_desc'] = 'في حالة استعمال لوحة إدارة المساق، ستكون القائمة الافتراضية مخفية. من خلال تأشير هذا، يمكنك إظهار القائمة الافتراضية فضلاً عن لوحة إدارة المساق للمعلم. يعد هذا الأمر مثالياً في حالة استعمال ملحق من طرف ثالث يستعمل قائمة المساق للوصول إلى الإعدادات.';
$string['coursehome'] = 'الصفحة الرئيسية';
$string['courseinfo'] = 'وصف المساق';
$string['coursemanage'] = 'إعدادات المادة';
$string['coursemanage_desc'] = 'إدارة المادة بأكملها';
$string['coursemanagementbutton'] = 'إدارة المادة';
$string['coursemanagementinfo'] = 'لوحة قائمة إدارة المادة';
$string['coursemanagementinfodesc'] = 'يوفر Fordson لوحة إدارة مساق منظمة وفريدة يمكن للمعلمين الوصول إليها من أيّ مكان ضمن المساق للوصول إلى روابط الإدارة. يمكن للطلاب أيضًا الوصول إلى دقة قيادة المساق خاصة بالطالب تتضمن معلومات ذات صلة به. ننصح بشدة أن تبقي هذا قيد التشغيل.';
$string['coursemanagementtextbox'] = 'رسالة إدارة المساق';
$string['coursemanagementtextbox_desc'] = 'إضافة رسالة للمعلمين في لوحة إدارة المساق في كل صفحة منه.';
$string['coursemanagementtoggle'] = 'إظهار لوحات إدارة المساق للمعلمين والطلاب';
$string['coursemanagementtoggle_desc'] = 'يؤدي ذلك إلى عرض روابط إدارة المساق في لوحة منظمة للمعلمين. إنها توفر دفة قيادة لكل الروابط التي يحتاجونها لإدارة المساق ومستخدميه. سيعرض ذلك أيضًا لوحة النظرة العامة للمساق للطلاب مع التقديرات، إكمال المساق، وعناصر أخرى منه.';
$string['coursestaff'] = 'معلّمي المادة';
$string['coursestyle1'] = 'نمط بلاطة  1';
$string['coursestyle10'] = 'عرض مادة Moodle الافتراضية';
$string['coursestyle2'] = 'نمط بلاطة  2';
$string['coursestyle3'] = 'نمط بلاطة 3';
$string['coursestyle4'] = 'نمط بلاطة  4 مع ملخص المساق';
$string['coursestyle5'] = 'نمط أفقي 1';
$string['coursestyle6'] = 'التفاصيل الكاملة لصورة الخلفية الأفقية';
$string['coursestyle7'] = 'عنوان خلفية الصورة الأفقية والمعلم فقط';
$string['coursestyle8'] = 'عامودين أفقيين';
$string['coursestyle9'] = 'تدريب الشركات - الحد الأدنى مع شريط التقدم';
$string['coursetileinfo'] = 'خيارات عرض المادة';
$string['coursetileinfodesc'] = 'تتيح لك هذه الإعدادات تخصيص كيفية عرض المقررات الدراسية في صفحة الواجهة وكذلك تصنيفات المقررات الدراسية.';
$string['coursetilestyle'] = 'عرض بلاطة المادة';
$string['coursetilestyle_desc'] = 'عند معاينة تصنيفات المقررات الدراسية، يمكنك الاختيار من بين الأنماط التالية لعرض المقررات الدراسية. <a href="https://goo.gl/fMXzSo" target="_new">تعليمات Fordson </a>';
$string['createinfo'] = 'زر بناء مادة خاصة';
$string['createinfodesc'] = 'يظهر هذا الزر على الصفحة الرئيسية عندما يكون باستطاعة المستخدم إنشاء مقرر جديد. سيشاهد هذا الزر من له دور منشئ المساق على مستوى الموقع.';
$string['currentinparentheses'] = '(حالياً)';
$string['customloginheading'] = 'صفحة تسجيل الدخول المخصصة';
$string['customlogininfo'] = 'إعدادات صفحة تسجيل الدخول المخصصة';
$string['customlogininfo_desc'] = 'هذا يسمح لك بإنشاء صفحة تسجيل دخول مخصصة. تتضمن الإعدادات الأخرى في القالب التي سيتم عرضها في صفحة تسجيل الدخول ما يأتي:
* إدارة الموقع > الأمان > سياسات الموقع > إجبار المستخدمين على تسجيل الدخول = تأكد من تأشيره ليتم نقل المستخدمين إلى صفحة تسجيل الدخول المخصصة الخاصة بك.
* إدارة الموقع > المظهر > الشعارات > الشعار =  قم برفع صورة هنا وستظهر أعلى نموذج تسجيل الدخول.
* Fordson > إعدادات الصور المخصصة > صورة تسجيل الدخول الافتراضية، يمكن استعمالها لتغيير صورة الخلفية في صفحة تسجيل الدخول.
* Fordson > مناطق المحتوى > الصفحة الرئيسية، يمكن استعمال التنبيه لتوفير إشعار في أعلى الصفحة.';
$string['dashactivityoverview'] = 'نظرة عامة على الأنشطة';
$string['displaybottom'] = 'عرض في الحاشية';
$string['displaymycourses'] = 'عرض المقررات الدراسية المنضم إليها';
$string['displaymycoursesdesc'] = 'عرض المقررات الدراسية المنضم إليها للمستخدمين في شريط التنقل العلوي.';
$string['displaythiscourse'] = 'عرض قائمة المادة';
$string['displaythiscoursedesc'] = 'عرض الانتقال إلى قسم في قائمة المادة للمستخدمين في شريط التنقل العلوي. يحتوي هذا على عناصر القائمة التي تم العثور عليها مسبقًا في درج التنقل.';
$string['displaytop'] = 'عرض في أعلى الصفحة';
$string['drawerbkg'] = 'لون خلفية الدُرْج الجانبي';
$string['drawerbkg_desc'] = 'لون خلفية الدُرج الجانبي للقائمة الموجودة على الجانب الأيسر من الصفحة.';
$string['editoff'] = 'ايقاف التحرير';
$string['editon'] = 'تشغيل التحرير';
$string['enablecategoryicon'] = 'أيقونات عرض الفئة';
$string['enablecategoryicon_desc'] = 'عند تأشيره، سيعرض تصنيفات المقررات الدراسية بشكل أيقونات';
$string['enhancedmydashboard'] = 'لوحة التحكم الخاصة بي المعززة';
$string['enhancedmydashboard_desc'] = 'سيؤدي تشغيل هذا إلى تعزيز صفحة لوحة التحكم الخاصة بي لتضمين كل ميزات fordson، مثل نموذج الانضمام السهل، شرائط تمرير الكتل، شريط تنقل الأيقونات، النص المخصص للصفحة الرئيسية، عرض الشرائح، والمزيد.';
$string['enrollcoursecard'] = 'الوصول';
$string['facebook'] = 'رابط فيسبوك';
$string['facebookdesc'] = 'أدخل رابط فيسبوك (أي https://www.facebook.com/)';
$string['favicon'] = 'الأيقونة المفضلة';
$string['favicon_desc'] = 'تغيير الأيقونة المفضلة لـ Fordson. الصور ذات الخلفية الشفافة وارتفاعها 32 بكسل ستعمل بشكل أفضل. الأنواع المسموح بها: PNG ، JPG  ICO';
$string['feature1info'] = 'ميزة 1';
$string['feature2info'] = 'ميزة 2';
$string['feature3info'] = 'ميزة 3';
$string['featureimage'] = 'ميزة الصورة';
$string['featureimage_desc'] = 'ستظهر هذه الصورة بجانب النص المميز في صف واحد.';
$string['featureinfo_desc'] = 'تتكون الميزة من صورة ونصّ سيظهران في صفحة تسجيل الدخول المخصصة جنبًا إلى جنب. ينبغي عليك إضافة كل من الصورة والنصّ حتى تظهر الميزة.';
$string['featuretext'] = 'ميزة النصّ';
$string['featuretext_desc'] = 'سيظهر هذا النص بجانب الصورة المميزة في صف واحد. استخدم Heading4 لإنشاء عنوان خاص داخل مربع النص. في Atto Editor H4 هو Heading Medium.';
$string['flickr'] = 'رابط Flickr';
$string['flickrdesc'] = 'أدخل رابط صفحتك في Flickr (مثل https://www.flickr.com/mycollege)';
$string['footerbkg'] = 'لون خلفية تذييل الصفحة';
$string['footerbkg_desc'] = 'لون خلفية تذييل الصفحة عند أسفلها.';
$string['footerdesc'] = 'تتيح لك العناصر أدناه تقديم العلامة التجارية إلى تذييل القالب.';
$string['footerheading'] = 'تذييل الصفحة';
$string['footerheadingsocial'] = 'الرموز الإجتماعية';
$string['footerheadingsub'] = 'تخصيص تذييل الصفحة الرئيسية';
$string['footnote'] = 'الحاشية';
$string['footnotedesc'] = 'محرر محتوى الحاشية السفلية لتذييل الصفحة الرئيسي';
$string['fploginform'] = 'لون نموذج تسجيل الدخول';
$string['fploginform_desc'] = 'لون خلفية نموذج تسجيل الدخول على الصفحة الرئيسية المخصصة.';
$string['fpsignup'] = 'الدخول';
$string['fptextbox'] = 'نص الصفحة الرئيسية لمصادقة المستخدم';
$string['fptextbox_desc'] = 'يظهر مربع النص هذا في الصفحة الرئيسية بمجرد المصادقة على المستخدم. إنه مثالي لوضع رسالة ترحيب وتقديم إرشادات للمتعلم.';
$string['fptextboxlogout'] = 'مربع نص الصفحة الرئيسية  للزائر';
$string['fptextboxlogout_desc'] = 'يظهر مربع النص هذا في الصفحة الرئيسية للزوار وهو مثالي لوضع رسالة ترحيب أو رابط لصفحة تسجيل الدخول.';
$string['frontpagemycoursessorting'] = 'ترتيب مقرراتي حسب الدخول الأخير';
$string['frontpagemycoursessorting_desc'] = 'عند تأشيره، هذه الميزة ستقوم بفرز مقرراتي (المقررات الدراسية المنضم إليها) حسب آخر وصول للمستخدم. سيؤدي ذلك إلى تجاوز إعداد "فرز مقرراتي" ضمن "التنقل". إذا لم يتم تأشيره، فسيتم عرض (مقرراتي) كالمعتاد. يشمل ذلك مقرراتي المعروضة في القائمة المنسدلة أعلى الصفحة فضلاً عن عرض مقرراتي في الصفحة الرئيسية للموقع. هذا لا يؤثر على لوحة التحكم أو كتلها.';
$string['generalcontentinfo'] = 'إعدادات عرض المحتوى العام';
$string['generalcontentinfodesc'] = 'تساعدك الخيارات أدناه في تخصيص طريقة عرض المحتوى وتشغيل ميزات إضافية لـ Fordson.';
$string['generalsettings'] = 'الاعدادات العامة';
$string['googleplus'] = 'رابط Google+';
$string['googleplusdesc'] = 'أدخل رابط ملفك الشخصي في Google+ (مثل http://plus.google.com/107817105228930159735)';
$string['gutterwidth'] = 'محتوى الحشو';
$string['gutterwidth_desc'] = 'يتحكم هذا الإعداد في مقدار التباعد المستخدم على يسار ويمين المحتوى الرئيسي.';
$string['headerdefaultimage'] = 'صورة الرأس الافتراضية';
$string['headerdefaultimage_desc'] = 'الصورة الافتراضية لعناوين المقررات الدراسية والصفحات التي ما سواها';
$string['headerimagepadding'] = 'ارتفاع صورة الرأس';
$string['headerimagepadding_desc'] = 'التحكم في الحشو وارتفاع صورة العنوان للمساقات.';
$string['headerlogo'] = 'شعار الرأس';
$string['headerlogo_desc'] = 'سيتم عرض هذا الشعار في الجزء العلوي من الصفحة في منطقة العنوان. إنه يستعمل تحجيم الصور المتجاوب من bootstrap.';
$string['homemyclasses'] = 'الصفحة الرئيسية للصفوف';
$string['homemycomp'] = 'الصفحة الرئيسية للكفاءة';
$string['homemycourses'] = 'الصفحة الرئيسية للمساق';
$string['homemycred'] = 'الصفحة الرئيسية الاعتماد';
$string['homemylectures'] = 'الصفحة الرئيسية للمحاضرة';
$string['homemylessons'] = 'الصفحة الرئيسية للدرس';
$string['homemymodules'] = 'الصفحة الرئيسية للوحدة';
$string['homemyplans'] = 'الصفحة الرئيسية للخطة';
$string['homemyprofessionaldevelopment'] = 'الصفحة الرئيسية للمطور';
$string['homemyprograms'] = 'الصفحة الرئيسية للبرنامج';
$string['homemytraining'] = 'الصفحة الرئيسية للتدريب';
$string['homemyunits'] = 'الصفحة الرئيسية للوحدة';
$string['iconnavheading'] = 'رمز التنقل';
$string['iconnavheadingsub'] = 'إنشاء أزراة مع أيقونات للاستخدام على الصفحة الرئيسية.
الروابط يمكن أن تذهب بك إلى أيّ مكان.';
$string['iconwidth'] = 'عرض أيقونة الصفحة الرئيسية';
$string['iconwidth_desc'] = 'عرض الرموز الفردية الثمانية في شريط التنقل في الأيقونة على الصفحة الرئيسية.';
$string['iconwidthinfo'] = 'إعداد عرض زر الأيقونة';
$string['iconwidthinfodesc'] = 'حدد عرضًا يسمح بنص الارتباط الخاص بك ليناسب داخل أزرار التنقل في الأيقونة.';
$string['ilearnsecurebrowser'] = 'تم تأمين هذا الاختبار باستخدام iLearn Secure Browser (يجب استخدام جهاز Chromebook باستخدام تطبيق iLearn لمحاولة هذا الاختبار)';
$string['imagesettings'] = 'إعدادات الصور المخصصة';
$string['instagram'] = 'رابط الانستغرام';
$string['instagramdesc'] = 'أدخل رابط صفحة الانستغرام الخاصة بك. (بمعنى https://instagram.com/mycollege)';
$string['jitsibuttontextdesc'] = 'إضافة نص إلى الزر الذي ستتم إضافته أعلى كل مساق في مودل. هذا الزر سيأخذ المستخدمين إلى غرفة اجتماع Jitsi تتم صياغة رابطه من اسم المساق ومُعرَّفه. ينبغي أن بكون لديك مخدم ويب لاجتماعات Jitsi .';
$string['jitsibuttonurldesc'] = 'مثال على مخدم عمومي: https://meet.jit.si <br> لا تُضف الشَّرطة الخلفية اللاحقة <br> سيتم استعمال عنوان الرابط هذا مع الزر الذي ستتم إضافته تلقائيًا إلى كل مساق في مودل عند منطقة الرأس. نوصي بشدة بأن تقوم بتهيئة مخدم Jitsi الخاص بك مع فرض تسجيل الدخول إلى غرفة اجتماعات Jitsi.';
$string['layoutinfo'] = 'إعدادات الشكل الظاهري';
$string['layoutinfodesc'] = 'التحكم في تخطيط الصفحة عن طريق اختيار تصميم.';
$string['learningcontentpadding'] = 'تباعد المحتوى التعليمي';
$string['learningcontentpadding_desc'] = 'يتحكم هذا في مقدار المسافة بين أعلى الصفحة والمحتوى الرئيسي للمساق. بشكل عام، تريد أن يكون هذا أقل من ارتفاع صورة العنوان.';
$string['linkedin'] = 'رابط LinkedIn';
$string['linkedindesc'] = 'أدخل رابط ملفك الشخصي في LinkedIn. (أي https://www.linkedin.com/)';
$string['loginimage'] = 'صورة تسجيل الدخول الافتراضية';
$string['loginimage_desc'] = 'صورة خلفية صفحة تسجيل الدخول';
$string['loginnavicon1'] = 'الأيقونة 1';
$string['loginnavicon2'] = 'الأيقونة 2';
$string['loginnavicon3'] = 'الأيقونة 3';
$string['loginnavicon4'] = 'الأيقونة 4';
$string['loginnavicontext'] = 'نص الأيقونة';
$string['loginnavicontextdesc'] = 'النص الذي سيظهر أسفل الرمز. اجعل الموضوع قصير للحصول على أفضل النتائج.';
$string['loginnavicontitletext'] = 'عنوان الأيقونة';
$string['loginnavicontitletextdesc'] = 'النص الذي يظهر أسفل الرمز كعنوان.';
$string['logintopimage'] = 'صورة صفحة تسجيل الدخول';
$string['logintopimage_desc'] = 'تظهر هذه الصورة في صفحة تسجيل الدخول، إلى يمين نموذج تسجيل الدخول. هذا مثالي للشعار أو شعار مع خلفية شفافة.';
$string['marketboxbuttoncolor'] = 'لون زر مربع التسويق';
$string['marketboxbuttoncolor_desc'] = 'لون خلفية زر مربع التسويق.';
$string['marketboxcolor'] = 'لون خلفية مربع التسويق';
$string['marketboxcolor_desc'] = 'لون خلفية مربع التسويق.';
$string['marketboxcontentcolor'] = 'لون خلفية محتوى مربع التسويق';
$string['marketboxcontentcolor_desc'] = 'لون الخلفية لمحتوى مربع التسويق. هذا موضع ظهور النص في نقطة التسويق ويمكن أن يكون مختلفًا عن لون خلفية المربع من أجل جذب الانتباه إلى النص.';
$string['marketing1'] = 'نقطة التسويق 1';
$string['marketing2'] = 'نقطة التسويق 2';
$string['marketing3'] = 'نقطة التسويق 3';
$string['marketing4'] = 'نقطة التسويق 4';
$string['marketing5'] = 'نقطة التسويق 5';
$string['marketing6'] = 'نقطة التسويق 6';
$string['marketing7'] = 'نقطة التسويق 7';
$string['marketing8'] = 'نقطة التسويق 8';
$string['marketing9'] = 'نقطة التسويق 9';
$string['marketingbuttontext'] = 'نص الرابط';
$string['marketingbuttontextdesc'] = 'النص الذي يظهر على الزر.';
$string['marketingbuttonurl'] = 'الرابط';
$string['marketingbuttonurldesc'] = 'العنوان الذي سوف يشير الزر إليه.';
$string['marketingcontent'] = 'المحتوى';
$string['marketingcontentdesc'] = 'المحتوى المراد عرضه في مربع التسويق. أبقه مختصرًا ولطيفًا.';
$string['marketingdesc'] = 'هذا القالب يعطيك خيار تمكين تسعة نقاط "تسويق" أو "إعلان" تحت عارض الشرائح. إنها تسمح لك بتعريف المعلومات الأساسية إلى مستخدميك بسهولة كما تقدم لهم روابط مباشرة.';
$string['marketingheading'] = 'بلاطات التسويق';
$string['marketingheadingsub'] = 'ثلاثة مواضع في صفحة الواجهة لإضافة المعلومات والروابط';
$string['marketingheight'] = 'إرتفاع صور التسويق';
$string['marketingheightdesc'] = 'إذا أردت عرض الصور في مربعات التسويق، يمكنك تحديد إرتفاعها هنا.';
$string['marketingicon'] = 'أيقونة الرابط';
$string['marketingicondesc'] = 'اسم الأيقونة التي ترغب باستعمالها في عنوان نقاط التسويق. القائمة تجدها <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">هنا</a>. أدخل فقط ما تجده بعد "fa-"، مثلاً "star".';
$string['marketingimage'] = 'الصورة';
$string['marketingimage_desc'] = 'يوفر هذا خيار عرض صورة في نقطة التسويق';
$string['marketinginfodesc'] = 'أدخل إعدادات نقطة التسويق الخاصة بك. ينبغي عليك تضمين عنوان لكي تظهر نقطة التسويق. العنوان سيقوم بتفعيل نقطة التسويق كل على حدة.';
$string['marketingstyle'] = 'منتقي نمط بلاطة التسويق';
$string['marketingstyle1'] = 'شريط تسليط الضوء العلوي';
$string['marketingstyle2'] = 'أرسل ملاحظه';
$string['marketingstyle3'] = 'بساطة';
$string['marketingstyle4'] = 'صندوق مظلل';
$string['marketingstyle_desc'] = 'إختر من بين أنماط التسويق التالية. سيؤدي ذلك إلى تغيير شكل مربعات التسويق ونمطها في الصفحة الرئيسية للموقع.';
$string['marketingtitle'] = 'العنوان';
$string['marketingtitledesc'] = 'العنوان المراد عرضه في نقطة التسويق هذه. ينبغي عليك تضمين عنوان لتظهر "بلاطة التسويق".';
$string['marketingurltarget'] = 'رابط الهدف';
$string['marketingurltargetdesc'] = 'اختر كيف ينبغي فتح الرابط';
$string['marketingurltargetnew'] = 'صفحة جديدة';
$string['marketingurltargetparent'] = 'في الإطر الأصلي';
$string['marketingurltargetself'] = 'الصفحة الحالية';
$string['markettextbg'] = 'خلفية نص بلاطة التسويق';
$string['markettextbg_desc'] = 'لون الخلفية لمنطقة النص في بلاطة التسويق.';
$string['menusettings'] = 'إعدادات القائمة';
$string['myclasses'] = 'موادي';
$string['mycomp'] = 'كفاءاتي';
$string['mycourses'] = 'مقرراتي';
$string['mycoursesinfo'] = 'قائمة الانضمامات الديناميكية إلى المقررات الدراسية وقوائم التنقل في المقررات';
$string['mycoursesinfodesc'] = 'يعرض قائمة متحركة من المقررات الدراسية المنضم إليها المستخدم في شريط التنقل العلوي. سيؤدي ذلك أيضاً إلى التحكم بقائمة التنقل في المقرر لكل مقرر على حدة.';
$string['mycoursetitle'] = 'المصطلح';
$string['mycoursetitledesc'] = 'تغيير مصطلح رابط "مساقتي" في القائمة المنسدلة';
$string['mycred'] = 'بيانات الاعتماد الخاصة بي';
$string['mygradestext'] = 'درجاتي';
$string['mylectures'] = 'محاضراتي';
$string['mylessons'] = 'دروسي';
$string['mymodules'] = 'نماذجي';
$string['myplans'] = 'خططي';
$string['myprofessionaldevelopment'] = 'تطويراتي';
$string['myprograms'] = 'برامجي';
$string['myprogresspercentage'] = 'النسبة %';
$string['myprogresstext'] = 'تقدّمي';
$string['mytraining'] = 'تدريبي';
$string['myunits'] = 'وحداتي';
$string['navbarcolorswitch'] = 'تبديل لون شريط التمرير';
$string['navbarcolorswitch_desc'] = 'تعمل هذه الميزة على تغيير لون شريط التنقل حسب دور المستخدم. سيرى الطالب لونًا معينًا وسيرى المعلم لونًا آخر. يكون هذا مفيدًا عندما يغير المعلم الأدوار ويساعد على التمييز بين طريقة عرض الطالب وطريقة عرض المعلم.';
$string['navbarcolorswitch_off'] = 'لا تقم بتغيير لون شريط التنقل بناءً على الدور.';
$string['navbarcolorswitch_on'] = 'تغيير لون شريط التنقل بناءً على الدور.';
$string['navdrawerbtn'] = 'التنقل';
$string['navicon'] = 'الأيقونة';
$string['navicon1'] = 'الصفحة الرئيسية الأيقونة الأولى';
$string['navicon2'] = 'الصفحة الرئيسية الأيقونة الثانية';
$string['navicon3'] = 'الصفحة الرئيسية الأيقونة الثالثة';
$string['navicon4'] = 'الصفحة الرئيسية الأيقونة الرابعة';
$string['navicon5'] = 'الصفحة الرئيسية الأيقونة الخامسة';
$string['navicon6'] = 'الصفحة الرئيسية الأيقونة السادسة';
$string['navicon7'] = 'الصفحة الرئيسية الأيقونة السابعة';
$string['navicon8'] = 'الصفحة الرئيسية الأيقونة الثامنة';
$string['naviconbutton1textdefault'] = 'لوحة القيادة';
$string['naviconbutton2textdefault'] = 'التقويم';
$string['naviconbutton3textdefault'] = 'الشارات';
$string['naviconbutton4textdefault'] = 'كل المقررات الدراسية';
$string['naviconbuttoncreatetextdefault'] = 'إنشاء مساق';
$string['naviconbuttontext'] = 'الرابط';
$string['naviconbuttontextdesc'] = 'النص الذي يظهر أسفل الأيقونة.';
$string['naviconbuttonurl'] = 'الرابط';
$string['naviconbuttonurldesc'] = 'العنوان الذي سوف يشير الزر إليه. يمكنك الارتباط بأيّ مكان بما في ذلك المواقع الخارجية .. فقط أدخل عنوان الرابط الصحيح. إذا كان موقع Moodle الخاص بك في دليل فرعي ، فلن يعمل الرابط الافتراضي.
يرجى ضبط الرابط ليعكس الدليل الفرعي.
مثال إذا كان "moodle" هو مجلد الدليل الفرعي الخاص بك ، فسيلزم تغيير عنوان URL إلى / moodle / my /';
$string['navicondesc'] = 'اسم الأيقونة التي ترغب باستعمالها. القائمة تجدها <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">هنا</a>. أدخل فقط ما تجده بعد "fa-"، مثلاً "star".';
$string['naviconslidedesc'] = 'نص الرمز المقترح: سهم لأسفل. أو اختر من القائمة هنا.
فقط أدخل ما بعد "fa-" ، على سبيل المثال "نجمة".';
$string['noenrolments'] = 'ليس لديك أيّ تسجيلات حالية';
$string['nomycourses'] = 'أنت غير مسجّل في أيّ مادة.';
$string['pagelayout'] = 'منتقي التخطيط';
$string['pagelayout1'] = 'تخطيط Boost افتراضي';
$string['pagelayout2'] = 'كامل العرض / أعلى رأس الصورة';
$string['pagelayout3'] = 'توسيط المحتوى / تداخل رأس الصورة';
$string['pagelayout4'] = 'توسيط المحتوى / صورة رأس الشاشة الكاملة';
$string['pagelayout5'] = 'صورة تخطيط  Boost الافتراضية / مربع عنوان المادة';
$string['pagelayout_desc'] = 'اختر من بين التخطيطات التالية. تتطلب بعض تخطيطات الصفحة تعديلات إضافية على صفحة معايرات التحضير المسبق.
تأكد من الانتباه إلى: تعلّم تباعد المحتوى، إرتفاع صورة الرأس، حشو المحتوى، حيث سيساعد ذلك في ضبط موضع صورة الرأس والحشو على يسار ويمين محتوى التعلم الرئيسي. <a href="https://goo.gl/fMXzSo" target="_new">تعليمات Fordson</a>';
$string['pinterest'] = 'رابط موقع Pinterest';
$string['pinterestdesc'] = 'أدخل رابط صفحتك في موقع Pinterest (مثلاً https://pinterest.com/mycollege)';
$string['pluginname'] = 'Fordson';
$string['preset'] = 'الإعداد المسبق للمظهر';
$string['preset_desc'] = 'اختر إعدادًا مسبقًا لتغيير القالب على نطاق واسع.
شاهد تعليمات لـ Fordson 3.5 Theme';
$string['presetadjustmentsettings'] = 'التعديلات السابقة';
$string['presetfiles'] = 'ملفات إضافية لمظهر سابق';
$string['presetfiles_desc'] = 'يمكن استعمال ملفات التحضير المسبق لتغيير القالب إلى حدٍ كبير. أنظر <a href="https://docs.moodle.org/dev/Boost_Presets">تحضيرات Boost المسبقة</a> للحصول على معلومات حول إنشاء ومشاركة ملفات التحضير المسبق الخاصة بك.';
$string['presets_settings'] = 'المسبقة';
$string['privacy:metadata'] = 'مظهر Fordson لا يخزن أي بيانات شخصية عن أيّ مستخدم.';
$string['qbank'] = 'بنك الأسئلة';
$string['qbank_desc'] = 'إنشاء وتنظيم أسئلة الاختبارات';
$string['rawscss'] = 'SCSS الأصلية';
$string['rawscss_desc'] = 'استخدم هذا الحقل لتوفير كود SCSS الذي سيتم حقنه في نهاية ورقة الأنماط.';
$string['rawscsspre'] = 'SCSS الأولية والأصلية';
$string['rawscsspre_desc'] = 'في هذا الحقل ، يمكنك توفير تهيئة كود SCSS ، سيتم حقنه قبل أيّ شيء آخر.
معظم الوقت سوف تستخدم هذا الإعدادات لتحديد المتغيرات.';
$string['region-fp-a'] = 'عمود A';
$string['region-fp-b'] = 'عمود B';
$string['region-fp-c'] = 'عمود C';
$string['region-side-pre'] = 'اليمين';
$string['section_mods'] = 'النماذج:';
$string['sectionlayout'] = 'منتقي نمط الأقسام';
$string['sectionlayout1'] = 'الافتراضي Boost';
$string['sectionlayout2'] = 'بطاقة ملاحظة بالغامق';
$string['sectionlayout3'] = 'تبويبات المجلد';
$string['sectionlayout4'] = 'لوحة القص';
$string['sectionlayout5'] = 'صندوق بسيط';
$string['sectionlayout6'] = 'عنوان القسم البارز';
$string['sectionlayout7'] = 'متعلم جامعي';
$string['sectionlayout8'] = 'متعلم الشركات';
$string['sectionlayout_desc'] = 'اختر من الموضوع التالي / أنماط القسم الأسبوعية.
شاهد تعليمات لمظهر  Fordson 3.5';
$string['setting_navdrawersettings'] = 'إعدادات شريط التنقل';
$string['setting_navdrawersettings_desc'] = 'تمكين ميزة درج التنقل  Boost .
لا يتطلب Fordson درج للتنقل. لقد استبدلناها بقائمة منسدلة للانتقال إلى القسم.
يمكنك إعادة تمكين درج التنقل أدناه.';
$string['showactivitynav'] = 'إظهار التنقل في النشاط';
$string['showactivitynav_desc'] = 'ألغ تحديد هذا الخيار لإيقاف التنقل في النشاط أسفل صفحات النشاط.';
$string['showblockregions'] = 'إظهار مناطق الكتل الإضافية في صفحة الواجهة';
$string['showblockregions_desc'] = 'تشغيل ثلاث مناطق إضافية للكتل في صفحة واجهة الموقع. تظهر هذه مباشرة تحت أيقونة شريط التنقل.';
$string['showcourseadminstudents'] = 'عرض إعدادات الطالب للمادة على المدير';
$string['showcourseadminstudents_desc'] = 'هذا يعرض إعدادات المقرر للطلاب. هذا مطلوب إذا كنت تريد السماح لهم بإلغاء الانضمام في المقررات الدراسية.';
$string['showcourseheaderimage'] = 'إظهار صور المساق';
$string['showcourseheaderimage_desc'] = 'اسمح للمعلمين بتخصيص صورة رأس المادة عن طريق تحميل ملف صورة في إعدادات المادة.';
$string['showcustomlogin'] = 'قم بتشغيل تسجيل الدخول المخصص';
$string['showcustomlogin_desc'] = 'يجب تشغيل هذا لتفعيل للإعدادات المخصصة أدناه.';
$string['showloginform'] = 'عرض نموذج تسجيل الدخول';
$string['showloginform_desc'] = 'قم بإلغاء التحديد لإخفاء نموذج تسجيل الدخول المخصص على الصفحة الرئيسية .. للمستخدمين الذين تم تسجيل خروجهم.';
$string['shownavclosed'] = 'درج التنقل مغلق بشكل افتراضي';
$string['shownavclosed_desc'] = 'إظهار درج التنقل منغلق لجميع المستخدمين افتراضيًا في كل صفحة.';
$string['shownavdrawer'] = 'إظهار درج التنقل';
$string['shownavdrawer_desc'] = 'ألغت Fordson الحاجة إلى درج التنقل من خلال استخدام قائمة منسدلة للتنقل داخل المادة.
إذا كان يجب عليك استخدام درج التنقل ، فيمكنك تحديد هذا المربع لإعادة تمكينه.';
$string['showonlygroupteachers'] = 'فقط أظهر مجموعة المعلمين';
$string['showonlygroupteachers_desc'] = 'عند التمكين ، سيتم عرض المعلمين فقط  في نفس المجموعة .. مثل الطالب في لوحة إدارة الطالب للمادة .';
$string['showslideshow'] = 'تنشيط عرض الشرائح';
$string['showslideshow_desc'] = 'حدد هذا الخيار لتشغيل ميزة عرض الشرائح.';
$string['showstudentcompletion'] = 'إظهار إكمال الطالب';
$string['showstudentcompletion_desc'] = 'إظهار شريط  إتمام الطالب في لوحة الطالب. حتى مع تحديد هذا الخيار ، يجب أن تكون المادة قيد التشغيل حتى يتم عرضها.';
$string['showstudentgrades'] = 'عرض درجات الطلاب';
$string['showstudentgrades_desc'] = 'إظهار رابط دفتر التقديرات للطالب في لوحة معلومات الطالب. حتى مع تحديد هذا الخيار ، يجب أن يكون البرنامج الدراسي قيد التشغيل لإظهار درجات الطالب.';
$string['siteadminquicklink'] = 'إدارة الموقع';
$string['skype'] = 'حساب Skype';
$string['skypedesc'] = 'أدخل اسم المستخدم لحساب Skype العائد لمنظمتك';
$string['slide1info'] = 'الشريحة 1';
$string['slide1infodesc'] = 'ثفاصيل الشريحة 1.';
$string['slide2info'] = 'الشريحة 2';
$string['slide2infodesc'] = 'تفاصيل الشريحة 2 .';
$string['slide3info'] = 'الشريحة 3';
$string['slide3infodesc'] = 'تفاصيل الشريحة 3 .';
$string['slidecontent'] = 'وصف الشريحة';
$string['slidecontent_desc'] = 'أضف وصفًا لهذه الشريحة.';
$string['slideimage'] = 'صورة الشريحة';
$string['slideimage_desc'] = 'أضف صورة خلفية لهذه الشريحة.';
$string['sliderinfo'] = 'زر أيقونة الشريحة الخاصة';
$string['sliderinfodesc'] = 'هذا الزر يعرض/يخفي مربع نص خاص ينزلق من شريط التنقل في الأيقونة. هذا مثالي لعرض المقررات الدراسية المميزة، لتقديم المساعدة أو إدراج التدريب المطلوب للموظفين.';
$string['slideshowheight'] = 'ارتفاع عرض الشرائح';
$string['slideshowheight_desc'] = 'أضبط إرتفاع عرض الشرائح في صفحة الموقع الرئيسية وصفحة لوحة التحكم. يتم تجاهل هذا الإعداد في صفحة تسجيل الدخول المخصصة. في تلك الصفحة، يتم تحديد إرتفاع الشريحة حسب حجم الصفحة وعرضها.';
$string['slideshowsettings'] = 'عرض الشرائح';
$string['slidetextbox'] = 'مربع نص الشريحة';
$string['slidetextbox_desc'] = 'سيتم عرض محتوى مربع النص هذا عند الضغط على زر الشريحة.';
$string['slidetitle'] = 'عنوان الشريحة';
$string['slidetitle_desc'] = 'أدخل عنوانًا لهذه الشريحة.';
$string['sociallink'] = 'تخصيص الرابط الاجتماعي';
$string['sociallinkdesc'] = 'أدخل رابط الوسائط الاجتماعية المخصص الخاص بك. (أي http://dearbornschools.org)';
$string['sociallinkicon'] = 'أيقونة الرابط';
$string['sociallinkicondesc'] = 'أدخل اسم fontawesome للأيقونة الخاصة بك<br />يمكن العثور على قائمة كاملة بأيقونات FontAwesome في
https://fontawesome.com/v4.7.0/icons/';
$string['socialnetworks'] = 'الشبكات الإجتماعية';
$string['studentdashboardtextbox'] = 'رسالة لوحة التحكم للطالب';
$string['studentdashboardtextbox_desc'] = 'إضافة رسالة للطلاب في لوحة التحكم الخاصة بالطلاب في كل صفحة من صفحات المقرر.';
$string['studentdashbutton'] = 'لوحة القيادة للمادة';
$string['textcontentinfo'] = 'محتوى مخصص';
$string['textcontentinfodesc'] = 'استخدم مربعات النص أدناه لإضافة معلومات مخصصة للمستخدمين.';
$string['thiscourse'] = 'هذا المساق';
$string['thismyclasses'] = 'هذا الفصل';
$string['thismycomp'] = 'هذه الكفاءة';
$string['thismycourses'] = 'هذه المادة';
$string['thismycred'] = 'هذا الاعتماد';
$string['thismylectures'] = 'هذه المحاضرة';
$string['thismylessons'] = 'هذا الدرس';
$string['thismymodules'] = 'هذه الوحدة';
$string['thismyplans'] = 'هذه الخطة';
$string['thismyprofessionaldevelopment'] = 'هذا التطوير المهني';
$string['thismyprograms'] = 'هذا البرنامج';
$string['thismytraining'] = 'هذا التدريب';
$string['thismyunits'] = 'هذه الوحدة';
$string['titletooltip'] = 'تلميح لعنوان المساق';
$string['titletooltip_desc'] = 'إذا كنت تستخدم عنوان المادة المقلّم ، يمكنك استخدام التلميحات التي ستعرض عنوان المادة بالكامل على شكل تلميح . حدد هذا المربع لتشغيل التلميحات.';
$string['togglemarketing'] = 'موضع بلاطة التسويق';
$string['togglemarketing_desc'] = 'حدد المكان الذي ستوضع فيه بلاطات التسويق في الصفحة الرئيسية.';
$string['topnavbarbg'] = 'شريط التنقل العلوي الافتراضي';
$string['topnavbarbg_desc'] = 'لون خلفية المحتوى لشريط التنقل العلوي.';
$string['topnavbarteacherbg'] = 'شريط التنقل العلوي في دور المعلم';
$string['topnavbarteacherbg_desc'] = 'لون خلفية المحتوى لشريط التنقل العلوي عندما يكون المستخدم معلمًا. ينبغي تشغيل هذه الميزة في إعدادات القائمة.
يرجى الاطلاع على الإعداد navbarcolorswitch.';
$string['trimsummary'] = 'تقليم ملخص المادة';
$string['trimsummary_desc'] = 'أدخل رقمًا لقص طول الملخص. يمثل هذا الرقم الأحرف التي سيتم عرضها.';
$string['trimtitle'] = 'تقليم عنوان المادة';
$string['trimtitle_desc'] = 'أدخل رقمًا لتقليص طول العنوان. يمثل هذا الرقم الأحرف التي سيتم عرضها.';
$string['tumblr'] = 'رابط Tumblr';
$string['tumblrdesc'] = 'أدخل رابط خاص Tumblr   (أي http://www.tumblr.com)';
$string['twitter'] = 'رابط تويتر';
$string['twitterdesc'] = 'أدخل رابط مغذي حسابك في تويتر (مثل https://www.twitter.com/mycollege)';
$string['userlinks'] = 'روابط المستخدم';
$string['userlinks_desc'] = 'إدارة طلابك';
$string['viewsectionmodules'] = 'عرض وحدات القسم';
$string['vimeo'] = 'رابط Vimeo';
$string['vimeodesc'] = 'أدخل رابطك  لقناة Vimeo . (أي http://vimeo.com/)';
$string['vk'] = 'رابط VKontakte';
$string['vkdesc'] = 'أدخل رابط لصفحة VKontakte . (أي http://www.vk.com/)';
$string['website'] = 'رابط الموقع';
$string['websitedesc'] = 'أدخل رابط لموقع الويب الخاص بك. (أي http://dearbornschools.org)';
$string['youtube'] = 'رابط اليوتيوب';
$string['youtubedesc'] = 'أدخل رابط قناتك على YouTube. (أي http://www.youtube.com/)';
