<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'scorm', language 'da', version '4.0'.
 *
 * @package     scorm
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activation'] = 'Aktivering';
$string['activityloading'] = 'Du føres automatisk til aktiviteten i';
$string['activityoverview'] = 'Du har SCORM-pakker der kræver din opmærksomhed';
$string['activitypleasewait'] = 'Aktiviteten indlæses, et øjeblik...';
$string['adminsettings'] = 'Admin-indstillinger';
$string['advanced'] = 'Parametre';
$string['aicchacpkeepsessiondata'] = 'AICC HACP-sessiondata';
$string['aicchacpkeepsessiondata_desc'] = 'Antal dage eksterne AICC HACP-sessionsdata kan bevares (en høj værdi vil fylde tabellen med gamle data men kan være hensigtsmæssig ved fejlsøgning)';
$string['aicchacptimeout'] = 'AICC HACP timeout';
$string['aicchacptimeout_desc'] = 'Antal minutter en ekstern AICC HACP-session kan forblive åben';
$string['aiccuserid_desc'] = 'AICC-standarden for brugernavne er meget restriktiv sammenlignet med Moodle, og tillader kun alfanumeriske tegn, bindestreg og understreg. Punktummer, mellemrum og @-tegn tillades ikke. Er indstillingen aktiveret, køres bruger-id-numre i stedet for brugernavne gennem AICC-pakken.';
$string['aliasonly'] = 'Ved valg af en imsmanifest.xml fil fra et arkiv skal du bruge et alias/en genvej til denne fil.';
$string['allowapidebug'] = 'Aktiver API-fejlsøgning og sporing (set the capture mask with apidebugmask)';
$string['allowtypeaicchacp'] = 'Aktiver ekstern AICC HACP';
$string['allowtypeaicchacp_desc'] = 'Er indstillingen aktiveret, tillades ekstern AICC HACP-kommunikation til indsendelse af forespørgsler uden at brugeren er logget ind fra den eksterne AICC-pakke';
$string['allowtypeexternal'] = 'Aktiver ekstern pakketype';
$string['allowtypeexternalaicc'] = 'Aktiver direkte AICC URL';
$string['allowtypeexternalaicc_desc'] = 'Er indstillingen aktiveret, muliggøres en direkte url til en enkelt AICC-pakke';
$string['allowtypelocalsync'] = 'Aktiver downloadet pakketype';
$string['areacontent'] = 'Indholdsfiler';
$string['areapackage'] = 'Pakkefil';
$string['asset'] = 'Materiale';
$string['assetlaunched'] = 'Materiale - vist';
$string['attempt'] = 'Forsøg';
$string['attempt1'] = '1 forsøg';
$string['attempts'] = 'Forsøg';
$string['attemptsmanagement'] = 'Administration af besvarelser';
$string['attemptstatusall'] = 'Betjeningspanel og indgangsside';
$string['attemptstatusentry'] = 'Kun forside';
$string['attemptstatusmy'] = 'Kun betjeningspanel';
$string['attemptsx'] = '{$a} forsøg';
$string['attr_error'] = 'Forkert værdi for attribut ({$a->attr}) i tag {$a->tag}.';
$string['autocommit'] = 'Auto-aflevering';
$string['autocommit_help'] = 'Er indstillingen aktiveret, gemmes SCORM-data automatisk i databasen. Egnet til SCORM-objekter der ikke regelmæssigt gemmer deres data.';
$string['autocommitdesc'] = 'Gem automatisk SCORM-data hvis SCORM-pakken ikke gør det.';
$string['autocontinue'] = 'Auto-fortsæt';
$string['autocontinue_help'] = 'Er indstillingen aktiveret, lanceres efterfølgende læringsobjekter automatisk, ellers skal knappen "Fortsæt" bruges.';
$string['autocontinuedesc'] = 'Er indstillingen aktiveret, lanceres efterfølgende læringsobjekter automatisk, ellers skal knappen "Fortsæt" bruges.';
$string['averageattempt'] = 'Gennemsnitlige forsøg';
$string['badarchive'] = 'Du skal levere en gyldig zip-fil';
$string['badimsmanifestlocation'] = 'Der blev fundet en imsmanifest.xml-fil, men ikke i roden af din zip-pakke. Pak din SCORM igen';
$string['badmanifest'] = 'Fejl i manifestet: se fejllog';
$string['browse'] = 'Vis';
$string['browsed'] = 'Vist';
$string['browsemode'] = 'Forhåndsvisning';
$string['browserepository'] = 'Gennemse arkiv';
$string['calculatedweight'] = 'Beregnet vægt';
$string['calendarend'] = '{$a} lukker';
$string['calendarstart'] = '{$a} åbner';
$string['cannotaccess'] = 'Du kan ikke kalde dette script på denne måde';
$string['cannotfindsco'] = 'Kunne ikke finde SCO';
$string['chooseapacket'] = 'Vis eller opdater en SCORM-pakke';
$string['closebeforeopen'] = 'Du har specificeret en lukkedag før åbningsdagen.';
$string['collapsetocwinsize'] = 'Sammenfold indholdsfortegnelsen når vinduets størrelse er under';
$string['collapsetocwinsizedesc'] = 'Med denne indstilling kan du specificere den vinduesstørrelse hvorunder indholdsfortegnelsen automatisk skal foldes sammen.';
$string['compatibilitysettings'] = 'Indstillinger for kompatibilitet';
$string['completed'] = 'Færdigt';
$string['completionscorerequired'] = 'Kræver minimumspoint';
$string['completionscorerequired_help'] = 'Aktivering af denne indstilling vil kræve at deltageren opnår en minimumskarakter for at få en markering som gennemført for denne SCORM-aktivitet sammen med andre gennemførelseskrav.';
$string['completionscorerequireddesc'] = 'En mindste score på {$a} kræves for gennemførelse';
$string['completionstatus_completed'] = 'Gennemført';
$string['completionstatus_passed'] = 'Bestået';
$string['completionstatusallscos_help'] = 'Nogle SCORM-pakker indeholder flere komponenter eller "scos" - når denne indstilling er aktiveret skal alle scos i pakken have den relevante lesson_status for at blive markeret som gennemført.';
$string['completionstatusrequired'] = 'Kræver status';
$string['completionstatusrequired_help'] = 'Markering af en eller flere statusser vil kræve at en bruger skal opnå mindst en af de markerede statusser for at blive markeret som færdig med denne SCORM-aktivitet såvel som alle andre fuldførelsesbetingelser for aktiviteter.';
$string['completionstatusrequireddesc'] = 'Studerende skal opnå mindst en af følgende statusser: {$a}';
$string['confirmloosetracks'] = 'ADVARSEL: Det ser ud til at pakken er ændret eller modificeret. Hvis pakkens struktur er ændret kan det hænde at nogle af brugernes sporvalg er gået tabt under opdateringen.';
$string['contents'] = 'Indhold';
$string['coursepacket'] = 'Kursuspakke';
$string['coursestruct'] = 'Kursusstruktur';
$string['crontask'] = 'Baggrundsbehandling af SCORM';
$string['currentwindow'] = 'Nuværende vindue';
$string['datadir'] = 'Filsystemfejl: Kan ikke oprette en mappe til kursusdata.';
$string['defaultdisplaysettings'] = 'Standard visningsindstillinger';
$string['defaultgradesettings'] = 'Standard karakterindstillinger';
$string['defaultothersettings'] = 'Andre standardindstillinger';
$string['deleteallattempts'] = 'Slet alle SCORM-forsøg';
$string['deleteattemptcheck'] = 'Er du nu sikker på du vil helt slette disse forsøg?';
$string['deleteselected'] = 'Slet markerede besvarelser';
$string['deleteuserattemptcheck'] = 'Er du helt sikker på at du slette alle dine forsøg?';
$string['details'] = 'Følg oplysninger';
$string['directories'] = 'Vis mappelinks';
$string['disabled'] = 'Deaktiveret';
$string['display'] = 'Display';
$string['displayactivityname'] = 'Vis aktivitetsnavn';
$string['displayactivityname_help'] = 'Hvorvidt aktivitetens navn skal vises over SCORM-afspilleren.';
$string['displayattemptstatus'] = 'Vis status på forsøg';
$string['displayattemptstatus_help'] = 'Denne indstilling muliggør et resumé af brugeres forsøg i blokken med kursusoversigt i Betjeningspanelet og/eller på SCORM\'s forside.';
$string['displayattemptstatusdesc'] = 'Hvorvidt der skal vises et resumé af brugeres forsøg i blokken med kursusoversigt i Betjeningspanelet og/eller på SCORM\'s forside.';
$string['displaycoursestructure'] = 'Vis kursets struktur på første side';
$string['displaycoursestructure_help'] = 'Er indstillingen aktiveret, vises indholdsfortegnelsen på SCORM\'s oversigtsside.';
$string['displaycoursestructuredesc'] = 'Her vælges standardværdien på indstillingen for visning af kursusstruktur på første side.';
$string['displaydesc'] = 'Hvorvidt SCORM-pakken skal vises i et nyt vindue.';
$string['displaysettings'] = 'Visningsindstillinger';
$string['dnduploadscorm'] = 'Tilføj en SCORM-pakke';
$string['domxml'] = 'Eksternt DOMXML-bibliotek';
$string['element'] = 'Element';
$string['enter'] = 'Start';
$string['entercourse'] = 'Gå til kursus';
$string['errorlogs'] = 'Fejllog';
$string['eventattemptdeleted'] = 'Besvarelse slettet';
$string['eventreportviewed'] = 'Rapport set';
$string['eventscolaunched'] = 'Sco åbnet';
$string['eventscorerawsubmitted'] = 'Afleveret rå SCORM-point';
$string['eventstatussubmitted'] = 'Afleveret SCORM-status';
$string['eventuserreportviewed'] = 'Brugerrapport set';
$string['everyday'] = 'Hver dag';
$string['everytime'] = 'Hver gang den er i brug';
$string['exceededmaxattempts'] = 'Du har nået det maksimale antal forsøg.';
$string['exit'] = 'Forlad SCORM-kurset';
$string['exitactivity'] = 'Afslut aktiviteten';
$string['expired'] = 'Beklager, denne aktivitet lukkede {$a} og er ikke længere tilgængelig';
$string['failed'] = 'Dumpet';
$string['finishscorm'] = 'Hvis du er færdig med at se dette materiale, {$a}';
$string['finishscormlinkname'] = 'Klik her for at vende tilbage til kursussiden';
$string['firstaccess'] = 'Første adgang';
$string['firstattempt'] = 'Første forsøg';
$string['floating'] = 'Flydende';
$string['forceattemptalways'] = 'Altid';
$string['forcecompleted'] = 'Gennemtving som gennemført';
$string['forcecompleted_help'] = 'Er indstillingen aktiveret, sættes det aktuelle forsøg til "gennemført". (Virker kun med SCORM 1.2-pakker.)';
$string['forcecompleteddesc'] = 'Her styres standard for indstillingen "Gennemtving som gennemført"';
$string['forcejavascript'] = 'Tving brugere til at aktivere JavaScript';
$string['forcejavascript_desc'] = 'Er indstillingen aktiveret (anbefales), undgås adgang til SCORM-objekter når JavaScript ikke understøttes eller ikke er aktiveret i brugerens browser. Er indstillingen deaktiveret, kan brugeren se SCORM, men API-kommunikationen vil fejle og karakterer vil ikke blive gemt.';
$string['forcejavascriptmessage'] = 'Der kræves JavaScript for at se dette, aktiver det i din browser og prøv igen.';
$string['forcenewattempts'] = 'Gennemtving et nyt forsøg';
$string['found'] = 'Manifest fundet';
$string['frameheight'] = 'Højde på "stage frame" eller vindue.';
$string['framewidth'] = 'Bredde på "stage frame" eller vindue.';
$string['fromleft'] = 'Fra venstre';
$string['fromtop'] = 'Fra toppen';
$string['fullscreen'] = 'Brug hele skærmen';
$string['general'] = 'Generelle data';
$string['gradeaverage'] = 'Gennemsnitlig bedømmelse';
$string['gradeforattempt'] = 'Karakter for besvarelse';
$string['gradehighest'] = 'Højeste bedømmelse';
$string['grademethod'] = 'Bedømmelsesmetode';
$string['grademethod_help'] = 'Vurderingsmetoden definerer hvordan karakteren for et enkelt besvarelsesforsøg bestemmes. Der er 4 metoder:

* Læringobjekter - Antal gennemførte/beståede læringsobjekter
* Højeste karakter - Højeste point opnået i alle beståede læringsobjekter
* Gennemsnitskarakter - Gennemsnittet af alle point
* Karakter i alt - Summen af alle point';
$string['grademethoddesc'] = 'Karaktergivningsmetoden definerer hvordan karakteren for et enkelt besvarelsesforsøg fastsættes.';
$string['gradereported'] = 'Karakter rapporteret';
$string['gradescoes'] = 'Læringsobjekter';
$string['gradesettings'] = 'Karakterindstillinger';
$string['gradesum'] = 'Samlet bedømmelse';
$string['height'] = 'Højde';
$string['hidden'] = 'Skjult';
$string['hidebrowse'] = 'Deaktiver forhåndsvisning';
$string['hidebrowse_help'] = 'Med forhåndsvisning kan en studerende kigge i en aktivitet inden den forsøges besvaret. Er forhåndsvisning deaktiveret, vil forhåndsvisningsknappen være skjult.';
$string['hidebrowsedesc'] = 'Med forhåndsvisning kan en studerende kigge i en aktivitet inden den forsøges besvaret.';
$string['hideexit'] = 'Skjul afslut-link';
$string['hidereview'] = 'Skjul "Gennemse"-knappen';
$string['hidetoc'] = 'Vis kursusstruktur i afspilleren';
$string['hidetoc_help'] = 'Hvordan indholdsfortegnelsen vises i SCORM-afspilleren';
$string['hidetocdesc'] = 'Denne indstilling specificerer hvordan indholdsfortegnelsen vises i SCORM-afspilleren';
$string['highestattempt'] = 'Højeste forsøg';
$string['identifier'] = 'Spørgsmålsidentifikator';
$string['incomplete'] = 'Ukomplet';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'Info';
$string['interactions'] = 'Interaktioner';
$string['invalidactivity'] = 'SCORM-aktiviteten er ikke korrekt';
$string['invalidhacpsession'] = 'Ugyldig HACP-session';
$string['invalidmanifestname'] = 'Der kan kun vælges imsmanifest.xml eller zip-filer';
$string['invalidmanifestresource'] = 'ADVARSEL: De følgende ressourcer, der refereres til i dit manifest, blev ikke fundet:';
$string['invalidstatus'] = 'Ugyldig status';
$string['invalidurl'] = 'Ugyldig URL specificeret';
$string['invalidurlhttpcheck'] = 'Ugyldig URL specificeret. Fejlbesked: <pre>{$a->cmsg}</pre>';
$string['last'] = 'Seneste adgang';
$string['lastaccess'] = 'Seneste adgang';
$string['lastattempt'] = 'Sidste fuldførte forsøg';
$string['lastattemptlock'] = 'Luk efter den endelige besvarelse';
$string['lastattemptlock_help'] = 'Er indstillingen aktiveret, kan en studerende ikke bruge SCORM-player\'en når alle deres tildelte forsøg er opbrugt.';
$string['lastattemptlockdesc'] = 'Er indstillingen aktiveret, kan en studerende ikke bruge SCORM-player\'en når alle de tildelte forsøg er opbrugt.';
$string['location'] = 'Vis placeringslinjen';
$string['max'] = 'Maks. point';
$string['maximumattempts'] = 'Antal forsøg';
$string['maximumattempts_help'] = 'Denne indstilling aktiverer begrænsning af et antal besvarelsesforsøg. Det kan kun bruges til SCORM 1.2 og AICC-pakker';
$string['maximumattemptsdesc'] = 'Denne indstilling styrer højeste besvarelsesforsøg som standard for en aktivitet';
$string['maximumgradedesc'] = 'Her vælges hvilken højeste karakter, der skal bruges som standard i en aktivitet';
$string['menubar'] = 'Vis menulinjen';
$string['min'] = 'Minimum point';
$string['missing_attribute'] = 'Mangler attribut {$a->attr} i tag {$a->tag}';
$string['missing_tag'] = 'Mangler tag {$a->tag}';
$string['missingparam'] = 'En krævet parameter mangler eller er forkert';
$string['mode'] = 'Tilstand';
$string['modulename'] = 'Scorm-pakke';
$string['modulename_help'] = 'En SCORM-pakke er en samling filer som er pakket i overensstemmelse med en vedtaget standard for undervisningsmaterialer. SCORM-modulet muliggør SCORM- eller AICC-pakker at blive uploadet som en zip-fil og tilføjet et kursus.

Indholdet vises som regel over flere sider med navigation mellem siderne. Der er forskellige muligheder for visning af indholdet i et pop op-vindue, tabel over indhold, med navigationsknapper mv. SCORM-aktiviteter omfatter normalt spørgsmål med karakterer opført i karakterbogen.

SCORM kan bruges til

* Præsentation af multimedieindhold og animationer
* Som et vurderingsværktøj';
$string['modulename_link'] = 'mod/scorm/view';
$string['modulenameplural'] = 'Scorm-pakker';
$string['myattempts'] = 'Mine besvarelsesforsøg';
$string['nav'] = 'Vis navigation';
$string['nav_help'] = 'Denne indstilling styrer hvorvidt navigationsknapper skal vises eller skjules, og deres position.

Der er 3 muligheder:

* Nej - navigationsknapper vises ikke
* Under indholdet - navigationsknapper vises under indholdet af SCORM-pakken
* Flydende - navigationsknapper vises flydende, positioneret fra toppen og fra venstre styret af pakken.';
$string['navdesc'] = 'Denne indstilling styrer hvorvidt navigationsknapper skal vises eller skjules, og deres position';
$string['navigation'] = 'Navigation';
$string['navpositionleft'] = 'Position af navigationsknapper fra venstre i pixels.';
$string['navpositiontop'] = 'Position af navigationsknapper fra toppen i pixels.';
$string['networkdropped'] = 'SCORM-playeren har konstateret at din internetforbindelse er upålidelig eller er blevet afbrudt. Fortsætter du med denne SCORM-aktivitet, vil din progression ikke blive gemt.<br />Du bør forlade aktiviteten nu og returnere når du har en pålidelig internetforbindelse.';
$string['newattempt'] = 'Prøv et nyt forsøg';
$string['next'] = 'Fortsæt';
$string['no_attributes'] = 'Tagget {$a->tag} kræver attributter';
$string['no_children'] = 'Tagget {$a->tag} kræver undertags';
$string['noactivity'] = 'Intet at rapportere';
$string['noattemptsallowed'] = 'Antal tilladte forsøg';
$string['noattemptsmade'] = 'Antal forsøg, du har gjort';
$string['nolimit'] = 'Ubegrænsede forsøg';
$string['nomanifest'] = 'Forkert filpakke - mangler imsmanifest.xml eller AICC-struktur';
$string['noprerequisites'] = 'Desværre, du opfylder ikke betingelserne for at få adgang til denne aktivitet.';
$string['noreports'] = 'Ingen rapport at vise';
$string['normal'] = 'Normal';
$string['noscriptnoscorm'] = 'Din browser understøtter ikke javascript eller har det deaktiveret. Denne scorm-pakke vil måske ikke fungere korrekt.';
$string['not_corr_type'] = 'Type rod i tag {$a->tag}';
$string['notattempted'] = 'Ikke forsøgt';
$string['notopenyet'] = 'Beklager, denne aktivitet er ikke tilgængelig før {$a}';
$string['objectives'] = 'Mål';
$string['openafterclose'] = 'Du har angivet åbningsdatoen før lukkedatoen';
$string['optallstudents'] = 'alle brugere';
$string['optattemptsonly'] = 'kun brugere med forsøg';
$string['options'] = 'Valgmuligheder (Forhindres af nogle browsere)';
$string['optionsadv'] = 'Muligheder (Avanceret)';
$string['optionsadv_desc'] = 'Er indstillingen markeret, vil højde og bredde opføres som avancerede indstillinger';
$string['optnoattemptsonly'] = 'kun brugere uden forsøg';
$string['organization'] = 'Organisation';
$string['organizations'] = 'Organisationer';
$string['othersettings'] = 'Flere indstillinger';
$string['package'] = 'Filpakke';
$string['package_help'] = 'Pakkefilen er en zip- (eller pif-) fil med SCORM-/AICC-kursusdefinitionsfiler.';
$string['packagedir'] = 'Filsystemfejl: Kan ikke oprette en mappe til pakken.';
$string['packagefile'] = 'Der er ikke angivet en pakkefil';
$string['packagehdr'] = 'Pakke';
$string['packageurl'] = 'URL';
$string['packageurl_help'] = 'Denne indstilling muliggør angivelse af en URL til SCORM-pakken i stedet for at vælge en fil via filvælgeren.';
$string['page-mod-scorm-x'] = 'Enhver SCORM-pakke';
$string['pagesize'] = 'Sidestørrelse';
$string['passed'] = 'Bestået';
$string['php5'] = 'PHP 5 (DOMXML native library)';
$string['pluginadministration'] = 'SCORM/AICC-pakkeadministration';
$string['pluginname'] = 'SCORM-pakke';
$string['popup'] = 'Nyt vindue';
$string['popuplaunched'] = 'Denne SCORM-pakke er vist i et pop op-vindue. Når du er færdig med at se den kan du klikke her for at vende tilbage til kursussiden.';
$string['popupmenu'] = 'I en rullemenu';
$string['popupopen'] = 'Åbn pakken i et nyt vindue';
$string['popupsblocked'] = 'Det sker at pop op-vinduer er blokerede og forhindrer SCORM-pakken i at køre. Tjek dine browserindstillinger og prøv så igen.';
$string['position_error'] = 'Tagget {$a->tag} kan ikke stå inde i et {$a->parent}-tag';
$string['preferencespage'] = 'Indstillinger kun for denne side';
$string['preferencesuser'] = 'Indstillinger for denne rapport';
$string['prev'] = 'Forrige';
$string['protectpackagedownloads'] = 'Beskyt pakkedownloads';
$string['protectpackagedownloads_desc'] = 'Er indstillingen aktiveret, kan SCORM-pakker kun downloades hvis brugeren har beføjelsen "course:manageactivities". Er indstillingen deaktiveret, kan SCORM-pakker altid downloades (af mobile enheder eller andre formål).';
$string['raw'] = 'Rå point';
$string['regular'] = 'Regulært manifest';
$string['report'] = 'Rapport';
$string['reportcountallattempts'] = '{$a->nbattempts} besvarelser af {$a->nbusers} brugere, ud af {$a->nbresults} resultater';
$string['reportcountattempts'] = '{$a->nbresults} resultater ({$a->nbusers} brugere)';
$string['reports'] = 'Rapporter';
$string['repositorynotsupported'] = 'Dette filarkiv supporterer ikke direkte links til en imsmanifest.xml-fil.';
$string['response'] = 'Respons';
$string['result'] = 'Resultat';
$string['results'] = 'Resultater';
$string['review'] = 'Gennemse';
$string['reviewmode'] = 'Gennemsynstilstand';
$string['rightanswer'] = 'Rigtigt svar';
$string['scoes'] = 'Læringsobjekter';
$string['score'] = 'Score';
$string['scorm:addinstance'] = 'Tilføj en ny SCORM-pakke';
$string['scorm:deleteownresponses'] = 'Slet egne besvarelser';
$string['scorm:deleteresponses'] = 'Slet SCORM-forsøg';
$string['scorm:savetrack'] = 'Gem spor';
$string['scorm:skipview'] = 'Spring oversigten over';
$string['scorm:viewreport'] = 'Vis rapporter';
$string['scorm:viewscores'] = 'Vis point';
$string['scormclose'] = 'Tilgængelig indtil';
$string['scormcourse'] = 'Scorm-kursus';
$string['scormloggingoff'] = 'API-logning er ikke aktiv';
$string['scormloggingon'] = 'API-logning er aktiv';
$string['scormopen'] = 'Tilgængelig fra';
$string['scormresponsedeleted'] = 'Slettede brugerforsøg';
$string['scormtype'] = 'Type';
$string['scormtype_help'] = 'Denne indstilling styrer hvordan pakken inkluderes på kurset. Der er 4 muligheder:

* Uploadet pakke - SCORM-pakken kan vælges i filvælgeren
* Eksternt SCORM-manifest - En URL til en imsmanifest.xml kan specificeres. Bemærk: Hvis URL\'en er på et andet domæne end dette site er "Downloadet pakke" en bedre mulighed, da karakterer ellers ikke vil blive gemt.
* Downloadet pakke - en URL til pakken kan specificeres. Pakken vil blive pakket ud, gemt lokalt og opdateret når den eksterne SCORM-pakke er opdateret.
* Ekstern AICC-URL - Denne URL starter en enkelt AICC-aktivitet. En pseudopakke vil blive bygget omkring dette.';
$string['scrollbars'] = 'Tillad at vinduet scrolles';
$string['search:activity'] = 'SCORM-pakke - aktivitetsinformation';
$string['selectall'] = 'Vælg alle';
$string['selectnone'] = 'Fravælg alle';
$string['show'] = 'Vis';
$string['sided'] = 'Til siden';
$string['skipview'] = 'Studerende springer indholdsoversigten over';
$string['skipview_help'] = 'Denne indstilling sætter standarden for hvornår indholdsstruktureren for en side springes over (ikke vises). Hvis kun pakken indeholder et læringsobjekt, kan indholdsstrukturen altid springes over.';
$string['skipviewdesc'] = 'Denne indstilling sætter standarden for hvornår indholdsstruktureren for en side springes over';
$string['slashargs'] = 'ADVARSEL! Slash-argumenter er deaktiveret på dette site og objekter fungerer måske ikke som ventet!';
$string['stagesize'] = 'Objektes størrelse';
$string['stagesize_help'] = 'Disse to indstillinger angiver bredde og højde på ramme-/vindueslæringsobjekter.';
$string['started'] = 'Begyndt';
$string['status'] = 'Status';
$string['statusbar'] = 'Vis statuslinje';
$string['student_response'] = 'Svar';
$string['subplugintype_scormreport'] = 'Rapport';
$string['subplugintype_scormreport_plural'] = 'Rapporter';
$string['suspended'] = 'Suspenderet';
$string['syntax'] = 'Syntaksfejl';
$string['tag_error'] = 'Ukendt tag ({$a->tag}) med indholdet: {$a->value}';
$string['time'] = 'Tid';
$string['title'] = 'Titel';
$string['toc'] = 'Indholdsfortegnelse';
$string['too_many_attributes'] = 'Tagget {$a->tag} har for mange attributter';
$string['too_many_children'] = 'Tagget {$a->tag} har for mange undertags';
$string['toolbar'] = 'Vis værktøjslinjen';
$string['totaltime'] = 'Tid i alt';
$string['trackcorrectcount'] = 'Antal korrekte';
$string['trackcorrectcount_help'] = 'Antal rigtige resultater for dette spørgsmål';
$string['trackid'] = 'Id';
$string['trackid_help'] = 'Dette er din SCORM-pakkes identifikator til dette spørgsmål, SCORM-specifikationen tillader ikke levering af hele spørgsmålsteksten.';
$string['trackingloose'] = 'ADVARSEL: Sporingsdata fra denne SCORM-pakke vil gå tabt';
$string['tracklatency'] = 'Latens';
$string['tracklatency_help'] = 'Tiden fra spørgsmålet åbnede for besvarelser fra studerende til første besvarelse.';
$string['trackpattern'] = 'Mønster';
$string['trackpattern_help'] = 'Sådan bør et korrekt svar på spørgsmålet være, det viser ikke den studerendes respons.';
$string['trackresponse'] = 'Respons';
$string['trackresponse_help'] = 'Dette er den studerendes respons på spørgsmålet';
$string['trackresult'] = 'Resultat';
$string['trackresult_help'] = 'Viser om den studerende gav en korrekt respons';
$string['trackscoremax'] = 'Maksimumpoint';
$string['trackscoremin'] = 'Minimumspoint';
$string['trackscoreraw_help'] = 'Tal der reflekterer den studerendes ydelse relativ til intervallet afgrænset af værdierne for min og maks.';
$string['tracksuspenddata'] = 'Suspender data';
$string['tracktime'] = 'Tidspunkt';
$string['tracktime_help'] = 'Tidspunkt da besvarelsesforsøget begyndte';
$string['tracktype'] = 'Type';
$string['tracktype_help'] = 'Type spørgsmål, f.eks. "valg" eller "kort svar"';
$string['trackweight'] = 'Vægt';
$string['trackweight_help'] = 'Vægt tildelt spørgsmålet når karakteren beregnes.';
$string['type'] = 'Type';
$string['typeaiccurl'] = 'Ekstern AICC-URL';
$string['typeexternal'] = 'Eksternt SCORM-manifest';
$string['typelocal'] = 'Uploadet pakke';
$string['typelocalsync'] = 'Downloadet pakke';
$string['undercontent'] = 'Under indholdet';
$string['unziperror'] = 'Der opstod en fejl under udpakningen';
$string['updatefreq'] = 'Auto-opdateringsfrekvens';
$string['updatefreq_error'] = 'Jævnlig auto-opdatering kan kun sættes når pakkefilen beværtes eksternt';
$string['updatefreq_help'] = 'Dette muliggør at den eksterne pakke automatisk downloades og opdateres';
$string['updatefreqdesc'] = 'Denne indstilling sætter standard auto-opdateringsfrekvensen på en aktivitet';
$string['validateascorm'] = 'Valider en SCORMpakke';
$string['validation'] = 'Valideringsresultat';
$string['validationtype'] = 'Disse indstillinger styrer DOMXML-biblioteket der bruges til at validere SCORM-manifestet. Hvis du er i tvivl, er det bedst at lade dem være.';
$string['value'] = 'Værdi';
$string['versionwarning'] = 'Manifestversionen er ældre end version 1.3. Advarsel ved {$a->tag} tagget.';
$string['viewallreports'] = 'Vis rapport for {$a} forsøg';
$string['viewalluserreports'] = 'Vis rapporter for {$a} brugere';
$string['whatgrade'] = 'Forsøgsvurdering';
$string['whatgrade_help'] = 'Hvis flere forsøg på besvarelse accepteres, styrer denne indstilling hvorvidt højeste, gennemsnitlige, første eller sidste færdiggjorte forsøg opføres i karakterbogen. Det sidst forsøgte forsøg inkluderer ikke "mislykket" status.

Bemærkninger til håndtering af flere forsøg:

* Mulighed for at starte på et nyt forsøg gives af en tjekboks over Enter-knappen på indholdsstruktursiden, så sørg for at give adgang til den side hvis du vil give mulighed for mere end et forsøg.
* Nogle SCORM-pakker er "intelligente" omkring nye forsøg, andre er ikke. Det betyder, at hvis en studerende vender tilbage til et eksisterende forsøg, hvis ikke SCORM-pakken har en intern logik der forhindrer overskrivning af tidligere forsøg, kan de ændres, selv hvis forsøget allerede var gennemført eller bestået.
* Indstillingerne "Gennemtving gennemført", "Gennemtving nyt forsøg" og "Luk efter den endelige besvarelse" giver også yderligere administration af flere forsøg.';
$string['whatgradedesc'] = 'Hvorvidt det højeste, gennemsnitlige, første eller sidste gennemførte forsøg opføres i karakterbogen hvis flere forsøg accepteres.';
$string['width'] = 'Bredde';
$string['window'] = 'Vindue';
