<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'da', version '4.0'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Handling';
$string['activityoverview'] = 'Du har spørgeskemaer, der skal afleveres';
$string['additionalinfo'] = 'Yderligere information';
$string['additionalinfo_help'] = 'Tekst, der skal vises øverst på første side af dette spørgeskema. (fx instruktioner, baggrundsinformation osv.)';
$string['addnewquestion'] = 'Tilføjer {$a} spørgsmål';
$string['addquestions'] = 'Tilføj spørgsmål';
$string['addselqtype'] = 'Tilføj valgt spørgsmålstype';
$string['alignment'] = 'Opstilling af radio-knapper';
$string['alignment_help'] = 'Vælg opstilling af knapper: lodret (standard) eller vandret.';
$string['alignment_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['all'] = 'Alt';
$string['alreadyfilled'] = 'Du har allerede udfyldt dette spørgeskema for os{$a}. Tak.';
$string['andaveragevalues'] = 'og gennemsnitlige værdier';
$string['anonymous'] = 'Anonym';
$string['answerquestions'] = 'Besvar spørgsmålene...';
$string['attempted'] = 'Spørgeskemaet er indsendt.';
$string['attemptstillinprogress'] = 'I gang. Gemt på:';
$string['autonumbering'] = 'Autonummerering';
$string['autonumbering_help'] = 'Automatisk nummerering af spørgsmål og sider. Det kan være nødvendigt at slå automatisk nummerering fra i spøgeskemaer med betinget forgrening.';
$string['autonumberno'] = 'Spørgsmål og sider skal ikke nummereres';
$string['autonumberpages'] = 'Autonummerer sider';
$string['autonumberpagesandquestions'] = 'Autonummerer sider og spørgsmål';
$string['autonumberquestions'] = 'Autonummerer spørgsmål';
$string['average'] = 'Gennemsnit';
$string['averageposition'] = 'Gennemsnitlig placering';
$string['averagerank'] = 'Gennemsnitlig rang';
$string['bodytext'] = 'Indholdstekst';
$string['boxesnbexact'] = 'præcis {$a} kasse(r).';
$string['boxesnbmax'] = 'højst {$a} kasse(r).';
$string['boxesnbmin'] = 'mindst {$a} kasse(r).';
$string['boxesnbreq'] = 'Til dette spørgsmål skal du krydse af';
$string['by'] = 'af';
$string['cannotviewpublicresponses'] = 'Du kan ikke se svar på dette offentlige spørgeskema.';
$string['chart:bipolar'] = 'Grafer';
$string['chart:hbar'] = 'Vandrette grafer';
$string['chart:radar'] = 'Radar';
$string['chart:rose'] = 'Rose';
$string['chart:type'] = 'Skematype';
$string['chart:type_help'] = 'Vælg den skematype, du vil bruge her';
$string['chart:vprogress'] = 'Lodret progressionsbar';
$string['checkallradiobuttons'] = 'Vær venlig at markere <strong>{$a}</strong> radio-knapper!';
$string['checkboxes'] = 'Afkrydsningsbokse';
$string['checkboxes_help'] = 'Indsæt en valgmulighed pr. linje, som brugeren kan vælge et eller flere svar fra.';
$string['checkboxes_link'] = 'mod/questionnaire/questions#Check_Boxes';
$string['checkbreaksadded'] = 'Sideskift indsat ved position(erne):';
$string['checkbreaksok'] = 'Alle påkrævede sideskift er til stede!';
$string['checkbreaksremoved'] = 'Fjernede {$a} ekstra sideskift.';
$string['checknotstarted'] = 'Udvælgelse ikke påbegyndt';
$string['checkstarted'] = 'Udvælgelse påbegyndt';
$string['clicktoswitch'] = '(klik for at skifte)';
$string['closed'] = 'Spørgeskemaet er lukket {$a}. Tak.';
$string['closedate'] = 'Brug lukkedato';
$string['closeson'] = 'Spørgeskemaet lukker d. {$a}';
$string['completionsubmit'] = 'Studerende skal indsende dette spørgeskema for at det er fuldført';
$string['confalts'] = '- OR - <br />Bekræftelsesside';
$string['configmaxsections'] = 'Højeste antal feedback-sektioner';
$string['configusergraph'] = 'Vis skemaer til feedback på \'Personlighedstest\'';
$string['configusergraphlong'] = 'Brug <a href="http://www.rgraph.net/">Rgraph</a>biblioteket til at vise feedbackskemaer til \'Personlighedstest\'.';
$string['confirmdelallresp'] = 'Er du sikker på, du vil slette ALLE svar i dette spørgeskema?';
$string['confirmdelchildren'] = 'Hvis du sletter dette spørgsmål, vil dets underspørgsmål også blive slette:';
$string['confirmdelgroupresp'] = 'Er du sikker på, at du vil slette ALLE svar fra {$a}?';
$string['confirmdelquestion'] = 'Er du sikker på, du vil slette spørgsmålet på position {$a}?';
$string['confirmdelquestionresps'] = 'Dette vil også slette de(t) {$a} svar, der allerede er afgivet til spørgsmålet.';
$string['confirmdelresp'] = 'Er du sikker på, du vil slette svaret fra&nbsp;{$a}&nbsp;?';
$string['confpage'] = 'Overskrift';
$string['confpage_help'] = 'Overskrift (med fed) og indholdstekst til bekræftelsessiden, som vises efter at en bruger har fuldført spørgeskemaet. (Hvis der er en URL, går den forud for bekræftelsestekst.) Hvis du lader dette felt være tomt, vil en standardtekst blive vist, når spørgeskemaet fuldføres (Tak fordi du udfyldte spørgeskemaet).';
$string['confpagedesc'] = 'Overskrift (med fed) og indholdstekst til &quot;Bekræftelse&quot; siden, som vises efter at en bruger har fuldført spørgeskemaet. (Hvis der er en URL, går den forud for bekræftelsestekst)';
$string['contentoptions'] = 'Indholdsmuligheder';
$string['couldnotcreatenewsurvey'] = 'Kunne ikke oprette en ny spørgeundersøgelse!';
$string['couldnotdelresp'] = 'Kunne ikke slette svar';
$string['createcontent'] = 'Definer nyt indhold';
$string['createcontent_help'] = 'Vælg en af radio-knapmulighederne. \'Opret ny\' er standard.';
$string['createcontent_link'] = 'mod/questionnaire/mod#Content_Options';
$string['createnew'] = 'Opret ny';
$string['crontask'] = 'Oprydning i spørgeskema';
$string['date'] = 'Dato';
$string['date_help'] = 'Brug denne spørgsmålstype, hvis du forventer, at svaret er en korrekt formatteret dato.';
$string['date_link'] = 'mod/questionnaire/questions#Date';
$string['dateformatting'] = 'Brug formatet år-måned-dag, fx 14 marts 1945:&nbsp; <strong>1945-03-04</strong>';
$string['deleteallresponses'] = 'Slet ALLE svar';
$string['deletecurrentquestion'] = 'Slet spørgsmål {$a}';
$string['deletedallgroupresp'] = 'Slet ALLE svar i gruppen {$a}';
$string['deletedallresp'] = 'Svar til spørgeskema slettet';
$string['deletedisabled'] = 'Dette element kan ikke slettes';
$string['deletedresp'] = 'Slettet svar';
$string['deleteresp'] = 'Slet dette svar';
$string['deletingresp'] = 'Sletter svar';
$string['dependquestion'] = 'Hovedspørgsmål';
$string['dependquestion_help'] = 'Du kan vælge et hovedspørgsmål og en valgmulighed til dette svar. Et underspørgsmål vil kun blive vist for den studerende, hvis hovedspørgsmål og valgmulighed tidligere er valgt.';
$string['dependquestion_link'] = 'mod/questionnaire/questions#Parent_Question';
$string['displaymethod'] = 'Visningsmetode ikke defineret for spørgsmål.';
$string['download'] = 'download';
$string['downloadtextformat'] = 'Download';
$string['downloadtextformat_help'] = 'Denne egenskab gør det muligt at gemme alle svar fra et spørgeskema i et frivilligt understøttet filformat.
Du kan vælge at inkludere ekstra data i eksporten, og du kan vælge automatisk at sende filen til udvalgte brugere.';
$string['downloadtextformat_link'] = 'mod/questionnaire/report#Download_in_text_format';
$string['dropdown'] = 'Dropdown-boks';
$string['dropdown_help'] = 'Der er ikke nogen egentlig fordel ved at bruge dropdown-boks frem for radio-knapper, på nær måske til længere lister med valgmuligheder for at spare skærmplads.';
$string['dropdown_link'] = 'mod/questionnaire/questions#Dropdown_Box';
$string['edit'] = 'Rediger';
$string['editingquestionnaire'] = 'Redigerer indstillinger for spørgeskema';
$string['editquestion'] = 'Redigerer {$a} spørgsmål';
$string['email'] = 'E-mail';
$string['errnewname'] = 'Beklager, navnet er allerede i brug. Vælg et andet navn.';
$string['erroropening'] = 'Fejl ved åbning af spørgeskema.';
$string['errortable'] = 'Fejl i systemtabel.';
$string['essaybox'] = 'Tekstboks';
$string['essaybox_help'] = 'Dette spørgsmål vil vise et enkelt tekstfelt (1 linje) med x tekstkolonner (eller områdets bredde) og y tekstrækker (antal tekstlinjer).

Hvis du lader både x og y stå med deres standardværdi på 0 (eller hvis du sætter den til 0), vil Moodles html-editor blive vist med standardhøjde og -bredde (hvis den er tilgængelig i kurset/brugerkonteksten og brugerens profil).';
$string['event_all_responses_deleted'] = 'Alle svar slettet';
$string['event_all_responses_saved_as_text'] = 'Alle svar gemt som tekst';
$string['event_all_responses_viewed'] = 'Rapport med alle svar set';
$string['event_individual_responses_viewed'] = 'Rapport med individuelle svar set';
$string['event_non_respondents_viewed'] = 'Respondenter, der ikke har svaret, set';
$string['event_previewed'] = 'Forhåndsvisning af spørgeskema';
$string['event_question_created'] = 'Spørgsmål oprettet';
$string['event_question_deleted'] = 'Spørgsmål slettet';
$string['event_response_deleted'] = 'Individuelt svar slettet';
$string['event_resumed'] = 'Forsøg genoptaget';
$string['event_saved'] = 'Svar gemt';
$string['event_submitted'] = 'Svar indsendt';
$string['feedback'] = 'Feedback';
$string['feedback_help'] = 'Feedback-hjælp';
$string['feedback_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Messages';
$string['feedbackaddmorefeedbacks'] = 'Tilføj {no} flere feedback-felter';
$string['feedbackbysection'] = 'Feedback på sektioner';
$string['feedbackeditingglobal'] = 'Redigerer overordnet feedback på spørgeskema';
$string['feedbackeditingmessages'] = 'Redigerer spørgeskemaets feedback-beskeder';
$string['feedbackeditingsections'] = 'Redigerer spørgeskemaets feedback-sektioner';
$string['feedbackeditmessages'] = 'Gem sektionsindstillinger og rediger feedback-beskeder';
$string['feedbackeditsections'] = 'Gem indstillinger og rediger feedback-sektioner';
$string['feedbackerrorboundaryformat'] = 'Grænserne for feedback-score skal være enten en procentsats eller et tal. Den værdi, du skrev i grænse {$a} blev ikke genkendt.';
$string['feedbackerrorboundaryoutofrange'] = 'Grænserne for feedback-score skal ligge mellem 0% og 100%. Den værdi, du indtastede i grænse {$a} ligger uden for det tilladte området.';
$string['feedbackerrorjunkinboundary'] = 'Du skal udfylde boksene med feedback-scoregrænser uden at efterlade tomme pladser.';
$string['feedbackerrorjunkinfeedback'] = 'Du skal udfylde feedback-boksene uden at efterlade tomme felter.';
$string['feedbackerrororder'] = 'Grænserne for feedback-score skal stå i rækkefølge med den højeste først. Den værdi, du indtastede i grænse {$a} ligger uden for rækkefølge.';
$string['feedbackglobal'] = 'Overordnet feedback';
$string['feedbackglobalheading'] = 'Overordnet feedback-overskrift';
$string['feedbackglobalmessages'] = 'Overordnet feedback-beskeder';
$string['feedbackhdr'] = 'Feedback';
$string['feedbackheading'] = 'Feedback-overskrift';
$string['feedbackheading_help'] = 'I feedback-overskriftsfeltet kan du bruge 2 variabler: $scoreprocent og $modsatscoreprocent';
$string['feedbackmessages'] = '{$a} sektionsbeskeder';
$string['feedbacknextsection'] = 'Næste sektion {$a}';
$string['feedbacknone'] = 'Ingen feedback-beskeder';
$string['feedbacknotes'] = 'Feedback-noter';
$string['feedbacknotes_help'] = 'Tekst, der bliver skrevet her, vises til respondenterne sidst i deres feedback-rapport';
$string['feedbackoptions'] = 'Feedback-muligheder';
$string['feedbackoptions_help'] = 'Feedback-muligheder er tilgængelige hvis dit spørgeskema indeholder følgende spørgsmålstyper og spørgsmålsindstillinger:
Radioknapper; Rullemenu-bokse; Ja/Nej eller Vurdering (normal eller Osgood-skala). Disse spørgsmål skal sættes som obligatoriske, deres spørgsmålsnavn må IKKE være tomt og svarmulighederne skal indeholde en værdi.';
$string['feedbackoptions_link'] = 'mod/questionnaire/personality_test';
$string['feedbackremovequestionfromsection'] = 'Dette spørgsmål er del af feedback-sektion [{$a}]';
$string['feedbackremovesection'] = 'Hvis du fjerner dette spørgsmål, vil hele feedback-sektion [{$a}] blive fjernet';
$string['feedbackreport'] = 'Feedback-rapport';
$string['feedbackscore'] = 'Feedback-score';
$string['feedbackscoreboundary'] = 'Grænse for feedback-score';
$string['feedbackscores'] = 'Vis scores';
$string['feedbackscores_help'] = 'Vis tabellen med feedback-scores';
$string['feedbacksection'] = 'Sektion';
$string['feedbacksectionheading'] = '{$a} sektionsoverskrift';
$string['feedbacksectionheadingmissing'] = 'Du skal indtaste en overskrift til denne feedback-sektion!';
$string['feedbacksectionheadingtext'] = 'Overskrift';
$string['feedbacksectionlabel'] = 'Etiket';
$string['feedbacksectionlabel_help'] = 'Denne etiket vil blive brugt i kurver/diagrammer. Gør teksten så kort som muligt!';
$string['feedbacksections'] = 'Feedback-sektioner';
$string['feedbacksectionsselect'] = 'Sektioner';
$string['feedbacksectionsselect_help'] = 'Sæt dine spørgsmål ind i disse sektioner';
$string['feedbacksectionsselect_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Sections_2';
$string['feedbacksettingssaved'] = 'Feedback-indstillinger gemt';
$string['feedbacktype'] = 'Feedback-type';
$string['field'] = 'Spørgsmål {$a}';
$string['fieldlength'] = 'Længde på inputboks';
$string['fieldlength_help'] = 'Til spørgsmålstypen **Tekstfelt** (1 linje) skal du skrive **Længde på inputboks** og **Maksimum tekstlængde** på den tekst, der skal skrives af respondenten.

Standardværdierne er 20 anslag for bredden på inputboksen og 25 anslag for maksimumlængden på den tekst, der skrives.';
$string['finished'] = 'Du har besvaret alle spørgsmålene i spørgeskemaet!';
$string['firstrespondent'] = 'Første respondent';
$string['formateditor'] = 'html-editor';
$string['formatplain'] = 'Almindelig tekst';
$string['grade'] = 'Afleveringskarakter';
$string['gradesdeleted'] = 'Karakterer for spørgeskema slettet';
$string['headingtext'] = 'Overskriftstekst';
$string['horizontal'] = 'Vandret';
$string['id'] = 'id';
$string['includechoicecodes'] = 'Inkluder valgkoder';
$string['includechoicetext'] = 'Inkluder valgtekst';
$string['incorrectcourseid'] = 'Kursus-id er ikke korrekt';
$string['incorrectmodule'] = 'Kursusmodul-id var ikke korrekt';
$string['incorrectquestionnaire'] = 'Spørgeskema er ikke korrekt';
$string['invalidresponse'] = 'Ugyldigt svar angivet.';
$string['invalidresponserecord'] = 'Ugyldigt svarpost angivet.';
$string['invalidsurveyid'] = 'Ugyldigt spørgeskema-id.';
$string['kindofratescale'] = 'Skala for vurderingstype';
$string['kindofratescale_help'] = 'Højreklik på Mere hjælp-linket nedenfor.';
$string['kindofratescale_link'] = 'mod/questionnaire/questions#Type_of_rate_scale';
$string['lastrespondent'] = 'Sidste respondent';
$string['length'] = 'Længde';
$string['managequestions'] = 'Administrer spørgsmål';
$string['managequestions_help'] = 'I sektionen \'Administrer spørgsmål\' på siden \'Rediger spørgsmål\' kan du udføre et antal processer på spørgeskemaets spørgsmål.';
$string['managequestions_link'] = 'mod/questionnaire/questions#Manage_questions';
$string['maxdigitsallowed'] = 'Højeste antal tilladte cifre';
$string['maxdigitsallowed_help'] = 'Brug **Max. tilladte cifre** som grænse for antallet af tegn til et numerisk spørgsmål. Bemærk at decimaler også tæller som et tegn.';
$string['maxdigitsallowed_link'] = 'mod/questionnaire/questions#Numeric';
$string['maxforcedresponses'] = 'Højeste antal tvungne svar';
$string['maxtextlength'] = 'Maksimum tekstlængde';
$string['messageprovider:message'] = 'Spørgeskema-påmindelse';
$string['minforcedresponses'] = 'Laveste antal tvungne svar';
$string['minforcedresponses_help'] = 'Brug disse parametre til at tvinge respondenter til at afkrydse mindst **Min.** bokse og højst **Maks.** bokse. For at gennemtvinge afkrydsning af et præcist antal bokse skal du indstille **Min.** og **Maks.** til samme værdi. Hvis du kun ønsker en mindste eller højeste værdi, skal du bare lade den anden værdi stå på standarden **0**. Hvis du indstiller **Min.** eller **Maks.** til andre værdier end standarden **0**, vil der blive vist en advarsel, hvis respondenten ikke følger dine forudsætninger. Du skal naturligvis gøre eventuelle forudsætninger klar for respondenten enten i spørgeskemaets overordnede instruktioner eller i teksten til de berørte spørgsmål.';
$string['misconfigured'] = 'Kurset er fejlkonfigureret';
$string['missingname'] = 'Spørgsmål {$a} kan ikke bruges i denne feedback-sektion, fordi det ikke har noget navn.';
$string['missingnameandrequired'] = 'Spørgsmål {$a} kan ikke bruges i denne feedback-sektion, fordi det ikke har noget navn og det er ikke obligatorisk.';
$string['missingquestion'] = 'Besvar det påkrævede spørgsmål';
$string['missingquestions'] = 'Besvar de påkrævede spørgsmål:';
$string['missingrequired'] = 'Spørgsmål {$a} kan ikke bruges i denne feedback-sektion, fordi det ikke er obligatorisk.';
$string['modulename'] = 'Spørgeskema';
$string['modulename_help'] = 'Spørgeskemamodulet gør det altid muligt at oprette en spørgeundersøgelse med brug af forskellige spørgsmålstyper, med det formål at indsamle data fra brugere.';
$string['modulename_link'] = 'mod/questionnaire/view';
$string['modulenameplural'] = 'Spørgeskemaer';
$string['movedisabled'] = 'Dette element kan ikke flyttes';
$string['myresponses'] = 'Alle dine svar';
$string['myresponsetitle'] = 'Dit/Dine {$a} svar';
$string['myresults'] = 'Dine resultater';
$string['name'] = 'Navn';
$string['navigate'] = 'Tillad forgrenede spørgsmål';
$string['navigate_help'] = 'Tillad underspørgsmål til Ja/Nej-spørgsmål og radio-knapspørgsmål afhængig af deres valg i dit spørgeskema.';
$string['navigate_link'] = 'mod/questionnaire/conditional_branching';
$string['next'] = 'Næste';
$string['nextpage'] = 'Næste side';
$string['nlines'] = '{$a} linjer';
$string['noanswer'] = 'Intet svar';
$string['noattempts'] = 'Der er ingen svar på dette spørgeskema';
$string['nodata'] = 'Ingen data offentliggjort.';
$string['noduplicates'] = 'Ingen kopierede valg';
$string['noduplicateschoiceserror'] = 'Du skal skrive mindst 2 mulige svar til muligheden \'Ingen kopierede valg\'!';
$string['non_respondents'] = 'Brugere, der endnu ikke har indsendt deres svar på dette spørgeskema';
$string['noneinuse'] = 'Dette spørgeskema indeholder ingen svar.';
$string['nopublicsurveys'] = 'Ingen offentlige spørgeskemaer.';
$string['noresponsedata'] = 'Ingen svar på dette spørgsmål.';
$string['noresponses'] = 'Ingen svar';
$string['normal'] = 'Normal';
$string['not_started'] = 'ikke begyndt';
$string['notanumber'] = 'Talformatet <strong>{$a}</strong> accepteres ikke.';
$string['notapplicable'] = 'Ikke anvendelig';
$string['notapplicablecolumn'] = 'Ikke anvendelig-kolonne';
$string['notavail'] = 'Dette spørgeskema er ikke længere tilgængeligt. Bed din underviser slette det.';
$string['noteligible'] = 'Du er ikke kvalificeret til at svare på dette spørgeskema.';
$string['notemplatesurveys'] = 'Ingen skabelon-spørgeskemaer.';
$string['notenoughscaleitems'] = 'Du skal mindst skrive 2 skalaelementer!';
$string['notifications_link'] = 'mod/questionnaire/mod#Submission_Notifications';
$string['notopen'] = 'Dette spørgeskema er ikke åbent før {$a}.';
$string['notrequired'] = 'Der kræves ikke svar';
$string['nousersselected'] = 'Ingen brugere valgt';
$string['num'] = '#';
$string['numattemptsmade'] = '{$a} forsøg på dette spørgeskema';
$string['numberfloat'] = 'det antal, du skrev <strong>{$a->number}</strong> er blevet omformatteret/afrundet med <strong>{$a->precision}</strong> decimalpladser.';
$string['numberofdecimaldigits'] = 'Antal decimalcifre';
$string['numberofdecimaldigits_link'] = 'mod/questionnaire/questions#Numeric';
$string['numberscaleitems'] = 'Antal skalaelementer';
$string['numberscaleitems_help'] = 'Antal skalaelementer er det *antal elementer*, der skal bruges i din vurderingsskala. Man bruges normalt en værdi på 3 til 5. Standardværdi: **5**.';
$string['numeric'] = 'Numerisk';
$string['numeric_help'] = 'Brug denne spørgsmålstype hvis du forventer, at svaret er et korrekt formatteret tal.';
$string['of'] = 'af';
$string['opendate'] = 'Brug startdato';
$string['option'] = 'valgmlighed {$a}';
$string['optionalname'] = 'Spørgsmålsnavn';
$string['optionalname_help'] = 'Spørgsmålsnavnet bruges kun, når du eksporterer svar til CSV/Excel-format.
Hvis du aldrig eksporterer til CSV, behøver du ikke bekymre dig om spørgsmålsnavne.
Hvis du planlægger at eksportere data fra dine spørgeskemaer til CSV jævnligt, har du to valgmuligheder til navngivning af spørgsmål.';
$string['optionalname_link'] = 'mod/questionnaire/questions#Question_Name';
$string['or'] = '- ELLER -';
$string['order_ascending'] = 'Stigende orden';
$string['order_default'] = 'Se standardorden';
$string['order_descending'] = 'Faldende orden';
$string['orderresponses'] = 'Opstil svarene';
$string['orderresponses_help'] = 'Når du viser alle svar, kan du opstille valgmulighederne efter antal svar (Gennemsnit-kolonnen) for følgende 4 spørgsmålstyper.

* radio-knap til enkelt svar
* dropdown-liste til enkelt svar
* flere svarmuligheder (afkrydsningsbokse)
* vurderingsspørgsmål (inklusiv Likert-skalaer).

Når du kommer til siden med alle svar, er de som standard opstillet i den rækkefølge, som den person, der har udarbejdet spørgeskemaet, har skrevet valgmulighederne.
Du kan vælge at opstille dem i stigende eller faldende orden.';
$string['orderresponses_link'] = 'mod/questionnaire/report#Order_Responses';
$string['osgood'] = 'Osgood';
$string['other'] = 'Anden:';
$string['otherempty'] = 'Hvis du markerer dette, skal du skrive noget tekst i tekstfeltet (1 linje)!';
$string['overviewnumresplog'] = 'svar';
$string['overviewnumresplog1'] = 'svar';
$string['overviewnumrespvw'] = 'svar';
$string['overviewnumrespvw1'] = 'svar';
$string['owner'] = 'Ejer';
$string['page'] = 'Side';
$string['pageof'] = 'Side {$a->page} af {$a->totpages}';
$string['participant'] = 'Deltager';
$string['pleasecomplete'] = 'Vær venlig at fuldføre dette valg.';
$string['pluginadministration'] = 'Administration af spørgeskema';
$string['pluginname'] = 'Spørgeskema';
$string['position'] = 'position';
$string['possibleanswers'] = 'Mulige svar';
$string['posteddata'] = 'Nåede siden med offentliggjorte data:';
$string['preview_label'] = 'Forhåndsvisning';
$string['preview_questionnaire'] = 'Forhåndsvisning af spørgeskema';
$string['previewing'] = 'Forhåndsviser spørgeskema';
$string['previous'] = 'Foregående';
$string['previouspage'] = 'Foregående side';
$string['print'] = 'Print dette svar';
$string['printblank'] = 'Print';
$string['printblanktooltip'] = 'Åbner en printvenligt version af et tomt spørgeskemae';
$string['printtooltip'] = 'Åbner en printvenlig version med nuværende svar';
$string['private'] = 'Privat';
$string['public'] = 'Offentlig';
$string['publiccopy'] = 'Kopi:';
$string['publicoriginal'] = 'Original:';
$string['qtype'] = 'Type';
$string['qtype_help'] = 'Vælg om brugerne skal kunne svare en gang, dagligt, ugentligt, månedligt eller et ubegrænset antal gange (mange).';
$string['qtypedaily'] = 'svar dagligt';
$string['qtypemonthly'] = 'svar månedligt';
$string['qtypeonce'] = 'svar en gang';
$string['qtypeunlimited'] = 'svar mange gange';
$string['qtypeweekly'] = 'svar ugentligt';
$string['questionnaire:addinstance'] = 'Tilføj et nyt spørgeskema';
$string['questionnaire:copysurveys'] = 'Kopier skabelon og private spørgeskemaer';
$string['questionnaire:createpublic'] = 'Opret offentlige spørgeskemaer';
$string['questionnaire:createtemplates'] = 'Opret skabelon-spørgeskemaer';
$string['questionnaire:deleteresponses'] = 'Slet eventuelle svar';
$string['questionnaire:downloadresponses'] = 'Download svar i en CSV-fil';
$string['questionnaire:editquestions'] = 'Opret og rediger spørgsmål til spørgeskema';
$string['questionnaire:manage'] = 'Opret og rediger spørgeskemaer';
$string['questionnaire:message'] = 'Send besked til respondenter, der ikke svarer';
$string['questionnaire:preview'] = 'Forhåndsvis spørgeskemaer';
$string['questionnaire:printblank'] = 'Print tomt spørgeskema';
$string['questionnaire:readallresponseanytime'] = 'Læs alle svar når som helst';
$string['questionnaire:readallresponses'] = 'Læs resumé af svar, afhængig af hvornår de er åbne';
$string['questionnaire:readownresponses'] = 'Læs egne svar';
$string['questionnaire:submit'] = 'Fuldfør og indsend et spørgeskema';
$string['questionnaire:view'] = 'Se et spørgeskema';
$string['questionnaire:viewsingleresponse'] = 'Se fuldstændige individuelle svar';
$string['questionnaireadministration'] = 'Spørgeskema-administration';
$string['questionnairecloses'] = 'Spørgeskema lukker';
$string['questionnaireopens'] = 'Spørgeskema åbner';
$string['questionnairereport'] = 'Spørgeskema-rapport';
$string['questionnum'] = 'spørgsmål #';
$string['questions'] = 'Spørgsmål';
$string['questionsinsection'] = 'Spørgsmål i denne sektion:';
$string['questiontypes'] = 'Spørgsmålstyper';
$string['questiontypes_help'] = 'Se Moodle-dokumentation nedenfor';
$string['questiontypes_link'] = 'mod/questionnaire/questions#Question_Types';
$string['radiobuttons'] = 'Radio-knapper';
$string['radiobuttons_help'] = 'I denne spørgsmålstype skal respondenten vælge en af de tilbudte muligheder.';
$string['radiobuttons_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['rank'] = 'Rang';
$string['ratescale'] = 'Bedøm (skala 1..5)';
$string['ratescale_help'] = 'Se Moodle-dokumentation nedenfor';
$string['ratescale_link'] = 'mod/questionnaire/questions#Rate_.28scale_1..5.29';
$string['realm'] = 'Spørgeskema-type';
$string['realm_help'] = '* **Det er tre typer spørgeskemaer:**
* Privat - tilhører kun det kursus det er defineret i.
* Skabelon - kan kopieres og redigeres.
* Offentligt - kan deles mellem flere kurser.';
$string['realm_link'] = 'mod/questionnaire/qsettings#Questionnaire_Type';
$string['redirecturl'] = 'Den url, en bruger sendes retur til efter at have udfyldt dette spørgeskema.';
$string['remove'] = 'Slet';
$string['removeallquestionnaireattempts'] = 'Slet alle spørgeskema-svar';
$string['removenotinuse'] = 'Dette spørgeskema har tidligere været afhængigt af et offentligt spørgeskema, som er blevet slettet. Det kan ikke længere bruges og skal slettes.';
$string['required'] = 'Svar påkrævet';
$string['required_help'] = 'Hvis du vælger ***Ja***, vil der blive krævet svar på dette spørgsmål, dvs. at respondenten ikke kan indsende spørgeskemaet., før spørgsmålet er besvaret.';
$string['required_link'] = 'mod/questionnaire/questions#Response_Required';
$string['requiredparameter'] = 'Et påkrævet parameter manglede.';
$string['reset'] = 'Nulstil';
$string['respeligiblerepl'] = '(erstattet af rolle-underkendelser)';
$string['respondent'] = 'Respondent';
$string['respondenteligibleall'] = 'alle';
$string['respondenteligiblestudents'] = 'kun studerende';
$string['respondenteligibleteachers'] = 'kun lærere';
$string['respondents'] = 'Respondenter';
$string['respondenttype'] = 'Respondent-type';
$string['respondenttype_help'] = 'Du kan vise dine brugeres fulde navne ved hvert svar ved at indstille dette til \'fulde navn\'.
Du kan skjule dine brugeres identiteter fra svarene ved at indstille dette til \'anonym\'.';
$string['respondenttype_link'] = 'mod/questionnaire/mod#Respondent_Type';
$string['respondenttypeanonymous'] = 'anonym';
$string['respondenttypefullname'] = 'fulde navn';
$string['response'] = 'Svar';
$string['responsefieldlines'] = 'Input-boks størrelse';
$string['responseformat'] = 'Svar-format';
$string['responseoptions'] = 'Svar-muligheder';
$string['responses'] = 'Svar';
$string['responseview'] = 'Studerende kan se ALLE svar';
$string['responseview_help'] = 'Du kan specificere, hvem der kan se svarene fra alle respondenter på indsendte spørgeskemaer (generelle statistiktabeller).';
$string['responseview_link'] = 'mod/questionnaire/mod#Response_viewing';
$string['responseviewstudentsalways'] = 'Altid';
$string['responseviewstudentsnever'] = 'Aldrig';
$string['responseviewstudentswhenanswered'] = 'Efter at have besvaret spørgeskemaet';
$string['responseviewstudentswhenclosed'] = 'Efter at spørgeskemaet er lukket';
$string['restrictedtoteacher'] = 'Disse funktioner kan kun bruges af lærere, der kan redigere!';
$string['resume'] = 'Gem/Genoptag svar';
$string['resume_help'] = 'Når du vælger denne indstilling, kan brugere gemme deres svar på spørgeskemaet, inden de indsender dem.
Brugere kan forlade spørgeskemaet ufærdigt og på et senere tidspunkt genoptage det fra det sted, de er nået til.';
$string['resume_link'] = 'mod/questionnaire/mod#Save/Resume_answers';
$string['resumesurvey'] = 'Genoptag spørgeskema';
$string['return'] = 'Vend tilbage';
$string['save'] = 'Gem';
$string['saveasnew'] = 'Gem som nyt spørgsmål';
$string['savedbutnotsubmitted'] = 'Dette spørgeskema er gemt, men endnu ikke indsendt.';
$string['savedprogress'] = 'Dine svar er gemt. Du kan når som helst vende tilbage og færdiggøre spørgeskemaet.';
$string['saveeditedquestion'] = 'Gem spørgsmål {$a}';
$string['savesettings'] = 'Gem indstillinger';
$string['section'] = 'Beskrivelse';
$string['sectionbreak'] = '----- Ny side -----';
$string['sectionbreak_help'] = '----- Ny side -----';
$string['sectionsnotset'] = 'Du skal vælge mindst ET spørgsmål pr. sektion!<br />Sektioner ikke valgt: {$a}';
$string['sectiontext'] = 'Etiket';
$string['sectiontext_help'] = 'Dette er ikke et spørgsmål men en (kort) tekst, der vil blive vist for at introducere en serie af spørgsmål.';
$string['selecttheme'] = 'Vælg et tema (CSS), der skal bruges i dette spørgeskema.';
$string['send'] = 'Send';
$string['send_message'] = 'Send besked til valgte brugere';
$string['send_message_to'] = 'Send besked til:';
$string['sendemail'] = 'Send e-mail';
$string['sendemail_help'] = 'Sender en kopi af hver aflevering til de(n) angivne adresse(r). Du kan angive mere end en adresse ved at adskille dem med kommaer. Efterlad et tomt felt hvis ikke du vil have backup til e-mail. Kræver at "allowemailreporting" er aktiveret i modulindstillingerne.';
$string['settings'] = 'Indstillinger';
$string['settingssaved'] = 'Indstillinger gemt';
$string['show_nonrespondents'] = 'Ikke-respondenter';
$string['started'] = 'begyndt';
$string['strfdate'] = '%d/%m/%å';
$string['strfdateformatcsv'] = 'd/m/å T:m:s';
$string['subject'] = 'Emne';
$string['submitoptions'] = 'Afleveringsvalgmuligheder';
$string['submitpreview'] = 'Indsend forhåndsvisning';
$string['submitpreviewcorrect'] = 'Denne aflevering ville blive accepteret som korrekt udfyldt.';
$string['submitsurvey'] = 'Indsend spørgeskema';
$string['submitted'] = 'Indsendt d.:';
$string['subtitle'] = 'Undertitel';
$string['subtitle_help'] = 'Dette spørgeskemas undertitel. Vises kun under titlen på første side.';
$string['summary'] = 'Resumé';
$string['surveynotexists'] = 'spørgeskema findes ikke.';
$string['surveyowner'] = 'Du skal være ejer af spørgeskemaet for at kunne udføre denne handling.';
$string['surveyresponse'] = 'Svar fra spørgeskema';
$string['template'] = 'Skabelon';
$string['templatenotviewable'] = 'Skabelon-spørgeskemaer kan ikke vises.';
$string['text'] = 'Spørgsmålstekst';
$string['textareacolumns'] = 'Tekstområde-kolonner';
$string['textareacolumns_help'] = 'Dette spørgsmål vil bestå af et tekstfelt (1 linje) med **x** *Tekstområde-kolonner* (eller område *bredde*) og **y** *Tekstområde-rækker* (antal tekst *linjer*).
Hvis du lader både x og y stå med deres standardværdi på **0** (eller hvis du sætter den til **0**), vil html-editoren blive vist med standardhøjde og -bredde (hvis den er tilgængelig i kursets/brugerkontekstens brugerprofil).';
$string['textarearows'] = 'Tekstområde-rækker';
$string['textbox'] = 'Tekstfelt (1 linje)';
$string['textbox_help'] = 'Til spørgsmålstypen \'Tekstfelt\' (1 linje) skal du skrive længden på input-boksen og den maksimale tekstlængde, der kan skrives af respondenten.
Standardværdier er 20 anslag for input-boksens bredde og 25 anslag for maksimumlængden på den tekst, der skrives ind.';
$string['textdownloadoptions'] = 'Valgmuligheder for csv-download';
$string['thank_head'] = 'Tak fordi du udfyldte dette spørgeskema';
$string['theme'] = 'Tema';
$string['thismonth'] = 'denne måned';
$string['thisresponse'] = 'Dette svar';
$string['thisweek'] = 'denne uge';
$string['title'] = 'Titel';
$string['title_help'] = 'Titlen på dette spørgeskema, som vil stå øverst på hver side. Som standard er titlen indstillet til at være spørgeskemaets navn, men du kan redigere det, som du vil.';
$string['today'] = 'i dag';
$string['total'] = 'Total';
$string['type'] = 'Spørgsmålstype';
$string['undefinedquestiontype'] = 'Udefineret spørgsmålstype';
$string['unknown'] = 'Ukendt';
$string['unknownaction'] = 'Ukendt spørgeskema-handling specificeret ...';
$string['url'] = 'Bekræftelses-url';
$string['url_help'] = 'Den url, som brugeren returneres til efter at have udfyldt spørgeskemaet.';
$string['useprivate'] = 'Der findes en kopi';
$string['usepublic'] = 'Brug offentlig';
$string['usetemplate'] = 'Brug skabelon';
$string['vertical'] = 'Lodret';
$string['view'] = 'Se';
$string['viewallresponses'] = 'Se alle svar';
$string['viewallresponses_help'] = 'Hvis spørgeskemaet er indstillet til **Gruppe-tilstand**: *Synlige grupper* eller er indstillet til *Adskilte grupper* og den nuværende bruger har beføjelsen *moodle/site:accessallgroups* (i den nuværende kontekst), og grupper er defineret i det nuværende kursus, har brugeren adgang til en rullemenu med grupper. Denne rullemenu gør det muligt for brugeren at filtrere spørgeskemaets svar efter grupper.
Hvis indstillingen er **Gruppe-tilstand**: *Adskilte grupper*, kan brugere som ikke har beføjelsen *moodle/site:accessallgroups* (som regel studerende eller medundervisere, der ikke kan redigere osv.), kun se svar fra de(n) gruppe(r), de er medlem af.';
$string['viewallresponses_link'] = 'Viewing_Questionnaire_responses#Group_filtering';
$string['viewbyresponse'] = 'Liste med svar';
$string['viewindividualresponse'] = 'Individuelle svar';
$string['viewindividualresponse_help'] = 'Klik på respondenternes navne i listen nedenfor for at se deres individuelle svar.';
$string['viewresponses'] = 'Alle svar ({$a})';
$string['viewyourresponses'] = 'Din svar-visning {$a}';
$string['warning'] = 'Advarsel, der blev fundet en fejl.';
$string['wronganswers'] = 'Der er noget galt med dine svar (se nedenfor)';
$string['wrongdateformat'] = 'Den indtastede dato: <strong>{$a}</strong> svarer ikke til det format, der er vist i eksemplet.';
$string['wrongdaterange'] = 'FEJL! Årstallet skal ligge i intervallet 1902 til 2037.';
$string['wrongformat'] = 'Der r noget galt med dit svar på spørgsmål:&nbsp;';
$string['wrongformats'] = 'Der er noget galt med dine svar på spørgsmålene:&nbsp;';
$string['yesno'] = 'Ja/Nej';
$string['yesno_help'] = 'Simpelt Ja/Nej-spørgsmål';
$string['yourresponse'] = 'Dit svar';
$string['yourresponses'] = 'Dine svar';
