<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'offlinequiz', language 'ru', version '4.0'.
 *
 * @package     offlinequiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add'] = 'Добавить';
$string['addarandomquestion'] = 'Случайные вопросы';
$string['addarandomquestion_help'] = 'Moodle добавляет случайный выбор вопросов с несколькими вариантами ответов (или вопросов с несколькими вариантами ответов «все или ничего») в текущую группу автономных тестов. Количество добавляемых вопросов может быть задано. Вопросы выбираются из текущей категории вопросов (и, если она выбрана, из ее подкатегорий).';
$string['addarandomselectedquestion'] = 'Добавить случайный вопрос...';
$string['addlist'] = 'Добавить список';
$string['addnewpagesafterselected'] = 'Добавить разделители страниц после выбранных вопросов';
$string['addnewquestion'] = 'Новый вопрос';
$string['addnewquestionsqbank'] = 'Добавить вопросы в категорию {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Добавить переопределение пользователя';
$string['addpagebreak'] = 'Добавить разрыв страницы';
$string['addpagehere'] = 'Добавить страницу здесь';
$string['addparts'] = 'Добавить участников';
$string['addquestionfrombankatend'] = 'Добавить из банка вопросов в конце';
$string['addquestionfrombanktopage'] = 'Добавить из банка вопросов на страницу {$a}';
$string['addrandom'] = 'Добавить случайным образом {$a} вопросов с множественным выбором';
$string['addrandomfromcategory'] = 'Случайные вопросы';
$string['addrandomquestion'] = 'Случайные вопросы';
$string['addrandomquestiontoofflinequiz'] = 'Добавить вопросы в автономный тест {$a-> name} (группа {$a->group})';
$string['addrandomquestiontopage'] = 'Добавить случайный вопрос на страницу {$a}';
$string['addtoofflinequiz'] = 'Добавить в офлайн-тест';
$string['addtoqueue'] = 'Добавить в очередь';
$string['allinone'] = 'Без ограничения';
$string['alllists'] = 'Все списки';
$string['allornothing'] = 'Все или ничего';
$string['allresults'] = 'Показать все результаты';
$string['allstudents'] = 'Показать всех студентов';
$string['alwaysavailable'] = 'Всегда доступно';
$string['analysis'] = 'Анализ вопроса';
$string['answerform'] = 'Форма для ответов';
$string['answerformforgroup'] = 'Ответ для группы  {$a}';
$string['answerforms'] = 'Формы ответов';
$string['answerpdfxy'] = 'Форма для ответов ({$a}->maxquestions questions / {$a}->maxanswers options)';
$string['areyousureremoveselected'] = 'Вы уверены, что хотите удалить все выбранные вопросы?';
$string['attemptexists'] = 'Попытка существует';
$string['attemptsexist'] = 'Вы не можете больше добавлять или убирать вопросы';
$string['attemptsnum'] = 'Результаты: {$a}';
$string['attemptsonly'] = 'Показать только студентов с результатами';
$string['attendances'] = 'Посещаемость';
$string['basicideasofofflinequiz'] = 'Основные идеи автономного теста';
$string['blackwhitethreshold'] = 'Порог черного/белого';
$string['bulksavegrades'] = 'Сохранить оценки';
$string['calibratescanner'] = 'Калибровка сканера';
$string['cannoteditafterattempts'] = 'Вы не можете добавлять или убирать вопросы, потому что уже есть завершенные результаты ({$a})';
$string['category'] = 'Категория';
$string['changed'] = 'Результаты были изменены';
$string['changeevaluationmode'] = 'Измените способ проведения оценки. Возможно только если это разрешено администратором.';
$string['checkparts'] = 'Отметить выбранных участников как присутствующих';
$string['checkuserid'] = 'Проверьте ID группы/пользователя';
$string['chooseagroup'] = 'Выберите группу...';
$string['closebeforeopen'] = 'Не удалось обновить автономный тест. Вы указали дату закрытия раньше даты открытия.';
$string['closestudentview'] = 'Закрыть просмотр студента';
$string['closewindow'] = 'Закрыть окно';
$string['cmmissing'] = 'Модуль курса для автономного теста с ID {$a} отсутствует';
$string['configblackwhitethreshold'] = 'Устанавливает порог между 1-99 для преобразования черного-белого - чем выше значение, тем больше белого должен содержать импортированный пиксель для распознавания как белый. Любое другое значение не приводит к преобразованию черного/белого вообще.';
$string['configdecimalplaces'] = 'Количество цифр после запятой при отображении оценок за офлайн-тест';
$string['configdisableimgnewlines'] = 'Эта опция отключает новые строки до и после изображений в листах вопросов PDF. Предупреждение: это может привести к проблемам с форматированием.';
$string['configexperimentalevaluation'] = 'Экспериментальная оценка листов ответов';
$string['configexperimentalevaluationdesc'] = 'НЕ ИСПОЛЬЗУЙТЕ В ПРОИЗВОДСТВЕ! Эта опция используется для альфа-тестирования алгоритма оценки. Если для этого параметра установлено значение «Да», его можно включить в параметрах экземпляра автономного теста. Мы настоятельно не рекомендуем использовать эту опцию. Отсутствует возможность восстановления потерянных данных из-за включения этой опции.';
$string['configintro'] = 'Установленные здесь значения используются в качестве значений по умолчанию для параметров новых автономных тестов.';
$string['configkeepfilesfordays'] = 'Определите, сколько дней загруженные файлы изображений будут храниться. В течение этого времени файлы изображений будут доступны в отчете администратора офлайн-теста.';
$string['configonlylocalcategories'] = 'Общие категории вопросов не допускаются.';
$string['configpapergray'] = 'белый - значение для бумаги, которая используется для оценки листов с ответами';
$string['configshuffleanswers'] = 'Перемешать ответы';
$string['configshufflequestions'] = 'Если вы включите эту опцию, то порядок вопросов в группах автономных тестов  будет случайным образом перемешиваться при каждом повторном создании предварительного просмотра на вкладке «Создание форм».';
$string['configshufflewithin'] = 'Если вы включите эту опцию, то части, составляющие отдельные вопросы, будут случайным образом перемешиваться при создании форм вопросов и ответов.';
$string['configuseridentification'] = 'Формула, описывающая идентификацию пользователя. Эта формула используется для назначения форм ответов пользователям в системе. Правая часть уравнения должна обозначать поле в таблице пользователя Moodle.';
$string['confirmremovequestion'] = 'Вы уверены, что хотите удалить этот вопрос {$a}?';
$string['copy'] = 'Копировать';
$string['copyright'] = '<strong>Предупреждение. Текст на этой странице является вашей личной информацией. Эти вопросы защищены авторским правом. Вам запрещено копировать их или показывать другим людям!</strong>';
$string['copyselectedtogroup'] = 'Добавить выбранные вопросы в группу: {$a}';
$string['copytogroup'] = 'Добавить все вопросы в группу: {$a}';
$string['correct'] = 'верно';
$string['correcterror'] = 'решено';
$string['correctforgroup'] = 'Правильные ответы для группы {$a}';
$string['correctionform'] = 'Правка';
$string['correctionforms'] = 'Формы правки';
$string['correctionoptionsheading'] = 'Параметры правки';
$string['correctupdated'] = 'Обновленная правильная форма для группы {$a}.';
$string['couldnotgrab'] = 'Не удается получить изображение {$a}';
$string['couldnotregister'] = 'Не удается зарегистрировать пользователя {$a}';
$string['createcategoryandaddrandomquestion'] = 'Создать категорию и добавить случайный вопрос';
$string['createlistfirst'] = 'Добавить участников';
$string['createofflinequiz'] = 'Создать формы';
$string['createpartpdferror'] = 'PDF-формы со списком участников {$a} не может быть создан. Вероятно, он пуст.';
$string['createpdf'] = 'PDF-форма';
$string['createpdferror'] = 'Форма для группы {$a} не может быть создана. Вероятно, нет вопрсоов в группе.';
$string['createpdffirst'] = 'Создать сначала PDF-список';
$string['createpdfforms'] = 'Создать формы';
$string['createpdfs'] = 'Скачать формы';
$string['createpdfsparticipants'] = 'PDF-формы для списка участников';
$string['createquestionandadd'] = 'Создать новый вопрос и добавить в тест';
$string['createquiz'] = 'Создать формы';
$string['csvfile'] = 'CSV-файл';
$string['csvformat'] = 'Текстовый файл с разделителями запятыми (CSV)';
$string['csvplus1format'] = 'Текстовый файл с необработанными данными (CSV)';
$string['csvpluspointsformat'] = 'Текстовый файл с точками (CSV)';
$string['darkgray'] = 'Темно-серый';
$string['datanotsaved'] = 'Не удается сохранить настройки';
$string['decimalplaces'] = 'Разрядность';
$string['decimalplaces_help'] = 'Число знаков после запятой при отображении оценок за офлайн-тест';
$string['deletelistcheck'] = 'Вы действительно хотите удалить выбранные списки и всех их участников?';
$string['deletepagecheck'] = 'Вы действительно хотите удалять выбранные страницы?';
$string['deletepagesafterselected'] = 'Убрать разделители страниц после выбранных вопросов';
$string['deletepartcheck'] = 'Вы действительно хотите удалить выбранных участников?';
$string['deleteparticipantslist'] = 'Удалить список участников';
$string['deletepdfs'] = 'Удалить документы';
$string['deleteresultcheck'] = 'Вы действительно хотите удалить выбранные результаты?';
$string['deleteselectedpart'] = 'Удалить выбранных участников';
$string['deleteselectedresults'] = 'Удалить выбранные результаты';
$string['deletethislist'] = 'Удалить этот список';
$string['deleteupdatepdf'] = 'Удалить и обновить PDF-формы';
$string['difficultytitle'] = 'Сложность';
$string['difficultytitlea'] = 'Сложность A';
$string['difficultytitleb'] = 'Сложность B';
$string['difficultytitlediff'] = 'Различия';
$string['disableimgnewlines'] = 'Отключить новые строки до и после изображений';
$string['disableimgnewlines_help'] = 'Эта опция отключает новые строки до и после изображений в листах вопросов PDF. Предупреждение: это может привести к проблемам с форматированием.';
$string['displayoptions'] = 'Параметры отображения';
$string['done'] = 'готово';
$string['downloadallzip'] = 'Скачать все файлы в архиве ZIP';
$string['downloadpartpdf'] = 'Скачать PDF-файл для списка {$a}';
$string['downloadpdfs'] = 'Скачать документы';
$string['downloadresultsas'] = 'Скачать результаты в:';
$string['dragtoafter'] = 'После {$a}';
$string['dragtostart'] = 'К началу';
$string['editgroupquestions'] = 'Редактировать вопросы группы';
$string['editgroups'] = 'Редактировать офлайн-группы';
$string['editingofflinequiz'] = 'Редактирование группы вопросов';
$string['editingofflinequiz_help'] = 'При создании автономных тестов основными концепциями являются:
<ul><li>Автономный тест, содержащий вопросы на одной или нескольких страницах</li>
<li> Банк вопросов, в котором хранятся копии всех вопросов, организованных по категориям </li></ul>';
$string['editingofflinequizx'] = 'Редактировать автономный тест: {$a}';
$string['editlist'] = 'Редактировать список';
$string['editlists'] = 'Редактировать списки';
$string['editmaxmark'] = 'Изменить максимальную оценку';
$string['editofflinequiz'] = 'Редактировать офлайн-тест';
$string['editofflinesettings'] = 'Редактировать автономные настройки';
$string['editorder'] = 'Редактировать последовательность';
$string['editparticipants'] = 'Редактировать участников';
$string['editquestion'] = 'Редактировать вопрос';
$string['editquestions'] = 'Редактировать вопросы';
$string['editscannedform'] = 'Редактировать сканируемую форму';
$string['editthislist'] = 'Редактировать список';
$string['emptygroups'] = 'Некоторые группы офлайн-теста пусты. Пожалуйста, добавьте туда вопросы.';
$string['enroluser'] = 'Записать пользователя';
$string['erroraccessingreport'] = 'Вам не разрешено смотреть этот отчет';
$string['errorreport'] = 'Отчет об ошибках импорта';
$string['eventattemptdeleted'] = 'Попытка офлайн-теста удалена';
$string['eventattemptpreviewstarted'] = 'Начат просмотр попытки офлайн-теста';
$string['eventattemptreviewed'] = 'Пересмотрена попытка офлайн-теста';
$string['eventattemptsummaryviewed'] = 'Просмотрена сводка по попытке офлайн-теста';
$string['eventattemptviewed'] = 'Просмотрена попытка офлайн-теста';
$string['eventdocscreated'] = 'Созданы формы вопроса и ответа для офлайн-теста';
$string['eventdocsdeleted'] = 'Удалены формы вопроса и ответа для офлайн-теста';
$string['eventeditpageviewed'] = 'Просмотрена страница редактирования офлайн-теста';
$string['eventofflinequizattemptsubmitted'] = 'Отправлена попытка офлайн-теста';
$string['eventoverridecreated'] = 'Переопределение автономного теста создано';
$string['eventoverridedeleted'] = 'Переопределение автономного теста удалено';
$string['eventoverrideupdated'] = 'Переопределения автономного теста обновлено';
$string['eventparticipantmarked'] = 'Участник офлайн-теста отмечен вручную';
$string['eventquestionmanuallygraded'] = 'Вопрос оценен вручную';
$string['eventreportviewed'] = 'Просмотрен отчет офлайн-теста';
$string['eventresultsregraded'] = 'Переоценены результаты офлайн-теста';
$string['everythingon'] = 'активировано';
$string['excelformat'] = 'Электронная таблица Excel (XLSX)';
$string['experimentalevaluation'] = 'Экспериментальная оценка листов ответов';
$string['experimentalevaluation_help'] = 'Экспериментальная оценка листов ответов';
$string['fileformat'] = 'Формат листов с вопросами';
$string['fileformat_help'] = 'Выберите, хотите ли вы, чтобы ваши вопросы были в формате PDF, DOCX или TEX. Формы ответов и листы с иправлениями всегда будут создаваться в формате PDF.';
$string['fileprefixanswer'] = 'форма_ответа';
$string['fileprefixcorrection'] = 'правильная_форма';
$string['fileprefixform'] = 'форма_вопроса';
$string['fileprefixparticipants'] = 'список_участников';
$string['filesizetolarge'] = 'Некоторые из ваших файлов изображений очень большие. Размеры будут изменены во время перекодирования. Пожалуйста, попробуйте сканировать с разрешением от 200 до 300 точек на дюйм и в черно-белом режиме. Это ускорит перекодирование в следующий раз.';
$string['filterbytags'] = 'Фильтр по тегам...';
$string['fontsize'] = 'Размер шрифта';
$string['forautoanalysis'] = 'Для автоматического анализа';
$string['formforcorrection'] = 'Правильные ответы для группы {$a}';
$string['formforgroup'] = 'Форма вопросов для группы {$a}';
$string['formforgroupdocx'] = 'Форма вопросов для группы {$a} (DOCX)';
$string['formforgrouplatex'] = 'Форма вопросов для группы {$a} (LATEX)';
$string['formsexist'] = 'Формы уже созданы';
$string['formsexistx'] = 'Формы уже созданы (<a href="{$a}">Скачать формы</a>)';
$string['formsheetsettings'] = 'Настройки формы';
$string['formspreview'] = 'Предпросмотр для форм';
$string['formwarning'] = 'Форма ответа не определена. Пожалуйста, свяжитесь с вашим администратором.';
$string['fromquestionbank'] = 'из банка вопросов';
$string['functiondisabledbysecuremode'] = 'Эта функция в настоящее время отключена';
$string['generalfeedback'] = 'Основной отзыв';
$string['generalfeedback_help'] = 'Общий отзыв - это текст, который отображается после попытки ответа на вопрос. В отличие от отзыва по конкретному вопросу, который зависит от полученного ответа,  общий отзыв всегда одинаков.';
$string['generatepdfform'] = 'Сгенерировать PDF-форму';
$string['grade'] = 'Оценка';
$string['gradedon'] = 'Оценено';
$string['gradedscannedform'] = 'Отсканированная форма с оценками';
$string['gradeiszero'] = 'Примечание: Максимальная оценка за этот офлайн-тест 0 баллов!';
$string['gradeswarning'] = 'Оценки для вопросов должны быть числовыми';
$string['gradewarning'] = 'Оценка за вопрос должна быть числовой';
$string['gradingofflinequiz'] = 'Оценки';
$string['gradingofflinequizx'] = 'Оценки: {$a}';
$string['gradingoptionsheading'] = 'Опции оценки.';
$string['greeniscross'] = 'засчитано как крестик';
$string['group'] = 'Группа';
$string['groupoutofrange'] = 'Группа была вне диапазона и заменена группой А.';
$string['hasresult'] = 'Результат существует';
$string['hotspotdeletiontask'] = 'Удаление точки доступа';
$string['html'] = 'HTML';
$string['idnumber'] = 'Идентификационный номер';
$string['imagefile'] = 'Файл изображения';
$string['imagenotfound'] = 'Файл изображения {$a} не найден';
$string['imagenotjpg'] = 'Изображение не соответствует формату JPG или PNG: {$a}';
$string['imagickwarning'] = 'Отсутствует imagemagick: попросите системного администратора установить библиотеку imagemagick и проверьте путь к преобразованному двоичному файлу в настройках фильтра нотации TeX. Вы не можете импортировать файлы TIF без imagemagick!';
$string['import'] = 'Импортировать';
$string['importedon'] = 'Импортировано';
$string['importerror11'] = 'Существует другой результат';
$string['importerror12'] = 'Пользователь не зарегистрирован';
$string['importerror13'] = 'Нет информации о группе';
$string['importerror14'] = 'Не удалось получить';
$string['importerror15'] = 'Ненадежная маркировка';
$string['importerror16'] = 'Ошибка страницы';
$string['importerror17'] = 'Незавершенные страницы';
$string['importerror21'] = 'Не удалось получить';
$string['importerror22'] = 'Ненадежная маркировка';
$string['importerror23'] = 'Пользователя нет в списке';
$string['importerror24'] = 'Список не обнаружен';
$string['importforms'] = 'Импортировать формы ответа';
$string['importfromto'] = 'Импортирование из {$a->from} в {$a->to}, всего {$a->total}.';
$string['importisfinished'] = 'Импортирование офлайн-теста {$a} завершено';
$string['importlinkresults'] = 'Ссылка на результаты: {$a}';
$string['importlinkverify'] = 'Ссылка для удостоверения: {$a}';
$string['importmailsubject'] = 'Уведомление об импорте офлайн-теста';
$string['importnew'] = 'Импорт';
$string['importnew_help'] = '<p>
В ZIP-архив можно импортировать как отдельные файлы отсканированных изображений, так и несколько файлов отсканированных изображений. Модуль «Автономный тест» будет обрабатывать файлы изображений в фоновом режиме.
Имена файлов не должны содержать специальных символов, таких как умлаут. Изображения должны быть GIF, PNG или ТIF. Рекомендуется разрешение от 200 до 300pi.</p>';
$string['importnumberexisting'] = 'Количество повторных форм: {$a}';
$string['importnumberpages'] = 'Количество успешно импортированных страниц: {$a}';
$string['importnumberresults'] = 'Количество импортированных: {$a}';
$string['importnumberverify'] = 'Количество форм, требующих удостоверения: {$a}';
$string['importtimefinish'] = 'Процесс завершен: {$a}';
$string['importtimestart'] = 'Процесс начат: {$a}';
$string['inconsistentdata'] = 'Противоречивые данные: {$a}';
$string['info'] = 'Информация';
$string['infoshort'] = 'i';
$string['insecuremarkings'] = 'Ненадежные отметки требуют ручной корректировки';
$string['insecuremarkingsforquestion'] = 'Ненадежные отметки требуют ручной корректировки для вопроса';
$string['insertnumber'] = 'Пожалуйста, вставьте верный идентификационный номер, помеченный голубой рамкой';
$string['instruction1'] = 'Данная форма ответов будет отсканирована автоматически. Пожалуйста, не складывайте и не пачкайте ее. Используйте синюю или черную ручку для ответов:';
$string['instruction2'] = 'Только четкие отметки будут оценены корректно. Если вам требуется исправление, закрасьте место для ответа и поле будет считаться пустым:';
$string['instruction3'] = 'Исправленные ответы не могут быть помечены снова. Пожалуйста, не пишите ничего за пределами специальных мест для ответов.';
$string['introduction'] = 'Введение';
$string['invalidformula'] = 'Неверная формула для идентификации пользователя. Формула должна иметь вид <prefix>[<#digits>]<suffix>=<db-field&>.';
$string['invalidnumberofdigits'] = 'Недопустимое количество используемых цифр. Допускается только в количестве от 1 до 9.';
$string['invaliduserfield'] = 'Используется недопустимое поле пользовательской таблицы.';
$string['invigilator'] = 'Экзаменатор';
$string['ischecked'] = 'Участие отмечено';
$string['isnotchecked'] = 'Участие не отмечено';
$string['itemdata'] = 'Itemdata';
$string['keepfilesfordays'] = 'Хранить файл (дней)';
$string['lightgray'] = 'Светло-серый';
$string['linktoscannedform'] = 'Просмотреть отсканированную форму';
$string['listnotdetected'] = 'Не удается определить штрих-код для списка';
$string['logdeleted'] = 'Запись журнала {$a} удалена.';
$string['logourl'] = 'URL логотипа';
$string['lowertrigger'] = 'Ниже второй границы';
$string['lowertriggerzero'] = 'Нижняя вторая граница равна нулю';
$string['lowerwarning'] = 'Ниже первой границы';
$string['lowerwarningzero'] = 'Первая нижняя граница равна нулю';
$string['marginwarning'] = 'Пожалуйста, распечатайте следующие PDF-файлы без дополнительных полей!<br /> Не допускайте раздачи ксерокопий студентам. Если у вас есть какие-либо сомнения, закажите копии в службе поддержки.';
$string['marks'] = 'Отметки';
$string['matrikel'] = 'Номер студента';
$string['maxgradewarning'] = 'Максимальная оценка должна быть числом';
$string['maxmark'] = 'Максимальный балл';
$string['membersinplist'] = '{$a->count} участников в <a href="{$a->url}">{$a->name}</a>';
$string['missingimagefile'] = 'Отсутствует файл изображения';
$string['missingitemdata'] = 'Отсутствуют ответы для пользователя {$a}';
$string['missinglogdata'] = 'Отсутствуют записи журнала для существующего результата';
$string['missingquestion'] = 'Данный вопрос больше не существует';
$string['missinguserid'] = 'Отсутствует идентификационный номер пользователя. Не удается прочитать штрих-код.';
$string['modulename'] = 'Офлайн-тест';
$string['modulename_help'] = 'Этот модуль позволяет учителю разрабатывать автономные тесты, состоящие из вопросов с множественным выбором.
Эти вопросы хранятся в банке вопросов Moodle и могут быть повторно использованы в рамках курсов и даже между курсами.
Автономные тесты можно загрузить в виде PDF -, DOCX- или LaTeX-файлов. Студенты отмечают свои ответы на бланках формуляров. Листы форм сканируются, а ответы импортируются в систему.';
$string['modulenameplural'] = 'Офлайн-тесты';
$string['moodleprocessing'] = 'Позволить Moodle обрабатывать данные';
$string['movecorners'] = 'Измените расположение угловых маркеров, используя перетаскивание';
$string['moveselectedonpage'] = 'Переместить выбранные вопросы на страницу {$a}';
$string['multianswersforsingle'] = 'Несколько ответов в вопросе, где подразумевается один ответ';
$string['multichoice'] = 'Множественный выбор';
$string['multipleanswers'] = 'Выберите по меньшей мере один ответ';
$string['name'] = 'Название офлайн-теста';
$string['neededcorrection'] = '< strong>Внимание: некоторые из ваших отметок нуждались в ручной коррекции. Взгляните на красные квадраты на следующем рисунке.
<br /> Они обозначают ручное вмешательство преподавателя, что и задержало публикацию результатов офлайн-теста!</strong>';
$string['newgrade'] = 'Оценено';
$string['newpage'] = 'Новая страница';
$string['noattemptexists'] = 'Не существует результата';
$string['noattempts'] = 'Результаты не импортированы';
$string['noattemptsonly'] = 'Отобразить студентов без результатов';
$string['nocourse'] = 'Отсутствует курс с ID {$а->course}, к которому относится офлайн-тест с ID {$а->offlinequiz}.';
$string['nogradesseelater'] = 'Тест еще не оценен для {$a}. Результаты будут опубликованы здесь.';
$string['nogroupdata'] = 'Нет информации о группе для пользователя {$a}';
$string['nomcquestions'] = 'Нет вопросов с множественным выбором в группе {$a}';
$string['noofflinequiz'] = 'Нет офлайн-теста с идентификатором {$a}';
$string['nopages'] = 'Не импортировано ни одной страницы';
$string['noparticipantsfound'] = 'Участники не найдены';
$string['nopdfscreated'] = 'Документы не созданы';
$string['noquestions'] = 'Некоторые группы офлайн-теста пусты. Пожалуйста, добавьте вопросы.';
$string['noquestionselected'] = 'Не выбрано ни одного вопроса.';
$string['noquestionsfound'] = 'Нет вопросов в группе {$a}';
$string['noquestionsonpage'] = 'Пустая страница';
$string['noresults'] = 'Нет результатов.';
$string['noreview'] = 'Вам не разрешено пересматривать офлайн-тест';
$string['noscannedpage'] = 'Нет отсканированных страниц с идентификатором {$a}';
$string['notagselected'] = 'Тэг не выбран';
$string['nothingtodo'] = 'Ничего не делать!';
$string['notxtfile'] = 'Нет TXT файла';
$string['notyetgraded'] = 'Еще не оценено';
$string['nozipfile'] = 'Нет ZIP файла';
$string['numattempts'] = 'Количество импортированных результатов: {$a}';
$string['numattemptsqueue'] = '{$a} форм ответов добавлено в очередь. После обработки данных на ваш email будет отправлено уведомление.';
$string['numattemptsverify'] = 'Отсканированные формы, ожидающие корректировки: {$a}';
$string['numberformat'] = 'Значением должно быть число из {$a} цифр.';
$string['numbergroups'] = 'Число групп';
$string['numpages'] = '{$a} страниц импортировано';
$string['numquestionsx'] = 'Вопросов: {$a}';
$string['numusersadded'] = '{$a} участников добавлено';
$string['odsformat'] = 'Электронная таблица OpenDocument (ODS)';
$string['offlineimplementationfor'] = 'Офлайн реализация для';
$string['offlinequiz:addinstance'] = 'Добавить офлайн-тест';
$string['offlinequiz:attempt'] = 'Попытка';
$string['offlinequiz:changeevaluationmode'] = 'Сделать возможным изменение режима оценки. ПРЕДУПРЕЖДЕНИЕ: НЕ ПРИМЕНЯТЬ на реально используемых сайтах!';
$string['offlinequiz:createofflinequiz'] = 'Создать формы офлайн-теста';
$string['offlinequiz:deleteattempts'] = 'Удалить результаты офлайн-теста';
$string['offlinequiz:grade'] = 'Оценить офлайн-тесты вручную';
$string['offlinequiz:manage'] = 'Управление офлайн-тестами';
$string['offlinequiz:preview'] = 'Предпросмотр офлайн-тестов';
$string['offlinequiz:view'] = 'Просмотр информации офлайн-теста';
$string['offlinequiz:viewreports'] = 'Просмотр отчетов офлайн-теста';
$string['offlinequizcloses'] = 'Офлайн-тест закрывается';
$string['offlinequizcloseson'] = 'Пересмотр офлайн-теста закроется {$a}';
$string['offlinequizisclosed'] = 'Офлайн-тест закрыт)';
$string['offlinequizisclosedwillopen'] = 'Офлайн-тест закрыт (откроется {$a})';
$string['offlinequizisopen'] = 'Этот офлайн-тест открыт';
$string['offlinequizisopenwillclose'] = 'Офлайн-тест открыт (закроется {$a})';
$string['offlinequizopenedon'] = 'Этот офлайн тест открыт {$a}';
$string['offlinequizopens'] = 'Офлайн-тест открывается';
$string['offlinequizsettings'] = 'Офлайн-настройки';
$string['offlinequizwillopen'] = 'Офлайн-тест открывается: {$a}';
$string['oneclickenrol'] = 'Подписка в один клик';
$string['oneclickenroldesc'] = 'Если эта опция активирована, учителя имеют возможность регистрировать пользователей одним щелчком мыши, исправляя формы ответов (ошибка «Пользователь не на курсе»).';
$string['oneclickrole'] = 'Роль для подписки в один клик';
$string['oneclickroledesc'] = 'Выберите роль, используемую для регистрации в 1 клик. Могут быть выбраны только роли с прототипом «студент».';
$string['onlylocalcategories'] = 'Только локальные категории вопросов';
$string['orderandpaging'] = 'Сортировка и постраничный вывод';
$string['orderandpaging_help'] = 'Цифры 10, 20, 30, ... напротив каждого вопроса указывают порядок вопросов. Номера увеличиваются на 10, чтобы оставить место для дополнительных вопросов, которые могут быть вставлены. Чтобы изменить порядок вопросов, измените номера, а затем нажмите кнопку «Изменить порядок вопросов».

Чтобы добавить разрывы страниц после определенных вопросов, установите флажки рядом с вопросами и нажмите кнопку «Добавить разрывы страниц после выбранных вопросов».

Чтобы распределить вопросы по нескольким страницам, нажмите кнопку «Разбить на страницы» и выберите нужное количество вопросов на странице.';
$string['orderingofflinequiz'] = 'Сортировка и постраничный вывод';
$string['otherresultexists'] = 'Уже существует другой результат для {$a}, импорт';
$string['outof'] = '{$a->grade} превышает максимум {$a->maxgrade}';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Общий отзыв';
$string['overview'] = 'Обзор';
$string['overviewdownload_help'] = 'Загрузить обзор';
$string['page-mod-offlinequiz-edit'] = 'Редактировать страницу офлайн-тестирования';
$string['page-mod-offlinequiz-x'] = 'Любая страница офлайн-теста';
$string['pagecorrected'] = 'Исправленный лист со списком участников импортирован';
$string['pageevaluationtask'] = 'Оценка листа ответов для плагина офлайн-теста';
$string['pageimported'] = 'Лист со списком участников импортирован';
$string['pagenotdetected'] = 'Не удается определить штрих-код для страницы.';
$string['pagenumberimported'] = 'Лист {$a} со списком участников импортирован';
$string['pagenumberupdate'] = 'Обновление номера страницы';
$string['pagesizeparts'] = 'Отображать участников на странице:';
$string['papergray'] = 'Уровень белизны бумаги';
$string['papergray_help'] = 'Если белые участки отсканированных бланков ответов очень темные, вы можете исправить это, установив значение темно-серого цвета.';
$string['partcheckedwithoutresult'] = '<a href="{$a->url}">{$a->count} отмеченных участников без результата</a>';
$string['partcheckedwithresult'] = '{$a} отмеченных участников с результатом';
$string['partial'] = 'частично';
$string['participants'] = 'Участники';
$string['participants_help'] = '<p>Списки участников предназначены для больших офлайн-тестов с большим количеством участников. Они помогают учителю проверить, кто из учеников прошел тест и правильно ли были импортированы все результаты.
Вы можете добавлять пользователей в разные списки. Каждый список мог бы, например, содержать участников определенного класса. Участники могут быть членами специальной группы. Для создания таких групп можно использовать инструмент регистрации групп.
Списки участников могут быть загружены в виде PDF-документов, распечатаны и помечены крестиками, как и формы ответов на офлайн-тест. После этого они могут быть загружены, и помеченные студенты будут отмечены как присутствующие в базе данных.
Пожалуйста, избегайте пятен на штрих-кодах, поскольку они используются для идентификации студентов.</p>';
$string['participantsinlists'] = 'Участники в списках';
$string['participantslist'] = 'Список участников';
$string['participantslists'] = 'Участники';
$string['partimportnew'] = 'Загрузка списка участников';
$string['partimportnew_help'] = '<p>
На этой вкладке вы можете загрузить заполненные списки участников. В ZIP-архив можно загрузить как отдельные файлы отсканированных изображений, так и несколько файлов отсканированных изображений. Модуль офлайн-теста будет обрабатывать файлы изображений в фоновом режиме.
Имена файлов не принципиальны, но не должны содержать специальных символов, таких как умлаут. Изображения должны быть в формате GIF, PNG или TIF. Рекомендуется разрешение от 200 до 300dpi.</p>';
$string['partuncheckedwithoutresult'] = '{$a} неотмеченных участников без результатов';
$string['partuncheckedwithresult'] = '<a href="{$a->url}">{$a->count} неотмеченные участники без результата</a>';
$string['pdfdeletedforgroup'] = 'Форма для группы {$a} удалена';
$string['pdfintro'] = 'Дополнительная информация';
$string['pdfintro_help'] = 'Эта информация будет напечатана на первой странице таблицы вопросов и должна содержать общую информацию о том, как заполнить форму ответа.';
$string['pdfintrotext'] = '<b>Как отвечать?</b><br />Форма ответов будет отсканирована автоматически. Пожалуйста, не складывайте и не пачкайте ее. Используйте черную или синюю ручку. Если вам требуется поправить ответ - закрасьте поле для ответа и оно будет расценено как пустое.<br />';
$string['pdfintrotoolarge'] = 'Вступление слишком длинное (более 2000 символов)';
$string['pdfscreated'] = 'PDF-формы были созданы';
$string['pdfsdeletedforgroup'] = 'Формы для группы {$a} удалены';
$string['pearlywhite'] = 'Жемчужно белый';
$string['pluginadministration'] = 'Управление офлайн-тестом';
$string['pluginname'] = 'Офлайн-тест';
$string['point'] = 'точка';
$string['present'] = 'существующий';
$string['preventsamequestion'] = 'Предотвратить многократное использование одного и того же вопроса в разных группах';
$string['preview'] = 'Предпросмотр';
$string['previewforgroup'] = 'Предпросмотр для группы {$a}';
$string['previewquestion'] = 'Предпросмотр вопроса';
$string['printstudycodefield'] = 'Напечатать поле кода исследования в таблице вопросов';
$string['printstudycodefield_help'] = 'Если флажок установлен, поле кода исследования будет напечатано на первой странице таблицы вопросов.';
$string['privacy:data_folder_name'] = 'Информация об офлайн-тесте';
$string['privacy:metadata:core_files'] = 'Офлайн-тест использует файл API для хранения сгенерированных таблиц вопросов и ответов и заполненных листов с ответами.';
$string['privacy:metadata:core_question'] = 'Офлайн-тест использует API вопросов для сохранения вопросов тестов.';
$string['privacy:metadata:mod_quiz'] = 'Офлайн-тест использует API теста для сохранения результатов тестов.';
$string['privacy:metadata:offlinequiz'] = 'Таблица офлайн-теста сохраняет все сведения, относящиеся к экземпляру данного теста';
$string['privacy:metadata:offlinequiz:course'] = 'Столбец "курс" в таблице офлайн-теста хранит информацию, в каком курсе содержится этот тест.';
$string['privacy:metadata:offlinequiz:decimalpoints'] = 'Количество десятичных знаков в расчете оценок.';
$string['privacy:metadata:offlinequiz:disableimgnewlines'] = 'Следует отключить новые строки до и после изображений';
$string['privacy:metadata:offlinequiz:docscreated'] = 'Если документы были созданы, то этому полю присваивается значение 1, в противном случае - 0.';
$string['privacy:metadata:offlinequiz:fileformat'] = 'Формат файла, который используется для печати листов вопросов, 0 для pdf, 1 для docx, 2 для LaTeX';
$string['privacy:metadata:offlinequiz:fontsize'] = 'Размер шрифта в таблицах вопросов.';
$string['privacy:metadata:offlinequiz:grade'] = 'Оценка показывает максимальное количество баллов, которое можно получить в этом тесте';
$string['privacy:metadata:offlinequiz:id_digits'] = 'Сохраняет количество цифр, которые имел ID при создании листов ответов. Это необходимо для обратной совместимости, если между созданием и импортом листов ответов будет увеличено их количество.';
$string['privacy:metadata:offlinequiz:introformat'] = 'Это поле не используется.';
$string['privacy:metadata:offlinequiz:name'] = 'Колонка \'Имя\' сохраняет название офлайн-теста';
$string['privacy:metadata:offlinequiz:numgroups'] = 'Количество различных групп, которые имеет этот тест';
$string['privacy:metadata:offlinequiz:papergray'] = 'Полутоновая шкала онлайн-теста';
$string['privacy:metadata:offlinequiz:pdfintro'] = 'Текст вступления, который вставляется в вопросные листы в начале';
$string['privacy:metadata:offlinequiz:printstudycodefield'] = 'Предпочтительно, если код исследования будет напечатан на полях вопроса. 1 для истины, 0 - в противном случае.';
$string['privacy:metadata:offlinequiz:showgrades'] = 'Сохраняется, если количество баллов за вопрос должно быть напечатано на листе вопросов.';
$string['privacy:metadata:offlinequiz:showquestioninfo'] = 'Сохраняется, если должна отображаться информация о вопросах, 0 - нет, 1 - информация о типе вопроса, 2 - количество правильных ответов.';
$string['privacy:metadata:offlinequiz:showtutorial'] = 'Сохраняется, если учеников попросят выполнить руководство по офлайн-тесту.';
$string['privacy:metadata:offlinequiz:shufflequestions'] = 'Предпочтительно, чтобы вопросы должны быть перемешаны при создании теста.  1 для перетасовки, в противном случае 0.';
$string['privacy:metadata:offlinequiz:timeclose'] = 'Столбец ВРЕМЯ ЗАКРЫТИЯ сохраняет, когда офлайн-тест был/будет закрыт.';
$string['privacy:metadata:offlinequiz:timecreated'] = 'Время, когда был создан офлайн-тест';
$string['privacy:metadata:offlinequiz:timemodified'] = 'Столбец ВРЕМЯ сохраняет время, когда офлайн-тест был изменен в последний раз.';
$string['privacy:metadata:offlinequiz:timeopen'] = 'Столбец ВРЕМЯ НАЧАЛА сохраняет время, когда офлайн-тест был/будет открыт.';
$string['privacy:metadata:offlinequiz_choices'] = 'В этой таблице содержится информация обо всех крестиках для всех отсканированных страниц. Эта информация необходима для последующего создания результатов на основе количества крестиков.';
$string['privacy:metadata:offlinequiz_choices:choicenumber'] = 'Количество вариантов ответа для этого вопроса.';
$string['privacy:metadata:offlinequiz_choices:scannedpageid'] = 'отсканированная страница, к которой относится вариант';
$string['privacy:metadata:offlinequiz_choices:value'] = 'Считается ли выбор варианта перечеркнутым? 0 - нет, 1- да, -1- возможно';
$string['privacy:metadata:offlinequiz_group_questions'] = 'Эта таблица хранит все вопросы для каждой группы офлайн-теста.';
$string['privacy:metadata:offlinequiz_group_questions:maxmark'] = 'Максимальное количество баллов, которое можно набрать за этот вопрос';
$string['privacy:metadata:offlinequiz_group_questions:offlinegroupid'] = 'Offlinequiz - этот групповой вопрос относится к';
$string['privacy:metadata:offlinequiz_group_questions:offlinequizid'] = 'Offlinequizid - этот групповой вопрос относится к';
$string['privacy:metadata:offlinequiz_group_questions:page'] = 'Страница, на которой этот вопрос напечатан в листах ответов';
$string['privacy:metadata:offlinequiz_group_questions:position'] = 'Положение в офлайн-тесте';
$string['privacy:metadata:offlinequiz_group_questions:questionid'] = 'ID выбранного вопроса';
$string['privacy:metadata:offlinequiz_group_questions:slot'] = 'Место для вопроса в тесте';
$string['privacy:metadata:offlinequiz_groups'] = 'Таблица для групп, в которых участвуют тесты.';
$string['privacy:metadata:offlinequiz_groups:answerfilename'] = 'Имя файла, который используется для сохранения файла с ответами';
$string['privacy:metadata:offlinequiz_groups:correctionfilename'] = 'Файл, который используется для сохранения файла с  исправлениями';
$string['privacy:metadata:offlinequiz_groups:number'] = 'номер группы для этого офлайн-теста, 1 для группы А, 2 - группа Б и т.д.';
$string['privacy:metadata:offlinequiz_groups:numberofpages'] = 'количество страниц, необходимых для печати листов с ответами';
$string['privacy:metadata:offlinequiz_groups:offlinequizid'] = 'ID офлайн-теста, к которому относится  этот тест';
$string['privacy:metadata:offlinequiz_groups:questionfilename'] = 'Имя файла, который используется для сохранения файла с вопросами';
$string['privacy:metadata:offlinequiz_groups:sumgrades'] = 'сумма всех оценок за все вопросы в этой группе';
$string['privacy:metadata:offlinequiz_groups:templateusageid'] = 'ID шаблона, который используется для создания результата в API теста';
$string['privacy:metadata:offlinequiz_hotspots'] = 'Эта таблица хранит все позиции блоков (если они были успешно оценены).';
$string['privacy:metadata:offlinequiz_hotspots:blank'] = 'Если точка доступа успешно проанализирована';
$string['privacy:metadata:offlinequiz_hotspots:name'] = 'Тип точки доступа, например u%номер точки доступа пользователя, а-0-0 для вопроса 1 ответ 1 и т.д.';
$string['privacy:metadata:offlinequiz_hotspots:scannedpageid'] = 'Отсканированная страница с точкой доступа';
$string['privacy:metadata:offlinequiz_hotspots:time'] = 'время последнего обновления для этой точки доступа';
$string['privacy:metadata:offlinequiz_hotspots:x'] = 'Значение x точки доступа';
$string['privacy:metadata:offlinequiz_hotspots:y'] = 'Значение y точки доступа';
$string['privacy:metadata:offlinequiz_p_choices'] = 'В этой таблице сохраняются все крестики для списков участников';
$string['privacy:metadata:offlinequiz_p_choices:scannedpageid'] = 'отсканированная страница, к которой относится этот выбор';
$string['privacy:metadata:offlinequiz_p_choices:userid'] = 'ID пользователя, к которому имеет отношение этот выбор';
$string['privacy:metadata:offlinequiz_p_choices:value'] = 'Заполнен ли крест (0 - не заполнен, 1- заполнен, -1 - неразборчив)';
$string['privacy:metadata:offlinequiz_p_lists'] = 'эта таблица сохраняет информацию о списке участников, где учителя могут отметить, принимал ли участие ученик';
$string['privacy:metadata:offlinequiz_p_lists:filename'] = 'имя файла для списка';
$string['privacy:metadata:offlinequiz_p_lists:name'] = 'название списка участников';
$string['privacy:metadata:offlinequiz_p_lists:number'] = 'номер списка в офлайн-тесте';
$string['privacy:metadata:offlinequiz_p_lists:offlinequizid'] = 'офлайн-тест, к которому относится данный список';
$string['privacy:metadata:offlinequiz_page_corners'] = 'Эта таблица сохраняет все углы каждой отсканированной страницы, чтобы быстрее оценить ее для следующей оценки или исправления';
$string['privacy:metadata:offlinequiz_page_corners:position'] = 'Информация о том, находится ли этот угол вверху или внизу, а также справа или слева.';
$string['privacy:metadata:offlinequiz_page_corners:scannedpageid'] = 'Отсканированная страница, на которой находится этот угол';
$string['privacy:metadata:offlinequiz_page_corners:x'] = 'Значение x угла';
$string['privacy:metadata:offlinequiz_page_corners:y'] = 'Значение y угла';
$string['privacy:metadata:offlinequiz_participants'] = 'таблица участников сохраняет информацию о том, принимал ли пользователь участие в тесте или нет.';
$string['privacy:metadata:offlinequiz_participants:checked'] = 'Информация, если этот пользователь был отмечен в списке участников';
$string['privacy:metadata:offlinequiz_participants:listid'] = 'ID листа, в который входит этот участник';
$string['privacy:metadata:offlinequiz_participants:userid'] = 'ID пользователя';
$string['privacy:metadata:offlinequiz_queue'] = 'Эта таблица сохраняет очередь загрузки. Для каждой загрузки в этой таблице есть свой собственный объект';
$string['privacy:metadata:offlinequiz_queue:importuserid'] = 'ID учителя, который внес файлы';
$string['privacy:metadata:offlinequiz_queue:offlinequizid'] = 'ID офлайн-теста в очереди';
$string['privacy:metadata:offlinequiz_queue:status'] = 'статус необходимой очереди';
$string['privacy:metadata:offlinequiz_queue:timecreated'] = 'Время, когда были внесены листы офлайн-теста';
$string['privacy:metadata:offlinequiz_queue:timefinish'] = 'Время окончания оценки очереди';
$string['privacy:metadata:offlinequiz_queue:timestart'] = 'Время начала оценки очереди';
$string['privacy:metadata:offlinequiz_queue_data'] = 'Эта таблица сохраняет данные для очереди, так как каждый файл в очереди будет получать объект ее данных.';
$string['privacy:metadata:offlinequiz_queue_data:error'] = 'Если статус выдает ошибку, то здесь будет находиться более подробное сообщение об ошибке';
$string['privacy:metadata:offlinequiz_queue_data:filename'] = 'имя файла, в котором находится этот объект данных очереди';
$string['privacy:metadata:offlinequiz_queue_data:queueid'] = 'очередь, к которой относятся эти данные';
$string['privacy:metadata:offlinequiz_queue_data:status'] = 'Статус данных очереди';
$string['privacy:metadata:offlinequiz_results'] = 'Эта таблица сохраняет все итоговые данные, которые не могут быть сохранены в API теста';
$string['privacy:metadata:offlinequiz_results:offlinegroupid'] = 'Группа офлайн-теста, к которому относится этот результат.';
$string['privacy:metadata:offlinequiz_results:offlinequizid'] = 'Офлайн-тест, к которому относится этот результат.';
$string['privacy:metadata:offlinequiz_results:status'] = 'Статус результата (выполнен/не выполнен)';
$string['privacy:metadata:offlinequiz_results:sumgrades'] = 'Сумма всех оценок для этого результата';
$string['privacy:metadata:offlinequiz_results:teacherid'] = 'Учитель, загрузивший результаты';
$string['privacy:metadata:offlinequiz_results:timefinish'] = 'Конечное время, когда результат был введен в первый раз';
$string['privacy:metadata:offlinequiz_results:timemodified'] = 'Дата изменения результата';
$string['privacy:metadata:offlinequiz_results:timestart'] = 'Начало времени, когда результат был введен в первый раз';
$string['privacy:metadata:offlinequiz_results:usageid'] = 'ID шаблона из API теста, в котором сохраняется этот результат';
$string['privacy:metadata:offlinequiz_results:userid'] = 'Пользователь, которому принадлежит этот результат';
$string['privacy:metadata:offlinequiz_scanned_p_pages'] = 'Эта таблица сохраняет страницы участников и общую информацию о них';
$string['privacy:metadata:offlinequiz_scanned_p_pages:error'] = 'ошибка (если существует), эта страница сработала при обработке';
$string['privacy:metadata:offlinequiz_scanned_p_pages:filename'] = 'Название файла для отсканированной страницы';
$string['privacy:metadata:offlinequiz_scanned_p_pages:listnumber'] = 'Номер списка';
$string['privacy:metadata:offlinequiz_scanned_p_pages:offlinequizid'] = 'Офлайн-тест принадлежит этой странице участников';
$string['privacy:metadata:offlinequiz_scanned_p_pages:status'] = 'состояние этой отсканированной страницы';
$string['privacy:metadata:offlinequiz_scanned_p_pages:time'] = 'Время обработки этой страницы';
$string['privacy:metadata:offlinequiz_scanned_pages'] = 'Таблица сохраняет информацию об отсканированной странице офлайн-теста';
$string['privacy:metadata:offlinequiz_scanned_pages:error'] = 'Подробное описание ошибки, имеющейся на этой странице (если она существует).';
$string['privacy:metadata:offlinequiz_scanned_pages:filename'] = 'Имя файла отсканированной страницы';
$string['privacy:metadata:offlinequiz_scanned_pages:groupnumber'] = 'Номер группы, к которой относится этот тест';
$string['privacy:metadata:offlinequiz_scanned_pages:offlinequizid'] = 'офлайн-тест отсканированной страницы';
$string['privacy:metadata:offlinequiz_scanned_pages:pagenumber'] = 'Номер страницы';
$string['privacy:metadata:offlinequiz_scanned_pages:resultid'] = 'Результат, относящийся к этой странице';
$string['privacy:metadata:offlinequiz_scanned_pages:status'] = 'статус страницы';
$string['privacy:metadata:offlinequiz_scanned_pages:time'] = 'Время, когда страница была обработана';
$string['privacy:metadata:offlinequiz_scanned_pages:userkey'] = 'Ключ вычеркнутого из страницы пользователя (не ID)';
$string['privacy:metadata:offlinequiz_scanned_pages:warningfilename'] = 'Имя файла, создаваемого при неправильном заполнении теста исправляется, и пользователь получает предупреждение об этом';
$string['questionanalysis'] = 'Анализ сложности';
$string['questionanalysistitle'] = 'Таблица анализа сложности';
$string['questionbankcontents'] = 'Банк вопросов содержит';
$string['questionforms'] = 'Формы вопросов';
$string['questioninfoanswers'] = 'Количество правильных ответов';
$string['questioninfocorrectanswer'] = 'правильный ответ';
$string['questioninfocorrectanswers'] = 'правильные ответы';
$string['questioninfonone'] = 'Ничего';
$string['questioninfoqtype'] = 'Тип вопроса';
$string['questionname'] = 'Название вопроса';
$string['questionpage'] = 'Страница';
$string['questionsheet'] = 'Лист вопроса';
$string['questionsin'] = 'Вопросов в';
$string['questionsingroup'] = 'Вопросов в группе';
$string['questionsinthisofflinequiz'] = 'Вопросов в этом офлайн-тесте';
$string['questiontextisempty'] = '[пустой текст вопроса]';
$string['quizdate'] = 'Дата офлайн-теста';
$string['quizopenclose'] = 'Даты открытия и закрытия';
$string['quizopenclose_help'] = 'Студенты могут просматривать свои попытки после открытия и до закрытия';
$string['quizquestions'] = 'Вопросы теста';
$string['randomfromexistingcategory'] = 'Случайный вопрос из имеющийся категории';
$string['randomnumber'] = 'Количество случайных вопросов';
$string['randomquestionusinganewcategory'] = 'Случайный вопрос с использованием новой категории';
$string['readjust'] = 'Подрегулировать';
$string['reallydeletepdfs'] = 'Вы действительно хотите удалить файлы форм?';
$string['reallydeleteupdatepdf'] = 'Вы действительно хотите удалить и обновить список участников?';
$string['recreatepdfs'] = 'Пересоздать PDF-ки';
$string['recurse'] = 'Включить вопросы из подкатегорий тоже';
$string['rediswrong'] = 'неверный крестик или отсутствует крестик';
$string['refreshpreview'] = 'обновить предпросмотр';
$string['regrade'] = 'Переоценить';
$string['regradedisplayexplanation'] = '<b>Внимание:</b> переоценивание не изменит оценки, которые были выставлены вручную!';
$string['regradinginfo'] = 'Если вы измените количество баллов за вопрос, вы должны перепроверить офлайн-тест, чтобы обновить результаты участников.';
$string['regradingquiz'] = 'Переоценивание';
$string['regradingresult'] = 'Переоценивание результатов для пользователя {$a}...';
$string['reloadpreview'] = 'Перезагрузить предпросмотр';
$string['reloadquestionlist'] = 'Перезагрузить список вопросов';
$string['remove'] = 'Убрать';
$string['removeemptypage'] = 'Убрать пустую страницу';
$string['removepagebreak'] = 'Удалить разрыв страницы';
$string['removeselected'] = 'Убрать выбранное';
$string['reordergroupquestions'] = 'Пересортировать вопросы группы';
$string['reorderquestions'] = 'Пересортировать вопросы';
$string['reordertool'] = 'Показать инструмент пересортировки';
$string['repaginate'] = 'Сформировать новый постраничный вывод с {$a} вопросами на странице';
$string['repaginatecommand'] = 'Сформировать новый постраничный вывод';
$string['repaginatenow'] = 'Сформировать новый постраничный вывод сейчас';
$string['reportends'] = 'Обзор результатов заканчивается';
$string['reportoverview'] = 'Обзор';
$string['reportstarts'] = 'просмотр результатов';
$string['resetofflinequizzes'] = 'Сбросить данные офлайн-теста';
$string['resultexists'] = 'Такой же результат для {$a} уже существует, импорт проигнорирован.';
$string['resultimport'] = 'Импорт результатов';
$string['results'] = 'Результаты';
$string['review'] = 'Обзор';
$string['reviewbefore'] = 'Позволить просмотр обзора при открытом офлайн-тесте';
$string['reviewclosed'] = 'После закрытия офлайн-теста';
$string['reviewcloses'] = 'Обзор закрывается';
$string['reviewimmediately'] = 'Сразу после попытки';
$string['reviewincludes'] = 'Обзор включает в себя';
$string['reviewofresult'] = 'Обзор результатов';
$string['reviewopens'] = 'Обзор открывается';
$string['reviewoptions'] = 'Студенты могут видеть';
$string['reviewoptionsheading'] = 'Опции обзора';
$string['rimport'] = 'Загрузить/Поправить';
$string['rotate'] = 'Повернуть';
$string['rotatingsheet'] = 'Лист повернут...';
$string['save'] = 'Сохранить';
$string['saveandshow'] = 'Сохранить и показать изменения студенту';
$string['savescannersettings'] = 'Сохранить настройки сканера';
$string['scannedform'] = 'Отсканированная форма';
$string['scannerformfortype'] = 'Форма для типа {$a}';
$string['scanneroptions'] = 'Настройки сканера';
$string['scannerpdfs'] = 'Пустые формы';
$string['scannerpdfstext'] = 'Скачайте следующие пустые формы, если вы хотите использовать свою программу для сканирования.';
$string['scanningoptionsheading'] = 'Опции сканирования';
$string['score'] = 'Количество очков';
$string['search:activity'] = 'Офлайн-тест - информация об элементе курса';
$string['select'] = 'Выбрать';
$string['selectagroup'] = 'Выбрать группу';
$string['selectall'] = 'Выбрать все';
$string['selectcategory'] = 'Выбрать категорию';
$string['selectdifferentgroup'] = 'Пожалуйста, выберите другую группу!';
$string['selectedattempts'] = 'Выбранные попытки...';
$string['selectformat'] = 'Выберите формат...';
$string['selectgroup'] = 'Выберите группу';
$string['selectlist'] = 'Пожалуйста, выберите список или попробуйте подрегулировать лист:';
$string['selectmultipletoolbar'] = 'Выберите несколько панелей инструментов';
$string['selectnone'] = 'Снять отметки выбора';
$string['selectpage'] = 'Пожалуйста, выберите номер страницы или попробуйте подрегулировать лист:';
$string['selectquestiontype'] = '-- Выберите тип вопроса --';
$string['showallparts'] = 'Показать все {$a} участников';
$string['showcopyright'] = 'Показать авторскую отметку';
$string['showcopyrightdesc'] = 'Если вы включите эту опцию, заявление об авторских правах будет отображаться на странице просмотра результатов студента.';
$string['showgrades'] = 'Печатать оценки вопросов';
$string['showgrades_help'] = 'Этот параметр определяет, следует ли печатать на листе вопросов максимальные оценки вопросов оффлайн- теста.';
$string['showmissingattemptonly'] = 'Показать всех выбранных участников без результата';
$string['showmissingcheckonly'] = 'Показать всех невыбранных участников без результата';
$string['shownumpartsperpage'] = 'Показывать {$a} участников на странице';
$string['showquestioninfo'] = 'Распечатать информацию об ответах';
$string['showstudentview'] = 'Показать вид от студента';
$string['showtutorial'] = 'Показать руководство по офлайн-тесту учащимся';
$string['showtutorial_help'] = 'Этот параметр определяет, смогут ли учащиеся просмотреть руководство об основах оффлайн-тестов. Это руководство содержит информацию о том, как обрабатывать различные типы документов в оффлайн-тестах. В интерактивной части они узнают, как правильно отмечать свой идентификатор студента. <br />
<b> Примечание:</b><br />
Если вы установите для этого параметра значение «Да», но скроете оффлайн-тест, то ссылка на руководство не будет видна. В этом случае вы можете добавить ссылку на странице курса.';
$string['showtutorialdescription'] = 'Вы можете добавить ссылку на руководство на страницу курса, используя URL:';
$string['shuffleanswers'] = 'Перемешать ответы';
$string['shufflequestions'] = 'Перемешать вопросы';
$string['shufflequestionsanswers'] = 'Перемешать вопросы и ответы';
$string['shufflequestionsselected'] = 'Было задано перемешивание вопросов, поэтому некоторые действия, относящиеся к страницам, недоступны. Для изменения параметра перемешивания {$a}.';
$string['shufflewithin'] = 'Перемешать в вопросах';
$string['shufflewithin_help'] = 'Если включено, части, составляющие каждый вопрос будут перемешиваться случайным образом каждый раз, когда вы нажимаете кнопку перезагрузки в виде превью. ПРИМЕЧАНИЕ: Этот параметр применяется только к вопросам, у которых активировано перемешивание.';
$string['signature'] = 'Подпись';
$string['singlechoice'] = 'Единственный выбор';
$string['standard'] = 'Стандарт';
$string['starttutorial'] = 'Начать руководство по тестированию';
$string['statistics'] = 'Статистика';
$string['statisticsplural'] = 'Статистика';
$string['statsoverview'] = 'Обзор статистики';
$string['studycode'] = 'Код обучения';
$string['temporaryfiledeletiontask'] = 'Удалить временные файлы';
$string['theattempt'] = 'Попытка';
$string['timesup'] = 'Время вышло!';
$string['totalmarksx'] = 'Общая оценка: {$a}';
$string['totalpointsx'] = 'Общая оценка: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Всего {$a} вопросов в категории.';
$string['trigger'] = 'нижняя/верхняя граница';
$string['tutorial'] = 'Руководство по офлайн-тесту';
$string['type'] = 'Тип';
$string['uncheckparts'] = 'Отметить выбранных учатников как отсутствующих';
$string['updatedsumgrades'] = 'Сумма всех оценок группы {$a->letter} была пересчитана и составляет {$a->grade}.';
$string['upgradingfilenames'] = 'Обновление названий файла документов: оффлайн-тест {$a->done}/{$a->outof} (ID оффлайн-теста {$a->info})';
$string['upgradingilogs'] = 'Обновление отсканированных страниц: отсканировано страниц {$a->done}/{$a->outof} <br/>(идентификатор офлайн-теста {$a->info})';
$string['upgradingofflinequizattempts'] = 'Обновление попыток офлайн-теста: офлайн-тест {$a->done}/{$a->outof} <br/>(идентификатор офлайн-теста {$a->info})';
$string['upload'] = 'Загрузить/Исправить';
$string['uploadpart'] = 'Загрузить/Исправить список участников';
$string['uppertrigger'] = 'Более высокая вторая граница';
$string['uppertriggerzero'] = 'Более высокая вторая граница равна нулю';
$string['upperwarning'] = 'Более высокая первая граница';
$string['upperwarningzero'] = 'Более высокая первая граница равна нулю';
$string['useradded'] = 'Пользователь {$a} добавлен';
$string['userdoesnotexist'] = 'Пользователь {$a} не существует в системе';
$string['useridentification'] = 'Идентификация пользователя';
$string['userimported'] = 'Пользователь {$a} импортирован и оценен';
$string['usernotincourse'] = 'Пользователь {$a} не в курсе';
$string['usernotinlist'] = 'Пользователь не зарегистрирован в списке';
$string['usernotregistered'] = 'Пользователь {$a} не зарегистрирован в курсе';
$string['userpageimported'] = 'Одна страница импортирована для пользователя {$a}';
$string['valuezero'] = 'Значение должно быть отлично от нуля';
$string['viewresults'] = 'Просмотреть результаты';
$string['white'] = 'Белый';
$string['withselected'] = 'С выбранным...';
$string['zerogradewarning'] = 'Предупреждение: оценка за ваш офлайн-тест 0.0!';
$string['zipfile'] = 'ZIP-файл';
$string['zipok'] = 'ZIP-файл импортирован';
