<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'pl', version '5.1'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Akcja';
$string['activityoverview'] = 'Masz kwestionariusze do wypełnienia';
$string['additionalinfo'] = 'Dodatkowa informacja';
$string['additionalinfo_help'] = 'Tekst, który ma być wyświetlony w górnej części pierwszej strony kwestionariusza. (tj. instrukcje, informacje, itp.)';
$string['addnewquestion'] = 'Dodawanie pytania: {$a}';
$string['addquestion'] = 'Dodaj pytanie...';
$string['addquestions'] = 'Dodaj pytania';
$string['addselqtype'] = 'Dodaj wybrany typ zapytania';
$string['alignment'] = 'Wyrównanie przycisków Radio';
$string['alignment_help'] = 'Należy wybrać wyrównanie przycisków: pionowo (domyślnie) lub poziomo.';
$string['alignment_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['all'] = 'Wszystko';
$string['alreadyfilled'] = 'Kwestionariusz {$a} został już wcześniej wypełniony. Dziękujemy.';
$string['andaveragevalues'] = 'oraz średnie wartości';
$string['anonymous'] = 'Anonimowy';
$string['answergiven'] = 'Wybrano tę odpowiedź';
$string['answernotgiven'] = 'Nie wybrano tej odpowiedzi';
$string['answerquestions'] = 'Wybierz ten link aby odpowiedzieć na pytania!';
$string['answers'] = 'Odpowiedzi';
$string['attempted'] = 'Ten kwestionariusz został przesłany.';
$string['attemptstillinprogress'] = 'W trakcie realizacji. Zostało zapisane na:';
$string['autonumbering'] = 'Automatyczna numeracja';
$string['autonumbering_help'] = 'Automatyczne numerowanie pytań oraz stron. Można zablokować automatyczne numerowanie poprzez zastosowanie warunku.';
$string['autonumberno'] = 'Proszę nie numerować żadnych pytań i stron';
$string['autonumberpages'] = 'Automatyczna numeracja stron';
$string['autonumberpagesandquestions'] = 'Automatyczna numeracja stron oraz pytań';
$string['autonumberquestions'] = 'Automatyczna numeracja pytań';
$string['average'] = 'Średnia';
$string['averagerank'] = 'Średni ranking';
$string['bodytext'] = 'Tekst główny';
$string['boxesnbexact'] = 'dokładnie {$a} opcje(i).';
$string['boxesnbmax'] = 'co najwyżej {$a} opcje(i).';
$string['boxesnbmin'] = 'co najmniej {$a} opcje(i).';
$string['boxesnbreq'] = 'Dla tego pytania należy zaznaczyć&nbsp;';
$string['by'] = 'przez';
$string['checkallradiobuttons'] = 'Proszę zaznaczyć wszystkie <strong>{$a}</strong> przyciski radiowe!';
$string['checkboxes'] = 'Pola do zaznaczenia';
$string['checkboxes_help'] = 'W celu wybrania przez użytkownika jednej lub wielu odpowiedzi proszę wprowadzić każdą z nich w osobnej linii.';
$string['checkboxes_link'] = 'mod/questionnaire/questions#Check_Boxes';
$string['clicktoswitch'] = '(kliknij, aby przełączyć)';
$string['closebeforeopen'] = 'Data zamknięcia jest wcześniejsza, niż data otwarcia.';
$string['closed'] = 'Ten kwestionariusz został zamknięty w dniu {$a}. Dziękujemy';
$string['closedate'] = 'Pozwól na odpowiedzi do';
$string['closeson'] = 'Kwestionariusz zamyka się {$a}';
$string['completionsubmit'] = 'Student musi przesłać ten kwestionariusz, aby go ukończyć.';
$string['condition'] = 'Warunek';
$string['confalts'] = '- LUB - <br />Strona z potwierdzeniem';
$string['confirmdelallresp'] = 'Czy na pewno usunąć wszystkie odpowiedzi w tej ankiecie?';
$string['confirmdelgroupresp'] = 'Czy na pewno chcesz usunąć wszystkie odpowiedzi {$a}?';
$string['confirmdelresp'] = 'Czy na pewno chcesz usunąć odpowiedź przesłaną przez {$a}?';
$string['confpage'] = 'Tekst nagłówka';
$string['confpage_help'] = 'Nagłówek (wytłuszczony) oraz tekst główny strony "Potwierdzenie", wyświetlanej po wypełnieniu i przesłaniu kwestionariusza (jeżeli został podany URL, jest on zawsze używany zamiast tekstu potwierdzenia). Jeżeli pola strony z potwierdzeniem pozostaną nie wypełnione, to po przesłaniu kwestionariusza system wyświetli standardową wiadomość (Dziękujemy za wypełnienie kwestionariusza).';
$string['confpagedesc'] = 'Nagłówek (wytłuszczony) oraz tekst główny strony "Potwierdzenie", wyświetlanej po wypełnieniu i przesłaniu kwestionariusza (jeżeli został podany URL, jest on zawsze używany zamiast tekstu potwierdzenia).';
$string['contentoptions'] = 'Opcje treści';
$string['couldnotcreatenewsurvey'] = 'Nie można utworzyć nowej ankiety!';
$string['couldnotdelresp'] = 'Nie można usunąć odpowiedzi';
$string['createcontent'] = 'Proszę zdefiniować nową treść';
$string['createcontent_help'] = 'Proszę wybrać i zaznaczyć jeden spośród przycisków radiowych. Domyślnie system zaznacza \'Utwórz nowy\'.';
$string['createcontent_link'] = 'mod/questionnaire/mod#Content_Options';
$string['createnew'] = 'Utwórz nowy';
$string['date'] = 'Data';
$string['date_help'] = 'Należy użyć tego typu pytania jeśli oczekujemy, żeby odpowiedzią była poprawnie sformatowana data.';
$string['date_link'] = 'mod/questionnaire/questions#Date';
$string['dateformatting'] = 'Proszę użyć formatu rok-miesiąc-dzień, np. dla 4 marca 1945: <strong>1945-03-04</strong>';
$string['deleteallresponses'] = 'Usuń wszystkie odpowiedzi';
$string['deletecurrentquestion'] = 'Usuń pytanie {$a}';
$string['deletedallgroupresp'] = 'Usunięto wszystkie odpowiedzi w grupie {$a}';
$string['deletedallresp'] = 'Usunięto wszystkie odpowiedzi';
$string['deletedisabled'] = 'Ten element nie może być usunięty';
$string['deletedresp'] = 'Usunięto odpowiedź';
$string['deleteresp'] = 'Usuń tę odpowiedź';
$string['deletingresp'] = 'Usuwanie odpowiedzi';
$string['dependencies'] = 'Zależności';
$string['dependquestion'] = 'Pytanie nadrzędne';
$string['dependquestion_link'] = 'mod/questionnaire/questions#Parent_Question';
$string['displaymethod'] = 'Nie została zdefiniowana metoda wyświetlania pytania';
$string['download'] = 'Pobierz';
$string['downloadpdf'] = 'Pobierz plik PDF';
$string['downloadtextformat'] = 'Pobierz w formacie tekstowym';
$string['downloadtextformat_help'] = 'Ta funkcja pozwala na zapisanie wszystkich odpowiedzi kwestionariusza w pliku tekstowym (CSV).
 Plik ten może być następnie zaimportowany do arkusza kalkulacyjnego (np. MS Excel, Open Office Calc) lub pakietu statystycznego w celu dalszego przetwarzania.';
$string['downloadtextformat_link'] = 'mod/questionnaire/report#Download_in_text_format';
$string['downloadtypes'] = 'Typ raportu';
$string['dropdown'] = 'Lista rozwijana';
$string['dropdown_help'] = 'Nie ma znaczących korzyści z używania listy rozwijanej zamiast przycisku radiowego.
Jedynie ze względu na liczbę opcji można zaoszczędzić miejsce na ekranie.';
$string['dropdown_link'] = 'mod/questionnaire/questions#Dropdown_Box';
$string['edit'] = 'Edytuj';
$string['editingquestionnaire'] = 'Edycja ustawień Kwestionariusza';
$string['editquestion'] = 'Edycja pytania typu {$a}';
$string['email'] = 'E-mail';
$string['errnewname'] = 'Niestety, podana nazwa jest już używana. Proszę wybrać inną nazwę.';
$string['erroropening'] = 'Błąd otwarcia kwestionariusza.';
$string['errortable'] = 'Błąd: uszkodzona tabela systemowa.';
$string['essaybox'] = 'Dłuższa wypowiedź';
$string['essaybox_help'] = 'W ramach tego pytania zostanie wyświetlone miejsce na wprowadzenie odpowiedzi w formie pola tekstowego o <strong>x</strong> <em>kolumnach znaków</em> (czyli - o takiej <em>szerokości</em>) i <strong>y</strong> <em>rzędach tekstu</em> (czyli - o takiej liczbie <em>wierszy</em>).

Pozostawienie standardowych wartości <strong>0</strong> zarówno dla x, jak i dla y (lub przywrócenie wartości <strong>0</strong> po wcześniejszych zmianach), skutkuje wyświetleniem okna edytora HTML o standardowych rozmiarach
(jeżeli opcja ta jest dostępna w kontekście kurs/użytkownik i dopuszczalna przez profil użytkownika).';
$string['event_all_responses_deleted'] = 'Wszystkie odpowiedzi zostały usunięte';
$string['event_saved'] = 'Odpowiedzi zapisane';
$string['event_submitted'] = 'Odpowiedzi przesłane';
$string['feedback'] = 'Opinia zwrotna';
$string['feedback_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Messages';
$string['feedbackeditsections'] = 'Zapisz ustawienia i edytuj sekcje opinii zwrotnej';
$string['feedbackglobal'] = 'Ogólna opinia zwrotna';
$string['feedbacknone'] = 'Brak wiadomości opinii zwrotnej';
$string['feedbacknotes'] = 'Notatki opinii zwrotnej';
$string['feedbackoptions'] = 'Opcje opinii zwrotnej';
$string['feedbackoptions_link'] = 'mod/questionnaire/personality_test';
$string['feedbackscores'] = 'Wyświetl wyniki';
$string['feedbacksectionsselect_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Sections_2';
$string['field'] = 'Pytanie {$a}';
$string['fieldlength'] = 'Długość pola tekstowego';
$string['fieldlength_help'] = 'Dla pytania typu <strong>Pole tekstowe</strong> należy określić <strong>Długość pola tekstowego</strong> oraz <strong>Maks. dozwoloną długość tekstu</strong>, jaki może być wprowadzony przez
respondenta.

Standardowo przyjmowane wartości, to 20 znaków dla pola tekstowego i 25 znaków dla maksymalnej długości tekstu.';
$string['finished'] = 'Udzielono już wszystkich odpowiedzi w ramach tego kwestionariusza!';
$string['firstrespondent'] = 'Pierwszy respondent';
$string['formateditor'] = 'Edytor HTML';
$string['formatplain'] = 'Zwykły tekst';
$string['grade'] = 'Skala oceny odpowiedzi';
$string['gradesdeleted'] = 'Oceny zostały usunięte';
$string['headingtext'] = 'Tekst nagłówka';
$string['horizontal'] = 'Poziomo';
$string['id'] = 'Identyfikator';
$string['includechoicecodes'] = 'Należy uwzględnić kod odpowiedzi';
$string['includechoicetext'] = 'Należy uwzględnić tekst odpowiedzi';
$string['includeincomplete'] = 'Uwzględnij niekompletne odpowiedzi';
$string['incorrectcourseid'] = 'Identyfikator przedmiotu jest nieprawidłowy';
$string['incorrectmodule'] = 'Błędne identyfikator modułu kursu';
$string['incorrectquestionnaire'] = 'Kwestionariusz jest nieprawidłowy';
$string['invalidresponse'] = 'Podano nieprawidłową specyfikację odpowiedzi.';
$string['invalidresponserecord'] = 'Podano nieprawidłową specyfikację rekordu odpowiedzi.';
$string['invalidsurveyid'] = 'Nieprawidłowy identyfikator kwestionariusza.';
$string['kindofratescale'] = 'Rodzaj skali';
$string['kindofratescale_help'] = 'Proszę kliknąć na link poniżej aby uzyskać pomoc.';
$string['kindofratescale_link'] = 'mod/questionnaire/questions#Type_of_rate_scale';
$string['lastrespondent'] = 'Ostatni respondent';
$string['length'] = 'Długość';
$string['managequestions'] = 'Zarządzaj pytaniami';
$string['managequestions_link'] = 'mod/questionnaire/questions#Manage_questions';
$string['mandatory'] = 'Obowiązkowe - Wszystkie zależności muszą być spełnione.';
$string['maxdigitsallowed'] = 'Maks. dozwolona liczba cyfr';
$string['maxdigitsallowed_help'] = 'Używając parametru <strong>Maks. dozwolona liczba cyfr</strong> i <strong>Liczba cyfr dziesiętnych</strong> można wymusić formatowanie odpowiedzi z określoną dokładnością.';
$string['maxdigitsallowed_link'] = 'mod/questionnaire/questions#Numeric';
$string['maxforcedresponses'] = 'Maks. liczba wymuszonych odpowiedzi';
$string['maxtextlength'] = 'Maks. dozwolona długość tekstu';
$string['messageprovider:message'] = 'Przypomnienie o kwestionariuszu';
$string['messageprovider:notification'] = 'Powiadomienie o wypełnionym kwestionariuszu';
$string['minforcedresponses'] = 'Min. liczba wymuszonych odpowiedzi';
$string['minforcedresponses_help'] = 'Można wykorzystać te parametry, aby wymusić zaznaczenie przez respondenta <strong>Min</strong>imalnej lub <strong>Maks</strong>ymalnej liczby pól wyboru. Jeżeli ustawione zostaną takie same (lecz różne od zera!) wartości dla <strong>Min.</strong> i <strong>Maks.</strong> liczby odpowiedzi, respondent będzie musiał zaznaczyć dokładnie tyle pól wyboru. Jeżeli wymagana jest jedynie minimalna, bądź maksymalna liczba odpowiedzi, po prostu należy pozostawić drugi parametr równy jego wartości standardowej, tj. <strong>0</strong>.
Ustawienie wartości parametrów <strong>Min.</strong> lub <strong>Maks.</strong> wymaganej liczby odpowiedzi, innej niż standardowe <strong>0</strong>, skutkuje - w sytuacji, gdy respondent nie zastosuje się do założonych wymagań - wyświetleniem ostrzeżenia. Z oczywistych względów należy jednoznacznie przedstawić takie wymagania, albo w ogólnej instrukcji kwestionariusza, albo w tekście właściwego pytania.';
$string['misconfigured'] = 'Kurs jest źle skonfigurowany';
$string['missingquestion'] = 'Proszę odpowiedzieć na obowiązkowe pytanie';
$string['missingquestions'] = 'Proszę odpowiedzieć na obowiązkowe pytania:';
$string['modulename'] = 'Kwestionariusz';
$string['modulename_help'] = 'Moduł Kwestionariusza pozwala tworzyć ankiety zawierające różnego typu pytania, w celu zebrania informacji od użytkowników.';
$string['modulename_link'] = 'mod/questionnaire/view';
$string['modulenameplural'] = 'Kwestionariusze';
$string['movedisabled'] = 'Ten element nie może być przeniesiony';
$string['myresponses'] = 'Wszystkie odpowiedzi';
$string['myresponsetitle'] = 'Odpowiedzi w liczbie {$a}';
$string['myresults'] = 'Wyniki';
$string['name'] = 'Nazwa';
$string['navigate'] = 'Zezwól na pytania rozgałęzione';
$string['navigate_link'] = 'mod/questionnaire/conditional_branching';
$string['next'] = 'Następny';
$string['nextpage'] = 'Następna strona';
$string['nlines'] = '{$a} linii';
$string['noanswer'] = 'Brak odpowiedzi';
$string['nodata'] = 'Brak przesłanych danych.';
$string['noduplicates'] = 'Brak powtarzających się wyborów';
$string['noduplicateschoiceserror'] = 'Należy umieścić przynajmniej dwie możliwe odpowiedzi w opcji "Brak powtarzających się wyborów"';
$string['non_respondents'] = 'Użytkownicy, którzy jeszcze nie udzielili odpowiedzi w ramach tego kwestionariusza';
$string['noneinuse'] = 'Kwestionariusz nie zawiera żadnych pytań';
$string['nopublicsurveys'] = 'Brak ogólnodostępnych kwestionariuszy.';
$string['noresponsedata'] = 'Brak odpowiedzi na to pytanie.';
$string['noresponses'] = 'Brak odpowiedzi';
$string['normal'] = 'Normalny';
$string['not_started'] = 'nie rozpoczęty';
$string['notanumber'] = '<strong>{$a}</strong> nie jest akceptowanym formatem liczbowym.';
$string['notapplicable'] = 'N.D.';
$string['notapplicablecolumn'] = 'Kolumna N.D.';
$string['notavail'] = 'Ten kwestionariusz nie jest już dostępny.';
$string['noteligible'] = 'Brak uprawnień pozwalających wypełnić ten kwestionariusz';
$string['notemplatesurveys'] = 'Brak szablonów kwestionariuszy';
$string['notifications_link'] = 'mod/questionnaire/mod#Submission_Notifications';
$string['notopen'] = 'Ten kwestionariusz nie będzie dostępny przed datą: {$a}';
$string['notrequired'] = 'Ta odpowiedź nie jest wymagana';
$string['num'] = '#';
$string['numattemptsmade'] = 'Wykonano {$a} podejść do tego kwestionariusza';
$string['numberfloat'] = 'Wprowadzona liczba: <strong>{$a->number}</strong> została przeformatowana/zaokrąglona do postaci o liczbie miejsc dziesiętnych równej <strong>{$a->precision}</strong>.';
$string['numberofdecimaldigits'] = 'Liczba cyfr dziesiętnych';
$string['numberofdecimaldigits_link'] = 'mod/questionnaire/questions#Numeric';
$string['numberscaleitems'] = 'Liczba pozycji na skali';
$string['numberscaleitems_help'] = 'Liczba pozycji na skali, to <em>liczba elementów</em> - punktów lub ocen opisowych (powiązanych z punktami), używanych w skali oceniania.
Skala punktowa rozciąga się od 1 do wartości parametru. Zwykle stosuje się dla <strong>liczby pozycji na skali</strong> wartość 3 lub 5, przy czym domyślnym wyborem jest właśnie <strong>5</strong>.';
$string['numeric'] = 'Liczba';
$string['numeric_help'] = 'Należy użyć tego typu pytania jeśli oczekujemy odpowiedzi w określonym formacie liczbowym.';
$string['of'] = 'z';
$string['opendate'] = 'Udostępniaj po dacie otwarcia';
$string['option'] = 'opcja {$a}';
$string['optional'] = 'Dowolne - Przynajmniej jedna z zależności musi być spełniona.';
$string['optionalname'] = 'Nazwa pytania';
$string['optionalname_help'] = 'Nazwa pytania jest jedynie używana przy eksporcie odpowiedzi do formatu CSV/Excel.
 Nie należy przywiązywać wagi do nazewnictwa pytań jeśli funkcjonalność eksportu do CSV nie będzie nigdy wykorzystywana.
 Jeżeli natomiast planujemy regularnie eksportować dane z kwestionariusza do pliku CSV, wtedy należy wybrać jedną z dwóch opcji nazewnictwa pytań.';
$string['optionalname_link'] = 'mod/questionnaire/questions#Question_Name';
$string['or'] = '- LUB -';
$string['order_ascending'] = 'Kolejność rosnąca';
$string['order_default'] = 'Wyświetl domyślną kolejność';
$string['order_descending'] = 'Kolejność malejąca';
$string['orderresponses'] = 'Kolejność odpowiedzi';
$string['orderresponses_help'] = 'Wyświetlając wszystkie odpowiedzi można wybrać kolejność dla następujących 4 rodzajów pytań.

* pojedynczy radiowy przycisk wyboru
* pojedyncza rozwijana lista wyboru
* wiele opcji wyboru
* pytania ze skalą odpowiedzi (łącznie ze skalą Likerta).

Po wejściu na stronę "Wszystkie odpowiedzi", domyślnie odpowiedzi będą posortowane w kolejności jakiej Twórca pytania wprowadzał do nich wybór.
 Można posortować odpowiedzi w kolejności rosnącej lub malejącej.';
$string['orderresponses_link'] = 'mod/questionnaire/report#Order_Responses';
$string['osgood'] = 'Skala Osgooda';
$string['other'] = 'Inne:';
$string['otherempty'] = 'Jeśli ta pozycja zostanie wybrana, należy wpisać jakiś tekst w polu tekstowym obok!';
$string['overviewnumresplog'] = 'odpowiedzi';
$string['overviewnumresplog1'] = 'odpowiedź';
$string['overviewnumrespvw'] = 'odpowiedzi';
$string['overviewnumrespvw1'] = 'odpowiedź';
$string['owner'] = 'Właściciel';
$string['page'] = 'Strona';
$string['pageof'] = 'Strona {$a->page} z {$a->totpages}';
$string['participant'] = 'Uczestnik';
$string['pluginadministration'] = 'Administracja kwestionariuszem';
$string['pluginname'] = 'Kwestionariusz';
$string['position'] = 'pozycja';
$string['possibleanswers'] = 'Możliwe odpowiedzi';
$string['posteddata'] = 'Osiągnięto stronę z przesłanymi danymi:';
$string['preview_label'] = 'Podgląd';
$string['preview_questionnaire'] = 'Podgląd kwestionariusza';
$string['previewing'] = 'Podgląd Kwestionariusza';
$string['previous'] = 'Poprzedni';
$string['previouspage'] = 'Poprzednia strona';
$string['print'] = 'Drukuj odpowiedź';
$string['printblank'] = 'Drukuj puste';
$string['printblanktooltip'] = 'Otwiera okno z pustym kwestionariuszem w formacie dostosowanym do wydruku';
$string['printtooltip'] = 'Otwiera okno z aktualnymi odpowiedziami w formacie dostosowanym do wydruku';
$string['private'] = 'Prywatny';
$string['progressbar'] = 'Wyświetlaj pasek postępu';
$string['progressbar_info'] = 'Kwestionariusz {$a} ukończony.';
$string['progresshelp'] = 'Pasek postępu';
$string['public'] = 'Ogólnodostępny';
$string['qtype'] = 'Typ';
$string['qtype_help'] = 'Proszę wybrać czy użytkownicy będą mogli odpowiedzieć: raz, codziennie, co tydzień, co miesiąc czy nieograniczoną liczbę razy. Jeżeli planowane jest, by użytkownicy mieli tylko jedną możliwość wypełnienia kwestionariusza, proszę wybrać opcję "odpowiedź jednorazowa". Natomiast jeśli użytkownicy mogą wypełniać kwestionariusz wielokrotnie, proszę wybrać opcję "odpowiedź wielokrotna".';
$string['qtypedaily'] = 'odpowiedź codzienna';
$string['qtypemonthly'] = 'odpowiedź comiesięczna';
$string['qtypeonce'] = 'odpowiedź jednorazowa';
$string['qtypeunlimited'] = 'odpowiedź wielokrotna';
$string['qtypeweekly'] = 'odpowiedź cotygodniowa';
$string['questionnaire:addinstance'] = 'Dodaj nowy kwestionariusz';
$string['questionnaire:copysurveys'] = 'Skopiuj szablony i kwestionariusze prywatne';
$string['questionnaire:createpublic'] = 'Utwórz kwestionariusz ogólnodostępny';
$string['questionnaire:createtemplates'] = 'Utwórz szablon kwestionariusza';
$string['questionnaire:deleteresponses'] = 'Usuń wszelkie odpowiedzi';
$string['questionnaire:downloadresponses'] = 'Pobierz odpowiedzi w pliku CSV';
$string['questionnaire:editquestions'] = 'Utwórz i edytuj pytania kwestionariusza';
$string['questionnaire:manage'] = 'Utwórz i edytuj kwestionariusze';
$string['questionnaire:message'] = 'Wyślij wiadomość do uczestników, którzy nie udzielili odpowiedzi';
$string['questionnaire:preview'] = 'Podgląd kwestionariuszy';
$string['questionnaire:printblank'] = 'Drukuj pusty kwestionariusz';
$string['questionnaire:readallresponseanytime'] = 'Wczytaj wszystkie odpowiedzi niezależnie od ich daty';
$string['questionnaire:readallresponses'] = 'Wczytaj streszczenia odpowiedzi, zależnie od ich daty';
$string['questionnaire:readownresponses'] = 'Przeczytaj własne odpowiedzi';
$string['questionnaire:submit'] = 'Wypełnij i prześlij kwestionariusz';
$string['questionnaire:view'] = 'Zobacz kwestionariusz';
$string['questionnaire:viewsingleresponse'] = 'Zobacz zestawienie indywidualnych odpowiedzi';
$string['questionnaireadministration'] = 'Administracja kwestionariusza';
$string['questionnairecloses'] = 'Zamknięcie kwestionariusza';
$string['questionnaireopens'] = 'Otwarcie kwestionariusza';
$string['questionnairereport'] = 'Raport kwestionariusza';
$string['questionnum'] = 'Pytanie #';
$string['questions'] = 'Pytania';
$string['questiontypes'] = 'Typy pytań';
$string['questiontypes_help'] = 'Odnośnik do dokumentacji Moodle poniżej';
$string['questiontypes_link'] = 'mod/questionnaire/questions#Question_Types';
$string['radiobuttons'] = 'Przyciski radiowe';
$string['radiobuttons_help'] = 'W tego typu pytaniu, respondent musi wybrać jeden z zaproponowanych wyborów.';
$string['radiobuttons_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['rank'] = 'Ocena';
$string['ratescale'] = 'Ocena (w skali 1...5)';
$string['ratescale_help'] = 'Odnośnik do dokumentacji Moodle poniżej';
$string['ratescale_link'] = 'mod/questionnaire/questions#Rate_.28scale_1..5.29';
$string['realm'] = 'Rodzaj kwestionariusza';
$string['realm_help'] = '* **Dostępne są trzy rodzaje kwestionariuszy:**
 * Prywatny - taki kwestionariusz przynależy wyłącznie do kursu, w którym został utworzony.
 * Szablon - taki kwestionariusz może być kopiowany i zmieniany.
 * Publiczny - taki kwestionariusz może być używany w wielu kursach.';
$string['realm_link'] = 'mod/questionnaire/qsettings#Questionnaire_Type';
$string['redirecturl'] = 'URL strony, na którą użytkownik zostanie przekierowany po wypełnieniu kwestionariusza';
$string['remove'] = 'Usuń';
$string['removeallquestionnaireattempts'] = 'Usuwanie wszystkich odpowiedzi';
$string['required'] = 'Odpowiedź jest wymagana';
$string['required_help'] = 'Zaznaczenie opcji <em><strong>Tak</strong></em> spowoduje, że odpowiedź na to pytanie będzie obowiązkowa.
 Oznacza to, że system nie pozwoli respondentowi na przesłanie wypełnionej ankiety, tak długo, jak nie zostanie wprowadzona odpowiedź na to pytanie.
 Próba przesłania ankiety w takiej sytuacji (lub próba przejścia do następnej strony w przypadku kwestionariusza wielostronicowego) skutkuje wyświetleniem ostrzeżenia,
 zawierającego listę wszystkich pytań kwestionariusza (lub bieżącej strony) z ustawieniem <em>Wymagana odpowiedź = Tak</em>, na które nie zostały udzielone odpowiedzi.';
$string['required_link'] = 'mod/questionnaire/questions#Response_Required';
$string['requiredparameter'] = 'Pominięto wymagany parametr.';
$string['reset'] = 'Wyczyść';
$string['respeligiblerepl'] = '(zastąpione przez nadpisanie ról)';
$string['respondent'] = 'Respondent';
$string['respondenteligibleall'] = 'wszyscy';
$string['respondenteligiblestudents'] = 'tylko studenci';
$string['respondenteligibleteachers'] = 'tylko nauczyciele';
$string['respondents'] = 'Respondenci';
$string['respondenttype'] = 'Rodzaj respondenta';
$string['respondenttype_help'] = 'Można sygnować ankiety poszczególnych respondentów ich pełnym imieniem i nazwiskiem. W tym celu należy ustawić wartość parametru <strong>Rodzaj respondenta</strong> jako <em>&quot;znany z nazwiska&quot;</em>.
 Można ukryć tożsamość respondenta wybierając dla tego parametru wartość <em>&quot;anonimowy&quot;</em>.';
$string['respondenttype_link'] = 'mod/questionnaire/mod#Respondent_Type';
$string['respondenttypeanonymous'] = 'anonimowy';
$string['respondenttypefullname'] = 'pełna nazwa';
$string['response'] = 'Odpowiedź';
$string['responsefieldlines'] = 'Rozmiar pola tekstowego';
$string['responseformat'] = 'Format odpowiedzi';
$string['responseoptions'] = 'Opcje odpowiedzi';
$string['responses'] = 'Odpowiedzi';
$string['responseview'] = 'Studenci mogą przeglądać WSZYSTKIE odpowiedzi';
$string['responseview_help'] = 'W tym miejscu można określić, kto będzie mógł przeglądać wszystkie przesłane odpowiedzi złożonych kwestionariuszy (ogólne tabele statystyczne).';
$string['responseview_link'] = 'mod/questionnaire/mod#Response_viewing';
$string['responseviewstudentsalways'] = 'Zawsze';
$string['responseviewstudentsnever'] = 'Nigdy';
$string['responseviewstudentswhenanswered'] = 'Po zakończeniu wpisywania odpowiedzi';
$string['responseviewstudentswhenclosed'] = 'Po zamknięciu kwestionariusza';
$string['restrictedtoteacher'] = 'Ta funkcjonalność jest dostępna wyłącznie dla nauczycieli z prawem edycji!';
$string['resume'] = 'Zapisz/Wznów odpowiedzi';
$string['resume_help'] = 'Ustawienie tej opcji na <em>Tak</em> pozwala użytkownikom na zapisanie swoich odpowiedzi w trakcie wypełniania kwestionariusza.
 Użytkownik może przerwać ankietę, po czym wznowić ją w późniejszym terminie, kontynuując odpowiedzi od stanu, w jakim dokonany został zapis.';
$string['resume_link'] = 'mod/questionnaire/mod#Save/Resume_answers';
$string['resumesurvey'] = 'Wznów kwestionariusz';
$string['return'] = 'Powróć';
$string['save'] = 'Zapisz';
$string['save_and_exit'] = 'Zapisz i wyjdź';
$string['saveasnew'] = 'Zapisz jako nowe pytanie';
$string['savedbutnotsubmitted'] = 'Ten kwestionariusz został zachowany, ale nie jest jeszcze przesłany.';
$string['savedprogress'] = 'Stan pracy został zapisany. Można zawsze powrócić do wypełniania tego kwestionariusza. W tym celu proszę kliknąć na link {$a} poniżej. System może zażądać podania identyfikatora i hasła, zanim zezwoli na kontynuację';
$string['saveeditedquestion'] = 'Zapisz pytanie {$a}';
$string['savesettings'] = 'Zapisz ustawienia';
$string['search:activity'] = 'Kwestionariusz - informacje o aktywności';
$string['search:question'] = 'Kwestionariusz - pytania';
$string['section'] = 'Opis';
$string['sectionbreak'] = '---- Podział strony ----';
$string['sectionbreak_help'] = '---- Podział strony ----';
$string['sectiontext'] = 'Etykieta';
$string['sectiontext_help'] = 'To nie jest pytanie ale krótki tekst, który będzie stanowił wprowadzenie do serii pytań.';
$string['selecttheme'] = 'Proszę wybrać szablon graficzny (styl CSS), jaki ma być używany dla tego kwestionariusza.';
$string['send'] = 'Wyślij';
$string['send_message'] = 'Wysyłanie wiadomości do wybranych użytkowników';
$string['send_message_to'] = 'Wyślij wiadomość do:';
$string['sendemail'] = 'Wyślij e-mail';
$string['sendemail_help'] = 'Przesyła kopię wypełnionego kwestionariusza na podany adres.
Można podać więcej niż jeden adres, rozdzielając je przecinkami.
Należy pozostawić to pole puste, jeśli nie chcemy korzystać z potwierdzenia przez email.';
$string['settings'] = 'Ustawienia';
$string['settingssaved'] = 'Zapisano ustawienia';
$string['show_nonrespondents'] = 'Pokaż, kto nie udzielił odpowiedzi';
$string['strictdateformatting'] = 'Wprowadź datę, korzystając z selektora dat lub w formacie \'dd.mm.rrrr\' (dzień.miesiąc.rok)';
$string['subject'] = 'Temat';
$string['submissionnotificationhtmluser'] = '<a href="{$a->profileurl}">{$a->username}</a> <a href="{$a->submissionurl}">wypełnił(a)</a> kwestionariusz "{$a->name}" w ramach kursu "{$a->coursename}".';
$string['submissionnotificationsubject'] = 'Wypełniono kwestionariusz';
$string['submissionnotificationtextanon'] = 'Zarejestrowano złożenie ({$a->submissionurl}) kwestionariusza "{$a->name}".';
$string['submissionnotificationtextuser'] = '{$a->username} ({$a->profileurl}) wypełnił(a) ({$a->submissionurl}) kwestionariusz "{$a->name}" w ramach kursu "{$a->coursename}".';
$string['submitoptions'] = 'Opcje przesyłania';
$string['submitpreview'] = 'Prześlij podgląd';
$string['submitpreviewcorrect'] = 'To zgłoszenie będzie przyjęte jako prawidłowo wypełnione.';
$string['submitsurvey'] = 'Prześlij kwestionariusz';
$string['submitted'] = 'Przesłane w dniu:';
$string['subtitle'] = 'Podtytuł';
$string['subtitle_help'] = 'Podtytuł tego kwestionariusza będzie wyświetlany poniżej tytułu, wyłącznie na pierwszej stronie.';
$string['summary'] = 'Streszczenie';
$string['surveynotexists'] = 'kwestionariusz nie istnieje.';
$string['surveyowner'] = 'Musisz być właścicielem kwestionariusza, aby móc wykonać tę operację.';
$string['surveyresponse'] = 'Odpowiedzi dla kwestionariusza';
$string['template'] = 'Szablon';
$string['templatenotviewable'] = 'Szablony kwestionariuszy nie mogą być przeglądane.';
$string['text'] = 'Tekst pytania';
$string['textareacolumns'] = 'Kolumny pola tekstowego';
$string['textareacolumns_help'] = 'W ramach tego pytania zostanie wyświetlone miejsce na wprowadzenie odpowiedzi w formie pola tekstowego o <strong>x</strong> <em>kolumnach znaków</em> (czyli - o takiej <em>szerokości</em>) i <strong>y</strong> <em>rzędach tekstu</em> (czyli - o takiej liczbie <em>wierszy</em>).
Pozostawienie standardowych wartości <strong>0</strong> zarówno dla x, jak i dla y (lub przywrócenie wartości <strong>0</strong> po wcześniejszych zmianach), skutkuje wyświetleniem okna edytora HTML o standardowych rozmiarach
(jeżeli opcja ta jest dostępna w kontekście kurs/użytkownik i dopuszczalna przez profil użytkownika).';
$string['textarearows'] = 'Wiersze pola tekstowego';
$string['textbox'] = 'Pole tekstowe';
$string['textbox_help'] = 'Dla pytania typu <strong>Pole tekstowe</strong> należy określić <strong>Długość pola tekstowego</strong> oraz <strong>Maks. dozwoloną długość tekstu</strong>, jaki może być wprowadzony przez
respondenta.

Standardowo przyjmowane wartości, to 20 znaków dla pola tekstowego i 25 znaków dla maksymalnej długości tekstu.';
$string['textdownloadoptions'] = 'Opcje pobierania dla pliku tekstowego (CSV)';
$string['thank_head'] = 'Dziękujemy za wypełnienie kwestionariusza.';
$string['theme'] = 'Szablon graficzny';
$string['thismonth'] = 'bieżący miesiąc';
$string['thisweek'] = 'bieżący tydzień';
$string['title'] = 'Tytuł';
$string['title_help'] = 'Tytuł kwestionariusza zostanie wyświetlony u góry każdej jego strony. Standardowo, <em>Tytuł</em> jest predefiniowany jako identyczny z <em>Nazwą</em> kwestionariusza, ale może być dowolnie zmieniony zgodnie z preferencjami autora.';
$string['today'] = 'dziś';
$string['total'] = 'Sumarycznie';
$string['totalresponses'] = 'Całkowita liczba odpowiedzi na to pytanie';
$string['type'] = 'Typ pytania';
$string['undefinedquestiontype'] = 'Nieznany typ pytania!';
$string['unknown'] = 'Nieznany';
$string['unknownaction'] = 'Zażądano wykonania nieznanego działania...';
$string['url'] = 'URL z potwierdzeniem';
$string['url_help'] = 'URL do którego użytkownik jest przekierowany po wypełnieniu kwestionariusza.';
$string['useprivate'] = 'Skopiuj istniejący';
$string['usepublic'] = 'Użyj ogólnodostępny';
$string['usetemplate'] = 'Użyj szablonu';
$string['vertical'] = 'Pionowo';
$string['view'] = 'Przeglądaj';
$string['viewallresponses'] = 'Przeglądaj wszystkie odpowiedzi';
$string['viewallresponses_help'] = 'Jeżeli kwestionariusz używa ustawienia <strong>Rodzaj grup</strong>:<em>Widoczne grupy</em>, albo - <strong>Rodzaj grup</strong>:<em>Osobne grupy</em> w sytuacji, gdy bieżący użytkownik
 ma uprawnienia <em>moodle/site:accessallgroups</em> (w bieżącym kontekście) i jeżeli grupy zostały zdefiniowane w bieżącym kursie,
 wówczas użytkownik ma dostęp do rozwijanej listy grup. Jeżeli ustawienia realizują drugą opcję: <strong>Rodzaj grup</strong>:<em>Osobne grupy</em>, to użytkownicy bez uprawnień <em>moodle/site:accessallgroups</em>
 (zwykle - studenci lub nauczyciele bez praw edycji) będą mogli przeglądać odpowiedzi tylko tych respondentów, którzy należą do ich grupy (lub grup).';
$string['viewallresponses_link'] = 'Viewing_Questionnaire_responses#Group_filtering';
$string['viewbyresponse'] = 'Lista odpowiedzi';
$string['viewindividualresponse'] = 'Indywidualne odpowiedzi';
$string['viewindividualresponse_help'] = 'Aby przeglądać pojedyncze odpowiedzi należy kliknąć na nazwę respondenta na liście, która znajduje się poniżej.';
$string['viewresponses'] = 'Wszystkie odpowiedzi ({$a})';
$string['viewyourresponses'] = 'Twoje odpowiedzi - przeglądaj {$a}';
$string['warning'] = 'Uwaga, wystąpił błąd.';
$string['wronganswers'] = 'Wystąpił jakiś problem z odpowiedziami (zobacz poniżej)';
$string['wrongdateformat'] = 'Podana data: <strong>$a</strong> jest niezgodna z formatem podanym w przykładzie.';
$string['wrongdaterange'] = 'BŁĄD! Rok musi mieścić się w przedziale od 1902 do 2037.';
$string['wrongformat'] = 'Wystąpił jakiś problem z odpowiedzią dla pytania:&nbsp;';
$string['wrongformats'] = 'Wystąpił jakiś problem z odpowiedziami dla pytań:&nbsp;';
$string['yesno'] = 'Tak/Nie';
$string['yesno_help'] = 'Proste pytanie typu - Tak/Nie';
$string['yourresponse'] = 'Twoja odpowiedź';
$string['yourresponses'] = 'Twoje odpowiedzi';
