<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'format_tiles', language 'pl', version '5.1'.
 *
 * @package     format_tiles
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addsections'] = 'Dodaj kafelek';
$string['admintools'] = 'Narzędzia administratora';
$string['all'] = 'Wszystko';
$string['allcomplete'] = 'Wszystko kompletne';
$string['allcoursescomplypalette'] = 'Wszystkie kursy mają już dozwolone kolory płytek. Nie trzeba nic resetować. Upewnij się, że zapisałeś wszelkie zmiany w dozwolonych kolorach przed naciśnięciem przycisku reset.';
$string['allowphototiles'] = 'Zezwalaj na umieszczenie zdjęcia na kafelku';
$string['allowphototiles_desc'] = 'Po wybraniu tej opcji nauczyciele będą mogli przesłać zdjęcie, które posłuży jako tło kafelka.  Nadal będą mogli używać standardowych ikon kafelków w tym samym kursie. (Jeśli nie zostanie wybrana, dozwolone będą tylko ikony kafelków, a inne poniższe ustawienia kafelków ze zdjęciami zostaną zignorowane).';
$string['allowsubtilesview'] = 'Zezwalaj na widok pod-kafelków';
$string['allowsubtilesview_desc'] = 'Umożliwić użycie ustawienia kursu, które po wybraniu w obrębie kafelka pokazuje aktywności (z wyjątkiem etykiet) jako podkafelki, zamiast standardowej listy.';
$string['alternativelink'] = 'alternatywny link';
$string['areyousure'] = 'Jesteś pewny?';
$string['asfraction'] = 'Pokaż jako ułamek';
$string['aspectratiotootallorwide'] = 'Przesłany obraz został zapisany, ale proszę sprawdzić, ponieważ może być <strong>{$a->tallorwide}</strong>. Jeśli nie wygląda to dobrze, proszę przyciąć go do standardowych wymiarów krajobrazu i przesłać ponownie.  Np. 300 szerokości x 200 wysokości będzie pasować.';
$string['aspercentagedial'] = 'Pokaż jako % koła';
$string['assumedatastoreconsent'] = 'Zakładanie zgody na lokalne przechowywanie w przeglądarce';
$string['assumedatastoreconsent_desc'] = 'Jeśli zaznaczone, użytkownikowi <b>nie</b> zostanie wyświetlone okno dialogowe z prośbą o zgodę na przechowywanie danych w pamięci lokalnej przeglądarki';
$string['backupfailed'] = 'Kopia zapasowa nie powiodła się';
$string['basecolour'] = 'Kolor kafelków';
$string['basecolour_help'] = 'Ustawiony tutaj kolor zostanie zastosowany do wszystkich kafelków w kursie. (Dostępne kolory są ustalane przez administratora witryny na stronie ustawień wtyczki Format kafelków).';
$string['brandcolour'] = 'Color domyślny (brand)';
$string['changedcolour'] = 'Kolor kafelka przywrócony do domyślnego dla kursu {$a}';
$string['checkforproblemcourses'] = 'Sprawdź i usuń problematyczne kursy';
$string['clickiffailstoload'] = 'Kliknij jeśli strona się nie ładuje';
$string['close'] = 'Zamknij';
$string['collapse'] = 'Zwiń sekcję';
$string['collapsesections'] = 'Zwiń wszystkie';
$string['colourblue'] = 'Niebieski';
$string['colourdarkgreen'] = 'Ciemno zielony';
$string['colourgreen'] = 'Zielony';
$string['colourlightblue'] = 'Jasno niebieski';
$string['colourname_descr'] = 'Wyświetl nazwę dla koloru (nazwa zwykle nie jest widoczna dla użytkowników - zamiast tego widzą kolorową próbkę)';
$string['colournamegeneral'] = 'Wyświetl nazwę dla koloru powyżej';
$string['colourpurple'] = 'Purpurowy';
$string['colourred'] = 'Czerwony';
$string['colours'] = 'Kolory';
$string['complete'] = 'kompletne';
$string['complete-n-auto'] = 'Pozycja nie jest kompletna.  Zostanie on oznaczony jako kompletny, gdy spełnisz wszystkie kryteria ukończenia. Nie można tego zmienić ręcznie.';
$string['complete-y-auto'] = 'Pozycja ukończona.  Został oznaczony jako kompletny, gdy spełniłeś kryteria ukończenia. Nie można tego zmienić ręcznie.';
$string['completion_help'] = 'Znacznik po prawej stronie aktywności może zostać użyty do wskazania, czy aktywność została ukończona (jeśli nie, pojawi się pusty okrąg). <br>
<br>
W zależności od ustawienia znacznik może pojawić się automatycznie po zakończeniu aktywności zgodnie z warunkami ustalonymi przez nauczyciela. <br> <br>
W innych przypadkach możesz kliknąć pusty okrąg, gdy uznasz, że ukończyłeś aktywność, wtedy kolor okręgu zmieni się na zielony. (Kliknięcie go ponownie usunie zaznaczenie, jeśli zmienisz zdanie.)';
$string['completionswitchhelp'] = '<p>Wybrałeś wyświetlanie śledzenia ukończenia na każdym kafelku. Dlatego ustawiliśmy „Śledzenie ukończenia > Włącz” w dalszej części tej strony na „Tak”.</p>
<p>Ponadto musisz włączyć śledzenie ukończenia dla <b>każdego elementu</b>, który śledzisz. np. w przypadku pliku PDF kliknij „Edytuj ustawienia”, przejdź do sekcji Ukończenie aktywności i wybierz potrzebne ustawienie.</p>
<p>Możesz to również zrobić <b>zbiorczo</b>, jak wyjaśniono w <a href="https://docs.moodle.org/35/en/Activity_completion_settings" target="_blank">szczegółowym wyjaśnieniu śledzenia ukończenia na moodle.org</a></p>';
$string['completionwarning'] = 'Śledzenie ukończenia jest włączone na poziomie kursu, ale na poziomie indywidualnej aktywności żadne elementy nie mają włączonego śledzenia, więc nie ma czego śledzić.';
$string['completionwarning_changeinbulk'] = 'Zmiana całościowa';
$string['completionwarning_help'] = 'Musisz umożliwić śledzenie poszczególnych elementów, edytując je (w sekcji Ukończenie aktywności > Śledzenie ukończenia) lub możesz to zrobić zbiorczo w obszarze Ustawienia kursu > Śledzenie ukończenia > Edytuj zbiorczo ukończenie działania';
$string['contact'] = 'Skontaktuj się';
$string['contactdeveloper'] = 'Skontaktuj się z deweloperem';
$string['contents'] = 'Zawartość';
$string['courseshowtileprogress'] = 'Postęp na każdym kafelku';
$string['courseshowtileprogress_error'] = 'Masz opcję „Śledzenie ukończenia > Włącz śledzenie ukończenia” ustawioną na „Nie” (patrz dalej na tej stronie), co powoduje konflikt z tym ustawieniem. Jeśli chcesz wyświetlić postęp na kafelkach, ustaw „Śledzenie ukończenia > Włącz śledzenie ukończenia” na „Tak”. W przeciwnym razie ustaw to ustawienie na „Nie”.';
$string['courseshowtileprogress_help'] = '<p>Po wybraniu, postęp użytkownika w aktywnościach będzie widoczny na każdym kafelku jako <em>ułamek</em> (np. „Postęp 2/10” oznacza ukończenie 2 z 10 aktywności) lub jako < em>procent</em> w kole.</p><p>Można tego użyć tylko wtedy, gdy włączono opcję „Śledzenie ukończenia: > Włącz śledzenie ukończenia”.</p><p>Jeśli w obrębie nie ma żadnych aktywności, które można śledzić danego kafelka, wskaźnik nie będzie wyświetlany dla tego kafelka.</p>';
$string['courseshowtileprogress_link'] = 'Activity_completion_settings#Activity_settings';
$string['coursetoomanysections'] = 'Ostrzeżenie dla edytującego: ten kurs ma więcej kafelków niż dozwolone maksimum. Studentom zostanie pokazanych maksymalnie {$a->max} (do "{$a->tilename}") (prowadzący mogą zobaczyć więcej).';
$string['courseusebarforheadings'] = 'Podkreśl nagłówki kolorowym oznaczeniem';
$string['courseusebarforheadings_help'] = 'Wyświetlaj kolorową zakładkę po lewej stronie nagłówka w kursie za każdym razem, gdy w edytorze tekstu zostanie wybrany styl nagłówka';
$string['courseusesubtiles'] = 'Użyj pod-kafelków dla aktywności';
$string['courseusesubtiles_help'] = 'W każdym kafelku pokaż każdą aktywność jako kafelek podrzędny, a nie jako listę aktywności na stronie. Nie dotyczy to etykiet, które nie będą wyświetlane jako kafelki podrzędne, więc mogą być używane jako nagłówki między kafelkami.';
$string['currentsection'] = 'Ten kafelek';
$string['customcss'] = 'Niestandardowy CSS';
$string['customcssdesc'] = 'Niestandardowy kod CSS do zastosowania w sekcji treści kursu, gdy używany jest format kursu. Nie zostanie to zweryfikowane, więc pamiętaj, aby wprowadzić poprawny kod. Na przykład:<p>.section { color: red; }</p><p>li.activity.subtile.resource.pdf { background-color: orange !important; }</p>';
$string['datapref'] = 'Preferencje danych';
$string['datapreferror'] = 'Funkcja preferencji danych jest dostępna tylko wtedy, gdy w przeglądarce jest dostępny JavaScript. W przeciwnym razie nie można włączyć przechowywania danych.';
$string['dataprefquestion'] = '<p>Aby ułatwić korzystanie z tej witryny, przechowujemy informacje użytkowe (o działaniu) w Twojej przeglądarce, takie jak numer identyfikacyjny ostatniego otwartego kafelka. Pozostaje on na twoim komputerze przez chwilę na wypadek, gdybyś ponownie odwiedził tę stronę. Nie używamy go do śledzenia. Czy zgadzasz się na to rozwiązanie?</p><p>Zapamiętamy Twój wybór, dopóki nie wyczyścisz historii przeglądania. Aby zrezygnować, kliknij „Anuluj”.</p>';
$string['defaultthiscourse'] = 'Domyślne dla tego kursu';
$string['defaulttilecolour'] = 'Wykasuj kolor kafelka';
$string['defaulttileicon'] = 'Ikona kafelka';
$string['defaulttileicon_help'] = 'Ikona wybrana tutaj, pojawi się domyślnie na <em> wszystkich </em> kafelkach tego kursu. Poszczególne kafelki mogą mieć wybraną inną ikonę lub zdjęcie tła, używając innego ustawienia na poziomie kafelków.';
$string['deleteemptytiles'] = 'Usuń puste kafelki';
$string['deleteimage'] = 'Wykasuj obraz';
$string['deletesection'] = 'Wykasuj kafelek';
$string['developedby'] = '"Format kafelków" stworzony przez {$a}';
$string['developer'] = 'Developer';
$string['disabledbyadmin'] = 'Wyłączone przez Administratora strony';
$string['displayfilterbar'] = 'Pasek filtrowania';
$string['displayfilterbar_error'] = '185 / 5 000
Wyniki tłumaczenia
O ile nie skonfigurowałeś efektów uczenia się dla tego kursu, możesz wyświetlić pasek filtrowania tylko na podstawie numerów kafelków, a nie na podstawie efektów kształcenia. Najpierw stwórz efekty kształcenia, a potem wróć tutaj. Widzieć';
$string['displayfilterbar_help'] = '<p>Po wybraniu spowoduje automatyczne wyświetlenie tablicy przycisków przed ekranem kafelków w kursie, które użytkownicy mogą kliknąć, aby odfiltrować kafelki do określonych zakresów</p><p>Po wybraniu opcji „na podstawie numerów kafelków” zostanie wyświetlony szereg przycisków m.in. przycisk dla kafelków 1-4, przycisk dla kafelków 5-8 itd.</p><p>Gdy wybrano „w oparciu o efekty kształcenia w kursie”, będzie jeden przycisk na efekt kursu. Każdy kafelek można przypisać do danego efektu (a zatem do danego przycisku) na stronie ustawień tego kafelka.</p>';
$string['displayfilterbar_link'] = 'Outcomes';
$string['displaytitle_mod_doc'] = 'Dokument Word';
$string['displaytitle_mod_html'] = 'Strona Web';
$string['displaytitle_mod_jpeg'] = 'Obraz';
$string['displaytitle_mod_mp3'] = 'Audio';
$string['displaytitle_mod_mp4'] = 'Video';
$string['displaytitle_mod_pdf'] = 'PDF';
$string['displaytitle_mod_ppt'] = 'Prezentacja Powerpoint';
$string['displaytitle_mod_txt'] = 'Text';
$string['displaytitle_mod_xls'] = 'Arkusz kalkulacyjny';
$string['displaytitle_mod_zip'] = 'Zip';
$string['download'] = 'Download';
$string['editoradvicesubtiles'] = 'W tej wersji wtyczki Tiles działania będą wyświetlane jako podkafelki tylko wtedy, gdy tryb edycji jest wyłączony';
$string['editsection'] = 'Edytuj Tytuł';
$string['editsectionname'] = 'Edytuj nazwę kafelka';
$string['embeddedurlerror'] = 'Jeśli zewnętrzna strona internetowa odmawia otworzenia w powyższym oknie, użyj:';
$string['enablelinebreakfilter'] = 'Włącz filtr przerwania linii';
$string['enablelinebreakfilter_desc'] = 'Filtruj tytuły kafelków pod kątem niewidocznego znaku łączącego słowa {$a} i, jeśli jest użyty, a tytuł tytułu jest długi, zastąp go „-”, aby umożliwić łamanie wiersza. W przeciwnym razie zastąp go niczym (tzn. bez łamania wiersza).';
$string['entersection'] = 'Przejdź do sekcji';
$string['existingimage'] = 'Obraz dla tego kafelka';
$string['expand'] = 'Rozwiń';
$string['expandall'] = 'Rozwiń wszystkie';
$string['expandsections'] = 'Odkryj wszystkie aktywności (wszystkie sekcje)';
$string['fileaddedtobottom'] = 'Plik dodano na dole sekcji';
$string['filterboth'] = 'Pokaż przyciski na podstawie numerów kafelków i efektów kształcenia kursu';
$string['filternumbers'] = 'Pokaż przyciski na podstawie numerów kafelków';
$string['filteroutcomes'] = 'Pokaż przyciski na podstawie efektów kształcenia kursu';
$string['filteroutcomesrestore'] = 'Oryginalny kurs wykorzystywał efekty kształcenia na pasku filtrowania, które nie są jeszcze obsługiwane podczas procesu przywracania. Dlatego ustawienie paska filtrowania zostało zmienione w przywróconym kursie. Jeśli chcesz użyć efektów kształcenia do filtrowania kafelków w przywróconym kursie, skonfiguruj efekty ponownie. Oryginalny kurs nie został zmieniony.';
$string['fittilestowidth'] = 'Dopasuj kafelki do szerokości ekranu';
$string['fittilestowidth_desc'] = 'Jeśli ta opcja jest zaznaczona, gdy użytkownik uzyskuje dostęp do kursu na urządzeniu niemobilnym, kafelki opóźnią ładowanie strony o pół sekundy aby otworzył się najlepiej dopasowany wygląd strony. Unikaj jednego kafelka w jednym wierszu, wyśrodkuj kafelki na ekranie. Stanie się tak tylko przy pierwszym wejściu na kurs w danej sesji. Ustawienie zostanie zapamiętane dla sesji lub do czasu dostosowania rozmiaru ekranu przez użytkownika.';
$string['fixproblems'] = 'Naprawić problemy';
$string['folderdisplayerror'] = 'Foldery są ustawione na wyświetlanie zawartości w tekście nie są zgodne z formatem pod-kafelków. Dlatego <a href="{$a}">folder</a> został zmieniony tak, aby wyświetlał się na osobnej stronie';
$string['followthemecolour'] = 'Wymuś przestrzeganie koloru motywu';
$string['followthemecolour_desc'] = 'Jeśli ustawione na tak, nauczyciele nie będą mieli wyboru przez tę wtyczkę, a wszystkie kolory kafelków poniżej zostaną zignorowane. Zamiast tego zostanie podjęta próba uzyskania głównego koloru motywu i użycia go w zamian';
$string['guidance'] = 'Wskazówki';
$string['height'] = 'wysokość';
$string['hidden'] = 'Ukryty';
$string['hide'] = 'Ukryj';
$string['highestsectionnum'] = 'Najwyższy odnaleziony numer sekcji';
$string['home'] = 'Kurs domowy';
$string['icontitle-address-book-o'] = 'Książka adresowa';
$string['icontitle-assessment_graded'] = 'Ocena A+';
$string['icontitle-assessment_timer'] = 'Zegar oceny';
$string['icontitle-asterisk'] = 'Gwiazdka';
$string['icontitle-award-solid'] = 'Nagroda (rozeta)';
$string['icontitle-balance-scale'] = 'Wagi';
$string['icontitle-bar-chart'] = 'Wykres słupkowy';
$string['icontitle-bell-o'] = 'Dzwonek';
$string['icontitle-binoculars'] = 'Lornetka';
$string['icontitle-bitcoin'] = 'Bitcoin';
$string['icontitle-book'] = 'Książka';
$string['icontitle-bookmark-o'] = 'Zakładka';
$string['icontitle-briefcase'] = 'Aktówka';
$string['icontitle-building'] = 'Budynek';
$string['icontitle-bullhorn'] = 'Megafon';
$string['icontitle-bullseye'] = 'Tarcza';
$string['icontitle-calculator'] = 'Kalkulator';
$string['icontitle-calendar'] = 'Kalendarz';
$string['icontitle-calendar-check-o'] = 'Kalendarz ze znacznikiem wyboru';
$string['icontitle-check'] = 'Potwierdzony';
$string['icontitle-child'] = 'Dziecko';
$string['icontitle-clock-o'] = 'Zegar';
$string['icontitle-clone'] = 'Duplikować';
$string['icontitle-cloud-download'] = 'Pobieranie';
$string['icontitle-cloud-upload'] = 'Wysyłanie';
$string['icontitle-comment-o'] = 'Komentarz';
$string['icontitle-comments-o'] = 'Komentarze';
$string['icontitle-compass'] = 'Kompas';
$string['icontitle-diamond'] = 'Diament';
$string['icontitle-dollar'] = 'Dolar';
$string['icontitle-euro'] = 'Euro';
$string['icontitle-exclamation-triangle'] = 'Uwaga';
$string['icontitle-feed'] = 'RSS';
$string['icontitle-file-text-o'] = 'Plik tekstowy';
$string['icontitle-film'] = 'Film';
$string['icontitle-flag-checkered'] = 'Flaga (w szachownicę)';
$string['icontitle-flag-o'] = 'Flaga';
$string['icontitle-flash'] = 'Piorun';
$string['icontitle-flask'] = 'Fiolka';
$string['icontitle-flipchart'] = 'Tablica';
$string['icontitle-frown-o'] = 'Krzywić się';
$string['icontitle-gavel'] = 'Młotek licytacyjny';
$string['icontitle-gbp'] = 'Funt brytyjski';
$string['icontitle-globe'] = 'Globus';
$string['icontitle-handshake-o'] = 'Uścisk dłoni';
$string['icontitle-headphones'] = 'Słuchawki';
$string['icontitle-heartbeat'] = 'Bicie serca';
$string['icontitle-history'] = 'Zegar historii';
$string['icontitle-home'] = 'Strona główna';
$string['icontitle-id-card-o'] = 'Karta identyfikacyjna';
$string['icontitle-info'] = 'Informacja';
$string['icontitle-jigsaw'] = 'Puzzle';
$string['icontitle-key'] = 'Klucz';
$string['icontitle-laptop'] = 'Laptop';
$string['icontitle-life-buoy'] = 'Koło ratunkowe';
$string['icontitle-lightbulb-o'] = 'Żarówka';
$string['icontitle-line-chart'] = 'Wykres liniowy';
$string['icontitle-list'] = 'Lista wypunktowana';
$string['icontitle-list-ol'] = 'Lista numerowana';
$string['icontitle-location-arrow'] = 'Strzałka lokalizacji';
$string['icontitle-map-marker'] = 'Znacznik mapy';
$string['icontitle-map-o'] = 'Mapa';
$string['icontitle-map-signs'] = 'Drogowskazy na mapie';
$string['icontitle-microphone'] = 'Mikrofon';
$string['icontitle-mobile-phone'] = 'Telefon komórkowy';
$string['icontitle-mortar-board'] = 'Czapka';
$string['icontitle-music'] = 'Muzyka';
$string['icontitle-newspaper-o'] = 'Gazeta';
$string['icontitle-pencil-square-o'] = 'Zaznaczenie';
$string['icontitle-person'] = 'Osoba';
$string['icontitle-pie-chart'] = 'Wykres kołowy';
$string['icontitle-podcast'] = 'Podcast';
$string['icontitle-puzzle-piece'] = 'puzle';
$string['icontitle-question-circle'] = 'Znak zapytania w kółku';
$string['icontitle-random'] = 'Losowy';
$string['icontitle-refresh'] = 'Odświeżanie';
$string['icontitle-road'] = 'Droga';
$string['icontitle-search'] = 'Lupa';
$string['icontitle-sliders'] = 'Suwaki';
$string['icontitle-smile-o'] = 'Uśmiech';
$string['icontitle-star'] = 'Gwiazda (wypełniona)';
$string['icontitle-star-half-o'] = 'Gwiazda (w połowie wypełniona)';
$string['icontitle-star-o'] = 'Gwiazda (niewypełniona)';
$string['icontitle-survey'] = 'Ankieta';
$string['icontitle-tags'] = 'Tagi';
$string['icontitle-tasks'] = 'Zadania';
$string['icontitle-television'] = 'Telewizja';
$string['icontitle-thinking-person'] = 'Osoba z żarówką';
$string['icontitle-thumbs-o-down'] = 'Palec w dół';
$string['icontitle-thumbs-o-up'] = 'Palec w górę';
$string['icontitle-trophy'] = 'Puchar';
$string['icontitle-umbrella'] = 'Parasolka';
$string['icontitle-university'] = 'Uniwersytet';
$string['icontitle-user-o'] = 'Osoba (niewypełniony)';
$string['icontitle-users'] = 'Ludzie';
$string['icontitle-volume-up'] = 'Głośnik';
$string['icontitle-wrench'] = 'Klucz';
$string['imagecannotbeused'] = 'Nie można użyć obrazu';
$string['imagedeletedfrom'] = 'Obraz usunięty z „{$a}”';
$string['imagesavedfor'] = 'Obraz zapisany dla kafelka {$a}}"';
$string['imagesize'] = 'Rozmiar obrazu';
$string['jsactivate'] = 'Animowana nawigacja włączona';
$string['jsdeactivated'] = 'Wyłączyłeś animowaną nawigację na swoim koncie';
$string['jsreactivated'] = 'Aktywowałeś animowaną nawigację na swoim koncie. Nawigacja może być szybsza w użyciu. Wymaga włączonej obsługi JavaScript.';
$string['links'] = 'Linki';
$string['loading'] = 'Ładowanie';
$string['maxcoursesectionsallowed'] = 'Maksymalna liczba sekcji kursu dozwolona w tym środowisku to {$a}.';
$string['modalmodules'] = 'Moduły modalne';
$string['modalmodules_desc'] = 'Uruchom te moduły kursu w oknie modalnym.  (Inne moduły mogą zostać dodane w późniejszej wersji).';
$string['modalresources'] = 'Zasoby modalne';
$string['modalresources_desc'] = 'Uruchom te zasoby w oknie modalnym.  Uwaga: jeśli jest to dozwolone, aktywności URL będą otwierane w oknie modalnym tylko wtedy, gdy są ustawione na {$a->displayembed} na poziomie aktywności (np. filmy z YouTube lub Vimeo).  Nawet wtedy mogą być zablokowane przez właściciela strony przed wyświetlaniem w formie osadzonej - patrz {$a->link}';
$string['modalwindows'] = 'Okna modalne';
$string['newsectionname'] = 'Nowa nazwa dla tematu {$a}';
$string['nexttopic'] = 'Następny temat';
$string['noconnectionerror'] = 'Nie można załadować zawartości.  Sprawdź swoje połączenie internetowe';
$string['nojswarning'] = 'Twoja przeglądarka nie obsługuje języka JavaScript lub jest on wyłączony.  Po włączeniu obsługi języka JavaScript dostępny jest ulepszony interfejs.';
$string['none'] = 'Brak';
$string['noproblemsfound'] = 'Nie znaleziono żadnych problemów';
$string['notcomplete'] = 'Niekompletny';
$string['notrecommended'] = 'Niezalecane';
$string['novaliddefaultcolour'] = 'Brak ustawionego prawidłowego koloru dla domyślnego koloru kafelka poniżej';
$string['numberofsections'] = 'Liczba sekcji w kursie';
$string['ok'] = 'OK';
$string['other'] = 'Inne';
$string['outcomes'] = 'Efekty kształcenia';
$string['outcomesunavailable'] = 'Efekty kształcenia niedostępne';
$string['overall'] = 'Całościowo';
$string['overallprogress'] = 'Ukończenie aktywności - postęp całościowy';
$string['overallprogressshort'] = 'Postęp całościowy';
$string['photoguidance_desc'] = '<p>Prześlij zdjęcie w formacie <strong>landscape</strong>.  Szerokość powinna być około 1,35 razy większa od wysokości.  Np. 270 szerokości x 200 wysokości będzie dobrze pasować.  Nie musisz być dokładny.</p>
<p>Zdjęcia w formacie portretowym nie będą pasowały do kształtu płytki.  Duże obrazy lub pliki zostaną przeskalowane i skompresowane, jeśli to konieczne, po załadowaniu.</p> <p>';
$string['photolibrary'] = 'Biblioteka zdjęć';
$string['photolibrary_desc'] = 'Są to zdjęcia, które ostatnio przesłałeś lub używałeś. Aby użyć jednego z nich jako tła dla tego kafelka, kliknij je.  Aby przesłać nowe, skorzystaj z zakładki przesyłania powyżej.';
$string['phototilesaltstyle'] = 'Zdjęcia do kafelków styl alternatywny';
$string['phototilesaltstyle_desc'] = 'Jeśli nie jest zaznaczony (domyślne ustawienie), kafelki ze zdjęciami będą pokazywać tytuł na górze kafelka.  W stylu alternatywnym tytuł jest wyświetlany na dole.';
$string['phototilesettings'] = 'Kafelki ze zdjęciami';
$string['phototiletitletransarency'] = 'Przezroczystość tytułu kafelka ze zdjęciem';
$string['phototiletitletransarency_desc'] = 'Nakładka tytułu na kafelku ze zdjęciem może mieć lekko przezroczyste tło lub jednokolorowe tło (0%)';
$string['phototitletitlelineheight'] = 'Wysokość wiersza tytułu';
$string['phototitletitlepadding'] = 'Wypełnienie pionowych linii tytułu';
$string['picknewicon'] = 'Wybierz nową ikonę';
$string['picknewiconphoto'] = 'Wybierz nową ikonę lub zdjęcie w tle';
$string['pluginname'] = 'Format kafelków';
$string['previoustopic'] = 'Poprzedni temat';
$string['privacy:metadata:preference:format_tiles_stopjsnav'] = 'Czy użytkownik wyłączył animowaną nawigację JavaScript.';
$string['privacypolicy'] = 'Polityka prywatności';
$string['problemcourses'] = 'Problematyczne kursy';
$string['problemcoursesintro'] = 'Poniższe kursy mają numery sekcji wyższe niż oczekiwano. Użyj poniższych przycisków, aby rozwiązać problemy.';
$string['progress'] = 'Postęp';
$string['reactivate'] = 'reaktywować';
$string['reopenlastsection'] = 'Ponowne otwarcie ostatnio odwiedzanego kafelka';
$string['reopenlastsection_desc'] = 'Po zaznaczeniu tej opcji, jeśli użytkownik ponownie odwiedzi kurs, po przybyciu na miejsce zostanie ponownie otwarta ostatnia sekcja, którą miał otwartą.';
$string['resetallcoursecolours'] = 'Wyzeruj wszystkie kolory kursów';
$string['resetcolours'] = 'Resetowanie kolorów';
$string['resetcolours_desc'] = 'Naciśnij ten przycisk, aby zresetować kolor kafelka dla wszystkich kursów, które nie mają jednego z poniższych kolorów.  Kursy zostaną przestawione na domyślny kolor kafelków podany poniżej.  Możesz użyć tego przycisku po zmianie palety kolorów poniżej, ale upewnij się, że <strong>zapisałeś wszelkie zmiany</strong> w kolorach poniżej przed naciśnięciem tego przycisku.  Uważaj, bo może to zmienić kolor wielu kursów!';
$string['restorefailed'] = 'Przywracanie nie powiodło się';
$string['restoreincorrectsections'] = 'Błąd: Nie można ukończyć, ponieważ kurs źródłowy zawiera niepoprawnie ponumerowane sekcje jest wyższy niż maksimum dozwolone (e.g. section number ({$a->sectionnum}) jest większa od maksymalnej dopuszczalnej wartości ({$a->maxallowed}).  Spróbuj wykluczyć lub usunąć sekcje z wysokim numerem.';
$string['restoretoomanysections'] = 'Błąd: Nie można wykonać kopii zapasowej ani przywrócić danych, ponieważ uwzględniono zbyt wiele sekcji kursu ({$a->numsections}) i jest to więcej niż dozwolone ({$a->maxallowed}). Spróbuj wyłączyć lub usunąć niektóre sekcje.';
$string['revealcontents'] = 'Ujawnienie zawartości kafelka';
$string['section0name'] = 'Ogólne';
$string['sectionerrorstring'] = 'Twoja sesja mogła wygasnąć.  Spróbuj odświeżyć tę stronę.';
$string['sectionerrortitle'] = 'Błąd ładowania zawartości';
$string['sectionname'] = 'Kafelek';
$string['sectionnumber'] = 'Numer sekcji / kafelka';
$string['selected'] = 'Wybrane';
$string['setavailabletilecolours'] = 'Dopuszczalne kolory kafelków (dla całej szerokości strony)';
$string['settings'] = 'Ustawienia formatu kafelków';
$string['show'] = 'Pokaż';
$string['showalltiles'] = 'Pokaż wszystkie kafelki';
$string['showfromothers'] = 'Pokaż kafelek';
$string['showoverallprogress'] = 'Pokaż wskaźnik postępu całościowego';
$string['showoverallprogress_desc'] = 'Pokaż wskaźnik "Całościowy % postępu" w prawym górnym rogu kursu (wyświetlana wartość stanowi sumę % ukończenia każdego kafelka, w oparciu o ukończenie aktywności, a nie w oparciu o ukończenie kursu)';
$string['showprogresssphototiles_desc'] = 'Jeśli zostanie wybrany, postępy ucznia (np. Postęp 2/5) będą wyświetlane na kafelkach ze zdjęciami';
$string['showseczerocoursewide'] = 'Pokaż sekcję zerową na szczycie wszystkich sekcji';
$string['showseczerocoursewide_desc'] = 'Jeśli zaznaczone, sekcja zero (najwyższa sekcja) będzie wyświetlana na stronie docelowej kursu i na górze <b>każdej strony sekcji kursu</b> (tj. na górze zawartości każdego kafelka). Jeśli niezaznaczone (zalecane), będzie wyświetlane tylko na stronie docelowej kursu';
$string['showseparatewin'] = 'Pokaż plik w osobnym oknie';
$string['sitename'] = 'Nazwa strony';
$string['snapwarning'] = 'Możliwe jest edytowanie kursu w formacie kafelków przy użyciu innego motywu, a następnie przejście z powrotem do motywu Snap po zakończeniu edycji.';
$string['snapwarning_help'] = '';
$string['subtileszeczerotoggled'] = 'Górna sekcja przełączana między formatem listy i formatem pod-kafelków';
$string['sureresetcolours'] = 'Czy na pewno chcesz przywrócić domyślne kolory kafelków kursu? Wpłynie to na {$a} kursy';
$string['tilecolourgeneral'] = 'Paleta kolorów - kolor opcjonalny';
$string['tilecolourgeneral_descr'] = 'Te ustawienia pozwalają administratorowi określić, jakie kolory będą dostępne dla nauczycieli, którzy będą mogli zgłaszać się na kursy. Ustaw kolor na czarny (#000), aby wyłączyć ten kolor. Jeśli zmienisz tutaj kolory, żadne zmiany nie zostaną wprowadzone do istniejących kursów, aż do następnej próby zmiany koloru kafelków przez nauczyciela. W tym momencie nauczyciel będzie miał dostęp tylko do kolorów, które tutaj ustawiłeś.';
$string['tilecolourschanged'] = 'Kolory płytek zostały zresetowane. Wszystkie płytki mają teraz kolory zgodne z poniższymi kolorami.';
$string['tileicon'] = 'Ikona wyświetlana tylko na tym kafelku';
$string['tileicon_help'] = 'Wybrany tutaj element zastąpi, tylko dla tego kafelka, dowolną ikonę kafelka ustawioną na poziomie kursu.';
$string['tileicons'] = 'Ikony kafelków';
$string['tileoutcome'] = 'Efekt kształcenia dla tego kafelka';
$string['tileoutcome_help'] = 'Jeśli wybierzesz efekt kształcenia dla tego kafelka, w ustawieniach kursu będziesz mógł wyświetlić zestaw <em>przycisków filtrujących</em>, po jednym dla każdego wyniku, które po naciśnięciu filtrują wyświetlane kafelki według tego, dla którego efektu kształcenia został przydzielony';
$string['tileselecttip'] = 'Oto prostszy sposób zmiany ikony kafelka lub zdjęcia: w trakcie kursu z włączonym trybem edycji wystarczy kliknąć ikonę lub zdjęcie, które chcesz zmienić. Pojawi się okno wyboru ikon.';
$string['tilesformatregistration'] = 'Rejestracja formatu kafelków';
$string['togglecompletion'] = 'Kliknij, aby przełączyć stan ukończenia';
$string['togglecompletioncomplete'] = 'Kliknij, aby przełączyć stan ukończenia (zakończony)';
$string['togglecompletionincomplete'] = 'Kliknij, aby przełączyć stan ukończenia (nie zakończony)';
$string['tootall'] = 'za wysoki na kafelek';
$string['toowide'] = 'za szeroki na kafelek';
$string['transparenttitleadjustments'] = 'Dostosowanie przezroczystości tytułu';
$string['transparenttitleadjustments_desc'] = 'W przypadku kafelków ze zdjęciem z przezroczystym tłem tytułu, w zależności od motywu, możesz dostosować je, aby przezroczyste linie tytułu nie nakładały się podczas zawijania.
Pamiętaj, że różnią się one nieco w zależności od przeglądarki. Sugerowane wartości dla motywów Chrome: Boost i Clean: 30,5 i 4 | Możliwość dostosowania: 32 i 4 | Ruch: 32 i 2 | Remui: 32 i 2,5';
$string['uploadnewphoto'] = 'Prześlij nowe zdjęcie';
$string['uploadnewphoto_help'] = 'Prześlij obraz, który ma być użyty na tym kafelku';
$string['usejavascriptnav'] = 'Użyj nawigacji JavaScript ze strony głównej kafelków';
$string['usejavascriptnav_desc'] = 'Po zaznaczeniu, jeśli użytkownik kliknie kafelek na stronie głównej kursu i ma JavaScript, JS zostanie użyty do przejścia do zawartości kafelka. Zawartość kafelków będzie przechowywana lokalnie w przeglądarce zgodnie z innymi ustawieniami poniżej. Jeśli nie jest zaznaczona, JS nie będzie używany, a zamiast tego będzie używana starsza nawigacja. Pozostałe poniższe ustawienia JS zostaną zignorowane.';
$string['usejseditingexpandcollapse'] = 'Tryb edycji - użyj JavaScript, aby rozwinąć/zwinąć kafelki';
$string['usejseditingexpandcollapse_desc'] = 'Jeśli ta opcja jest wybrana, w trybie edycji nauczyciel może zwijać i rozwijać kafelki edycji z animowanymi przejściami. Zawartość kafelków zostanie załadowana po rozwinięciu, bez ponownego ładowania strony.';
$string['usejsnavforsinglesection'] = 'Użyj nawigacji JS dla strony z pojedynczą sekcją';
$string['usejsnavforsinglesection_desc'] = 'Gdy zaznaczone, każde wywołanie strony z pojedynczą sekcją (&section=xx) będzie obsługiwane za pomocą JavaScript, poprzez uruchomienie strony głównej kursu, animowanej w celu otwarcia w żądanej sekcji za pomocą JS, zamiast wywoływania strony pojedynczej sekcji PHP w starym stylu';
$string['usesubtilesseczero'] = 'Użyj pod-kafelków w górnej części';
$string['usesubtilesseczero_help'] = 'Jeśli zaznaczysz tę opcję, podkategorie będą używane w górnej części kursu oraz we wszystkich podkategoriach.  Jest to możliwe tylko wtedy, gdy używasz pod-kafelki w całym kursie.  Jest to spowodowane tym, że pod-kafelki zajmują dużo miejsca na samej górze kursu.  Lepiej nie zaznaczać tej opcji, aby wszystkie elementy w górnej części kursu były wyświetlane w standardowym formacie listy.';
$string['version'] = 'Wersja  {$a}';
$string['width'] = 'szerokość';
