<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'pl', version '5.1'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Brak dostępu';
$string['accountlocked'] = 'Twoje konto jest zablokowane. Link do odblokowania został wysłany e-mailem.';
$string['accounts'] = 'Konta';
$string['accountunlocked'] = 'Twoje konto jest odblokowane. Możesz się zalogować.';
$string['addcategory'] = 'Dodaj kategorię';
$string['additionalhtml'] = 'Dodatkowy HTML';
$string['additionalhtml_desc'] = 'Te ustawienia pozwalają na określenie, jaki kod HTML zostanie dodany do każdej strony. Można tu ustawić kod HTML dodany w sekcji HEAD dokumentu, zaraz po otwarciu znacznika BODY lub tuż przed jego zamknięciem.<br />Pozwala to na tworzenie własnych nagłówków lub stopek każdej strony, czy włączanie wsparcia ze strony serwisów takich, jak Google Analytics, niezależnie od wybranej skórki serwisu.';
$string['additionalhtml_heading'] = 'Dodatkowy kod HTML do dodania na każdej stronie.';
$string['additionalhtmlfooter'] = 'Przed zamknięciem znacznika BODY';
$string['additionalhtmlfooter_desc'] = 'Zawartość zostanie dodana do kodu strony tuż przed znacznikiem zamykającym sekcję BODY.';
$string['additionalhtmlhead'] = 'Wewnątrz sekcji HEAD';
$string['additionalhtmlhead_desc'] = 'Zawartość zostanie dodana do kodu strony tuż przed znacznikiem zamykającym sekcję HEAD.';
$string['additionalhtmltopofbody'] = 'Po otwarciu znacznika BODY';
$string['additionalhtmltopofbody_desc'] = 'Zawartość zostanie dodana do kodu strony tuż przed znacznikiem otwierającym sekcję BODY.';
$string['admincategory'] = 'Kategoria "{$a}"';
$string['adminseesall'] = 'Administratorzy mają wgląd we wszystko';
$string['adminseesallevents'] = 'Administratorzy widzą wszystkie wydarzenia';
$string['adminseesownevents'] = 'Administratorzy są tacy jak inni użytkownicy';
$string['advancedfeatures'] = 'Zaawansowane funkcje';
$string['agedigitalconsentverification'] = 'Weryfikacja cyfrowego wieku';
$string['agedigitalconsentverification_desc'] = 'Ta opcja umożliwia weryfikację cyfrowego wieku przed wyświetleniem strony rejestracji użytkownikom dokonującym samodzielnej rejestracji. Chroni to Twoją witrynę przed rejestracją nieletnich bez zgody ich rodzica/opiekuna. Dodatkowe informacje można uzyskać klikając w link <a target="_blank" href="{$a}">kontakt z pomocą techniczną</a>.';
$string['ageofdigitalconsentmap'] = 'Cyfrowy wiek zgody';
$string['ageofdigitalconsentmap_desc'] = 'Domyślny cyfrowy wiek wyrażania zgody oraz wiek w każdym kraju, w którym różni się od domyślnego, można określić tutaj. Wpisz każdy wiek w nowym wierszu w formacie: kod kraju, wiek (oddzielone przecinkiem). Domyślny wiek jest oznaczony * zamiast kodu kraju. Kody krajów są zgodne z normą ISO 3166-2.';
$string['allcountrycodes'] = 'Wszystkie kody krajów';
$string['allowattachments'] = 'Zezwól na załączniki';
$string['allowbeforeblock'] = 'Lista dozwolonych IP będzie przetwarzana jako pierwsza';
$string['allowbeforeblockdesc'] = 'Domyślnie, najpierw porównywane są wpisy z listy zablokowanych adresów IP. Jeśli opcja jest zaznaczona, przed lista zablokowanych adresów IP przetwarzana jest lista otwartych adresów IP.';
$string['allowcategorythemes'] = 'Zezwól na motyw dla kategorii';
$string['allowcohortthemes'] = 'Zezwól na motyw dla kohort';
$string['allowcoursethemes'] = 'Zezwól na motyw dla kursu';
$string['allowedemaildomains'] = 'Dozwolone domeny pocztowe';
$string['allowediplist'] = 'Lista dozwolonych adresów IP';
$string['allowemailaddresses'] = 'Dozwolone domeny poczty elektronicznej';
$string['allowemojipicker'] = 'Biblioteka Emoji';
$string['allowframembedding'] = 'Zezwalaj na umieszczanie ramek';
$string['allowframembedding_help'] = 'Zezwalaj na umieszczanie tej strony w ramkach na  zewnętrznych stronach. Włączenie tej funkcji nie jest zalecane ze względów bezpieczeństwa.';
$string['allowguestmymoodle'] = 'Zezwól gościom na dostęp do Kokpitu';
$string['allowindexing'] = 'Zezwalaj na indeksowanie przez wyszukiwarki';
$string['allowindexing_desc'] = 'Określa, czy umożliwić wyszukiwarkom indeksowanie witryny. "Wszędzie" pozwoli wyszukiwarkom wyszukiwać wszędzie, łącznie ze stronami logowania i rejestracji, co oznacza, że witryny z włączonym wymuszonym logowaniem są nadal indeksowane. Aby uniknąć ryzyka spamu związanego z możliwą do przeszukiwania stroną rejestracji, użyj opcji "Wszędzie poza stronami logowania i rejestracji". "Nigdzie" powie wyszukiwarkom, by nie indeksowały żadnej strony. Uwaga: jest to tylko znacznik w nagłówku strony. To od wyszukiwarki zależy poszanowanie tagu.';
$string['allowindexingeverywhere'] = 'Wszędzie';
$string['allowindexingexceptlogin'] = 'Wszędzie z wyjątkiem strony logowania i rejestracji';
$string['allowindexingnowhere'] = 'Nigdzie';
$string['allowobjectembed'] = 'Zezwalaj na znaczniki EMBED i OBJECT';
$string['allowthemechangeonurl'] = 'Zezwalaj na zmiany motywu graficznego w adresie URL';
$string['allowuserblockhiding'] = 'Zezwalaj użytkownikom na ukrywanie bloków';
$string['allowusermailcharset'] = 'Zezwalaj użytkownikom na dobór kodowania znaków';
$string['allowuserswitchrolestheycantassign'] = 'Zezwalaj użytkownikom bez możliwości przypisywania ról na ich przełączanie';
$string['allowuserthemes'] = 'Zezwalaj na motyw dla użytkowników';
$string['alternativefullnameformat'] = 'Alternatywny format pełnej nazwy';
$string['alternativefullnameformat_desc'] = 'To określa, jak nazwy są wyświetlane użytkownikom z możliwością wyświetlania widoków (domyślnie użytkownicy w roli menedżera, nauczyciela lub nauczyciela bez praw edycji). Teksty zastępcze, których można używać, są takie same jak dla opcji "Pełny format nazwy".';
$string['always'] = 'Zawsze';
$string['appearance'] = 'Wygląd';
$string['aspellpath'] = 'Ścieżka do aspell';
$string['asyncbackupdisabled'] = 'Twoja witryna jest obecnie skonfigurowana do korzystania z synchronicznych kopii zapasowych. Asynchroniczne kopie zapasowe zapewniają lepszą obsługę użytkownika i zostaną one włączone dla wszystkich witryn dla Moodle LMS 4.5 LTS. Synchroniczne kopie zapasowe zostaną usunięte z Moodle LMS w wersji po 4.5 LTS';
$string['authentication'] = 'Uwierzytelnianie';
$string['authpreventaccountcreation'] = 'Nie pozwalaj na tworzenie kont przy uwierzytelnianiu';
$string['authpreventaccountcreation_help'] = 'Podczas uwierzytelnienia użytkownika zostaje założone jego konto, o ile jeszcze nie istnieje. Jeśli do uwierzytelniania wykorzystuje się zewnętrzną bazę danych, jak na przykład LDAP, lecz dostęp do strony ma być ograniczony wyłącznie do posiadaczy kont, tę opcję należy włączyć. Nowe konta będą w takim przypadku tworzone ręcznie lub poprzez przesłanie danych użytkowników. Uwaga: to ustawienie nie dotyczy uwierzytelniania MNet.';
$string['authsettings'] = 'Zarządzaj uwierzytelnianiem';
$string['autolang'] = 'Automatyczne wykrywanie języka';
$string['autolangusercreation'] = 'Podczas tworzenia konta ustaw język przeglądarki jako preferowany język użytkownika';
$string['autologinguests'] = 'Automatyczne logowanie gości';
$string['availableto'] = 'Dostępne dla';
$string['availabletoanyone'] = 'Dostępne dla każdego odwiedzającego witrynę';
$string['availabletoauthenticated'] = 'Ograniczone do uwierzytelnionych użytkowników';
$string['backgroundcolour'] = 'Przezroczysty kolor';
$string['backup_shortname'] = 'Użyj nazwy kursu w nazwie pliku kopii zapasowej';
$string['backup_shortnamehelp'] = 'Użyj nazwy kursu jako części nazwy pliku kopii zapasowej.';
$string['backups'] = 'Kopie zapasowe';
$string['badwordsconfig'] = 'Wprowadź listę złych słów rozdzielając je przecinkami';
$string['badwordsdefault'] = 'Jeżeli lista użytkownika jest pusta, użyta będzie domyślna lista z paczki językowej.';
$string['badwordslist'] = 'Lista złych słów zdefiniowana przez użytkownika';
$string['blockediplist'] = 'Lista zablokowanych adresów IP';
$string['blockinstances'] = 'Instancje';
$string['blockmultiple'] = 'Wielokrotny';
$string['blockprotect'] = 'Chroń instancje';
$string['blockprotect_help'] = 'Wybrane bloki będą chronione przed usunięciem dla całego serwisu. Najczęściej to ustawienie stosuje się do ochrony bloków nawigacji i ustawień, których przywrócenie po skasowaniu może być bardzo utrudnione.';
$string['blockprotectblock'] = 'Chroń instancje {$a}';
$string['blockprotected'] = 'Chronione instancje bloków: {$a}';
$string['blocksettings'] = 'Zarządzaj blokami';
$string['blockunprotectblock'] = 'Niechronione instancje {$a}';
$string['blockunprotected'] = 'Niechronione instancje bloków: {$a}';
$string['bloglevel'] = 'Widoczność blogu';
$string['bookmarkadded'] = 'Dodano do zakładek';
$string['bookmarkalreadyexists'] = 'Ta strona jest już dodana do zakładek';
$string['bookmarkdeleted'] = 'Zakładka skasowana';
$string['bookmarkthispage'] = 'Dodaj stronę do zakładek';
$string['cacheapplication'] = 'Pamięć podręczna aplikacji';
$string['cacheapplicationhelp'] = 'Buforowane elementy są wspólne dla wszystkich użytkowników i wygasną z określonym TTL';
$string['cachejs'] = 'Obsługuj Javascript z wykorzystaniem pamięci podręcznej';
$string['cachejs_help'] = 'Pamięć podręczna dla Javascriptu i jego kompresja znacznie przyspieszają ładowanie stron. Ustawienie jest zalecane dla serwisów przeznaczonych dla użytkowników. Deweloperzy najczęściej jednak wyłączają tę opcję.';
$string['cacherequest'] = 'Pytanie o pamięć podręczną';
$string['cacherequesthelp'] = 'Specyficzna pamięć podręczna użytkownika, wygaśnie w przypadku gdy wniosek jest kompletny. Zaprojektowany w celu zastąpienia obszarów, w których używamy statycznych sklepów';
$string['cachesession'] = 'Pamięć podręczna sesji';
$string['cachesessionhelp'] = 'Pamięć podręczna konkretnego użytkownika, która wygasa kiedy sesja użytkownika kończy się. Zaprojektowane do złagodzenia napięć/rozrostu sesji.';
$string['cachesettings'] = 'Ustawienia pamięci podręcznej';
$string['cachetemplates'] = 'Buforuj szablony';
$string['cachetemplates_help'] = 'Buforowanie szablonów poprawi wydajność ładowania strony i jest zdecydowanie zalecane w przypadku witryn produkcyjnych. Programiści prawdopodobnie będą chcieli wyłączyć tę funkcję.';
$string['caching'] = 'Buforowanie';
$string['calendar_weekend'] = 'Dni weekendowe';
$string['calendarexportsalt'] = 'Dodatkowe dane kryptograficzne dla procesu eksportu kalendarza';
$string['calendarsettings'] = 'Kalendarz';
$string['calendartype'] = 'Typ kalendarza';
$string['calendartype_desc'] = 'Wybierz domyślny typ kalendarza dla całej witryny. To ustawienie może być zmienione w ustawieniach kursu lub przez użytkowników we własnym profilu.';
$string['campaign'] = 'Kampania';
$string['cannotdeletemodfilter'] = 'Nie możesz odinstalować "{$a->filter}", ponieważ jest on częścią modułu "{$a->module}".';
$string['cannotuninstall'] = '{$a} nie można odinstalować';
$string['categoryemail'] = 'Email';
$string['cfgwwwrootslashwarning'] = '$CFG->wwwroot jest niepoprawnie zdefiniowany w pliku config.php. Zawiera znak \'/\' na końcu, który musi zostać usunięty.';
$string['cfgwwwrootwarning'] = '$CFG->wwwroot jest niepoprawnie zdefiniowany w pliku config.php. Powinien pasować do adresu URL, którego używasz do dostępu do tej strony.';
$string['change'] = 'zmiana';
$string['checkboxno'] = 'Nie';
$string['checkboxyes'] = 'Tak';
$string['checkupgradepending'] = 'Aktualizacja';
$string['choosefiletoedit'] = 'Wybierz plik do edycji';
$string['cleanup'] = 'Uporządkuj';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 't';
$string['cliexitgraceful'] = 'Wychodzę z gracją, proszę czekać...';
$string['cliexitnow'] = 'Wyjście właśnie teraz';
$string['cliincorrectvalueerror'] = 'Błąd, niepoprawna wartość "{$a->value}" dla "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Nieprawidłowa wartość, spróbuj ponownie';
$string['clistatusdisabled'] = 'Status: wyłączony';
$string['clistatusenabled'] = 'Status: włączony';
$string['clistatusenabledlater'] = 'status: tryb konserwacji CLI zostanie włączony w: {$a}';
$string['clitypevalue'] = 'wartość typu';
$string['clitypevaluedefault'] = 'Typ wartości, naciśnij Enter, aby użyć wartości domyślnej ({$a})';
$string['cliunknowoption'] = 'Nieznane opcje:
  {$a}
Proszę użyć opcji --help.';
$string['cliupgradecompletenomaintenanceupgrade'] = 'Aby wyczyścić pozostałe pamięci podręczne po przełączeniu ruchu użytkowników na nowy kod:

  php admin/cli/purge_caches.php --muc
  php admin/cli/purge_caches.php --js
  php admin/cli/purge_caches.php --filter
  php admin/cli/purge_caches.php --other

Oczyszczanie należy wykonywać pojedynczo, z przerwami między poleceniami, aby zmniejszyć skoki obciążenia serwera WWW.';
$string['cliupgradedefault'] = 'Nowe ustawienie: {$a}';
$string['cliupgradedefaultheading'] = 'Ustawianie nowych wartości domyślnych';
$string['cliupgradedefaultverbose'] = 'Nowe ustawienie: {$a->name}, Domyślne ustawienie: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Uaktualnienie z wiersza poleceń z {$a->oldversion} do {$a->newversion} zakończone pomyślnie.';
$string['cliupgrademaintenancenotrequired'] = 'Ta aktualizacja NIE spowoduje przejścia w tryb konserwacji dla użytkowników.';
$string['cliupgrademaintenancerequired'] = 'Ta aktualizacja spowoduje przejście w tryb konserwacji dla użytkowników.';
$string['cliupgradenoneed'] = 'Do zainstalowanej wersji {$a} nie są wymagane uaktualnienia. Dziękujemy za odwiedziny.';
$string['cliupgradepending'] = 'Aktualizacja w toku';
$string['cliupgradesetlock'] = 'Aktualizacja została zablokowana tylko do wykonywania poprzez CLI.';
$string['cliupgradeunsetlock'] = 'Usunięto istniejącą blokadę aktualizacji wykonania poprzez CLI.';
$string['cliyesnoprompt'] = 'wpisz y (czyli tak) lub n (czyli nie)';
$string['close'] = 'Zamknij';
$string['cohort_customfield'] = 'Niestandardowe pola kohort';
$string['commentsperpage'] = 'Komentarze wyświetlane na stronie';
$string['commonactivitysettings'] = 'Ustawienia podstawowe';
$string['commonfiltersettings'] = 'Wspólne ustawienia filtrowania';
$string['commonsettings'] = 'Ustawienia podstawowe';
$string['componentinstalled'] = 'Komponent zainstalowany';
$string['computedfromlogs'] = 'Obliczono na podstawie logów od: {$a}.';
$string['condifmodeditdefaults'] = 'Ustawienia w tej sekcji staną się ustawieniami domyślnymi podczas tworzenia nowych aktywności.';
$string['confeditorhidebuttons'] = 'Wybierz przyciski które powinny być ukryte w edytorze HTML.';
$string['configallcountrycodes'] = 'Lista krajów, które można wybrać w kilku miejscach serwisu, na przykład w profilu użytkownika. Jeśli lista pozostanie pusta (domyślnie), zostanie wykorzystana lista z pliku countries.php standardowego angielskiego pakietu językowego, pochodząca ze standardu ISO 3166-1. W innych przypadkach można podać listę kodów krajów oddzielając je przecinkami, np. "GB,FR,ES". Jeśli do listy zostaną dopisane nowe, niestandardowe, kody, należy je dodać do pliku countries.php angielskiego i lokalnie wykorzystywanego pakietu językowego.';
$string['configallowassign'] = 'Dla każdej roli w lewej kolumnie wybierz role, które możesz przypisać innym osobom.';
$string['configallowattachments'] = 'Jeśli ta opcja jest włączona, wiadomości e-mail wysłane z tej witryny mogą zawierać załączniki, np. odznaki.';
$string['configallowcategorythemes'] = 'Jeśli włączysz tą opcję, będziesz mógł ustawić motyw graficzny dla kategorii. Ustawienie to będzie miało wpływ na wszystkie kategorie podrzędne. Uwaga: włączenie motywu dla kategorii może mieć wpływ na wydajność.';
$string['configallowcohortthemes'] = 'Opcja ustawienia motywu dla poziomu kohorty. Wpłynie to na wyświetlanie u wszystkich użytkowników w tej samej kohorcie lub kilku, ale z tym samym motywem.';
$string['configallowcoursethemes'] = 'Jeśli włączysz tę opcję, użytkownicy będą mieli możliwość użycia swoich własnych motywów. Motywy kursu nadpisują wszystkie inne wybrane motywy (motywy witryny, użytkownika, kategorii, kohorty lub zdefiniowane przez adres URL).';
$string['configallowedemaildomains'] = 'Wyświetl domeny e-mail, które mogą zostać ujawnione w sekcji "Od" wychodzącej poczty e-mail. Domyślna opcja "Empty" (Opróżnij) użyje adresu No reply (Brak odpowiedzi) dla wszystkich wychodzących wiadomości e-mail. Korzystanie z symboli wieloznacznych jest dozwolone np. * .example.com zezwoli na wysyłanie e-maili z dowolnej poddomeny example.com, ale nie z samego example.com. Wymaga to osobnego wpisu.';
$string['configallowemailaddresses'] = 'Jeśli chcesz zastrzec adresy email do pewnych domen, dodaj te domeny do listy, oddzielając je spacją. Wszystkie inne domeny nie znajdujące się na liście zostaną odrzucone. Aby dodać subdomenę dodaj ją wykorzystując \'.\'. np <strong>ourcollege.edu.au .gov.au</strong>';
$string['configallowemojipicker'] = 'Biblioteka Emoji umożliwia użytkownikom wybieranie emotikon, aby dodawać je do wiadomości i innych obszarów tekstowych za pomocą przycisku wyboru Emoji na pasku narzędzi Atto.';
$string['configallowemojipickerincompatible'] = 'Twoja obecna konfiguracja bazy danych nie obsługuje poprawnie emotikonów. Aby włączyć selektor emotikonów, musisz <a href="https://docs.moodle.org/en/MySQL_full_unicode_support"> zaktualizować swoją bazę danych, aby uzyskać pełną obsługę unicode</a>.';
$string['configallowguestmymoodle'] = 'Jeśli włączone, goście mogą uzyskać dostęp do Kokpitu. W przeciwnym razie goście są przekierowywani do strony głównej.';
$string['configallowobjectembed'] = 'Z powodu bezpieczeństwa, zwykli użytkownicy nie mają prawa wstawiania kodów HTML zawierających znaczniki EMBED i OBJECT. Może to być robione jedynie przez odpowiedni bezpieczny filtr dla multimediów. Jeśli jednak chcesz zezwolić na użycie tych tagów włącz tą opcję.';
$string['configallowoverride'] = 'Zezwalaj rolom po lewej stronie odrzucać role w każdej kolumnie***';
$string['configallowoverride2'] = 'Wybierz które role mogą być nadpisane przez rolę podaną w lewej kolumnie.<br />
Zwróć uwagę, że te ustawienia dotyczą tylko użytkowników którzy mają również włączone uprawnienia do moodle/role:override lub moodle/role:safeoverride.';
$string['configallowswitch'] = 'Wybierz, na jakie role może przełączyć się użytkownik, na podstawie ról już przypisanych. Oprócz dokonania wpisu w tej tabeli, żeby użytkownik mógł przełączać role musi mieć włączoną opcję moodle/role:switchroles.<br />Można przełączyć się tylko na role z włączoną opcją moodle/course:view, nie mając przy tym włączonej opcji moodle/site:doanything, więc niektóre opcje w tej tabeli są niedostępne.';
$string['configallowthemechangeonurl'] = 'Po włączeniu tej opcjo możliwe jest zmienianie motywów poprzez dodanie:<br />?theme=nazwa_motywu do adresu URI, na przykład mymoodlesite.com/?theme=afterburner lub<br />&theme=nazwa_motywu do wewnętrznego adresu URI Moodle, np. mymoodlesite.com/course/view.php?id=2&theme=afterburner.';
$string['configallowuserblockhiding'] = 'Czy chcesz zezwolić użytkownikom aby mogli używać przyciski &bdquo;pokaż/ukryj blok&rdquo;? Ta funkcjonalność wykorzystuje Javascript i pozwala na indywidualne ukrywanie bloków przez użytkowników.';
$string['configallowusermailcharset'] = 'Włączając tą opcję zezwolisz każdemu użytkownikowi na wybór własnej strony kodowej dla emaili';
$string['configallowuserswitchrolestheycantassign'] = 'Domyślnie, by użytkownicy mogli przełączać swoje role, wymagane jest włączenie opcji moodle/role:assign. Aktywowanie niniejszej opcji znosi tę konieczność i uzależnia role dostępne w menu „Przełącz na rolę” wyłącznie od zawartości tabeli „Pozwól na przypisywanie ról”. Zaleca się by ustawienia w tabeli „Pozwól na przypisywanie ról” nie pozwalały użytkownikom przełączyć się do ról o wyższych uprawnieniach niż aktualne.';
$string['configallowuserthemes'] = 'Jeśli włączysz tę opcję, pozwolisz użytkownikom używać ich własnych motywów. Motywy użytkownika mają pierwszeństwo przed motywem strony (ale nie motywu kursu)';
$string['configallowview'] = 'Dla każdej roli w lewej kolumnie wybierz role, które mogą wyświetlać, wyszukiwać i filtrować.';
$string['configallusersaresitestudents'] = 'Czy w przypadku aktywności na stronie głównej WSZYSCY powinni być traktowani jako studenci? Jeżeli odpowiesz "Tak", każdy potwierdzony użytkownik będzie mógł skorzystać z tych aktywności jako student. Jeżeli odpowiesz "Nie", wtedy tylko użytkownicy, którzy są już uczestnikami co najmniej jednego kursu będą mogli wziąć udział w aktywnościach na stronie głównej. Tylko administratorzy i użytkownicy ze szczególnie przypisaną rolą mają uprawnienia nauczyciela w aktywnościach dostępnych na stronie głównej.';
$string['configauthenticationplugins'] = 'Wybierz wtyczki uwierzytelniania, których pragniesz użyć i uporządkuj je w odpowiedniej kolejności działania.';
$string['configautolang'] = 'Wykrywa domyślny język z ustawień przeglądarki. Jeśli opcja jest wyłączona wówczas zostaną wprowadzone ustawienia domyślne strony.';
$string['configautolangusercreation'] = 'Jeśli ta opcja jest włączona, gdy konto użytkownika jest tworzone automatycznie przy pierwszym logowaniu (np. przy użyciu uwierzytelniania LDAP lub OAuth 2), język przeglądarki użytkownika jest ustawiany jako preferowany język. W przeciwnym razie domyślny język witryny zostanie ustawiony jako preferowany język użytkownika.';
$string['configautologinguests'] = 'Czy niezalogowani użytkownicy mają być zalogowani automatycznie jako gość jeśli wchodzą do kursu jako goście?';
$string['configbloglevel'] = 'To ustawienie pozwala określić stopień ograniczeń wyświetlania blogów. Ustawia ono zakres samego WYŚWIETLANIA. Nie dotyczy wpisów ani typów wpisów bloga. Jeżeli nie chcesz blogów, możesz je wyłączyć całkowicie.';
$string['configcalendarcustomexport'] = 'Włącz niestandardowy zakres dat eksportu kalendarza';
$string['configcalendarexportsalt'] = 'Ten przypadkowy tekst służy do poprawy bezpieczeństwa tokenów uwierzytelniających stosowanych do eksportu kalendarzy. Proszę pamiętać, że wszystkie tokeny będą unieważnione, jeśli zmienisz ten tekst.';
$string['configcookiesecure'] = 'Jeśli serwer akceptuje tylko połączenia https: zaleca się włączyć wysyłanie bezpiecznych ciasteczek. Jeśli włączono, upewnij się, że serwer nie akceptuje http:// lub ustaw stałe przekierowanie na https://. Kiedy adres <em>wwwroot</em> nie zaczyna się od https://, to ustawienie jest automatycznie wyłączone.';
$string['configcountry'] = 'Jeśli ustawisz tutaj kraj wtedy będzie on wybierany jako domyslny dla nowo towrzonych kont. Aby zmusić użytkowników do samodzielnego wyboru nie ustawiaj tutaj kraju.';
$string['configcoursegraceperiodafter'] = 'Klasyfikuj kursy zakończone jako aktualne przez okres podanej liczby dni - od daty zakończenia kursu.';
$string['configcoursegraceperiodbefore'] = 'Klasyfikuj przyszłe kursy jako trwające przez te wiele dni przed datą rozpoczęcia kursu.';
$string['configcourseoverviewfilesext'] = 'Lista oddzielonych przecinkami dozwolonych rozszerzeń plików grafiki kursu.';
$string['configcourseoverviewfileslimit'] = 'Maksymalna liczba plików, które mogą być wyświetlane obok podsumowania kursu na stronie z listą kursów. Pierwszy dodany plik obrazu jest używany jako obraz kursu w przeglądzie kursów w Kokpicie użytkowników; wszelkie dodatkowe pliki są wyświetlane tylko na stronie z listą kursów.';
$string['configcourserequestnotify'] = 'Wpisz użytkownika, który ma być powiadomiony, gdy nowy kurs jest zamówiony.';
$string['configcourserequestnotify2'] = 'Użytkownicy, którzy zostaną powiadomieni, gdy nowy kurs będzie zamówiony. Tylko użytkownicy, którzy mogą zatwierdzać zamówienia, są tutaj wymienieni.';
$string['configcoursesperpage'] = 'Podaj liczbę kursów, które mają być wyświetlone na stronę, na liście kursów.';
$string['configcourseswithsummarieslimit'] = 'Max. liczba kursów do wyświetlenia na liście kursów, włączając w to podsumowania przed wycofaniem się do prostszego wyświetlania.';
$string['configcronclionly'] = 'Jeśli zaznaczono, skrypt cron może być uruchamiany tylko z linii poleceń, a nie przez Internet. To ustawienie jest nadrzędne wobec  hasła cron poniżej.';
$string['configcronremotepassword'] = 'Oznacza to, że skryptu cron.php nie można uruchomić z poziomu przeglądarki internetowej bez podania hasła. Obowiązuje następująca składnia URL: <pre> http://site.example.com/admin/cron.php?password=naszeHaslo</pre> Jeśli pole jest puste, hasło nie jest wymagane.';
$string['configcurlcache'] = 'Czas ważności cache cURL w sekundach.';
$string['configcustommenuitems'] = 'Tutaj można skonfigurować menu niestandardowe. Wprowadź każdą pozycję menu w nowej linii w formacie: tekst menu, adres URL łącza (opcjonalnie, nie w przypadku pozycji menu głównego z podpozycjami), tytuł podpowiedzi (opcjonalnie) i kod języka lub listę kodów oddzielonych przecinkami (opcjonalnie, w celu wyświetlenia linii tylko użytkownikom określonego języka), oddzielone znakami kreski pionowej. Linie zaczynające się od myślnika pojawią się jako pozycje menu w poprzednim menu najwyższego poziomu, a ### tworzy separator. Na przykład:
<pre>
Kursy
-Wszystkie kursy|/course/
-Wyszukaj kursy|/course/search.php
-###
-FAQ|https://example.org/faq
-Preguntas más frecuentes|https://example.org/pmf||es
Aplikacja mobilna|https://example.org/app|Pobierz aplikację
</pre>';
$string['configcustomusermenuitems'] = 'Można skonfigurować zawartość menu użytkownika (z wyjątkiem linku wylogowania, który jest dodawany automatycznie). Każdy ciąg jest oddzielony pionową kreską i składa się z 1) ciągu w postaci „langstringname, componentname" lub jako zwykły tekst, 2) adresu URL i 3) ikony w postaci ikony pix (w folderze pix o strukturze [nazwa podfolderu] / [nazwa ikony], np. i/publish) lub jako adres URL. W razie potrzeby można w osobnej linni wstawić komentarz rozpoczynający się znakiem #.';
$string['configdbsessions'] = 'Jeśli to ustawienie zostanie zaznaczone – pozwoli użyć bazy danych do przechowywania informacji o aktualnej sesji. Jest to szczególnie użyteczne dla dużych / często odwiedzanych stron lub stron budowanych na klastrach serwerów. Dla większości stron powinno zostać to odznaczone, a wówczas używany będzie dysk serwera. Należy zauważyć, że zmiana tego ustawienia w danej chwili wyloguje wszystkich aktualnie zalogowanych użytkowników (włączając w to również Ciebie).';
$string['configdebug'] = 'Jeśli włączysz tę opcję, będzie pokazywanych więcej błędów w raporcie PHP. Opcja przydatna tylko dla programistów.';
$string['configdebugdisplay'] = 'Włączone oznacza, że raporty błędów trafią na strony HTML. Jest to praktyczne, ale zakłóca nagłówki XHTML, JS, cookies i HTTP w ogóle. Wyłączone wyśle raporty do logów serwera, umożliwiając lepsze debugowanie. Ustawienie PHP error_log wskazuje, do którego dziennika pójdą raporty.';
$string['configdebugpageinfo'] = 'Włącz, jeśli chcesz aby informacje o stronie były wyświetlane w stopce strony.';
$string['configdebugvalidators'] = 'Włącz, jeśli chcesz mieć w stopce strony linki do zewnętrznych walidatorów  Być może trzeba będzie utworzyć nowego użytkownika o nazwie <em>w3cvalidator</em> i włączyć dostęp gościa. Zmiany te mogą umożliwić nieautoryzowany dostęp do serwera, nie należy włączać na oficjalnych witrynach';
$string['configdefaulthomepage'] = 'To determinuje na jaką stronę powinien zostać przekierowany użytkownik po zalogowaniu się do serwisu? To ustawienie określa również pierwszy link w nawigacji dla użytkowników motywów opartych o motyw klasyczny.';
$string['configdefaultrequestcategory'] = 'Kursy zamówione przez użytkowników mających możliwość żądania nowych kursów w kontekście systemu i zostaną one umieszczone w tej kategorii, chyba że użytkownicy mają możliwość wybrania innej kategorii.';
$string['configdefaultrequestedcategory'] = 'Domyślna kategoria do umieszczania zamawianych kursów po ich zatwierdzeniu.';
$string['configdefaultuserroleid'] = 'Wszyscy zalogowani użytkownicy będą mieli uprawnienia roli, którą tu wymienisz na poziomie strony, DODATKOWO do innych ról, które mogą posiadać. Domyślną rolą jest \'Authenticated user\'. Zwróć uwagę, że nie będzie to wpływało negatywnie na inne role które posiadają użytkownicy, o ile nie stosujesz stanu Zabroń. Dzięki temu mamy gwarancję, że użytkownicy mają uprawnienia, których nie przydziela się na poziomie strony kursu (np. przeglądać forum dyskusyjne, zarządzać kalendarzem itd.).';
$string['configdeleteincompleteusers'] = 'Po tym okresie, konta bez wypełnionego imienia, nazwiska i adresu e-mail zostaną usunięte.';
$string['configdeleteunconfirmed'] = 'Jeśli używasz autentyfikacji przez email, jest to okres podczas, którego akceptowane będą potwierdzenia założenia konta. Po tym okresie niepotwierdzone konta zostaną usunięte.';
$string['configdenyemailaddresses'] = 'Aby zablokować adresy email z podanych domen należy wpisać je tutaj na listę. Jeśli chcesz zablokować wszystkie poddomeny poprzedź kropką całą domenę. Przykładowa lista: <strong>hotmail.com yahoo.co.uk .com.pl</strong> - zablokowane dwie domeny i wszystkie domeny z końcówką com.pl';
$string['configdisableuserimages'] = 'Wyłącz użytkownikom możliwość zmiany obrazków w profilu.';
$string['configdisplayloginfailures'] = 'Ta opcja pozwoli wyświetlać użytkownikom informacje o poprzednich nieudanych próbach logowania.';
$string['configdndallowtextandlinks'] = 'Włącza lub wyłącza przeciąganie i upuszczanie linku i tekstu na stronie kursu, obok przeciągania i upuszczania plików. Należy pamiętać, że przeciąganie tekstu do Firefoxa lub między różnymi przeglądarkami jest zawodne i może skutkować brakiem wgrania danych, lub wgrania uszkodzonego tekstu.';
$string['configdoclang'] = 'Ten język będzie używany w linkach do stron dokumentacji.';
$string['configdocroot'] = 'Tutaj możesz zdefiniować ścieżkę do własnej dokumentacji moodle. Pamiętaj jednak aby zachować ten sam układ ścieżek i plików jak w przypadku dokumentacji dostępnej pod adresem http://docs.moodle.org.';
$string['configdoctonewwindow'] = 'Jeżeli włączysz tę opcję, linki do dokumentacji Moodle będą wyświetlane w nowym oknie';
$string['configduration_high'] = 'Ta wartość jest zbyt wysoka. Maksymalna wartość to {$a}.';
$string['configduration_low'] = 'Ta wartość jest zbyt niska. Minimalna wartość to {$a}.';
$string['configeditordictionary'] = 'Ta wartość będzie użyta jeśli aspell nie posiada słownika dla języka użytkownika';
$string['configeditorfontlist'] = 'Wybierz czcionki które powinny pojawić się w liście rozwijanej edytora.';
$string['configemailchangeconfirmation'] = 'Wymagaj potwierdzenia jeśli użytkownik zmieni swój adres email w profilu.';
$string['configemaildkimselector'] = 'Sygnatura DKIM musi być zgodna z ustawioną dla domeny w DNS.';
$string['configemailfromvia'] = 'Dodaj informacje w sekcji "Od" wychodzących wiadomości e-mail, która informuje odbiorcę, skąd pochodzi ten e-mail, a także pomaga walczyć z przypadkowymi odpowiedziami na adresy e-mail no-reply.';
$string['configemailheaders'] = 'Nagłówki wiadomości e-mail, które mają być dodawane do wszystkich wychodzących wiadomości e-mail.';
$string['configemailsubjectprefix'] = 'Tekst, który ma poprzedzać określenie tematu poczty wychodzącej.';
$string['configenableanalytics'] = 'Modele analityczne, takie jak „Studenci zagrożeni przerwaniem nauki” lub „Nadchodzące zajęcia”, mogą generować prognozy, wysyłać powiadomienia i oferować dalsze działania, takie jak przesyłanie wiadomości użytkownikom.';
$string['configenableblogs'] = 'Ten przełącznik dostarcza wszystkim użytkownikom witryny możliwość prowadzenia własnego bloga.';
$string['configenablecalendarexport'] = 'Włącz eksport lub subskrypcję kalendarzy.';
$string['configenablecomments'] = 'Włącz komentarze';
$string['configenablecourserequests'] = 'Jeśli włączone, użytkownicy z możliwością żądania nowych kursów (moodle/course:request) będą mieli opcję żądania kursu. Ta możliwość nie jest dozwolona dla żadnej z domyślnych ról. Może być stosowana w kontekście całego systemu lub kategorii.';
$string['configenablemobilewebservice'] = 'Włącz usługę mobilną wykorzystywaną przez oficjalną aplikację Moodle lub innych aplikacji. Aby uzyskać więcej informacji, zapoznaj się z {$a}';
$string['configenablerssfeeds'] = 'Ta opcja zezwala na działanie RSS na całej stronie. Właściwie aby zauważyć jakiekolwiek zmiany należy zezwolić na RSS także w trybach indywidualnych – idź do ustawień Trybów pod Ustawienia Administratora';
$string['configenablerssfeedsdisabled'] = 'To jest niemożliwe ponieważ wiadomości RSS są wyłączone na tej platformie. Aby to zmienić zmień ustawienia zmiennych w Konfiguracji Administracji.';
$string['configenablerssfeedsdisabled2'] = 'Kanały RSS zostały wyłączone na poziomie serwera. Musisz włączyć je wcześniej w Administracja serwisu - Serwer - RSS.';
$string['configenablestats'] = 'Jeśli wybierzesz \'tak\', cronjob Moodle będzie nadzorował logowania i generował statystyki. W zależności od liczby operacji na Twojej stronie realizacja tej opcji może chwilę potrwać. Jeśli zezwolisz na to, będziesz mógł obserwować interesujące wykresy i statystyki o każdym z twoich kursów lub o wszystkich równocześnie';
$string['configenabletrusttext'] = 'Moodle domyślnie wyczyści tekst, który przychodzi od użytkowników, aby usunąć wszelkie możliwe złe skrypty, media itd. mogące stwarzać ryzyko naruszenia bezpieczeństwa. System Zaufanej Treści jest sposobem nadania konkretnym użytkownikom, że ufa się możliwości zawarcia tych zaawansowanych właściwości w ich zawartości bez ingerencji. Aby uaktywnić ten system, na początku należy włączyć to ustawienie, a następnie zezwolić na Zaufaną Zawartość dla konkretnej roli Moodle. Tekst stworzony i ładowany przez takich użytkowników będzie oznaczony jako zaufany i nie będzie czyszczony przed wyświetleniem.';
$string['configenablewebservices'] = 'Usługi sieci Web pozwalają innym systemom zalogować się do tego Moodle i wykonywać na nim operacje. Dla bezpieczeństwa ta funkcja powinna być wyłączona, chyba że naprawdę jej potrzebujesz.';
$string['configenablewsdocumentation'] = 'Włączyć automatyczne generowanie dokumentacji webserwisów. Użytkownik może uzyskać dostęp do własnej dokumentacji na stronie bezpiecznych kluczy {$a}. Wyświetli się  dokumentacja tylko dla włączonych protokołów .';
$string['configerrorlevel'] = 'Wybierz ile ostrzeżeń PHP ma być wyświetlanych. Zazwyczaj nejlepszy w tym miejscu wybór to \'Normal\'.';
$string['configexportlookahead'] = 'Ile dni naprzód przyjąć podczas eksportu';
$string['configexportlookback'] = 'Ile dni wstecz przyjąć podczas eksportu';
$string['configextendedusernamechars'] = 'Opcja pozwala na użycie dowolnych znaków w nazwie użytkownika. Domyślne ustawienie na \'nie\' ogranicza nazwy użytkowników do znaków alfanumerycznych, podkreślenia (_), myślnika (-), kropki (.) oraz symbolu małpy (@).';
$string['configextramemorylimit'] = 'Niektóre skrypty (wyszukujące, tworzące kopie zapasowe lub cron) wymagają więcej pamięci. Ustaw większe wartości dla dużych witryn.';
$string['configfilterall'] = 'Filtruj wszystkie ciągi znaków, włączając w to nagłówki, tytuły, przyciski nawigacji itp. Zazwyczaj użyteczne podczas używania filtrów multilang, należy zauważyć, iż powoduje nadmierne obciążenie strony, przy niewielkich korzyściach';
$string['configfiltermatchoneperpage'] = 'Automatyczne linkowanie tworzy jedynie pojedynczy link do pierwszego wystąpienia tekstu znalezionego na stronie. Wszystkie następne są ignorowane.';
$string['configfiltermatchonepertext'] = 'Filtry automatycznego łączenia będą jedynie tworzyły pojedynczy link do pierwszego pasującego przykładu tekstu, znalezionego w każdym punkcie tekstu (np. zasób, blok) na  stronie. Wszystkie pozostałe zostaną zignorowane. To ustawienie jest ignorowane jeśli jedno z ustawień na stronie zostało zaznaczone jako \'Tak\'';
$string['configfilternavigationwithsystemcontext'] = 'Normalne użycie filtrowania jest powiązane z kontekstem, w którym jest używane (np. kontekst kursu), ale w przypadku nawigacji w witrynie wyraźne filtrowanie wszystkiego z kontekstem witryny może przynieść poprawę wydajności podczas korzystania z filtrowania "Zawartość i nagłówki".';
$string['configfilteruploadedfiles'] = 'Przepuszczaj wszystkie załadowane pliki HTML i tekstowe przez filtry zanim je pokażesz. Tylko załadowane pliki HTML albo żadne.';
$string['configforcelogin'] = 'Normalnie strona główna i zestawienie kursów (lecz nie same kursy) mogą być przeglądane bez logowania się na stronę. Jeśli chcesz wymusić na odwiedzającym konieczność zalogowania się, zanim wykona on JAKĄKOLWIEK czynność na stronie, wówczas powinieneś zaznaczyć to ustawienie.';
$string['configforceloginforprofiles'] = 'Zaznaczenie tego ustawienia zmusza odwiedzającego do zalogowania się na konkretne konto (nie jako gość) zanim zostanie przekierowany do stron profilu użytkownika. Jeśli wyłączysz to ustawienie, może okazać się, że niektórzy użytkownicy wysyłają reklamy (spam) lub inne niedozwolone treści w ich profilach, co będzie widoczne dla "reszty świata",';
$string['configfrontpage'] = 'Wybrane powyżej elementy zostaną wyświetlone na stronie głównej serwisu.';
$string['configfrontpagecourselimit'] = 'Maksymalna liczba kursów';
$string['configfrontpagecourselimithelp'] = 'Maksymalna liczba kursów, które mają być wyświetlane na stronie głównej witryny w spisie kursów.';
$string['configfrontpageloggedin'] = 'Wybrane powyżej elementy zostaną wyświetlone na stronie głównej gdy użytkownik jest zalogowany.';
$string['configfullnamedisplay'] = 'Określa sposób wyświetlania nazw w całości. Wartość domyślna „language” pozostawia decyzję ciągowi „fullnamedisplay” w bieżącym pakiecie językowym. W niektórych językach obowiązują inne konwencje wyświetlania nazw.

W przypadku większości witryn jednojęzycznych najskuteczniejszym ustawieniem jest „imię i nazwisko”, ale możesz też całkowicie ukryć nazwiska. Wyrażenia zastępcze, których można użyć, to: firstname, lastname, firstnamephonetic, lastnamephonetic, middlename oraz alternatename.';
$string['configgeoipfile'] = 'Lokalizacja pliku danych binarnych GeoIP City. Ten plik nie jest częścią dystrybucji Moodle i musi zostać pobrany osobno z <a href="http://www.maxmind.com/">MaxMind</a>. Można kupić wersję komercyjną lub używać w wersji bezpłatnej. <br /> W tym celu należy się zarejestrować stronie i pobrać bazę City - <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/" >https://dev.maxmind.com/geoip/geoip2/geolite2/</a>, rozpakować plik i umieścić go w katalogu "{$a}" na serwerze.';
$string['configgetremoteaddrconf'] = 'Jeśli twój serwer jest za odwrotnym proxy, można użyć tego ustawienia, aby określić, które nagłówki HTTP zawierają poprawny zdalny adres IP. Nagłówki są czytane w kolejności, użyty będzie pierwszy dostępny.';
$string['configgradebookroles'] = 'Ustawienie umożliwia kontrolowanie kto pojawia się w dzienniku ocen. Użytkownicy muszą mieć co najmniej jedną z tych ról w kursie aby zostali wyświetleni w dzienniku ocen dla tego kursu.';
$string['configgradeexport'] = 'Które formaty eksportu dziennika ocen są podstawowymi metodami eksportowania ocen. Wybrane pluginy będą ustawiać i używać pola "ostatnio wyeksportowany" dla każdej oceny. W związku z tym wyeksportowane rekordy mogą być oznaczone jako "nowy" czy "aktualizowany". Jeśli nie jesteś pewien, nie zaznaczaj niczego.';
$string['configgradeexportdefault'] = 'Wybierz format eksportu dziennika ocen, który ma być domyślną metodą eksportowania ocen.';
$string['confighiddenuserfields'] = 'Wybierz które pola informacji o użytkowniku pragniesz ukryć przed innymi użytkownikami, nie będącymi nauczycielami/administratorami. Ustawienie to reguluje poziom ochrony prywatności uczniów. Trzymaj klawisz CTRL w celu zaznaczenia wielu pól';
$string['configidnumber'] = 'Ta opcja określa czy (a) Użytkownicy nie są w ogóle proszeni o podanie numeru identyfikacyjnego ID, (b) Użytkownicy są proszeni o podanie numeru identyfikacyjnego ID, lecz mogą pozostawić pole pustym, lub (c) Użytkownicy są proszeni o podanie numeru identyfikacyjnego ID i nie mogą pozostawić pola pustym. Podany numer identyfikacyjny ID zostanie wyświetlony w ich Profilu';
$string['configintro'] = 'Na tej stronie możesz określić liczbę zróżnicowanych konfiguracji, które pozwolą na prawidłową prace Moodle na Twoim serwerze. Nie należy się zbytnio tym przejmować – zazwyczaj ustawienia domyślne wystarczają w zupełności, a Ty zawsze możesz wrócić do tej strony później i zmienić te ustawienia';
$string['configintroadmin'] = 'Na tej stronie powinieneś skonfigurować  swoje główne konto administratora, które będzie zezwalało na całościowe kontrolowanie strony. Upewnij się, że podałeś bezpieczną nazwę użytkownika i hasło, jak również aktualny adres e-mail. W przyszłości możesz dodawać kolejne konta administratorów.';
$string['configintrosite'] = 'Ta strona pozwala na konfiguracje strony startowej i nazwę serwisu. Możesz wrócić później i zmienić te ustawienia używając menu administratora.';
$string['configiplookup'] = 'Po kliknięciu na adres IP (taki jak 34.12.222.93), taki jak w dzienniku zdarzeń, zostaje pokazana mapa z najlepszym trafieniem skąd może pochodzić dany adres IP. Istnieją różne pluginy z których można wybierać, każdy z nich ma swoje zalety i wady.';
$string['configkeeptagnamecase'] = 'Zaznacz, jeśli chcesz, aby w nazwach znaczników zachować wielkie-małe litery tak, jak wpisali je użytkownicy, którzy je stworzyli';
$string['configlang'] = 'Wybierz domyślny język dla całej strony. Użytkownicy mogą zmienić to ustawienie w menu języka lub profilu osobistym.';
$string['configlanglist'] = 'Jeśli pozostawisz puste, w menu języków zostaną wyświetlone wszystkie języki zainstalowane na stronie. Alternatywnie menu językowe można skrócić wpisując listę kodów języków oddzielonych przecinkami np.: en,de,fr. W razie potrzeby można określić inną nazwę języka niż nazwa pakietu językowego, stosując format: kod języka|nazwa języka, np.: en_kids|English, de_kids|Deutsch.';
$string['configlangmenu'] = 'Wybierz zezwalanie (lub nie) na wyświetlanie menu zasad językowych na stronie głównej, stronie logowania itd. Nie ogranicza to możliwości ustawienia przez użytkownika preferowanego języka w jego własnym profilu';
$string['configlangstringcache'] = 'Buforuje wszystkie stringi językowe w skompilowanych plikach w katalogu danych. Jeśli tłumaczysz Moodle lub zmieniasz ciągi w kodzie źródłowym Moodle, możesz tę opcję wyłączyć. W przeciwnym razie pozostaw ją, aby serwer szybciej działał.';
$string['configlatinexcelexport'] = 'Wybierz kodowanie dla eksportu do Excel-a';
$string['configlocale'] = 'Wybierz ustawienia regionalne dla całej witryny — spowoduje to zastąpienie języka i formatu dat we wszystkich pakietach językowych (choć nie ma to wpływu na nazwy dni w kalendarzu). Odpowiednią konfigurację regionalną musisz mieć zainstalowaną w swoim systemie operacyjnym (np. dla Linuksa en_US.UTF-8 lub es_ES.UTF-8). W większości przypadków pole to powinno pozostać puste.';
$string['configlockrequestcategory'] = 'Jeśli ta opcja jest włączona, użytkownicy z możliwością zamawiania nowych kursów w kontekście systemu nie będą mogli wybrać kategorii w formularzu zamawiania nowego kursu. Alternatywnym sposobem ograniczenia użytkowników do zamawiania nowego kursu tylko w jednej kategorii jest zastosowanie możliwości zamawiania nowych kursów w kontekście kategorii.';
$string['configloglifetime'] = 'To ustawienie określa przedział czasu , z jakiego zostaną zachowane logowania na stronie. Logowania które nie mieszczą się w zaznaczonym przedziale czasowym są automatycznie usuwane. Zalecane jest zachowywać logowania tak długo, jak to tylko możliwe, w przypadku gdybyś ich potrzebował, lecz jeśli posiadasz bardzo zajęty serwer i w przeszłości miałeś problemy z jego wydajnością, wówczas możesz być zainteresowany ograniczeniem interesującego Cię przedziału czasu.
Wartości mniejsze niż 30 nie są zalecane, ponieważ wówczas statystyki mogą nie działać poprawnie';
$string['configlookahead'] = 'Dni do Lookahead';
$string['configmailnewline'] = 'Znak nowej linii używany w wiadomościach e-mail. CRLF jest wymagany zgodnie z RFC 822bis, niektóre serwery pocztowe robią automatyczną konwersję z LF na CRLF, inne serwery błędnie konwertują z CRLF na CRCRLF, jeszcze inne odrzucają maile z osobnym LF (na przykład qmail). Spróbuj zmienić to ustawienie, jeśli masz problemy z niedostarczonych wiadomości e-mail lub podwójnymi znakami nowej linii .';
$string['configmaxbytes'] = 'To ustawienie określa maksymalną wielkość plików, które można załadować na całą stronę. To ustawienie jest ograniczane przez ustawienie PHP upload_max_filesize oraz ustawienie Appache LimitRequestBody. Po kolei, limity wielkości plików, zakres wielkości przy wyborze poziomu kursu lub poziomu modułu';
$string['configmaxconsecutiveidentchars'] = 'Hasło nie może mieć więcej niż podaną liczbę kolejnych identycznych znaków. Użyj 0 aby wyłączyć tę opcję.';
$string['configmaxeditingtime'] = 'Ten parametr określa, ile czasu jest przeznaczone na ponowną edycję wpisów na forum, w słowniku pojęć itp. Zazwyczaj 30 minut jest dobrą wartością.';
$string['configmaxevents'] = 'Maksymalna liczba nadchodzących wydarzeń';
$string['configmaxusersperpage'] = 'Max. liczba użytkowników wyświetlanych w selektorze użytkowników  w kursie, grupie, kohorcie, usług sieciowych, itd.';
$string['configmessaging'] = 'Czy przesyłanie wiadomości między użytkownikami ma być włączone?';
$string['configmessagingallowemailoverride'] = 'Zezwalaj użytkownikom na przesyłanie powiadomień na inny adres e-mail niż podany w profilu użytkownika';
$string['configmessagingallusers'] = 'Jeśli ta opcja jest włączona, użytkownicy mogą wyświetlać listę wszystkich użytkowników witryny, podczas wybierania osoby, do której chce się wysłać wiadomość (jeśli preferencje użytkownika obejmuje opcję akceptowania wiadomości od wszystkich w witrynie)
Jeśli ta opcja jest wyłączona, użytkownicy mogą tylko wyświetlać listę użytkowników w swoich kursach i mają tylko dwie opcje w preferencjach wiadomości — akceptować wiadomości tylko od swoich kontaktów lub od swoich kontaktów i wszystkich osób na swoich kursach.';
$string['configmessagingdefaultpressenter'] = 'Opcja „Użyj entera, aby wysłać” jest domyślnie włączona w ustawieniach wiadomości użytkowników.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Powiadomienia o przeczytaniu i nieprzeczytaniu wiadomości można usunąć, aby zaoszczędzić miejsce. Jak długo po utworzeniu powiadomienia można je usunąć?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Przeczytane powiadomienia mogą być usunięte w celu zaoszczędzenia miejsca. Po jakim czasie od przeczytania można je usunąć?';
$string['configminpassworddigits'] = 'Hasło musi zawierać conajmniej tyle cyfr.';
$string['configminpasswordlength'] = 'Hasło musi być conajmniej tak długie.';
$string['configminpasswordlower'] = 'Hasło musi zawierać conajmniej tyle małych liter.';
$string['configminpasswordnonalphanum'] = 'Hasło musi zawierać conajmniej tyle znaków nie znajdujących się w alfabecie.';
$string['configminpasswordupper'] = 'Hasło musi zawierać conajmniej tyle wielkich liter.';
$string['configmypagelocked'] = 'To ustawienie zapobiega edycji strony głównej przez nie-adminów';
$string['confignavcourselimit'] = 'Ogranicza liczbę kursów wyświetlanych użytkownikowi w nawigacji.';
$string['confignavshowallcourses'] = 'Jeśli opcja jest włączona, użytkownicy zobaczą kursy, do których są zapisani  zarówno w gałęzi Moje kursy jak i kursu w menu Nawigacja. Jeśli opcja jest wyłączona, użytkownicy zapisani będą widzieć tylko gałąź Moje kursy. Liczba wyświetlanych kursów nadal będzie ograniczona przez pole "(navcourselimit)", gdy użytkownik nie jest zalogowany lub nie jest zapisany na jakikolwiek kurs.';
$string['confignavshowcategories'] = 'Pokaż kategorie w menu Nawigacja. Kursy, do których użytkownik jest aktualnie zapisany, będą wyświetlane w gałęzi Moje kursy bez kategorii.';
$string['confignoreplyaddress'] = 'Emaile są czasami wysyłane w imieniu użytkownika (na przykład w obszarze forum). Adres e-mail który tutaj wpiszesz będzie używany jako adres "Wyjścia" w przypadkach gdy odbiorca nie powinien posiadać możliwości bezpośredniej odpowiedzi na konto użytkownika (na przykład gdy użytkownik wybierze opcję prywatności swojego adresu)';
$string['confignotifyloginfailures'] = 'Jeśli błędy logowania zostały zapisane mogą być wysłane e-maile powiadamiające o tym. Kto powinien mieć dostęp do tych powiadomień.”';
$string['confignotifyloginthreshold'] = 'Jeśli powiadomienia o błędnych loginach są aktywne, ile błędnych prób logowania przez jednego użytkownika lub jeden adres IP warto zachowywać';
$string['confignotloggedinroleid'] = 'Użytkownicy nie zalogowani na stronie będą mieli tę rolę zagwarantowaną w kontekście strony. W większości przypadków gość jest najbardziej pożądany, ale można chcieć utworzyć role które będą mniej lub bardziej ograniczone. Takie działania jak dodawanie komentarzy nadal wymagają żeby użytkownik był zalogowany.';
$string['configopentowebcrawlers'] = 'Jeśli włączysz to ustawienie Google będzie mogło wejść do twojego serwisu jako Gość. Ponadto osoby wchodzące na swój serwis z użyciem linków znalezionych na Google będą automatycznie logowani jako goście. Pamiętaj, że dostęp do kursów będzie możliwy tylko wtedy gdy w poszczególnych kursach jest włączona dostęp dla gości.';
$string['configoverride'] = 'Zdefiniowane w pliku config.php';
$string['configpasswordpolicy'] = 'Włączenie tej opcji spowoduje, że Moodle będzie sprawdzał hasła użytkowników pod kątem zgodności z polityką haseł. Użyj ustawień poniżej by zdefiniować tę politykę. Ustawienia zostaną zignorowane jeśli ustawisz tę opcję na \'nie\'';
$string['configpasswordpolicycheckonlogin'] = 'Jeśli ta opcja jest włączona, hasła użytkowników będą sprawdzane zgodnie z polityką haseł za każdym razem, gdy użytkownicy się logują. Jeśli sprawdzenie się nie powiedzie, użytkownik będzie musiał zmienić swoje hasło przed kontynuowaniem.
Warto włączyć to ustawienie po zaktualizowaniu zasad haseł.';
$string['configpasswordresettime'] = 'Określa ilość czasu potrzebnego ludziom na potwierdzenie prośby o zresetowanie hasła przed jego wygaśnięciem. Zazwyczaj 30 min. jest optymalną wartością.';
$string['configpathtodu'] = 'Ścieżka do programu du (najczęściej jest to /usr/bin/du). Jeśli podasz w tym miejscu ścieżkę do tego programu wtedy wyświetlanie zawartości katalogów z dużą liczbą plików będzie wykonywane szybciej.';
$string['configpathtophp'] = 'Ścieżka do interfejsu wiersza polecenia PHP (prawdopodobnie /usr/bin/php). Jeśli wprowadzona, skrypty crona mogą być uruchamiane z interfejsu sieciowego administratora.';
$string['configperfdebug'] = 'Jeśli włączysz tę opcję, w stopce stron standardowej kompozycji wyświetlana będzie informacja o wydajności.';
$string['configprofileroles'] = 'Lista ról, które są widoczne na stronie profilu użytkownika i uczestników.
';
$string['configprofilesforenrolledusersonly'] = 'Aby zablokować treści wpisywane przez  spamerów do opisów w automatycznie tworzonych profilach przez spamboty, opis w profilu jest zablokowany (niewidoczny) do czasu, użytkownik ten zapisze się do co najmniej jednego kursu.';
$string['configprotectusernames'] = 'Domyślnie forget_password.php, dotyczące zapomnianego hasła, nie wyświetla żadnych wskazówek które pozwoliłyby na odgadnięcie nazwy użytkownika lub adresu poczty elektronicznej.';
$string['configproxybypass'] = 'Lista oddzielonych przecinkami (częściowych) nazw hostów lub adresów IP, która powinna omijać proxy (np.: 192.168., .mojadomena.com)';
$string['configproxyhost'] = 'Jeśli ten <b>serwer</b> używa serwera proxy żeby dostac sie do Internetu wprowadź tutaj nazwę i port serwera proxy. Inaczej pozostaw puste.';
$string['configproxylogunsafe_help'] = 'To ustawienie próbuje logować połączenia wewnętrzne, które nie przechodzą przez serwer proxy, a powinny.';
$string['configproxypassword'] = 'Hasło potrzebne do uzyskania dostępu do Internetu za pośrednictwem serwera proxy. Pozostaw puste, jeżeli hasło nie jest wymagane (rozszerzenie PHP cURL jest wymagane).';
$string['configproxyport'] = 'Jeżeli ten serwer wymaga wykorzystania komputera proxy, proszę o wprowadzenie portu proxy w tym miejscu.';
$string['configproxytype'] = 'Typ proxy (PHP5 i rozszerzenie cURL wymagane dla obsługi SOCKS5).';
$string['configproxyuser'] = 'Nazwa użytkownika potrzebne do uzyskania dostępu do Internetu za pośrednictwem serwera proxy. Pozostaw puste, jeżeli nie jest wymagana (rozszerzenie PHP cURL jest wymagane).';
$string['configrecaptchaprivatekey'] = 'Ciąg znaków używany do komunikacji między serwerem Moodle a serwerem reCAPTCHA. Uzyskaj go dla tej witryny, odwiedzając http://www.google.com/recaptcha';
$string['configrecaptchapublickey'] = 'Ciąg znaków używany do wyświetlania elementu reCAPTCHA w formularzu rejestracji. Generowany przez http://www.google.com/recaptcha';
$string['configrequestedstudentname'] = 'Słowo definiujące studenta w kursach';
$string['configrequestedstudentsname'] = 'Słowo definiujące studentów w kursach';
$string['configrequestedteachername'] = 'Słowo definiujące nauczyciela w kursach';
$string['configrequestedteachersname'] = 'Słowo definiujące nauczycieli w kursach';
$string['configreverseproxyignore'] = 'Jeśli twój serwer znajduje się za wieloma odwrotnymi serwerami proxy (reverse proxy), które dołączają do nagłówka X-Forwarded-For, należy określić oddzieloną przecinkami listę adresów IP lub podsieci odwrotnych serwerów proxy, które mają być ignorowane w celu znalezienia prawidłowego adresu IP użytkownika.';
$string['configsectioninterface'] = 'Interfejs';
$string['configsectionmail'] = 'poczta';
$string['configsectionmaintenance'] = 'Utrzymywanie (konserwacja)';
$string['configsectionmisc'] = 'Różne (Miscellaneous)';
$string['configsectionoperatingsystem'] = 'System operacyjny';
$string['configsectionpermissions'] = 'Uprawnienia';
$string['configsectionrequestedcourse'] = 'Żądania utworzenia kursów';
$string['configsectionsecurity'] = 'bezpieczeństwo';
$string['configsectionstats'] = 'Statystyki';
$string['configsectionuser'] = 'Użytkownik';
$string['configsecureforms'] = 'Moodle może używać dodatkowego poziomu zabezpieczeń podczas akceptowania danych pochodzących z różnych postaci stron web. Jeśli jest to zaznaczone ,wówczas parametr HTTP REFERER przeglądarki jest dodatkowo weryfikowany. W niektórych przypadkach może rodzić to problemy, jeśli użytkownik używa firewall’a (na przykład Zonealarm) skonfigurowanego na usuwanie HTTP REFERER z odwiedzanych stron web. Objawia się to \'zablokowaniem\'. Jeśli twoim użytkownicy mają problemy ze stroną logowania (na przykład) możesz chcieć odznaczyć to ustawienie, mimo iż, spowoduje to większą wrażliwość Twojej strony na prymitywne ataki hasłowe. Jeśli nie jesteś pewien pozostaw to ustawienie zaznaczone jako \'Tak\'';
$string['configservicespage'] = 'Wprowadź adres URL strony usług i wsparcia lub pozostaw puste, aby połączyć się z usługami Moodle na moodle.com. Link jest wyświetlany tylko dla administratorów witryny.';
$string['configsessioncookie'] = 'To ustawienie określa nazwę cookie używanego dla sesji Moodle. Jest to ustawienie opcjonalne, i użyteczne jedynie w celu unikania komplikujących cookies podczas uruchomienia kilku kopii Moodle działających w obrębie tej samej strony web';
$string['configsessioncookiedomain'] = 'To pozwala zmienić domenę, z której  ciasteczka Moodle są dostępne. Jest to przydatne przy dostosowywaniu Moodle (np. wtyczki uwierzytelniania lub zapisów), kiedy trzeba udostępniać informacje o sesji Moodle innej aplikacji internetowej w innej subdomenie. <strong>UWAGA: Zdecydowanie zaleca się, aby pozostawić ustawienie domyślne (puste) - nieprawidłowa wartość zablokuje możliwość logowania się do serwisu.</strong>';
$string['configsessioncookiepath'] = 'Jeśli musisz zmienić miejsce do którego przeglądarki przesyłają "ciasteczka" Moodle, możesz zmienić to ustawienie określając podkatalog twojej witryny (może lepiej: serwera). W przeciwnym przypadku domyślna wartość "/" powinna działać prawidłowo';
$string['configsessiontimeout'] = 'Jeśli użytkownicy zalogowani na tą stronę są bezczynni przez dłuższy czas (bez ładowania stron), są automatycznie wylogowywani (ich sesja zostaje zakończona). Ten parametr określa w/w przedział czasu.';
$string['configsessiontimeoutwarning'] = 'Jeśli osoby zalogowane na tej stronie są bezczynne przez dłuższy czas (bez wczytywania stron), zostaną ostrzeżone, że ich sesja niedługo się skończy. Ta zmienna określa, jak długi powinien być ten czas.';
$string['configsessiontimeoutwarningcheck'] = 'Ostrzeżenie o przekroczeniu limitu czasu sesji musi być mniejsze niż limit czasu sesji';
$string['configshowcommentscount'] = 'Pokaż liczbę komentarzy. Wywoła to jedną więcej kwerendę podczas wyświetlania linków komentarzy.';
$string['configshowicalsource'] = 'Pokazuje informacje źródłowe dla zdarzeń iCal';
$string['configshowsiteparticipantslist'] = 'Wszyscy z tych studentów i nauczycieli będą zapisani w zestawieniu uczestników. Kto powinien mieć dostęp do tego zestawienia?';
$string['configsitedefaultlicense'] = 'Domyślna strona licencji';
$string['configsitedefaultlicensehelp'] = 'Domyślna licencja dla publikowania treści na tej stronie';
$string['configsitemailcharset'] = 'Wszystkie e-maile wysyłane z tej strony będą kodowane w sposób zdefiniowany tutaj. Ale każdy użytkownik będzie mógł dostosować to jeżeli uaktywni się następne pole.';
$string['configsitemaxcategorydepth'] = 'Maksymalna głębokość kategorii';
$string['configsitemaxcategorydepthhelp'] = 'Określa maksymalną głębokość podkategorii rozwiniętych podczas wyświetlania kategorii lub listy kombi. Kategorie głębszego poziomu pojawią się jako linki, a użytkownik będzie mógł je rozwinąć za pomocą żądania AJAX.';
$string['configslasharguments'] = 'Pliki (obrazy, załadowane pliki, itd.) są dostarczane poprzez skrypt używający ‘slash arguments’ (argumenty po ukośniku). Ta metoda pozwala na łatwiejsze używanie pamięci podręcznej przez przeglądarkę, serwery proxy itd. Niestety niektóre serwery PHP nie dopuszczają takiej metody, a więc jeśli masz problemy z przeglądaniem wgrywanych plików lub obrazów (np. zdjęć użytkowników), ustaw ten parametr na opcję pierwszą.';
$string['configsmtpauthtype'] = 'To ustawia typ uwierzytelniania na serwerze smtp.';
$string['configsmtphosts'] = 'Nadaj pełną nazwę jednemu lub większej liczbie lokalnych serwerów SMTP, które będą używane przez Moodle do wysłania maili (np. \'mail.a.com\' or \'mail.a.com;mail.b.com\'). Jeśli pozostawisz to miejsce pustym Moodle będzie używać domyślnej metody PHP do wysyłania maili';
$string['configsmtpmaxbulk'] = 'Maksymalna liczba wiadomości wysyłanych przez sesję SMTP. Grupowanie wiadomości może przyspieszyć wysyłanie wiadomości email. Wartość poniżej 2 wymusi tworzenie nowej sesji SMTP dla każdego email-a.';
$string['configsmtpoauthservice'] = 'Wybierz usługę OAuth 2 skonfigurowaną do komunikacji z serwerem SMTP. Jeśli usługa jeszcze nie istnieje, konieczne będzie jej utworzenie. Pamiętaj, że musisz ustawić typ uwierzytelniania SMTP na XOAUTH2.';
$string['configsmtpsecure'] = 'Jeżeli serwer SMTP wymaga bezpiecznego połączenia, należy określić właściwy typ protokołu.';
$string['configsmtpuser'] = 'Jeśli ustawiłeś serwer SMTP powyżej i serwer wymaga uwierzytelnienia, wpisz tutaj nazwę konta i hasło.';
$string['configstartwday'] = 'Początek tygodnia';
$string['configstatsfirstrun'] = 'To ustawienie określa jak odległe w czasie logowania powinny być zachowywane <b> pierwszy czas </b> w celu tworzenia statystyk przetwarzania. Jeśli zauważasz duży ruch na stronie i masz dzielone łącze, prawdopodobnie nie będzie dobrym rozwiązaniem ustawianie zbyt dużego przedziału czasowego, ponieważ może potrzebować na to zbyt długiego czasu i nazbyt obciążać dane źródłowe. (Należy zwrócić uwagę, iż dlatego ustawienia 1 miesiąc=28 dni. Na wykresach i generowanych raportach 1 miesiąc=1 miesiąc kalendarzowy.)';
$string['configstatsmaxruntime'] = 'Proces generowania statystyk może być dość intensywny, w celu jego ograniczenia użyj kombinacji tego pola i następnego do określenia kiedy statystyki mają być realizowane i przez jaki czas.';
$string['configstatsmaxruntime2'] = 'Przetwarzanie statystyk może być dość intensywny, określenie max. czasu pozwala na zbieranie statystyk w jednym dniu. Max. liczba dni przetwarzania w jednym wykonywaniu cron to 31.';
$string['configstatsmaxruntime3'] = 'Określ maksymalny dozwolony czas na obliczanie statystyk z jednego dnia pamiętając, że przetwarzanie statystyk bardzo obciąża serwer. Maksymalna liczba dni przetwarzanych w jednym wywołaniu cron jest określona poniżej.';
$string['configstatsruntimedays'] = 'Określa maksymalną liczbę dni przetwarzanych w każdej sesji obliczania statystyki. Kiedy statystyki są aktualne, tylko jeden dzień będzie przetwarzany. Można zmienić tę wartość w zależności od obciążenia serwera. Skróć okres, jeśli zależy ci na krótszych czasach wykonania crona';
$string['configstatsruntimestart'] = 'O której godzinie cronjob powinien rozpocząć proces generowania statystyk?
Proszę określić różne godziny, jeśli masz wiele witryn Moodle na jednym serwerze fizycznym.';
$string['configstatsuserthreshold'] = 'To ustawienie określa minimalną liczbę użytkowników zapisanych na kurs, aby był on ujęty w statystykach.';
$string['configstrictformsrequired'] = 'Jeśli opcja jest włączona, w wymaganych polach w formularzach nie wystarczy wprowadzić samej spacji lub tylko białych znaków.';
$string['configstripalltitletags'] = 'Odznacz to ustawienie by zezwolić na kod HTML w aktywnościach i nazwach zasobów.';
$string['configsupportavailability'] = 'To ustawienie określa, kto ma dostęp do strony pomocy technicznej ze stopki.';
$string['configsupportemail'] = 'Ten adres e-mail będzie widoczny dla użytkowników serwisu jako e-mail pomocy technicznej (na przykład, kiedy nowy użytkownik założy konto w serwisie). W przypadku pozostawienia pustego pola taki przydatny e-mail nie będzie dostępny dla użytkowników.';
$string['configsupportname'] = 'Imię osoby lub działu oferującego pomoc techniczną przez e-mail lub stronę internetową.';
$string['configsupportpage'] = 'Wpisz adres URL strony pomocy technicznej lub pozostaw puste, aby utworzyć łącze do formularza kontaktowego. Link wyświetlany jest w stopce serwisu.';
$string['configtempdatafoldercleanup'] = 'Usuń tymczasowe pliki z katalogu danych, które są starsze niż zaznaczony czas.';
$string['configthemedesignermode'] = 'Normalnie wszystkie obrazy motywu graficznego i arkusze stylów są buforowane w przeglądarkach i na serwerze przez bardzo długi czas, w związku z wydajnością. W przypadku projektowania motywów lub pisania kodu lepiej będzie włączyć ten tryb, aby nie korzystać ze zbuforowanej wersji. Ostrzeżenie: wtedy witryna będzie działać wolniej dla wszystkich użytkowników! Alternatywnie można również wyczyścić pamięć podręczną motywu ręcznie na stronie \'Wyboru kompozycji\'.';
$string['configthemelist'] = 'Pozostaw to pole puste jeśli chcesz zezwolić na używanie dowolnej kompozycji. Jeśli chcesz zawęzić listę dostępnych kompozycji możesz wpisać tutaj nazwy dostępnych kompozycji oddzielając je przecinkiem (Nie używaj spacji!). Na przykład: standard,orangewhite.';
$string['configtimezone'] = 'Domyślna strefa czasowa wyświetlania dat. Każdy użytkownik może zmienić to ustawienie w swoim profilu. Zadania Cron i inne ustawienia serwera są określone w tej strefie czasowej. Powinieneś zmienić to ustawienie, jeśli wyświetla się jako „Nieprawidłowa strefa czasowa”';
$string['configuseblogassociations'] = 'Czy użytkownicy powinni być w stanie kojarzyć wpisy na swoich blogach z kursami i modułami kursu?';
$string['configusesitenameforsitepages'] = 'Jeśli opcja jest włączona, odpowiednia gałąź menu Nawigacja zamiast nazwy \'Strony\' będzie wyświetlała krótką nazwę witryny.';
$string['configusetags'] = 'Czy funkcjonalność tagów ma być włączona w całym serwisie?';
$string['configvariables'] = 'Zmienne';
$string['configverifychangedemail'] = 'Umożliwia weryfikację adresów e-mail po ich zmianie poprzez sprawdzenie listy dopuszczalnych i zabronionych domen. Jeśli ta opcja jest wyłączona, domeny są tak weryfikowane tylko w przypadku tworzenia nowych użytkowników.';
$string['configvisiblecourses'] = 'Wyświetlaj kursy w ukrytych kategoriach normalnie';
$string['configwarning'] = 'Bądź ostrożny zmieniając te ustawienia - błędne wartości mogą powodować problemy.';
$string['configyuicomboloading'] = 'Ta opcja pozwala na optymalizację ładowania plików bibliotek YUI. To ustawienie powinno być włączone na witrynach produkcyjnych ze względu na wydajność.';
$string['confirmation'] = 'Potwierdzenie';
$string['confirmationpending'] = 'Oczekiwanie na potwierdzenie';
$string['confirmcontextlock'] = '{$a->contextname} jest obecnie odblokowany. Zablokowanie sprawi, że kontekst będzie tylko do odczytu i uniemożliwi użytkownikom wprowadzanie zmian. Czy na pewno chcesz kontynuować?';
$string['confirmcontextunlock'] = '{$a->contextname} jest obecnie zablokowany. Odblokowanie pozwoli użytkownikom na wprowadzanie zmian. Czy na pewno chcesz kontynuować?';
$string['confirmdeletecomments'] = 'Czy na pewno chcesz usunąć zaznaczony(e) komentarz(e)?';
$string['confirmed'] = 'Potwierdzone';
$string['contactsitesupport'] = 'Skontaktuj się z pomocą techniczną';
$string['contenttypeuninstalling'] = 'Istnieje {$a->count} treści obsługiwanych przez {$a->type}. Zostaną one usunięte. Czy chcesz kontynuować?';
$string['contextlockappliestoadmin'] = 'Blokowanie zawartości dotyczy administratorów';
$string['contextlockappliestoadmin_desc'] = 'Jeśli ta opcja jest wyłączona, administratorzy mają dostęp do zapisu we wszystkich zablokowanych elementach.';
$string['contextlocking'] = 'Blokowanie zawartości';
$string['contextlocking_desc'] = 'To ustawienie włącza dostęp tylko do odczytu dla wybranych kategorii, kursów, aktywności lub bloków.';
$string['cookiesecure'] = 'Tylko bezpieczne ciasteczka';
$string['country'] = 'Domyślny kraj';
$string['course_customfield'] = 'Pola niestandardowe kursu';
$string['coursecolor'] = 'Kolor {$a}';
$string['coursecolorheading_desc'] = 'Wszystkie kursy bez ustawionego obrazu w ustawieniach kursu są wyświetlane na pulpicie nawigacyjnym z losowym wzorem na karcie kursu. Kolory użyte we wzorze można określić poniżej.';
$string['coursecolorsettings'] = 'Kolory kart kursu';
$string['coursecontact'] = 'Zarządzanie kursem';
$string['coursecontact_desc'] = 'To ustawienie pozwala na kontrolowanie kto jest wyświetlany w opisie kursu.';
$string['coursecontactduplicates'] = 'Wyświetl w kontaktach kursowych wszystkie role osób';
$string['coursecontactduplicates_desc'] = 'Włączenie tej opcji powoduje, że użytkownicy z więcej niż jedną wybraną rolą osoby kontaktowej w ramach kursu będą wyświetlani w opisie kursu wraz z każdą z ich ról. W przeciwnym razie będą wyświetlane z tylko jedną rolą (w zależności od tego, która z tych ról znajduje się najwyżej w sekcji „Zdefiniuj role” w administracji witryny).';
$string['coursecreationguide'] = 'Adres URL przewodnika tworzenia kursów Moodle';
$string['coursecreationguide_help'] = 'Określa ścieżkę do przewodnika tworzenia kursów Moodle z krótkimi filmami i ogólnymi wskazówkami dotyczącymi tworzenia kursów. Link do przewodnika jest wyświetlany na stronie Moje kursy, gdy nie ma żadnych kursów do pokazania. Tylko użytkownicy z możliwością tworzenia kursów zobaczą ten link.';
$string['coursegraceperiodafter'] = 'Okres karencji dla zakończonych kursów';
$string['coursegraceperiodbefore'] = 'Okres karencji dla przyszłych kursów';
$string['courselistshortnames'] = 'Wyświetl rozszerzone nazwy kursów (krótkie+pełne)';
$string['courselistshortnames_desc'] = 'Podczas wyświetlania listy kursów i na ekranach administracji, wyświetlaj zarówno Skrócone nazwy kursu, jak Pełne nazwy. W rzeczywistości, po włączeniu tego ustawienia, używany jest ciąg \'courseextendednamedisplay\', więc można go zmieniać za pomocą dostosowania języka.';
$string['coursemgmt'] = 'Zarządzaj kursami i kategoriami';
$string['courseoverview'] = 'Przegląd kursów';
$string['courserequestnotify'] = 'Zgłaszanie zapotrzebowania na kursy';
$string['courserequestnotifyemail'] = '<p>Użytkownik {$a->user} poprosił o nowy kurs.</br>
Możesz przejrzeć prośbę w sekcji <a href="{$a->link}">Kursy oczekujące na zatwierdzenie</a>.</p>
<p>Szczegóły prośby:</p>
<ul>
<li>Pełna nazwa kursu: {$a->fullname</li>
<li>Skrócona nazwa kursu: {$a->shortname</li>
<li>Kategoria: {$a->category</li>
<li>Powód prośby o kurs: {$a->reason</li>
</ul>';
$string['courserequests'] = 'Zamówienia kursów';
$string['courserequestspending'] = 'Żądania oczekujących kursów';
$string['courses'] = 'Kursy';
$string['coursesperpage'] = 'Liczba kursów co stronę';
$string['courseswithsummarieslimit'] = 'Kursy z limitem podsumowania';
$string['creatornewroleid'] = 'Rola Kreatora w nowych kursach';
$string['creatornewroleid_help'] = 'Jeśli użytkownik nie ma jeszcze uprawnień do zarządzania nowym kursem, jest on automatycznie zapisywany z wykorzystaniem tej roli.';
$string['cron'] = 'Cron';
$string['cron_enabled'] = 'Włącz cron';
$string['cron_enabled_desc'] = 'Cron zazwyczaj powinien być włączony, jednak to ustawienie pozwala na tymczasowe jego wyłączenie, na przykład przed restartem serwera. Jeśli jest wyłączony, system nie może uruchamiać nowych zadań w tle. Zwróć uwagę, że cron nie powinien być wyłączany przez długi czas, ponieważ uniemożliwi to działanie ważnych funkcji.';
$string['cron_help'] = 'Skrypt cron.php uruchamia szereg zaplanowanych zadań, takich jak wysyłanie wiadomości e-mail z powiadomieniami na forum, w różnych odstępach czasu. Skrypt powinien być uruchamiany regularnie - najlepiej co minutę.';
$string['cron_keepalive'] = 'Podtrzymaj';
$string['cron_keepalive_desc'] = 'Czas trwania odpytywania o dodatkowe zadania. To ustawienie zapewnia, że cron będzie zawsze uruchomiony. Jeśli używasz dedykowanych programów uruchamiających zadania, ustaw wartość na 0. W przeciwnym razie ustaw wartość podobną do limitu współbieżnych zadania adhoc. Unikaj dłuższych czasów. Maksymalny czas to 15 minut.';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'Ustaw uruchamianie Cron-a tylko z linii poleceń';
$string['cronerrorclionly'] = 'Niestety, dostęp z internetu do tej strony został zablokowany przez administratora.';
$string['cronerrorpassword'] = 'Niestety, nie podałeś poprawnego hasła by uzyskać dostęp do tej strony.';
$string['croninfrequent'] = 'Pomiędzy dwoma ostatnimi uruchomieniami skryptu konserwacyjnego cron upłynęło {$a->actual} i powinien on być uruchamiany co {$a->expected}. Zalecamy skonfigurowanie go tak, aby działał częściej.';
$string['cronremotepassword'] = 'Hasło dla zdalnego dostępu do Cron-a';
$string['cronwarning'] = 'Skrypt <a href="{$a->url}">admin/cron.php script</a> nie był uruchamiany od {$a->actual}, a powinien być uruchamiany co {$a->expected}.';
$string['cronwarningcli'] = 'Skrypt <code>admin/cli/cron.php</code> nie był uruchamiany od {$a->actual}, a powinien być uruchamiany co {$a->expected}.';
$string['cronwarningnever'] = 'Skrypt <code>admin/cli/cron.php</code> nigdy nie został uruchomiony, a powinien być uruchamiany co {$a->expected}.';
$string['cronwarningneverweb'] = 'Skrypt <a href="{$a->url}">admin/cron.php script</a> nigdy nie został uruchomiony, a powinien być uruchamiany co {$a->expected}.';
$string['ctyperequired'] = 'Rozszerzenie PHP ctype jest teraz wymagane przez Moodle w celu zwiększenia wydajności witryny i dla kompatybilności z wieloma językami.';
$string['curlcache'] = '"Czas życia" cache cURL';
$string['curlrequired'] = 'Rozszerzenie PHP cURL jest teraz wymagane przez Moodle, w celu komunikowania się z repozytoriami Moodle.';
$string['curlsecurityallowedport'] = 'Lista dozwolonych portów cURL';
$string['curlsecurityallowedportsyntax'] = 'Lista numerów portów, z którymi cURL może się połączyć. Poprawne wpisy to tylko liczby całkowite. Umieść każdą pozycję w nowej linii. Jeśli pozostawisz puste, wszystkie porty są dozwolone. Jeśli ustawisz je, w niemal wszystkich przypadkach, dla cURL należy podać porty zarówno 443, jak i 80, aby połączyć się z standardowymi portami HTTPS i HTTP.';
$string['curlsecurityblockedhosts'] = 'Lista zablokowanych hostów cURL';
$string['curlsecurityblockedhostssyntax'] = 'Umieść każdą pozycję w nowej linii. Ważnymi wpisami są pełne adresy IPv4 lub IPv6 (takie jak 192.168.10.1, 0: 0: 0: 0: 0: 0: 0: 0: 1, :: 1, fe80: :), które pasują do pojedynczego hosta; lub notacji CIDR (np. 231.54.211.0/20 lub fe80 :: / 64); lub zakresu adresów IP (takich jak 231.3.56.10-20 lub fe80 :: 1111-bbbb), w których zakres dotyczy ostatniej grupy adresu; lub nazw domen (takich jak localhost lub example.com); Lub nazw domen (np. * .example.com lub *sub.example.com). Puste linie nie są
dozwolone.';
$string['curlsecurityurlblocked'] = 'Adres URL jest zablokowany.';
$string['curltimeoutkbitrate'] = 'Bitrate używany przy obliczaniu limitów czasu cURL (kbps)';
$string['curltimeoutkbitrate_help'] = 'Ten parametr jest używany do obliczenia odpowiedniego limitu czasu podczas długotrwałych żądań cURL. W ramach tego obliczenia wysyłane jest żądanie HEAD HTTP w celu określenia rozmiaru zawartości. Ustawienie tej opcji na 0 wyłącza to żądanie.';
$string['currenttheme'] = 'Obecny motyw graficzny';
$string['customcheck'] = 'Inne kontrole';
$string['custommenu'] = 'Niestandardowe menu';
$string['custommenuitems'] = 'Elementy niestandardowego menu';
$string['customusermenuitems'] = 'Pozycja menu użytkownika';
$string['datarootsecurityerror'] = '<p><strong>OSTRZEŻENIE: LUKA BEZPIECZEŃSTWA!</strong></p><p>Twój główny katalog danych umieszczony jest w złym miejscu i przez to jest bezpośrednio dostępny z sieci. Oznacza to, że każdy użytkownik sieci internet może mieć dostęp do twoich prywatnych plików, a mogą być one użyte, aby uzyskać pełną kontrolę nad twoim serwisem!</p>
<p><em>Musisz</em> przenieść główny katalog danych ({$a}) <em>poza</em> katalog publicznie dostępny z sieci i uaktualnić ustawienie <code>$CFG->dataroot</code> w config.php .</p>';
$string['datarootsecuritywarning'] = 'Konfiguracja strony może nie być bezpieczna. Upewnij się, że główny katalog z danymi ({$a}) nie jest dostępny bezpośrednio z sieci.';
$string['dbprefixtoolong'] = 'Prefiks bazy danych ($CFG->prefix) jest zbyt długi ({$a->current} znaki). Maksymalna dozwolona liczba znaków to {$a->maximum}.';
$string['dbsessions'] = 'Użyj bazy danych dla informacji sesji';
$string['debug'] = 'Komunikaty usuwania błędów';
$string['debugall'] = 'WSZYSCY: Pokaż wszystkie uzasadnione komunikaty naprawiania błędów PHP.';
$string['debugdeveloper'] = 'DEWELOPER: dodatkowe wiadomości dotyczące naprawiania błędów Moodle dla deweloperów.';
$string['debugdisplay'] = 'Wyświetl komunikaty błędów';
$string['debugging'] = 'Usuwanie błędów';
$string['debugminimal'] = 'MINIMALNIE: Pokaż tylko błędy krytyczne.';
$string['debugnone'] = 'ŻADNE: Nie pokazuj żadnych błędów ani komunikatów.';
$string['debugnormal'] = 'NORMALNE: Pokazuj błędy, ostrzeżenia i powiadomienia.';
$string['debugpageinfo'] = 'Pokaż stronę informacji';
$string['debugsqltrace'] = 'Pokaż źródło wywołań SQL';
$string['debugsqltrace1'] = 'Pokaż tylko jedną linię wywołania';
$string['debugsqltrace100'] = 'Pokaż pełny stack trace';
$string['debugsqltrace2'] = 'Pokaż 2 wiersze Pokaż 2 wiersze';
$string['debugsqltrace_desc'] = 'Jeśli włączone, częściowy lub pełny stack trace PHP jest dodawany do SQL jako komentarz.';
$string['debugstringids'] = 'Pokaż oryginalne ciągi językowe';
$string['debugstringids_desc'] = 'Jeśli włączona, identyfikator napisu i plik językowy będzie wyświetlany jeżeli do adresu URL strony zostanie dodany parametr ?strings=1 lub &strings=1.';
$string['debugtemplateinfo'] = 'Pokaż informacje o szablonie';
$string['debugtemplateinfo_desc'] = 'Jeśli opcja ta jest włączona, szablony używane do renderowania są wyświetlane jako komentarze w kodzie HTML strony. Po zmianie ustawienia należy wyczyścić pamięć podręczną. Używaj tylko do tymczasowego debugowania, ponieważ powoduje błędy walidacji HTML i może uszkodzić skrypty strony. Może również zepsuć podstawową funkcjonalność!';
$string['debugvalidators'] = 'Pokaż linki walidatora';
$string['defaultcity'] = 'Domyślne miasto';
$string['defaultcity_help'] = 'Miasto wprowadzone tutaj będzie domyślnym podczas tworzenia nowych kont użytkowników.';
$string['defaultformatnotset'] = 'Błąd podczas ustalania domyślnego formatu kursu. Proszę sprawdzić ustawienia strony.';
$string['defaulthomepage'] = 'Strona startowa dla użytkowników';
$string['defaultrequestcategory'] = 'Domyślna kategoria zapotrzebowania na kursy';
$string['defaultsettinginfo'] = 'Domyślna wartość: {$a}';
$string['defaultuserroleid'] = 'Domyślna rola dla wszystkich użytkowników';
$string['deletedplugintypesdetected'] = 'Wykryto usuniętą wtyczkę „{$a}”. Powinna ona zostać przeniesiona/odinstalowana w okresie wycofywania. Obecnie jest to nieobsługiwany typ wtyczki i instalacja/aktualizacja nie będzie możliwa do momentu odinstalowania wtyczki.';
$string['deleteduserx'] = 'Usunięto użytkownika {$a}';
$string['deleteincompleteusers'] = 'Wykasuj niepotwierdzonych  użytkowników po';
$string['deleteunconfirmed'] = 'Usuń nieskonfigurowanych użytkowników po';
$string['deleteuser'] = 'Skasuj użytkownika';
$string['density'] = 'gęstość';
$string['denyemailaddresses'] = 'Niedozwolone domeny poczty elektronicznej';
$string['development'] = 'Rozwój';
$string['devicetype'] = 'Typ urządzenia';
$string['devlibdirpresent'] = 'Katalogi z bibliotekami programistycznymi, zwłaszcza <em>/vendor</em> i <em>/node_modules</em>, nie powinny być obecne w witrynach publicznych. Zobacz <a href="{$a->moreinfourl}">raport przeglądu zabezpieczeń</a>, aby uzyskać więcej informacji.';
$string['disabled'] = 'Wyłączone';
$string['disableplugin'] = 'Wyłącz {$a}';
$string['disableuserimages'] = 'Wyłącz obrazy w profilu użytkownika';
$string['displayerrorswarning'] = '<p>Włączanie ustawienia PHP: <em>display_errors</em> nie jest zalecane na stronach komercyjnych, ponieważ komunikaty o błędach mogą ujawnić poufne informacje o twoim serwerze.</p>';
$string['displayloginfailures'] = 'Wyświetl nieudane logowania';
$string['divertallemails'] = 'Przekierowanie e-mail';
$string['divertallemailsdetail'] = 'Używany jako zabezpieczenie na środowiskach developerskich podczas testowania wiadomości e-mail. Opcja nie powinna być używana na środowisku produkcyjnym.';
$string['divertallemailsexcept'] = 'Wyjątki dotyczące przekierowania wiadomości e-mail';
$string['divertallemailsexcept_desc'] = 'Lista wyjątków dla e-maili oddzielonych przecinkami lub nowymi wierszami. Każda reguła jest interpretowana jako wyrażenie regularne, np<pre>simone@acme.com
.*@acme.com
fred(\\+.*)?@acme.com
</pre>';
$string['divertallemailsto'] = 'Przekieruj wszystkie e-maile';
$string['divertallemailsto_desc'] = 'Jeśli włączone, wszystkie wiadomości e-mail będą przekierowywane na ten jeden adres e-mail.';
$string['dndallowtextandlinks'] = 'Upload linków/tekstu metodą przeciągnij-upuść';
$string['doclang'] = 'Język dla dokumentacji';
$string['docroot'] = 'Ścieżka bazowa dla Moodle Docs';
$string['doctonewwindow'] = 'Otwórz w nowym oknie';
$string['doesnotfit'] = 'Ustawienia wyświetlanie email';
$string['doesnotfitdetail'] = 'Wyświetl ustawienia dla adresu e-mail wychodzącego z Moodle.';
$string['download'] = 'Pobierz';
$string['downloadcoursecontentallowed'] = 'Funkcja pobierania treści kursu jest dostępna';
$string['downloadcoursecontentallowed_desc'] = 'Whether the download course content feature is available to courses. Jeśli jest dostępna, pobieranie treści kursu można włączyć/wyłączyć za pomocą ustawienia "Włącz pobieranie treści kursu" w menu edycji kursu (domyślne ustawienia można ustawić w <a href={$a} target="_blank">Ustawienia domyślne kursu</a>).';
$string['durationunits'] = 'czas trwania jednostki';
$string['edithelpdocs'] = 'Edytuj dokumenty pomocy';
$string['editlang'] = '<b>Edytuj</b>';
$string['editorbackgroundcolor'] = 'Kolor tła';
$string['editordictionary'] = 'Edytor słownika';
$string['editorfontfamily'] = 'Rodzina czcionek';
$string['editorfontlist'] = 'Lista czcionek';
$string['editorfontsize'] = 'Rozmiar czcionki';
$string['editorhidebuttons'] = 'Ukryte przyciski';
$string['editorkillword'] = 'Filtr formatu słów';
$string['editorspelling'] = 'Edytor pisowni
';
$string['editorspellinghelp'] = 'Włącza lub wyłącza sprawdzanie pisowni. Jeśli włączone, <strong>aspell</strong> musi być zainstalowane na serwerze.';
$string['editstrings'] = 'Edytuj słowa albo łańcuchy znaków';
$string['emailchangeconfirmation'] = 'Potwierdzenie zmiany emaila';
$string['emaildkim'] = 'Podpisywanie poczty elektronicznej DomainKeys Identified Mail (DKIM)';
$string['emaildkiminfo'] = 'Jeśli ustawiona jest sygnatura DKIM i zostanie znaleziony plik prywatnego certyfikatu, który odpowiada domenie adresu „Od” w $CFG-dataroot/dkim/[domena]/[selektor].private, wiadomość e-mail zostanie podpisana. W większości przypadków (na przykład, jeśli dozwolone domeny e-mail są puste) potrzebny jest tylko jeden certyfikat w <pre>{$a->path}</pre>. Więcej szczegółów dotyczących konfiguracji można znaleźć w dokumentacji <a href="{$a->docs}">Mail configuration</a>.';
$string['emaildkimselector'] = 'Selektor DKIM';
$string['emailfromvia'] = 'Email za pośrednictwem informacji';
$string['emailheaders'] = 'Nagłówki wiadomości e-mail';
$string['emailsubjectprefix'] = 'Tekst prefiksu tematu wiadomości e-mail';
$string['emoticonalt'] = 'Tekst alternatywny';
$string['emoticoncomponent'] = 'Komponent obrazka';
$string['emoticonimagename'] = 'Nazwa obrazu';
$string['emoticons'] = 'Emotikony';
$string['emoticons_desc'] = 'Na tej stronie pokazane są emotikony używane w witrynie. Aby usunąć wiersz z tabeli, zapisz formularz z pustą wartością w jednym z wymaganych pól. Aby wprowadzić nowy emotikon, wypełnij ostatni wiersz. Aby przywrócić wszystkie pola do wartości domyślnych, kliknij na link powyżej.
* Tekst (wymagane) - Ten tekst zostanie zastąpiony obrazem emotikona (r.męski wg słownika - przyp. tłum.). Musi mieć co najmniej dwa znaki.
* Nazwa obrazka (wymagane) - nazwa pliku obrazka emotikona bez rozszerzenia, względem katalogu pix.
* Komponent obrazka (wymagane) - komponent zawierający ikonę.
* Tekst alternatywny (opcjonalnie) - tekst zastępujący emotikon i jego komponent.';
$string['emoticonsreset'] = 'Resetuj ustawienia emotikon do wartości domyślnych';
$string['emoticontext'] = 'Tekst';
$string['emptysettingvalue'] = 'Pusty';
$string['enableanalytics'] = 'Analityka';
$string['enableblogs'] = 'Włącz blogi';
$string['enablecalendarexport'] = 'Włącz eksportowanie kalendarza';
$string['enablecomments'] = 'Włącz komentarze';
$string['enablecommunicationsubsystem'] = 'Włącz dostawców usług komunikacyjnych';
$string['enablecommunicationsubsystem_desc'] = 'Umożliwienie integracji z dostawcami usług komunikacyjnych, takimi jak Matrix, aby nauczyciele i uczniowie mogli łatwiej się komunikować. Możesz zarządzać tymi integracjami w <a href="settings.php section=managecommunicationproviders">Wtyczki</a>.';
$string['enablecourserelativedates'] = 'Włącz względną datę kursu';
$string['enablecourserelativedates_desc'] = 'Zezwól na skonfigurowanie kursu tak, by możliwe było ustawienie względnych dat rozpoczęcia kursu przez użytkownika.';
$string['enablecourserequests'] = 'Włącz zgłaszanie zapotrzebowania na kursy';
$string['enabled'] = 'Włączony';
$string['enabledashboard'] = 'Włącz Kokpit';
$string['enabledashboard_help'] = 'Kokpit domyślnie wyświetla Oś czasu, Kalendarz i Ostatnio używane elementy. Możesz ustawić inny domyślny Kokpit dla wszystkich i umożliwić użytkownikom dostosowanie własnego Kokpitu. Jeśli opcja ta jest wyłączona, należy ustawić opcję "Strona startowa dla użytkowników" na wartość inną niż Kokpit.';
$string['enableglobalsearch'] = 'Włącz globalne wyszukiwanie';
$string['enableglobalsearch_desc'] = 'Jeśli opcja jest włączona, dane zostaną zindeksowane i synchronizowane przez zaplanowane zadanie.';
$string['enablegravatar'] = 'Włącz Gravatar';
$string['enablegravatar_help'] = 'Po włączeniu tej opcji Moodle spróbuje pobrać zdjęcie z profilu użytkownika z Gravatar, jeśli użytkownik nie dodał zdjęć.';
$string['enablemobilewebservice'] = 'Włącz usługi sieciowe dla urządzeń mobilnych';
$string['enablepdfexportfont'] = 'Włącz czcionki PDF';
$string['enablepdfexportfont_desc'] = 'Jeśli twoja witryna zawiera kursy w różnych językach, które wymagają innych czcionek w generowanych plikach PDF, możesz udostępnić opcję ustawienia czcionki w ustawieniach kursu. Musisz określić dostępne czcionki w $CFG->pdfexportfont w config.php.';
$string['enableplugin'] = 'Włącz {$a}';
$string['enablerecordcache'] = 'Włącz record cache';
$string['enablerssfeeds'] = 'Włącz kanały RSS';
$string['enablesearchareas'] = 'Włącz obszary wyszukiwania';
$string['enablesharingtomoodlenet'] = 'Włącz udostępnianie w MoodleNet (wychodzące)';
$string['enablesharingtomoodlenet_desc'] = 'Pozwól użytkownikom udostępniać zawartość kursu do instancji MoodleNet, jeśli mają odpowiednie uprawnienia.';
$string['enablestats'] = 'Włącz statystyki';
$string['enabletrusttext'] = 'Zezwalaj na zaufaną zawartość';
$string['enableuserfeedback'] = 'Włącz opinie o tym oprogramowaniu';
$string['enableuserfeedback_desc'] = 'Jeśli opcja ta jest włączona, link "Przekaż opinię o tym oprogramowaniu" jest wyświetlany w stopce, aby użytkownicy mogli przekazywać opinie o oprogramowaniu Moodle do Moodle HQ. Jeśli ustawiona jest opcja "Następne przypomnienie o opinii zwrotnej", użytkownikowi wyświetlane jest również przypomnienie na Kokpicie w określonym odstępie czasu. Ustawienie opcji "Następne przypomnienie o opinii zwrotnej" na "Nigdy" wyłącza przypomnienie w Kokpicie, pozostawiając link "Przekaż opinię o tym oprogramowaniu" w stopce.';
$string['enablewebservices'] = 'Włącz usługi sieciowe';
$string['enablewsdocumentation'] = 'Dokumentacja usług sieciowych';
$string['encryptedpassword_edit'] = 'Wprowadź nową wartość';
$string['encryptedpassword_set'] = '(Ustawione i zaszyfrowane)';
$string['enroladminnewcourse'] = 'Automatyczne zapisuj administratora do nowych kursów';
$string['enroladminnewcourse_help'] = 'Kiedy administrator dodaje nowy kurs, czy powinien zostać automatycznie zapisany i przypisany do roli twórców w nowych kursach?';
$string['enrolinstancedefaults'] = 'Domyślne ustawienia dla zapisów';
$string['enrolinstancedefaults_desc'] = 'Domyślne ustawienia zapisów w nowym kursie.';
$string['enrolmultipleusers'] = 'Zapisz użytkowników';
$string['ensureauroraversion'] = 'Twoja witryna działa w oparciu o silnik bazy danych Amazon Aurora. Wersja MySQL w Amazon Aurora musi być zgodna z wersją Moodle, którą instalujesz lub do której aktualizujesz. Sprawdź zgodność w <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraMySQLReleaseNotes/AuroraMySQL.Updates.30Updates.html">Aktualizacjach silnika bazy danych dla Amazon Aurora MySQL w wersji 3</a>.';
$string['entitytasklog'] = 'Dziennik zadań';
$string['environment'] = 'Środowisko';
$string['environmenterrortodo'] = 'Musisz usunąć wszystkie problemy (błędy) w środowisku serwera zanim rozpocznie się instalacja tej wersji Moodle!';
$string['environmenterrorupgrade'] = 'Ostrzeżenie: należy rozwiązać wszystkie znalezione powyżej problemy (błędy) środowiskowe przed przystąpieniem do aktualizacji tej wersji Moodle! Aktualizowanie bez rozwiązania tych wymagań może spowodować problemy tj. utratą danych. Czy jesteś pewny że chce kontynuować uaktualnianie?';
$string['environmentmariadbwrongdbtype'] = 'Nieprawidłowy $CFG->dbtype. Musisz zmienić go w pliku config.php z \'mysqli\' na \'mariadb\'.';
$string['environmentmustfixsetting'] = 'Ustawienia PHP muszą być zmienione.';
$string['environmentok'] = 'Środowisko twojego serwera spełnia minimalne wymagania.';
$string['environmentrecommendcustomcheck'] = 'Jeśli ten test się nie powiedzie, wskazuje to na potencjalne problemy';
$string['environmentrecommendinstall'] = 'jest zalecane, żeby było zainstalowane/włączone';
$string['environmentrecommendversion'] = 'wersja {$a->needed} jest zalecana a ty używasz wersji {$a->current}';
$string['environmentrequirecustomcheck'] = 'ten test musi być zaliczony';
$string['environmentrequireinstall'] = 'jest niezbędne, aby było zainstalowane i włączone';
$string['environmentrequireversion'] = 'wymagana jest wersja {$a->needed}, a ty używasz wersji {$a->current}';
$string['environmentsettingok'] = 'Wykryto zalecane ustawienia';
$string['environmentshouldfixcustomcheck'] = 'opcja powinna być włączona, aby uzyskać najlepsze rezultaty';
$string['environmentshouldfixsetting'] = 'Ustawienie PHP powinny być zmienione.';
$string['environmentxmlerror'] = 'Błąd odczytywania danych środowiska ({$a->error_code})';
$string['errordeletingconfig'] = 'Wystąpił błąd podczas usuwania danych konfiguracji wtyczki \'{$a}\'.';
$string['errorsetting'] = 'Nie można zapisać ustawień';
$string['errorwithsettings'] = 'Niektóre ustawienia nie zostały zmienione z powodu błędu.';
$string['eventshandlersinuse'] = 'Następujące wtyczki w twoim systemie używają przestarzałych procedur obsługi interfejsu Events 1 API: \'{$a}\'. Proszę je zaktualizować, używając interfejsu Events 2 API. Sprawdź https://docs.moodle.org/dev/Events_API#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Każdy z uprawnieniem \'{$a}\'';
$string['exceptions'] = 'wyjątki';
$string['execpathnotallowed'] = 'Ustawienie ścieżek lokalnych i wykonywalnych jest wyłączona w config.php';
$string['experimental'] = 'Eksperymentalne';
$string['experimentalsettings'] = 'Ustawienia eksperymentalne';
$string['extendedusernamechars'] = 'Zezwalaj na rozszerzony zestaw znaków w nazwach użytkowników';
$string['extramemorylimit'] = 'Dodatkowy limit pamięci PHP';
$string['fatalsessionautostart'] = '<p>Wykryto poważny błąd w konfiguracji, proszę powiadomić administratora serwera.</p><p> Aby działało prawidłowo, Moodle wymaga od administratora zmiany ustawień PHP.</p><p>
<code>session.auto_start</code> musi być ustawiony na <code>wyłączony</code>.</p><p> To ustawienie jest kontrolowane przez edycję <code>php.ini</code>, konfigurację <br /> Apache/IIS lub plik .htaccess na serwerze.</p>';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'Favicon jest wyświetlany obok tytułu strony w zakładce przeglądarki. Favicon Moodle jest wyświetlany, jeśli nie podano niestandardowego favicon.';
$string['feedbacksettings'] = 'Ustawienia opinii zwrotnej';
$string['fileconversioncleanuptask'] = 'Czyszczenie tymczasowych zapisów konwersji plików.';
$string['filecreated'] = 'Nowy plik został utworzony';
$string['filescleanupperiod'] = 'Częstotliwość usuwania plików z kosza';
$string['filescleanupperiod_help'] = 'Częstotliwość usuwania plików śmieciowych. Są to pliki powiązane z kontekstem, który już nie istnieje, na przykład w przypadku usunięcia kursu. Uwaga: to ustawienie może skutkować brakiem plików w kursie, którego kopia zapasowa jest tworzona, usuwana, a następnie przywracana, jeśli ustawienie „Dołącz pliki” (backup_auto_files) w „Ustawieniach automatycznej kopii zapasowej” jest wyłączone.';
$string['filesizeunits'] = 'jednostki rozmiaru pliku';
$string['filestoredin'] = 'Zapisz plik w folderze';
$string['filestoredinhelp'] = 'Gdzie plik ma zostać zachowany';
$string['filterall'] = 'Filtruj wszystkie napisy';
$string['filtermatchoneperpage'] = 'Filtr dopasowuje raz co stronę';
$string['filtermatchonepertext'] = 'Filtr dopasowuje raz co tekst';
$string['filternavigationwithsystemcontext'] = 'Filtruj nawigację w kontekście systemu';
$string['filters'] = 'Filtry';
$string['filtersettings'] = 'Ustawienia filtrów';
$string['filtersettingsgeneral'] = 'Ogólne ustawienia dla filtra';
$string['filteruploadedfiles'] = 'Filtruj wgrane pliki';
$string['forceclean'] = 'Czyszczenie treści wszędzie';
$string['forceclean_desc'] = 'Treści dodane do witryny są zwykle czyszczone przed wyświetleniem, aby usunąć wszystko, co może być zagrożeniem bezpieczeństwa. Treści nie są jednak czyszczone w niektórych miejscach, takich jak opisy działań, zasoby strony lub bloki HTML, aby umożliwić dodawanie skryptów, multimediów, ramek wbudowanych itp. Jeśli to ustawienie jest włączone, WSZYSTKIE treści zostaną wyczyszczone. Może to spowodować, że istniejąca treść nie będzie już poprawnie wyświetlana.';
$string['forcelogin'] = 'Wymuszaj zalogowanie użytkowników';
$string['forceloginforprofileimage'] = 'Wymuszaj zalogowanie użytkowników, aby wyświetlić zdjęcie w profilu.';
$string['forceloginforprofileimage_help'] = 'Jeśli opcja jest włączona, użytkownicy muszą być zalogowani, aby zobaczyć zdjęcia z profilu użytkownika, a we wszystkich powiadomieniach mailowych będzie używany domyślny obraz użytkownika.';
$string['forceloginforprofiles'] = 'Zmuś użytkowników do zalogowania do profili';
$string['forcetimezone'] = 'Wymuś strefę czasową';
$string['formatuninstallwithcourses'] = 'Istnieje {$a->count} kursów używające {$a->format}. Ich format zostanie zmieniony na {$a->defaultformat} (domyślny format dla tej strony). Niektóre dane specyficzne dla formatu mogą zostać utracone. Czy na pewno chcesz kontynuować?';
$string['frontpage'] = 'Strona główna';
$string['frontpagebackup'] = 'Kopia strony głównej';
$string['frontpagedefaultrole'] = 'Domyślna rola strony głównej';
$string['frontpagefilters'] = 'Filtry strony głównej';
$string['frontpageloggedin'] = 'Elementy strony głównej po zalogowaniu';
$string['frontpageoverrides'] = 'Strona główna nadpisuje uprawnienia';
$string['frontpagequestions'] = 'Pytania strony głównej';
$string['frontpagerestore'] = 'Odtwórz stronę główną';
$string['frontpageroles'] = 'Role strony głównej';
$string['frontpagesettings'] = 'Ustawienia strony głównej';
$string['fullnamedisplay'] = 'Format pełnej nazwy';
$string['fullnamedisplayprivate'] = 'Format pełnej nazwy - prywatny';
$string['gdrequired'] = 'Rozszerzenie GD jest teraz wymagane przez Moodle do konwersji obrazu.';
$string['generalsettings'] = 'Ogólne ustawienia';
$string['geoipdbedition'] = 'GeoIP Database Edition';
$string['geoipdbedition_desc'] = 'Wybierz edycję bazy danych GeoIP do pobrania. Należy pamiętać, że korzystanie z bazy danych GeoIP2-City wymaga ważnej płatnej licencji.';
$string['geoipfile'] = 'Baza danych GeoIP City';
$string['geoipmaxmindaccid'] = 'Identyfikator konta MaxMind';
$string['geoipmaxmindaccid_desc'] = 'Identyfikator konta utworzonego w usłudze MaxMind API.';
$string['geoipmaxmindlicensekey'] = 'Klucz licencyjny MaxMind';
$string['geoipmaxmindlicensekey_desc'] = 'Klucz licencyjny konta utworzonego w usłudze MaxMind API.';
$string['getremoteaddrconf'] = 'Źródło zalogowanego adresu IP';
$string['globalsearch'] = 'Globalne wyszukiwanie';
$string['globalsearchmanage'] = 'Zarządzaj globalnym wyszukiwaniem';
$string['googlemapkey3'] = 'Klucz API Google Maps V3';
$string['googlemapkey3_help'] = 'Należy wprowadzić specjalny klucz, aby korzystać z Google Maps do wizualizacji wyszukiwania adresów IP. Możesz uzyskać klucz bezpłatnie na <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Idź do pierwszego brakującego łańcucha znaków';
$string['gradebook'] = 'Dziennik ocen';
$string['gradebookroles'] = 'Oceniane role';
$string['gradeexport'] = 'Podstawowa metoda eksportu ocen';
$string['gradeexportdefault'] = 'Domyślna metoda eksportu ocen';
$string['gravatardefaulturl'] = 'URL domyślnego obrazu Gravatar';
$string['gravatardefaulturl_help'] = 'Gravatar wymaga domyślnego obrazu do wyświetlenia, gdy nie jest w stanie znaleźć zdjęcia danego użytkownika. Wpisz pełny adres URL obrazu. Jeśli zostawisz to pole puste, Moodle spróbuje użyć najbardziej odpowiedniego domyślnego obrazu dla przeglądanej strony. Należy zauważyć, że Gravatar zapewnia <a href="https://en.gravatar.com/site/implement/images/#default-image">obrazy domyślne</a> .';
$string['group_customfield'] = 'Pola niestandardowe grup';
$string['groupenrolmentkeypolicy'] = 'Zasady klucza dostępu dla grupy';
$string['groupenrolmentkeypolicy_desc'] = 'Jeśli ta opcja jest włączona, klucze rejestracji grupowej będą sprawdzane pod kątem zasad haseł określonych w powyższych ustawieniach.';
$string['grouping_customfield'] = 'Pola niestandardowe grup nadrzędnych';
$string['guestroleid'] = 'Rola dla gości';
$string['guestroleid_help'] = 'Ta rola jest automatycznie przypisana do użytkownika gość. Jest ona również tymczasowo przydzielona do użytkowników, którzy wchodzą do kursu poprzez moduł zapisu gościa.';
$string['h5pgetcontenttypestask'] = 'Pobierz dostępne typy zawartości H5P z h5p.org';
$string['helpadminseesall'] = 'Czy w kalendarzu witryny administratorzy widzą i filtrują wydarzenia ze wszystkich kalendarzy kursów czy tylko tych z kursów, na które są zapisani? Bez względu na wybraną opcję, administratorzy będą mogą zarządzać wydarzeniami dla każdego kalendarza kursu, przechodząc najpierw do kursu, a następnie bezpośrednio do kalendarza kursu.';
$string['helpcalendarcustomexport'] = 'Włącz opcję eksportu niestandardowych zakresu dat w eksporcie kalendarza. Eksport kalendarza musi być włączony przed użyciem tego efektu.';
$string['helpexportlookahead'] = 'Ile dni w przyszłości kalendarza ma szukać wydarzeń podczas eksportu do niestandardowych opcji eksportu?';
$string['helpexportlookback'] = 'Ile dni w przeszłości kalendarza ma szukać wydarzeń podczas eksportu do niestandardowych opcji eksportu?';
$string['helpforcetimezone'] = 'Możesz pozowolić użytkownikom na indywidualny wybór strefy czasowej, lub wymusić strefę czasową dla wszystkich.';
$string['helpshowicalsource'] = 'Jeśli opcja jest włączona, nazwa subskrypcji i link zostanie pokazany dla importowanych wydarzeń iCal.';
$string['helpsitemaintenance'] = 'Do uaktualnień i do pozostałej pracy';
$string['helpstartofweek'] = 'Od jakiego dnia zaczyna się tydzień w kalendarzu';
$string['helpupcominglookahead'] = 'Jak wiele dni do przodu jest pokazywanych domyślnie w kalendarzu dla nadchodzących wydarzeń?';
$string['helpupcomingmaxevents'] = 'Jak wiele (maksymalnie) nadchodzących zdarzeń jest pokazywanych domyślnie użytkownikowi?';
$string['helpweekenddays'] = 'Które dni tygodnia są traktowane jako "weekend" i pokazywane innym kolorem?';
$string['hiddenuserfields'] = 'Ukryj pola użytkownika';
$string['hidefromall'] = 'Ukryj przed wszystkimi';
$string['hidefromnone'] = 'Nie ukrywaj';
$string['hidefromstudents'] = 'Ukryj przed uczniami';
$string['hookcallbacknotcallable'] = 'Tej funkcji zwrotnej (callback) nie można wywołać. Może to być spowodowane tym, że klasa lub metoda nie istnieje, lub tym, że metoda nie jest publiczna.';
$string['hookcallbacks'] = 'Funkcje zwrotne (Callbacks)';
$string['hookcallbacks_help'] = 'Lista funkcji zwrotnych (callbacks), które zostaną wywołane po wysłaniu hooka.

Pokazana kolejność jest kolejnością wywoływania funkcji zwrotnych.

Funkcja zwrotna o wyższym priorytecie zostanie wywołana przed funkcją o niższym priorytecie.';
$string['hookclassmissing'] = 'Nie znaleziono klasy hooka';
$string['hookclassmissing_desc'] = 'Agent wykrywania hooków zwrócił klasę, która nie istnieje.';
$string['hookconfigoverride'] = 'Nadpisane';
$string['hookconfigoverride_help'] = 'Definicja tej funkcji zwrotnej została zastąpiona w pliku konfiguracyjnym witryny, config.php';
$string['hookdeprecates'] = 'Przestarzałe funkcje zwrotne';
$string['hookdescription'] = 'Opis';
$string['hookdescriptionmissing'] = 'Hook nie posiada metody opisu';
$string['hookname'] = 'Hook';
$string['hooksoverview'] = 'Przegląd hooków';
$string['hookunknown'] = 'Nie znaleziono hooka';
$string['hookunknown_desc'] = 'Obiekt, na który nasłuchuje ta funkcja zwrotna, jest niedostępny. Mógł zostać usunięty lub zmieniono jego nazwę, lub może nie być dostępny w tej wersji Moodle.';
$string['hostname'] = 'Nazwa hosta';
$string['htmleditor'] = 'Edytor HTML';
$string['htmleditorsettings'] = 'Ustawienia edytora HTML';
$string['htmlsettings'] = 'Ustawienia HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'Ochrona HTTP';
$string['iconvrequired'] = 'Instalacja rozszerzenia ICONV jest wymagana.';
$string['igbinary322buggyversion'] = 'Rozszerzenie php-igbinary zainstalowane na stronie może prowadzić do problemów podczas uruchamiania z PHP 7.2. Zaleca się aktualizację do php-igbinary 3.2.5 lub nowszej lub alternatywnie aktualizację do PHP 7.3 lub nowszej.';
$string['ignore'] = 'Ignoruj';
$string['importantupdates_content'] = '<p>W następnej wersji - Moodle 5.0, której wydanie zaplanowano na kwiecień 2025 r., aktywności  czatu i ankiety zostaną usunięte z podstawowej dystrybucji Moodle. Będą dostępne jako wtyczki w <a href="https://moodle.org/plugins/">katalogu wtyczek Moodle</a>.</p>
<p>Jeśli chcesz nadal korzystać z czatu lub ankiety w swojej witrynie, będziesz mógł zainstalować je jako wtyczki przed uaktualnieniem do Moodle 5.0.</p>';
$string['importantupdates_title'] = 'Ważna aktualizacja dotycząca aktywności czatu i ankiet';
$string['includemoduleuserdata'] = 'Uwzględnij dane modułu użytkownika';
$string['incompatibleblocks'] = 'Niekompatybilne bloki';
$string['incompleteunicodesupport'] = 'Bieżąca konfiguracja MySQL lub MariaDB korzysta z \'utf8\'. Ten zestaw znaków nie obsługuje czterech bajtowych znaków, które zawierają niektóre emoji. Próba użycia tych znaków spowoduje błąd podczas aktualizowania rekordu i wszelkie informacje wysyłane do bazy danych zostaną utracone. Proszę zmienić ustawienia na \'utf8mb4\'. Szczegółowe informacje można znaleźć w dokumentacji.';
$string['indexdata'] = 'Zindeksuj dane';
$string['indexinginfo'] = 'Zalecanym sposobem indeksowania zawartości witryny jest użycie zaplanowanego zadania \'Indeksowanie globalnego wyszukiwania\'.';
$string['installhijacked'] = 'Instalacja musi być zakończona z oryginalnego adresu IP, przepraszamy.';
$string['installsessionerror'] = 'Nie można inicjalizować sesji PHP, upewnij się, że Twoja przeglądarka akceptuje pliki cookies.';
$string['intlrecommended'] = 'Rozszerzenie intl usprawnia obsługę wielu języków i np. zgodne z ustawieniami regionalnymi prawidłowe sortowanie.';
$string['intlrequired'] = 'Rozszerzenie Intl jest wymagane w celu poprawy obsługi internacjonalizacji, na przykład sortowania zgodnego z ustawieniami narodowymi i nazw domen międzynarodowych.';
$string['invalidagedigitalconsent'] = 'Cyfrowy wiek zgody jest nieprawidłowy: {$a}';
$string['invalidforgottenpasswordurl'] = 'Adres URL zapomnianego hasła nie jest prawidłowym adresem URL.';
$string['invalidsection'] = 'Niewłaściwa sekcja';
$string['invalidthemepreset'] = 'Wybrany plik ustawień wstępnych nie jest zgodny z tym motywem. Błąd kompilacji SCSS to: "{$a}"';
$string['invaliduserchangeme'] = 'Nazwa "changeme" jest zarezerwowana - nie możesz użyć tej nazwy do stworzenia konta';
$string['ipblocked'] = 'Ta strona jest obecnie niedostępna.';
$string['ipblocker'] = 'Blokowanie IP';
$string['ipblockersyntax'] = 'Umieść każdy wpis w jednej linii. Poprawny wpis to: pełny adres IP (np. <b>192.168.10.1),</b> który pasuje do jednego hosta; częściowy adres (np. <b>192,168.),</b> który pasuje do każdego adresu rozpoczynającego się od tych liczb; notacja CIDR (np. <b>231.54.211.0/20)</b>; zakres adresów IP (np. <b>231.3.56.10-20),</b> gdzie zakres odnosi się do ostatniej części adresu. Tekstowe nazwy domen (jak \'example.com\') nie są obsługiwane. Puste wiersze są ignorowane.';
$string['iplookup'] = 'Wyszukaj adres IP';
$string['iplookupgeoplugin'] = 'Usługa <a href="http://www.geoplugin.com">geoPlugin</a> jest obecnie wykorzystywana do wyszukiwania informacji geograficznych. Na dokładniejsze wyniki zaleca się lokalną instalację kopii bazy danych MaxMind GeoLite.';
$string['iplookupinfo'] = 'Moodle domyślnej używa darmowego serwera NetGeo (The Internet Geographic Database) do wyszukiwania lokalizacji adresów IP. Niestety ta baza danych nie jest już utrzymywana i może zwrócić <em>zupełne bzdury</em>. Zaleca się zainstalować lokalną kopię darmowej bazy danych GeoLite2 City od MaxMind. <br /> Lokalizacja IP wyświetlana jest na prostej mapce lub w Google Maps. Należy pamiętać, że trzeba mieć konto Google i uzyskać darmowy klucz API Google Maps, aby interaktywne mapy działały.';
$string['iplookupmaxmindnote'] = 'Ten produkt zawiera dane GeoLite stworzone przez MaxMind, dostępne na <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>. ';
$string['iscustomadminwarnings'] = 'Wykryto, że Twoja witryna korzysta z niestandardowego katalogu administratora. Ta funkcja nie jest już obsługiwana i zostanie usunięta po wydaniu wersji 4.2 Moodle.';
$string['ishttpswarning'] = 'Wykryto, że twoja strona nie jest zabezpieczona z użyciem HTTPS. W celu uzyskania wyższego bezpieczeństwa i integracji z innymi systemami, zalecane jest dokonanie migracji strony do HTTPS.';
$string['keeptagnamecase'] = 'Zachować wielkie-małe litery w tagach';
$string['lang'] = 'Domyślny język';
$string['langcache'] = 'Cache menu językowego';
$string['langcache_desc'] = 'Buforuj menu językowe. Jeśli opcja jest włączona, lista dostępnych tłumaczeń jest buforowana. Pamięć podręczna jest automatycznie odświeżana podczas instalacji lub usuwania paczki językowej za pośrednictwem wbudowanego narzędzia. Jeśli instalujesz nową paczkę językową ręcznie, trzeba użyć funkcji \'Wyczyść wszystkie bufory pamięci podręcznej\' w celu odświeżenia pamięci podręcznej.';
$string['langlist'] = 'Języki w menu językowym';
$string['langmenu'] = 'Wyświetl menu językowe';
$string['langmenuinsecurelayout'] = 'Wyświetlaj menu językowe w tzw. układzie bezpiecznym';
$string['langmenuinsecurelayout_desc'] = 'Włączenie tej opcji umożliwia użytkownikowi zmianę języka podczas rozwiązywania testu lub innej czynności z wykorzystaniem układu bezpiecznego (w którym część funkcji jest z ekranu usunięta).';
$string['langpackwillbeupdated'] = 'UWAGA: Moodle będzie próbował pobrać aktualizacje pakietów językowych podczas aktualizacji.';
$string['langstringcache'] = 'Cache wszystkich łańcuchów językowych';
$string['languagesettings'] = 'Ustawienia językowe';
$string['latinexcelexport'] = 'Kodowanie dla Excel-a';
$string['legacyfilesaddallowed'] = 'Zezwalaj na dodawanie do plików kursu';
$string['legacyfilesaddallowed_help'] = 'Jeżeli kurs ma pliki, zezwala nowym plikom i folderom na dodawanie do nich.';
$string['legacyfilesinnewcourses'] = 'Stare pliki kursu w nowym kursie';
$string['legacyfilesinnewcourses_help'] = 'Domyślnie pliki kursu starego formatu (wersja 1.9) są dostępne tylko w kursach, które były przeniesione z tej wersji. Uwaga: Niektóre funkcje, jak kopia zapasowa pojedynczej aktywności nie obsługują już takich plików.';
$string['libcurlwarning'] = 'Wykryto, że libcurl nie obsługuje CURLOPT_PROTOCOL. Ze względów bezpieczeństwa zalecana jest aktualna instalacja libcurl.';
$string['licensesettings'] = 'Ustawienia licencji';
$string['linkadmincategories'] = 'Link do kategorii admina';
$string['linkadmincategories_help'] = 'Jeśli aktywny ustawienie kategorii admina będzie wyświetlane jako linki w nawigacji i będzie doprowadzać do kategorii stron administracyjnych.';
$string['loading'] = 'Ładowanie';
$string['localetext'] = 'Lokalizacja dla całego serwisu';
$string['localstringcustomization'] = 'Lokalne dostosowanie języka';
$string['location'] = 'Lokalizacja';
$string['locationsettings'] = 'Ustawienia lokalizacji';
$string['locked'] = 'Zablokowany';
$string['lockoutduration'] = 'Czas trwania blokady konta';
$string['lockoutduration_desc'] = 'Zablokowane konto zostanie automatycznie odblokowane po tym czasie.';
$string['lockoutemailbody'] = 'Drogi użytkowniku :{$a->firstname},
Twoje konto (nazwa użytkownika: {$a->username}) w serwisie {$a->sitename} zostało zablokowane po wielu nieudanych próbach logowania.

Aby odblokować konto, przejdź do poniższej strony: {$a->link}

W większości programów pocztowych powyższy adres powinien być aktywny, Jeżeli nie możesz go kliknąć, skopiuj go i wklej w oknie przeglądarki internetowej.

Jeśli potrzebujesz pomocy, skontaktuj się z administratorem witryny
{$a->admin}';
$string['lockoutemailsubject'] = 'Twoje konto zostało zablokowane {$a}';
$string['lockouterrorunlock'] = 'Dostarczono nieprawidłowe informacje do odblokowania konta.';
$string['lockoutthreshold'] = 'Próg blokady konta';
$string['lockoutthreshold_desc'] = 'Wybierz liczbę nieudanych prób logowań, po których nastąpi blokada konta. Ta funkcja może być nadużywana w atakach typu DoS.';
$string['lockoutwindow'] = 'Okno obserwacji blokady konta';
$string['lockoutwindow_desc'] = 'Czas obserwacji dla progu blokady, jeżeli nie ma nieudanych prób logowania, licznik logowań zostanie zresetowany po tym czasie.';
$string['lockrequestcategory'] = 'Zapobiegaj wybieraniu kategorii';
$string['log'] = 'Logi';
$string['logguests'] = 'Logi dostępu gości';
$string['logguests_help'] = 'To ustawienie umożliwia rejestrowanie działań konta gość i niezalogowanych użytkowników. Wiele profesjonalnych stron może żądać wyłączenia tego monitorowania z powodów wydajności. Zaleca się zachować to ustawienie na witrynach publicznych.';
$string['logininfoinsecurelayout'] = 'Wyświetl zalogowanego użytkownika w układzie bezpiecznym';
$string['logininfoinsecurelayout_desc'] = 'Włączenie tej funkcji powoduje, że pełne imię i nazwisko zalogowanego użytkownika będzie wyświetlane na pasku nawigacji podczas próby wykonania testu lub innej czynności z wykorzystaniem układu bezpiecznego.';
$string['loginpageautofocus'] = 'Automatyczny fokus na stronie logowania';
$string['loginpageautofocus_help'] = 'Włączenie tej opcji poprawia użyteczność strony logowania, ale automatyczny fokus na polach może zostać uznany za problem z dostępnością.';
$string['loglifetime'] = 'Zachowaj logi przez';
$string['logo'] = 'Logo';
$string['logo_desc'] = 'Pełne logo, które może być użyte jako dekoracja w niektórych tematach (takich jak podstawowe motywy). Obraz ten może mieć dość wysoką rozdzielczość, ponieważ będzie skalowany do użycia (i buforowany pod kątem wydajności). Loga, które mają większą szerokość niż są wysokość, zwykle dają lepsze wyniki. Akceptowane formaty: PNG i JPG.';
$string['logocompact'] = 'Kompaktowe logo';
$string['logocompact_desc'] = 'Kompaktowa wersja tego samego logo, co powyżej, na przykład emblemat, tarcza lub ikona. Obraz powinien być wyraźny nawet w małych rozmiarach. Akceptowane formaty: PNG i JPG.';
$string['logossettings'] = 'Loga';
$string['logstorenotrequired'] = 'Magazyn logu nie jest wymagany';
$string['logstoressupported'] = 'Magazyny logów, które wspierają ten raport';
$string['longtimewarning'] = '<b>Zakończenie działania tego procesu może potrwać długo.</b>';
$string['mailnewline'] = 'Nowa linia znaków w mail-u';
$string['maintenancemode'] = 'W trybie konserwacji';
$string['maintenancemodeisscheduled'] = 'Przerwa techniczna rozpocznie się za {$a->min} min. {$a->sec} sek.';
$string['maintenancemodeisscheduledlong'] = 'Przerwa techniczna rozpocznie się za {$a->hour} godz., {$a->min} min., {$a->sec} sek.';
$string['maintfileopenerror'] = 'Błąd podczas otwierania plików konserwacyjnych!';
$string['maintinprogress'] = 'Konserwacja w trakcie...';
$string['managecontextlock'] = 'Zablokuj ten kontekst';
$string['managecontextlocklocked'] = '{$a->contextname} i wszystkie niższe konteksty są teraz zablokowane.';
$string['managecontextlockunlocked'] = '{$a->contextname} i wszystkie niższe konteksty są teraz odblokowane.';
$string['managecontextunlock'] = 'Odblokuj ten kontekst';
$string['managecustomfields'] = 'Zarządzaj niestandardowymi typami pól';
$string['manageformats'] = 'Zarządzaj formami kursów';
$string['manageformatsgotosettings'] = 'Domyślny format może być zmieniony w: {$a}';
$string['managelang'] = 'Zarządzaj';
$string['manageqbanks'] = 'Zarządzaj wtyczkami banku pytań';
$string['manageqbehaviours'] = 'Zarządzaj zachowaniem pytań';
$string['manageqtypes'] = 'Zarządzaj typami pytań';
$string['maturity100'] = 'Wersja beta';
$string['maturity150'] = 'Kandydat do wydania';
$string['maturity200'] = 'Wersja stabilna';
$string['maturity50'] = 'Wersja alfa';
$string['maturityallowunstable'] = 'Podpowiedź: możesz chcieć uruchomić ten skrypt z opcją --allow-unstable';
$string['maturitycoreinfo'] = 'Twoja witryna obecnie używa niestabilnej wersji kodu źródłowego - "{$a}"';
$string['maturitycorewarning'] = 'Wersja Moodle, którą zamierzasz zainstalować lub uaktualnić zawiera wersję niestabilną kodu &quot;{$a}&quot; który nie jest wskazana do stosowania w większości witryn produkcyjnych. Jeśli to nie było twoim zamiarem, upewnij się, że aktualizujesz do stabilnej gałęzi kodu Moodle. Więcej szczegółów znajdziesz w Dokumentacji Moodle.';
$string['maxbytes'] = 'Maksymalna wielkość załadowanego pliku';
$string['maxcharacter'] = 'maksymalnie {$a} znaków';
$string['maxconsecutiveidentchars'] = 'Kolejne identyczne znaki';
$string['maxeditingtime'] = 'Maksymalny czas edycji wpisów';
$string['maxsizeperdownloadcoursefile'] = 'Maksymalny rozmiar pliku';
$string['maxsizeperdownloadcoursefile_desc'] = 'Maksymalny rozmiar każdego pliku podczas pobierania treści kursu. Pliki przekraczające ten rozmiar zostaną pominięte przy pobieraniu.';
$string['maxtimelimit'] = 'Maksymalny czas limitu';
$string['maxtimelimit_desc'] = 'Aby ograniczyć maksymalny czas wykonania PHP, wprowadź tutaj wartość w sekundach. 0 oznacza, że są używane domyślne restrykcje Moodle. Jeżeli masz serwer nieprodukcyjny z własnym limitem czasu, ustaw tą wartość niżej aby otrzymywać błędy PHP w logach. Nie stosuje się tej opcji do skryptów CLI.';
$string['maxusersperpage'] = 'Maksymalna liczba użytkowników na stronie';
$string['mbstringrecommended'] = 'Zainstalowanie opcjonalnej biblioteki MBSTRING jest mocno zalecane, aby poprawić wydajność strony, szczególnie jeśli strona używa języków niełacińskich.';
$string['mbstringrequired'] = 'Instalacja biblioteki MBSTRING jest wymagana, by poprawić wydajność witryny, szczególnie jeśli witryna obsługuje języki inne niż łacińskie.';
$string['mediapluginavi'] = 'Włącz filtr dla plików .avi';
$string['mediapluginflv'] = 'Włącz filtr dla plików .flv';
$string['mediapluginimg'] = 'Włącz auto-osadzanie podlinkowanych obrazów';
$string['mediapluginmov'] = 'Włącz filtr dla plików .mov';
$string['mediapluginmp3'] = 'Włącz filtr dla plików .mp3';
$string['mediapluginmpg'] = 'Włącz filtr dla plików .mpg';
$string['mediapluginogg'] = 'Włącz filtr .ogg';
$string['mediapluginogv'] = 'Włącz filtr .ogv';
$string['mediapluginram'] = 'Włącz filtr dla plików .ram';
$string['mediapluginrm'] = 'Włącz filtr dla plików .rm';
$string['mediapluginrpm'] = 'Włącz filtr dla plików .rpm';
$string['mediapluginwmv'] = 'Włącz filtr dla plików .wmv';
$string['mediapluginyoutube'] = 'Włącz filtrowanie linków YouTube';
$string['messaging'] = 'Włącz system wymiany wiadomości';
$string['messagingallowemailoverride'] = 'Nadpisanie adresu email do powiadomień';
$string['messagingallusers'] = 'Zezwalaj na przesyłanie wiadomości w całej witrynie';
$string['messagingcategory'] = 'Wiadomości';
$string['messagingdefaultpressenter'] = 'Użyj klawisza Enter, aby wysłać (domyślnie włączone)';
$string['messagingdeleteallnotificationsdelay'] = 'Usuń wszystkie powiadomienia';
$string['messagingdeletereadnotificationsdelay'] = 'Usuń przeczytane powiadomienia';
$string['messagingssettings'] = 'Ustawienie wysyłania wiadomości';
$string['minpassworddigits'] = 'Cyfry';
$string['minpasswordlength'] = 'Długość hasła';
$string['minpasswordlower'] = 'Małe litery';
$string['minpasswordnonalphanum'] = 'Litery spoza alfabetu';
$string['minpasswordupper'] = 'Wielkie litery';
$string['misc'] = 'Różne (Miscellaneous)';
$string['mlbackendsettings'] = 'Ustawienia backendu uczenia maszynowego';
$string['mnetrestore_extusers'] = '<strong>Uwaga:</strong> Ten plik kopii zapasowej zawiera zdalne konta użytkowników Moodle Network, które zostaną w ramach procesu przywrócone.';
$string['mnetrestore_extusers_admin'] = '<strong>Uwaga:</strong> Ten plik kopii prawdopodobnie pochodzi z innej instalacji Moodle i zawiera konta zdalnych użytkowników sieciowych Moodle Network. Proces odtwarzania będzie próbował odnaleźć zdalne hosty Moodle dla wszystkich utworzonych użytkowników. Ci użytkownicy, którzy nie zostaną odnalezieni, będą automatycznie przełączeni na wewnętrzne uwierzytelnianie (zamiast MNet). Dziennik odtwarzania poinformuje Cię o tym.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Uwaga:</strong> Ten plik kopii zapasowej pochodzi z innej instalacji Moodle i zawiera zdalne konta użytkowników Moodle Network, które mogą nie zostać przywrócone. Ta operacja nie jest obsługiwana. Jeżeli jesteś pewien, że plik został stworzony w tej instalacji Moodle, lub jesteś pewien, że wszystkie potrzebne hosty Moodle Network są skonfigurowane, możesz spróbować przywrócić.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Uwaga:</strong> Ten plik kopii prawdopodobnie pochodzi z innej instalacji Moodle i zawiera konta zdalnych użytkowników sieciowych Moodle Network. Nie masz uprawnień do wykonania tego typu odtwarzania. Skontaktuj się z administratorem witryny lub ewentualnie przywrócić ten kurs bez informacji o użytkownikach (modułów, plików...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Zdalny użytkownik Moodle Network {$a->username} (pochodzących z {$a->mnethosturl}) przełączony na  lokalnego uwierzytelnionego użytkownika {$a->auth}.';
$string['mobilenotconfiguredwarning'] = 'Aplikacja Moodle Mobile nie jest włączona.';
$string['modassignmentinuse'] = 'Twoja witryna nadal korzysta z wtyczki Assignment 2.2 (Zadanie 2.2). Przed aktualizacją należy 1) wykonać kopię zapasową wszystkich działań w ramach Assignment 2.2, które chcesz zachować i przywrócić je jako działania w ramach Assignment , oraz 2) usunąć wszystkie dane Assignment 2.2 z bazy danych.';
$string['modassignmentsubpluginsexist'] = 'Mogą być obecne podwtyczki Assignment 2.2. Folder mod/assignment i wszystkie jego podwtyczki muszą zostać usunięte przed aktualizacją.';
$string['modeditdefaults'] = 'Domyślne wartości dla ustawień aktywności';
$string['modsettings'] = 'Zarządzaj aktywnościami';
$string['modulesecurity'] = 'Bezpieczeństwo modułów';
$string['moodlebrandedapp'] = 'Markowa aplikacja Moodle';
$string['moodlebrandedappreference'] = 'Alternatywnie, można uzyskać <a href="https://moodle.com/branded-app/">aplikację Branded Moodle</a> z własnym, niestandardowym brandingiem.';
$string['mustenablestats'] = 'Statystyki nie zostały jeszcze uaktywnione na tej stronie.';
$string['mycourses'] = 'Moje kursy';
$string['mydashboard'] = 'Domyślny Kokpit systemu';
$string['mymoodle'] = 'Kokpit';
$string['mypage'] = 'Domyślna strona Kokpitu';
$string['mypagelocked'] = 'Zablokuj domyślną stronę';
$string['myprofile'] = 'Domyślna strona profilu';
$string['navadduserpostslinks'] = 'Dodaj linki do wpisów użytkownika';
$string['navadduserpostslinks_help'] = 'Dwa linki będą dodawane do każdego użytkownika w nawigacji: do dyskusji, które użytkownik zaczął, i do wiadomości, jakie wpisał na forach w całej witrynie lub w konkretnych kursach.';
$string['navcourselimit'] = 'Limit liczby kursów';
$string['navfilter'] = 'Filtruj niestandardowe menu';
$string['navfilter_desc'] = 'Przetwarzaj niestandardowe menu za pomocą filtrów Moodle, które są ustawione tak, aby stosować się do <strong>Treści i nagłówków</strong>. Jest to przydatne do włączania dynamicznych niestandardowych elementów menu.';
$string['navigationupgrade'] = 'To uaktualnienie wprowadza dwa nowe bloki nawigacji, które zastąpią te bloki: Administracja, Kursy, Aktywności i Uczestnicy. Jeśli ustawiałeś jakieś specjalne uprawnienia do tych bloków, sprawdź, czy wszystko działa tak, jak powinno.';
$string['navshowallcourses'] = 'Pokaż wszystkie kursy';
$string['navshowcategories'] = 'Pokaż kategorie kursów';
$string['navshowfrontpagemods'] = 'Pokaż aktywności strony głównej w nawigacji';
$string['navshowfrontpagemods_help'] = 'Jeśli opcja będzie włączona, aktywności strony głównej będą wyświetlane w nawigacji na dole strony.';
$string['navshowfullcoursenames'] = 'Pokaż pełne nazwy kursów';
$string['navshowfullcoursenames_help'] = 'Jeśli włączony, w nawigacji zostaną pokazane pełne nazwy kursów, zamiast krótkich.';
$string['navshowmycoursecategories'] = 'Pokaż moje kategorie kursów';
$string['navshowmycoursecategories_help'] = 'Jeśli ta opcja jest włączona, kursy w zakładce użytkownika „Moje kursy” będą wyświetlane w kategoriach w bloku nawigacyjnym (tylko motywy oparte na wersji klasycznej).';
$string['navsortmycourseshiddenlast'] = 'Sortuj moje ukryte kursy jako ostatnie';
$string['navsortmycourseshiddenlast_help'] = 'Włączenie powoduje, że wszystkie ukryte kursy będą wyświetlane po widocznych kursach (dla użytkowników, którzy mogą wyświetlać ukryte kursy). W przeciwnym razie wszystkie kursy, niezależnie od ich widoczności, zostaną wymienione zgodnie z ustawieniem „Sortuj moje kursy”.';
$string['navsortmycoursessort'] = 'Kolejność kursów w bloku nawigacyjnym';
$string['navsortmycoursessort_help'] = 'To określa, czy kursy są pokazywane poniżej Moich kursów wg kolejności sortowania (np. ustawienie kolejności w Ustawienia > Administracja strony > Kursy > Dodaj/Edytuj kursy) lub alfabetycznie wg ustawień kursu.';
$string['never'] = 'Nigdy';
$string['neverdeleteruns'] = 'Nigdy nie kasuj trwających';
$string['newestdocindexed'] = 'Najnowszy indeksowany dokument';
$string['nobookmarksforuser'] = 'Nie masz żadnych zakładek';
$string['nodatabase'] = 'Brak bazy danych';
$string['noemaileverwarning'] = '<strong>Uwaga:</strong> wszystkie wychodzące e-maile zostały wyłączone';
$string['nohttpsformobilewarning'] = 'Zaleca się włączyć HTTPS z ważnym certyfikatem.  Moodle będzie zawsze próbować używać bezpiecznego połączenia w pierwszej kolejności.';
$string['nomissingstrings'] = 'Nie ma brakujących fraz';
$string['none'] = 'Żaden';
$string['nonewsettings'] = 'Podczas tego uaktualnienia nie dodano żadnych nowych ustawień';
$string['nonexistentbookmark'] = 'Zakładka o którą prosisz nie istnieje';
$string['noreplyaddress'] = 'Adres no-reply';
$string['noreplydomain'] = 'Adres no-reply i domena';
$string['noreplydomaindetail'] = 'Ustawienia dla adresu no-reply i domeny';
$string['noresults'] = 'Nie znaleziono wyników';
$string['noroles'] = 'Brak ról';
$string['nosupportedlogstore'] = 'Nie znaleziono wspieranego magaznu  logu';
$string['noteunneededblocks'] = 'Uwaga: Bloki ustawione do wyświetlania nie będą wyświetlane w menu „Dodaj blok” w kursie, jeśli zostały określone w ustawieniu motywu „Niepotrzebne bloki”.';
$string['notifications'] = 'Powiadomienia';
$string['notifyloginfailures'] = 'Wyślij wiadomość e-mail o błędach logowania do';
$string['notifyloginthreshold'] = 'Próg dla powiadomień poczty elektronicznej';
$string['notloggedinroleid'] = 'Rola dla odwiedzających';
$string['numberofmissingstrings'] = 'Liczba brakujących łańcuchów: {$a}';
$string['numberofstrings'] = 'Całkowita liczba łańcuchów:  {$a->strings} <br />Brakuje: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'Token odświeżania dla jednej z usług OAuth {$a->issuer} w Twojej witrynie {$a->siteurl} wygasł. Ograniczy to funkcjonalność wszelkich wtyczek korzystających z tej usługi. Aby rozwiązać ten problem, odwiedź stronę konfiguracji usług OAuth 2 i kliknij ikonę „Połącz konto systemowe” w wierszu tabeli dotyczącym tej usługi. Pamiętaj, aby za każdym razem logować się przy użyciu tego samego konta usługi w systemie OAuth.';
$string['oauthrefreshtokenexpiredshort'] = 'Token odświeżania OAuth wygasł dla {$a->issuer} na twojej witrynie {$a->siteurl}.';
$string['onlynoreply'] = 'Tylko gdy z pochodzi z adresu \'no-reply\'';
$string['opcacherecommended'] = 'Buforowanie kodu operacji PHP zwiększa wydajność i zmniejsza zapotrzebowanie na pamięć, rozszerzenie OPcache jest zalecane i w pełni wspierane.';
$string['opensslrecommended'] = 'Instalacja opcjonalnej biblioteki OpenSSL jest wysoce zalecane -- aktywuje sieciową funkcjonalność Moodle.';
$string['opensslrequired'] = 'Rozszerzenie PHP OpenSSL jest obecnie wymagane przez Moodle do zapewnienia silniejszych usług kryptograficznych.';
$string['opentowebcrawlers'] = 'Otwórz dla Google';
$string['optionalmaintenancemessage'] = 'Opcjonalna wiadomość dla trybu konserwacji';
$string['order1'] = 'Pierwszy';
$string['order2'] = 'Drugi';
$string['order3'] = 'Trzeci';
$string['order4'] = 'Czwarty';
$string['outgoingmailconfig'] = 'Konfiguracja poczty wychodzącej';
$string['overridetossl'] = 'Protokół HTTPS do logowania został wycofany. Teraz wymuszony jest protokół SSL. Aby naprawić ten problem, zmień wwwroot w config.php na https://';
$string['pageinfodebugsummary'] = 'Ta strona to: {$a}';
$string['passwordchangelogout'] = 'Wyloguj po zmianie hasła';
$string['passwordchangelogout_desc'] = 'Jeśli jest włączone, po zmianie hasła wszystkie sesje przeglądarki są kończone, oprócz tego, w którym zostało określone nowe hasło. (To ustawienie nie wpływa na zmiany haseł przez przesyłanie zbiorcze).';
$string['passwordchangetokendeletion'] = 'Usuń tokeny dostępu do usługi internetowej po zmianie hasła';
$string['passwordchangetokendeletion_desc'] = 'Jeśli aktywne, kiedy hasło zostanie zmienione to cały dostęp tego użytkownika zostanie usunięty.';
$string['passwordpolicy'] = 'Zasady dot. hasła';
$string['passwordpolicycheckonlogin'] = 'Sprawdź hasło podczas logowania';
$string['passwordresettime'] = 'Max. czas na potwierdzenie żądania zresetowania hasła';
$string['passwordreuselimit'] = 'Limit rotacji hasła';
$string['passwordreuselimit_desc'] = 'Ile razy użytkownik musi zmienić swoje hasło, zanim będzie mógł ponownie użyć hasła. Skróty wcześniej używanych haseł są przechowywane w tabeli lokalnej bazy danych. Ta funkcja może nie być kompatybilna z niektórymi zewnętrznymi wtyczkami uwierzytelniającymi.';
$string['pathtodot'] = 'Ścieżka do dot';
$string['pathtodot_help'] = 'Ścieżka do narzędzia dot. Najczęściej: /usr/bin/dot. Aby być w stanie generować grafikę z plików DOT, musisz mieć zainstalowane narzędzie dot i wskazać je tutaj. Należy pamiętać, że na razie jest ono używane tylko przez funkcje profilowania (Rozwój->Profilowanie) wbudowane w Moodle.';
$string['pathtodu'] = 'Ścieżka do du';
$string['pathtogs'] = 'Ścieżka do ghostscript';
$string['pathtogs_help'] = 'W przypadku większości instalacji Linux można to pozostawić jako \'/usr/bin/gs\'. W systemie Windows będzie to coś w stylu \'c:\\gs\\bin\\gswin32c.exe\' (upewnij się, że w ścieżce nie ma spacji - w razie potrzeby skopiuj pliki \'gswin32c.exe\' i \'gsdll32.dll\' do nowego folderu bez spacji w ścieżce)';
$string['pathtopdftoppm'] = 'Ścieżka do pdftoppm';
$string['pathtopdftoppm_help'] = '<a href="https://poppler.freedesktop.org/">Poppler</a> to biblioteka do renderowania plików PDF, która zawiera narzędzie pdftoppm do konwersji plików PDF do PNG. Wydajność jest ogólnie lepsza niż w przypadku korzystania z Ghostscript, szczególnie w przypadku dużych plików. Jeśli jest dostępne, pdftoppm będzie używane zamiast Ghostscript. W większości instalacji Linuksa, ścieżka może być pozostawiona jako /usr/bin/pdftoppm. W przeciwnym razie należy zainstalować pakiet poppler-utils lub poppler, w zależności od dystrybucji systemu Linux. W systemie Windows jest on dostarczany przez instalacje Cygwin.';
$string['pathtopgdump'] = 'Ścieżka do pq_dump';
$string['pathtopgdumpdesc'] = 'Tego potrzeba tylko wtedy gdy w systemie jest więcej niż jeden pg_dump (np jeżeli masz zainstalowaną więcej niż jedną wersje postgresql)';
$string['pathtopgdumpinvalid'] = 'Błędna scieżka do pg_dump - albo błędna scieżka albo nie można wykonać polecenia.';
$string['pathtophp'] = 'Ścieżka do PHP CLI';
$string['pathtopsql'] = 'Ścieżka do psql';
$string['pathtopsqldesc'] = 'Tego potrzeba tylko wtedy gdy w systemie jest więcej niż jeden psql (np jeżeli masz zainstalowaną więcej niż jedną wersje postgresql)';
$string['pathtopsqlinvalid'] = 'Błędna scieżka do psql - albo błędna scieżka albo nie można wykonać polecenia.';
$string['pathtopython'] = 'Ścieżka do Python';
$string['pathtopythondesc'] = 'Ścieżka do wykonywalnego pliku binarnego w języku Python (dopuszczalne są zarówno Python 2, jak i Python 3).';
$string['pathtosassc'] = 'Ścieżka do SassC';
$string['pathtosassc_help'] = 'Określenie lokalizacji pliku binarnego SassC spowoduje przełączenie kompilatora SASS z implementacji PHP Moodle na SassC. Więcej informacji można znaleźć na stronie https://github.com/sass/sassc.';
$string['pcreunicodewarning'] = 'Zalecamy używanie rozszerzenia PHP PCRE zgodnego z systemem znaków Unicode.';
$string['perfdebug'] = 'Informacja o wydajności';
$string['perfdebugdeferred'] = 'Oczekiwanie na zakończenie skryptu w celu wyświetlenia informacji o wydajności ...';
$string['performance'] = 'Wydajność';
$string['pgcluster'] = 'Klaster PostgreSQL';
$string['pgclusterdescription'] = 'Parametry wersji/klastru do operacji z linii poleceń. Jeśli masz tylko jeden postgresql w systemie lub nie wiesz co z tym zrobić pozostaw puste.';
$string['phpfloatproblem'] = 'Wykryto nieoczekiwany problem w obsłudze liczb float w PHP - {$a}';
$string['pid'] = 'PID';
$string['pleaserefreshregistration'] = 'Twoja strona została zarejestrowana. Ostatnia aktualizacja danych rejestracji nastąpiła {$a}<br />Zadanie harmonogramu "Rejestracja strony" zapewnia, że rejestracja jest aktualna. Możesz również ręcznie zaktualizować dane rejestracji w dowolnym momencie.';
$string['pleaserefreshregistrationnewdata'] = 'Informacje rejestracyjne zostały zmienione. Potwierdź je, używając przycisku \'Aktualizuj rejestrację\'.';
$string['pleaserefreshregistrationunknown'] = 'Twoja strona została zarejestrowana, jednak data rejestracji nie jest znana. Proszę zaktualizować rejestrację korzystając z przycisku \'Zaktualizuj rejestrację\' i upewnij się, że zadanie terminowe \'Rejestracja strony\' jest łączony, aby rejestracja automatycznie się aktualizowała.';
$string['plugin'] = 'Wtyczka';
$string['plugin_disabled'] = 'wyłączone: {$a}.';
$string['plugin_enabled'] = 'włączone: {$a}.';
$string['plugins'] = 'Wtyczki';
$string['pluginscheck'] = 'Kontrola zależności wtyczek';
$string['pluginscheckfailed'] = 'Kontrola zależności nie powiodła się dla {$a->pluginslist}';
$string['pluginschecktodo'] = 'Musisz uwzględnić wszystkie wymagania wtyczek przed przystąpieniem do instalacji tej wersji Moodle!';
$string['pluginsoverview'] = 'Przegląd wtyczek';
$string['pluginsoverviewsee'] = 'Wyświetl <a href="{$a->url}">przegląd wtyczek</a>, aby zobaczyć więcej informacji.';
$string['policysettings'] = 'Ustawienia polityk';
$string['privacy:metadata'] = 'Wtyczka Administracja nie przechowuje żadnych danych osobowych.';
$string['privacyandpolicies'] = 'Prywatność i zasady';
$string['privacysettings'] = 'Ustawienia prywatności';
$string['profilecategory'] = 'Kategoria';
$string['profilecategoryname'] = 'Nazwa kategorii (musi być unikatowa)';
$string['profilecategorynamenotunique'] = 'Ta nazwa kategorii jest już używana';
$string['profilecommonsettings'] = 'Pospolite ustawienia';
$string['profileconfirmcategorydeletion'] = 'Nie jest/są {$a} pole/pola w tej kategorii, które zostaną przeniesione do kategorii powyżej (lub poniżej, jeżeli w kategorii pierwszej). <br /> Czy nadal chcesz usunąć tę kategorię?';
$string['profileconfirmfielddeletion'] = 'Istnieją {$a} rekordy użytkownika dla tego pola które zostaną usunięte. <br /> Czy nadal chcesz usunąć to pole?';
$string['profilecreatecategory'] = 'Stwórz nową kategorię dla profilu';
$string['profilecreatefield'] = 'Stwórz nowe pole profilu';
$string['profilecreatenewcategory'] = 'Stwórz nową kategorię';
$string['profilecreatenewfield'] = 'Utwórz nowe \'{$a}\' pole profilu';
$string['profiledefaultcategory'] = 'Inne pola';
$string['profiledefaultchecked'] = 'Domyślnie zaznaczone';
$string['profiledefaultdata'] = 'Domyślna wartość';
$string['profiledeletecategory'] = 'Usuwanie kategorii';
$string['profiledeletefield'] = 'Usuwanie pola \'{$a}\'';
$string['profiledescription'] = 'Opis pola';
$string['profiledscript'] = 'Ten skrypt został sprofilowany';
$string['profiledscriptview'] = 'Zobacz informacje profilowania dla tego skryptu';
$string['profileeditcategory'] = 'Edycja kategorii: {$a}';
$string['profileeditfield'] = 'Edycja pola profilu: {$a}';
$string['profilefield'] = 'Pole profilu';
$string['profilefieldcolumns'] = 'Kolumny';
$string['profilefieldispassword'] = 'Czy jest to pole hasła?';
$string['profilefieldlink'] = 'Link';
$string['profilefieldlink_help'] = 'Aby przekształcić tekst na link, należy wpisać adres URL zawierający znak $$, gdzie $$ zostanie zastąpiony tekstem. Na przykład, aby przekształcić Twitter ID na link, wprowadź http://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Miejsce docelowe linku';
$string['profilefieldmaxlength'] = 'Limit znaków';
$string['profilefieldmaxlength_help'] = 'Aby użyć tego pola w ustawieniu „Pokaż tożsamość użytkownika”, limit musi wynosić 255 znaków lub mniej.';
$string['profilefieldrows'] = 'Wiersze';
$string['profilefields'] = 'Pola w profilu użytkownika';
$string['profilefieldsize'] = 'Wielkość wyświetlania';
$string['profileforceunique'] = 'Czy dane powinny być unikalne?';
$string['profileinvaliddata'] = 'Niewłaściwa wartość';
$string['profilelocked'] = 'Czy to pole jest zablokowane?';
$string['profilemenudefaultnotinoptions'] = 'Wartość domyślna nie jest jedną z dostępnych opcji';
$string['profilemenunooptions'] = 'Nie podano opcji menu';
$string['profilemenuoptions'] = 'Opcje menu (jedna na linię)';
$string['profilemenutoofewoptions'] = 'Musisz wprowadzić co najmniej 2 opcje';
$string['profilename'] = 'Nazwa';
$string['profilenofieldsdefined'] = 'Żadne pole nie zostało zdefiniowane';
$string['profilerequired'] = 'Czy to pole jest wymagane?';
$string['profileroles'] = 'Widoczne role profilu';
$string['profilesforenrolledusersonly'] = 'Profile jedynie dla zapisanych użytkowników';
$string['profileshortname'] = 'Krótka nazwa (musi być unikalna)';
$string['profileshortnameinvalid'] = 'Ta krótka nazwa może zawierać wyłącznie znaki alfanumeryczne (litery i cyfry) lub podkreślenie (_).';
$string['profileshortnamenotunique'] = 'Ta krótka nazwa jest już używana';
$string['profilesignup'] = 'Wyświetlić na stronie zapisów?';
$string['profilespecificsettings'] = 'Specyficzne ustawienia';
$string['profilevisible'] = 'Dla kogo jest widoczne to pole?';
$string['profilevisible_help'] = '* Nie widoczny - tylko dla prywatnych informacji widzianych przez administratora
* Widoczny dla użytkownika - tylko dla prywatnych informacji widzianych przez użytkownika oraz administratora
* Widoczne dla użytkownika, nauczycieli i administratorów - tylko dla prywatnych informacji widzianych przez użytkownika, administratorów i nauczycieli (w profilu kursu).
* Widoczny dla wszystkich';
$string['profilevisibleall'] = 'Widoczny dla wszystkich';
$string['profilevisiblenone'] = 'Nie widoczny';
$string['profilevisibleprivate'] = 'Widoczny dla użytkownika';
$string['profilevisibleteachers'] = 'Widoczne dla użytkownika, nauczycieli i administratorów';
$string['profiling'] = 'Profilowanie';
$string['profilingallowall'] = 'Ciągłe profilowanie';
$string['profilingallowall_help'] = 'Jeśli włączysz to ustawienie, w dowolnym momencie można użyć gdziekolwiek parametru PROFILEALL, aby włączyć profilowanie wszystkich skryptów wykonywanych w tej sesji Moodle. Analogicznie, można użyć parametru PROFILEALLSTOP, aby zatrzymać profilowanie.';
$string['profilingallowme'] = 'Profilowanie selektywne';
$string['profilingallowme_help'] = 'Jeśli włączysz to ustawienie, możesz użyć gdziekolwiek parametru PROFILEME, aby włączyć profilowanie konkretnego skryptu. Analogicznie można użyć parametru DONTPROFILEME, aby wyłączyć profilowanie.';
$string['profilingautofrec'] = 'Automatyczne profilowanie';
$string['profilingautofrec_help'] = 'Jesli skonfigurujesz to ustawienie, niektóre żądania (losowo, na podstawie określonej częstości - 1 z N) zostaną wybrane i automatycznie profilowane, a wyniki będą przechowane do dalszej analizy. Zauważ, że ten sposób profilowania uznaje ustawienia włączenia/wykluczenia profilowania. Ustaw na 0, aby wyłączyć automatyczne profilowanie.';
$string['profilingenabled'] = 'Włącz profilowanie';
$string['profilingenabled_help'] = 'Jeśli to ustawienie zostanie włączone, wtedy profilowanie będzie dostępne na tej stronie i będziesz mógł określić jego zachowanie poprzez konfigurację następnej opcji.';
$string['profilingexcluded'] = 'Wyklucz profilowanie';
$string['profilingexcluded_help'] = 'Lista adresów URL, które będą wyłączone z profilowania spośród tych, określonych jako "Skrypty do profilowania". (Lista rozdzielona przecinkami, adresy absolutne pomijając wwwroot, dające się wywołać)';
$string['profilingimportprefix'] = 'Profilowany przedrostek importu';
$string['profilingimportprefix_desc'] = 'Dla łatwiejszego wykrywania, wszystkie importowane działa profilowania zostaną poprzedzone z podaną tutaj wartością.';
$string['profilingincluded'] = 'Skrypty do profilowania';
$string['profilingincluded_help'] = 'Lista adresów URL, które będą automatycznie profilowane. (Lista rozdzielona przecinkami, adresy absolutne pomijając wwwroot, dające się wywołać) Przykłady: /index.php, /course/view.php. Znaki specjalne * są akceptowane w dowolnej pozycji. Przykłady: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Przechowaj przebiegi profilowania przez';
$string['profilinglifetime_help'] = 'Określ czas, przez który chcesz zachować informacje o starych przebiegach profilowania. Starsze będą usuwane okresowo. Zauważ, że tonie dotyczy profilowanie oznaczonego jako \'przebieg odniesienia\'.';
$string['profilingslow'] = 'Sprofiluj wolne strony';
$string['profilingslow_help'] = 'Ustawiając minimalny czas w sekundach, wszystkie wolniejsze strony zostaną sprofilowane. Tylko profile, które są wolniejsze niż istniejący profil dla tego samego skryptu, zostaną zachowane. Ustaw na 0, aby wyłączyć. Należy pamiętać, że jest to zgodne z ustawieniami wykluczeń.';
$string['protectusernames'] = 'Chroń nazwę użytkownika';
$string['proxybypass'] = 'Hosty, które omijają proxy';
$string['proxyfixunsafe'] = 'Napraw połączenia bez proxy';
$string['proxyhost'] = 'Host proxy';
$string['proxylogunsafe'] = 'Rejestruj połączenia bez proxy';
$string['proxypassword'] = 'Hasło proxy';
$string['proxyport'] = 'Port proxy';
$string['proxytype'] = 'Typ proxy';
$string['proxyuser'] = 'Nazwa użytkownika proxy';
$string['purgecaches'] = 'Wyczyść wszystkie bufory pamięci podręcznej';
$string['purgecachesconfirm'] = 'Moodle może buforować motywy graficzne, JavaScript, łańcuchy językowe, przefiltrowany tekst, kanały RSS i wiele innych przetworzonych danych. Czyszczenie tych buforów  usuwa te dane z serwera i powoduje, że przeglądarek pobierają danych ponownie, dzięki czemu można mieć pewność, że wyświetlają się najnowsze dane produkowane przez aktualny kod. Czyszczenie pamięci podręcznej nie jest niebezpieczne, ale Twoja strona może przez chwilę działać wolniej, zanim bufory zapełnią się ponownie.';
$string['purgecachesfinished'] = 'Wszystkie bufory pamięci podręcznej zostały wyczyszczone.';
$string['purgecachesnoneselected'] = 'Wybierz jeden lub więcej typów pamięci podręcznej do wyczyszczenia';
$string['purgecachespage'] = 'Wyczyść pamięć podręczną';
$string['purgecoursecache'] = 'Kursy';
$string['purgefiltercache'] = 'Filtry tekstu';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Ciągi językowe';
$string['purgemuc'] = 'Pamięć MUC (Moodle Universal Cache)';
$string['purgeothercaches'] = 'Podręczne pliki i wszystkie inne';
$string['purgeselectedcaches'] = 'Wyczyść wybrane bufory pamięci';
$string['purgeselectedcachesfinished'] = 'Wybrane bufory pamięci podręcznej zostały wyczyszczone.';
$string['purgetemplates'] = 'Szablony';
$string['purgethemecache'] = 'Motywy';
$string['query'] = 'Zapytanie';
$string['question'] = 'Pytanie';
$string['questionbehaviours'] = 'Zachowanie pytań';
$string['questioncwqpfscheck'] = 'Jedno lub więcej losowych pytań w teście jest skonfigurowanych tak, aby wybrać pytania z kombinacji kategorii pytań wspólnych i nieudostępnionych. Zobacz <a href="{$a->reporturl}">raport pytań losowych</a> i <a href="{$a->docsurl}">dokumentację</a>.';
$string['questioncwqpfsok'] = 'Dobrze. W testach nie ma pytań "Losowych", które pobierałyby pytania ze współdzielonych i nie współdzielonych kategorii.';
$string['questiontype'] = 'Rodzaj pytania';
$string['questiontypes'] = 'Rodzaje pytań';
$string['quizattemptsupgradedmessage'] = 'W Moodle 2.1 było ważne uaktualnienie dla pytań. Była możliwość opóźnienia części aktualizacji bazy danych, które mogły być uruchomione później. Przed aktualizacją do Moodle 2.7, ta aktualizacja musi być ukończona.';
$string['recaptchaprivatekey'] = 'ReCAPTCHA, klucz sekretny';
$string['recaptchapublickey'] = 'ReCAPTCHA, klucz strony';
$string['referrernone'] = 'Domyślna przeglądarka';
$string['referrerpolicy'] = 'Zasady dotyczące stron odsyłających';
$string['referrerpolicydesc'] = 'Ustaw nagłówek zasad dotyczących stron odsyłających, który będzie dołączany do odpowiedzi z Twojej witryny.';
$string['register'] = 'Zarejestruj swoją stronę';
$string['registration'] = 'Rejestracja';
$string['registration_help'] = 'Rejestrując się:

* Otrzymasz alerty bezpieczeństwa
* Możesz aktywować powiadomienia push aplikacji mobilnej ze swojej strony
* Wnosisz wkład do naszych statystyk Moodle dotyczących światowej społeczności';
$string['registrationwarning'] = 'Nie przegap ważnych aktualizacji i alertów bezpieczeństwa.';
$string['registrationwarningcontactadmin'] = 'Ta strona nie jest zarejestrowana. Poproś administratora o zarejestrowanie strony, aby nie przegapił ważnych aktualizacji.';
$string['releasenoteslink'] = 'Aby zapoznać się z informacjami na temat tej wersji Moodla przeczytaj informacje zawarte w <a target="_blank" href="{$a}">Release Notes</a>.';
$string['rememberuserlicensepref'] = 'Zapamiętaj preferencje użytkownika dotyczące licencji';
$string['rememberuserlicensepref_help'] = 'Jeśli jest włączona, ostatnia licencja wybrana przez użytkownika jest wstępnie wybierana podczas przesyłania pliku w selektorze plików. W przeciwnym razie wstępnie wybrana jest domyślna licencja witryny.';
$string['rememberusername'] = 'Zapamiętaj login';
$string['rememberusername_desc'] = 'Włącz, jeśli chcesz przechowywać trwałe ciasteczka z nazwą użytkownika. Trwałe pliki cookie mogą być uznane za zagrożenie prywatności, jeśli są używane bez zgody.';
$string['replacefrontsearch'] = 'Używany do wyszukiwania kursów w witrynie';
$string['reportsmanage'] = 'Zarządzaj raportami';
$string['required'] = 'Wymagane';
$string['requiredentrieschanged'] = 'Uwaga: Po uaktualnieniu ustawienie „Wpisy wymagane przed wyświetleniem” jest teraz wymuszane w następujących aktywnościach bazy danych:<br/>{$a->text}<br/>';
$string['requiremodintro'] = 'Wymagaj opisu aktywności';
$string['requiremodintro_desc'] = 'Jeśli opcja będzie włączona, użytkownicy będą zmuszeni do wprowadzenia opisu dla każdej aktywności.';
$string['requires'] = 'Wymagania';
$string['resetindentation'] = 'Zresetuj wcięcia w całej witrynie';
$string['resetindentation_help'] = 'Spowoduje to usunięcie wszelkich wcięć ustawionych wcześniej we wszystkich kursach w witrynie {$a->format}.';
$string['resetindentation_title'] = 'Zresetować wcięcia w całej witrynie?';
$string['resetindentationsuccess'] = 'Reset wcięcia.';
$string['restorecourse'] = 'Odtwórz kurs';
$string['restorernewroleid'] = 'Rola w kursie po odtworzeniu';
$string['restorernewroleid_help'] = 'Jeśli użytkownik nie ma jeszcze uprawnień do zarządzania nowo przywróconym kursem, jest on automatycznie przypisywany do tej roli i w razie potrzeby zapisywany. Wybierz "Żaden", jeśli nie chcesz, aby osoby, które przywróciły kurs, mogły zarządzać każdym przywróconym kursem.';
$string['resultfilter'] = 'Filtruj wg. wyników';
$string['reverseproxy'] = 'Odwrotne proxy';
$string['reverseproxyignore'] = 'Ignoruj wszystkie reverse proxy';
$string['riskconfig'] = 'Użytkownicy mogą zmieniać konfigurację i zachowanie strony';
$string['riskconfigshort'] = 'Zagrożenie konfiguracji';
$string['riskdataloss'] = 'Użytkownicy mogą zniszczyć duże ilości danych';
$string['riskdatalossshort'] = 'Ryzyko utraty danych';
$string['riskmanagetrust'] = 'Użytkownicy mogą zmieniać zaufane ustawienia innych użytkowników';
$string['riskmanagetrustshort'] = 'Zarządzaj zaufaniami';
$string['riskpersonal'] = 'Użytkownicy mogą uzyskać dostęp do prywatnych danych innych użytkowników';
$string['riskpersonalshort'] = 'Zagrożenie prywatności';
$string['riskspam'] = 'Użytkownicy mogą wysyłać spam do użytkowników strony lub innych użytkowników';
$string['riskspamshort'] = 'Zagrożenie spamem';
$string['riskxss'] = 'Użytkownicy mogą dodawać pliki i teksty które pozwalają na cross-site scripting (XSS)';
$string['riskxssshort'] = 'Zagrożenie XSS';
$string['roleswithexceptions'] = '{$a->roles} z {$a->exceptions}';
$string['rssglobaldisabled'] = 'Wyłączone na poziomie strony';
$string['save'] = 'Zapisz';
$string['savechanges'] = 'Zapisz zmiany';
$string['scssinvalid'] = 'Kod SCSS jest nieprawidłowy, zawiodło: {$a}';
$string['search'] = 'Wyszukaj';
$string['searchablecourses'] = 'Kursy z możliwością wyszukiwania';
$string['searchallavailablecourses'] = 'Kursy do przeszukiwania';
$string['searchallavailablecourses_desc'] = 'W niektórych sytuacjach wyszukiwarka może nie działać podczas przeszukiwania dużej liczby kursów. Ustaw wyszukiwanie tylko zapisanych kursów, jeśli chcesz ograniczyć liczbę przeszukiwanych kursów.';
$string['searchallavailablecourses_off'] = 'Szukaj tylko w zapisanych kursach';
$string['searchallavailablecourses_on'] = 'Szukaj we wszystkich kursach, do których użytkownik ma dostęp';
$string['searchallavailablecoursesdesc'] = 'W przypadku ustawienia wyszukiwania tylko w obrębie zapisanych kursów, informacje o kursie (nazwa i podsumowanie) oraz zawartość kursu będą wyszukiwane tylko w kursach, do których użytkownik jest zapisany. W przeciwnym razie informacje o kursie i zawartość kursu będą wyszukiwane we wszystkich kursach, do których użytkownik ma dostęp, takich jak kursy z włączonym dostępem gościa.';
$string['searchalldeleted'] = 'Cała zindeksowana zawartość została usunięta';
$string['searchalternatesettings'] = 'Alternatywne ustawienia dla zapytań';
$string['searchalternatesettings_desc'] = 'Po uzupełnieniu tych ustawień można wybrać "ustawienia alternatywne" dla tej wyszukiwarki w opcji wyszukiwarki tylko dla zapytań na stronie "Zarządzaj globalnym wyszukiwaniem". Jest to przydatne tylko w przypadku przechodzenia między dwiema wyszukiwarkami tego samego typu.';
$string['searchareadisabled'] = 'Pole wyszukiwania wyłączone';
$string['searchareaenabled'] = 'Pole wyszukiwania włączone';
$string['searchareas'] = 'Pole wyszukiwania';
$string['searchbanner'] = 'Informacje o wyszukiwaniu';
$string['searchbannerenable'] = 'Wyświetl informacje o wyszukiwaniu';
$string['searchbannerenable_desc'] = 'Jeśli ta opcja jest włączona, poniższy tekst będzie wyświetlany u góry ekranu wyszukiwania dla wszystkich użytkowników. Może to służyć do informowania użytkowników o przeprowadzaniu konserwacji wyszukiwarki.';
$string['searchdefaultcategory'] = 'Domyślna kategoria wyszukiwania';
$string['searchdefaultcategory_desc'] = 'Wyniki z wybranej kategorii obszaru wyszukiwania zostaną wyświetlone jako domyślne.';
$string['searchdeleteindex'] = 'Usuń całą zindeksowaną zawartość';
$string['searchdisplay'] = 'Opcje wyświetlania wyników wyszukiwania';
$string['searchenablecategories'] = 'Wyświetlaj wyniki z podziałem na kategorie';
$string['searchenablecategories_desc'] = 'Jeśli ta opcja jest włączona, wyniki wyszukiwania będą wyświetlane w osobnych kategoriach.';
$string['searchengine'] = 'Silnik wyszukiwania';
$string['searchenginealternatesettings'] = '{$a} (ustawienia alternatywne)';
$string['searchenginequeryonly'] = 'Wyszukiwarka zapytań';
$string['searchenginequeryonly_desc'] = 'Ta wyszukiwarka będzie używana tylko do wykonywania zapytań, a nie indeksowania. Korzystając z tej funkcji, można ponownie indeksować w innej wyszukiwarce, podczas gdy zapytania użytkowników nadal działają z tej wyszukiwarki.';
$string['searchenginequeryonly_none'] = 'Brak (użyj głównej wyszukiwarki do zapytań)';
$string['searchenginequeryonlysame'] = 'Wyszukiwarka zapytań i wyszukiwarka główna nie mogą być ustawione na tę samą wartość.';
$string['searchhideallcategory'] = 'Ukryj wszystkie kategorie wyników';
$string['searchhideallcategory_desc'] = 'Jeśli ta opcja jest zaznaczona, kategoria ze wszystkimi wynikami zostanie ukryta na ekranie wyników wyszukiwania.';
$string['searchincludeallcourses'] = 'Uwzględnij wszystkie widoczne kursy';
$string['searchincludeallcourses_desc'] = 'Jeśli opcja ta jest włączona, wyniki wyszukiwania będą zawierać informacje o kursach (nazwę i podsumowanie), które są widoczne dla użytkownika, nawet jeśli nie ma on dostępu do treści kursu.';
$string['searchindexactions'] = 'Akcje indeksowania';
$string['searchindexdeleted'] = 'Indeks usunięty';
$string['searchindextime'] = 'Limit czasu indeksowania';
$string['searchindextime_desc'] = 'Podczas indeksowania dużych ilości nowych treści zaplanowane zadanie zostanie zatrzymane po osiągnięciu tego limitu czasowego. Będzie kontynuowany przy następnym uruchomieniu zadania.';
$string['searchindexupdated'] = 'Zawartość sinika wyszukiwania została zaktualizowana';
$string['searchindexwhendisabled'] = 'Indeksuj, gdy wyłączone';
$string['searchindexwhendisabled_desc'] = 'Zezwala zaplanowanemu zadaniu na budowanie indeksu wyszukiwania nawet po wyłączeniu wyszukiwania. Jest to przydatne, jeśli chcesz zbudować indeks przed uaktywnieniem studentom możliwości wyszukiwania.';
$string['searchinsettings'] = 'Wyszukaj w ustawieniach';
$string['searchlastrun'] = 'Ostatnie uruchomienie (czas, # dokumenty, # rekordy, # zignorowane)';
$string['searchmanagement'] = 'Zarządzanie wyszukiwaniem';
$string['searchmanagement_desc'] = 'Opcje te są przydatne podczas wprowadzania zmian w witrynach z bardzo dużymi indeksami wyszukiwania, których odbudowa zajmuje dużo czasu.';
$string['searchmaxtopresults'] = 'Maksymalnie najlepsze wyniki';
$string['searchmaxtopresults_desc'] = 'Maksymalna liczba najwyżej sklasyfikowanych wyników, które mają być wyświetlane nad wynikami wyszukiwania treści kursu, kursów i użytkowników.';
$string['searchnotavailable'] = 'Wyszukiwanie nie jest dostępne';
$string['searchoptions'] = 'Opcje wyszukiwania';
$string['searchpartial'] = '(jeszcze nie w pełni zindeksowane)';
$string['searchreindexed'] = 'Cała zawartośc stron została ponownie zaindeksowana.';
$string['searchreindexindex'] = 'Przeindeksuj całą zawartość strony';
$string['searchresults'] = 'Wyniki wyszukiwania';
$string['searchsetupinfo'] = 'Ustawienia wyszukiwania';
$string['searchteacherroles'] = 'Role nauczyciela';
$string['searchteacherroles_desc'] = 'Wybierz wszystkie role, które sprawiają, że użytkownicy z roli są wyżej w wynikach wyszukiwania.';
$string['searchtopresults'] = 'Najlepsze wyniki';
$string['searchupdateindex'] = 'Zaktualizuj indeksowaną zawartość';
$string['sectionerror'] = 'Błąd sekcji!';
$string['secureforms'] = 'Użyj dodatkowej ochrony formularza';
$string['security'] = 'Ochrona';
$string['selectsearchengine'] = 'Wybierz silnik wyszukiwania';
$string['server'] = 'Serwer';
$string['serverchecks'] = 'Kontrola serwera';
$string['serverlimit'] = 'Limit serwera';
$string['servicespage'] = 'Link do usług i wsparcia';
$string['sessionautostartwarning'] = '<p>Wykryto poważny błąd w konfiguracji, należy powiadomić administratora serwera. </p><p> Aby Moodle działał prawidłowo, administrator musi zmienić ustawienia PHP. </p><p> <code>session.auto_start</code> musi być ustawione na <code>off</code> . </p><p> Należy to zmienić poprzez edycję pliku <code>php.ini</code>, konfiguracji Apache/IIS lub <code>.htaccess</code> na serwerze. </p>';
$string['sessioncookie'] = 'Prefiks pliku cookie';
$string['sessioncookiedomain'] = 'Domena cookie';
$string['sessioncookiepath'] = 'Ścieżka do pliku cookie';
$string['sessionhandling'] = 'Obsługa sesji';
$string['sessiontimeout'] = 'Limit czasu';
$string['sessiontimeoutwarning'] = 'Ostrzeżenie o przekroczeniu limitu czasu';
$string['settingdependenton'] = 'To ustawienie może być ukryte na podstawie wartości <strong>{$a}</strong>.';
$string['settingfileuploads'] = 'Przesyłanie plików  jest wymagane do normalnej pracy, proszę włączyć tą opcję w konfiguracji PHP.';
$string['settingmaxinputvars'] = 'Zaleca się, aby ustawienie PHP max_input_vars miało wartość co najmniej 5000.';
$string['settingmaxinputvarsrequired'] = 'Ustawienie PHP max_input_vars musi wynosić co najmniej 5000.';
$string['settingmemorylimit'] = 'Wykryto za mało pamięci, ustaw większy limit pamięci w ustawieniach PHP.';
$string['settingsafemode'] = 'Moodle nie jest w pełni kompatybilny z trybem awaryjnym, należy poprosić administratora serwera, aby go wyłączył. Używanie Moodle w trybie awaryjnym nie jest obsługiwane i należy spodziewać się różnych problemów.';
$string['settingzendexceptionignoreargs'] = 'Ze względów bezpieczeństwa zdecydowanie zaleca się włączenie ustawienia PHP zend.exception_ignore_args.';
$string['setupsearchengine'] = 'Ustaw silnik wyszukiwania';
$string['showcommentscount'] = 'Pokaż licznik komentarzy';
$string['showdetails'] = 'Pokaż szczegóły';
$string['showuseridentity'] = 'Pokazuj dodatkowo pola';
$string['showuseridentity_desc'] = 'Podczas wybierania lub poszukiwania i wyświetlania listy użytkowników, pola te mogą być wyświetlane obok pełnej nazwy użytkownika. Pola są widoczne tylko dla użytkowników, którzy mają uprawnienie moodle/site:viewuseridentity, domyślnie, nauczycieli i managerów. (Ta opcja może mieć zastosowanie w instytucji, gdzie dodatkowe jedno lub dwa pola są obowiązkowe).';
$string['simplexmlrequired'] = 'Rozszerzenie PHP SimpleXML jest teraz wymagane przez Moodle.';
$string['sitemailcharset'] = 'Zbiór znaków';
$string['sitemaintenance'] = 'Trwają prace administracyjne. Strona jest chwilowo niedostępna.';
$string['sitemaintenancemode'] = 'Tryb konserwacji';
$string['sitemaintenanceoff'] = 'Tryb konserwacji został wyłączony i strona jest wyświetlana normalnie';
$string['sitemaintenanceon'] = 'Strona jest aktualnie w trybie konserwacji (tylko administratorzy mogą się logować i używać stronę)';
$string['sitemaintenanceoncli'] = 'Twoja strona jest aktualnie w trybie konserwacji CLI, żadny dostęp do strony nie jest dozwolony.';
$string['sitemaintenancetitle'] = '{$a} w trybie konserwacji';
$string['sitemaintenancewarning'] = 'Strona jest aktualnie w trybie konserwacji (tylko administratorzy mogą się logować). Aby włączyć normalny tryb strony, <a href="maintenance.php">wyłącz tryb konserwacji</a>.';
$string['sitemaintenancewarning2'] = 'Twoja strona jest aktualnie w trybie konserwacji (tylko administratorzy mogą się logować). Aby wrócić do normalnej pracy, <a href="{$a}">wyłącz tryb konserwacji</a>.';
$string['sitemenubar'] = 'Nawigacja strony';
$string['sitenameintitle'] = 'Uwzględnij nazwę witryny w tytule strony';
$string['sitenameintitle_help'] = 'To ustawienie spowoduje dołączenie nazwy witryny na końcu tytułu strony. Zaleca się umieszczanie nazwy witryny w tytule strony, ponieważ poprawi to dostępność witryny, umożliwiając użytkownikom szybką identyfikację strony, na której aktualnie się znajdują.';
$string['sitepolicies'] = 'Ustawienia zabezpieczeń witryny';
$string['sitepolicy'] = 'URL strony regulaminu';
$string['sitepolicy_help'] = 'Jeśli masz ustawioną politykę zarządzania stroną, na którą wszyscy użytkownicy musza się zgodzić przed skorzystaniem ze strony, wówczas ustaw tutaj URL, w przeciwnym razie pozostaw to pole pustym. URL może wskazywać gdziekolwiek – dogodnym miejscem będzie plik pośród plików strony. Np. http://yoursite/file.php/1/policy.html';
$string['sitepolicyguest'] = 'URL strony regulaminu dla gości';
$string['sitepolicyguest_help'] = 'Adres URL zasad witryny, które wszyscy goście muszą zobaczyć i wyrazić zgodę przed uzyskaniem dostępu do witryny. Zauważ, że to ustawienie będzie działało tylko wtedy, gdy funkcja obsługi zasad serwisu jest ustawiona na wartość domyślną (rdzeń).';
$string['sitepolicyhandler'] = 'Przewodnik po polityce / zasadach strony';
$string['sitepolicyhandler_desc'] = 'Określa sposób zarządzania politykami i zgodami użytkownika. Domyślny (podstawowy) moduł obsługi umożliwia określenie adresu URL zasad witryny i adresu URL zasad witryny dla gości. Procedura postępowania z politykami umożliwia ustawienie polityki strony, prywatności i innych zasad. Umożliwia także przeglądanie zgody użytkownika oraz, w razie potrzeby, zgodę w imieniu osób niepełnoletnich.';
$string['sitepolicyhandlercore'] = 'Domyślny (rdzeń)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'Jeżeli wybrane, sekcja tematu zostanie wyświetlona na stronie głównej serwisu';
$string['sixtyfourbitsrequired'] = 'Wykryto, że Twoja witryna nie korzysta z 64-bitowej wersji PHP. Przed zainstalowaniem tej wersji Moodle musisz zaktualizować swój system (system operacyjny, PHP...).';
$string['sixtyfourbitswarning'] = 'Wykryto, że Twoja witryna nie używa 64-bitowej wersji PHP. Zaleca się uaktualnienie witryny w celu zapewnienia przyszłej zgodności.';
$string['slasharguments'] = 'Oddzielaj argumenty znakiem slash';
$string['slashargumentswarning'] = 'Zalecane jest użycie argumentów slash. W przyszłości będzie to wymagane. Aby uzyskać więcej informacji, zobacz dokumentację <a href="https://docs.moodle.org/en/admin/environment/slasharguments">Używanie argumentów slash.</a>';
$string['smallscreensonly'] = 'Tylko małe ekrany';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'Typ autoryzacji SMTP';
$string['smtpdetail'] = 'Ustawienia protokołu SMTP (Simple Mail Transfer Protocol) do wysyłania wiadomości e-mail.';
$string['smtphosts'] = 'Nazwa serwera SMTP';
$string['smtpmaxbulk'] = 'limit sesji SMTP';
$string['smtppass'] = 'Hasło SMTP';
$string['smtpsecure'] = 'Bezpieczeństwo SMTP';
$string['smtpuser'] = 'Nazwa użytkownika SMTP';
$string['soaprecommended'] = 'Zainstalowanie opcjonalnego rozszerzenia SOAP jest przydatne dla usług internetowych i niektórych wtyczek.';
$string['sort_fullname'] = 'Pełna nazwa kursu';
$string['sort_idnumber'] = 'Numer ID kursu';
$string['sort_shortname'] = 'Krótka nazwa kursu';
$string['sort_sortorder'] = 'Porządek sortowania';
$string['spellengine'] = 'Narzędzie sprawdzające pisownię';
$string['spelllanguagelist'] = 'Listę języków do sprawdzania pisowni';
$string['splrequired'] = 'Rozszerzenie PHP SPL jest obecnie wymagane przez Moodle.';
$string['stats'] = 'Statystyka';
$string['statsfirstrun'] = 'Maksymalny interwał przetwarzania';
$string['statsmaxruntime'] = 'Maksymalny czas wykonywania';
$string['statsmoodleorg'] = 'statystyk';
$string['statsruntimedays'] = 'Dni do przetworzenia';
$string['statsruntimestart'] = 'Wykonaj o';
$string['statsuserthreshold'] = 'Próg użytkownika';
$string['stickyblocks'] = 'Przylegające bloki';
$string['stickyblockscourseview'] = 'Strona kursu';
$string['stickyblocksduplicatenotice'] = 'Jeśli jakikolwiek blok dodany w tym miejscu istnieje już na pojedynczej stronie, spowoduje to stworzenie duplikatu. <br /> Jedynie załączony plik będzie nie edytowalny, duplikat ciągle pozostanie edytowalny';
$string['stickyblocksmymoodle'] = 'Moja strona domowa (Mój Moodle)';
$string['stickyblockspagetype'] = 'Typ strony do konfiguracji';
$string['strictformsrequired'] = 'Ścisłe sprawdzanie wymaganych pól';
$string['stripalltitletags'] = 'Usuń tagi HTML ze wszystkich nazw aktywności';
$string['supportandservices'] = 'Wsparcie i usługi';
$string['supportavailability'] = 'Dostępność wsparcia';
$string['supportcontact'] = 'Kontakt wsparcia';
$string['supportemail'] = 'Email wsparcia';
$string['supportemailsubject'] = '{$a} - prośba o pomoc';
$string['supportname'] = 'Nazwa wsparcia';
$string['supportpage'] = 'Strona wsparcia';
$string['suspenduser'] = 'Zawieś konto użytkownika';
$string['switchlang'] = 'Zmień katalog języków';
$string['systempaths'] = 'Ścieżki systemowe';
$string['tablenosave'] = 'Zmiany w powyższej tabeli są zapisywane automatycznie.';
$string['tablesnosave'] = 'Zmiany w powyższej tabeli są zapisywane automatycznie.';
$string['tabselectedtofront'] = 'W tabeli zakładkami, wiersz z aktualnym zaznaczeniem powinnien znaleźć się na początku';
$string['tabselectedtofronttext'] = 'Przenieść wybrany wiersz tabeli na wierzch';
$string['task_adhoc_concurrency_limit'] = 'Limit współbieżnych zadania ad hoc';
$string['task_adhoc_concurrency_limit_desc'] = 'Liczba modułów uruchamiających zadania ad hoc, które mogą być uruchamiane jednocześnie. Jeśli limit jest wysoki, zaplanowane zadania mogą nie być uruchamiane regularnie, gdy jest dużo zadań ad hoc. Ustawienie wartości 0 wyłączy przetwarzanie zadań ad hoc.';
$string['task_adhoc_failed_retention'] = 'Okres przechowywania nieudanych zadań ad hoc';
$string['task_adhoc_failed_retention_desc'] = 'Maksymalny okres, przez który zakończone niepowodzeniem zadania ad hoc, będą przechowywane w kolejce po osiągnięciu limitu ponownych prób uruchomienia.';
$string['task_adhoc_max_runtime'] = 'Czas życia modułu uruchamiającego zadania ad hoc';
$string['task_adhoc_max_runtime_desc'] = 'Czas życia modułu uruchamiającego zadania ad hoc zanim zostanie zakończony. Zalecany jest krótki czas życia, ponieważ nie ma ograniczeń co do liczby zadań ad hoc umieszczonych w kolejce.';
$string['task_dbreads'] = 'Zapisy do bazy danych';
$string['task_dbstats'] = 'Baza danych';
$string['task_dbwrites'] = 'Odczyty z bazy danych';
$string['task_duration'] = 'Okres';
$string['task_endtime'] = 'Koniec czasu';
$string['task_logmode'] = 'Kiedy logować';
$string['task_logmode_all'] = 'Przechowuj logi wyjściowe wszystkich zadań';
$string['task_logmode_desc'] = 'Możesz wybrać, kiedy ma być rejestrowane zadanie. Domyślnie dzienniki są zawsze rejestrowane. Można całkowicie wyłączyć rejestrowanie lub zmienić na rejestrowanie tylko tych zadań, które zakończyły się niepowodzeniem.';
$string['task_logmode_failonly'] = 'Przechowuj logii tylko dla zadań, które zakończyły się niepowodzeniem';
$string['task_logmode_none'] = 'Nie loguj niczego';
$string['task_logoutput'] = 'Dane wyjściowe zadania';
$string['task_logretainruns'] = 'Zachowaj przebiegi';
$string['task_logretainruns_desc'] = 'Liczba przebiegów każdego zadania do zachowania. To ustawienie współdziała z ustawieniem "Okres przechowywania": zastosowane zostanie to, które zostanie osiągnięte jako pierwsze.';
$string['task_logretention'] = 'Okres przechowywania';
$string['task_logretention_desc'] = 'Maksymalny okres przechowywania dzienników. To ustawienie współdziała z ustawieniem "Zachowaj przebiegi": zastosowane zostanie to, które zostanie osiągnięte jako pierwsze.';
$string['task_logtostdout'] = 'Wyświetlanie wyjścia';
$string['task_logtostdout_desc'] = 'Gdy zadania są uruchomione, a dane wyjściowe są przechwytywane, czy przechwycone dane wyjściowe powinny być również wyświetlane podczas wykonywania zadania.';
$string['task_result'] = 'Wynik';
$string['task_result:failed'] = 'Nie udało się';
$string['task_scheduled_concurrency_limit'] = 'Limit współbieżnych zaplanowanych zadań';
$string['task_scheduled_concurrency_limit_desc'] = 'Liczba modułów uruchamiania zaplanowanych zadań, które mogą być uruchamiane jednocześnie. Jeśli limit jest wysoki, serwer może doświadczyć dużego obciążenia, co ma wpływ na wydajność. Ustawienie wartości 0 całkowicie wyłączy przetwarzanie zaplanowanych zadań.';
$string['task_scheduled_max_runtime'] = 'Czas życia modułu uruchamiającego zaplanowane zadania';
$string['task_scheduled_max_runtime_desc'] = 'Czas życia modułu uruchamiającego zaplanowane zadania przed jego zwolnieniem.';
$string['task_starttime'] = 'Czas początkowy';
$string['task_stats:dbreads'] = 'odczytów: {$a}';
$string['task_stats:dbwrites'] = 'zapisów: {$a}';
$string['task_status'] = 'Status zadania';
$string['task_status_desc'] = 'Zadanie \'{$a->name}\' ma status {$a->status}. Aby uzyskać szczegółowe informacje, zobacz {$a->class}{$a->extradescription} w <a href="{$a->gotourl}">Zaplanowane zadania</a>.';
$string['task_type:adhoc'] = 'Ad hoc';
$string['task_type:scheduled'] = 'Zaplanowany';
$string['taskadmintitle'] = 'Zadanie';
$string['taskanalyticscleanup'] = 'Czyszczenie analiz';
$string['taskautomatedbackup'] = 'Automatyczne tworzenie kopii zapasowych';
$string['taskautomatedbackup_report'] = 'Raport automatycznych kopii zapasowych';
$string['taskbackupcleanup'] = 'Wyczyść tabele kopii zapasowych, dzienniki i pliki';
$string['taskbadgesadhoc'] = 'Przyznaj odznaki';
$string['taskbadgescron'] = 'Przyznaj odznaki';
$string['taskbadgesmessagecron'] = 'Przetwarzanie w tle w celu wysyłania powiadomień odznak';
$string['taskblogcron'] = 'Synchronizuj zewnętrzne blogi';
$string['taskcachecleanup'] = 'Usuń wygasłe wpisy pamięci podręcznej';
$string['taskcachecron'] = 'Przetwarzanie w tle dla pamięci podręcznej';
$string['taskcalendarcron'] = 'Wyślij powiadomienia kalendarza';
$string['taskcheckforupdates'] = 'Sprawdź aktualizacje';
$string['taskcompletiondaily'] = 'Oznaczenie ukończenia jako rozpoczęte';
$string['taskcompletionregular'] = 'Oblicz standardowe dane ukończenia';
$string['taskcontextcleanup'] = 'Wyczyść konteksty';
$string['taskcreatecontexts'] = 'Utwórz brakujące konteksty';
$string['taskdeleteincompleteusers'] = 'Usuń niekompletnych użytkowników';
$string['taskdeleteunconfirmedusers'] = 'Usuń niepotwierdzonych użytkowników';
$string['taskeventscron'] = 'Przetwarzanie w tle dla wydarzeń';
$string['taskfiletrashcleanup'] = 'Wyczyść kosz z plików';
$string['taskglobalsearchindex'] = 'Indeksowanie globalnego wyszukiwania';
$string['taskglobalsearchoptimize'] = 'Optymalizacja indeksu globalnego wyszukiwania';
$string['taskgradecron'] = 'Przetwarzanie w tle dla dziennika ocen';
$string['taskgradehistorycleanup'] = 'Przetwarzanie w tle w celu czyszczenia tabeli historii ocen';
$string['taskh5pcleanup'] = 'Czyszczenie nieużywanych plików H5P';
$string['tasklegacycron'] = 'Przetwarzanie zapisu cron dla wtyczek';
$string['tasklockcleanuptask'] = 'Wyczyść metadane zadania ad hoc';
$string['tasklogcleanup'] = 'Czyszczenie dziennika zadań';
$string['tasklogging'] = 'Konfiguracja dziennika zadań';
$string['tasklogs'] = 'Dzienniki zadań';
$string['taskmessagingcleanup'] = 'Przetwarzanie w tle dla wiadomości';
$string['taskpasswordresetcleanup'] = 'Oczyść reset haseł dla prób';
$string['taskplagiarismcron'] = 'Przetwarzanie w tle dla starszych wtyczek plagiatów';
$string['taskportfoliocron'] = 'Przetwarzanie w tle dla wtyczek portfela';
$string['taskprocessing'] = 'Przetwarzanie zadań';
$string['taskquestioncron'] = 'Przetwarzanie w tle w celu czyszczenia podglądu pytań';
$string['taskquestionstatscleanupcron'] = 'Przetwarzanie w tle w celu czyszczenia pamięci podręcznych statystyk pytań';
$string['taskrefreshsystemtokens'] = 'Odśwież tokeny OAuth dla kont serwisowych';
$string['taskregistrationcron'] = 'Rejestracja strony';
$string['tasksendfailedloginnotifications'] = 'Wyślij powiadomienie o niepowodzeniu logowania';
$string['tasksendnewuserpasswords'] = 'Wyślij hasła nowym użytkownikom';
$string['tasksessioncleanup'] = 'Oczyść ze starych sesji';
$string['taskstatscron'] = 'Przetwarzanie w tle dla statystyk';
$string['tasktagcron'] = 'Przetwarzanie w tle dla tagów';
$string['tasktempfilecleanup'] = 'Usuń nieaktualne pliki tymczasowe';
$string['tasktype'] = 'Typ';
$string['taskupdategeoip2file'] = 'Aktualizacja pliku GeoIP';
$string['tempdatafoldercleanup'] = 'Wyczyść tymczasowe pliki danych starsze niż';
$string['templates'] = 'Szablony';
$string['testoutgoingmailconf'] = 'Test konfiguracji poczty wychodzącej';
$string['testoutgoingmailconf_errorcommunications'] = 'Twoja witryna nie może komunikować się z serwerem poczty. Sprawdź konfigurację poczty wychodzącej.';
$string['testoutgoingmailconf_fromemail'] = 'Z nazwy użytkownika lub adresu e-mail';
$string['testoutgoingmailconf_fromemail_help'] = 'Pole to emuluje wysyłanie wiadomości od tego użytkownika, ale nagłówek From użyty w prawdziwej wiadomości e-mail będzie zależał od innych ustawień, takich jak dozwolone domeny internetowe.';
$string['testoutgoingmailconf_fromemail_invalid'] = 'Nieprawidłowa nazwa użytkownika lub adres e-mail. Musi to być prawidłowy format e-mail lub nazwa użytkownika istniejąca w Moodle.';
$string['testoutgoingmailconf_message'] = 'To jest wiadomość testowa, która potwierdza, że pomyślnie skonfigurowałeś pocztę wychodzącą z witryny. Wysłano: {$a}';
$string['testoutgoingmailconf_sendtest'] = 'Wyślij wiadomość tekstową';
$string['testoutgoingmailconf_sentmail'] = 'Ta witryna pomyślnie wysłała wiadomość testową na serwer pocztowy. <br /> Od: {$a->fromemail} <br /> Do: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a->site}: wiadomość testowa. {$a->additional} Wysłano: {$a->time}';
$string['testoutgoingmailconf_subjectadditional'] = 'Dodatkowy temat';
$string['testoutgoingmailconf_toemail'] = 'Na adres e-mail';
$string['testoutgoingmaildetail'] = 'Uwaga: przed testowaniem zapisz konfigurację.';
$string['testsiteupgradewarning'] = 'Obecnie używasz strony testowej {$a}, aby poprawnie to uaktualnić, użyj narzędzia interfejsu z linii poleceń';
$string['themedefinedinconfigphp'] = 'Nie można zmienić motywu, ponieważ jest ustawiony na {$a} w config.php.';
$string['themedesignermode'] = 'Tryb projektowania motywu graficznego';
$string['themedesignermodewarning'] = 'Tryb projektanta motywów jest włączony. Nie należy go włączać w witrynach produkcyjnych, ponieważ może to znacznie obniżyć wydajność.';
$string['themeeditsettingsname'] = 'Edytuj ustawienia motywu „{$a}”';
$string['themelist'] = 'Lista motywów';
$string['themeresetcaches'] = 'Wyczyść pamięć podręczną motywów graficznych';
$string['themeselect'] = 'Zmień motywgraficzny';
$string['themeselector'] = 'Motywy';
$string['themesettingsadvanced'] = 'Zaawansowane ustawienia motywu';
$string['themesettingscustom'] = 'Niestandardowe ustawienia motywu';
$string['themesettingsname'] = 'Ustawienia szaty graficznej „{$a}”';
$string['themeusagereportname'] = 'Raport użycia motywu \'{$a}\'';
$string['therewereerrors'] = 'Wystąpiły błędy w twoich danych';
$string['thirdpartylibrary'] = 'Biblioteka';
$string['thirdpartylibrarylocation'] = 'Lokalizacja';
$string['thirdpartylibs'] = 'Biblioteki firm trzecich';
$string['timezone'] = 'Domyślna strefa czasowa';
$string['timezoneforced'] = 'To jest wymuszone przez administratora strony';
$string['timezoneinvalid'] = 'Niepoprawna strefa czasowa "{$a}"';
$string['timezoneisforcedto'] = 'Wymuś dla wszystkich użytkowników użycie';
$string['timezonenotforced'] = 'Użytkownicy mogą wybrać swoją własną strefę czasową';
$string['timezonephpdefault'] = 'Domyślna strefa czasowa PHP ({$a})';
$string['timezoneserver'] = 'Strefa czasowa serwera ({$a})';
$string['tlswarning'] = 'Nie wykryto żadnego rozszerzenia PHP/cURL z obsługą TLSv1.2. Niektóre usługi mogą nie działać. Zdecydowanie zaleca się uaktualnienie bibliotek TLS.';
$string['tokenduration'] = 'Czas trwania tokenu utworzonego przez użytkownika';
$string['tokenduration_desc'] = 'Czas, przez jaki token serwisowy utworzony przez użytkownika (na przykład za pośrednictwem aplikacji mobilnej) jest ważny.';
$string['tokenizerrecommended'] = 'Instalowanie opcjonalnego rozszerzenie PHP Tokenizer jest zalecane - poprawia to funkcjonalność Sieci Moodle.';
$string['tools'] = 'Narzędzia admina';
$string['toolsmanage'] = 'Zarządzaj narzędziami admina';
$string['unattendedoperation'] = 'Nienadzorowana operacja';
$string['unbookmarkthispage'] = 'Usuń stronę z zakładek';
$string['unicoderequired'] = 'Wymagane jest aby składować wszystkie dane w formacie unicode (UTF-8). Nowe instalacje muszą być wykonane w bazach danych których domyślne kodowanie są ustawione jako Unicode. Jeżeli dokonywane jest uaktualnienie, należy przeprowadzić proces migracji UTF-8 (zobacz stronę Administratora).';
$string['uninstallplugin'] = 'Odinstaluj';
$string['unlockaccount'] = 'Odblokuj konto';
$string['unoconvwarning'] = 'Zainstalowana wersja unoconv nie jest obsługiwana.';
$string['unsupported'] = 'Niewspierany';
$string['unsupporteddbfileformat'] = 'Twoja baza danych używa Antylopy jako formatu pliku. Pełna obsługa UTF-8 w MySQL i MariaDB wymaga formatu pliku Barracuda. Przejdź do formatu pliku Barracuda. Zapoznaj się z dokumentacją <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support">Pełna obsługa Unicode w MySQL.</a>';
$string['unsupporteddbfilepertable'] = 'Aby uzyskać pełną obsługę UTF-8, zarówno MySQL, jak i MariaDB zmiany wymagają ustawienia MySQL \'innodb_file_per_table\' na \'ON\'. Więcej informacji można znaleźć w dokumentacji.';
$string['unsupporteddblargeprefix'] = 'Aby uzyskać pełną obsługę UTF-8, zarówno MySQL, jak i MariaDB zmiany wymagają ustawienia MySQL \'innodb_large_prefix\' na \'ON\'. Więcej informacji można znaleźć w dokumentacji.';
$string['unsupporteddbstorageengine'] = 'Wybrany silnik bazy danych nie jest już wspierany.';
$string['unsupporteddbtablerowformat'] = 'Twoja baza danych zawiera tabele używające Antylopy jako formatu pliku. Zalecane jest przekonwertowanie tabel na format pliku Barracuda. Zobacz dokumentację <a href="https://docs.moodle.org/en/cli">Administracja za pośrednictwem wiersza poleceń</a>, aby uzyskać szczegółowe informacje na temat narzędzia do konwersji tabel InnoDB na Barracuda.';
$string['unsupportedphpversion7'] = 'PHP w wersji 7 lub nowszej nie jest wspierane';
$string['unsupportedphpversion71'] = 'PHP w wersji 7.1 lub nowszej nie jest wspierane';
$string['unsupportedphpversion72'] = 'PHP w wersji 7.2 lub nowszej nie jest wspierane';
$string['unsupportedphpversion73'] = 'PHP w wersji 7.3 lub nowszej nie jest wspierane';
$string['unsupportedphpversion74'] = 'PHP w wersji 7.4 lub nowszej nie jest wspierane';
$string['unsupportedphpversion80'] = 'PHP w wersji 8.0 lub nowszej nie jest wspierane';
$string['unsupportedphpversion81'] = 'PHP w wersji 8.1 lub nowszej nie jest wspierane';
$string['unsupportedphpversion82'] = 'PHP 8.2 i nowsze nie są obsługiwane.';
$string['unsupportedphpversion83'] = 'Wersja PHP 8.3 i nowsza nie jest obsługiwana.';
$string['unsupportedphpversion84'] = 'Wersje PHP 8.4 i nowsze nie są obsługiwane.';
$string['unsuspenduser'] = 'Aktywuj konto użytkownika';
$string['updateaccounts'] = 'Uaktualnij istniejące konta';
$string['updateautocheck'] = 'Automatycznie sprawdzaj czy dostępne są aktualizacje';
$string['updateautocheck_desc'] = 'Jeśli opcja jest włączona, witryna automatycznie sprawdzi czy dostępne są aktualizacje zarówno dla kodu Moodle oraz wszystkich dodatkowych wtyczek. Jeśli jest nowa aktualizacja, zgłoszenie to zostanie wysłane do administratorów witryny.';
$string['updateavailable'] = 'Istnieje nowsza wersja Moodle!';
$string['updateavailable_moreinfo'] = 'Więcej informacji ...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Wersja {$a}';
$string['updateavailabledetailslink'] = 'Zapoznaj się ze szczegółami na {$a->url}';
$string['updateavailableforplugin'] = 'Istnieje nowa wersja niektórych z twoich wtyczek!';
$string['updateavailableinstall'] = 'Zainstaluj tę aktualizację';
$string['updateavailableinstallall'] = 'Zainstaluj dostępne aktualizacje ({$a})';
$string['updateavailableinstallallhead'] = 'Instalowanie dostępnych aktualizacji';
$string['updateavailablenot'] = 'Twój kod Moodle jest aktualny!';
$string['updateavailablerecommendation'] = 'Zaleca się aktualizację witryny do najnowszej wersji, aby uzyskać wszystkie najnowsze poprawki dot. zabezpieczeń i błędów.';
$string['updatecomponent'] = 'Uaktualnij komponent';
$string['updateminmaturity'] = 'Wymagana dojrzałość kodu';
$string['updateminmaturity_desc'] = 'Powiadamiaj o dostępnych aktualizacjach, tylko jeżeli dostępny kod został wybrany co najmniej na poziomie stabilnym. Aktualizacje dla wtyczek, które nie deklarują dla ich kodu poziomu stabilnego są zawsze zgłaszane bez względu na to ustawienie.';
$string['updatenotificationfooter'] = 'Twoja witryna Moodle {$a->siteurl} jest skonfigurowana do automatycznego sprawdzania dostępnych aktualizacji. Otrzymujesz tę wiadomość jako administrator serwisu. Możesz wyłączyć automatyczne sprawdzanie dostępnych aktualizacji w Administracja serwisu / Serwer / Powiadomienia o aktualizacjach lub dostosować dostarczanie tej wiadomości za pośrednictwem strony preferencji.';
$string['updatenotifications'] = 'Powiadomienia o aktualizacji';
$string['updatenotificationsubject'] = 'Aktualizacje Moodle są dostępne ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Powiadamiaj o nowych wydaniach';
$string['updatenotifybuilds_desc'] = 'Jeśli opcja jest włączona, dostępna aktualizacja dla kodu Moodle jest także raportowana, kiedy nowa kompilacja dla bieżącej wersji jest dostępna. Kompilacje ciągle są udoskonalane dla danej wersji Moodle. Są one zazwyczaj wydawane co tydzień. Jeżeli wyłączone, dostępna aktualizacja będzie raportowana tylko wtedy, kiedy będzie miała wyższą wersję niż wydana wersja Moodle. Sprawdzanie wersji wtyczek nie jest objęte w tym ustawieniu.';
$string['upgradeerror'] = 'Wystąpił nieznany błąd podczas aktualizacji modułu {$a->plugin} do wersji {$a->version}, nie można kontynuować.';
$string['upgradeforumread'] = 'Nowa funkcjonalność została dodana w Moodle 1.5 aby śledzić przeczytane/nieprzeczytane wątki na forum. <br /> Aby użyć tej funkcji musisz <a href="{$a}">auaktualić tabele w bazie danych</a>.';
$string['upgradeforumreadinfo'] = 'Nowy program został dodany w Moodle 1.5 w celu śledzenia przeczytanych/nie przeczytanych opinii na forum. Aby skorzystać z tej opcji musisz zaktualizować swoje tabele za pomocą wszelkich informacji śledzących dla istniejących wpisów. W zależności od wielkości Twojej strony może zająć to dłuższy okres czasu (liczony nawet w godzinach) i może powodować znaczne obciążenia bazy danych, a więc zalecane jest stosowanie go podczas okresów bezczynności. Aktualizacja ta nie będzie miała wpływu na funkcjonalność Twojej strony, nie wpłynie ona również na obsługę użytkowników. Po rozpoczęciu procesu powinieneś przeprowadzić go do końca ( okno przeglądarki powinno pozostać otwarte). Nie należy jednak przejmować się przerwaniem procesu wynikłym wskutek zamknięcia strony, ponieważ można  <br /><br /> Czy chcesz teraz rozpocząć proces aktualizacji?”';
$string['upgradekeyreq'] = 'Wymagany klucz aktualizacji';
$string['upgradekeyset'] = 'Zaktualizuj klucz (pozostaw puste jeśli nie jest to skonfigurowane)';
$string['upgradelogs'] = 'Dla pełnej funkcjonalności twoje dawne pliki logów muszą zostać zaktualizowane. <a href="{$a}">Więcej informacji</a>';
$string['upgradelogsinfo'] = 'Aby móc przeglądać stare logi musisz dokonać ich aktualizacji. W zależności od konfiguracji twojej strony internetowej proces ten może potrwać parę godzin i mocno wpłynąć na wydajność bazy danych. Gdy rozpoczniesz już proces aktualizacji, poczekaj aż on się skończy (nie zamykaj okna przeglądarki). Strona będzie działała poprawnie dla innych użytkowników.<br />Czy chcesz teraz dokonać aktualizacji logów?';
$string['upgradepluginsfirst'] = 'Zaleca się najpierw zainstalować wszystkie dostępne aktualizacje';
$string['upgradepluginsinfo'] = 'Aktualizacja wtyczek';
$string['upgradepluginsinfo_help'] = 'Dostępne są aktualizacje niektórych wtyczek. Powinieneś zainstalować je wszystkie przed aktualizacją bazy danych Moodle. Jeśli Twoja witryna nie obsługuje automatycznego wdrażania aktualizacji, musisz ręcznie pobrać i zainstalować nowe wersje wtyczek na swoim serwerze.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'Nowe ustawienia';
$string['upgradesettingsintro'] = 'Ustawienia pokazane poniżej zostały dodane podczas ostatniego uaktualnienia Moodle. Dokonaj koniecznych zmian w wartościach domyślnych i kliknij "Zapisz ustawienia" na dole strony.';
$string['upgradestalefiles'] = 'Wykryto pomieszane wersje Moodle, aktualizacja nie może być kontynuowana';
$string['upgradestalefilesinfo'] = 'Proces aktualizacji Moodle został wstrzymany, ponieważ co najmniej dwa skrypty PHP z głównych wersji Moodle zostały wykryte w katalogu Moodle.

To może później spowodować poważne problemy, więc należy przed kontynuacją upewnić się, że w katalogu Moodle są pliki dla pojedynczej wersji Moodle.

Zalecanym sposobem oczyszczenia katalogu Moodle jest podany poniżej:

* zmienić obecną nazwę katalogu Moodle na "moodle_old"
* stworzyć nowy katalog Moodle zawierający tylko pliki z pobranego standardowego pakietu Moodle, lub repozytorium Git Moodle
* przenieś ortyginalny plik config.php i wszelakie niestandardowe wtyczki z katalogu "moodle_old" do nowego katalogu Moodle

Kiedy masz czysty katalog Moodle, odśwież tą stroną aby wznowić proces aktualizacji Moodle.

To ostrzeżenie jest najczęściej spowodwane przez wypakowanie standardowego pakietu Moodle z poprzedniej wersji Moodle. Dopóki jest wporządku dla aktualizacji drobnych, to jest silnie odradzane dla głównych aktualizacji Moodle.

Ostrzeżenie to może być również spowodowane przez niekompletną operację ściągnięcia lub aktualizacji z repozytorium Git, w którym przypadku możesz poczekać na zakończenie operacji, lub uruchomić odpowiednie polecenie oczyszczenia i ponowić operację.

Więcej informacji znajdziesz w dokumentacji aktualizacji na <a href="{$a}">{$a}</a>.';
$string['upgradestart'] = 'Uaktualnij teraz bazę danych Moodle';
$string['upgradesure'] = '<p>Pliki Moodle zostały zmienione i zaraz rozpocznie się automatyczna aktualizacja do wersji: </p>
<p><strong>{$a}</strong></p>
<p>Wykonanej aktualizacji nie można cofnąć. Proces aktualizacji może trwać długo.</p>
<p>Czy jesteś pewien że chcesz dokonać aktualizacji do tej wersji?</p>';
$string['upgradetimedout'] = 'Przekroczono limit czasu aktualizacji, proszę uruchomić proces ponownie.';
$string['upgradingdata'] = 'Aktualizuje dane';
$string['upgradinglogs'] = 'Aktualizuje pliki logów';
$string['upgradingversion'] = 'Aktualizacja do nowszej wersji';
$string['upwards'] = 'w górę';
$string['useblogassociations'] = 'Włącz skojarzenia bloga';
$string['user'] = 'Użytkownik';
$string['userbulk'] = 'Działania zbiorcze na użytkownikach';
$string['userbulkdownload'] = 'Eksportuj użytkowników jako';
$string['userdefaultpreferences'] = 'Domyślne preferencje użytkownika';
$string['userfeedbackafterupgrade'] = 'Po każdej większej aktualizacji';
$string['userfeedbackencouragement'] = '<p>Moodle zawiera funkcję, która daje użytkownikom możliwość przekazywania opinii na temat oprogramowania Moodle za pośrednictwem zewnętrznej witryny ankietowej hostowanej przez Moodle HQ.</p>
<p>Moodle HQ dąży do otwartości i przejrzystości w zakresie praktyk gromadzenia danych. Dlatego chcemy mieć pewność, że użytkownik jest świadomy i kontroluje tę funkcję.</p>
<p>Opinie użytkowników pomagają Moodle HQ w ulepszaniu oprogramowania Moodle. Aby włączyć tę funkcję, przejdź do <a href="{$a}">Ustawienia opinii</a>.</p>';
$string['userfeedbacknextreminder'] = 'Następne przypomnienie o opinii zwrotnej';
$string['userfeedbacknextreminder_desc'] = 'Kiedy powinniśmy ponownie poprosić użytkownika o wyrażenie opinii?';
$string['userfeedbackperiodically'] = 'Okresowo';
$string['userfeedbackremindafter'] = 'Pokaż przypomnienie po';
$string['userfeedbackremindafter_desc'] = 'Przypomnij użytkownikom ponownie, aby przesłali opinię po określonej liczbie dni.';
$string['userfiltersdefault'] = 'Domyślne filtry użytkownika';
$string['userfiltersdefault_desc'] = 'Wybierz filtry, które powinny być wyświetlane na stronie „Przeglądaj listę użytkowników” i na stronie „Wielokrotne akcje na  użytkownikach. Przytrzymaj klawisz Ctrl, aby wybrać wiele elementów. Niezaznaczone filtry będą dostępne po kliknięciu linku „Pokaż więcej ...”.';
$string['userimagesdisabled'] = 'Zdjęcia profilu użytkownika są niedostępne';
$string['userlist'] = 'Przeglądaj listę użytkowników';
$string['usermanagement'] = 'Zarządzanie użytkownikami';
$string['userpolicies'] = 'Zasady użytkownika';
$string['userpreference'] = 'Preferencje użytkownika';
$string['userquota'] = 'Pojemność miejsca na pliki prywatne';
$string['userquota_desc'] = 'Maksymalna ilość danych, które każdy użytkownik może przechowywać w swoim obszarze plików prywatnych.';
$string['users'] = 'Użytkownicy';
$string['usesitenameforsitepages'] = 'Użyj nazwy strony dla podstron';
$string['usetags'] = 'Włącz tagi';
$string['validateemptylineerror'] = 'Puste linie nie są poprawne';
$string['validateerror'] = 'Ta wartość jest nieprawidłowa';
$string['validateerrorlist'] = 'Te wpisy są niepoprawne: {$a}';
$string['validateiperror'] = 'Te adresy IP są nieprawidłowe: {$a}';
$string['verifychangedemail'] = 'Ogranicz domeny gdy jest zmieniany e-mail';
$string['warningcurrentsetting'] = 'Nieprawidłowa wartość: {$a}';
$string['warningiconvbuggy'] = 'Twoja wersja biblioteki iconv nie obsługuje identyfikatora //IGNORE. Możesz zainstalować rozszerzenie mbstring, który może być używany dla tekstów zawierających niepoprawne znaki w UTF-8.';
$string['webproxy'] = 'Serwer Proxy';
$string['webproxyinfo'] = 'Wypełnij poniższe opcje, jeśli Twój serwer Moodle nie ma bezpośredniego dostępu do Internetu. Dostęp do Internetu jest wymagany do pobierania danych środowiskowych, pakietów językowych, kanałów RSS, stref czasowych itp.<br /><em>Wysoce zalecane jest rozszerzenie PHP cURL.</em>';
$string['xmlrpcwebserviceenabled'] = 'Wykryto, że protokół XML-RPC Web Service jest włączony w Twojej witrynie. Ta funkcja opiera się na rozszerzeniu PHP XML-RPC, które nie jest już obsługiwane przez PHP.';
$string['yuicomboloading'] = 'Optymalizacja ładowania YUI';
$string['ziprequired'] = 'Rozszerzenie Zip PHP jest obecnie wymagane przez Moodle. Binaria info-ZIP i biblioteki PclZip nie są już używane.';
