<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'lo', version '5.1'.
 *
 * @package     lesson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'ຄວບຄຸມການເຂົ້າເຖິງ';
$string['actionaftercorrectanswer'] = 'ການປະຕິບັດຫຼັງຈາກຄຳຕອບຖືກຕ້ອງ';
$string['actionaftercorrectanswer_help'] = 'ຫຼັງຈາກຕອບຄໍາຖາມຢ່າງຖືກຕ້ອງ, ມີ 3 ທາງເລືອກສໍາລັບໜ້າຕໍ່ໄປນີ້:

* ປົກກະຕິ - ປະຕິບັດຕາມເສັ້ນທາງຂອງບົດຮຽນ
* ສະແດງໜ້າທີ່ບໍ່ເຫັນ - ໜ້າຕ່າງຕ້ອງຖືກສະແດງຢູ່ໃນລຳດັບແບບສຸ່ມໂດຍບໍ່ມີໜ້າໃດສະແດງສອງເທື່ອ
* ສະແດງໜ້າທີ່ບໍ່ມີຄຳ ຕອບ - ໜ້າຕ່າງຖືກສະແດງຢູ່ໃນລຳດັບແບບສຸ່ມ, ດ້ວຍໜ້າຕ່າງໆທີ່ມີຄຳ ຖາມທີ່ບໍ່ມີຄຳຕອບສະແດງໃຫ້ເຫັນອີກ';
$string['actions'] = 'ການປະຕິບັດ';
$string['activitylink'] = 'ເຊື່ອມຕໍ່ຫາກິດຈະກຳທີ່ແນ່ນອນ';
$string['activitylink_help'] = 'ເພື່ອສະໜອງການເຊື່ອມຕໍ່ໃນຕອນທ້າຍຂອງບົດຮຽນກັບກິດຈະກໍາອື່ນໃນຫຼັກສູດ, ເລືອກກິດຈະກໍາຈາກເມນູເລື່ອນລົງ.';
$string['activitylinkname'] = 'ໄປທີ: {$a}';
$string['activityoverview'] = 'ທ່ານມີຊ່ວງເວລາທີ່ຮອດກຳນົດແລ້ວ';
$string['addabranchtable'] = 'ເພີ່ມໜ້າເນື້ອໃນ';
$string['addanendofbranch'] = 'ເພີ່ມການສິ້ນສຸດສາຂາ';
$string['addanewpage'] = 'ເພີ່ມໜ້າໃໝ່';
$string['addaquestionpage'] = 'ເພີ່ມໜ້າຄຳຖາມ';
$string['addaquestionpagehere'] = 'ເພີ່ມໜ້າຄຳຖາມຢູ່ທີ່ນີ້';
$string['addbranchtable'] = 'ເພີ່ມໜ້າເນື້ອໃນ';
$string['addcluster'] = 'ເພີ່ມກຸ່ມ';
$string['addedabranchtable'] = 'ເພີ່ມໜ້າເນື້ອໃນແລ້ວ';
$string['addedanendofbranch'] = 'ເພີ່ມສາຂາສຸດທ້າຍແລ້ວ';
$string['addedaquestionpage'] = 'ເພີ່ມໜ້າຄຳຖາມແລ້ວ';
$string['addedcluster'] = 'ເພີ່ມຊຸດແລ້ວ';
$string['addedendofcluster'] = 'ເພີ່ມໜ້າຊຸດສຸດທ້າຍແລ້ວ';
$string['addendofbranch'] = 'ເພີ່ມສາຂາຊຸດສຸດທ້າຍ';
$string['addendofcluster'] = 'ເພີ່ມຊຸດສຸດທ້າຍ';
$string['addessay'] = 'ສ້າງໜ້າຄຳຖາມບົດຂຽນ';
$string['addmatching'] = 'ສ້າງໜ້າຄຳຖາມກົງກັນ';
$string['addmultichoice'] = 'ສ້າງໜ້າຄຳຖາມຫຼາຍຕົວເລືອກ';
$string['addnewgroupoverride'] = 'ເພີ່ມການລົບລ້າງກຸ່ມ';
$string['addnewuseroverride'] = 'ເພີ່ມການລົບລ້າງຜູ້ໃຊ້';
$string['addnumerical'] = 'ສ້າງໜ້າຄຳຖາມເປັນຕົວເລກ';
$string['addpage'] = 'ເພີ່ມໜ້າ';
$string['addshortanswer'] = 'ສ້າງໜ້າຄຳຖາມຄຳຕອບສັ້ນ';
$string['addtruefalse'] = 'ສ້າງໜ້າຄຳຖາມຈິງ/ບໍ່ຈິງ';
$string['allotheranswers'] = 'ຄຳຕອບອື່ນທັງໝົດ';
$string['allotheranswersjump'] = 'ການຂ້າມຄຳຕອບອື່ນທັງໝົດ';
$string['allotheranswersscore'] = 'ຄະແນນຄຳຕອບອື່ນທັງໝົດ';
$string['allowofflineattempts'] = 'ອະນຸຍາດໃຫ້ພະຍາຍາມສອນບົດຮຽນອອບລາຍໂດຍໃຊ້ແອັບມືຖື';
$string['allowofflineattempts_help'] = 'ຖ້າເປີດໃຊ້, ຜູ້ໃຊ້ແອັບມືຖືສາມາດດາວໂຫຼດບົດຮຽນ ແລະ ພະຍາຍາມເຮັດມັນອອບລາຍໄດ້.
ຄຳຕອບທັງໝົດທີ່ເປັນໄປໄດ້ ແລະ ຄຳຕອບທີ່ຖືກຕ້ອງຈະຖືກດາວໂຫຼດເຊັ່ນກັນ.
ໝາຍເຫດ: ມັນບໍ່ເປັນໄປໄດ້ສຳລັບບົດຮຽນທີ່ຈະພະຍາຍາມອອບລາຍຖ້າມັນມີເວລາຈຳກັດ.';
$string['anchortitle'] = 'ເລີ່ມຈາກເນື້ອໃນຫຼັກ';
$string['and'] = 'ແລະ';
$string['answer'] = 'ຄຳຕອບ';
$string['answeredcorrectly'] = 'ຄຳຕອບທີ່ຖືກຕ້ອງ.';
$string['answersfornumerical'] = 'ຄຳຕອບສຳລັບຄຳຖາມທີ່ເປັນຕົວເລກຄວນຈັບຄູ່ກັບຄ່າຕ່ຳສຸດ ແລະ ສູງສຸດ';
$string['arrangebuttonshorizontally'] = 'ຈັດວາງປຸ່ມເນື້ອໃນຕາມແນວນອນບໍ?';
$string['attempt'] = 'ພະຍາຍາມ: {$a}';
$string['attemptheader'] = 'ພະຍາຍາມ';
$string['attemptinfonograde'] = '{$a->timestart} ({$a->duration})';
$string['attemptinfowithgrade'] = '{$a->grade}% {$a->timestart} ({$a->duration})';
$string['attempts'] = 'ພະຍາຍາມ';
$string['attemptsdeleted'] = 'ລຶບຄວາມພະຍາຍາມແລ້ວ';
$string['attemptsremaining'] = 'ທ່ານມີ {$a} ຄວາມພະຍາຍາມທີ່ຍັງເຫຼືອຢູ່';
$string['available'] = 'ມີໃຫ້ຈາກ';
$string['averagescore'] = 'ຄະແນນສະເລ່ຍ';
$string['averagetime'] = 'ເວລາສະເລ່ຍ';
$string['branch'] = 'ເນື້ອໃນ';
$string['branchtable'] = 'ເນື້ອໃນ';
$string['cachedef_overrides'] = 'ຂໍ້ມູນການລົບລ້າງຜູ້ໃຊ້ ແລະ ກຸ່ມ';
$string['cancel'] = 'ຍົກເລີກ';
$string['cannotfindanswer'] = 'ຜິດພາດ: ບໍ່ສາມາດຊອກຫາຄຳຕອບ';
$string['cannotfindattempt'] = 'ຜິດພາດ: ບໍ່ສາມາດຊອກຫາຄວາມພະຍາຍາມ';
$string['cannotfindessay'] = 'ຜິດພາດ: ບໍ່ສາມາດຊອກຫາບົດຂຽນ';
$string['cannotfindfirstgrade'] = 'ຜິດພາດ: ບໍ່ສາມາດຊອກຫາຄະແນນ';
$string['cannotfindfirstpage'] = 'ບໍ່ສາມາດຊອກຫາໜ້າທຳອິດ';
$string['cannotfindgrade'] = 'ຜິດພາດ: ບໍ່ສາມາດຊອກຫາຄະແນນ';
$string['cannotfindnewestgrade'] = 'ຜິດພາດ: ບໍ່ສາມາດຊອກຫາຄະແນນໃໝ່ທີ່ສຸດ';
$string['cannotfindnextpage'] = 'ການສຳຮອງຂໍ້ມູນບົດຮຽນ: ບໍ່ສາມາດຊອກຫາໜ້າຕໍ່ໄປ!';
$string['cannotfindpagerecord'] = 'ເພີ່ມສາຂາສຸດທ້າຍ: ບໍ່ພົບບັນທຶກໜ້າ';
$string['cannotfindpages'] = 'ບໍ່ສາມາດຊອກຫາໜ້າບົດຮຽນ';
$string['cannotfindpagetitle'] = 'ຢືນຢັນລຶບ: ບໍ່ພົບຫົວຂໍ້ໜ້າ';
$string['cannotfindpreattempt'] = 'ບໍ່ພົບບັນທຶກຄວາມພະຍາຍາມກ່ອນໜ້າ!';
$string['cannotfindrecords'] = 'ຜິດພາດ: ບໍ່ສາມາດຊອກຫາບັນທຶກບົດຮຽນ';
$string['cannotfindtimer'] = 'ຜິດພາດ: ບໍ່ສາມາດຊອກຫາບັນທຶກ lesson_timer';
$string['cannotfinduser'] = 'ຜິດພາດ: ບໍ່ສາມາດຊອກຫາຜູ້ໃຊ້';
$string['canretake'] = '{$a} ສາມາດເຮັດຄືນໃໝ່';
$string['casesensitive'] = 'ນຳໃຊ້ການສຳນວນປົກກະຕິ';
$string['casesensitive_help'] = 'ໝາຍຖືກໃສ່ປ່ອງໝາຍຖືກ ເພື່ອໃຊ້ສຳນວນປົກກະຕິເພື່ອວິເຄາະຄຳຕອບ.';
$string['checkbranchtable'] = 'ກວດສອບໜ້າເນື້ອຫາ';
$string['checkedthisone'] = 'ກວດສອບສິ່ງນີ້ແລ້ວ.';
$string['checknavigation'] = 'ກວດສອບໜ້າເນື້ອຫາ';
$string['checkquestion'] = 'ກວດສອບຄຳຖາມ';
$string['classstats'] = 'ສະຖິຕິຊັ້ນ';
$string['clicktodownload'] = 'ເພື່ອດາວໂຫຼດໄຟລ໌ ກົດລິ້ງຕໍ່ໄປນີ້.';
$string['closebeforeopen'] = 'ບໍ່ສາມາດປັບປຸງບົດຮຽນ. ທ່ານຕ້ອງລະບຸວັນທີ່ປິດ ກ່ອນ ວັນທີເປີດ';
$string['cluster'] = 'ຊຸດ';
$string['clusterjump'] = 'ຄຳຖາມທີ່ບໍ່ເຫັນພາຍໃນຊຸດ';
$string['clustertitle'] = 'ຊຸດ';
$string['collapsed'] = 'ຍຸບເຂົ້າ';
$string['comments'] = 'ຄຳເຫັນຂອງທ່ານ';
$string['completed'] = 'ສຳເລັດແລ້ວ';
$string['completederror'] = 'ສຳເລັດບົດຮຽນ';
$string['completethefollowingconditions'] = 'ທ່ານຕ້ອງປະກອບເງື່ອນໃນບົດຮຽນໄຂຕໍ່ໄປນີ້ໃນ <b>{$a}</b> ກ່ອນທີ່ທ່ານຈະສາມາດດໍາເນີນການຕໍ່ໄປ.';
$string['completiondetail:reachend'] = 'ໄປທີ່ກິດຈະກຳຢູ່ສຸດທ້າຍ';
$string['completiondetail:timespent'] = 'ໃຊ້ຢ່າງໜ້ອຍ {$a} ໃນກິດຈະກຳນີ້';
$string['completionendreached'] = 'ເຂົ້າເຖິງຄັ້ງສຸດທ້າຍທີ່ຕ້ອງການ';
$string['completionendreached_desc'] = 'ນັກຮຽນຕ້ອງເຂົ້າເຖິງໜ້າບົດຮຽນສຸດທ້າຍເພື່ອສຳເລັດກິດຈະກຳນີ້';
$string['completiontimespentdesc'] = 'ນັກຮຽນຕ້ອງເຮັດກິດຈະກຳນີ້ເປັນຢ່າງໜ້ອຍ {$a}';
$string['completiontimespentgroup'] = 'ໃຊ້ເວລາທີ່ຕ້ອງການ';
$string['conditionsfordependency'] = 'ເງື່ອນໄຂສໍາລັບການເພິ່ງພາອາໄສ';
$string['configintro'] = 'ຄ່າທີ່ຕັ້ງໄວ້ທີ່ນີ້ກໍານົດຄ່າເລີ່ມຕົ້ນທີ່ຖືກນໍາໃຊ້ໃນຮູບແບບການຕັ້ງຄ່າເມື່ອສ້າງກິດຈະກໍາການຮຽນໃໝ່. ການຕັ້ງຄ່າທີ່ລະບຸວ່າ ເປັນຂັ້ນສູງຈະສະແດງສະເພາະເມື່ອມີການຄລິກລິ້ງ \'ສະແດງເພີ່ມເຕີມ...\'.';
$string['configmaxanswers'] = 'ຈຳນວນຄຳຕອບສູງສຸດເລີ່ມຕົ້ນຕໍ່ໜ້າ';
$string['configmediaclose'] = 'ສະແດງປຸ່ມປິດເປັນສ່ວນໜຶ່ງຂອງປັອບອັບທີ່ສ້າງຂຶ້ນສໍາລັບໄຟລ໌ສື່ທີ່ເຊື່ອມໂຍງ';
$string['configmediaheight'] = 'ກໍານົດຄວາມສູງຂອງໜ້າຈໍປັອບອັບສໍາລັບໄຟລ໌ສື່ທີ່ເຊື່ອມໂຍງແລ້ວ';
$string['configmediawidth'] = 'ກໍານົດຄວາມກວ້າງຂອງໜ້າຈໍປັອບອັບສໍາລັບໄຟລ໌ສື່ທີ່ເຊື່ອມໂຍງ';
$string['configpassword_desc'] = 'ບໍ່ວ່າຈະຕ້ອງການລະຫັດຜ່ານເພື່ອເຂົ້າຫາບົດຮຽນຫຼືບໍ່.';
$string['configslideshowbgcolor'] = 'ສີພື້ນຫຼັງສຳລັບສະໄລ້ໂຊຖ້າມັນຖືກເປີດນຳໃຊ້';
$string['configslideshowheight'] = 'ຕັ້ງຄວາມສູງຂອງສະໄລ້ໂຊຖ້າມັນຖືກເປີດໃຊ້ງານ';
$string['configslideshowwidth'] = 'ຕັ້ງຄວາມກ້ວາງຂອງສະໄລ້ໂຊຖ້າມັນຖືກເປີດໃຊ້ງານ';
$string['configtimelimit_desc'] = 'ຖ້າຫາກຕັ້ງເວລາຈຳກັດ, ຄຳເຕືອນຈະຖືກສະແດງໃນຕອນຕົ້ນຂອງບົດຮຽນ ແລະ ມີໂມງນັບຖອຍຫຼັງ. ຖ້າຕັ້ງເປັນສູນ, ຈາກນັ້ນບໍ່ມີກຳນົດເວລາ.';
$string['confirmdelete'] = 'ລຶບໜ້າ';
$string['confirmdeletionofthispage'] = 'ຢືນຢັນການລຶບໜ້ານີ້';
$string['congratulations'] = 'ຍິນດີນຳ - ຮອດບົດຮຽນສຸດທ້າຍແລ້ວ';
$string['continue'] = 'ສືບຕໍ່';
$string['continuetoanswer'] = 'ສືບຕໍ່ເພື່ອປ່ຽນຄຳຕອບ.';
$string['continuetonextpage'] = 'ສືບຕໍ່ໜ້າຕໍ່ໄປ.';
$string['correctanswerjump'] = 'ແກ້ໄຂການຂ້າມຄຳຕອບ';
$string['correctanswerscore'] = 'ແກ້ໄຂຄະແນນຄຳຕອບ';
$string['correctresponse'] = 'ການຕອບທີ່ຖືກຕ້ອງ';
$string['createaquestionpage'] = 'ສ້າງໜ້າຄຳຖາມ';
$string['credit'] = 'ຄະແນນເພີ່ມ';
$string['customscoring'] = 'ການໃຫ້ຄະແນນປັບແຕ່ງເອງ';
$string['customscoring_help'] = 'ຖ້າເປີດນຳໃຊ້, ຫຼັງຈາກນັ້ນຄໍາຕອບແຕ່ລະອັນອາດຈະໃຫ້ຄ່າຈຸດເປັນຕົວເລກ (ເປັນບວກ ຫຼື ລົບ).';
$string['deadline'] = 'ເສັ້ນຕາຍ';
$string['defaultessayresponse'] = 'ບົດຮຽນຂອງທ່ານຈະໄດ້ຄະແນນໂດຍຄູສອນຂອງທ່ານ.';
$string['deleteallattempts'] = 'ລຶບຄວາມພະຍາຍາມບົດຮຽນທັງໝົດ';
$string['deletedefaults'] = 'ໄດ້ລຶບ {$a} x ບົດຮຽນມາດຕະຖານ';
$string['deletedpage'] = 'ລຶບໜ້າແລ້ວ';
$string['deletepagenamed'] = 'ລຶບໜ້າ: {$a}';
$string['deleting'] = 'ກຳລັງລຶບ';
$string['deletingpage'] = 'ກຳລັງລຶບໜ້າ: {$a}';
$string['dependencyon'] = 'ຂື້ນກັບ';
$string['dependencyon_help'] = 'ການຕັ້ງຄ່ານີ້ ອະນຸຍາດໃຫ້ເຂົ້າເຖິງບົດຮຽນນີ້ຂຶ້ນກັບການປະຕິບັດຂອງນັກຮຽນໃນບົດຮຽນອື່ນຢູ່ໃນວິຊາດຽວກັນ. ການປະສົມປະສານຂອງເວລາທີ່ໃຊ້ໄປ, ສໍາເລັດ ຫຼື "ຄະແນນດີກວ່າ" ອາດຈະຖືກນໍາໃຊ້.';
$string['description'] = 'ຄຳອະທິບາຍ';
$string['deselectallattempts'] = 'ບໍ່ເລືອກຄວາມພະຍາຍາມທັງໝົດ';
$string['detailedstats'] = 'ສະຖິຕິທີ່ລະອຽດ';
$string['didnotanswerquestion'] = 'ບໍ່ໄດ້ຕອບຄຳຖາມນີ້.';
$string['didnotreceivecredit'] = 'ບໍ່ໄດ້ຮັບຄະແນນເພີ່ມນີ້';
$string['disabled'] = 'ປິດໃຊ້ງານ';
$string['displaydefaultfeedback'] = 'ໃຊ້ຄຳຕິຊົມເລີ່ມຕົ້ນ';
$string['displaydefaultfeedback_help'] = 'ຖ້າເປີດນຳໃຊ້, ເມື່ອບໍ່ພົບຄໍາຕອບສໍາລັບຄໍາຖາມສະເພາະ, ຄໍາຕອບເລີ່ມຕົ້ນຂອງ "ນັ້ນແມ່ນຄໍາຕອບທີ່ຖືກຕ້ອງ" ຫຼື "ນັ້ນແມ່ນຄໍາຕອບຜິດ" ຈະຖືກສະແດງ.';
$string['displayinleftmenu'] = 'ສະແດງໃນເມນູບໍ?';
$string['displayleftif'] = 'ຄະແນນຕ່ຳສຸດຫາເມນູສະແດງ';
$string['displayleftif_help'] = 'ການຕັ້ງຄ່ານີ້ ກຳນົດວ່ານັກຮຽນຕ້ອງໄດ້ຄະແນນສະເພາະກ່ອນເບິ່ງເມນູບົດຮຽນ. ສິ່ງນີ້ບັງຄັບໃຫ້ນັກຮຽນຕ້ອງຜ່ານບົດຮຽນທັງໝົດດ້ວຍຄວາມພະຍາຍາມທໍາອິດຂອງເຂົາເຈົ້າ, ຫຼັງຈາກນັ້ນຫຼັງຈາກໄດ້ຄະແນນທີ່ຕ້ອງການແລ້ວເຂົາເຈົ້າສາມາດໃຊ້ເມນູເພື່ອທົບທວນຄືນ.';
$string['displayleftmenu'] = 'ສະແດງເມນູ';
$string['displayleftmenu_help'] = 'ຖ້າເປີດນຳໃຊ້, ເມນູທີ່ອະນຸຍາດໃຫ້ຜູ້ໃຊ້ສາມາດນຳທາງຜ່ານລາຍການໜ້າຕ່າງໆຈະຖືກສະແດງ.';
$string['displayofgrade'] = 'ສະແດງຄະແນນ (ສຳລັບນັກຮຽນເທົ່ານັ້ນ)';
$string['displayreview'] = 'ໃຫ້ທາງເລືອກເພື່ອລອງຕອບຄຳຖາມ';
$string['displayreview_help'] = 'ຖ້າເປີດໃຊ້, ເມື່ອຄໍາຖາມຖືກຕອບບໍ່ຖືກຕ້ອງ, ນັກຮຽນໄດ້ຮັບທາງເລືອກໃຫ້ລອງມັນຄືນໃໝ່ໂດຍບໍ່ໃຫ້ຄະແນນ ຫຼື ສືບຕໍ່ບົດຮຽນ. ຖ້ານັກຮຽນຄລິກໄປຫາຄໍາຖາມອື່ນ, ຈາກນັ້ນຄໍາຕອບທີ່ເລືອກ (ຜິດ) ຈະຖືກປະຕິບັດຕາມ. ໂດຍຄ່າເລີ່ມຕົ້ນ ຄໍາຕອບທີ່ຜິດແມ່ນຖືກຕັ້ງໄປ “ໜ້ານີ້” ແລະ ມີຄະແນນເປັນ 0, ສະນັ້ນ ຈິ່ງແນະນໍາໃຫ້ທ່ານຕັ້ງຄໍາຕອບທີ່ຜິດໄປຫາໜ້າອື່ນ ເພື່ອຫຼີກເວັ້ນຄວາມສັບສົນກັບນັກຮຽນຂອງທ່ານ.';
$string['displayscorewithessays'] = '<p>ທ່ານໄດ້ຮັບ {$a->score} ຈາກທັງໝົດ {$a->tempmaxgrade} ສຳລັບຄຳຖາມທີ່ໄດ້ຄະແນນອັດຕະໂນມັດ.</p>
<p>ຄຳຖາມບົດຂຽນ {$a->essayquestions} ຂອງທ່ານຈະໄດ້ຄະແນນ ແລະ ເພີ່ມເຂົ້າໃນຄະແນນສຸດທ້າຍຂອງທ່ານໃນພາຍຫຼັງ.</p>
<p>ຄະແນນປັດຈຸບັນຂອງທ່ານທີ່ບໍ່ມີຄຳຖາມບົດຂຽນແມ່ນ {$a->score} ຈາກທັງໝົດ {$a->grade}.</p>';
$string['displayscorewithoutessays'] = 'ຄະແນນຂອງທ່ານແມ່ນ {$a->score} (ຈາກທັງໝົດ {$a->grade}).';
$string['duplicatepagenamed'] = 'ໜ້າຊ້ຳກັນ: {$a}';
$string['edit'] = 'ແກ້ໄຂ';
$string['editbranchtable'] = 'ແກ້ໄຂໜ້າເນື້ອໃນ';
$string['editcluster'] = 'ແກ້ໄຂຊຸດ';
$string['editendofbranch'] = 'ແກ້ໄຂໜ້າສາຂາສຸດທ້າຍ';
$string['editendofcluster'] = 'ແກ້ໄຂໜ້າຊຸດສຸດທ້າຍ';
$string['editessay'] = 'ແກ້ໄຂໜ້າຄຳຖາມບົດຂຽນ';
$string['editinglesson'] = 'ກຳລັງແກ້ໄຂບົດຮຽນ';
$string['editingquestionpage'] = 'ແກ້ໄຂ {$a} ໜ້າຄຳຖາມ';
$string['editlesson'] = 'ແກ້ໄຂບົດຮຽນ';
$string['editlessonsettings'] = 'ແກ້ໄຂການຕັ້ງຄ່າບົດຮຽນ';
$string['editmatching'] = 'ແກ້ໄຂໜ້າຄຳຖາມກົງກັນ';
$string['editmultichoice'] = 'ແກ້ໄຂໜ້າຄຳຖາມຫຼາຍຕົວເລືອກ';
$string['editnumerical'] = 'ແກ້ໄຂໜ້າຄຳຖາມເປັນຕົວເລກ';
$string['editoverride'] = 'ແກ້ໄຂການລົບລ້າງ';
$string['editpage'] = 'ແກ້ໄຂຈຳນວນໜ້າ';
$string['editpagecontent'] = 'ແກ້ໄຂເນື້ອໃນໜ້າ';
$string['editquestion'] = 'ແກ້ໄຂໜ້າຄຳຖາມ';
$string['editshortanswer'] = 'ແກ້ໄຂໜ້າຄຳຖາມຄຳຕອບສັ້ນ';
$string['edittruefalse'] = 'ແກ້ໄຂໜ້າຄຳຖາມ ຈິງ/ບໍ່ຈິງ';
$string['email'] = 'ອີເມລ';
$string['emailallgradedessays'] = 'ອີເມລບົດຂຽນທີ່ໄດ້ຄະແນນທັງໝົດ';
$string['emailgradedessays'] = 'ອີເມລບົດຂຽນທີ່ໄດ້ຄະແນນ';
$string['emailsuccess'] = 'ອີເມລສົ່ງສຳເລັດ';
$string['emptypassword'] = 'ລະຫັດຜ່ານບໍ່ສາມາດເປົ່າຫວ່າງ';
$string['enabled'] = 'ເປີດໃຊ້ງານ';
$string['endofbranch'] = 'ສາຂາສຸດທ້າຍ';
$string['endofcluster'] = 'ຊຸດສຸດທ້າຍ';
$string['endofclustertitle'] = 'ຊຸດສຸດທ້າຍ';
$string['endoflesson'] = 'ບົດຮຽນສຸດທ້າຍ';
$string['enteredthis'] = 'ປ້ອນສິ່ງນີ້.';
$string['enterpassword'] = 'ກະລຸນາໃສ່ລະຫັດຜ່ານ:';
$string['eolstudentoutoftime'] = 'ເອົາໃຈໃສ່: ທ່ານບໍ່ມີເວລາສຳລັບບົດຮຽນນີ້. ຄຳຕອບສຸດທ້າຍຂອງທ່ານອາດຈະບໍ່ຖືກນັບຖ້າມັນຖືກຕອບຫຼັງຈາກເວລາໝົດ.';
$string['eolstudentoutoftimenoanswers'] = 'ທ່ານບໍ່ໄດ້ຕອບຄຳຖາມໃດໆ. ທ່ານໄດ້ຮັບ 0 ສຳລັບບົດຮຽນນີ້.';
$string['essay'] = 'ບົດຂຽນ';
$string['essayemailmessage2'] = '<p>ກຽມພ້ອມບົດຂຽນ: {$a->question}</p><p>ຄຳຕອບຂອງທ່ານ: <em>{$a->response}</em></p><p>ຄຳເຫັນຜູ້ໃຫ້ຄະແນນ: <em>{$a->comment}</em></p><p>ທ່ານໄດ້ຮັບ {$a->earned} ຈາກທັງໝົດ {$a->outof} ສຳລັບຄຳຖາມບົດຂຽນນີ້.</p><p>ຄະແນນຂອງທ່ານສຳລັບບົດຮຽນ {$a->lesson} ໄດ້ປ່ຽນແປງເປັນ {$a->newgrade}%.</p>';
$string['essayemailmessagesmall'] = '<p>ທ່ານໄດ້ຮັບ {$a->earned} ຈາກທັງໝົດ {$a->outof} ສຳລັບຄຳຖາມບົດຂຽນນີ້.</p><p>ຄະແນນຂອງທ່ານສຳລັບບົດຮຽນ {$a->lesson} ໄດ້ປ່ຽນແປງເປັນ {$a->newgrade}%.</p>';
$string['essayemailsubject'] = 'ຄະແນນມີໃຫ້ສຳລັບຄຳຖາມບົດຮຽນ';
$string['essaynotgradedyet'] = 'ບົດຂຽນນີ້ບໍ່ໄດ້ຮັບຄະແນນເທື່ອ';
$string['essayresponses'] = 'ຕອບກັບບົດຂຽນ';
$string['essays'] = 'ບົດຂຽນ';
$string['essayscore'] = 'ຄະແນນບົດຂຽນ';
$string['eventcontentpageviewed'] = 'ເບິ່ງເນື້ອໃນໜ້າ';
$string['eventessayassessed'] = 'ປະເມີນບົດຂຽນ';
$string['eventessayattemptviewed'] = 'ເບິ່ງຄວາມພະຍາຍາມບົດຂຽນ';
$string['eventhighscoreadded'] = 'ເພີ່ມຄະແນນສູງສຸດບົດຮຽນແລ້ວ';
$string['eventhighscoresviewed'] = 'ເບິ່ງຄະແນນສູງສຸດບົດຮຽນແລ້ວ';
$string['eventlessonended'] = 'ສິ້ນສຸດບົດຮຽນແລ້ວ';
$string['eventlessonrestarted'] = 'ເລີ່ມບົດຮຽນຄືນໃໝ່';
$string['eventlessonresumed'] = 'ສືບຕໍ່ບົດຮຽນ';
$string['eventlessonstarted'] = 'ເລີ່ມຕົ້ນບົດຮຽນແລ້ວ';
$string['eventoverridecreated'] = 'ສ້າງການລົບລ້າງບົດຮຽນ';
$string['eventoverridedeleted'] = 'ລຶບການລົບລ້າງບົດຮຽນ';
$string['eventoverrideupdated'] = 'ປັບປຸງການລົບລ້າງບົດຮຽນ';
$string['eventpagecreated'] = 'ສ້າງໜ້າແລ້ວ';
$string['eventpagedeleted'] = 'ລຶບໜ້າແລ້ວ';
$string['eventpagemoved'] = 'ຍ້າຍໜ້າແລ້ວ';
$string['eventpageupdated'] = 'ປັບປຸງໜ້າແລ້ວ';
$string['eventquestionanswered'] = 'ຕອບຄຳຖາມແລ້ວ';
$string['eventquestionviewed'] = 'ເບິ່ງຄຳຖາມແລ້ວ';
$string['false'] = 'ບໍ່ຜ່ານ';
$string['fileformat'] = 'ຮູບແບບໄຟລ໌';
$string['finalwrong'] = 'ບໍ່ປານໃດ.';
$string['finish'] = 'ສຳເລັດ';
$string['firstanswershould'] = 'ຄຳຕອບທຳອິດຄວນຂ້າມໄປໜ້າ "ຖືກຕ້ອງ"';
$string['firstwrong'] = 'ທ່ານໄດ້ຕອບຜິດ. ທ່ານຢາກພະຍາຍາມຕອບຄຳຖາມອີກບໍ? (ຖ້າທ່ານຕອບຄໍາຖາມໄດ້ຢ່າງຖືກຕ້ອງ, ມັນຈະບໍ່ນັບໃສ່ຄະແນນສຸດທ້າຍຂອງທ່ານ.)';
$string['flowcontrol'] = 'ຄວບຄຸມຂັ້ນຕອນ';
$string['fractionsaddwrong'] = 'ຄະແນນໃນທາງບວກທີ່ທ່ານໄດ້ເລືອກບໍ່ໄດ້ເພີ່ມເຂົ້າໃສ່ 100%<br />ແທນທີ່ຈະ, ເຂົາເຈົ້າເພີ່ມຂຶ້ນເປັນ {$ a}%<br />mjkoຕ້ອງການກັບຄືນ ແລະ ແກ້ໄຂຄໍາຖາມນີ້ບໍ?';
$string['fractionsnomax'] = 'ໜຶ່ງໃນຄໍາຕອບຄວນຈະເປັນ 100%, ສະນັ້ນ ມັນເປັນໄປໄດ້ທີ່ຈະໄດ້ຄະແນນເຕັມສໍາລັບຄໍາຖາມນີ້.<br />ເຈົ້າຕ້ອງການກັບຄືນໄປແກ້ໄຂຄໍາຖາມນີ້ບໍ?';
$string['full'] = 'ຂະຫຍາຍແລ້ວ';
$string['general'] = 'ທົ່ວໄປ';
$string['gotoendoflesson'] = 'ໄປທີ່ບົດຮຽນສຸດທ້າຍ';
$string['gradebetterthan'] = 'ຄະແນນດີກວ່າ (&#37;)';
$string['gradebetterthanerror'] = 'ໄດ້ຄະແນນຫຼາຍກວ່າ {$a} ສ່ວນຮ້ອຍ';
$string['graded'] = 'ໄດ້ຄະແນນ';
$string['gradeessay'] = 'ຄະແນນຄຳຖາມບົດຂຽນ ({$a->notgradedcount} ບໍ່ໄດ້ຄະແນນ ແລະ {$a->notsentcount} ບໍ່ໄດ້ສົ່ງ)';
$string['gradeis'] = 'ຄະແນນແມ່ນ {$a}';
$string['gradeoptions'] = 'ຄະແນນທາງເລືອກ';
$string['groupoverrides'] = 'ລົບລ້າງຄະແນນ';
$string['groupoverridesdeleted'] = 'ລຶບລົບການລ້າງຄະແນນ';
$string['groupsnone'] = 'ບໍ່ມີກຸ່ມທີ່ທ່ານສາມາດເຂົ້າຫາ';
$string['handlingofretakes'] = 'ຈັດການກັບການເຮັດຄືນໃໝ່';
$string['handlingofretakes_help'] = 'ຖ້າອະນຸຍາດໃຫ້ເຮັດການສອບເສັງຄືນໃໝ່, ການຕັ້ງຄ່ານີ້ ລະບຸວ່າ ຄະແນນຂອງບົດຮຽນແມ່ນສະເລ່ຍ ຫຼື ສູງສຸດຂອງຄວາມພະຍາຍາມທັງໝົດ.';
$string['havenotgradedyet'] = 'ບໍ່ໄດ້ຄະແນນເທື່ອ.';
$string['here'] = 'ຢູ່ທີ່ນີ້';
$string['highscore'] = 'ຄະແນນສູງ';
$string['hightime'] = 'ເວລາສູງ';
$string['importcount'] = 'ກຳລັງນຳເຂົ້າ {$a} ຄຳຖາມ';
$string['importquestions'] = 'ກຳລັງນຳເຂົ້າຄຳຖາມ';
$string['importquestions_help'] = 'ຄຸນສົມບັດນີ້ ເຮັດໃຫ້ມີຄໍາຖາມໃນຮູບແບບທີ່ຫຼາກຫຼາຍທີ່ຈະນໍາເຂົ້າຜ່ານທາງໄຟລ໌ຂໍ້ຄວາມ.';
$string['inactiveoverridehelp'] = '* ການລົບລ້າງນີ້ ແມ່ນບໍ່ມີການເຄື່ອນໄຫວ ເນື່ອງຈາກການເຂົ້າເຖິງກິດຈະກໍາຂອງຜູ້ໃຊ້ຖືກຈໍາກັດ. ອັນນີ້ສາມາດເປັນຍ້ອນການມອບໝາຍເປັນກຸ່ມ ຫຼື ບົດບາດ, ການຈໍາກັດການເຂົ້າຫາອື່ນໆ ຫຼື ກິດຈະກໍາຖືກເຊື່ອງໄວ້.';
$string['indicator:cognitivedepth'] = 'ຄວາມຮູ້ບົດຮຽນ';
$string['indicator:cognitivedepth_help'] = 'ຕົວຊີ້ວັດນີ້ແມ່ນອີງໃສ່ຄວາມເຂົ້າໃຈຂອງນັກຮຽນທີ່ເຂົ້າເຖິງໄດ້ໃນກິດຈະກໍາບົດຮຽນ.';
$string['indicator:cognitivedepthdef'] = 'ຄວາມຮູ້ບົດຮຽນ';
$string['indicator:cognitivedepthdef_help'] = 'ຜູ້ເຂົ້າຮ່ວມໄດ້ບັນລຸອັດຕາສ່ວນຂອງການມີສ່ວນຮ່ວມທາງດ້ານມັນສະໝອງທີ່ສະ ເໜີໂດຍກິດຈະກໍາບົດຮຽນໃນລະຫວ່າງໄລຍະເວລາການວິເຄາະນີ້ (ລະດັບ = ບໍ່ມີການເບິ່ງ, ເບິ່ງ, ສົ່ງ, ເບິ່ງຄໍາຄິດເຫັນ, ຄໍາຄິດເຫັນກ່ຽວກັບຄໍາຕິຊົມ, ສົ່ງຄືນຫຼັງຈາກເບິ່ງຄໍາຄິດເຫັນ)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'ສັງຄົມບົດຮຽນ';
$string['indicator:socialbreadth_help'] = 'ຕົວຊີ້ວັດນີ້ ແມ່ນອີງໃສ່ຄວາມກວ້າງທາງສັງຄົມທີ່ນັກຮຽນບັນລຸໄດ້ໃນກິດຈະກໍາບົດຮຽນ.';
$string['indicator:socialbreadthdef'] = 'ສັງຄົມບົດຮຽນ';
$string['indicator:socialbreadthdef_help'] = 'ຜູ້ເຂົ້າຮ່ວມໄດ້ ບັນລຸອັດຕາສ່ວນຂອງການມີສ່ວນຮ່ວມທາງສັງຄົມທີ່ສະເໜີໂດຍກິດຈະກໍາບົດຮຽນ ໃນລະຫວ່າງໄລຍະເວລາການວິເຄາະນີ້ (ລະດັບ = ບໍ່ມີການເຂົ້າຮ່ວມ, ຜູ້ເຂົ້າຮ່ວມຢ່າງດຽວ, ຜູ້ເຂົ້າຮ່ວມກັບຜູ້ອື່ນ)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insertedpage'] = 'ໃສ່ໜ້າແລ້ວ';
$string['invalidfile'] = 'ໄຟລ໌ບໍ່ຖືກຕ້ອງ';
$string['invalidid'] = 'ບໍ່ມີລະຫັດປະຈຳຕົວຊຸດລາຍວິຊາ ຫຼື ລະຫັດປະຈຳຕົວບົດຮຽນທີ່ໄດ້ຜ່ານ';
$string['invalidlessonid'] = 'ລະຫັດປະຈຳຕົວບົດຮຽນບໍ່ຖືກຕ້ອງ';
$string['invalidoverrideid'] = 'ລະຫັດປະຈຳຕົວການລົບລ້າງບໍ່ຖືກຕ້ອງ';
$string['invalidpageid'] = 'ລະຫັດປະຈຳຕົວໜ້າບໍ່ຖືກຕ້ອງ';
$string['jump'] = 'ຂ້າມ';
$string['jumps'] = 'ຂ້າມ';
$string['jumps_help'] = 'ແຕ່ລະຄໍາຕອບ (ສໍາລັບຄໍາຖາມ) ຫຼື ຄໍາອະທິບາຍ (ສໍາລັບໜ້າເນື້ອໃນ) ມີການຂ້າມທີ່ສອດຄ້ອງກັນ. ການຂ້າມສາມາດເປັນຕົວແທນໄດ້, ເຊັ່ນ: ໜ້ານີ້ ຫຼື ໜ້າຕໍ່ໄປ, ຫຼື ຢ່າງແທ້ຈິງ, ລະບຸໜ້າໃດໜຶ່ງຂອງໜ້າຕ່າງໆໃນບົດຮຽນ.';
$string['jumpsto'] = 'ຂ້າມໄປ <em>{$a}</em>';
$string['leftduringtimed'] = 'ທ່ານໄດ້ອອກໄປໃນລະຫວ່າງການຮຽນທີ່ເວລາໝົດ.<br />ກະລຸນາ ຄລິກໃສ່ ສືບຕໍ່ ເພື່ອເລີ່ມຕົ້ນບົດຮຽນຄືນໃໝ່.';
$string['leftduringtimednoretake'] = 'ທ່ານໄດ້ປະໄວ້ໃນລະຫວ່າງການຮຽນທີ່ກໍານົດເວລາ ແລະ ທ່ານບໍ່ໄດ້ຖືກອະນຸຍາດໃຫ້ຮຽນຄືນໃໝ່ ຫຼື ສືບຕໍ່ບົດຮຽນໄດ້.';
$string['leftduringtimedsession'] = 'ທ່ານໄດ້ອອກໃນເວລາບົດຮຽນໝົດເວລາ.';
$string['lesson:addinstance'] = 'ເພີ່ມບົດຮຽນໃໝ່';
$string['lesson:edit'] = 'ແກ້ໄຂກິດຈະກຳບົດຮຽນ';
$string['lesson:grade'] = 'ໃຫ້ຄະແນນຄຳຖາມບົດຂຽນບົດຮຽນ';
$string['lesson:manage'] = 'ຈັດການກິດຈະກຳບົດຮຽນ';
$string['lesson:manageoverrides'] = 'ຈັດການການລົບລ້າງບົດຮຽນ';
$string['lesson:view'] = 'ເບິ່ງກິດຈະກຳບົດຮຽນ';
$string['lesson:viewreports'] = 'ເບິ່ງລາຍງານບົດຮຽນ';
$string['lessonbeingpreviewed'] = 'ບົດຮຽນໄດ້ຖືກເບິ່ງຕົວຢ່າງໃນປະຈຸບັນ.';
$string['lessonclosed'] = 'ປິດບົດຮຽນນີ້ໃນ {$a}.';
$string['lessoncloses'] = 'ປິດບົດຮຽນ';
$string['lessoneventcloses'] = '{$a} ປິດ';
$string['lessoneventopens'] = '{$a} ເປີດ';
$string['lessonformating'] = 'ຮູບແບບບົດຮຽນ';
$string['lessonmenu'] = 'ເມນູບົດຮຽນ';
$string['lessonnotready'] = 'ບົດຮຽນນີ້ຍັງບໍ່ພ້ອມທີ່ຈະໃຫ້ເຮັດ. ກະລຸນາຕິດຕໍ່ {$a} ຂອງທ່ານ.';
$string['lessonnotready2'] = 'ບົດຮຽນນີ້ຍັງບໍ່ພ້ອມທີ່ຈະໃຫ້ເຮັດ.';
$string['lessonopen'] = 'ບົດຮຽນນີ້ຈະເປີດໃນ {$a}.';
$string['lessonopens'] = 'ເປີດບົດຮຽນ';
$string['lessonpagelinkingbroken'] = 'ບໍ່ພົບໜ້າທຳ ອິດ. ການເຊື່ອມຕໍ່ຫນ້າຂອງບົດຮຽນຕ້ອງຖືກແຍກ. ກະລຸນາຕິດຕໍ່ຜູ້ເບິ່ງແຍງລະບົບ.';
$string['lessonstats'] = 'ສະຖິຕິບົດຮຽນ';
$string['linkedmedia'] = 'ສື່ທີ່ເຊື່ອມໂຍງແລ້ວ';
$string['loginfail'] = 'ລົ້ມເຫຼວໃນການເຂົ້າສູ່ລະບົບ, ກະລຸນາລອງໃໝ່ອີດຄັ້ງ...';
$string['lowscore'] = 'ຄະແນນຕ່ຳ';
$string['lowtime'] = 'ເວລາໜ້ອຍ';
$string['manualgrading'] = 'ຄະແນນບົດຂຽນ';
$string['matchesanswer'] = 'ຈັບຄູ່ຄຳຖາມ';
$string['matching'] = 'ຈັບຄູ່';
$string['matchingpair'] = 'ຈັບຄູ່ເປັນຄູ່ {$a}';
$string['maxgrade'] = 'ຄະແນນສູງສຸດ';
$string['maxgrade_help'] = 'ການຕັ້ງຄ່ານີ້ ລະບຸຄະແນນສູງສຸດສໍາລັບບົດຮຽນ. ຖ້າຕັ້ງເປັນ 0, ບົດຮຽນບໍ່ປາກົດຢູ່ໃນໜ້າຄະແນນ.';
$string['maximumnumberofanswersbranches'] = 'ຈຳນວນສູງສຸດຂອງຄຳຕອບ';
$string['maximumnumberofanswersbranches_help'] = 'ການຕັ້ງຄ່ານີ້ລະບຸຈໍານວນຄໍາຕອບສູງສຸດທີ່ອາດຈະໃຊ້ຢູ່ໃນບົດຮຽນ. ຖ້າໃຊ້ພຽງແຕ່ຄໍາຖາມທີ່ ຖືກ/ຜິດ, ມັນສາມາດຕັ້ງເປັນ 2. ການຕັ້ງຄ່າອາດຈະຖືກປ່ຽນແປງໄດ້ຕະຫຼອດເວລາ, ເພາະວ່າມັນມີຜົນກັບສິ່ງທີ່ຄູສອນເຫັນເທົ່ານັ້ນ, ບໍ່ແມ່ນຂໍ້ມູນ.';
$string['maximumnumberofattempts'] = 'ຈຳນວນສູງສຸດຂອງຄວາມພະຍາຍາມຕໍ່ໜຶ່ງຄຳຖາມ';
$string['maximumnumberofattempts_help'] = 'ການຕັ້ງຄ່ານີ້ ລະບຸຈໍານວນຄວາມພະຍາຍາມສູງສຸດທີ່ອະນຸຍາດໃຫ້ສໍາລັບແຕ່ລະຄໍາຖາມ. ຖ້າຕອບຜິດຊ້ຳແລ້ວຊ້ຳອີກ, ເມື່ອຮອດຈຳນວນສູງສຸດ, ໜ້າຕໍ່ໄປຂອງບົດຮຽນຈະສະແດງຂຶ້ນ.';
$string['maximumnumberofattemptsreached'] = 'ເຖິງຈໍານວນຄວາມພະຍາຍາມສູງສຸດ - ຍ້າຍໄປໜ້າຕໍ່ໄປ';
$string['mediaclose'] = 'ສະແດງປຸ່ມປິດ:';
$string['mediafile'] = 'ສື່ທີ່ເຊື່ອມໂຍງແລ້ວ';
$string['mediafile_help'] = 'ໄຟລ໌ສື່ອາດຈະຖືກອັບໂຫຼດເພື່ອໃຊ້ເຂົ້າໃນບົດຮຽນ. ລິ້ງ \'ຄລິກທີ່ນີ້ເພື່ອເບິ່ງ\' ຈະຖືກສະແດງຢູ່ໃນບລັອກທີ່ເອີ້ນວ່າ \'ສື່ທີ່ເຊື່ອມໂຍງແລ້ວ\' ຢູ່ໃນແຕ່ລະໜ້າຂອງບົດຮຽນ.';
$string['mediafilepopup'] = 'ຄລິກເພື່ອເບິ່ງ';
$string['mediaheight'] = 'ຄວາມສູງໜ້າຈໍປັອບອັບ';
$string['mediawidth'] = 'ຄວາມກວ້າງໜ້າຈໍປັອບອັບ:';
$string['messageprovider:graded_essay'] = 'ການແຈ້ງເຕືອນບົດຮຽນບົດຂຽນທີ່ໄດ້ຄະແນນ';
$string['minimumnumberofquestions'] = 'ຈຳນວນຕ່ຳສຸດຂອງຄະແນນ';
$string['minimumnumberofquestions_help'] = 'ການຕັ້ງຄ່ານີ້ລະບຸຈໍານວນຄໍາຖາມຕ່ຳສຸດທີ່ຈະຖືກນໍາໃຊ້ເພື່ອຄິດໄລ່ຄະແນນສໍາລັບກິດຈະກໍາ.';
$string['missingname'] = 'ໃສ່ຊື່ຫຼິ້ນ';
$string['modattempts'] = 'ອະນຸຍາດການທົບທວນຄືນນັກຮຽນ';
$string['modattempts_help'] = 'ຖ້າເປີດໃຊ້ງານ, ນັກຮຽນສາມາດນໍາທາງຜ່ານບົດຮຽນອີກເທື່ອຫນຶ່ງຕັ້ງແຕ່ເລີ່ມຕົ້ນ.';
$string['modattemptsnoteacher'] = 'ນັກຮຽນທົບທວນຄືນວຽກສຳລັນນັກຮຽນເທົ່ານັ້ນ.';
$string['modulename'] = 'ບົດຮຽນ';
$string['modulename_help'] = 'ຊຸດກິດຈະກໍາຂອງບົດຮຽນເຮັດໃຫ້ຄູສາມາດສົ່ງເນື້ອຫາ ແລະ/ຫຼື ປະຕິບັດກິດຈະກໍາຕ່າງໆໃນລັກສະນະທີ່ໜ້າສົນໃຈ ແລະ ປ່ຽນແປງໄດ້. ຄູສາມາດນໍາໃຊ້ບົດຮຽນເພື່ອສ້າງຊຸດຂອງຫນ້າເນື້ອຫາ ຫຼື ກິດຈະກໍາການສອນທີ່ສະເໜີເສັ້ນທາງ ຫຼື ທາງເລືອກຕ່າງໆສໍາລັບຜູ້ຮຽນ. ໃນກໍລະນີໃດກໍ່ຕາມ, ຄູອາຈານສາມາດເລືອກທີ່ຈະເພີ່ມການມີສ່ວນພົວພັນ ແລະ ຮັບປະກັນຄວາມເຂົ້າໃຈໂດຍການລວມເອົາຄໍາຖາມທີ່ຫຼາກຫຼາຍ, ເຊັ່ນ: ທາງເລືອກຫຼາຍ, ການຈັບຄູ່ ແລະ ຄໍາຕອບສັ້ນ. ອີງຕາມການເລືອກຄໍາຕອບຂອງນັກຮຽນ ແລະ ວິທີທີ່ຄູພັດທະນາບົດຮຽນ, ນັກຮຽນອາດຈະກ້າວໄປສູ່ໜ້າຕໍ່ໄປ, ຖືກນໍາກັບຄືນໄປຫາໜ້າກ່ອນໜ້າ ຫຼື ຖືກປ່ຽນເສັ້ນທາງໄປສູ່ເສັ້ນທາງທີ່ແຕກຕ່າງກັນທັງໝົດ.

ບົດຮຽນອາດຈະໄດ້ຮັບການຈັດອັນດັບ, ໂດຍມີຄະແນນທີ່ບັນທຶກໄວ້ໃນປຶ້ມຊັ້ນຮຽນ.

ບົດຮຽນອາດຈະຖືກນໍາໃຊ້

* ສໍາລັບການຮຽນຮູ້ດ້ວຍຕົນເອງຂອງຫົວຂໍ້ໃຫມ່
* ສໍາລັບສະຖານະການ ຫຼື ຈໍາລອງ/ການຕັດສິນໃຈການອອກກໍາລັງກາຍ
* ສໍາລັບການແກ້ໄຂທີ່ແຕກຕ່າງກັນ, ມີຊຸດຄໍາຖາມການແກ້ໄຂທີ່ແຕກຕ່າງກັນຂຶ້ນກັບຄໍາຕອບທີ່ໃຫ້ຄໍາຖາມເບື້ອງຕົ້ນ';
$string['modulename_link'] = 'mod/lesson/view';
$string['modulenameplural'] = 'ບົດຮຽນ';
$string['move'] = 'ຍ້າຍໜ້າ';
$string['movedpage'] = 'ຍ້າຍໜ້າແລ້ວ';
$string['movepagehere'] = 'ຍ້າຍໜ້າໄປບ່ອນນີ້';
$string['movepagenamed'] = 'ຍ້າຍໜ້າ: {$a}';
$string['moving'] = 'ກຳລັງຍ້າຍໜ້າ: {$a}';
$string['multianswer'] = 'ຫຼາຍຄຳຕອບ';
$string['multianswer_help'] = 'ໝາຍຕິກໃສ່ກ່ອງໝາຍຖ້າມີຫຼາຍກວ່າໜຶ່ງຄຳຕອບເປັນຄຳຕອບທີ່ຖືກຕ້ອງ.';
$string['multichoice'] = 'ຫຼາຍຕົວເລືອກ';
$string['multipleanswer'] = 'ຫຼາຍຄຳຕອບ';
$string['nameapproved'] = 'ອະນຸຍາດຊື່ແລ້ວ';
$string['namereject'] = 'ຂໍອະໄພ, ຊື່ຂອງທ່ານໄດ້ຖືກປະຕິເສດໂດຍການກັ່ນຕອງ.<br />ກະລຸນາລອງຊື່ອື່ນ.';
$string['new'] = 'ໃໝ່';
$string['nextpage'] = 'ໜ້າຕໍ່ໄປ';
$string['noanswer'] = 'ໜຶ່ງ ຫຼື ຫຼາຍຄຳຖາມບໍ່ມີຄຳຕອບໃຫ້. ກະລຸນາກັບຄືນ ແລະ ສົ່ງຄຳຕອບ.';
$string['noattemptrecordsfound'] = 'ບໍ່ມີບັນທຶກຄວາມພະຍາຍາມ: ບໍ່ມີຄະແນນໃຫ້';
$string['nobranchtablefound'] = 'ບໍ່ພົບເນື້ອຫາໜ້າ';
$string['noclose'] = 'ບໍ່ມີວັນທີ່ປິດ';
$string['nocommentyet'] = 'ບໍ່ມີຄຳເຫັນເທື່ອ.';
$string['nocoursemods'] = 'ບໍ່ພົບກິດຈະກຳ';
$string['nocredit'] = 'ບໍ່ມີຄະແນນເພີ່ມ';
$string['nodeadline'] = 'ບໍ່ມີມື້ກຳນົດ';
$string['noessayquestionsfound'] = 'ບໍ່ພົບຄຳຖາມບົດຂຽນໃນບົດຮຽນນີ້.';
$string['nohighscores'] = 'ບໍ່ມີຄະແນນສູງສຸດ';
$string['nolessonattempts'] = 'ບໍ່ມີຄວາມພະຍາຍາມໃນບົດຮຽນນີ້.';
$string['nolessonattemptsgroup'] = 'ສະມາຊິກກຸ່ມຂອງ {$a} ບໍ່ມີຄວາມພະຍາຍາມໃດໆໃນບົດຮຽນນີ້.';
$string['none'] = 'ບໍ່ມີ';
$string['nooneansweredcorrectly'] = 'ບໍ່ມີໃຜຕອບຄຳຖາມຢ່າງຖືກຕ້ອງ.';
$string['nooneansweredthisquestion'] = 'ບໍ່ມີໃຜຕອບຄຳຖາມນີ້.';
$string['noonecheckedthis'] = 'ບໍ່ມີໃຜໄດ້ກວດສອບສິ່ງນີ້.';
$string['nooneenteredthis'] = 'ບໍ່ມີໃຜເຂົ້າຫາສິ່ງນີ້.';
$string['noonehasanswered'] = 'ບໍ່ມີໃຜໄດ້ຕອບຄຳຖາມບົດຂຽນເທື່ອ.';
$string['noonehasansweredgroup'] = 'ບໍ່ມີໃຜໃນ {$a} ໄດ້ຕອບຄຳຖາມບົດຂຽນເທື່ອ.';
$string['noopen'] = 'ບໍ່ມີວັນທີເປີດ';
$string['nooverridecreated'] = 'ບໍ່ໄດ້ສ້າງການລົບລ້າງ.';
$string['nooverridedata'] = 'ທ່ານຕ້ອງລົບລ້າງຢ່າງໜ້ອຍໜຶ່ງໃນການຕັ້ງຄ່າບົດຮຽນ';
$string['noretake'] = 'ທ່ານບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ເຮັດຄືນບົດຮຽນນີ້.';
$string['normal'] = 'ທຳມະດາ - ປະຕິບັດຕາມເສັ້ນທາງບົດຮຽນ';
$string['notcompleted'] = 'ຍັງບໍ່ສຳເລັດ';
$string['notcompletedwithdate'] = 'ບໍ່ສຳເລັດ ({$a})';
$string['notdefined'] = 'ບໍ່ໄດ້ກຳນົດ';
$string['notenoughsubquestions'] = 'ບໍ່ໄດ້ກໍານົດຄໍາຖາມຍ່ອຍພຽງພໍ!';
$string['notenoughtimespent'] = 'ທ່ານສຳເລັດບົດຮຽນນີ້ໃນ {$a->timespent}, ເຊິ່ງໜ້ອຍກວ່າເວລາທີ່ຕ້ອງການຂອງ {$a->timerequired}. ທ່ານອາດຈະຕ້ອງພະຍາຍາມບົດຮຽນອີກຄັ້ງ.';
$string['notgraded'] = 'ບໍ່ໄດ້ຄະແນນ';
$string['notitle'] = 'ບໍ່ມີຫົວຂໍ້';
$string['notyetcompleted'] = 'ບົດຮຽນໄດ້ເລີ່ມຕົ້ນ, ແຕ່ຍັງບໍ່ສຳເລັດ';
$string['numberofcorrectanswers'] = 'ຈຳນວນຄຳຕອບທີ່ຖືກຕ້ອງ: {$a}';
$string['numberofcorrectanswersheader'] = 'ຈຳນວນຄຳຕອບທີ່ຖືກຕ້ອງ';
$string['numberofcorrectmatches'] = 'ຈຳນວນກົງກັນທີ່ຖືກຕ້ອງ: {$a}';
$string['numberofpagestoshow'] = 'ຈຳນວນໜ້າທີ່ຈະສະແດງ';
$string['numberofpagestoshow_help'] = 'ການຕັ້ງຄ່ານີ້ລະບຸຈໍານວນຫນ້າທີ່ສະແດງຢູ່ໃນບົດຮຽນ. ມັນສາມາດໃຊ້ໄດ້ກັບບົດຮຽນທີ່ມີຫນ້າທີ່ສະແດງຢູ່ໃນລໍາດັບສຸ່ມເທົ່ານັ້ນ (ເມື່ອ "ການປະຕິບັດຫຼັງຈາກຄໍາຕອບທີ່ຖືກຕ້ອງ" ຖືກກໍານົດເປັນ "ສະແດງໜ້າທີ່ບໍ່ເຫັນ" ຫຼື "ສະແດງໜ້າທີ່ບໍ່ມີຄໍາຕອບ"). ຖ້າຕັ້ງເປັນສູນ, ທຸກໆໜ້າຈະຖືກສະແດງ.';
$string['numberofpagesviewed'] = 'ຈຳນວນຄຳຖາມທີ່ໄດ້ຕອບ: {$a}';
$string['numberofpagesviewedheader'] = 'ຈຳນວນຄຳຖາມທີ່ໄດ້ຕອບ';
$string['numberofpagesviewednotice'] = 'ຈຳນວນຄຳຖາມທີ່ໄດ້ຕອບ: {$a->nquestions} (ທ່ານຄວນຕອບຄຳຖາມຢ່າງໜ້ອຍ {$a->minquestions})';
$string['numerical'] = 'ເປັນຕົວເລັກ';
$string['numericanswer'] = 'ຕຳຕອບເປັນຕົວເລກ';
$string['numericanswer_help'] = 'ທ່ານສາມາດລະບຸຕົວເລກດຽວ, ຫຼື ລະດັບຂອງຕົວເລກໂດຍການນໍາໃຊ້ຈໍ້າສອງເມັດ. ຕົວຢ່າງ 2:5 ໝາຍຄວາມວ່າ ຄໍາຕອບໃດໆລະຫວ່າງ 2 ແລະ 5 ແລະ ລວມທັງ 2 ແລະ 5 ແມ່ນຖືກຕ້ອງ.';
$string['offlinedatamessage'] = 'ທ່ານໄດ້ເຮັດວຽກກັບຄວາມພະຍາຍາມນີ້ໂດຍໃຊ້ອຸປະກອນມືຖື. ຂໍ້ມູນຖືກບັນທຶກໄວ້ໃນເວັບໄຊທ໌ນີ້ຄັ້ງສຸດທ້າຍເມື່ອ {$a} ກ່ອນໜ້າ. ກະລຸນາກວດເບິ່ງວ່າ ທ່ານບໍ່ມີວຽກທີ່ບໍ່ໄດ້ບັນທຶກໄວ້.';
$string['ongoing'] = 'ສະແດງຄະແນນກຳລັງດຳເນີນ';
$string['ongoing_help'] = 'ຖ້າເປີດໃຊ້ງານ, ແຕ່ລະໜ້າຈະສະແດງຄະແນນຂອງນັກຮຽນທີ່ໄດ້ຮັບຈາກຈໍານວນທັງຫມົດທີ່ເປັນໄປໄດ້ຈົນເຖິງປະຈຸບັນ.';
$string['ongoingcustom'] = 'ທ່ານໄດ້ {$a->score} ຄະແນນຈາກທັງໝົດ {$a->currenthigh} ຄະແນນມາຮອດປະຈຸ.';
$string['ongoingnormal'] = 'ທ່ານໄດ້ຕອບຄຳຖາມ {$a->correct} ທີ່ຖືກຕ້ອງຈາກທັງໝົດ {$a->viewed} ຂອງຄວາມພະຍາຍາມ.';
$string['onpostperpage'] = 'ໜຶ່ງການໂພສຕໍ່ໜຶ່ງຄະແນນ';
$string['openafterclose'] = 'ທ່ານໄດ້ລະບຸວັນທີເປີດຫຼັງຈາກວັນທີປິດ';
$string['options'] = 'ທາງເລືອກ';
$string['or'] = 'ຫຼື';
$string['ordered'] = 'ຕາມລຳດັບ';
$string['other'] = 'ອື່ນໆ';
$string['outof'] = 'ຈາກທັງໝົດ {$a}';
$string['override'] = 'ລົບລ້າງ';
$string['overridedeletegroupsure'] = 'ທ່ານແນ່ໃຈບໍວ່າທ່ານຕ້ອງການລຶບການລົບລ້າງສຳລັບກຸ່ມ {$a}?';
$string['overridedeleteusersure'] = 'ທ່ານແນ່ໃຈບໍວ່າທ່ານຕ້ອງການລຶບການລົບລ້າງສຳລັບຜູ້ໃຊ້ {$a}?';
$string['overridegroup'] = 'ລົບລ້າງກຸ່ມ';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'ລົບລ້າງ';
$string['overrideuser'] = 'ລົບລ້າງຜູ້ໃຊ້';
$string['overrideusereventname'] = '{$a->lesson} - ລົບລ້າງ';
$string['overview'] = 'ພາບລວມ';
$string['overview_help'] = 'ບົດຮຽນແມ່ນປະກອບດ້ວຍຈໍານວນໜ້າ ແລະ ໜ້າເນື້ອໃນທາງເລືອກ. ໜ້າໃດໜຶ່ງມີບາງເນື້ອໃນ  ແລະ ປົກກະຕິແລ້ວຈະສິ້ນສຸດດ້ວຍຄຳຖາມ. ກ່ຽວຂ້ອງກັບແຕ່ລະຄໍາຕອບຂອງຄໍາຖາມແມ່ນການກະໂດດ. ການໂດດສາມາດກ່ຽວຂ້ອງກັນ, ເຊັ່ນ: ໜ້ານີ້ ຫຼື ໜ້າຕໍ່ໄປ, ຫຼື ຢ່າງແທ້ຈິງ, ລະບຸຫນ້າໃດໜຶ່ງໃນບົດຮຽນ. ໜ້າເນື້ອຫາແມ່ນຫນ້າທີ່ມີຊຸດຂອງການເຊື່ອມຕໍ່ໄປຫາໜ້າອື່ນໆໃນບົດຮຽນ, ຕົວຢ່າງ: ສາລະບານ.';
$string['page'] = 'ໜ້າ: {$a}';
$string['page-mod-lesson-edit'] = 'ແກ້ໄຂໜ້າບົດຮຽນ';
$string['page-mod-lesson-view'] = 'ເບິ່ງ ຫຼື ເບິ່ງຕົວຢ່າງໜ້າແກ້ໄຂ';
$string['page-mod-lesson-x'] = 'ໜ້າບົດຮຽນໃດໜຶ່ງ';
$string['pageanswers'] = 'ໜ້າຄຳຕອບ';
$string['pagecontents'] = 'ໜ້າເນື້ອໃນ';
$string['pageresponses'] = 'ໜ້າຕອບກັບ';
$string['pages'] = 'ໜ້າ';
$string['pagetitle'] = 'ຫົວຂໍ້ໜ້າ';
$string['password'] = 'ລະຫັດຜ່ານ';
$string['passwordprotectedlesson'] = '{$a} ແມ່ນບົດຮຽນທີ່ປົກປ້ອງດ້ວຍລະຫັດຜ່ານ.';
$string['pleasecheckoneanswer'] = 'ກະລຸນາກວດສອບໜຶ່ງຄຳຖາມ';
$string['pleasecheckoneormoreanswers'] = 'ກະລຸນາກວດສອບໜຶ່ງ ຫຼື ຫຼາຍຄຳຖາມ';
$string['pleaseenteryouranswerinthebox'] = 'ກະລຸນາໃສ່ຄຳຕອບຂອງທ່ານໃນກ່ອງ';
$string['pleasematchtheabovepairs'] = 'ກະລຸນາຈັບຄູ່ຄູ່ຂ້າງເທິງ';
$string['pluginadministration'] = 'ການບໍລິຫານບົດຮຽນ';
$string['pluginname'] = 'ບົດຮຽນ';
$string['pointsearned'] = 'ໄດ້ຮັບຄະແນນ';
$string['postprocesserror'] = 'ເກີດມີຄວາມຜິດພາດໃນເວລາຫຼັງຈາກການປະເມີນ!';
$string['postsuccess'] = 'ຫຼັງຈາກການສຳເລັດ';
$string['practice'] = 'ບົດຝຶກຫັດ';
$string['practice_help'] = 'ບົດຝຶກຫັດບໍ່ປະກົດໃນປື້ມຄະແນນ';
$string['preprocesserror'] = 'ເກີດມີຄວາມຜິດພາດໃນເວລາການປະເມີນລ່ວງໜ້າ!';
$string['prerequisiteisobsolete'] = 'ທາງເລືອກບົດຮຽນແບບັງຄັບນີ້ ແມ່ນເນື່ອງຈາກວ່າ ຈະຖືກລົບອອກ. ກະລຸນາໃຊ້ຂໍ້ຈຳກັດການເຂົ້າເຖິງແທນ.';
$string['prerequisitelesson'] = 'ບົດຮຽນແບບບັງຄັບ';
$string['preview'] = 'ເບິ່ງຕົວຢ່າງ';
$string['previewlesson'] = 'ເບິ່ງຕົວຢ່າງ {$a}';
$string['previewpagenamed'] = 'ໜ້າເບິ່ງຕົວຢ່າງ: {$a}';
$string['previouspage'] = 'ໜ້າກ່ອນໜ້າ';
$string['privacy:metadata:attempts'] = 'ບັນທຶກຂອງໜ້າພະຍາຍາມ';
$string['privacy:metadata:attempts:answerid'] = 'ລະຫັດປະຈຳຕົວຄຳຕອບ';
$string['privacy:metadata:attempts:correct'] = 'ບໍ່ວ່າຄວາມພະຍາຍາມຈະຖືກຕ້ອງ';
$string['privacy:metadata:attempts:pageid'] = 'ລະຫັດປະຈຳຕົວໜ້າ';
$string['privacy:metadata:attempts:retry'] = 'ໝາຍເລກຄວາມພະຍາຍາມ';
$string['privacy:metadata:attempts:timeseen'] = 'ເວລາເມື່ອໄດ້ເຮັດຄວາມພະຍາຍາມ';
$string['privacy:metadata:attempts:useranswer'] = 'ລາຍລະອຽດກ່ຽວກັບຄຳຕອບຂອງຜູ້ໃຊ້';
$string['privacy:metadata:attempts:userid'] = 'ລະຫັດປະຈຳຕົວຂອງຜູ້ໃຊ້';
$string['privacy:metadata:branch'] = 'ບັນທຶກຂອງໜ້າທີ່ໄດ້ເບິ່ງ';
$string['privacy:metadata:branch:flag'] = 'ບໍ່ວ່າຈະເປັນໜ້າຕໍ່ໄປໄດ້ຄິດໄລ່ແບບສຸ່ມ';
$string['privacy:metadata:branch:nextpageid'] = 'ລະຫັດປະຈຳຕົວໜ້າຕໍ່ໄປ';
$string['privacy:metadata:branch:pageid'] = 'ລະຫັດປະຈຳຕົວໜ້າ';
$string['privacy:metadata:branch:retry'] = 'ຈຳນວນຄວາມພະຍາຍາມ';
$string['privacy:metadata:branch:timeseen'] = 'ເວລາທີ່ໄດ້ເບິ່ງໜ້າ';
$string['privacy:metadata:branch:userid'] = 'ລະຫັດປະຈຳຕົວຜູ້ໃຊ້';
$string['privacy:metadata:grades'] = 'ບັນທຶກຂອງຄະແນນສຳລັບແຕ່ລະບົດຮຽນ';
$string['privacy:metadata:grades:completed'] = 'ວັນທີທີ່ໄດ້ໃຫ້ຄະແນນ';
$string['privacy:metadata:grades:grade'] = 'ຄະແນນທີ່ໃຫ້';
$string['privacy:metadata:grades:userid'] = 'ລະຫັດປະຈຳຕົວຜູ້ໃຊ້';
$string['privacy:metadata:overrides'] = 'ບັນທຶກການລົບລ້າງຕໍ່ບົດຮຽນ';
$string['privacy:metadata:overrides:available'] = 'ເວລາເມື່ອອາດມີຄວາມພະຍາຍາມບົດຮຽນ';
$string['privacy:metadata:overrides:deadline'] = 'ເສັ້ນຕາຍສຳລັບການສຳເລັດບົດຮຽນ.';
$string['privacy:metadata:overrides:maxattempts'] = 'ຈຳນວນຄວາມພະຍາຍາມສູງສຸດ';
$string['privacy:metadata:overrides:password'] = 'ລະຫັດຜ່ານເພື່ອເຂົ້າເຖິງບົດຮຽນ';
$string['privacy:metadata:overrides:retake'] = 'ບໍ່ວ່າຈະໄດ້ອະນຸຍາດໃຫ້ມີການເຮັດຄືນໃໝ່';
$string['privacy:metadata:overrides:review'] = 'ບໍ່ວ່າຈະໄດ້ອະນຸຍາດໃຫ້ລອງຕອບຄຳຖາມຄືນໃໝ່';
$string['privacy:metadata:overrides:timelimit'] = 'ເວລາຈຳກັດໃຫ້ສຳເລັດບົດຮຽນ, ໃນວິນາທີ';
$string['privacy:metadata:overrides:userid'] = 'ລະຫັດປະຈຳຕົວຜູ້ໃຊ້';
$string['privacy:metadata:timer'] = 'ບັນທຶກຂອງຄວາມພະຍາຍາມບົດຮຽນ';
$string['privacy:metadata:timer:completed'] = 'ບໍ່ວ່າຄວາມພະຍາຍາມຈະສຳເລັດ';
$string['privacy:metadata:timer:lessontime'] = 'ຊ່ວງເວລາສຸດທ້າຍທີ່ພວກເຮົາໄດ້ບັນຶກກິດຈະກຳ';
$string['privacy:metadata:timer:starttime'] = 'ວັນທີທີ່ພວກເຮົາໄດ້ພະຍາຍາມເລີ່ມຕົ້ນ';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'ຊ່ວງເວລາສຸດທ້າຍທີ່ພວກເຮົາບັນທຶກການເຄື່ອນໄຫວຈາກແອັບຯມືຖື';
$string['privacy:metadata:timer:userid'] = 'ລະຫັດປະຈຳຕົວຜູ້ໃຊ້';
$string['privacy:metadata:userpref:lessonview'] = 'ໂໝດສະແດງທີ່ມັກເທື່ອກຳລັງແກ້ໄຂບົດຮຽນ';
$string['privacy:path:essayanswers'] = 'ຄຳຕອບບົດຂຽນ';
$string['privacy:path:essayresponses'] = 'ການຕອບບົດຂຽນ';
$string['privacy:path:pages'] = 'ໜ້າ';
$string['processerror'] = 'ມີຄວາມຜິດພາດເກີດຂື້ນໃນລະຫວ່າງກຳລັງປະເມີນ!';
$string['progressbar'] = 'ແຖບຄວາມກ້າວໜ້າ';
$string['progressbar_help'] = 'ຖ້າເປີດໃຊ້, ແຖບຈະສະແດງຢູ່ດ້ານລຸ່ມຂອງຫນ້າບົດຮຽນສະແດງໃຫ້ເຫັນອັດຕາສ່ວນການສໍາເລັດໂດຍປະມານ.';
$string['progressbarteacherwarning'] = 'ແຖບຄວາມຄືບໜ້າບໍ່ສະແດງສຳລັບ {$a}';
$string['progressbarteacherwarning2'] = 'ທ່ານຈະບໍ່ເຫັນແຖບຄວາມຄືບໜ້າ ເພາະວ່າທ່ານສາມາດແກ້ໄຂບົດຮຽນນີ້ໄດ້';
$string['progresscompleted'] = 'ທ່ານໄດ້ສຳເລັດ {$a}% ຂອງບົດຮຽນ';
$string['qtype'] = 'ປະເພດໜ້າ';
$string['question'] = 'ຄຳຖາມ';
$string['questionoption'] = 'ຄຳຖາມ';
$string['questiontype'] = 'ປະເພດຄຳຖາມ';
$string['randombranch'] = 'ໜ້າເນື້ອຫາສຸ່ມ';
$string['randompageinbranch'] = 'ຄຳຖາມສຸ່ມພາຍໃນໜ້າເນື້ອຫາ';
$string['rank'] = 'ອັນດັບ';
$string['rawgrade'] = 'ຄະແນນດິບ';
$string['receivedcredit'] = 'ໄດ້ຮັບຄະແນນເພີ່ມ';
$string['redisplaypage'] = 'ໜ້າສະແດງ';
$string['removeallgroupoverrides'] = 'ລຶບການລົບລ້າງກຸ່ມທັງໝົດ';
$string['removealluseroverrides'] = 'ລຶບການລົບລ້າງຜູ້ໃຊ້ທັງໝົດ';
$string['report'] = 'ລາຍງານ';
$string['reports'] = 'ລາຍງານ';
$string['response'] = 'ການຕອບ';
$string['retakesallowed'] = 'ອະນຸຍາດໃຫ້ເຮັດຄືນໃໝ່';
$string['retakesallowed_help'] = 'ຖ້າເປີດໃຊ້, ນັກຮຽນສາມາດພະຍາຍາມບົດຮຽນຫຼາຍກວ່າຫນຶ່ງຄັ້ງ.';
$string['returnto'] = 'ກັບຄືນສູ່ {$a}';
$string['returntocourse'] = 'ກັບຄືນສູ່ລາຍວິຊາ';
$string['reverttodefaults'] = 'ກັບໄປເປັນຄ່າເລີ່ມຕົ້ນຂອງບົດຮຽນ';
$string['review'] = 'ທົບທວນຄືນ';
$string['reviewlesson'] = 'ທົບທວນຄືນ';
$string['reviewquestionback'] = 'ແມ່ນແລ້ວ, ຂ້ອຍຕ້ອງການທີ່ຈະລອງ';
$string['reviewquestioncontinue'] = 'ບໍ່ແມ່ນ, ຂ້ອຍຕ້ອງການທີ່ຈະໄປຫາຄຳຖາມຕໍ່ໄປ';
$string['sanitycheckfailed'] = 'ການກວດສອບຄວາມບໍ່ປົກກະຕິບໍ່ສຳເລັດ: ຄວາມພະຍາຍາມນີ້ຖືກລຶບແລ້ວ';
$string['save'] = 'ບັນທຶກ';
$string['savechanges'] = 'ບັນທຶກການປ່ຽແປງ';
$string['savechangesandeol'] = 'ບັນທຶກການປ່ຽນແປງທັງໝົດ ແລະ ໄປໃນຕອນທ້າຍຂອງບົດຮຽນ.';
$string['saveoverrideandstay'] = 'ບັນທຶກ ແລະ ປ້ອນເຂົ້າການລົບລ້າງອື່ນ';
$string['savepage'] = 'ໜ້າບັນທຶກ';
$string['score'] = 'ຄະແນນ';
$string['score_help'] = 'ຄະແນນແມ່ນໃຊ້ພຽງແຕ່ເມື່ອການໃຫ້ຄະແນນແບບກຳນົດເອງຖືກເປີດໃຊ້ງານ. ແຕ່ລະຄໍາຕອບສາມາດໄດ້ຮັບຄ່າຈຸດເປັນຕົວເລກ (ບວກ ຫຼື ລົບ).';
$string['scores'] = 'ຄະແນນ';
$string['search:activity'] = 'ບົດຮຽນ - ຂໍ້ມູນກິດຈະກຳ';
$string['secondpluswrong'] = 'ບໍ່ປານໃດ. ທ່ານຕ້ອງການລອງໃໝ່ອີກຄັ້ງບໍ?';
$string['selectallattempts'] = 'ເລືອກຄວາມພະຍາຍາມທັງໝົດ';
$string['selectaqtype'] = 'ເລືອກປະເພດຄຳຖາມ';
$string['sent'] = 'ສົ່ງແລ້ວ';
$string['shortanswer'] = 'ຄຳຕອບສັ້ນ';
$string['showanunansweredpage'] = 'ສະແດງໜ້າທີ່ບໍ່ໄດ້ຕອບຄຳຖາມ';
$string['showanunseenpage'] = 'ສະແດງໜ້າທີ່ບໍ່ໄດ້ພົບເຫັນ';
$string['singleanswer'] = 'ຄຳຕອບດຽວ';
$string['skip'] = 'ຂ້າມການນຳທາງ';
$string['slideshow'] = 'ສະໄລ້ໂຊ';
$string['slideshow_help'] = 'ຖ້າເປີດໃຊ້ງານ, ບົດຮຽນຈະສະແດງເປັນສະໄລ້ໂຊ, ມີຄວາມກວ້າງ ແລະ ຄວາມສູງຄົງທີ່.';
$string['slideshowbgcolor'] = 'ສີພື້ນຫຼັງສະໄລ້ໂຊ';
$string['slideshowheight'] = 'ຄວາມສູງສະໄລ້ໂຊ';
$string['slideshowwidth'] = 'ຄວາມກວ້າງສະໄລ້ໂຊ';
$string['startlesson'] = 'ເລີ່ມບົດຮຽນ';
$string['studentattemptlesson'] = '{$a->lastname}, {$a->attempt} ຈຳນວນຄວາມພະຍາຍາມຂອງ {$a->firstname}';
$string['studentname'] = 'ຊື່ {$a}';
$string['studentoneminwarning'] = 'ຄຳເຕືອນ: ທ່ານມີ 1 ນາທີ ຫຼື ໜ້ອຍກວ່າເພື່ອສຳເລັດບດຮຽນນີ້.';
$string['studentoutoftimeforreview'] = 'ເຊີນຊາບ: ທ່ານບໍ່ມີເວລາສຳລັບການທົບທວນບົດຮຽນນີ້';
$string['studentresponse'] = 'ການຕອບກັບຂອງ {$a}';
$string['submit'] = 'ສົ່ງ';
$string['submitname'] = 'ຊື່ສົ່ງ';
$string['teacherjumpwarning'] = 'ການໂດດ {$a->cluster} ຫຼື ການກະໂດດ {$a->unseen} ຖືກໃຊ້ໃນບົດຮຽນນີ້. ການໂດດໜ້າຕໍ່ໄປຈະຖືກໃຊ້ແທນ. ເຂົ້າສູ່ລະບົບເປັນນັກຮຽນເພື່ອທົດສອບການໂດດເຫຼົ່ານີ້.';
$string['teacherongoingwarning'] = 'ຄະແນນຕໍ່ເນື່ອງແມ່ນສະແດງໃຫ້ນັກຮຽນເທົ່ານັ້ນ. ເຂົ້າສູ່ລະບົບເປັນນັກຮຽນເພື່ອທົດສອບຄະແນນຢ່າງຕໍ່ເນື່ອງ.';
$string['teachertimerwarning'] = 'ເຄື່ອງຈັບເວລາໃຊ້ໄດ້ກັບນັກຮຽນເທົ່ານັ້ນ. ທົດສອບໂມງຈັບເວລາໂດຍການເຂົ້າສູ່ລະບົບເປັນນັກຮຽນ.';
$string['thatsthecorrectanswer'] = 'ນັ້ນແມ່ນຄຳຕອບທີ່ຖືກຕ້ອງ';
$string['thatsthewronganswer'] = 'ນັ້ນແມ່ນຄຳຕອບທີ່ຜິດ';
$string['thefollowingpagesjumptothispage'] = 'ໜ້າຕໍ່ໄປນີ້ກະໂດດໄປໜ້ານີ້';
$string['thispage'] = 'ໜ້ານີ້';
$string['timeisup'] = 'ເວລາໝົດແລ້ວ';
$string['timelimit'] = 'ຈຳກັດເວລາ';
$string['timelimit_help'] = 'ຖ້າເປີດໃຊ້ງານ, ການເຕືອນກ່ຽວກັບການກໍານົດເວລາຈະສະແດງໃນຕອນຕົ້ນຂອງບົດຮຽນ ແລະ ເຄື່ອງຈັບເວລານັບຖອຍຫຼັງຈະສະແດງ. ຄໍາຕອບໃດໆທີ່ໄດ້ຮັບຫຼັງຈາກເວລາຜ່ານໄປແມ່ນບໍ່ໄດ້ຮັບຄະແນນ.';
$string['timelimitwarning'] = 'ທ່ານມີ {$a} ເພື່ອສຳເລັດບົດຮຽນນີ້';
$string['timeremaining'] = 'ເວລາທີ່ຍັງເຫຼືອ';
$string['timespenterror'] = 'ໃຊ້ເວລາຢ່າງໜ້ອຍ {$a} ນາທີໃນບົດຮຽນ';
$string['timespentminutes'] = 'ເວລາທີ່ໃຊ້ (ນາທີ)';
$string['timetaken'] = 'ເວລາທີ່ໄດ້ໃຊ້';
$string['totalpagesviewedheader'] = 'ຈຳນວນໜ້າທີ່ໄດ້ເບິ່ງ';
$string['true'] = 'ຖືກ';
$string['truefalse'] = 'ຖືກ/ຜິດ';
$string['unabledtosavefile'] = 'ໄຟລ໌ທີ່ທ່ານອັບໂຫຼດບໍ່ສາມາດບັນທຶກໄດ້';
$string['unknownqtypesnotimported'] = '{$a} ຄຳຖາມທີ່ບໍ່ຮອງຮັບປະເພດຄຳຖາມບໍ່ໄດ້ຖືກນຳເຂົ້າ';
$string['unseenpageinbranch'] = 'ບໍ່ເຫັນຄຳຖາມພາຍໃນໜ້າເນື້ອຫາ';
$string['unsupportedqtype'] = 'ປະເພດຄຳຖາມບໍ່ຮັບຮອງ ({$a})!';
$string['updatedpage'] = 'ປັບປຸງໜ້າແລ້ວ';
$string['updatefailed'] = 'ປັບປຸງຜິດພາດ';
$string['updatepagenamed'] = 'ໜ້າປັບປຸງ: {$a}';
$string['usemaximum'] = 'ນຳໃຊ້ສູງສຸດ';
$string['usemean'] = 'ນຳໃຊ້ໝາຍເຖິງ';
$string['usepassword'] = 'ບົດຮຽນທີ່ປົກປ້ອງໂດຍລະຫັດຜ່ານ';
$string['usepassword_help'] = 'ຖ້າເປີດໃຊ້ງານ, ຈຳເປັນຕ້ອງມີລະຫັດຜ່ານເພື່ອເຂົ້າຫາບົດຮຽນ.';
$string['useroverrides'] = 'ລົບລ້າງຜູ້ໃຊ້';
$string['useroverridesdeleted'] = 'ລຶບການລົບລ້າງຜູ້ໃຊ້ແລ້ວ';
$string['usersnone'] = 'ບໍ່ມີນັດຮຽນເຂົ້າເຖິງບົດຮຽນນີ້';
$string['viewessayanswers'] = 'ເບິ່ງຄຳຕອບບົດຂຽນ';
$string['viewgrades'] = 'ເບິ່ງຄະແນນ';
$string['viewreports'] = 'ເບິ່ງ {$a->attempts} ສຳເລັດແລ້ວ {$a->student} ພະຍາຍາມ';
$string['viewreports2'] = 'ເບິ່ງຄວາມພະຍາຍາມ {$a} ສຳເລັດແລ້ວ';
$string['warning'] = 'ຄຳເຕືອນ';
$string['welldone'] = 'ດີຫຼາຍ!';
$string['whatdofirst'] = 'ທ່ານຕ້ອງການເຮັດຫຍັງກ່ອນໝູ່?';
$string['withselectedattempts'] = 'ກັບຄວາມພະຍາຍາມທີ່ເລືອກ...';
$string['wronganswerjump'] = 'ກະໂດດຄຳຕອບຜິດ';
$string['wronganswerscore'] = 'ຄະແນນຄຳຕອບຜິດ';
$string['wrongresponse'] = 'ການຕອບກັບຜິດ';
$string['youhaveseen'] = 'ທ່ານໄດ້ເຫັນຫຼາຍກວ່າໜຶ່ງໜ້າຂອງບົດຮຽນນີ້ແລ້ວ.<br />ທ່ານຕ້ອງການເລີ່ມຕົ້ນທີ່ໜ້າສຸດທ້າຍທີ່ທ່ານເຫັນບໍ?';
$string['youranswer'] = 'ຄຳຕອບຂອງທ່ານ';
$string['yourcurrentgradeis'] = 'ຄະແນນປະຈຸບັນຂອງທ່ານແມ່ນ {$a}';
$string['yourcurrentgradeisoutof'] = 'ຄະແນນປະຈຸບັນຂອງທ່ານແມ່ນ {$a->grade} ຈາກທັງໝົດ {$a->total}';
$string['youshouldview'] = 'ທ່ານຄວນຕອບຄຳຖາມຢ່າງໜ້ອຍ: {$a}';
