<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'install', language 'lo', version '5.1'.
 *
 * @package     install
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admindirerror'] = 'ລາຍຊື່ຜູ້ເບິ່ງແຍງລະບົບທີ່ລະບຸນັ້ນບໍ່ຖືກຕ້ອງ';
$string['admindirname'] = 'ບັນຊີຜູ້ເບິ່ງແຍງ';
$string['admindirsetting'] = 'webhosts ຈໍານວນໜ້ອຍດຽວໃຊ້ /admin ເປັນ URL ພິເສດສໍາລັບທ່ານທີ່ຈະເຂົ້າເຖິງ
     ກະດານຄວບຄຸມ ຫຼື ບາງສິ່ງບາງຢ່າງ. ແຕ່ຫນ້າເສຍດາຍ, ສິ່ງນີ້ຂັດແຍ້ງກັບ
     ສະຖານທີ່ມາດຕະຖານສໍາລັບໜ້າຜູ້ເບິ່ງແຍງລະບົບ Moodle. ທ່ານສາມາດແກ້ໄຂນີ້ໂດຍ
     ການປ່ຽນຊື່ລາຍການຜູ້ເບິ່ງແຍງລະບົບໃນການຕິດຕັ້ງຂອງທ່ານ, ແລະ ໃສ່ມັນ
     ຊື່ໃຫມ່ຢູ່ທີ່ນີ້. ຕົວຢ່າງ: <br /> <br /> <b>moodleadmin</b><br /> <br />
     ສິ່ງນີ້ຈະແກ້ໄຂການເຊື່ອມຕໍ່ຜູ້ເບິ່ງແຍງລະບົບໃນ Moodle.';
$string['admindirsettinghead'] = 'ການຕັ້ງຄ່າບັນຊີຜູ້ເບິ່ງແຍງ...';
$string['admindirsettingsub'] = 'webhosts ຈໍານວນໜ້ອຍດຽວໃຊ້ /admin ເປັນ URL ພິເສດສໍາລັບທ່ານທີ່ຈະເຂົ້າເຖິງ
     ກະດານຄວບຄຸມ ຫຼື ບາງສິ່ງບາງຢ່າງ. ແຕ່ຫນ້າເສຍດາຍ, ສິ່ງນີ້ຂັດແຍ້ງກັບ
     ສະຖານທີ່ມາດຕະຖານສໍາລັບໜ້າຜູ້ເບິ່ງແຍງລະບົບ Moodle. ທ່ານສາມາດແກ້ໄຂນີ້ໂດຍ
     ການປ່ຽນຊື່ລາຍການຜູ້ເບິ່ງແຍງລະບົບໃນການຕິດຕັ້ງຂອງທ່ານ, ແລະ ໃສ່ມັນ
     ຊື່ໃຫມ່ຢູ່ທີ່ນີ້. ຕົວຢ່າງ: <br /> <br /> <b>moodleadmin</b><br /> <br />
     ສິ່ງນີ້ຈະແກ້ໄຂການເຊື່ອມຕໍ່ຜູ້ເບິ່ງແຍງລະບົບໃນ Moodle.';
$string['availablelangs'] = 'ຊຸດພາສາທີ່ມີໃຫ້';
$string['caution'] = 'ການເຕືອນ';
$string['chooselanguage'] = 'ເລືອກພາສາ';
$string['chooselanguagehead'] = 'ເລືອກພາສາ';
$string['chooselanguagesub'] = 'ກະລຸນາເລືອກພາສາສໍາລັບການຕິດຕັ້ງ. ພາສານີ້ຍັງຈະຖືກໃຊ້ເປັນພາສາເລີ່ມຕົ້ນສໍາລັບເວັບໄຊທ໌, ເຖິງແມ່ນວ່າ ມັນອາດຈະຖືກປ່ຽນແປງໃນພາຍຫຼັງ.';
$string['cliadminemail'] = 'ທີ່ຢູ່ອີເມວຜູ້ໃຊ້ຜູ້ເບິ່ງແຍງລະບົບໃໝ່';
$string['cliadminpassword'] = 'ລະຫັດຜ່ານຜູ້ໃຊ້ຜູ້ເບິ່ງແຍງລະບົບໃໝ່';
$string['cliadminusername'] = 'ຊື່ຜູ້ໃຊ້ບັນຊີຜູ້ເບິ່ງແຍງລະບົບ';
$string['clialreadyconfigured'] = 'ໄຟລ໌ການຕັ້ງຄ່າ config.php ມີຢູ່ແລ້ວ. ກະລຸນາໃຊ້ admin/cli/install_database.php ເພື່ອຕິດຕັ້ງ Moodle ສໍາລັບເວັບໄຊທ໌ນີ້.';
$string['clialreadyinstalled'] = 'ໄຟລ໌ການຕັ້ງຄ່າ config.php ມີຢູ່ແລ້ວ. ກະລຸນາໃຊ້ admin/cli/install_database.php ເພື່ອອັບເກຣດ Moodle ສໍາລັບເວັບໄຊນີ້.';
$string['cliinstallfinished'] = 'ການຕິດຕັ້ງສຳເລັດແລ້ວ.';
$string['cliinstallheader'] = 'ໂຄງການການຕິດຕັ້ງສາຍຄຳສັ່ງ Moodle {$a}';
$string['climustagreelicense'] = 'ໃນຮູບແບບທີ່ບໍ່ແມ່ນການໂຕ້ຕອບທີ່ທ່ານຕ້ອງໄດ້ເຫັນດີກັບໃບອະນຸຍາດໂດຍການລະບຸທາງເລືອກ ໃບອະນຸຍາດ -- ເຫັນດີ-';
$string['cliskipdatabase'] = 'ກຳລັງຂ້າມການຕິດຕັ້ງຖານຂໍ້ມູນ.';
$string['clisupportemail'] = 'ສະໜັບສະໜູນທີ່ຢູ່ອີເມລ';
$string['clitablesexist'] = 'ຕາຕະລາງຖານຂໍ້ມູນແລ້ວ; ການຕິດຕັ້ງ CLI ບໍ່ສາມາດສືບຕໍ່ໄດ້.';
$string['compatibilitysettings'] = 'ກຳລັງກວດສອບການຕັ້ງຄ່າ PHP ຂອງທ່ານ...';
$string['compatibilitysettingshead'] = 'ກຳລັງກວດສອບການຕັ້ງຄ່າ PHP ຂອງທ່ານ...';
$string['compatibilitysettingssub'] = 'ເຄື່ອງແມ່ຂ່າຍຂອງທ່ານຄວນຜ່ານການທົດສອບທັງຫມົດເຫຼົ່ານີ້ ເພື່ອເຮັດໃຫ້ Moodle ເຮັດວຽກຢ່າງຖືກຕ້ອງ';
$string['configfilenotwritten'] = 'ສະຄຣິບຕິດຕັ້ງບໍ່ສາມາດສ້າງໄຟລ໌ config.php ທີ່ມີການຕັ້ງຄ່າທີ່ທ່ານເລືອກໄດ້ໂດຍອັດຕະໂນມັດ, ອາດຈະເປັນຍ້ອນລາຍການ Moodle ບໍ່ສາມາດຂຽນໄດ້. ທ່ານສາມາດຄັດລອກລະຫັດຕໍ່ໄປນີ້ດ້ວຍຕົນເອງເຂົ້າໄປໃນໄຟລ໌ທີ່ມີຊື່ວ່າ config.php ພາຍໃນລະບົບຮາກຂອງ Moodle.';
$string['configfilewritten'] = 'config.php ໄດ້ຖືກສ້າງຢ່າງສຳເລັດ';
$string['configurationcomplete'] = 'ການກຳນົດຄ່າສຳເລັດແລ້ວ';
$string['configurationcompletehead'] = 'ການກຳນົດຄ່າສຳເລັດແລ້ວ';
$string['configurationcompletesub'] = 'Moodle ໄດ້ພະຍາຍາມບັນທຶກການຕັ້ງຄ່າຂອງທ່ານໃນໄຟລ໌ໃນຮາກຂອງການຕິດຕັ້ງ Moodle ຂອງທ່ານ.';
$string['database'] = 'ຖານຂໍ້ມູນ';
$string['databasehead'] = 'ການຕັ້ງຄ່າຖານຂໍ້ມູນ';
$string['databasehost'] = 'ເຈົ້າພາບຖານຂໍ້ມູນ';
$string['databasename'] = 'ຊື່ຖານຂໍ້ມູນ';
$string['databasepass'] = 'ລະຫັດຜ່ານຖານຂໍ້ມູນ';
$string['databaseport'] = 'ພອດຖານຂໍ້ມູນ';
$string['databasesocket'] = 'ເຕົ້າຮັບ Unix';
$string['databasetypehead'] = 'ເລືອກຕົວຂັບເຄື່ອນຖານຂໍ້ມູນ';
$string['databasetypesub'] = 'Moodle ຮອງຮັບເຄື່ອງແມ່ຂ່າຍຖານຂໍ້ມູນຫຼາຍປະເພດ. ກະລຸນາຕິດຕໍ່ຜູ້ບໍລິຫານເຊີບເວີຖ້າຫາກວ່າ ທ່ານບໍ່ຮູ້ວ່າປະເພດໃດທີ່ຈະນໍາໃຊ້.';
$string['databaseuser'] = 'ຜູ້ໃຊ້ຖານຂໍ້ມູນ';
$string['dataroot'] = 'ລາຍການຂໍ້ມູນ';
$string['datarooterror'] = 'ບໍ່ພົບ ຫຼື ສ້າງ \'ລາຍການຂໍ້ມູນ\' ທີ່ທ່ານລະບຸໄວ້. ແກ້ໄຂເສັ້ນທາງ ຫຼື ສ້າງລາຍການນັ້ນດ້ວຍຕົນເອງ.';
$string['datarootpermission'] = 'ການອະນຸຍາດລາຍການຂໍ້ມູນ';
$string['datarootpublicerror'] = '\'ລາຍການຂໍ້ມູນ\' ທີ່ທ່ານລະບຸແມ່ນສາມາດເຂົ້າເຖິງໄດ້ໂດຍກົງຜ່ານເວັບ, ທ່ານຕ້ອງໃຊ້ລາຍການທີ່ແຕກຕ່າງກັນ.';
$string['dbconnectionerror'] = 'ພວກເຮົາບໍ່ສາມາດເຊື່ອມຕໍ່ກັບຖານຂໍ້ມູນທີ່ທ່ານລະບຸໄດ້. ກະລຸນາກວດເບິ່ງການຕັ້ງຄ່າຖານຂໍ້ມູນຂອງທ່ານ.';
$string['dbcreationerror'] = 'ການສ້າງຖານຂໍ້ມູນຜິດພາດ. ບໍ່ສາມາດສ້າງຊື່ຖານຂໍ້ມູນທີ່ມີການຕັ້ງຄ່າທີ່ສະໜອງໃຫ້';
$string['dbhost'] = 'ເຈົ້າພາບເຊີເວີ';
$string['dbpass'] = 'ລະຫັດຜ່ານ';
$string['dbport'] = 'ພອດ';
$string['dbprefix'] = 'ຄໍານໍາຫນ້າຕາຕະລາງ';
$string['dbtype'] = 'ປະເພດ';
$string['directorysettings'] = '<p>ກະລຸນາຢືນຢັນສະຖານທີ່ຂອງການຕິດຕັ້ງ Moodle ນີ້.</p>

<p><b>ທີ່ຢູ່ເວັບ:</b>
ລະບຸທີ່ຢູ່ເວັບເຕັມທີ່ Moodle ຈະຖືກເຂົ້າຫາ.
ຖ້າເວັບໄຊທ໌ຂອງທ່ານສາມາດເຂົ້າເຖິງໄດ້ຜ່ານຫຼາຍ URLs ຫຼັງຈາກນັ້ນເລືອກ
ທີ່ເປັນທໍາມະຊາດທີ່ສຸດທີ່ນັກຮຽນຂອງທ່ານຈະໃຊ້. ບໍ່ລວມ
ເຄື່ອງໝາຍທັບ.</p>

<p><b>ລາຍການ Moodle:</b>
ລະບຸເສັ້ນທາງລາຍການເຕັມໃນການຕິດຕັ້ງນີ້
ກວດໃຫ້ແນ່ໃຈວ່າຕົວພິມໃຫຍ່/ນ້ອຍຖືກຕ້ອງ.</p>

<p><b>ລາຍການຂໍ້ມູນ:</b>
ທ່ານຕ້ອງການບ່ອນທີ່ Moodle ສາມາດບັນທຶກໄຟລ໌ທີ່ອັບໂຫຼດໄດ້. ສິ່ງນີ້
ລາຍການຄວນຈະສາມາດອ່ານໄດ້ ແລະ ຂຽນໄດ້ໂດຍຜູ້ໃຊ້ເວັບເຊີບເວີ
(ປົກກະຕິແລ້ວ \'ບໍ່ມີໃຜ\' ຫຼື \'apache\'), ແຕ່ມັນຕ້ອງບໍ່ສາມາດເຂົ້າເຖິງໄດ້
ໂດຍກົງຜ່ານເວັບ. ຕົວຕິດຕັ້ງຈະພະຍາຍາມສ້າງມັນຖ້າບໍ່ມີ.</p>';
$string['directorysettingshead'] = 'ກະລຸນາຢືນຢັນສະຖານທີ່ຂອງການຕິດຕັ້ງ Moodle ນີ້';
$string['directorysettingssub'] = '<b>ທີ່ຢູ່ເວັບ:</b>
ລະບຸທີ່ຢູ່ເວັບເຕັມທີ່ Moodle ຈະຖືກເຂົ້າຫາ.
ຖ້າເວັບໄຊທ໌ຂອງທ່ານສາມາດເຂົ້າເຖິງໄດ້ຜ່ານຫຼາຍ URLs ຫຼັງຈາກນັ້ນເລືອກ
ທໍາມະຊາດທີ່ສຸດທີ່ນັກຮຽນຂອງທ່ານຈະໃຊ້. ບໍ່ລວມ
ເຄື່ອງໝາຍທັບ.
<br />
<br />
<b>ລາຍການ Moodle:</b>
ລະບຸເສັ້ນທາງລາຍການເຕັມໃນການຕິດຕັ້ງນີ້
ໃຫ້ແນ່ໃຈວ່າຕົວພິມໃຫຍ່/ນ້ອຍຖືກຕ້ອງ.
<br />
<br />
<b>ລາຍການຂໍ້ມູນ:</b>
ທ່ານຕ້ອງການບ່ອນທີ່ Moodle ສາມາດບັນທຶກໄຟລ໌ທີ່ອັບໂຫຼດໄດ້. ສິ່ງນີ້
ລາຍການຕ້ອງສາມາດອ່ານໄດ້ ແລະ ຂຽນໄດ້ໂດຍຜູ້ໃຊ້ເວັບເຊີບເວີ
(ປົກກະຕິແລ້ວ \'ບໍ່ມີໃຜ\' ຫຼື \'apache\'), ແຕ່ມັນຕ້ອງບໍ່ສາມາດເຂົ້າເຖິງໄດ້
ໂດຍກົງຜ່ານເວັບ. ຕົວຕິດຕັ້ງຈະພະຍາຍາມສ້າງມັນຖ້າບໍ່ມີ.';
$string['dirroot'] = 'ລາຍການ Moodle';
$string['dirrooterror'] = 'ການຕັ້ງຄ່າ \'Moodle directory\' ເບິ່ງຄືວ່າ ບໍ່ຖືກຕ້ອງ - ພວກເຮົາບໍ່ສາມາດຊອກຫາການຕິດຕັ້ງ Moodle ຢູ່ທີ່ນັ້ນ. ຄ່າລຸ່ມນີ້ຖືກຕັ້ງໃໝ່ແລ້ວ.';
$string['download'] = 'ດາວໂຫຼດ';
$string['downloadlanguagebutton'] = 'ດາວໂຫຼດ &quot;{$a}&quot; ຊຸດພາສາ';
$string['downloadlanguagehead'] = 'ດາວໂຫຼດຊຸດພາສາ';
$string['downloadlanguagenotneeded'] = 'ທ່ານອາດຈະສືບຕໍ່ຂະບວນການຕິດຕັ້ງໂດຍໃຊ້ຊຸດພາສາເລີ່ມຕົ້ນ, "{$a}".';
$string['downloadlanguagesub'] = 'ຕອນນີ້ທ່ານມີທາງເລືອກໃນການດາວໂຫຼດຊຸດພາສາ ແລະ ສືບຕໍ່ຂະບວນການຕິດຕັ້ງໃນພາສານີ້.<br /><br />ຖ້າທ່ານບໍ່ສາມາດດາວໂຫຼດຊຸດພາສາໄດ້, ຂະບວນການຕິດຕັ້ງຈະສືບຕໍ່ເປັນພາສາອັງກິດ. (ເມື່ອຂະບວນການຕິດຕັ້ງສໍາເລັດ, ທ່ານຈະມີໂອກາດທີ່ຈະດາວໂຫຼດ ແລະ ຕິດຕັ້ງຊຸດພາສາເພີ່ມເຕີມ.)';
$string['doyouagree'] = 'ທ່ານເຫັນດີບໍ ? (ເຫັນດີ/ບໍ່ເຫັນດີ):';
$string['environmenthead'] = 'ກຳລັງກວດສອບສະພາບແວດລ້ອມຂອງທ່ານ ...';
$string['environmentsub'] = 'ພວກເຮົາກຳລັງກວດສອບວ່າ ອົງປະກອບຕ່າງໆຂອງລະບົບຂອງທ່ານຕອບສະໜອງໄດ້ຕາມຄວາມຕ້ອງການຂອງລະບົບຫຼືບໍ່';
$string['environmentsub2'] = 'ແຕ່ລະລຸ້ນ Moodle ມີຄວາມຕ້ອງການສະບັບ PHP ຕ່ຳສຸດທີ່ ແລະ ຈໍານວນການຂະຫຍາຍ PHP ບັງຄັບ.
ການກວດສອບສະພາບແວດລ້ອມຢ່າງເຕັມທີ່ ແມ່ນເຮັດກ່ອນທີ່ຈະຕິດຕັ້ງ ແລະ ຍົກລະດັບແຕ່ລະຄົນ. ກະລຸນາຕິດຕໍ່ຫາຜູ້ບໍລິຫານເຄື່ອງແມ່ຂ່າຍ ຖ້າຫາກວ່າທ່ານບໍ່ຮູ້ວິທີການຕິດຕັ້ງສະບັບໃໝ່ ຫຼື ເປີດໃຊ້ຂະຫຍາຍ PHP ໄດ້.';
$string['errorsinenvironment'] = 'ກວດສອບສິ່ງແວດລ້ອມບໍ່ສໍາເລັດ!';
$string['fail'] = 'ບໍ່ສຳເລັດ';
$string['fileuploads'] = 'ອັບໂຫຼດໄຟລ໌';
$string['fileuploadserror'] = 'ສິ່ງນີ້ຄວນເປັນໃນ';
$string['fileuploadshelp'] = '<p>ການອັບໂຫຼດໄຟລ໌ເບິ່ງຄືວ່າຖືກປິດຢູ່ໃນເຊີບເວີຂອງທ່ານ.</p>

<p>Moodle ຍັງສາມາດຕິດຕັ້ງໄດ້, ແຕ່ຖ້າບໍ່ມີຄວາມສາມາດນີ້, ທ່ານຈະບໍ່ສາມາດໄດ້
    ເພື່ອອັບໂຫຼດໄຟລ໌ຫຼັກສູດ ຫຼື ຮູບໂປຼໄຟລ໌ຜູ້ໃຊ້ໃໝ່.</p>

<p>ເພື່ອເປີດໃຊ້ການອັບໂຫຼດໄຟລ໌ທ່ານ (ຫຼື ຜູ້ເບິ່ງແຍງລະບົບຂອງທ່ານ) ຈະຕ້ອງ
    ແກ້ໄຂໄຟລ໌ php.ini ຕົ້ນຕໍໃນລະບົບຂອງທ່ານ ແລະ ປ່ຽນການຕັ້ງຄ່າສໍາລັບ
    <b>file_uploads</b> ຫາ \'1\'.</p>';
$string['inputdatadirectory'] = 'ລາຍການຂໍ້ມູນ';
$string['inputwebadress'] = 'ທີ່ຢູ່ອີເມລ :';
$string['inputwebdirectory'] = 'ລາຍການ Moodle:';
$string['installation'] = 'ການຕິດຕັ້ງ';
$string['invaliddbprefix'] = 'ຄຳນຳໜ້າບໍ່ຖືກຕ້ອງ. ຄຳນຳໜ້າສາມາດປະກອບດ້ວຍຕົວພິມນ້ອຍ ແລະ ຂີດກ້ອງເທົ່ານັ້ນ.';
$string['langdownloaderror'] = 'ຂໍອະໄພ, ບໍ່ສາມາດດາວໂຫຼດພາສາ "{$a}" ໄດ້. ຂະບວນການຕິດຕັ້ງຈະສືບຕໍ່ເປັນພາສາອັງກິດ.';
$string['langdownloadok'] = 'ພາສາ "{$a}" ຖືກຕິດຕັ້ງສຳເລັດແລ້ວ. ຂະບວນການຕິດຕັ້ງຈະສືບຕໍ່ໃນພາສານີ້.';
$string['memorylimit'] = 'ການຈຳກັດຄວາມຈຳ';
$string['memorylimiterror'] = 'ການຈຳກັດຄວາມຈຳ PHP ໄດ້ຖືກຕັ້ງຂ້ອນຂ້າງຕ່ຳ ... ທ່ານອາດຈະພົບບັນຫາໃນພາຍຫຼັງ.';
$string['mysqliextensionisnotpresentinphp'] = 'PHP ບໍ່ໄດ້ຖືກຕັ້ງຄ່າຢ່າງຖືກຕ້ອງກັບສ່ວນຂະຫຍາຍ MySQLi ສໍາລັບມັນເພື່ອຕິດຕໍ່ສື່ສານກັບ MySQL. ກະລຸນາກວດເບິ່ງໄຟລ໌ php.ini ຂອງທ່ານ ຫຼື ລວບລວມ PHP ຄືນໃໝ່.';
$string['nativeauroramysql'] = 'Aurora MySQL (ພື້ນຖານ/auroramysql)';
$string['nativeauroramysqlhelp'] = '<p>ຖານຂໍ້ມູນແມ່ນບ່ອນທີ່ຕັ້ງຄ່າ ແລະ ຂໍ້ມູນສ່ວນໃຫຍ່ຂອງ Moodle ຖືກເກັບໄວ້ ແລະ ຕ້ອງໄດ້ຮັບການຕັ້ງຄ່າຢູ່ທີ່ນີ້.</p>
<p>ຊື່ຖານຂໍ້ມູນ, ຊື່ຜູ້ໃຊ້ ແລະ ລະຫັດຜ່ານແມ່ນຕ້ອງໃສ່ຊ່ອງຂໍ້ມູນ; ຄຳນຳໜ້າຕາຕະລາງແມ່ນເປັນທາງເລືອກ.</p>
<p>ຊື່ຖານຂໍ້ມູນອາດມີແຕ່ຕົວອັກສອນ ແລະ ຕົວເລກ, ໂດລາ ($) ແລະ ຂີດກ້ອງ (_).</p>
<p>ຖ້າບໍ່ມີຖານຂໍ້ມູນໃນປັດຈຸບັນ ແລະ ຜູ້ໃຊ້ທີ່ທ່ານລະບຸວ່າມີການອະນຸຍາດ, Moodle ຈະພະຍາຍາມທີ່ຈະສ້າງຖານຂໍ້ມູນໃໝ່ທີ່ມີການອະນຸຍາດ ແລະ ການຕັ້ງຄ່າທີ່ຖືກຕ້ອງ.</p>
<p>ໄດເວີນີ້ບໍ່ເຂົ້າກັນໄດ້ກັບເຄື່ອງຈັກ MyISAM ແບບເກົ່າ.</p>';
$string['nativemariadb'] = 'MariaDB (ພື້ນຖານ/mariadb)';
$string['nativemariadbhelp'] = '<p>ຖານຂໍ້ມູນແມ່ນບ່ອນທີ່ຕັ້ງຄ່າ ແລະ ຂໍ້ມູນສ່ວນໃຫຍ່ຂອງ Moodle ຖືກເກັບໄວ້ ແລະ ຕ້ອງໄດ້ຮັບການຕັ້ງຄ່າຢູ່ທີ່ນີ້.</p>
<p>ຊື່ຖານຂໍ້ມູນ, ຊື່ຜູ້ໃຊ້ ແລະ ລະຫັດຜ່ານແມ່ນຕ້ອງໃສ່ຊ່ອງຂໍ້ມູນ; ຄຳນຳໜ້າຕາຕະລາງແມ່ນເປັນທາງເລືອກ.</p>
<p>ຊື່ຖານຂໍ້ມູນອາດມີແຕ່ຕົວອັກສອນອັກສອນ ແລະ ຕົວເລກ, ໂດລາ ($) ແລະ ຂີດກ້ອງ (_).</p>
<p>ຖ້າບໍ່ມີຖານຂໍ້ມູນໃນປັດຈຸບັນ ແລະ ຜູ້ໃຊ້ທີ່ທ່ານລະບຸວ່າ ມີການອະນຸຍາດ Moodle ຈະພະຍາຍາມທີ່ຈະສ້າງຖານຂໍ້ມູນໃຫມ່ທີ່ມີການອະນຸຍາດ ແລະ ການຕັ້ງຄ່າທີ່ຖືກຕ້ອງ.</p>
<p>ໄດເວີນີ້ບໍ່ເຂົ້າກັນໄດ້ກັບເຄື່ອງຈັກ MyISAM ແບບເກົ່າ.</p>';
$string['nativemysqli'] = 'Improved MySQL (ພື້ນຖານ/mysqli)';
$string['nativemysqlihelp'] = '<p>ຖານຂໍ້ມູນແມ່ນບ່ອນທີ່ຕັ້ງຄ່າ ແລະ ຂໍ້ມູນສ່ວນໃຫຍ່ຂອງ Moodle ຖືກເກັບໄວ້ ແລະ ຕ້ອງໄດ້ຮັບການຕັ້ງຄ່າຢູ່ທີ່ນີ້.</p>
<p>ຊື່ຖານຂໍ້ມູນ, ຊື່ຜູ້ໃຊ້ ແລະ ລະຫັດຜ່ານແມ່ນຕ້ອງໃສ່ຊ່ອງຂໍ້ມູນ; ຄຳນຳໜ້າຕາຕະລາງແມ່ນເປັນທາງເລືອກ.</p>
<p>ຊື່ຖານຂໍ້ມູນອາດມີແຕ່ຕົວອັກສອນອັກສອນ ແລະ ຕົວເລກ, ໂດລາ ($) ແລະ ຂີດກ້ອງ (_).</p>
<p>ຖ້າບໍ່ມີຖານຂໍ້ມູນໃນປັດຈຸບັນ ແລະ ຜູ້ໃຊ້ທີ່ທ່ານລະບຸວ່າ ມີການອະນຸຍາດ, Moodle ຈະພະຍາຍາມທີ່ຈະສ້າງຖານຂໍ້ມູນໃໝ່ທີ່ມີການອະນຸຍາດ ແລະ ການຕັ້ງຄ່າທີ່ຖືກຕ້ອງ.</p>';
$string['nativepgsql'] = 'PostgreSQL (ພື້ນຖານ/pgsql)';
$string['nativepgsqlhelp'] = '<p>ຖານຂໍ້ມູນແມ່ນບ່ອນທີ່ຕັ້ງຄ່າ ແລະ ຂໍ້ມູນສ່ວນໃຫຍ່ຂອງ Moodle ຖືກເກັບໄວ້ ແລະ ຕ້ອງໄດ້ຮັບການຕັ້ງຄ່າຢູ່ທີ່ນີ້.</p>
<p>ຊື່ຖານຂໍ້ມູນ, ຊື່ຜູ້ໃຊ້, ລະຫັດຜ່ານ ແລະ ຄຳນຳໜ້າຕາຕະລາງແມ່ນຕ້ອງມີຊ່ອງໃສ່ຕື່ມ.</p>
<p>ຖານຂໍ້ມູນຕ້ອງມີຢູ່ແລ້ວ ແລະ ຜູ້ໃຊ້ຕ້ອງມີການເຂົ້າເຖິງທັງອ່ານ ແລະ ຂຽນໃສ່ມັນ.</p>';
$string['nativesqlsrv'] = 'SQL*Server Microsoft (ພື້ນຖານ/sqlsrv)';
$string['nativesqlsrvhelp'] = 'ຕອນນີ້ທ່ານຕ້ອງການຕັ້ງຄ່າຖານຂໍ້ມູນທີ່ຂໍ້ມູນ Moodle ສ່ວນໃຫຍ່ຈະຖືກເກັບໄວ້.
ຖານຂໍ້ມູນນີ້ຕ້ອງໄດ້ຮັບການສ້າງແລ້ວ ແລະ ຊື່ຜູ້ໃຊ້ ແລະ ລະຫັດຜ່ານທີ່ສ້າງຂຶ້ນເພື່ອເຂົ້າເຖິງມັນ. ຄໍານໍາໜ້າຕາຕະລາງແມ່ນບັງຄັບ.';
$string['nativesqlsrvnodriver'] = 'Microsoft Drivers ສໍາລັບ SQL Server ສໍາລັບ PHP ບໍ່ໄດ້ຖືກຕິດຕັ້ງ ຫຼື ບໍ່ຖືກຕັ້ງຄ່າຢ່າງຖືກຕ້ອງ.';
$string['pass'] = 'ຜ່ານ';
$string['paths'] = 'ເສັ້ນທາງ';
$string['pathserrcreatedataroot'] = 'ລາຍການຂໍ້ມູນ ({$a->dataroot}) ບໍ່ສາມາດສ້າງໄດ້ໂດຍຕົວຕິດຕັ້ງ.';
$string['pathshead'] = 'ຢືນຢັນເສັ້ນທາງ';
$string['pathsrodataroot'] = 'ລາຍການ Dataroot ບໍ່ສາມາດຂຽນໄດ້.';
$string['pathsroparentdataroot'] = 'ລາຍຊື່ພໍ່ແມ່ ({$a->parent}) ບໍ່ສາມາດຂຽນໄດ້. ລາຍການຂໍ້ມູນ ({$a->dataroot}) ບໍ່ສາມາດສ້າງໄດ້ໂດຍຕົວຕິດຕັ້ງ.';
$string['pathssubadmindir'] = 'webhosts ຈໍານວນໜ້ອຍດຽວໃຊ້ /admin ເປັນ URL ພິເສດສໍາລັບທ່ານທີ່ຈະເຂົ້າເຖິງກະດານຄວບຄຸມ ຫຼື ບາງສິ່ງບາງຢ່າງ. ແຕ່ໜ້າເສຍດາຍ, ນີ້ຂັດກັບສະຖານທີ່ມາດຕະຖານສໍາລັບໜ້າ ຜູ້ເບິ່ງແຍງລະບົບ Moodle. ທ່ານສາມາດແກ້ໄຂສິ່ງນີ້ໂດຍການປ່ຽນຊື່ຜູ້ເບິ່ງແຍງລະບົບໃນການຕິດຕັ້ງຂອງທ່ານ ແລະ ໃສ່ຊື່ໃໝ່ນີ້ຢູ່ທີ່ນີ້. ຕົວຢ່າງ: <em>moodleadmin</em>. ສິ່ງນີ້ຈະແກ້ໄຂການເຊື່ອມຕໍ່ຜູ້ເບິ່ງແຍງລະບົບໃນ Moodle.';
$string['pathssubdataroot'] = '<p>ລາຍການທີ່ Moodle ຈະເກັບຮັກສາເນື້ອຫາໄຟລ໌ທັງໝົດທີ່ອັບໂຫຼດໂດຍຜູ້ໃຊ້.</p>
<p>ລາຍການນີ້ຄວນຈະເປັນທັງສາມາດອ່ານໄດ້ ແລະ ຂຽນໄດ້ໂດຍຜູ້ໃຊ້ເວັບເຊີບເວີ (ໂດຍປົກກະຕິແລ້ວ \'www-data\', \'nobody\', ຫຼື \'apache\').</p>
<p>ມັນຕ້ອງບໍ່ສາມາດເຂົ້າເຖິງໄດ້ໂດຍກົງຜ່ານເວັບ.</p>
<p>ຖ້າບໍ່ມີບັນຊີລາຍຊື່ໃນປັດຈຸບັນ, ຂະບວນການຕິດຕັ້ງຈະພະຍາຍາມສ້າງມັນ.</p>';
$string['pathssubdirroot'] = '<p>ເສັ້ນທາງເຕັມໄປຫາລາຍການທີ່ມີລະຫັດ Moodle.</p>';
$string['pathssubwwwroot'] = '<p>ທີ່ຢູ່ເຕັມທີ່ Moodle ຈະຖືກເຂົ້າຫາເຊັ່ນ: ທີ່ຢູ່ທີ່ຜູ້ໃຊ້ຈະເຂົ້າໄປໃນແຖບທີ່ຢູ່ຂອງຕົວທ່ອງເວັບຂອງເຂົາເຈົ້າເພື່ອເຂົ້າເຖິງ Moodle.</p>
<p>ມັນບໍ່ສາມາດເຂົ້າເຖິງ Moodle ໂດຍໃຊ້ຫຼາຍທີ່ຢູ່. ຖ້າເວັບໄຊທ໌ຂອງທ່ານສາມາດເຂົ້າເຖິງໄດ້ຜ່ານຫຼາຍທີ່ຢູ່ ຈາກນັ້ນເລືອກອັນທີ່ງ່າຍທີ່ສຸດ ແລະ ຕັ້ງການປ່ຽນເສັ້ນທາງຖາວອນສຳລັບແຕ່ລະທີ່ຢູ່ອື່ນ.</p>
<p>ຖ້າເວັບໄຊຂອງທ່ານສາມາດເຂົ້າເຖິງໄດ້ທັງຈາກອິນເຕີເນັດ ແລະ ຈາກເຄືອຂ່າຍພາຍໃນ (ບາງຄັ້ງເອີ້ນວ່າ ອິນທຣາເນັດ), ຫຼັງຈາກນັ້ນໃຫ້ໃຊ້ທີ່ຢູ່ສາທາລະນະທີ່ນີ້.</p>
<p>ຖ້າທີ່ຢູ່ປັດຈຸບັນບໍ່ຖືກຕ້ອງ, ກະລຸນາປ່ຽນ URL ໃນແຖບທີ່ຢູ່ຂອງບຣາວເຊີຂອງທ່ານ ແລະ ເລີ່ມການຕິດຕັ້ງຄືນໃໝ່.</p>';
$string['pathsunsecuredataroot'] = 'ສະຖານທີ່ຕັ້ງ Dataroot ແມ່ນບໍ່ປອດໄພ';
$string['pathswrongadmindir'] = 'ລາຍການບໍລິຫານບໍ່ມີຢູ່';
$string['pgsqlextensionisnotpresentinphp'] = 'PHP ບໍ່ໄດ້ຖືກຕັ້ງຄ່າຢ່າງຖືກຕ້ອງກັບສ່ວນຂະຫຍາຍ PGSQL ເພື່ອໃຫ້ມັນສາມາດສື່ສານກັບ PostgreSQL. ກະລຸນາກວດເບິ່ງໄຟລ໌ php.ini ຂອງທ່ານ ຫຼື ລວບລວມ PHP ຄືນໃໝ່.';
$string['phpextension'] = 'ສ່ວນຂະຫຍາຍ PHP {$a}';
$string['phpversion'] = 'ສະບັບ PHP';
$string['releasenoteslink'] = 'ສຳລັບຂໍ້ມູນກ່ຽວກັບສະບັບ Moodle, ກະລຸນາເບິ່ງບັນທຶກປົດປ່ອຍທີ່ {$a}';
$string['safemode'] = 'ໂໝດທີ່ປອດໄພ';
$string['safemodeerror'] = 'Moodle ມີບັນຫາກັບໂໝດຄວາມປອດໄພທີ່ເປີດ';
$string['safemodehelp'] = '<p>Moodle ອາດຈະມີຫຼາຍບັນຫາກ່ຽວກັບການເປີດໂໝດຄວາມປອດໄພ, ບໍ່ແມ່ນຢ່າງຫນ້ອຍແມ່ນວ່າ
    ມັນອາດຈະບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ສ້າງໄຟລ໌ໃຫມ່.</p>

<p>ປົກກະຕິແລ້ວ ໂໝດປອດໄພແມ່ນເປີດໃຊ້ໂດຍເຈົ້າພາບເວັບສາທາລະນະທີ່ວິຕົກກັງວົນເທົ່ານັ້ນ, ດັ່ງນັ້ນທ່ານອາດຈະມີ
    ພຽງແຕ່ຊອກຫາບໍລິສັດເວັບໂຮດຕິ້ງໃຫມ່ສໍາລັບເວັບໄຊທ໌ Moodle ຂອງທ່ານ.</p>

<p>ທ່ານສາມາດພະຍາຍາມສືບຕໍ່ການຕິດຕັ້ງ ຖ້າຫາກວ່າທ່ານຕ້ອງການ, ແຕ່ຄາດວ່າຈະມີບັນຫາບາງຢ່າງໃນພາຍຫຼັງ.</p>';
$string['sessionautostart'] = 'ເລີ່ມຕົ້ນຊ່ວງເວລາອັດຕະໂນມັດ';
$string['sessionautostarterror'] = 'ສິ່ງນີ້ຄວນຖືກປິດ';
$string['sessionautostarthelp'] = '<p>Moodle ຕ້ອງການການຮອງຮັບຊ່ວງເວລາ ແລະ ຈະບໍ່ເຮັດວຽກໂດຍບໍ່ມີມັນ.</p>

<p>ຊ່ວງເວລາ ສາມາດເປີດໃຊ້ໄດ້ໃນໄຟລ໌ php.ini ... ຊອກຫາຕົວກຳນົດ session.auto_start.</p>';
$string['sqliteextensionisnotpresentinphp'] = 'PHP ບໍ່ໄດ້ຖືກຕັ້ງຄ່າຢ່າງຖືກຕ້ອງກັບສ່ວນຂະຫຍາຍ SQLite. ກະລຸນາກວດເບິ່ງໄຟລ໌ php.ini ຂອງທ່ານ ຫຼື ລວບລວມ PHP ຄືນໃໝ່.';
$string['upgradingqtypeplugin'] = 'ກຳລັງຍົກລະດັບປລັກອິນຄຳຖາມ/ປະເພດ';
$string['welcomep10'] = '{$a->installername} ({$a->installerversion})';
$string['welcomep20'] = 'ທ່ານກໍາລັງເຫັນໜ້ານີ້ ເພາະວ່າທ່ານໄດ້ຕິດຕັ້ງປະສົບຜົນສໍາເລັດ ແລະ
     ເປີດຕົວແພັກເກັດ <strong>{$a->packname} {$a->packversion}</strong> ໃນຄອມພິວເຕີຂອງທ່ານ. ຊົມເຊີຍ!';
$string['welcomep30'] = 'ສິ່ງນີ້ໄດ້ປົດປ່ອຍ <strong>{$a->installername}</strong> ລວມມີໄປຼແກຼມ
    ເພື່ອສ້າງສະພາບແວດລ້ອມທີ່ <strong>Moodle</strong> ຈະດຳເນີນ, ຄື:';
$string['welcomep40'] = 'ແພັກເກດຍັງລວມມີ <strong>Moodle {$a->moodlerelease} ({$a->moodleversion})</strong>.';
$string['welcomep50'] = 'ການນໍາໃຊ້ຄໍາຮ້ອງສະໝັກທັງໝົດໃນແພັດເກດນີ້ ແມ່ນຖືກຄຸ້ມຄອງໂດຍໃບອະນຸຍາດຂອງພວກເຂົາ. ແພັກເກດ <strong>{$a->installername}</strong> ທີ່ສົມບູນແມ່ນ <a href="https://www.opensource.org/docs/definition_plain.html">ແຫຼ່ງຂໍ້ມູນເປີດ</a> ແລະ ຖືກແຈກຢາຍພາຍໃຕ້ ໃບອະນຸຍາດ <a href="https://www.gnu.org/copyleft/gpl.html">GPL</a>.';
$string['welcomep60'] = 'ຫນ້າຕໍ່ໄປນີ້ຈະນໍາທ່ານຜ່ານບາງຂັ້ນຕອນທີ່ງ່າຍຕໍ່ການປະຕິບັດຕາມ
     ກຳນົດຄ່າ ແລະ ຕັ້ງຄ່າ <strong>Moodle</strong> ໃນຄອມພິວເຕີຂອງທ່ານ. ທ່ານອາດຈະຍອມຮັບຄ່າເລີ່ມຕົ້ນ
     ການຕັ້ງຄ່າ ຫຼື ທາງເລືອກ, ປັບປຸງໃຫ້ເຂົາເຈົ້າເໝາະສົມກັບຄວາມຕ້ອງການຂອງທ່ານເອງ.';
$string['welcomep70'] = 'ຄລິກທີ່ປຸ່ມ "ຕໍ່ໄປ" ດ້ານລຸ່ມ ເພື່ອສືບຕໍ່ການຕັ້ງຄ່າ <strong>Moodle</strong>.';
$string['wwwroot'] = 'ທີ່ຢູ່ເວັບ';
$string['wwwrooterror'] = '\'ທີ່ຢູ່ເວັບ\' ເບິ່ງຄືວ່າບໍ່ຖືກຕ້ອງ - ການຕິດຕັ້ງ Moodle ນີ້ບໍ່ປາກົດຢູ່ທີ່ນັ້ນ. ຄ່າລຸ່ມນີ້ຖືກຕັ້ງໃໝ່ແລ້ວ.';
