<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'report_security', language 'no', version '5.1'.
 *
 * @package     report_security
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['check_antivirus_details'] = 'Denne statusen kontrollerer om det har vært en nylig oppdaget feil basert på terskelen satt i hovedantivirusinnstillingene.';
$string['check_antivirus_error'] = '{$a->errors} feil har blitt oppdaget i løpet av siste {$a->lookback}';
$string['check_antivirus_info'] = 'Ingen antivirus skannere er aktivert for øyeblikket';
$string['check_antivirus_logstore_not_supported'] = 'Kan ikke bekrefte tilstanden til antivirusskannere på grunn av typen logglagringsom er valgt';
$string['check_antivirus_name'] = 'Antivirus';
$string['check_antivirus_ok'] = '{$a->scanners} antivirusskanner(e) aktivert, ingen problemer har blitt oppdaget i siste {$a->lookback}';
$string['check_configrw_details'] = '<p>Det anbefales at fil-rettighetene til config.php endres etter installasjonen slik at webserveren ikke kan gjøre endringer. Vennligst merk at denne sjekken ikke forbedrer serverens generelle sikkerhet, selv om den forsinker og eventuelt begrenser generelle sikkerhetshull.</p>';
$string['check_configrw_name'] = 'config.php er skrivbar';
$string['check_configrw_ok'] = 'config.php er sikret mot endringer via PHP script.';
$string['check_configrw_warning'] = 'PHP script kan endre config.php.';
$string['check_cookiesecure_details'] = '<p>Dersom https er aktivert anbefales det at sikre cookier også aktiveres. Du bør også legge til en permanent omadressering til https. Ideelt bør dette også støtte HSTS headere.</p>';
$string['check_cookiesecure_error'] = 'Vennligst aktiver sikre cookier';
$string['check_cookiesecure_http'] = 'Du på aktivere https for å bruke sikre cookies';
$string['check_cookiesecure_name'] = 'Sikre cookier';
$string['check_cookiesecure_ok'] = 'Sikre cookier er aktivert';
$string['check_crawlers_details'] = '<p>Åpen for Google-innstillingen lar søkemotorer indeksere kurs med gjestetilgang. Det er ikke noe poeng å aktivere denne innstillingen dersom gjestetilgang er avslått.';
$string['check_crawlers_error'] = 'Det er åpnet for tilgang for søkemotorer, men gjestetilgangen er deaktivert.';
$string['check_crawlers_info'] = 'Søkemotorer kan indeksere kurs med gjestetilgang.';
$string['check_crawlers_name'] = 'Åpen for Google';
$string['check_crawlers_ok'] = 'Tilgang for søkemotorer er deaktivert.';
$string['check_defaultuserrole_details'] = '<p>Alle påloggede brukere får funksjoner som standard brukerrolle. Sørg for at ingen risikofylte funksjoner er tillatt i denne rollen.</p>
<p>Den eneste støttede eldre typen for standardbrukerrollen er <em>Autentisert bruker</em>. Mulighet for kursvisning må ikke være aktivert.</p>
<p>Vennligst sjekk om alternativet for automatisk forespørsel om sletting av data er aktivert. Brukere kan be om slettinger som kan slette store mengder data.</p>';
$string['check_defaultuserrole_error'] = 'Standardrollen "{$a}" er ikke korrekt satt opp!';
$string['check_defaultuserrole_name'] = 'Registrert brukerrolle';
$string['check_defaultuserrole_notset'] = 'Standard rolle er ikke satt.';
$string['check_defaultuserrole_ok'] = 'Angitte innstillinger for rolledefinisjoner er OK.';
$string['check_dirindex_info'] = 'Katalogindeks bør ikke være aktivert';
$string['check_displayerrors_details'] = '<p>Aktivering av  PHP innstillingen <code>display_errors</code> anbefales ikke da feilmeldinger kan inneholde sensitiv informasjon om serveren.</p>';
$string['check_displayerrors_error'] = 'PHP-innstillingen for feilvisning er aktivert. Vi anbefaler at du slår den av.';
$string['check_displayerrors_name'] = 'Visning av PHP-feil';
$string['check_displayerrors_ok'] = 'Visning av PHP-feil er deaktivert.';
$string['check_dotfiles_info'] = 'Alle dotfiles unntatt /.well-known/* skal ikke være offentlige';
$string['check_emailchangeconfirmation_details'] = '<p>Det anbefales at e-postbekreftelse kreves når brukeren endrer e-postadressen i profilen. Hvis den er deaktivert kan spammere misbruke kontoen til å sende søppelpost.>/p>';
$string['check_emailchangeconfirmation_error'] = 'Brukere kan skrive inn hvilken som helst e-Brukere kan skrive inn valgfri e-postadresse.';
$string['check_emailchangeconfirmation_info'] = 'Angir at brukere kun kan bruke e-postadresser fra godkjente domener.';
$string['check_emailchangeconfirmation_name'] = 'Bekreft endring av e-postadresse';
$string['check_emailchangeconfirmation_ok'] = 'Bekreft endring av e-postadressen i brukerprofilen.';
$string['check_embed_details'] = '<p>Ubegrenset OBJECT og EMBED i tekst er meget risikofylt. Alle registrerte brukere kan dermed starte et XSS-angrep mot andre brukere. Denne innstillingen bør abolutt være deaktivert på produksjonsservere.';
$string['check_embed_error'] = 'Ubegrenset OBJECT og EMBED er aktivert - dette er MEGET risikofylt på da aller fleste servere.';
$string['check_embed_name'] = 'Tillat EMBED og OBJECT';
$string['check_embed_ok'] = 'Ubegrenset OBJECT og EMBED er ikke tillatt.';
$string['check_frontpagerole_details'] = '<p>Standard hovedsiderolle gis ut til alle registrerte brukere for aktiviteter på hovedsiden. Vennligst sjekk at du ikke har noen risikofylte rettigheter på denne rollen.</p><p>Det anbefales at du ved behov oppretter en arvet rolle i stedet for å endre Moodles standardroller.</p>';
$string['check_frontpagerole_error'] = 'Ukorrekt definert forsiderolle "{$a}" oppdaget!';
$string['check_frontpagerole_name'] = 'Forsiderolle';
$string['check_frontpagerole_notset'] = 'Forsiderolle er ikke angitt.';
$string['check_frontpagerole_ok'] = 'Forsidens rolleinnstillinger er OK.';
$string['check_guestrole_details'] = '<p>Gjesterollen er for gjester, ikke innloggede brukere og tilfeldig gjestetilgang. Vennligst sjekk at det ikke er gitt risikable rettigheter til denne rollen.</p>
<p>Eneste støttede arvede type for gjesterollen er <em>Gjest</em>.</p>';
$string['check_guestrole_error'] = 'Gjesterollen "{$a}" er ikke satt opp riktig!';
$string['check_guestrole_name'] = 'Rollen Gjest';
$string['check_guestrole_notset'] = 'Rollen Gjest er ikke satt';
$string['check_guestrole_ok'] = 'Rollen Gjest er OK satt opp.';
$string['check_nodemodules_details'] = '<p>Mappen <em>{$a->path}</em> inneholder Node.js-moduler og deres avhengigheter, typisk installert via NPM-verktøyet. Disse modulene kan være nødvendige for lokal Moodle-utvikling, som når en f.eks. benytter Grunt-rammeverket. De er IKKE nødvendige for kjøre koden på en Moodle-portal i produksjon og kan inneholde potensielt skadelig kode som åpner portalen for angrep utenfra.</p><p>Det anbefales sterkt at mappen fjernes hvis portalen er tilgjengelig via en offentlig adresse, eller i det minste sperrer for webtilgang til mappen.</p>';
$string['check_nodemodules_info'] = 'Mappen node_modules skal ikke publiseres på produksjonsportaler.';
$string['check_nodemodules_name'] = 'Mappe for Node.js-moduler';
$string['check_openprofiles_details'] = 'Åpne brukerprofiler kan angripes av spammere. Vi anbefaler at enten <code>Tving brukere til å logge inn for å se profiler</code> eller <code>Tving brukere til å logge inn</code> er aktivert.';
$string['check_openprofiles_error'] = 'Enhver kan se brukerprofiler uten innlogging.';
$string['check_openprofiles_name'] = 'Åpne brukerprofiler';
$string['check_openprofiles_ok'] = 'Innlogging kreves før en kan se brukerprofiler.';
$string['check_passwordpolicy_details'] = '<p>Det anbefales at det settes passordregler, siden det er svært vanlig å gjette seg fram til vanlige passord. Ikke gjør kravene for strenge, da dette kan resultere i at brukerne stadig glemmer passordet og til slutt skriver det ned.</p>';
$string['check_passwordpolicy_error'] = 'Passordregler er ikke aktivert';
$string['check_passwordpolicy_name'] = 'Passordregler';
$string['check_passwordpolicy_ok'] = 'Passordregler er aktivert';
$string['check_preventexecpath_details'] = '<p> Å tillate kjørbare stier å angis via Admin GUI er en vektor for  eskalering av privelegier. Dette må forsterkes via config.php:</p><p><code>$CFG->preventexecpath = true;<code> </ p>';
$string['check_preventexecpath_name'] = 'Kjørbare stier';
$string['check_preventexecpath_ok'] = 'Kjørbare stier kan bare settes i config.php.';
$string['check_preventexecpath_warning'] = 'Kjørbare stier kan settes in admin-grensesnittet.';
$string['check_publicpaths_403'] = '(Returnerte en 403, ideelt sett burde være 404)';
$string['check_publicpaths_generic'] = '{$a} filer skal ikke være offentlige';
$string['check_publicpaths_name'] = 'Sjekk alle offentlige / private stier';
$string['check_publicpaths_ok'] = 'Ingen interne stier er offentlig tilgjengelige';
$string['check_publicpaths_warning'] = 'Noen interne stier er offentlig tilgjengelige';
$string['check_riskadmin_detailsok'] = '<p>Vennligst bekreft følgede liste over administratorer:</p> {$a}';
$string['check_riskadmin_detailswarning'] = '<p>Vennligst bekreft følgede liste over administratorer:</p>{$a->admins}
<p>Det anbefales at en bare tildeler administratorrettigheter i systemkonteksten. Følgende har admin-rettigheter som ikke støttes:</p>{$a->unsupported}';
$string['check_riskadmin_name'] = 'Administratorer';
$string['check_riskadmin_ok'] = 'Fant {$a} administratorer';
$string['check_riskadmin_unassign'] = '<a href="{$a->url}">{$a->fullname} ({$a->email}) Vis rolletildeling</a>';
$string['check_riskadmin_warning'] = 'Fant  {$a->admincount} administratorer og  {$a->unsupcount} med administratorrettigheter andre steder på systemet.';
$string['check_riskbackup_details_overriddenroles'] = '<p>Disse aktiverte overstyringene gir brukere rett til å inkludere brukerdata i sikkerhetskopier. Du bør sjekke om disse tillatelsene er nødvendige.</p> {$a}';
$string['check_riskbackup_details_systemroles'] = '<p>Følgende systemroller er satt til å tillate brukere å ta med brukerdata i sikkerhetskopier. Du bør sjekke om disse tillatelsene er nødvendige.</p> {$a}';
$string['check_riskbackup_details_users'] = '<p>På grunn av overordnede roller eller lokale overstyringer har følgende brukerkontoer rett til å ta sikkerhetskopier med private data fra alle påmeldte brukere i kurs. Du bør sjekke om du stoler på disse brukerne og at brukerpassord er beskyttet med sterke passord:</p> {$a}';
$string['check_riskbackup_detailsok'] = 'Ingen roller har eksplisitt tillatelse til å ta sikkerhetskopi av brukerdata. Likevel, merk at administratorer med tillatelsen "Gjøre alt" kan utføre dette.';
$string['check_riskbackup_editoverride'] = '<a href="{$a->url}">{$a->name} in {$a->contextname}</a>';
$string['check_riskbackup_editrole'] = '<a href="{$a->url}">{$a->name}</a>';
$string['check_riskbackup_name'] = 'Sikkerhetskopi av brukerdata';
$string['check_riskbackup_ok'] = 'Ingen roller har eksplisitt rett til å ta sikkerhetskopi av brukerdata';
$string['check_riskbackup_unassign'] = '<a href="{$a->url}">{$a->fullname} ({$a->email}) in {$a->contextname}</a>';
$string['check_riskbackup_warning'] = 'Fant {$a->rolecount} roller, {$a->overridecount} overstyringer og {$a->usercount} brukere med rett til å ta sikkerhetskopi av brukerdata.';
$string['check_riskxss_details'] = '<p>RISK_XSS viser deg alle risikable rettigheter bare klarerte brukere kan benytte.</p>
<p>Vennligst bekreft følgende liste av brukere og sikre at disse er klarerte for denne serveren:</p><p>{$a}</p>';
$string['check_riskxss_name'] = 'XSS klarerte brukere';
$string['check_riskxss_warning'] = 'RISK_XSS - fant {$a} brukere som ikke er klarert.';
$string['check_unsecuredataroot_details'] = '<p>Datakatalogen må ikke kunne nås direkte fra web. Beste måten å sikre dette på er å plassere datakatalogen utenfor webområdet på serveren.</p>
<p>Dersom du flytter katalogen, må du oppdatere <code>$CFG->dataroot</code> innstillingen i <code>config.php</code> tilsvarende.</p>';
$string['check_unsecuredataroot_error'] = 'Datakatalogen  <code>{$a}</code> er plassert feil og direkte tilgjengelig via web!';
$string['check_unsecuredataroot_name'] = 'Usikker datakatalog';
$string['check_unsecuredataroot_ok'] = 'Datakatalogen skal IKKE være tilgjengelig direkte via web.';
$string['check_unsecuredataroot_warning'] = 'Datakatalogen  <code>{$a}</code> er plassert feil og kan være tilgjengelig direkte via web.';
$string['check_upgradefile_info'] = 'Filer med oppgraderingsnotater bør ikke være offentlig';
$string['check_vendordir_details'] = '<p> Katalogen <em> {$a-> path} </ em> inneholder ulike tredjepartsbiblioteker og deres avhengigheter, vanligvis installert av PHP Composer. Disse bibliotekene kan være nødvendig for lokal Moodle-utvikling, for eksempel for installering av PHP Unit-rammeverket. De trenger ikke å kjøre i en Moodle-portali produksjon, og de kan inneholde potensielt farlig kode som åpner portalen ditt for eksterne angrep. </p> <p> Det anbefales sterkt å fjerne katalogen hvis nettstedet er tilgjengelig via en offentlig URL, eller i det minste forby webtilgang til det i webserverkonfigurasjonen. </ p>';
$string['check_vendordir_info'] = 'Leverandørmappen bør ikke være tilstede på offentlige portaler.';
$string['check_vendordir_name'] = 'Leverandørmappe';
$string['check_webcron_details'] = '<p>Å kjøre cron fra adressefeltet i nettleseren kan eksponere sensitiv informasjon til anonyme brukere. Det er derfor anbefalt å kun kjøre cron fra kommandolinjen eller sette et passord for fjerntilgang</p>';
$string['check_webcron_name'] = 'Webcron';
$string['check_webcron_ok'] = 'Anonyme brukere har ikke tilgang til cron';
$string['check_webcron_warning'] = 'Anonyme brukere har tilgang til cron';
$string['configuration'] = 'Konfigurasjon';
$string['description'] = 'Beskrivelse';
$string['details'] = 'Detaljer';
$string['eventreportviewed'] = 'Vis sikkerhetssjekkrapporten';
$string['issue'] = 'Problem';
$string['pluginname'] = 'Sikkerhetsoversikt';
$string['privacy:metadata'] = 'Modulen "Sikkerhetsoversikt" lagrer ikke noen persondata.';
$string['security:view'] = 'Vis sikkerhetsrapport';
$string['timewarning'] = 'Databehandlingen kan ta lang tid, vennligst vær tålmodig...';
