<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'h5p', language 'lt', version '5.1'.
 *
 * @package     h5p
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a11yTitle:label'] = 'Pagalbinių technologijų pavadinimas';
$string['acceptTerms'] = 'Sutinku su <a href=":url" target="_blank">naudojimo sąlygomis</a>';
$string['accountDetailsLinkText'] = 'čia';
$string['actions'] = 'Veiksmai';
$string['add'] = 'Pridėti';
$string['addedandupdatedpp'] = 'Įtraukta naujų H5P bibliotekų {$a->%new} ir atnaujinta senų {$a->%old}.';
$string['addedandupdatedps'] = 'Įtraukta naujų H5P bibliotekų {$a->%new} ir atnaujinta sena {$a->%old}.';
$string['addedandupdatedsp'] = 'Įtraukta nauja H5P biblioteka {$a->%new} ir atnaujinta senos {$a->%old}.';
$string['addedandupdatedss'] = 'Įtraukta nauja H5P biblioteka {$a->%new} ir atnaujinta sena {$a->%old}.';
$string['addednewlibraries'] = 'Įtraukta naujų H5P bibliotekų {$a->%new}.';
$string['addednewlibrary'] = 'Pridėta {$a->%new} nauja H5P biblioteka.';
$string['additionallicenseinfo'] = 'Bet kokia papildoma informacija apie licenciją';
$string['address'] = 'Adresas';
$string['age'] = 'Tipinis amžius';
$string['ageDescription'] = 'Šio turinio tikslinė auditorija. Galimi įvesties formatai, atskirti kableliais: "1,34-45,-50,59-".';
$string['altText'] = 'Alternatyvus tekstas';
$string['atto_h5p'] = 'Įterpti H5P mygtuką';
$string['atto_h5p_description'] = 'Mygtukas Įterpti H5P „Atto“ rengyklėje leidžia naudotojams įterpti H5P turinį įvedant URL arba įterpiant kodą arba įkeliant H5P failą.';
$string['author'] = 'Autorius';
$string['authorcomments'] = 'Autoriaus komentarai';
$string['authorcommentsdescription'] = 'Pastabos turinio rengyklei. (Šis tekstas nebus paskelbtas kaip autorių teisių informacijos dalis.)';
$string['authorname'] = 'Autoriaus vardas';
$string['authorrole'] = 'Autoriaus vaidmuo';
$string['back'] = 'Atgal';
$string['by'] = 'iš';
$string['cancelCrop'] = 'Atšaukti apkirpimą';
$string['cancelPublishConfirmationDialogCancelButtonText'] = 'Ne';
$string['cancelPublishConfirmationDialogConfirmButtonText'] = 'Taip';
$string['cancelPublishConfirmationDialogDescription'] = 'Ar tikrai norite atšaukti bendrinimo procesą?';
$string['cancelPublishConfirmationDialogTitle'] = 'Atšaukti bendrinimą';
$string['cancellabel'] = 'Atšaukti';
$string['ccattribution'] = 'Priskyrimas (CC BY)';
$string['ccattributionnc'] = 'Priskyrimas - Nekomercinis naudojimas (CC BY-NC)';
$string['ccattributionncnd'] = 'Priskyrimas - Nekomercinis naudojimas - Jokių išvestinių kūrinių (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Priskyrimas - Nekomercinis naudojimas - Analogiškas platinimas (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Priskyrimas - Jokių išvestinių kūrinių (CC BY-ND)';
$string['ccattributionsa'] = 'Priskyrimas - Analogiškas platinimas (CC BY-SA)';
$string['ccpdd'] = 'Priskyrimas Viešajai sričiai (CC0)';
$string['changeHasBeenSubmitted'] = 'Buvo pateiktas pakeitimas';
$string['changedby'] = 'Pakeista';
$string['changedescription'] = 'Pokyčio aprašymas';
$string['changelog'] = 'Pakeitimų žurnalas';
$string['changeplaceholder'] = 'Nuotrauka apkarpyta, tekstas pakeistas ir kt.';
$string['city'] = 'Miestas';
$string['close'] = 'Uždaryti';
$string['confirmCrop'] = 'Patvirtinti apkirpimą';
$string['confirmdialogbody'] = 'Patvirtinkite, kad norite tęsti. Šio veiksmo negalima anuliuoti.';
$string['confirmdialogheader'] = 'Patvirtinti veiksmą';
$string['confirmlabel'] = 'Patvirtinti';
$string['connectionLost'] = 'Nutrūko ryšys. Rezultatai bus saugomi ir išsiųsti, kai ryšys bus atkurtas.';
$string['connectionReestablished'] = 'Ryšys atkurtas.';
$string['contactPerson'] = 'Kontaktinis asmuo';
$string['contactPersonDescription'] = 'Jei kils problemų dėl leidėjo bendrinamo turinio, H5P susisieks su kontaktiniu asmeniu. Kontaktinio asmens vardas ir pavardė ar kita informacija nebus skelbiama ar dalijamasi su trečiosiomis šalimis';
$string['contentAvailable'] = 'Jūsų turinys paprastai bus pasiekiamas Hub per vieną darbo dieną.';
$string['contentCopied'] = 'Turinys nukopijuotas į iškarpinę';
$string['contentLicenseTitle'] = 'Turinio licencijos informacija';
$string['contentUpdateSoon'] = 'Jūsų turinys netrukus bus atnaujintas';
$string['contentchanged'] = 'Šis turinys pasikeitė nuo tada, kai jį paskutinį kartą naudojote.';
$string['contentinuse'] = 'Šis turinys gali būti naudojamas kitose vietose.';
$string['contenttype'] = 'Turinio tipas';
$string['copyright'] = 'Naudojimo teisės';
$string['copyrightWarning'] = 'Autorių teisių saugomos medžiagos negalima bendrinti H5P turinio centre. Jei turinys licencijuotas naudojant OER palankią licenciją, pvz., Creative Commons, pasirinkite atitinkamą licenciją. Jei ne, šio turinio negalima bendrinti.';
$string['copyrightinfo'] = 'Autorių teisių informacija';
$string['copyrightstring'] = 'Autorių teisės';
$string['copyrighttitle'] = 'Rodyti autorių teisių informaciją šiam turiniui.';
$string['couldNotParseJSONFromZip'] = 'Nepavyko išanalizuoti JSON iš paketo: {$a->%fileName}';
$string['couldNotReadFileFromZip'] = 'Nepavyko nuskaityti failo iš paketo: {$a->%fileName}';
$string['country'] = 'Šalis';
$string['creativecommons'] = '„Creative Commons“';
$string['cropImage'] = 'Apkirpti paveiksliuką';
$string['currentStep'] = 'Žingsnis :step iš :total';
$string['date'] = 'Data';
$string['deletelibraryconfirm'] = '<p>Ar tikrai norite ištrinti versiją <em>\'{$a->version}\'</em> iš bibliotekos <em>\'{$a->name}</em>? Bus pašalinta biblioteka ir visi jos naudojimo būdai.</p><p>Šios operacijos anuliuoti negalima.</p>';
$string['deletelibraryversion'] = 'Naikinti versiją';
$string['deleting'] = 'Naikinama biblioteka';
$string['description'] = 'Aprašas';
$string['disablefullscreen'] = 'Išjungti viso ekrano režimą';
$string['discipline:dropdownButton'] = 'Išskleidžiamojo meniu mygtukas';
$string['discipline:in'] = 'į';
$string['discipline:searchPlaceholder'] = 'Įveskite norėdami ieškoti disciplinų';
$string['disciplineDescription'] = 'Galite pasirinkti kelias disciplinas';
$string['disciplineLabel'] = 'Disciplinos';
$string['disciplineLimitReachedMessage'] = 'Galite pasirinkti iki :numDisciplines disciplinų';
$string['disciplines'] = 'Disciplinos';
$string['download'] = 'Atsisiųsti';
$string['downloadtitle'] = 'Atsisiųskite šį turinį kaip H5P failą.';
$string['editInfoTitle'] = 'Redaguoti <strong>:title</strong> informaciją';
$string['editcontent'] = 'Redaguoti H5P turinį';
$string['editingFailed'] = 'Redaguoti nepavyko.';
$string['editor'] = 'Redaktorius';
$string['emailAddress'] = 'Elektroninio pašto adresas';
$string['emailAddressDescription'] = 'El. pašto adresą naudos H5P, kad susisiektų su leidėju, jei kiltų problemų dėl turinio arba leidėjui reikės atkurti paskyrą. Jis nebus skelbiamas ar bendrinamas su jokiomis trečiosiomis šalimis';
$string['embed'] = 'Įterpti';
$string['embedtitle'] = 'Peržiūrėkite šio turinio įdėjimo kodą.';
$string['error:emptycontentid'] = 'Nurodytas URL neteisingas arba negalite redaguoti šio failo.';
$string['eventh5pdeleted'] = 'H5P panaikintas';
$string['eventh5pviewed'] = 'H5P turinys peržiūrėtas';
$string['feature'] = 'Funkcija';
$string['fetchtypesfailure'] = 'Nebuvo galima gauti informacijos apie turimus H5P turinio tipus. H5P saugyklos ryšio triktis';
$string['fileExceedsMaxSize'] = 'Vienas iš paketo failų viršija maksimalų leistiną failo dydį. ({$a->%file} {$a->%used} > {$a->%max})';
$string['filter_displayh5p'] = 'Rodyti H5P filtrą';
$string['filter_displayh5p_description'] = 'Display H5P filtras konvertuoja URL į įterptą H5P turinį.';
$string['fullscreen'] = 'Per visą ekraną';
$string['gpl'] = 'Bendroji Viešoji Licencija v3';
$string['h5p'] = 'H5P';
$string['h5pcustomcss'] = 'Tinkintas CSS';
$string['h5pcustomcss_help'] = 'CSS, taikytinas H5P turiniui.';
$string['h5peditor'] = 'H5P rengyklė';
$string['h5pfilenotfound'] = 'H5P failas nerastas';
$string['h5pinvalidurl'] = 'Netinkamas H5P turinio URL.';
$string['h5plibraryhandler'] = 'H5P sistemos tvarkytojas';
$string['h5plibraryhandler_help'] = 'H5P sistema, naudojama H5P turiniui rodyti. Rekomenduojama naujausia versija.';
$string['h5pmanage'] = 'Tvarkyti H5P turinio tipus';
$string['h5poverview'] = 'H5P apžvalga';
$string['h5ppackage'] = 'H5P turinio tipas';
$string['h5ppackage_help'] = 'H5P turinio tipas yra failas su H5P arba ZIP plėtiniu, kuriame yra visos bibliotekos, reikalingos turiniui rodyti.';
$string['h5pprivatefile'] = 'Šio H5P turinio negalima rodyti, nes neturite prieigos prie .h5p failo.';
$string['h5psettings'] = 'H5P nuostatos';
$string['h5ptitle'] = 'Aplankykite h5p.org kad pamatytumėte daugiau turinio.';
$string['height'] = 'aukštis';
$string['helpChoosingLicense'] = 'Padėti man išsirinkti licenciją';
$string['hideadvanced'] = 'Slėpti išplėstinius';
$string['icon'] = 'Piktograma';
$string['iconDescription'] = '640x480px. Jei nepasirinktas turinys, bus naudojama kategorijos piktograma';
$string['installedcontentlibraries'] = 'Įdiegtos H5P bibliotekos';
$string['installedcontenttypes'] = 'Įdiegti H5P turinio tipai';
$string['installedh5p'] = 'Įdiegtas H5P';
$string['invalidAge'] = 'Netinkamas tipinio amžiaus įvesties formatas. Galimi įvesties formatai, atskirti kableliais: "1, 34-45, -50, -59-".';
$string['invalidcontextid'] = 'H5P failas nerastas (netinkamas konteksto id)';
$string['invalidfile'] = 'Failas „{$a->%filename}“ neleidžiamas. Leidžiami tik failai su šiais plėtiniais: {$a->%files-allowed}.';
$string['invalidlanguagefile'] = 'Netinkamas kalbos failas {$a->%file} bibliotekoje {$a->%library}';
$string['invalidlanguagefile2'] = 'Neteisingas kalbos failas {$a->%languageFile} buvo įtrauktas į biblioteką {$a->%name}';
$string['invalidlibrarydata'] = 'Pateikti neteisingi {$a->%property} duomenys {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Pateikti {$a->%property} neteisingi duomenys {$a->%library}. Tikimasi loginio kintamojo.';
$string['invalidlibraryname'] = 'Netinkamas bibliotekos pavadinimas: {$a->%name}';
$string['invalidlibrarynamed'] = 'Turinyje naudojama H5P biblioteka {$a->%library} negalioja';
$string['invalidlibraryoption'] = 'Neteisėta parinktis {$a->%option} {$a->%library}';
$string['invalidlibraryproperty'] = 'Nepavyko nuskaityti nuosavybės {$a->%property} {$a->%library}';
$string['invalidmainjson'] = 'Trūksta galiojančio pagrindinio failo „h5p.json“';
$string['invalidmultiselectoption'] = 'Netinkama kelių pasirinkimų parinktis.';
$string['invalidpackage'] = 'Neteisingas H5P turinio tipas';
$string['invalidselectoption'] = 'Netinkama pasirinkta parinktis.';
$string['invalidsemanticsjson'] = 'Neteisingas semantics.json failas buvo įtrauktas į biblioteką {$a->%name}';
$string['invalidsemanticstype'] = 'H5P vidinė klaida: nežinomas turinio tipas „{$a->@type}“ semantikoje. Pašalinamas turinys!';
$string['invalidstring'] = 'Pateikta eilutė negalioja pagal semantikos regexp. (reikšmė: "{$a->%value}", reguliarioji išraiška: "{$a->%regexp}")';
$string['isNowSubmitted'] = 'Dabar pateikta H5P Hub';
$string['keywordExists'] = 'Raktažodis jau yra!';
$string['keywords'] = 'Raktažodžiai';
$string['keywordsDescription'] = 'Galite pridėti kelis raktažodžius, atskirtus kableliais. Norėdami patvirtinti raktažodžius, paspauskite „Enter“ arba „Add“.';
$string['keywordsExits'] = 'Raktažodis jau yra!';
$string['keywordsPlaceholder'] = 'Pridėti raktažodžių';
$string['language'] = 'Kalba';
$string['level'] = 'Lygis';
$string['librariesmanagerdescription'] = '<p>H5P suteikia galimybę naudotojams kurti interaktyvų turinį pateikiant įvairių tipų turinį.</p><p>Norėdami užtikrinti, kad svetainėje būtų naudojami tik patikimi H5P turinio tipai, turite <i>arba</i> </p><ul><li>Įkelti H5P turinio tipus iš h5p.org <i>arba</i></li><li>Įgalinti suplanuotą užduotį „Atsisiųsti galimus H5P turinio tipus iš h5p.org“</li></ul><p>Pastaba: naudotojai galės naudoti tik svetainėje įdiegtus H5P turinio tipus.</p>';
$string['librarydirectoryerror'] = 'Bibliotekos katalogo pavadinimas turi atitikti machineName arba machineName-majorVersion.minorVersion (iš library.json). (Katalogas: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['license'] = 'Licencija';
$string['licenseCC010'] = 'CC0 1.0 Universali (CC0 1.0)
Priskyrimas Viešajai sričiai';
$string['licenseCC010U'] = 'CC0 1.0 Universali';
$string['licenseCC10'] = '1.0 Generic';
$string['licenseCC20'] = '2.0 Generic';
$string['licenseCC25'] = '2.5 Generic';
$string['licenseCC30'] = '3.0 Neperkelta';
$string['licenseCC40'] = '4.0 Tarptautinė';
$string['licenseDescription'] = 'Pasirinkite licenciją savo turiniui';
$string['licenseDetails'] = 'Išsami informacija apie licenciją';
$string['licenseDialogDescription'] = 'Spustelėkite konkrečią licenciją, kad gautumėte informacijos apie tinkamą naudojimą';
$string['licenseGPL'] = 'Bendroji viešoji licencija';
$string['licenseV1'] = 'Versija 1';
$string['licenseV2'] = 'Versija 2';
$string['licenseV3'] = 'Versija 3';
$string['licenseVersionDescription'] = 'Pasirinkite licencijos versiją';
$string['licensee'] = 'Licencijos turėtojas';
$string['licenseextras'] = 'Licencijos priedai';
$string['licenseversion'] = 'Licencijos versija';
$string['lockh5pdeploy'] = 'Šio H5P turinio pasiekti negalima, nes jis diegiamas. Pabandykite dar kartą vėliau.';
$string['logoUploadText'] = 'Organizacijos logotipas arba avataras';
$string['longDescription'] = 'Ilgas aprašymas';
$string['longDescriptionPlaceholder'] = 'Ilgas jūsų turinio aprašymas';
$string['mainTitle'] = 'Bendrinamas <strong>:title</strong>';
$string['mainlibrarydisabled'] = 'Šio failo negalima rodyti, nes jo turinio tipas išjungtas. Susisiekite su administratoriumi ir paprašykite įgalinti turinio tipą.';
$string['maxLength'] = 'Didžiausias simbolių skaičius yra :length';
$string['missingcontentfolder'] = 'Trūksta tinkamo turinio aplanko';
$string['missingcoreversion'] = 'Sistemai nepavyko iš paketo įdiegti komponento {$a->%component}, nes tam reikalinga naujesnė H5P papildinio versija. Šioje svetainėje šiuo metu veikia {$a->%current} versija, o reikalinga versija yra {$a->%required} arba naujesnė. Atnaujinkite ir bandykite dar kartą.';
$string['missingdependency'] = 'Trūksta priklausomybės {$a->@dep}, kurios reikalauja {$a->@lib}.';
$string['missinglibrary'] = 'Trūksta būtinos bibliotekos {$a->@library}';
$string['missinglibraryfile'] = 'Bibliotekoje trūksta failo „{$a->%file}“: „{$a->%name}“';
$string['missinglibraryjson'] = 'Nepavyko rasti bibliotekos.json failo su galiojančiu JSON formatu bibliotekai {$a->%name}';
$string['missinglibraryproperty'] = 'Trūksta būtinos nuosavybės {$a->%property} iš {$a->%library}';
$string['missingmainlibrary'] = 'Trūksta pagrindinės bibliotekos {$a->@library}';
$string['missingmbstring'] = '„Mbstring“ PHP plėtinys nėra įkeltas. Jis reikalingas, kad H5P tinkamai veiktų.';
$string['missinguploadpermissions'] = 'Atminkite, kad bibliotekos gali būti jūsų įkeltame faile, tačiau jums neleidžiama įkelti naujų bibliotekų. Susisiekite su administratoriumi.';
$string['next'] = 'Kitas';
$string['nocopyright'] = 'Nėra autorių teisių informacijos šiam turiniui.';
$string['noextension'] = 'Įkeltas failas nėra tinkamas HTML5 paketas. (Jis neturi .h5p failo plėtinio.)';
$string['noh5plibhandlerdefined'] = 'Nėra įdiegtos H5P sistemos tvarkyklės, todėl H5P turinio rodyti negalima.';
$string['nojson'] = 'Pagrindinis failas h5p.json neteisingas';
$string['nopermissiontodeploy'] = 'Šio failo negalima rodyti, nes jį įkėlė naudotojas, neturėdamas reikiamos galimybės įdiegti H5P turinio.';
$string['nopermissiontoedit'] = 'Neturite leidimo redaguoti H5P turinio.';
$string['notrustablefile'] = 'Šio failo negalima rodyti, nes jį įkėlė naudotojas, negalėdamas atnaujinti H5P turinio tipų. Susisiekite su administratoriumi, kad paprašytumėte įdiegti turinio tipą.';
$string['nounzip'] = 'Įkeltas failas nėra tinkamas HTML5 paketas. (Jo išarchyvuoti neįmanoma.)';
$string['offlineDialogBody'] = 'Nepavyko išsiųsti informacijos apie jūsų atliktą šią užduotį. Patikrinkite interneto ryšį.';
$string['offlineDialogHeader'] = 'Jūsų ryšys su serveriu nutrūko';
$string['offlineDialogRetryButtonLabel'] = 'Bandykite dar kartą dabar';
$string['offlineDialogRetryMessage'] = 'Bandoma dar kartą :num....';
$string['offlineSuccessfulSubmit'] = 'Rezultatai sėkmingai pateikti.';
$string['optionalInfo'] = 'Pasirinktina informacija';
$string['originator'] = 'Pradininkas';
$string['pd'] = 'Viešasis domenas';
$string['pddl'] = 'Viešojo domeno dedikacija ir licencija';
$string['pdm'] = 'Public Domain Mark (PDM)';
$string['phone'] = 'Telefonas';
$string['pleaseWait'] = 'Prašome palaukti...';
$string['pluginname'] = 'H5P paketas';
$string['privacy:metadata'] = 'H5P posistemis nesaugo jokių asmens duomenų.';
$string['publisherDescription'] = 'Leidėjo aprašymas';
$string['publisherDescriptionText'] = 'Tai bus rodoma bendrinamo turinio skiltyje „Leidėjo informacija“.';
$string['publisherFieldDescription'] = 'Bendrinamame turinyje tai bus rodoma kaip „Leidėjo pavadinimas“';
$string['publisherFieldTitle'] = 'Leidėjas';
$string['registerOnHub'] = 'Užsiregistruoti „H5P Hub“.';
$string['registrationFailed'] = 'An error occurred';
$string['registrationFailedDescription'] = 'Šiuo metu mums nepavyko sukurti paskyros. Kažkas nutiko. Bandykite dar kartą vėliau.';
$string['registrationTitle'] = 'H5P Hub registracija';
$string['remove'] = 'Pašalinti';
$string['removeChip'] = 'Pašalinti :chip iš sąrašo';
$string['removeImage'] = 'Pašalinti paveikslėlį';
$string['requiredInfo'] = 'Reikalinga informacija';
$string['resizescript'] = 'Įtraukite šį skriptą į savo svetainę, jei norite dinamiško įterptojo turinio dydžio:';
$string['resubmitScores'] = 'Bandoma pateikti saugomus rezultatus.';
$string['reuse'] = 'Pakartotinis naudojimas';
$string['reuseContent'] = 'Pakartotinis turinio naudojimas';
$string['reuseDescription'] = 'Pakartotinai naudoti šį turinį.';
$string['reviewAndSave'] = 'Peržiūrėti ir išsaugoti';
$string['reviewAndShare'] = 'Peržiūrėti ir pasidalinti';
$string['reviewInfo'] = 'Peržiūrėti informaciją';
$string['reviewMessage'] = 'Prieš dalindamiesi peržiūrėkite toliau pateiktą informaciją';
$string['rotateLeft'] = 'Pasukti kairėn';
$string['rotateRight'] = 'Pasukti dešinėn';
$string['saveChanges'] = 'Išsaugoti pakeitimus';
$string['screenshots'] = 'Ekrano nuotraukos';
$string['screenshotsDescription'] = 'Pridėkite iki penkių savo turinio ekrano kopijų';
$string['share'] = 'Bendrinti';
$string['shareFailed'] = 'Bendrinti nepavyko.';
$string['shareTryAgain'] = 'Kažkas ne taip, pabandykite bendrinti dar kartą.';
$string['shared'] = 'Bendrinama';
$string['sharingNote'] = 'Visą informaciją apie turinį galima redaguoti po bendrinimo';
$string['shortDescription'] = 'Trumpas aprašymas';
$string['shortDescriptionPlaceholder'] = 'Trumpas jūsų turinio aprašymas';
$string['showadvanced'] = 'Rodyti išplėstinius';
$string['showless'] = 'Rodyti mažiau';
$string['showmore'] = 'Rodyti daugiau';
$string['size'] = 'Dydis';
$string['someKeywordsExits'] = 'Kai kurie iš šių raktinių žodžių jau egzistuoja';
$string['source'] = 'Šaltinis';
$string['startingover'] = 'Pradėsite iš naujo.';
$string['status'] = 'Būsena';
$string['subContentWarning'] = 'Subturiniu (vaizdais, klausimais ir kt.) bus dalijamasi pagal :license, nebent autorystės įrankyje nurodyta kitaip';
$string['sublevel'] = 'Sublygis';
$string['submitted'] = 'Pateikta!';
$string['successfullyRegistred'] = 'Sėkmingai užregistravote paskyrą H5P Hub';
$string['successfullyRegistredDescription'] = 'Jūsų paskyros duomenys gali būti pakeisti';
$string['successfullyUpdated'] = 'Jūsų H5P Hub paskyros nustatymai buvo sėkmingai pakeisti';
$string['task_h5p'] = 'H5P suplanuota užduotis';
$string['task_h5p_description'] = 'H5P suplanuota užduotis atsisiunčia galimus H5P turinio tipus iš h5p.org.';
$string['thumbnail'] = 'Miniatiūra';
$string['title'] = 'Pavadinimas';
$string['undisclosed'] = 'Nepaskelbta';
$string['unpackedFilesExceedsMaxSize'] = 'Bendras neišpakuotų failų dydis viršija didžiausią leistiną dydį. ({$a->%used} > {$a->%max})';
$string['updateRegistrationOnHub'] = 'Išsaugoti paskyros nustatymus';
$string['updatedlibraries'] = 'Atnaujintos {$a->%old} H5P bibliotekos.';
$string['updatedlibrary'] = 'Atnaujinta {$a->%old} H5P biblioteka.';
$string['uploadlibraries'] = 'Įkelti H5P turinio tipus';
$string['uploadsuccess'] = '„H5P“ turinio tipai sėkmingai įkelti';
$string['width'] = 'plotis';
$string['wrongversion'] = 'Šiame turinyje naudojama H5P bibliotekos versija {$a->%machineName} negalioja. Turinyje yra {$a->%contentLibrary}, bet jis turėtų būti {$a->%semanticsLibrary}.';
$string['year'] = 'Metai';
$string['years'] = 'Metai';
$string['yearsfrom'] = 'Metai (nuo)';
$string['yearsto'] = 'Metai (iki)';
$string['zip'] = 'Zip';
