<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'lt', version '5.1'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Prieiga atmesta';
$string['accountlocked'] = 'Jūsų paskyra yra užrakinta. El. paštu buvo išsiųsta atrakinimo nuoroda.';
$string['accounts'] = 'Paskyros';
$string['accountunlocked'] = 'Jūsų paskyra atrakinta. Galite prisijungti.';
$string['addcategory'] = 'Pridėti kategoriją';
$string['additionalhtml'] = 'Papildomas HTML';
$string['additionalhtml_desc'] = 'Šie nustatymai leidžia nurodyti HTML, kurį norite įtraukti į kiekvieną puslapį. Galite nustatyti HTML, kuris bus įtrauktas į puslapio žymą HEAD, iškart atidarius BODY žymą arba prieš pat uždarant body žymą.<br />Tai leidžia pridėti pasirinktines antraštes arba poraštes kiekviename puslapyje, arba labai lengvai pridėti palaikymą tokioms paslaugoms kaip „Google Analytics“, nepriklausomai nuo pasirinktos temos.';
$string['additionalhtml_heading'] = 'Papildoma HTML kaba, įtraukiama į kiekvieną puslapį.';
$string['additionalhtmlfooter'] = 'Prieš uždarant BODY';
$string['additionalhtmlfooter_desc'] = 'Šis turinys bus įtrauktas į kiekvieną puslapį  prieš uždarant ,,body" žymę.';
$string['additionalhtmlhead'] = 'Žymėje HEAD';
$string['additionalhtmlhead_desc'] = 'Šis turinys bus pateikiamas kiekvienos žymės HEAD / ANTRAŠTĖ puslapio apačioje';
$string['additionalhtmltopofbody'] = 'Atidarius BODY';
$string['additionalhtmltopofbody_desc'] = 'Šis turinys bus įtrauktas į kiekvieną puslapį, atidarius žymę BODY.';
$string['admincategory'] = 'Kategorija: {$a}';
$string['adminseesall'] = 'Administratoriai mato viską';
$string['adminseesallevents'] = 'Administratoriai mato visus įvykius';
$string['adminseesownevents'] = 'Administratoriai yra tokie pat naudotojai';
$string['advancedfeatures'] = 'Išplėstinės funkcijos';
$string['agedigitalconsentverification'] = 'Skaitmeninis amžiaus patvirtinimo sutikimas';
$string['agedigitalconsentverification_desc'] = 'Įgalinamas skaitmeninio sutikimo amžiaus patvirtinimas prieš pateikiant registracijos puslapį savarankiškai besiregistruojantiems naudotojams. Taip jūsų svetainė apsaugoma nuo nepilnamečių prisijungimo be tėvų/globėjų sutikimo. Jei reikia daugiau pagalbos, pateikiama išsami <a target="_blank" href="{$a}">palaikymo kontaktinė</a> informacija.';
$string['ageofdigitalconsentmap'] = 'Skaitmeninis amžius sutikimas';
$string['ageofdigitalconsentmap_desc'] = 'Čia gali būti nurodytas numatytasis skaitmeninis sutikimo amžius ir amžius bet kurioje šalyje, kur jis skiriasi nuo numatytojo. Įveskite kiekvieną amžių naujoje eilutėje su formatu: šalies kodas, amžius (atskirkite kableliu). Numatytasis amžius nurodomas * vietoje šalies kodo. Šalių kodai nurodyti ISO 3166-2.';
$string['allcountrycodes'] = 'Visų šalių kodai';
$string['allowattachments'] = 'Leisti priedus';
$string['allowbeforeblock'] = 'Pirmiausia bus apdorojamas leidžiamas sąrašas';
$string['allowbeforeblockdesc'] = 'Numatyta, kad pirmiausia sugretinami užblokuotų IP įrašai. Jei ši parinktis įjungta, leidžiamų IP įrašai apdorojami prieš blokuotųjų sąrašus.';
$string['allowcategorythemes'] = 'Leisti kategorijos temas';
$string['allowcohortthemes'] = 'Leisti junginių temas';
$string['allowcoursethemes'] = 'Leisti kurso temas';
$string['allowedemaildomains'] = 'Leistini el. pašto domenai';
$string['allowediplist'] = 'Leidžiamų IP protokolų sąrašas';
$string['allowemailaddresses'] = 'Leistini el. pašto domenai';
$string['allowemojipicker'] = 'Jaustukų rinkiklis';
$string['allowframembedding'] = 'Leidžiama įterpti rėmelį / kadrą';
$string['allowframembedding_help'] = 'Jei įjungta, ši svetainė gali būti įterpta į rėmelį nuotolinėje sistemoje, kaip rekomenduojama naudojant registracijos papildinį „Paskelbti kaip LTI įrankį“. Kitu atveju saugumo sumetimais rekomenduojama palikti rėmelio įdėjimą išjungtą. Atminkite, kad programėlėje mobiliesiems šio nustatymo nepaisoma ir rėmelio įterpimas visada leidžiamas.';
$string['allowguestmymoodle'] = 'Leisti svečiams prisijungti prie "Mano pagrindinis" puslapio';
$string['allowindexing'] = 'Leisti indeksavimą paieškos varikliuose';
$string['allowindexing_desc'] = 'Tai lemia, ar leisti paieškos sistemoms indeksuoti jūsų svetainę. „Visur“ leis paieškos sistemoms ieškoti visur, įskaitant prisijungimo ir registracijos puslapius, o tai reiškia, kad svetainės, kuriose įjungtas priverstinis prisijungimas, vis tiek indeksuojamos. Kad išvengtumėte pavojaus, kad prisiregistravimo puslapyje galima ieškoti nepageidaujamo pašto, naudokite „Visur, išskyrus prisijungimo ir prisiregistravimo puslapius“. „Niekur“ nurodys paieškos sistemoms neindeksuoti jokio puslapio. Atminkite, kad tai tik žyma svetainės antraštėje. Paieškos variklis turi atsižvelgti į žymą.';
$string['allowindexingeverywhere'] = 'Visur';
$string['allowindexingexceptlogin'] = 'Visur, išskyrus prisijungimo ir registravimo puslapius';
$string['allowindexingnowhere'] = 'Niekur';
$string['allowobjectembed'] = 'Leisti žymes EMBED ir OBJECT';
$string['allowthemechangeonurl'] = 'Leisti keisti temas URL';
$string['allowuserblockhiding'] = 'Leisti naudotojams slėpti blokus';
$string['allowusermailcharset'] = 'Leisti naudotojui pasirinkti simbolių rinktinį';
$string['allowuserswitchrolestheycantassign'] = 'Leisti naudotojams, neturintiems vaidmenų priskyrimo galimybės, perjungti vaidmenis';
$string['allowuserthemes'] = 'Leisti naudotojo temas';
$string['alternativefullnameformat'] = 'Alternatyvus pilno vardo formatas';
$string['alternativefullnameformat_desc'] = 'Tai apibrėžia, kaip vardai rodomi naudotojams, turintiems vardų peržiūros funkciją (pagal numatytuosius nustatymus naudotojams, turintiems tvarkytojo, dėstytojo arba neredaguojančio dėstytojo vaidmenį). Vietos rezervavimo ženklai, kuriuos galima naudoti, yra tokie kaip nustatymui „Viso vardo formatas“.';
$string['always'] = 'Visada';
$string['appearance'] = 'Išvaizda';
$string['aspellpath'] = 'Kelias į „Aspell“';
$string['asyncbackupdisabled'] = 'Šiuo metu jūsų svetainė sukonfigūruota naudoti sinchronines atsargines kopijas. Asinchroninės atsarginės kopijos užtikrina geresnę naudotojų patirtį, nes naudotojams leidžiama atlikti kitas operacijas, kol kuriama atsarginė kopija arba atkuriama. Asinchroninės atsarginės kopijos įjungtos visose svetainėse nuo „Moodle 4.5 LTS“. Sinchroninės atsarginės kopijos bus pašalintos iš „Moodle LMS“ versijos po 4.5 LTS.';
$string['authentication'] = 'Autentifikavimas';
$string['authpreventaccountcreation'] = 'Uždrausti paskyros kūrimą, kol autentifikuojama.';
$string['authpreventaccountcreation_help'] = 'Kai naudotojas autentifikuojamas, paskyra svetainėje yra automatiškai sukuriama, jei jos dar nėra. Jei išorinės duomenų bazės, tokios kaip LDAP yra naudojamos, bet jūs norite  apriboti priėjimą prie svetainės tik naudotojams kurie jau turi paskyras, tada šis pasirinkimas turėtų būti įgalintas. Naujas paskyras reikės sukurti rankiniu būdu arba per naudotojų įkėlimo funkciją. Šis nustatymas negalioja MNet autentifikavimui.';
$string['authsettings'] = 'Valdyti autentifikavimą';
$string['autolang'] = 'Automatinis kalbos aptikimas';
$string['autolangusercreation'] = 'Kurdami paskyrą nustatyti naudotojo naršyklės kalbą kaip pageidaujamą kalbą';
$string['autologinguests'] = 'Prijungti svečius automatiškai';
$string['availableto'] = 'Galima';
$string['availabletoanyone'] = 'Prieinama visiems, kurie lankosi svetainėje';
$string['availabletoauthenticated'] = 'Tik autentifikuotiems naudotojams';
$string['backgroundcolour'] = 'Permatoma spalva';
$string['backup_shortname'] = 'Naudoti kurso pavadinimą atsarginės kopijos failo pavadinime';
$string['backup_shortnamehelp'] = 'Naudoti kurso pavadinimą kaip atsarginės kopijos failo pavadinimo dalį.';
$string['backups'] = 'Atsarginė kopija';
$string['badwordsconfig'] = 'Įveskite blogų žodžių, atskirtų kableliais, sąrašą.';
$string['badwordsdefault'] = 'Jei pasirinktinis sąrašas tuščias, bus naudojamas numatytasis sąrašas iš kalbos paketo.';
$string['badwordslist'] = 'Pasirinktinis blogų žodžių sąrašas';
$string['blockediplist'] = 'Užblokuotų IP sąrašas';
$string['blockinstances'] = 'Egzemplioriai';
$string['blockmultiple'] = 'Keli';
$string['blockprotect'] = 'Ištrynimo apsauga';
$string['blockprotect_help'] = 'Jei užrakinsite tam tikro tipo bloką, niekas negalės pridėti ar ištrinti jo egzempliorių. (Žinoma, galite vėl atrakinti, jei reikia ir redaguoti egzempliorius.)

Taip siekiama apsaugoti tokius blokus, kaip navigacija ir nustatymai, kuriuos labai sunku grąžinti, jei jie netyčia ištrinami.';
$string['blockprotectblock'] = 'Apsaugoti „{$a}“ egzempliorius';
$string['blockprotected'] = '„{$a}“ bloko egzemplioriai yra apsaugoti.';
$string['blocksettings'] = 'Tvarkyti blokus';
$string['blockunprotectblock'] = 'Atšaukti „{$a}“ egzempliorių apsaugą';
$string['blockunprotected'] = '{$a} bloko egzemplioriai neapsaugoti.';
$string['bloglevel'] = 'Tinklaraščio matomumas';
$string['bookmarkadded'] = 'Žymė įtraukta.';
$string['bookmarkalreadyexists'] = 'Jau pažymėjote šį puslapį.';
$string['bookmarkdeleted'] = 'Žymė panaikinta.';
$string['bookmarkthispage'] = 'Žymėti šį puslapį';
$string['cacheapplication'] = 'Programos talpykla';
$string['cacheapplicationhelp'] = 'Talpyklos elementai yra bendrinami su visais naudotojais ir galioja iki nustatyto laiko (ttl).';
$string['cachejs'] = 'Įtraukti į talpyklą „Javascript“';
$string['cachejs_help'] = '.„Javascript“ talpinimas ir glaudinimas labai pagerina puslapio įkėlimo efektyvumą. Primygtinai rekomenduojama naudoti jį produkcinėse svetainėse. Programų kūrėjai šią funkciją greičiausiai norės išjungti.';
$string['cacherequest'] = 'Prašyti talpyklos';
$string['cacherequesthelp'] = 'Specifinė naudotojo talpykla, kurios galiojimo laikas baigiasi, kai užklausa įvykdoma. Sukurta pakeisti sritis, kuriose naudojame statines talpyklas.';
$string['cachesession'] = 'Sesijos talpykla';
$string['cachesessionhelp'] = 'Specifinė naudotojo talpykla, kurios galiojimo laikas baigiasi, kai baigiasi naudotojo sesija. Sukurta palengvinti seanso įtampą.';
$string['cachesettings'] = 'Talpyklos nustatymai';
$string['cachetemplates'] = 'Talpyklos šablonai';
$string['cachetemplates_help'] = 'Šablonų kaupimas talpykloje pagerins puslapio įkėlimo našumą ir yra labai rekomenduojamas produkcinėse svetainėse. Programuotojai tikriausiai norės išjungti šią funkciją.';
$string['caching'] = 'Talpinama';
$string['calendar_weekend'] = 'Savaitgalio dienos';
$string['calendarexportsalt'] = 'Eksportavimo saugumo tekstas';
$string['calendarsettings'] = 'Kalendorius';
$string['calendartype'] = 'Kalendoriaus tipas';
$string['calendartype_desc'] = 'Pasirinkite numatytąjį kalendoriaus tipą visai svetainei. Šis nustatymas gali būti nepaisomas kurso parametrams ar naudotojų asmeniniuose profiliuose.';
$string['campaign'] = 'Kampanija';
$string['cannotdeletemodfilter'] = 'Negalite panaikinti \'{$a->filter}\' įdiegties, nes šis filtras yra modulio \'{$a->module}\' dalis.';
$string['cannotuninstall'] = '{$a} negali būti išinstaliuotas.';
$string['categoryemail'] = 'Elektroninis paštas';
$string['cfgwwwrootslashwarning'] = 'Faile config.php klaidingai apibrėžtas $CFG->wwwroot. Pabaigoje įtrauktas simbolis \'/\', kurį reikia pašalinti.';
$string['cfgwwwrootwarning'] = '$CFG->wwwroot yra neteisingai apibrėžtas config.php faile. Jis nesutampa su URL, kurį naudojate norėdami prieiti prie šio puslapio.';
$string['change'] = 'pakeisti';
$string['checkboxno'] = 'Ne';
$string['checkboxyes'] = 'Taip';
$string['checkupgradepending'] = 'Atnaujinimas';
$string['choosefiletoedit'] = 'Pasirinkti norimą redaguoti failą';
$string['cleanup'] = 'Valymas';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 't';
$string['cliexitgraceful'] = 'Gražiai išeinama, palaukite...';
$string['cliexitnow'] = 'Išeinama dabar';
$string['cliincorrectvalueerror'] = 'Klaida, klaidinga "{$a->option}" reikšmė "{$a->value}"';
$string['cliincorrectvalueretry'] = 'Klaidinga reikšmė, bandykite dar kartą';
$string['clistatusdisabled'] = 'Būsena: išjungta';
$string['clistatusenabled'] = 'Būsena: įjungta';
$string['clistatusenabledlater'] = 'statusas: CLI priežiūros režimas bus įjungtas {$a}';
$string['clitypevalue'] = 'tipo reikšmė';
$string['clitypevaluedefault'] = 'tipo reikšmė, paspauskite „Enter“, jei norite naudoti numatytąją reikšmę ({$a})';
$string['cliunknowoption'] = 'Neatpažintos parinktys:
  {$a}
Naudokite --žinyno parinktį.';
$string['cliupgradecompletenomaintenanceupgrade'] = 'Jei norite išvalyti likusias talpyklas po to, kai naudotojo srautas buvo perjungtas į naują kodą:

    php admin/cli/purge_caches.php --muc
    php admin/cli/purge_caches.php --js
    php admin/cli/purge_caches.php --filter
    php admin/cli/purge_caches.php --other

Kad sumažintumėte žiniatinklio serverio apkrovos šuolius, šiuos valymus turėtumėte atlikti atskirai, su tarpais tarp komandų.';
$string['cliupgradedefault'] = 'Nauja nuostata: {$a}';
$string['cliupgradedefaultheading'] = 'Naujų numatytųjų reikšmių nustatymas';
$string['cliupgradedefaultverbose'] = 'Naujas nustatymas: {$a->name}, Numatytoji reikšmė: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Komandinės eilutės atnaujinimas iš {$a->oldversion} į {$a->newversion} baigtas sėkmingai.';
$string['cliupgrademaintenancenotrequired'] = 'Dėl šio atnaujinimo naudotojai neįjungs priežiūros režimo.';
$string['cliupgrademaintenancerequired'] = 'Dėl šio atnaujinimo naudotojai turės priežiūros režimą.';
$string['cliupgradenoneed'] = 'Įdiegtos versijos {$a} naujinimas nereikalingas. Ačiū, kad užsukote!';
$string['cliupgradepending'] = 'Laukiama atnaujinimo';
$string['cliupgradesetlock'] = 'Atnaujinimas buvo užrakintas tik CLI vykdymui.';
$string['cliupgradeunsetlock'] = 'Esamas CLI vykdymo atnaujinimo užraktas buvo pašalintas.';
$string['cliyesnoprompt'] = 'įveskite t (taip) arba n (ne)';
$string['close'] = 'Uždaryti';
$string['cohort_customfield'] = 'Junginio pasirinktiniai laukai';
$string['commentsperpage'] = 'Puslapyje rodomų komentarų skaičius';
$string['commonactivitysettings'] = 'Bendrieji nustatymai';
$string['commonfiltersettings'] = 'Bendrieji filtro nustatymai';
$string['commonsettings'] = 'Bendrieji nustatymai';
$string['componentinstalled'] = 'Komponentas įdiegtas';
$string['computedfromlogs'] = 'Apskaičiuota pagal žurnalus nuo {$a}.';
$string['condifmodeditdefaults'] = 'Kuriant naują veiklą ar išteklius, nustatymų formoje naudojamos numatytosios reikšmės.';
$string['confeditorhidebuttons'] = 'Pasirinkite mygtukus, kurie HTML rengyklėje turėtų būti slepiami.';
$string['configallcountrycodes'] = 'Tai šalių, kurias galima pasirinkti įvairiose vietose, pvz., naudotojo profilyje, sąrašas. Jei jis tuščias (numatyta), naudojamas standartiniame anglų k. pakete esančio failo countries.php sąrašas. Tai sąrašas iš ISO 3166-1. Kitu atveju galite nurodyti kableliais atskirtų kodų sąrašą, pvz., GB,FR,ES. Jei čia įtrauksite naujų nestandartinių kodų, turėsite įtraukti juos į anglų k. paketo failą countries.php ir į savo kalbos paketą.';
$string['configallowassign'] = 'Kiekvienam vaidmeniui kairiajame stulpelyje pasirinkite, kuriuos vaidmenis jie gali priskirti kitiems.';
$string['configallowattachments'] = 'Jei įgalinta, el. laiškai išsiųsti iš šios svetainės, galės turėti priedų, tokių kaip pasiekimai.';
$string['configallowcategorythemes'] = 'Jei įjungsite tai, temas galima bus nustatyti kategorijos lygiu. Tai turės įtakos visoms antrinėms kategorijoms ir kursams, nebent nustatyta būtent jų tema. ĮSPĖJIMAS: kategorijų temų įjungimas gali turėti įtakos našumui.';
$string['configallowcohortthemes'] = 'Jei tai įjungsite, temas bus galima nustatyti grupės lygiu. Tai turės įtakos visiems naudotojams, turintiems tik vieną grupę arba daugiau nei vieną, bet tą pačią temą.';
$string['configallowcoursethemes'] = 'Jei įjungta, kursams bus leista nustatyti savo temas. Kurso temos nepaiso visų kitų temų pasirinkimų (svetainės, naudotojo, kategorijos, grupės arba URL apibrėžtos temos).';
$string['configallowedemaildomains'] = 'Išvardykite el. pašto domenus, kuriuos leidžiama atskleisti siunčiamo el. pašto skiltyje „Nuo“. Pagal numatytuosius nustatymus „Tuščias“ visiems siunčiamiems el. laiškams bus naudojamas adresas „Neatsakyti“. Leidžiama naudoti pakaitos simbolius pvz. *.example.com, tai leis el. laiškus siųsti iš bet kurio example.com padomenio, bet ne iš paties example.com. Tam reikės atskiro įvedimo.';
$string['configallowemailaddresses'] = 'Jei norite apriboti visus naujus el. pašto adresus pagal tam tikrus domenus, išvardykite juos čia, atskirdami tarpais. Visi kiti domenai bus atmesti. Jei norite, kad būtų leidžiami subdomenai, įtraukite domeną, prieš jį nurodę ženklą „.“. Norėdami leisti šakninį domeną kartu su jo padomeniais, pridėkite domeną du kartus – vieną kartą su priešais esančiu „. ir vieną kartą be pvz. .ourcollege.edu.au ourcollege.edu.au.';
$string['configallowemojipicker'] = 'Įjungtas jaustukų rinkiklis leidžia naudotojams pasirinkti jaustukus, pavyzdžiui, šypsenėles, ir juos pridėti žinutėse ir kitose teksto srityse per jaustukų rinkiklio mygtuką „Atto“ teksto rengyklėje.';
$string['configallowemojipickerincompatible'] = 'Dabartinė duomenų bazės konfigūracija tinkamai nepalaiko jaustukų. Kad įgalintumėte jaustukų rinkiklį, turėsite <a href="https://docs.moodle.org/en/MySQL_full_unicode_support">naujinti duomenų bazę, kad gautumėte visišką unikodo palaikymą</a>.';
$string['configallowguestmymoodle'] = 'Jei įjungta, svečiai gali pasiekti „Mano pagrindinis“ puslapį. Kitu atveju svečiai nukreipiami į svetainės pagrindinį puslapį.';
$string['configallowobjectembed'] = 'Saugumo sumetimais naudotojams, turintiems besimokančiojo vaidmenį, neleidžiama įterpti daugialypės terpės į tekstus naudojant HTML žymas EMBED ir OBJECT, tačiau daugialypę terpę vis tiek galima rodyti naudojant daugialypės terpės papildinių filtrą. Jei norite leisti šias žymas, įjunkite šią parinktį.';
$string['configallowoverride'] = 'Galite leisti asmenims, turintiems vaidmenis kairėje pusėje, keisti kai kuriuos stulpelių vaidmenis';
$string['configallowoverride2'] = 'Kiekvienam vaidmeniui kairiajame stulpelyje pasirinkite, kuriems vaidmenims jie gali nustatyti keitimą.<br />Naudotojai taip pat turi turėti galimybę moodle/role:override arba moodle/role:safeoverride.';
$string['configallowswitch'] = 'Kiekvienam vaidmeniui kairiajame stulpelyje pasirinkite, į kuriuos vaidmenis jie gali pereiti.<br />Naudotojai taip pat turi turėti galimybę moodle/role:switchroles.';
$string['configallowthemechangeonurl'] = 'Jei įjungta, temą galima pakeisti pridedant:<br />?theme=themename prie bet kurio Moodle URL (pvz.: mymoodlesite.com/?theme=afterburner ) arba <br />&theme=themename prie bet kurio vidinio Moodle URL ( pvz.: mymoodlesite.com/course/view.php?id=2&theme=afterburner ).';
$string['configallowuserblockhiding'] = 'Ar norite leisti naudotojams slėpti / rodyti šalutinius blokus visoje šioje svetainėje? Ši funkcija naudoja „Javascript“ bei slapukus, kad atsimintų kiekvieno sutraukiamo bloko būseną, ir turi įtakos tik naudotojo rodiniui.';
$string['configallowusermailcharset'] = 'Įjungus, visi naudotojai šioje svetainėje galės nusakyti savo simbolių rinkinį el. paštui.';
$string['configallowuserswitchrolestheycantassign'] = 'Numatyta, kad tam, jog naudotojui galėtų perjungti vaidmenis, būtinas „moodle“ / vaidmuo:assign. Įjungus šį parametrą šis reikalavimas pašalinamas, o vaidmenys, išvardyti išplečiamajame meniu Perjungti vaidmenį į, nustatomi tik pagal lentelės Leisti vaidmenų priskyrimus parametrus. Rekomenduojama nustatyti lentelės Leisti vaidmenų priskyrimus parametrus taip, kad naudotojams nebūtų leidžiama perjungti vaidmens, turinčio daugiau galimybių nei esamas vaidmuo.';
$string['configallowuserthemes'] = 'Jei įjungsite šį parametrą, naudotojams bus leidžiama nustatyti savo temas. Naudotojų temos perrašys svetainės temas (bet ne kursų temas)';
$string['configallowview'] = 'Kiekvienam vaidmeniui kairiajame stulpelyje pasirinkite, kuriuos vaidmenis jie gali peržiūrėti, ieškoti ir pagal kuriuos filtruoti.';
$string['configallusersaresitestudents'] = 'Ar vykdant veiklą svetainės pagrindiniame puslapyje VISI naudotojai turėtų būti laikomi besimokančiaisiais?  Jei taip, tuomet kiekvienas, turintis paskyrą, galės dalyvauti šioje veikloje kaip besimokantysis.  Jei ne, tuomet šioje veikloje galės dalyvauti tik tie naudotojai, kurie jau yra bent vieno kurso dalyviai. Tik administratoriai ir specialiai paskirti naudotojai gali veikti kaip dėstytojai svetainės pagrindiniame puslapyje.';
$string['configauthenticationplugins'] = 'Pasirinkite norimus naudoti autentifikavimo papildinius ir išdėstykite juos trikčių įveikimo tvarka.';
$string['configautolang'] = 'Nustatykite numatytąją kalbą pagal naršyklės parametrą, jei naudojama išjungtos svetainės numatytoji reikšmė.';
$string['configautolangusercreation'] = 'Jei įjungta, kai naudotojo paskyra sukuriama automatiškai pirmą kartą prisijungus (pvz., naudojant LDAP arba OAuth 2 autentifikavimą), naudotojo naršyklės kalba nustatoma kaip pageidaujama kalba. Kitu atveju numatytoji svetainės kalba nustatoma kaip naudotojo pageidaujama kalba.';
$string['configautologinguests'] = 'Ar lankytojai turėtų būti automatiškai prijungiami kaip svečiai, kai prisijungia prie kursų naudodami svečio prieigą?';
$string['configbloglevel'] = 'Šis parametras leidžia jums apriboti lygį, iki kurio galima peržiūrėti šioje svetainėje esančius naudotojų tinklaraščius. Atkreipkite dėmesį, kad nurodomas maksimalus VIEWER, o ne skelbėjo arba tinklaraščio skelbimų tipų kontekstas. Tinklaraščius taip pat galite visiškai išjungti, jei nenorite jų matyti.';
$string['configcalendarcustomexport'] = 'Įgalinti tinkintos kalendoriaus dienų sekos eksportavimą';
$string['configcalendarexportsalt'] = 'Šis atsitiktinis tekstas naudojamas norint pagerinti autentifikavimo atpažinimo ženklų, naudojamų kalendoriams eksportuoti, saugą. Atkreipkite dėmesį, kad visi esami atpažinimo ženklai bus neleistini, jei pakeisite šį maišos „salt“.';
$string['configcookiesecure'] = 'Jei serveris priima tik https ryšius, rekomenduojama įjungti saugių slapukų siuntimą. Jei jis įjungtas, įsitikinkite, kad žiniatinklio serveris nepriima http:// arba nustato nuolatinį peradresavimą į https:// adresą ir ideliai siunčia HSTS antraštes. Kai <em>wwwroot</em> adresas nepradedamas https://, šis parametras automatiškai išjungiamas.';
$string['configcountry'] = 'Jei čia nustatysite šalį, ji bus pasirenkama kaip numatytoji naujose naudotojų paskyrose. Jei norite, kad šalį pasirinktų naudotojas, palikite šį parametrą nenustatytą.';
$string['configcoursegraceperiodafter'] = 'Klasifikuokite ankstesnius kursus kaip vykstančius tiek daug dienų po kurso pabaigos datos.';
$string['configcoursegraceperiodbefore'] = 'Priskirkite būsimus kursus kaip vykstančius tiek daug dienų iki kurso pradžios datos.';
$string['configcourseoverviewfilesext'] = 'Kableliais atskirtas leistinų kursų vaizdo failų plėtinių sąrašas.';
$string['configcourseoverviewfileslimit'] = 'Maksimalus failų skaičius, kuris gali būti rodomas šalia kursų santraukos kursų sąrašo puslapyje. Pirmasis pridėtas vaizdo failas yra naudojamas kaip kurso vaizdas kurso apžvalgoje naudotojų informacijos suvestinėse; visi papildomi failai rodomi tik kursų sąrašo puslapyje.';
$string['configcourserequestnotify'] = 'Įveskite naudotojo, kuris bus informuojamas apie naujų kursų sukūrimo prašymą, vardą.';
$string['configcourserequestnotify2'] = 'Naudotojai, kurie bus informuoti apie naujo kurso sukūrimo prašymą. Čia išvardyti tik naudotojai, kurie gali patvirtinti kurso sukūrimo prašymus.';
$string['configcoursesperpage'] = 'Įveskite kursų, rodomų kiekviename kursų sąrašo puslapyje, skaičių.';
$string['configcourseswithsummarieslimit'] = 'Didžiausias kursų skaičius, kurį reikia parodyti kursų sąraše, įskaitant santraukas prieš grįžtant prie paprastesnio sąrašo.';
$string['configcronclionly'] = '„Cron" scenarijaus paleidimas iš žiniatinklio naršyklės gali atskleisti privilegijuotą informaciją nežinomiems naudotojams. Todėl rekomenduojama „Cron“ scenarijų paleisti tik naudojant komandų eilutę arba nustatant „Cron" slaptažodį nuotolinei prieigai.';
$string['configcronremotepassword'] = 'Tai reiškia, kad cron.php scenarijaus negalima paleisti iš žiniatinklio naršyklės nepateikus slaptažodžio naudojant tokią URL formą:<pre> https://site.example.com/admin/cron.php?password=opensesame </pre>Jei šis laukas paliekamas tuščias, slaptažodžio nereikia.';
$string['configcurlcache'] = '„cURL“ talpyklos gyvavimo laikas sekundėmis.';
$string['configcustommenuitems'] = 'Čia galite sukonfigūruoti pasirinktinį meniu.
Įveskite kiekvieną meniu elementą į naują eilutę tokiu formatu: meniu tekstas, nuorodos URL (nebūtina, ne viršutiniame meniu elemente su antriniais elementais), patarimo pavadinimas (nebūtina) ir kalbos kodas arba kableliais atskirtų kodų sąrašas (neprivaloma, kad eilutė būtų rodoma tik nurodytos kalbos naudotojams), atskirta vertikaliais brūkšneliais. Eilutės, prasidedančios brūkšneliu, bus rodomos kaip meniu elementai ankstesniame aukščiausio lygio meniu, o ### sudaro skirtuką. Pavyzdžiui:
<prieš>
Kursai
-Visi kursai|/kursas/
-Kursų paieška|/course/search.php
-###
-DUK|https://example.org/faq
-Preguntas más frecuentes|https://example.org/pmf||es
Programėlė mobiliesiems|https://example.org/app|Atsisiųskite mūsų programą
</pre>';
$string['configcustomusermenuitems'] = 'Galite konfigūruoti naudotojo meniu turinį (išskyrus atsijungimo nuorodą, kuri pridedama automatiškai). Kiekviena eilutė yra atskirta vertikaliais brūkšneliais ir susideda iš 1) eilutės „langstringname, componentname“ forma arba kaip paprastas tekstas ir 2) URL. Skirstytuvus galima naudoti pridedant vieno ar daugiau # simbolių eilutę, kur pageidaujama.';
$string['configdbsessions'] = 'Jei šis parametras įjungtas, jis naudos duomenų bazę, kad saugotų informaciją apie dabartinius seansus. Tai ypač naudinga naudojant dideles / intensyviai veikiančias svetaines arba svetaines, įtaisytas serverių telkinyje. Daugelyje svetainių šį parametrą greičiausiai reikėtų palikti išjungtą, kad būtų naudojamas serverio diskas. Atkreipkite dėmesį, kad pakeitus šį parametrą dabar, bus atjungti visi esami naudotojai (įskaitant jus). Jei naudojate „MySQL“, įsitikinkite, kad max_allowed_packet, esantis „my.cnf“ (arba „my.ini“), yra mažiausiai 4 M.';
$string['configdebug'] = 'Jei įjungsite šį parametrą, PHP error_reporting bus padidintos, todėl bus išspausdinama daugiau įspėjimų. Tai naudinga tik programų kūrėjams.';
$string['configdebugdisplay'] = 'Nustačius klaidų ataskaitas kaip įjungtas, jis bus atliekamos HTML puslapyje. Tai praktiška, bet paprastai suskaito XHTML, JS, slapukų ir HTTP antraštes. Nustatykite ataskaitas kaip išjungtas, kad jos siųstų išvestį į jūsų serverių žurnalus ir leistų geriau derinti. PHP parametras error_log valdo, į kurį žurnalą siunčiama išvestis.';
$string['configdebugpageinfo'] = 'Įjunkite, jei norite, kad puslapio informacija būtų spausdinama poraštėje.';
$string['configdebugvalidators'] = 'Įjunkite, jei norite, kad puslapio poraštėje būtų saitų su išoriniais tikrintojų serveriais. Jums gali reikėti sukurti naują naudotoją <em>w3cvalidator</em> ir įjungti svečio prieigą. Šie pakeitimai gali leisti neįgaliotą prieigą prie serverio, neįjunkite jų produkcinėse svetainėse!';
$string['configdefaulthomepage'] = 'Į kurį puslapį naudotojai turi būti nukreipti prisijungus prie svetainės? Šis nustatymas taip pat nustato pirmąją nuorodą klasikinės temos naudotojams.';
$string['configdefaultrequestcategory'] = 'Kursai, kurių paprašė naudotojai, galintys prašyti naujų kursų sistemos kontekste, bus įtraukti į šią kategoriją, nebent naudotojai galės pasirinkti kitą kategoriją.';
$string['configdefaultrequestedcategory'] = 'Numatytoji kategorija, į kurią turi būti perkelti kursai, kurių užklausos buvo pateiktos (jei jie patvirtinti).';
$string['configdefaultuserroleid'] = 'Visiems prisijungusiems naudotojams bus suteiktos jūsų čia nurodyto vaidmens galimybės svetainės lygiu KARTU su bet kuriais kitais vaidmenimis, kurie galėjo būti suteikti tokiems naudotojams. Numatytasis vaidmuo yra Autentifikuotas naudotojas (arba Svečias senesnėse versijose). Atkreipkite dėmesį, kad šis vaidmuo nekonfliktuos su kitais naudotojų turimais vaidmenimis, jis tiesiog užtikrins, kad visi naudotojai turės galimybes, kurios nepriskiriamos kursų lygiu (pvz., skelbti tinklaraščio įrašus, tvarkyti savo kalendorių ir t. t.).';
$string['configdeleteincompleteusers'] = 'Praėjus šiam laikotarpiui, visos paskyros be vardo, pavardės arba el. Pašto adreso bus pašalintos.';
$string['configdeleteunconfirmed'] = 'Naudojant tam tikrus autentifikavimo metodus, pvz., el. paštu pagrįstą savarankišką registraciją, naudotojai turi patvirtinti savo paskyrą per tam tikrą laiką. Pasibaigus šiam laikotarpiui, visos senos nepatvirtintos paskyros ištrinamos.';
$string['configdenyemailaddresses'] = 'Norėdami uždrausti tam tikrų domenų el. pašto adresus, išvardykite šiuos domenus čia tokiu pat būdu. Visi kiti domenai bus leidžiami. Norėdami uždrausti subdomenus, įtraukite domeną, prieš jį nurodę ženklą „.“, pvz., <strong>hotmail.com yahoo.co.uk .live.com</strong>';
$string['configdisableuserimages'] = 'Išjunkite galimybę naudotojams keisti naudotojo profilio paveikslėlį.';
$string['configdisplayloginfailures'] = 'Pasirinktiems naudotojams rodys informaciją apie ankstesnius nesėkmingus prisijungimus.';
$string['configdndallowtextandlinks'] = 'Įgalinkite arba išjunkite failų arba saitų vilkimą į kurso puslapį, kartu su failų vilkimu. Atkreipkite dėmesį, kad teksto vilkimas Firefox arba tarp skirtingų naršyklių yra nepatikimas ir gali neįkelti duomenų arba gali įkelti pažeistą tekstą.';
$string['configdoclang'] = 'Ši kalba bus naudojama dokumentacijos lapų nuorodose.';
$string['configdocroot'] = 'Apibrėžia kelią į "Moodle Docs", kad būtų galima pateikti konkretaus konteksto dokumentaciją per nuorodas "Šio puslapio dokumentacija" kiekvieno puslapio poraštėje. Jei laukas paliekamas tuščias, nuorodos nebus rodomos.';
$string['configdoctonewwindow'] = 'Jei įjungta, nuorodos į „Moodle“ dokumentus bus rodomos naujame lange.';
$string['configduration_high'] = 'Ši vertė per didelė. Didžiausia vertė yra {$a}.';
$string['configduration_low'] = 'Ši vertė per maža. Mažiausia vertė yra {$a}.';
$string['configeditordictionary'] = 'Ši reikšmė bus naudojama, jei „Aspell“ nėra naudotojų kalbos žodyno.';
$string['configeditorfontlist'] = 'Pasirinkite šriftus, kurie turėtų būti rodomi rengyklės išplečiamajame sąraše.';
$string['configemailchangeconfirmation'] = 'Reikalauti patvirtinimo el. paštu žingsnio, kai savo profilyje naudotojai pakeičia el. pašto adresą.';
$string['configemaildkimselector'] = 'DKIM parinkiklis yra savavališkas ir jūsų DNS įrašas (-ai) turi atitikti tai.';
$string['configemailfromvia'] = 'Pridėkite informaciją siunčiamo el. pašto skiltyje „Nuo“. Tai informuoja gavėją, iš kur buvo gautas šis el. laiškas, taip pat padeda kovoti su gavėjais, netyčia atsakančiais į neatsakomus el. pašto adresus.';
$string['configemailheaders'] = 'Neapdorotos el. laiškų antraštės, kurias reikia pridėti pažodžiui prie visų siunčiamų el. laiškų.';
$string['configemailsubjectprefix'] = 'Tekstas turi būti įrašytas prieš visų siunčiamų laiškų temos eilutę.';
$string['configenableanalytics'] = 'Analitikos modeliai, tokie kaip "Besimokantieji, kuriems gresia išmetimas" ar "Numatytos artėjančios veiklos",  gali generuoti prognozes, siųsti įžvalgos pranešimus ir pasiūlyti kitus veiksmus, pvz., pranešimus naudotojams.';
$string['configenableblogs'] = 'Šis jungiklis suteikia visiems svetainės naudotojams savą tinklaraštį.';
$string['configenablecalendarexport'] = 'Įjungti eksportavimą į kalendorius arba jų prenumeravimą.';
$string['configenablecomments'] = 'Įjungti komentarus';
$string['configenablecourserequests'] = 'Jei įjungta, naudotojai, galintys prašyti naujų kursų (moodle/course:request), turės galimybę prašyti kursų. Ši funkcija neleidžiama jokiems numatytiesiems vaidmenims. Ji gali būti taikoma sistemos ar kategorijos kontekste.';
$string['configenablemobilewebservice'] = 'Įgalinti mobilias paslaugas oficialiai "Moodle" programėlei arba kitų programėlių užklausoms. Norėdami sužinoti daugiau, skaitykite {$a}';
$string['configenablerssfeeds'] = 'Jei įjungta, gausite RSS informacijos santraukas iš visos svetainės, pavyzdžiui, dienoraščių, forumų, duomenų bazių ir žodynų. Norėdami matyti visus pakeitimus, RSS informacijos santraukas turite įjungti ir atskiruose kurso veiklose.';
$string['configenablerssfeedsdisabled'] = 'Neprieinama, nes RSS informacijos santraukos išjungtos visoje svetainėje. Norėdami jas įjungti, eikite į Administratoriaus konfigūracija dalį Kintamųjų parametrai.';
$string['configenablerssfeedsdisabled2'] = 'RSS kanalai šiuo metu yra išjungti svetainės lygiu. Jie gali būti įjungti naudojant išplėstines svetainės administravimo funkcijas.';
$string['configenablestats'] = 'Jei čia pasirinksite Taip, „Moodle“ „Cron“ užduotis apdoros žurnalus ir surinks statistinės informacijos. Atsižvelgiant į jūsų svetainės srauto apimtį, tai gali šiek tiek užtrukti. Jei įjungsite, galėsite peržiūrėti kai kurias įdomias diagramas ir statistinius duomenis apie visus savo kursus arba apie visą svetainę.';
$string['configenabletrusttext'] = 'Numatyta, kad „Moodle“ visada atidžiai išvalo iš naudotojų gautus tekstus, kad pašalintų visus galimus blogus scenarijus, mediją ir t. t., kurie galėtų kelti grėsmę saugai. Patikimo turinio sistema yra būdas suteikti tam tikram patikimam naudotojui galimybę be jokių trukdžių įtraukti šias išplėstines funkcijas į turinį. Norėdami įjungti šią sistemą, pirmiausia turite įjungti šį parametrą, tada suteikti Patikimo turinio teises konkrečiam „Moodle“ vaidmeniui. Tokių naudotojų sukurti arba įkelti tekstai bus pažymėti kaip patikimi ir nebus valomi prieš juos rodant.';
$string['configenablewebservices'] = 'Interneto paslaugos suteikia galimybę kitoms sistemoms, pavyzdžiui, Moodle programėlei, prisijungti prie svetainės ir atlikti operacijas. Siekiant papildomo saugumo, nustatymas turėtų būti išjungtas, jei nenaudojate programos arba išorinio įrankio / paslaugos, kurią reikia integruoti naudojant žiniatinklio paslaugas.';
$string['configenablewsdocumentation'] = 'Įgalinkite automatinį žiniatinklio tarnybų dokumentacijos generavimą. Naudotojas gali prieiti prie savo dokumentacijos saugos raktų puslapyje {$a}. Jame rodoma tik įjungtų protokolų dokumentacija.';
$string['configerrorlevel'] = 'Pasirinkite norimų rodyti PHP įspėjimų skaičių. Dažniausiai geriausia rinktis įprastą skaičių.';
$string['configexportlookahead'] = 'Dienos, į kurias reikia žiūrėti eksportuojant';
$string['configexportlookback'] = 'Dienos, kurias reikia pažvelgti eksportuojant';
$string['configextendedusernamechars'] = 'Jei įjungta, naudotojų varduose gali būti bet kokių simbolių, išskyrus didžiąsias raides. Kitu atveju leidžiami tik raidiniai ir skaitmeniniai simboliai su mažosiomis raidėmis, pabraukimu (_), brūkšneliu (-), tašku (.) ir simboliu (@).';
$string['configextramemorylimit'] = 'Kai kuriems scenarijams, pvz., ieškos, atsarginių kopijų kūrimo / atkūrimo arba „Cron“, reikia daugiau atminties. Didesnėse svetainėse nustatykite didesnes reikšmes.';
$string['configfilterall'] = 'Filtruokite visas eilutes, įskaitant antraštes, pavadinimus, naršymo juostą ir t. t. Tai ypač naudinga naudojant kelių kalbų filtrą. Kitu atveju taip tiesiog papildomai apkraunama sistema, o naudos gausite labai mažai.';
$string['configfiltermatchoneperpage'] = 'Automatiniai susiejimo filtrai sugeneruos tik vieną pirmojo atitinkančio teksto egzemplioriaus, rasto baigtame puslapyje, saitą. Visų kitų bus nepaisoma.';
$string['configfiltermatchonepertext'] = 'Automatinio susiejimo filtrai sugeneruos tik vieną nuorodą pirmam atitinkamo teksto egzemplioriui, randamam kiekviename puslapio teksto elemente. Visi kiti ignoruojami. Šis nustatymas neturi įtakos, jei įjungta parinktis „Filtruoti atitiktį vieną kartą puslapyje“.';
$string['configfilternavigationwithsystemcontext'] = 'Įprastas filtravimo naudojimas yra susietas su kontekstu, kuriame jis naudojamas (pvz., kurso kontekstas), tačiau svetainės naršymui aiškiai viską filtravus pagal svetainės kontekstą, naudojant „turinio ir antraščių“ filtravimą galima pagerinti našumą.';
$string['configfilteruploadedfiles'] = 'Apdoroti visus įkeltus HTML ir tekstinius failus  su filtrais prieš juos vaizduojant, tik įkelti HTML failai arba išvis jokių.';
$string['configforcelogin'] = 'Paprastai žmonės gali skaityti svetainės pagrindinį puslapį ir kursų sąrašus (bet ne kursus) neprisijungę prie svetainės. Jei norite priversti žmones prisijungti prie svetainės, turėtumėte įjungti šį nustatymą.';
$string['configforceloginforprofiles'] = 'Šis nustatymas verčia žmones prisijungti tikra (ne svečio) paskyra prieš peržiūrint bet kurio naudotojo profilį. Jei išjungėte šį nustatymą, galite pastebėti, kad kai kurie naudotojai savo profiliuose skelbia reklamą (spam) ar kitą netinkamą turinį, kuris vėliau bus matomas visam pasauliui.';
$string['configfrontpage'] = 'Aukščiau pasirinkti elementai bus rodomi svetainės pagrindiniame puslapyje.';
$string['configfrontpagecourselimit'] = 'Maksimalus kursų skaičius';
$string['configfrontpagecourselimithelp'] = 'Didžiausias kursų skaičius, kuris turi būti rodomas svetainės pagrindiniame puslapyje, kursų sąrašuose.';
$string['configfrontpageloggedin'] = 'Aukščiau pasirinkti elementai bus rodomi svetainės pagrindiniame puslapyje, kai naudotojas bus prisijungęs.';
$string['configfullnamedisplay'] = 'Tai apibrėžia, kaip rodomi vardai, kai jie rodomi pilni. Numatytoji reikšmė „language“ dabartiniame kalbos pakete palieka eilutę „fullnamedisplay“. Kai kurių kalbų vardų rodymo taisyklės skiriasi.

Daugumoje vienakalbių svetainių veiksmingiausias nustatymas yra „firstname lastname“, tačiau galite pasirinkti slėpti pavardes. Vietos žymos, kurias galima naudoti: firstname, lastname, firstnamephonetic, lastnamephonetic, middlename, ir alternatename.';
$string['configgeoipfile'] = 'GeoLite2 City dvejetainių duomenų failo vieta. Šis failas nėra Moodle platinimo dalis ir jį reikia gauti atskirai iš <a href="https://www.maxmind.com/">MaxMind</a>. Galite nusipirkti komercinę versiją arba naudoti nemokamą versiją. Turėsite užsiregistruoti, kad atsisiųstumėte miesto duomenų bazės failą. Tai galite padaryti adresu  <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/" >https://dev.maxmind.com/geoip/geoip2/geolite2/</a>. Užsiregistravę ir atsisiuntę failą, išskleiskite jį į savo serverio katalogą „{$a}“.';
$string['configgetremoteaddrconf'] = 'Jei jūsų serveris yra atvirkštiniame tarpiniame serveryje, galite naudoti šį parametrą, kad nurodytumėte, kurios HTTP antraštės yra tinkamos nuotolinio IP adresui talpinti. Antraštės skaitomos nuosekliai, naudojant pirmąją galimą.';
$string['configgradebookroles'] = 'Šis parametras leidžia jums valdyti, kas bus rodoma įvertinimų knygelėje. Naudotojai turi turėti bent vieną iš šių kursų vaidmenų, kad būtų rodomi to kurso įvertinimų knygelėje.';
$string['configgradeexport'] = 'Pasirinkite, kuris iš įvertinimų knygelės eksportavimo formatų yra pagrindinis įvertinimų eksportavimo būdas. Tada pasirinkti papildiniai kiekvienam įvertinimui nustatys ir naudos lauką „Paskutinis eksportuotas“. Pavyzdžiui, eksportuoti įrašai gali būti identifikuojami kaip Nauji arba Atnaujinti. Jei nesate tikri, palikite visus žymės langelius nepažymėtus.';
$string['configgradeexportdefault'] = 'Pasirinkite, kuris įvertinimų knygelės eksporto formatas yra numatytasis įvertinimų eksportavimo būdas.';
$string['confighiddenuserfields'] = 'Pasirinkite, kuriuos naudotojo informacijos laukus norite slėpti nuo kitų naudotojų (ne kursų dėstytojų / administratorių). Taip padidinsite besimokančiųjų privatumą. Nuspauskite klavišą CTRL, kad pasirinktumėte kelis laukus.';
$string['configidnumber'] = 'Ši parinktis nurodo, ar (a) naudotojų išvis nebus prašoma nurodyti ID numerio, (b) naudotojų bus prašoma nurodyti ID numerį, bet jie galės palikti lauką tuščią arba (c) naudotojų bus prašoma nurodyti ID numerį ir jie negalės palikti lauko tuščio. Jei naudotojo ID numeris suteikiamas, jis rodomas naudotojo profilyje.';
$string['configintro'] = 'Šiame puslapyje galite nurodyti konfigūracijos kintamųjų, padedančių „Moodle“ tinkamai veikti jūsų serveryje, skaičių. Per daug dėl jų nesijaudinkite – dažniausiai puikiai tiks numatytosios reikšmės, be to, vėliau galėsite bet kada grįžti į šį puslapį ir pakeisti parametrus.';
$string['configintroadmin'] = 'Šiame puslapyje turėtumėte konfigūruoti savo pagrindinę administratoriaus paskyrą, kuri galės valdyti visą svetainę. Įsitikinkite, kad sukūrėte patikimą naudotojo vardą bei slaptažodį ir nurodėte leistiną el. pašto adresą. Vėliau galėsite sukurti daugiau administratoriaus paskyrų.';
$string['configintrosite'] = 'Šiame puslapyje galite konfigūruoti šios naujos svetainės pagrindinį puslapį ir pavadinimą. Vėliau galėsite čia grįžti ir bet kada pakeisti šiuos nustatymus naudodami meniu Administravimas.';
$string['configiplookup'] = 'Kai spustelite IP adresą (pvz., 34.12.222.93), pvz., rodomą žurnaluose, jums rodomas žemėlapis ir tiksliausias spėjimas, kur yra šis IP. Yra įvairių papildinių, iš kurių galite rinktis. Kiekvienas jų turi savo pranašumų ir trūkumų.';
$string['configkeeptagnamecase'] = 'Pažymėkite, jei norite, kad žymių pavadinimų registras išliktų toks, kokį įvedė juos sukūrę naudotojai';
$string['configlang'] = 'Pasirinkite numatytąją visos svetainės kalbą. Naudotojai gali keisti šį parametrą naudodami kalbos meniu arba parametrą, esantį jų asmeniniame profilyje.';
$string['configlanglist'] = 'Jei paliksite tuščią, kalbos meniu bus rodomos visos svetainėje įdiegtos kalbos. Arba kalbos meniu galima sutrumpinti įvedant kableliais atskirtų kalbų kodų sąrašą, pvz. en, de, fr. Jei pageidaujama, gali būti nurodytas kitoks kalbos pavadinimas nei kalbos paketo pavadinimas, naudojant formatą: kalbos kodas|kalbos pavadinimas pvz. en_kids|English,de_kids|Deutsch.';
$string['configlangmenu'] = 'Pasirinkite, ar norite rodyti bendrosios paskirties kalbos meniu pagrindiniame puslapyje, prisijungimo puslapyje ir t. t. Tai neturės įtakos naudotojo galimybei nustatyti norimą kalbą savo profilyje.';
$string['configlangstringcache'] = 'Talpina visas kalbos eilutes į sukompiliuotus failus duomenų kataloge. Jei verčiate „Moodle“ arba keičiate „Moodle“ šaltinio kodo eilutes, galite išjungti šį parametrą. Kitu atveju palikite jį įjungtą, kad našumas būtų geresnis.';
$string['configlatinexcelexport'] = 'Pasirinkite „Excel“ eksportavimo kodavimą.';
$string['configlocale'] = 'Pasirinkite visos svetainės lokalę, kad būtų pakeistas visų kalbos paketų datų formatas ir kalba (tai neturės įtakos kalendoriaus dienų pavadinimams). Turėsite įdiegti šiuos lokalės duomenis savo operacinėje sistemoj (pvz., jei naudojate „Linux“ – en_US.UTF-8 arba es_ES.UTF-8). Daugeliu atveju šis laukas turėtų likti tuščias.';
$string['configlockrequestcategory'] = 'Jei įjungta, naudotojai, galintys pateikti užklausą dėl naujų kursų sistemos kontekste, negalės pasirinkti kategorijos naujo kurso užklausos formoje. Alternatyvus būdas apriboti naudotojų prašymus dėl naujo kurso tik vienoje kategorijoje yra pritaikyti galimybę prašyti naujų kursų kategorijos kontekste.';
$string['configloglifetime'] = 'Nurodo, kiek laiko turėtų būti saugomi naudotojo veiklos žurnalai. Žurnalai, senesni nei nurodytas laikotarpis, automatiškai panaikinami. Geriausia saugoti žurnalus kuo ilgiau tuo atveju, jei jų prireiktų, tačiau jei jūsų serveris ypač užimtas ir kyla našumo problemų, galite sutrumpinti žurnalo saugojimo laikotarpį. Nerekomenduojama nurodyti mažesnės nei 30 reikšmės, nes gali netinkamai veikti statistiniai duomenys.';
$string['configlookahead'] = 'Būsimų dienų skaičius';
$string['configmailnewline'] = 'Naujos eilutės simboliai naudojami laiško žinutėje. CRLF yra būtinas pagal RFC 822bis. Kaikurie pašto serveriai automatiškai konvertuoja iš LF į CRLF, kiti pašto serveriai klaidingai konvertuoja iš CRLF į CRCRLF, taip pat kiti atmeta laiškus tik su LF(pvz.: qmail). Pabandykite pakeisti šiuos nustatymus jei turite problemų su nepristatytai laiškais arba dvigubomis naujomis eilutėmis.';
$string['configmaxbytes'] = 'Tai nurodo didžiausią į svetainę įkeltų failų dydį. Šį nustatymą riboja PHP nustatymai post_max_size ir upload_max_filesize, taip pat Apache nustatymas LimitRequestBody. Savo ruožtu maxbytes riboja dydžių diapazoną, kurį galima pasirinkti kurso ar veiklos lygiu. Jei pasirenkamas „Svetainės įkėlimo limitas“, bus naudojamas didžiausias serverio leidžiamas dydis.';
$string['configmaxconsecutiveidentchars'] = 'Slaptažodyje negali būti daugiau nuoseklių identiškų simbolių, nei nurodo šis skaičius. Naudokite 0, kad išjungtumėte šį tikrinimą.';
$string['configmaxeditingtime'] = 'Nurodo, kiek laiko asmenys turės skelbimams, žodyno komentarams ir t. t. redaguoti. Paprastai geriausia nurodyti 30 min.';
$string['configmaxevents'] = 'Būsimų įvykių skaičius';
$string['configmaxusersperpage'] = 'Didžiausias rodomas naudotojų skaičius pasirenkant naudotojus kurse, grupėje, junginyje, žiniatinklio paslaugose ir kt.';
$string['configmessaging'] = 'Jei įjungta, naudotojai gali siųsti žinutes kitiems svetainės naudotojams.';
$string['configmessagingallowemailoverride'] = 'Leisti naudotojams gauti el.pašto žinučių pranešimus į kitą el.pašto adresą nei nurodytas profilyje';
$string['configmessagingallusers'] = 'Jei įjungta, naudotojai gali peržiūrėti visų svetainės naudotojų sąrašą, kai nori kam nors siųsti žinutę, o jų pranešimų nuostatose yra galimybė priimti pranešimus iš bet kurio svetainės lankytojo. Jei išjungta, naudotojai gali peržiūrėti tik savo kursų naudotojų sąrašą, o pranešimų nuostatose jie turi tik dvi parinktis – priimti pranešimus tik iš savo kontaktų arba jų kontaktų ir bet kurio kurso dalyvio.';
$string['configmessagingdefaultpressenter'] = 'Ar naudotojų susirašinėjimo nustatymuose pagal numatytuosius nustatymus įjungta „Siųsti naudojant klavišą Enter“.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Perskaitytus ir neskaitytus pranešimus galima ištrinti, kad sutaupyti vietos. Per kiek laiko po pranešimo sukūrimo galima jį ištrinti?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Perskaitytus pranešimus galima panaikinti, kad būtų taupoma vieta. Po kiek laiko galima panaikinti perskaitytą pranešimą?';
$string['configminpassworddigits'] = 'Slaptažodyje turi būti mažiausiai tiek skaitmenų.';
$string['configminpasswordlength'] = 'Slaptažodį turi sudaryti mažiausiai tiek simbolių.';
$string['configminpasswordlower'] = 'Slaptažodyje turi būti mažiausiai tiek mažųjų raidžių.';
$string['configminpasswordnonalphanum'] = 'Slaptažodyje turi būti mažiausiai tiek ne raidinių-skaitinių simbolių.';
$string['configminpasswordupper'] = 'Slaptažodyje turi būti mažiausiai tiek didžiųjų raidžių.';
$string['configmypagelocked'] = 'Šis parametras draudžia redaguoti numatytąjį puslapį neturint administratoriaus teisių';
$string['confignavcourselimit'] = 'Ribojamas kursų skaičius rodomas naudotojui naršymo metu.';
$string['confignavshowallcourses'] = 'Šis nustatymas nustato, ar naudotojai, užsiregistravę į kursus, naršymo juostoje gali matyti kursus (visų kursų sąrašą), be „Mano kursų“ (kursų, kuriuose jie yra užsiregistravę), sąrašo.';
$string['confignavshowcategories'] = 'Rodyti kursų kategorijas naršymo juostoje ir naršymo blokuose. Tai netaikoma kursams, kuriuose naudotojas šuo metu yra įsiregistravęs; jie vis tiek bus išvardyti sąraše „Mano kursai“ be kategorijų.';
$string['confignoreplyaddress'] = 'El. laiškai kartais yra siunčiami naudotojo naudai. El. pašto adresas jūs nusakote bus naudojamas kaip "Iš kur" adresas tuo atveju kai gavėjai neturi galimybės tiesiogiai atrašyti( kai naudotojas pasirenka laikyti adresą nematomą).';
$string['confignotifyloginfailures'] = 'Siųsti pranešimus apie prisijungimo nesėkmes šiems pasirinktiems naudotojams. Tam reikia įjungti vidinę žurnalų saugyklą (pvz., standartinę žurnalų saugyklą).';
$string['confignotifyloginthreshold'] = 'Jei pranešimai apie nesėkmingus prisijungimus yra aktyvūs, apie kiek nesėkmingų vieno naudotojo arba IP adreso bandymų prisijungti turėtų būti pranešama?';
$string['confignotloggedinroleid'] = 'Naudotojai, neprisijungę prie šios svetainės, bus traktuojami kaip gavę šį vaidmenį svetainės kontekste. Svečias yra beveik visada čia tinkamiausias vaidmuo, bet taip pat galite kurti vaidmenis, kurie yra daugiau arba mažiau apriboti. Norint kurti skelbimus vis tiek reikės, kad naudotojas tinkamai prisijungtų.';
$string['configopentowebcrawlers'] = 'Jei įjungsite šį parametrą, „Google“ bus leidžiama prieiti prie jūsų svetainės kaip svečiui. Be to, žmonės, kurie ras jūsų svetainę naudodami „Google“ iešką, bus automatiškai prijungti kaip svečiai. Atkreipkite dėmesį, kad tai suteiks skaidrią prieigą tik prie kursų, kur jau leidžiama svečių prieiga.';
$string['configoverride'] = 'Apibrėžta faile config.php';
$string['configpasswordpolicy'] = 'Jei įjungta, naudotojų slaptažodžiai bus tikrinami pagal reikalavimus slaptažodžiui, kaip nurodyta toliau pateiktuose nustatymuose. Reikalavimų slaptažodžiui įjungimas neturės įtakos esamiems naudotojams, kol jie nenuspręs arba nebus paprašyta pakeisti savo slaptažodį arba kol nebus įjungtas nustatymas „Tikrinti slaptažodį prisijungimo metu".';
$string['configpasswordpolicycheckonlogin'] = 'Jei įjungta, naudotojų slaptažodžiai bus tikrinami pagal reikalavimus slaptažodžiui kiekvieną kartą naudotojui jungiantis. Jei patikrinti nepavyks, prieš tęsdamas naudotojas turės pakeisti slaptažodį.
Šį nustatymą naudinga įjungti atnaujinus reikalavimus slaptažodžui.';
$string['configpasswordresettime'] = 'Nurodoma, kiek laiko žmonės turi, kad patvirtintų slaptažodžio nustatymo iš naujo užklausą, kol jos galiojimo laikas baigiasi. Paprastai 30 minučių yra gera vertė.';
$string['configpathtodu'] = 'Kelias į „du“. Greičiausiai kažkas panašaus į /usr/bin/du. Jei įvesite tai, puslapiai, kuriuose rodomas katalogų turinys, veiks daug greičiau, kai bus naudojami katalogai su daug failų.';
$string['configpathtophp'] = 'Kelias į PHP CLI. Tikriausiai kažkas panašaus į /usr/bin/php. Jei įvesite tai, cron scenarijus bus galima vykdyti iš administratoriaus interneto sąsajos.';
$string['configperfdebug'] = 'Jei įjungsite šį parametrą, našumo informacija bus spausdinama standartinės temos poraštėje';
$string['configprofileroles'] = 'Vaidmenys, išvardyti naudotojų profiliuose ir dalyvių puslapyje.';
$string['configprofilesforenrolledusersonly'] = 'Norint išvengti pašto šiukšlintojų piktnaudžiavimo, dar neįregistruotų į jokius kursus naudotojų profilių aprašai slepiami. Nauji naudotojai turi įsiregistruoti į mažiausiai vienus kursus, kad galėtų įtraukti profilio aprašą.';
$string['configprotectusernames'] = 'Jei įjungta, užmiršto slaptažodžio forma nerodys jokių užuominų, leidžiančių atspėti paskyros naudotojo vardus ar el. pašto adresus.';
$string['configproxybypass'] = 'Sąrašas (dalinių) prieglobos vardų arba IP adresų, kurie turėtų apeiti tarpinį serverį. Kiekvieną elementą atskirkite kableliais be tarpų. Pavyzdžiui: 192.168.0.0.0/16,*.mydomain.com.';
$string['configproxyfixunsafe_help'] = 'Taip bandoma ištaisyti vidinius kreipimusis, kurie nepraeina per tarpinį serverį, pridedant MoodleBot naudotojo agentą ir naudojant tarpinį serverį.';
$string['configproxyhost'] = 'Jei šis <b>serveris</b> turi naudoti tarpinio serverio kompiuterį, (pvz., užkardą), kad prieitų prie interneto, čia nurodykite tarpinio serverio pagrindinio kompiuterio pavadinimą. Kitu atveju palikite jį tuščią.';
$string['configproxylogunsafe_help'] = 'Taip bandoma registruoti vidinius kreipimusis, kurie nevyksta per tarpinį serverį ir turėtų.';
$string['configproxypassword'] = 'Norint prieiti prie interneto naudojant tarpinį serverį būtinas slaptažodis, jei jo reikalaujama. Laukas tuščias, jei slaptažodžio nereikalaujama (būtinas PHP „cURL“ plėtinys).';
$string['configproxyport'] = 'Jei šiam serveriui būtinas tarpinio serverio kompiuteris, čia nurodykite tarpinio serverio prievadą.';
$string['configproxytype'] = 'Žiniatinklio tarpinio serverio tipas (SOCKS5 palaikyti būtinas PHP5 ir „cURL“ plėtinys).';
$string['configproxyuser'] = 'Norint prieiti prie interneto naudojant tarpinį serverį būtinas naudotojo vardas, jei jo reikalaujama. Laukas tuščias, jei naudotojo vardo nereikalaujama (būtinas PHP „cURL“ plėtinys).';
$string['configrecaptchaprivatekey'] = 'Simbolių eilutė (slaptasis raktas), naudojama norint užmegzti ryšį tarp jūsų „Moodle“ serverio ir „recaptcha“ serverio. „ReCAPTCHA“ raktus galima gauti iš <a target="_blank" href="https://www.google.com/recaptcha"> „Google reCAPTCHA“ </a>.';
$string['configrecaptchapublickey'] = 'Simbolių eilutė (svetainės raktas), naudojama norint rodyti reCAPTCHA elementą registracijos formoje ir svetainės palaikymo formoje. ReCAPTCHA raktus galima gauti iš <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestedstudentname'] = 'Besimokantįjį reiškiantis žodis, naudojamas kursuose, kurių užklausos pateiktos';
$string['configrequestedstudentsname'] = 'Besimokančiuojus reiškiantis žodis, naudojamas kursuose, kurių užklausos pateiktos';
$string['configrequestedteachername'] = 'Dėstytoją reiškiantis žodis, naudojamas kursuose, kurių užklausos pateiktos';
$string['configrequestedteachersname'] = 'Dėstytojus reiškiantis žodis, naudojamas kursuose, kurių užklausos pateiktos';
$string['configreverseproxyignore'] = 'Jei jūsų serveris yra už kelių atvirkštinių tarpinių serverių, kurie pridedami prie antraštės X-Forwarded-For, tada nurodykite kableliais atskirtų IP adresų arba atvirkštinių tarpinių serverių potinklių sąrašą, kurių reikia nepaisyti, kad rastumėte teisingą naudotojo IP adresą.';
$string['configsectioninterface'] = 'Sąsaja';
$string['configsectionmail'] = 'Paštas';
$string['configsectionmaintenance'] = 'Palaikymas';
$string['configsectionmisc'] = 'Kita';
$string['configsectionoperatingsystem'] = 'Operacinė sistema';
$string['configsectionpermissions'] = 'Teisės';
$string['configsectionrequestedcourse'] = 'Kurso sukūrimo prašymai';
$string['configsectionsecurity'] = 'Sauga';
$string['configsectionstats'] = 'Statistika';
$string['configsectionuser'] = 'Naudotojas';
$string['configsecureforms'] = '„Moodle“ gali naudoti papildomą saugos lygį priimdama duomenis iš žiniatinklio formų. Jei jis įjungtas, naršyklės kintamasis HTTP_REFERER tikrinamas lyginant su dabartiniu formos adresu. Ypač retais atvejais tai gali sukelti problemų, jei naudotojas naudoja užkardą (pvz., „Zonealarm“), sukonfigūruotą pašalinti HTTP_REFERER iš žiniatinklio srauto. Požymiai – „užstrigimas“ formoje. Jei jūsų naudotojams kyla problemų prisijungimo puslapyje, galite išjungti šį parametrą, nors tai padarius jūsų svetainė gali tapti atviresnė agresyvioms slaptažodžių atakoms. Jei abejojate, palikite parametro reikšmę Taip.';
$string['configservicespage'] = 'Įveskite paslaugų ir palaikymo puslapio URL arba palikite tuščią, kad susietumėte su Moodle paslaugų adresu moodle.com. Nuoroda rodoma tik administratoriams.';
$string['configsessioncookie'] = 'Šis parametras tinkina slapuko, naudojamo „Moodle“ seansuose, pavadinimą. Jis pasirinktinis ir naudingas tik norint nesupainioti slapukų, kai toje pačioje žiniatinklio svetainėje veikia daugiau nei viena „Moodle“ kopija.';
$string['configsessioncookiedomain'] = 'Šis parametras leidžia jums keisti domeną, iš kurio gaunami „Moodle“ slapukai. Tai naudinga tinkinant „Moodle“ (pvz, autentifikavimo arba įregistravimo papildinius), kai „Moodle“ seanso informaciją reikia naudoti bendrai su žiniatinklio taikomąja programa kitame subdomene. <strong>ĮSPĖJIMAS: primygtinai rekomenduojama palikti numatytąją šio parametro reikšmę (tuščia), nes klaidinga reikšmė uždraus visus prisijungimus prie svetainės.</strong>';
$string['configsessioncookiepath'] = 'Jei reikia keisti, kur naršyklės siunčia „Moodle“ slapukus, galite keisti šį parametrą ir nurodyti savo žiniatinklio svetainės subkatalogą. Kitu atveju galite palikti numatytąjį simbolį /.';
$string['configsessiontimeout'] = 'Jei prie šios svetainės prisijungę žmonės ilgai neatlieka jokių veiksmų (neįkelia puslapių), jie automatiškai atjungiami (baigiamas jų seansas. Šis kintamasis nurodo, kokio ilgumo turėtų būti toks neveiklumo laikotarpis.';
$string['configsessiontimeoutwarning'] = 'Jei žmonės, prisijungę prie šios svetainės, ilgą laiką neveikia (nekrauna puslapių), jie yra įspėjami, kad jų sesija netrukus baigsis. Šis kintamasis nurodo, kiek laiko turėtų trukti.';
$string['configsessiontimeoutwarningcheck'] = 'Seanso skirtojo laiko įspėjimas turi būti mažesnis nei seanso skirtasis laikas';
$string['configshowcommentscount'] = 'Rodyti komentarų skaičių. Rodant komentarų saitą reikės atlikti dar vieną užklausą';
$string['configshowicalsource'] = 'Rodyti iCal įvykių šaltinio informaciją';
$string['configshowsiteparticipantslist'] = 'Visi šie svetainės besimokantieji ir dėstytojai bus išvardyti svetainės dalyvių sąraše. Kam bus leidžiama peržiūrėti šį dalyvių sąrašą?';
$string['configsitedefaultlicense'] = 'Numatytoji svetainės licencija';
$string['configsitedefaultlicensehelp'] = 'Numatytoji licencija turiniui publikuoti šioje svetainėje';
$string['configsitemailcharset'] = 'Visi el. laiškai sugeneruoti jūsų svetainės bus išsiųsti simbolių rinkiniu nusakytu čia. Be to, kiekvienas naudotojas individualiai gali nustatyti jei kitas nustatymas yra įjungtas';
$string['configsitemaxcategorydepth'] = 'Didžiausias kategorijos gylis';
$string['configsitemaxcategorydepthhelp'] = 'Tai nurodo maksimalų antrinių kategorijų gylį, išplečiamą rodant kategorijas arba kombinuotąjį sąrašą. Gilesnio lygio kategorijos bus rodomos kaip nuorodos ir naudotojas galės jas išplėsti su AJAX užklausa.';
$string['configslasharguments'] = 'Norint, kad SCORM paketai ir kelių failų ištekliai būtų rodomi teisingai, reikalingi „Slash argumentai“ (naudojant <em>PATH_INFO</em>). Jei jūsų žiniatinklio serveris nepalaiko „pasvirojo brūkšnio argumentų“ ir negalite jo sukonfigūruoti, šį nustatymą galima išjungti, tačiau dėl to viskas neveiks.<br />Pastaba: „Pasvirojo brūkšnio argumentai“ bus naudojami privalomai būsimose Moodle versijose.';
$string['configsmtpauthtype'] = 'Tai nustato autentifikavimo tipą, naudojamą SMTP serveryje.';
$string['configsmtphosts'] = 'Duokite pilną vardą vieno ar kelių vietinių SMTP serverių, kuriuos Moodle turėtų naudoti siųsti paštui(pvz.: „mail.a.com“ arba „mail.a.com;mail.b.com“). Nusakyti ne numatytą prievadą (kitą nei 25), galite naudoti [server]:[port] sintaksė (pvz „mail.a.com:587“. Jei paliksite tuščią, Moodle naudos numatytą PHP  siuntimo metodą.';
$string['configsmtpmaxbulk'] = 'Didžiausias galimas kiekis žinučių kurias galima išsiųsti per SMTP sesiją. Grupuotos žinutės gali paspartinti laiškų siuntimą. Reikšmės mažesnės už 2 priverčia sukurti naują SMTP sesiją kiekvienam laiškui.';
$string['configsmtpoauthservice'] = 'Pasirinkite „OAuth 2“ paslaugą, sukonfigūruotą bendrauti su SMTP serveriu. Jei paslauga dar neegzistuoja, turėsite ją sukurti. Atminkite, kad SMTP autentifikavimo tipą turite nustatyti į XOAUTH2.';
$string['configsmtpsecure'] = 'Jei SMTP serveriui reikalingas saugus ryšys, nurodykite teisingą protokolo tipą.';
$string['configsmtpuser'] = 'Jeigu jūs nusakėte SMTP serverį aukščiau, ir jis reikalauja patvirtinimo, tada įveskite naudotojo vardą ir slaptažodį čia.';
$string['configstartwday'] = 'Savaitės pradžia';
$string['configstatsfirstrun'] = 'Šis parametras nurodo, kiek išsamiai turėtų būtų apdorojami žurnalai <b>pirmą kartą</b>, kai „Cron“ užduotis nori apdoroti statistinius duomenis. Jei jūsų srautas didelis ir naudojate bendrą išteklių nuomą, greičiausiai nevertėtų per daug gilintis, nes apdorojimas gali trukti ilgai ir sunaudoti daug išteklių (atkreipkite dėmesį, kad šio parametro 1 mėnuo yra 28 dienos. Generuojamose diagramose ir ataskaitose 1 mėnuo yra 1 kalendorinis mėnuo.)';
$string['configstatsmaxruntime'] = 'Statistinių duomenų apdorojimas gali būti gana intensyvus, todėl naudokite šio ir paskesnio lauko derinį, kad nurodytumėte, kada apdorojimas bus paleidžiamas ir kiek truks.';
$string['configstatsmaxruntime2'] = 'Statistinių duomenų apdorojimas gali būti gana intensyvus. Nurodykite maksimalų leistiną laiką vienos dienos statistiniams duomenims rinkti. Maksimalus vieno „Cron“ vykdymo apdorojamų dienų skaičius yra 31.';
$string['configstatsmaxruntime3'] = 'Tai nurodo maksimalų vienos dienos statistikos skaičiavimo laiką, turint omenyje, kad statistikos apdorojimas gali labai apkrauti serverį. Žemiau galima nurodyti maksimalų dienų, apdorojamų vienu kronu, skaičių.';
$string['configstatsruntimedays'] = 'Tai nurodo maksimalų kiekvieno statistinių duomenų vykdymo apdorojamų dienų skaičių. Kai statistiniai duomenys atnaujinti, bus apdorojama tik viena diena, todėl atsižvelgdami į savo serverio apkrovą koreguokite šią reikšmę ir sumažinkite ją, jei „Cron“ reikia vykdyti trumpiau.';
$string['configstatsruntimestart'] = 'Kada turėtų būti paleistas cronjob, kurio metu apdorojama statistika? Jei viename serveryje yra kelios Moodle svetainės, rekomenduojama nurodyti skirtingą laiką.';
$string['configstatsuserthreshold'] = 'Šis parametras nurodo minimalų į kursą įsiregistravusių naudotojų skaičių, įtrauktiną į statistinių duomenų skaičiavimą.';
$string['configstrictformsrequired'] = 'Jei įgalinta, naudotojams draudžiama padėti tarpą arba naują eilutę tik reikalaujamose laukuose formose.';
$string['configstripalltitletags'] = 'Panaikinkite šio parametro žymėjimą, kad leistumėte HTML žymes veiklos ir resursų pavadinimuose.';
$string['configsupportavailability'] = 'Nustato, kas turi prieigą prie svetainės palaikymo iš poraštės.';
$string['configsupportemail'] = 'Jei šioje svetainėje sukonfigūruotas SMTP, o palaikymo puslapis nenustatytas, šiuo el. pašto adresu bus gauti pranešimai, pateikti naudojant palaikymo formą. Jei siuntimas nepavyks, el. pašto adresas bus rodomas prisijungusiems naudotojams.';
$string['configsupportname'] = 'Asmens ar kito subjekto, teikiančio pagalbą per paramos formą arba pagalbos puslapį, vardas.';
$string['configsupportpage'] = 'Įveskite palaikymo puslapio URL arba palikite tuščią, kad susietumėte su kontaktų forma. Nuoroda rodoma svetainės poraštėje.';
$string['configtempdatafoldercleanup'] = 'Pašalinti laikinus duomenų failus iš duomenų aplanko, kuris yra senesnis nei pasirinktas laikas.';
$string['configthemedesignermode'] = 'Paprastai viso temos vaizdai ir stilių lapai talpinami naršyklės ir serveryje labai ilgai, kad būtų galima užtikrinti našumą. Jei kuriate temas arba kuriate kodą, greičiausiai norėsite įjungti šį režimą, kad jums nebūtų teikiamos talpinamos versijos. Įspėjimas: jūsų svetainės veikimas taps lėtesnis visiems naudotojams! Taip pat galite iš naujo rankiniu būdu nustatyti temų talpyklas temų pasirinkimo puslapyje.';
$string['configthemelist'] = 'Palikite tuščią, kad leistumėte naudoti bet kurią leistiną temą. Jei norite sutrumpinti temų meniu, čia galite nurodyto kableliais atskirtų pavadinimų sąrašą (nenaudokite tarpų!). Pavyzdžiui: standard,orangewhite.';
$string['configtimezone'] = 'Tai numatytoji datų rodymo laiko juosta – kiekvienas naudotojas gali nepaisyti šio nustatymo savo profilyje. Šioje laiko juostoje nurodytos Cron užduotys ir kiti serverio nustatymai. Turėtumėte pakeisti nustatymą, jei jis rodomas kaip „Netinkama laiko juosta“';
$string['configuseblogassociations'] = 'Ar naudotojai turėtų galėti tvarkyti savo tinklaraštį susiedami įrašus su kursais ir kursų moduliais?';
$string['configusesitenameforsitepages'] = 'Jei įjungta, trumpasis svetainės pavadinimas bus naudojamas svetainės puslapių mazgui naršymo lange, o ne eilutėje „Svetainės puslapiai“.';
$string['configusetags'] = 'Ar žymių funkcijos turėtų būti įjungtos visoje svetainėje?';
$string['configvariables'] = 'Kintamieji';
$string['configverifychangedemail'] = 'Įjungiamas pakeistų el. pašto adresų tikrinimas naudojant leidžiamų ir draudžiamų el. pašto domenų parametrus. Jei šis parametras išjungtas, domenus reikalaujama taikyti tik kuriant naujus naudotojus.';
$string['configvisiblecourses'] = 'Įprastai rodyti kursus paslėptose kategorijose';
$string['configwarning'] = 'Būkite atsargūs modifikuodami šiuos parametrus – dėl neįprastų reikšmių gali iškilti problemų.';
$string['configyuicomboloading'] = 'Ši parinktis įjungia YUI bibliotekų sujungtų failų įkėlimo optimizavimą. Šį parametrą reikėtų įjungti produkcinėse svetainėse norint pagerinti našumą.';
$string['confirmation'] = 'Patvirtinimas';
$string['confirmationpending'] = 'Laukiama patvirtinimo';
$string['confirmcontextlock'] = '{$a->contextname} šiuo metu yra užšaldytas. Užšaldymas leis jį tik skaityti ir neleisti naudotojams atlikti pakeitimų. Ar tikrai norite tęsti?';
$string['confirmcontextunlock'] = '{$a->contextname} šiuo metu yra užšaldytas. Užšaldymo atšaukimas leis naudotojams atlikti pakeitimus. Ar tikrai norite tęsti?';
$string['confirmdeletecomments'] = 'Ar tikrai norite ištrinti pasirinktą (-us) komentarą (-us)?';
$string['confirmed'] = 'Patvirtinta';
$string['contactsitesupport'] = 'Susisiekti su svetainės palaikymo komanda';
$string['contenttypeuninstalling'] = 'Yra {$a->count} turinio, kurį palaiko {$a->type}. Jis bus ištrintas. Ar tikrai norite tęsti?';
$string['contextlockappliestoadmin'] = 'Konteksto įšaldymas taikomas administratoriams';
$string['contextlockappliestoadmin_desc'] = 'Jei išjungta, administratoriai turi rašymo prieigą prie bet kokio užšaldyto konteksto.';
$string['contextlocking'] = 'Konteksto užšaldymas';
$string['contextlocking_desc'] = 'Šis nustatymas leidžia nustatyti tik skaitymo prieigą pasirinktoms kategorijoms, kursams, veikloms ar blokams.';
$string['cookiesecure'] = 'Tik saugūs slapukai';
$string['country'] = 'Numatytoji šalis';
$string['course_customfield'] = 'Kursų pasirinktiniai laukai';
$string['coursecolor'] = 'Spalva {$a}';
$string['coursecolorheading_desc'] = 'Visi kursai, kuriems kurso nustatymuose nenustatytas kurso paveikslėlis, rodomi puslapyje Mano kursai su raštuota kurso kortele. Toliau galima nurodyti šablonui naudojamas spalvas.';
$string['coursecolorsettings'] = 'Kurso kortelės spalvos';
$string['coursecontact'] = 'Kursų kontaktiniai asmenys';
$string['coursecontact_desc'] = 'Šis parametras leidžia jums valdyti, kas rodoma kursų apraše. Naudotojai turi turėti mažiausiai vieną iš šių kursų vaidmenų, kad būtų rodomi tų kursų apraše.';
$string['coursecontactduplicates'] = 'Rodyti visų kurso kontaktų vaidmenis';
$string['coursecontactduplicates_desc'] = 'Jei įjungta, naudotojai, turintys daugiau nei vieną pasirinktiems kursams kontakto vaidmenis, bus rodomi kurso aprašyme su kiekvienu jų vaidmeniu. Kitu atveju, jie bus rodomi tik su vienu vaidmeniu (atsižvelgiant į tai, kuris svetainės administravimo skiltyje „Apibrėžti vaidmenis“ yra aukščiausias).';
$string['coursecreationguide'] = '„Moodle“ kurso kūrimo vadovo URL';
$string['coursecreationguide_help'] = 'Nurodo kelią į „Quickstart“ vadovą su trumpais vaizdo įrašais ir bendrais patarimais, kaip kurti kursus. Kai nėra kursų, kuriuos būtų galima rodyti, puslapyje „Mano kursai“ rodoma nuoroda į vadovą. Nuorodą matys tik naudotojai, galintys kurti kursus.';
$string['coursegraceperiodafter'] = 'Atidėjimo laikotarpis ankstesniems kursams';
$string['coursegraceperiodbefore'] = 'Atidėjimo laikotarpis būsimiems kursams';
$string['courselistshortnames'] = 'Rodyti sutrumpintus vardus';
$string['courselistshortnames_desc'] = 'Rodyti sutrumpintus vardus taip pat kaip pilną vardą kai vaizduojamas kursų sąrašas.';
$string['coursemgmt'] = 'Tvarkyti kursus ir kategorijas';
$string['courseoverview'] = 'Kursų apžvalga';
$string['courserequestnotify'] = 'Pranešimas apie kurso sukūrimo prašymą';
$string['courserequestnotifyemail'] = '<p>{$a->user} pateikė naujo kurso užklausą.</p>
<p>Užklausą galite peržiūrėti adresu <a href="{$a->link}">{$a->link}</a>.</p>

<p>Užklausos informacija:</p>
<ul>
<li>Visas kurso pavadinimas: {$a->fullname}</li>
<li>Trumpasis kurso pavadinimas:  {$a->shortname}</li>
<li>Kategorija: {$a->category}</li>
<li>Kurso prašymo priežastis:  {$a->reason}</li>
</ul>';
$string['courserequests'] = 'Kurso sukūrimo prašymai';
$string['courserequestspending'] = 'Laukiantys kurso sukūrimo prašymai';
$string['courses'] = 'Kursai';
$string['coursesperpage'] = 'Kursų skaičius puslapyje';
$string['courseswithsummarieslimit'] = 'Kursai su santraukos apribojimu';
$string['creatornewroleid'] = 'Kūrėjų vaidmuo naujuose kursuose';
$string['creatornewroleid_help'] = 'Jei naudotojas dar neturi teisių valdyti naujus kursus, jis automatiškai įregistruojamas naudojant šį vaidmenį.';
$string['cron'] = '„Cron“';
$string['cron_enabled'] = 'Įgalinti cron';
$string['cron_enabled_desc'] = 'Cron paprastai turėtų būti įjungtas, tačiau šis nustatymas leidžia laikinai jį išjungti, pavyzdžiui, prieš paleidžiant serverį iš naujo. Jei išjungta, sistema negali pradėti naujų foninių užduočių. Atminkite, kad cron neturėtų būti išjungtas ilgą laiką, nes tai neleis veikti svarbioms funkcijoms.';
$string['cron_help'] = 'Cron.php scenarijus vykdo daugybę užduočių skirtingais suplanuotais intervalais, pavyzdžiui, siunčia pranešimus apie forumo įrašus. Scenarijus turėtų būti paleistas reguliariai – geriausia kas minutę.';
$string['cron_keepalive'] = 'Išlaikyti veikiantį';
$string['cron_keepalive_desc'] = 'Papildomų užduočių vykdymo trukmė. Šis nustatymas skirtas užtikrinti, kad "cron" veiktų visada. Jei naudojate specialius užduočių vykdytojus, nustatykite 0. Kitu atveju nustatykite vertę, panašią į adhoc užduočių vykdymo lygiagretumo ribą. Venkite ilgesnių laikų. Maksimalus laikas yra 15 minučių.';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = '„Cron“ vykdymas tik per komandų eilutę';
$string['cronerrorclionly'] = 'Atsiprašome, administratorius išjungė interneto prieigą prie šio puslapio.';
$string['cronerrorpassword'] = 'Atsiprašome, nenurodėte galiojančio slaptažodžio, leidžiančio prieiti prie šio puslapio.';
$string['croninfrequent'] = 'Tarp paskutinių dviejų cron priežiūros scenarijaus paleidimų buvo {$a->actual} ir jis turėtų būti paleistas kas {$a->expected}. Rekomenduojame sukonfigūruoti, kad jis veiktų dažniau.';
$string['cronremotepassword'] = '„Cron“ nuotolinės prieigos slaptažodis';
$string['cronwarning'] = '<a href="{$a->url}">admin/cron.php scenarijus</a> nebuvo paleistas {$a->actual} ir turėtų būti paleistas kas {$a->expected}.';
$string['cronwarningcli'] = 'Scenarijus <code>admin/cli/cron.php</code> nebuvo paleistas {$a->actual} ir turėtų būti paleistas kas {$a->expected}.';
$string['cronwarningnever'] = 'Scenarijus <code>admin/cli/cron.php</code> niekada nebuvo paleistas ir turėtų paleisti kiekvieną {$a->tikėtiną}.';
$string['cronwarningneverweb'] = '<a href="{$a->url}">admin/cron.php scenarijus</a> niekada nebuvo paleistas ir turėtų paleisti kiekvieną {$a->tikėtiną}.';
$string['ctyperequired'] = '„Moodle“ dabar reikalauja naudoti „ctype“ PHP plėtinį, kad pagerėtų svetainės našumas ir būtų užtikrintas daugiakalbis suderinamumas.';
$string['curlcache'] = '„cURL“ talpyklos TTL';
$string['curlrequired'] = '„Moodle“ dabar reikalauja naudoti „CURL“ PHP plėtinį, kad būtų galima užmegzti ryšį su „Moodle“ saugyklomis.';
$string['curlsecurityallowedport'] = 'cURL leidžiamų prievadų sąrašas';
$string['curlsecurityallowedportsyntax'] = 'Prievadų numerių, prie kurių cURL gali prisijungti, sąrašas. Tinkami įrašai yra tik sveikieji skaičiai. Kiekvieną įrašą perkelkite į naują eilutę. Jei paliekama tuščia, leidžiami visi prievadai. Jei nustatyta, beveik visais atvejais cURL reikia nurodyti ir 443, ir 80, kad būtų galima prisijungti prie standartinių HTTPS ir HTTP prievadų.';
$string['curlsecurityblockedhosts'] = 'cURL užblokuotų prieglobų sąrašas';
$string['curlsecurityblockedhostssyntax'] = 'Kiekvieną įrašą perkelkite į naują eilutę. Tinkami įrašai yra pilni IPv4 arba IPv6 adresai (pvz., 192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80::), atitinkantys vieną pagrindinį kompiuterį; arba CIDR žymėjimas (pvz., 231.54.211.0/20 arba fe80::/64); arba IP adresų diapazonas (pvz., 231.3.56.10-20 arba fe80::1111-bbbb), kur diapazonas taikomas paskutinei adreso grupei; arba domenų vardai (pvz., localhost arba example.com); arba pakaitos simbolių domeno vardai (pvz., *.example.com arba *.sub.example.com). Tuščios eilutės neleidžiamos.';
$string['curlsecurityurlblocked'] = 'URL yra užblokuotas.';
$string['curltimeoutkbitrate'] = 'Greitaveika naudojama apskaičiuoti praėjusį laiką (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Šis nustatymas yra naudojamas apskaičiuoti atitinkamas pertraukas per dideles cURL užklausas. Kaip dalis šio skaičiavimo HTTP antraštės užklausa yra siunčiama, kad būtų nustatytas turinio dydis. Nustatant į 0, išjungia šias užklausas.';
$string['currenttheme'] = 'Dabartinė tema';
$string['customcheck'] = 'Kitos patikros';
$string['custommenu'] = 'Pasirinktinis meniu';
$string['custommenuitems'] = 'Pasirinktinio meniu elementai';
$string['customusermenuitems'] = 'Naudotojo meniu elementai';
$string['datarootsecurityerror'] = '<p><strong>SAUGOS ĮSPĖJIMAS!</strong></p><p>Jūsų šakninių duomenų katalogas yra klaidingoje vietoje ir yra matomas žiniatinklyje. Tai reiškia, kad prie visų jūsų privačių failų gali prieiti bet kas, be to, įsilaužėlis gali panaudoti kai kuriuos privačius jūsų failus, kad gautų neteisėtą administratoriaus prieigą prie jūsų svetainės!</p> <p>Jūs <em>privalote</em> perkelti šakninių duomenų katalogą ({$a}) į naują vietą, kuri nėra jūsų viešajame žiniatinklio kataloge, ir atitinkamai atnaujinti <code>$CFG->šakninių duomenų</code> parametrą faile config.php.</p>';
$string['datarootsecuritywarning'] = 'Gali būti, kad jūsų svetainės konfigūracija nėra saugi. įsitikinkite, kad jūsų šakninių duomenų katalogas ({$a}) neprieinamas tiesiogiai per žiniatinklį.';
$string['dbprefixtoolong'] = 'Jūsų svetainės duomenų bazės prefiksas ($CFG->prefix) yra per ilgas ({$a->current} characters). Didžiausias leistinas simbolių skaičius yra {$a->maximum}.';
$string['dbsessions'] = 'Naudokite duomenų bazę seanso informacijai';
$string['debug'] = 'Derinimo žinutės';
$string['debugall'] = 'VISKAS: rodyti visas pagrįstas PHP derinimo žinutes';
$string['debugdeveloper'] = 'PROGRAMŲ KŪRĖJAS: papildomos programų kūrėjams skirtos „Moodle“ derinimo žinutės';
$string['debugdisplay'] = 'Rodyti derinimo žinutes';
$string['debugging'] = 'Derinimas';
$string['debugminimal'] = 'MINIMALUS: rodyti tik lemtingas klaidas';
$string['debugnone'] = 'NĖRA: nerodyti jokių klaidų ar įspėjimų';
$string['debugnormal'] = 'ĮPRASTAS: rodyti klaidas, įspėjimus ir pranešimus';
$string['debugpageinfo'] = 'Rodyti puslapio informaciją';
$string['debugsqltrace'] = 'Rodyti SQL iškvietimų kilmę';
$string['debugsqltrace1'] = 'Rodyti tik vieną iškvietimo liniją';
$string['debugsqltrace100'] = 'Rodyti visą steko seką';
$string['debugsqltrace2'] = 'Rodyti 2 eilutes steko sekos';
$string['debugsqltrace_desc'] = 'Jei įjungta, dalinė arba visa PHP steko seka įtraukiama į SQL kaip komentaras.';
$string['debugstringids'] = 'Rodyti kalbų eilučių kilmę';
$string['debugstringids_desc'] = 'Jei įgalinta, kalbos eilutės komponentai ir identifikatoriai rodomi, kai prie puslapio URL pridedama ?strings=1 arba &strings=1.';
$string['debugtemplateinfo'] = 'Rodyti šablono informaciją';
$string['debugtemplateinfo_desc'] = 'Jei ši funkcija įjungta, šablonai, naudojami atvaizdavimui, rodomi kaip puslapio HTML komentarai. Pakeitus nustatymą, reikia išvalyti talpyklą. Naudokite tik laikinam derinimui, nes tai sukelia HTML patvirtinimo klaidas ir gali pažeisti puslapio skriptus. Ji taip pat gali pažeisti pagrindinį funkcionalumą!';
$string['debugvalidators'] = 'Rodyti tikrintojų saitus';
$string['defaultcity'] = 'Numatytasis miestas';
$string['defaultcity_help'] = 'Čia įvestas miestas bus numatytasis miestas kuriant naujas naudotojų paskyras.';
$string['defaultformatnotset'] = 'Klaida nustatant numatytajį kursų formatą. Patikrinkite svetainės nustatymus';
$string['defaulthomepage'] = 'Pradinis puslapis naudotojams';
$string['defaultrequestcategory'] = 'Numatytoji kurso prašymo kategorija';
$string['defaultsettinginfo'] = 'Numatyta: {$a}';
$string['defaultuserroleid'] = 'Numatytasis visų naudotojų vaidmuo';
$string['deleteduserx'] = 'Ištrintas naudotojas {$a}';
$string['deleteincompleteusers'] = 'Naikinti nebaigtus naudotojus po';
$string['deleteunconfirmed'] = 'Naikinti ne visiškai nustatytus naudotojus po';
$string['deleteuser'] = 'Naikinti naudotoją';
$string['density'] = 'Tankis';
$string['denyemailaddresses'] = 'Uždrausti el. pašto domenai';
$string['development'] = 'Kūrimas';
$string['devicetype'] = 'Įrenginio tipas';
$string['devlibdirpresent'] = 'Katalogai su kūrimo bibliotekomis, ypač <em>/vendor</em> ir <em>/node_modules</em>, neturėtų būti viešose svetainėse. Norėdami gauti daugiau informacijos, žr. <a href="{$a->moreinfourl}">saugos apžvalgos ataskaitą</a>.';
$string['disabled'] = 'Išjungta';
$string['disableplugin'] = 'Išjungti {$a}';
$string['disableuserimages'] = 'Išjungti naudotojų profilių vaizdus';
$string['displayerrorswarning'] = 'Nerekomenduojama įjungti PHP parametro <em>display_errors</em> gamybos svetainės, nes kai kurios klaidos žinutės atskleisti slaptos informacijos apie jūsų serverį.';
$string['displayloginfailures'] = 'Rodyti prisijungimo triktis';
$string['divertallemails'] = 'El. pašto nukreipimas';
$string['divertallemailsdetail'] = 'Naudojama kaip apsaugos priemonė kūrimo aplinkose bandant el. laiškus ir neturėtų būti naudojama produkcinėje aplinkoje.';
$string['divertallemailsexcept'] = 'Pašto nukreipimo išimtys';
$string['divertallemailsexcept_desc'] = 'El. pašto išimties taisyklių sąrašas, atskirtas kableliais arba naujomis eilutėmis. Kiekviena taisyklė interpretuojama kaip reguliari išraiška pvz. <pre>simone@acme.com
.*@acme.com
fred(\\+.*)?@acme.com
</pre>';
$string['divertallemailsto'] = 'Nukreipti visus el. laiškus';
$string['divertallemailsto_desc'] = 'Jei nustatyta, visi el. laiškai bus nukreipti į šį vieną el. pašto adresą.';
$string['dndallowtextandlinks'] = 'Tekstų/saitų įkėlimas vilkimu';
$string['doclang'] = 'Kalba docs\'ams';
$string['docroot'] = '„Moodle“ dokumentų šakninis katalogas';
$string['doctonewwindow'] = 'Atidaryti naujame lange';
$string['doesnotfit'] = 'E. pašto rodymo nustatymai';
$string['doesnotfitdetail'] = 'Rodyti el. pašto, išeinančio iš „Moodle“, nustatymus.';
$string['download'] = 'Atsisiųsti';
$string['downloadcoursecontentallowed'] = 'Galima atsisiųsti kurso turinio funkciją';
$string['downloadcoursecontentallowed_desc'] = 'Ar kursų turinio atsisiuntimo funkcija pasiekiama kursams. Jei įmanoma, kurso turinio atsisiuntimus galima įjungti / išjungti naudojant kurso redagavimo meniu nustatymą „Įgalinti kurso turinio atsisiuntimą“ (galima nustatyti <a href={$a} target="_blank">Numatytieji kurso parametrai</a>).';
$string['durationunits'] = 'trukmės vienetai';
$string['edithelpdocs'] = 'Redaguoti žinyno dokumentus';
$string['editlang'] = '<b>Redaguoti</b>';
$string['editorbackgroundcolor'] = 'Fono  spalva';
$string['editordictionary'] = 'Rengyklės žodynas';
$string['editorfontfamily'] = 'Šriftų grupė';
$string['editorfontlist'] = 'Šriftų sąrašas';
$string['editorfontsize'] = 'Šrifto dydis';
$string['editorhidebuttons'] = 'Paslėpti mygtukai';
$string['editorkillword'] = '„Word“ formatų filtras';
$string['editorspelling'] = 'Rengyklės rašyba';
$string['editorspellinghelp'] = 'Įjungti arba išjungti rašybos tikrinimą. Įjungus, serveryje būtina įdiegti <strong>„Aspell“</strong>.';
$string['editstrings'] = 'Redaguoti žodžius arba frazes';
$string['emailchangeconfirmation'] = 'El. pašto keitimo patvirtinimas';
$string['emaildkim'] = '„DomainKeys Identified Mail“ (DKIM) el. pašto pasirašymas';
$string['emaildkiminfo'] = 'Jei nustatytas ir DKIM parinkiklis, ir randamas privataus sertifikato failas, atitinkantis el. laiško „Nuo“ adreso domeną, esantį $CFG->dataroot/dkim/[domenas]/[selector].private, el. laiškas bus pasirašytas. Daugeliu atvejų (pavyzdžiui, jei allowemaildomains laukas tuščias) <pre>{$a->path}</pre> reikalingas tik vienas sertifikatas. Norėdami gauti daugiau informacijos apie sąranką, žr. dokumentaciją <a href="{$a->docs}">Pašto konfigūracija</a>.';
$string['emaildkimselector'] = 'DKIM parinkiklis';
$string['emailfromvia'] = 'Paštu per informaciją';
$string['emailheaders'] = 'Laiškų antraštės';
$string['emailsubjectprefix'] = 'El. pašto temos priešdėlio tekstas';
$string['emoticonalt'] = 'Alternatyvusis tekstas';
$string['emoticoncomponent'] = 'Vaizdo komponentas';
$string['emoticonimagename'] = 'Vaizdo pavadinimas';
$string['emoticons'] = 'Emocijos';
$string['emoticons_desc'] = 'Ši forma apibrėžia jaustukus (arba šypsniukus), naudojamus jūsų svetainėje. Norėdami pašalinti eilutę iš lentelės, įrašykite formą bet kuriame būtiname lauke palikę tuščią reikšmę. Norėdami užregistruoti naują jaustuką, užpildykite paskutinės tuščios eilutės laukus. Norėdami iš naujo nustatyti visų laukų numatytąsias reikšmes, spustelėkite aukščiau pateiktą saitą. * Tekstas (būtinas) – šis tekstas bus pakeistas jaustuko vaizdu. Jis turi būti mažiausiai dviejų simbolių ilgio. * Vaizdo pavadinimas (būtinas) – jaustuko vaizdo failo vardas be plėtinio, susijęs su komponento paveikslėlių aplanku. * Vaizdo komponentas (būtinas) – komponentas, pateikiantis piktogramą. * Alternatyvusis tekstas (pasirinktinis) – jaustuko alternatyviojo teksto eilutės identifikatorius ir komponentas.';
$string['emoticonsreset'] = 'Nustatyti numatytąsias jaustukų parametro reikšmes';
$string['emoticontext'] = 'Tekstas';
$string['emptysettingvalue'] = 'Tuščia';
$string['enableanalytics'] = 'Analitika';
$string['enableblogs'] = 'Įjungti dienoraščius';
$string['enablecalendarexport'] = 'Įjungti kalendoriaus eksportavimą';
$string['enablecomments'] = 'Įjungti komentarus';
$string['enablecommunicationsubsystem'] = 'Įgalinti ryšių paslaugų teikėjus';
$string['enablecommunicationsubsystem_desc'] = 'Leisti integraciją su komunikacijos paslaugų teikėjais, pavyzdžiui, „Matrix“, kad dėstytojai ir besimokantieji galėtų lengviau bendrauti. Šias integracijas galite valdyti <a href="settings.php?section=managecommunicationproviders">Papildiniai</a>.';
$string['enablecourserelativedates'] = 'Įgalinti kurso santykines datas';
$string['enablecourserelativedates_desc'] = 'Leisti nustatyti kursus, kad būtų rodomos datos, palyginti su naudotojo kurso pradžios data.';
$string['enablecourserequests'] = 'Įjungti naujo kurso sukūrimo prašymus';
$string['enabled'] = 'Įgalintas';
$string['enabledashboard'] = 'Įgalinti "Mano pagrindinis"';
$string['enabledashboard_help'] = 'Pagal numatytuosius nustatymus prietaisų skydelyje rodomi laiko juostos, kalendoriaus ir neseniai aplankytų elementų sąrašai. Galite nustatyti kitokį numatytąjį prietaisų skydelį visiems ir leisti naudotojams pritaikyti savo prietaisų skydelį. Jei išjungta, reikia nustatyti "Pradinis naudotojų puslapis" kitą reikšmę nei prietaisų skydelyje.';
$string['enableglobalsearch'] = 'Įjungti visuotinę paiešką';
$string['enableglobalsearch_desc'] = 'Jei įjungta, duomenys bus indeksuojami ir sinchronizuojami pagal suplanuotą užduotį.';
$string['enablegravatar'] = 'Įjungti „Gravatar“';
$string['enablegravatar_help'] = 'Kai įjungta Moodle bandys atsinešti naudotojo paveikslėlį ir „Gravatar“ jei naudotojas dar neįkėlė paveikslėlio.';
$string['enablemobilewebservice'] = 'Įgalinti mobiliojo interneto servisa';
$string['enablepdfexportfont'] = 'Įjungti PDF šriftus';
$string['enablepdfexportfont_desc'] = 'Jei jūsų svetainėje yra kursų skirtingomis kalbomis, kuriems reikia kitų šriftų sugeneruotuose PDF failuose, kurso nustatymuose galite pateikti parinktį „nustatyti šriftą“. Turite nurodyti galimus šriftus $CFG->pdfexportfont, config.php.';
$string['enableplugin'] = 'Įjungti {$a}';
$string['enablerecordcache'] = 'Įjungti įrašų talpyklą';
$string['enablerssfeeds'] = 'Įjungti RSS informacijos santraukas';
$string['enablesearchareas'] = 'Įjungti paieškos sritį';
$string['enablesharingtomoodlenet'] = 'Įgalinti bendrinimą su MoodleNet (išeinantis)';
$string['enablesharingtomoodlenet_desc'] = 'Leisti naudotojams dalytis kurso turiniu su sukonfigūruota "MoodleNet" priemone, jei jie turi atitinkamas galimybes.';
$string['enablestats'] = 'Įjungti statistinius duomenis';
$string['enabletrusttext'] = 'Įjungti patikimą turinį';
$string['enableuserfeedback'] = 'Įgalinti atsiliepimus apie šią programinę įrangą';
$string['enableuserfeedback_desc'] = 'Jei įjungta, poraštėje rodoma nuoroda „Pateikti atsiliepimą apie šią programinę įrangą“, kad naudotojai galėtų pateikti atsiliepimą apie „Moodle“ programinę įrangą „Moodle“ būstinei. Jei nustatyta parinktis „Kitas atsiliepimo priminimas“, naudotojui taip pat bus rodomas priminimas prietaisų skydelyje nurodytu intervalu. Nustačius „Kitas atsiliepimo priminimas“ į „Niekada“, prietaisų skydelio priminimas išjungiamas, o poraštėje paliekama nuoroda „Pateikti atsiliepimą apie šią programinę įrangą“.';
$string['enablewebservices'] = 'Įjungti žiniatinklio tarnybas';
$string['enablewsdocumentation'] = 'Žiniatinklio tarnybų dokumentacija';
$string['encryptedpassword_edit'] = 'Įvesti naują vertę';
$string['encryptedpassword_set'] = '(Nustatyta ir užšifruota)';
$string['enroladminnewcourse'] = 'Automatiškai registruoti administratorių į naujus kursus';
$string['enroladminnewcourse_help'] = 'Kai administratorius prideda naują kursą, ar jis turėtų būti automatiškai įregistruotas ir jam priskirtas kūrėjo vaidmuo?';
$string['enrolinstancedefaults'] = 'Įregistravimo egzemplioriaus numatytosios reikšmės';
$string['enrolinstancedefaults_desc'] = 'Numatytieji įregistravimo parametrai naujuose kursuose.';
$string['enrolmultipleusers'] = 'Įregistruoti naudotojus';
$string['entitytasklog'] = 'Užduočių žurnalas';
$string['environment'] = 'Aplinka';
$string['environmenterrortodo'] = 'Prieš tęsdami šios „Moodle“ versijos diegimą turite išspręsti visas aplinkos problemas (klaidas).';
$string['environmenterrorupgrade'] = 'Įspėjimas: prieš tęsdami šios „Moodle“ versijos naujinimą turite išspręsti visas aplinkos problemas (klaidas). Jei naujinsite neįvykdę šių reikalavimų, gali iškilti problemų, pvz., galite prarasti duomenis. Ar tikrai norite tęsti naujinimą?';
$string['environmentmariadbwrongdbtype'] = 'Neteisingas $CFG->db tipas. Savo config.php faile turite jį pakeisti iš „mysqli“ į „mariadb“.';
$string['environmentmustfixsetting'] = 'Būtina pakeisti PHP parametrą.';
$string['environmentok'] = 'Jūsų serverio aplinka atitinka visus minimalius reikalavimus.';
$string['environmentrecommendcustomcheck'] = 'jei nepavyksta atlikti šio testo, tai nurodo galimą problemą';
$string['environmentrecommendinstall'] = 'turėtų būti įdiegta ir įjungta, kad rezultatai būtų optimalūs';
$string['environmentrecommendversion'] = 'rekomenduojama naudoti versiją {$a->needed}, o jūs naudojate {$a->current}';
$string['environmentrequirecustomcheck'] = 'šis testas turi būti sėkmingai atliktas';
$string['environmentrequireinstall'] = 'turi būti įdiegta ir įjungta';
$string['environmentrequireversion'] = 'būtina naudoti versiją {$a->needed}, o jūs naudojate {$a->current}';
$string['environmentsettingok'] = 'aptiktas rekomenduojamas parametras';
$string['environmentshouldfixcustomcheck'] = 'turėtų būti įjungtas, kad rezultatai būtų geriausi';
$string['environmentshouldfixsetting'] = 'Reikėtų pakeisti PHP parametrą.';
$string['environmentxmlerror'] = 'Klaida nuskaitant aplinkos duomenis ({$a->error_code})';
$string['errordeletingconfig'] = 'Naikinant papildinio {$a} konfigūravimo įrašus įvyko klaida.';
$string['errorsetting'] = 'Nepavyko įrašyti parametro:';
$string['errorwithsettings'] = 'Jūsų parametrų nepavyko pakeisti dėl klaidos.';
$string['eventshandlersinuse'] = 'Jūsų sistemoje šie papildiniai naudoja "Events 1 API deprecated" tvarkykles: "{$a}". Atnaujinkite juos, kad jie naudotų Events 2 API. Žr. https://docs.moodle.org/dev/Events_API#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Visi, kas gali {$a}';
$string['exceptions'] = 'išimtys';
$string['execpathnotallowed'] = 'Vykdomųjų ir vietinių kelių nustatymas išjungtas config.php';
$string['experimental'] = 'Eksperimentiniai';
$string['experimentalsettings'] = 'Eksperimentiniai parametrai';
$string['extendedusernamechars'] = 'Leisti naudoti išplėstinius simbolius naudotojų varduose';
$string['extramemorylimit'] = 'Papildomas PHP atminties limitas.';
$string['fatalsessionautostart'] = '<p>Aptikta rimta konfigūracijos klaida, praneškite serverio administratoriui.</p><p> Norint, kad „Moodle“ veiktų tinkamai, reikia, kad administratorius pakeistų PHP parametrus.</p><p>Parametro <code>session.auto_start</code> reikšmė turi būti <code>išjungta</code>.</p><p>Šis parametras valdomas redaguojant <code>php.ini</code>, „Apache“ / IIS <br />konfigūraciją arba <code>.htaccess</code> failą, esantį serveryje.</p>';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'Favicon rodoma šalia puslapio pavadinimo naršyklės skirtuke. Moodle adresyno piktograma rodoma, jei nepateikta pasirinktinė favicon.';
$string['feedbacksettings'] = 'Atsiliepimo nuostatos';
$string['fileconversioncleanuptask'] = 'Failų konvertavimo laikinųjų įrašų išvalymas';
$string['filecreated'] = 'Sukurtas naujas failas';
$string['filescleanupperiod'] = 'Išvalyti šiukšliadėžės failus';
$string['filescleanupperiod_help'] = 'Kaip dažnai ištrinami šiukšliadėžės failai. Tai yra failai, susieti su kontekstu, kurio nebėra, pavyzdžiui, kai kursas ištrinamas. Atkreipkite dėmesį: dėl šio nustatymo kurse gali trūkti failų, kurių atsarginės kopijos sukuriamos, ištrinamos ir atkuriamos, jei parametras „Įtraukti failus“ (backup_auto_files) „Automatinės atsarginės kopijos nustatymuose“ yra išjungtas.';
$string['filesizeunits'] = 'failo dydžio vienetai';
$string['filestoredin'] = 'Įrašyti failą aplanke:';
$string['filestoredinhelp'] = 'Kur bus saugomas failas';
$string['filterall'] = 'Filtruoti visas eilutes';
$string['filtermatchoneperpage'] = 'Filtruoti atitikimą, kad būtų rodomas vienas kiekviename puslapyje';
$string['filtermatchonepertext'] = 'Filtruoti atitikimą, kad būtų rodomas vienas visame tekste';
$string['filternavigationwithsystemcontext'] = 'Filtruoti navigaciją pagal sistemos kontekstą';
$string['filters'] = 'Filtrai';
$string['filtersettings'] = 'Tvarkyti filtrus';
$string['filtersettingsgeneral'] = 'Bendrieji filtro parametrai';
$string['filteruploadedfiles'] = 'Filtro įkelti failai';
$string['forceclean'] = 'Turinio valymas visur';
$string['forceclean_desc'] = 'Į svetainę įtrauktas turinys paprastai išvalomas prieš jį rodant, kad būtų pašalinta visa, kas gali kelti grėsmę saugumui. Tačiau turinys nėra išvalomas tam tikrose vietose, pvz., veiklos aprašymuose, puslapių šaltiniuose ar HTML blokuose, kad būtų galima pridėti scenarijus, mediją, eilutinius rėmelius ir kt. Jei šis nustatymas įjungtas, VISAS turinys bus išvalytas. Dėl to esamas turinys gali būti netinkamai rodomas.';
$string['forcelogin'] = 'Reikalauti, kad naudotojai prisijungtų';
$string['forceloginforprofileimage'] = 'Versti naudotojus  prisijungti kad peržiūrėti naudotojo paveikslėlius';
$string['forceloginforprofileimage_help'] = 'Jei įjungta, naudotojai turi prisijungti, kad galėtų peržiūrėti naudotojo profilio nuotraukas, o numatytoji naudotojo nuotrauka bus naudojama visuose pranešimų el. laiškuose.';
$string['forceloginforprofiles'] = 'Reikalauti, kad naudotojai prisijungtų prie profilių';
$string['forcetimezone'] = 'Reikalauti naudoti numatytąją laiko juostą';
$string['formatuninstallwithcourses'] = 'Yra {$a->count} kursai, naudojantys {$a->format}. Jų formatas bus pakeistas į {$a->defaultformat} (numatytasis formatas šioje svetainėje). Kai kurie specifiniai formato duomenys gali būti prarasti. Ar tikrai norite tęsti?';
$string['frontpage'] = 'Pradinis svetainės puslapis';
$string['frontpagebackup'] = 'Svetainės pradinio puslapio atsarginė kopija';
$string['frontpagedefaultrole'] = 'Numatytasis svetainės pradinio puslapio vaidmuo';
$string['frontpagefilters'] = 'Svetainės pradinio puslapio filtrai';
$string['frontpageloggedin'] = 'Svetainės pradinio puslapio elementai prisijungus';
$string['frontpageoverrides'] = 'Svetainės pradinio puslapio teisių keitimai';
$string['frontpagequestions'] = 'Svetainės pradinio puslapio klausimai';
$string['frontpagerestore'] = 'Svetainės pradinio puslapio atkūrimas';
$string['frontpageroles'] = 'Svetainės pradinio puslapio vaidmenys';
$string['frontpagesettings'] = 'Svetainės pradinio puslapio nustatymai';
$string['fullnamedisplay'] = 'Viso pavadinimo formatas';
$string['fullnamedisplayprivate'] = 'Pilno vardo formatas - privatus';
$string['gdrequired'] = 'GD plėtinys dabar reikalingas Moodle vaizdo konvertavimui.';
$string['generalsettings'] = 'Bendrieji nustatymai';
$string['geoipdbedition'] = 'GeoIP duomenų bazės leidimas';
$string['geoipdbedition_desc'] = 'Pasirinkite GeoIP duomenų bazės leidimą, kurį norite atsisiųsti. Atkreipkite dėmesį, kad norint naudotis "GeoIP2-City" duomenų baze, reikia turėti galiojančią mokamą licenciją.';
$string['geoipfile'] = 'GeoIP City DB';
$string['geoipmaxmindaccid'] = '„MaxMind“ paskyros ID';
$string['geoipmaxmindaccid_desc'] = '"MaxMind API" paslaugoje sukurtos paskyros ID.';
$string['geoipmaxmindlicensekey'] = 'MaxMind licencijos raktas';
$string['geoipmaxmindlicensekey_desc'] = '"MaxMind API" paslaugoje sukurtos paskyros licencijos raktas.';
$string['getremoteaddrconf'] = 'Užregistruotas IP adreso šaltinis';
$string['globalsearch'] = 'Visuotinė paieška';
$string['globalsearchmanage'] = 'Tvarkyti visuotinę paiešką';
$string['googlemapkey3'] = '„Google“ žemėlapių API  V3 raktas';
$string['googlemapkey3_help'] = 'Jums reikia įvesti specialų „Google“ žemėlapių raktą, norėdami naudoti IP adresų paieškos vizualizaciją. Jūs galite nemokamai gauti raktą čia <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Pereiti prie pirmos trūkstamos eilutės';
$string['gradebook'] = 'Įvertinimų knygelė';
$string['gradebookroles'] = 'Įvertinti vaidmenys';
$string['gradeexport'] = 'Pirminis įvertinimų eksportavimo metodas';
$string['gradeexportdefault'] = 'Numatasis įvertinimo eksporto metodas';
$string['gravatardefaulturl'] = 'Gravatar numatytojo vaizdo URL';
$string['gravatardefaulturl_help'] = '„Gravatar“ turi būti rodomas numatytasis vaizdas, jei jis negali rasti paveikslėlio tam tikram naudotojui. Pateikite visą vaizdo URL. Jei paliksite šį nustatymą tuščią, „Moodle“ bandys naudoti tinkamiausią numatytąjį vaizdą jūsų žiūrimam puslapiui. Taip pat atminkite, kad „Gravatar“ turi daugybę kodų, kuriuos galima naudoti <a href="https://en.gravatar.com/site/implement/images/#default-image">numatytiesiems vaizdams generuoti</a>.';
$string['group_customfield'] = 'Grupuoti pasirinktinius laukus';
$string['groupenrolmentkeypolicy'] = 'Grupės įregistravimo raktų strategija';
$string['groupenrolmentkeypolicy_desc'] = 'Jei įjungta, grupės registracijos raktai bus tikrinami pagal reikalavimus slaptažodžiui kaip nurodyta anksčiau pateiktuose nustatymuose.';
$string['grouping_customfield'] = 'Pasirinktinių laukų grupavimas';
$string['guestroleid'] = 'Svečio vaidmuo';
$string['guestroleid_help'] = 'Šis vaidmuo automatiškai priskiriamas svečiui naudotojui. Jis taip pat laikinai priskiriamas neįsiregistravusiems naudotojams, kurie prieina prie kursų naudodami svečių įregistravimo papildinį.';
$string['h5pgetcontenttypestask'] = 'Atsisiųsti galimus H5P turinio tipus iš h5p.org';
$string['helpadminseesall'] = 'Ar svetainės kalendoriuje administratoriai mato ir filtruoja įvykius iš visų kursų kalendorių ar tik iš kursų, kuriuose jie yra užsiregistravę? Nepriklausomai nuo pasirinktos parinkties, administratoriai visada galės tvarkyti kiekvieno kurso kalendoriaus įvykius, pirmiausia eidami į kursą, o tada tiesiogiai pasiekdami kursų kalendorių.';
$string['helpcalendarcustomexport'] = 'Įgalinti tinkintos dienų sekos eksportavimo parinktį kalendoriaus eksportavime. Kad tai įsigaliotų, kalendoriaus eksportavimas turi būti įgalintas.';
$string['helpexportlookahead'] = 'Po kiek dienų ateityje kalendorius ieško įvykių eksportuojant tinkintą eksportavimo parinktį?';
$string['helpexportlookback'] = 'Prieš kiek dienų kalendorius ieško įvykių eksportuojant tinkintą eksportavimo parinktį?';
$string['helpforcetimezone'] = 'Galite leisti naudotojams individualiai pasirinkti laiko juostą arba reikalauti, kad tam tikrą laiko juostą naudotų visi.';
$string['helpshowicalsource'] = 'Jei įjungta, bus rodomas „iCal“ importuotų įvykių prenumeratos pavadinimas ir nuoroda.';
$string['helpsitemaintenance'] = 'Naujinimams ir kitam darbui';
$string['helpstartofweek'] = 'Kuria diena pradedama kalendoriaus savaitė?';
$string['helpupcominglookahead'] = 'Kiek pagal numatytuosius parametrus būsimų įvykių dienų apima kalendorius?';
$string['helpupcomingmaxevents'] = 'Kiek (daugiausia) pagal numatytuosius parametrus būsimų įvykių rodoma naudotojui?';
$string['helpweekenddays'] = 'Kurios savaitės dienos laikomos savaitgaliais ir vaizduojamos kita spalva?';
$string['hiddenuserfields'] = 'Slėpti naudotojo laukus';
$string['hidefromall'] = 'Slėpti nuo visų naudotojų';
$string['hidefromnone'] = 'Neslėpti nuo nieko';
$string['hidefromstudents'] = 'Slėpti nuo besimokančiųjų';
$string['hookcallbacks'] = 'Priešpriešinės iškvietos';
$string['hookconfigoverride'] = 'Perrašytas';
$string['hookdescription'] = 'Aprašymas';
$string['hostname'] = 'Host pavadinimas';
$string['htmleditor'] = 'HTML rengyklė';
$string['htmleditorsettings'] = 'HTML rengyklės parametrai';
$string['htmlsettings'] = 'HTML parametrai';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP sauga';
$string['iconvrequired'] = 'Būtina įdiegti ICONV plėtinį.';
$string['igbinary322buggyversion'] = 'Svetainėje įdiegtas php-igbinary plėtinys gali sukelti problemų dirbant su PHP 7.2. Jums rekomenduojama atnaujinti į php-igbinary 3.2.5 arba naujesnę versiją arba į PHP 7.3 ar naujesnę versiją.';
$string['ignore'] = 'Nepaisyti';
$string['importantupdates_content'] = '<p>„Moodle 5.0“, kurį planuojama išleisti 2025 m. balandį, Pokalbių ir Apklausų veiklos
bus pašalintos iš „Moodle“ branduolio. Jos bus prieinamos kaip papildiniai
<a href="https://moodle.org/plugins/">„Moodle“ papildinių katalogas</a>.</p>
<p>Jei norite svetainėje ir toliau naudoti Pokalbių ar Apklausų veiklas, prieš atnaujindami „Moodle 5.0“ galėsite jas įdiegti kaip papildinius.</p>';
$string['importantupdates_title'] = 'Svarbus atnaujinimas dėl Pokalbių ir Apklausų veiklų';
$string['includemoduleuserdata'] = 'Įtraukti modulių naudotojų duomenis';
$string['incompatibleblocks'] = 'Nesuderinami blokai';
$string['incompleteunicodesupport'] = 'Dabartinė „MySQL“ arba „MariaDB“ sąranka naudoja „utf8“. Šis simbolių rinkinys nepalaiko keturių baitų simbolių, kuriuose yra keletas jaustukų. Bandant naudoti šiuos simbolius, atnaujinant įrašą įvyks klaida, o visa į duomenų bazę siunčiama informacija bus prarasta. Apsvarstykite galimybę pakeisti nustatymus į „utf8mb4“. Išsamią informaciją rasite dokumentacijoje.';
$string['indexdata'] = 'Indekso duomenys';
$string['indexinginfo'] = 'Rekomenduojamas būdas indeksuoti svetainės turinį yra naudoti suplanuotą užduotį „Visuotinės paieškos indeksavimas“.';
$string['installhijacked'] = 'Apgailestaujame, diegimą būtina užbaigti iš pradinio IP adreso.';
$string['installsessionerror'] = 'Nepavyko inicijuoti PHP seanso. Patikrinkite, ar Jūsų naršyklė priima slapukus.';
$string['intlrecommended'] = 'Intl plėtinys yra naudojamas norint pagerinti internacionalizavimo palaikymą, pvz., rūšiavimą atsižvelgiant į lokalę.';
$string['intlrequired'] = 'Intl plėtinys reikalingas siekiant pagerinti internacionalizavimo palaikymą, pvz., rūšiavimą atsižvelgiant į lokalę ir tarptautinius domenų pavadinimus.';
$string['invalidagedigitalconsent'] = 'Skaitmeninis sutikimo amžius negalioja: {$a}';
$string['invalidforgottenpasswordurl'] = 'Pamiršto slaptažodžio URL nėra galiojantis URL.';
$string['invalidsection'] = 'Neleistina dalis.';
$string['invalidthemepreset'] = 'Pasirinktas išankstinių nustatymų rinkinio failas nesuderinamas su šia tema. SCSS kompiliavimo klaida buvo: „{$a}“';
$string['invaliduserchangeme'] = 'Naudotojo vardas „changeme“ yra rezervuotas – naudodami jį negalite kurti paskyros.';
$string['ipblocked'] = 'Ši svetainė šiuo metu neprieinama.';
$string['ipblocker'] = 'IP blokuotojas';
$string['ipblockersyntax'] = 'Padėkite kiekvieną įrašą vienoje eilutėje. Tinkami įrašai yra arba visas IP adresas (pvz., <b>192.168.10.1</b>), kuris atitinka vieną pagrindinį kompiuterį; arba dalinis adresas (pvz., <b>192.168</b>), atitinkantis bet kurį šiais skaičiais prasidedantį adresą; arba CIDR žymėjimas (pvz., <b>231.54.211.0/20</b>); arba IP adresų diapazonas (pvz., <b>231.3.56.10-20</b>), kur diapazonas taikomas paskutinei adreso daliai. Tekstiniai domenų pavadinimai (pvz., „example.com“) nepalaikomi. Tuščios eilutės ir tekstas po simbolio „#“ nepaisomi.';
$string['iplookup'] = 'IP adreso paruošta reikšmė';
$string['iplookupgeoplugin'] = 'Šiuo metu geografinei informacijai ieškoti naudojama paslauga <a href="https://www.geoplugin.com">geoPlugin</a>. Norėdami gauti tikslesnius rezultatus, rekomenduojame įdiegti vietinę MaxMind GeoIP duomenų bazę.';
$string['iplookupinfo'] = 'Pagal numatytuosius nustatymus „Moodle“ naudoja nemokamą internetinį „NetGeo“ (Internet Geographic Database) serverį IP adresų vietai ieškoti, deja, ši duomenų bazė nebetvarkoma ir gali grąžinti <em>labai neteisingus</em> duomenis.
Rekomenduojama įdiegti vietinę nemokamos GeoLite2 City duomenų bazės kopiją iš MaxMind.<br />
IP adreso vieta rodoma paprastame žemėlapyje arba naudojant Google Maps. Atkreipkite dėmesį, kad norint įjungti interaktyvius žemėlapius, turite turėti Google paskyrą ir pateikti paraišką dėl nemokamo Google Maps API rakto.';
$string['iplookupmaxmindnote'] = 'Šis produktas apima "MaxMind" sukurtus "GeoIP City" duomenis, kuriuos galima rasti  <a href="https://www.maxmind.com">https://www.maxmind.com</a>.';
$string['iscustomadminwarnings'] = 'Aptikta, kad jūsų svetainė naudoja priskirtą administratoriaus katalogą. Ši funkcija nebepalaikoma ir bus pašalinta po Moodle 4.2.';
$string['ishttpswarning'] = 'Aptikta, kad jūsų svetainė neapsaugota naudojant HTTPS. Primygtinai rekomenduojama perkelti svetainę į HTTPS, kad būtų padidintas saugumas ir geresnė integracija su kitomis sistemomis.';
$string['keeptagnamecase'] = 'Palikti žymės pavadinimo registrą';
$string['lang'] = 'Numatyta kalba';
$string['langcache'] = 'Talpyklos kalbos meniu';
$string['langcache_desc'] = 'Talpinti kalbos meniu. Jei įjungta, sąrašas galimų vertimų yra patalpinamas. Talpykla yra automatiškai atnaujinama kai jūs įrašote ar ištrinate kalbos paketą per kablos paketų tvarkymo įrankį. Jeigu jūs įrašysite kalbos paketą patys, tada turėsite išvalyti visas talpyklas kad atnaujintumėte įrašytą sąrašą.';
$string['langlist'] = 'Kalbų meniu esančios kalbos';
$string['langmenu'] = 'Rodyti kalbų meniu';
$string['langmenuinsecurelayout'] = 'Rodyti kalbos meniu saugiu išdėstymu';
$string['langmenuinsecurelayout_desc'] = 'Jei įjungta, naudotojas galės pakeisti kalbą, kai bando atlikti testą ar atlikti kitą veiklą, naudodamas saugų išdėstymą.';
$string['langpackwillbeupdated'] = 'PASTABA: atnaujinimo metu „Moodle“ bandys atsisiųsti jūsų kalbos paketų atnaujinimus.';
$string['langstringcache'] = 'Talpinti visas kalbos eilutes';
$string['languagesettings'] = 'Kalbos parametrai';
$string['latinexcelexport'] = '„Excel“ kodavimas';
$string['legacyfilesaddallowed'] = 'Leisti pridėti prie senesnių kursų failų';
$string['legacyfilesaddallowed_help'] = 'Jei kurse yra senų kursų failų, leisti prie jo pridėti naujų failų ir aplankų.';
$string['legacyfilesinnewcourses'] = 'Senstelėję kursų failai naujuose kursuose';
$string['legacyfilesinnewcourses_help'] = 'Numatyta, kad senstelėjusių kursų failų sritys prieinamos tik atnaujintuose kursuose. Atkreipkite dėmesį, kad kai kurios funkcijos, pvz., vienos veiklos atsarginės kopijos kūrimas / atkūrimas, nesuderinamos su šiais parametrais.';
$string['libcurlwarning'] = 'Nustatyta, kad libcurl nepalaiko CURLOPT_PROTOCOL. Saugumo sumetimais rekomenduojama įdiegti naujausią libcurl.';
$string['licensesettings'] = 'Licencijos parametrai';
$string['linkadmincategories'] = 'Susieti administratoriaus kategorijas';
$string['linkadmincategories_help'] = 'Jei įgalinta administratoriaus nuostatų kategorijos bus rodomos kaip nuorodos navigacijoje ir nuves į administratoriaus kategorijos puslapius.';
$string['loading'] = 'Įkeliama';
$string['localetext'] = 'Visos svetainės lokalė';
$string['localstringcustomization'] = 'Vietinės eilutės tinkinimas';
$string['location'] = 'Vieta';
$string['locationsettings'] = 'Vietos parametrai';
$string['locked'] = 'Užrakinta';
$string['lockoutduration'] = 'Paskyros užrakinimo trukmė';
$string['lockoutduration_desc'] = 'Užrakinta paskyra automatiškai atrakinama praėjus šiam laikotarpiui.';
$string['lockoutemailbody'] = 'Sveiki, {$a->firstname},

Jūsų paskyra su naudotojo vardu {$a->username} serveryje „{$a->sitename}“
buvo užrakinta po kelių neteisingų bandymų prisijungti.

Norėdami atrakinti paskyrą, eikite šiuo adresu

{$a->link}

Daugumoje pašto programų tai turėtų būti rodoma kaip mėlyna nuoroda, kurią galite tiesiog spustelėti.
Jei tai neveikia, tada nukopijuokite ir įklijuokite adresą į adreso
eilutę interneto naršyklės lango viršuje.

Jei reikia pagalbos, susisiekite su svetainės administratoriumi,
{$a->admin}';
$string['lockoutemailsubject'] = 'Jūsų paskyra {$a} buvo užrakinta';
$string['lockouterrorunlock'] = 'Pateikta neteisinga paskyros atrakinimo informacija.';
$string['lockoutthreshold'] = 'Sąskaitos blokavimo riba';
$string['lockoutthreshold_desc'] = 'Pasirinkti nesėkmingų bandymų prisijungti, dėl kurių paskyra bus užblokuota, skaičių. Šia funkcija gali būti piktnaudžiaujama atliekant paslaugų atsisakymo atakas.';
$string['lockoutwindow'] = 'Paskyros užrakinimo stebėjimo langas';
$string['lockoutwindow_desc'] = 'Blokavimo slenksčio stebėjimo laikas, jei nėra nesėkmingų bandymų, po šio laiko slenksčio skaitiklis nustatomas iš naujo.';
$string['lockrequestcategory'] = 'Neleisti pasirinkti kategorijos';
$string['log'] = 'Žurnalai';
$string['logguests'] = 'Registruoti svečio prieigą';
$string['logguests_help'] = 'Šis parametras įjungia svečio paskyros ir neprisijungusių naudotojų veiksmų registravimą. Aukšto profilio svetainėse gali būti norima išjungti šį registravimą, kad našumas būtų geresnis. Produkcinėse svetainėse rekomenduojama palikti šį parametrą įjungtą.';
$string['logininfoinsecurelayout'] = 'Rodyti prisijungusį naudotoją saugiame išdėstyme';
$string['logininfoinsecurelayout_desc'] = 'Jei įjungta, naršymo juostoje bus rodomas visas prisijungusio naudotojo vardas ir pavardė, kai bandoma atlikti testą ar atlikti kitą veiklą naudojant saugų išdėstymą.';
$string['loginpageautofocus'] = 'Automatinio fokusavimo prisijungimo puslapio forma';
$string['loginpageautofocus_help'] = 'Šio pasirinkimo įgalinimas padarys prisijungimo puslapį praktiškesnį, bet fokusuojamos sritys gali turėti pasiekiamumo problemų.';
$string['loglifetime'] = 'Laikyti žurnalus';
$string['logo'] = 'Logotipas';
$string['logo_desc'] = 'Visas logotipas, kuris bus naudojamas kaip kai kurių temų puošmena (pvz., pagrindinės temos). Šis vaizdas gali būti gana didelės skiriamosios gebos, nes jis bus sumažintas naudojimui (ir talpykloje, kad veiktų). Platesni negu aukšti logotipai paprastai duoda geresnių rezultatų.';
$string['logocompact'] = 'Kompaktiškas logotipas';
$string['logocompact_desc'] = 'Kompaktiška to paties logotipo versija, kaip nurodyta aukščiau, pvz., emblema, skydas ar piktograma. Vaizdas turi būti aiškus net esant mažiems dydžiams.';
$string['logossettings'] = 'Logotipai';
$string['logstorenotrequired'] = 'Žurnalų saugykla nebūtina';
$string['logstoressupported'] = 'Žurnalų saugyklos, palaikančios šią ataskaitą';
$string['longtimewarning'] = '<b>Atkreipkite dėmesį, kad šis procesas gali ilgai užtrukti.</b>';
$string['mailnewline'] = 'Naujos eilutės simboliai laiške';
$string['maintenancemode'] = 'Priežiūros režimu';
$string['maintenancemodeisscheduled'] = 'Svetainė bus perjungta į priežiūros režimą {$a->min} minutę {$a->sec} sekundę';
$string['maintenancemodeisscheduledlong'] = 'Svetainė bus perjungta į priežiūros režimą {$a->hour} valandą {$a->min} minutę {$a->sec} sekundę';
$string['maintfileopenerror'] = 'Atidarant priežiūros failus įvyko klaida!';
$string['maintinprogress'] = 'Priežiūra yra vykdoma...';
$string['managecontextlock'] = 'Užšaldyti šį kontekstą';
$string['managecontextlocklocked'] = '{$a->contextname} ir visi žemesni kontekstai yra užšaldyti.';
$string['managecontextlockunlocked'] = '{$a->contextname} ir visi žemesni kontekstai nebėra užšaldyti.';
$string['managecontextunlock'] = 'Nebeužšaldyti šio konteksto';
$string['managecustomfields'] = 'Tvarkykite pasirinktinių laukų tipus';
$string['manageformats'] = 'Tvarkyti kursų formatus';
$string['manageformatsgotosettings'] = 'Numatytasis formatas gali būti pakeistas {$a}';
$string['managelang'] = 'Tvarkyti';
$string['manageqbanks'] = 'Tvarkyti klausimų banko papildinius';
$string['manageqbehaviours'] = 'Tvarkyti klausimų elgseną';
$string['manageqtypes'] = 'Tvarkyti klausimų tipus';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Kandidatinė versija';
$string['maturity200'] = 'Stabili versija';
$string['maturity50'] = 'Alfa';
$string['maturityallowunstable'] = 'Patarimas: Jūs galite paleisti šį scenarijų su --allow-unstable parinktimi.';
$string['maturitycoreinfo'] = 'Jūsų puslapis šiuo metu dirba su nestabiliu "{$a}"  plėtojamu kodu.';
$string['maturitycorewarning'] = 'Ši Moodle versija kurią jūs įrašote ar išplečiate turi nestabilaus "{$a}" plėtojamo kodo kuris nėra skirtas naudotis produkcinėje svetainėje. Jeigu tai nėra ko jūs norite, įsitikinkite kad atnaujinate ir STABILIOS Moodle kodo šakos. Žiūrėti Moodle dokumentus norit daugiau informacijos.';
$string['maxbytes'] = 'Didžiausias įkeliamo failo dydis';
$string['maxcharacter'] = 'Daugiausia simbolių: {$a}';
$string['maxconsecutiveidentchars'] = 'Iš eilės einantys vienodi simboliai';
$string['maxeditingtime'] = 'Maksimalus laikotarpis skelbimams redaguoti';
$string['maxsizeperdownloadcoursefile'] = 'Maksimalus failo dydis';
$string['maxsizeperdownloadcoursefile_desc'] = 'Maksimalus kiekvieno failo dydis atsisiunčiant kurso turinį. Failai, viršijantys šį dydį, nebus atsisiunčiami.';
$string['maxtimelimit'] = 'Maksimalus laiko limitas';
$string['maxtimelimit_desc'] = 'Norėdami apriboti maksimalų PHP vykdymo laiką, kurį Moodle leis nerodant jokios išvesties, įveskite reikšmę čia sekundėmis. 0 reiškia, kad naudojami numatytieji Moodle apribojimai. Jei turite priekinį serverį su savo laiko limitu, nustatykite šią reikšmę mažesnę, kad žurnaluose gautumėte PHP klaidas. Netaikoma CLI scenarijams.';
$string['maxusersperpage'] = 'Daugiausia naudotojų puslapyje';
$string['mbstringrecommended'] = 'Labai rekomenduojama įdiegti pasirinktinę MBSTRING biblioteką, kad būtų galima pagerinti svetainės našumą, ypač jei jūsų svetainėje palaikomos ne lotynų kalbos rašmenimis užrašomos kalbos.';
$string['mbstringrequired'] = 'Norint pagerinti svetainės našumą, būtina įdiegti MBSTRING biblioteką, ypač jei svetainė palaiko ne lotynų kalbas.';
$string['mediapluginavi'] = 'Įjungti .avi filtrą';
$string['mediapluginflv'] = 'Įjungti .flv filtrą';
$string['mediapluginimg'] = 'Įjungti automatinį susietų vaizdų įdėjimą';
$string['mediapluginmov'] = 'Įjungti .mov filtrą';
$string['mediapluginmp3'] = 'Įjungti .mp3 filtrą';
$string['mediapluginmpg'] = 'Įjungti .mpg filtrą';
$string['mediapluginogg'] = 'Įjungti .ogg filtrą';
$string['mediapluginogv'] = 'Įjungti .ogv filtrą';
$string['mediapluginram'] = 'Įjungti .ram filtrą';
$string['mediapluginrm'] = 'Įjungti';
$string['mediapluginrpm'] = 'Įjungti .rpm filtrą';
$string['mediapluginwmv'] = 'Įjungti .wmv filtrą';
$string['mediapluginyoutube'] = 'Įjungti „YouTube“ saitų filtrą';
$string['messaging'] = 'Įjungti žinučių siuntimo sistemą';
$string['messagingallowemailoverride'] = 'Pranešimo el.paštu nepaisymas';
$string['messagingallusers'] = 'Leisti susirašinėti visoje svetainėje';
$string['messagingcategory'] = 'Susirašinėjimas';
$string['messagingdefaultpressenter'] = 'Pagal numatytuosius nustatymus naudoti „Enter“, jei norima siųsti.';
$string['messagingdeleteallnotificationsdelay'] = 'Naikinti visus pranešimus';
$string['messagingdeletereadnotificationsdelay'] = 'Trinti perskaitytus pranešimus';
$string['messagingssettings'] = 'Susirašinėjimo nuostatos';
$string['minpassworddigits'] = 'Skaitmenys';
$string['minpasswordlength'] = 'Slaptažodžio ilgis';
$string['minpasswordlower'] = 'Mažosios raidės';
$string['minpasswordnonalphanum'] = 'Ne raidės ir ne skaitmenys';
$string['minpasswordupper'] = 'Didžiosios raidės';
$string['misc'] = 'Kita';
$string['mlbackendsettings'] = 'Mašininio mokymosi foninės sistemos nustatymai';
$string['mnetrestore_extusers'] = '<strong>Pastaba:</strong> šiame atsarginės kopijos faile yra nuotolinio „Moodle“ tinklo naudotojų paskyrų, kurios bus atkurtos kaip proceso dalis.';
$string['mnetrestore_extusers_admin'] = '<strong>Pastaba:</strong> šis atsarginės kopijos failas yra iš kito „Moodle“ diegimo ir jame yra nuotolinio „Moodle“ tinklo naudotojų paskyrų. Atkūrimo procesas bandys sugretinti visų sukurtų naudotojų „Moodle“ tinklo pagrindinius kompiuterius. Nesutampantys pagrindiniai kompiuteriai bus automatiškai perjungti į vidinio autentifikavimo režimą (vietoje „mnet“). Atkūrimo žurnale apie tai bus pateikta informacija.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Pastaba:</strong> šis atsarginės kopijos failas akivaizdžiai yra iš kito „Moodle“ diegimo ir jame yra nuotolinio „Moodle“ tinklo naudotojų paskyrų, kurių gali nepavykti atkurti. Ši operacija nepalaikoma. Jei esate tikri, kad ji buvo sukurta naudojant šią „Moodle“ įdiegtį, arba galite užtikrinti, kad visi reikalingi „Moodle“ tinklo pagrindiniai kompiuteriai yra sukonfigūruoti, galite vis tiek pabandyti atkurti.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Pastaba:</strong> šis atsarginės kopijos failas yra iš kito „Moodle“ diegimo ir jame yra nuotolinio „Moodle“ tinklo naudotojų paskyrų. Jums neleidžiama vykdyti šio tipo atkūrimo. Kreipkitės į svetainės administratorių arba atkurkite šį kursą be jokios naudotojų informacijos (modulių, failų...).';
$string['mnetrestore_extusers_switchuserauth'] = 'Nuotolinio „Moodle“ tinklo naudotojas {$a->username} (iš {$a->mnethosturl}) persijungė į vietinį {$a->auth} autentifikuotą naudotoją.';
$string['mobilenotconfiguredwarning'] = 'Moodle programėlė neįjungta.';
$string['modassignmentinuse'] = 'Jūsų svetainėje tebenaudojamas 2.2 papildinys „Užduotis 2.2“. Prieš atnaujindami turite: 1) sukurti atsarginę visų Užduotis 2.2 veiklų, kurias norite išsaugoti, kopiją ir atkurti jas kaip užduotis, ir 2) iš duomenų bazės ištrinti visus užduočių 2.2 duomenis.';
$string['modeditdefaults'] = 'Numatytosios veiklos parametrų reikšmės';
$string['modsettings'] = 'Tvarkyti veiklas';
$string['modulesecurity'] = 'Modulio sauga';
$string['moodlebrandedapp'] = 'Firminė „Moodle“ programėlė';
$string['moodlebrandedappreference'] = 'Arba gaukite <a href="https://moodle.com/branded-app/">Moodle programą su prekės ženklu</a> su savo tinkintu prekės ženklu.';
$string['mustenablestats'] = 'Šioje svetainėje dar neįjungta statistika.';
$string['mycourses'] = 'Mano kursai';
$string['mydashboard'] = 'Sistemos numatytoji ataskaitų sritis';
$string['mymoodle'] = 'Mano pagrindinis';
$string['mypage'] = 'Numatytasis Mano pagrindinis puslapis';
$string['mypagelocked'] = 'Užrakinti numatytąjį puslapį';
$string['myprofile'] = 'Numatytasis profilio puslapis';
$string['navadduserpostslinks'] = 'Pridėti sąsaja naudotojo žinučių peržiūrai';
$string['navadduserpostslinks_help'] = 'Kai įjungta dvi sąsajos bus pridėtos kiekvienam naudotojui navigacijoje kad būtų galima peržiūrėti diskusijas kurias naudotojas pradėjo ir žinutes kurias naudotojas parašė forume per visą svetainę ar konkretų kursą.';
$string['navcourselimit'] = 'Kursų limitas';
$string['navfilter'] = 'Filtro pasirinktinis meniu';
$string['navigationupgrade'] = 'Šis versijos naujinimas pateikia du naujus naršymo blokus, kurie pakeis šiuos blokus: Administravimas, Kursai, Veiklos ir Dalyviai. Jei šiuos blokuose buvote nustatę specialių teisių, turėtumėte patikrinti ir įsitikinti, kad viskas veikia taip, kaip norite.';
$string['navshowallcourses'] = 'Rodyti visus kursus';
$string['navshowcategories'] = 'Rodyti kursų kategorijas';
$string['navshowfrontpagemods'] = 'Rodyti svetainės pradinio puslapio veiklas navigacijoje';
$string['navshowfrontpagemods_help'] = 'Jei įgalinta, pradinio puslapio veiklos bus rodomos navigacijoje po svetainės puslapiais. Šis nustatymas taikomas tik Klasikinės versijos temoms.';
$string['navshowfullcoursenames'] = 'Rodyti kurso pilną pavadinimą';
$string['navshowfullcoursenames_help'] = 'Jei įjungta, navigacijoje bus naudojami pilni kursų pavadinimai, o ne trumpi pavadinimai.';
$string['navshowmycoursecategories'] = 'Rodyti mano kurso kategorijas';
$string['navshowmycoursecategories_help'] = 'Jei įgalinta, kursai naudotojo mano kursų šakoje bus rodomi kategorijose (tik Klasikinės temos).';
$string['navsortmycourseshiddenlast'] = 'Paslėptus kursus surūšiuoti paskutinius';
$string['navsortmycourseshiddenlast_help'] = 'Jei įjungta, visi paslėpti kursai bus pateikti po matomų kursų (naudotojams, kurie gali peržiūrėti paslėptus kursus). Kitu atveju visi kursai, neatsižvelgiant į jų matomumą, bus išvardyti pagal nustatymą „Rūšiuoti mano kursus“.';
$string['navsortmycoursessort'] = 'Kursų tvarka navigacijos bloke';
$string['navsortmycoursessort_help'] = 'Ar kursai turėtų būti išvardyti pagal Svetainės administravimas > Kursai > Tvarkyti kursus ir kategorijas nustatytą rikiavimo tvarką, ar abėcėlės tvarka pagal kurso nustatymus? Šis nustatymas taikomas tik temoms, pagrįstoms Classic.';
$string['never'] = 'Niekada';
$string['neverdeleteruns'] = 'Niekada nenaikinti vykdymų';
$string['newestdocindexed'] = 'Naujausias dokumentas indeksuotas';
$string['nobookmarksforuser'] = 'Neturite jokių žymelių.';
$string['nodatabase'] = 'Nėra duomenų bazės';
$string['noemaileverwarning'] = '<strong>Pastaba:</strong> visi siunčiami el. laiškai buvo išjungti';
$string['nohttpsformobilewarning'] = 'Yra rekomenduojama įgalinti HTTPS su galiojančiu sertifikatu. Moodle programėlė visada pirmiausia bandys naudoti apsaugotą ryšį.';
$string['nomissingstrings'] = 'Nėra trūkstamų eilučių';
$string['none'] = 'Nėra';
$string['nonewsettings'] = 'Šio versijos naujinimo metu neįtraukta jokių naujų parametrų';
$string['nonexistentbookmark'] = 'Žymelės, kurios užklausą pateikėte, nėra.';
$string['noreplyaddress'] = 'No-reply adresas';
$string['noreplydomain'] = 'Neatsakyti ir domenas';
$string['noreplydomaindetail'] = 'Neatsakyti ir sukonfigūruotų domenų nustatymai';
$string['noresults'] = 'Rezultatų nerasta.';
$string['noroles'] = 'Nėra vaidmenų';
$string['nosupportedlogstore'] = 'Nerasta palaikomų žurnalų saugyklos';
$string['noteunneededblocks'] = 'Pastaba: blokai, nustatyti "rodyti", nebus įtraukti į kurso meniu „Pridėti bloką“, jei jie nurodyti temos nustatyme „Nereikalingi blokai“.';
$string['notifications'] = 'Pranešimai';
$string['notifyloginfailures'] = 'Siųsti prisijungimo klaidas el. laišku';
$string['notifyloginthreshold'] = 'El. pašto pranešimų riba';
$string['notloggedinroleid'] = 'Lankytojų vaidmuo';
$string['numberofmissingstrings'] = 'Trūkstamų eilučių skaičius: {$a}';
$string['numberofstrings'] = 'Bendras eilučių skaičius: {$a->strings}<br />trūksta: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'Vienos iš „OAuth“ paslaugų {$a->issuer} atnaujinimo prieigos raktas jūsų svetainėje {$a->siteurl} nebegalioja. Tai apribos bet kokių priedų, naudojančių šią paslaugą, funkcionalumą. Norėdami išspręsti šią problemą, apsilankykite „OAuth 2 Services“ konfigūracijos puslapyje ir šios paslaugos lentelės eilutėje spustelėkite piktogramą „Prijungti sistemos paskyrą“. Būtinai kiekvieną kartą prisijunkite naudodami tą pačią „OAuth“ sistemos paslaugos paskyrą.';
$string['oauthrefreshtokenexpiredshort'] = 'Baigėsi {$a->issuer} „OAuth“ atnaujinimo prieigos raktas jūsų svetainėje {$a->siteurl}.';
$string['onlynoreply'] = 'Tik kai nuo adreso be galimybės atsakyti';
$string['opcacherecommended'] = 'PHP operacinės kodo talpyklos kaupimas pagerina našumą ir sumažina atminties poreikį, rekomenduojamas ir visiškai palaikomas OPcache plėtinys.';
$string['opensslrecommended'] = 'Ypač rekomenduojama įdiegti pasirinktinę „OpenSSL“ biblioteką, kad būtų įjungtos „Moodle“ darbo tinkle funkcijos.';
$string['opensslrequired'] = 'Moodle dabar reikalauja OpenSSL PHP plėtinio stipresnės kriptografinės paslaugos teikimui.';
$string['opentowebcrawlers'] = 'Atidaryti „Google“';
$string['optionalmaintenancemessage'] = 'Pasirinktinės priežiūros žinutė';
$string['order1'] = 'Pirmas';
$string['order2'] = 'Antras';
$string['order3'] = 'Trečias';
$string['order4'] = 'Ketvirtas';
$string['outgoingmailconfig'] = 'Išsiunčiamo pašto konfigūracija';
$string['overridetossl'] = 'Prisijungimams skirtas HTTPS dabar nebenaudojamas. Šis atvejis dabar priverstas naudoti SSL. Norėdami ištaisyti šį įspėjimą, pakeiskite savo wwwroot failą config.php į https://';
$string['pageinfodebugsummary'] = 'Šis puslapis yra: {$a}';
$string['passwordchangelogout'] = 'Atjungti po slaptažodžio keitimo';
$string['passwordchangelogout_desc'] = 'Jei įjungta, kai pakeičiamas slaptažodis, visos naršyklės sesijos yra nutraukiamos, išskyrus tą, kurioje nurodytas naujas slaptažodis. (Šis nustatymas neturi įtakos slaptažodžio pakeitimams masinio naudotojo įkėlimo metu.)';
$string['passwordchangetokendeletion'] = 'Pašalinti žiniatinklio paslaugų prieigos požymius po slaptažodžio keitimo';
$string['passwordchangetokendeletion_desc'] = 'Jei įjungta, pakeitus slaptažodį, visi naudotojo žiniatinklio paslaugų prieigos požymiai  bus panaikinti.';
$string['passwordpolicy'] = 'Reikalavimai slaptažodžiui';
$string['passwordpolicycheckonlogin'] = 'Tikrinti slaptažodį jungiantis';
$string['passwordresettime'] = 'Maksimalus laikas patvirtinti slaptažodį iš naujo';
$string['passwordreuselimit'] = 'Slaptažodžio kaitaliojimo limitas';
$string['passwordreuselimit_desc'] = 'Kiek kartų naudotojas turi pakeisti slaptažodį, kad jam būtų leista pakartotinai jį naudoti. Anksčiau naudotų slaptažodžių maišos yra saugomos vietinėje duomenų bazės lentelėje. Ši funkcija gali būti nesuderinama su kai kuriais išoriniais autentifikavimo papildiniais.';
$string['pathtodot'] = 'Kelias į „dot“';
$string['pathtodot_help'] = 'Kelias į tašką. Linux sistemoje tai kažkas panašaus į /usr/bin/dot. „Windows“ sistemoje tai yra kažkas panašaus į C:\\Program Files (x86)\\Graphviz2.38\\bin\\dot.exe. „Mac“ sistemoje tai yra kažkas panašaus į /opt/local/bin/dot. Kad galėtumėte generuoti grafiką iš DOT failų, turite įdiegti taško vykdomąjį failą ir nurodyti jį čia.';
$string['pathtodu'] = 'Kelias į „du“';
$string['pathtogs'] = 'Kelias į ghostscript';
$string['pathtogs_help'] = 'Daugumoje „Linux“ diegimų tai gali būti palikta kaip „/usr/bin/gs“. „Windows“ sistemoje tai bus kažkas panašaus į „c:\\gs\\bin\\gswin32c.exe“ (įsitikinkite, kad kelyje nėra tarpų – jei reikia, nukopijuokite failus „gswin32c.exe“ ir „gsdll32.dll“ į naują aplanką be tarpo kelyje)';
$string['pathtopdftoppm'] = 'Kelias į pdftoppm';
$string['pathtopdftoppm_help'] = '<a href="https://poppler.freedesktop.org/">Poppler</a> yra PDF atvaizdavimo biblioteka, kurioje yra įrankis pdftoppm, skirtas PDF failams konvertuoti į PNG. Našumas paprastai yra geresnis nei naudojant Ghostscript, ypač dideliems failams. Jei įmanoma, bus naudojamas pdftoppm, o ne Ghostscript. Daugumoje „Linux“ diegimų kelias gali būti paliktas kaip /usr/bin/pdftoppm. Kitu atveju, atsižvelgiant į „Linux“ platinimą, turite įdiegti „poppler-utils“ arba „poppler“ paketą. Sistemoje „Windows“ ją teikia „Cygwin“ diegimas.';
$string['pathtopgdump'] = 'Kelias į „pg_dump“';
$string['pathtopgdumpdesc'] = 'Jį būtina įvesti tik tada, jei jūsų sistemoje yra daugiau nei vienas „pg_dump“ (pavyzdžiui, jei turite daugiau nei vieną įdiegtą „postgresql“ versiją)';
$string['pathtopgdumpinvalid'] = 'Neleistinas kelias į „pg_dump“ – klaidingas kelias arba tai nėra vykdomasis failas';
$string['pathtophp'] = 'Kelias į PHP CLI';
$string['pathtopsql'] = 'Kelias į „psql“';
$string['pathtopsqldesc'] = 'Jį būtina įvesti tik tada, jei jūsų sistemoje yra daugiau nei vienas „psql“ (pavyzdžiui, jei turite daugiau nei vieną įdiegtą „postgresql“ versiją)';
$string['pathtopsqlinvalid'] = 'Neleistinas kelias į „psql“ – klaidingas kelias arba tai nėra vykdomasis failas';
$string['pathtopython'] = 'Kelias į Python';
$string['pathtopythondesc'] = 'Kelias į jūsų vykdomąjį Python dvejetainį failą (tinka ir Python 2, ir Python 3).';
$string['pathtosassc'] = 'Kelias į SassC';
$string['pathtosassc_help'] = 'Nurodę SassC dvejetainio failo vietą, SASS kompiliatorius bus perjungtas iš Moodle PHP diegimo į SassC. Daugiau informacijos rasite adresu https://github.com/sass/sassc.';
$string['pcreunicodewarning'] = 'PCRE PHP išplėtimo, kuris yra suderinamas su Unicode simboliais naudojimas yra labai rekomenduotinas.';
$string['perfdebug'] = 'Našumo informacija';
$string['performance'] = 'Našumas';
$string['pgcluster'] = '„PostgreSQL“ klasteris';
$string['pgclusterdescription'] = '„PostgreSQL“ versijos / telkinio komandų eilutės operacijų parametras. Jei jūsų sistemoje yra tik vienas „postgresql“ arba nesate tikri, kas tai yra, palikite šį parametrą tuščią.';
$string['phpfloatproblem'] = 'Aptikta nenumatytų problemų apdorojant PHP slankiųjų duomenų numerius –  {$a}';
$string['pid'] = 'PID';
$string['pleaserefreshregistration'] = 'Jūsų svetainė užregistruota. Registracija paskutinį kartą atnaujinta {$a}.<br />Suplanuota užduotis „Svetainės registracija“ atnaujina jūsų registraciją. Taip pat galite bet kada rankiniu būdu atnaujinti savo registraciją.';
$string['pleaserefreshregistrationnewdata'] = 'Pasikeitė registracijos informacija. Patvirtinkite tai naudodami mygtuką „Atnaujinti registraciją“.';
$string['pleaserefreshregistrationunknown'] = 'Jūsų svetainė užregistruota, bet registracijos data nežinoma. Atnaujinkite savo registraciją naudodami mygtuką „Atnaujinti registraciją“ arba įsitikinkite, kad įjungta suplanuota užduotis „Svetainės registracija“, kad jūsų registracija būtų atnaujinta automatiškai.';
$string['plugin'] = 'Papildinys';
$string['plugin_disabled'] = '{$a} išjungtas.';
$string['plugin_enabled'] = '{$a} įjungtas.';
$string['plugins'] = 'Papildiniai';
$string['pluginscheck'] = 'Papildinio priklausomybių patikrinimas';
$string['pluginscheckfailed'] = 'Priklausomybių patikrinimas nepavyko {$a->pluginslist}';
$string['pluginschecktodo'] = 'Pradžiai turite išspręsti visus papildinių reikalavimus prieš įrašant naują Moodle versiją!';
$string['pluginsoverview'] = 'Papildinių peržiūra';
$string['pluginsoverviewsee'] = 'Žiūrėti <a href="{$a->url}"> papildinių peržiūros</a>  puslapį, kad gauti daugiau informacijos.';
$string['policysettings'] = 'Politikos nustatymai';
$string['privacy:metadata'] = 'Valdymo papildinys nesaugo jokių asmeninių duomenų.';
$string['privacyandpolicies'] = 'Privatumas ir politika';
$string['privacysettings'] = 'Privatumo nustatymai';
$string['profilecategory'] = 'Kategorija';
$string['profilecategoryname'] = 'Kategorijos pavadinimas (turi būti unikalus)';
$string['profilecategorynamenotunique'] = 'Šis kategorijos pavadinimas jau naudojamas';
$string['profilecommonsettings'] = 'Bendrieji nustatymai';
$string['profileconfirmcategorydeletion'] = 'Šioje kategorijoje yra {$a} laukai (-ų), kurie bus perkelti į aukščiau esančią kategoriją (arba į žemiau esančią kategoriją, jei tai aukščiausio lygio kategorija.<br />Ar vis tiek norite panaikinti šią kategoriją?';
$string['profileconfirmfielddeletion'] = 'Yra {$a} šio lauko naudotojo įrašai (-ų), kurie bus panaikinti.<br />Ar vis tiek norite panaikinti šį lauką?';
$string['profilecreatecategory'] = 'Kurti naują profilio kategoriją';
$string['profilecreatefield'] = 'Kurti naują profilio lauką';
$string['profilecreatenewcategory'] = 'Kuriama nauja kategorija';
$string['profilecreatenewfield'] = 'Kuriamas naujas &quot;{$a}&quot; profilio laukas';
$string['profiledefaultcategory'] = 'Kiti laukai';
$string['profiledefaultchecked'] = 'Pažymėta pagal numatytuosius parametrus';
$string['profiledefaultdata'] = 'Numatytoji reikšmė';
$string['profiledeletecategory'] = 'Naikinama kategorija';
$string['profiledeletefield'] = 'Naikinamas laukas';
$string['profiledescription'] = 'Lauko aprašymas';
$string['profiledscript'] = 'Šis scenarijus buvo profiliuotas';
$string['profiledscriptview'] = 'Peržiūrėti šio scenarijaus profiliavimo informaciją';
$string['profileeditcategory'] = 'Redaguojama kategorija: {$a}';
$string['profileeditfield'] = 'Redaguojamas profilio laukas: {$a}';
$string['profilefield'] = 'Profilio laukas';
$string['profilefieldcolumns'] = 'Stulpeliai';
$string['profilefieldispassword'] = 'Ar tai yra slaptažodžio laukas?';
$string['profilefieldlink'] = 'Saitas';
$string['profilefieldlink_help'] = 'Norėdami pakeisti nuorodą į tekstą, įveskite URL, kuriame būtų $$, kur $$ bus pakeisti tekstu. Pavyzdžiui, norėdami pakeisti „Twitter“ ID į nuorodą, įveskite https://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Saito tikslinė vieta';
$string['profilefieldmaxlength'] = 'Simbolių limitas';
$string['profilefieldmaxlength_help'] = 'Norint naudoti šį lauką nustatyme "Rodyti naudotojo tapatybę", turi būti ne daugiau kaip 255 simboliai.';
$string['profilefieldrows'] = 'Eilutės';
$string['profilefields'] = 'Naudotojo profilio laukai';
$string['profilefieldsize'] = 'Rodymo dydis';
$string['profileforceunique'] = 'Ar duomenys turėtų būti unikalūs?';
$string['profileinvaliddata'] = 'Neleistina reikšmė';
$string['profilelocked'] = 'Ar šis laukas užrakintas?';
$string['profilemenudefaultnotinoptions'] = 'Numatytoji reikšmė nėra viena iš parinkčių';
$string['profilemenunooptions'] = 'Nepateikta jokių menių parinkčių';
$string['profilemenuoptions'] = 'Meniu parinktys (viena kiekvienoje eilutėje)';
$string['profilemenutoofewoptions'] = 'Turite pateikti mažiausiai 2 parinktis';
$string['profilename'] = 'Pavadinimas';
$string['profilenofieldsdefined'] = 'Neapibrėžta jokių laukų';
$string['profilerequired'] = 'Ar šis laukas būtinas?';
$string['profileroles'] = 'Profilio matomi vaidmenys';
$string['profilesforenrolledusersonly'] = 'Tik įsiregistravusių naudotojų profiliai';
$string['profileshortname'] = 'Trumpasis pavadinimas (turi būti unikalus)';
$string['profileshortnameinvalid'] = 'Šiame trumpajame pavadinime gali būti tik raidės ir skaitmeniniai simboliai (raidės ir skaičiai) arba apatinis brūkšnelis (_).';
$string['profileshortnamenotunique'] = 'Šis trumpasis pavadinimas jau naudojamas';
$string['profilesignup'] = 'Ar rodyti registracijos puslapyje?';
$string['profilespecificsettings'] = 'Konkretūs parametrai';
$string['profilevisible'] = 'Kam matomas šis laukas?';
$string['profilevisible_help'] = '* Nematomas – skirtas privatiems duomenims, kuriuos gali peržiūrėti tik administratoriai
* Matomas naudotojui – skirtas privatiems duomenims, kuriuos gali peržiūrėti tik naudotojas ir administratoriai
* Matomas naudotojui, dėstytojams ir administratoriams - skirtas privatiems duomenims, kuriuos gali peržiūrėti tik naudotojas, administratoriai ir dėstytojai (kurso profilyje)
* Matomas visiems';
$string['profilevisibleall'] = 'Matomas visiems';
$string['profilevisiblenone'] = 'Nematomas';
$string['profilevisibleprivate'] = 'Matomas naudotojui';
$string['profilevisibleteachers'] = 'Matoma naudotojams, dėstytojams ir administratoriams';
$string['profiling'] = 'Profiliavimas';
$string['profilingallowall'] = 'Nuolatinis profiliavimas';
$string['profilingallowall_help'] = 'Jei įjungsite šį parametrą, bet kuriuo metu galėsite bet kur naudoti parametrą PROFILEALL (PGC), kad įjungtumėte visų per „Moodle“ seansus vykdomų scenarijų profiliavimą. Taip pat galite naudoti parametrą PROFILEALLSTOP, kad jį sustabdytumėte.';
$string['profilingallowme'] = 'Atrankinis profiliavimas';
$string['profilingallowme_help'] = 'Jei įjungsite šį parametrą, galėsite atrankiniu būdu bet kur naudoti parametrą PROFILEME (PGC) ir bus atliktas to scenarijaus profiliavimas. Taip pat galite naudoti parametrą DONTPROFILEME, kad uždraustumėte atlikti profiliavimą.';
$string['profilingautofrec'] = 'Automatinis profiliavimas';
$string['profilingautofrec_help'] = 'Sukonfigūravus šį nustatymą, kai kurios užklausos (atsitiktinai, remiantis nurodytu dažniu – 1 iš N) bus parenkamos ir automatiškai profiliuojamos, išsaugodamos rezultatus tolesnei analizei. Atminkite, kad šis profiliavimo būdas atsižvelgia į įtraukimo / neįtraukimo nustatymus. Norėdami išjungti automatinį profiliavimą, nustatykite jį į 0.';
$string['profilingenabled'] = 'Įjungti profiliavimą';
$string['profilingenabled_help'] = 'Jei įjungsite šį parametrą, šioje  svetainėje bus galimas profiliavimas ir galėsite apibrėžti jo veikimą konfigūruodami paskesnes parinktis.';
$string['profilingexcluded'] = 'Neįtraukti profiliavimo';
$string['profilingexcluded_help'] = 'Sąrašas (atskirtas kableliais arba naujomis eilutėmis, absoliučiai praleidžiamas wwwroot, iškviečiamas) URL, kurie nebus profiliuojami iš tų, kurie apibrėžti nustatant „Profiluoti šiuos“.';
$string['profilingimportprefix'] = 'Profiliavimo importo priešdėlis';
$string['profilingimportprefix_desc'] = 'Kad būtų lengviau aptikti, prie visų importuotų profiliavimo paleidimų bus nurodyta čia nurodyta vertė.';
$string['profilingincluded'] = 'Profiliuoti šiuos';
$string['profilingincluded_help'] = 'Sąrašas (atskirtas kableliais arba naujomis eilutėmis, absoliučiai praleidžiamas wwwroot, iškviečiamas) URL, kurie bus automatiškai profiliuojami. Pavyzdžiai: /index.php, /course/view.php. Taip pat priima * wildchar bet kurioje padėtyje. Pavyzdžiai: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Laikyti profiliavimo vykdymus';
$string['profilinglifetime_help'] = 'Nurodykite, kiek laiko norite laikyti informaciją apie senus profiliavimo vykdymus. Senesni profiliavimai bus reguliariai šalinami. Atkreipkite dėmesį, kad neįtraukiami jokie profiliavimo vykdymai, pažymėti kaip „nuorodinis vykdymas“.';
$string['profilingslow'] = 'Lėti profilio puslapiai';
$string['profilingslow_help'] = 'Nustačius minimalų laiką sekundėmis, visi puslapiai bus lėtesni. Bus saugomi tik tie profiliai, kurie yra lėtesni už esamą to paties scenarijaus profilį. Norėdami išjungti, nustatykite 0. Atminkite, kad taip atsižvelgiama į išskyrimo nustatymus.';
$string['protectusernames'] = 'Apsaugoti naudotojų vardus';
$string['proxybypass'] = 'Tarpinio serverio apėjimo pagrindiniai kompiuteriai';
$string['proxyfixunsafe'] = 'Taisyti neįgaliotus kreipimusis';
$string['proxyhost'] = 'Tarpinio serverio pagrindinis kompiuteris';
$string['proxylogunsafe'] = 'Registruoti neįgaliotus kreipimusis';
$string['proxypassword'] = 'Tarpinio serverio slaptažodis';
$string['proxyport'] = 'Tarpinio serverio prievadas';
$string['proxytype'] = 'Tarpinio serverio tipas';
$string['proxyuser'] = 'Tarpinio serverio naudotojo vardas';
$string['purgecaches'] = 'Valyti visas talpyklas';
$string['purgecachesconfirm'] = '„Moodle“ gali talpinti temas, „Javascript“, kalbos eilutes, filtruotą tekstą, RSS informacijos santraukas ir daug kitų apskaičiuotų duomenų vienetų. Išvalius tokias talpyklas, šie duomenys bus panaikinti iš serverio, o naršyklės turės pakartotinai gauti duomenis, kad galėtumėte būti įsitikinę, jog peržiūrite pačias naujausias dabartinio kodo sukurtas reikšmes. Valyti talpyklas nepavojinga, bet svetainė gali veikti lėčiau, kol serveris ir klientai skaičiuos ir talpins naują informaciją.';
$string['purgecachesfinished'] = 'Visos talpyklos buvo išvalytos';
$string['purgecachesnoneselected'] = 'Pasirinkite vieną ar daugiau talpyklų, kurias norite išvalyti';
$string['purgecachespage'] = 'Išvalyti talpyklas';
$string['purgecoursecache'] = 'Kursai';
$string['purgefiltercache'] = 'Teksto filtrai';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Kalbos eilutės';
$string['purgemuc'] = 'Visos MUC talpyklos';
$string['purgeothercaches'] = 'Visi failai ir įvairios talpyklos';
$string['purgeselectedcaches'] = 'Išvalyti pasirinktas talpyklas';
$string['purgeselectedcachesfinished'] = 'Pasirinktos talpyklos buvo išvalytos.';
$string['purgetemplates'] = 'Šablonai';
$string['purgethemecache'] = 'Temos';
$string['query'] = 'Užklausa';
$string['question'] = 'Klausimas';
$string['questionbehaviours'] = 'Klausimų elgsena';
$string['questioncwqpfscheck'] = 'Vienas ar keli atsitiktiniai testo klausimai yra nustatyti, kad būtų galima pasirinkti klausimus iš bendrinamų ir nebendrinamų klausimų kategorijų. Žr. <a href="{$a->reporturl}">atsitiktinių klausimų ataskaitą</a> ir <a href="{$a->docsurl}">dokumentaciją</a>.';
$string['questioncwqpfsok'] = 'Gerai. Jūsų testuose nėra „atsitiktinių“ klausimų, kurie nustatyti pasirinkti klausimus iš bendrai naudojamų ir nenaudojamų klausimų kategorijų mišinio.';
$string['questiontype'] = 'Klausimo tipas';
$string['questiontypes'] = 'Klausimų tipai';
$string['quizattemptsupgradedmessage'] = 'Moodle 2.1 buvo esminis klausimų atnaujinimas. Buvo galima atidėti kai kurias duomenų bazės naujinimo dalis, kad jos būtų paleistos vėliau. Prieš atnaujinant į Moodle 2.7, šis atnaujinimas turi būti baigtas.';
$string['recaptchaprivatekey'] = '„ReCAPTCHA“ slaptasis raktas';
$string['recaptchapublickey'] = '„ReCAPTCHA“ svetainės raktas';
$string['referrernone'] = 'Numatytoji naršyklės parinktis';
$string['referrerpolicy'] = 'Persiuntimo politika';
$string['referrerpolicydesc'] = 'Nustatykite persiuntimo politikos antraštę, kuri būtų įtraukta į atsakymus iš jūsų svetainės.';
$string['register'] = 'Užregistruoti Jūsų svetainę';
$string['registration'] = 'Registracija';
$string['registration_help'] = 'Registruojantis:

* Gaunate saugos įspėjimus
* Galite suaktyvinti mobiliųjų programų tiesioginius pranešimus iš savo svetainės
* Jūs prisidedate prie mūsų pasaulinės bendruomenės Moodle statistikos';
$string['registrationwarning'] = 'Nepraleiskite svarbių atnaujinimų ir įspėjimų apie saugumą.';
$string['registrationwarningcontactadmin'] = 'Ši svetainė nėra registruota. Paprašykite administratoriaus užregistruoti svetainę, kad jis nepraleistų svarbių atnaujinimų.';
$string['releasenoteslink'] = 'Informacijos apie šią „Moodle“ versiją, žr. internete esančias <a target="_blank" href="{$a}">Laidos pastabas</a>';
$string['rememberuserlicensepref'] = 'Prisiminti naudotojo licencijos nuostatas';
$string['rememberuserlicensepref_help'] = 'Jei įjungta, įkeliant failą į failų rinkiklį iš anksto pasirenkama paskutinė naudotojo pasirinkta licencija. Kitu atveju iš anksto pasirenkama numatytoji svetainės licencija.';
$string['rememberusername'] = 'Prisiminti naudotojo vardą';
$string['rememberusername_desc'] = 'Įjunkite jei norite saugoti nuolatinius slapukus su naudotojų vardais kol naudotojas prisijungęs. Nuolatiniai slapukai gali būti palaikyti privatumo pažeidimu jei naudojami be sutikimo.';
$string['replacefrontsearch'] = 'Naudojama svetainės pradžios kurso paieškai';
$string['reportsmanage'] = 'Tvarkyti pranešimus';
$string['required'] = 'Privalomas';
$string['requiredentrieschanged'] = 'Pastaba: Atnaujinus, nustatymas „Būtini įrašai prieš peržiūrint“  bus vykdomas šiose duomenų bazės veiklose: <br/>{$a->text}<br/>';
$string['requiremodintro'] = 'Reikalauti veiklos aprašo';
$string['requiremodintro_desc'] = 'Jei įjungta, naudotojai privalės įvesti aprašymą kiekvienai veiklos sričiai.';
$string['requires'] = 'Būtina';
$string['resetindentation'] = 'Atstatyti įtraukas visoje svetainėje';
$string['resetindentation_help'] = 'Tai pašalins visas anksčiau nustatytas įtraukas visiems kursams visoje svetainėje su „{$a->format}“ formatu.';
$string['resetindentation_title'] = 'Atstatyti įtraukas visoje svetainėje?';
$string['resetindentationsuccess'] = 'Įtraukos atstatymas.';
$string['restorecourse'] = 'Atkurti kursą';
$string['restorernewroleid'] = 'Atkūrėjo vaidmuo kursuose';
$string['restorernewroleid_help'] = 'Jei naudotojas dar neturi leidimo tvarkyti naujai restauruotus kursus, naudotojas automatiškai yra priskiriamas šiaip rolei ir išregistruojamas jei reikia. Pasirinkite „Joks“ jei jūs nenorite kad restauratoriai galėtų tvarkyti kiekvieną restauruotą kursą.';
$string['resultfilter'] = 'Filtruoti pagal rezultatą';
$string['reverseproxy'] = 'Atvirkštinis tarpinis serveris';
$string['reverseproxyignore'] = 'Ignoruoti atvirkštinius tarpinius serverius';
$string['riskconfig'] = 'Naudotojai galėtų keisti svetainės konfigūraciją ir veikimą';
$string['riskconfigshort'] = 'Konfigūracijos pavojus';
$string['riskdataloss'] = 'Naudotojai galėtų sunaikinti daug turinio ar informacijos';
$string['riskdatalossshort'] = 'Duomenų praradimo pavojus';
$string['riskmanagetrust'] = 'Naudotojai galėtų keisti kitų naudotojų patikimumo parametrus';
$string['riskmanagetrustshort'] = 'Valdyti patikimumą';
$string['riskpersonal'] = 'Naudotojai galėtų gauti prieigą prie kitų naudotojų asmeninės informacijos';
$string['riskpersonalshort'] = 'Privatumo pavojus';
$string['riskspam'] = 'Naudotojai galėtų siųsti pašto šiukšles svetainės naudotojams ar kitiems asmenims';
$string['riskspamshort'] = 'Pašto šiukšlių pavojus';
$string['riskxss'] = 'Naudotojai galėtų įtraukti failus ir tekstus, kuriuose leidžiami kryžminių svetainių scenarijai (XSS)';
$string['riskxssshort'] = 'XSS pavojus';
$string['roleswithexceptions'] = '{$a->roles} su {$a->exceptions}';
$string['rssglobaldisabled'] = 'Išjungta svetainės lygiu';
$string['save'] = 'Įrašyti';
$string['savechanges'] = 'Įrašyti keitimus';
$string['scssinvalid'] = 'SCSS kodas negalioja, neatitinka: {$a}';
$string['search'] = 'Ieškoti';
$string['searchablecourses'] = 'Ieškomi kursai';
$string['searchallavailablecourses'] = 'Ieškomi kursai';
$string['searchallavailablecourses_desc'] = 'Kai kuriais atvejais paieškos variklis gali neveikti ieškant daugelyje kursų. Jei reikia apriboti ieškomų kursų skaičių, nustatykite ieškoti tik įregistruotų kursų.';
$string['searchallavailablecourses_off'] = 'Ieškoti tik kursuose, kuriuose esate įregistruotas';
$string['searchallavailablecourses_on'] = 'Ieškoti visuose kursuose, kuriuos gali pasiekti naudotojas';
$string['searchallavailablecoursesdesc'] = 'Jei nustatyta ieškoti tik įregistruotuose kursuose, kursų informacijos (pavadinimo ir santraukos) ir kurso turinio bus ieškoma tik tuose kursuose, kuriuose naudotojas yra įsiregistravęs. Priešingu atveju kursų informacijos ir kursų turinio bus ieškoma visuose kursuose, kuriuos naudotojas gali pasiekti. , pvz., kursai su įjungta svečių prieiga.';
$string['searchalldeleted'] = 'Visas indeksuotas turinys buvo panaikintas';
$string['searchalternatesettings'] = 'Alternatyvūs tik užklausų nustatymai';
$string['searchalternatesettings_desc'] = 'Jei užbaigsite šiuos nustatymus, puslapyje „Tvarkyti visuotinę paiešką“ galite pasirinkti „alternatyvius nustatymus“ šiam paieškos varikliui. Tai naudinga tik pereinant tarp dviejų to paties tipo paieškos sistemų.';
$string['searchareadisabled'] = 'Paieškos laukas išjungtas';
$string['searchareaenabled'] = 'Paieškos laukas įjungtas';
$string['searchareas'] = 'Paieškos laukai';
$string['searchbanner'] = 'Ieškoti informacijos';
$string['searchbannerenable'] = 'Rodyti paieškos informaciją';
$string['searchbannerenable_desc'] = 'Jei įjungta, toliau pateiktas tekstas bus rodomas visiems naudotojams paieškos ekrano viršuje. Tai gali būti naudojama informuojant naudotojus, kai atliekama paieškos variklio priežiūra.';
$string['searchdefaultcategory'] = 'Numatytoji paieškos kategorija';
$string['searchdefaultcategory_desc'] = 'Pasirinktos paieškos srities kategorijos rezultatai bus rodomi pagal numatytuosius nustatymus.';
$string['searchdeleteindex'] = 'Ištrinti visą indeksuotą turinį';
$string['searchdisplay'] = 'Paieškos rezultatų rodymo parinktys';
$string['searchenablecategories'] = 'Rodyti rezultatus atskirose kategorijose';
$string['searchenablecategories_desc'] = 'Jei įjungta, paieškos rezultatai bus rodomi atskirose kategorijose.';
$string['searchengine'] = 'Paieškos sistema';
$string['searchenginealternatesettings'] = '{$a} (alternatyvūs nustatymai)';
$string['searchenginequeryonly'] = 'Paieškos variklis tik užklausoms';
$string['searchenginequeryonly_desc'] = 'Ši paieškos sistema bus naudojama tik užklausoms pateikti, o ne indeksuoti. Naudodami šią funkciją galite iš naujo indeksuoti kitą paieškos variklį, o naudotojų užklausos ir toliau veiks iš šio.';
$string['searchenginequeryonly_none'] = 'Nėra (užklausoms naudokite pagrindinį paieškos variklį)';
$string['searchenginequeryonlysame'] = 'Užklausos paieškos variklio ir pagrindinio paieškos variklio reikšmės negali būti nustatytos tos pačios vertės.';
$string['searchhideallcategory'] = 'Slėpti visas rezultatų kategorijas';
$string['searchhideallcategory_desc'] = 'Jei pažymėta, kategorija su visais rezultatais bus paslėpta paieškos rezultatų ekrane.';
$string['searchincludeallcourses'] = 'Įtraukti visus matomus kursus';
$string['searchincludeallcourses_desc'] = 'Jei įjungta, paieškos rezultatuose bus įtraukta kursų informacija (pavadinimas ir santrauka), kurias matys naudotojas, net jei jis neturi prieigos prie kurso turinio.';
$string['searchindexactions'] = 'Indekso veiksmai';
$string['searchindexdeleted'] = 'Indeksas pašalintas';
$string['searchindextime'] = 'Indeksavimo laiko limitas';
$string['searchindextime_desc'] = 'Indeksuojant didelius kiekius naujo turinio, suplanuota užduotis sustos pasibaigus šiam terminui. Tai tęsis kitą kartą, kai bus vykdoma užduotis.';
$string['searchindexupdated'] = 'Paieškos sistemos turinys buvo atnaujintas';
$string['searchindexwhendisabled'] = 'Indeksas išjungus';
$string['searchindexwhendisabled_desc'] = 'Leidžia suplanuotai užduočiai sukurti paieškos indeksą, net kai paieška išjungta. Tai naudinga, jei norite sukurti indeksą, kol paieškos priemonė nepasirodo besimokantiesiems.';
$string['searchinsettings'] = 'Ieškoti parametruose';
$string['searchlastrun'] = 'Paskutinis paleidimas (laikas, # dokumentai, # įrašai, # nepaisymai)';
$string['searchmanagement'] = 'Paieškos valdymas';
$string['searchmanagement_desc'] = 'Šios parinktys yra naudingos atliekant pakeitimus svetainėse su labai dideliais paieškos indeksais, kurių atkūrimas užtrunka ilgai.';
$string['searchmaxtopresults'] = 'Didžiausi geriausi rezultatai';
$string['searchmaxtopresults_desc'] = 'Didžiausias aukščiausią reitingą turinčių rezultatų, kurie bus rodomi virš kurso turinio, kursų ir naudotojų paieškos rezultatų, skaičius.';
$string['searchnotavailable'] = 'Paieška negalima';
$string['searchoptions'] = 'Paieškos parinktys';
$string['searchpartial'] = '(dar nevisiškai indeksuota)';
$string['searchreindexed'] = 'Visas svetainės turinys buvo indeksuotas iš naujo.';
$string['searchreindexindex'] = 'Indeksuoti visą svetainės turinį iš naujo';
$string['searchresults'] = 'Paieškos rezultatai';
$string['searchsetupinfo'] = 'Paieškos nustatymai';
$string['searchteacherroles'] = 'Dėstytojo vaidmenys';
$string['searchteacherroles_desc'] = 'Pasirinkite visus vaidmenis, dėl kurių naudotojai, turintys vaidmenų reitingą, yra aukštesni paieškos rezultatuose.';
$string['searchtopresults'] = 'Geriausi rezultatai';
$string['searchupdateindex'] = 'Atnaujinti indeksuotą turinį';
$string['sectionerror'] = 'Dalies klaida!';
$string['secureforms'] = 'Naudoti papildomą formos saugą';
$string['security'] = 'Sauga';
$string['selectsearchengine'] = 'Pasirinkti paieškos sistemą';
$string['server'] = 'Serveris';
$string['serverchecks'] = 'Serverio patikros';
$string['serverlimit'] = 'Serverio limitas';
$string['servicespage'] = 'Paslaugų ir palaikymo nuoroda';
$string['sessionautostartwarning'] = '<p>Aptikta rimta konfigūracijos klaida, praneškite serverio administratoriui.</p><p> Norint, kad „Moodle“ veiktų tinkamai, reikia, kad administratorius pakeistų PHP parametrus.</p><p>Parametro <code>session.auto_start</code> reikšmė turi būti <code>išjungta</code>.</p><p>Šis parametras valdomas redaguojant <code>php.ini</code>, „Apache“ / IIS <br />konfigūraciją arba <code>.htaccess</code> failą, esantį serveryje.</p>';
$string['sessioncookie'] = 'Slapuko priešvardis';
$string['sessioncookiedomain'] = 'Slapuko domenas';
$string['sessioncookiepath'] = 'Slapuko kelias';
$string['sessionhandling'] = 'Seanso apdorojimas';
$string['sessiontimeout'] = 'Skirtasis laikas';
$string['sessiontimeoutwarning'] = 'Perspėjimas apie skirtąjį laiką';
$string['settingdependenton'] = 'Šis nustatymas gali būti paslėptas, atsižvelgiant į <strong>{$a}</strong> reikšmę.';
$string['settingfileuploads'] = 'Norint užtikrinti įprastą veikimą, būtinas failų įkėlimas. Įjunkite jį PHP konfigūracijoje.';
$string['settingmaxinputvars'] = 'PHP parametras max_input_vars rekomenduojamas bent 5000.';
$string['settingmaxinputvarsrequired'] = 'PHP nustatymas max_input_vars turi būti bent 5000.';
$string['settingmemorylimit'] = 'Aptikta, kad nepakanka atminties. PHP parametruose nustatykite didesnį atminties limitą.';
$string['settingsafemode'] = '„Moodle“ nėra visiškai suderinama su saugiuoju režimu. Paprašykite serverio administratoriaus jį išjungti. „Moodle“ paleidimas saugiuoju režimu nėra palaikomas, jei tai darysite, gali iškilti įvairių problemų.';
$string['setupsearchengine'] = 'Paieškos sistemos nustatymai';
$string['showcommentscount'] = 'Rodyti komentarų skaičių';
$string['showdetails'] = 'Rodyti išsamią informaciją';
$string['showuseridentity'] = 'Parodyti naudotojo tapatybę';
$string['showuseridentity_desc'] = 'Kai pasirinkta ieškant naudotojų ir rodant naudotojų sąrašus, šie laukai gali būti rodomi kartu su jų vardu ir pavarde. Laukai rodomi tik tiems naudotojams, kurie turi moodle/site:viewuseridentity galimybę; pagal numatytuosius nustatymus dėstytojai ir tvarkytojai. (Ši parinktis prasmingiausia, jei pasirenkate vieną ar du laukus, kurie jūsų įstaigoje yra privalomi.)

Laukai, pažymėti *, yra pasirinktiniai naudotojo profilio laukai. Galite pasirinkti šiuos laukus, tačiau šiuo metu yra kai kurių ekranų, kuriuose jie nebus rodomi.';
$string['simplexmlrequired'] = '„Moodle“ dabar reikalauja naudoti „SimpleXML“ PHP plėtinį.';
$string['sitemailcharset'] = 'Simbolių rinkinys';
$string['sitemaintenance'] = 'Šiuo metu vykdoma svetainės priežiūra, todėl svetainė neprieinama';
$string['sitemaintenancemode'] = 'Priežiūros režimas';
$string['sitemaintenanceoff'] = 'Priežiūros režimas išjungtas, svetainė vėl veikia įprastai';
$string['sitemaintenanceon'] = 'Šiuo metu jūsų svetainė veikia priežiūros režimu (tik administratoriai gali prisijungti prie svetainės arba ją naudoti).';
$string['sitemaintenanceoncli'] = 'Šiuo metu jūsų svetainė veikia CLI priežiūros režimu, interneto prieiga nėra leidžiama.';
$string['sitemaintenancetitle'] = '{$a} atliekama techninė priežiūra';
$string['sitemaintenancewarning'] = 'Šiuo metu jūsų svetainė veikia priežiūros režimu (tik administratoriai gali prisijungti prie svetainės arba ją naudoti). Norėdami grąžinti įprastą šios svetainės režimą, <a href="{$a}">išjunkite priežiūros režimą</a>.';
$string['sitemaintenancewarning2'] = 'Šiuo metu jūsų svetainė veikia priežiūros režimu (tik administratoriai gali prisijungti prie svetainės arba ją naudoti). Norėdami grąžinti įprastą šios svetainės režimą, <a href="{$a}">išjunkite priežiūros režimą</a>.';
$string['sitemenubar'] = 'Svetainės navigacija';
$string['sitenameintitle'] = 'Įtraukti svetainės pavadinimą į puslapio pavadinimą';
$string['sitenameintitle_help'] = 'Pagal šį nustatymą puslapio pavadinimo pabaigoje bus pridėtas svetainės pavadinimas. Rekomenduojama svetainės pavadinimą įtraukti į puslapio pavadinimą, nes tai pagerins svetainės prieinamumą ir leis naudotojams greitai nustatyti, kuriame puslapyje jie šiuo metu yra.';
$string['sitepolicies'] = 'Svetainės saugos nustatymai';
$string['sitepolicy'] = 'Svetainės strategijos URL';
$string['sitepolicy_help'] = 'Svetainės politikos URL, kurį visi registruoti naudotojai turi matyti ir su juo sutikti prieš prisijungdami prie svetainės. Atminkite, kad šis nustatymas veiks tik tuo atveju, jei svetainės politikos tvarkytojas bus nustatytas kaip numatytasis (pagrindinis).';
$string['sitepolicyguest'] = 'Svečiams skirtas svetainės strategijos URL';
$string['sitepolicyguest_help'] = 'Svetainės politikos URL, kurį visi svečiai turi matyti ir su juo sutikti prieš patekdami į svetainę. Atminkite, kad šis nustatymas veiks tik tuo atveju, jei svetainės politikos tvarkytojas bus nustatytas kaip numatytasis (pagrindinis).';
$string['sitepolicyhandler'] = 'Svetainės politikos tvarkytojas';
$string['sitepolicyhandler_desc'] = 'Tai lemia, kaip tvarkoma politika ir naudotojų sutikimai. Numatytoji (pagrindinė) tvarkytuvė leidžia nurodyti svetainės politikos URL ir svetainės politikos URL svečiams. Politikos tvarkytuvė leidžia nustatyti svetainės, privatumo ir kitas strategijas. Tai taip pat leidžia peržiūrėti naudotojų sutikimus ir, jei reikia, duoti sutikimą nepilnamečių vardu.';
$string['sitepolicyhandlercore'] = 'Numatytasis (core)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'Puslapio viršuje rodyti dalį, į kurią galima įtraukti pasirinktinį turinį.';
$string['sixtyfourbitsrequired'] = 'Aptikta, kad jūsų svetainėje nenaudojama 64 bitų PHP versija. Prieš diegdami šią Moodle versiją, turite atnaujinti savo sistemą (operacinė sistema, PHP...).';
$string['sixtyfourbitswarning'] = 'Aptikta, kad jūsų svetainėje nenaudojama 64 bitų PHP versija. Norint užtikrinti suderinamumą ateityje, rekomenduojama atnaujinti svetainę.';
$string['slasharguments'] = 'Naudoti pasvirojo brūkšnio argumentus';
$string['slashargumentswarning'] = 'Rekomenduojama įjungti pasvirojo brūkšnio argumentų naudojimą. Ateityje tai bus reikalinga. Norėdami gauti daugiau informacijos, žr. dokumentaciją <a href="https://docs.moodle.org/en/admin/environment/slasharguments">Pasvirojo brūkšnio argumentų naudojimas</a>.';
$string['smallscreensonly'] = 'Tik maži ekranai';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'SMTP autentifikavimo tipas';
$string['smtpdetail'] = 'Paprasto pašto perdavimo protokolo (SMTP) nustatymai e. pašto siuntimui.';
$string['smtphosts'] = 'SMTP pagrindinis kompiuteris';
$string['smtpmaxbulk'] = 'SMTP sesijos limitas';
$string['smtppass'] = 'SMTP slaptažodis';
$string['smtpsecure'] = 'SMTP saugumas';
$string['smtpuser'] = 'SMTP naudotojo vardas';
$string['soaprecommended'] = 'Pasirinktinio SOAP plėtinio įdiegimas  naudingas žiniatinklio paslaugoms ir kai kuriems papildiniams.';
$string['sort_fullname'] = 'Visas kurso pavadinimas';
$string['sort_idnumber'] = 'Kurso ID numeris';
$string['sort_shortname'] = 'Trumpas kurso pavadinimas';
$string['sort_sortorder'] = 'Rikiavimo tvarka';
$string['spellengine'] = 'Rašybos modulis';
$string['spelllanguagelist'] = 'Rašybos kalbų sąrašas';
$string['splrequired'] = '„Moodle“ dabar reikalauja naudoti SPL PHP plėtinį.';
$string['stats'] = 'Statistika';
$string['statsfirstrun'] = 'Maksimalus apdorojimo intervalas';
$string['statsmaxruntime'] = 'Maksimalus vykdymo laikas';
$string['statsmoodleorg'] = 'statistika';
$string['statsruntimedays'] = 'Apdorojimo dienų skaičius';
$string['statsruntimestart'] = 'Vykdyti';
$string['statsuserthreshold'] = 'Naudotojo slenkstis';
$string['stickyblocks'] = 'Statiški blokai';
$string['stickyblockscourseview'] = 'Kursų puslapis';
$string['stickyblocksduplicatenotice'] = 'Jei bet kuris jūsų čia įtrauktas blokas jau yra tam tikrame puslapyje, bus sukurtas jo dublikatas.<br />Redaguoti negalima tik susegtų blokų, dublikatą vis tiek bus galima redaguoti.';
$string['stickyblocksmymoodle'] = 'Mano „Moodle“';
$string['stickyblockspagetype'] = 'Konfigūruotinas puslapio tipas';
$string['strictformsrequired'] = 'Griežtas patvirtinimas privalomiems laukams';
$string['stripalltitletags'] = 'Pašalinti HTML žymes iš visų veiklų pavadinimų';
$string['supportandservices'] = 'Parama ir paslaugos';
$string['supportavailability'] = 'Palaikymo prieinamumas';
$string['supportcontact'] = 'Palaikymo kontaktas';
$string['supportemail'] = 'Palaikymo el. pašto adresas';
$string['supportemailsubject'] = 'Svetainės palaikymo užklausa – {$a}';
$string['supportname'] = 'Palaikymo pavadinimas';
$string['supportpage'] = '„Susisiekite su svetainės palaikymo komanda“ nuoroda';
$string['suspenduser'] = 'Sulaikyti naudotojo paskyrą';
$string['swaggerui'] = '„Moodle“ REST API vartotojo sąsaja (SwaggerUI)';
$string['switchlang'] = 'Perjungti kalbos katalogą';
$string['systempaths'] = 'Sistemos keliai';
$string['tablenosave'] = 'Aukščiau esančios lentelės pakeitimai įrašyti automatiškai.';
$string['tablesnosave'] = 'Aukščiau esančių lentelių pakeitimai įrašyti automatiškai.';
$string['tabselectedtofront'] = 'Ar lentelių, turinčių skirtukų, eilutė su dabar pasirinktu skirtuku turėtų būti perkeliama į priekį?';
$string['tabselectedtofronttext'] = 'Perkelti pasirinktą skirtuko eilutę į priekį';
$string['task_adhoc_concurrency_limit'] = 'Ad hoc užduočių lygiagretumo riba';
$string['task_adhoc_concurrency_limit_desc'] = 'Ad hoc užduočių vykdytojų, kuriuos leidžiama vykdyti vienu metu, skaičius. Jei riba yra didelė, suplanuotos užduotys gali būti nevykdomos reguliariai, kai yra daug ad hoc užduočių. Nustačius 0, ad hoc užduočių apdorojimas bus visiškai išjungtas.';
$string['task_adhoc_failed_retention'] = 'Neįvykdytos ad hoc užduoties saugojimo laikotarpis';
$string['task_adhoc_failed_retention_desc'] = 'Maksimalus laikotarpis, kurį nepavykusios ad hoc užduotys turėtų likti eilėje, kol pasiekiamas jų pakartotinių bandymų limitas.';
$string['task_adhoc_max_runtime'] = 'Ad hoc užduočių vykdymo laikas';
$string['task_adhoc_max_runtime_desc'] = 'Ad hoc užduočių vykdytojo amžius prieš jį išlaisvinant. Rekomenduojama trumpa trukmė, nes eilėje esančių ad hoc užduočių skaičius neribojamas. Jei šis skaičius per didelis ir turite didelę ad hoc užduočių eilę, suplanuotos užduotys gali būti nevykdomos reguliariai.';
$string['task_dbreads'] = 'Duomenų bazės nuskaitymai';
$string['task_dbstats'] = 'Duomenų bazė';
$string['task_dbwrites'] = 'Duomenų bazės įrašymai';
$string['task_duration'] = 'Trukmė';
$string['task_endtime'] = 'Pabaigos laikas';
$string['task_logmode'] = 'Kada registruoti';
$string['task_logmode_all'] = 'Išsaugokite visų užduočių žurnalo išvestį';
$string['task_logmode_desc'] = 'Galite pasirinkti, kada norite, kad užduočių registravimas vyktų. Pagal numatytuosius nustatymus žurnalai visada fiksuojami. Galite visiškai išjungti registravimą arba pakeisti tik registravimo užduotis, kurios nepavyksta.';
$string['task_logmode_failonly'] = 'Saugoti žurnalus tik tų užduočių, kurios nepavyksta';
$string['task_logmode_none'] = 'Nieko nerašyti';
$string['task_logoutput'] = 'Užduoties rezultatas';
$string['task_logretainruns'] = 'Išlaikyti veikimą';
$string['task_logretainruns_desc'] = 'Kiekvienos išlaikomos užduoties paleidimų skaičius. Šis nustatymas sąveikauja su nustatymu „Saugojimo laikotarpis“: bus taikomas tas, kuris pasiekiamas anksčiau.';
$string['task_logretention'] = 'Saugojimo periodas';
$string['task_logretention_desc'] = 'Maksimalus laikotarpis, kurį žurnalai turėtų būti saugomi. Šis nustatymas sąveikauja su nustatymu „Išlaikyti paleidimus“: bus taikomas tas, kuris pasiekiamas anksčiau';
$string['task_logtostdout'] = 'Rodyti žurnalo išvestį';
$string['task_logtostdout_desc'] = 'Kai vykdomos užduotys ir fiksuojama išvestis, ar fiksuota išvestis taip pat turėtų būti rodoma vykdant užduotį.';
$string['task_result'] = 'Rezultatas';
$string['task_result:failed'] = 'Nepavyko';
$string['task_scheduled_concurrency_limit'] = 'Suplanuotas užduočių lygiagretumo limitas';
$string['task_scheduled_concurrency_limit_desc'] = 'Suplanuotų užduočių vykdytojų, kuriuos leidžiama vykdyti vienu metu, skaičius. Jei riba yra didelė, serveris gali patirti didelę apkrovą, kuri turi įtakos našumui. Nustačius 0, suplanuotų užduočių apdorojimas bus visiškai išjungtas.';
$string['task_scheduled_max_runtime'] = 'Suplanuotas užduočių vykdymo laikas';
$string['task_scheduled_max_runtime_desc'] = 'Suplanuotos užduočių vykdytojo amžius, kol jis bus atlaisvintas.';
$string['task_starttime'] = 'Pradžia';
$string['task_stats:dbreads'] = '{$a} skaitymai';
$string['task_stats:dbwrites'] = '{$a} rašymai';
$string['task_status'] = 'Užduoties būsena';
$string['task_status_desc'] = 'Užduotis „{$a->name}“ yra {$a->status}. Norėdami gauti daugiau informacijos, žr. {$a->class}{$a->extradescription} <a href="{$a->gotourl}">Suplanuotose užduotyse</a>.';
$string['task_type:adhoc'] = 'Ad hoc';
$string['task_type:scheduled'] = 'Suplanuotas';
$string['taskadmintitle'] = 'Užduotys';
$string['taskanalyticscleanup'] = '„Analytics“ valymas';
$string['taskautomatedbackup'] = 'Automatizuotos atsarginės kopijos';
$string['taskautomatedbackup_report'] = 'Automatizuota atsarginių kopijų ataskaita';
$string['taskbackupcleanup'] = 'Išvalyti atsarginės kopijos lenteles, žurnalus ir failus.';
$string['taskbadgesadhoc'] = 'Skirti pasiekimą';
$string['taskbadgescron'] = 'Pridėti pasiekimų suteikimo adhoc užduotis';
$string['taskbadgesmessagecron'] = 'Foninis apdorojimas pasiekimų pranešimų siuntimui';
$string['taskblogcron'] = 'Sinchronizuoti išorinius tinklaraščius';
$string['taskcachecleanup'] = 'Pašalinti pasibaigusius talpyklos įrašus';
$string['taskcachecron'] = 'Foninis talpyklų apdorojimas';
$string['taskcalendarcron'] = 'Siųsti kalendoriaus pranešimus';
$string['taskcheckforupdates'] = 'Patikrinti atnaujinimus';
$string['taskcompletiondaily'] = 'Baigimo ženklas kaip pradėtas';
$string['taskcompletionregular'] = 'Skaičiuoti įprastus užbaigimo duomenis';
$string['taskcontextcleanup'] = 'Valymo kontekstai';
$string['taskcreatecontexts'] = 'Sukurti trūkstamus kontekstus';
$string['taskdeleteincompleteusers'] = 'Naikinti neužbaigtus naudotojus';
$string['taskdeleteunconfirmedusers'] = 'Ištrinti nepatvirtintus naudotojus';
$string['taskeventscron'] = 'Fono apdorojimas įvykiams';
$string['taskfiletrashcleanup'] = 'Išvalyti failus iš šiukšliadėžės';
$string['taskglobalsearchindex'] = 'Visuotinės paieškos indeksavimas';
$string['taskglobalsearchoptimize'] = 'Visuotinės paieškos indekso optimizavimas';
$string['taskgradecron'] = 'Foninis apdorojimas įvertinimų knygelėje';
$string['taskgradehistorycleanup'] = 'Foninis apdorojimas, skirtas valyti įvertinimų istorijos lenteles';
$string['taskh5pcleanup'] = 'Nenaudojamų H5P failų valymas';
$string['tasklegacycron'] = 'Pasenęs cron apdorojimas, skirtas papildiniams';
$string['tasklockcleanuptask'] = 'Išvalyti ad hoc užduoties metaduomenis';
$string['tasklogcleanup'] = 'Užduočių žurnalų valymas';
$string['tasklogging'] = 'Užduočių žurnalo konfigūracija';
$string['tasklogs'] = 'Užduočių žurnalai';
$string['taskmessagingcleanup'] = 'Fono apiforminimas susirašinėjimui';
$string['taskpasswordresetcleanup'] = 'Slaptažodžio nustatymo iš naujo bandymai';
$string['taskplagiarismcron'] = 'Foninis apdorojimas senam cron sutapties papildiniuose';
$string['taskportfoliocron'] = 'Portfelio papildinių foninis apdorojimas';
$string['taskprocessing'] = 'Užduočių apdorojimas';
$string['taskquestioncron'] = 'Fono apdorojimas, skirtas klausimų peržiūroms išvalyti';
$string['taskquestionstatscleanupcron'] = 'Foninis apdorojimas, skirtas klausimų statistikos talpykloms išvalyti';
$string['taskrefreshsystemtokens'] = 'Atnaujinti paslaugų paskyrų OAuth prieigos raktus';
$string['taskregistrationcron'] = 'Svetainės registracija';
$string['tasksendfailedloginnotifications'] = 'Siųsti klaidingus prisijungimų pranešimus';
$string['tasksendnewuserpasswords'] = 'Siųsti naujus naudotojo slaptažodžius';
$string['tasksessioncleanup'] = 'Išvalyti senas sesijas';
$string['taskstatscron'] = 'Foninis statistikos apdorojimas';
$string['tasktagcron'] = 'Foninis žymų apdorojimas';
$string['tasktempfilecleanup'] = 'Ištrintu pasenusius laikinuosius failus';
$string['tasktype'] = 'Tipas';
$string['taskupdategeoip2file'] = 'Atnaujinti GeoIP failą';
$string['tempdatafoldercleanup'] = 'Išvalyti laikinus duomenų failus senesnius nei';
$string['templates'] = 'Šablonai';
$string['testoutgoingmailconf'] = 'Išbandyti siunčiamo pašto konfigūraciją';
$string['testoutgoingmailconf_errorcommunications'] = 'Jūsų svetainė negalėjo susisiekti su jūsų pašto serveriu. Patikrinkite siunčiamo pašto konfigūraciją.';
$string['testoutgoingmailconf_fromemail'] = 'Nuo naudotojo vardo arba el. pašto adreso';
$string['testoutgoingmailconf_fromemail_help'] = 'Šis laukas imituoja pranešimo siuntimą iš to naudotojo, tačiau antraštė Nuo, naudojama tikrame išsiųstame el. laiške, priklausys nuo kitų nustatymų, pvz., leidžiamų el. pašto domenų.';
$string['testoutgoingmailconf_fromemail_invalid'] = 'Neteisingas Nuo naudotojo vardas arba el. pašto adresas. Turi būti galiojantis el. pašto formatas arba esamas Moodle naudotojo vardas.';
$string['testoutgoingmailconf_message'] = 'Tai bandomasis pranešimas, patvirtinantis, kad sėkmingai sukonfigūravote savo svetainės siunčiamą paštą. Išsiųsta: {$a}';
$string['testoutgoingmailconf_sendtest'] = 'Siųsti testinį pranešimą';
$string['testoutgoingmailconf_sentmail'] = 'Ši svetainė sėkmingai išsiuntė testinį pranešimą į pašto serverį. <br />Nuo: {$a->fromemail}<br />Iki: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a->site}: testinė žinutė. {$a->additional} Išsiųsta: {$a->time}';
$string['testoutgoingmailconf_subjectadditional'] = 'Papildoma tema';
$string['testoutgoingmailconf_toemail'] = 'El. pašto adresas';
$string['testoutgoingmaildetail'] = 'Pastaba: prieš bandydami išsaugokite savo konfigūraciją. <br />{$a}';
$string['testsiteupgradewarning'] = 'Šiuo metu naudojate {$a} bandomąją svetainę. Norėdami tinkamai ją atnaujinti, naudokite komandų eilutės sąsajos įrankį';
$string['themedefinedinconfigphp'] = 'Temos negalima pakeisti, nes config.php yra nustatyta į {$a}.';
$string['themedesignermode'] = 'Temų dizainerio režimas';
$string['themedesignermodewarning'] = 'Temos dizainerio režimas yra įjungtas. Jis  neturėtų būti įjungiamas galutinėje svetainėje, nes tai gali žymiai sumažinti našumą.';
$string['themeeditsettingsname'] = 'Redaguoti temos nustatymus \'{$a}\'';
$string['themelist'] = 'Temų sąrašas';
$string['themeresetcaches'] = 'Valyti temų talpyklas';
$string['themeselect'] = 'Parinkti temą';
$string['themeselector'] = 'Temos';
$string['themesettingsadvanced'] = 'Išplėstiniai temos nustatymai';
$string['themesettingscustom'] = 'Pasirinktiniai temos nustatymai';
$string['themesettingsname'] = 'Temos nustatymai „{$a}“';
$string['themeusagereportname'] = 'Temos naudojimo ataskaita „{$a}“';
$string['therewereerrors'] = 'Duomenyse rasta klaidų';
$string['thirdpartylibrary'] = 'Biblioteka';
$string['thirdpartylibrarylocation'] = 'Vieta';
$string['thirdpartylibs'] = 'Trečiųjų šalių bibliotekos';
$string['timezone'] = 'Numatytoji laiko juosta';
$string['timezoneforced'] = 'To reikalauja svetainės administratorius';
$string['timezoneinvalid'] = 'Netinkama laiko zona "{$a}"';
$string['timezoneisforcedto'] = 'Reikalauti, kad visi naudotojai naudotų';
$string['timezonenotforced'] = 'Naudotojai gali pasirinkti savo laiko juostą';
$string['timezonephpdefault'] = 'Numatyta PHP laiko juosta ({$a})';
$string['timezoneserver'] = 'Serverio laiko zona ({$a})';
$string['tlswarning'] = 'Neaptiktas PHP/cURL plėtinys su TLSv1.2 palaikymu. Kai kurios paslaugos gali neveikti. Primygtinai rekomenduojama atnaujinti TLS bibliotekas.';
$string['tokenduration'] = 'Naudotojo sukurto prieigos rakto trukmė';
$string['tokenduration_desc'] = 'Laikotarpis, kurį galioja naudotojo sukurtas žiniatinklio paslaugų prieigos raktas (pavyzdžiui, per mobiliąją programėlę).';
$string['tokenizerrecommended'] = 'Rekomenduojama įdiegti pasirinktinę PHP „Tokenizer“ plėtinį, kad būtų pagerintos „Moodle“ darbo tinkle funkcijos.';
$string['tools'] = 'Administratoriaus įrankiai';
$string['toolsmanage'] = 'Tvarkyti administratoriaus įrankius';
$string['unattendedoperation'] = 'Neprižiūrimas veikimas';
$string['unbookmarkthispage'] = 'Pašalinti šio puslapio žymeles';
$string['unicoderequired'] = 'Visi duomenys turi būti saugomi Unicode formatu (UTF-8). Naujai diegiamoje duomenų bazėje UTF-8 turi būti nustatytas kaip numatytasis simbolių rinkinys. Jei atnaujinate, turite laikytis UTF-8 perkėlimo proceso.';
$string['uninstallplugin'] = 'Šalinti įdiegtį';
$string['unlockaccount'] = 'Atrakinti paskyrą';
$string['unoconvwarning'] = 'Jūsų įdiegta unoconv versija nepalaikoma.';
$string['unsupported'] = 'Nepalaikomas';
$string['unsupporteddbfileformat'] = 'Jūsų duomenų bazėje kaip failo formatas naudojamas Antelope. Visiškam UTF-8 palaikymui MySQL ir MariaDB reikalingas Barracuda failo formatas. Perjunkite į Barracuda failo formatą. Norėdami gauti daugiau informacijos, žr. dokumentaciją <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support">visiškas MySQL unicode palaikymas</a>.';
$string['unsupporteddbfilepertable'] = 'Norint visiškai palaikyti UTF-8, tiek MySQL, tiek MariaDB reikia pakeisti MySQL nustatymą „innodb_file_per_table“ į „ON“. Daugiau informacijos rasite dokumentacijoje.';
$string['unsupporteddblargeprefix'] = 'Norint visiškai palaikyti UTF-8, tiek MySQL, tiek MariaDB reikia pakeisti MySQL nustatymą „innodb_large_prefix“ į „ON“. Daugiau informacijos rasite dokumentacijoje.';
$string['unsupporteddbstorageengine'] = 'Naudojamas duomenų bazės saugojimo variklis nebepalaikomas.';
$string['unsupporteddbtablerowformat'] = 'Jūsų duomenų bazėje yra lentelių, kuriose kaip failo formatas yra Antelope. Lenteles rekomenduojama konvertuoti į Barracuda failo formatą. Daugiau informacijos apie įrankį, skirtą InnoDB lentelėms konvertuoti į Barracuda, rasite dokumentacijoje <a href="https://docs.moodle.org/en/cli">Administravimas naudojant komandų eilutę</a>.';
$string['unsupportedphpversion7'] = 'PHP 7 ir naujesnės versijos nepalaikomos.';
$string['unsupportedphpversion71'] = 'PHP 7.1 ir naujesnės versijos nepalaikomos.';
$string['unsupportedphpversion72'] = 'PHP 7.2 ir naujesnės versijos nepalaikomos.';
$string['unsupportedphpversion73'] = 'PHP 7.3 ir naujesnės versijos nepalaikomos.';
$string['unsupportedphpversion74'] = 'PHP 7.4 ir naujesnės versijos nepalaikomos.';
$string['unsupportedphpversion80'] = 'PHP 8 ir naujesnės versijos nepalaikomos.';
$string['unsupportedphpversion81'] = 'PHP 8.1 ir naujesnės versijos nepalaikomos.';
$string['unsupportedphpversion82'] = 'PHP 8.2 ir naujesnės versijos nepalaikomos.';
$string['unsupportedphpversion83'] = 'PHP 8.3 ir naujesnės versijos nepalaikomos.';
$string['unsuspenduser'] = 'Aktyvuoti naudotojo paskyrą';
$string['updateaccounts'] = 'Naujinti esamas paskyras';
$string['updateautocheck'] = 'Automatiškai tikrinti ar yra galimų atnaujinimų';
$string['updateautocheck_desc'] = 'Jei įgalinta, Jūsų svetainė automatiškai tikrins "Moodle" ir visų papildomų papildinių kodo atnaujinimus. Jei naujas kodas bus rastas, pranešimas bus išsiųstas visiems svetainės administratoriams.';
$string['updateavailable'] = 'Yra naujesnė "Moodle" versija!';
$string['updateavailable_moreinfo'] = 'Daugiau informacijos...';
$string['updateavailable_release'] = '"Moodle" {$a}';
$string['updateavailable_version'] = 'Versija {$a}';
$string['updateavailabledetailslink'] = 'Spauskite {$a->url} norint gauti daugiau informacijos';
$string['updateavailableforplugin'] = 'Kai kuriems Jūsų papildiniams yra naujesnė versija!';
$string['updateavailableinstall'] = 'Įdiegti šį atnaujinimą';
$string['updateavailableinstallall'] = 'Įdiegti galimus atnaujinimus ({$a})';
$string['updateavailableinstallallhead'] = 'Diegiami galimi atnaujinimai';
$string['updateavailablenot'] = 'Jūsų "Moodle" kodas nereikalauja atnaujinimo!';
$string['updateavailablerecommendation'] = 'Primygtinai rekomenduojama, atnaujinti svetainę į naujausią versiją, kad būtų gaunami visi saugumo atnaujinimai ir klaidų pataisymai.';
$string['updatecomponent'] = 'Naujinti komponentą';
$string['updateminmaturity'] = 'Reikalaujamas kodo brandumas';
$string['updateminmaturity_desc'] = 'Pranešti apie galimus atnaujinimus tik tada, jei kodas atitinka pasirinktą brandos lygį. Papildinių atnaujinimai, kuriems nenurodytas kodo brandos lygis, bus visada rodomi nepriklausomai nuo šios nuostatos.';
$string['updatenotificationfooter'] = 'Moodle svetainei {$a->siteurl} nustatyta automatiškai tikrinti ar nėra galimų atnaujinimų. Jūs gavote šį pranešimą, kadangi esate svetainės administratorius. Galite išjungti automatinius galimų naujinimų tikrinimus Administravimas / Serveris / Atnaujinimo pranešimai arba valdyti savo gaunamus pranešimus nuostatų puslapyje.';
$string['updatenotifications'] = 'Atnaujinimo pranešimai';
$string['updatenotificationsubject'] = 'Jūsų Moodle svetainei yra atnaujinimų ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Pranešti apie naują kodą';
$string['updatenotifybuilds_desc'] = 'Jei įgalinta, pranešimas apie galimą "Moodle" kodo atnaujinimą bus pateiktas, kai atsiras naujas esamos versijos kodo leidimas. Kodo leidimai yra tęstiniai patobulinimai esamai "Moodle" versijai. Jie dažniausiai yra išleidžiami kas savaitė. Jei išjungta, apie įmanomą atnaujinimą bus pranešta tik tada, kai atsiras nauja "Moodle" versija. Ši nuostata neįtakoja papildinių patikrinimo.';
$string['upgradeerror'] = 'Atnaujinant {$a->plugin} versiją į {$a->version} įvyko nežinoma klaida. Negalima tęsti';
$string['upgradeforumread'] = 'Į „Moodle“ 1.5 versiją įtraukta nauja funkcija, leidžianti sekti perskaitytus / neperskaitytus forumo skelbimus.<br />Norėdami naudoti šią funkciją, turite <a href="{$a}">atnaujinti savo lenteles</a>.';
$string['upgradeforumreadinfo'] = 'Į „Moodle“ 1.5 versiją įtraukta nauja funkcija, leidžianti sekti perskaitytus / neperskaitytus forumo skelbimus. Norėdami naudoti šią funkciją, turite atnaujinti savo lenteles nurodydami visą esamų skelbimų sekimo informaciją. Atsižvelgiant į jūsų svetainės dydį, tai gali užtrukti ilgai (kelias valandas) ir gerokai apkrauti duomenų bazę, todėl geriausia tai atlikti per ramų laikotarpį. Tačiau šio versijos naujinimo metu jūsų svetainė ir toliau veiks, o naudotojai galės ją įprastai naudoti. Paleidę šį procesą, turėtumėte leisti jam pasibaigti (palikite naršyklės langą atidarytą). Tačiau jei sustabdysite procesą uždarydami langą, nesijaudinkite – galite pradėti iš naujo.<br /><br />Ar norite pradėti versijos naujinimo procesą dabar?';
$string['upgradekeyreq'] = 'Reikalingas naujovinimo raktas';
$string['upgradekeyset'] = 'Naujovinimo raktas (palikite tuščią, jei nenorite nustatyti)';
$string['upgradelogs'] = 'Norint naudoti visas funkcijas, reikia atnaujinti senų žurnalų versiją. <a href="{$a}">Daugiau informacijos</a>';
$string['upgradelogsinfo'] = 'Neseniai atlikta žurnalų saugojimo būdo pakeitimų. Norėdami galėti peržiūrėti visus senus savo žurnalus pagal veikslas, turite atnaujinti senų žurnalų versiją. Atsižvelgiant į jūsų svetainės dydį, tai gali užtrukti ilgai (pvz., kelias valandas) ir gerokai apkrauti duomenų bazę, jei svetainė didelė. Paleidę šį procesą, turėtumėte leisti jam pasibaigti (palikite naršyklės langą atidarytą). Nesijaudinkite – kiti žmonės galės naudotis jūsų svetaine, kol bus naujinamos žurnalų versijos.<br /><br />Ar norite naujinti žurnalų versiją dabar?';
$string['upgradepluginsfirst'] = 'Rekomenduojama pirmiausiai įdiegti visus galimus atnaujinimus';
$string['upgradepluginsinfo'] = 'Atnaujinami papildiniai';
$string['upgradepluginsinfo_help'] = 'Kai kuriems Jūsų papildiniams yra prienami atnaujinimai. Prieš atnaujinant Moodle duomenų bazę, juos turėtumėte įdiegti.  Jei svetainėje nėra palaikomas automatinis atnaujinimas, turite atsisiųsti atnaujinimą ir įdiegti jį savo serveryje rankiniu būdu.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'Nauji parametrai';
$string['upgradesettingsintro'] = 'Žemiau pateikti nustatymai buvo pridėti paskutinio Moodle atnaujinimo metu. Atlikite visus būtinus numatytųjų nustatymų pakeitimus ir spustelėkite mygtuką „Išsaugoti pakeitimus“ šio puslapio apačioje.';
$string['upgradestalefiles'] = 'Aptiktos maišytos "Moodle" versijos, plėtotė negali tęstis';
$string['upgradestalefilesinfo'] = '„Moodle“ atnaujinimo procesas buvo pristabdytas, nes „Moodle“ kataloge buvo aptikti PHP scenarijai iš mažiausiai dviejų pagrindinių „Moodle“ versijų.

Vėliau tai gali sukelti didelių problemų, todėl norėdami tęsti, turite užtikrinti, kad „Moodle“ kataloge būtų tik vienos „Moodle“ versijos failai.

Rekomenduojamas būdas išvalyti Jūsų „Moodle“ katalogą yra toks:

* pervadinkite esamą „Moodle“ katalogą į "moodle_senas"
* sukurkite naują „Moodle“ katalogą, kuriame būtų tik failai iš standartinio „Moodle“ paketo atsisiuntimo arba iš „Moodle“ Git saugyklos
* perkelkite originalų config.php failą ir visus nestandartinius papildinius iš "moodle_senas" katalogo į naują „Moodle“ katalogą

Kai turite švarų „Moodle“ katalogą, atnaujinkite šį puslapį, kad atnaujintumėte „Moodle“ naujinimo procesą.

Šį įspėjimą dažnai sukelia standartinio „Moodle“ paketo išpakavimas iš ankstesnės „Moodle“ versijos. Nors tai tinka nedideliems naujinimams, tai griežtai nerekomenduojama atlikti dideliems „Moodle“  naujinimams.

Šį įspėjimą taip pat gali sukelti neužbaigta patikros arba atnaujinimo operacija iš Git saugyklos. Tokiu atveju jums gali tekti tiesiog palaukti, kol operacija bus baigta, arba galbūt paleiskite atitinkamą valymo komandą ir bandykite dar kartą.

Daugiau informacijos rasite naujovinimo dokumentacijoje adresu <a href="{$a}">{$a}</a>.';
$string['upgradestart'] = 'Atnaujinti Moodle duomenų bazę dabar';
$string['upgradesure'] = '<p>Jūsų „Moodle“ failai pakeisti, o jūs ruošiatės automatiškai atnaujinti savo serverį į šią versiją: </p>
<p><strong>{$a}</strong> </p>
<p>Padarę tai, grįžti nebegalėsite. Atkreipkite dėmesį, kad šis procesas gali ilgai užtrukti. </p>
<p>Ar tikrai norite atnaujinti serverį į šią versiją?</p>';
$string['upgradetimedout'] = 'Baigėsi skirtasis versijos naujinimo laikas. Norėdami naujinti versiją, paleiskite iš naujo.';
$string['upgradingdata'] = 'Naujinama duomenų versija';
$string['upgradinglogs'] = 'Naujinama žurnalų versija';
$string['upgradingversion'] = 'Naujinama į naują versiją';
$string['upwards'] = 'aukštyn';
$string['useblogassociations'] = 'Įjungti susiejimus';
$string['user'] = 'Naudotojas';
$string['userbulk'] = 'Masiniai naudotojo veiksmai';
$string['userbulkdownload'] = 'Eksportuoti naudotojus kaip';
$string['userdefaultpreferences'] = 'Naudotojo numatytosios parinktys';
$string['userfeedbackafterupgrade'] = 'Po kiekvieno didesnio atnaujinimo';
$string['userfeedbackencouragement'] = '<p>Moodle 3.9 ir naujesnėje versijoje įtraukta nauja funkcija, kuri suteikia vartotojams galimybę teikti atsiliepimus apie Moodle programinę įrangą Moodle būstinei per išorinę apklausų svetainę, kurią priglobia Moodle būstinė. Jokia naudotoją identifikuojanti informacija nepersiunčiama į apklausos svetainę.</p>
<p>Moodle būstinė stengiasi būti atvira ir skaidri savo duomenų rinkimo praktika. Taigi norime įsitikinti, kad žinote ir kontroliuojate šią funkciją.</p>
<p>Naudotojų atsiliepimai labai padės „Moodle“ būstinei tobulinti „Moodle“ programinę įrangą. Norėdami įjungti šią funkciją, eikite į <a href="{$a}">Atsiliepimų nustatymus</a>.</p>';
$string['userfeedbacknextreminder'] = 'Kito atsiliepimo priminimas';
$string['userfeedbacknextreminder_desc'] = 'Kada turėtume paprašyti naudotojo vėl pateikti atsiliepimą?';
$string['userfeedbackperiodically'] = 'Periodiškai';
$string['userfeedbackremindafter'] = 'Rodyti prinimimą po';
$string['userfeedbackremindafter_desc'] = 'Vėl priminti naudotojams, kad pateiktų atsiliepimą po nurodyto dienų skaičiaus.';
$string['userfiltersdefault'] = 'Numatytieji naudotojo filtrai';
$string['userfiltersdefault_desc'] = 'Pasirinkite filtrus, kuriuos norite rodyti puslapyje „Masiniai naudotojo veiksmai“. Norėdami pasirinkti kelis filtrus, laikykite nuspaudę klavišą Ctrl. Nepasirinkti filtrai vis tiek bus pasiekiami spustelėjus nuorodą „Rodyti daugiau“.';
$string['userimagesdisabled'] = 'Naudotojo profilio paveikslai yra išjungti';
$string['userlist'] = 'Naršyti naudotojų sąrašą';
$string['usermanagement'] = 'Naudotojo valdymas';
$string['userpolicies'] = 'Naudotojų politika';
$string['userpreference'] = 'Naudotojo nuostatos';
$string['userquota'] = 'Privačių failų erdvė';
$string['userquota_desc'] = 'Didžiausias duomenų kiekis, kurį kiekvienas naudotojas gali saugoti savo asmeninių failų srityje.';
$string['users'] = 'Naudotojai';
$string['usesitenameforsitepages'] = 'Naudoti svetainės vardą svetainės puslapiams';
$string['usetags'] = 'Įjungti žymių funkcijas';
$string['validateemptylineerror'] = 'Tuščios eilutės negalioja';
$string['validateerror'] = 'Ši reikšmė yra neleistina';
$string['validateerrorlist'] = 'Šie įrašai yra neteisingi: {$a}';
$string['validateiperror'] = 'Šie IP adresai yra neteisingi: {$a}';
$string['verifychangedemail'] = 'Riboti domenus keičiant el. paštą';
$string['warningcurrentsetting'] = 'Neleistina dabartinė reikšmė: {$a}';
$string['warningiconvbuggy'] = 'Jūsų turima ICONV bibliotekos versija nepalaiko //IGNORE modifikatoriaus. Vietoj jos, Jūs turėtumėte įsidiegti MBSTRING plėtinį, kuris gali būti panaudotas eilučių, turinčių neteisingus UTF-8 simbolius, valymui.';
$string['webproxy'] = 'Žiniatinklio tarpinis serveris';
$string['webproxyinfo'] = 'Jei jūsų Moodle serveris negali tiesiogiai prisijungti prie interneto, užpildykite šias parinktis. Norint atsisiųsti aplinkos duomenis, kalbų paketus, RSS informacijos santraukas, laiko juostas ir kt., reikalinga prieiga prie interneto.<br /><em>Labai rekomenduojamas PHP cURL plėtinys.</em>';
$string['xmlrpcwebserviceenabled'] = 'Aptikta, kad jūsų svetainėje įjungtas XML-RPC žiniatinklio tarnybos protokolas. Ši funkcija priklauso nuo PHP XML-RPC plėtinio, kurio PHP nebepalaiko.';
$string['yuicomboloading'] = 'YUI kombinuotas įkėlimas';
$string['ziprequired'] = '„Moodle“ dabar reikalauja naudoti PHP plėtinį „Zip“. „info-ZIP“ dvejetainiai failai arba „PclZip“ biblioteka nebenaudojama.';
