<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'mnet', language 'mn', version '5.1'.
 *
 * @package     mnet
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['RPC_HTTPS_SELF_SIGNED'] = 'HTTPS (өөрийн баталгаажуулалттай)';
$string['RPC_HTTPS_VERIFIED'] = 'HTTPS (баталгаажуулалттай)';
$string['RPC_HTTP_PLAINTEXT'] = 'HTTP шифрлэгдээгүй';
$string['RPC_HTTP_SELF_SIGNED'] = 'HTTP (өөрийн баталгаажуулалттай)';
$string['RPC_HTTP_VERIFIED'] = 'HTTP (баталгаажуулалттай)';
$string['aboutyourhost'] = 'Таны серверийн тухай';
$string['accesslevel'] = 'Хандалтын түвшин';
$string['addhost'] = 'Хост нэмэх';
$string['addnewhost'] = 'Шинэ хост нэмэх';
$string['addtoacl'] = 'Хандалтын хяналт нэмэх';
$string['allhosts'] = 'Бүх хост';
$string['allhosts_no_options'] = 'Олон хостыг харах үед ямар ч сонголт байхгүй байна';
$string['allow'] = 'Зөвшөөрөх';
$string['applicationtype'] = 'Аппликейшны төрөл';
$string['authfail_nosessionexists'] = 'Баталгаажуулалт амжилтгүй боллоо: mnet сейшн байхгүй байна.';
$string['authfail_sessiontimedout'] = 'Баталгаажуулалт амжилтгүй боллоо: mnet сейшны хугацаа дууссан байна.';
$string['authfail_usermismatch'] = 'Баталгаажуулалт амжилтгүй боллоо: хэрэглэгч таарахгүй байна.';
$string['authmnetdisabled'] = 'MNet баталгаажуулалтын нэмэлт хэрэгсэл <strong>идэвхгүй</strong> байна.';
$string['badcert'] = 'Энэ нь хүчинтэй сертификат биш байна.';
$string['certdetails'] = 'Сертификатын дэлгэрэнгүй мэдээлэл';
$string['configmnet'] = 'MNet нь энэ серверийг бусад сервер эсвэл сервистэй харилцах боломжийг олгодог.';
$string['couldnotgetcert'] = '<br />{$a} дээр сертификат олдсонгүй. <br /> Хост ажиллахгүй эсвэл буруу тохируулагдсан байж болзошгүй.';
$string['couldnotmatchcert'] = 'Энэ нь вэб серверийн гаргасан сертификаттай таарахгүй байна.';
$string['courses'] = 'хичээлүүд';
$string['courseson'] = 'хичээлүүд';
$string['current_transport'] = 'Ашиглаж буй шилжүүлэлт';
$string['currentkey'] = 'Ашиглаж буй нийтийн түлхүүр';
$string['databaseerror'] = 'Өгөгдлийн санд дэлгэрэнгүй мэдээлэл бичиж чадсангүй.';
$string['deleteaserver'] = 'Серверийг устгаж байна';
$string['deletedhostinfo'] = 'Энэ хостыг устгасан байна. Устгах үйлдлийг буцаахыг хүсвэл устгасан төлөвийг "Үгүй" болгох хэрэгтэй.';
$string['deletedhosts'] = 'Устгагдсан хост: {$a}';
$string['deletehost'] = 'Хостыг устгах';
$string['deletekeycheck'] = 'Та энэ түлхүүрийг устгахдаа итгэлтэй байна уу?';
$string['deleteoutoftime'] = 'Таны энэ түлхүүрийг устгах 60 секундын хугацаа дууссан байна. Дахин эхлүүлнэ үү.';
$string['deleteuserrecord'] = 'SSO ACL:  {$a->host} хостоос \'{$a->user}\' хэрэглэгчийн бүртгэлийг устгана уу.';
$string['deletewrongkeyvalue'] = 'Алдаа гарлаа. Та серверийнхээ SSL түлхүүрийг устгах оролдлого хийгээгүй бол хортой халдлагад өртсөн байх магадлалтай. Ямар ч арга хэмжээ аваагүй байна.';
$string['deny'] = 'Татгалзах';
$string['description'] = 'Тодорхойлолт';
$string['duplicate_usernames'] = 'Бид таны хэрэглэгчийн хүснэгтийн "mnetostid" болон "хэрэглэгчийн нэр" багана дээр индекс үүсгэж чадсангүй.<br />Энэ нь <a href="{$a}" target="_blank">таны хэрэглэгчийн хүснэгтэд хэрэглэгчийн нэр давхардсан үед гарч болно.</a>.<br />Хийгдэж буй шинэчлэлт амжилттай дуусах шаардлагатай. Дээрх холбоос дээр дарвал уг асуудлыг шийдвэрлэх заавар шинэ цонхонд гарах болно. Үүнд шинэчлэлтийн төгсгөлд хандах боломжтой.<br />';
$string['enabled_for_all'] = '(Бүх хостод энэ сервисийг идэвхжүүлсэн).';
$string['enterausername'] = 'Хэрэглэгчийн нэр эсвэл таслалаар тусгаарласан хэрэглэгчийн нэрсийн жагсаалтыг оруулна уу.';
$string['error7020'] = 'Энэ алдаа нь алсын сайт нь буруу wwwroot бүхий бичлэг үүсгэсэн тохиолдолд ихэвчлэн гардаг. Жишээ нь https://www.yoursite.com гэхийн оронд https://yoursite.com. Алсын сайтын администратортой өөрийн wwwroot (config.php файлд заасны дагуу)-ээр холбогдож, хостын бичлэгийг шинэчлэх хүсэлт гаргана уу.';
$string['error7022'] = 'Таны алсын сайт руу илгээсэн зурвас нь зөв шифрлэгдсэн боловч гарын үсэггүй байна. Энэ бол маш гэнэтийн зүйл юм. Энэ тохиолдолд та алдааг бүртгэх хэрэгтэй (хэрэглэж буй аппликейшны хувилбарын талаар аль болох их мэдээлэл өгөх гэх мэт).';
$string['error7023'] = 'Алсын сайт нь таны сайтын бүртгэлтэй бүх түлхүүрээр таны зурвасыг тайлахыг оролдсон ч чадаагүй. Та алсын сайтад гараас оруулах замаар уг асуудлыг шийдэх боломжтой. Алсын сайттай хэдэн сарын турш холбогдоогүй тохиолдолд ийм асуудал тохиолдох магадлалтай.';
$string['error7024'] = 'Та алсын сайт руу шифрлэгдээгүй зурвас илгээсэн ч алсын сайт нь таны шифрлэгдээгүй харилцааг хүлээн авахгүй. Энэ бол маш гэнэтийн зүйл юм. Энэ тохиолдолд та алдааг бүртгэх хэрэгтэй (хэрэглэж буй аппликейшны хувилбарын талаар аль болох их мэдээлэл өгөх гэх мэт).';
$string['error7026'] = 'Таны зурваст гарын үсэг зурсан түлхүүр нь алсын хостоос таны серверт хадгалсан түлхүүрээс өөр байна. Алсын хост таны ашиглаж буй түлхүүрийг татахыг оролдсон боловч чадсангүй. Алсын хостыг гараас оруулж, дахин оролдоно уу.';
$string['error709'] = 'Алсын сайт таниас SSL түлхүүр авч чадсангүй.';
$string['eventaccesscontrolcreated'] = 'Хандалтын хяналтыг үүсгэсэн';
$string['eventaccesscontrolupdated'] = 'Хандалтын хяналтыг шинэчилсэн';
$string['expired'] = 'Энэ түлхүүрийн хугацаа дууссан';
$string['expires'] = 'Хүчинтэй хугацаа';
$string['expireyourkey'] = 'Энэ түлхүүрийг устгах';
$string['expireyourkeyexplain'] = 'Moodle таны түлхүүрийг 28 хоног тутам автоматаар сольдог (өгөгдмөл тохиргоогоор) бөгөөд та энэ түлхүүрийг хүссэн үедээ <em>гараар</em> хүчингүй болгох боломжтой. Энэ нь түлхүүрээ алдсан тохиолдолд хэрэг болно. Орлуулах түлхүүрийг тухай бүр автоматаар үүсгэдэг.<br />Энэ түлхүүрийг устгаснаар та администратор тус бүртэй гараар холбогдож, шинэ түлхүүрээ өгөх хүртэл бусад аппликейшнтай холбогдох боломжгүй болно.';
$string['exportfields'] = 'Экспортлох талбар';
$string['failedaclwrite'] = '\'{$a}\' хэрэглэгчийн MNet хандалтын хяналтын жагсаалтад бичихэд алдаа гарлаа.';
$string['findlogin'] = 'Нэвтрэлт хайх';
$string['forbidden-function'] = 'Энэ функцийг RPC-д идэвхжүүлээгүй байна.';
$string['forbidden-transport'] = 'Таны ашиглах гэж буй шилжүүлэлтийн аргыг зөвшөөрөөгүй байна.';
$string['forcesavechanges'] = 'Өөрчлөлтийг хадгалахыг шаардах';
$string['helpnetworksettings'] = 'MNet холболтыг тохируулах';
$string['hidelocal'] = 'Дотоод хэрэглэгчийг нуух';
$string['hideremote'] = 'Гадаад хэрэглэгчийг нуух';
$string['host'] = 'хост';
$string['hostcoursenotfound'] = 'Хост эсвэл хичээл олдсонгүй';
$string['hostdeleted'] = 'Хостыг устгасан';
$string['hostexists'] = 'Ийм хост нэртэй хостод бичлэг байна. (Үүнийг устгасан байж болзошгүй.) <a href="{$a}">Бичлэгийг засварлах</a>';
$string['hostlist'] = 'Сүлжээнд холбогдсон хостын жагсаалт';
$string['hostname'] = 'Хостын нэр';
$string['hostnamehelp'] = 'Алсын хостын бүрэн эрхтэй домэйн нэр, жишээ нь www.example.com';
$string['hostnotconfiguredforsso'] = 'Энэ серверийг алсаас нэвтрэхээр тохируулаагүй байна.';
$string['hostsettings'] = 'Хостын тохиргоо';
$string['http_self_signed_help'] = 'Алсын хост дээр өөрийн баталгаажуулалттай DIY SSL сертификатыг ашигласан холболтыг зөвшөөрнө.';
$string['http_verified_help'] = 'Алсын хост дээрх PHP дээр баталгаажсан SSL сертификат ашигласан холболтыг зөвшөөрнө, гэхдээ http дээр (https биш) зөвшөөрнө.';
$string['https_self_signed_help'] = 'http дээр алсын хост дээрх PHP дээр өөрийн баталгаажуулалттай DIY SSL ашигласан холболтыг зөвшөөрнө.';
$string['https_verified_help'] = 'Алсын хост дээр баталгаажсан SSL сертификат ашигласан холболтыг зөвшөөрнө.';
$string['id'] = 'ID дугаар';
$string['idhelp'] = 'Энэ утгыг автоматаар оноох бөгөөд өөрчлөх боломжгүй';
$string['importfields'] = 'Импортлох талбар';
$string['inspect'] = 'Шалгах';
$string['installnosuchfunction'] = 'Кодын алдаа! Файлаас ямар нэг зүйл ({$a->file}) mnet xmlrpc функцыг ({$a->method}) суулгахыг оролдож байгаа бөгөөд үүнийг илрүүлж чадахгүй байна!';
$string['installnosuchmethod'] = 'Кодын алдаа! Классаас ямар нэгэн зүйл ({$a->class}) mnet xmlrpc аргыг ({$a->method}) суулгахыг оролдож байгаа бөгөөд үүнийг илрүүлж чадахгүй байна!';
$string['installreflectionclasserror'] = 'Кодын алдаа! \'{$a->class}\' классын \'{$a->method}\' аргын хувьд MNet дотоод шалгалт амжилтгүй болсон. Алдааны анхны зурвас нь: \'{$a->error}\'';
$string['installreflectionfunctionerror'] = 'Кодын алдаа! \'{$a->file}\' файлын \'{$a->method}\' функцын хувьд MNet дотоод шалгалт амжилтгүй болсон. Алдааны анхны зурвас нь: \'{$a->error}\'';
$string['invalidaccessparam'] = 'Хандалтын параметр буруу байна.';
$string['invalidactionparam'] = 'Үйлдлийн параметр буруу байна.';
$string['invalidhost'] = 'Та хүчинтэй хост танигчийг оруулах шаардлагатай';
$string['invalidpubkey'] = 'Түлхүүр нь хүчинтэй SSL түлхүүр биш байна. ({$a})';
$string['invalidurl'] = 'URL хаягийн параметр буруу байна.';
$string['ipaddress'] = 'IP хаяг';
$string['is_in_range'] = '<code>{$a}</code> IP хаяг нь хүчинтэй итгэмжлэгдсэн хостыг илэрхийлнэ.';
$string['ispublished'] = '{$a} нь танд энэ сервисийг идэвхжүүлсэн байна.';
$string['issubscribed'] = '{$a} таны хост дээрх энэ сервисийг холбосон байна.';
$string['keydeleted'] = 'Таны түлхүүрийг амжилттай устгаж, солилоо.';
$string['keydeletedcancelled'] = 'Түлхүүрт өөрчлөлт ороогүй байна.';
$string['keymismatch'] = 'Таны энэ хостод барьж буй нийтийн түлхүүр нь одоогоор ашиглаж буй нийтийн түлхүүрээс өөр байна. Одоогоор ашиглаж буй түлхүүр нь:';
$string['last_connect_time'] = 'Сүүлийн холболтын хугацаа';
$string['last_connect_time_help'] = 'Энэ хосттой таны хамгийн сүүлд холбогдсон хугацаа.';
$string['last_transport_help'] = 'Энэ хосттой хамгийн сүүлд холбогдоход ашигласан дамжуулах хэрэгсэл.';
$string['leavedefault'] = 'Оронд нь өгөгдмөл тохиргоог ашиглах';
$string['listservices'] = 'Сервисийн жагсаалт';
$string['loginlinkmnetuser'] = '<br />Хэрэв та MNet алсын хэрэглэгч бөгөөд <a href="{$a}">энд цахим шуудангийн хаягаа баталгаажуулах</a> боломжтой бол таныг нэвтрэх хуудас руу дахин чиглүүлэх боломжтой.<br />';
$string['logs'] = 'лог бүртгэл';
$string['managemnetpeers'] = 'Удирдах';
$string['method'] = 'Арга';
$string['methodhelp'] = '{$a}-н аргын тусламж';
$string['methodsavailableonhost'] = '{$a} дээрх боломжит аргууд';
$string['methodsavailableonhostinservice'] = '{$a->host} дээрх {$a->service} ашиглах боломжит аргууд';
$string['methodsignature'] = '{$a} аргын гарын үсэг';
$string['mnet'] = 'MNet';
$string['mnet_concatenate_strings'] = '3 (хүртэлх) тэмдэгт мөрийг холбож, үр дүнг буцаана';
$string['mnet_session_prohibited'] = 'Одоогоор таны гэрийн серверийн хэрэглэгчид {$a} руу роуминг хийх эрхгүй байна.';
$string['mnetdisabled'] = 'MNet<strong>идэвхгүй байна</strong>.';
$string['mnetidprovider'] = 'MNet ID үйлчилгээ үзүүлэгч';
$string['mnetidproviderdesc'] = 'Та өмнө нь нэвтрэхдээ ашигласан хэрэглэгчийн нэртэйгээ тохирох зөв цахим шуудангийг хаягийг оруулсан тохиолдолд нэвтрэх холбоосыг авахдаа энэ боломжийг ашиглаж болно.';
$string['mnetidprovidermsg'] = 'Та {$a} өөрийн үйлчилгээ үзүүлэгчид нэвтрэх боломжтой байх ёстой.';
$string['mnetidprovidernotfound'] = 'Уучлаарай, өөр мэдээлэл олдсонгүй.';
$string['mnetpeers'] = 'Ижил түвшний';
$string['mnetservices'] = 'Сервисүүд';
$string['mnetsettings'] = 'MNet тохиргоо';
$string['moodle_home_help'] = 'Алсын хост дээрх MNet аппликейшны нүүр хуудсанд хандах зам, жишээ нь /moodle/.';
$string['name'] = 'Нэр';
$string['net'] = 'Сүлжээ';
$string['networksettings'] = 'Сүлжээний тохиргоо';
$string['never'] = 'Хэзээ ч үгүй';
$string['noaclentries'] = 'SSO хандалтын хяналтын жагсаалтад бичлэг байхгүй байна';
$string['noaddressforhost'] = 'Уучлаарай, энэ хостын нэрийг ({$a}) шийдэж чадсангүй!';
$string['nocurl'] = 'PHP cURL санг суулгаагүй байна';
$string['nolocaluser'] = 'Алсын хэрэглэгчийн дотоод бүртгэл байхгүй бөгөөд уг хост нь автоматаар хэрэглэгч үүсгэдэггүй тул бүртгэл үүсгэх боломжгүй. Администратортойгоо холбогдоно уу!';
$string['nomodifyacl'] = 'Танд MNet хандалтын хяналтын жагсаалтыг өөрчлөх зөвшөөрөл байхгүй.';
$string['nonmatchingcert'] = 'Сертификатын гарчиг <br /><em>{$a->subject}</em><br />нь <br /><em>{$a->host}</em> хостоос ирсэн хосттой таарахгүй байна.';
$string['nopubkey'] = 'Нийтийн түлхүүрийг сэргээхэд асуудал гарлаа.<br />Хост MNet-ийг зөвшөөрөхгүй эсвэл түлхүүр буруу байна.';
$string['nosite'] = 'Сайтын түвшний хичээлийг олж чадсангүй';
$string['nosuchfile'] = '{$a} файл/функц байхгүй байна.';
$string['nosuchfunction'] = 'RPC хувьд функцыг хориглосон эсвэл функцыг олох боломжгүй.';
$string['nosuchmodule'] = 'Функцыг буруу хаягласан тул олох боломжгүй. Mod/modulename/lib/functionname форматыг ашиглана уу.';
$string['nosuchpublickey'] = 'Гарын үсгийн баталгаажуулалтын нийтийн түлхүүрийг авах боломжгүй.';
$string['nosuchservice'] = 'RPC сервис энэ хост дээр ажиллахгүй байна.';
$string['nosuchtransport'] = 'Ийм ID дугаартай дамжуулалт байхгүй байна.';
$string['notBASE64'] = 'Энэ тэмдэгт мөр нь base64 кодлогдсон формат биш байна. Энэ нь хүчинтэй түлхүүр байж чадахгүй.';
$string['notPEM'] = 'Энэ түлхүүр нь PEM форматтай биш байна. Энэ нь ажиллахгүй.';
$string['not_in_range'] = '<code>{$a}</code> IP хаяг нь хүчинтэй итгэмжлэгдсэн хостыг төлөөлөж чадахгүй.';
$string['notenoughidpinfo'] = 'Таныг таниулагч үйлчилгээ үзүүлэгч нь бидэнд таны бүртгэлийг дотоодод үүсгэх, шинэчлэхэд шаардлагатай хангалттай мэдээлэл өгөхгүй байна. Уучлаарай!';
$string['notinxmlrpcserver'] = 'MNet алсын клиент рүү хандах оролдлого, XMLRPC серверийн гүйцэтгэлийн үед биш';
$string['notmoodleapplication'] = 'АНХААРУУЛГА: Энэ нь Moodle аппликейшн биш тул шалгалтын зарим арга зөв ажиллахгүй байж болзошгүй.';
$string['notpermittedtojump'] = 'Танд энэ Moodle серверээс алсын сейшн эхлүүлэх зөвшөөрөл байхгүй байна.';
$string['notpermittedtojumpas'] = 'Та өөр хэрэглэгчээр нэвтэрсэн үед алсын сейшнг эхлүүлэх боломжгүй.';
$string['notpermittedtoland'] = 'Танд алсын сейшн эхлүүлэх зөвшөөрөл байхгүй байна.';
$string['off'] = 'Унтраах';
$string['on'] = 'Асаах';
$string['options'] = 'Сонголтууд';
$string['peerprofilefielddesc'] = 'Энд шинэ хэрэглэгчийг үүсгэх үед профайлын талбарыг илгээх, импортлох нээлттэй тохиргоог хүчингүй болгож болно';
$string['permittedtransports'] = 'Зөвшөөрөгдсөн шилжүүлэлт';
$string['phperror'] = 'Таны хүсэлтийг биелүүлэхэд дотоод PHP алдаа саад боллоо.';
$string['position'] = 'Байрлал';
$string['postrequired'] = 'Устгах функц нь POST хүсэлтийг шаарддаг.';
$string['profileexportfields'] = 'Илгээх талбар';
$string['profilefielddesc'] = 'Хэрэглэгчийн бүртгэл үүсгэх, шинэчлэх үед MNet-ээр илгээж, хүлээн авсан профайлын талбарын жагсаалтыг энд тохируулах боломжтой. Түүнчлэн үүнийг ижил түвшний MNet  тус бүрээр хүчингүй болгож болно. Дараах талбарыг үргэлж илгээх бөгөөд энэ нь зайлшгүй биш гэдгийг анхаарна уу: {$a}';
$string['profilefields'] = 'Профайлын талбар';
$string['profileimportfields'] = 'Импортлох талбар';
$string['promiscuous'] = 'Замбараагүй';
$string['publickey'] = 'Нийтийн түлхүүр';
$string['publickey_help'] = 'Нийтийн түлхүүрийг алсын серверээс автоматаар авдаг.';
$string['publickeyrequired'] = 'Та нийтийн түлхүүрийг өгөх ёстой.';
$string['publish'] = 'Нийтлэх';
$string['reallydeleteserver'] = 'Та серверийг устгахдаа итгэлтэй байна уу?';
$string['receivedwarnings'] = 'Дараах анхааруулгыг хүлээн авлаа';
$string['recordnoexists'] = 'Бичлэг байхгүй байна.';
$string['reenableserver'] = 'Үгүй - серверийг дахин идэвхжүүлэхийн тулд энэ сонголтыг хийнэ үү.';
$string['registerallhosts'] = 'Бүх хостыг бүртгэх (замбараагүй горим)';
$string['registerallhostsexplain'] = 'Та автоматаар холбогдохыг оролдсон бүх хостыг бүртгэхээр сонгож болно. Энэ нь тантай холбогдож, нийтийн түлхүүр хүссэн дурын MNet сайтын хостын жагсаалтад бичлэг гарах болно.<br />Танд \'Бүх хост\'-ын сервисийг тохируулах дараах сонголтууд байна. Энд зарим сервисийг идэвхжүүлснээр дурын алсын серверт ялгаагүйгээр сервис үзүүлэх боломжтой болно.';
$string['registerhostsoff'] = 'Одоогоор <b>унтраалттай</b> бүх хостыг бүртгэх';
$string['registerhostson'] = 'Одоогоор <b>асаалттай</b> бүх хостыг бүртгэх';
$string['remotecourses'] = 'Алсын хичээл';
$string['remotehost'] = 'Алсын хост';
$string['remotehosts'] = 'Алсын хостууд';
$string['remoteuser'] = 'Алсын {$a->remotetype} хэрэглэгч';
$string['remoteuserinfo'] = 'Профайлыг <a href="{$a->remoteurl}">{$a->remotename}</a> хаягаас татаж авсан';
$string['requiresopenssl'] = 'Сүлжээнд OpenSSL өргөтгөл шаардлагатай';
$string['restore'] = 'Сэргээх';
$string['returnvalue'] = 'Буцаах утга';
$string['reviewhostdetails'] = 'Хостын дэлгэрэнгүй мэдээллийг хянан шалгах';
$string['reviewhostservices'] = 'Хостын сервисийг хянан шалгах';
$string['selectaccesslevel'] = 'Жагсаалтаас хандалтын түвшинг сонгоно уу.';
$string['selectahost'] = 'Алсын хостыг сонгоно уу.';
$string['service'] = 'Сервисийн нэр';
$string['serviceid'] = 'Сервисийн ID дугаар';
$string['servicesavailableonhost'] = '{$a} дээрх боломжит үйлчилгээнүүд';
$string['serviceswepublish'] = 'Бидний {$a}-д үзүүлдэг үйлчилгээнүүд.';
$string['serviceswesubscribeto'] = 'Бидний бүртгүүлсэн {$a} үйлчилгээнүүд.';
$string['settings'] = 'Тохиргоо';
$string['showlocal'] = 'Дотоод хэрэглэгчдийг харуулах';
$string['showremote'] = 'Алсын хэрэглэгчдийг харуулах';
$string['ssl_acl_allow'] = 'SSO ACL: \'{$a->host}\' хостын \'{$a->user}\' хэрэглэгчийг зөвшөөрөх';
$string['ssl_acl_deny'] = 'SSO ACL: \'{$a->host}\' хостын \'{$a->user}\' хэрэглэгчийг хориглох';
$string['sslverification'] = 'SSL баталгаажуулалт';
$string['sslverification_help'] = 'Энэ сонголт нь HTTPS ашиглан холбогдох үед аюулгүй байдлын түвшинг тохируулах боломжийг олгоно.

* Байхгүй: аюулгүй байдлын түвшин байхгүй
* Зөвхөн хостыг баталгаажуулах: SSL сертификатын домэйныг баталгаажуулна
* Хост ба ижил түвшний хостыг баталгаажуулах (санал болгож байна): SSL сертификатын домэйн болон гаргагчийг баталгаажуулна';
$string['ssoaccesscontrol'] = 'SSO хандалтын хяналт';
$string['ssoacldescr'] = 'Энэ хуудсыг алсын MNet хостоос тодорхой хэрэглэгчид хандах эрх олгох/татгалзахад ашиглана. Энэ нь алсын хэрэглэгчид SSO сервисийг санал болгох үед ажилладаг. Өөрийн <em>дотоод</em> хэрэглэгчдийн бусад MNet хост руу хийх роуминг хянахын тулд тэдэнд <em>mnetlogintoremote</em> боломжийг олгох системийн эрхийг ашиглана.';
$string['ssoaclneeds'] = 'Энэ функцыг ажиллуулахын тулд сүлжээ асаалттай, MNet баталгаажуулалтын нэмэлт хэрэгслийг идэвхжүүлсэн байх шаардлагатай.';
$string['strict'] = 'Тодорхой';
$string['subscribe'] = 'Бүртгүүлэх';
$string['system'] = 'Систем';
$string['testclient'] = 'MNet туршилтын үйлчлүүлэгч';
$string['testtrustedhosts'] = 'Хаягийг турших';
$string['testtrustedhostsexplain'] = 'Итгэмжлэгдсэн хост мөн эсэхийг шалгах үүднээс IP хаягаа оруулна.';
$string['theypublish'] = 'Тэд нийтэлдэг';
$string['theysubscribe'] = 'Тэд бүртгүүлдэг';
$string['transport_help'] = 'Эдгээр сонголт нь харилцан хамааралтай тул та баталгаажуулсан SSL сертификат бүхий өөрийн сервертэй тохиолдолд л алсын хостыг баталгаажуулсан SSL сертификат ашиглахыг шаардах боломжтой.';
$string['trustedhosts'] = 'XML-RPC хост';
$string['trustedhostsexplain'] = '<p>Итгэмжлэгдсэн хостын механизм нь тодорхой машинд дурын Moodle API хэсэгт XML-RPC хостоор дамжуулан дуудлага хийх боломжийг олгодог. Энэ нь Moodle системийн үйлдлийг хянах скриптэд байдаг ба идэвхжүүлэх нь маш аюултай байж болно. Хэрэв эргэлзэж байвал үүнийг унтраах хэрэгтэй.</p>
<p><strong>Энэ нь дурын стандарт MNet функцэд шаардлагагүй!</strong> Та юу хийж байгаагаа мэдэж байгаа үед л үүнийг асаагаарай.</p>
<p>Үүнийг идэвхжүүлэхийн тулд мөр бүрд нэг IP хаяг эсвэл
сүлжээний жагсаалтыг оруулна уу. Зарим жишээ:</p>
Таны локал хост:<br />127.0.0.1<br />Таны дотоод хост (сүлжээний блоктой):<br />127.0.0.1/32<br />Зөвхөн 192.168.0.7 IP хаягтай хост:<br />192.168.0.7/32<br />192.168.0.1-ээс 192.168.0.255 хоорондох IP хаягтай дурын хост:<br />192.168.0.0/24<br />Дурын хост:<br />192.108. /0<br />Сүүлийн жишээ нь зөвлөмж болгож буй тохиргоо <strong>биш</strong> болно.';
$string['turnitoff'] = 'Үүнийг унтраа';
$string['turniton'] = 'Үүнийг асаа';
$string['type'] = 'Төрөл';
$string['unknown'] = 'Тодорхойгүй';
$string['unknownerror'] = 'Зөвшилцөх явцад үл мэдэгдэх алдаа гарлаа.';
$string['usercannotchangepassword'] = 'Та алсын хэрэглэгч тул нууц үгээ энд өөрчлөх боломжгүй.';
$string['userchangepasswordlink'] = '<br /> Та нууц үгээ өөрийн <a href="{$a->wwwroot}/login/change_password.php">{$a->description}</a> үйлчилгээ үзүүлэгчид хандан солих боломжтой.';
$string['usernotfullysetup'] = 'Таны хэрэглэгчийн бүртгэл бүрэн бус байна. Та <a href="{$a}">үйлчилгээ үзүүлэгчид хандан</a> өөрийн профайлыг бүрэн эсэхийг шалгах хэрэгтэй. Үүнийг хүчин төгөлдөр болгохын тулд танд системээс гарч, дахин нэвтрэх шаардлага гарч магадгүй.';
$string['usersareonline'] = 'Анхааруулга: Тухайн серверийн {$a} хэрэглэгч одоогоор таны сайтад нэвтэрсэн байна.';
$string['validated_by'] = 'Энэ нь сүлжээгээр баталгаажсан: <code>{$a}</code>';
$string['verifyhostandpeer'] = 'Хост, ижил түвшний хостуудыг баталгаажуулах';
$string['verifyhostonly'] = 'Зөвхөн хостыг баталгаажуулах';
$string['verifysignature-error'] = 'Гарын үсгийн баталгаажуулалт амжилтгүй боллоо. Алдаа гарлаа.';
$string['verifysignature-invalid'] = 'Гарын үсгийн баталгаажуулалт амжилтгүй боллоо. Энд та гарын үсэг зураагүй бололтой.';
$string['version'] = 'Хувилбар';
$string['warning'] = 'Анхааруулга';
$string['wrong-ip'] = 'Таны IP хаяг нь манайд бүртгэлтэй байгаа хаягтай таарахгүй байна.';
$string['xmlrpc-missing'] = 'Та энэ функцыг ашиглахын тулд өөрийн PHP өрөлтөд XML-RPC суулгасан байх шаардлагатай.';
$string['yourhost'] = 'Таны хост';
$string['yourpeers'] = 'Таны ижил түвшний хостууд';
