<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'mn', version '5.1'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Танд удахгүй болох BigBlueButton уулзалт байна';
$string['bbbduetimeoverstartingtime'] = 'Хаагдах хугацаа нь нээгдэх хугацаанаас сүүлд байх ёстой.';
$string['bbbdurationwarning'] = 'Энэ уулзалтын үргэлжлэх хугацаа нь ихдээ %duration% минут байна.';
$string['bbbrecordallfromstartwarning'] = 'Уулзалт эхэлснээс хойш бичлэг хийж байна.';
$string['bbbrecordwarning'] = 'Энэ уулзалтын бичлэгийг хийж болно.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Шинэ BigBlueButton өрөө нэмэх';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Уулзалтыг шууд дамжуулах тохиолдол үүсгэх';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Бичлэг бүхий тохиолдол үүсгэх';
$string['bigbluebuttonbn:deleterecordings'] = 'Бичлэгийг устгах';
$string['bigbluebuttonbn:importrecordings'] = 'Бичлэгийг импортлох';
$string['bigbluebuttonbn:join'] = 'BigBlueButton өрөөнд нэгдэх';
$string['bigbluebuttonbn:managerecordings'] = 'Бичлэгийг удирдах';
$string['bigbluebuttonbn:protectrecordings'] = 'Бичлэгийг хамгаалах';
$string['bigbluebuttonbn:publishrecordings'] = 'Бичлэгийг нийтлэх';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Бичлэгийн хамгаалалтыг цуцлах';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Бичлэгийг нийтэлснийг цуцлах';
$string['bigbluebuttonbn:view'] = 'BigBlueButton өрөөг харах';
$string['bigbluebuttonbn:viewallrecordingformats'] = 'Бүх бичлэгийн форматыг үзэх';
$string['cachedef_currentfetch'] = 'Саяхан татаж авсан бичлэгийг жагсаах өгөгдөл.';
$string['cachedef_recordings'] = 'metadata-г бичих';
$string['cachedef_serverinfo'] = 'Зайнаас хандах серверийн мэдээлэл';
$string['cachedef_validatedurls'] = 'Баталгаажсан URL шалгах кэш';
$string['calendarstarts'] = '{$a} төлөвлөгдсөн';
$string['cannotperformaction'] = 'Энэ бичлэгт {$a} үйлдлийг гүйцэтгэх боломжгүй';
$string['completionattendance'] = 'Суралцагч оролцох ёстой хуралдаан:';
$string['completionattendance_desc'] = 'Өрөөнд орж, дор хаяж {$a} минутын турш байна.';
$string['completionattendance_event_desc'] = 'Суралцагч өрөөнд орж, хуралдаанд дор хаяж {$a} минут оролцсон';
$string['completionattendancegroup'] = 'Ирц шаардах';
$string['completionengagement_desc'] = 'Уулзалтын үеэр үйл ажиллагаанд оролцох.';
$string['completionengagementchats'] = 'Чат';
$string['completionengagementchats_desc'] = '{$a} чатад оролцох';
$string['completionengagementchats_event_desc'] = '{$a} чат үүссэн';
$string['completionengagementemojis'] = 'Эможи';
$string['completionengagementemojis_desc'] = 'Тэдний эможийг {$a} удаа өөрчлөх.';
$string['completionengagementemojis_event_desc'] = 'Тэдний эможийг {$a} удаа өөрчилсөн.';
$string['completionengagementgroup'] = 'Оролцохыг шаардах';
$string['completionengagementpollvotes'] = 'Санал асуулга';
$string['completionengagementpollvotes_desc'] = 'Санал асуулгад {$a} удаа санал өгнө.';
$string['completionengagementpollvotes_event_desc'] = '{$a} санал асуулгад хариулсан.';
$string['completionengagementraisehand'] = 'Гараа өргөхийн шаардах';
$string['completionengagementraisehand_desc'] = '{$a} удаа гараа өргөх';
$string['completionengagementraisehand_event_desc'] = '{$a} удаа гараа өргөсөн';
$string['completionengagementtalks'] = 'Ярилцах';
$string['completionengagementtalks_desc'] = '{$a} удаа ярилцах';
$string['completionengagementtalks_event_desc'] = '{$a} яриа өрнүүлсэн';
$string['completionupdatestate'] = 'Дууссан төлөвт оруулах';
$string['completionvalidatestate'] = 'Баталгаажуулж дуусгах';
$string['completionvalidatestatetriggered'] = 'Баталгаажуулж дуусгахыг идэвхжүүлсэн.';
$string['completionview_event_desc'] = 'Өрөөг харсан';
$string['config_checksum_algorithm'] = 'BigBlueButton серверийн хяналтын-нийлбэр алгоритм';
$string['config_checksum_algorithm_description'] = 'BigBlueButton серверийн хяналтын-нийлбэрийн алгоритм. SHA256 болон SHA512 нь илүү найдвартай, SHA512 нь FIPS 140-2-тэй нийцдэг.';
$string['config_default_messages'] = 'Өгөгдмөл зурвас';
$string['config_default_messages_description'] = 'Үйл ажиллагааны өгөгдмөл зурвасыг тохируулах';
$string['config_disablecam_default'] = 'Өгөгдмөлөөр идэвхжүүлсэн веб камерыг идэвхгүй болгох';
$string['config_disablecam_default_description'] = 'Хэрэв идэвхжүүлбэл веб камер идэвхгүй болно.';
$string['config_disablecam_editable'] = 'Засварлах боломжтой веб камерыг идэвхгүй болгох';
$string['config_disablecam_editable_description'] = 'Өгөгдмөлөөр идэвхгүй болгосон веб камерыг тохиолдол нэмэх эсвэл шинэчлэх үед засварлах боломжтой';
$string['config_disablemic_default'] = 'Өгөгдмөлөөр идэвхжүүлсэн микрофоныг идэвхгүй болгох';
$string['config_disablemic_default_description'] = 'Хэрэв идэвхжүүлбэл микрофон идэвхгүй болох болно.';
$string['config_disablemic_editable'] = 'Микрофоныг идэвхгүй болгох эсэхийг засварлах боломжтой';
$string['config_disablemic_editable_description'] = 'Өгөгдмөлөөр идэвхгүй болгосон микрофоныг тохиолдол нэмэх эсвэл шинэчлэх үед засварлах боломжтой';
$string['config_disablenote_default'] = 'Өгөгдмөлөөр идэвхжүүлсэн хуваалцсан тэмдэглэлийг идэвхгүй болгох';
$string['config_disablenote_default_description'] = 'Хэрэв идэвхжүүлбэл хуваалцсан тэмдэглэл идэвхгүй болох болно.';
$string['config_disablenote_editable'] = 'Засварлах боломжтой хуваалцсан тэмдэглэлийг идэвхгүй болгох';
$string['config_disablenote_editable_description'] = 'Өгөгдмөлөөр идэвхгүй болгосон хуваалцсан тэмдэглэлийг тохиолдол нэмэх эсвэл шинэчлэх үед засварлах боломжтой.';
$string['config_disableprivatechat_default'] = 'Өгөгдмөлөөр идэвхжүүлсэн хувийн чатыг идэвхгүй болгох';
$string['config_disableprivatechat_default_description'] = 'Хэрэв идэвхжүүлбэл хувийн чат идэвхгүй болно.';
$string['config_disableprivatechat_editable'] = 'Засварлах боломжтой хувийн чатыг идэвхгүй болгох';
$string['config_disableprivatechat_editable_description'] = 'Өгөгдмөлөөр идэвхгүй болгосон хувийн чатыг тохиолдол нэмэх эсвэл шинэчлэх үед засварлах боломжтой.';
$string['config_disablepublicchat_default'] = 'Өгөгдмөлөөр идэвхжүүлсэн нийтийн чатыг идэвхгүй болгох';
$string['config_disablepublicchat_default_description'] = 'Хэрэв идэвхжүүлбэл нийтийн чат идэвхгүй болно.';
$string['config_disablepublicchat_editable'] = 'Засварлах боломжтой нийтийн чатыг идэвхгүй болгох';
$string['config_disablepublicchat_editable_description'] = 'Өгөгдмөлөөр идэвхгүй болгосон нийтийн чатыг тохиолдол нэмэх эсвэл шинэчлэх үед засварлах боломжтой.';
$string['config_experimental_features'] = 'Туршилтын онцлог шинжүүд';
$string['config_experimental_features_description'] = 'Туршилтын онцлог шинжүүдын тохиргоо';
$string['config_extended_capabilities'] = 'Өргөтгөсөн боломжууд';
$string['config_extended_capabilities_description'] = 'BigBlueButton сервер санал болгох үед өргөтгөсөн боломжуудад зориулсан тохиргоо.';
$string['config_general'] = 'Ерөнхий тохиргоо';
$string['config_general_description'] = 'BigBlueButton-ийг тохируулахын тулд та өөрийн BigBlueButton сервер болон итгэмжлэлээ ашиглах эсвэл <a href="https://registration-portal.blindsidenetworks.com/" target="_blank">Blindside Networks бүртгэлийн портал (шинэ цонхонд нээгдэнэ)</a>-аар дамжуулан итгэмжлэл авах боломжтой.';
$string['config_guestaccess_enabled'] = 'Гадаад зочны хандалт';
$string['config_guestaccess_enabled_description'] = 'Хуудсанд бүртгэлгүй хэрэглэгч өрөөнд хандахыг зөвшөөрөх';
$string['config_hideuserlist_default'] = 'Өгөгдмөлөөр идэвхжүүлсэн хэрэглэгчийн жагсаалтыг нуух';
$string['config_hideuserlist_default_description'] = 'Хэрэв идэвхжүүлбэл уулзалтад оролцогчдийн жагсаалтыг нуух болно.';
$string['config_hideuserlist_editable'] = 'Засварлах боломжтой хэрэглэгчийн жагсаалтыг нуух';
$string['config_hideuserlist_editable_description'] = 'Өгөгдмөлөөр нуусан хэрэглэгчийн жагсаалтыг тохиолдол нэмэх эсвэл шинэчлэх үед засварлах боломжтой.';
$string['config_importrecordings'] = 'Бичлэгийг импортлох';
$string['config_importrecordings_description'] = 'Эдгээр тохиргоо нь тусгай онцлогтой байдаг.';
$string['config_importrecordings_enabled'] = 'Бичлэгийг импортлохыг идэвхжүүлсэн';
$string['config_importrecordings_enabled_description'] = 'Үүнийг болон бичлэгийн онцлогийг идэвхжүүлсэн үед өөр хичээлийн бичлэгийг үйл ажиллагаа руу импортлох боломжтой болно.';
$string['config_importrecordings_from_deleted_enabled'] = 'Устгасан үйл ажиллагааны бичлэгийг импортлохыг идэвхжүүлсэн';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Үүнийг болон бичлэг импортлох онцлогийг идэвхжүүлсэн үед тухайн хичээлээс устгасан үйл ажиллагааны бичлэгийг импортлох боломжтой болно.';
$string['config_locksettings'] = 'Түгжих тохиргооны тохируулга';
$string['config_locksettings_description'] = 'Эдгээр тохиргоо нь түгжих тохиргооны UI дах боломжуудыг идэвхжүүлэх эсвэл идэвхгүй болгохоос гадна тэдгээрийн өгөгдмөл утгыг тохируулна.';
$string['config_meetingevents_enabled'] = 'Шууд болж буй уулзалтыг бүртгэх';
$string['config_meetingevents_enabled_description'] = 'Хэрэв идэвхжүүлбэл шууд болж буй уулзалтуудыг дууссаны дараа боловсруулах болно. Энэ онцлог нь үйл ажиллагааг дуусгахад шаардлагатай бөгөөд BigBlueButton сервер нь post_events скриптийг боловсруулах чадвартай тохиолдолд л ажиллах болно.';
$string['config_muteonstart'] = 'Эхлэх үед дууг хаах';
$string['config_muteonstart_default'] = 'Эхлэх үед дууг хаахыг өгөгдмөлөөр идэвхжүүлсэн';
$string['config_muteonstart_default_description'] = 'Хэрэв идэвхжүүлбэл уулзалт эхлэх үед дууг хаана.';
$string['config_muteonstart_description'] = 'Эдгээр тохиргоо нь UI дахь боломжуудыг идэвхжүүлэх эсвэл идэвхгүй болгохоос гадна тэдгээрийн өгөгдмөл утгыг тохируулна.';
$string['config_muteonstart_editable'] = 'Эхлэх үед дууг хаахыг засварлах боломжтой';
$string['config_muteonstart_editable_description'] = 'Өгөгдмөлөөр эхлэх үед дууг хаахыг тохиолдол нэмэх эсвэл шинэчлэх үед засварлах боломжтой.';
$string['config_participant'] = 'Оролцогчид';
$string['config_participant_description'] = 'Эдгээр тохиргоо нь оролцогчийн өгөгдмөл дүрийг тохируулна.';
$string['config_participant_moderator_default'] = 'Зохицуулагч';
$string['config_participant_moderator_default_description'] = 'Шинэ өрөө нэмэх үед энэ дүрмийг өгөгдмөлөөр ашигладаг.';
$string['config_poll_interval'] = 'Өрөөний төлөвийг шинэчлэх санал асуулгын завсарлага (секундээр)';
$string['config_poll_interval_description'] = 'Санал асуулгын завсарлага нь хамгийн багадаа 2 секунд байна. Шаардлагатай бол завсарлагыг нэмэгдүүлэх замаар алсын серверийн ачааллыг бууруулж болно.';
$string['config_presentation_default'] = 'Өгөгдмөл үзүүлэн файл';
$string['config_presentation_default_description'] = 'Бүх өрөөнд ашиглах файлыг өгч болно.';
$string['config_preuploadpresentation'] = 'Урьдчилан байршуулсан үзүүлэн';
$string['config_preuploadpresentation_description'] = 'Эдгээр тохиргоо нь UI дахь боломжуудыг идэвхжүүлэх эсвэл идэвхгүй болгохоос гадна тэдгээрийн өгөгдмөл утгыг тохируулна.';
$string['config_preuploadpresentation_editable'] = 'Урьдчилан байршуулсан засварлах боломжтой үзүүлэн';
$string['config_preuploadpresentation_editable_description'] = 'UI дахь урьдчилан байршуулсан үзүүлэнг өрөө эсвэл хурал нэмэх, шинэчлэх үед засварлах боломжтой.';
$string['config_profile_picture_enabled'] = 'Профайл зургийг харуулах';
$string['config_profile_picture_enabled_description'] = 'BigBlueButton уулзалтад оролцогчдын профайлын зургийг харуулах уу?';
$string['config_recording'] = 'Бичиж байна';
$string['config_recording_all_from_start_default'] = 'Эхлэх үед бичлэгийг эхлүүлэх';
$string['config_recording_all_from_start_default_description'] = 'Шинэ BigBlueButton өрөө нэмэх үед \'Эхлэх үед бичлэгийг эхлүүлэх\' тохиргоог өгөгдмөлөөр идэвхжүүлэх шаардлагатай.';
$string['config_recording_all_from_start_editable'] = 'Эхлэх үед бичлэгийг эхлүүлэх эсэхийг засварлах боломжтой';
$string['config_recording_all_from_start_editable_description'] = 'BigBlueButton үйл ажиллагааны тохиргоонд \'Эхлэх үед бичлэгийг эхлүүлэх\' тохиргоог засварлах боломжтой юу?';
$string['config_recording_default'] = 'Бичлэг хийхийг өгөгдмөлөөр идэвхжүүлсэн';
$string['config_recording_default_description'] = 'Шинэ BigBlueButton өрөө нэмэх үед \'Уулзалтыг бичиж болно\' тохиргоог засварлах боломжтой юу?';
$string['config_recording_description'] = 'Эдгээр тохиргоо нь тусгай онцлогтой';
$string['config_recording_editable'] = 'Уулзалтыг бичиж болох эсэхийг засварлах боломжтой';
$string['config_recording_editable_description'] = 'Шинэ BigBlueButton өрөө нэмэх үед \'Уулзалтыг бичиж болно\' тохиргоог засварлах боломжтой юу?';
$string['config_recording_hide_button_default'] = 'Бичлэг хийх товчийг нуух';
$string['config_recording_hide_button_default_description'] = 'Хэрэв тэмдэглэсэн бол бичлэг хийх товчлуурыг нуух болно';
$string['config_recording_hide_button_editable'] = 'Бичлэг хийх товчийг нуух эсэхийг засварлах боломжтой';
$string['config_recording_hide_button_editable_description'] = 'BigBlueButton үйл ажиллагааны тохиргоонд \'Бичлэг хийх товчийг нуух\' тохиргоог засварлах боломжтой юу?';
$string['config_recording_protect_editable'] = 'Бичлэгийг хамгаалсан төлөвийг засварлах боломжтой';
$string['config_recording_protect_editable_description'] = 'Сонгосон тохиолдолд харагдах хэсэгт бичлэгийг хамгаалах/хамгаалалтгүй болгох сонголтыг харуулна.';
$string['config_recording_refresh_period'] = 'Бичлэгийг сэргээх хугацаа (секундээр)';
$string['config_recording_refresh_period_description'] = 'Бичлэг хийх алсын зайн мэдээллийг сэргээхийн тулд BigBlueButton серверээс хэр давтамжтай асууж байх ёстой вэ?';
$string['config_recording_safe_formats'] = 'Бичлэгийн форматыг бүгд үзэх боломжтой';
$string['config_recording_safe_formats_description'] = 'Бүх хүн үзэх боломжтой форматуудыг сонгоно уу.
Бусад форматыг зөвхөн mod/bigbluebuttonbn:viewallrecordingformats болон mod/bigbluebuttonbn:managerecordings чадвартай багш болон бусад хэрэглэгчид үзэх боломжтой.';
$string['config_recordingready_enabled'] = 'Бичлэг хийх боломжтой гэсэн мэдэгдэл илгээх';
$string['config_recordingready_enabled_description'] = 'Идэвхжүүлсэн бол бичлэг хийх холбоос боломжтой үед мэдэгдэл илгээгдэх болно. Энэ функц нь BigBlueButton сервер дээр post_publish_recording_ready_callback скриптийг идэвхжүүлэхийг шаарддаг.';
$string['config_recordings'] = 'Бичлэгийг харуулах';
$string['config_recordings_asc_sort'] = 'Бичлэгүүдийг он цагийн дарааллаар жагсаах';
$string['config_recordings_asc_sort_description'] = 'Бичлэгүүдийг огноогоор, он цагийн дарааллаар эсвэл он цагийн урвуу дарааллаар (хамгийн сүүлийн үеийн бичлэг эхлээд) эрэмбэлсэн.';
$string['config_recordings_deleted_default'] = 'Өгөгдмөлөөр идэвхжүүлсэн устгасан үйл ажиллагааны бичлэгийг оролцуулах';
$string['config_recordings_deleted_default_description'] = 'Идэвхжүүлсэн бол идэвхжүүлснээс хойш устгагдсан аливаа үйл ажиллагааны бичлэгийг бичлэгийн хүснэгтэд оруулна.';
$string['config_recordings_deleted_editable'] = 'Устгасан үйл ажиллагааны бичлэгийг оролцуулах эсэхийг засварлах боломжтой';
$string['config_recordings_deleted_editable_description'] = 'Устгасан үйл ажиллагааны бичлэгийг өгөгдмөлөөр оруулах эсэхийг тохиолдол нэмэх эсвэл шинэчлэх үед засварлах боломжтой';
$string['config_recordings_description'] = 'Эдгээр тохиргоо нь тусгай онцлогтой';
$string['config_recordings_general'] = 'Бичлэгийн тохиргоог харуулах';
$string['config_recordings_general_description'] = 'Эдгээр тохиргоог зөвхөн бичлэгийг харуулж байх үед л ашиглана';
$string['config_recordings_imported_default'] = 'Зөвхөн импортолсон холбоосыг харуулахыг өгөгдмөлөөр идэвхжүүлсэн';
$string['config_recordings_imported_default_description'] = 'Хэрэв идэвхжүүлбэл бичлэгийн хүснэгтэд зөвхөн бичлэгийн импортын холбооснуудыг оруулна.';
$string['config_recordings_imported_editable'] = 'Импортолсон холбоосыг харуулах эсэхийг засварлах боломжтой';
$string['config_recordings_imported_editable_description'] = 'Зөвхөн импортлосон холбоосуудыг өгөгдмөлөөр харуулах эсэхийг тохиолдол нэмэх эсвэл шинэчлэх үед засварлах боломжтой';
$string['config_recordings_preview_default'] = 'Урьдчилан харахыг өгөгдмөлөөр идэвхжүүлсэн';
$string['config_recordings_preview_default_description'] = 'Хэрэв идэвхжүүлбэл үзүүлэнг хүснэгтэд урьдчилан харуулна.';
$string['config_recordings_preview_editable'] = 'Урьдчилан харуулах тохиргоог засварлах боломжтой';
$string['config_recordings_preview_editable_description'] = 'Урьдчилан харуулах тохиргоог тохиолдол нэмэх эсвэл шинэчлэх үед засварлах боломжтой';
$string['config_scheduled'] = 'Төлөвлөсөн уулзалтууд';
$string['config_scheduled_description'] = 'Эдгээр тохиргоо нь төлөвлөсөн уулзалтын өгөгдмөл үйл явцыг тодорхойлно.';
$string['config_scheduled_pre_opening'] = 'Нээх цагаас өмнө хандах боломжтой';
$string['config_scheduled_pre_opening_description'] = 'Төлөвлөсөн нээх цагаас өмнө өрөө нээлттэй байх хугацаа (минутаар).';
$string['config_server_url'] = 'BigBlueButton серверийн URL';
$string['config_server_url_description'] = 'Blindside Networks компанийн <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">Moodle системд зориулсан үнэгүй BigBlueButton үйлчилгээ (шинэ цонхонд нээнэ)</a>-нд зориулсан өгөгдмөл батламж нь дараах хязгаарлалттай:
<ol>
<li>Нэг уулзалтын хугацаа нь хамгийн ихдээ 60 минут байна</li>
<li>Нэг уулзалтад зэрэг оролцох хэрэглэгчийн тоо хамгийн ихдээ 25 байна.</li>
<li>Бичлэгийг 7 хоногийн хугацаатай хадгалах бөгөөд татаж авах боломжгүй</li>
<li>Суралцагчийн веб камер нь зөвхөн зохицуулагчид л харагдана. </li>
</ol>';
$string['config_shared_secret'] = 'BigBlueButton хуваалцсан нууц';
$string['config_shared_secret_description'] = 'BigBlueButton серверийн аюулгүй байдлын нууц. Өгөгдмөд нууц нь Blindside Networks компаниас үзүүлдэг үнэгүй BigBlueButton үйлчилгээ юм.';
$string['config_uidelegation_enabled'] = 'UI төлөөллийг идэвхжүүлсэн';
$string['config_uidelegation_enabled_description'] = 'Эдгээр тохиргоо нь BigBlueButton серверт UI төлөөллийг идэвхжүүлэх эсвэл идэвхгүй болгодог.';
$string['config_userlimit'] = 'Хэрэглэгчийн хязгаар';
$string['config_userlimit_default'] = 'Хэрэглэгчийн хязгаарыг өгөгдмөлөөр идэвхжүүлсэн';
$string['config_userlimit_default_description'] = 'Өрөө шинээр нэмэх үед уулзалтад оролцож болох хэрэглэгчийн тоо. 0 гэсэн утга нь хэрэглэгчийн тоог хязгаарлаагүй болохыг илэрхийлнэ.';
$string['config_userlimit_description'] = 'Эдгээр тохиргоо нь UI дахь боломжуудыг идэвхжүүлэх эсвэл идэвхгүй болгохоос гадна тэдгээрийн өгөгдмөл утгыг тохируулна.';
$string['config_userlimit_editable'] = 'Хэрэглэгчийн хязгаар тохиргоог засварлах боломжтой';
$string['config_userlimit_editable_description'] = 'Өгөгдмөлөөр тодорхойлсон хэрэглэгчийн хязгаарыг өрөө эсвэл хурал нэмэх, шинэчлэх үед засварлах боломжтой.';
$string['config_voicebridge'] = 'Дуут гүүр';
$string['config_voicebridge_description'] = 'Эдгээр тохиргоо нь UI дахь боломжуудыг идэвхжүүлэх эсвэл идэвхгүй болгохоос гадна тэдгээрийн өгөгдмөл утгыг тохируулна.';
$string['config_voicebridge_editable'] = 'Хурлын дуут гүүрийг засварлах боломжтой';
$string['config_voicebridge_editable_description'] = 'Хурлын дуут гүүрний дугаарыг өрөөнд тогтмол ашиглахаар тохируулсан байна. Хэрэв тус дугаарыг хуваарилсан бол бусад өрөөнд ашиглах боломжгүй.';
$string['config_waitformoderator'] = 'Зохицуулагчийг хүлээх';
$string['config_waitformoderator_cache_ttl'] = 'Зохицуулагч TTL кэшийг хүлээх';
$string['config_waitformoderator_cache_ttl_description'] = 'Тус нэмэлт хэрэгсэл нь клиентийн ачааллыг дэмжихийн тулд кэш ашигладаг. Энэ параметр нь BigBlueButton сервер рүү  дараагийн хүсэлтийг илгээхээс өмнө кэш хадгалах хугацааг тодорхойлдог.';
$string['config_waitformoderator_default'] = 'Зохицуулагчийг хүлээхийг өгөгдмөл утгаар идэвхжүүлсэн';
$string['config_waitformoderator_default_description'] = 'Шинэ BigBlueButton өрөө нэмэх үед "Зохицуулагчийг хүлээх" тохиргоог өгөгдмөл утгаар идэвхжүүлэх ёстой юу?';
$string['config_waitformoderator_description'] = 'Эдгээр тохиргоо нь тусгай онцлогтой';
$string['config_waitformoderator_editable'] = 'Зохицуулагчийг хүлээх эсэхийг засварлах боломжтой';
$string['config_waitformoderator_editable_description'] = 'BigBlueButton үйл ажиллагааны тохиргоонд "Зохицуулагчийг хүлээх" хэсэгт засвар хийх боломжтой  юу?';
$string['config_waitformoderator_ping_interval'] = 'Зохицуулагчийн пинг хүлээх';
$string['config_waitformoderator_ping_interval_description'] = 'Зохицуулагч өрөөнд нэвтэрсэн эсэхийг шалгахын тулд сервер хэр олон удаа пинг хийж шалгах вэ?';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButton нь хэрэгцээгүй болсон гадаад хувьсагчтай config.php файлыг ашигладаг. Шинэ хувилбарууд тус файлыг дэмжихгүй тул хөрвүүлнэ үү.';
$string['config_warning_curl_not_installed'] = 'Тус боломж нь php файлд зориулсан CURL өргөтгөлийг суулгаж, идэвхжүүлэхийг шаарддаг. Энэ нөхцөлийг бүрэн хангасан тохиолдолд л тохиргоонд хандах боломжтой болно.';
$string['config_welcome_default'] = 'Өгөгдмөл угтах зурвас';
$string['config_welcome_default_description'] = 'Оролцогч өрөөнд орж ирэх үед угтах зурвасыг харуулна. Хэрэв талбарыг хоосон орхивол BigBlueButton серверт тохируулсан өгөгдмөл зурвас харагдах болно.';
$string['config_welcome_editable'] = 'Угтах зурвасыг багш засварлах боломжтой';
$string['config_welcome_editable_description'] = 'Тохиолдол нэмэх болон шинэчлэх үед угтах зурвасыг засварлах боломжтой';
$string['end_session_confirm'] = 'Та уулзалтыг дуусгахыг хүсэж байна уу?';
$string['end_session_confirm_title'] = 'Үнэхээр уулзалтыг дуусгах уу?';
$string['end_session_notification'] = 'Уулзалт дууслаа.';
$string['ends_at'] = 'Төгсгөл';
$string['event_activity_created'] = 'Үйл ажиллагаа үүслээ';
$string['event_activity_deleted'] = 'Үйл ажиллагаа устлаа';
$string['event_activity_updated'] = 'Үйл ажиллагаа шинэчлэгдлээ';
$string['event_live_session'] = 'Шууд дамжуулах уулзалтын арга хэмжээ';
$string['event_meeting_created'] = 'Уулзалт үүслээ';
$string['event_meeting_ended'] = 'Уулзалтыг албаар дуусгасан.';
$string['event_meeting_joined'] = 'Уулзалтад нэгдсэн';
$string['event_meeting_left'] = 'Уулүалтаас гарсан';
$string['event_recording_deleted'] = 'Бичлэгийг устгасан';
$string['event_recording_edited'] = 'Бичлэгийг засварласан';
$string['event_recording_imported'] = 'Бичлэг импортолсон';
$string['event_recording_protected'] = 'Бичлэгийг хамгаалсан';
$string['event_recording_published'] = 'Бичлэгийг нийтэлсэн';
$string['event_recording_unprotected'] = 'Бичлэгийн хамгаалалтыг цуцалсан';
$string['event_recording_unpublished'] = 'Бичлэг нийтэлснээ цуцалсан';
$string['event_recording_viewed'] = 'Бичлэгийг үзсэн';
$string['event_unknown'] = 'Үл мэдэх арга хэмжээ';
$string['general_error_cannot_create_meeting'] = 'Уулзалт үүсгэж чадсангүй';
$string['general_error_cannot_get_recordings'] = 'Бичлэг хийж чадсангүй';
$string['general_error_no_answer'] = 'Хоосон хариулт. BigBlueButton серверийн url хаягийг шалгаад BigBlueButton сервер ажиллаж байгаа эсэхийг шалгана уу.';
$string['general_error_not_allowed_to_create_instances'] = 'Хэрэглэгчийг ямар нэгэн тохиолдол үүсгэхийг зөвшөөрөөгүй.';
$string['general_error_not_found'] = '{$a} дугаартай BigBlueButton үйл ажиллагаа олдсонгүй';
$string['general_error_unable_connect'] = 'Холбогдох боломжгүй. BigBlueButton серверийн url хаягийг шалгаад BigBlueButton сервер ажиллаж байгаа эсэхийг шалгана уу.
Дэлгэрэнгүй: {$a}';
$string['guest_invitation_full_message'] = 'Сайн уу,
<p>Таныг {$a->course_fullname} хичээлийн <strong>{$a->name}</strong> BigBlueButton уулзалтад урьсан байна.</p>
<p>Холбоос: {$a->guestjoinurl}<br/>
<p>Нууц үг: {$a->guestpassword}</p>
<p>Танд тусламж хэрэгтэй бол {$a->sender}-тай холбогдоно уу. </p>';
$string['guest_invitation_small_message'] = 'Сайн байна уу,

Таныг {$a->course_fullname} хичээлийн {$a->name} BigBlueButton уулзалтад урьсан байна.

Холбоос: {$a->guestjoinurl}
Нууц үг: {$a->guestpassword}

Танд тусламж хэрэгтэй бол {$a->sender} урилга илгээгчтэй холбогдоно уу.';
$string['guest_invitation_subject'] = 'Урилга:  {$a->course_fullname} хичээлийн {$a->name} уулзалт';
$string['guestaccess_activitynotfound'] = 'Үйл ажиллагаа олдсонгүй';
$string['guestaccess_add'] = 'Зочин нэмэх';
$string['guestaccess_add_no_id'] = 'Тохиолдлын ID өгсөн BigBlueButton байхгүй';
$string['guestaccess_copy_password'] = 'Нууц үг хуул';
$string['guestaccess_emails'] = 'Зочны цахим шуудан';
$string['guestaccess_emails_help'] = 'Таслалаар тусгаарлагдсан цахим шуудангийн хаягийн жагсаалт.';
$string['guestaccess_emails_invalidemail'] = 'Хүчингүй цахим шуудан: {$a}';
$string['guestaccess_feature_disabled'] = 'Зочны хандалтыг идэвхгүй болгосон.';
$string['guestaccess_invite_failure'] = '{$a->emails} хэрэглэгчийг урихад алдаа гарлаа: {$a->errors}';
$string['guestaccess_invite_success'] = '{$a->emails} цахим шуудан руу урилга илгээсэн.';
$string['guestaccess_join_meeting'] = 'Зөвлөгөөнд нэгдэх';
$string['guestaccess_meeting_invalid_password'] = 'Нууц үг буруу байна.';
$string['guestaccess_meeting_not_started'] = 'Зөвлөгөөн хараахан эхлээгүй байна. Дараа дахин холбогдоно уу.';
$string['guestaccess_meeting_password'] = 'Зөвлөгөөний нууц үг';
$string['guestaccess_password'] = 'Нууц үг';
$string['guestaccess_title'] = 'Тус зөвлөгөөнд зочин нэмэх';
$string['guestaccess_username'] = 'Зочны нэвтрэх нэр';
$string['index_confirm_end'] = 'Та уулзалтыг дуусгахыг хүсэж байна уу?';
$string['index_disabled'] = 'идэвхгүй болгосон';
$string['index_enabled'] = 'идэвхжүүлсэн';
$string['index_ending'] = 'Уулзалтыг дуусгаж байна ... түр хүлээнэ үү';
$string['index_error_bbtn'] = 'BigBlueButton ID {$a} буруу байна';
$string['index_error_checksum'] = 'Хяналтын-нийлбэрт алдаа гарлаа. Та зөв нууц оруулсан эсэх ээ шалгана уу.';
$string['index_error_forciblyended'] = 'Уулзалтыг гар аргаар дуусгасан учир энэ уулзалтад нэгдэх боломжгүй байна.';
$string['index_error_noinstances'] = 'BigBlueButton өрөөний тохиолдол байхгүй байна.';
$string['index_error_unable_display'] = 'Уулзалтыг харуулах боломжгүй байна. BigBlueButton серверийн url хаягийг шалгаад BigBlueButton сервер ажиллаж байгаа эсэхийг шалгана уу.';
$string['index_heading'] = 'BigBlueButton өрөө';
$string['index_heading_actions'] = 'Үйлдэл';
$string['index_heading_group'] = 'Бүлэг';
$string['index_heading_moderator'] = 'Зохицуулагчид';
$string['index_heading_name'] = 'Өрөө';
$string['index_heading_recording'] = 'Бичлэг';
$string['index_heading_users'] = 'Хэрэглэгч';
$string['index_heading_viewer'] = 'Үзэгч';
$string['indicator:cognitivedepth'] = 'BigBlueButton танин мэдэхүйн';
$string['indicator:cognitivedepth_help'] = 'Энэ үзүүлэлт нь суралцагчийн BigBlueButton-ын үйл ажиллагаанд хүрсэн танин мэдэхүйн гүнд тулгуурладаг.';
$string['indicator:socialbreadth'] = 'BigBlueButton нийгмийн';
$string['indicator:socialbreadth_help'] = 'Энэ үзүүлэлт нь суралцагчийн BigBlueButton-ын үйл ажиллагааны явцад хүрсэн нийгмийн хүрээн дээр суурилдаг.';
$string['instance_type_default'] = 'Бичлэг бүхий өрөө';
$string['instance_type_recording_only'] = 'Зөвхөн бичлэг';
$string['instance_type_room_only'] = 'Зөвхөн өрөө';
$string['instanceprofilewithoutrecordings'] = 'Тус профайлын тохиолдол нь бичлэгийг харуулж чадахгүй';
$string['messageprovider:instance_updated'] = 'BigBlueButton уулзалтыг шинэчилсэн';
$string['messageprovider:recording_ready'] = 'BigBlueButton бичлэг байгаа';
$string['minute'] = 'минут';
$string['minutes'] = 'минут';
$string['mod_form_block_general'] = 'Ерөнхий';
$string['mod_form_block_guestaccess'] = 'Зочны хандалт';
$string['mod_form_block_participants'] = 'Шууд уулзалтын үеэр үүрэг оноосон';
$string['mod_form_block_presentation'] = 'Үзүүлэнгийн агуулга';
$string['mod_form_block_presentation_default'] = 'Үзүүлэнгийн өгөгдмөл агуулга';
$string['mod_form_block_record'] = 'Бичлэгийн тохиргоо';
$string['mod_form_block_recordings'] = 'Бичлэгийн үзэлт';
$string['mod_form_block_room'] = 'Өрөөний тохиргоо';
$string['mod_form_block_schedule'] = 'Уулзалтын цаг';
$string['mod_form_field_closingtime'] = 'Хаах';
$string['mod_form_field_conference_name'] = 'Уулзалтын нэр';
$string['mod_form_field_disablecam'] = 'Веб камерыг идэвхгүй болгох';
$string['mod_form_field_disablemic'] = 'Микрофоныг идэвхгүй болгох';
$string['mod_form_field_disablenote'] = 'Хуваалцсан тэмдэглэлийг идэвхгүй болгох';
$string['mod_form_field_disableprivatechat'] = 'Хувийн чатыг идэвхгүй болгох';
$string['mod_form_field_disablepublicchat'] = 'Нийтийн чатыг идэвхгүй болгох';
$string['mod_form_field_duration'] = 'Үргэлжлэх хугацаа';
$string['mod_form_field_duration_help'] = 'Уулзалтын үргэлжлэх хугацааг тохируулснаар бичлэг дуусахаас өмнө уулзалт үргэлжлэх хамгийн дээд хугацааг тогтооно';
$string['mod_form_field_guestallowed'] = 'Зочны хандалтыг зөвшөөрөх';
$string['mod_form_field_hideuserlist'] = 'Хэрэглэгчийн жагсаалтыг нуух';
$string['mod_form_field_instanceprofiles'] = 'Тохиолдлын төрөл';
$string['mod_form_field_instanceprofiles_help'] = 'Хэрэв бичлэг хийх бол "Бичлэг бүхий өрөө" сонголтыг, бусад тохиолдолд "Зөвхөн өрөө" сонголтыг сонгоно. Уулзалтын бичлэг хийсний дараа өөр уулзалт байхгүй бол "Зөвхөн бичлэг" сонголтыг сонгоно.';
$string['mod_form_field_intro'] = 'Тайлбар';
$string['mod_form_field_intro_help'] = 'Өрөөний товч тайлбар';
$string['mod_form_field_mustapproveuser'] = 'Зохицуулагчийн зөвшөөрлөөр зочин нэгдэнэ';
$string['mod_form_field_muteonstart'] = 'Эхлэхэд дууг хаах';
$string['mod_form_field_name'] = 'Өрөөний нэр';
$string['mod_form_field_nosettings'] = 'Засварлах боломжтой тохиргоо байхгүй байна';
$string['mod_form_field_openingtime'] = 'Нээх';
$string['mod_form_field_participant_add'] = 'Төлөөлөгч нэмэх';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Зохицуулагч';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Үзэгч';
$string['mod_form_field_participant_list'] = 'Төлөөлөгч';
$string['mod_form_field_participant_list_action_add'] = 'Нэмэх';
$string['mod_form_field_participant_list_action_remove'] = 'Хасах';
$string['mod_form_field_participant_list_text_as'] = 'уулзалтад нэгдэх үүрэг:';
$string['mod_form_field_participant_list_type_all'] = 'Бүх хэрэглэгч элссэн';
$string['mod_form_field_participant_list_type_owner'] = 'Эзэмшигч';
$string['mod_form_field_participant_list_type_role'] = 'Үүрэг';
$string['mod_form_field_participant_list_type_user'] = 'Хэрэглэгч';
$string['mod_form_field_record'] = 'Уулзалтын бичлэгийг хийх боломжтой.';
$string['mod_form_field_recordallfromstart'] = 'Эхнээс нь бүгдийг бичих';
$string['mod_form_field_recordhidebutton'] = 'Бичлэг хийх товчлуурыг нуух';
$string['mod_form_field_recordings_deleted'] = 'Устгасан үйл ажиллагааны бичлэг оруулах';
$string['mod_form_field_recordings_html'] = 'Хүснэгтийг энгийн HTML хэлбэрээр харуулах';
$string['mod_form_field_recordings_imported'] = 'Зөвхөн импортолсон холбоос харуулах';
$string['mod_form_field_recordings_preview'] = 'Бичлэгийг урьдчилан харах талбарыг харуулах';
$string['mod_form_field_room_name'] = 'Өрөөний нэр';
$string['mod_form_field_userlimit'] = 'Хэрэглэгчийн хязгаар';
$string['mod_form_field_userlimit_help'] = 'Уулзалтад оролцох боломжтой хэрэглэгчийн хамгийн их тоо. Хэрэглэгчийн тоог хязгаарлахгүй бол 0 гэж онооно.';
$string['mod_form_field_voicebridge'] = 'Дуут гүүр [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Форматын алдаа. Та 1-ээс 9999-ийн хооронд тоо оруулах ёстой.';
$string['mod_form_field_voicebridge_help'] = 'Оролцогчид залгах үед ээ дуут уулзалтад нэгдэхийн тулд оруулдаг 1-ээс 9999-ийн хоорондох тоо.  Хэрэв утга нь 0 бол статик дуут гүүрний дугаарыг харгалзалгүй BigBlueButton үйлчилгээ нь санамсаргүй тоо үүсгэнэ. Бичсэн дөрвөн цифрийн угтвар нь 7 болно.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Давхцахгүй утга байх ёстой. Энэ тоог өөр өрөөнд ашиглаж байна.';
$string['mod_form_field_wait'] = 'Зохицуулагчийг хүлээнэ үү';
$string['mod_form_field_wait_help'] = 'Оролцогчид өрөөнд орохын өмнө зохицуулагчийг хүлээх шаардлагатай юу?';
$string['mod_form_field_welcome'] = 'Угтах зурвас';
$string['mod_form_field_welcome_default'] = '%%CONFNAME%%-д тавтай морилно уу.';
$string['mod_form_field_welcome_help'] = 'Оролцогч өрөөнд ороход угтах зурвас гарч ирнэ. Хэрэв талбарыг хоосон орхивол веб хуудасны удирдлагад тохируулсан өгөгдмөл мессеж гарч ирнэ.';
$string['mod_form_locksettings'] = 'Түгжих тохиргоо';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButton нь цахим сургалтад зориулсан нээлттэй-эхийн веб хурлын систем юм. Энэ нь аудио, видеог бодит-цагт хуваалцах, чат бичих, үзүүлэн болон дэлгэц хуваалцах, олон-хэрэглэгч дундаа ашиглах самбар, завсарлагааны өрөө, санал асуулга болон эможиг дэмждэг.

BigBlueButton системийг ашиглан шууд онлайн хичээл явуулах, виртуал оффисын цаг буюу алслагдсан оюутнуудтай хамтран ажиллах бүлэг гэх мэт уулзалт үүсгэж болно. Уулзалтыг дараа дахин тоглуулахаар бичлэг хийх боломжтой.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButton';
$string['new_bigblubuttonbn_activities'] = 'BigBlueButton үйл ажиллагаа';
$string['nosuchinstance'] = '{$a->id} дугаартай {$a->entity} тохиолдол байхгүй байна';
$string['notification_instance_created_intro'] = '<a href="{$a->link}">{$a->name}</a> BigBlueButton өрөө үүслээ.';
$string['notification_instance_created_small'] = '{$a->name} нэртэй шинэ BigBlueButton өрөө үүслээ.';
$string['notification_instance_created_subject'] = 'Шинэ BigBlueButton өрөө үүслээ.';
$string['notification_instance_description'] = 'Тайлбар';
$string['notification_instance_end_date'] = 'Дуусах огноо';
$string['notification_instance_name'] = 'Гарчиг';
$string['notification_instance_start_date'] = 'Эхлэх огноо';
$string['notification_instance_updated_intro'] = '<a href="{$a->link}">{$a->name}</a> BigBlueButton өрөөг шинэчилсэн.';
$string['notification_instance_updated_small'] = '{$a->name} BigBlueButton уулзалтыг шинэчилсэн.';
$string['notification_instance_updated_subject'] = 'Таны BigBlueButton өрөөг шинэчилсэн';
$string['notification_recording_ready_html'] = '<a href="{$a->link}">{$a->name}</a>. BigBlueButton өрөөний уулзалтын бичлэг бэлэн байна.';
$string['notification_recording_ready_plain'] = '{$a->name} BigBlueButton өрөөний уулзалтын бичлэг бэлэн байна. Бичлэгт хандахын тулд {$a->link} холбоосоор зочилно уу.';
$string['notification_recording_ready_small'] = '{$a->name} BigBlueButton өрөөний бичлэг бэлэн байна.';
$string['notification_recording_ready_subject'] = 'Бичлэг хийх боломжтой';
$string['pluginadministration'] = 'BigBlueButton удирдлага';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'BigBlueButton уулзалт үүсгэх болон нэгдэхийн тулд хэрэглэгчийн өгөгдлийг сервертэй солилцох шаардлагатай.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'BigBlueButton серверт хандаж буй хэрэглэгчийн бүтэн нэр.';
$string['privacy:metadata:bigbluebutton:userid'] = 'BigBlueButton серверт хандаж буй хэрэглэгчийн ID.';
$string['privacy:metadata:bigbluebuttonbn'] = 'BigBlueButton уулзалтын тохиргоо';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'BigBlueButton уулзалт дах хэрэглэгчийн үүргийг тодорхойлох дүрмүүд. Хэрэглэгч тус бүрд эсвэл үүрэг бүрээр эрхийг оноож өгөх тул хэрэглэгчийн ID-г хадгална.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Нэмэлт хэрэгсэл ашиглахад үүссэн арга хэмжээг хадгалдаг.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Хэрэглэгчийн үүсгэсэн арга хэмжээний төрөл';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'Хэрэглэгч хандах эрхтэй уулзалтын ID';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Уулзалт болон бичлэгтэй холбоотой нэмэлт мэдээлэл.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Лог бүртгэл үүссэн цаг.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'Арга хэмжээг үүсгэсэн хэрэглэгчийн ID';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'Бичлэгийн тухай мета өгөгдлийг хадгалах';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'Бичлэгийг хамгийн сүүлд өөрчилсөн хэрэглэгчийн ID.';
$string['progress_createbigbluebuttonbn'] = 'BigBlueButton ({$a}) үйл ажиллагааг үүсгэж байна';
$string['recordings_from_deleted_activities'] = 'Устгасан үйл ажиллагааны бичлэгүүд';
$string['recordingurlnotfound'] = 'Бичлэгийн URL буруу байна.';
$string['removedevents'] = 'Устгасан арга хэмжээ';
$string['removedlogs'] = 'Тусгай лог бичлэгүүдийг устгасан';
$string['removedrecordings'] = 'Устгасан бичлэг';
$string['removedtags'] = 'Устгасан таг';
$string['report_join_info'] = '{$a} зөвлөгөөн';
$string['report_play_recording_info'] = '{$a} бичлэгийг тоглуулсан';
$string['report_room_view'] = 'үзсэн';
$string['resetevents'] = 'Устгасан арга хэмжээ';
$string['resetlogs'] = 'Тусгай лог бичлэгүүдийг устгах';
$string['resetlogs_help'] = 'Лог бүртгэлийг устгаснаар бичлэгийн лавлагаа алдагдах болно.';
$string['resetrecordings'] = 'Бичлэгийг устгах';
$string['resetrecordings_help'] = 'Бичлэгийг устгаснаар хандах боломжгүй болно. Энэ үйлдлийг буцаах боломжгүй!';
$string['resettags'] = 'Таг устгах';
$string['search:activity'] = 'BigBlueButton - үйл ажиллагааны мэдээлэл';
$string['search:tags'] = 'BigBlueButton - тагийн мэдээлэл';
$string['sendnotification'] = 'Мэдэгдэл илгээх';
$string['settings'] = 'BigBlueButton тохиргоо';
$string['started_at'] = 'Эхэлсэн';
$string['starts_at'] = 'Эхлэх';
$string['taskname:check_dismissed_recordings'] = 'Хараахан олдоогүй бичлэг байгаа эсэхийг шалгана уу';
$string['taskname:check_pending_recordings'] = 'Хүлээгдэж буй бичлэгийг авч ирэх';
$string['userlimitreached'] = 'Уулзалтад зөвшөөрөгдсөн хэрэглэгчийн тоо гүйцсэн байна.';
$string['view_conference_action_end'] = 'Уулзалт дуусгах';
$string['view_conference_action_join'] = 'Уулзалтад нэгдэх';
$string['view_error_action_not_completed'] = 'Үйлдлийг дуусгаж чадсангүй';
$string['view_error_bigbluebutton'] = 'BigBlueButton алдаа гарлаа. {$a}';
$string['view_error_create'] = 'BigBlueButton сервер алдааны зурвас өгсөн. Өрөө үүсгэх боломжгүй байна.';
$string['view_error_current_state_not_found'] = 'Одоогийн төлөв олдсонгүй. Бичлэг устсан эсвэл BigBlueButton сервер нь гүйцэтгэсэн үйлдэлтэй тохирохгүй байна.';
$string['view_error_import_no_courses'] = 'Бичлэгийг хайх хичээл байхгүй байна.';
$string['view_error_import_no_recordings'] = 'Тус хичээлд импортлох бичлэг байхгүй байна.';
$string['view_error_invalid_session'] = 'Уулзалтын хугацаа дууссан байна. Үйл ажиллагааны хуудас руу буцна уу.';
$string['view_error_max_concurrent'] = 'Зэрэг явуулж болох уулзалтын тоо гүйцсэн байна.';
$string['view_error_meeting_not_running'] = 'Зарим зүйл буруу байна: уулзалт хийж болохгүй байна.';
$string['view_error_no_group'] = 'Ямар ч бүлэг байхгүй байна. Та хичээлд нэгдэхийн тулд эхлээд бүлэг үүсгэх хэрэгтэй.';
$string['view_error_no_group_student'] = 'Таныг бүлэгт нэмээгүй байгаа тул багштайгаа холбогдоно уу.';
$string['view_error_no_group_teacher'] = 'Ямар нэгэн бүлэг байхгүй байна. Та бүлэг үүсгэх хэрэгтэй.';
$string['view_error_unable_join'] = 'Өрөөнд орох боломжгүй байна. BigBlueButton серверийн URL замыг шалгаад, мөн BigBlueButton сервер ажиллаж байгаа эсэхийг шалгана уу.';
$string['view_error_unable_join_student'] = 'BigBlueButton сервертэй холбогдох боломжгүй байна.';
$string['view_error_unable_join_teacher'] = 'BigBlueButton сервертэй холбогдох боломжгүй байна. Администратортай холбогдоно уу.';
$string['view_error_url_missing_parameters'] = 'Энэ URL замын параметр дутуу байна';
$string['view_error_userlimit_reached'] = 'Уулзалтад оролцохыг зөвшөөрөгдсөн хэрэглэгчийн тоо гүйцсэн байна.';
$string['view_groups_nogroups_warning'] = 'Энэ өрөөг бүлгийг ашиглахад зориулан тохируулсан боловч хичээлд бүлгийг тодорхойлж өгөөгүй байна.';
$string['view_groups_notenrolled_warning'] = 'Энэ өрөөг бүлгийг ашиглахад зориулан тохируулсан боловч та бүлгийн гишүүн биш байна.';
$string['view_groups_selection'] = 'Нэгдэхийг хүсэж буй бүлэг ээ сонгоод үйлдлийг баталгаажуулна уу';
$string['view_groups_selection_join'] = 'Нэгдэх';
$string['view_groups_selection_warning'] = 'Бүлэг тус бүр өрөөтэй бөгөөд та нэгээс олон өрөөнд хандах боломжтой. Зөв өрөө сонгохоо мартуузай.';
$string['view_login_moderator'] = 'Зохицуулагчаар нэвтэрч байна ...';
$string['view_login_viewer'] = 'Үзэгчээр нэвтэрч байна ...';
$string['view_message_and'] = 'бас';
$string['view_message_conference_has_ended'] = 'Уулзалт дууссан байна.';
$string['view_message_conference_in_progress'] = 'Уулзалт явагдаж байна.';
$string['view_message_conference_not_started'] = 'Уулзалт хараахан эхлээгүй байна.';
$string['view_message_conference_room_ready'] = 'Өрөө бэлэн болсон тул та одоо уулзалтад нэгдэх боломжтой.';
$string['view_message_conference_user_limit_reached'] = 'Уулзалтад орох боломжтой хэрэглэгчийн тоо гүйцсэн байна.';
$string['view_message_conference_wait_for_moderator'] = 'Зохицуулагчийг нэгдэхийг хүлээж байна.';
$string['view_message_cron_disabled'] = 'Бичлэгийн жагсаалтыг шинэчлээгүй байх магадлалтай тул дараах мэдээллээр веб сайтын администратортой холбогдоно уу: {$a}';
$string['view_message_finished'] = 'Энэ үйл ажиллагаа дууссан байна';
$string['view_message_has_joined'] = 'нэгдсэн';
$string['view_message_have_joined'] = 'нэгдсэн';
$string['view_message_hour'] = 'цаг';
$string['view_message_hours'] = 'цаг';
$string['view_message_importrecordings_disabled'] = 'Серверт бичлэгийн холбоосыг импорт хийхийг идэвхгүй болгосон байна.';
$string['view_message_minute'] = 'минут';
$string['view_message_minutes'] = 'минут';
$string['view_message_moderator'] = 'Зохицуулагч';
$string['view_message_moderators'] = 'Зохицуулагчид';
$string['view_message_norecordings'] = 'Ямар нэгэн бичлэг байхгүй байна.';
$string['view_message_notavailableyet'] = 'Энэ уулзалт хараахан бэлэн болоогүй байна.';
$string['view_message_recordings_disabled'] = 'Бичлэгийг сервер дээр идэвхгүй болгосон байна. \'Зөвхөн бичлэг\' төрлийн BigBlueButton үйл ажиллагааг ашиглах боломжгүй.';
$string['view_message_room_closed'] = 'Энэ өрөө хаалттай байна.';
$string['view_message_room_open'] = 'Энэ өрөө нээлттэй байна.';
$string['view_message_room_ready'] = 'Энэ өрөө бэлэн байна.';
$string['view_message_session_for'] = 'уулзалт:';
$string['view_message_session_has_user'] = 'Энд:';
$string['view_message_session_has_users'] = 'Энд:';
$string['view_message_session_no_users'] = 'Энэ уулзалтад хэрэглэгч байхгүй байна';
$string['view_message_session_running_for'] = 'Уулзалт үргэлжилж байна';
$string['view_message_session_started_at'] = 'Уулзалт эхэлсэн:';
$string['view_message_tab_close'] = 'Энэ таб/цонхыг гараар хаах ёстой';
$string['view_message_times'] = 'удаа';
$string['view_message_user'] = 'Хэрэглэгч';
$string['view_message_users'] = 'Хэрэглэгчид';
$string['view_message_viewer'] = 'Үзэгч';
$string['view_message_viewers'] = 'Үзэгчид';
$string['view_mobile_message_groups_not_supported'] = 'Энэ тохиолдлыг бүлгүүдтэй ажиллахад идэвхжүүлсэн боловч мобайл хувилбар үүнийг хараахан дэмжихгүй байна. Та веб хувилбарыг ашиглана уу.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Та энэ хуудсан дээр 45 секундээс удаан байсан байна. Хуралд нэгдэхийн тулд хуудсыг дахин сэргээнэ үү.';
$string['view_noguests'] = 'BigBlueButton өрөө нь зочидод нээлттэй биш байна.';
$string['view_nojoin'] = 'Та энэ уулзалтад нэгдэхийг зөвшөөрсөн үүрэг хүлээгээгүй байна.';
$string['view_recording'] = 'бичлэг хийх';
$string['view_recording_actionbar'] = 'Хэрэгслийн мөр';
$string['view_recording_activity'] = 'Үйл ажиллагаа';
$string['view_recording_button_import'] = 'Бичлэг хийх холбоосыг импортлох';
$string['view_recording_button_return'] = 'Буцах';
$string['view_recording_course'] = 'Хичээл';
$string['view_recording_date'] = 'Огноо';
$string['view_recording_delete_confirmation'] = 'Та {$a} бичлэгийг устгахдаа итгэлтэй байна уу?';
$string['view_recording_delete_confirmation_warning_p'] = 'Энэ бичлэгийн {$a} холбоос нь өөр хичээл эсвэл үйл ажиллагаанд импортлогдсон байна. Хэрэв бичлэгийг устгавал эдгээр холбоос мөн устах болно.';
$string['view_recording_delete_confirmation_warning_s'] = 'Энэ бичлэгийн {$a} холбоос нь өөр хичээл эсвэл үйл ажиллагаанд импортлогдсон байна. Хэрэв бичлэгийг устгавал тус холбоос мөн устах болно.';
$string['view_recording_description'] = 'Тайлбар';
$string['view_recording_description_edithint'] = 'Бичлэгийг бусдаас ялгахад туслах тайлбарыг нэмж болно.';
$string['view_recording_description_editlabel'] = 'Тайлбарыг засварлах';
$string['view_recording_duration'] = 'Үргэлжлэх хугацаа';
$string['view_recording_duration_min'] = 'мин';
$string['view_recording_format_errror_unreachable'] = 'Энэ бичлэгийн форматын URL-д хүрэх боломжгүй байна.';
$string['view_recording_format_notes'] = 'Тэмдэглэл';
$string['view_recording_format_podcast'] = 'Подкаст';
$string['view_recording_format_presentation'] = 'Үзүүлэн';
$string['view_recording_format_screenshare'] = 'Дэлгэц хуваалцах';
$string['view_recording_format_statistics'] = 'Статистик';
$string['view_recording_format_video'] = 'Видео';
$string['view_recording_import_confirmation'] = 'Бичлэгийг импортлохыг хүсэж байна уу?';
$string['view_recording_length'] = 'Урт';
$string['view_recording_link_warning'] = 'Энэ нь өөр курс эсвэл үйл ажиллагаанд үүсгэсэн бичлэгийн холбоос юм.';
$string['view_recording_list_action_delete'] = 'Устгаж байна';
$string['view_recording_list_action_edit'] = 'Шинэчилж байна';
$string['view_recording_list_action_play'] = 'Тоглуулах';
$string['view_recording_list_action_process'] = 'Боловсруулж байна';
$string['view_recording_list_action_protect'] = 'Хамгаалж байна';
$string['view_recording_list_action_publish'] = 'Нийтэлж байна';
$string['view_recording_list_action_unprotect'] = 'Хамгаалалтыг цуцалж байна';
$string['view_recording_list_action_unpublish'] = 'Нийтэлснийг цуцалж байна';
$string['view_recording_list_action_update'] = 'Шинэчилж байна';
$string['view_recording_list_actionbar'] = 'Хэрэгслийн мөр';
$string['view_recording_list_actionbar_delete'] = 'Устгах';
$string['view_recording_list_actionbar_edit'] = 'Засварлах';
$string['view_recording_list_actionbar_hide'] = 'Нуух';
$string['view_recording_list_actionbar_import'] = 'Импортлох';
$string['view_recording_list_actionbar_protect'] = 'Үүнийг хувийн болгох';
$string['view_recording_list_actionbar_publish'] = 'Нийтлэх';
$string['view_recording_list_actionbar_show'] = 'Харуулах';
$string['view_recording_list_actionbar_unprotect'] = 'Үүнийг нийтийн болгох';
$string['view_recording_list_actionbar_unpublish'] = 'Нийтэлснийг цуцлах';
$string['view_recording_list_activity'] = 'Үйл ажиллагаа';
$string['view_recording_list_course'] = 'Хичээл';
$string['view_recording_list_date'] = 'Огноо';
$string['view_recording_list_description'] = 'Тайлбар';
$string['view_recording_list_duration'] = 'Үргэлжлэх хугацаа';
$string['view_recording_list_recording'] = 'Бичлэг хийх';
$string['view_recording_meeting'] = 'Зөвлөгөөн';
$string['view_recording_modal_button'] = 'Хэрэглэх';
$string['view_recording_modal_title'] = 'Бичлэг хийх утгыг тохируулах';
$string['view_recording_name'] = 'Нэр';
$string['view_recording_name_edithint'] = 'Бичлэгийг танихад туслах нэр өгч болно.';
$string['view_recording_name_editlabel'] = 'Нэрийг засварлах';
$string['view_recording_playback'] = 'Дахин тоглуулах';
$string['view_recording_preview'] = 'Урьдчилан харах';
$string['view_recording_preview_help'] = 'Зургийг бүтэн хэмжээгээг харахын тулд хулганыг дээгүүр нь гүйлгэ';
$string['view_recording_protect_confirmation'] = '{$a} бичлэгийг хамгаалахыг хүсэж байна уу?';
$string['view_recording_protect_confirmation_warning_p'] = 'Бичлэгийн {$a} холбоосыг өөр үйл ажиллагаа эсвэл хичээлд импортолсон байна. Хэрэв бичлэгийг хамгаалбал энэ нь импортолсон холбоост мөн нөлөөлнө.';
$string['view_recording_protect_confirmation_warning_s'] = 'Бичлэгийн {$a} холбоосыг өөр үйл ажиллагаа эсвэл хичээлд импортолсон байна. Хэрэв бичлэгийг хамгаалбал энэ нь импортолсон холбоост мөн нөлөөлнө.';
$string['view_recording_publish_confirmation'] = '{$a} бичлэгийг нийтлэхийг хүсэж байна уу?';
$string['view_recording_publish_confirmation_warning_p'] = 'Бичлэгийн {$a} холбоосыг өөр үйл ажиллагаа эсвэл хичээлд импортолсон байна. Хэрэв бичлэгийг нийтэлбэл эдгээр холбоос мөн нийтлэгдэнэ.';
$string['view_recording_publish_confirmation_warning_s'] = 'Бичлэгийн {$a} холбоосыг өөр үйл ажиллагаа эсвэл хичээлд импортолсон байна. Хэрэв бичлэгийг нийтэлбэл энэ холбоос мөн нийтлэгдэнэ.';
$string['view_recording_publish_link_deleted'] = 'Анхны бичлэг нь BigBlueButton сервер дээр байхгүй тул энэ холбоосыг дахин нийтлэх боломжгүй. Тиймээс энэ холбоосыг устгах хэрэгтэй.';
$string['view_recording_publish_link_not_published'] = 'Анхны бичлэгийн нийтэлснийг цуцалсан тул энэ холбоосыг дахин нийтлэх боломжгүй.';
$string['view_recording_recording'] = 'Бичлэг хийх';
$string['view_recording_select_course'] = 'Задрах цэсээс эхлээд хичээлийг сонгоно уу';
$string['view_recording_tags'] = 'Шошгонууд';
$string['view_recording_unprotect_confirmation'] = '{$a} бичлэгийн хамгаалалтыг цуцлахыг хүсэж байна уу?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'Бичлэгийн {$a} холбоосыг өөр хичээл эсвэл үйл ажиллагаанд импортолсон байна. Хэрвээ бичлэгийн хамгаалалтыг цуцалбал энэ нь импортолсон холбоост нөлөөлнө.';
$string['view_recording_unprotect_confirmation_warning_s'] = 'Бичлэгийн {$a} холбоосыг өөр хичээл эсвэл үйл ажиллагаанд импортолсон байна. Хэрвээ бичлэгийн хамгаалалтыг цуцалбал энэ нь импортолсон холбоост нөлөөлнө.';
$string['view_recording_unprotect_link_deleted'] = 'Анхны бичлэг нь BigBlueButton серверт байхгүй тул энэ холбоосны хамгаалалтыг цуцлах боломжгүй. Тиймээс холбоосыг устгах хэрэгтэй.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Анхны бичлэг нь хамгаалагдсан тул энэ холбоосны хамгаалалтыг цуцлах боломжгүй.';
$string['view_recording_unpublish_confirmation'] = '{$a} бичлэг нийтэлснээ цуцлахыг хүсэж байна уу?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Бичлэгийн {$a} холбоосыг өөр хичээл эсвэл үйл ажиллагаанд импортолсон байна. Хэрвээ бичлэгийг нийтэлснээ цуцалбал эдгээр холбоосны нийтлэл мөн цуцлагдана.';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Бичлэгийн {$a} холбоосыг өөр хичээл эсвэл үйл ажиллагаанд импортолсон байна. Хэрвээ бичлэгийг нийтэлснээ цуцалбал энэ холбоосны нийтлэл мөн цуцлагдана.';
$string['view_recording_yui_first'] = 'Эхнийх';
$string['view_recording_yui_go'] = 'Явах';
$string['view_recording_yui_last'] = 'Сүүлчийнх';
$string['view_recording_yui_next'] = 'Дараах';
$string['view_recording_yui_page'] = 'Хуудас';
$string['view_recording_yui_prev'] = 'Өмнөх';
$string['view_recording_yui_rows'] = 'Мөр';
$string['view_recording_yui_show_all'] = 'Бүгдийг харуулах';
$string['view_room'] = 'Өрөө харах';
$string['view_section_title_presentation'] = 'Үзүүлэнгийн файл';
$string['view_section_title_recordings'] = 'Бичлэг';
$string['waitformoderator'] = 'Зохицуулагчийг нэгдэхийг хүлээж байна.';
