<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'it', version '5.1'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.block_myoverview.browseallcourses'] = 'Sfoglia tutti i corsi';
$string['addon.block_myoverview.nocoursesenrolleddescription'] = 'Sfoglia tutti i corsi disponibili qui sotto e inizia a imparare.';
$string['addon.block_myoverview.noresult'] = 'La tua ricerca non ha trovato corsi corrispondenti.';
$string['addon.block_myoverview.noresultdescription'] = 'Prova a modificare i filtri o sfoglia tutti i corsi qui sotto.';
$string['addon.blog.errorloadentries'] = 'Si è verificato un errore durante il caricamento del blog.';
$string['addon.blog.showonlyyourentries'] = 'Visualizza solo i tuoi inserimenti';
$string['addon.calendar.calendarevent'] = 'Eventi del calendario';
$string['addon.calendar.calendarevents'] = 'Eventi del calendario';
$string['addon.calendar.calendarreminders'] = 'Promemoria del calendario';
$string['addon.calendar.currentmonth'] = 'Mese corrente';
$string['addon.calendar.defaultnotificationtime'] = 'Orario di notifica di default';
$string['addon.calendar.errorloadevent'] = 'Si è verificato un errore durante il caricamento degli eventi.';
$string['addon.calendar.errorloadevents'] = 'Si è verificato un errore durante il caricamento degli eventi.';
$string['addon.calendar.monthlyview'] = 'Vista mensile';
$string['addon.calendar.noevents'] = 'Non ci sono eventi';
$string['addon.calendar.reminders'] = 'Promemoria';
$string['addon.calendar.setnewreminder'] = 'Imposta un nuovo promemoria';
$string['addon.competency.errornocompetenciesfound'] = 'Non sono state trovate competenze';
$string['addon.competency.nocompetencies'] = 'Non sono presenti competenze';
$string['addon.coursecompletion.complete'] = 'Completato';
$string['addon.coursecompletion.couldnotloadreport'] = 'Non è stato possibile caricare il report di completamento del corso, per favore riprova più tardi.';
$string['addon.enrol_self.confirmselfenrol'] = 'Sei sicuro di voler iscriverti a questo corso?';
$string['addon.enrol_self.errorselfenrol'] = 'Si è verificato un errore durante l\'iscrizione autonoma.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Configura dsipositivi';
$string['addon.messageoutput_airnotifier.pushdisabledwarning'] = 'I tuoi utenti non ricevono notifiche da questo sito sui loro dispositivi mobili. Abilita le notifiche mobili nella pagina Impostazioni notifiche.';
$string['addon.messages.contactlistempty'] = 'L\'elenco dei contatti è vuoto';
$string['addon.messages.contactname'] = 'Nome del contatto';
$string['addon.messages.deletemessage'] = 'Elimina messaggio';
$string['addon.messages.deletemessageconfirmation'] = 'Sei sicuro di eliminare il messaggio? Verrà eliminato soltanto dalla tua conversazione, ma sarà ancora visibile dall\'utente che ha ricevuto o inviato il messaggio.';
$string['addon.messages.errordeletemessage'] = 'Si è verificato un errore durante l\'eliminazione del messaggio.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Si è verificato un errore durante la ricezione dei contatti dal server.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Si è verificato un errore durante la ricezione delle discussioni dal server.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Si è verificato un errore durante la ricezione dei messaggi dal server.';
$string['addon.messages.errorwhileretrievingusers'] = 'Si è verificato un errore durante il caricamento degli utenti dal server.';
$string['addon.messages.messagenotsent'] = 'Il messaggio non è stato inviato, per favore riprova più tardi.';
$string['addon.messages.newmessages'] = 'Nuovi messaggi';
$string['addon.messages.nousersfound'] = 'Non sono stati trovati utenti';
$string['addon.messages.showdeletemessages'] = 'Visualizza messaggi eliminati';
$string['addon.messages.type_blocked'] = 'Bloccato';
$string['addon.messages.type_offline'] = 'Offline';
$string['addon.messages.type_online'] = 'Online';
$string['addon.messages.type_search'] = 'Risultati della ricerca';
$string['addon.messages.type_strangers'] = 'Altri';
$string['addon.messages.useentertosenddescdesktop'] = 'Se disabilitato, è possibile utilizzare Ctrl+Invio per inviare il messaggio.';
$string['addon.messages.useentertosenddescmac'] = 'Se disabilitato, è possibile utilizzare Cmd+Invio per inviare il messaggio.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Non è stato possibile aggiungere messaggi alla conversazione {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Non è stato possibile inviare messaggi all\'utente {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Accetta la dichiarazione di invio.';
$string['addon.mod_assign.allowsubmissionsanddescriptionfromdatesummary'] = 'I dettagli del compito e il modulo di invio saranno disponibili da <strong>{{$a}}</strong>';
$string['addon.mod_assign.allowsubmissionsfromdatesummary'] = 'Questo compito accetterà invii a partire dal <strong>{{$a}}</strong>';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Non puoi aggiungere o modificare un invio nell\'app perché non è stato possibile recuperare la dichiarazione di invio dal sito.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Alcuni metodi di valutazione non sono ancora supportati dall\'app e non possono essere modificati.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Non puoi inviare un compito nell\'app perché non è stato possibile recuperare la dichiarazione di invio dal sito.';
$string['addon.mod_assign.duedateno'] = 'Nessuna scadenza';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Non puoi aggiungere o modificare un invio nell\'app perché alcuni plugin non sono ancora supportati per la modifica.';
$string['addon.mod_assign.errorshowinginformation'] = 'Impossibile visualizzare le informazioni sull\'invio.';
$string['addon.mod_assign.feedbacknotsupported'] = 'Questo feedback non è supportato dalla app e può non contenere tutte le informazioni.';
$string['addon.mod_assign.gradenotsynced'] = 'Valutazione non sincronizzata';
$string['addon.mod_assign.notallparticipantsareshown'] = 'I partecipanti che non hanno consegnato non sono visualizzati.';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'Ci sono {{count}} bozze.';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'Ci sono {{count}} partecipanti.';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'Ci sono {{count}} consegne che richiedono la valutazione.';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'Ci sono {{count}} compiti consegnati.';
$string['addon.mod_assign.numberofteamscountdescription'] = 'Ci sono {{count}} team.';
$string['addon.mod_assign.submissionnotsupported'] = 'Questa consegna non è supportata dalla app e può non contenere tutte le informazioni.';
$string['addon.mod_assign.syncblockedusercomponent'] = 'valutazione utente';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'La valutazione dell\'utente è stata modificata sul sito.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'La consegna dell\'utente è stata modificata sul sito.';
$string['addon.mod_chat.confirmloss'] = 'Sei sicuro? La cronologia della chat potrebbe andare persa.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Si è verificato un errore durante il collegamento alla chat.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Si è verificato un errore durante la ricezione dei dati della chat.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Si è verificato un errore durante la ricezione degli utenti della chat.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Si è verificato un errore durante la ricezione dei messaggi dal server.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Si è verificato un errore durante l\'invio del messaggio.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Per inviare messaggi devi essere online.';
$string['addon.mod_chat.nosessionsfound'] = 'Non è stata trovata nessuna sezione';
$string['addon.mod_chat.showincompletesessions'] = 'Visualizza sessioni non completate';
$string['addon.mod_choice.errorgetchoice'] = 'Si è verificato un errore durante la ricezione di dati della scelta.';
$string['addon.mod_choice.responsesresultgraphdescription'] = 'Il {{number}}% ha scelto l\'opzione {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'La tua ultima risposta deve essere sincronizzata prima di poter essere inclusa nei risultati.';
$string['addon.mod_data.edittagsnotsupported'] = 'L\'app non supporta la modifica di tag';
$string['addon.mod_data.errorapproving'] = 'Si è verificato un errore durante l\'approvazione o disapprovazione del record.';
$string['addon.mod_data.errordeleting'] = 'Si è verificato un errore durante l\'eliminazione del record.';
$string['addon.mod_data.locationpermissiondenied'] = 'L\'accesso alla tua posizione è stato negato.';
$string['addon.mod_data.mylocation'] = 'La mia posizione';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Spiacente, la ricerca per tag non è supportata dall\'app.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'I feedback con CAPTCHA non possono essere completati offline, o se non configurati, o se il server è inattivo.';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = 'Sono state inviate {{count}} risposte.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Il feedback è stato salvato e sarà inviato più tardi.';
$string['addon.mod_feedback.questionscountdescription'] = 'Ci sono {{count}} domande.';
$string['addon.mod_folder.emptyfilelist'] = 'Non ci sono file da visualizzare.';
$string['addon.mod_forum.errorgetforum'] = 'Si è verificato un errore durante la ricezione dei dati del forum.';
$string['addon.mod_forum.errorgetgroups'] = 'Si è verificato un errore durante la ricezione delle impostazioni gruppo.';
$string['addon.mod_forum.errorloadingsortingorder'] = 'Forum non disponibile in questo ordine di visualizzazione';
$string['addon.mod_forum.errorloadingsortingorderdetails'] = 'Prova a cambiare l\'ordine di visualizzazione o collegati a Internet per visualizzare questo forum.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Non è stato possibile creare la discussione in tutti i gruppi.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'In questo forum non sono presenti discussioni.';
$string['addon.mod_forum.group'] = 'Gruppo';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} discussioni';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} interventi';
$string['addon.mod_forum.postingroup'] = 'Post nel gruppo "{{groupname}}".';
$string['addon.mod_forum.refreshposts'] = 'Aggiorna interventi';
$string['addon.mod_glossary.browsemode'] = 'Sfoglia voci';
$string['addon.mod_glossary.byalphabet'] = 'In ordine alfabetico';
$string['addon.mod_glossary.byauthor'] = 'Raggruppa per autore';
$string['addon.mod_glossary.bycategory'] = 'Raggruppa per categoria';
$string['addon.mod_glossary.bynewestfirst'] = 'Dalla più recente';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Aggiornati di recente';
$string['addon.mod_glossary.bysearch'] = 'Cerca';
$string['addon.mod_glossary.cannoteditentry'] = 'Non è possibile modificare la voce';
$string['addon.mod_glossary.entriestobesynced'] = 'Voci da sincronizzare';
$string['addon.mod_glossary.entrypendingapproval'] = 'Questa voce è in attesa di approvazione.';
$string['addon.mod_glossary.errordeleting'] = 'Errore durante l\'eliminazione della voce.';
$string['addon.mod_glossary.errorloadingentries'] = 'Si è verificato un errore durante il caricamento delle voci.';
$string['addon.mod_glossary.errorloadingentry'] = 'Si è verificato un errore durante il caricamento della voce.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Si è verificato un errore durante il caricamento del glossario.';
$string['addon.mod_glossary.noentriesfound'] = 'Non sono state trovate voci.';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Scarica file H5P';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Si è verificato un errore durante lo scaricamento dei dati dell\'attività H5P';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'Il pacchetto H5P non è stato scaricato. Per utilizzarlo è necessario scaricarlo.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'Il pacchetto H5P è stato modificato dopo l\'ultimo scaricamento. Per utilizzarlo è necessario scaricarlo nuovamente.';
$string['addon.mod_h5pactivity.numberofattempts'] = '{{$a}} tentativi';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'E\' necessario essere online per visualizzare il pacchetto H5P.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Visualizza tentativo {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Visualizza descrizione';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Questa lezione contiene un salto a una pagina di contenuto casuale. Non può essere eseguita nell\'app finché non è stata avviata in un browser web.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Questo tentativo non può più essere revisionato perché un altro tentativo è stato completato.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Il tentativo è stato completato offline.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'E\' stato sincronizzato un tentativo offline. Desideri rivederlo?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Il tentativo è stato completato sul sito.';
$string['addon.mod_lti.errorgetlti'] = 'Si è verificato un errore durante la ricezione dei dati del modulo.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'l\'URL di lancio non è valida.';
$string['addon.mod_lti.launchactivity'] = 'Lancia l\'attività';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Si è verificato un errore durante il caricamento della pagina.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Puoi tentare questo quiz nell\'app, ma dovrai inviare il tentativo nel browser per i seguenti motivi:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Questo tentativo di quiz non può essere inviato per i seguenti motivi:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Questo tentativo non è stato sincronizzato dal {{$a}}. Se hai continuato questo tentativo su un altro dispositivo, potresti perdere dei dati.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Si è verificato un errore durante il salvataggio delle domande. Sei sicuro di abbandonare il quiz?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Questo quiz non può essere eseguito nell\'app perché il comportamento delle domande non è supportato:';
$string['addon.mod_quiz.errordownloading'] = 'Si è verificato un errore durante lo scaricamento dei dati.';
$string['addon.mod_quiz.errorgetattempt'] = 'Si è verificato un errore durante la ricezione dei dati del tentativo.';
$string['addon.mod_quiz.errorgetquestions'] = 'Si è verificato un errore durante la ricezione delle domande.';
$string['addon.mod_quiz.errorgetquiz'] = 'Si è verificato un errore durante la ricezione dei dati del quiz.';
$string['addon.mod_quiz.errorparsequestions'] = 'Si è verificato un errore durante la lettura delle domande. Per favore svolgi il quiz usando un browser.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Questo quiz non può essere svolto nell\'app poiché contiene domande che non sono supportate nell\'app.';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Questo quiz non può essere eseguito nell\'app perché ci sono regole di accesso non supportate:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Si è verificato un errore durante il salvataggio del tentativo.';
$string['addon.mod_quiz.finishedofflinenotice'] = 'Il tuo tentativo è stato inviato e salvato. Verrà trasmesso al sito quando tornerai online.';
$string['addon.mod_quiz.finishnotsynced'] = 'Completato ma non sincronizzato.';
$string['addon.mod_quiz.opentoc'] = 'Apri navigazione';
$string['addon.mod_quiz.warningattemptfinished'] = 'Tentativo offline scartato perché completato sul sito o non trovato.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Alcune risposte offline sono state scartate perché le domande sono state modificate online.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Tentativo non completato perché alcune risposte offline sono state scartate. Controlla le tue risposte e invia nuovamente il tentativo.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Il quiz contiene domande non supportare dall\'app:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Si è verificato un errore durante il caricamento del contenuto.';
$string['addon.mod_resource.openthefile'] = 'Apri';
$string['addon.mod_resource.resourcestatusoutdated'] = 'Questo file è stato modificato dall\'ultima volta che lo hai aperto.';
$string['addon.mod_resource.resourcestatusoutdatedconfirm'] = 'Esiste una versione più recente di questo file. Per visualizzarla, collega il tuo dispositivo a Internet.';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Non è stato possibile calcolare le valutazioni.';
$string['addon.mod_scorm.dataattemptshown'] = 'Questi dati appartengono al tentativo numero {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Si è verificato un errore durante la creazione di un tentativo offline. Per favore riprova.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Si è verificato un errore durante lo scaricamento dello SCORM "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Si è verificato un errore durante la ricezione dei dati SCORM.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Spiacente, l\'applicazione supporta solamente SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Lo scaricamento di pacchetti SCORM è disabilitato. Per favore contatta l\'amministratore del sito.';
$string['addon.mod_scorm.errornovalidsco'] = 'Questo SCORM non ha SCO visibili da caricare.';
$string['addon.mod_scorm.errorpackagefile'] = 'Spiacente, l\'applicazione supporta solamente pacchetti ZIP.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Si è verificato un errore durante la sincronizzazione. Per favore riprova.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Questo tentativo ha dati non sincronizzati.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Questo tentativo non può essere inviato perché hai superato il numero massimo di tentativi.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Questo SCORM non è stato scaricato, lo sarà non appena lo aprirai.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Questo SCORM è stato modificato dall\'ultimo scaricamento e sarà scaricato nuovamente non appena lo aprirai.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Alcuni dati offline del tentativo {{number}} sono stati eliminati perché non è stato possibile inserirli in un nuovo tentativo.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Alcuni tentativi non sono stati sincronizzati sul sito poiché è presente un tentativo svolto online che non è stato terminato. Per sincronizzare, devi prima terminare il tentativo online.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Si è verificato un errore durante l\'invio del sondaggio. Per favore riprova.';
$string['addon.mod_survey.errorgetsurvey'] = 'Si è verificato un errore durante la ricezione di dati del sondaggio.';
$string['addon.mod_survey.results'] = 'Risultati';
$string['addon.mod_url.accessurl'] = 'Accedi all\'URL';
$string['addon.mod_url.pointingtourl'] = 'URL dove punta la risorsa.';
$string['addon.mod_wiki.errorloadingpage'] = 'Si è verificato un errore durante il caricamento della pagina.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Il wiki non ha contenuti.';
$string['addon.mod_wiki.gowikihome'] = 'Vai alla prima pagina del wiki';
$string['addon.mod_wiki.subwiki'] = 'Subwiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Il titolo non può essere vuoto';
$string['addon.mod_wiki.viewpage'] = 'Visualizza pagina';
$string['addon.mod_wiki.wikipage'] = 'Pagina wiki';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Strategia di valutazione {{$a}} non supportata';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Devi inserire un titolo.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'La consegna è stata modificata sul sito.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'La valutazione è stata modificata sul sito.';
$string['addon.notes.warningnotenotsent'] = 'Non è stato possibile aggiungere note al corso {{course}}. {{error}}';
$string['addon.notifications.allownotifications'] = 'Consenti notifiche';
$string['addon.notifications.errorgetnotifications'] = 'Si è verificato un errore durante la ricezione delle notifiche.';
$string['addon.notifications.notifications'] = 'Notifiche';
$string['addon.notifications.playsound'] = 'Riproduci suono';
$string['addon.notifications.therearentnotificationsyet'] = 'Non ci sono notifiche.';
$string['addon.notifications.typeofnotification'] = 'Tipo di notifica';
$string['addon.privatefiles.couldnotloadfiles'] = 'Impossibile caricare l\'elenco dei file.';
$string['addon.privatefiles.emptyfilelist'] = 'Non ci sono file da mostrare.';
$string['addon.privatefiles.erroruploadnotworking'] = 'Al momento non è possibile caricare file sul sito.';
$string['addon.storagemanager.confirmdeleteallsitedata'] = 'Eliminare tutti i dati scaricati dal sito?';
$string['addon.storagemanager.confirmdeletecourses'] = 'Eliminare i dati scaricati da tutti i corsi?';
$string['addon.storagemanager.confirmdeletedatafrom'] = 'Eliminare tutti i dati scaricati da "{{name}}"?';
$string['addon.storagemanager.coursedownloads'] = 'Download dei corsi';
$string['addon.storagemanager.courseinfo'] = 'Scarica il contenuto del corso per lavorare offline. Le tue attività si sincronizzeranno automaticamente quando il dispositivo tornerà online.';
$string['addon.storagemanager.deleteallsitedata'] = 'Elimina tutti i dati scaricati del sito';
$string['addon.storagemanager.deleteallsitedatainfo'] = 'Saranno eliminati tutti i dati scaricati da \'{{name}}\', compresi i corsi scaricati e le risorse che ti permettono di lavorare offline';
$string['addon.storagemanager.deletecourses'] = 'Elimina i dati scaricati da tutti i corsi';
$string['addon.storagemanager.deletedata'] = 'Elimina dati scaricati';
$string['addon.storagemanager.deletedatafrom'] = 'Elimina tutti i dati scaricati da "{{name}}"';
$string['addon.storagemanager.downloaddatafrom'] = 'Scarica {{name}}';
$string['addon.storagemanager.downloadedcourses'] = 'Corsi scaricati';
$string['addon.storagemanager.downloads'] = 'Download';
$string['addon.storagemanager.errordeletedownloadeddata'] = 'Errore durante l\'eliminazione dei dati scaricati.';
$string['addon.storagemanager.managedownloads'] = 'Gestisci download';
$string['addon.storagemanager.totaldownloads'] = 'Download totali';
$string['addon.storagemanager.totalspaceusage'] = 'Spazio totale utilizzato';
$string['addon.tinymce.enabletinymceeditor'] = 'Usa l\'editor di testo TinyMCE';
$string['addon.tinymce.enabletinymceeditordescription'] = 'Un editor avanzato con funzionalità di formattazione aggiuntive.';
$string['addon.tinymce.license'] = 'A Moodle Pty Ltd è stata concessa una licenza commerciale TinyMCE compatibile con la licenza Apache 2.0.';
$string['appstoredescription'] = 'NOTA: l\'applicazione ufficiale Moodle Mobile funziona solamente con siti Moodle abilitati appositamente. In caso diproblemi di collegamento, contattare l\'amministratore del sito.

L\'app consente di:

- navigare nel contenuto del corso, anche oflfine
- ricevere notifiche istantanee di messaggi e di eventi
- trovare rapidamente e contattare altri partecipanti
- caricare dal dispositivo mobile immagini, audio, video e altri tipi di file
- visualizzare le valutazioni del corso
- molto altro ancora!

Per ulteriori informazioni: http://docs.moodle.org/en/Mobile_app

Saremo lieti di conoscere le tue impressioni sulle funzionalità disponibili e ricevere suggerimenti sulle funzionalità da implementare nella app.

L\'app ha bisogno delle seguenti autorizzazioni:
Registrare audio - Per registrare file audio da caricare su Moodle
Leggere è modificare il contenuto della memoria SD - Per scaricare i contenuti sulla memoria SD e visualizzarli offline
Accesso alla rete - Per collegarsi al sito Moodle, verificare lo stato del collegamento e impostare la modalità offline
Essere lanciata all\'avvio - Per ricevere le notifiche con l\'app in background
Evitare lo standby del telefono - Per ricever notifiche push in qualsiasi momento';
$string['assets.mimetypes.application/vnd.apple.keynote'] = 'Presentazione Apple Keynote';
$string['assets.mimetypes.application/vnd.apple.numbers'] = 'Foglio di calcolo Apple Numbers';
$string['assets.mimetypes.application/vnd.apple.pages'] = 'Documento Apple Pages';
$string['assets.mimetypes.application/vnd.google-apps.audio'] = 'Audio di Google Drive';
$string['assets.mimetypes.application/vnd.google-apps.document'] = 'Google Docs';
$string['assets.mimetypes.application/vnd.google-apps.drawing'] = 'Google Drawing';
$string['assets.mimetypes.application/vnd.google-apps.file'] = 'File di Google Drive';
$string['assets.mimetypes.application/vnd.google-apps.folder'] = 'Cartella di Google Drive';
$string['assets.mimetypes.application/vnd.google-apps.form'] = 'Google Forms';
$string['assets.mimetypes.application/vnd.google-apps.fusiontable'] = 'Google Fusion Tables';
$string['assets.mimetypes.application/vnd.google-apps.presentation'] = 'Google Slides';
$string['assets.mimetypes.application/vnd.google-apps.script'] = 'Google Apps Scripts';
$string['assets.mimetypes.application/vnd.google-apps.site'] = 'Google Sites';
$string['assets.mimetypes.application/vnd.google-apps.spreadsheet'] = 'Google Sheets';
$string['assets.mimetypes.application/vnd.google-apps.video'] = 'Video di Google Drive';
$string['core.ajaxendpointnotfound'] = 'Endpoint AJAX non trovato. Questo può accadere se il sito Moodle è troppo vecchio o blocca l\'accesso a questo endpoint. L\'app Moodle supporta solo sistemi Moodle {{$a}} o versioni successive.';
$string['core.browser'] = 'Browser';
$string['core.calculating'] = 'Calcolo in corso';
$string['core.cannotconnect'] = 'Non è stato possibile effettuare il collegamento';
$string['core.cannotdownloadfiles'] = 'Lo scaricamento di file è disabilitato. Per favore contatta l\'amministratore del sito.';
$string['core.cannotinstallapk'] = 'Impossibile installare file .apk';
$string['core.cannotinstallapkinfo'] = 'Per motivi di sicurezza, non puoi installare app sconosciute sul tuo dispositivo tramite questa app. Se desideri comunque procedere, devi aprire il file in un browser.';
$string['core.cannotlogoutpageblocks'] = 'Salva o annulla le modifiche prima di continuare.';
$string['core.cannotopeninapp'] = 'Questo file potrebbe non funzionare correttamente su questo dispositivo. Vuoi aprirlo comunque?';
$string['core.cannotopeninappdownload'] = 'Questo file potrebbe non funzionare correttamente su questo dispositivo. Vuoi scaricarlo comunque?';
$string['core.captureaudio'] = 'Registra audio';
$string['core.capturedimage'] = 'Foto scattata.';
$string['core.captureimage'] = 'Scatta foto';
$string['core.capturevideo'] = 'Registra video';
$string['core.certificaterror'] = 'Il certificato di questo sito non può essere considerato attendibile dal tuo dispositivo: {{details}}';
$string['core.clearsearch'] = 'Pulisci la ricerca';
$string['core.clearstoreddata'] = 'Cancella dati memorizzati {{$a}}';
$string['core.clicktoseefull'] = 'Click per visualizzare il contenuto completo.';
$string['core.comments.commentsnotworking'] = 'Impossibile recuperare i commenti';
$string['core.comments.warningcommentsnotsent'] = 'Non è stato possibile sincronizzare i commenti. {{error}}';
$string['core.confirmcanceledit'] = 'Sei sicuro di abbandonare questa pagina? Tutte le modifiche saranno perdute.';
$string['core.confirmleavepagedescription'] = 'Le modifiche non salvate andranno perse.';
$string['core.confirmleavepagetitle'] = 'Abbandonare la pagina?';
$string['core.confirmloss'] = 'Sei sicuro? Le modifiche andranno perdute.';
$string['core.confirmopeninbrowser'] = 'Desideri aprirlo nel browser?';
$string['core.confirmremoveselectedfile'] = 'Questo eliminerà permanentemente \'{{filename}}\'. Non potrai annullare l\'operazione.';
$string['core.confirmremoveselectedfiles'] = 'Questo eliminerà permanentemente i file selezionati. Non potrai annullare l\'operazione.';
$string['core.connectandtryagain'] = 'Connettiti a Internet e riprova.';
$string['core.connectionlost'] = 'Connessione al sito persa';
$string['core.contactsupport'] = 'Contatta il supporto';
$string['core.contactverb'] = 'Contatta';
$string['core.contenteditingsynced'] = 'Il contenuto in fase di modifica è stato sincronizzato.';
$string['core.contentlinks.chooseaccount'] = 'Seleziona account';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Scegli un account con cui aprire il link.';
$string['core.contentlinks.confirmurlothersite'] = 'Questo link appartiene a un altro sito. Vuoi aprirlo?';
$string['core.contentlinks.errornoactions'] = 'Impossibile trovare un\'azione da eseguire con questo link.';
$string['core.contentlinks.errornosites'] = 'Impossibile trovare un sito in grado di gestire questo link.';
$string['core.contentlinks.errorredirectothersite'] = 'L\'URL di reindirizzamento non può puntare a un sito diverso.';
$string['core.copiedtoclipboard'] = 'Testo copiato nella clipboard';
$string['core.copytoclipboard'] = 'Copia nella clipboard';
$string['core.course.activitynotavailableoffline'] = 'Questa attività non è disponibile offline.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'La risorsa alla quale si sta accedendo non è supportata per l\'accesso mobile, accedi cliccando su Apri nel Browser.';
$string['core.course.activityrequiresconnection'] = 'Questa attività è disponibile solo con una connessione a Internet. Se il tuo dispositivo è offline, non potrai accedervi.';
$string['core.course.allsections'] = 'Tutte le sezioni';
$string['core.course.aria:sectionprogress'] = 'Progresso sezione:';
$string['core.course.availablespace'] = 'Attualmente hai circa {{available}} di spazio libero.';
$string['core.course.cannotdeletewhiledownloading'] = 'I file non possono essere eliminati mentre l\'attività è in fase di download. Attendi il completamento del download.';
$string['core.course.changesofflinemaybelost'] = 'Eventuali modifiche apportate a questa attività mentre sei offline potrebbero non essere salvate.<br><br>Connetti il dispositivo a Internet per evitare la perdita dei progressi.';
$string['core.course.confirmdownload'] = 'Stai per scaricare {{size}}.{{availableSpace}} Vuoi continuare?';
$string['core.course.confirmdownloadunknownsize'] = 'Non è stato possibile calcolare la dimensione del download.{{availableSpace}} Vuoi continuare?';
$string['core.course.confirmdownloadzerosize'] = 'Stai per iniziare il download. {{availableSpace}} Sei sicuro di voler continuare?';
$string['core.course.confirmlimiteddownload'] = 'Non sei collagato al Wi-Fi.';
$string['core.course.confirmpartialdownloadsize'] = 'Stai per scaricare <strong>almeno</strong> {{size}}.{{availableSpace}} Vuoi continuare?';
$string['core.course.couldnotloadsectioncontent'] = 'Non è stato possibile caricare il contenuto della sezione, per favore riprova più tardi.';
$string['core.course.couldnotloadsections'] = 'Non è stato possibile caricare le sezioni, per favore riprova più tardi.';
$string['core.course.downloadcoursesprogressdescription'] = 'Download dei corsi: scaricati {{count}} su {{total}}.';
$string['core.course.downloadsectionprogressdescription'] = 'Download della sezione: scaricati {{count}} su {{total}}.';
$string['core.course.errordownloadingcourse'] = 'Si è verificato un errore durante lo scaricamento del corso.';
$string['core.course.errordownloadingsection'] = 'Si è verificato un errore durante lo scaricamento della sezione.';
$string['core.course.errorgetmodule'] = 'Si è verificato un errore durante la ricezione dei dati dell\'attività.';
$string['core.course.insufficientavailablequota'] = 'Il tuo dispositivo non è in grado di allocare spazio sufficiente per questo download. Potrebbe riservare spazio per aggiornamenti di sistema e app. Libera dello spazio prima di riprovare.';
$string['core.course.insufficientavailablespace'] = 'Stai tentando di scaricare {{size}}. Questo lascerebbe il dispositivo con spazio insufficiente per funzionare normalmente. Libera dello spazio prima di riprovare.';
$string['core.course.lastaccessedactivity'] = 'Ultima attività accessa';
$string['core.course.manualcompletionnotsynced'] = 'Completamento manuale non sincronizzato.';
$string['core.course.modulenotfound'] = 'Risorsa o attività non trovata. Assicurati di essere online e che sia ancora disponibile.';
$string['core.course.nextactivity'] = 'Attività successiva';
$string['core.course.nextactivitynotfound'] = 'Attività successiva non trovata. Potrebbe essere nascosta o eliminata.';
$string['core.course.nocontentavailable'] = 'Non sono presenti contenuti.';
$string['core.course.previousactivity'] = 'Attività precedente';
$string['core.course.previousactivitynotfound'] = 'Attività precedente non trovata. Potrebbe essere nascosta o eliminata.';
$string['core.course.refreshcourse'] = 'Aggiorna corso';
$string['core.course.useactivityonbrowser'] = 'Puoi comunque usarla tramite il browser del tuo dispositivo.';
$string['core.course.warningmanualcompletionmodified'] = 'Il completamento manuale di un\'attività è stato modificato sul sito.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Alcuni completamenti manuali offline del corso \'{{name}}\' sono stati eliminati. {{error}}';
$string['core.coursenogroups'] = 'Non fai parte di nessun gruppo di questo corso.';
$string['core.courses.browserenrolinstructions'] = 'Ti porteremo al browser del tuo dispositivo. Una volta completata l\'iscrizione, torna in questa app.';
$string['core.courses.cannotretrievemorecategories'] = 'Non è possibile recuperare categorie più profonde del livello {{$a}}.';
$string['core.courses.completeenrolmentbrowser'] = 'Completa l\'iscrizione nel browser';
$string['core.courses.downloadcourses'] = 'Scarica corsi';
$string['core.courses.enrolme'] = 'Iscrivimi';
$string['core.courses.errorloadcategories'] = 'Si è verificato un errore durante il caricamento delle categorie.';
$string['core.courses.errorloadcourses'] = 'Si è verificato un errore durante il caricamento dei corsi.';
$string['core.courses.errorloadplugins'] = 'I plugin richiesti da questo corso non possono essere caricati correttamente. Ricarica l\'app e riprova.';
$string['core.courses.errorsearching'] = 'Si è verificato un errore durante la ricerca.';
$string['core.courses.filtermycourses'] = 'Filtra i miei corsi';
$string['core.courses.notenrollable'] = 'Non puoi iscriverti al corso.';
$string['core.courses.otherenrolments'] = 'Altre iscrizioni';
$string['core.courses.password'] = 'Chiave di iscrizione';
$string['core.courses.refreshcourses'] = 'Aggiorna corsi';
$string['core.courses.searchcoursesadvice'] = 'Puoi utilizzare la ricerca corsi per accedere come ospite oppure iscriverti nei corsi che lo consentono.';
$string['core.courses.showonlyenrolled'] = 'Mostra solo i miei corsi';
$string['core.courses.totalcoursesearchresults'] = 'Totale corsi: {{$a}}';
$string['core.currentdevice'] = 'Dispositivo attuale';
$string['core.datastoredoffline'] = 'Dati memorizzati sul dispositivo perché non è stato possibile inviarli. Verranno inviati automaticamente più tardi.';
$string['core.deletedoffline'] = 'Eliminato offline';
$string['core.deleting'] = 'Eliminazione in corso';
$string['core.desktop'] = 'Desktop';
$string['core.dfdaymonthyear'] = 'DD-MM-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Annulla';
$string['core.dismiss'] = 'Chiudi';
$string['core.dontshowagain'] = 'Non mostrare più.';
$string['core.downloaded'] = 'Scaricato';
$string['core.downloading'] = 'Scaricamento in corso';
$string['core.editor.hidetoolbar'] = 'Nascondi barra degli strumenti';
$string['core.editor.toggle'] = 'Attiva/disattiva editor';
$string['core.emptysplit'] = 'Questa pagina apparirà vuota se il pannello a sinistra è vuoto o in caricamento.';
$string['core.endingtime'] = 'Ora di fine: {{$a}}';
$string['core.errorchangecompletion'] = 'Si è verificato un errore durante la modifica dello stato di completamento. Per favore riprova.';
$string['core.errorcode'] = 'Codice errore: {{errorCode}}';
$string['core.errordeletefile'] = 'Si è verificato un errore durante l\'eliminazione del file. Per favore riprova.';
$string['core.errordetailshide'] = 'Nascondi dettagli errore';
$string['core.errordetailsshow'] = 'Mostra dettagli errore';
$string['core.errordownloading'] = 'Si è verificato un errore durante lo scaricamento del file.';
$string['core.errordownloadingsomefiles'] = 'Si è verificato un errore durante lo scaricamento dei file. E\' possibile che manchino alcuni file.';
$string['core.errorfileexistssamename'] = 'Un file con lo stesso nome è già presente.';
$string['core.errorinvalidform'] = 'Controlla che tutti i campi obbligatori siano compilati e che i dati inseriti siano nel formato corretto.';
$string['core.errorinvalidresponse'] = 'E\' stata ricevuta una risposta non valida. Se l\'errore persiste, contatta l\'amministratore del sito.';
$string['core.errorloadingcontent'] = 'Si è verificato un errore durante il caricamento del contenuto.';
$string['core.errorofflinedisabled'] = 'La navigazione offline è disabilitata sul tuo sito. Devi essere connesso a Internet per usare l\'app.';
$string['core.erroropenfiledownloading'] = 'Errore nell\'apertura del file: devi attendere il completamento del download.';
$string['core.erroropenfilenoapp'] = 'Si è verificato un errore durante l\'apertura del file: non sono disponibili app per aprire questo tipo di file.';
$string['core.erroropenfilenoextension'] = 'Si è verificato un errore durante l\'apertura del file: il file non ha un\'estensione.';
$string['core.erroropenpopup'] = 'L\'attività tenta di aprirsi in una finestra popup. Le popup non sono supportate nella app.';
$string['core.errorrenamefile'] = 'Si è verificato un errore durante la modifica del nome del file. Per favore riprova.';
$string['core.errorsitesupport'] = 'Se il problema persiste, contatta il supporto del sito.';
$string['core.errorsomedatanotdownloaded'] = 'Se hai scaricato questa attività, nota che alcuni dati non sono stati scaricati per motivi di prestazioni e utilizzo dei dati.';
$string['core.errorsomethingwrong'] = 'Qualcosa è andato storto. Riprova.';
$string['core.errorsync'] = 'Si è verificato un errore durante la sincronizzazione. Per favore riprova.';
$string['core.errorsyncblocked'] = 'Questo {{$a}} non può essere sincronizzato in questo momento a causa di un processo in corso. Riprova più tardi. Se il problema persiste, prova a riavviare l\'app.';
$string['core.errorurlschemeinvalidscheme'] = 'Questa URL è pensata per essere usata in un\'altra app: {{$a}}.';
$string['core.errorurlschemeinvalidsite'] = 'L\'URL di questo sito non può essere aperto in questa app.';
$string['core.exactalarmsturnedoff'] = 'Le notifiche in tempo reale sono disattivate';
$string['core.exactalarmsturnedoffmessage'] = 'Per non perdere avvisi importanti, attiva \'Allarmi e promemoria\' nelle impostazioni del tuo dispositivo.';
$string['core.filedeletedsuccessfully'] = 'Hai eliminato correttamente \'{{filename}}\'';
$string['core.filenameexist'] = 'Un file con lo stesso non è già presente: {{$a}}';
$string['core.fileuploader.audio'] = 'Audio';
$string['core.fileuploader.camera'] = 'Camera';
$string['core.fileuploader.confirmuploadfile'] = 'Stai per caricare {{size}}. Sei sicuro di continuare?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Non è stato possibile calcolare la dimensione del caricamento. Vuoi continuare?';
$string['core.fileuploader.discardrecording'] = 'Annulla registrazione';
$string['core.fileuploader.errorcapturingaudio'] = 'Si è verificato un errore durante la registrazione dell\'audio';
$string['core.fileuploader.errorcapturingimage'] = 'Si è verificato un errore durante l\'acquisizione dell\'immagine.';
$string['core.fileuploader.errorcapturingvideo'] = 'Si è verificato un errore durante l\'acquisizione del video';
$string['core.fileuploader.errorgettingimagealbum'] = 'Si è verificato un errore durante la ricezione dell\'immagine dall\'album.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Devi essere online per caricare file.';
$string['core.fileuploader.errornoapp'] = 'Non hai un\'app per svolgere questa azione.';
$string['core.fileuploader.errorreadingfile'] = 'Si è verificato un errore durante la lettura del file.';
$string['core.fileuploader.errorwhileuploading'] = 'Si è verificato un errore durante il caricamento del file.';
$string['core.fileuploader.file'] = 'File';
$string['core.fileuploader.fileuploaded'] = 'File caricato correttamente';
$string['core.fileuploader.maxbytesfile'] = 'Il file {{$a.file}} è troppo grande. La dimensione massima consentita è {{$a.size}}.';
$string['core.fileuploader.microphonepermissiondenied'] = 'Il permesso di accesso al microfono è stato negato.';
$string['core.fileuploader.microphonepermissionrestricted'] = 'L\'accesso al microfono è limitato.';
$string['core.fileuploader.pauserecording'] = 'Pausa registrazione';
$string['core.fileuploader.photoalbums'] = 'Album fotografico';
$string['core.fileuploader.readingfile'] = 'Letture file in corso';
$string['core.fileuploader.readingfileperc'] = 'Lettura file: {{$a}}%';
$string['core.fileuploader.resumerecording'] = 'Riprendi registrazione';
$string['core.fileuploader.selectafile'] = 'Seleziona un file';
$string['core.fileuploader.startrecordinginstructions'] = 'Tocca per iniziare la registrazione';
$string['core.fileuploader.uploadafile'] = 'Carica un file';
$string['core.fileuploader.uploading'] = 'Caricamento in corso';
$string['core.fileuploader.uploadingperc'] = 'Caricamento: {{$a}}%';
$string['core.fileuploader.video'] = 'Video';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.goto'] = 'Vai a {{$a}}';
$string['core.h5p.errorgetemail'] = 'Errore nel recupero dell\'email dell\'utente. Controlla la connessione e riprova.';
$string['core.h5p.offlinedisabled'] = 'Il sito non permette il download dei pacchetti H5P.';
$string['core.h5p.play'] = 'Esegui H5P';
$string['core.hasdatatosync'] = 'Questo {{$a}} ha dati offline da sincronizzare.';
$string['core.howtoobtaincoordinates'] = 'Puoi ottenere le tue coordinate usando un\'app GPS o un\'<a href="{{url}}">app di mappe</a>.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.iframehelp'] = 'Questo contenuto non funziona?';
$string['core.image'] = 'Immagine';
$string['core.imageviewer'] = 'Visualizzatore di immagini';
$string['core.ioscookieshelp'] = 'I contenuti incorporati potrebbero richiedere i cookie. Vai nelle impostazioni iOS dell\'app, abilita \'Consenti tracciamento tra siti\' e riprova.';
$string['core.lastdownloaded'] = 'Ultimo download';
$string['core.lastsync'] = 'Ultima sincronizzazione';
$string['core.leave'] = 'Esci';
$string['core.loadmore'] = 'Carica altro';
$string['core.locationnolongeravailable'] = 'Il rilevamento della posizione non è più disponibile. {{howToObtain}}';
$string['core.login.authenticating'] = 'Autenticazione in corso';
$string['core.login.changepasswordbutton'] = 'Cambia password';
$string['core.login.changepasswordhelp'] = 'Se hai problemi a cambiare la password, riprova più tardi o contatta la tua scuola o fornitore di formazione.';
$string['core.login.changepasswordreconnectinstructions'] = 'Se non hai cambiato correttamente la password, ti verrà chiesto di farlo di nuovo.';
$string['core.login.changepasswordsupportsubject'] = 'Aiuto per cambiare la password';
$string['core.login.confirmdeletesite'] = 'Sei sicuro di eliminare il sito {{sitename}}?';
$string['core.login.connect'] = 'Collegati!';
$string['core.login.connecttomoodle'] = 'Collegati a Moodle';
$string['core.login.connecttomoodleapp'] = 'Stai cercando di connetterti a un sito Moodle normale. Scarica l\'app ufficiale Moodle per accedere a questo sito.';
$string['core.login.connecttoworkplaceapp'] = 'Stai cercando di connetterti a un sito Moodle Workplace. Scarica l\'app Moodle Workplace per accedere a questo sito.';
$string['core.login.credentialsdescription'] = 'Per favore inserisci username e password per l\'autenticazione';
$string['core.login.credentialshelp'] = 'Se hai problemi ad accedere, riprova più tardi o contatta la tua scuola o fornitore di formazione.';
$string['core.login.credentialssupportsubject'] = 'Aiuto per accedere';
$string['core.login.emailconfirmsentnoemail'] = '<p>Una email dovrebbe essere stata inviata al tuo indirizzo.</p><p>Contiene istruzioni semplici per completare la registrazione.</p>';
$string['core.login.emailnotmatch'] = 'Le email non corrispondono';
$string['core.login.erroraccesscontrolalloworigin'] = 'La chiamata cross-origin che stai effettuando è stata rifiutata. Per ulteriori informazioni: https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = 'Si è verificato un errore durante l\'eliminazione di questo sito. Per favore riprova.';
$string['core.login.errorexampleurl'] = 'L\'URL https://campus.example.edu è solo un esempio, non un sito reale. <strong>Usa l\'URL del sito della tua scuola o organizzazione.</strong>';
$string['core.login.errorqrnoscheme'] = 'Questo URL non è valido per il login.';
$string['core.login.errorupdatesite'] = 'Si è verificato un errore durante l\'aggiornamento del token del sito.';
$string['core.login.exceededloginattempts'] = 'Hai bisogno di aiuto per accedere? Prova a {{recoverPassword}} o contatta il supporto del sito.';
$string['core.login.exceededloginattemptsrecoverpassword'] = 'recuperare la password';
$string['core.login.exceededloginattemptssupportsubject'] = 'Non riesco ad accedere';
$string['core.login.exceededloginattemptswithoutpassword'] = 'Hai bisogno di aiuto per accedere? Contatta il supporto del sito.';
$string['core.login.exceededloginattemptswithoutsupport'] = 'Hai bisogno di aiuto per accedere? Prova a {{recoverPassword}}.';
$string['core.login.exceededpasswordresetattempts'] = 'Sembra che tu abbia problemi ad accedere al tuo account. Puoi contattare la tua scuola o riprovare più tardi.';
$string['core.login.exceededpasswordresetattemptssupportsubject'] = 'Non riesco a resettare la password';
$string['core.login.faqcannotfindmysiteanswer'] = 'Se non riesci a trovare il sito Moodle tramite l\'URL, contatta la persona responsabile di Moodle nella tua scuola o organizzazione.';
$string['core.login.faqcannotfindmysitequestion'] = 'Non riesco a trovare il mio sito tramite l\'URL.';
$string['core.login.faqcantloginanswer'] = '<p>Una volta connesso al sito Moodle, potrai accedere con il tuo username e password abituali.</p><br><p>Se hai dimenticato username o password, seleziona <strong>Password persa?</strong>. Se continui ad avere problemi, contatta la persona responsabile di Moodle nella tua scuola o organizzazione.</p>';
$string['core.login.faqcantloginquestion'] = 'Non riesco ad accedere.';
$string['core.login.faqmore'] = 'Consulta <a href="https://docs.moodle.org/en/Moodle_app_FAQ#toc" target="_blank">le FAQ</a> per altre risposte.';
$string['core.login.faqsetupsiteanswer'] = 'Visita {{$link}} per vedere le opzioni disponibili per creare il tuo sito Moodle.';
$string['core.login.faqsetupsitelinktitle'] = 'Inizia ora.';
$string['core.login.faqsetupsitequestion'] = 'Voglio creare il mio sito Moodle.';
$string['core.login.faqtestappanswer'] = 'Per testare l\'app su un sito demo Moodle, inserisci "teacher" o "student" nel campo <strong>Il tuo sito</strong> e premi <strong>Connettiti al sito</strong>.';
$string['core.login.faqtestappquestion'] = 'Posso testare l\'app su un sito demo?';
$string['core.login.faqwhatisurlanswer'] = '<p>Se non trovi il sito per nome, prova a cercarlo tramite l\'URL.</p><p>Per trovare l\'URL:</p><ol><li>Apri un browser e vai alla pagina di login del tuo sito Moodle.</li><li>In alto vedrai l\'URL, es. "campus.example.edu".<br>{{$image}}</li><li>Copia l\'URL (senza /login o ciò che segue), incollalo in <strong>Il tuo sito</strong> nell\'app e premi <strong>Connettiti al sito</strong></li><li>Ora puoi accedere con username e password.</li></ol><p>Se non riesci ancora a trovare il sito, contatta la persona responsabile di Moodle nella tua scuola o organizzazione.</p>';
$string['core.login.faqwhatisurlquestion'] = 'Come posso trovare il mio sito?';
$string['core.login.faqwhereisqrcode'] = 'Dove si trova il codice QR?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>Se la tua scuola o fornitore lo ha abilitato, troverai il codice QR in fondo alla pagina del tuo profilo utente.</p>{{$image}}';
$string['core.login.findyoursite'] = 'Trova il tuo sito';
$string['core.login.invalidaccount'] = 'Verificare le proprie credenziali o chiedere all\'amministratore del sito di controllare la configurazione del sito.';
$string['core.login.invalidmoodleversion'] = 'La versione di Moodle non è valida. La versione minima richiesta è la {{$a}} o versioni successive.';
$string['core.login.invalidsite'] = 'L\'URL del sito non è valida';
$string['core.login.invalidtime'] = 'Orario non valido';
$string['core.login.invalidvaluemax'] = 'Il valore massimo è {{$a}}';
$string['core.login.invalidvaluemin'] = 'Il valore minimo è {{$a}}';
$string['core.login.loginbutton'] = 'Login';
$string['core.login.mobileservicesnotenabled'] = 'I servizi mobile non sono abilitati nel sito. Per richiederne l\'abilitazione, contattare l\'amministrazione del sito.';
$string['core.login.morewaystologin'] = 'Altri modi per accedere';
$string['core.login.notloggedin'] = 'Devi essere autenticato';
$string['core.login.onboardingcreatemanagecourses'] = 'Crea e gestisci i tuoi corsi';
$string['core.login.onboardingenrolmanagestudents'] = 'Crea e gestisci i tuoi studenti';
$string['core.login.onboardinggetstarted'] = 'Primi passi con Moodle';
$string['core.login.onboardingialreadyhaveasite'] = 'Ho già un sito Moodle';
$string['core.login.onboardingimalearner'] = 'Sono uno studente';
$string['core.login.onboardingimaneducator'] = 'Sono un formatore';
$string['core.login.onboardingineedasite'] = 'Mi serve un sito Moodle';
$string['core.login.onboardingprovidefeedback'] = 'Fornisci feedback tempestivi';
$string['core.login.onboardingtoconnect'] = 'Per connetterti all\'app Moodle hai bisogno di un sito Moodle';
$string['core.login.onboardingwelcome'] = 'Benvenuto nell\'App Moodle!';
$string['core.login.or'] = 'Oppure';
$string['core.login.passwordrequired'] = 'Password necessaria';
$string['core.login.recaptchachallengeimage'] = 'Immagine sfida reCAPTCHA';
$string['core.login.recaptchaexpired'] = 'Verifica scaduta. Rispondi di nuovo alla domanda di sicurezza.';
$string['core.login.recaptchaincorrect'] = 'La risposta alla domanda di sicurezza non è corretta.';
$string['core.login.reconnect'] = 'Riconnetti';
$string['core.login.reconnecthelp'] = 'Se hai problemi a riconnetterti, riprova più tardi o contatta la tua scuola o fornitore.';
$string['core.login.reconnectsupportsubject'] = 'Aiuto per riconnettersi';
$string['core.login.reconnecttosite'] = 'Riconnettiti al sito';
$string['core.login.removeaccount'] = 'Rimuovi account';
$string['core.login.searchby'] = 'Cerca per:';
$string['core.login.selectsite'] = 'Seleziona il sito:';
$string['core.login.signupplugindisabled'] = '{{$a}} non è abilitato.';
$string['core.login.signuprequiredfieldnotsupported'] = 'Il modulo di registrazione contiene un campo personalizzato obbligatorio non supportato dall\'app. Crea l\'account tramite browser.';
$string['core.login.siteaddress'] = 'Indirizzo del sito';
$string['core.login.siteaddressplaceholder'] = 'https://campus.example.edu';
$string['core.login.sitebadgedescription'] = 'Ci sono {{count}} notifiche non lette.';
$string['core.login.sitehasredirect'] = 'Il tuo sito contiene almeno un reindirizzamento HTTP. L\'app non può seguirli, questo potrebbe impedire la connessione.';
$string['core.login.siteinmaintenance'] = 'Il sito è in modalità manutenzione';
$string['core.login.sitenotallowed'] = 'Questo sito non è più disponibile.';
$string['core.login.sitepolicynotagreederror'] = 'Politiche del sito non accettate.';
$string['core.login.siteurl'] = 'URL del sito';
$string['core.login.siteurlrequired'] = 'L\'URL del sito è obbligatoria. Esempio:<i>http://www.yourmoodlesite.abc or https://www.yourmoodlesite.efg</i>';
$string['core.login.stillcantconnect'] = 'Ancora non riesci a connetterti?';
$string['core.login.toggleremove'] = 'Modifica elenco account';
$string['core.login.unsupportedsite'] = 'Sito non accessibile tramite l\'app';
$string['core.login.unsupportedsitemessage'] = '{{site}} non può essere accessibile tramite questa app.<br><br>Puoi comunque accedervi usando un browser web.';
$string['core.login.usernamerequired'] = 'Username obbligatorio';
$string['core.login.visitchangepassword'] = 'Vuoi visitare il sito per cambiare la password?';
$string['core.login.webservicesnotenabled'] = 'Nel sito non sono stati abilitati i web service. Per favore contatta l\'amministratore del sito per verificare la configurazione.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Puoi comunque connetterti al sito inserendo username e password.';
$string['core.login.yourenteredsite'] = 'Collegati al sito';
$string['core.lostconnection'] = 'Il token di autenticazione non è valido o è scaduto. Devi autenticarti nuovamente.';
$string['core.mainmenu.switchaccount'] = 'Cambia account';
$string['core.needhelp'] = 'Serve aiuto?';
$string['core.needinternettoaccessit'] = 'Devi essere connesso a Internet per accedervi.';
$string['core.networkerrormsg'] = 'La rete non è abilitata o non funziona.';
$string['core.nooptionavailable'] = 'Nessuna opzione disponibile';
$string['core.nopasswordchangeforced'] = 'Non puoi procedere senza cambiare la password.';
$string['core.nopermissionerror'] = 'Spiacente, ma attualmente non hai i permessi per fare questo';
$string['core.notapplicable'] = 'n/d';
$string['core.notavailablecontentinapp'] = 'Questo contenuto non è disponibile nell\'app, ma puoi aprirlo in un browser web usando il pulsante seguente.';
$string['core.notavailableoffline'] = 'Questo contenuto non è disponibile offline. Connettiti a Internet e riprova.';
$string['core.notdownloadable'] = 'Non scaricabile';
$string['core.notnow'] = 'Non ora';
$string['core.notsent'] = 'Non inviato';
$string['core.nummore'] = '{{$a}} in più';
$string['core.openfile'] = 'Apri file';
$string['core.openfilewithextension'] = 'Apri file {{extension}}';
$string['core.openfullimage'] = 'Click per visualizare l\'immagine a dimensioni reali';
$string['core.openinbrowser'] = 'Apri nel browser';
$string['core.openinbrowserdescription'] = 'Verrai indirizzato a un browser web';
$string['core.openmodinbrowser'] = 'Apri {{$a}} nel browser';
$string['core.opensecurityquestion'] = 'Apri domanda di sicurezza';
$string['core.opensettings'] = 'Apri impostazioni';
$string['core.openwith'] = 'Apri con...';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.play'] = 'Riproduci';
$string['core.policy.havereadandagreepolicy'] = 'Ho letto e accetto la {{policyname}}';
$string['core.policy.nopoliciesyet'] = 'Nessuna policy o accordo presente.';
$string['core.policy.policyacceptmandatory'] = 'Comprendo e accetto le policy obbligatorie del sito';
$string['core.policy.sitepolicynotagreederror'] = 'Policy del sito non accettata.';
$string['core.policy.viewpolicy'] = 'Visualizza policy {{policyname}}.';
$string['core.pulltorefresh'] = 'Trascina per aggiornare';
$string['core.qrscanner'] = 'Scanner QR';
$string['core.question.cannotdeterminestatus'] = 'Non è possibile determinare lo stato';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'Il tuo sito non supporta ancora l\'allegare file alle risposte.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'Il tuo sito non supporta ancora la modifica di file incorporati.';
$string['core.question.errorquestionnotsupported'] = 'Questo tipo di domanda non è supportato dall\'app: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Tocca per selezionare e poi tocca per rilasciare.';
$string['core.question.questionmessage'] = 'Domanda {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Verrai reindirizzato al sito.';
$string['core.reminders.atthetime'] = 'All\'ora dell\'evento';
$string['core.reminders.custom'] = 'Personalizzato...';
$string['core.reminders.customreminder'] = 'Promemoria personalizzato';
$string['core.reminders.delete'] = 'Elimina promemoria';
$string['core.reminders.reminderset'] = 'Promemoria impostato per {{$a}}';
$string['core.reminders.reminderunset'] = 'Promemoria eliminato';
$string['core.reminders.setareminder'] = 'Imposta un promemoria';
$string['core.reminders.setareminderfor'] = 'Imposta un promemoria per "{{title}}" ({{label}})';
$string['core.reminders.setreminder'] = 'Imposta promemoria';
$string['core.reminders.timebefore'] = '{{value}} {{units}} prima';
$string['core.reminders.value'] = 'Valore';
$string['core.removedownloadeddata'] = 'Rimuovi dati scaricati';
$string['core.removefiles'] = 'Rimuovi file {{$a}}';
$string['core.reportbuilder.filtersapplied'] = 'Potrebbero essere applicati dei filtri a questa vista. Per modificare i filtri o cambiare l\'ordine, <a href="{{$a}}">apri questo report nel browser.</a>';
$string['core.reportbuilder.hidecolumns'] = 'Nascondi colonne';
$string['core.reportbuilder.showcolumns'] = 'Mostra colonne';
$string['core.requireduserdatamissing'] = 'Nel profilo di questo utente mancano alcuni dati. Per favore compila i dati mancanti e riprova.<br>{{$a}}';
$string['core.resume'] = 'Riprendi';
$string['core.retry'] = 'Riprova';
$string['core.scanqr'] = 'Scansiona codice QR';
$string['core.scrollbackward'] = 'Scorri indietro';
$string['core.scrollforward'] = 'Scorri avanti';
$string['core.search.allcategories'] = 'Tutte le categorie';
$string['core.search.empty'] = 'Cosa stai cercando?';
$string['core.search.filtercategories'] = 'Filtra risultati per';
$string['core.search.filtercourses'] = 'Cerca in';
$string['core.search.noresults'] = 'Nessun risultato per "{{$a}}"';
$string['core.search.noresultshelp'] = 'Controlla errori di battitura o prova parole chiave diverse';
$string['core.search.resultby'] = 'Di {{$a}}';
$string['core.searching'] = 'Ricerca in corso';
$string['core.serverconnection'] = 'Errore nella connessione al server: {{details}}';
$string['core.settings.about'] = 'Informazioni';
$string['core.settings.appsettings'] = 'Impostazioni App';
$string['core.settings.appversion'] = 'Versione App';
$string['core.settings.cannotsyncloggedout'] = 'Questo sito non può essere sincronizzato perché hai effettuato il logout. Riprova quando sei nuovamente loggato.';
$string['core.settings.cannotsyncoffline'] = 'La sincronizzazione del sito è fallita perché il dispositivo non è connesso a Internet.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Il dispositivo non è connesso al Wi-Fi. Collegarsi ad una rete Wi-Fi o disabilitare Risparmio dati nelle impostazione dell\'app.';
$string['core.settings.changelanguage'] = 'Cambia in {{$a}}';
$string['core.settings.changelanguagealert'] = 'Cambiare lingua riavvierà l\'app.';
$string['core.settings.colorscheme'] = 'Schema colori';
$string['core.settings.colorscheme-dark'] = 'Scuro';
$string['core.settings.colorscheme-light'] = 'Chiaro';
$string['core.settings.colorscheme-system'] = 'Default di sistema';
$string['core.settings.colorscheme-system-notice'] = 'La modalità predefinita dipenderà dal supporto del tuo dispositivo.';
$string['core.settings.compilationinfo'] = 'Informazioni di compilazione';
$string['core.settings.connecttosync'] = 'Il tuo dispositivo è offline. Connettiti a Internet per sincronizzare i siti.';
$string['core.settings.connectwifitosync'] = 'Collegarsi ad un Wi-Fi o disabilitare Risparmio dati per sincronizzare i siti';
$string['core.settings.copyinfo'] = 'Copia informazioni sul dispositivo nella clipboard';
$string['core.settings.cordovadevicemodel'] = 'Modello del dispositivo Cordova';
$string['core.settings.cordovadeviceosversion'] = 'Versione SO del dispositivo Cordova';
$string['core.settings.cordovadeviceplatform'] = 'Piattaforma del dispositivo Cordova';
$string['core.settings.cordovadeviceuuid'] = 'UUID del dispositivo Cordova';
$string['core.settings.cordovaversion'] = 'Versione Cordova';
$string['core.settings.debugdisplaydescription'] = 'Se abilitato, saranno visualizzate più informazioni relative agli errori';
$string['core.settings.developeroptions'] = 'Opzioni sviluppatore';
$string['core.settings.deviceinfo'] = 'Informazioni sul dispositivo';
$string['core.settings.deviceos'] = 'SO del dispositivo';
$string['core.settings.displayformat'] = 'Formato di visualizzazione';
$string['core.settings.enableanalytics'] = 'Abilita analisi';
$string['core.settings.enableanalyticsdescription'] = 'Se abilitato, l\'app raccoglierà dati anonimi sull\'uso.';
$string['core.settings.enabledownloadsection'] = 'Abilita scaricamento sezioni';
$string['core.settings.enablepinchtozoom'] = 'Abilita pinch-to-zoom';
$string['core.settings.enablerichtexteditor'] = 'Abilita editor di testo';
$string['core.settings.enablerichtexteditordescription'] = 'Se abilitato, sarà possibile utilizzare un editor di testo per inserire contenuti';
$string['core.settings.encryptedpushsupported'] = 'Notifiche push criptate supportate';
$string['core.settings.entriesincache'] = '{{$a}} voci nella cache';
$string['core.settings.estimatedfreespace'] = 'Spazio libero stimato';
$string['core.settings.filesystemroot'] = 'Root del filesystem';
$string['core.settings.fontsize'] = 'Dimensione testo';
$string['core.settings.forcedsetting'] = 'Questa impostazione è stata forzata dalla configurazione del sito.';
$string['core.settings.helpusimprove'] = 'Aiutaci a migliorare l\'app';
$string['core.settings.ioscookies'] = 'Tracciamento tra siti';
$string['core.settings.ioscookiesdescription'] = 'I contenuti incorporati potrebbero richiedere i cookie tra siti per funzionare. Vai nelle impostazioni iOS dell\'app e abilita "Consenti tracciamento tra siti".';
$string['core.settings.legaldisclaimer'] = 'Disclaimer legale';
$string['core.settings.localnotifavailable'] = 'Notifiche locali disponibili';
$string['core.settings.locationhref'] = 'URL Webview';
$string['core.settings.logintosync'] = 'Accedi per sincronizzare';
$string['core.settings.navigatorlanguage'] = 'Navigator language';
$string['core.settings.navigatoruseragent'] = 'Navigator userAgent';
$string['core.settings.networkstatus'] = 'Stato della connessione internet';
$string['core.settings.opensourcelicenses'] = 'Licenze Open Source';
$string['core.settings.privacypolicy'] = 'Privacy policy';
$string['core.settings.publisher'] = 'Editore';
$string['core.settings.pushid'] = 'ID notifiche push';
$string['core.settings.reportinbackground'] = 'Invia errori automaticamente';
$string['core.settings.screen'] = 'Informazioni sullo schermo';
$string['core.settings.showdownloadoptions'] = 'Mostra opzioni di download';
$string['core.settings.siteinfo'] = 'Info sito';
$string['core.settings.sitesynccompleted'] = 'Sincronizzazione sito completata.';
$string['core.settings.sitesyncfailed'] = 'Sincronizzazione sito fallita';
$string['core.settings.spaceusage'] = 'Spazio utilizzato';
$string['core.settings.syncdatasaver'] = 'Risparmio dati: sincronizza solo su Wi-Fi';
$string['core.settings.synchronization'] = 'Sincronizzazione';
$string['core.settings.synchronizenow'] = 'Sincronizza adesso';
$string['core.settings.synchronizenowhelp'] = 'Tutte le modifiche effettuate offline, compresi messaggi e notifiche, saranno sincronizzate quando il dispositivo è connesso';
$string['core.settings.syncsettings'] = 'Impostazioni di sincronizzazione';
$string['core.settings.wificonnection'] = 'Connessione WiFi';
$string['core.settings.youradev'] = 'Ora sei uno sviluppatore';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Scegli un account in cui salvare il file.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Un file con questo nome esiste già. Vuoi sostituirlo o rinominarlo in "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Non ci sono siti registrati. Aggiungi un sito prima di condividere un file con l\'app.';
$string['core.sharedfiles.nosharedfiles'] = 'Non ci sono file condivisi memorizzati su questo sito.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Non hai file da caricare qui. Per caricare un file da un\'altra app, individua il file e clicca su "Apri con".';
$string['core.sharedfiles.rename'] = 'Rinomna';
$string['core.sharedfiles.replace'] = 'Sostituisci';
$string['core.sharedfiles.sharedfiles'] = 'File condivisi';
$string['core.sharedfiles.successstorefile'] = 'File salvato correttamente. Seleziona il file per caricarlo nei tuoi file privati o usarlo in un\'attività.';
$string['core.sitenotfoundhelp'] = 'Non possiamo trovare il sito inserito. Controlla errori di battitura o riprova più tardi. Se il problema persiste, contatta la tua scuola o fornitore.';
$string['core.siteunavailablehelp'] = 'Il sito "{{site}}" non è disponibile in questo momento. Riprova più tardi o contatta la tua scuola o fornitore.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Spiacente...';
$string['core.start'] = 'Avvia';
$string['core.startingtime'] = 'Ora di inizio: {{$a}}';
$string['core.storingfiles'] = 'Salvataggio file';
$string['core.submittedoffline'] = 'Inviato (Offline)';
$string['core.swipenavigationtourdescription'] = 'Scorri a sinistra o destra per navigare.';
$string['core.tablet'] = 'Tablet';
$string['core.tag.errorareanotsupported'] = 'Quest\'area tag non è supportata dall\'app.';
$string['core.tag.tagareabadgedescription'] = 'Ci sono {{count}} elementi.';
$string['core.tag.warningareasnotsupported'] = 'Alcune aree tag non sono visualizzate perché non supportate dall\'app.';
$string['core.thereisdatatosync'] = 'Ci sono {{$a}} offline da sincronizzare.';
$string['core.toggledelete'] = 'Attiva/disattiva pulsanti elimina';
$string['core.tryagain'] = 'Riprova';
$string['core.turnon'] = 'Accendi';
$string['core.turnonexactalarms'] = 'Attiva avvisi in tempo reale';
$string['core.turnonnotifications'] = 'Attiva notifiche';
$string['core.turnonnotificationsmessage'] = 'Vuoi ricevere notifiche su attività e compiti?';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Nota';
$string['core.unexpectederror'] = 'Si è verificato un errore inatteso. Riprova chiudendo e riaprendo l\'applicazione.';
$string['core.unicodenotsupported'] = 'Alcune emoji non sono supportate su questo sito. Verranno rimosse al momento dell\'invio del messaggio.';
$string['core.unicodenotsupportedcleanerror'] = 'Testo vuoto trovato durante la pulizia dei caratteri Unicode.';
$string['core.unknown'] = 'Sconosciuto';
$string['core.unzipping'] = 'Decompressione in corso';
$string['core.updaterequired'] = 'Aggiornamento app richiesto';
$string['core.updaterequireddesc'] = 'Aggiorna l\'app alla versione {{$a}}';
$string['core.user.completeprofile'] = 'Completa profilo';
$string['core.user.completeprofilehelp'] = 'Se hai problemi a completare il profilo, riprova più tardi o contatta la tua scuola o fornitore.';
$string['core.user.completeprofilenotice'] = 'Prima di continuare, completa i campi obbligatori del profilo.';
$string['core.user.completeprofilereconnectinstructions'] = 'Se non hai completato correttamente il profilo, ti verrà chiesto di farlo di nuovo.';
$string['core.user.completeprofilesupportsubject'] = 'Aiuto per completare il profilo';
$string['core.user.completeyourprofile'] = 'Completa il tuo profilo';
$string['core.user.contact'] = 'Contatto';
$string['core.user.detailsnotavailable'] = 'Non puoi visualizzare i dettagli di questo utente.';
$string['core.user.errorloaduser'] = 'Errore nel caricamento utente.';
$string['core.user.sendemail'] = 'Email';
$string['core.user.support'] = 'Contatta supporto sito';
$string['core.user.supportsubject'] = '[App] {{subject}}';
$string['core.user.userwithid'] = 'Utente con ID {{id}}';
$string['core.usernologin'] = 'Autenticazione revocata per questo account';
$string['core.viewcode'] = 'Visualizza codice';
$string['core.vieweditor'] = 'Visualizza editor';
$string['core.viewembeddedcontent'] = 'Visualizza contenuto incorporato';
$string['core.viewer.decreasetextsize'] = 'Riduci dimensione testo';
$string['core.viewer.enterreadingmode'] = 'Entra in modalità lettura';
$string['core.viewer.exitreadingmode'] = 'Esci dalla modalità lettura';
$string['core.viewer.increasetextsize'] = 'Aumenta dimensione testo';
$string['core.viewer.openreadingmodesettings'] = 'Apri impostazioni modalità lettura';
$string['core.viewer.readingthemeauto'] = 'Seguire app';
$string['core.viewer.readingthemedark'] = 'Scuro';
$string['core.viewer.readingthemehcm'] = 'Alto contrasto';
$string['core.viewer.readingthemelight'] = 'Chiaro';
$string['core.viewer.readingthemesepia'] = 'Seppia';
$string['core.wanttochangesite'] = 'Vuoi cambiare sito o uscire?';
$string['core.warningofflinedatadeleted'] = 'Le modifiche offline a {{component}} \'{{name}}\' sono state scartate. {{error}}';
$string['core.warningofflinedatadeletedreason'] = 'Nuove modifiche a questa attività sono state effettuate da un altro dispositivo.';
$string['core.warnopeninbrowser'] = '<p>Stai per uscire dall\'app per aprire la seguente URL nel browser del dispositivo. Vuoi continuare?</p>
<p><b>{{url}}</b></p>';
$string['core.whyisthishappening'] = 'Perché sta succedendo questo?';
$string['core.wsfunctionnotavailable'] = 'La funzione webservice non è disponibile.';
$string['core.youreoffline'] = 'Sei offline';
$string['core.youreonline'] = 'Sei di nuovo online';
$string['core.zoomin'] = 'Zoom avanti';
$string['core.zoomout'] = 'Zoom indietro';
$string['freemium.biometriclogin'] = 'Accesso biometrico';
$string['freemium.biometriclogindescription'] = 'Posiziona il dito sul lettore di impronte.';
$string['freemium.biometricloginenablefaceid'] = 'Abilita FaceID';
$string['freemium.biometricloginenablefingerprint'] = 'Abilita impronta digitale';
$string['freemium.biometricloginenabletouchid'] = 'Abilita TouchID';
$string['freemium.biometricloginloginwithfaceid'] = 'Accedi con FaceID';
$string['freemium.biometricloginloginwithfingerprint'] = 'Accedi con impronta digitale';
$string['freemium.biometricloginloginwithtouchid'] = 'Accedi con TouchID';
$string['freemium.biometricloginskip'] = 'Salta per ora';
$string['freemium.biometricloginsuccessfullyenabled'] = '{{ biometricMethod }} abilitato.';
$string['freemium.biometricloginturnoff'] = 'Puoi attivare o disattivare questa funzione in qualsiasi momento nelle impostazioni.';
$string['freemium.biometriclogintypefaceid'] = 'FaceID';
$string['freemium.biometriclogintypefingerprint'] = 'Impronta digitale';
$string['freemium.biometriclogintypetouchid'] = 'TouchID';
$string['freemium.biometricloginwithfingerorface'] = 'Usa l\'accesso biometrico con impronta digitale o riconoscimento facciale.';
$string['freemium.change'] = 'Modifica';
$string['freemium.coursesbatchdownloaddisabled'] = 'Il download batch dei corsi non è abilitato per questo sito.';
$string['freemium.coursesdownloadlimitreached'] = 'Limite di download dei corsi raggiunto! Puoi avere solo {{limit}} corsi scaricati. Contatta l\'amministratore per aumentare il limite o rimuovere corsi dal dispositivo.';
$string['freemium.downloadmainapplicationrequired'] = 'Puoi connetterti a questo sito solo usando l\'app dedicata.';
$string['freemium.downloadmainapplicationsuggestion'] = 'Il sito a cui stai tentando di connetterti ha un\'app dedicata che potresti voler provare.';
$string['freemium.feature_biometriclogin'] = 'Accesso biometrico';
$string['freemium.feature_coursesdownload'] = 'Corsi scaricati';
$string['freemium.feature_multimediapushnotifications'] = 'Notifiche push multimediali';
$string['freemium.feature_pushnotificationsdevices'] = 'Dispositivi per notifiche push';
$string['freemium.feature_qrlogin'] = 'Autenticazione tramite QR code';
$string['freemium.feature_remotethemes'] = 'Temi remoti';
$string['freemium.feature_sitelogo'] = 'Logo del sito';
$string['freemium.notallowed'] = 'Non consentito';
$string['freemium.nottoday'] = 'Non oggi';
$string['freemium.qrlogindisabled'] = 'L\'autenticazione con codice QR non è abilitata su questo sito: <br><br>{{url}}';
$string['freemium.qrloginexpiredkey'] = 'Il QR code è scaduto. Aggiorna la pagina e scansiona di nuovo.';
$string['freemium.qrloginipmismatch'] = 'Il dispositivo che stai usando per connetterti non sembra essere sulla stessa rete di quello che mostra il QR code. Assicurati che entrambi siano connessi alla stessa rete (es. stessa WiFi).<br><br>Se l\'errore persiste, contatta l\'amministratore del sito.';
$string['freemium.ratetheapp'] = 'Ti sta piacendo la nostra app?';
$string['freemium.ratetheapp_feedbackko'] = 'Dicci cosa non va';
$string['freemium.ratetheapp_feedbackmessage'] = 'Il tuo feedback sarà anonimo';
$string['freemium.ratetheapp_feedbackok'] = 'Invia feedback';
$string['freemium.ratetheapp_feedbackplaceholder'] = 'Scrivi qualcosa qui';
$string['freemium.ratetheapp_feedbacksent'] = 'Grazie! Il tuo feedback è stato inviato con successo.';
$string['freemium.ratetheapp_sendtostore'] = 'Potresti valutare la nostra app? Ci aiuterà a migliorarla.';
$string['freemium.remindmelater'] = 'Ricordamelo più tardi';
$string['freemium.settingsoptionsfacial'] = 'Abilita accesso facciale';
$string['freemium.settingsoptionsfingerprint'] = 'Abilita accesso con impronta digitale';
$string['freemium.subscription'] = 'Abbonamento sito';
$string['freemium.subscriptiondetails'] = 'Dettagli abbonamento';
$string['freemium.subscriptionfeature_exceeded_customlanguagestrings'] = '{{ overflowCount }} stringhe personalizzate ignorate';
$string['freemium.subscriptionfeature_exceeded_custommenuitems'] = '{{ overflowCount }} voci di menu personalizzate ignorate';
$string['freemium.subscriptionfeature_exceeded_disabledfeatures'] = '{{ overflowCount }} funzioni disabilitate sono ancora attive';
$string['freemium.subscriptionfeature_exceeded_remotethemes'] = 'Il tuo tema personalizzato non viene applicato';
$string['freemium.subscriptionfeature_exceeded_sitelogo'] = 'Il logo del sito non viene applicato';
$string['freemium.subscriptionfeature_limited'] = 'Limitato a {{ limit }}';
$string['freemium.subscriptionfeature_unlimited'] = 'Illimitato';
$string['freemium.subscriptionplan'] = 'Piano di abbonamento';
$string['freemium.subscriptionplan_expired'] = 'scaduto';
$string['freemium.subscriptionplan_free'] = 'Gratuito';
$string['freemium.subscriptionplan_upgrade'] = 'Aggiorna il tuo piano';
$string['freemium.subscriptionplan_validuntil'] = 'valido fino al {{ date }}';
$string['freemium.subscriptionplandescription'] = 'I piani di abbonamento indicano quali restrizioni si applicano a questo sito.';
$string['freemium.subscriptionplanlearnmore'] = 'Per saperne di più';
$string['freemium.upsell_renewexpired'] = 'Il tuo abbonamento è scaduto';
$string['freemium.upsell_renewexpiring'] = 'Il tuo abbonamento scadrà tra {{ days }} giorni';
$string['freemium.upsell_renewtitle'] = 'Rinnova il tuo abbonamento';
$string['freemium.upsell_upgradefreeaccept'] = 'Aggiorna';
$string['freemium.upsell_upgradefreemessage'] = 'Attualmente sei nel piano gratuito, esegui l\'upgrade per sbloccare più funzioni.';
$string['freemium.upsell_upgradefreepostpone'] = 'Più tardi';
$string['freemium.upsell_upgradefreetitle'] = 'Aggiorna il tuo piano';
$string['pluginname'] = 'Stringhe di lingua Moodle Mobile';
$string['workplace.teams.isoverdue'] = 'Ha elementi scaduti o non completati';
