<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_ollama', language 'it', version '5.1'.
 *
 * @package     aiprovider_ollama
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:explain_text:model'] = 'Modello di spiegazione del testo';
$string['action:explain_text:model_help'] = 'Il modello utilizzato per spiegare il testo fornito.';
$string['action:explain_text:systeminstruction'] = 'Istruzioni di sistema';
$string['action:explain_text:systeminstruction_help'] = 'Istruzioni inviate al modello di intelligenza artificiale insieme al prompt dell\'utente. Si sconsiglia di modificare queste istruzioni, a meno che non sia assolutamente necessario.';
$string['action:generate_text:model'] = 'Modello di generazione del testo';
$string['action:generate_text:model_help'] = 'Il modello utilizzato per generare le risposte.';
$string['action:generate_text:systeminstruction'] = 'Istruzioni di sistema';
$string['action:generate_text:systeminstruction_help'] = 'Istruzioni inviate al modello di intelligenza artificiale insieme al prompt dell\'utente. Si sconsiglia di modificare queste istruzioni, a meno che non sia assolutamente necessario.';
$string['action:summarise_text:model'] = 'Modello di riepilogo del testo';
$string['action:summarise_text:model_help'] = 'Il modello utilizzato per riepilogare il testo.';
$string['action:summarise_text:systeminstruction'] = 'Istruzioni di sistema';
$string['action:summarise_text:systeminstruction_help'] = 'Istruzioni inviate al modello di intelligenza artificiale insieme al prompt dell\'utente. Si sconsiglia di modificare queste istruzioni, a meno che non sia assolutamente necessario.';
$string['custom_model_name'] = 'Nome del modello personalizzato';
$string['enablebasicauth'] = 'Abilita autenticazione di base';
$string['enablebasicauth_help'] = 'Abilita l\'autenticazione di base per il provider API Ollama.';
$string['endpoint'] = 'Endpoint API';
$string['endpoint_help'] = 'L\'endpoint API per il server API di Ollama.';
$string['extraparams'] = 'Parametri aggiuntivi';
$string['extraparams_help'] = 'Consente di configurare parametri aggiuntivi. Il formato JSON è supportato. Ad esempio:
<pre>
{
  "temperature": 0.5,
  "max_tokens": 100
}
</pre>';
$string['invalidjson'] = 'La stringa JSON non è valida';
$string['password'] = 'Password';
$string['password_help'] = 'Password utilizzata per l\'autenticazione di base.';
$string['pluginname'] = 'Provider di API Ollama';
$string['privacy:metadata'] = 'Il provider API Ollama non memorizza dati personali';
$string['privacy:metadata:aiprovider_ollama:externalpurpose'] = 'Queste informazioni vengono inviate all\'API di Ollama per generare una risposta. Le impostazioni del proprio account Ollama potrebbero modificare il modo in cui Ollama archivia e conserva questi dati. Questo plugin non invia esplicitamente dati utente a Ollama né li memorizza in Moodle LMS.';
$string['privacy:metadata:aiprovider_ollama:model'] = 'Modello utilizzato per generare la risposta.';
$string['privacy:metadata:aiprovider_ollama:prompttext'] = 'Prompt di testo inserito dall\'utente utilizzato per generare la risposta.';
$string['settings'] = 'Impostazioni';
$string['settings_help'] = 'Regolare le impostazioni qui sotto per personalizzare il modo in cui le richieste vengono inviate a Ollama.';
$string['settings_mirostat'] = 'Mirostat';
$string['settings_mirostat_help'] = 'Mirostat è un algoritmo di decodifica neurale del testo per il controllo della perplessità. 0 = disabilitato, 1 = Mirostat, 2 = Mirostat 2.0. (Default: 0)';
$string['settings_seed'] = 'seed';
$string['settings_seed_help'] = 'Imposta il seed del numero casuale da utilizzare per la generazione. Impostando un numero specifico, il modello genererà lo stesso testo per lo stesso prompt. (Default: 0)';
$string['settings_temperature'] = 'temperatura';
$string['settings_temperature_help'] = 'La temperatura influenza la casualità e la creatività dell\'output, oppure la sua prevedibilità. Aumentando la temperatura, il modello risponderà in modo più creativo. (Default: 0,8)';
$string['settings_top_k'] = 'top_k';
$string['settings_top_k_help'] = 'Riduce la probabilità di generare risposte prive di senso. Un valore più alto (ad esempio 100) fornirà risposte più diversificate, mentre un valore più basso (ad esempio 10) sarà più conservativo. (Default: 40)';
$string['settings_top_p'] = 'top_p';
$string['settings_top_p_help'] = 'Funziona in sinergia con top-k. Un valore più alto (ad esempio 0,95) produrrà un testo più vario, mentre un valore più basso (ad esempio 0,5) genererà un testo più mirato e conservativo. (Default: 0,9)';
$string['username'] = 'Username';
$string['username_help'] = 'Username utilizzato per l\'autenticazione di base.';
