<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_deepseek', language 'it', version '5.1'.
 *
 * @package     aiprovider_deepseek
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:explain_text:endpoint'] = 'Endpoint API';
$string['action:explain_text:model'] = 'Modello di spiegazione del testo';
$string['action:explain_text:model_help'] = 'Il modello utilizzato per spiegare il testo fornito.';
$string['action:explain_text:systeminstruction'] = 'Istruzioni di sistema';
$string['action:explain_text:systeminstruction_help'] = 'Queste istruzioni vengono inviate al modello di intelligenza artificiale insieme al prompt dell\'utente. Si sconsiglia di modificare queste istruzioni, a meno che non sia assolutamente necessario.';
$string['action:generate_text:endpoint'] = 'Endpoint API';
$string['action:generate_text:model'] = 'Modello IA';
$string['action:generate_text:model_help'] = 'Il modello utilizzato per generare le risposte testuali.';
$string['action:generate_text:systeminstruction'] = 'Istruzioni di sistema';
$string['action:generate_text:systeminstruction_help'] = 'Queste istruzioni vengono inviate al modello di intelligenza artificiale insieme al prompt dell\'utente. Si sconsiglia di modificare queste istruzioni, a meno che non sia assolutamente necessario.';
$string['action:summarise_text:endpoint'] = 'Endpoint API';
$string['action:summarise_text:model'] = 'Modello IA';
$string['action:summarise_text:model_help'] = 'Il modello utilizzato per riassumere il testo fornito.';
$string['action:summarise_text:systeminstruction'] = 'Istruzioni di sistema';
$string['action:summarise_text:systeminstruction_help'] = 'Queste istruzioni vengono inviate al modello di intelligenza artificiale insieme al prompt dell\'utente. Si sconsiglia di modificare queste istruzioni, a meno che non sia assolutamente necessario.';
$string['apikey'] = 'Chiave API DeepSeek';
$string['apikey_help'] = 'È possibile prelevare una chiave dalle <a href="https://platform.deepseek.com/api_keys" target="_blank">chiavi API DeepSeek</a>.';
$string['custom_model_name'] = 'Nome del modello personalizzato';
$string['extraparams'] = 'Parametri extra';
$string['extraparams_help'] = 'È possibile configurare parametri aggiuntivi in formato JSON. Ad esempio:
<pre>
{
    "temperature": 0.5,
    "max_tokens": 100
}
</pre>';
$string['invalidjson'] = 'Stringa JSON non valida';
$string['pluginname'] = 'Provider API DeepSeek';
$string['privacy:metadata'] = 'Il plugin provider API DeepSeek non memorizza dati personali.';
$string['privacy:metadata:aiprovider_deepseek:externalpurpose'] = 'Queste informazioni vengono inviate all\'API DeepSeek per generare una risposta. Le impostazioni dell0account DeepSeek potrebbero modificare il modo in cui DeepSeek archivia e conserva questi dati. Nessun dato utente viene inviato esplicitamente a DeepSeek o archiviato in Moodle LMS da questo plugin.';
$string['privacy:metadata:aiprovider_deepseek:model'] = 'Modello utilizzato per generare la risposta.';
$string['privacy:metadata:aiprovider_deepseek:prompttext'] = 'Prompt di testo inserito dall\'utente utilizzato per generare la risposta.';
$string['settings'] = 'Impostazioni';
$string['settings_frequency_penalty'] = 'frequency_penalty';
$string['settings_frequency_penalty_help'] = 'Numero compreso tra -2,0 e 2,0. I valori positivi penalizzano i nuovi token in base alla loro frequenza nel testo fino a quel momento, riducendo la probabilità che il modello ripeta la stessa riga alla lettera.';
$string['settings_help'] = 'Regolare le impostazioni seguenti per personalizzare il modo in cui le richieste vengono inviate a DeepSeek.';
$string['settings_logprobs'] = 'logprobs';
$string['settings_logprobs_help'] = 'Specifica se restituire o meno le probabilità logaritmiche dei token di output. Se true, restituisce le probabilità logaritmiche di ciascun token di output restituito nel contenuto del messaggio.';
$string['settings_logprobs_label'] = 'Abilita';
$string['settings_max_tokens'] = 'max_tokens';
$string['settings_max_tokens_help'] = 'Numero intero compreso tra 1 e 8192. Numero massimo di token che possono essere generati nel completamento della chat. La lunghezza totale dei token di input e dei token generati è limitata dalla lunghezza del contesto del modello. Se max_tokens non è specificato, viene utilizzato il valore predefinito 4096.';
$string['settings_presence_penalty'] = 'presence_penalty';
$string['settings_presence_penalty_help'] = 'Numero compreso tra -2,0 e 2,0. I valori positivi penalizzano i nuovi token in base alla loro presenza nel testo, aumentando la probabilità che il modello tratti nuovi argomenti.';
$string['settings_temperature'] = 'temperatura';
$string['settings_temperature_help'] = 'Quale temperatura di campionamento utilizzare, tra 0 e 2. Valori più alti come 0,8 renderanno l\'output più casuale, mentre valori più bassi come 0,2 lo renderanno più mirato e deterministico. In genere consigliamo di modificare questo parametro o top_p, ma non entrambi.';
$string['settings_top_logprobs'] = 'top_logprobs';
$string['settings_top_logprobs_help'] = 'Un numero intero compreso tra 0 e 20 che specifica il numero di token con maggiore probabilità di essere restituiti in ogni posizione del token, ciascuno con una probabilità logaritmica associata. logprobs deve essere impostato su true se si utilizza questo parametro.';
$string['settings_top_p'] = 'op_p';
$string['settings_top_p_help'] = 'Un\'alternativa al campionamento con temperatura, chiamata campionamento del nucleo, in cui il modello considera i risultati dei token con massa di probabilità top_p. Quindi 0,1 significa che vengono considerati solo i token che comprendono la massa di probabilità più alta del 10%. Generalmente consigliamo di modificare questo parametro o la temperatura, ma non entrambi.';
