<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grouptool', language 'zh_cn', version '5.1'.
 *
 * @package     grouptool
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activated_group'] = '可注册的组';
$string['activated_groups'] = '可注册的组！';
$string['active'] = '激活';
$string['activegroups'] = '激活组';
$string['add_member'] = '添加 <strong>{$a->username}</strong>  到 <strong>{$a->groupname}</strong> 组';
$string['added_member'] = '已将 <strong>{$a->username}</strong>  添加到 <strong>{$a->groupname}</strong> 组';
$string['administration'] = '管理';
$string['administration_alt'] = '分组及可用组设置';
$string['agroups'] = '激活组';
$string['ajax_edit_size_help'] = '保存新的大小，使用 &lt;Enter&gt;, use &lt;ESC&gt; 如果要放弃，保持为空来删除个数';
$string['all_groups_full'] = '因为全部组都已满员，所以 <strong>{$a}</strong>  无法注册。';
$string['allow_multiple'] = '多重注册';
$string['allow_multiple_help'] = '允许学生同时注册多个组。你需要指定学生至少要选择多少个组（等于指定的最小组数量）和最多注册多少个组（等于指定的最大组数量）';
$string['allow_reg'] = '允许自行注册';
$string['allow_reg_help'] = '允许学生自行注册以便学生能自己在下面选择并注册到想加入的已激活组。';
$string['allow_unreg'] = '允许退组';
$string['allow_unreg_help'] = '在截止日期前（可选），允许学生自行退组或改变注册的组。';
$string['allowed'] = '允许的';
$string['already_marked'] = '这个组已经标记为可以注册';
$string['already_member'] = '<strong>{$a->username}</strong> 已经加入了<strong>{$a->groupname}</strong> 组';
$string['already_occupied'] = ' <strong>{$a->grpname}</strong> 组已经满员了，因为有其他人注册并占用了可用位置，看看其他组还有没有机会吧。';
$string['already_queued'] = '<strong>{$a->username}</strong> 已在列入 <strong>{$a->groupname}</strong>组的候补队伍中。';
$string['already_registered'] = '<strong>{$a->username}</strong> 已经在 <strong>{$a->groupname}</strong>组里注册过了。';
$string['alwaysshowdescription'] = '始终显示说明';
$string['alwaysshowdescription_help'] = '如果禁用，上面的分配说明仅在注册开始后学生才可以看见。';
$string['asterisk_marks_moodle_registrations'] = '用户有(*)标记的，已经在相应的Moodle-Group组里注册了。';
$string['availabledate'] = '注册开始日期';
$string['availabledate_help'] = '注册开始日期。在此日期后学生才能注册到选择的组里（如果允许）';
$string['availabledateno'] = '始终可用';
$string['calendaravailable'] = '{$a} 个注册已开放了';
$string['calendardue'] = '{$a} 个注册已到期了';
$string['cant_enrol'] = '课程内无法自动同意用户加入。';
$string['cfg_addinstanceset_head'] = '其他设置';
$string['cfg_addinstanceset_head_info'] = '分组工具 的其他设置';
$string['cfg_admin_head'] = '查看管理的默认设置';
$string['cfg_admin_head_info'] = '分组工具 视图上管理栏的标准设置';
$string['cfg_allow_multiple'] = '多重注册';
$string['cfg_allow_multiple_desc'] = '默认允许学生同时注册多个组。';
$string['cfg_allow_reg'] = '允许自行注册';
$string['cfg_allow_reg_desc'] = '默认允许学生注册他们自己';
$string['cfg_allow_unreg'] = '允许退组';
$string['cfg_allow_unreg_desc'] = '用户可以退组并且改变想加入的组吗？';
$string['cfg_choose_max'] = '选择最大值';
$string['cfg_choose_max_desc'] = '用户同时可以注册的组的最大数量';
$string['cfg_choose_min'] = '选择最小值';
$string['cfg_choose_min_desc'] = '用户必须注册组的最少数量';
$string['cfg_force_dereg'] = '在 分组工具 里强制退组';
$string['cfg_force_dereg_desc'] = '强制退组不仅仅在 分组工具 中生效，同时会退出moodle的组。';
$string['cfg_force_importreg'] = '在 分组工具 里强制退组';
$string['cfg_force_importreg_desc'] = '通过 分组工具 强制将从 Moodle 群组导入的用户也强制注册到 分组工具 实例中。';
$string['cfg_groups_queues_limit'] = '每个组的队列数量';
$string['cfg_groups_queues_limit_desc'] = '默认有多少个学生可以同时处于候补队列中';
$string['cfg_grpsize'] = '全局组容量大小';
$string['cfg_grpsize_desc'] = '在 分组工具 中每个组的默认容量大小';
$string['cfg_ifgroupdeleted'] = '如果组被删除';
$string['cfg_ifgroupdeleted_desc'] = '是否应该为 分组工具 实例重新创建已删除的组，还是直接删除 分组工具 中对这些组的所有引用（包括组数据、注册和队列）？ 注意：如果你选择"重新创建群组"，那么在"课程管理/用户/群组"下删除后，这些群组将自动重建。';
$string['cfg_ifmemberadded'] = '如果增加了组成员';
$string['cfg_ifmemberadded_desc'] = '在moodle组中新增加的组成员，是注册到grouptool的组里，还是忽略掉？';
$string['cfg_ifmemberremoved'] = '如果删除了组成员';
$string['cfg_ifmemberremoved_desc'] = '如果moodle组里的成员被删除后，是否从grouptool的注册组中删除？';
$string['cfg_immediate_reg'] = '注册立即生效';
$string['cfg_immediate_reg_desc'] = '每个注册是不是需要及时更新到moodle的组里？';
$string['cfg_importfields'] = '比较字段内容来决定导入/注销';
$string['cfg_importfields_desc'] = '定义在导入/注销用户时要与数据进行比较的用户表中的字段。这些字段会依次查找，直到找到唯一匹配项为止。可能/有用的值例如：username、idnumber、email。 注意事项：没有检查字段名称是否正确。允许使用的字符：a-z、A-Z 和 \',\'。';
$string['cfg_instance_head'] = '默认实例设置';
$string['cfg_instance_head_info'] = '新建实例时的默认设置';
$string['cfg_max_queues'] = '每个参与者同时允许的最大队列位置数量';
$string['cfg_max_queues_desc'] = '决定一个用户在默认情况下可以同时在多少个不同的群组的候补队列中。';
$string['cfg_moodlesync_head'] = '同步行为';
$string['cfg_moodlesync_head_info'] = '决定在moodle组成员变化或单个组被删除后，grouptool应该怎么做';
$string['cfg_name_scheme'] = '标准命名方案';
$string['cfg_name_scheme_desc'] = '在生成组时使用的标准命名方案';
$string['cfg_show_add_info'] = '在自行注册时显示相关组的额外信息';
$string['cfg_show_add_info_desc'] = '在注册表单里显示moodle组的额外信息，如说明或图片';
$string['cfg_show_members'] = '显示组成员';
$string['cfg_show_members_desc'] = '决定组成员默认是否可见';
$string['cfg_use_individual'] = '使用单个大小';
$string['cfg_use_individual_desc'] = '是否应为每个小组默认使用其各自的大小';
$string['cfg_use_queue'] = '使用队列';
$string['cfg_use_queue_desc'] = '默认在组满员时，是否使用队列注册候补人员';
$string['cfg_use_size'] = '使用组大小';
$string['cfg_use_size_desc'] = '默认组的大小是否有限制';
$string['cfg_users_queues_limit'] = '每个用户在队列中的位置数量';
$string['cfg_users_queues_limit_desc'] = '决定用户默认可以同时在多少个不同的组里排队。';
$string['change_group'] = '改变组';
$string['change_group_to'] = '继续改变组到 <strong>{$a->groupname}</strong> 吗？';
$string['change_group_to_success'] = '改变组成功。 <strong>{$a->username}</strong>  现已注册到 <strong>{$a->groupname}</strong> 组。';
$string['changes_saved'] = '变化已保存';
$string['checkbox_control_header'] = '选择/反选组和分组';
$string['checkbox_control_header_help'] = '<p>通过使用此功能，您可以在分组工具中激活或停用一个或多个分组：<ol><li>在多选字段中 "全部" （所有可用组都会被激活或停用），一个分组或多个分组（使用分组旁边的小图标和使用 Ctrl + Click方式来切换到多选模式）。</li><li>使用下列之一的选项 "选择/取消选择/反选"：<ul><li><b>选择：</b> 选中的组会被激活。</li><li><b>取消选择：</b> 选中的组会被取消选择。 </li><li><b>反选：</b> 所有未被选中的组会被激活。 </li></ul></li><li>点"继续"来确认你的选择。</li></ol></p>';
$string['choose'] = '选择...';
$string['choose_group'] = '必须目标组！';
$string['choose_max'] = '可选组的最大数量';
$string['choose_max_text'] = '你最多可以选择 <strong>{$a}</strong> 个组！';
$string['choose_min'] = '可选组的最小数量';
$string['choose_min_max_text'] = '你要在 <strong>{$a->min}</strong> 到 <strong>{$a->max}</strong> 个组之间选择！';
$string['choose_min_text'] = '你至少要选择 <strong>{$a}</strong> 个组！';
$string['choose_minmax_title'] = '待选择的组';
$string['choose_targetgroup_import'] = '导入到组里';
$string['choose_targetgroup_unregister'] = '从相应的组里取消注册';
$string['chooseactivity'] = '在数据显示前你必须选择一个活动！';
$string['completiondetail:register'] = '注册的组： {$a}';
$string['completionregister'] = '学生必须注册的组：';
$string['condition_prevent_access'] = '当前条件不允许你设置grouptool实例';
$string['confirm_delete'] = '你将要完全删除这个组。这会导致全部组成员众组中不可恢复的删除。确实要继续吗？';
$string['confirm_delete_title'] = '你要要删除这个元素？';
$string['copied_grade_feedback'] = '组评估<br />+提交自： <strong>{$a->student}</strong><br />+评估者： <strong>{$a->teacher}</strong><br />+初始日期时间：<strong>{$a->date}</strong><br />+反馈： <strong>{$a->feedback}</strong>';
$string['copy'] = '复制';
$string['copy_chosen'] = '复制选择';
$string['copy_grade_confirm'] = '继续复制这个成绩？';
$string['copy_grade_overwrite_confirm'] = '继续复制这个成绩？现有以前的成绩会被改写！';
$string['copy_grades_confirm'] = '继续复制这些成绩？';
$string['copy_grades_errors'] = '复制成绩过程中至少出现了一个错误：';
$string['copy_grades_overwrite_confirm'] = '继续复制成绩？现有以前的成绩会被改写！';
$string['copy_grades_success'] = '下面的成绩已成功更新了：';
$string['copy_refgrades_feedback'] = '从组里其他成员中复制参考的成绩和反馈到选择的组';
$string['copygrade'] = '复制成绩';
$string['could_not_add'] = '不能添加 <strong>{$a->username}</strong> 到 <strong>{$a->groupname}</strong>组';
$string['couldnt_move_down'] = '无法下移组';
$string['couldnt_move_up'] = '无法上移组';
$string['createGroups'] = '新建组';
$string['create_1_person_groups'] = '新建1人组';
$string['create_1_person_groups_help'] = '每个选中的用户都生成一个单人组。 除了 # 和 @ 你可以使用下面的符号来替换用户数据：<ul><li>[username] - 用户名</li><li>[firstname] - 名</li><li>[lastname] - 姓</li><li>[idnumber] - 学号</li></ul>如果某些数据缺失，符号会被替换为符号名称XX，此处 XX 代表组号';
$string['create_assign_groupings'] = '新建/配置分组';
$string['create_fromto_groups'] = '新建数量在一定间隔（如从34到89）的组， <strong>不自动分配</strong> 组成员';
$string['create_fromto_groups_help'] = '用变量数字生成组 (如从34 到 89） - 使用这种模式来创建（缺失）组（如组 4，组 5，组 6)。输入你想使用的组名上的限制和数字位数 （如 1, 01, 001, 0001...）。可以使用 "组成员数量 M"定义一个特定的组容量大小。 <strong>不会自动</strong> 分配组成员。';
$string['create_groupings_confirm'] = '按上面预览的结果新建分组？';
$string['create_groupings_confirm_problem'] = '至少出现了一个错误（参考上面的预览）！';
$string['create_groups_confirm'] = '继续如上面预览的情况新建组？';
$string['create_groups_confirm_problem'] = '当尝试基于给定的命名方案新建组时出现了冲突 - 请看预览 - Moodle的组必须有唯一名称。这类冲突可能是因为现有同名的组或者命名方案有语法问题（... 例如，空，缺少 # 符号）。';
$string['create_n_m_groups'] = '为M个成员新建N个组，<strong>不自动分配</strong> 组成员';
$string['create_n_m_groups_help'] = '为 M 个成员新建 N 个组- 按此模式建组需要指定 N 和 M 。如七个有三个成员的组。 <strong>不会自动分配</strong> 组成员。';
$string['createinsertgrouping'] = '添加到分组';
$string['deactivated_group'] = '停用的组';
$string['deactivated_groups'] = '停用了组！';
$string['define_amount_groups'] = '定义组的数量N';
$string['define_amount_groups_help'] = '定义组数 N - 期望的组的数量。 在命名方案中可以指定组使用的方案<ul><li># (会用组号码替换) and</li><li>@ (会用字母替换)</li></ul>再选择用户分配到期望的组。';
$string['define_amount_members'] = '定义组成员的数量M';
$string['define_amount_members_help'] = '定义成员数量 M - 每个组的容量。需要的组的数量会被自动计算。如果选中了阻止太小的组，组成员少于70%的用户会被分流到其他组。';
$string['delete_reference'] = '删除grouptool';
$string['description'] = '说明';
$string['deselect'] = '取消选择';
$string['determinismerror'] = '注册结束日期不能在开始日期前或在过去。';
$string['digits'] = '最小数字位数';
$string['disabled'] = '禁用';
$string['drag'] = '移动';
$string['due'] = 'Grouptool期限';
$string['duedate'] = '注册结束';
$string['duedate_help'] = '注册结束日期。此后学生不能再自行注册，老师可以开始处理候补队列等工作。';
$string['duedateno'] = '无限制日期';
$string['early'] = '早于{$a}';
$string['error_activating_group'] = '组 <strong>{$a->groupid}</strong> 在grouptool  <strong>{$a->grouptoolid}</strong>激活时发生了错误！';
$string['error_at'] = '错误位于';
$string['error_deactivating_group'] = '组 <strong>{$a->groupid}</strong> 在 grouptool <strong>{$a->grouptoolid}</strong>停用时发生了错误！';
$string['error_getting_data'] = '获取组数据时发生了错误！没有错误信息或多于1个错误信息被返回！';
$string['error_saving_new_order'] = '在保存新的顺序时，组 <strong>{$a}</strong>发生了错误';
$string['eventagrpcreated'] = '已新建激活的组';
$string['eventagrpdeleted'] = '已删除激活的组';
$string['eventagrpsupdated'] = '已更新激活的组';
$string['eventdequeuingstarted'] = '开始取消队列';
$string['eventgroupcreationstarted'] = '开始新建组';
$string['eventgroupgraded'] = '组已被评估';
$string['eventgroupingscreated'] = '分组完成';
$string['eventgrouprecreated'] = '已重新建组';
$string['eventoverviewexported'] = '导出总览';
$string['eventqueueentrycreated'] = '新建队列入口';
$string['eventqueueentrydeleted'] = '队列入口已删除';
$string['eventregistrationcreated'] = '忆新建注册';
$string['eventregistrationdeleted'] = '注册已删除';
$string['eventregistrationpushstarted'] = '推送注册已开始';
$string['eventuserimported'] = '用户已导入';
$string['eventuserlistexported'] = '导出用户列表';
$string['eventusermoved'] = '已移动用户';
$string['exceedgroupqueuelimit'] = '超出了组的队列限制！';
$string['exceedgroupsize'] = '超出了组的成员数量限制！';
$string['exceeduserqueuelimit'] = '超出了用户队列数量限制！';
$string['exceeduserreglimit'] = '超出了用户注册限制！';
$string['feedbackplural'] = '反馈';
$string['filters_legend'] = '过滤数据';
$string['filterunoccupied'] = '仅显示有空位的组';
$string['followchanges'] = '跟随变化';
$string['forceregistration'] = '在grouptool强制注册';
$string['forceregistration_help'] = '请注意，分组工具中的组与 Moodle 课程的标准组在本质上存在差异。如果您想将用户同时导入到分组工具的群组和 Moodle 标准群组中，请勾选此复选框。';
$string['found_multiple'] = '发现多个用户不能唯一标识：';
$string['free'] = '自由';
$string['fromgttoerror'] = '结束的值大小必须要等于或大于开始的值';
$string['fullgroup'] = '组已满员';
$string['general_information'] = '一般信息';
$string['general_registration_exception'] = '发生了一个注册意外问题，我们无法确定原因！';
$string['global_userstats'] = '<strong>{$a->users}</strong> 用户中的 <strong>{$a->reg_users}</strong> 个已经注册。 <strong>{$a->notreg_users}</strong> 个用户还没有注册。';
$string['grading'] = '评估';
$string['grading_activity_title'] = '活动';
$string['grading_alt'] = '用来把一个组内成员的成绩复制到同组其他成员的工具，1个组或多个组均可用。';
$string['grading_filter_select_title'] = '组';
$string['grading_filter_select_title_help'] = '选择要使用的组：<ul><li>无冲突 - 全部组，只有1个组成员有所选择活动的成绩</li><li>全部 - 全部组</li><li>"组名" - 仅指定的所选的组</li></ul>';
$string['grading_grouping_select_title'] = '过滤分组';
$string['group_administration'] = '管理组';
$string['group_administration_alt'] = '管理（激活）组和分组';
$string['group_assign_error'] = '无法指定组！';
$string['group_assign_error_prev'] = '不能指定组！';
$string['group_creation'] = '新建组';
$string['group_creation_alt'] = '新建组';
$string['group_creation_failed'] = '新建组失败！';
$string['group_creation_success'] = '成功新建了组！';
$string['group_not_found'] = '在分组工具 <strong>{$a->grouptoolid}</strong>中找不到 <strong>{$a->groupid}</strong> 组！';
$string['group_not_in_grouping'] = '选择的组不是所选择分组的成员';
$string['group_or_member_count'] = '组/成员统计';
$string['group_places'] = '组容量';
$string['group_places_help'] = '字段 组容量 用反斜杠分隔了以下三个信息：首先是组的总名额数，其次是空闲名额的数量，最后是已经被占用的名额数量。';
$string['groupchange_from_non_unique_reg'] = '无法更改组，因为原来的组不是唯一的！';
$string['groupcreation'] = '新建组';
$string['groupcreationmode'] = '模式';
$string['groupfromtodigits'] = '组名中的数字从，到 &amp：';
$string['groupinfo'] = '组信息';
$string['grouping_assign_error'] = '无法成功指定分组：';
$string['grouping_assign_error_prev'] = '不能成功指定分组：';
$string['grouping_assign_success'] = '已成功指定：';
$string['grouping_assign_success_prev'] = '可被成功指定：';
$string['grouping_creation_error'] = '无法新建分组！';
$string['grouping_creation_error_prev'] = '不能新建分组！';
$string['grouping_creation_only_success'] = '分组已成功新建！';
$string['grouping_creation_only_success_prev'] = '分组可成功新建！';
$string['grouping_creation_success'] = '成功新建了分组并把它指定给了 <strong>{$a}</strong> 组！';
$string['grouping_creation_success_prev'] = '可成功新建分组并把它指定给了 <strong>{$a}</strong> 组！';
$string['grouping_exists_error'] = '无法新建分组，因为已有同名分组存在！';
$string['grouping_exists_error_prev'] = '不能新建分组，因为已有同名分组存在！';
$string['groupings_created_and_groups_added'] = '分组已新建，组已添加！';
$string['groupingscreation'] = '新建和指定分组';
$string['groupingselect'] = '选择组的分组';
$string['groupingselect_help'] = '新建选中组的分组：<ul><li>为所选择的组新建单个分组。分组名称可自由选择。</li><li>为每个选择中的组新建分组。分组名称跟随相应的组。</li><li>添加所选的组到已有分组</li></ul>';
$string['groupoverview'] = '组信息总览';
$string['groups_created'] = '成功新建了组！';
$string['groups_queues_limit'] = '每个组的队列容量';
$string['groups_queues_limit_help'] = '如果激活了，每个组的队列容量限制';
$string['groupselection'] = '选择的组';
$string['groupselection_help'] = '选择希望为其复制选定评分和反馈的组/人员，方法是激活相应的复选框。如果仅显示一个组，则使用该条目右侧的相应按钮来选择要复制的评分源。';
$string['groupsize'] = '组容量';
$string['groupsize_gets_enabled'] = '若继续，组容量将会自动启用。阻止其生效的方法是指定 <strong>{$a->field}</strong>字段值为0';
$string['groupsize_individual_gets_enabled'] = '若继续，各个组的容量将自动启用。阻止其生效的方法是指定<strong>{$a->field}</strong>  完全不要使用组容量值或使用<strong>{$a->globalsize}</strong> 全局值来启用全局值。';
$string['groupstatus'] = '状态';
$string['groupstatus_help'] = '当前组的状态用颜色标识：<ul><li>绿色 - 激活的组。该组已分配给这个分组工具。如果允许自行注册，学生可以注册到这个组。</li><li>灰 - 停用的组。 这类组在此分组工具中不可用。</li></ul>单击颜色符号可改变状态。';
$string['grouptool'] = '分组工具';
$string['grouptool:addinstance'] = '添加分组工具实例到课程';
$string['grouptool:administrate_groups'] = '管理（激活）组和分组';
$string['grouptool:create_groupings'] = '使用分组工具新建分组。';
$string['grouptool:create_groups'] = '使用分组工具新建组！';
$string['grouptool:export'] = '以不同格式导出组和注册数据';
$string['grouptool:grade'] = '从一个组成员复制成绩到组内其他成员';
$string['grouptool:grade_own_group'] = '从一个组成员复制成绩到组内其他成员，如果原始成绩并非本人所给';
$string['grouptool:move_students'] = '移动学生到其他组。';
$string['grouptool:register'] = '使用分组工具注册自己到一个激活的组';
$string['grouptool:register_students'] = '使用分组工具注册学生到一个激活的组。（同时用于候补队列）';
$string['grouptool:unregister_students'] = '使用分组工具取消学生的注册。';
$string['grouptool:view_description'] = '查看分组工具说明';
$string['grouptool:view_groups'] = '查看激活的组';
$string['grouptool:view_own_registration'] = '查看拥有的注册信息。';
$string['grouptool:view_registrations'] = '使用分组工具查看某人在某个激活组的已注册/候补信息';
$string['grouptool:view_regs_course_overview'] = '使用分组工具查看激活组里包含已注册/候补信息的用户清单。';
$string['grouptool:view_regs_course_view'] = '使用分组工具查看包含激活组里已注册/候补信息的用户清单。';
$string['grouptool:view_regs_group_overview'] = '使用分组工具查看激活组里包含已注册/候补信息的组清单。';
$string['grouptool:view_regs_group_view'] = '使用分组工具查看激活组里包含已注册/候补信息的组清单。';
$string['grouptoolfieldset'] = '实例设置';
$string['grouptoolname'] = '分组工具名称';
$string['grouptoolname_help'] = '分组工具实例的名称';
$string['groupuser_import'] = '导入组用户';
$string['groupuser_unregister'] = '取消组用户注册';
$string['grp_marked'] = '为注册标记';
$string['grpsizezeroerror'] = '组容量必须 等于或大于1。其他都不行。';
$string['ifgroupdeleted'] = '如果组被删除';
$string['ifgroupdeleted_help'] = '如果在分组工具实例中删除了某个组，是否应该自动重新创建该组，或者直接删除它在grouptool中的所有引用（包括额外的组数据、注册信息和队列）？注意：如果你选择"重建组"，那么在"课程管理 / 用户 / 组"下，删除后的组将会被自动重建。';
$string['ifmemberadded'] = '如果组成员被添加';
$string['ifmemberadded_help'] = '通过moodle添加的新的组成员应该同时注册到分组工具的组内，还是忽略掉？';
$string['ifmemberremoved'] = '如果组成员被删除';
$string['ifmemberremoved_help'] = '用户若从对应的moodle组里删除，分组工具对应组的相关注册信息是不是应该删除';
$string['ignorechanges'] = '忽略改变';
$string['ignored_not_found_users'] = '至少有一个用户未能添加到组里！';
$string['ignored_not_found_users_unregister'] = '至少有一个用户未被找到！';
$string['ignoring_not_found_users'] = '至少有一个用户没有在数据库里找到，这些用户都会被忽略。';
$string['immediate_reg'] = '注册立即生效';
$string['immediate_reg_help'] = '如启用，注册（取消）会跟随moodle系统。如果未启用，注册（取消）则处理分组工具的缓存中，可以被教师推送到moodle系统里。';
$string['import'] = '导入';
$string['import_conflict_user_queued'] = '用户 <strong>{$a->fullname}</strong> 已经在 <strong>{$a->groupname}</strong>组的候补队列当中！';
$string['import_desc'] = '通过 ID-numbers的清单导入用户到特定的组里';
$string['import_in_inactive_group_rejected'] = '分组工具中针对组 <strong>{$a}</strong> 注册被退回，因为组未被激活。使用分组工具激活该组来允许注册。';
$string['import_in_inactive_group_warning'] = '注意：组 <strong>{$a}</strong> 当前在分组工具中处于未激活状态，因此不会被显示出来。';
$string['import_progress_completed'] = '导入结束';
$string['import_progress_import'] = '导入用户';
$string['import_progress_preview_completed'] = '导入预览已结束';
$string['import_progress_search'] = '查找用户';
$string['import_progress_start'] = '开始导入';
$string['import_skipped'] = '为组 <strong>{$a->groupname}</strong>跳过用户 <strong>{$a->fullname}</strong> ！';
$string['import_user'] = '在组 <strong>{$a->groupname}</strong>导入 <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>)  成功。';
$string['import_user_prev'] = '在组 <strong>{$a->groupname}</strong>导入 <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>)  成功。';
$string['import_user_problem'] = '在组 <strong>{$a->groupname}</strong>里导入 <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong> - <strong>{$a->id}</strong>)的过程中的问题。';
$string['importbutton'] = '导入用户';
$string['inactive'] = '未激活';
$string['inactivegroups'] = '未激活的组';
$string['inactivegroups_hide'] = '隐藏未激活的组';
$string['inactivegroups_show'] = '显示未激活的组';
$string['includedeleted'] = '包括删除的用户';
$string['includedeleted_help'] = '如果选中，删除的用户不会在清单中被过滤掉。已删除的用户在导入过程中不会被加入课程中。';
$string['includeonlyactiveenrol'] = '仅包括有效的注册';
$string['includeonlyactiveenrol_help'] = '如果允许，被停用的用户不会包括在组里。';
$string['incomplete_only_label'] = '仅显示缺失成绩的组';
$string['incorrect_tab'] = '不正确的表格，这个表格有误！';
$string['individual_size_info'] = '* 分组工具的组容量设置';
$string['intro'] = '说明';
$string['invert'] = '反选';
$string['landscape'] = '横向';
$string['late'] = '{$a} 后';
$string['limit'] = '限制';
$string['loading'] = '加载...';
$string['manage_members'] = '管理成员';
$string['max_queues_reached'] = '已到最大队列容量值！';
$string['max_regs_reached'] = '已到最大允许注册值！';
$string['maxmembers'] = '全部组容量大小';
$string['messageprovider:grouptool_moveupreg'] = '在队列中前移来注册';
$string['missing_source_selection'] = '未选择源！';
$string['modulename'] = '分组工具';
$string['modulename_help'] = '分组工具可处理多种与组有关的任务：<ul><li>它允许以不同模式创建群组（群组数量/群组成员数量、单人组、群组间隔）以及每个群组的分组。</li><li>此外，它还可以让学生在规定时间内自行注册到特定群组。</li><li>该模块还具有群组评分功能，即从一个群组成员复制活动成绩到其他群组成员。</li><li>通过 ID 号列表将用户导入群组</li><li>对每个课程群组进行概览，包括所有注册信息、成员、队列等，并且能够将这些数据导出为不同的文件格式（PDF/XLSX/ODS/TXT）。</li><li>可导出的课程用户列表，包括他们的注册信息、队列等。</li></ul><p>(!) 请注意，群组工具中的群组与课程中的 Moodle 标准群组有本质区别。为确保群组类型的一致性，请将"Moodle 变更行为"部分的参数设置为"跟随变更"。</p>';
$string['modulenameplural'] = '分组工具';
$string['moodlesync'] = '在moodle中有关变化的应对方式';
$string['moodlesync_help'] = '如果moodle组成员发生变动或单个组被删除，分组工具应该如何应对';
$string['moreregsthanpossible'] = '完成所需的注册数量不能高于允许的最大注册数量。';
$string['move'] = '移动';
$string['move_help'] = '[Missing langstring text]';
$string['move_user'] = '从候补队列中移动到组中';
$string['movedown'] = '向上移动1个';
$string['moveup'] = '向下移动1个';
$string['multiple'] = '管理组用户';
$string['multiple_desc'] = '多重注册/取消';
$string['must_specify_groupingname'] = '需要提供分组的名称！';
$string['mustbegt0'] = '选择的最小分组数量必须大于或等于 0。不允许输入字母或其他符号。';
$string['mustbegtoeqmin'] = '必须大于或等于最小值';
$string['mustbeposint'] = '选择的最大分组数量必须大于或等于1。不允许输入字母或其他符号。';
$string['mygroups_only_label'] = '仅显示本人评分的源入口';
$string['myoverview_registrations_missing'] = '注册缺失';
$string['name_scheme_tags'] = '<span class="tag firstname">[firstname]</span>
<span class="tag lastname">[lastname]</span>
<span class="tag idnumber">[idnumber]</span>
<span class="tag username">[username]</span>
<span class="tag alpha">@</span>
<span class="tag number">#</span>';
$string['nameschemenotunique'] = '这个命名方案指定的组名不唯一 （<strong>{$a}</strong>）。 请选择其他名称或使用 # （数字索引） or @ （字母索引） 来新建唯一的组名。';
$string['namingscheme'] = '命名方案';
$string['namingscheme_help'] = '<p>命名方案定义了新建组时如何自动命名。</p><p>请注意：<br /><ol><li>组名在课程里必须唯一。 </li><li>如果一次要新建多个组，必须使用 tags 来生成唯一名称。 </li></ol></p><p>每个 tags 会被自动替换。 tags 在[] 的，与用户数据关联， # 和 @ 会被替换为组的序数。 如果允许了JavaScript，简单点击 tags 来添加它们到命名方案中。 请注意组名在每个课程中必须唯一并且因此你可能需要修改命名方案直到命名不会冲突。</p>';
$string['no_active_groups'] = '没有激活的组';
$string['no_conflictfree_to_display'] = '没有限制冲突的组要显示，因此显示全部的组。';
$string['no_data_to_display'] = '没有组数据用于显示！';
$string['no_grades_present'] = '没有成绩显示';
$string['no_groupmembers_to_display'] = '没有组成员可供显示，因此显示全部的组。';
$string['no_groups_to_display'] = '没有组可显示！';
$string['no_queues_to_resolve'] = '当前没有队列需要解决！';
$string['no_registrations'] = '没有注册';
$string['no_target_selected'] = '选择的复制操作没有目标，至少要选择一个目标。';
$string['no_users_to_display'] = '没有用户可显示！';
$string['noaccess'] = '你不能操作这个模块（可能你不属于有权限的组）。';
$string['nobody_queued'] = '没有人在候补';
$string['nodeletion'] = '删除这个组被禁用了，因为本课程中至少有一个分组工具实例被设置为该组被删除时要重建。';
$string['nogroupingselected'] = '没有选择分组。';
$string['nogroups'] = '这个课程里没有组。';
$string['nogroupsactive'] = '分组工具中没有激活的组。';
$string['nogroupschoose'] = '选择组';
$string['nogroupscreate'] = '新建组';
$string['nogroupsgrouping'] = '没有组在这个分组中。';
$string['nogroupsinactive'] = '本分组工具中没有激活的组。';
$string['nogrouptools'] = '没有分组工具！';
$string['nonconflicting'] = '没有冲突';
$string['noregistrationdue'] = '无限';
$string['nosmallgroups'] = '阻止小组';
$string['nosmallgroups_help'] = '如果启用，确保每个组至少达到其70%的组容量。如果有一个或多个组未能达到这个标准，这些组内的成员将被分流到其他超过这个要求的组。';
$string['not_allowed_to_show_members'] = '你没有权限查看这些信息。';
$string['not_graded_by_me'] = '已被他人评分';
$string['not_in_queue_or_registered'] = '<strong>{$a->username}</strong> 既没有在组 <strong>{$a->groupname}</strong>中注册成功也不在其候补队列中';
$string['not_permitted'] = '未被允许';
$string['not_registered'] = '你还没有注册！';
$string['not_synced_reg_present'] = '未与当前注册信息同步';
$string['notenoughregs'] = '用户需要更多的注册！';
$string['nothing_to_push'] = '没有数据要推送！';
$string['notification:group_recreated'] = '组 <a href="{$a->groupurl}" 名称为"{$a->groupname}">{$a->groupname}</a> 已经被分组工具 <a href="{$a->grouptoolurl}" 名称为"{$a->grouptoolname}">{$a->grouptoolname}</a> 重建因为它被设置成重建被删除的组。';
$string['notification:registrations_recreated'] = '组 <a href="{$a->groupurl}" 名称为"{$a->groupname}">{$a->groupname}</a> 的成员已被再次添加，因为分组工具 <a href="{$a->grouptoolurl}" 名称为"{$a->grouptoolname}">$a->grouptoolname}</a> 被设置成重建删除的组。这个组忆被其他分组工具所重建。';
$string['nowhere_queued'] = '没有候补队列';
$string['number_of_groups'] = '组的数量N';
$string['number_of_members'] = '组的数量M';
$string['number_of_students'] = '学生数量';
$string['occupied'] = '已占用';
$string['onenewgrouping'] = '在一个新的分组';
$string['onenewgroupingpergroup'] = '一个组一个分组';
$string['open_group_message'] = '打开组消息';
$string['orientation'] = 'PDF-orientation';
$string['outdated'] = '偏离';
$string['overflowwarning'] = '如果继续导入，实例 <strong>{$a->instancename}</strong> 中的组容量大小将会超限！';
$string['overview'] = '总览';
$string['overview_alt'] = '组及组成员总览';
$string['overview_tab'] = '组视图';
$string['overview_tab_alt'] = '打开组视图';
$string['overwrite_label'] = '重写已有的成绩';
$string['place_allocated_in_group_success'] = '组 <strong>{$a->groupname}</strong> 已经成功被标记为可以注册';
$string['places'] = '位置';
$string['pluginadministration'] = '分组工具管理';
$string['pluginname'] = '分组工具';
$string['portrait'] = '竖向';
$string['preview'] = '预览';
$string['privacy:metadata:agrpid'] = '在分组工具中代表moodle的组标识';
$string['privacy:metadata:enrolexplanation'] = '分组工具在导入过程中会自动为未注册该课程的用户进行注册，以便能够将他们添加到要导入的目标组中。';
$string['privacy:metadata:gradesexplanation'] = '分组工具可以把一个成员的成绩复制到同组其他成员。';
$string['privacy:metadata:groupexplanation'] = '分组工具用来管理moodle的组。';
$string['privacy:metadata:messageexplanation'] = '分组工具发送消息给即将被注册的候补队列用户。';
$string['privacy:metadata:mod_grouptool_group_filter'] = '要过滤的组有哪些？';
$string['privacy:metadata:mod_grouptool_mygroups_only'] = '只考虑/显示本人所在组';
$string['privacy:metadata:modified_by'] = '如果被人修改，标识被修改的用户。';
$string['privacy:metadata:queued'] = '包括全部候补队列用户。';
$string['privacy:metadata:registered'] = '包括已注册的用户和标记为注册的用户。';
$string['privacy:metadata:timestamp'] = '记录最后修改的时间与日期。';
$string['privacy:metadata:userid'] = '用户标识符。';
$string['queue'] = '队列';
$string['queue_and_multiple_reg_title'] = '队列及多重注册';
$string['queue_in_group'] = '继续把 <strong>{$a->username}</strong> 放在 <strong>{$a->groupname}</strong>组的候补队列中？';
$string['queue_in_group_success'] = '成功将 <strong>{$a->username}</strong> 放入<strong>{$a->groupname}</strong>组的候补队列中！';
$string['queue_places'] = '排队数量';
$string['queue_you_in_group'] = '继续把你放在 <strong>{$a->groupname}</strong>组中排队？';
$string['queue_you_in_group_success'] = '已为你在 <strong>{$a->groupname}</strong>组中成功排队！';
$string['queued'] = '已排队';
$string['queued_in_group_info'] = '<strong>{$a->username}</strong> 已在 <strong>{$a->groupname}</strong>组的候补队列中';
$string['queued_on_rank'] = '排队顺序 #{$a}';
$string['queueing_is'] = '排队队列是';
$string['queues'] = '队列';
$string['queues_max'] = '每个人同时排队最大数量';
$string['queuesgrp'] = '队列及最大容量';
$string['queuesgrp_help'] = '如果允许候补队列，试图在满员的组里注册的学生，会在候补队列中按顺序排队直到同组中其他人取消注册。注册期限后，教师可以将学生移动其他组如果他们仍在队列中，按组清单的顺序添加到对应的组中。你应该定义一个用户能够进行候补的组的最大数量。<br />在此分组工具中限制每个人的最大排队入口数量。';
$string['queuesizeerror'] = '队列容量必须为整数且大于等于0。字母和其他符号不被允许。';
$string['queuespresent'] = '当前有队列，继续的话队列会被删除。若要继续，请再次单击保存。';
$string['queuespresenterror'] = '队列中有用户候补，处理完成前不能取消队列。';
$string['rank'] = '排名';
$string['recreate_group'] = '重建组';
$string['reference_grade_feedback'] = '参考评分/反馈';
$string['refresh_table_button'] = '刷新预览';
$string['reg_in_full_group'] = '无法将 <strong>{$a->username}</strong> 注册到<strong>{$a->groupname}</strong> 组，因为组已满员。';
$string['reg_not_open'] = '当前无法注册。可能是因为注册期限已过或现在未被允许注册。';
$string['reg_you_in_full_group'] = '无法在 <strong>{$a->groupname}</strong> 组中注册，因为组满员了。';
$string['register'] = '注册';
$string['register_in_group'] = '确定要将 <strong>{$a->username}</strong>  注册于 <strong>{$a->groupname}</strong>组中？';
$string['register_in_group_success'] = '成功将 <strong>{$a->username}</strong> 注册于 <strong>{$a->groupname}</strong>组！';
$string['register_you_in_group'] = '确定要在 <strong>{$a->groupname}</strong>组中注册？';
$string['register_you_in_group_success'] = '成功在 <strong>{$a->groupname}</strong>!组中注册！';
$string['register_you_in_group_successmail'] = '成功在 <strong>{$a->groupname}</strong>!组中注册！';
$string['register_you_in_group_successmailhtml'] = '成功在 <strong>{$a->groupname}</strong>!组中注册！';
$string['registered'] = '注册完成';
$string['registered_in_group_info'] = '{$a->username} 在 <strong>{$a->groupname}</strong> 组中注册完成';
$string['registered_on_rank'] = '在顺序#{$a} 位置注册完成';
$string['registration_details'] = '注册详细信息';
$string['registration_missing'] = '1个注册信息缺失';
$string['registration_period_end'] = '注册结束于';
$string['registration_period_start'] = '注册开始于';
$string['registrationdue'] = '注册结束';
$string['registrationnotification'] = '{$a->course->shortname} -> {$a->modulenameplural} -> {$a->grouptoolname}
----------------------------------------------------------
{$a->message}
----------------------------------------------------------';
$string['registrations'] = '组注册';
$string['registrations_missing'] = '{$a}注册缺失';
$string['regpresent'] = '用户已经{$a}';
$string['rename_failed'] = '重命名字段！';
$string['renamed_group'] = '重命名组！';
$string['report'] = '分组报表';
$string['require_registration'] = '需要注册';
$string['require_registration_help'] = '为标记这个活动为结束，学生需要注册组的最小数量。 注意队列中的数量不在考虑规则之内。如果数值大于1， 需要激活 "多重注册" 并且 "选择组的最大数量" 需要大于或等于这个值';
$string['reset_agrps'] = '重置激活的组';
$string['reset_agrps_help'] = '为分组工具重置课程的全部组为未激活。这也会删除本课程此分组工具下的全部注册和队列信息。';
$string['reset_queues'] = '重置队列';
$string['reset_queues_help'] = '激活的组重置时，队列也会自动删除。';
$string['reset_registrations'] = '重置注册';
$string['reset_registrations_help'] = '如果激活的组被重置，注册信息会被自动删除。';
$string['reset_transparent_unreg'] = '取消所有推送的组成员注册';
$string['reset_transparent_unreg_help'] = '删除所有属于这些活跃的分组工具中的组所关联的用户。';
$string['resize'] = '改变大小';
$string['resized_group'] = '改变组的容量';
$string['resolve_queue'] = '处理候补队列';
$string['resolve_queue_legend'] = '处理候补队列';
$string['resolve_queue_title'] = '处理等待的候补队列';
$string['search:activity'] = '分组工具 - 活动信息';
$string['select'] = '选择';
$string['selected'] = '已选择的';
$string['selectfromcohort'] = '从群中选择成员';
$string['selectfromgroup'] = '从组中选择成员';
$string['selectfromgroup_help'] = '仅把指定组的成员分配到新建组';
$string['selectfromgrouping'] = '从分组中选择成员';
$string['selectfromgrouping_help'] = '仅在指定的组里把成员分配给新建的组';
$string['selectmultiple'] = '选择多个';
$string['selectsingle'] = '选择单个';
$string['selfregistration'] = '注册';
$string['selfregistration_alt'] = '注册一个或多个组（依据设置而定）';
$string['setactive'] = '激活';
$string['setinactive'] = '停用';
$string['settingspage'] = '编辑组设置';
$string['show_members'] = '显示组成员';
$string['show_members_help'] = '允许学生（在特定条件下）看见哪些人在组里已经注册。<br /><li><strong>本人 - 注册结束后：</strong> 在注册结束后显示用户注册的组成员</li><li><strong>本人 - 自行注册后：</strong> 在用户自行注册或被他人注册后显示用户注册的组里的成员</li><li><strong>是：</strong> 显示组成员</li></ul>';
$string['showafterdue'] = '全部 - 注册结束后';
$string['showownafterdue'] = '本人 - 注册结束后';
$string['showownafterreg'] = '本人 - 自行注册后';
$string['size'] = '组容量';
$string['size_grp'] = '组容量设置';
$string['size_grp_help'] = '如果组容量达到了每个组最大的限制（全局限制）。如果激活了单个容量限制选项，每个组的容量可以在下面的列表里设置。';
$string['size_help'] = '显示当前组的容量，如果组容量大小是由各个组自定的。';
$string['skip_user_import'] = '跳过导入';
$string['skipped'] = '跳过';
$string['sortlist_no_data'] = '当前没有组！';
$string['source'] = '源';
$string['source_missing'] = '没有复制源';
$string['sources_missing'] = '至少有1个组没有选择复制源';
$string['start'] = '开始';
$string['status'] = '状态';
$string['status_help'] = '<ul><li><strong>✔</strong> 已在moodle和分组工具中的组注册</li><li><strong>?</strong> 已在Moodle的组中注册但没有在分组工具中的组注册</li><li><strong>+</strong> 在分组工具中的组注册了但没在Moodle的组里</li><li><strong>1, 2, 3...</strong> 分组工具中的候补队列</li></ul>';
$string['successfully_deleted_groups'] = '成功删除了组。';
$string['swapped_groups'] = '已交换组<strong>{$a->a}</strong> (顺序 <strong>{$a->aorder}</strong>) 和 <strong>{$a->b}</strong> (顺序 <strong>{$a->border}</strong>)!';
$string['switched_to_all_groups'] = '在所有组里改变组过滤器';
$string['target'] = '目标';
$string['too_many_queue_places'] = ' <strong>{$a->username}</strong> 无法在 <strong>{$a->groupname}</strong>组中排队，因为 <strong>{$a->username}</strong> 已在太多的组里排队了。';
$string['too_many_regs'] = '用户已注册/排队了太多的组。';
$string['toolessregspresent'] = '至少1个用户注册的组太少，因此选择组至少要达到 {$a}。';
$string['toomanyregs'] = '注意：新的期望组容量至少要指定比组里成员数量更多。<br />如有必要，在改变组容量的时候减少现有组的成员数量。';
$string['toomanyregspresent'] = '至少有1个用户注册了太多的组。因此选择了最大组数量至少要大于{$a}。';
$string['total'] = '合计';
$string['unqueue'] = '从队列中移除';
$string['unqueue_from_group'] = '继续把 <strong>{$a->username}</strong> 从 <strong>{$a->groupname}</strong>组中候补队列中移除？';
$string['unqueue_from_group_success'] = '成功将 <strong>{$a->username}</strong> 从 <strong>{$a->groupname}</strong>组的队列中移除。';
$string['unqueue_you_from_group'] = '继续将你从 <strong>{$a->groupname}</strong>组的队列中移除？';
$string['unqueue_you_from_group_success'] = '成功将你从 <strong>{$a->groupname}</strong>组的队列中移除。';
$string['unreg'] = '取消注册';
$string['unreg_from_group'] = '继续将<strong>{$a->username}</strong> 从 <strong>{$a->groupname}</strong>组中取消注册？';
$string['unreg_from_group_success'] = '成功将<strong>{$a->username}</strong> 从 <strong>{$a->groupname}</strong>组中取消注册。';
$string['unreg_is'] = '取消注册';
$string['unreg_not_allowed'] = '不允许取消注册';
$string['unreg_you_from_group'] = '继续将你从<strong>{$a->groupname}</strong>组中取消注册？';
$string['unreg_you_from_group_success'] = '成功将你从<strong>{$a->groupname}</strong>组中取消注册。';
$string['unregfrommgroups'] = '从分组工具中强制取消注册';
$string['unregfrommgroups_help'] = '取消注册会从分组工具的组和moodle组中移除用户。';
$string['unregister'] = '取消注册';
$string['unregister_conflict_user_not_in_group'] = '用户 <strong>{$a->fullname}</strong> 不在<strong>{$a->groupname}</strong>组中。';
$string['unregister_desc'] = '取消多个用户的注册';
$string['unregister_from_inactive_group_warning'] = '注意： <strong>{$a}</strong> 组在分组工具中是未激活的因此不会被显示。';
$string['unregister_in_inactive_group_warning'] = '注意： <strong>{$a}</strong> 组在分组工具中是未激活的因此不会被显示。';
$string['unregister_progress_completed'] = '取消注册已完成';
$string['unregister_progress_preview_completed'] = '取消注册预览已完成';
$string['unregister_progress_start'] = '开始取消注册';
$string['unregister_progress_unregister'] = '取消注册用户';
$string['unregister_skipped'] = '跳过 <strong>{$a->groupname}</strong>组中的用户 <strong>{$a->fullname}</strong> 。';
$string['unregister_user'] = '成功取消 <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) 在 <strong>{$a->groupname}</strong> 组中的注册。';
$string['unregister_user_from_moodle_group'] = '成功取消 <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) 在moodle组 <strong>{$a->groupname}</strong> 中的注册。';
$string['unregister_user_not_in_group'] = '用户 <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) 不在moodle的 <strong>{$a->groupname}</strong>组里。';
$string['unregister_user_only_in_moodle_group'] = '用户 <strong>{$a->fullname}</strong> 仅在moodle的 <strong>{$a->groupname}</strong> 组里，但不在分组工具的组里。';
$string['unregister_user_prev'] = '取消 <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) 在 <strong>{$a->groupname}</strong>组中的注册。';
$string['unregisterbutton'] = '取消用户注册';
$string['update_grouplist_success'] = '成功更新激活的组。';
$string['updatemdlgrps'] = '在moodle组里注册';
$string['uptodate'] = '最新';
$string['use_all_or_chosen'] = '使用全部或选中的';
$string['use_all_or_chosen_help'] = '选择 "全部l" 来为每个课程的组新建分组。选择 "选中" 只为选中的组新建分组。';
$string['use_individual'] = '为每个组单独设置容量';
$string['use_individual_help'] = '使用单个组容量值覆盖全局容量值 。这可通过底部的有序组列表设置来完成。';
$string['use_queue'] = '使用队列';
$string['use_queue_help'] = '组满员时学生可以使用候补队列。这个设置只能用于允许自行注册且组容量有限制。';
$string['use_size'] = '激活';
$string['user'] = '用户';
$string['user_has_too_less_regs'] = '不能取消注册或排队，因为 <strong>{$a->username}</strong>  注册或排队了太少的组。';
$string['user_is_deleted'] = '找到的用户账号 (ID <strong>{$a->id}</strong>，名字 <strong>{$a->fullname}</strong>) 已经删除。因此不能注册到这个课程。';
$string['user_move_prev'] = '<strong>{$a->user}</strong> 将会从<strong>{$a->from_group}</strong> 的队列 中移到 <strong>{$a->to_group}</strong>组中。';
$string['user_moved'] = '<strong>{$a->user}</strong> 已经从<strong>{$a->from_group}</strong>组的队列中移到了 <strong>{$a->to_group}</strong>组中。';
$string['user_not_found'] = '找不到用户 <strong>{$a}</strong> 。';
$string['userlist'] = '用户清单';
$string['userlist_alt'] = '查看用户清单和注册信息。导出有关数据为 (PDF, plain text, Excel) 等格式。';
$string['userlist_help'] = '列出的 ID-numbers 由一个或多个字符分割 <ul><li>[,] comma</li><li>[;] semicolon</li><li>[ ] space</li><li>[\\n] newline</li><li>[\\r] carriage return</li><li>[\\t] tabulator</li></ul>';
$string['userlist_tab'] = '课程视图';
$string['userlist_tab_alt'] = '打开课程视图';
$string['users_queues_limit'] = '每个用户的排队数量';
$string['users_queues_limit_help'] = '如果激活，限制每个用户的可排队数量';
$string['users_tab'] = '参与者';
$string['users_tab_alt'] = '显示参与者';
$string['view_registrations'] = '查看注册信息';
$string['viewmoodlegroups'] = '至moodle组';
$string['with_selection'] = '选中的...';
$string['you_are_already_marked'] = '标记的 <strong>{$a->groupname}</strong> 组已经开放注册。';
$string['you_are_already_queued'] = '你已经在 <strong>{$a->groupname}</strong>组的候补队列中了。';
$string['you_are_already_registered'] = '你已经在<strong>{$a->groupname}</strong>组中注册了。';
$string['you_are_not_in_queue_or_registered'] = '你在 <strong>{$a->groupname}</strong>组中既没有注册也没有排队';
$string['you_change_group_to_success'] = '成功变组。你现在已在 <strong>{$a->groupname}</strong>组中注册。';
$string['you_have_too_less_regs'] = '无法取消注册或排队，因为你注册或排队的组太少。';
$string['you_have_too_many_queue_places'] = '无法在 <strong>{$a->groupname}</strong> 中排队，因为你已在太多的组中排队了。';
$string['your_place_allocated_in_group_success'] = '成功将 <strong>{$a->groupname}</strong>组设置为可注册';
