<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'nl', version '5.1'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Je kunt een voorbeeld zien van deze test, maar als het een echte test was, zou je geblokkeerd zijn omdat:';
$string['action'] = 'Actie';
$string['activityoverview'] = 'Je hebt testen te voltooien';
$string['adaptive'] = 'Adaptieve modus';
$string['adaptive_help'] = 'Indien ingeschakeld zijn meerder antwoorden op een vraag toegestaan binnen dezelfd poging van een test. Als een antwoord als fout is aangeduid, dan mag de leerling de vraag onmiddellijk opnieuw proberen te beantwoorden. Hoewel, afhankelijk van de "strafpunten geven" instelling, zullen strafpunten afgetrokken worden voor elke foute poging.';
$string['add'] = 'Voeg toe';
$string['addaquestion'] = 'een nieuwe vraag';
$string['addarandomquestion'] = 'een willekeurige vraag';
$string['addarandomquestion_help'] = 'Wanneer een willekeurige vraag wordt toegevoegd, dan resulteert dat in een willekeurig gekozen vraag uit de gekozen categorie die toegevoegd wordt aan de test. Dat betekent dat verschillende leerlingen waarschijnlijk een verschillende set vragen gaan krijgen en wanneer de test meerdere pogingen toelaat, dat elke poging waarschijnlijk een nieuwe selectie vragen zal bevatten.';
$string['addarandomquestion_success'] = 'Er zijn willekeurige vragen toegevoegd';
$string['addarandomselectedquestion'] = 'Voeg een willekeurig gekozen vraag toe..';
$string['addasection'] = 'een nieuwe sectiekop';
$string['adddescriptionlabel'] = 'Een beschrijving/label toevoegen';
$string['addingquestion'] = 'Vraag toevoegen';
$string['addingquestions'] = '<p>Aan deze kant van de pagina kun je je vragenlijst beheren. De vragen worden bewaard per categorie om je te helpen ze te ordenen. Ze kunnen gebruikt worden in elke test van je cursus of zelfs in andere cursussen als je ze wil \'publiceren\'.</p><p>
Pas wanneer je een categorie gekozen of gemaakt hebt, kun je vragen maken of bewerken.
Je kunt gelijk welke van die vragen selecteren om ze toe te voegen aan je test aan de andere kant van deze pagina.<p>';
$string['addmoreoverallfeedbacks'] = 'Voeg {no} feedbackvelden toe';
$string['addnewgroupoverride'] = 'Voeg overschrijving groep toe';
$string['addnewpagesafterselected'] = 'Nieuwe pagina\'s toevoegen na geselecteerde vragen';
$string['addnewquestionsqbank'] = 'Voeg de vragen toe aan de categorie {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Voeg overschrijving gebruiker toe';
$string['addpagebreak'] = 'Voeg een paginascheiding in';
$string['addpagehere'] = 'Voeg hier een pagina toe';
$string['addquestion'] = 'Voeg vraag toe';
$string['addquestionfrombankatend'] = 'Voeg aan het einde toe uit de vragenpool';
$string['addquestionfrombanktopage'] = 'Voeg toe aan pagina {$a} uit de vragenpool';
$string['addquestions'] = 'Voeg vragen toe';
$string['addquestionstoquiz'] = 'Voeg vragen aan de huidige test toe';
$string['addrandom'] = 'Voeg {$a} willekeurige vragen toe';
$string['addrandom1'] = 'Voeg toe';
$string['addrandom2'] = 'willekeurige vragen';
$string['addrandomfromcategory'] = 'Voeg willekeurige vragen uit een categorie toe';
$string['addrandomquestion'] = 'Voeg een willekeurige vraag toe';
$string['addrandomquestionatend'] = 'Voeg aan het einde een willekeurige vraag toe';
$string['addrandomquestiontopage'] = 'Voeg een willekeurige vraag toe op pagina {$a}';
$string['addrandomquestiontoquiz'] = 'Voeg een willekeurig vraag toe aan test {$a}';
$string['addselectedquestionstoquiz'] = 'Voeg geselecteerde vragen toe aan de test';
$string['addselectedtoquiz'] = 'Voeg het geselecteerde toe aan de test';
$string['addtoquiz'] = 'Voeg toe aan test';
$string['affectedstudents'] = 'Leerling {$a}';
$string['aftereachquestion'] = 'Na het toevoegen van elke vraag';
$string['afternquestions'] = 'Na het toevoegen van {$a} vragen';
$string['age'] = 'leeftijd';
$string['allattempts'] = 'Alle pogingen';
$string['allinone'] = 'Onbeperkt';
$string['allowreview'] = 'Sta nalezen toe';
$string['alreadysubmitted'] = 'Waarschijnlijk heb je deze poging al bewaard';
$string['alternativeunits'] = 'Alternatieve eenheden';
$string['alwaysavailable'] = 'Altijd beschikbaar';
$string['alwayslatest'] = 'Altijd laatste';
$string['analysisoptions'] = 'Analyse-opties';
$string['analysistitle'] = 'Vraag analysetabel';
$string['answer'] = 'Antwoord';
$string['answered'] = 'Beantwoord';
$string['answerhowmany'] = 'Eén of meer antwoorden';
$string['answers'] = 'Juiste antwoorden';
$string['answersingleno'] = 'Meer antwoorden toegestaan';
$string['answersingleyes'] = 'Slechts één antwoord';
$string['answertoolong'] = 'Antwoord is te lang na lijn {$a} (maximum 255 tekens)';
$string['anytags'] = 'Alle tags';
$string['aon'] = 'AON-opmaak';
$string['areyousureremoveselected'] = 'Ben je zeker dat je alle geselecteerde vragen wil verwijderen?';
$string['asshownoneditscreen'] = 'Zoals getoond op het bewerkscherm';
$string['attempt'] = 'Poging {$a}';
$string['attemptalreadyclosed'] = 'Deze poging is al beëindigd.';
$string['attemptclosed'] = 'Poging is nog niet gesloten';
$string['attemptduration'] = 'Tijdsduur';
$string['attemptedon'] = 'Poging op';
$string['attempterror'] = 'Je mag deze test nu niet proberen omdat:';
$string['attempterrorcontentchange'] = 'Dit testvoorbeeld bestaat niet meer. (Als een test bewerkt wordt, dan worden automatische alle voorbeelden die bezig zijn verwijderd.)';
$string['attempterrorcontentchangeforuser'] = 'Deze testpoging bestaat niet meer.';
$string['attempterrorinvalid'] = 'Ongeldig testpogingsID';
$string['attemptfirst'] = 'Eerste poging';
$string['attemptgradeddelay'] = 'Vertraging voor het verzenden van meldingen over beoordeelde pogingen';
$string['attemptgradeddelay_desc'] = 'Er wordt een vertraging toegepast voordat de leerling een e-mail krijgt over beoordeelde testpogingen, zodat de leraar tijd heeft om het cijfer nog aan te passen.';
$string['attemptincomplete'] = 'De poging (door {$a}) is nog niet voltooid.';
$string['attemptlast'] = 'Laatste poging';
$string['attemptnumber'] = 'Poging';
$string['attemptquiz'] = 'Poging test';
$string['attemptquiznow'] = 'Start de test nu';
$string['attemptreviewtitle'] = '{$a}: beoordeel poging';
$string['attemptreviewtitlepaged'] = '{$a->name}: beoordeel poging (page{$a->currentpage} van {$ a-> totalpages})';
$string['attempts'] = 'Pogingen';
$string['attempts_help'] = 'Het totale aantal toegestane pogingen (niet het aantal extra pogingen).';
$string['attemptsallowed'] = 'Toegestane pogingen';
$string['attemptsdeleted'] = 'Testpogingen verwijderd';
$string['attemptselection'] = 'Kies welke pogingen per gebruiker je wil analyseren';
$string['attemptsexist'] = 'Je kan niet langer vragen toevoegen of verwijderen';
$string['attemptsnum'] = 'Pogingen: {$a}';
$string['attemptsnumthisgroup'] = 'Pogingen: {$a->total} ({$a->group} van deze groep)';
$string['attemptsnumyourgroups'] = 'Pogingen: {$a->total} ({$a->group} van jouw groepen)';
$string['attemptsonly'] = 'Toon enkel leerlingen met testpogingen';
$string['attemptstate'] = 'Status';
$string['attemptstillinprogress'] = 'Poging nog bezig';
$string['attemptsummarytitle'] = '{$a}: beoordeel samenvatting';
$string['attemptsunlimited'] = 'Onbeperkt aantal pogingen';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (pagina {$a->currentpage} van {$a->totalpages})';
$string['autosaveperiod'] = 'Tijd tussen automatisch bewaren';
$string['autosaveperiod_desc'] = 'De antwoorden van de leerlingen kunnen automatisch bewaard worden tijdens de test. De antwoorden worden bewaard wanneer er iets wijzigt en dan na deze tijd. Het hoe korter de tijd tussen het bewaren van de antwoorden, hoe hoger de belasting op de server, maar hoe kleiner de kans dat leerlingen hun werk verliezen. Als je deze tijd veel korter wil maken, doe dat dan in stapjes en observeer je serverbelasting. Als de server te hoog belast is, zet de waarde dan langer. Als je de waarde op 0 zet, dan wordt er niet automatisch bewaard.';
$string['back'] = 'Terug naar controleer vraag';
$string['backtocourse'] = 'Terug naar cursus';
$string['backtoquestionlist'] = 'Terug naar de vragenlijst';
$string['backtoquiz'] = 'Terug naar het bewerken/wijzigen van de test';
$string['banknotfound'] = 'Vragenpool niet gevonden, probeer opnieuw te zoeken';
$string['bestgrade'] = 'Hoogste cijfer';
$string['bothattempts'] = 'Toon leerlingen met en zonder testpogingen';
$string['browsersecurity'] = 'Browserbeveiliging';
$string['browsersecurity_help'] = 'Wanneer "Popup over het volledige scherm met Javascript-beveiliging" geselecteerd is,
* Zal de test alleen starten als de gebruiker een browser heeft die JavaScript ondersteunt
* Zal de test in een volledig scherm pop-up verschijnen dat alle andere schermen bedekt en geen navigatiecontrole heeft.
* Wordt zoveel mogelijk verhinderd dat leelingen gebruik maken van functies zoals kopiëren en plakken';
$string['cachedef_overrides'] = 'Informatie gebruiker- en groepsoverschrijving';
$string['calculated'] = 'Berekend';
$string['calculatedquestion'] = 'Berekende vraag niet ondersteund op lijn {$a}. De vraag wordt genegeerd.';
$string['cannotcreatepath'] = 'Pad kan niet gemaakt worden ({$a})';
$string['cannoteditafterattempts'] = 'Je kunt geen vragen toevoegen of verwijderen omdat er al pogingen bestaan in deze test. ({$a})';
$string['cannotfindprevattempt'] = 'Kan geen voorgaande poging vinden om verder te zetten.';
$string['cannotfindquestionregard'] = 'Kon vragen niet vinden om opnieuw te beoordelen!';
$string['cannotinsert'] = 'Kan vraag niet invoegen';
$string['cannotinsertrandomquestion'] = 'Kon geen nieuwe willekeurige vraag toevoegen!';
$string['cannotloadquestion'] = 'Kon vraagopties niet laden';
$string['cannotloadtypeinfo'] = 'Kon vraagtypespecifieke informatie niet laden';
$string['cannotopen'] = 'Kan exportbestand niet openen ({$a})';
$string['cannotremoveallsectionslots'] = 'Je hebt alle vragen onder de kop \'{$a}\' geselecteerd. Het is niet toegestaan om alle vragen onder een sectie kop te verwijderen.';
$string['cannotremoveslots'] = 'Kan vragen niet verwijderen';
$string['cannotrestore'] = 'Kon vraagsessies niet terugzetten';
$string['cannotreviewopen'] = 'Je kunt deze poging niet nakijken - ze is nog open';
$string['cannotsavelayout'] = 'Kon opmaak niet bewaren';
$string['cannotsavenumberofquestion'] = 'Kon het aantal vragen per pagina niet bewaren';
$string['cannotsavequestion'] = 'Kon vragenlijst niet bewaren';
$string['cannotsetgrade'] = 'Kon geen nieuw maximum instellen voor de test';
$string['cannotsetsumgrades'] = 'Sumgrades instellen mislukt';
$string['cannotstartgradesmismatch'] = 'Kan geen poging voor deze test starten. De test is ingesteld om op {$a->grade} beoordeeld te worden, maar geen enkele vraag in de test heeft een maximumcijfer. Dit kan op de "Bewerk test" pagina opgelost worden.';
$string['cannotstartmissingquestion'] = 'Kan geen poging voor deze test starten. De test bevat een vraag die niet bestaat.';
$string['cannotstartnoquestions'] = 'Kan de poging voor deze test niet starten. De test is nog niet klaar. Er zijn nog geen vragen toegevoegd.';
$string['cannotwrite'] = 'Kan exportbestand niet wegschrijven ({$a})';
$string['canredoquestions'] = 'Opnieuw doen toestaan binnen een poging';
$string['canredoquestions_desc'] = 'Indien ingeschakeld zullen leerlingen die een bepaalde vraag voltooid hebben een \'Probeer een andere vraag zoals deze\'-knop zien. Hiermee kunnen ze een gelijkaardige, willekeurig gekozen vraag proberen, zonder de hele testpoging te moeten insturen en een nieuwe poging te starten. Deze optie is vooral nuttig voor oefentesten.

Deze instelling is enkel van toepassing voor vragen en vraaggedrag (bijvoorbeeld onmiddellijke feedback of interactief met meerdere pogingen) waar het mogelijk is om een vraag te beëindigen voor de poging is ingestuurd.';
$string['canredoquestions_help'] = 'Indien ingeschakeld zullen leerlingen die een bepaalde vraag voltooid hebben een \'Probeer een andere vraag zoals deze\'-knop zien. Hiermee kunnen ze een gelijkaardige, willekeurig gekozen vraag proberen, zonder de hele testpoging te moeten insturen en een nieuwe poging te starten. Deze optie is vooral nuttig voor oefentesten.

Deze instelling is enkel van toepassing voor vragen en vraaggedrag (bijvoorbeeld onmiddellijke feedback of interactief met meerdere pogingen) waar het mogelijk is om een vraag te beëindigen voor de poging is ingestuurd.';
$string['canredoquestionsyes'] = 'Ja, geef de mogelijkheid om een andere vraag te proberen';
$string['caseno'] = 'Nee, hoofd/kleine letters zijn niet belangrijk';
$string['casesensitive'] = 'Gevoeligheid voor hoofd/kleine letters';
$string['caseyes'] = 'Ja, hoofd/kleine letters moeten exact hetzelfde zijn';
$string['categoryadded'] = 'Categorie \'{$a}\' is toegevoegd';
$string['categorydeleted'] = 'Categorie \'{$a}\' is verwijderd';
$string['categorynoedit'] = 'Je hebt geen recht om categorie \'{$a}\' te bewerken.';
$string['categoryupdated'] = 'De categorie is met succes geüpdatet';
$string['close'] = 'Sluit weergave test';
$string['closebeforeopen'] = 'De sluittijd moet na de openingstijd liggen.';
$string['closed'] = 'Gesloten';
$string['closepreview'] = 'Sluit voorbeeld';
$string['closereview'] = 'Sluit nalezen';
$string['comment'] = 'Commentaar';
$string['commentorgrade'] = 'Geef commentaar of verander cijfer';
$string['comments'] = 'Commentaren';
$string['completedon'] = 'Voltooid';
$string['completionattemptsexhausted'] = 'Slaagcijfer of alle beschikbare voltooide pogingen';
$string['completionattemptsexhausted_help'] = 'Markeer vragen als voltooid wanneer leerlingen het maximum aantal pogingen gebruikt hebben.';
$string['completiondetail:minattempts'] = 'Maak pogingen: {$a}';
$string['completiondetail:passorexhaust'] = 'Behaal het slaagcijfer of voltooi alle beschikbare pogingen';
$string['completionminattempts'] = 'Minimale pogingen';
$string['completionminattemptsdesc'] = 'Minimaal aantal vereiste pogingingen: {$a}';
$string['completionminattemptserror'] = 'Het minimumaantal pogingen moet lager zijn dan of gelijk zijn aan de toegestane pogingen.';
$string['completionpassorattemptsexhausteddesc'] = 'Leerling moet het slaagcijfer behalen of alle beschikbare pogingen voor deze activiteit gebruiken';
$string['configadaptive'] = 'Als je ja kiest voor deze optie, dan zal de leerlingen de leerlingen meerdere antwoorden per vraag kunnen geven, zelfs binnen dezelfde test.';
$string['configattemptsallowed'] = 'Beperking op het aantal keer dat leerlingen de test mogen proberen.';
$string['configdecimaldigits'] = 'Aantal cijfers na de komma bij het tonen van het testresultaat.';
$string['configdecimalplaces'] = 'Aantal cijfers dat getoond moet worden na de komma wanneer je de cijfers van de test toont.';
$string['configdecimalplacesquestion'] = 'Aantal cijfers dat getoond moet worden na de komma wanneer de cijfers van individuele vragen getoond worden.';
$string['configdelay1'] = 'Als je hier een tijd instelt, dan zal de leerling zo lang moeten wachten voor die de test opnieuw mag doen na de eerste poging.';
$string['configdelay1st2nd'] = 'Als je hier een tijd ingeeft, dan kan de leerling zijn tweede poging niet starten tot die tijd sinds de eerste poging verlopen is.';
$string['configdelay2'] = 'Als je hier een tijd instelt, dan zal de leerling zo lang moeten wachten voor die de derde of latere pogingen mag doen.';
$string['configdelaylater'] = 'Als je hier een tijd ingeeft, dan kan de leerling zijn volgende poging niet starten voor deze tijd verlopen is tussen de pogingen.';
$string['configeachattemptbuildsonthelast'] = 'Als meerdere pogingen toegelaten zijn, dan moet elke nieuwe pogingen de resultaten van de vorige poging bevatten.';
$string['configgrademethod'] = 'Als er meerdere pogingen toegelaten zijn, welke methode moet de testmodule dan gebruiken om het uiteindelijke cijfer van de leerling te berekenen.';
$string['configintro'] = 'De instellingen die je hier maakt bepalen de se standaardwaarden die gebruikt zullen worden in het instellingenformulier wanneer je een nieuwe test maakt. Je kunt ook instellen welke instellingen als geavanceerd beschouwd zullen worden.';
$string['configintroglobal'] = 'Deze instellingen regelen sitebreed het gedrag van de activiteit Test.';
$string['configmaximumgrade'] = 'Het standaard totaalcijfer.';
$string['confignavmethod'] = 'In vrije navigatie kunnen vragen in gelijk welke volgorde beantwoord worden door te navigeren. In sequentiële modus moeten de vragen in strikte volgorde beantwoord worden.';
$string['confignewpageevery'] = 'Wanneer je vragen toevoegd aan de test, dan zullen er automatisch paginascheidingen toegevoegd worden volgens de instelling die je hier maakt.';
$string['configoutcomesadvanced'] = 'Als deze optie is ingeschakeld, dan zullen de resultaten op de bewerkpagina van de test, geavanceerde instellingen worden.';
$string['configpenaltyscheme'] = 'Aantal strafpunten voor elk fout antwoord in adaptieve modus.';
$string['configpopup'] = 'Dwing de testpoging in een pop-upvenster en gebruik javascript truukjes om kopiëren, plakken en dergelijke te verhinderen tijdens testen.';
$string['configrequirepassword'] = 'Leerlingen moeten dit wachtwoord ingeven voor ze aan een test kunnen beginnen.';
$string['configrequiresubnet'] = 'Leerlingen kunnen alleen testen afleggen vanaf deze computers';
$string['configreviewoptions'] = 'Deze opties controleren welke informatie gebruikers kunnen zien wanneer ze een test nakijken of wanneer ze de resultaten van de test bekijken.';
$string['configshowblocks'] = 'Toon blokken tijdens testpogingen';
$string['configshowuserpicture'] = 'Toon de foto van de gebruiker op het scherm wanneer de test afgenomen wordt.';
$string['configshufflewithin'] = 'Als je deze optie inschakelt, dan zullen  voor elke leerling de antwoorden op de vragen door elkaar gehaald worden. Dit moet ook ingeschakeld zijn bij de instellingen van de vraag.';
$string['configtimelimit'] = 'Standaardtijd voor testen in minuten. 0 betekent geen tijdslimiet.';
$string['configtimelimitsec'] = 'Standaardtijdslimiet voor testen in seconden. 0 betekent geen tijdslimiet';
$string['configurerandomquestion'] = 'Configureer vraag';
$string['confirmclose'] = 'Als je je antwoorden ingestuurd hebt, kun je ze niet meer wijzigen.';
$string['confirmremovequestion'] = 'Weet je zeker dat je deze {$a} vraag wil verwijderen?';
$string['confirmremovesectionheading'] = 'Weet je zeker dat je de \'{$a}\' sectie-kop wil verwijderen?';
$string['confirmserverdelete'] = 'Ben je er zeker van dat je server <b>{$a}</b> van de lijst wil schrappen?';
$string['connectionerror'] = 'Netwerkverbinding verloren (Automatisch bewaren mislukt).

Neem nota van wat je op deze pagina ingetikt hebt tijdens de laatste minuten en probeer opnieuw te verbinden.

Als de connectie terug lukt, dan zou je antwoord bewaard moeten worden en zal dit bericht verdwijnen.';
$string['connectionok'] = 'Netwerkverbinding hersteld. Je kunt veilig verder werken.';
$string['containercategorycreated'] = 'Deze categorie is aangemaakt om alle originele categorieën in te verzamelen. Die zijn naar site-niveau verplaatst om onderstaande redenen.';
$string['continueattemptquiz'] = 'Ga verder met je poging';
$string['continuepreview'] = 'Ga verder met controleren';
$string['copyingfrom'] = 'Kopie aan het maken van vraag \'{$a}\'';
$string['copyingquestion'] = 'Vraag kopiëren';
$string['correct'] = 'Juist';
$string['correctanswer'] = 'Juist  antwoord';
$string['correctanswerformula'] = 'Juiste antwoordformule';
$string['correctansweris'] = 'Juist antwoord: {$a}';
$string['correctanswerlength'] = 'Aantal beduidende cijfers';
$string['correctanswers'] = 'Juiste antwoorden';
$string['correctanswershows'] = 'Juist antwoord toont';
$string['corrresp'] = 'Juist antwoord';
$string['countdown'] = 'Aftellen';
$string['countdownfinished'] = 'De test gaat dicht. Je moet nu je antwoorden bewaren.';
$string['countdowntenminutes'] = 'De test gaat over tien minuten dicht.';
$string['coursetestmanager'] = 'Course Test Manager- opmaak';
$string['createcategoryandaddrandomquestion'] = 'Maak een categorie en voeg een willekeurige vraag toe';
$string['createfirst'] = 'Je moet eerst enkele kort antwoordvragen maken.';
$string['createmultiple'] = 'Maak meer vragen';
$string['createnewquestion'] = 'Maak nieuwe vraag';
$string['createquestionandadd'] = 'Maak een nieuwe vraag en voeg ze toe aan de test.';
$string['currentbank'] = 'Huidige vragenpool: {$a}';
$string['custom'] = 'Aangepast formaat';
$string['dataitemneed'] = 'Je moet minstens één set gegevens ingeven om een geldige vraag te verkrijgen';
$string['datasetdefinitions'] = 'Herbruikbare datasetdefinities voor categorie {$a}';
$string['datasetnumber'] = 'Aantal';
$string['daysavailable'] = 'Dagen beschikbaar';
$string['decimaldigits'] = 'Decimalen in cijfers';
$string['decimalplaces'] = 'Aantal decimalen in cijfers';
$string['decimalplaces_help'] = 'Deze instelling bepaalt het aantal decimalen dat getoond moeten worden bij het cijfer van elke poging. Enkel het tonen van het cijfer wordt beïnvloed, niet de cijfers die in de databank bewaard worden, noch de interne berekeningen die met volledige nauwkeurigheid uitgevoerd worden.';
$string['decimalplacesquestion'] = 'Aantal decimalen in cijfers voor vragen';
$string['decimalplacesquestion_help'] = 'Het aantal te tonen decimalen voor cijfers van individuele vragen.';
$string['decimalpoints'] = 'Decimale cijfers';
$string['default'] = 'Standaard';
$string['defaultgrade'] = 'Standaardbeoordeling vraag';
$string['defaultinfo'] = 'De standaardcategorie voor vragen.';
$string['defaultsettings'] = 'Standaardinstellingen Test';
$string['delay1'] = 'Tijdsverschil tussen eerste en tweede poging';
$string['delay1st2nd'] = 'Verplichte wachttijd tussen 1ste en 2de poging';
$string['delay1st2nd_help'] = '<p>Als je hier een tijd instelt, dan zal de leerling die bepaalde tijd moeten wachten voor hij een tweede poging voor deze test kan doen.</p>';
$string['delay2'] = 'Tijdsverschil tussen volgende pogingen';
$string['delaylater'] = 'Verplichtte wachttijd tussen latere pogingen';
$string['delaylater_help'] = '<p>Als je hier een tijd instelt, zullen leerlingen deze tijd moeten wachten voor alle pogingen die ze willen doen, volgend op de tweede poging.</p>';
$string['deleteattemptcheck'] = 'Ben je er zeker van dat je deze pogingen wil verwijderen?';
$string['deleteselected'] = 'Selectie verwijderen';
$string['deletingquestionattempts'] = 'Testpogingen aan het verwijderen';
$string['description'] = 'Beschrijving';
$string['disabled'] = 'Uitgeschakeld';
$string['displayoptions'] = 'Toon';
$string['donotuseautosave'] = 'Bewaar niet automatisch';
$string['download'] = 'Klik om het bestand met de geëxporteerde categorie te downloaden';
$string['downloadextra'] = '(dit bestand is ook bewaard bij de bestanden van je cursus in de map /backupdata/quiz)';
$string['dragtoafter'] = 'Na {$a}';
$string['dragtostart'] = 'Naar start';
$string['duplicateresponse'] = 'De inzending werd genegeerd omdat je eerder al een gelijkaardig antwoord gaf.';
$string['eachattemptbuildsonthelast'] = 'Elke poging bouwt voort op de vorige';
$string['eachattemptbuildsonthelast_help'] = '<p>Als meerdere pogingen toegestaan worden en deze instelling wordt op <b>ja</b> gezet, dan zal elke nieuwe poging
de resultaten van de vorige poging bevatten. Dit maakt het mogelijk een begonnen test later te voltooien.</p>

<p>Om bij elke poging een lege test te tonen, kies je <b>Nee</b> voor deze instelling.</p>';
$string['edit_slotdisplaynumber_hint'] = 'Bewerk vraagnummer (max. 16 tekens)';
$string['edit_slotdisplaynumber_label'] = 'Nieuwe waarde voor {$a}';
$string['editcategories'] = 'Bewerk de categorieën';
$string['editcategory'] = 'Bewerk categorie';
$string['editcatquestions'] = 'Bewerk vragen van de categorie';
$string['editingquestion'] = 'Een vraag bewerken';
$string['editingquiz'] = 'Bewerk test';
$string['editingquiz_help'] = 'Bij het maken van een test zijn de belangrijkste concepten:

* De test, met vragen op één of meerdere pagina\'s
* De vragenpool, die kopieën bewaart van alle vragen, georganiseerd in categorieën
* Willekeurige vragen - Een leerling krijgt verschillende vragen telkens wanneer ze de test doen en verschillende leerlingen kunnen ook verschillende vragen krijgen';
$string['editingquiz_link'] = 'mod/quiz/edit';
$string['editingquizx'] = 'Test bewerken: {$a}';
$string['editmaxmark'] = 'Bewerk maximumcijfer';
$string['editoverride'] = 'Bewerk overschrijving';
$string['editqcats'] = 'Bewerk vraagcategorieën';
$string['editquestion'] = 'Bewerk vraag';
$string['editquestions'] = 'Bewerk vragen';
$string['editquiz'] = 'Bewerk test';
$string['editquizquestions'] = 'Bewerk vragen van de test';
$string['emailconfirmautosubmitsmall'] = 'Bedankt voor het insturen van je antwoorden op \'{$a->quizname}\'';
$string['emailconfirmbody'] = 'Beste {$a->username},

Bedankt voor het insturen van je antwoorden voor \'{$a->quizname}\'
uit de cursus \'{$a->coursename}\'
op {$a->submissiontime}.

Deze e-mail bevestigt dat  je antwoorden bewaard zijn.

Je kunt deze test vinden op {$a->quizurl}.';
$string['emailconfirmbodyautosubmit'] = 'Hallo {$a->username},

De tijd voor de test \'{$a->quizname}\' in de cursus \'{$a->coursename}\' is verstreken. Je antwoorden zijn automatisch verzonden om {$a->submissiontime}.

Dit bericht bevestigt dat je antwoorden zijn bewaard.

Je hebt toegang tot deze test op {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Bedankt voor het insturen van je antwoorden voor \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Bevestiging van ingestuurde antwoorden: {$a->quizname}';
$string['emailmanualgradedbody'] = 'Hallo {$a->studentname},

Je antwoorden op \'{$a->quizname}\' in cursus \'{$a->coursename}\' op {$a->attempttimefinish} zijn nu beoordeeld.

Je kunt je resultaat en feedback bekijken door naar \'{$a->quizurl}\' te gaan en je poging te bekijken.';
$string['emailmanualgradedsubject'] = 'Je poging tot {$a->quizname} is beoordeeld';
$string['emailnotifybody'] = 'Beste {$a->username},

{$a->studentname} heeft de test \'{$a->quizname} ({$a->quizurl}) uit de cursus \'{$a->coursename}\' voltooid.

Je kunt deze test nakijken op {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} heeft {$a->quizname} voltooid. Zie {$a->quizviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} heeft de test {$a->quizname} voltooid';
$string['emailoverduebody'] = 'Beste {$a->studentname},

Je startte een poging voor test \'{$a->quizname}\' in de cursus \'{$a->coursename}\', maar je hebt die nooit ingestuurd. Ze had moeten ingestuurd zijn voor {$a->attemptduedate}.

Als je deze poging nog wil insturen, ga dan naar {$a->attemptsummaryurl} en klik op de insturen-knop. Je moet dit doen voor {$a->attemptgraceend} of de poging zal niet meegerekend worden.';
$string['emailoverduesmall'] = 'Je hebt je poging voor test {$a->quizname} niet ingestuurd. Ga naar {$a->attemptsummaryurl} voor {$a->attemptgraceend} als je ze toch nog wil insturen.';
$string['emailoverduesubject'] = 'Poging nu te laat: {$a->quizname}';
$string['empty'] = 'Leeg';
$string['enabled'] = 'Ingeschakeld';
$string['endtest'] = 'Einde poging ...';
$string['erroraccessingreport'] = 'Je krijgt geen toegang tot dit rapport';
$string['errorinquestion'] = 'Fout in de vraag';
$string['errormissingquestion'] = 'Fout: de vraag met id {$a} ontbreekt in het systeem';
$string['errornotnumbers'] = 'Fout - antwoorden moeten cijfers zijn';
$string['errorunexpectedevent'] = 'Onverwachte gebeurteniscode {$a->event} gevonden voor vraag {$a->questionid} in poging {$a->attemptid}.';
$string['essay'] = 'Open vraag';
$string['essayquestions'] = 'Vragen';
$string['eventattemptautosaved'] = 'Testpoging automatisch bewaard';
$string['eventattemptdeleted'] = 'Testpoging verwijderd';
$string['eventattemptmanualgradingcomplete'] = 'Testpoging handmatig beoordelen voltooid';
$string['eventattemptpreviewstarted'] = 'Bekijken testpoging gestart';
$string['eventattemptquestionrestarted'] = 'Testpoging herbegonnen';
$string['eventattemptreviewed'] = 'Testpoging nagekeken';
$string['eventattemptsummaryviewed'] = 'Samenvatting testpoging bekeken';
$string['eventattemptupdated'] = 'Testpoging aangepast';
$string['eventattemptviewed'] = 'Testpoging bekeken';
$string['eventeditpageviewed'] = 'Test bewerkenpagina bekeken';
$string['eventoverridecreated'] = 'Test overschrijven gemaakt';
$string['eventoverridedeleted'] = 'Test overschrijven verwijderd';
$string['eventoverrideupdated'] = 'Test overschrijven aangepast';
$string['eventpagebreakcreated'] = 'Pagina-einde gemaakt';
$string['eventpagebreakdeleted'] = 'Pagina-einde verwijderd';
$string['eventquestionmanuallygraded'] = 'Vraag manueel beoordeeld';
$string['eventquizattemptabandoned'] = 'Testpoging verlaten';
$string['eventquizattemptgraded'] = 'Testpoging beoordeeld';
$string['eventquizattemptregraded'] = 'Test-poging opnieuw beoordeeld';
$string['eventquizattemptreopened'] = 'Testpoging heropend';
$string['eventquizattemptstarted'] = 'Testpoging gestart';
$string['eventquizattemptsubmitted'] = 'Testpoging ingestuurd';
$string['eventquizattempttimelimitexceeded'] = 'Tijdslimiet testpoging overschreden';
$string['eventquizgradeitemcreated'] = 'Test cijferitem gemaakt';
$string['eventquizgradeitemdeleted'] = 'Test cijferitem verwijderd';
$string['eventquizgradeitemorderchanged'] = 'Test cijferitem volgorde gewijzigd';
$string['eventquizgradeitemupdated'] = 'Test cijferitem aangepast';
$string['eventquizgradeupdated'] = 'Test-cijfer bijgewerkt';
$string['eventquizrepaginated'] = 'Test opnieuw gepagineerd';
$string['eventreportviewed'] = 'Testrapport bekeken';
$string['eventsectionbreakcreated'] = 'Sectie-einde gemaakt';
$string['eventsectionbreakdeleted'] = 'Sectie-verdeling verwijderd';
$string['eventsectionshuffleupdated'] = 'Sectie willekeurige volgorde bijgewerkt';
$string['eventsectiontitleupdated'] = 'Sectietitel bijgewerkt';
$string['eventslotcreated'] = 'Slot aangemaakt';
$string['eventslotdeleted'] = 'Slot verwijderd';
$string['eventslotdisplayedquestionnumberupdated'] = 'Slot weergegeven vraagnummer bijgewerkt';
$string['eventslotgradeitemupdated'] = 'Slot cijferitem aangepast';
$string['eventslotmarkupdated'] = 'Slot aangepast';
$string['eventslotmoved'] = 'Slot verplaatst';
$string['eventslotrequirepreviousupdated'] = 'Slot vereist vorige aanpassing';
$string['eventslotversionupdated'] = 'Slotversie aangepast';
$string['everynquestions'] = 'Elke {$a} vragen';
$string['everyquestion'] = 'Elke vraag';
$string['everythingon'] = 'Alles ingeschakeld';
$string['existingcategory'] = 'Bestaande categorie';
$string['exportcategory'] = 'export categorie';
$string['exporterror'] = 'Er is een fout opgetreden tijdens het verwerken van de export';
$string['exportingquestions'] = 'Vragen zijn geëxporteerd naar een bestand';
$string['exportname'] = 'Bestandsnaam';
$string['exportquestions'] = 'Exporteer  vragen naar bestand';
$string['extraattemptrestrictions'] = 'Extra beperkingen op pogingen';
$string['false'] = 'Onwaar';
$string['feedback'] = 'Feedback';
$string['feedbackerrorboundaryformat'] = 'De marges van de feedback moet een getal of een percentage zijn. De waarde {$a} die je ingevoerd hebt, wordt niet herkend.';
$string['feedbackerrorboundaryoutofrange'] = 'De marges van de feedback moeten tussen 0% en 100% liggen. De waarde {$a} die je ingevoerd hebt ligt daarbuiten.';
$string['feedbackerrorjunkinboundary'] = 'Je moet de velden van de feedbackmarges invullen zonder plaatsen leeg te laten.';
$string['feedbackerrorjunkinfeedback'] = 'Je moet de feedbackvelden invullen zonder plaatsen leeg te laten.';
$string['feedbackerrororder'] = 'De marges voor feedback moeten in volgorde ingevuld worden, de hoogste eerst. De waarde die je in marge {$a} invulde, is niet in volgorde.';
$string['file'] = 'Bestand';
$string['fileformat'] = 'Bestandsformaat';
$string['fillcorrect'] = 'Vul aan met het juiste';
$string['filloutnumericalanswer'] = 'Je geeft hier minstens één mogelijk antwoord en een tolerantie op. Het eerste overeenkomende antwoord zal gebruikt worden om het cijfer en de feedback te bepalen. Als je feedback geeft zonder antwoord, dan zal dat gebruikt worden om aan leerlingen te tonen die geen antwoord uit de lijst gaven.';
$string['filloutoneanswer'] = 'Je moet minstens één mogelijk antwoord invullen. Lege antwoorden zullen niet worden gebruikt. Een \'*\' kan als jokerteken gebruikt worden en dient dan als een willekeurig teken. Het eerste antwoord dat overeenkomt zal gebruikt worden om het cijfer en de feedback te bepalen.';
$string['filloutthreequestions'] = 'Je moet minstens drie vragen geven met hun antwoorden. Je kunt extra foute antwoorden geven door antwoorden in te vullen met een blanco vraag. Lijnen waar  zowel vraag als antwoord leeg zijn, zullen genegeerd worden.';
$string['fillouttwochoices'] = 'Je moet minstens twee keuzemogelijkheden invullen. Lege keuzemogelijkheden zullen niet worden gebruikt.';
$string['finishattemptdots'] = 'Beëindig poging...';
$string['finishreview'] = 'Nakijken beëindigen';
$string['forceregeneration'] = 'maak nieuwe waarden';
$string['formatnotfound'] = 'Import- / exportopmaak {$a} niet gevonden';
$string['formulaerror'] = 'Formulefouten!';
$string['fractionsaddwrong'] = 'De positieve cijfers die je hebt gekozen tellen niet op tot 100%
<br />In plaats daarvan tellen ze op tot {$a}%
<br />Wil je terug gaan en deze vraag verbeteren?';
$string['fractionsnomax'] = 'Eén van de antwoorden moet 100% zijn, zodat het mogelijk is
<br />om een vol punt voor deze vraag te krijgen.
<br />Wil je terug gaan en deze vraag verbeteren?';
$string['fromfile'] = 'uit bestand:';
$string['functiondisabledbysecuremode'] = 'Die functie is momenteel uitgeschakeld';
$string['generalfeedback'] = 'Algemene feedback vraag';
$string['generalfeedback_help'] = 'Algemene feedback is tekst die getoond wordt nadat een leerling een vraag beantwoord heeft. Anders dan gewone feedback, die afhankelijk is van het antwoord dat de leerling gegeven heeft, wordt deze algemene feedback altijd getoond.';
$string['gobacktoquiz'] = 'Ga terug';
$string['graceperiod'] = 'Extra tijd voor inzenden';
$string['graceperiod_desc'] = 'Wanneer de tijd voor de test is ingesteld op \'Geef extra tijd om in te sturen, maar niet om antwoorden te wijzigen\', dan is dit de extra tijd die toegestaan wordt.';
$string['graceperiod_help'] = 'Wanneer de tijd voor de test is ingesteld op \'Geef extra tijd om in te sturen, maar niet om antwoorden te wijzigen\', dan is dit de extra tijd die toegestaan wordt.';
$string['graceperiodmin'] = 'Periode extra tijd om in te sturen';
$string['graceperiodmin_desc'] = 'Er is mogelijk een probleem op het einde van een test. Enerzijds willen we leerlingen zo lang mogelijk laten doorwerken. Dit kan met de timer die de test automatisch instuurt wanneer de tijd op is. Anderzijds kan de server overbelast geraken en kan er wat tijd verlopen voor die alle antwoorden verwerkt heeft. Daarom zullen we antwoorden accepteren tot dit aantal seconden nadat de tijd verstreken is, zodat de leerlingen niet gestraft worden omdat de server traag is. De leerling kan dit echter misbruiken en deze extra tijd gebruiken om vragen te beantwoorden. Je moet de balans opmaken over hoeveel je de performantie van je server vertrouwt tijdens testen.';
$string['graceperiodtoosmall'] = 'De extra tijd moet meer zijn dan {$a}.';
$string['gradeall'] = 'Alles beoordelen';
$string['gradeaverage'] = 'Gemiddelde cijfer';
$string['gradeboundary'] = 'Cijfermarge';
$string['gradeessays'] = 'Beoordeel open vragen';
$string['gradehighest'] = 'Hoogste cijfer';
$string['gradeitemdefaultname'] = 'Nieuw cijferitem {$a}';
$string['gradeitemdelete'] = 'Verwijder cijferitem {$a}';
$string['gradeitemedit'] = 'Bewerk naam van cijferitem {$a}';
$string['gradeitemmarkscheme'] = 'Wijs cijfers per sectie toe';
$string['gradeitemnewname'] = 'Nieuwe naam voor cijferitem {$a}';
$string['gradeitemnoneselected'] = '[geen]';
$string['gradeitemnoslots'] = 'Deze test heeft nog geen vragen. Voeg eerst vragen toe, kom dan hier terug om cijfers per sectie in te stellen.';
$string['gradeitems'] = 'Beoordelingsitems';
$string['gradeitemsautosetup'] = 'Cijfer geven voor elke sectie';
$string['gradeitemsetup'] = 'Cijfers per sectie instellen';
$string['gradeitemsnoneyet'] = 'Maak cijfers per sectie in je test. Wijs vragen of testsecties toe aan deze cijfers om het resultaat op te splitsen in verschillende categorieën.';
$string['gradeitemsremoveall'] = 'Instellingen opnieuw instellen';
$string['gradeitemsremoveallconfirm'] = 'Instellingen cijfers per sectie  opnieuw instellen?';
$string['gradeitemsremoveallmessage'] = 'Dit zal alle cijfers per sectie  verwijderen en de toewijzing van vragen en secties verwijderen.<br><br>Deze actie heeft geen invloed op de vragen en de secties en ook niet op bestaande pogingen in de test.';
$string['gradeitemsremovealltitle'] = 'Instellingen cijfers per sectie opnieuw instellen';
$string['grademethod'] = 'Beoordelingsmethode';
$string['grademethod_help'] = 'Wanneer je meerdere pogingen toelaat, zijn er verschillende manieren waarop je de beschikbare cijfers kunt gebruiken om het totaalcijfer op de test te berekenen.

* Hoogste cijfer van alle pogingen
* Gemiddelde cijfer van alle pogingen
* Eerste poging (Alle andere pogingen worden genegeerd)
* Laatste poging (Alle andere pogingen worden genegeerd)';
$string['gradesdeleted'] = 'Cijfers van de test verwijderd';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}';
$string['gradetopassmustbeset'] = 'Slaagcijfer kan geen nul zijn omdat de test is ingesteld om een slaagcijfer te behalen als voltooiingsmethode. Geef hier een andere waarde dan een nul.';
$string['gradetopassoutof'] = 'Slaagcijfer: {$a->grade} op {$a->maxgrade}';
$string['gradingdetails'] = 'Cijfer voor deze inzending:
{$a->raw}/{$a->max}';
$string['gradingdetailsadjustment'] = 'Met de vorige strafpunten geeft dit
<strong>{$a->cur}/{$a->max}</strong>';
$string['gradingdetailspenalty'] = 'Deze inzending kreeg {$a} strafpunten';
$string['gradingdetailszeropenalty'] = 'Je werd niet bestraft voor deze inzending';
$string['gradingmethod'] = 'Beoordelingsmethode: {$a}';
$string['groupoverrides'] = 'Groepsoverschrijvingen';
$string['groupoverridesdeleted'] = 'Groepsoverschrijvingen verwijderd';
$string['groupsnone'] = 'Er zijn geen groepen waartoe je toegang hebt.';
$string['guestsno'] = 'Sorry, gasten kunnen testen niet bekijken noch een poging wagen';
$string['hidebreaks'] = 'Verberg paginascheidingen';
$string['hidereordertool'] = 'Verberg tool om vraagvolgorde te wijzigen';
$string['history'] = 'Geschiedenis van antwoorden:';
$string['howquestionsbehave_desc'] = 'Standaardinstelling voor de manier waarop vragen zich gedragen in een test.';
$string['imagedisplay'] = 'Weer te geven afbeelding';
$string['import_help'] = 'Met deze functie kun je vragen importeren uit externe textbestanden.

Je moet UTF8-encoding gebruiken. Wees vooral voorzichtig met bestanden die je met Microsoft Office genereert, omdat die meestal een encoding gebruiken die niet correct zal afgehandeld worden.

Import- en exportbestandsformaten zijn plugins. Er kunnen optionele bestandsformaten beschikbaar zijn in de Modules and Plugins database op Moodle.org.';
$string['import_link'] = 'question/import';
$string['importcategory'] = 'importeer categorie';
$string['importerror'] = 'Er is een fout opgetreden tijdens het importeren';
$string['importfilearea'] = 'Importeer van een bestand uit de cursusbestanden';
$string['importfileupload'] = 'Importeer van een geüpload bestand';
$string['importfromthisfile'] = 'Importeer vanuit dit bestand';
$string['importingquestions'] = '{$a} vragen uit een bestand aan het importeren';
$string['importmax10error'] = 'Er zit een fout in de vraag. Je mag niet meer dan tien mogelijke antwoorden geven.';
$string['importmaxerror'] = 'Er zit een fout in de vraag. Er zijn te veel antwoorden.';
$string['importquestions'] = 'Importeer vragen uit bestand';
$string['inactiveoverridehelp'] = '* Deze overschrijving is niet actief omdat de toegang tot de activiteit beperkt is voor deze gebruiker. Dit kan te wijten zijn aan groep of roltoewijzingen, andere beperkingen of omdat de activiteit verborgen is.';
$string['incorrect'] = 'Niet juist';
$string['indicator:cognitivedepth'] = 'Test cognitief';
$string['indicator:cognitivedepth_help'] = 'Deze indicator is gebaseerd op de door de leerling bereikte cognitieve diepte in een Test activiteit.';
$string['indicator:cognitivedepthdef'] = 'Test cognitief';
$string['indicator:cognitivedepthdef_help'] = 'De deelnemer heeft dit percentage van de cognitieve betrokkenheid van de Test-activiteiten bereikt tijdens dit analyse-interval (Niveaus = Geen weergave, Bekijken, Verzenden, Feedback bekijken, Reageren op feedback, Opnieuw verzenden na het bekijken van feedback)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Test sociaal';
$string['indicator:socialbreadth_help'] = 'Deze indicator is gebaseerd op de door de leerling behaalde sociale breedte in een Test activiteit.';
$string['indicator:socialbreadthdef'] = 'Test sociaal';
$string['indicator:socialbreadthdef_help'] = 'De deelnemer heeft dit percentage van de sociale betrokkenheid van de Test-activiteiten bereikt tijdens dit analyse-interval (Niveaus = geen deelname, alleen deelnemer, deelnemer met anderen)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indivresp'] = 'Antwoorden van ieder afzonderlijk op elk item';
$string['info'] = 'Info';
$string['infoshort'] = 'i';
$string['initialnumfeedbacks'] = 'Initieel aantal algemene feedbackvelden';
$string['initialnumfeedbacks_desc'] = 'Geef zoveel lege algemene feedbackzones bij het maken van een nieuwe test. Wanneer de test gemaakt is, toont het formulier het aantal vereiste velden voor het aantal feedbacks in de test. De instelling moet minstens 1 zijn.';
$string['inprogress'] = 'Bezig';
$string['introduction'] = 'Beschrijving';
$string['invalidattemptid'] = 'Die poging ID bestaat niet';
$string['invalidcategory'] = 'Categorie ID is ongeldig';
$string['invalidoverrideid'] = 'Ongeldig overschrijvingsID';
$string['invalidquestionid'] = 'Ongeldige vraag ID';
$string['invalidquizid'] = 'Ongeldige test ID';
$string['invalidrandomslot'] = 'Ongeldige slot id willekeurige vraag';
$string['invalidsource'] = 'Deze bron is niet geldig';
$string['invalidsourcetype'] = 'Ongeldig brontype';
$string['invalidstateid'] = 'Ongeldige status ID';
$string['lastanswer'] = 'Je laatste antwoord was';
$string['lastautosave'] = 'Laatst bewaard: {$a}';
$string['layout'] = 'Opmaak';
$string['layoutasshown'] = 'Paginaopmaak zoals hier.';
$string['layoutasshownwithpages'] = 'Paginaopmaak zoals hier <small>(automatisch nieuwe pagina elke {$a} vragen.</small>';
$string['layoutshuffledandpaged'] = 'Vragen in willekeurige volgorde met {$a} vragen per pagina';
$string['layoutshuffledsinglepage'] = 'Vragen in willekeurige volgorde, allemaal op één pagina.';
$string['link'] = 'Link';
$string['listitems'] = 'Lijst van items in de test';
$string['literal'] = 'Jokertekens';
$string['loadingquestionsfailed'] = 'Het laden van vragen is mislukt: {$a}';
$string['makecopy'] = 'Bewaar als nieuwe vraag';
$string['managetypes'] = 'Beheer vraagtypes en servers';
$string['manualgradequestion'] = 'Beoordeel vraag  {$a->question} in {$a->quiz} door {$a->user} manueel';
$string['manualgrading'] = 'Beoordelen';
$string['mark'] = 'Bewaren';
$string['markall'] = 'Pagina bewaren';
$string['marks'] = 'Cijfers';
$string['marks_help'] = 'De numerieke cijfers voor elke vraag en de algemene score voor de poging. Je kunt enkel cijfers selecteren als maximaal cijfer is geselecteerd';
$string['match'] = 'Koppelen';
$string['matchanswer'] = 'Koppel antwoord';
$string['matchanswerno'] = 'Passend antwoord {$a}';
$string['max'] = 'Max';
$string['maxmark'] = 'Bewerk cijfer';
$string['maxmarks'] = 'Maximaal cijfer';
$string['maxmarks_help'] = 'Het maximale cijfer voor elke vraag.';
$string['messageprovider:attempt_grading_complete'] = 'Melding dat je poging is beoordeeld';
$string['messageprovider:attempt_overdue'] = 'Waarschuwing wanneer je testpoging over tijd gaat';
$string['messageprovider:confirmation'] = 'Bevestiging van je eigen testinzendingen';
$string['messageprovider:quiz_open_soon'] = 'Test opent binnenkort';
$string['messageprovider:submission'] = 'Melding van testen ingestuurd door je leerlingen';
$string['min'] = 'Min';
$string['minutes'] = 'Minuten';
$string['missingcategory'] = 'Ontbrekende vraagcategorie';
$string['missingcorrectanswer'] = 'Het goede antwoord moet worden aangegeven';
$string['missingitemtypename'] = 'Ontbrekende naam';
$string['missingquestion'] = 'Deze test bestaat niet meer';
$string['modulename'] = 'Test';
$string['modulename_help'] = 'Met de testmodule kan de leraar een set testen ontwerpen die bestaan uit meerkeuze, waar/onwaar, koppel en andere vragentypes.

De leraar kan er voor kiezen om een test meerdere keren te laten proberen, met de vragen door elkaar geschud of willekeurig gekozen uit een vragenpool. Er kan een tijdslimiet ingesteld worden.

Elke poging wordt automatisch beoordeeld, met uitzondering van de open vragen, en het cijfer wordt in de cijferlijst opgenomen.

De leraar kan kiezen of hints, feedback en juiste antwoorden aan de leerlingen getoond worden.

Testen kunnen gebruikt worden

* als eindexamen van een cursus
* als mini-tests voor leesopdrachten of aan het eind van een onderwerp
* als examenoefening, gebruik makend van vragen van een vorig examen.
* om onmiddellijke feedback te geven over de prestaties van een leerling
* voor zelfevaluatie';
$string['modulename_link'] = 'mod/quiz/view';
$string['modulenameplural'] = 'Testen';
$string['moveselectedonpage'] = 'Verplaats geselecteerde vragen naar pagina: {$a}';
$string['multichoice'] = 'Meerkeuze';
$string['multipleanswers'] = 'Kies minstens één antwoord';
$string['mustbesubmittedby'] = 'Deze poging moet ingestuurd worden voor {$a}.';
$string['name'] = 'Naam';
$string['navigatenext'] = 'Volgende pagina';
$string['navigateprevious'] = 'Vorige pagina';
$string['navmethod'] = 'Navigatiemethode';
$string['navmethod_free'] = 'Vrij';
$string['navmethod_help'] = 'Wanneer sequentiële navigatie is ingeschakeld, moet een leerling in de juiste volgorde door de test navigeren en mag niet terugkeren naar vorige pagina\'s, noch pagina\'s overslaan';
$string['navmethod_seq'] = 'Sequentieel';
$string['navnojswarning'] = 'Waarschuwing: deze links zullen je antwoorden niet bewaren. Gebruik de \'volgende\'-knop onderaan de pagina.';
$string['neverallononepage'] = 'Nooit, alle vragen op één pagina';
$string['newattemptfail'] = 'Fout: kon geen nieuwe poging voor de test starten';
$string['newcategory'] = 'Nieuwe categorie';
$string['newpage'] = 'Nieuwe pagina';
$string['newpage_help'] = '<p>Voor langere testen is het een goed idee om deze te verdelen over verschillende pagina\'s door het aantal vragen per pagina te beperken. Wanneer je vragen aan de test toevoegt, worden de paginascheidingen automatisch ingevoegd, afhankelijk van de instelling die je hier gemaakt hebt. Je kunt de paginascheidingen later ook met de hand verplaatsen op de pagina voor het bewerken van de test.
</p>';
$string['newpageevery'] = 'Start automatisch een nieuwe pagina';
$string['newsectionheading'] = 'Nieuwe kop';
$string['noanswers'] = 'Er zijn geen antwoorden geselecteerd!';
$string['noattempts'] = 'Er zijn geen pogingen geweest om deze test te maken';
$string['noattemptsfound'] = 'Geen pogingen gevonden';
$string['noattemptstoshow'] = 'Er zijn nog geen pogingen om te tonen';
$string['nocategory'] = 'Onjuiste of geen categorie opgegeven';
$string['noclose'] = 'Geen sluitdatum';
$string['nocommentsyet'] = 'Nog geen commentaar';
$string['noconnection'] = 'Er is op dit ogenblik geen verbinding naar een webservice die deze vraag kan behandelen. Neem contact op met je beheerder';
$string['nodataset'] = 'niets - dit is geen jokerteken';
$string['nodatasubmitted'] = 'Geen gegevens ingestuurd.';
$string['noessayquestionsfound'] = 'Geen manueel te beoordelen vragen gevonden';
$string['nogradewarning'] = 'Deze test is nog niet beoordeeld, je kunt dus nog geen algemene feedback instellen die verschillend is per cijfer.';
$string['nomoreattempts'] = 'Een nieuwe poging is niet meer toegestaan';
$string['none'] = 'Geen';
$string['noopen'] = 'Geen opendatum';
$string['nooverridedata'] = 'Je moet minstens één van de testinstellingen overschrijven';
$string['nopossibledatasets'] = 'Geen datasets beschikbaar';
$string['noquestionintext'] = 'De tekst van de vraag bevat geen ingebedde vragen';
$string['noquestions'] = 'Er zijn nog geen vragen toegevoegd';
$string['noquestionsfound'] = 'Geen vragen gevonden';
$string['noquestionsinquiz'] = 'Er zijn geen vragen in deze test.';
$string['noquestionsnotinuse'] = 'Deze willekeurige vraag wordt niet gebruikt omdat de categorie waaruit ze vragen haalt, leeg is.';
$string['noquestionsonpage'] = 'Lege pagina';
$string['noresponse'] = 'Geen reactie';
$string['noreview'] = 'Je mag deze test niet opnieuw bekijken';
$string['noreviewattempt'] = 'Je mag deze poging niet nakijken';
$string['noreviewshort'] = 'Opnieuw bekijken niet toegestaan';
$string['noreviewuntil'] = 'Tot {$a} mag je deze test niet opnieuw bekijken';
$string['noreviewuntilshort'] = 'Beschikbaar {$a}';
$string['noscript'] = 'Javascript moet ingeschakeld zijn om verder te kunnen gaan!';
$string['notavailabletostudents'] = 'Opmerking: deze test is nu niet beschikbaar voor je leerlingen.';
$string['notenoughrandomquestions'] = 'Er zijn  niet genoeg vragen in categorie  {$a->category} om vraag {$a->name} ({$a->id}) te maken.';
$string['notenoughsubquestions'] = 'Er zijn onvoldoende deelvragen gedefinieerd!<br />Wil je teruggaan en deze vraag herstellen?';
$string['notifyattemptsgradedtask'] = 'Stuur meldingen over beoordeelde testpogingen';
$string['notimedependentitems'] = 'Tijdsafhankelijke items worden op dit ogenblik niet ondersteund door de testmodule. Als oplossing kun je de tijdslimiet voor de hele test instellen. Wil je een ander item kiezen (of desalnietemin dit item gebruiken)?';
$string['notyetgraded'] = 'Nog niet beoordeeld';
$string['notyetviewed'] = 'Nog niet bekeken';
$string['notyourattempt'] = 'Dit is niet jouw poging!';
$string['noview'] = 'De aangemelde gebruiker mag deze test niet bekijken';
$string['numattempts'] = '{$a->studentnum}
{$a->studentstring} hebben
{$a->attemptnum} pogingen gedaan';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numeriek';
$string['numquestionsx'] = 'Vragen: {$a}';
$string['oneminute'] = '1 minuut';
$string['onlyteachersexport'] = 'Enkel leraren kunnen vragen exporteren';
$string['onlyteachersimport'] = 'Enkel leraren met bewerkrechten kunnen vragen importeren';
$string['onthispage'] = 'Op deze pagina';
$string['open'] = 'Niet beantwoord';
$string['openafterclose'] = 'Kon de test niet aanpassen. Je hebt een startdatum ingegeven na de einddatum.';
$string['openclosedatesupdated'] = 'Open- en sluittijden';
$string['optional'] = 'optioneel';
$string['orderandpaging'] = 'Volgorde en paginering';
$string['orderandpaging_help'] = 'De nummers 10, 20, 30 tegenover elke vraag duiden de volgorde van de vragen aan. De nummers verhogen per 10 om plaats te laten om bijkomende vragen in te voegen. Om de vragen van volgorde te veranderen, kun je de nummers veranderen en op de "herorden vragen" knop klikken.';
$string['orderingquiz'] = 'Volgorde en paginering';
$string['orderingquizx'] = 'Volgorde en paginering: {$a}';
$string['outcomesadvanced'] = 'Resultaten zijn geavanceerde instellingen';
$string['outof'] = '{$a->grade} op een maximum van {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} op een maximum van {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Algemene feedback test';
$string['overallfeedback_help'] = 'De algemene feedback is een tekst die aan de leerlingen wordt getoond nadat ze de hele test beëindigd hebben. Door puntenmarges in te geven (als percentage of als cijfer) kan de tekst afhankelijk gemaakt worden van het behaalde cijfer.';
$string['overdue'] = 'Te laat';
$string['overduehandling'] = 'Wanneer de tijd verlopen is';
$string['overduehandling_desc'] = 'Wat er standaard zou moeten gebeuren wanneer een leerling zijn test niet instuurd voor de tijd verlopen is.';
$string['overduehandling_help'] = 'Deze instelling controleert wat er gebeurt wanneer de leerling een test niet instuurt voor de tijd verstreken is. Als de leerling aan het werken is aan de test, dan zal de afteltimer de test altijd voor hen insturen, maar als ze afgemeld zijn, dan zal deze instelling bepalen wat er gebeurt.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = 'Pogingen moeten ingestuurd worden voor de tijd verlopen is of ze worden niet meegeteld';
$string['overduehandlingautosubmit'] = 'Open pogingen worden automatisch ingestuurd';
$string['overduehandlinggraceperiod'] = 'Er is extra tijd voorzien om open pogingen in te sturen, maar niet om meer vragen te beantwoorden';
$string['overduemustbesubmittedby'] = 'Deze poging is nu over tijd. Ze zou al moeten ingestuurd geweest zijn. Als je wil dat deze poging beoordeeld wordt, dan moet je ze insturen voor {$a}. Als je dit niet doet, dan zal er voor deze poging geen cijfer gegeven worden.';
$string['override'] = 'Overschrijf';
$string['overridecannotchange'] = 'De gebruiker of groep kan niet gewijzigd worden nadat een overschrijving gemaakt is.';
$string['overridecannotsetbothgroupanduser'] = 'Groep en gebruiker kunnen niet tegelijk ingesteld worden.';
$string['overridedeletegroupsure'] = 'Ben je er zeker van dat je de overschrijving voor groep {$a} wil verwijderen?';
$string['overridedeleteusersure'] = 'Ben je er zeker van dat je de overschrijving voor gebruiker {$a} wil verwijderen?';
$string['overridegroup'] = 'Overschrijf groep';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrideinvalidattempts'] = 'Pogingenwaarde moet groter dan nul zijn.';
$string['overrideinvalidexistingid'] = 'Bestaande overschrijving bestaat niet.';
$string['overrideinvalidgroup'] = 'Toegewezen groep bestaat niet.';
$string['overrideinvalidquiz'] = 'TestID set bestaat niet.';
$string['overrideinvalidtimelimit'] = 'Tijdslimiet moet groter dan nul zijn.';
$string['overrideinvaliduser'] = 'Gegeven gebruiker bestaat niet.';
$string['overridemissingdelete'] = 'OverschrijvingsID(s) {$a} konden niet verwijderd worden omdat ze niet bestaan of omdat ze geen deel uitmaken van de gegeven test.';
$string['overridemultiplerecordsexist'] = 'Er kan maar één overschrijving gemaakt worden voor dezelfde gebruiker/groep.';
$string['overridemustsetuserorgroup'] = 'Er moet een gebruiker of groep ingesteld worden.';
$string['overrides'] = 'Overschrijvingen';
$string['overridesforquiz'] = 'Instellingen overschrijven: {$a}';
$string['overridesnoneforgroups'] = 'Er zijn geen overschrijvingen voor groepsinstellingen gemaakt voor deze test.';
$string['overridesnoneforusers'] = 'Er zijn geen overschrijvingen van gebruikersinstellingen gemaakt voor deze test.';
$string['overridessummary'] = 'Er bestaan overschreven instellingen ({$a})';
$string['overridessummarygroup'] = 'Groepen: {$a}';
$string['overridessummarythisgroup'] = 'Er bestaan overschreven instellingen  ({$a}) voor deze groep';
$string['overridessummaryuser'] = 'Gebruikers: {$a}';
$string['overridessummaryyourgroups'] = 'Er bestaan overschreven instellingen ({$a}) voor jouw groepen';
$string['overrideuser'] = 'Overschrijf gebruiker';
$string['overrideusereventname'] = '{$a->quiz} - Overschrijf';
$string['page-mod-quiz-attempt'] = 'Poging testpagina';
$string['page-mod-quiz-edit'] = 'Bewerk testpagina';
$string['page-mod-quiz-report'] = 'Elke test rapportpagina';
$string['page-mod-quiz-review'] = 'Bekijk test pogingenpagina';
$string['page-mod-quiz-summary'] = 'Testpoging samenvattingspagina';
$string['page-mod-quiz-view'] = 'Test informatiepagina';
$string['page-mod-quiz-x'] = 'Elke testmodule pagina';
$string['pageshort'] = 'P';
$string['pagesize'] = 'Paginagrootte';
$string['parent'] = 'bovenliggend';
$string['parentcategory'] = 'Bovenliggende categorie';
$string['parsingquestions'] = 'Vragen uit het geïmporteerd bestand aan het verwerken.';
$string['partiallycorrect'] = 'Gedeeltelijk juist';
$string['penalty'] = 'Strafpunt';
$string['penaltyscheme'] = 'Gebruik strafpunten';
$string['penaltyscheme_help'] = '<p>Als een test in de adaptieve modus loopt, dan mag een leerling nog eens proberen na het geven van een fout antwoord. In dit geval wil je misschien voor elk fout antwoord strafpunten geven die dan afgetrokken worden van het totaalcijfer van de vraag. Het aantal strafpunten wordt voor elke vraag afzonderlijk gekozen wanneer je de vraag ingeeft of bewerkt.</p>

<p>Deze instelling heeft geen effect, tenzij de test in adaptieve modus loopt.</p>';
$string['percentcorrect'] = 'Percentage juist';
$string['pleaseclose'] = 'Je vraag is verwerkt. Je mag dit venster nu sluiten.';
$string['pluginadministration'] = 'Test beheer';
$string['pluginname'] = 'Test';
$string['popup'] = 'Toon de test in een \'veilig\' venster';
$string['popupblockerwarning'] = 'Dit deel van de test gebeurt in een beveiligd venster. Zet je pop-up-blocker af.';
$string['popupnotice'] = 'Leerlingen zien de test in een veilig venster';
$string['precreateattempts'] = 'Pogingen vooraf aanmaken';
$string['precreateattempts_desc'] = 'Het vooraf maken van pogingen helpt de site-performantie te verbeteren. Bijkomend met het inschakelen van deze instelling, moet je een periode instellen hoe lang vooraf de testen aangemaakt moeten worden. Deze instelling is enkel van toepassing op testen met een openingstijd.';
$string['precreateattempts_help'] = 'Vooraf pogingen aanmaken helpt de siteperformance te optimaliseren. Testvragen kunnen niet meer worden aangepast wanneer er pogingen zijn in een test.';
$string['precreateoff'] = 'Vooraf geen pogingen aanmaken';
$string['precreateperiod'] = 'Periode vooraf aanmaken';
$string['precreatetask'] = 'Pogingen vooraf aanmaken';
$string['precreateusedefault'] = 'Sitebrede standaardinstelling ({$a}) gebruiken';
$string['precreateyes'] = 'Ja, {$a} uur voor openingstijd van test';
$string['preprocesserror'] = 'Fout opgetreden tijdens de voorbereiding!';
$string['preview'] = 'Controleer test';
$string['previewquestion'] = 'Weergave van een vraag testen';
$string['previewquiz'] = 'Voorbeeld {$a}';
$string['previewquiznow'] = 'Controleer test';
$string['previewquizstart'] = 'Test bekijken';
$string['previous'] = 'Vorige status';
$string['privacy:metadata:core_question'] = 'De activiteit Test slaat informatie over het vraaggebruik op in het core_question subsysteem.';
$string['privacy:metadata:quiz'] = 'De activiteit Test maakt gebruik van testrapporten.';
$string['privacy:metadata:quiz_attempts'] = 'Details over iedere poging in een Test.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'Het pogingnummer.';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'De huidige pagina waar de gebruiker is.';
$string['privacy:metadata:quiz_attempts:gradednotificationsenttime'] = 'Het tijdstip waarop de gebruiker een melding kreeg dat de handmatige beoordeling van zijn poging voltooid was';
$string['privacy:metadata:quiz_attempts:preview'] = 'Of dit een voorvertoning is van de Test.';
$string['privacy:metadata:quiz_attempts:state'] = 'De huidige toestand van de poging.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'De som van punten in de poging.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'De tijd waarop de toestand is gecontroleerd.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'De tijd waarop de poging is voltooid.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'De tijd waarop de poging is geüpdated.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'De tijd waarop de poging is geüpdated via een offline update.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'De tijd waarop de poging is begonnen.';
$string['privacy:metadata:quiz_grades'] = 'Details over het overall cijfer voor deze Test.';
$string['privacy:metadata:quiz_grades:grade'] = 'Het overall cijfer voor deze Test.';
$string['privacy:metadata:quiz_grades:quiz'] = 'De test is beoordeeld.';
$string['privacy:metadata:quiz_grades:timemodified'] = 'De tijd waarop het cijfer is aangepast.';
$string['privacy:metadata:quiz_grades:userid'] = 'De gebruiker die is beoordeeld.';
$string['privacy:metadata:quiz_overrides'] = 'Details over overschrijvingen voor deze test';
$string['privacy:metadata:quiz_overrides:quiz'] = 'De test met overschrijvingsinformatie';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'De nieuwe afsluittijd voor de Test.';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'De nieuwe tijdslimiet voor de Test.';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'De nieuwe openingstijd voor de Test.';
$string['privacy:metadata:quiz_overrides:userid'] = 'De gebruiker die wordt overschreven';
$string['privacy:metadata:quizaccess'] = 'De activiteit Test maakt gebruik van toegangsregels voor test.';
$string['publish'] = 'Publiceer';
$string['publishedit'] = 'Je moet rechten hebben in de cursus die deze vragen publiceert om in deze categorie vragen te kunnen toevoegen of bewerken.';
$string['qbrief'] = 'V. {$a}';
$string['qname'] = 'naam';
$string['qti'] = 'IMS QTI-opmaak';
$string['qtypename'] = 'type, naam';
$string['question'] = 'Vraag';
$string['questionbank'] = 'uit vragenpool';
$string['questionbankmanagement'] = 'Vragenpool beheer';
$string['questionbehaviour'] = 'Vraaggedrag';
$string['questioncats'] = 'Vraagcategorieën';
$string['questiondeleted'] = 'Deze vraag is verwijderd. Neem contact op met je leraar.';
$string['questiondependencyadd'] = 'Er is geen beperking op wanneer vraag {$a->thisq} kan beantwoord worden. Klik om te wijzigen';
$string['questiondependencyfree'] = 'Geen beperking op deze vraag';
$string['questiondependencyremove'] = 'Vraag {$a->thisq} kan niet beantwoord worden voor de vorige vraag {$a->previousq} voltooid is. Klik om te wijzigen';
$string['questiondependsonprevious'] = 'Deze vraag kan niet beantwoord worden voor de vorige vraag voltooid is.';
$string['questiondraftonly'] = 'De vraag {$a} heeft alle versies in de status concept. Bezoek de vragenpool en stel de status in op gereed om deze vraag te kunnen gebruiken.';
$string['questiondraftwillnotwork'] = 'Deze vraag heeft alle versies in de status concept. Bezoek de vragenpool en stel de status in op gereed.';
$string['questioninuse'] = 'De vraag \'{$a}\' is op dit moment al in gebruik:';
$string['questionmissing'] = 'Vraag voor deze sessie ontbreekt';
$string['questionname'] = 'Naam vraag';
$string['questionnonav'] = '<span class="accesshide">Vraag </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Informatie </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Vraag {$a} is niet geladen vanuit de databank';
$string['questionorder'] = 'Vraagvolgorde';
$string['questionposition'] = 'Nieuwe positie in volgorde voor vraag {$a}';
$string['questions'] = 'Vragen';
$string['questionsetpreview'] = 'Voorvertoning vragenset';
$string['questionsinclhidden'] = 'Vragen (verborgen inbegrepen)';
$string['questionsinthisquiz'] = 'Vragen in deze test';
$string['questionsmatchingfilter'] = 'Vragen die overeenkomen met dit filter: {$a}';
$string['questionsperpage'] = 'Maximaal aantal vragen per pagina';
$string['questionsperpageselected'] = 'Het aantal vragen per pagina is vooraf vastgesteld. Daarom zijn de pagineringsmogelijkheden uitgeschakeld. Je kunt dit wijzigen in {$a}';
$string['questionsperpagex'] = 'Aantal vragen per pagina: {$a}';
$string['questiontext'] = 'Vraag tekst';
$string['questiontextisempty'] = '[Lege vraag tekst]';
$string['questiontype'] = 'Vraagtype {$a}';
$string['questiontypesetupoptions'] = 'Instellingen voor vraagtypes';
$string['questionversion'] = 'v{$a}';
$string['questionversionlatest'] = 'v{$a} (laatste)';
$string['quiz:addinstance'] = 'Voeg een nieuwe test toe';
$string['quiz:attempt'] = 'Pogingen voor test';
$string['quiz:deleteattempts'] = 'Verwijder pogingen voor test';
$string['quiz:emailconfirmsubmission'] = 'Ontvang een bevestiging wanneer je een test instuurt';
$string['quiz:emailnotifyattemptgraded'] = 'Ontvang een melding wanneer je poging is beoordeeld';
$string['quiz:emailnotifysubmission'] = 'Ontvang een melding wanneer je leerlingen een test insturen';
$string['quiz:emailwarnoverdue'] = 'Ontvang een waarschuwing wanneer je test-poging te laat is';
$string['quiz:grade'] = 'Handmatig (toets)cijfers aanpassen';
$string['quiz:ignoretimelimits'] = 'Negeert tijdslimiet op testen';
$string['quiz:manage'] = 'Testen beheren';
$string['quiz:manageoverrides'] = 'Beheer de overschrijvingen van instellingen van de test';
$string['quiz:preview'] = 'Testen bekijken';
$string['quiz:regrade'] = 'Testpogingen opnieuw nakijken';
$string['quiz:reopenattempts'] = 'Open nooit ingediende testpogingen opnieuw';
$string['quiz:reviewmyattempts'] = 'Herlees je eigen pogingen';
$string['quiz:view'] = 'Testinformatie bekijken';
$string['quiz:viewoverrides'] = 'Overschrijvingen van instellingen van de test bekijken';
$string['quiz:viewreports'] = 'Testresultaten bekijken';
$string['quizavailable'] = 'De test is beschikbaar tot: {$a}';
$string['quizclose'] = 'Sluit de test';
$string['quizclosed'] = 'Deze test  wordt op {$a} gesloten';
$string['quizcloses'] = 'Test gaat dicht';
$string['quizcloseson'] = 'Deze test sluit op {$a}.';
$string['quizeventcloses'] = '{$a} sluit';
$string['quizeventopens'] = '{$a} opent';
$string['quizinvalidquestions'] = 'Deze test bevat vragen met ongeldige types. Het ontbrekende vraagtype moet opnieuw worden geïnstalleerd of de betreffende vragen moeten worden verwijderd voordat de test kan worden gebruikt.';
$string['quizisclosed'] = 'Deze test is gesloten';
$string['quizisclosedwillopen'] = 'Test gesloten (opent {$a})';
$string['quizisopen'] = 'Deze test is open';
$string['quizisopenwillclose'] = 'Test open (sluit {$a})';
$string['quiznavigation'] = 'Testnavigatie';
$string['quizopen'] = 'Open de test';
$string['quizopenclose'] = 'Open en sluit data';
$string['quizopenclose_help'] = 'Leerlingen kunnen hun pogingen enkel starten na de open tijd en ze moeten er mee klaar zijn voor de sluit tijd.';
$string['quizopenclose_link'] = 'mod/quiz/timing';
$string['quizopendatesoonhtml'] = '<p>Beste {$a->firstname},</p>
<p>De test <strong>{$a->quizname}</strong> in cursus {$a->coursename} gaat binnenkort open.
<p><strong>Opent: {$a->timeopen}</strong></p>
<p><strong>Sluit: {$a->timeclose}</strong></p>
<p><a href="{$a->url}">Ga naar de test</a></p>';
$string['quizopendatesoonsubject'] = 'Opent op {$a->timeopen}: {$a->quizname}';
$string['quizopened'] = 'Deze test is open.';
$string['quizopenedon'] = 'Deze test opende op {$a}';
$string['quizopens'] = 'De test gaat open';
$string['quizopenwillclose'] = 'Deze test is open en sluit op {$a} om';
$string['quizordernotrandom'] = 'Volgorde van de vragen niet door elkaar gehaald';
$string['quizorderrandom'] = '* Volgorde van de vragen door elkaar gehaald';
$string['quizreport'] = 'Testrapport';
$string['quizsettings'] = 'Instellingen van de test';
$string['quizsetupnavigation'] = 'Navigatie testinstellingen';
$string['quiztimer'] = 'Test timer';
$string['quizwillopen'] = 'Deze test opent op {$a}';
$string['random'] = 'Willekeurige vraag';
$string['randomcatwithsubcat'] = '{$a} en subcategorieën';
$string['randomcoursecatwithsubcat'] = 'Elke categorie in een cursuscategorie {$a}';
$string['randomcoursewithsubcat'] = 'Elke categorie in deze cursus';
$string['randomcreate'] = 'Maak willekeurige vragen';
$string['randomediting'] = 'Een willekeurige vraag bewerken';
$string['randomfaultynosubcat'] = 'Beschadigde vraag';
$string['randomfromcategory'] = 'Willekeure vraag uit categorie:';
$string['randomfromexistingcategory'] = 'Willekeurig vraag van een bestaande categorie';
$string['randomfromunavailabletag'] = '{$a} (niet beschikbaar)';
$string['randommodulewithsubcat'] = 'Elke categorie van deze test';
$string['randomnosubcat'] = 'Enkel vragen uit deze categorie, niet uit de subcategorieën';
$string['randomnumber'] = 'Aantal willekeurige vragen';
$string['randomqname'] = 'Willekeurige vraag op basis van filtervoorwaarde';
$string['randomqnamecat'] = 'Willekeurig  ({$a->category})  gebaseerd op filtervoorwaarden';
$string['randomqnamecattags'] = 'Willekeurig ({$a->category}) gebaseerd op filtervoorwaarden met tags: {$a->tags}';
$string['randomqnametags'] = 'Willekeurige vraag gebaseerd op filtervoorwaarde met tags: {$a}';
$string['randomquestion'] = 'Willekeurige vraag';
$string['randomquestion_help'] = 'Een willekeurige vraag is een manier om willekeurig gekozen vragen uit een gespecificeerde categorie of via een gespecificeerde tag in een activiteit in te voegen.';
$string['randomquestiontags'] = 'Tags';
$string['randomquestiontags_help'] = 'Je kunt de selectiecriteria verder beperken door hier vraagtags te specificeren.

De "willekeurige" vragen zullen worden geselecteerd uit de vragen die al deze tags hebben.';
$string['randomquestionusinganewcategory'] = 'Willekeurige vraag van een nieuwe categorie';
$string['randomsystemwithsubcat'] = 'Elke categorie op systeemniveau';
$string['randomwithsubcat'] = 'Vragen uit deze categorie en uit de subcategorieën ervan.';
$string['readytosend'] = 'Je staat op het punt om de test in te sturen zodat hij beoordeeld kan worden. Weet je zeker dat je door wilt gaan?';
$string['reattemptquiz'] = 'Herkans de test';
$string['recentlyaddedquestion'] = 'Recent toegevoegde vraag!';
$string['recurse'] = 'Gebruik ook vragen in subcategorieën';
$string['redoesofthisquestion'] = 'Andere vragen hier geprobeerd: {$a}';
$string['redoquestion'] = 'Probeer een andere vraag zoals de deze';
$string['regrade'] = 'Herbereken alle pogingen';
$string['regradecomplete'] = 'Alle pogingen zijn herberekend';
$string['regradecount'] = '{$a->changed} van de {$a->attempt} cijfers zijn gewijzigd';
$string['regradedisplayexplanation'] = 'Pogingen die gewijzigd worden tijdens het herberekenen van de cijfers, worden als links getoond in het venster voor herberekening van de vragen';
$string['regradenotallowed'] = 'Je hebt onvoldoende rechten om deze test te herberekenen';
$string['regradingquestion'] = '"{$a}" aan het herberekenen';
$string['regradingquiz'] = 'Test "{$a}" aan het herbeoordelen';
$string['remove'] = 'Verwijder';
$string['removeallgroupoverrides'] = 'Alle groepsoverschrijvingen';
$string['removeallquizattempts'] = 'Alle pogingen van de test';
$string['removealluseroverrides'] = 'Alle gebruikersoverschrijvingen';
$string['removeemptypage'] = 'Verwijder lege pagina';
$string['removepagebreak'] = 'Verwijder paginascheiding';
$string['removeselected'] = 'Verwijder selectie';
$string['rename'] = 'Hernoem';
$string['renderingserverconnectfailed'] = 'De server {$a} slaagde er niet in een RQP aanvraag te verwerken. Controleer of de URL juist is.';
$string['reopenattempt'] = 'Opnieuw openen';
$string['reopenattemptareyousuremessage'] = 'Weet je zeker dat je testpoging {$a->attemptnumber} van {$a->attemptuser} opnieuw wilt openen?';
$string['reopenattemptareyousuretitle'] = 'Opnieuw openen?';
$string['reopenattemptwrongstate'] = 'Poging {$a->attemptid} is in de verkeerde status ({$a->state}) om opnieuw te worden geopend.';
$string['reopenedattemptwillbeinprogress'] = 'De poging blijft openstaan en kan worden voortgezet.';
$string['reopenedattemptwillbeinprogressuntil'] = 'De heropende poging blijft open en deze kan worden voortgezet tot de test sluit op {$a}.';
$string['reopenedattemptwillbesubmitted'] = 'De poging wordt onmiddellijk ter beoordeling ingestuurd.';
$string['reorderquestions'] = 'Verander de vraagvolgorde';
$string['reordertool'] = 'Verander vraagvolgorde';
$string['repaginate'] = 'Herpagineer met {$a} vragen per pagina';
$string['repaginatecommand'] = 'Herpagineer';
$string['repaginatenow'] = 'Herpagineer nu';
$string['replace'] = 'Vervang';
$string['replacementoptions'] = 'Vervangopties';
$string['report'] = 'Rapporten';
$string['reportanalysis'] = 'Vraag-analyse';
$string['reportattemptsfrom'] = 'Pogingen van';
$string['reportattemptsthatare'] = 'Pogingen die zijn';
$string['reportdisplayoptions'] = 'Toonopties';
$string['reportfullstat'] = 'Gedetailleerde cijfers';
$string['reportmulti_percent'] = 'Verschillende percentages';
$string['reportmulti_q_x_student'] = 'Keuzes van meerdere leerlingen';
$string['reportmulti_resp'] = 'Individuele antwoorden';
$string['reportmustselectstate'] = 'Je moet minstens één status kiezen';
$string['reportnotfound'] = 'Rapport onbekend ({$a})';
$string['reportoverview'] = 'Overzicht';
$string['reportregrade'] = 'Cijfers herberekenen';
$string['reportresponses'] = 'Antwoorddetails';
$string['reports'] = 'Rapporten';
$string['reportshowonly'] = 'Enkel pogingen tonen';
$string['reportshowonlyfinished'] = 'Toon maximum één voltooide poging per gebruiker ({$a})';
$string['reportsimplestat'] = 'Eenvoudige statistieken';
$string['reportusersall'] = 'alle gebruikers met een testpoging';
$string['reportuserswith'] = 'aangemelde gebruikers met een testpoging';
$string['reportuserswithorwithout'] = 'aangemelde gebruikers die wel of geen testpoging hebben';
$string['reportuserswithout'] = 'aangemelde gebruikers die nog geen testpoging hebben';
$string['reportwhattoinclude'] = 'Wat moet er in het rapport';
$string['requirepassword'] = 'Wachtwoord nodig';
$string['requirepassword_help'] = '<p>Dit veld is optioneel</p>

<p>Als je hier een wachtwoord ingeeft, dan moet elke deelnemer dit wachtwoord ingeven voor hij aan deze test mag beginnen.</p>';
$string['requiresubnet'] = 'Netwerkadres is nodig';
$string['requiresubnet_help'] = '<p>Dit veld is optioneel.</p>

<p>Je kunt de toegang tot deze test beperken tot bepaalde subnetten van het LAN of internet door hier een lijst te plaatsen van hele of gedeeltelijke IP-adressen, door komma\'s gescheiden.</p>

<p>Dit is vooral nuttig voor een afgeschermde test, waarbij je er zeker van wil zijn dat alleen de mensen in een bepaalde kamer deze test kunnen doen.</p>

<p>Bijvoorbeeld:  <b>192.168. , 231.54.211.0/20, 231.3.56.211</b></p>

<p>Er zijn drie types IP-adressen die je kunt gebruiken (je kunt geen domeinnamen geven zoals voorbeeld.com):
<ol>
<li>Volledige IP-adressen, zoals <b>192.168.10.1</b> die bij één enkele computer horen (of proxyserver).</li>
<li>Delen van IP-adressen, zoals <b>192.168</b> die horen bij alle computers waarvan de IP-adressen beginnen met die getallen.</li>
<li>CIDR-notatie, zoals <b>231.54.211.0/20</b> die je de mogelijkheid geeft om gedetailleerde subnetten te specifiëren.</li>
</ol>
</p>

<p>Spaties worden genegeerd.</p>';
$string['response'] = 'Antwoord';
$string['responses'] = 'Eigen antwoorden';
$string['results'] = 'Resultaten';
$string['returnattempt'] = 'Terug naar poging';
$string['reuseifpossible'] = 'gebruik verwijderde waarden opnieuw';
$string['reverttodefaults'] = 'Terug naar standaardinstellingen test.';
$string['review'] = 'Lees na';
$string['reviewafter'] = 'Sta nalezen toe nadat de test gesloten is';
$string['reviewalways'] = 'Sta nalezen altijd toe';
$string['reviewattempt'] = 'Poging nalezen';
$string['reviewbefore'] = 'Sta nalezen toe als de test open is';
$string['reviewclosed'] = 'Nadat de test gesloten is';
$string['reviewduring'] = 'Tijdens de poging';
$string['reviewimmediately'] = 'Onmiddellijk na de poging';
$string['reviewnever'] = 'Sta nooit nalezen toe';
$string['reviewofquestion'] = 'Herbekijk  {$a->question} in {$a->quiz} door {$a->user}';
$string['reviewopen'] = 'Later, terwijl de test nog open is (2 min)';
$string['reviewoptions'] = 'Leerlingen mogen nakijken';
$string['reviewoptionsheading'] = 'Opties voor herbekijken';
$string['reviewoptionsheading_help'] = 'Met deze optie controleer je welke informatie gebruikers kunnen zien wanneer zij een test nalezen of wanneer ze naar de testrapporten kijken.

**Tijdens de poging** zijn instellingen slechts relevant voor sommige scenario\'s, zoals \'interactief met meerdere pogingen\', die feedback kunnen tonen tijdens de poging.

**Onmiddellijk na een poging** betekent binnen de twee minuten nadat de gebruiker de test beëindigd heeft door op \'Bewaar alles en beëindig test te klikken.

**Later, terwijl de test nog open is** betekent na die twee minuten en voor de test sluit.

**Nadat de test gesloten is** betekent wanneer de sluittijd/datum verstreken is. Als voor de test geen sluittijd ingesteld is, wordt deze toestand nooit bereikt.';
$string['reviewoverallfeedback'] = 'Algemene feedback';
$string['reviewoverallfeedback_help'] = 'De feedback die aan het eind van een poging gegeven wordt, afhankelijk van het totaalcijfer van de leerling.';
$string['reviewresponse'] = 'Kijk antwoord na';
$string['reviewresponsetoq'] = 'Antwoord bekijken (vraag {$a})';
$string['reviewthisattempt'] = 'Nakijken van je antwoorden voor deze poging';
$string['rqp'] = 'Externe vraag';
$string['rqps'] = 'Vragen op afstand';
$string['sameasoverall'] = 'Zelfde als voor overzichtscijfer';
$string['save'] = 'Bewaar';
$string['saveandedit'] = 'Bewaar de wijzigingen en bewerk de vragen';
$string['saveattemptfailed'] = 'Het bewaren van deze testpoging is mislukt.';
$string['savedfromdeletedcourse'] = 'Bewaard uit het verwijderde van "{$a}"';
$string['savegrades'] = 'Bewaar cijfers';
$string['savemanualgradingfailed'] = 'Aanpassing is niet opgeslagen. Controleer het bericht hieronder en probeer het opnieuw';
$string['savemyanswers'] = 'Bewaar mijn antwoorden';
$string['savenosubmit'] = 'Bewaar zonder te beëindigen';
$string['saveoverrideandstay'] = 'Bewaar en geef een andere overschrijving in';
$string['savequiz'] = 'Bewaar deze hele test';
$string['saving'] = 'Bewaren...';
$string['savingnewgradeforquestion'] = 'Nieuw cijfer bewaren voor vraag id {$a}.';
$string['savingnewmaximumgrade'] = 'Nieuw maximumcijfer instellen.';
$string['score'] = 'Ruwe score';
$string['scores'] = 'Scores';
$string['search:activity'] = 'Test - activiteitsinformatie';
$string['searchbyname'] = 'Zoek op naam...';
$string['sectionheadingedit'] = 'Bewerk kop  \'{$a}\'';
$string['sectionheadingremove'] = 'Verwijder kop \'{$a}\'';
$string['sectionnoname'] = 'Naamloze sectie';
$string['seequestions'] = '(zie vragen)';
$string['select'] = 'Selecteer';
$string['selectall'] = 'Selecteer alle';
$string['selectattempt'] = 'Selecteer poging';
$string['selectcategory'] = 'Selecteer categorie';
$string['selectedattempts'] = 'Selecteer pogingen...';
$string['selectmultipleitems'] = 'Selecteer meerdere items';
$string['selectmultipletoolbar'] = 'Selecteer meerdere werkbalk';
$string['selectnone'] = 'Selecteer geen';
$string['selectquestionbank'] = 'Kies vragenpoel';
$string['selectquestionslot'] = 'Selecteer vraag {$a}';
$string['selectquestiontype'] = '--Selecteer vraagtype--';
$string['sendnotificationopendatesoon'] = 'Verwittig gebruiker voor een aankomende test opendatum';
$string['serveradded'] = 'Server toegevoegd';
$string['serveridentifier'] = 'Identificatie';
$string['serverinfo'] = 'Serverinformatie';
$string['servers'] = 'Servers';
$string['serverurl'] = 'Server URL';
$string['shortanswer'] = 'Kort antwoord';
$string['show'] = 'Laat zien';
$string['showall'] = 'Toon alle vragen op één pagina';
$string['showblocks'] = 'Toon blokken tijdens testpogingen';
$string['showblocks_help'] = 'Indien ja zullen normale blokken getoond worden tijdens testpogingen';
$string['showbreaks'] = 'Toon paginascheidingen';
$string['showcategorycontents'] = 'Toon categorie-inhoud {$a->arrow}';
$string['showcorrectanswer'] = 'In de feedback, de juiste antwoorden laten zien?';
$string['showdetailedmarks'] = 'beoordelingsdetails';
$string['showeachpage'] = 'Toon één pagina tegelijk';
$string['showfeedback'] = 'Feedback laten zien na het beantwoorden?';
$string['showinsecurepopup'] = 'Gebruik een \'veilig\' pop-upvenster voor pogingen';
$string['showlargeimage'] = 'Grote afbeelding';
$string['shownoattempts'] = 'leerlingen die de test nog niet gemaakt hebben';
$string['shownoattemptsonly'] = 'Toon enkel leerlingen zonder pogingen';
$string['shownoimage'] = 'Geen afbeelding';
$string['showreport'] = 'Toon rapport';
$string['showsmallimage'] = 'Kleine afbeelding';
$string['showteacherattempts'] = 'Toon de pogingen van de leraar';
$string['showuserpicture'] = 'Toon de foto van de gebruiker';
$string['showuserpicture_help'] = '<p>Als je deze optie inschakelt, zal de naam en foto van de leerling zichtbaar op het scherm gehouden worden tijdens een poging van de test en tijdens het nalezen.</p>

<p>Eén voorbeeld van wanneer je dit zou willen doen is tijdens het afnemen van examens waarbij je zelf aanwezig bent, zodat je kan zien of de leerling wel als zichzelf is aangemeld.</p>';
$string['shuffle'] = 'Willekeurige volgorde';
$string['shuffleanswers'] = 'Mix de antwoorden';
$string['shuffledrandomly'] = 'Willekeurige volgorde';
$string['shufflequestions'] = 'Mix de vragen';
$string['shufflequestions_help'] = 'Als je dit inschakelt, dan zal telkens wanneer de test geprobeerd wordt de volgorde van de vragen in deze sectie gewijzigd worden in willekeurige volgorde.

Dit kan het moeilijker maken voor leerlingen om te spieken, maar het maakt het ook moeilijker wanneer leerlingen een bepaalde vraag met de leraar willen bespreken.';
$string['shufflewithin'] = 'Haal antwoordvolgorde door elkaar';
$string['shufflewithin_help'] = '<p>Als je deze optie inschakelt, dan zullen de onderdelen waaruit elke vraag bestaat willekeurig door elkaar gehaald worden bij elke poging dat een leerling doet om de test te maken - gesteld dat deze optie ook ingesteld is bij de vragen van de test.</p>

<p>De bedoeling hiervan is om het de leerlingen moeilijker te maken om te spieken.</p>

<p>Dit is natuurlijk alleen van toepassing op vragen die uit meerdere onderdelen bestaan, zoals
   meerkeuzevragen en koppelvragen. Bij meerkeuzevragen wordt de volgorde van de antwoorden alleen verwisseld als deze instelling op "ja" staat. Voor koppelvragen worden de antwoorden altijd verwisseld. Met deze instelling kun je bepalen of ook nog eens de vraag-antwoord paren verwisseld worden.</p>

<p>Deze instelling heeft niets te maken met het gebruik van willekeurige vragen.</p>';
$string['singleanswer'] = 'Kies een antwoord';
$string['sortage'] = 'Sorteer op datum';
$string['sortalpha'] = 'Sorteer alfabetisch';
$string['sortquestionsbyx'] = 'Sorteer vragen volgens: {$a}';
$string['sortsubmit'] = 'Sorteer vragen';
$string['sorttypealpha'] = 'Sorteer op type, naam';
$string['specificapathnotonquestion'] = 'Het opgegeven pad is niet in de opgegeven vraag';
$string['specificquestionnotonquiz'] = 'De opgegeven vraag is niet in de opgegeven test';
$string['startagain'] = 'Start opnieuw';
$string['startattempt'] = 'Start poging';
$string['startedon'] = 'Gestart';
$string['startnewpreview'] = 'Start een nieuwe testpoging';
$string['stateabandoned'] = 'Nooit ingestuurd';
$string['statefinished'] = 'Beëindigd';
$string['statefinisheddetails'] = 'Ingestuurd {$a}';
$string['stateinprogress'] = 'Bezig';
$string['statenotloaded'] = 'De status van vraag {$a} is niet geladen vanuit de databank';
$string['statenotstarted'] = 'Niet gestart';
$string['stateoptions'] = 'Opties voor pogingstatus';
$string['stateoverdue'] = 'Te laat';
$string['stateoverduedetails'] = 'Moet ingestuurd worden door {$a}';
$string['statesubmitted'] = 'Ingestuurd';
$string['status'] = 'Status';
$string['stoponerror'] = 'Stop bij fout';
$string['submission_confirmation'] = 'Al je antwoorden insturen en test beëindigen?';
$string['submission_confirmation_unanswered'] = 'Vragen zonder antwoord: {$a}';
$string['submitallandfinish'] = 'Bewaar alles en beëindig test';
$string['subneterror'] = 'Deze test is zo beveiligd dat hij alleen toegankelijk is vanaf bepaalde plaatsen. Jouw computer staat niet in de lijst met toegelaten machines om deze test te maken.';
$string['subnetnotice'] = 'De test is vastgezet, zodat hij alleen geopend kan worden vanaf bepaalde plaatsen. Jouw computer staat niet op een toegelaten subnet. Als leraar kun je wel een voorbeeld bekijken.';
$string['subplugintype_quiz'] = 'Rapport';
$string['subplugintype_quiz_plural'] = 'Rapporten';
$string['subplugintype_quizaccess'] = 'Toegangsregel';
$string['subplugintype_quizaccess_plural'] = 'Toegangsregels';
$string['substitutedby'] = 'zal vervangen worden door';
$string['summaryofattempt'] = 'Samenvatting van poging';
$string['summaryofattempts'] = 'Jouw pogingen';
$string['temporaryblocked'] = 'Je mag tijdelijk deze test niet opnieuw proberen<br /> Je mag een niewe poging doen op:';
$string['theattempt'] = 'De poging';
$string['theattempt_help'] = 'Of de leerling de poging mag nalezen.';
$string['time'] = 'Tijd';
$string['timecompleted'] = 'Voltooid';
$string['timedelay'] = 'Je mag de test nog niet doen, omdat je nog niet lang genoeg gewacht hebt om deze test opnieuw te proberen';
$string['timeleft'] = 'Resterende tijd';
$string['timelimit'] = 'Tijdsduurlimiet';
$string['timelimit_help'] = 'Indien ingeschakeld, wordt de beschikbare tijd getoond op de initiële testpagina en wordt er een aftellende timer getoond in het navigatieblok van de test.';
$string['timelimit_link'] = 'mod/quiz/timing';
$string['timelimitexeeded'] = 'Sorry, de tijdsduur voor deze test is overschreden!';
$string['timestr'] = '%H:%M:%S op %d/%m/%y';
$string['timesup'] = 'Tijd is op!';
$string['timing'] = 'Tijd';
$string['tofile'] = 'naar bestand';
$string['tolerance'] = 'Tolerantie';
$string['toomanyrandom'] = 'Er zijn meer willekeurige vragen vereist, dan er in deze categorie zitten! ({$a})';
$string['top'] = 'Naar boven';
$string['totalmarks'] = 'Totaalcijfer';
$string['totalmarksx'] = 'Totaalcijfer: {$a}';
$string['totalquestionsinrandomqcategory'] = '{$a} vragen in de categorie';
$string['true'] = 'Waar';
$string['truefalse'] = 'Waar/Onwaar';
$string['type'] = 'Soort';
$string['unfinished'] = 'open';
$string['ungraded'] = 'Nog geen cijfer';
$string['unit'] = 'Eenheid';
$string['unknowntype'] = 'Vraagtype op lijn {$a} niet ondersteund. De vraag zal genegeerd worden';
$string['updatefilterconditon'] = 'Filtervoorwaarden bijwerken';
$string['updatefilterconditon_success'] = 'Filtervoorwaarden zijn bijgewerkt';
$string['updateoverdueattemptstask'] = 'Achterstallige testpogingen bijwerken';
$string['updatequizslotswithrandomxofy'] = 'Testslots met data van "willekeurige" vragen ({$a->done}/{$a->total})';
$string['updatesettings'] = 'Instellingen test bijwerken';
$string['updatingatttemptgrades'] = 'Cijfers updaten';
$string['updatingfinalgrades'] = 'Totaalcijfers updaten';
$string['updatingthegradebook'] = 'Cijferlijst updaten';
$string['upgradesure'] = '<div>Vooral de testmodule zal ingrijpende wijzigingen aanbrengen aan de tabellen. Deze upgrade is nog onvoldoende getest. Het is echt noodzakelijk dat je eerst een back-up van je databank  maakt voor je verder gaat.</div>';
$string['upgradingquizattempts'] = 'Testpogingen upgraden: test {$a->done}/{$a->outof} (TestID {$a->info}';
$string['upgradingveryoldquizattempts'] = 'Heel oude testpogingen aan het upgraden: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Deze categorie is verplaatst naar het site-niveau omdat na het verwijderen van de cursus bleek dat de vragen nog door andere testen op de server gebruikt worden.';
$string['useroverrides'] = 'Gebruikersoverschrijvingen';
$string['useroverridesdeleted'] = 'Gebruikersoverschrijvingen verwijderd';
$string['usersnone'] = 'Leerlingen hebben geen toegang tot deze test';
$string['validate'] = 'Valideer';
$string['viewallanswers'] = 'Bekijk {$a} voltooide testen';
$string['viewallreports'] = 'Bekijk overzicht van {$a} pogingen';
$string['viewed'] = 'Bekeken';
$string['warningmissingtype'] = '<b>Dit vraagtype is nog niet geïnstalleerd op je Moodleserver.<br />Waarschuw je Moodle beheerder.</b>';
$string['wheregrade'] = 'Waar is mijn cijfer?';
$string['wildcard'] = 'Jokerteken';
$string['windowclosing'] = 'Dit venster gaat gesloten worden.';
$string['withsummary'] = 'met samenvattende statistieken';
$string['wronguse'] = 'Je kunt deze pagina niet op die manier gebruiken';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Je moet aangemeld zijn bij deze cursus voor je deze test kunt maken.';
$string['yourfinalgradeis'] = 'Je eindcijfer voor deze test is {$a}';
