<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'advmindmap', language 'fr', version '5.1'.
 *
 * @package     advmindmap
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advmindmap'] = 'Carte mentale avancée';
$string['advmindmap:addinstance'] = 'Ajouter une session Carte mentale avancée';
$string['advmindmap:givecomment'] = 'Commenter';
$string['advmindmap:submit'] = 'Soumettre';
$string['advmindmap:view'] = 'Afficher';
$string['advmindmap:viewother'] = 'Afficher autre';
$string['advmindmapfieldset'] = 'Exemple de champ personnalisé';
$string['advmindmapintro'] = 'Introduction à la Carte mentale avancée';
$string['advmindmapname'] = 'Nom de la Carte mentale avancée';
$string['class'] = 'Classe';
$string['classno'] = 'Numéro de classe';
$string['copylink'] = '(Ctrl+C pour copier)';
$string['coursemisconf'] = 'Le cours est mal configuré';
$string['detail'] = 'Carte mentale avancée';
$string['detail_help'] = 'Carte mentale avancée<div class="indent">
<p>Une carte mentale est un diagramme utilisé pour représenter des mots, des idées, des tâches, ou d’autres éléments liés et organisés autour d’une idée ou notion clé centrale.</p>
<table class="advmindmap_help_table">
<tbody>
<tr>
<th width="40%">Fonction</th>
<th width="60%">Commande</th>
</tr>
<tr>
<td>Ajouter un nœud</td>
<td>- Double-cliquez à n’importe quel endroit<br />- Cliquez sur l’icône verte "+"<br />- Appuyez sur « Inser » pour ajouter un nœud affilié </td>
</tr>
<tr>
<td>Supprimer une note</td>
<td>- Appuyez sur « Ctrl » et cliquez sur le nœud<br />- Cliquez sur l’icône rouge « - »<br />- Appuyez sur « Suppr »</td>
</tr>
<tr>
<td>Rétablir/Répéter</td>
<td>- Faites « Ctrl »+« Z » ou « Ctrl »+« Y » sur votre clavier<br />- Cliquez sur les icônes flèche avant ou flèche arrière<br /></td>
</tr>
<tr>
<td>Bouger un nœud</td>
<td>Cliquez sur un nœud et déplacez le pour le bouger</td>
</tr>
<tr>
<td rowspan="1">Sauver carte mentale</td>
<td rowspan="1">Cliquez sur l’icône « disquette » dans le coin supérieur gauche</td>
</tr>
</tbody>
</table>
<p>(Le Module Mindmap (Carte mentale) a été développé originalement par <a href="http://ekpenso.com">ekpenso.com</a>. It is then modified by <a href="http://www.cite.hku.hk">CITE</a>.)</p>
</div>';
$string['editable'] = 'Modifiable';
$string['editingbyuser'] = 'Cette carte mentale de groupe est/a été modifiée par <span style="font-weight:bold;">{$a}</span> dans la dernière heure et est donc verrouillée.';
$string['errorcannotunlockadvmindmap'] = 'Impossible de déverrouiller la carte mentale, session incorrecte.';
$string['errorcannotviewgroupmindmap'] = 'Vous n’avez pas la permission de voir la carte mentale d’un autre groupe.';
$string['errorcannotviewusermindmap'] = 'Vous n’avez pas la permission de voir la carte mentale d’un autre utilisateur.';
$string['errorincorrectcmid'] = 'L’identifiant du module de cours est incorrect.';
$string['errorinvalidadvmindmap'] = 'Session Carte mentale avancée incorrecte.';
$string['errorinvalidauthor'] = 'L’auteur de la carte mentale n’est pas un utilisateur valide.';
$string['errornostudentincourse'] = 'Pas d’étudiants dans ce cours.';
$string['errornotingroup'] = 'Ceci est une carte mentale de groupe mais vous n’êtes dans aucun groupe et n’avez pas l’autorisation de voir les cartes mentales des autres groupes.';
$string['errornouseringroup'] = 'Pas d’utilisateurs dans ce groupe.';
$string['eventmindmapunlocked'] = 'Une carte mentale a été déverrouillée.';
$string['eventmindmapupdated'] = 'Une carte mentale a été mise à jour.';
$string['groupmembers'] = 'Membres du groupe';
$string['groupname'] = 'Nom du groupe';
$string['instances'] = 'Sessions Carte mentale avancée';
$string['invalidgroupmodefordummygroups'] = 'Quand l’option groupes d’exemple est sélectionnée, le réglages mode de groupes doit être « Aucun groupe »';
$string['invalidid'] = 'L’identifiant Carte mentale avancée est incorrect';
$string['ismember'] = '(✔ vous êtes membre du groupe)';
$string['largeconvas'] = 'Élargir la zone d’édition';
$string['lastupdated'] = 'Dernière modification';
$string['lockedbyyou'] = 'Cette carte mentale de groupe est verrouillée par vous, cliquez sur ce bouton pour déverrouiller et retourner au cours :';
$string['modulename'] = 'Carte mentale avancée';
$string['modulenameplural'] = 'Cartes mentales avancées';
$string['notavailable'] = 'Pas encore accessible';
$string['numdummygroups'] = 'Nombre de groupes d’exemple';
$string['pluginadministration'] = 'Administration Carte mentale avancée';
$string['pluginname'] = 'Carte mentale avancée';
$string['print'] = 'Imprimer :';
$string['removeinstances'] = 'Effacer toutes les sessions de cartes mentales';
$string['smallconvas'] = 'Réduire la zone d’édition';
$string['uneditable'] = 'La carte mentale n’est pas modifiable actuellement !';
$string['uniquelink'] = 'Lien vers cette carte mentale';
$string['unlockbutton'] = 'Déverrouiller et retourner au cours';
$string['unlockconfirm'] = 'Voulez-vous vraiment déverrouiller cette carte mentale et retourner au cours (toutes les modifications non sauvegardées seront perdues) ?';
$string['unlocktime'] = 'Temps estimé avant déverrouillage (si aucune autre modification par l’utilisateur) :';
$string['viewing'] = '(Affichage)';
$string['viewingauthor'] = 'Affichage de la carte mentale de {$a}';
$string['viewown'] = 'Voir votre propre carte mentale';
