<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'h5p', language 'el', version '5.1'.
 *
 * @package     h5p
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a11yTitle:label'] = 'Ετικέτα για Τεχνολογίες Υποστήριξης';
$string['acceptTerms'] = 'Αποδέχομαι τους <a href=":url" target="_blank">όρους χρήσης</a>';
$string['accountDetailsLinkText'] = 'εδώ';
$string['actions'] = 'Ενέργειες';
$string['add'] = 'Προσθήκη';
$string['addedandupdatedpp'] = 'Προστέθηκαν {$a->%new} νέες βιβλιοθήκες H5P και ενημερώθηκαν {$a->%old} παλιές.';
$string['addedandupdatedps'] = 'Προστέθηκαν {$a->%new} νέες βιβλιοθήκες H5P και ενημερώθηκε {$a->%old} παλιά.';
$string['addedandupdatedsp'] = 'Προστέθηκε {$a->%new} νέα βιβλιοθήκη H5P και ενημερώθηκαν {$a->%old} παλιές.';
$string['addedandupdatedss'] = 'Προστέθηκε {$a->%new} νέα βιβλιοθήκη H5P και ενημερώθηκε {$a->%old} παλιά.';
$string['addednewlibraries'] = 'Προστέθηκαν {$a->%new} νέες βιβλιοθήκες H5P.';
$string['addednewlibrary'] = 'Προστέθηκε {$a->%new} νέα βιβλιοθήκη H5P.';
$string['additionallicenseinfo'] = 'Κάθε επιπρόσθετη πληροφορία για την άδεια χρήσης';
$string['address'] = 'Διεύθυνση';
$string['age'] = 'Τυπική ηλικία';
$string['ageDescription'] = 'Το κοινό-στόχος αυτού του περιεχομένου. Δυνατά μορφότυπα εισόδου χωρισμένα με κόμματα: "1,34-45,-50,59-".';
$string['altText'] = 'Εναλλακτικό κείμενο';
$string['atto_h5p'] = 'Πλήκτρο εισαγωγής H5P';
$string['atto_h5p_description'] = 'Το πλήκτρο Εισαγωγή H5P, στον επεξεργαστή Atto επιτρέπει στους χρήστες να εισάγουν περιεχόμενο H5P είτε εισάγοντας μια διεύθυνση URL, είτε ενσωματώνοντας κώδικα, είτε ανεβάζοντας ένα αρχείο H5P.';
$string['author'] = 'Συγγραφέας';
$string['authorcomments'] = 'Σχόλια συγγραφέα';
$string['authorcommentsdescription'] = 'Σχόλια για τον συντάκτη του περιεχομένου. (Αυτό το κείμενο δεν θα δημοσιευτεί ως ένα μέρος των πληροφοριών πνευματικών δικαιωμάτων.)';
$string['authorname'] = 'Όνομα συγγραφέα';
$string['authorrole'] = 'Ρόλος συγγραφέα';
$string['back'] = 'Πίσω';
$string['by'] = 'από';
$string['cancelCrop'] = 'Ακύρωση περικοπής';
$string['cancelPublishConfirmationDialogCancelButtonText'] = 'Όχι';
$string['cancelPublishConfirmationDialogConfirmButtonText'] = 'Ναι';
$string['cancelPublishConfirmationDialogDescription'] = 'Είστε σίγουροι ότι θέλετε να ακυρώσετε τη διαδικασία κοινοποίησης;';
$string['cancelPublishConfirmationDialogTitle'] = 'Ακύρωση κοινοποίησης';
$string['cancellabel'] = 'Άκυρο';
$string['ccattribution'] = 'Αναφορά Δημιουργού (CC BY)';
$string['ccattributionnc'] = 'Αναφορά Δημιουργού - Μη Εμπορική Χρήση (CC BY-NC)';
$string['ccattributionncnd'] = 'Αναφορά Δημιουργού - Μη Εμπορική Χρήση + Όχι Παράγωγα (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Αναφορά Δημιουργού - Μη Εμπορική Χρήση - Παρόμοια Διανομή (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Αναφορά Δημιουργού - Όχι Παράγωγα (CC BY-ND)';
$string['ccattributionsa'] = 'Αναφορά Δημιουργού - Παρόμοια Διανομή (CC BY-SA)';
$string['ccpdd'] = 'Αφιέρωση στον Δημόσιο Τομέα (CC0)';
$string['changedby'] = 'Αλλαγή από';
$string['changedescription'] = 'Περιγραφή της αλλαγής';
$string['changelog'] = 'Καταγραφές αλλαγών';
$string['changeplaceholder'] = 'Περικοπή φωτογραφίας, αλλαγή κειμένου, κλπ.';
$string['city'] = 'Πόλη';
$string['close'] = 'Κλείσιμο';
$string['confirmCrop'] = 'Επιβεβαίωση περικοπής';
$string['confirmdialogbody'] = 'Παρακαλούμε, επιβεβαιώστε ότι επιθυμείτε τη συνέχεια. Αυτή η ενέργεια δεν μπορεί να αναιρεθεί.';
$string['confirmdialogheader'] = 'Επιβεβαίωση ενέργειας';
$string['confirmlabel'] = 'Επιβεβαίωση';
$string['connectionLost'] = 'Η σύνδεση χάθηκε. Τα αποτελέσματα θα αποθηκευτούν και θα αποσταλούν όταν η σύνδεση αποκατασταθεί.';
$string['connectionReestablished'] = 'Η σύνδεση αποκαταστάθηκε.';
$string['contactPerson'] = 'Πρόσωπο επικοινωνίας';
$string['contentCopied'] = 'Το περιεχόμενο αντιγράφηκε στο πρόχειρο';
$string['contentLicenseTitle'] = 'Πληροφορίες άδειας περιεχομένου';
$string['contentchanged'] = 'Αυτό το περιεχόμενο έχει αλλάξει από τότε που το χρησιμοποιήσατε τελευταία φορά.';
$string['contentinuse'] = 'Αυτό το περιεχόμενο μπορεί να χρησιμοποιείται σε άλλα μέρη.';
$string['contenttype'] = 'Τύπος περιεχομένου';
$string['copyright'] = 'Άδειες χρήσης';
$string['copyrightinfo'] = 'Πληροφορίες δικαιωμάτων πνευματικής ιδιοκτησίας';
$string['copyrightstring'] = 'Δικαιώματα πνευματικής ιδιοκτησίας';
$string['copyrighttitle'] = 'Εμφάνιση πληροφοριών δικαιωμάτων πνευματικής ιδιοκτησίας για αυτό το περιεχόμενο.';
$string['couldNotParseJSONFromZip'] = 'Αδυναμία συντακτικής ανάλυσης JSON από το πακέτο: {$a->%fileName}';
$string['couldNotReadFileFromZip'] = 'Αδυναμία ανάγνωσης αρχείου από το πακέτο: {$a->%fileName}';
$string['country'] = 'Χώρα';
$string['creativecommons'] = 'Creative Commons';
$string['cropImage'] = 'Περικοπή εικόνας';
$string['currentStep'] = 'Βήμα :step από :total';
$string['date'] = 'Ημερομηνία';
$string['deletelibraryconfirm'] = '<p>Σίγουρα θέλετε να διαγράψετε την έκδοση <em>«{$a-version}»</em> από τη βιβλιοθήκη <em>«{$a-name}»</em>; Θα αφαιρεθεί η βιβλιοθήκη και όλες οι χρήσεις της.</p><p>Αυτή η λειτουργία δεν μπορεί να αναιρεθεί.</p>';
$string['deletelibraryversion'] = 'Διαγραφή έκδοσης';
$string['deleting'] = 'Διαγραφή μιας βιβλιοθήκης';
$string['description'] = 'Περιγραφή';
$string['disablefullscreen'] = 'Απενεργοποίηση πλήρους οθόνης';
$string['discipline:dropdownButton'] = 'Κουμπί επιλογών';
$string['discipline:in'] = 'σε';
$string['discipline:searchPlaceholder'] = 'Πληκτρολογήστε για αναζήτηση τομέων';
$string['disciplineDescription'] = 'Μπορείτε να επιλέξετε πολλούς τομείς';
$string['disciplineLabel'] = 'Τομείς';
$string['disciplineLimitReachedMessage'] = 'Μπορείτε να επιλέξετε έως :numDisciplines τομείς';
$string['disciplines'] = 'Τομείς';
$string['download'] = 'Λήψη';
$string['downloadtitle'] = 'Λήψη αυτού του περιεχομένου ως ένα αρχείο H5P.';
$string['editInfoTitle'] = 'Επεξεργασία πληροφοριών για <strong>:title</strong>';
$string['editcontent'] = 'Επεξεργασία περιεχομένου H5P';
$string['editingFailed'] = 'Η επεξεργασία απέτυχε.';
$string['editor'] = 'Συντάκτης';
$string['emailAddress'] = 'Διεύθυνση email';
$string['embed'] = 'Ενσωμάτωση';
$string['embedtitle'] = 'Εμφάνιση του κώδικα ενσωμάτωσης για αυτό το περιεχόμενο.';
$string['error:emptycontentid'] = 'Η δεδομένη διεύθυνση URL είναι λανθασμένη ή δεν μπορείτε να επεξεργαστείτε αυτό το αρχείο.';
$string['eventh5pdeleted'] = 'Το H5P διαγράφηκε';
$string['eventh5pviewed'] = 'Το περιεχόμενο H5P εμφανίστηκε';
$string['feature'] = 'Χαρακτηριστικό';
$string['fetchtypesfailure'] = 'Αδυναμία λήψης οποιασδήποτε πληροφορίας για τους διαθέσιμους τύπους περιεχομένου H5P. Αποτυχία σύνδεσης με το αποθετήριο H5P.';
$string['fileExceedsMaxSize'] = 'Ένα από τα αρχεία μέσα στο πακέτο υπερβαίνει το μέγιστο επιτρεπόμενο μέγεθος. ({$a->%file} {$a->%used} > {$a->%max})';
$string['filter_displayh5p'] = 'Εμφάνιση φίλτρου H5P';
$string['filter_displayh5p_description'] = 'Το φίλτρο Εμφάνιση H5P μετατρέπει τις διευθύνσεις URL σε ενσωματωμένο περιεχόμενο H5P.';
$string['fullscreen'] = 'Πλήρης οθόνη';
$string['gpl'] = 'Γενική δημόσια άδεια έκδ. 3';
$string['h5p'] = 'H5P';
$string['h5peditor'] = 'Επεξεργαστής H5P';
$string['h5pfilenotfound'] = 'Το αρχείο H5P δεν βρέθηκε';
$string['h5pinvalidurl'] = 'Μη έγκυρη διεύθυνση URL περιεχομένου H5P.';
$string['h5plibraryhandler'] = 'Χειριστήριο πλαισίου H5P';
$string['h5plibraryhandler_help'] = 'Το πλαίσιο H5P που χρησιμοποιείται για την εμφάνιση οποιουδήποτε περιεχομένου H5P. Συνιστάται η τελευταία έκδοση.';
$string['h5pmanage'] = 'Διαχείριση τύπων περιεχομένου H5P';
$string['h5poverview'] = 'Επισκόπηση H5P';
$string['h5ppackage'] = 'Τύπος περιεχομένου H5P';
$string['h5ppackage_help'] = 'Ένας τύπος περιεχομένου H5P είναι ένα αρχείο με μια επέκταση (ονόματος αρχείου) H5P ή ZIP, που περιέχει όλες τις βιβλιοθήκες που απαιτούνται για να εμφανιστεί το περιεχόμενο.';
$string['h5pprivatefile'] = 'Αυτό το περιεχόμενο H5P δεν μπορεί να εμφανιστεί διότι δεν έχετε πρόσβαση στο αρχείο .h5p';
$string['h5psettings'] = 'Ρυθμίσεις H5P';
$string['h5ptitle'] = 'Επισκεφθείτε το h5p.org για να δείτε κι άλλο περιεχόμενο.';
$string['height'] = 'ύψος';
$string['helpChoosingLicense'] = 'Βοήθεια για επιλογή άδειας';
$string['hideadvanced'] = 'Απόκρυψη προχωρημένων';
$string['icon'] = 'Εικονίδιο';
$string['iconDescription'] = '640x480px. Αν δεν επιλεγεί, το περιεχόμενο θα χρησιμοποιήσει το εικονίδιο κατηγορίας';
$string['installedcontentlibraries'] = 'Εγκατεστημένες βιβλιοθήκες H5P';
$string['installedcontenttypes'] = 'Εγκατεστημένοι τύποι περιεχομένου H5P';
$string['installedh5p'] = 'Εγκατεστημένα H5P';
$string['invalidAge'] = 'Μη έγκυρη μορφή εισόδου για Τυπική ηλικία. Δυνατές μορφές: "1, 34-45, -50, -59-".';
$string['invalidcontextid'] = 'Το αρχείο H5P δεν βρέθηκε (μη έγκυρο αναγνωριστικό πλαισίου συμφραζομένων)';
$string['invalidfile'] = 'Το αρχείο «{$a->%filename}» δεν επιτρέπεται. Μόνο αρχεία με τις ακόλουθες επεκτάσεις (ονομάτων αρχείων) επιτρέπονται: {$a->%files-allowed}.';
$string['invalidlanguagefile'] = 'Μη έγκυρο αρχείο γλώσσας {$a->%file} στην βιβλιοθήκη {$a->%library}';
$string['invalidlanguagefile2'] = 'Μη έγκυρο αρχείο γλώσσας {$a->%languageFile} συμπεριλήφθηκε στην βιβλιοθήκη {$a->%name}';
$string['invalidlibrarydata'] = 'Μη έγκυρα δεδομένα δόθηκαν για την ιδιότητα {$a->%property} στην βιβλιοθήκη {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Μη έγκυρα δεδομένα δόθηκαν για την ιδιότητα {$a->%property} στην βιβλιοθήκη {$a->%library}. Αναμενόταν τύπος αλήθειας (boolean).';
$string['invalidlibraryname'] = 'Μη έγκυρο όνομα βιβλιοθήκης: {$a->%name}';
$string['invalidlibrarynamed'] = 'Η βιβλιοθήκη H5P {$a->%library} που χρησιμοποιείται σε αυτό το περιεχόμενο δεν είναι έγκυρη';
$string['invalidlibraryoption'] = 'Ανεπίτρεπτη επιλογή {$a->%option} στην βιβλιοθήκη {$a->%library}';
$string['invalidlibraryproperty'] = 'Αδυναμία ανάγνωσης της ιδιότητας {$a->%property} στην βιβλιοθήκη {$a->%library}';
$string['invalidmainjson'] = 'Λείπει ένα έγκυρο κύριο αρχείο h5p.json';
$string['invalidmultiselectoption'] = 'Μη έγκυρη επιλεγμένη επιλογή σε πολλαπλής επιλογής';
$string['invalidpackage'] = 'Μη έγκυρος τύπος περιεχομένου H5P';
$string['invalidselectoption'] = 'Μη έγκυρη επιλεγμένη επιλογή σε επιλογή.';
$string['invalidsemanticsjson'] = 'Μη έγκυρο αρχείο semantics.json συμπεριλήφθηκε στην βιβλιοθήκη {$a->%name}';
$string['invalidsemanticstype'] = 'Εσωτερικό σφάλμα H5P: άγνωστος τύπος περιεχομένου «{$a->@type}» στη σημασιολογία. Κατάργηση περιεχομένου!';
$string['invalidstring'] = 'Η παρεχόμενη συμβολοσειρά δεν είναι έγκυρη σύμφωνα με το regexp στη σημασιολογία. (τιμή: «{$a->%value}», regexp: «{$a->%regexp}»)';
$string['keywordExists'] = 'Η λέξη-κλειδί υπάρχει ήδη!';
$string['keywords'] = 'Λέξεις-κλειδιά';
$string['keywordsDescription'] = 'Μπορείτε να προσθέσετε πολλαπλές λέξεις-κλειδιά χωρισμένες με κόμματα. Πατήστε "Enter" ή "Προσθήκη" για επιβεβαίωση';
$string['keywordsExits'] = 'Οι λέξεις-κλειδιά υπάρχουν ήδη!';
$string['keywordsPlaceholder'] = 'Προσθήκη λέξεων-κλειδιών';
$string['language'] = 'Γλώσσα';
$string['level'] = 'Επίπεδο';
$string['librariesmanagerdescription'] = '<p>Το H5P επιτρέπει στους χρήστες να δημιουργούν διαδραστικό περιεχόμενο παρέχοντας μια σειρά τύπων περιεχομένου.</p><p>Για να εξασφαλιστεί ότι χρησιμοποιούνται μόνο έμπιστοι τύποι περιεχομένου H5P στον ιστότοπό σας, χρειάζεται <i>είτε </i></p><ul><li>Ανέβασμα τύπων περιεχομένου H5P από το h5p.org <i>είτε </i></li><li><i>Ενεργοποίηση της χρονοπρογραμματισμένης εργασίας «Λήψη διαθέσιμων τύπων περιεχομένου H5P από το h5p.org»</li></ul><p>Σημειώστε ότι οι χρήστες θα μπορούν να χρησιμοποιούν μόνο τους τύπους περιεχομένου H5P που είναι εγκατεστημένοι στον ιστότοπό σας.</p>';
$string['librarydirectoryerror'] = 'Το όνομα καταλόγου βιβλιοθήκης πρέπει να ταιριάζει με το machineName (όνομα μηχανής) ή το machineName-majorVersion.minorVersion (όνομα μηχανής - γενική έκδοση . ειδικότερη έκδοση)(από το library.json). (Κατάλογος: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['license'] = 'Άδεια χρήσης';
$string['licenseCC010'] = 'CC0 1.0 Παγκόσμια (CC0 1.0) Εκχώρηση ως Κοινό Κτήμα';
$string['licenseCC010U'] = 'CC0 1.0 Παγκόσμια';
$string['licenseCC10'] = '1.0 Γενική';
$string['licenseCC20'] = '2.0 Γενική';
$string['licenseCC25'] = '2.5 Γενική';
$string['licenseCC30'] = '3.0 Unported (χωρίς προσαρμογή στην τοπική νομοθεσία)';
$string['licenseCC40'] = '4.0 Διεθνής';
$string['licenseDescription'] = 'Επιλέξτε μια άδεια για το περιεχόμενό σας';
$string['licenseDetails'] = 'Λεπτομέρειες άδειας';
$string['licenseDialogDescription'] = 'Κάντε κλικ σε μια συγκεκριμένη άδεια για περισσότερες πληροφορίες σχετικά με τη σωστή χρήση';
$string['licenseGPL'] = 'Γενική δημόσια άδεια';
$string['licenseV1'] = 'Έκδοση 1';
$string['licenseV2'] = 'Έκδοση 2';
$string['licenseV3'] = 'Έκδοση 3';
$string['licenseVersionDescription'] = 'Επιλέξτε μια έκδοση άδειας';
$string['licensee'] = 'Αδειούχος';
$string['licenseextras'] = 'Επιπρόσθετα άδειας χρήσης';
$string['licenseversion'] = 'Έκδοση άδειας χρήσης';
$string['lockh5pdeploy'] = 'Δεν είναι δυνατή η πρόσβαση σε αυτό το περιεχόμενο H5P επειδή εγκαθίσταται/ετοιμάζεται προς χρήση ακόμη. Παρακαλούμε δοκιμάστε ξανά αργότερα.';
$string['logoUploadText'] = 'Λογότυπο ή άβαταρ οργανισμού';
$string['longDescription'] = 'Αναλυτική περιγραφή';
$string['longDescriptionPlaceholder'] = 'Αναλυτική περιγραφή του περιεχομένου σας';
$string['mainTitle'] = 'Κοινοποίηση <strong>:title</strong>';
$string['mainlibrarydisabled'] = 'Αδυναμία εμφάνισης αυτού του αρχείου επειδή ο τύπος περιεχομένου του είναι απενεργοποιημένος. Παρακαλούμε, επικοινωνήστε με τον διαχειριστή σας για να ζητήσετε την ενεργοποίηση του τύπου περιεχομένου.';
$string['maxLength'] = 'Ο μέγιστος αριθμός χαρακτήρων είναι :length';
$string['missingcontentfolder'] = 'Λείπει ένας έγκυρος φάκελος περιεχομένου';
$string['missingcoreversion'] = 'Το σύστημα δεν μπόρεσε να εγκαταστήσει το στοιχείο {$a->%component} από το πακέτο, καθώς απαιτεί μια νεότερη έκδοση του πρόσθετου H5P. Αυτός ο ιστότοπος εκτελεί αυτή τη στιγμή έκδοση {$a->%current}, ενώ η απαιτούμενη έκδοση είναι {$a->%required} ή νεότερη. Παρακαλούμε, αναβαθμίστε και προσπαθήστε ξανά.';
$string['missingdependency'] = 'Λείπει εξάρτηση {$a->@dep} που απαιτείται από {$a->@lib}.';
$string['missinglibrary'] = 'Λείπει απαιτούμενη βιβλιοθήκη {$a->@library}';
$string['missinglibraryfile'] = 'Το αρχείο «{$a->%file}» λείπει από την βιβλιοθήκη: «{$a->%name}»';
$string['missinglibraryjson'] = 'Αδυναμία εύρεσης αρχείου library.json με έγκυρο μορφότυπο json για την βιβλιοθήκη {$a->%name}';
$string['missinglibraryproperty'] = 'Η απαιτούμενη ιδιότητα {$a->%property} λείπει από την {$a->%library}';
$string['missingmbstring'] = 'Η επέκταση mbstring PHP δεν φορτώθηκε. Απαιτείται για την σωστή λειτουργία του H5P.';
$string['missinguploadpermissions'] = 'Σημειώστε ότι οι βιβλιοθήκες ενδέχεται να υπάρχουν στο αρχείο που ανεβάσατε, αλλά δεν σας επιτρέπεται το ανέβασμα νέων βιβλιοθηκών. Παρακαλούμε, επικοινωνήστε με τον διαχειριστή σας.';
$string['next'] = 'Επόμενο';
$string['nocopyright'] = 'Καμία διαθέσιμη πληροφορία δικαιωμάτων πνευματικής ιδιοκτησίας, για αυτό το περιεχόμενο.';
$string['noextension'] = 'Το αρχείο που ανεβάσατε δεν είναι ένα έγκυρο πακέτο HTML5. (Δεν έχει την επέκταση αρχείου .h5p)';
$string['noh5plibhandlerdefined'] = 'Δεν υπάρχει εγκατεστημένος χειριστής πλαισίου H5P, οπότε δεν μπορεί να εμφανιστεί περιεχόμενο H5P.';
$string['nojson'] = 'Το κύριο αρχείο h5p.json δεν είναι έγκυρο';
$string['nopermissiontodeploy'] = 'Αυτό το αρχείο δεν μπορεί να εμφανιστεί επειδή έχει ανεβεί από ένα χρήστη χωρίς την απαιτούμενη δυνατότητα να εγκαταστήσει/χρησιμοποιήσει περιεχόμενο H5P.';
$string['nopermissiontoedit'] = 'Δεν έχετε δικαιώματα επεξεργασίας περιεχομένου H5P.';
$string['notrustablefile'] = 'Αυτό το αρχείο δεν μπορεί να εμφανιστεί επειδή έχει ανεβεί από έναν χρήστη χωρίς την δυνατότητα ενημέρωσης τύπων περιεχομένου H5P. Παρακαλούμε, επικοινωνήστε με τον διαχειριστή σας για να ζητήσετε να εγκατασταθεί ο τύπος περιεχομένου.';
$string['nounzip'] = 'Το αρχείο που ανεβάσατε δεν είναι ένα έγκυρο πακέτο HTML5. (Δεν αποσυμπιέζεται.)';
$string['offlineDialogBody'] = 'Δεν μπορέσαμε να αποστείλουμε πληροφορίες για την ολοκλήρωση αυτής της εργασίας σας. Παρακαλούμε, ελέγξτε την σύνδεσή σας στο Διαδίκτυο.';
$string['offlineDialogHeader'] = 'Η σύνδεσή σας με τον εξυπηρετητή χάθηκε';
$string['offlineDialogRetryButtonLabel'] = 'Προσπάθεια ξανά τώρα';
$string['offlineDialogRetryMessage'] = 'Προσπάθεια ξανά σε :αρ....';
$string['offlineSuccessfulSubmit'] = 'Τα αποτελέσματα υποβλήθηκαν με επιτυχία.';
$string['optionalInfo'] = 'Προαιρετικές πληροφορίες';
$string['originator'] = 'Αρχικός δημιουργός';
$string['pd'] = 'Κοινό Κτήμα';
$string['pddl'] = 'Εκχώρηση και Άδεια ως Κοινό Κτήμα';
$string['pdm'] = 'Σήμα Κοινού Κτήματος (PDM)';
$string['phone'] = 'Τηλέφωνο';
$string['pleaseWait'] = 'Παρακαλώ περιμένετε...';
$string['pluginname'] = 'Πακέτο H5P';
$string['privacy:metadata'] = 'Το υποσύστημα H5P δεν αποθηκεύει κανένα προσωπικό δεδομένο.';
$string['publisherDescription'] = 'Περιγραφή εκδότη';
$string['publisherDescriptionText'] = 'Αυτό θα εμφανίζεται κάτω από τις "Πληροφορίες εκδότη" στο κοινοποιημένο περιεχόμενο';
$string['publisherFieldDescription'] = 'Αυτό θα εμφανίζεται ως "Όνομα εκδότη" στο κοινοποιημένο περιεχόμενο';
$string['publisherFieldTitle'] = 'Εκδότης';
$string['remove'] = 'Αφαίρεση';
$string['removeChip'] = 'Αφαίρεση :chip από τη λίστα';
$string['removeImage'] = 'Αφαίρεση εικόνας';
$string['requiredInfo'] = 'Απαιτούμενες πληροφορίες';
$string['resizescript'] = 'Συμπεριλάβετε αυτό το σενάριο στον ιστότοπό σας αν θέλετε δυναμικό μέγεθος του ενσωματωμένου περιεχομένου:';
$string['resubmitScores'] = 'Προσπάθεια για υποβολή αποθηκευμένων αποτελεσμάτων.';
$string['reuse'] = 'Επαναχρησιμοποίηση';
$string['reuseContent'] = 'Επαναχρησιμοποίηση περιεχομένου';
$string['reuseDescription'] = 'Επαναχρησιμοποίηση αυτού του περιεχομένου';
$string['reviewAndSave'] = 'Ανασκόπηση & Αποθήκευση';
$string['reviewAndShare'] = 'Ανασκόπηση & Κοινοποίηση';
$string['reviewInfo'] = 'Ανασκόπηση πληροφοριών';
$string['reviewMessage'] = 'Παρακαλώ ανασκοπήστε τις παρακάτω πληροφορίες πριν κοινοποιήσετε';
$string['rotateLeft'] = 'Περιστροφή αριστερά';
$string['rotateRight'] = 'Περιστροφή δεξιά';
$string['saveChanges'] = 'Αποθήκευση αλλαγών';
$string['screenshots'] = 'Στιγμιότυπα οθόνης';
$string['screenshotsDescription'] = 'Προσθέστε έως πέντε στιγμιότυπα του περιεχομένου σας';
$string['share'] = 'Κοινοποίηση';
$string['shareFailed'] = 'Η κοινοποίηση απέτυχε.';
$string['shareTryAgain'] = 'Κάτι πήγε στραβά, παρακαλώ δοκιμάστε ξανά να κοινοποιήσετε.';
$string['shared'] = 'Κοινοποιήθηκε';
$string['sharingNote'] = 'Όλες οι λεπτομέρειες περιεχομένου μπορούν να επεξεργαστούν μετά την κοινοποίηση';
$string['shortDescription'] = 'Σύντομη περιγραφή';
$string['shortDescriptionPlaceholder'] = 'Σύντομη περιγραφή του περιεχομένου σας';
$string['showadvanced'] = 'Εμφάνιση προχωρημένων';
$string['showless'] = 'Εμφάνιση λιγότερων';
$string['showmore'] = 'Εμφάνιση περισσότερων';
$string['size'] = 'Μέγεθος';
$string['someKeywordsExits'] = 'Ορισμένες από αυτές τις λέξεις-κλειδιά υπάρχουν ήδη';
$string['source'] = 'Πηγή';
$string['startingover'] = 'Θα ξεκινήσετε από την αρχή.';
$string['status'] = 'Κατάσταση';
$string['subContentWarning'] = 'Το υποπεριεχόμενο (εικόνες, ερωτήσεις κ.λπ.) θα κοινοποιηθεί υπό :license εκτός αν οριστεί διαφορετικά στο εργαλείο συγγραφής';
$string['sublevel'] = 'Υποεπίπεδο';
$string['submitted'] = 'Υποβλήθηκε!';
$string['task_h5p'] = 'Χρονοπρογραμματισμένη εργασία H5P';
$string['task_h5p_description'] = 'Η χρονοπρογραμματισμένη εργασία H5P κατεβάζει διαθέσιμους τύπους περιεχομένου H5P από το h5p.org.';
$string['thumbnail'] = 'Μικρογραφία';
$string['title'] = 'Τίτλος';
$string['undisclosed'] = 'Μυστικός';
$string['unpackedFilesExceedsMaxSize'] = 'Το συνολικό μέγεθος των ασυμπίεστων αρχείων υπερβαίνει το μέγιστο επιτρεπόμενο μέγεθος. ({$a->%used} > {$a->%max})';
$string['updatedlibraries'] = 'Ενημερώθηκαν {$a->%old} βιβλιοθήκες H5P.';
$string['updatedlibrary'] = 'Ενημερώθηκε {$a->%old} βιβλιοθήκη H5P.';
$string['uploadlibraries'] = 'Ανέβασμα τύπων περιεχομένου H5P';
$string['uploadsuccess'] = 'Οι τύποι περιεχομένου H5P ανέβηκαν με επιτυχία';
$string['width'] = 'πλάτος';
$string['wrongversion'] = 'Η έκδοση της βιβλιοθήκης H5P {$a->%machineName} που χρησιμοποιείται σε αυτό το περιεχόμενο είναι μη έγκυρη. Το περιεχόμενο περιέχει {$a->%contentLibrary}, αλλά θα έπρεπε {$a->%semanticsLibrary}.';
$string['year'] = 'Έτος';
$string['years'] = 'Έτος/-η';
$string['yearsfrom'] = 'Έτη (από)';
$string['yearsto'] = 'Έτη (έως)';
$string['zip'] = 'Ταχυδρομικός κώδικας';
