<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'datalynx', language 'el', version '5.1'.
 *
 * @package     datalynx
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Ενέργεια';
$string['actions'] = 'Ενέργειες καταχώρησης';
$string['activate'] = 'ενεργοποίηση';
$string['addline'] = 'Προσθήκη {$a}';
$string['addoptions'] = 'Προσθήκη επιλογών';
$string['admin'] = 'Διαχειριστής';
$string['admissibleroles'] = 'Αποδεκτοί ρόλοι';
$string['after'] = 'μετά';
$string['alignment'] = 'Στοίχιση';
$string['allof'] = 'όλα από';
$string['allowaddoption'] = 'Επιτρέπεται προσθήκη επιλογών';
$string['allowsubscription'] = 'Επιτρέπεται χειροκίνητη εγγραφή';
$string['allowunsubscription'] = 'Επιτρέπεται χειροκίνητη απ-εγγραφή';
$string['alltime'] = 'Πάντα';
$string['and'] = 'ΚΑΙ';
$string['andor'] = 'και/ή ...';
$string['anyof'] = 'οποιοδήποτε από';
$string['approved'] = 'εγκρίθηκε';
$string['approvednot'] = 'απορρίφθηκε';
$string['ascending'] = 'Αύξουσα';
$string['asdisplay'] = 'Χρήση υποδείγματος εμφάνισης';
$string['author'] = 'Συγγραφέας';
$string['authorinfo'] = 'Πληροφορίες συγγραφέα';
$string['autocompletion'] = 'Αυτόματη ολοκλήρωση';
$string['before'] = 'πριν';
$string['behavior'] = 'Συμπεριφορά';
$string['behavioradd'] = 'Προσθήκη συμπεριφοράς';
$string['behaviors'] = 'Συμπεριφορές';
$string['between'] = 'μεταξύ';
$string['blankfilter'] = 'Κενό φίλτρο';
$string['browse'] = 'Περιήγηση';
$string['columns'] = 'στήλες';
$string['comment'] = 'Σχόλιο';
$string['commentadd'] = 'Προσθήκη σχολίου';
$string['commentbynameondate'] = 'κατά {$a->name} - {$a->date}';
$string['commentdelete'] = 'Σίγουρα θέλετε να διαγραφεί αυτό το σχόλιο;';
$string['commentdeleted'] = 'Το σχόλια διαγράφηκε';
$string['commentedit'] = 'Επεξεργασία σχολίου';
$string['commentempty'] = 'Το σχόλιο ήταν κενό';
$string['commentinputtype'] = 'Τύπος εισόδου σχολίου';
$string['comments'] = 'Σχόλια';
$string['commentsallow'] = 'Επιτρέπονται σχόλια;';
$string['commentsaved'] = 'Το σχόλιο αποθηκεύτηκε';
$string['commentsn'] = '{$a} σχόλια';
$string['commentsnone'] = 'Κανένα σχόλιο';
$string['completionentries'] = 'Αριθμός (εγκεκριμένων καταχωρήσεων)';
$string['contains'] = 'περιέχει';
$string['convert'] = 'Μετατροπή';
$string['converttoeditor'] = 'Μετατροπή σε πεδίο συντάκτη';
$string['copyof'] = 'Αντίγραφο του {$a}';
$string['correct'] = 'Σωστό';
$string['csscode'] = 'Κώδικας CSS';
$string['cssinclude'] = 'CSS';
$string['cssincludes'] = 'Συμπερίληψη εξωτερικού CSS';
$string['csssaved'] = 'Το CSS αποθηκεύτηκε';
$string['cssupload'] = 'Ανέβασμα αρχείων CSS';
$string['csvdelimiter'] = 'διαχωριστικό';
$string['csvenclosure'] = 'εισαγωγικά';
$string['csvfailed'] = 'Αδυναμία ανάγνωσης των ακατέργαστων δεδομένων από το αρχείο CSV';
$string['csvoutput'] = 'Έξοδος CSV';
$string['csvsettings'] = 'Ρυθμίσεις CSV';
$string['custom'] = 'Προσαρμοσμένο υπόδειγμα';
$string['customfilter'] = 'Προσαρμοσμένο φίλτρο';
$string['customfilteradd'] = 'Προσθήκη ενός προσαρμοσμένου φίλτρου';
$string['customfilterandor'] = 'Όλες οι επιλεγμένες επιλογές πρέπει να είναι μέρος της καταχώρησης';
$string['customfilterandor_help'] = 'Εάν επιλεγεί, όλες οι επιλεγμένες επιλογές πρέπει να είναι μέρος της καταχώρησης.';
$string['customfilternew'] = 'Νέο προσαρμοσμένο φίλτρο';
$string['customfilters'] = 'Προσαρμοσμένα φίλτρα';
$string['datalynx:approve'] = 'Έγκριση μη εγκεκριμένων καταχωρήσεων';
$string['datalynx:comment'] = 'Γράψτε σχόλια';
$string['datalynx:viewdrafts'] = 'Εμφάνιση προσχεδίων';
$string['datalynx:viewentry'] = 'Εμφάνιση καταχωρήσεων';
$string['datalynx:viewindex'] = 'Εμφάνιση δεικτών/ευρετηρίου';
$string['datalynx:viewstatistics'] = 'Εμφάνιση στατιστικών';
$string['datalynx:writeentry'] = 'Γράψτε καταχωρήσεις';
$string['datalynx_csssaved'] = 'Το προσαρμοσμένο CSS αποθηκεύτηκε';
$string['datalynx_jssaved'] = 'Η προσαρμοσμένη JavaScript αποθηκεύτηκε';
$string['datalynx_team_updated'] = 'Η ομάδα ενημερώθηκε';
$string['defaultbehavior'] = 'Προεπιλεγμένη συμπεριφορά';
$string['defaultfilterlabel'] = 'Προεπιλεγμένο φίλτρο ({$a})';
$string['deletenotenrolled'] = 'Διαγραφή καταχωρήσεων από μη εγγεγραμμένους χρήστες';
$string['deleteoption'] = 'Διαγραφή;';
$string['deletetag'] = 'Διαγραφή ετικέτας';
$string['descending'] = 'Φθίνουσα';
$string['dfintervalcount'] = 'Αριθμός διαστημάτων';
$string['dflateallow'] = 'Καθυστερημένες αποστολές';
$string['dflateuse'] = 'Επιτρέπονται καθυστερημένες αποστολές';
$string['dfratingactivity'] = 'Βαθμολόγηση δραστηριότητας';
$string['dftimeavailable'] = 'Διαθέσιμη από';
$string['dftimedue'] = 'Οφειλόμενη';
$string['disabled'] = 'Εμφάνιση απενεργοποιημένων στοιχείων';
$string['disapproved'] = 'Μη εγκεκριμένα';
$string['displaytemplate'] = 'Εμφάνιση υποδείγματος';
$string['documenttype'] = 'Τύπος εγγράφου';
$string['dots'] = '...';
$string['download'] = 'Λήψη';
$string['duplicatename'] = 'Αυτό το όνομα υπάρχει ήδη. Παρακαλούμε, επιλέξτε ένα άλλο.';
$string['editable'] = 'Τροποποιήσιμο';
$string['editableby'] = 'Τροποποιήσιμο από';
$string['editing'] = 'Επεξεργασία';
$string['editingbehavior'] = 'Επεξεργασία συμπεριφορά πεδίου «{$a}»';
$string['editmode'] = 'Κατάσταση επεξεργασίας';
$string['editordisable'] = 'Απενεργοποίηση συντάκτη';
$string['editorenable'] = 'Ενεργοποίηση συντάκτη';
$string['edittemplate'] = 'Επεξεργασία υποδείγματος';
$string['email'] = 'Διεύθυνση ηλε.ταχυδρομείου';
$string['embed'] = 'Ενσωμάτωση';
$string['empty'] = 'άδειο';
$string['enabled'] = 'Ενεργοποιημένο';
$string['entries'] = 'Καταχωρήσεις';
$string['entriesadded'] = '{$a} καταχώρηση/-ήσεις προστέθηκαν';
$string['entriesanonymous'] = 'Να επιτρέπονται ανώνυμες καταχωρήσεις';
$string['entriesappended'] = '{$a} καταχώρηση/-ήσεις προσαρτήθηκαν';
$string['entriesapproved'] = '{$a} καταχώρηση/-ήσεις εγκρίθηκαν';
$string['entriesconfirmadd'] = 'Πρόκειται να δημιουργηθεί αντίγραφο {$a} καταχώρησης/-ήσεων. Θέλετε να συνεχίσετε;';
$string['entriesconfirmapprove'] = 'Πρόκειται να εγκριθεί/-ούν {$a} καταχώρηση/-ήσεις. Θέλετε να συνεχίσετε;';
$string['entriesconfirmdelete'] = 'Πρόκειται να διαγραφεί/-ούν {$a} καταχώρηση/-ήσεις. Θέλετε να συνεχίσετε;';
$string['entriesconfirmduplicate'] = 'Πρόκειται να δημιουργηθεί αντίγραφο {$a} καταχώρησης/-ήσεων. Θέλετε να συνεχίσετε;';
$string['entriesconfirmupdate'] = 'Πρόκειται να ενημερωθεί/-ούν {$a} καταχώρηση/-ήσεις. Θέλετε να συνεχίσετε;';
$string['entriescount'] = '{$a} καταχώρηση/-ήσεις';
$string['entriesdeleteall'] = 'Διαγραφή όλων των καταχωρήσεων';
$string['entriesdeleted'] = '{$a} καταχώρηση/-ήσεις διαγράφηκαν';
$string['entriesdisapproved'] = '{$a} καταχώρηση/-ήσεις απορρίφθηκαν';
$string['entriesduplicated'] = '{$a} καταχώρηση/-ήσεις αντιγράφηκαν';
$string['entriesfound'] = '{$a} καταχώρηση/-ήσεις βρέθηκαν';
$string['entriesimport'] = 'Εισαγωγή καταχωρήσεων';
$string['entriespending'] = 'Εκκρεμεί';
$string['entriesrequired'] = 'Απαιτούμενες καταχωρήσεις';
$string['entriessaved'] = '{$a} καταχώρηση/-ήσεις αποθηκεύτηκαν';
$string['entriestoview'] = 'Καταχωρήσεις που απαιτούνται πριν την εμφάνιση';
$string['entriesupdated'] = '{$a} καταχώρηση/-ήσεις ενημερώθηκαν';
$string['entry'] = 'Καταχώρηση';
$string['entryaddmultinew'] = 'Προσθήκη νέων καταχωρήσεων';
$string['entryaddnew'] = 'Προσθήκη νέας εγγραφής';
$string['entryauthor'] = 'Συγγραφέας καταχώρησης';
$string['entryinfo'] = 'Πληροφορίες καταχώρησης';
$string['entrylockonapproval'] = 'κλείδωμα όταν εγκριθεί';
$string['entrylockoncomments'] = 'κλείδωμα όταν σχολιαστεί';
$string['entrylockonratings'] = 'κλείδωμα όταν αξιολογηθεί';
$string['entrylocks'] = 'Κλειδώματα καταχώρησης';
$string['entrynew'] = 'Νέα καταχώρηση';
$string['entrynoneforaction'] = 'Δεν βρέθηκαν καταχωρήσεις για την αιτούμενη ενέργεια';
$string['entrynoneindatalynx'] = 'Καμία καταχώρηση στο datalynx';
$string['entryrating'] = 'Αξιολόγηση καταχώρησης';
$string['entrysaved'] = 'Η καταχώρησή σας αποθηκεύτηκε';
$string['entrysettings'] = 'Ρυθμίσεις καταχώρησης';
$string['entrysettingsupdated'] = 'Οι ρυθμίσεις καταχώρησης ενημερώθηκαν';
$string['entrytemplate'] = 'Υπόδειγμα καταχώρησης';
$string['entrytemplate_help'] = 'Υπόδειγμα καταχώρησης';
$string['entrytimelimit'] = 'Όριο χρόνου επεξεργασίας (λεπτά)';
$string['equal'] = 'ίσο';
$string['event_comment_created'] = 'Το σχόλιο δημιουργήθηκε';
$string['event_entry_approved'] = 'Η καταχώρηση εγκρίθηκε';
$string['event_entry_created'] = 'Η καταχώρηση δημιουργήθηκε';
$string['event_entry_deleted'] = 'Η καταχώρηση διαγράφηκε';
$string['event_entry_disapproved'] = 'Η καταχώρηση δεν εγκρίθηκε';
$string['event_entry_updated'] = 'Η καταχώρηση ενημερώθηκε';
$string['event_rating_added'] = 'Η αξιολόγηση προστέθηκε';
$string['event_rating_deleted'] = 'Η αξιολόγηση διαγράφηκε';
$string['event_rating_updated'] = 'Η αξιολόγηση ενημερώθηκε';
$string['event_team_updated'] = 'Η ομάδα ενημερώθηκε';
$string['eventsettings'] = 'Ρυθμίσεις γεγονότων';
$string['exactly'] = 'ακριβώς';
$string['existingoptions'] = 'Επεξεργασία υπαρχόντων επιλογών';
$string['export'] = 'Εξαγωγή';
$string['exportadd'] = 'Προσθήκη μιας νέας εμφάνισης εξαγωγής';
$string['exportall'] = 'Εξαγωγή όλων';
$string['exportcontent'] = 'Εξαγωγή περιεχομένου';
$string['exportpage'] = 'Σελίδα εξαγωγής';
$string['field'] = 'Πεδίο';
$string['fieldadd'] = 'Προσθήκη ενός πεδίου';
$string['fieldallowautolink'] = 'Να επιτρέπεται αυτόματη δημιουργία συνδέσμων';
$string['fieldattributes'] = 'Ιδιοχαρακτηριστικά πεδίου';
$string['fieldcreate'] = 'Δημιουργία ενός νέου πεδίου';
$string['fielddescription'] = 'Περιγραφή πεδίου';
$string['fieldedit'] = 'Επεξεργασία «{$a}»...';
$string['fieldeditable'] = 'Τροποποιήσιμο';
$string['fieldedits'] = 'Αριθμός τροποποιήσεων';
$string['fieldgroups'] = 'Ομάδεςπεδίων';
$string['fieldids'] = 'Αναγνωριστικά πεδίου';
$string['fieldlabel'] = 'Ταμπέλα πεδίου';
$string['fieldlist'] = 'Αναζητήσιμα πεδία';
$string['fieldmappings'] = 'Αντιστοιχίσεις πεδίων';
$string['fieldname'] = 'Όνομα πεδίου';
$string['fieldnew'] = 'Νέο {$a} πεδίο';
$string['fieldnoneforaction'] = 'Δεν βρέθηκαν πεδία για την ενέργεια που ζητήθηκε';
$string['fieldnoneindatalynx'] = 'Δεν καθορίστηκαν καθόλου πεδία για αυτό το datalynx.';
$string['fieldnonematching'] = 'Δεν βρέθηκαν καθόλου αντιστοιχισμένα πεδία';
$string['fieldnotmatched'] = 'Τα ακόλουθα πεδία στο αρχείο σας δεν είναι γνωστά σε αυτό το datalynx: {$a}';
$string['fieldoptions'] = 'Επιλογές (μία ανά γραμμή)';
$string['fieldoptionsdefault'] = 'Προεπιλεγμένες τιμές (μία ανά γραμμή)';
$string['fieldoptionsseparator'] = 'Διαχωριστικό επιλογών';
$string['fieldrequired'] = 'Πρέπει να δώσετε μια τιμή εδώ.';
$string['fieldrules'] = 'Κανόνες επεξεργασίας πεδίου';
$string['fields'] = 'Πεδία';
$string['fieldsadded'] = 'Πεδία που προστέθηκαν';
$string['fieldsconfirmdelete'] = 'Πρόκειται να διαγραφούν {$a} πεδία/-ο. Θέλετε να συνεχίσετε;';
$string['fieldsconfirmduplicate'] = 'Πρόκειται να δημιουργηθεί αντίγραφο {$a} πεδίων/-ου. Θέλετε να συνεχίσετε;';
$string['fieldsdeleted'] = 'Τα πεδία διαγράφηκαν. Ίσως χρειαστεί να ενημερώσετε τις προεπιλεγμένες ρυθμίσεις ταξινόμησης.';
$string['fieldsimportsettings'] = 'Εισαγωγή ρυθμίσεων';
$string['fieldsmax'] = 'Μέγιστο πεδίων';
$string['fieldsnonedefined'] = 'Δεν ορίστηκαν καθόλου πεδία';
$string['fieldsupdated'] = 'Τα πεδία ενημερώθηκαν';
$string['fieldtype'] = 'Τύπος πεδίου';
$string['fieldvisibility'] = 'Ορατό σε';
$string['fieldvisibleall'] = 'Όλοι';
$string['fieldvisiblenone'] = 'Μόνο διαχειριστές';
$string['fieldvisibleowner'] = 'Ιδιοκτήτης και διαχειριστές';
$string['fieldwidth'] = 'Πλάτος';
$string['fileexist'] = 'υπάρχει';
$string['filemaxsize'] = 'Συνολικό μέγεθος ανεβασμένων αρχείων';
$string['filemissing'] = 'λείπει';
$string['filesmax'] = 'Μέγιστος αριθμός ανεβασμένων αρχείων';
$string['filetypeany'] = 'Οποιοσδήποτε τύπος αρχείου';
$string['filetypeaudio'] = 'Αρχεία ήχου';
$string['filetypegif'] = 'αρχεία gif';
$string['filetypehtml'] = 'αρχεία HTML';
$string['filetypeimage'] = 'Αρχεία εικόνας';
$string['filetypejpg'] = 'αρχεία jpg';
$string['filetypepng'] = 'αρχεία png';
$string['filetypes'] = 'Αποδεκτοί τύποι αρχείων';
$string['filter'] = 'Φίλτρο';
$string['filteradd'] = 'Προσθήκη φίλτρου';
$string['filteradvanced'] = 'Προσαρμοσμένο φίλτρο';
$string['filterbypage'] = 'Κατά σελίδα';
$string['filtercancel'] = 'Ακύρωση φίλτρου';
$string['filtercreate'] = 'Δημιουργία ενός νέου φίλτρου';
$string['filtercurrent'] = 'Τρέχων φίλτρο';
$string['filtercustomsearch'] = 'Επιλογές αναζήτησης';
$string['filtercustomsort'] = 'Επιλογές ταξινόμησης';
$string['filterdescription'] = 'Περιγραφή φίλτρου';
$string['filteredit'] = 'Επεξεργασία «{$a}»...';
$string['filterformadd'] = 'Προσθήκη νέας φόρμας φίλτρου';
$string['filterforms'] = 'Φόρμες φίλτρου';
$string['filtergroupby'] = 'Ομαδοποίηση κατά';
$string['filterincomplete'] = 'Οι συνθήκες αναζήτησης πρέπει να πληρούνται.';
$string['filtermy'] = 'Το φίλτρο μου';
$string['filternew'] = 'Νέο φίλτρο';
$string['filternoneforaction'] = 'Δεν βρέθηκαν φίλτρα για την απαιτούμενη ενέργεια';
$string['filterperpage'] = 'Ανά σελίδα';
$string['filters'] = 'Φίλτρα';
$string['filtersadded'] = '{$a} φίλτρα προστέθηκαν';
$string['filtersave'] = 'Αποθήκευση φίλτρου';
$string['filtersconfirmdelete'] = 'Πρόκειται να διαγραφούν {$a} φίλτρα/-ο. Θέλετε να συνεχίσετε;';
$string['filtersconfirmduplicate'] = 'Πρόκειται να δημιουργηθούν αντίγραφα {$a} φίλτρων/-ου. Θέλετε να συνεχίσετε;';
$string['filtersdeleted'] = '{$a} φίλτρα διαγράφηκαν';
$string['filtersduplicated'] = '{$a} φίλτρα αντιγράφηκαν';
$string['filtersearchfieldlabel'] = 'Πεδίο αναζήτησης';
$string['filterselection'] = 'Επιλογή';
$string['filtersimplesearch'] = 'Απλή αναζήτηση';
$string['filtersmax'] = 'Μέγιστος αριθμός φίλτρων';
$string['filtersnonedefined'] = 'Δεν ορίστηκαν καθόλου φίλτρα';
$string['filtersnoneindatalynx'] = 'Δεν υπάρχει κανένα φίλτρο ορισμένο για αυτό το datalynx.';
$string['filtersortfieldlabel'] = 'Πεδίο ταξινόμησης';
$string['filterurlquery'] = 'Ερώτημα διεύθυνσης URL';
$string['filteruserreset'] = '** Επαναρχικοποίηση του φίλτρου μου';
$string['first'] = 'Πρώτο';
$string['firstdayofweek'] = 'Δευτέρα';
$string['formemptyadd'] = 'Δεν συμπληρώσατε κανένα πεδίο!';
$string['fromdate'] = 'Ημερομηνία Από';
$string['fromfile'] = 'Εισαγωγή από αρχείο zip';
$string['fulltextsearch'] = 'ΑναζήτησηΠλήρουςΚειμένου';
$string['generalactions'] = 'Γενικές ενέργειες';
$string['grade'] = 'Βαθμός';
$string['gradeinputtype'] = 'Τύπος εισόδου βαθμού';
$string['gradeitem'] = 'Στοιχείο βαθμού';
$string['grading'] = 'Βαθμολόγηση';
$string['gradingmethod'] = 'Μέθοδος βαθμολόγησης';
$string['gradingsettings'] = 'Ρυθμίσεις βαθμολόγησης δραστηριότητας';
$string['greater_equal'] = 'μεγαλύτερο από ή ίσο με';
$string['groupentries'] = 'Μέλη ομάδας';
$string['groupinfo'] = 'Πληροφορίες ομάδας';
$string['guest'] = 'Επισκέπτης';
$string['headercss'] = 'Προσαρμοσμένα στυλ CSS για κάθε εμφάνιση';
$string['headerjs'] = 'Προσαρμοσμένη javascript για κάθε εμφάνιση';
$string['hidden'] = 'Απόκρυψη';
$string['hideline'] = 'Απόκρυψη της τελευταίας γραμμής';
$string['horizontal'] = 'Οριζόντια';
$string['iamteammember'] = 'Είμαι μέλος ομάδας';
$string['id'] = 'Αναγνωριστικό';
$string['import'] = 'Εισαγωγή';
$string['importadd'] = 'Προσθήκη μιας νέας προβολής Εισαγωγής';
$string['in'] = 'σε';
$string['incorrect'] = 'Λανθασμένο';
$string['index'] = 'Δείκτης';
$string['internal'] = 'Εσωτερικό';
$string['intro'] = 'Εισαγωγή';
$string['invalidname'] = 'Παρακαλούμε, διαλέξτε ένα άλλο όνομα για αυτό {$a}';
$string['invalidurl'] = 'Η διεύθυνση URL που μόλις δώσατε δεν είναι έγκυρη';
$string['isdefault'] = 'Προεπιλεγμένη εμφάνιση';
$string['isedit'] = 'Τροποποίηση εμφάνισης';
$string['ismore'] = 'Εμφάνιση με λεπτομέρειες';
$string['jscode'] = 'Κώδικας Javascript';
$string['jsinclude'] = 'JS';
$string['jsincludes'] = 'Συμπερίληψη εξωτερικού κώδικα Javascript';
$string['jssaved'] = 'Ο κώδικας Javascript αποθηκεύτηκε';
$string['label'] = 'Ταμπέλα';
$string['less_equal'] = 'μικρότερο από ή ίσο με';
$string['less_than'] = 'μικρότερο από';
$string['limitchoice'] = 'Περιορισμός επιλογών των χρηστών';
$string['line'] = 'Γραμμή';
$string['listformat'] = 'Μορφότυπος λίστας';
$string['lock'] = 'Κλείδωμα';
$string['manage'] = 'Διαχείριση';
$string['managemode'] = 'Διαχείριση κατάστασης';
$string['manager'] = 'Διαχειριστής';
$string['mappingwarning'] = 'Όλα τα παλιά πεδία που δεν έχουν αντιστοιχιστεί σε ένα νέο πεδίο θα χαθούν και όλα τα δεδομένα σε αυτό το πεδίο θα διαγραφούν.';
$string['max'] = 'Μέγιστο';
$string['maxsize'] = 'Μέγιστο μέγεθος';
$string['mediafile'] = 'Πολυμεσικό αρχείο';
$string['mentor'] = 'Καθοδηγητής';
$string['min'] = 'Ελάχιστο';
$string['minteamsize'] = 'Ελάχιστο μέγεθος ομάδας';
$string['minteamsize_help'] = 'Δώστε τον ελάχιστο επιτρεπόμενο αριθμό μελών ομάδας εδώ.';
$string['modearray'] = 'Κατάσταση εμφάνισης';
$string['modulename'] = 'Datalynx';
$string['more'] = 'Περισσότερα';
$string['moreresults'] = '({$a} περισσότερα αποτελέσματα...)';
$string['movezipfailed'] = 'Αδυναμία μετακίνησης του αρχείου zip';
$string['multiapprove'] = 'Έγκριση';
$string['multidelete'] = 'Διαγραφή';
$string['multidownload'] = 'Λήψη';
$string['multiduplicate'] = 'Διπλότυπο';
$string['multiedit'] = 'Επεξεργασία';
$string['multiexport'] = 'Εξαγωγή';
$string['multishare'] = 'Κοινή χρήση';
$string['newbehavior'] = 'Συμπεριφορά νέου πεδίου';
$string['newfilterform'] = 'Φόρμα νέου φίλτρου';
$string['newvalue'] = 'Νέα τιμή';
$string['newvalueallow'] = 'Να επιτρέπονται νέες τιμές';
$string['noaccess'] = 'Δεν έχετε πρόσβαση σε αυτή τη σελίδα';
$string['noautocompletion'] = 'Χωρίς αυτόματη συμπλήρωση';
$string['nodatalynxs'] = 'Δεν βρέθηκε κανένα άρθρωμα Datalynx';
$string['noedit'] = 'Μη τροποποιήσιμο';
$string['noentries'] = 'Δεν υπάρχει καμία καταχώρηση προς εμφάνιση.';
$string['nomatch'] = 'Δεν βρέθηκε καμία καταχώρηση που να ταιριάζει!';
$string['nomatchingentries'] = 'Δεν υπάρχει καμία καταχώρηση που να ταιριάζει στο επιλεγμένο φίλτρο.';
$string['nomaximum'] = 'Κανένα μέγιστο';
$string['nooptions'] = 'Πρέπει να καθορίσετε τουλάχιστον μια επιλογή!';
$string['nopermission'] = 'Δεν έχετε το δικαίωμα εμφάνισης των καταχωρήσεων που καθορίστηκαν.';
$string['nosuchentries'] = 'Καμία διαθέσιμη καταχώρηση.';
$string['not'] = 'ΟΧΙ';
$string['notallowedtoeditentry'] = 'Δεν επιτρέπεται τροποποίηση αυτής της καταχώρησης.';
$string['notapproved'] = 'Η καταχώρηση δεν εγκρίθηκε ακόμη.';
$string['noteditable'] = 'Όταν δεν είναι τροποποιήσιμο';
$string['notemplate'] = 'Κανένα υπόδειγμα';
$string['notificationenable'] = 'Ενεργοποίηση ειδοποιήσεων για';
$string['notifyteam'] = 'Κανόνας ειδοποίησης';
$string['notifyteammembers'] = 'Ειδοποίηση μελών ομάδας';
$string['notopenyet'] = 'Λυπούμαστε. Αυτή η δραστηριότητα δεν είναι διαθέσιμη μέχρι {$a}.';
$string['notrequired'] = 'Δεν απαιτείται';
$string['notvisible'] = 'Όταν δεν είναι ορατό';
$string['novalue'] = 'Όταν είναι κενό';
$string['noviewsavailable'] = 'Καμία διαθέσιμη εμφάνιση';
$string['numapprovedentries'] = 'Αριθμός εγκεκριμένων καταχωρήσεων';
$string['numberrssarticles'] = 'Άρθρα RSS';
$string['numcharsallowed'] = 'Αριθμός χαρακτήρων';
$string['numdeletedentries'] = 'Αριθμός διαγραμμένων καταχωρήσεων';
$string['numtotalentries'] = 'Αριθμός δημιουργημένων καταχωρήσεων';
$string['numvisits'] = 'Αριθμός επισκέψεων';
$string['ondate'] = 'Στην ημερομηνία';
$string['option'] = 'Επιλογή';
$string['optionaldescription'] = 'Σύντομη περιγραφή (προαιρετικά)';
$string['optionalfilename'] = 'Όνομα αρχείου (προαιρετικά)';
$string['or'] = 'Ή';
$string['other'] = 'Άλλο';
$string['otheruser'] = 'Άλλος χρήστης';
$string['overwrite'] = 'Αντικατάσταση';
$string['overwritesettings'] = 'Αντικατάσταση τρεχόντων ρυθμίσεων';
$string['pagesize'] = 'Καταχωρήσεις ανά σελίδα';
$string['pagingbar'] = 'Μπάρα σελιδοποίησης';
$string['pagingnextslide'] = 'Επόμενη διαφάνεια';
$string['pagingpreviousslide'] = 'Προηγούμενη διαφάνεια';
$string['participants'] = 'Συμμετέχοντες';
$string['period'] = 'Περίοδος';
$string['pluginadministration'] = 'Διαχείριση δραστηριότητας Datalynx';
$string['pluginname'] = 'Datalynx';
$string['porttypeblank'] = 'Κενές καταχωρήσεις';
$string['porttypecsv'] = 'CSV';
$string['presetadd'] = 'Προσθήκη προρυθμίσεων';
$string['presetapply'] = 'Εφαρμογή';
$string['presetavailableincourse'] = 'Προρυθμίσεις μαθήματος';
$string['presetavailableinsite'] = 'Προρυθμίσεις ιστοτόπου';
$string['presetchoose'] = 'επιλέξτε μια προκαθορισμένη προρύθμιση';
$string['presetdata'] = 'με τα δεδομένα χρήστη';
$string['presetfaileddelete'] = 'Σφάλμα διαγραφής μιας προρύθμισης!';
$string['presetfromdatalynx'] = 'Δημιουργία μιας προρύθμισης';
$string['presetfromfile'] = 'Ανέβασμα προρύθμισης από αρχείο';
$string['presetmap'] = 'αντιστοίχιση πεδίων';
$string['presetnodata'] = 'χωρίς δεδομένα χρήστη';
$string['presetnodefinedfields'] = 'Η νέα προρύθμιση δεν έχει κανένα ορισμένο πεδίο!';
$string['presetnodefinedviews'] = 'Η νέα προρύθμιση δεν έχει καμία ορισμένη προβολή!';
$string['presetnoneavailable'] = 'Καμία διαθέσιμη προρύθμιση προς εμφάνιση';
$string['presetplugin'] = 'Πρόσθετο';
$string['presetrefreshlist'] = 'Ανανέωση λίστας';
$string['presets'] = 'Προρυθμίσεις';
$string['presetshare'] = 'Κοινή χρήση';
$string['presetsharesuccess'] = 'Η αποθήκευση έγινε με επιτυχία. Η προρύθμισή σας θα είναι τώρα διαθέσιμη σε ολόκληρο τον ιστότοπο.';
$string['presetsource'] = 'Πηγή προρύθμισης';
$string['presetusestandard'] = 'Χρήση μιας προρύθμισης';
$string['privacy:metadata:datalynx_contents:content'] = 'Περιεχόμενο';
$string['privacy:metadata:datalynx_contents:content1'] = 'Πρόσθετο περιεχόμενο 1';
$string['privacy:metadata:datalynx_contents:content2'] = 'Πρόσθετο περιεχόμενο 2';
$string['privacy:metadata:datalynx_contents:content3'] = 'Πρόσθετο περιεχόμενο 3';
$string['privacy:metadata:datalynx_contents:content4'] = 'Πρόσθετο περιεχόμενο 4';
$string['privacy:metadata:datalynx_contents:fieldid'] = 'Αναγνωριστικό ορισμού πεδίου';
$string['privacy:metadata:datalynx_entries:approved'] = 'Κατάσταση έγκρισης';
$string['privacy:metadata:datalynx_entries:groupid'] = 'Ομάδα';
$string['privacy:metadata:datalynx_entries:status'] = 'Κατάσταση αυτής της καταχώρησης';
$string['privacy:metadata:datalynx_entries:timecreated'] = 'Χρόνος δημιουργίας εγγραφής';
$string['privacy:metadata:datalynx_entries:timemodified'] = 'Χρόνος τελευταίας τροποποίησης εγγραφής';
$string['privacy:metadata:datalynx_entries:userid'] = 'Χρήστης που δημιούργησε την εγγραφή';
$string['random'] = 'Τυχαία';
$string['randomone'] = 'Ένα τυχαίο';
$string['range'] = 'Εύρος';
$string['rate'] = 'Αξιολόγηση';
$string['rating'] = 'Αξιολογήσεις';
$string['ratingmanual'] = 'Χειροκίνητα';
$string['ratingmethod'] = 'Μέθοδος αξιολόγησης';
$string['ratingno'] = 'Καμία αξιολόγηση';
$string['ratings'] = 'Αξιολογήσεις';
$string['ratingsaggregate'] = '{$a->value} ({$a->method} από {$a->count ratings})';
$string['ratingsavg'] = 'Μέσος όρος των αξιολογήσεων';
$string['ratingscount'] = 'Πλήθος των αξιολογήσεων';
$string['ratingsmax'] = 'Η καλύτερη αξιολόγηση';
$string['ratingsmin'] = 'Η χειρότερη αξιολόγηση';
$string['ratingsnone'] = '---';
$string['ratingssaved'] = 'Οι αξιολογήσεις αποθηκεύτηκαν';
$string['ratingssum'] = 'Σύνολο αξιολογήσεων';
$string['ratingsview'] = 'Εμφάνιση αξιολογήσεων';
$string['ratingsviewrate'] = 'Εμφάνιση και αξιολόγηση';
$string['ratingvalue'] = 'Τιμή αξιολόγησης';
$string['redirectto'] = 'Προβολή στόχος';
$string['reference'] = 'Αναφορά';
$string['referencefield'] = 'Πεδίο αναφοράς';
$string['renameoption'] = 'Μετονομασία σε:';
$string['required'] = 'Απαιτείται';
$string['requiredall'] = 'απαιτούνται όλα';
$string['requirednotall'] = 'δεν απαιτούνται όλα';
$string['resetsettings'] = 'Επαναρχικοποίηση φίλτρων';
$string['rssglobaldisabled'] = 'Απενεργοποιήθηκε. Δείτε τις μεταβλητές ρύθμισης του ιστοτόπου.';
$string['rsstemplate'] = 'Υπόδειγμα (τροφοδοσίας) RSS';
$string['rsstitletemplate'] = 'Υπόδειγμα τίτλου (τροφοδοσίας) RSS';
$string['rule'] = 'κανόνας';
$string['ruleaction'] = 'Ενέργεια κανόνα';
$string['ruleadd'] = 'Προσθήκη ενός κανόνα';
$string['rulecancel'] = 'Ακύρωση κανόνα';
$string['rulecondition'] = 'Συνθήκη';
$string['rulecreate'] = 'Δημιουργία ενός νέου κανόνα';
$string['ruledenydelete'] = 'Αποτροπή διαγραφής καταχώρησης';
$string['ruledenyedit'] = 'Αποτροπή τροποποίησης καταχώρησης';
$string['ruledenyview'] = 'Απόκρυψη καταχώρησης από όλους';
$string['ruledenyviewbyother'] = 'Απόκρυψη καταχώρησης από όλους εκτός από τον ιδιοκτήτη';
$string['ruledescription'] = 'Περιγραφή κανόνα';
$string['ruleedit'] = 'Επεξεργασία «{$a}»';
$string['ruleenabled'] = 'Ενεργοποιημένο';
$string['rulenew'] = 'Νέος κανόνας {$a}';
$string['rulenoneforaction'] = 'Δεν βρέθηκαν κανόνες για την ενέργεια που ζητήθηκε';
$string['rules'] = 'Κανόνες';
$string['rulesadded'] = '{$a} κανόνας/-όνες προστέθηκαν';
$string['rulesave'] = 'Αποθήκευση κανόνα';
$string['rulesconfirmdelete'] = 'Πρόκειται να διαγράψετε {$a} κανόνα/-όνες. Θέλετε να συνεχίσετε;';
$string['rulesconfirmduplicate'] = 'Πρόκειται να δημιουργήσετε αντίγραφο {$a} κανόνα/-όνων. Θέλετε να συνεχίσετε;';
$string['rulesdeleted'] = '{$a} κανόνας/-όνες διαγράφηκαν';
$string['rulesduplicated'] = '{$a} κανόνας/-όνες αντιγράφηκαν σε διπλότυπα';
$string['rulesmax'] = 'Μέγιστο κανόνων';
$string['rulesnonedefined'] = 'Δεν ορίστηκαν καθόλου κανόνες';
$string['rulesnoneindatalynx'] = 'Δεν υπάρχουν καθόλου κανόνες ορισμένοι για αυτό το datalynx.';
$string['rulesupdated'] = '{$a} κανόνας/-όνες ενημερώθηκαν';
$string['ruleupdate'] = 'Ενημέρωση ενός υπάρχοντος κανόνα';
$string['savecontinue'] = 'Αποθήκευση και Συνέχεια';
$string['search'] = 'Αναζήτηση';
$string['search:activity'] = 'Datalynx - στιγμιότυπα';
$string['search:entry'] = 'Datalynx - καταχωρήσεις';
$string['selectuser'] = 'Επιλογή χρήστη...';
$string['separateentries'] = 'Κάθε καταχώρηση σε ξεχωριστό αρχείο';
$string['separateparticipants'] = 'Διαχωρισμός συμμετεχόντων';
$string['setdefault'] = 'Ορισμός ως προεπιλεγμένη προβολή';
$string['setedit'] = 'Ορισμός ως προβολή επεξεργασίας';
$string['setmore'] = 'Ορισμός ως λεπτομερής προβολή';
$string['settings'] = 'Ρυθμίσεις';
$string['showall'] = 'Εμφάνιση όλων των καταχωρήσεων';
$string['shownothing'] = 'Να μην εμφανίζεται τίποτα';
$string['sortable'] = 'ταξινομήσημο';
$string['spreadsheettype'] = 'Τύπος λογιστικού φύλλου';
$string['statistics'] = 'Στατιστικά';
$string['statisticsfor'] = 'Στατιστικά για «{$a}»';
$string['status'] = 'Κατάσταση';
$string['statusrequired'] = 'Η κατάσταση πρέπει να οριστεί!';
$string['student'] = 'Μαθητής';
$string['submission'] = 'Υποβολή';
$string['submissionsinpopup'] = 'Υποβολές σε αναδυόμενο';
$string['submissionsview'] = 'Προβολή υποβολών';
$string['subplugintype_datalynxfield'] = 'Τύπος πεδίου Datalynx';
$string['subplugintype_datalynxfield_plural'] = 'Τύποι πεδίου Datalynx';
$string['subplugintype_datalynxrule'] = 'Τύπος κανόνα Datalynx';
$string['subplugintype_datalynxrule_plural'] = 'Τύποι κανόνα Datalynx';
$string['subplugintype_datalynxtool'] = 'Τύπος εργαλείου Datalynx';
$string['subplugintype_datalynxtool_plural'] = 'Τύποι εργαλείου Datalynx';
$string['subplugintype_datalynxview'] = 'Τύπος προβολής Datalynx';
$string['subplugintype_datalynxview_plural'] = 'Τύποι προβολής Datalynx';
$string['subscribe'] = 'Εγγραφή';
$string['tagarea_datalynx_contents'] = 'Καταχωρήσεις Datalynx';
$string['tagcollection_datalynx'] = 'Ετικέτες Datalynx';
$string['tagproperties'] = '{$a->tagtype} ιδιότητες ετικέτας: {$a->tagname}';
$string['teacher'] = 'Διδάσκων';
$string['teachersandstudents'] = '{$a->teachers} και {$a->students}';
$string['teamfield'] = 'Πεδίο ομάδας';
$string['teammembers'] = 'Μέλη ομάδας χρηστών';
$string['teams'] = 'Ομάδες χρηστών';
$string['teamsize'] = 'Μέγιστο μέγεθος ομάδας χρηστών';
$string['teamsize_help'] = 'Καθορισμός του μέγιστου μεγέθους της ομάδας. Πρέπει να είναι ένας θετικός ακέραιος.';
$string['textbox'] = 'Πλαίσιο κειμένου';
$string['textfield'] = 'ΠεδίοΚειμένου';
$string['textfieldvalues'] = 'Τιμές ΠεδίουΚειμένου';
$string['thisdatalynx'] = 'Αυτό το στιγμιότυπο Datalynx';
$string['thisfield'] = 'Αυτό το πεδίο';
$string['timecreated'] = 'Χρόνος δημιουργίας';
$string['timemodified'] = 'Χρόνος τροποποίησης';
$string['timestring0'] = 'από {$a->from} έως {$a->to}';
$string['timestring1'] = 'στις {$a->from}';
$string['timestring2'] = 'μέχρι {$a->to}';
$string['timestring3'] = 'από {$a->from} μέχρι τώρα ({$a->now})';
$string['timestring4'] = 'μέχρι τώρα ({$a->now})';
$string['todate'] = 'Μέχρι σήμερα';
$string['toolrun'] = 'Εκτέλεση';
$string['tools'] = 'Εργαλεία';
$string['triggeringevent'] = 'Πρόκληση γεγονότος';
$string['type'] = 'Τύπος';
$string['unique'] = 'Μοναδικό';
$string['unlock'] = 'Ξεκλείδωμα';
$string['unsubscribe'] = 'Κατάργηση εγγραφής';
$string['updatefield'] = 'Ενημέρωση ενός υπάρχοντος πεδίου';
$string['updateview'] = 'Ενημέρωση μιας υπάρχουσας προβολής';
$string['uploadfile'] = 'Αρχείο προς εισαγωγή';
$string['uploadtext'] = 'Κείμενο προς εισαγωγή';
$string['urlclass'] = 'Κλάσεις CSS';
$string['urltarget'] = 'ιδιοχαρακτηριστικό «στόχος»';
$string['userfields'] = 'Πεδία ορισμένα από το χρήστη';
$string['userinfo'] = 'Πληροφορίες χρήστη';
$string['useristeammember'] = 'Ένας χρήστης είναι ένα μέλος ομάδας';
$string['userpref'] = 'Προτιμήσεις χρήστη';
$string['usersubmissions'] = 'Εμφάνιση υποβολών';
$string['usersubmissionsinpopup'] = 'Υποβολές χρήστη σε αναδυόμενο';
$string['usersubmissionsview'] = 'Εμφάνιση υποβολών χρήστη';
$string['vertical'] = 'Κάθετα';
$string['view'] = 'εμφάνιση';
$string['viewadd'] = 'Προσθήκη μιας εμφάνισης';
$string['viewcharactertags'] = 'Ετικέτες χαρακτήρων';
$string['viewcreate'] = 'Δημιουργία μιας νέας εμφάνισης';
$string['viewcurrent'] = 'Τρέχουσα εμφάνιση';
$string['viewdescription'] = 'Εμφάνιση περιγραφής';
$string['viewedit'] = 'Επεξεργασία «{$a}»...';
$string['vieweditthis'] = 'Επεξεργασία αυτής της εμφάνισης';
$string['viewfieldtags'] = 'Ετικέτες πεδίου';
$string['viewfilter'] = 'Φίλτρο';
$string['viewgroupby'] = 'Ομαδοποίηση κατά';
$string['viewintervalsettings'] = 'Ρυθμίσεις διαλείμματος';
$string['viewlistfooter'] = 'Υποσέλιδο λίστας';
$string['viewlistheader'] = 'Επικεφαλίδα λίστας';
$string['viewmultiplefieldgroups'] = 'Μπορείτε να χρησιμοποιήσετε περισσότερες από μία ομάδες πεδίων.';
$string['viewname'] = 'Εμφάνιση ονόματος';
$string['viewnew'] = 'Νέα {$a} προβολή';
$string['viewoptions'] = 'Εμφάνιση επιλογών';
$string['viewpagingfield'] = 'Πεδίο σελιδοποίησης';
$string['viewperpage'] = 'Ανά σελίδα';
$string['viewresettodefault'] = 'Επαναρχικοποίηση προεπιλογών';
$string['viewreturntolist'] = 'Επιστροφή στη λίστα';
$string['views'] = 'Προβολές';
$string['viewsadded'] = 'Η προβολή προστέθηκε';
$string['viewsconfirmdelete'] = 'Πρόκειται να διαγράψετε {$a} προβολή/-ές. Θέλετε να συνεχίσετε;';
$string['viewsconfirmduplicate'] = 'Πρόκειται να δημιουργηθεί αντίγραφο {$a} προβολής/-ών. Θέλετε να συνεχίσετε;';
$string['viewsdeleted'] = 'Η προβολή διαγράφηκε';
$string['viewsectionpos'] = 'Θέση ενότητας';
$string['viewslidepaging'] = 'Σελιδοποίηση διαφανειών';
$string['viewsmax'] = 'Μέγιστος αριθμός προβολών';
$string['viewsupdated'] = 'Η προβολή ενημερώθηκε';
$string['viewtemplate'] = 'Εμφάνιση υποδείγματος';
$string['viewtemplate_help'] = 'Εμφάνιση υποδείγματος';
$string['viewtodate'] = 'Εμφανίσιμο έως';
$string['viewvisibility'] = 'Ορατότητα';
$string['visibility'] = 'Ορατότητα';
$string['visibleto'] = 'Ορατό σε';
$string['wrongdataid'] = 'Έχει δοθεί λάθος αναγνωριστικό Datalynx';
