<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'hu', version '5.1'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Tevékenységek';
$string['addcategory'] = 'Kategória hozzáadása';
$string['addcategoryerror'] = 'Kategória hozzáadása nem sikerült.';
$string['addexceptionerror'] = 'Hiba userid:gradeitem-hez való kivétel hozzáadása közben';
$string['addfeedback'] = 'Visszajelzés hozzáadása';
$string['addgradeletter'] = 'Értékelés betű hozzáadása';
$string['addidnumbers'] = 'Azonosítószámok hozzáadása';
$string['additem'] = 'Értékelési tétel hozzáadása';
$string['additionalfeedback'] = 'Kiegészítő visszajelzés';
$string['addoutcome'] = 'Eredmény hozzáadása';
$string['addoutcomeitem'] = 'Eredményelem hozzáadása';
$string['addscale'] = 'Skála hozzáadása';
$string['adjustedweight'] = 'Súly beállítva';
$string['aggregateextracreditmean'] = 'Értékelések átlaga (pluszpontokkal)';
$string['aggregatemax'] = 'Legjobb értékelés';
$string['aggregatemean'] = 'Értékelések átlaga';
$string['aggregatemedian'] = 'Értékelések mediánja';
$string['aggregatemin'] = 'Legrosszabb értékelés';
$string['aggregatemode'] = 'Értékelések módusza';
$string['aggregatenotonlygraded'] = 'Üres értékelésekkel együtt';
$string['aggregateonlygraded'] = 'Üres értékelések kizárása';
$string['aggregateonlygraded_help'] = 'Üres értékelés az az értékelés, ami hiányzik az értékelésnaplóból. Ez tartozhat egy olyan leadott feladathoz, melynek értékelése még nem történt meg; egy teszthez, amivel még nem próbálkoztak meg stb.

Ez a beállítás megadja, hogy az üres értékelések kimaradnak-e az összesítésből vagy mint a legrosszabb értékelés számítanak, például 0-ként egy 0 és 100 között értékelt feladatnál.';
$string['aggregateoutcomes'] = 'Eredmények szerepeltetése az összegzésben';
$string['aggregateoutcomes_help'] = '<p>Ha az eredményeket beleveszi az összesítésbe, ezzel nem állhat elő a kívánt globális pont, ezért választhat: beleveszi vagy kihagyja őket.</p>';
$string['aggregatesonly'] = 'Áttérés csak az összegzésekhez';
$string['aggregatesubcatsupgradedgrades'] = 'Megjegyzés: A portál frissítése során törlődött az "Összesítés az alkategóriákkal" beállítás. Mivel a kurzus ezt korábban használta, ajánlott a változást ellenőriznie az értékelésnaplóban.';
$string['aggregatesum'] = 'Természetes';
$string['aggregateweightedmean'] = 'Értékelések súlyozott átlaga';
$string['aggregateweightedmean2'] = 'Értékelések egyszerű súlyozott átlaga';
$string['aggregation'] = 'Összegzés';
$string['aggregation_help'] = 'Az összesítés szabja meg, hogy egy kategória esetén az értékelések miként egyesítendők.

* Értékelések átlaga - Az összes értékelés összege a értékelések számával elosztva
* Értékelések mediánja - Sorba rendezett értékelések esetén a középső értékelés
* Legrosszabb értékelés
* Legjobb értékelés
* Értékelések módusza - A módusz a leggyakrabban előforduló értékelés
* Természetes - Az összes értékelés súlyozott összege';
$string['aggregation_link'] = 'grade/aggregation';
$string['aggregationcoef'] = 'Összegzési együttható';
$string['aggregationcoefextra'] = 'Pluszpont';
$string['aggregationcoefextra_help'] = 'Ha az összesítés „Természetes” vagy „Egyszerű súlyozott átlag” és a pluszpont négyzet be van jelölve, akkor a kategória maximális értékeléséhez az értékelési tételre adott maximális pont nem adódik hozzá, így anélkül elérhető a kategória maximális értékelése (vagy az azt meghaladó értékelés, ha ilyet a rendszergazda beállított), hogy minden értékelési tétel esetén maximális értékelést kellene elérni.

Ha az összesítés „Értékelések átlaga (pluszpontokkal)” és a pluszpont nullánál nagyobb értékre van beállítva, akkor a pluszpont lesz az a tényező, amellyel az értékelést az átlagszámítás utáni összeghez való hozzáadás előtt megszorozzuk.';
$string['aggregationcoefextra_link'] = 'grade/aggregation';
$string['aggregationcoefextrasum'] = 'Pluszpont';
$string['aggregationcoefextrasum_help'] = 'Ha a Pluszpont négyzet be van jelölve, az értékelési tétel maximális pontja nem adódik hozzá a kategória maximális értékeléséhez. Így a kategórián belül a maximális értékelés (vagy, ha a rendszergazda engedélyezi, a maximális fölötti értékelés) anélkül érhető el, hogy minden értékelési tétel esetén meglenne a maximális értékelés.';
$string['aggregationcoefextrasum_link'] = 'grade/aggregation';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = 'Pluszpont súlya';
$string['aggregationcoefextraweight_help'] = 'Ha a pluszpont súlya nagyobb nullánál, az értékelés a végső értékelésnél pluszpontként kerül az összegzésbe. A megadott szám az a szorzótényező, amivel a kapott értékelést megszorozzuk, mielőtt hozzáadnánk az összeghez az átlag kiszámításánál.';
$string['aggregationcoefextraweight_link'] = 'grade/aggregation';
$string['aggregationcoefweight'] = 'Tétel súlya';
$string['aggregationcoefweight_help'] = 'A tétel súlya a kategória összegzése során befolyásolja az adott tétel fontosságát a többi, szintén a kategóriában lévő értékelési tételhez képest.';
$string['aggregationcoefweight_link'] = 'grade/aggregation';
$string['aggregationhintdropped'] = '(Kihagyva)';
$string['aggregationhintexcluded'] = '(Kizárva)';
$string['aggregationhintextra'] = '(Pluszpont)';
$string['aggregationhintnovalue'] = '(Üres)';
$string['aggregationofa'] = '{$a} összesítése';
$string['aggregationposition'] = 'Összegzési pozíció';
$string['aggregationposition_help'] = 'Meghatározza, hogy a kategória és a kurzus összegezve oszlopok elsőként vagy utolsóként szerepeljenek az értékelésnapló jelentéseiben.';
$string['aggregationsvisible'] = 'Használható összegzési típusok';
$string['aggregationsvisiblehelp'] = 'Válassza ki az összes használandó összegzési típust. Több elem kiválasztásához nyomja le a Ctrl billentyűt.';
$string['allgrades'] = 'Összes értékelés kategóriákként';
$string['allstudents'] = 'Minden tanuló';
$string['allusers'] = 'Minden felhasználó';
$string['autosort'] = 'Automatikus rendezés';
$string['availableidnumbers'] = 'Használható azonosítószámok';
$string['average'] = 'Átlag';
$string['averagesdecimalpoints'] = 'Oszlopátlagok tizedesjegyei';
$string['averagesdecimalpoints_help'] = 'Meghatározza, hány tizedesjegy jelenjen meg az egyes oszlopátlagok esetén, vagy a kategória vagy értékelési tétel globális beállítását használja inkább (öröklés).';
$string['averagesdisplaytype'] = 'Oszlopátlagok megjelenítésének típusa';
$string['averagesdisplaytype_help'] = '<p>Meghatározza, hogyan jelenjen meg átlag az egyes oszlopok esetén. Az Öröklés kiválasztása esetén az egyes oszlopok megjelenítési típusa lesz használatos.</p>';
$string['backupwithoutgradebook'] = 'A biztonsági mentés nem tartalmazza az értékelésnapló beállítását';
$string['badgrade'] = 'A megadott értékelés érvénytelen';
$string['badlyformattedscale'] = 'Adjon meg egy vesszőkkel elválasztott értéklistát (legalább két értékkel).';
$string['baduser'] = 'A megadott felhasználó érvénytelen';
$string['bonuspoints'] = 'Jutalompontok';
$string['bulkcheckboxes'] = 'Vegyes jelölőnégyzetek';
$string['calculatedgrade'] = 'Számított értékelés';
$string['calculation'] = 'Számítás';
$string['calculation_help'] = 'Az értékelésszámítás az osztályzat meghatározására használt képlet. A képlet egyenlőségjellel (=) kezdődik, és szokásos matematikai műveletjeleket -- pl. max, min és sum -- tartalmazhat. Szükség esetén egyéb értékelési tételek illeszthetők a számításba: ehhez kettős szögletes zárójelben adja meg az azonosítószámokat.';
$string['calculation_link'] = 'grade/calculation';
$string['calculationadd'] = 'Számítás hozzáadása';
$string['calculationedit'] = 'Számítás szerkesztése';
$string['calculationsaved'] = 'Számítás elmentve';
$string['calculationview'] = 'Számítás megtekintése';
$string['cannotaccessgroup'] = 'A kiválasztott csoport értékelései nem érhetők el.';
$string['categories'] = 'Kategóriák';
$string['category'] = 'Kategória';
$string['categoryedit'] = 'Kategória szerkesztése';
$string['categoryname'] = 'Kategória neve';
$string['categorytotal'] = 'Kategória összes pontszáma';
$string['categorytotalfull'] = '{$a->category} összesen';
$string['categorytotalname'] = 'Kategória összegzésének neve ';
$string['changedefaults'] = 'Alapbeállítások módosítása';
$string['changereportdefaults'] = 'Jelentés alapbeállításainak módosítása';
$string['chooseaction'] = 'Válasszon egy lépést ...';
$string['choosecategory'] = 'Kategória kiválasztása';
$string['collapsecriterion'] = 'Feltétel összecsukása';
$string['compact'] = 'Tömör';
$string['componentcontrolsvisibility'] = 'Az értékelési tétel láthatóságát a tevékenység beállításai szabályozzák.';
$string['contract'] = 'Szerződéskategória';
$string['contributiontocoursetotal'] = 'Hozzájárulás a kurzus összpontszámához';
$string['courseavg'] = 'Kurzusátlag';
$string['coursegradecategory'] = 'Kurzus értékelési kategóriája';
$string['coursegradedisplaytype'] = 'Kurzus értékelés-megjelenítési típusa';
$string['coursegradedisplayupdated'] = 'A kurzus értékelés-megjelenítési típusának frissítése megtörtént.';
$string['coursegradesettings'] = 'Kurzus értékelésbeállításai';
$string['coursename'] = 'Kurzus neve';
$string['coursescales'] = 'Kurzusskálák';
$string['coursesettings'] = 'Kurzus beállításai';
$string['coursesettingsexplanation'] = 'A kurzus értékelésbeállításaitól függ, miként jelenik meg a kurzus résztvevői számára az értékelésnapló.';
$string['coursesiamtaking'] = 'Kurzusaim tanulóként';
$string['coursesiamteaching'] = 'Kurzusaim oktatóként';
$string['coursetotal'] = 'Kurzus összegezve';
$string['createcategory'] = 'Kategória létrehozása';
$string['createcategoryerror'] = 'Új kategória létrehozása nem sikerült';
$string['creatinggradebooksettings'] = 'Értékelésnapló beállításainak létrehozása';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Jelenlegi szülők egyesítése';
$string['curveto'] = 'Görbe';
$string['decimalpoints'] = 'Összes tizedesjegy';
$string['decimalpoints_help'] = 'Megadja, hány tizedeshely jelenjen meg az egyes értékeléseknél. A beállításnak a számításokra nincs hatása, azok 5 tizedesnyi pontossággal állnak elő.';
$string['default'] = 'Alapbeállítás';
$string['defaultprev'] = 'Alapbeállítás ({$a})';
$string['deletecategory'] = 'Kategória törlése';
$string['disablegradehistory'] = 'Értékeléselőzmények kikapcsolása';
$string['disablegradehistory_help'] = 'Az értékelésekhez kapcsolódó táblázatokban végrehajtott módosítások nyomon követésének kikapcsolása. Ezzel kissé felgyorsítható a szerver működése és hely takarítható meg az adatbázisban.';
$string['displaylettergrade'] = 'Értékelési betűk megjelenítése';
$string['displaypercent'] = 'Kijelzés százalékkal';
$string['displaypoints'] = 'Kijelzés pontokkal';
$string['displayweighted'] = 'Súlyozott értékelések megjelenítése';
$string['droplow'] = 'A legalacsonyabb kihagyása';
$string['droplow_help'] = 'Beállítása esetén egy adott darabszámú legrosszabb értékelés kihagyható lesz az összesítésnél.';
$string['droplowestvalue'] = 'Legrosszabb értékelés kihagyásának beállítása';
$string['droplowestvalues'] = '{$a} legalacsonyabb érték kihagyása';
$string['dropped'] = 'Kihagyva';
$string['dropxlowest'] = 'Legalacsonyabb X kihagyása';
$string['dropxlowestwarning'] = 'Megjegyzés: a legrosszabb x kihagyása esetén az értékelés abból indul ki, hogy minden kategóriában a tételek azonos pontértékkel rendelkeznek. Ha eltérnek, az eredmény megjósolhatatlanná válik.';
$string['duplicatedgradeitem'] = '{$a} (másolat)';
$string['duplicatescale'] = 'Ismétlődő skála';
$string['edit'] = 'Szerkesztés';
$string['editcalculation'] = 'Kalkuláció szerkesztése';
$string['editcalculationverbose'] = '{$a->category} {$a->itemmodule}{$a->itemname} számítás szerkesztése';
$string['editfeedback'] = 'Visszajelzés szerkesztése';
$string['editgrade'] = 'Értékelés szerkesztése';
$string['editgradeletters'] = 'Értékelési betűk szerkesztése';
$string['editoutcome'] = 'Eredmény szerkesztése';
$string['editoutcomes'] = 'Eredmények szerkesztése';
$string['editscale'] = 'Kategóriák és elemek';
$string['edittree'] = 'Beállítás';
$string['editverbose'] = 'A(z) {$a->category} {$a->itemmodule} {$a->itemname} szerkesztése';
$string['enableoutcomes'] = 'Eredmények bekapcsolása';
$string['enableoutcomes_help'] = 'Bekapcsolása esetén az értékelési tételek eredmény-megállapításokhoz kötött egy vagy több skála segítségével értékelhetők.';
$string['encoding'] = 'Kódolás';
$string['encoding_help'] = 'Válassza ki a karakterkódolást. (A standard karakterkódolás az UTF-8.) Ha véletlenül hibás kódolást választ, az látható lesz az importálandó adatok előnézetében.';
$string['errorcalculationbroken'] = 'Hiba {$a} értékelési tétel számítása során.';
$string['errorcalculationnoequal'] = 'A képletnek egyenlőségjellel kell kezdődnie (=1+2)';
$string['errorcalculationunknown'] = 'Hibás képlet';
$string['errorgradevaluenonnumeric'] = 'Nem számszerű alacsony vagy magas érték érkezett az értékelésre';
$string['errornocalculationallowed'] = 'Ezen tétel esetén számítás nem alkalmazható';
$string['errornocategorisedid'] = 'Nincs kategorizálatlan azonosító!';
$string['errornocourse'] = 'Nincs kurzusinformáció';
$string['errorreprintheadersnonnumeric'] = 'Újranyomtatási fejléchez nem számjegyes érték érkezett';
$string['errorsavegrade'] = 'Az értékelést nem lehetett elmenteni.';
$string['errorsettinggrade'] = 'Hiba {$a->userid} felhasználó "{$a->itemname}" értékelésének mentése közben';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Hiba a(z) {$a->id} azonosítójú értékelési kategória "Csak a nem üres értékelések összegzése" beállításának frissítése közben';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Hiba a(z) {$a->id} azonosítójú értékelési kategória "Eredmények beillesztése az összegzésbe" beállításának frissítése közben';
$string['errorupdatinggradecategoryaggregation'] = 'Hiba a(z) {$a->id} azonosítójú értékelési kategória összegzési típusának frissítése közben';
$string['errorupdatinggradeitemaggregationcoef'] = 'Hiba a(z) {$a->id} azonosítójú értékelési kategória összegzési együtthatójának (súly vagy pluszpont) frissítése közben';
$string['eventgradedeleted'] = 'Értékelés törölve';
$string['eventgradeitemcreated'] = 'Értékelési tétel létrehozva';
$string['eventgradeitemdeleted'] = 'Értékelési tétel törölve';
$string['eventgradeitemupdated'] = 'Értékelési tétel frissítve';
$string['eventgradelettercreated'] = 'Értékelési betű létrehozva';
$string['eventgradeletterdeleted'] = 'Értékelési betű törölve';
$string['eventgradeletterupdated'] = 'Értékelési betű frissítve';
$string['eventgradeviewed'] = 'Az értékelésnaplóban lévő értékeléseket megtekintették';
$string['eventscalecreated'] = 'Skála létrehozva';
$string['eventscaledeleted'] = 'Skála törölve';
$string['eventscaleupdated'] = 'Skála frissítve';
$string['eventusergraded'] = 'Felhasználó értékelve';
$string['excluded'] = 'Kizárva';
$string['excluded_help'] = 'Bekapcsolása esetén az értékelés kimarad minden összegzésből.';
$string['expand'] = 'Kategória kiterjesztése';
$string['expandcriterion'] = 'Feltétel kibontása';
$string['export'] = 'Exportálás';
$string['exportalloutcomes'] = 'Minden eredmény exportálása';
$string['exportfeedback'] = 'Visszajelzés beillesztése az exportálásba';
$string['exportfeedback_desc'] = 'Ez exportálás során fölülírható.';
$string['exportformatoptions'] = 'Exportálási formátum beállításai';
$string['exportonlyactive'] = 'Felfüggesztett felhasználók kizárása';
$string['exportonlyactive_help'] = 'Csak a nem felfüggesztett, beiratkozott tanulók exportálása';
$string['exportplugins'] = 'Segédprogramok exportálása';
$string['exportsettings'] = 'Beállítások exportálása';
$string['exportto'] = 'Exportálás helye';
$string['externalurl'] = 'Külső URL';
$string['externalurl_desc'] = 'Külső értékelésnapló használata esetén itt kell megadni a hivatkozást.';
$string['extracreditvalue'] = 'Pluszpont {$a} esetén';
$string['extracreditwarning'] = 'Megjegyzés: egy kategória minden tételét pluszpontra állítva azok kikerülnek az értékelésszámításból, mert így nem lesz összesített értékelés';
$string['fail'] = 'Sikertelen';
$string['feedback'] = 'Visszajelzés';
$string['feedback_help'] = 'Itt bármilyen megjegyzés fűzhető a készülő értékelés mellé.';
$string['feedbackadd'] = 'Visszajelzés hozzáadása';
$string['feedbackedit'] = 'Visszajelzés szerkesztése';
$string['feedbackfiles'] = 'Visszajelzés állományai';
$string['feedbackforgradeitems'] = '{$a} visszajelzése';
$string['feedbackhistoryfiles'] = 'Visszajelzési előzmények állományai';
$string['feedbacks'] = 'Visszajelzések';
$string['feedbacksaved'] = 'Visszajelzés elmentve';
$string['feedbackview'] = 'Visszajelzés megtekintése';
$string['filterbyname'] = 'Szűrés név szerint';
$string['finalgrade'] = 'Végső értékelés';
$string['finalgrade_help'] = 'A felülírva jelölőnégyzet bejelölésekor egy értékelés módosítható vagy beszúrható.';
$string['fixedstudents'] = 'Statikus tanulói hasáb';
$string['fixedstudents_help'] = 'Lehetővé teszi az értékelések vízszintes görgetését, a tanulói oszlop elmozdulása nélkül, rögzítve azt.';
$string['forceimport'] = 'Importálás végrehajtása';
$string['forceimport_help'] = 'Értékelések importálása akkor is, ha az értékelések frissítve lettek a bemeneti állomány letöltése után';
$string['forceoff'] = 'Előírás: Ki';
$string['forceon'] = 'Előírás: Be';
$string['forelementtypes'] = 'a kiválasztott {$a} részére';
$string['forstudents'] = 'Tanulóknak';
$string['full'] = 'Teljes';
$string['fullmode'] = 'Értékelések és összegzések mutatása';
$string['generalsettings'] = 'Általános beállítások';
$string['grade_help'] = 'A tanuló munkájára adandó értékelés.';
$string['gradeadministration'] = 'Értékelés kezelése';
$string['gradealreadyupdated'] = '{$a} értékelés importálása elmaradt, mert a bemeneti állományban lévő értékelések régebbiek az értékelőjelentésben lévőknél. Ha ennek ellenére folytatná az importálást, válassza az Importálás végrehajtása beállítást.';
$string['gradeanalysis'] = 'Értékelés elemzése';
$string['gradebook'] = 'Értékelésnapló';
$string['gradebookcalculationsfixbutton'] = 'Értékelés változtatások elfogadása és számítási hibák javítása';
$string['gradebookcalculationsuptodate'] = 'Az értékelésnapló számításai naprakészek. A változások megtekintéséhez töltse újra az oldalt.';
$string['gradebookcalculationswarning'] = 'Megjegyzés: az értékelésnaplóban látszó értékeléseknél használt számítás hibát tartalmaz. Ha a kurzus még nem kezdődött el vagy még tart, javasolt a hibák kijavítása az alábbi gombra kattintásával, bár emiatt néhány értékelés módosulni fog. Ha a kurzus már véget ért és megtörtént az értékelések leadására, vélhetően nem akarja ezt javítani.

Az újabb verzió {$a->currentversion}; a most használt pedig a(z) {$a->gradebookversion}. Változások felsorolása: <a href="{$a->url}">Értékelésnapló számítási változtatásai</a>.';
$string['gradebookhiddenerror'] = 'Az értékelésnapló a mostani beállításban mindent elrejt a tanulók elől.';
$string['gradebookhistories'] = 'Értékeléselőzmények';
$string['gradebooksetup'] = 'Értékelésnapló beállítása';
$string['gradeboundary'] = 'Értékelési betű határa';
$string['gradeboundary_help'] = 'Ez a beállítás meghatározza a legkisebb százalékos határt, mely fölött az értékelésnél az adott értékelési betűt lesz feltüntetve.';
$string['gradecategories'] = 'Értékelési kategóriák';
$string['gradecategory'] = 'Értékelési kategória';
$string['gradecategoryonmodform'] = 'Értékelési kategória';
$string['gradecategoryonmodform_help'] = 'Ez a beállítás szabályozza azt a kategóriát, amelyikbe ezen tevékenység értékelései kerülnek az értékelésnaplóban.';
$string['gradecategorysettings'] = 'Értékelési kategória beállításai';
$string['gradedisplay'] = 'Értékelés megjelenítése';
$string['gradedisplaytype'] = 'Értékelés megjelenítésének típusa';
$string['gradedisplaytype_help'] = 'Megadja, miként jelenjenek meg az értékelések az értékelő és a felhasználói jelentésekben.

* Betűk - A betűk vagy szavak értékelési tartományokat jelölnek, az értékelésnapló beállításaiban a "Betűk"-nél megadott módon.
* Százalékok - A legjobb és legrosszabb értékelésekhez viszonyítva
* Valós - számszerű értékek vagy értékek egy skálából';
$string['gradedon'] = 'Értékelve: {$a}';
$string['gradeexport'] = 'Értékelés exportálása';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = 'Egyedi profilmezők az értékelés exportálásnál';
$string['gradeexportcustomprofilefields_desc'] = 'Az alábbi egyedi profilmezők szerepeljenek az exportált értékelésben, vesszőkkel elválasztva.';
$string['gradeexportdecimalpoints'] = 'Tizedesjegyek az értékelés exportálásnál';
$string['gradeexportdecimalpoints_desc'] = 'Az exportáláshoz megjelenítendő tizedesjegyek száma. Exportálás közben ez felülírható.';
$string['gradeexportdisplaytype'] = 'Megjelenítés típusa az értékelés exportálásnál';
$string['gradeexportdisplaytype_desc'] = 'Az értékelések exportálása során azok megjeleníthetők valós értékelésként, százalékok (a legjobb és legrosszabb értékeléshez képest) vagy betűk (A, B, C stb.) formájában. Exportálás közben ez felülírható.';
$string['gradeexportdisplaytypes'] = 'Megjelenítés típusok az értékelés exportálásnál';
$string['gradeexportuserprofilefields'] = 'Felhasználói profilmezők az értékelés exportálásnál';
$string['gradeexportuserprofilefields_desc'] = 'Az alábbi felhasználói profilmezők szerepeljenek az exportált értékelésben, vesszőkkel elválasztva.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradegrademinmax'] = 'Kezdeti legrosszabb és legjobb értékelések';
$string['gradehelp'] = 'Súgó az értékeléshez';
$string['gradehistorylifetime'] = 'Értékeléselőzmények megőrzési ideje';
$string['gradehistorylifetime_help'] = 'Megadja, mennyi ideig kívánja a változtatási előzményeket megőrizni az értékelésekhez kapcsolódó táblázatokban. Ajánlott minél hosszabb ideig megőrizni. Ha teljesítmény vagy tárhely terén problémába ütközik, próbálkozzék egy alacsonyabb értékkel.';
$string['gradeimport'] = 'Értékelés importálása';
$string['gradeimportfailed'] = 'Az értékelésimportálás végrehajtása sikertelen. Részletek:';
$string['gradeitem'] = 'Értékelési tétel';
$string['gradeitemaddusers'] = 'Kihagyni az értékelésből';
$string['gradeitemislocked'] = 'Ez a tevékenység az értékelésnaplóban zárolva van. Feloldásáig az értékelések módosítása nem lesz átvezetve az értékelésnaplóba.';
$string['gradeitemlocked'] = 'Értékelés zárolva';
$string['gradeitemmembersselected'] = 'Értékelésből kihagyva';
$string['gradeitemminmax'] = 'Legjobb és legrosszabb értékelések az értékelési tételek beállításoknak megfelelően';
$string['gradeitemnonmembers'] = 'Értékelésbe bevonva';
$string['gradeitemremovemembers'] = 'Bevonni az értékelésbe';
$string['gradeitems'] = 'Értékelési tételek';
$string['gradeitemsettings'] = 'Értékelési tétel beállításai';
$string['gradeitemsinc'] = 'Bevonandó értékelési tételek';
$string['gradeletter'] = 'Értékelési betű';
$string['gradeletter_help'] = 'Az értékelési betűk olyan betűk (A, B, C, ...) vagy szavak (Kiváló, Jó, Megfelelt, ...), amelyek egy értékelési tartományt jelképeznek.';
$string['gradeletternote'] = 'Egy értékelési betű törléséhez csak törölje az ahhoz tartozó<br /> három szövegterület valamelyikét és kattintson a Beküldésre.';
$string['gradeletteroverridden'] = 'Az értékelés alapbetűi módosultak.';
$string['gradeletters'] = 'Értékelési betűk';
$string['gradelocked'] = 'Értékelés zárolva';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Legjobb értékelés';
$string['grademax_help'] = 'Ez a beállítás adja meg a legjobb értékelést a számérték típusú értékelés esetén. Ez a maximum érték egy tevékenység-alapú értékelési tételnél a tevékenység beállítások oldalán adható meg.';
$string['grademin'] = 'Legrosszabb értékelés';
$string['grademin_help'] = 'Ez a beállítás adja meg a legrosszabb értékelést a számérték típusú értékelés esetén.';
$string['gradenotificationmessage'] = 'A(z) "{$a}" munkával kapcsolatosan új visszajelzése érkezett';
$string['gradenotificationsubject'] = 'Értékelésére sor került';
$string['gradeoutcomeitem'] = 'Értékelési eredménytétel';
$string['gradeoutcomes'] = 'Eredmények';
$string['gradeoutcomescourses'] = 'Kurzus eredményei';
$string['gradepass'] = 'Ponthatár';
$string['gradepass_help'] = 'Ez a beállítás adja meg a megfelelt értékeléshez szükséges minimumot. Az érték a tevékenység- és kurzusteljesítésnél, valamint az értékelésnaplóban is fel lesz használva, és a "megfelelt" értékelések zöld, míg a "nem felelt meg" értékelések piros kiemelést kapnak.';
$string['gradepassgreaterthangrade'] = 'A ponthatár nem lehet magasabb az elérhető legjobb értékelésnél: {$a}.';
$string['gradepointdefault'] = 'Alapértelmezett pontértéket';
$string['gradepointdefault_help'] = 'Ez a beállítás határozza meg az alapértelmezett pontértéket, amely egy értékelési tételnél elérhető.';
$string['gradepointdefault_validateerror'] = '1 és a maximális pontérték közé eső egész számot kell megadni';
$string['gradepointmax'] = 'Maximális pontérték';
$string['gradepointmax_help'] = 'Ez a beállítás határozza meg a maximális pontértéket, amely egy tevékenységnél elérhető.';
$string['gradepointmax_validateerror'] = '1 és 10000 közé eső egész számot kell megadni';
$string['gradepreferences'] = 'Értékelési beállítások';
$string['gradepreferenceshelp'] = 'Súgó az értékelési beállításokhoz';
$string['gradepublishing'] = 'Közzététel bekapcsolása';
$string['gradepublishing_help'] = 'Az értékelések közzététele azoknak egy webcímről való exportálását vagy importálását jelenti anélkül, hogy a Moodle-portálra be kellene jelentkezni. Bekapcsolása esetén a rendszergazdák és az értékelések közzétételére jogosultak (alapesetben az igazgatók) minden értékelésnaplóban megkapják az értékelések exportálásához szükséges beállításokat.';
$string['gradepublishinglink'] = 'Letöltés: {$a}';
$string['gradereport'] = 'Értékelési jelentés';
$string['graderreport'] = 'Értékelőjelentés';
$string['grades'] = 'Értékelések';
$string['gradesforuser'] = '{$a->user} értékelései';
$string['gradesmoduledeletionpendingwarning'] = 'Figyelem! Tevékenység törlése folyamatban. Néhány értékelés törölve lesz.';
$string['gradesmoduledeletionprefix'] = '[Törlés folyamatban]';
$string['gradesonly'] = 'Csak az értékelések mutatása';
$string['gradessettings'] = 'Értékelés beállításai';
$string['gradetype'] = 'Értékelés típusa';
$string['gradetype_help'] = '4 értékelési típus létezik:

* Nincs - Nem lehet értékelést adni
* Számérték - Egy számszerű érték, maximummal és minimummal
* Skála - Egy tétel egy listából
* Szöveg - Csak visszajelzés

Csak számértéken és skálán alapuló értékeléseket lehet összegezni. Egy tevékenység-alapú értékelési tétel típusa a tevékenység beállítások oldalán adható meg.';
$string['gradevaluetoobig'] = 'Az egyik pontérték magasabb az engedélyezett {$a} maximumnál';
$string['gradeview'] = 'Értékelés megtekintése';
$string['gradewasmodifiedduringediting'] = '{$a->username} esetén a(z) {$a->itemname} tételhez megadott értékelés ki lett hagyva, mert valaki azt azóta már frissítette.';
$string['gradeweighthelp'] = 'Súgó az értékelés súlyozásához';
$string['gradingmodulename'] = 'Értékelés ({$a})';
$string['groupavg'] = 'Csoportátlag';
$string['hidden'] = 'Rejtve';
$string['hidden_help'] = 'Bejelölése esetén a tanulók nem látják az értékeléseket. Szükség esetén beállítható egy elrejtési időtartam, így az értékelések az értékelés befejezése után jelenhetnek meg.';
$string['hiddenasdate'] = 'Leadás dátumának megjelenítése rejtett értékeléseknél';
$string['hiddenasdate_help'] = 'Ha a felhasználó nem láthatja a rejtett értékeléseket, a \'-\' helyett jelenjen meg a leadás dátuma.';
$string['hiddenuntil'] = 'Rejtve eddig';
$string['hiddenuntildate'] = 'Rejtve eddig: {$a}';
$string['hideadvanced'] = 'Részletes funkciók elrejtése';
$string['hideaverages'] = 'Átlagok elrejtése';
$string['hidecalculations'] = 'Számítások elrejtése';
$string['hidecategory'] = 'Rejtett';
$string['hideeyecons'] = 'Elrejtés/Felfedés ikonok elrejtése';
$string['hidefeedback'] = 'Visszajelzés elrejtése';
$string['hideforcedsettings'] = 'Előírt beállítások elrejtése';
$string['hideforcedsettings_help'] = 'Előírt beállítások elrejtése az értékelési felületen.';
$string['hidegroups'] = 'Csoportok elrejtése';
$string['hidelocks'] = 'Zárolások elrejtése';
$string['hidenooutcomes'] = 'Eredmények megjelenítése';
$string['hidequickfeedback'] = 'Gyors visszajelzés elrejtése';
$string['hideranges'] = 'Tartományok elrejtése';
$string['hidetotalifhiddenitems'] = 'Összesítések elrejtése, ha azok rejtett tételeket tartalmaznak.';
$string['hidetotalifhiddenitems_help'] = 'Itt adható meg, hogy a rejtett tételeket tartalmazó összesítéseket látják-e a tanulók, vagy kötőjel (-) jelenik meg helyükön. Megjelenítés esetén az eldönthető, hogy az összesítésben szerepeljenek-e a rejtett tételek vagy sem.

Ha a rejtett elemek nem kerülnek bele az összesítésbe, akkor az értékelőjelentésben a tanár más összesítést fog látni, mivel ő mindig az összes tétellel számított összesítést látja. Ha a rejtett tételek is szerepelnek benne, akkor a tanulók kiszámíthatják a rejtett tételeket.';
$string['hidetotalshowexhiddenitems'] = 'Összesítés megjelenítése rejtett tételek nélkül';
$string['hidetotalshowinchiddenitems'] = 'Összesítés megjelenítése rejtett tételekkel együtt';
$string['hideverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} elrejtése';
$string['highgradeascending'] = 'Növekvő rendezés';
$string['highgradedescending'] = 'Csökkenő rendezés';
$string['highgradeletter'] = 'Magas';
$string['identifier'] = 'Felhasználó azonosítási szempontja';
$string['idnumbers'] = 'Azonosítószámok';
$string['ignore'] = 'Kihagy';
$string['import'] = 'Importálás';
$string['importcsv'] = 'CSV importálása';
$string['importcsv_help'] = 'Az értékelések CSV-állományból importálhatók az alábbiak szerint:

* Az állomány minden sora egy rekordot tartalmaz
* Minden rekord egymástól vesszővel vagy más elválasztóval határolt adatokat tartalmaz
* Az első rekord az állomány fennmaradó részének a formáját meghatározó mezőneveket tartalmazza
* Kötelezően szerepelnie kell egy felhasználót azonosító mezőnévnek - ez lehet felhasználónév, azonosítószám vagy e-mail cím

Egy helyesen formált állományt előállíthat úgy, hogy először csak néhány értékelést exportál. Ezután az állományt szerkesztheti és CSV-állományként elmentheti.';
$string['importcsv_link'] = 'grade/import/csv/index';
$string['importcustom'] = 'Importálás egyéni eredményként (csak ezen kurzus esetén)';
$string['importdata'] = 'Adatok';
$string['importdata_help'] = 'Az értékelések OpenDocument vagy Excel tábla esetén közvetlenül átemelhetők ekként:

* Legalább egy oszlopban szerepeljen felhasználót beazonosító adat - felhasználónév, e-mail-cím vagy azonosítószám.
* A többi oszlopfejléc egyezzen meg aktuális tevékenységekkel vagy az értékelési tételekkel.

Megfelelő táblázat kialakítható először egyes értékelések exportálásával, ezután a táblázatot egészítse ki további értékelésekkel, majd mentse el.

Az importálandó oszlopokat válassza ki a táblázatból és másolja be ebbe a mezőbe.';
$string['importerror'] = 'Hiba, a kód meghívása nem a megfelelő paraméterekkel  történt.';
$string['importfailed'] = 'Sikertelen importálás. Adatimportálás nem történt.';
$string['importfeedback'] = 'Importálási visszajelzés';
$string['importfile'] = 'Állomány importálása';
$string['importfilemissing'] = 'Állomány importálására nem kerül sor, térjen vissza az űrlaphoz és töltsön föl egy érvényes állományt.';
$string['importfrom'] = 'Importálás helye';
$string['importoutcomenofile'] = 'A feltöltött állomány üres vagy hibás. Ellenőrizze, érvényes-e az állomány. A probléma a(z) {$a} soron jelentkezett; az az oka, hogy az adatsorok nem rendelkeznek annyi oszloppal, amennyivel az első sor (a fejléc), vagy az importált állományhoz nincsenek meg a szükséges fejlécek. Az exportált állomány alapján ellenőrizheti, hogy néz ki egy érvényes fejléccel rendelkező állomány.';
$string['importoutcomes'] = 'Eredmények importálása';
$string['importoutcomes_help'] = 'Eredmények importálhatók az exportált eredményekkel azonos formájú csv-állományokból.';
$string['importoutcomes_link'] = 'grade/outcome';
$string['importoutcomesuccess'] = 'Importálási eredmény #{$a->id} azonosítójú "{$a->name}" esetén';
$string['importplugins'] = 'Segédprogramok importálása';
$string['importpreview'] = 'Nyomtatási kép importálása';
$string['importsettings'] = 'Beállítások importálása';
$string['importskippednomanagescale'] = 'Nem jogosult új skála felvételére, ezért a(z) "{$a}" eredmény kimaradt, mivel ahhoz új skálát kellett volna fölvenni';
$string['importskippedoutcome'] = 'Ebben a környezetben már létezik "{$a}" rövid nevű eredmény, az importált állományban lévő ezért kimaradt.';
$string['importstandard'] = 'Importálás standard eredményekként';
$string['importsuccess'] = 'Az értékelés importálása sikerült';
$string['importxml'] = 'XML importálása';
$string['includescalesinaggregation'] = 'Skálák szerepeltetése az összegzésben';
$string['includescalesinaggregation_help'] = 'Módosíthatja azt, hogy a skálák számokként bekerüljenek-e minden kurzus minden értékelésnaplójának minden összegzett értékelésébe. VIGYÁZAT: ezen beállítás módosítása esetén minden összegzett értékelést újraszámol a rendszer.';
$string['incorrectcourseid'] = 'Hibás volt a kurzus-azonosító';
$string['incorrectcustomscale'] = '(Hibás egyéni tartomány, módosítsa.)';
$string['incorrectminmax'] = 'A minimumnak a maximumnál kisebbnek kell lennie';
$string['inherit'] = 'Örököl';
$string['intersectioninfo'] = 'Információ a tanuló/értékelés tekintetében';
$string['invalidgradeexporteddate'] = 'Érvénytelen exportálási dátum: vagy régebbi egy évnél, vagy a jövőt illetően formátuma érvénytelen.';
$string['item'] = 'Tétel';
$string['iteminfo'] = 'Tétel adatai';
$string['iteminfo_help'] = '<p>A tétellel kapcsolatos adatok rögzítésére szolgáló hely. A megadott szöveg sehol máshol nem jelenik meg.</p>';
$string['itemname'] = 'Tétel neve';
$string['itemnamehelp'] = 'A tétel modulból származó neve.';
$string['items'] = 'Tételek';
$string['itemsedit'] = 'Értékelés tétel szerkesztése';
$string['keephigh'] = 'A legmagasabb megtartása';
$string['keephigh_help'] = 'Bekapcsolása esetén csak a legjobb X értékelést tartja meg, ahol az X a kiválasztott érték.';
$string['keephighestvalues'] = 'A legmagasabb {$a} érték megtartása';
$string['keymanager'] = 'Kulcs kezelője';
$string['lessthanmin'] = 'A(z) {$a->itemname} {$a->username} esetén megadott értékelés nagyobb a maximálisan megengedettnél';
$string['letter'] = 'Betű';
$string['lettergrade'] = 'Betűs értékelés';
$string['lettergradenonnumber'] = 'Az alacsony és/vagy magas pont nem számjegyes volt';
$string['letterpercentage'] = 'Betű (százalék)';
$string['letterreal'] = 'Betű (valós)';
$string['letters'] = 'Betűk';
$string['linkedactivity'] = 'Kapcsolt tevékenység';
$string['linkedactivity_help'] = 'Ez a beállítás meghatároz egy tevékenységet, amelyhez ez az eredménytétel kapcsolódik. Ezzel mérhető a tanulói teljesítmény olyan kritériumok alapján, amelyeket a tevékenységhez tartozó értékelés nem vesz figyelembe.';
$string['linktoactivity'] = 'Kapcsolás a(z) {$a->title} című {$a->name} tevékenységhez';
$string['lock'] = 'Zárolás';
$string['locked'] = 'Zárolt';
$string['locked_help'] = 'Bejelölése esetén az értékeléseket a kapcsolódó tevékenység a továbbiakban nem fogja tudni automatikusan frissíteni.';
$string['locktime'] = 'Ezután zárolandó';
$string['locktimedate'] = 'Ezután zárolandó: {$a}';
$string['lockverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} zárolása';
$string['lowest'] = 'Legalacsonyabb';
$string['lowgradeletter'] = 'Alacsony';
$string['manageoutcomes'] = 'Eredmények kezelése';
$string['manualitem'] = 'Kézi tétel';
$string['mapfrom'] = 'Illesztés innen';
$string['mapfrom_help'] = 'Válassza ki a tábla felhasználót (felhasználónévvel, azonosítószámmal vagy e-mail címmel) azonosító adatokat tartalmazó oszlopát.';
$string['mappings'] = 'Értékelési tétel megfeleltetések';
$string['mappings_help'] = 'A tábla értékeléseket tartalmazó egyes értékeléses oszlopaihoz válassza ki az annak megfelelő értékelési tételt.';
$string['mapto'] = 'Illesztés ehhez';
$string['mapto_help'] = 'Válassza ki az \'Átvitel innen\' mezőhöz kiválasztottakkal egyező azonosító adatokat..';
$string['max'] = 'Legmagasabb';
$string['maxgrade'] = 'Legjobb értékelés';
$string['meanall'] = 'Összes értékelés';
$string['meangraded'] = 'Nem üres értékelések';
$string['meanselection'] = 'Oszlopátlagokhoz kiválasztott értékelések';
$string['meanselection_help'] = 'Ez a beállítás megadja, hogy az értékelés nélküli cellák bekerülnek-e az adott kategória vagy értékelési tétel átlagának számításába vagy sem.';
$string['median'] = 'Középérték';
$string['min'] = 'Legalacsonyabb';
$string['minimum_show'] = 'Legrosszabb értékelés megjelenítése';
$string['minimum_show_help'] = 'A legrosszabb értékelés az értékelések és súlyok számítására használatos. Ha nem jelenik meg, alapértéke 0 lesz, és nem lehet szerkeszteni.';
$string['minmaxtouse'] = 'Számításban használt legrosszabb és legjobb értékelés';
$string['minmaxtouse_desc'] = 'Ez a beállítás szabja meg, hogy az értékelésnaplóban megjelenített értékelés számításánál az értékelés adásakor érvényes kezdeti legrosszabb és legjobb értékelés legyen használva, avagy az értékelési tétel beállításainál megadott legrosszabb és legjobb értékelések. Ezt a beállítást célszerű nem csúcsidőben végrehajtani, mert az összes értékelés újraszámítása megterheli a szervert.';
$string['minmaxtouse_help'] = 'Ez a beállítás szabja meg, hogy az értékelésnaplóban megjelenített értékelés számításánál az értékelés adásakor érvényes kezdeti legrosszabb és legjobb értékelés legyen használva, avagy az értékelési tétel beállításainál megadott legrosszabb és legjobb értékelések.';
$string['minmaxtouse_link'] = 'Grades_min_max';
$string['minmaxupgradedgrades'] = 'Megjegyzés: egyes értékelések módosultak az értékelésnaplóban megjelenő értékelés kiszámítása során a legrosszabb és a legjobb értékelés változásából adódó következetlenség miatt. A változásokat ellenőrizze és fogadja el.';
$string['minmaxupgradefixbutton'] = 'Következetlenség feloldása';
$string['minmaxupgradewarning'] = 'Megjegyzés: egyes értékelések módosultak az értékelésnaplóban megjelenő értékelés kiszámítása során a legrosszabb és a legjobb értékelés változásából adódó következetlenség miatt. A következetlenség feloldásához kattintson az alábbi gombra; emiatt egyes értékelések módosulni fognak.';
$string['missingitemtypeoreid'] = 'A grade_edit_tree_column_select::get_item_cell($item, $params) 2. paraméteréből hiányzik a tömbkulcs (itemtype vagy eid)';
$string['missingscale'] = 'Skálát kell kiválasztani';
$string['mode'] = 'Leggyakoribb';
$string['modgrade'] = 'Értékelés';
$string['modgrade_help'] = 'Válassza ki a tevékenységhez kapcsolódó osztályozás típusát. Skála esetén a Skála lenyíló menüből választhat. Pont esetén megadhatja a tevékenységért járó maximális pontszámot.';
$string['modgradecantchangegradetype'] = 'A típust nem módosíthatja, mert már születtek értékelések.';
$string['modgradecantchangegradetypemsg'] = 'Már vannak értékelések, ezért a típusuk nem módosítható. Ha a legjobb értékelést szeretné módosítani, először el kell döntenie, átminősíti-e a meglévő értékeléseket vagy sem.';
$string['modgradecantchangegradetyporscalemsg'] = 'Már vannak értékelések, ezért a típus és a tartomány nem módosítható.';
$string['modgradecantchangeratingmaxgrade'] = 'A legjobb értékelést nem módosíthatja, ha az értékelendő tevékenységhez már vannak értékelések.';
$string['modgradecantchangescale'] = 'A tartományt nem módosíthatja, mert már születtek értékelések.';
$string['modgradecategorycantchangegradetypemsg'] = 'Ehhez a kategóriához olyan értékelési tételek kapcsolódnak, melyeket felülírtak. Mivel így bizonyos értékelések már megtörténtek, ezért az értékelés típusa nem módosítható. Ha a legjobb értékelést szeretné módosítani, először el kell döntenie, átminősíti-e a meglévő értékeléseket vagy sem.';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'Ehhez a kategóriához olyan értékelési tételek kapcsolódnak, melyeket felülírtak. Mivel így bizonyos értékelések már megtörténtek, ezért az értékelés típusa nem módosítható.';
$string['modgradecategoryrescalegrades'] = 'Felülírt értékelések átminősítése';
$string['modgradecategoryrescalegrades_help'] = 'A legjobb értékelés módosítása során el kell döntenie, módosuljanak-e a meglévő százalékos értékelések is.

Az \'Igen\' beállítás esetén a meglévő felülírt értékelések át lesznek minősítve, hogy a százalékos értékelések ne változnak.

Például \'Igen\' esetén, ha a legjobb értékelés egy tételnél 10-ről 20-ra módosul, egy 6/10 (60%) értékelés az átminősítés után 12/20-ra (60%) változik. \'Nem\' esetén viszont az értékelés nem változik, ezért kézzel kell beállítani az értékelési tételeket a megfelelő pontszámokhoz.';
$string['modgradedonotmodify'] = 'Ne módosítson meglévő értékeléseket';
$string['modgradeerrorbadpoint'] = 'Érvénytelen érték. 1 és {$a} közötti egész számnak kell lennie.';
$string['modgradeerrorbadscale'] = 'Érvénytelen skálát választott. Az alábbiak közül kell választania egyet.';
$string['modgrademaxgrade'] = 'Legjobb értékelés';
$string['modgraderescalegrades'] = 'Meglévő értékelések átminősítése';
$string['modgraderescalegrades_help'] = 'A legjobb értékelés módosítása során el kell döntenie, módosuljanak-e a meglévő százalékos értékelések is.

Az \'Igen\' beállítás esetén a meglévő értékelések át lesznek minősítve, hogy a százalékos értékelések ne változnak.

Például \'Igen\' esetén, ha a legjobb értékelés egy tételnél 10-ről 20-ra módosul, egy 6/10 (60%) értékelés az átminősítés után 12/20-ra (60%) változik. \'Nem\' esetén a 6/10 (60%) értékelésből 6/20 (30%) lenne, ezért kézzel kell beállítani az értékelési tételeket a megfelelő pontszámokhoz.';
$string['modgradetype'] = 'Típus';
$string['modgradetypenone'] = 'Nincs';
$string['modgradetypepoint'] = 'Pont';
$string['modgradetypescale'] = 'Skála';
$string['morethanmax'] = 'A(z) {$a->itemname} esetén {$a->username} részére beírt értékelés nagyobb, mint a megengedett legmagasabb';
$string['moveselectedto'] = 'A kiválasztott elemek áthelyezése ide:';
$string['movingelement'] = '{$a} áthelyezése';
$string['multfactor'] = 'Szorzó';
$string['multfactor_help'] = 'Az a tényező, amellyel az értékelési tétel összes értékelését meg kell szorozni, maximum értékként a legjobb értékeléssel. Például, ha a tényező 2 és a legjobb értékelés 100, akkor minden 50 alatti érték szorozva lesz 2-vel, és minden 50 fölötti pedig 100-ra módosul.';
$string['multfactorvalue'] = 'Szorzó {$a} esetén';
$string['mustchooserescaleyesorno'] = 'Megváltoztatja a meglévő értékeléseket?';
$string['mygrades'] = 'Felhasználói menü hivatkozása az értékelésekre';
$string['mygrades_desc'] = 'Ezzel kapcsolódhat a felhasználói menüből egy külső értékelésnaplóhoz.';
$string['mypreferences'] = 'Beállításaim';
$string['myreportpreferences'] = 'Jelentéseim beállításai';
$string['neverdeletehistory'] = 'Soha ne törölje az előzményt';
$string['newcategory'] = 'Új kategória';
$string['newitem'] = 'Új értékelési tétel';
$string['newoutcomeitem'] = 'Új eredményelem';
$string['no'] = 'Nem';
$string['nocategories'] = 'A kurzushoz nincs, vagy nem lehetett hozzáadni értékelési kategóriát';
$string['nocategoryname'] = 'Nincs megadva kategórianév.';
$string['nocategoryview'] = 'Nincs megtekinthető kategória';
$string['nocourses'] = 'Még nincsenek kurzusok';
$string['noexistingoutcomes'] = 'Nincsenek eredmények';
$string['noexistingscales'] = 'Nincsenek skálák';
$string['noforce'] = 'Ne írja elő';
$string['nogradeletters'] = 'Nincs beállítva értékelési betű';
$string['nogradesreturned'] = 'Nincs kapott értékelés';
$string['noidnumber'] = 'Nincs azonosítószám';
$string['nolettergrade'] = 'Nincs értékelési betű ehhez';
$string['nomode'] = 'Nem érvényes';
$string['nonnumericweight'] = 'Nem számjegyes érték érkezett ehhez';
$string['nonunlockableverbose'] = 'Az értékelés feloldásához {$a->itemname} feloldása szükséges.';
$string['nonweightedpct'] = 'súlyozatlan %';
$string['nooutcome'] = 'Nincs eredmény';
$string['nooutcomes'] = 'Az eredménytételeket kurzuseredményhez kell kötni, de a kurzusban nincsenek eredmények. Hozzáad egyet?';
$string['nopermissiontoresetweights'] = 'Súlyok visszaállítása nem engedélyezett';
$string['nopublish'] = 'Ne tegye közzé';
$string['noreports'] = 'A portálon nem tanul és nem tanít.';
$string['norolesdefined'] = 'Nincs szerep megadva a Rendszergazda > Pontok > Általános beállítások > Értékelt szerepek esetén';
$string['noscales'] = 'Az eredményeket kurzusskálához vagy globális skálához kell kötni, de a kurzusban nincsenek ilyenek. Hozzáad egyet?';
$string['noselectedcategories'] = 'nem voltak kiválasztva kategóriák.';
$string['noselecteditems'] = 'nem voltak kiválasztva tételek.';
$string['notenrolled'] = 'Jelenleg egy kurzust sem vett fel.';
$string['notteachererror'] = 'Ennek a használatához tanárnak kell lennie.';
$string['nousersloaded'] = 'Nincs betöltve felhasználó';
$string['nouserstograde'] = 'Nincs értékelésre váró felhasználó';
$string['numberofgrades'] = 'Értékelések száma';
$string['onascaleof'] = '{$a->grademin} és {$a->grademax} közötti skálán';
$string['operations'] = 'Műveletek';
$string['options'] = 'Lehetőségek';
$string['others'] = 'Egyebek';
$string['outcome'] = 'Eredmény';
$string['outcome_help'] = 'Ezen értékelési tétel eredménye.';
$string['outcomeassigntocourse'] = 'Másik eredmény hozzárendelése a kurzushoz';
$string['outcomecategory'] = 'Kategória eredményeinek létrehozása';
$string['outcomecategorynew'] = 'Új kategória';
$string['outcomeconfirmdelete'] = 'Biztosan törli a(z) "{$a}" eredményt?';
$string['outcomecreate'] = 'Új eredmény hozzáadása';
$string['outcomedelete'] = 'Eredmény törlése';
$string['outcomefullname'] = 'Teljes név';
$string['outcomeitem'] = 'Eredménytétel';
$string['outcomeitemsedit'] = 'Eredménytétel szerkesztése';
$string['outcomereport'] = 'Eredményről szóló jelentés';
$string['outcomes'] = 'Eredmények';
$string['outcomescourse'] = 'Kurzusban használt eredmények';
$string['outcomescoursecustom'] = 'Testre szabott (nem mozgatható)';
$string['outcomescoursenotused'] = 'Standard nincs használatban';
$string['outcomescourseused'] = 'Standard használatos (nem mozgatható)';
$string['outcomescustom'] = 'Testre szabott eredmények';
$string['outcomeshortname'] = 'Rövid név';
$string['outcomesstandard'] = 'Standard eredmények';
$string['outcomesstandardavailable'] = 'Elérhető standard eredmények';
$string['outcomestandard'] = 'Standard eredmény';
$string['outcomestandard_help'] = '<p>A standard eredmény az egész portálon minden kurzus számára elérhető.</p>';
$string['overallaverage'] = 'Globális átlag';
$string['overridden'] = 'Felülírva';
$string['overridden_help'] = 'Bekapcsolása esetén az értékelés nem módosítható a kapcsolódó tevékenységnél.

Amikor egy értékelés módosításra kerül az értékelési jelentésben, a felülírt jelölőnégyzet automatikusan be lesz jelölve. Ez eltávolítható, hogy az értékelés újra módosítható legyen a tevékenységnél.';
$string['overriddennotice'] = 'A tevékenységgel kapcsolatos végső értékelése kézzel módosítva lett.';
$string['overridecat'] = 'Kategória értékelések kézi felülírásának engedélyezése';
$string['overridecat_help'] = 'Kikapcsolása esetén a kategória értékeléseket nem lehet felülírni.';
$string['overridesitedefaultgradedisplaytype'] = 'Portál alapbeállításainak felülírása';
$string['overridesitedefaultgradedisplaytype_help'] = 'Bejelölése esetén a kurzushoz egyedi értékelési betűk és határok állíthatók be, a portál alapértelmezéseinek használata helyett.';
$string['overrideweightofa'] = '{$a} súly felülírása';
$string['parentcategory'] = 'Szülőkategória';
$string['pass'] = 'Sikeres';
$string['pctoftotalgrade'] = '%-a az összpontszámnak';
$string['percent'] = 'Százalék';
$string['percentage'] = 'Százalék';
$string['percentageletter'] = 'Százalék (betű)';
$string['percentagereal'] = 'Százalék (valós)';
$string['percentascending'] = 'Rendezés növekvő százalék szerint';
$string['percentdescending'] = 'Rendezés csökkenő százalék szerint';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Eltolás';
$string['plusfactor_help'] = '<p>Az a szám, amely a szorzó alkalmazása után a jelen osztályozási tétel minden pontjához hozzáadódik.</p>';
$string['plusfactorvalue'] = 'Eltolási érték  {$a} esetén';
$string['points'] = 'pont';
$string['pointsascending'] = 'Rendezés növekvő pontok szerint';
$string['pointsdescending'] = 'Rendezés csökkenő pontok szerint';
$string['positionfirst'] = 'Első';
$string['positionlast'] = 'Utolsó';
$string['preferences'] = 'Beállítások';
$string['prefgeneral'] = 'Általános';
$string['prefletters'] = 'Értékelési betűk és határok';
$string['prefrows'] = 'Speciális sorok';
$string['prefshow'] = 'Mutatás/elrejtés váltogatása';
$string['previewrows'] = 'Sorok nyomtatási képe';
$string['privacy:metadata:categorieshistory'] = 'Az értékelési kategóriák korábbi változatainak a rekordja';
$string['privacy:metadata:filepurpose'] = 'Az értékelésnaplóban egy felhasználó visszajelzési állományai';
$string['privacy:metadata:grade_import_newitem'] = 'Az értékelés importálásából az új grade_item nevek tárolására használt ideiglenes tábla';
$string['privacy:metadata:grade_import_newitem:importcode'] = 'Importálások egy tételét azonosító egyedi tételkód';
$string['privacy:metadata:grade_import_newitem:importer'] = 'Az adatokat importáló felhasználó';
$string['privacy:metadata:grade_import_newitem:itemname'] = 'Új értékelési tétel neve';
$string['privacy:metadata:grade_import_values'] = 'Értékelések importálásából használt ideiglenes tábla';
$string['privacy:metadata:grade_import_values:feedback'] = 'Értékelési visszajelzés';
$string['privacy:metadata:grade_import_values:finalgrade'] = 'Nyers értékelés érték';
$string['privacy:metadata:grade_import_values:importcode'] = 'Importálások egy tételét azonosító egyedi tételkód';
$string['privacy:metadata:grade_import_values:importer'] = 'Az adatokat importáló felhasználó';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'Megjelölendő, ha csak a visszajelzést importálták';
$string['privacy:metadata:grade_import_values:userid'] = 'Az a felhasználó, akinek az értékelését importálták';
$string['privacy:metadata:grades'] = 'Az értékelések rekordja';
$string['privacy:metadata:grades:aggregationstatus'] = 'Az összesítés állapota';
$string['privacy:metadata:grades:aggregationweight'] = 'Az összesítés súlya';
$string['privacy:metadata:grades:feedback'] = 'A visszajelzés';
$string['privacy:metadata:grades:finalgrade'] = 'Az értékelés';
$string['privacy:metadata:grades:information'] = 'További információk az értékelésről';
$string['privacy:metadata:grades:timemodified'] = 'Az értékelés utolsó módosításának az időpontja';
$string['privacy:metadata:grades:userid'] = 'Az értékeléssel rendelkező felhasználó azonosítója';
$string['privacy:metadata:grades:usermodified'] = 'A rekordot utoljára módosító felhasználó azonosítója';
$string['privacy:metadata:gradeshistory'] = 'A korábbi értékelések rekordja';
$string['privacy:metadata:history:loggeduser'] = 'A verziószámozás idején bejelentkezett felhasználó azonosítója';
$string['privacy:metadata:history:timemodified'] = 'Az értékelésverziózás időpontja';
$string['privacy:metadata:itemshistory'] = 'Az értékelési tételek korábbi változatainak a rekordja';
$string['privacy:metadata:outcomes'] = 'Az eredmények rekordja';
$string['privacy:metadata:outcomes:timemodified'] = 'A rekord módosításának az időpontja';
$string['privacy:metadata:outcomes:usermodified'] = 'A rekordot utoljára módosító felhasználó';
$string['privacy:metadata:outcomeshistory'] = 'Az eredmények korábbi változatainak a rekordja';
$string['privacy:metadata:scale'] = 'Skálák rekordja';
$string['privacy:metadata:scale:timemodified'] = 'A rekord utolsó módosításának időpontja';
$string['privacy:metadata:scale:userid'] = 'A rekordot utoljára módosító felhasználó';
$string['privacy:metadata:scalehistory'] = 'Skálák korábbi verzióinak rekordja';
$string['privacy:path:relatedtome'] = 'Hozzám kapcsolódó';
$string['privacy:request:historyactiondelete'] = 'Törlés';
$string['privacy:request:historyactioninsert'] = 'Beszúrás';
$string['privacy:request:historyactionupdate'] = 'Frissítés';
$string['privacy:request:unknowndeletedgradeitem'] = 'Ismeretlen (az értékelési tétel törlődött)';
$string['profilereport'] = 'Felhasználói profilról szóló jelentés';
$string['profilereport_help'] = 'A felhasználó profiloldalán használatos értékelési jelentés.';
$string['publishing'] = 'Közzététel';
$string['publishingoptions'] = 'Értékelés közzétételének lehetőségei';
$string['quickfeedback'] = 'Gyors visszajelzés';
$string['quickgrading'] = 'Gyors értékelés';
$string['quickgrading_help'] = 'Gyors értékelés során az értékelőjelentés minden pontcellájába bekerül egy szövegmező, ahol egyszerre szerkeszthet több értékelést is. Ezután a Frissítés gombra kattintva egyszerre hajthatja végre az összes módosítást, így nem kell egyenként sort keríteni erre.';
$string['range'] = 'Tartomány';
$string['rangedecimals'] = 'Tartomány tizedesjegyei';
$string['rangedecimals_help'] = 'Tartományhoz kijelzendő tizedesjegyek száma';
$string['rangesdecimalpoints'] = 'Tartományon belül látható tizedesjegyek';
$string['rangesdecimalpoints_help'] = 'Meghatározza, hány tizedesjegy jelenjen meg az egyes tartományok esetén, vagy a kategória vagy értékelés tétel globális beállítását használja inkább (öröklés).';
$string['rangesdisplaytype'] = 'Tartomány megjelenítésének típusa';
$string['rangesdisplaytype_help'] = '<p>Megadja az egyes tartományok megjelenítésének módját. Az Öröklés kiválasztása esetén az egyes oszlopok megjelenítési típusa lesz használatos.</p>';
$string['rank'] = 'Sorrend';
$string['rawpct'] = 'Nyers %';
$string['real'] = 'Valós';
$string['realletter'] = 'Valós (betű)';
$string['realpercentage'] = 'Valós (százalék)';
$string['recalculatinggrades'] = 'Értékelések újraszámítása';
$string['recovergradesdefault'] = 'Értékelések alapbeállításának visszaállítása';
$string['recovergradesdefault_help'] = 'Értékelések alapbeállításának visszaállítása felhasználó újbóli beiratkoztatása esetén';
$string['refreshpreview'] = 'Előnézet frissítése';
$string['regradeanyway'] = 'Újraértékelés mindenképpen';
$string['removeallcoursegrades'] = 'Összes értékelés';
$string['removeallcoursegrades_help'] = 'Bejelölése esetén minden kézzel hozzáadott értékelési tétel és értékelés törlődik az értékelésnaplóból a felülírt, kizárt, rejtett és zárolt értékelésekkel együtt. Csak a tevékenységekhez kapcsolódó értékelési tételek és értékelés őrződnek meg.';
$string['removeallcourseitems'] = 'Összes elem és kategória törlése';
$string['removeallcourseitems_help'] = 'Bejelölése esetén minden kézzel hozzáadott kategória és értékelési tétel törlődik az értékelésnaplóból a felülírt, kizárt, rejtett és zárolt értékelésekkel együtt. Csak a tevékenységekhez kapcsolódó értékelési tételek őrződnek meg.';
$string['report'] = 'Jelentés';
$string['reportdefault'] = 'Jelentés alapbeállítása ({$a})';
$string['reportplugins'] = 'Jelentés segédprogramjai';
$string['reportsettings'] = 'Jelentés beállításai';
$string['reprintheaders'] = 'Fejlécek újranyomtatása';
$string['resetweights'] = '{$a->itemname} súlyainak visszaállítása';
$string['resetweightsshort'] = 'Súlyok visszaállítása';
$string['respectingcurrentdata'] = 'a jelenlegi beállítás változatlanul hagyása';
$string['rowpreviewnum'] = 'Sorok előnézete';
$string['rowpreviewnum_help'] = 'Az importálás megerősítése előtt megtekintheti az importálandó adatokat. Ez a beállítás szabja meg, hány sor jelenjen meg az előnézetben.';
$string['savechanges'] = 'Módosítások mentése';
$string['savepreferences'] = 'Beállítások mentése';
$string['scaleconfirmdelete'] = 'Biztosan törli "{$a}" skáláját?';
$string['scaledpct'] = 'Léptékes %';
$string['seeallcoursegrades'] = 'Kurzus összes értékelésének mutatása';
$string['select'] = '{$a} kiválasztása';
$string['selectalloroneuser'] = 'Az összes vagy egy felhasználó kiválasztása';
$string['selectauser'] = 'Válasszon ki egy felhasználót';
$string['selectdestination'] = '{$a} célállomásának kiválasztása';
$string['separator'] = 'Elválasztó';
$string['separator_help'] = 'Válassza ki a CSV-állományban használandó elválasztót (ez általában a vessző).';
$string['sepcolon'] = 'Kettőspont';
$string['sepcomma'] = 'Vessző';
$string['sepsemicolon'] = 'Pontosvessző';
$string['septab'] = 'Tabulátor';
$string['setcategories'] = 'Kategóriák beállítása';
$string['setcategorieserror'] = 'Súlyok hozzáadása előtt kategóriákat kell a kurzusához beállítania.';
$string['setgradeletters'] = 'Értékelési betűk beállítása';
$string['setpreferences'] = 'Preferenciák beállítása';
$string['setting'] = 'Beállítás';
$string['settings'] = 'Beállítások';
$string['setup'] = 'Beállítás';
$string['setweights'] = 'Súlyok beállítása';
$string['showallhidden'] = 'Az összes rejtett megjelenítése';
$string['showallstudents'] = 'Minden tanuló megjelenítése';
$string['showaverage'] = 'Átlag kijelzése';
$string['showaverage_help'] = 'Megjelenjen-e az átlagok oszlopa vagy ne. Ha az átlag kiszámítása csak néhány értékelés alapján történik, a tanulók megbecsülhetik a többiek értékelését. A teljesítmény érdekében az átlag közelítőleges, ha rejtett elemeken alapszik.';
$string['showaverages'] = 'Oszlopátlagok megjelenítése';
$string['showaverages_help'] = 'Oszlopátlagok megjelenítése az értékelőjelentésben.';
$string['showcontributiontocoursetotal'] = 'A kurzus összpontszámához való hozzájárulás kijelzése';
$string['showcontributiontocoursetotal_help'] = 'Megjelenjen-e egy oszlop az értékelési tételeknél egy százalékos értékkel, mutatva, hogy az miként járul hozzá a kurzus értékeléséhez (súlyozás alkalmazása után) vagy ne.';
$string['showfeedback'] = 'Visszajelzés megjelenítése';
$string['showfeedback_help'] = 'Megjelenjen-e a visszajelzések oszlopa?';
$string['showgrade'] = 'Értékelések mutatása';
$string['showgrade_help'] = 'Megjelenjen-e az osztályzatok oszlopa?';
$string['showgroups'] = 'Csoportok megjelenítése';
$string['showhiddenitems'] = 'Rejtett tételek megjelenítése';
$string['showhiddenitems_help'] = 'Teljesen rejtve legyenek-e a rejtett értékelési tételek, vagy nevük megjelenjen-e a tanulók számára.

* Rejtettek megjelenítése - A rejtett értékelési tételek neve látható, de a tanulói értékelések nem
* Rejtve csak eddig - Az értékelési tételek a "rejtve eddig" alatt beállított időpontig nem láthatók, utána a teljes tétel látszik
* Nem látszik - A rejtett értékelési tételek egyáltalán nem láthatók';
$string['showhiddenuntilonly'] = 'Rejtve csak eddig';
$string['showingaggregatesonly'] = 'Csak az összegzések kijelzése';
$string['showingfullmode'] = 'Értékelések és összegzések megjelenítése';
$string['showinggradesonly'] = 'Csak az értékelések megjelenítése';
$string['showlettergrade'] = 'Értékelési betűk megjelenítése';
$string['showlettergrade_help'] = 'Megjelenjen-e a betűvel kifejezett értékelések oszlopa vagy ne.';
$string['shownohidden'] = 'Nem látszik';
$string['shownooutcomes'] = 'Eredmények elrejtése';
$string['shownumberofgrades'] = 'Értékelések számának feltüntetése az átlagokban';
$string['shownumberofgrades_help'] = 'Bekapcsolása esetén az átlag számításához használt értékelések száma megjelenik az egyes átlagok mellett zárójelben.';
$string['showonlyactiveenrol'] = 'Csak a beiratkozottak megjelenítése';
$string['showonlyactiveenrol_help'] = 'Ez határozza meg, hogy az értékelésnaplóban csak a beiratkozottak jelenjenek meg. Bekapcsolása esetén a felfüggesztett felhasználók nem jelennek meg az értékelésnaplóban.';
$string['showpercentage'] = 'Százalék megjelenítése';
$string['showpercentage_help'] = 'Megjelenjen-e az egyes értékelési tételek százalékos értéke vagy ne.';
$string['showrange'] = 'Tartományok kijelzése';
$string['showrange_help'] = 'Megjelenjen-e tartomány oszlopa?';
$string['showranges'] = 'Tartományok megjelenítése';
$string['showranges_help'] = 'Az értékelőjelentésben megjelenít egy sort az egyes értékelési tételek lehetséges tartományával.';
$string['showrank'] = 'Besorolás mutatása';
$string['showrank_help'] = 'Megjelenjen-e a tanuló helyzete az osztályhoz viszonyítva az egyes értékelési tételek esetén vagy ne.';
$string['showuserimage'] = 'Felhasználói profilképek megjelenítése';
$string['showuserimage_help'] = 'A értékelőjelentésben megjelenjen-e a felhasználó neve mellett a profilképe vagy ne.';
$string['showverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} megjelenítése';
$string['showweight'] = 'Súlyozások kijelzése';
$string['showweight_help'] = 'Megjelenjen-e az értékelési súlyok oszlopa vagy ne.';
$string['simpleview'] = 'Egyszeres nézet';
$string['sitewide'] = 'Egész portálra kiterjedő';
$string['sort'] = 'rendez';
$string['sortasc'] = 'Rendezés növekvő sorrendben';
$string['sortbyfirstname'] = 'Keresztnév szerinti rendezés';
$string['sortbylastname'] = 'Vezetéknév szerinti rendezés';
$string['sortdesc'] = 'Rendezés csökkenő sorrendben';
$string['standarddeviation'] = 'Szórás';
$string['stats'] = 'Statisztika';
$string['statslink'] = 'Statisztikák';
$string['student'] = 'Tanuló';
$string['studentsperpagereduced'] = 'Oldalankénti tanulószám csökkentése {$a->originalstudentsperpage} -- {$a->studentsperpage}. Esetleg növelje a PHP max_input_vars beállítását erről:{$a->maxinputvars}.';
$string['subcategory'] = 'Szokásos kategória';
$string['submissions'] = 'Leadott munkák';
$string['submittedon'] = 'Leadva:';
$string['sumofgradesupgradedgrades'] = 'Megjegyzés: a portál frissítése során az "Értékelések összege" összesítési módszer "Természetes"-re változott, ezért ajánlatos átvizsgálnia a értékelésnapló adatait.';
$string['switchtofullview'] = 'Váltás teljes nézetre';
$string['switchtosimpleview'] = 'Váltás egyszerű nézetre';
$string['topcategory'] = 'Felettes kategória';
$string['total'] = 'Összesen';
$string['totalweight100'] = 'Az összsúly 100-zal egyenlő';
$string['totalweightnot100'] = 'Az összsúly nem egyenlő 100-zal';
$string['turnfeedbackoff'] = 'Visszajelzés kikapcsolása';
$string['turnfeedbackon'] = 'Visszajelzés bekapcsolása';
$string['typenone'] = 'Nincs';
$string['typescale'] = 'Skála';
$string['typescale_help'] = '<p>Skálázó pontozás használata esetén kiválaszthat egy skálát. Tevékenységalapú értékelési tételhez a skála a tevékenységet frissítő oldalról választható ki.</p>';
$string['typetext'] = 'Szöveg';
$string['typevalue'] = 'Érték';
$string['uncategorised'] = 'Nincs kategorizálva';
$string['unchangedgrade'] = 'Az értékelés nem módosult';
$string['unenrolledusersinimport'] = 'Az importálás az alábbi értékeléseket tartalmazta a kurzusba jelenleg be nem iratkozott felhasználók esetén: {$a}';
$string['unlimitedgrades'] = 'Korlátlan értékelések';
$string['unlimitedgrades_help'] = 'Alapesetben az értékelések az értékelési tétel legjobb és legrosszabb értéke határolja be. Ezzel a beállítással megszünteti a korlátot és 100% fölötti értékelések rögzíthetők közvetlenül az értékelésnaplóban.';
$string['unlock'] = 'Zár feloldása';
$string['unlockverbose'] = '{$a->category} {$a->itemmodule} {$a->itemname} feloldása';
$string['unused'] = 'Nem használatos';
$string['updatedgradesonly'] = 'Csak új vagy frissített értékelések exportálása';
$string['upgradedgradeshidemessage'] = 'Figyelmeztetés kihagyása';
$string['upgradedminmaxrevertmessage'] = 'Változások visszaállítása';
$string['uploadgrades'] = 'Értékelések feltöltése';
$string['useadvanced'] = 'Részletes funkciók használata';
$string['usedcourses'] = 'Használatban lévő kurzusok';
$string['usedgradeitem'] = 'Használatban lévő értékelési tétel';
$string['usenooutcome'] = 'Nem használ eredményt';
$string['usenoscale'] = 'Nem használ skálát';
$string['usepercent'] = 'Százalék használata';
$string['user'] = 'Felhasználó';
$string['userenrolmentsuspended'] = 'A beiratkozás szünetel.';
$string['userfields_show'] = 'Felhasználói mezők megjelenítése';
$string['userfields_show_help'] = 'További felhasználói mezők - pl. e-mail cím - megjelenítése az értékelőjelentésben. A konkrét megjelenített mezőket a "showuseridentity" portálbeállítás vezérli.';
$string['usergrade'] = '{$a->fullname} ({$a->useridnumber}) felhasználó {$a->gradeidnumber} tétel esetén';
$string['userid'] = 'Felhasználói azonosító';
$string['useridnumberwarning'] = 'Az azonosítószám nélküli felhasználók az exportálásból kimaradnak, mivel nem importálhatók.';
$string['usermappingerror'] = 'Felhasználó-azonosítási hiba. Nincs "{$a->value}" értékkel rendelkező {$a->field} felhasználó.';
$string['usermappingerrorcurrentgroup'] = 'A felhasználó nem az adott csoport tagja.';
$string['usermappingerrormultipleusersfound'] = 'Felhasználóillesztési hiba: Több felhasználó létezik {$a->field} és "{$a->value}" értékkel. Használjon egyedi illesztési mezőt.';
$string['usermappingerrorusernotfound'] = 'Felhasználó-azonosítási hiba. Nincs ilyen felhasználó.';
$string['userpreferences'] = 'Felhasználói beállítások';
$string['useweighted'] = 'Súlyozás használata';
$string['verbosescales'] = 'Szöveges skálák';
$string['verbosescales_help'] = 'A leíró skálában számok helyett szavak szerepelnek. Ha \'Igen\'-t állít be, a számok mellett a leírásokat is importálni fogja, \'Nem\' esetén csak a számokat.';
$string['viewbygroup'] = 'Csoport';
$string['viewgrades'] = 'Értékelések megtekintése';
$string['weight'] = 'Súly';
$string['weight_help'] = 'Kategóriában vagy kurzusban több értékelési tétel viszonylagos értékének meghatározására való érték.';
$string['weightcourse'] = 'Súlyozott értékelések használata a kurzushoz';
$string['weightedascending'] = 'Növekvő súlyozott százalék szerinti rendezés';
$string['weighteddescending'] = 'Csökkenő súlyozott százalék szerinti rendezés';
$string['weightedpct'] = 'súlyozott %';
$string['weightedpctcontribution'] = 'súlyozott %-os hozzájárulás';
$string['weightofa'] = '{$a} súlya';
$string['weightorextracredit'] = 'Súly vagy pluszpont';
$string['weightoverride'] = 'súlybeállítás';
$string['weightoverride_help'] = 'Ha nem jelöli be, a súly visszaáll az automatikusan számított értékre. Ellenkező esetben elmarad a súly automatikus beállítása.';
$string['weights'] = 'Súlyok';
$string['weightsadjusted'] = 'Súlyait összesen 100-ra állítottuk.';
$string['weightsedit'] = 'Súlyok és pluszpontok szerkesztése';
$string['weightuc'] = 'Számított súly';
$string['writinggradebookinfo'] = 'Értékelésnapló beállításainak írása';
$string['xml'] = 'XML';
$string['yes'] = 'Igen';
$string['yourgrade'] = 'Értékelése';
