<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'hu', version '5.1'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Lépések';
$string['activate'] = 'Hozzáférés engedélyezése';
$string['activatesuccess'] = 'A(z) \'{$a}\' kitűző elérése engedélyezve.';
$string['addalignment'] = 'Külső jártasság vagy szabvány hozzáadása';
$string['addbadge'] = 'Kitűzők hozzáadása';
$string['addbadge_help'] = 'Válassza ki a kitűző-követelményhez hozzáadandó összes kitűzőt. Több elem kiválasztásához tartsa lenyomva a Ctrl billentyűt.';
$string['addbadgecriteria'] = 'Kitűző feltételek hozzáadása';
$string['addcohort'] = 'Globális csoport hozzáadása';
$string['addcohort_help'] = 'Válassza ki a kitűző-követelményhez hozzáadandó összes globális csoportot. Több elem kiválasztásához tartsa lenyomva a CTRL billentyűt.';
$string['addcompetency'] = 'Készség hozzáadása';
$string['addcompetency_help'] = 'Válassza ki a kitűző követelményéhez hozzáadandó összes készséget. Több elem kiválasztásához tartsa lenyomva a CTRL-billentyűt.';
$string['addcourse'] = 'Kurzusok hozzáadása';
$string['addcourse_help'] = 'Válassza ki azokat a kitűző kritériiumához hozzáadandó kurzusokat. Több kurzus kiválasztásához tartsa lenyomva a CTRL-billentyűt!';
$string['addcriteria'] = 'Feltételek hozzáadása';
$string['addcriteriatext'] = 'Feltételek hozzáadásához válasszon egy lehetőséget a lenyíló menüből.';
$string['addcriterion'] = 'Feltétel hozzáadása';
$string['addedtobackpack'] = 'Kitűző hozzáadása a hátizsákhoz';
$string['addrelated'] = 'Kapcsolódó kitűző hozzáadása';
$string['addtobackpack'] = 'Hozzáadás a hátizsákhoz';
$string['adminonly'] = 'Az oldalt csak rendszergazdák érhetik el';
$string['after'] = 'a kibocsátás dátuma után.';
$string['aggregationmethod'] = 'Összegzési mód';
$string['alignment'] = 'Igazítás';
$string['all'] = 'Mind';
$string['allmethod'] = 'Az összes kiválasztott feltétel teljesült';
$string['allmethodactivity'] = 'Minden kiválasztott tevékenység végrehajtva';
$string['allmethodbadges'] = 'Minden kiválasztott kitűzőt kiérdemelték';
$string['allmethodcohort'] = 'Tagság az összes kiválasztott globális csoportban.';
$string['allmethodcompetencies'] = 'Minden kiválasztott készség teljesült';
$string['allmethodcourseset'] = 'Minden kiválasztott kurzus teljesítve';
$string['allmethodmanual'] = 'Minden kiválasztott szerep adományoz kitűzőt';
$string['allmethodprofile'] = 'Minden kiválasztott profilmező teljesült';
$string['allowcoursebadges'] = 'Kurzuskitűzők engedélyezése';
$string['allowcoursebadges_desc'] = 'Kurzuskitűzők létrehozásának és odaítélésének engedélyezése.';
$string['allowexternalbackpack'] = 'Külső hátizsákhoz csatlakozás';
$string['allowexternalbackpack_desc'] = 'Engedélyezi, hogy a felhasználók külső hátizsákhoz kapcsolódjanak és erről a portálról megosszák kitűzőiket. Továbbá megjeleníthetik itt a profiloldalukon lévő külső hátizsákjuk nyilvános gyűjteményeit. Hagyja kikapcsolva ezt a lehetőséget, ha a weboldal internetről közvetlenül nem érhető el.';
$string['any'] = 'Bármelyik';
$string['anymethod'] = 'Bármely kiválasztott feltétel teljesült';
$string['anymethodactivity'] = 'A kiválasztott tevékenységek közül valamelyik végrehajtva';
$string['anymethodbadges'] = 'Bármelyik kiválasztott kitűzőt kiérdemelték';
$string['anymethodcohort'] = 'Tagság bármelyik kiválasztott globális csoportban.';
$string['anymethodcompetencies'] = 'A  kiválasztott készségek bármelyike teljesült';
$string['anymethodcourseset'] = 'A kiválasztott kurzusok közül valamelyik teljesítve';
$string['anymethodmanual'] = 'A kiválasztott szerepek bármelyike adományozza a kitűzőt';
$string['anymethodprofile'] = 'Bármely kiválasztott profilmező teljesült';
$string['apiversion'] = 'API-verzió támogatva';
$string['archivebadge'] = 'Törli a(z)  \'{$a}\' kitűzőt és megtartja a már kiadott kitűzőket?';
$string['archiveconfirm'] = 'Törli és megtartja a már kiadott kitűzőket?';
$string['archivehelp'] = 'Itt a kitűzőt "elavult" jelzéssel látja el és eltünteti a kitűzők felsorolásából. A tanulók ezt a kitűzőt már nem szerezhetik meg, de akik már megkapták, profiloldalukon megjeleníthetik és külső hátizsákjukra tűzhetik.
Ha a jövőben is hozzáférhetővé kívánja tenni a megszerzett kitűzőket, teljes törlés helyett válassza ezt a pontot.';
$string['attachment'] = 'Kitűző csatolása az üzenethez';
$string['attachment_help'] = 'Bejelölése esetén a kapott kitűző letöltéshez a címzett e-mailjéhez lesz mellékelve. (Használatához a Portálkezelés > Szerver > E-mail / Kimenő levelek beállítása alatt a csatolmányokat engedélyezni kell.)';
$string['award'] = 'Kitűző adományozása';
$string['awardedto'] = 'Kapta: {$a}';
$string['awardedtoyou'] = 'Kibocsátás dátuma';
$string['awardoncron'] = 'Sok felhasználónak adományozzuk a(z) \'{$a->badgename}\' kitűzőt. Egy darabig eltarthat, mire mindenki megkapja.';
$string['awards'] = 'Átvevők';
$string['backpackapiurl'] = 'Hátizsák-API webcíme';
$string['backpackavailability'] = 'Külső kitűző ellenőrzése';
$string['backpackavailability_help'] = 'Ahhoz, hogy a kitűzőt kapók bizonyíthassák, hogy a kitűzőt Öntől kapták, külső hátizsák-szolgáltatásnak kell elérnie az Ön portálját és egybevetnie az általa kiadott kitűzőkkel. Az Ön portálja jelenleg nem elérhető, így a már kiadott vagy később kiadandó kitűzők sem ellenőrizhetők.


**Miért jelent meg ez az üzenet?**

Előfordulhat, hogy tűzfal akadályozza meg külső felhasználók belépését, vagy portálját jelszó védi, esetleg portálját az internetről nem elérhető számítógépről működteti (pl. helyi fejlesztésre használt gépről).

**Ez gondot jelent?**
Éles portálon a gondot meg kell oldania, ha kitűzőket kíván adományozni, ellenkező esetben az átvevők nem fogják tudni bizonyítani, hogy kitűzőjüket Öntől kapták. Ha portálja még nem éles, kipróbálás céljából létrehozhat és adományozhat próbakitűzőket.

**Mi történik, ha a teljes portált nem tehetem nyilvánosan elérhetővé?**

Az ellenőrzéshez csak a  [portálom-webcíme]/badges/assertion.php webcímre van szükség, így ha tűzfalán ezen fájl elérését engedélyezni tudja, a kitűzők ellenőrzése végrehajtható.';
$string['backpackbadgessettings'] = 'Hátizsák beállításainak módosítása';
$string['backpackbadgessummary'] = 'Összesen  {$a->totalbadges} kitűző jelenik meg a(z) {$a->totalcollections} gyűjteményből.';
$string['backpackcannotsendverification'] = 'Nem küldhető igazoló e-mail';
$string['backpackconnected'] = 'A hátizsák összekapcsolva';
$string['backpackconnection'] = 'Csatlakozás egy hátizsákhoz';
$string['backpackconnection_connected'] = 'Az ön hátizsákja';
$string['backpackconnection_help'] = 'Tárolja el és ossza meg kitűzőit erről a portálról, és jelenítse meg más weboldalakról származó nyilvános kitűzőit a profiljánál.';
$string['backpackconnectioncancelattempt'] = 'Kapcsolódás másik e-mail címmel';
$string['backpackconnectionconnect'] = 'Kapcsolódás a Hátizsákhoz';
$string['backpackconnectionnottested'] = 'A hátizsák esetén a csatlakozás nem ellenőrizhető, mert az csak Open Badges 2.0 verziójú hátizsákok esetén működik.';
$string['backpackconnectionok'] = 'Hátizsák sikeresen csatlakoztatva';
$string['backpackconnectionresendemail'] = 'Ellenőrző e-mail újraküldése';
$string['backpackconnectionunexpectedmessage'] = 'A hátizsák ezt a hibaüzenetet adta vissza: "{$a}".';
$string['backpackconnectionunexpectedresult'] = 'Hiba történt a hátizsák csatlakoztatásakor. A hátizsák-szolgáltatója az alábbi üzenetet küldi: \'{$a}\'.';
$string['backpackdetails'] = 'Kitűző beállításai';
$string['backpackdisconnected'] = 'A hátizsák szétkapcsolva';
$string['backpackemail_required'] = 'email cím nem lehet üres';
$string['backpackemailverificationpending'] = 'Ellenőrzés folyamatban';
$string['backpackemailverifyemailbody'] = 'Kedves {$a->userfirstname}!<br>
<br>
Már majdnem kész a kitűzős hátizsákjának csatlakoztatása a(z) \'{$a->sitename}\' portálon!<br>
<br>
A csatlakozás megerősítéséhez erősítse meg e-mail címét az alábbi gombbal:<br>
<br>
{$a->buttonlink}<br>
<br>
Ha a gomb ez nem működik, másolja az alábbi hivatkozást böngészője címsorába:<br>
{$a->link}<br>
<br>
Ha nem ön próbálta meg csatlakoztatni a kitűzős hátizsákját, hagyja figyelmen kívül ezt az e-mailt<br>
<br>
Ha segítségre van szüksége, forduljon a portáltámogatáshoz:<br>
<br>
{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: Hátizsák e-mailen keresztüli ellenőrzése';
$string['backpackemailverifypending'] = 'Egy e-mailt küldtünk <strong>{$a}</strong> címre. A hátizsákjához való csatlakozáshoz kattintson a levélben lévő megerősítő hivatkozásra.';
$string['backpackemailverifysuccess'] = 'Mostantól csatlakozott a hátizsákjához.';
$string['backpackemailverifytokenmismatch'] = 'Az adott hivatkozásban szereplő token nem egyezik a rendszerben tárolttal. Ellenőrizze, hogy a legutóbb kapott e-mailben szereplő hivatkozásra kattintott-e.';
$string['backpackexporterror'] = 'A kitűzőt nem lehet a hátizsákhoz exportálni';
$string['backpackexporterrorwithinfo'] = 'Nem lehet exportálni a(z)  "{$a->badgename}" kitűzőt. Hiba: {$a->error}';
$string['backpackimport'] = 'Kitűzőimportálás beállításai';
$string['backpackimport_help'] = 'Ha sikerült csatlakozni a hátizsákhoz, a hátizsákján lévő kitűzőket megjelenítheti a "Kitűzőim" oldalon és a profiloldalán.

Ezen a területen kiválaszthatja, mely hátizsákjáról mely kitűzőgyűjtemények jelenjenek meg a profiloldalán.';
$string['backpackprovider'] = 'Hátizsák-szolgáltató';
$string['backpacksettings'] = 'Hátizsák beállításai';
$string['backpackweburl'] = 'Hátizsák webcíme';
$string['badgedetails'] = 'Részletek';
$string['badgeimage'] = 'A kitűző képe';
$string['badgeimage_help'] = 'A kép minimális mérete 300 x 300 képpont. A kitűző oldalán 300 x 300-as, a felhasználói profiloldalon 100 x 100-as méretben jelenik meg.';
$string['badgeimageinfo'] = 'A legjobb eredményhez négyzet alakú képet töltsön fel, legalább 300 x 300 pixel méretben.';
$string['badgeissued'] = 'Kitűző kiadva';
$string['badgeprivacysetting'] = 'Kitűző adatvédelmi beállításai';
$string['badgeprivacysetting_help'] = 'A megszerzett kitűzőket megjelenítheti profiloldalán. Ez a beállítás lehetővé teszi az újonnan szerzett kitűzők automatikus megjelenítését.

A "Kitűzőim" oldalon továbbra is módosíthatja az egyes kitűzők adatvédelmi beállításait.';
$string['badgeprivacysetting_str'] = 'Kitűzők automatikus megjelenítése a profiloldalamon';
$string['badges'] = 'Kitűzők';
$string['badgesalt'] = 'Védőérték az átvevő e-mail-címének a kivonatolásához';
$string['badgesalt_desc'] = 'Kivonattal a hátizsák-szolgáltatás anélkül ellenőrizni tudja a kitűzőt kapó kilétét, hogy megjelenítené e-mail-címét. A beállításban csak számok és betűk szerepelhetnek.

Megjegyzés: a kitűzőt kapók ellenőrzéséhez ne módosítsa ezt a beállítást, ha elkezdi adományozni a kitűzőket.';
$string['badgesdisabled'] = 'A kitűzők használata nincs engedélyezve ezen a portálon.';
$string['badgesearned'] = 'A szerzett kitűzők száma: {$a}';
$string['badgesettings'] = 'Kitűző beállításai';
$string['badgestatus_0'] = 'Nem elérhető';
$string['badgestatus_1'] = 'Elérhető';
$string['badgestatus_2'] = 'Nem elérhető (feltételekhez kötve)';
$string['badgestatus_3'] = 'Elérhető (feltételekhez kötve)';
$string['badgestatus_4'] = 'Archivált';
$string['badgestoearn'] = 'Elérhető kitűzők száma: {$a}';
$string['badgesview'] = 'Kurzuskitűzők';
$string['badgetags'] = 'Kitűző címkék';
$string['badgeurl'] = 'Kapcsolat a kiadott kitűzőkhöz';
$string['balignment'] = '({$a}) igazítás';
$string['bawards'] = 'Átvevők ({$a})';
$string['bcriteria'] = 'Feltételek';
$string['bdetails'] = 'Részletek szerkesztése';
$string['bendorsement'] = 'Jóváhagyás';
$string['bmessage'] = 'Üzenet';
$string['boverview'] = 'Áttekintés';
$string['brelated'] = '({$a}) kapcsolódó kitűzők';
$string['bydate'] = 'Teljesítette';
$string['claim'] = 'Igény';
$string['claimcomment'] = 'Megjegyzés a támogató megerősítéshez';
$string['claimid'] = 'Igény webcíme';
$string['clearsettings'] = 'Beállítások törlése';
$string['completioninfo'] = 'Kitűző adományozásának alapja';
$string['completionnotenabled'] = 'A kurzusteljesítés a kurzushoz nincs bekapcsolva, így nem szerepelhet a kitűző feltételei között. A kurzusteljesítést a kurzusbeállításoknál kapcsolhatja be.';
$string['configenablebadges'] = 'Bekapcsolása esetén kitűzőket hozhat létre és adhat át a portál felhasználóinak.';
$string['configuremessage'] = 'Kitűzőhöz kapcsolódó üzenet';
$string['connect'] = 'Kapcsolódás';
$string['connected'] = 'Kapcsolódva';
$string['connecting'] = 'Csatlakozás...';
$string['contact'] = 'E-mail';
$string['contact_help'] = 'A kitűző kibocsátójának e-mail címe.';
$string['copy'] = 'Másolás';
$string['copyof'] = '{$a} másolata';
$string['course'] = 'Kurzus: {$a}';
$string['coursebadges'] = 'Kitűzők';
$string['coursebadgesdisabled'] = 'A kurzusszintű kitűzők nincsenek engedélyezve ezen a portálon.';
$string['coursebadgetitle'] = '{$a} kurzuskitűző';
$string['coursecompletion'] = 'A tanulóknak teljesíteni kell ezt a kurzust';
$string['create'] = 'Új kitűző';
$string['createbutton'] = 'Kitűző létrehozása';
$string['creatorbody'] = '<p>{$a->user} teljesítette a kitűzőhöz előírt összes feltételt, így kitűzőt kapott. A kitűző megtekintése:  {$a->link} </p>';
$string['creatorsubject'] = '\'{$a}\'-t kapott!';
$string['criteria_0'] = 'Ez a kitűző odaítélhető, ha...';
$string['criteria_1'] = 'Tevékenység végrehajtása';
$string['criteria_1_help'] = 'Lehetővé teszi, hogy a kitűzőt a kurzuson belül meghatározott tevékenységek teljesítése alapján kapják meg a felhasználók.';
$string['criteria_2'] = 'Kitűző kézi adományozása szerep alapján';
$string['criteria_2_help'] = 'Lehetővé teszi, hogy a kitűzőt kézzel ítélhessék oda a kurzusban vagy a portálon bizonyos szerepkörrel rendelkező személyek.';
$string['criteria_3'] = 'Közösségi részvétel';
$string['criteria_3_help'] = 'Közösségi';
$string['criteria_4'] = 'Kurzus teljesítése alapján';
$string['criteria_4_help'] = 'A kurzust teljesítők számára kitűző adományozását teszi lehetővé. A feltételhez egyéb paraméterek írhatók elő, pl. minimális értékelés, a kurzus teljesítésének időpontja.';
$string['criteria_5'] = 'Több kurzus teljesítése';
$string['criteria_5_help'] = 'Több kurzust teljesítők számára kitűző adományozását teszi lehetővé. Az egyes kurzusokhoz egyéb paraméterek írhatók elő, pl. minimális értékelés, a kurzus teljesítésének időpontja.';
$string['criteria_6'] = 'Profilalapú teljesítés';
$string['criteria_6_help'] = 'Profiljukban bizonyos mezőket teljesítők számára kitűző adományozását teszi lehetővé. Választhat alapmezők és egyedi profilmezők közül.';
$string['criteria_7'] = 'Odaítélt kitűzők';
$string['criteria_7_help'] = 'Lehetővé teszi egy kitűző más kiérdemelt kitűzők alapján való odaítélését';
$string['criteria_8'] = 'Tagság globális csoportban';
$string['criteria_8_help'] = 'Lehetővé teszi kitűző adományozását, ha a felhasználó valamely globális csoport(ok) tagja lesz.';
$string['criteria_9'] = 'Készségek';
$string['criteria_9_help'] = 'Kitűző kiadásának engedélyezése a megszerzett készségek alapján.';
$string['criteria_descr'] = 'A tanulók megkapják ezt a kitűzőt, ha teljesítik az alábbi követelményt:';
$string['criteria_descr_0'] = 'A felsorolt követelmények közül teljesíts ez(eke)t: <strong>{$a}</strong> :';
$string['criteria_descr_1'] = 'Az alábbi tevékenységek közül <strong>{$a}</strong>-t sikerült teljesíteni:';
$string['criteria_descr_2'] = 'Ezt a kitűzőt az alábbi szerepek közül <strong>{$a}</strong> szereppel rendelkezők adhatják.';
$string['criteria_descr_4'] = 'A felhasználóknak teljesíteni kell a kurzust.';
$string['criteria_descr_5'] = 'Az alábbi kurzusok közül <strong>{$a}</strong> teljesítendő.';
$string['criteria_descr_6'] = 'Az alábbi profilmezők közül <strong>{$a}</strong> teljesítendő.';
$string['criteria_descr_7'] = 'Az alábbiak közül <strong>{$a}</strong> kitűzőt kell kiérdemelni:';
$string['criteria_descr_8'] = 'Tagság előírása az alábbi globális csoportok közül <strong>{$a}</strong> esetén.';
$string['criteria_descr_9'] = 'Az alábbi készségek közül <strong>{$a}</strong> teljesült:';
$string['criteria_descr_bydate'] = '<em>{$a}</em> időpontig';
$string['criteria_descr_grade'] = '<em>{$a}</em> minimális értékeléssel';
$string['criteria_descr_short0'] = 'közül <strong>{$a}</strong> teljesítendő.';
$string['criteria_descr_short1'] = 'közül <strong>{$a}</strong> teljesítendő.';
$string['criteria_descr_short2'] = '<strong>{$a}</strong> adta.';
$string['criteria_descr_short4'] = 'Teljesítse a kurzust';
$string['criteria_descr_short5'] = 'közül <strong>{$a}</strong> teljesítendő.';
$string['criteria_descr_short6'] = 'közül <strong>{$a}</strong> teljesítendő.';
$string['criteria_descr_short7'] = 'Kész <strong>{$a}</strong> ebből:';
$string['criteria_descr_short8'] = 'Tagság a globális csoportok közül <strong>{$a}</strong> esetén:';
$string['criteria_descr_short9'] = 'Ebből <strong>{$a}</strong> teljesült:';
$string['criteria_descr_single_1'] = 'Az alábbi tevékenységet teljesíteni kell:';
$string['criteria_descr_single_2'] = 'Ezt a kitűzőt az alábbi szereppel rendelkező adhatja:';
$string['criteria_descr_single_4'] = 'A felhasználóknak teljesíteni kell a kurzust.';
$string['criteria_descr_single_5'] = 'Az alábbi kurzust teljesíteni kell:';
$string['criteria_descr_single_6'] = 'Az alábbi profilmezőt teljesíteni kell:';
$string['criteria_descr_single_7'] = 'Az alábbi kitűzőt kell kiérdemelni:';
$string['criteria_descr_single_8'] = 'Tagság előírása az alábbi globális csoport esetén:';
$string['criteria_descr_single_9'] = 'Az alábbi készségek közül teljesültek:';
$string['criteria_descr_single_short1'] = 'Teljesítve:';
$string['criteria_descr_single_short2'] = 'Adományozta:';
$string['criteria_descr_single_short4'] = 'Teljesítse a kurzust';
$string['criteria_descr_single_short5'] = 'Teljesítve:';
$string['criteria_descr_single_short6'] = 'Teljesítve:';
$string['criteria_descr_single_short7'] = 'Kész:';
$string['criteria_descr_single_short8'] = 'Tagság itt:';
$string['criteria_descr_single_short9'] = 'Teljesült:';
$string['criteriacreated'] = 'A kitűzőhöz kapcsolódó feltételek létrehozása sikerült';
$string['criteriadeleted'] = 'A kitűzőhöz kapcsolódó feltételek törlése sikerült';
$string['criteriasummary'] = 'Feltételek összegzése';
$string['criteriaupdated'] = 'A kitűzőhöz kapcsolódó feltételek frissítése sikerült';
$string['criterror'] = 'Paraméterekkel kapcsolatos gondok';
$string['criterror_help'] = 'A mezőkészletben látszik az összes eredeti kitűzőfeltétel, de ezek már nem elérhetők. Az ilyen paraméterek bejelölését szüntesse meg, hogy a felhasználók a jövőben kitűzőt kaphassanak.';
$string['currentimage'] = 'Aktuális kép';
$string['currentstatus'] = 'Aktuális állapot:';
$string['dateawarded'] = 'Kiadás dátuma';
$string['dateearned'] = 'Dátum: {$a}';
$string['day'] = 'nap';
$string['deactivate'] = 'Hozzáférés kikapcsolása';
$string['deactivatesuccess'] = 'A(z) \'{$a}\' kitűző elérése letiltva.';
$string['defaultissuercontact'] = 'A kitűző adományozójának e-mail-címe';
$string['defaultissuercontact_desc'] = 'A kitűző adományozójához kapcsolódó e-mail-cím.  Open Badges v2.0 hátizsák esetén ez használatos hitelesítésre kitűzők hátizsákhoz való kiadása során.';
$string['defaultissuername'] = 'Kitűző adományozójának neve';
$string['defaultissuername_desc'] = 'A kiadmányozó vagy a hatóság neve';
$string['defaultissuerpassword'] = 'A kitűző adományozójának jelszava';
$string['defaultissuerpassword_help'] = 'A hátizsák portálján fiókra és a kitűző adományozója által a Portáladminisztráció / Kitűzők / Kitűzők beállításai alatt megadottak szerinti e-mail-címre van szükség. A fiókhoz tartozó jelszót itt adja meg.';
$string['delbadge'] = 'Törli a(z) \'{$a}\' kitűzőt az összes kiadott kitűzővel együtt?';
$string['delconfirm'] = 'Törli az összes kiadott kitűzővel együtt?';
$string['delcritconfirm'] = 'Biztosan törli a feltételt?';
$string['deletehelp'] = 'Egy kitűző teljes törlése esetén végérvényesen elvész minden hozzá kapcsolódó információ és feltétel. Akik megszerezték, nem férhetnek hozzá és  profiloldalukon nem jeleníthetik meg.
Megjegyzés: Akik már megszerezték a kitűzőt és kitűzték külső hátizsákjukra, az a hátizsákjukon megmarad. Ugyanakkor a feltételekhez nem férhetnek hozzá és nem hivatkozhatnak vissza erre a weboldalra.';
$string['delexternalbackpack'] = 'Portálhátizsák törlése';
$string['delexternalbackpackconfirm'] = 'Törli a portál \'{$a}\' hátizsákját?';
$string['delparamconfirm'] = 'Biztosan törli a paramétert?';
$string['description'] = 'Leírás';
$string['descriptioninfo'] = 'Mit jelképez ez a kitűző?';
$string['disconnect'] = 'Szétkapcsolás';
$string['donotaward'] = 'Jelenleg a kitűző nem aktív, így nem adományozható. Ha valakinek adni szeretné, állapotát állítsa át aktívra.';
$string['enablebadges'] = 'Kitűzők engedélyezése';
$string['endorsement'] = 'Jóváhagyás';
$string['error:backpackdatainvalid'] = 'A hátizsáktól visszakapott adatok érvénytelenek.';
$string['error:backpackemailnotfound'] = 'A(z)  \'{$a}\' e-mail cím nem kapcsolódik hátizsákhoz. Hozzon létre a fiókhoz egy  <a href="http://backpack.openbadges.org">hátizsákot</a> vagy jelentkezzen be egy másik e-mail címről.';
$string['error:badgeawardnotfound'] = 'Nem ellenőrizhető ez a kitűző. Lehet, hogy visszavonták.';
$string['error:badgenotfound'] = 'Nincs meg a kitűző.';
$string['error:cannotact'] = 'A kitűzőt nem lehet aktiválni.';
$string['error:cannotawardbadge'] = 'A kitűzőt nem lehet felhasználónak adni.';
$string['error:cannotdeletecriterion'] = 'Ez a feltétel nem törölhető.';
$string['error:cannotrevokebadge'] = 'Nem vonható vissza a felhasználó kitűzője.';
$string['error:clone'] = 'A kitűzőt nem lehet másolni.';
$string['error:connectionunknownreason'] = 'A csatlakozási kísérlet sikertelen, de nincs hozzá indok.';
$string['error:duplicatename'] = 'Ilyen névvel már szerepel kitűző a rendszerben.';
$string['error:externalbadgedoesntexist'] = 'Nincs meg a kitűző';
$string['error:guestuseraccess'] = 'Jelenleg vendégként kezeljük. Kitűzőinek megtekintéséhez lépjen be felhasználói fiókjából.';
$string['error:invalidcriteriatype'] = 'Érvénytelen feltételtípus';
$string['error:invalidexpiredate'] = 'A lejárat jövőbeni időpont lehet.';
$string['error:invalidexpireperiod'] = 'A lejárat nem lehet negatív szám vagy 0.';
$string['error:invalidparambadge'] = 'A kitűző nem létezik.';
$string['error:invalidparamcohort'] = 'A globális csoport nem létezik.';
$string['error:noactivities'] = 'A kurzusban nincs teljesítési feltételhez kötött tevékenység';
$string['error:nobadges'] = 'Nincsenek követelményként hozzáadható kurzus- vagy portálkitűzők. Portálkitűzőhöz csak más portálkitűzők adhatók meg követelményként. Kurzuskitűzőhöz más kurzuskitűzők vagy portálkitűzők adhatók meg.';
$string['error:nocohorts'] = 'Nincsenek globális csoportok';
$string['error:nocourses'] = 'A kurzusteljesítés a portál egyetlen kurzusához sincs hozzárendelve. A kurzusteljesítést a kurzusbeállítások között írhatja elő.';
$string['error:nogroupslink'] = '<p>Csak nyilvános gyűjtemények jelennek meg, <a href="{$a}" target="_blank" rel="nofollow">térjen át hátizsákjához</a> és hozzon létre egy pár nyilvános gyűjteményt.</p>';
$string['error:nogroupssummary'] = '<p>Hátizsákjában nincs nyilvános kitűzőgyűjtemény. </p>';
$string['error:nopermissiontoview'] = 'Nem nézheti meg, kik kaptak kitűzőt.';
$string['error:nosuchbadge'] = 'Nincs {$a} azonosítóval rendelkező kitűző.';
$string['error:nosuchcohort'] = 'Vigyázat: a globális csoport már nem elérhető.';
$string['error:nosuchcourse'] = 'Figyelem! A kurzus már nem elérhető.';
$string['error:nosuchfield'] = 'Figyelem! A felhasználói profilmező már nem elérhető.';
$string['error:nosuchmod'] = 'Figyelem! A tevékenység már nem elérhető.';
$string['error:nosuchrole'] = 'Figyelem! A szerep már nem elérhető.';
$string['error:nosuchuser'] = 'Ilyen e-mail címmel nincs felhasználói fiók a hátizsák-szolgáltatónál.';
$string['error:notifycoursedate'] = 'A kurzus- és tevékenységteljesítéshez kötött kitűzők adományozására a kurzus kezdetéig nem kerül sor ({$a}).';
$string['error:parameter'] = 'Figyelem! A helyes kitűzőkiadási folyamathoz legalább egy paramétert ki kell választani.';
$string['error:relatedbadgedoesntexist'] = 'Ilyen azonosítóval nincs nyilvános kitűző';
$string['error:requesterror'] = 'A csatlakozás nem sikerült (hibakód: {$a}).';
$string['error:requesttimeout'] = 'A csatlakozási idő időközben lejárt.';
$string['error:save'] = 'A kitűzőt nem lehet elmenteni.';
$string['error:userdeleted'] = '{$a->user} (A felhasználó a(z) {$a->site} portálon nem létezik)';
$string['eventbadgearchived'] = 'Kitűző archiválva';
$string['eventbadgeawarded'] = 'Kitűző odaítélve';
$string['eventbadgecreated'] = 'Kitűző létrehozva';
$string['eventbadgecriteriacreated'] = 'Kitűző feltételei létrehozva';
$string['eventbadgecriteriadeleted'] = 'Kitűző feltételei törölve';
$string['eventbadgecriteriaupdated'] = 'Kitűző feltételei frissítve';
$string['eventbadgedeleted'] = 'Kitűző törölve';
$string['eventbadgedisabled'] = 'Kitűző kikapcsolva';
$string['eventbadgeduplicated'] = 'Kitűző lemásolva';
$string['eventbadgeenabled'] = 'Kitűző bekapcsolva';
$string['eventbadgelistingviewed'] = 'Kitűzők felsorolása megtekintve';
$string['eventbadgerevoked'] = 'Kitűző visszavonva';
$string['eventbadgeupdated'] = 'Kitűző frissítve';
$string['eventbadgeviewed'] = 'Kitűző megtekintve';
$string['existingrecipients'] = 'Létező kitűzőt átvevők';
$string['existsinbackpack'] = 'A kitűző már benne van a hátizsákban';
$string['expired'] = 'Lejárt';
$string['expiredate'] = 'A kitűző {$a}.időpontban lejár.';
$string['expireddate'] = 'A kitűző {$a}.időpontban lejárt.';
$string['expiredin'] = 'Lejárt: {$a}';
$string['expireperiod'] = 'A kitűző kiadása után {$a}.nappal lejár.';
$string['expireperiodh'] = 'A kitűző kiadása után {$a}.órával lejár.';
$string['expireperiodm'] = 'A kitűző kiadása után {$a}.perccel lejár.';
$string['expireperiods'] = 'A kitűző kiadása után {$a}.másodperccel lejár.';
$string['expiresin'] = 'Lejár: {$a}';
$string['expirydate'] = 'Lejárat időpontja';
$string['expirydate_help'] = 'Választhatóan a kitűzők lejárhatnak egy megadott napon, vagy egy olyan napon, amelyet a felhasználónak adományozás kelte alapján számít ki a rendszer.';
$string['externalbackpack_required'] = 'A hátizsák szolgáltató nem lehet üres';
$string['externalbadges'] = 'Más portálokról származó kitűzőim';
$string['externalbadges_help'] = 'Itt jelennek meg a külső hátizsákon lévő kitűzői';
$string['externalbadgesp'] = 'Más portálokról származó kitűzők';
$string['externalconnectto'] = 'Külső kitűzők megjelenítéséhez kapcsolódnia kell egy <a href="{$a}">hátizsákhoz</a>.';
$string['fixed'] = 'Rögzített időpont: a kitűző az alábbi időpontban elévül:';
$string['hidden'] = 'Rejtett';
$string['hiddenbadge'] = 'A kitűző tulajdonosa ezt az információt nem tette elérhetővé.';
$string['hostedurl'] = 'Külső webcím';
$string['hostedurldescription'] = 'A kitűzőnek helyet adó külső webcím';
$string['imageauthoremail'] = 'Kép szerzőjének e-mailje';
$string['imageauthoremail_help'] = 'Megadása esetén a kitűzőkép szerzőjének az e-mail-címe látszik a kitűző oldalán.';
$string['imageauthorname'] = 'A kép szerzőjének a neve';
$string['imageauthorname_help'] = 'Megadása esetén a kitűzőkép szerzőjének a neve látszik a kitűző oldalán.';
$string['imageauthorurl'] = 'A kép szerzőjének webcíme';
$string['imageauthorurl_help'] = 'Megadása esetén a kitűzőkép szerzőjének a honlapja látszik a kitűző oldalán. A webcímnek http:// vagy https:// előtaggal kell kezdődni.';
$string['imagecaption'] = 'Képfelirat';
$string['imagecaption_help'] = 'Megadása esetén a kép felirata látszik a kitűző oldalán.';
$string['includeauthdetails'] = 'Hitelesítési részletek a hátizsákkal együtt';
$string['invalidurl'] = 'Érvénytelen webcím';
$string['issuancedetails'] = 'A kitűző lejárata';
$string['issuedbadge'] = 'A kiadott kitűző adatai';
$string['issuedby'] = 'Kiadta: {$a}';
$string['issuedon'] = 'Kiadva: {$a}';
$string['issuerdetails'] = 'Az adományozó adatai';
$string['issueremail'] = 'E-mail';
$string['issueremail_help'] = 'A támogató megerősítést kiállító szervezet kapcsolattartási e-mail-címe.';
$string['issuername'] = 'Név';
$string['issuername_endorsement'] = 'A jóváhagyó neve';
$string['issuername_endorsement_help'] = 'A jóváhagyó neve';
$string['issuername_help'] = 'Az adományozó szerv vagy hatóság neve';
$string['issuerurl'] = 'Hivatkozás';
$string['issuerurl_help'] = 'A támogató megerősítést kiállító szervezet honlapja. A webcímnek http:// vagy https:// előtaggal kell kezdődni.';
$string['language'] = 'Nyelv';
$string['language_help'] = 'A kitűző oldalán használt nyelv.';
$string['listbackpacks'] = 'Hátizsáklista';
$string['localbadges'] = '{$a} portálról származó kitűzőim';
$string['localbadgesh'] = 'A portálról származó kitűzőim';
$string['localbadgesh_help'] = 'A portálon kurzusteljesítéssel, kurzustevékenységekkel és más követelményekkel megszerzett összes kitűző.

Itt kezelheti kitűzőit, azaz nyilvánossá teheti vagy profiloldalához kötheti őket..

Kitűzőit letöltheti és gépre mentheti ömlesztve vagy egyesével. A letöltött kitűzőket hozzáadhatja külső hátizsák-szolgáltatásához.';
$string['localbadgesp'] = '{$a}:portálról származó kitűzők';
$string['localconnectto'] = 'A kitűzők portálon kívüli megosztásához kapcsolódnia kell egy <a href="{$a}">hátizsákhoz</a>.';
$string['loginbackpacktitle'] = '<strong>Bejelentkezés a hátizsákhoz</strong>';
$string['makeprivate'] = 'Nem tesz elérhetővé';
$string['makepublic'] = 'Elérhetővé tesz';
$string['managebackpacks'] = 'Hátizsákok kezelése';
$string['managebadges'] = 'Kitűzők kezelése';
$string['message'] = 'Üzenet törzsszövege';
$string['messagebody'] = '<p>Ön "%badgename%" kitűzőt kapott!</p> <p>További információkat olvashat a kitűzőről itt: %badgelink%.</p> <p>A kitűzőt kezelheti és a(z) {$a} weboldalról letöltheti.</p>';
$string['messagesubject'] = 'Gratulálunk! Ön kitűzőt kapott!';
$string['method'] = 'A feltétel akkor teljesül, ha...';
$string['mingrade'] = 'Szükséges minimális értékelés';
$string['month'] = 'hónap';
$string['moredetails'] = 'További részletek';
$string['mybackpack'] = 'Hátizsák-beállításaim';
$string['mybadges'] = 'Kitűzőim';
$string['namewithlink'] = 'Név hivatkozással';
$string['never'] = 'Soha: ez a kitűző nem évül el.';
$string['newbackpack'] = 'Új hátizsák hozzáadása';
$string['newbadge'] = 'Új kitűző hozzáadása';
$string['newbadgedeprecated'] = 'Átiránítás történt a badges/newbadge.php-ról. Kérjük, vegye figyelembe, hogy a badges/newbadge.php a közeljövőben eltávolításra kerül.
<br/>Frissítse a hivatkozásokat és könyvjelzőket, hogy azok a jelenlegi badges/edit.php oldalt használják!';
$string['newimage'] = 'Új kép';
$string['noalignment'] = 'A kitűzőhöz nincs megadva külső jártasság vagy szabvány.';
$string['noawards'] = 'A kitűzőt meg senki nem szerezte meg.';
$string['nobackpack'] = 'A fiókhoz nem kapcsolódik hátizsák-szolgáltatás .<br />';
$string['nobackpackbadgessummary'] = 'A kiválasztott gyűjteményekben nincsenek kitűzők';
$string['nobackpackcollectionssummary'] = 'Nincs kiválasztva kitűzőgyűjtemény';
$string['nobackpacks'] = 'Nincsenek hátizsákok';
$string['nobadges'] = 'Nincs elérhető kitűző.';
$string['nocompetencies'] = 'Nincs kiválasztva készség.';
$string['nocriteria'] = 'A kitűzőhöz még nincsenek előírva feltételek.';
$string['noendorsement'] = 'A kitűzőhöz nincs jóváhagyás';
$string['noexpiry'] = 'A kitűzőhöz nincs megadva lejárati idő.';
$string['nomatchingawards'] = 'Még senki sem kapta meg ezt a kitűzőt.';
$string['nomatchingbadges'] = 'Nincsenek a felhasználók számára elérhető kitűzők.';
$string['noparamstoadd'] = 'A kitűzőhöz nincsenek megadva további paraméterek.';
$string['norelated'] = 'A kitűzőhöz nincsenek kapcsolódó kitűzők.';
$string['notacceptedrole'] = 'Az Önhöz rendelt szereppel nem lehet kézileg kitűzőt adományozni.<br /> A kitűzőt kapott felhasználók megtekintéséhez látogasson el ide: {$a}.';
$string['notconnected'] = 'Nem kapcsolódik.';
$string['notealignment'] = 'Megadhatók a kitűzőhöz kapcsolódó külső jártasságok vagy szabványok. A külső jártasságok vagy szabványok a kitűző oldalán látszanak.';
$string['noteendorsement'] = 'Külső féltől származó támogató megerősítéssel növelhető a kitűző értéke. Például egy tanár által kiadott kitűzőt megerősíthet az iskola, vagy egy helyi szervezet által kiadott kitűzőt megerősíthet egy országos szervezet.';
$string['noterelated'] = 'Kapcsolattal rendelkező kitűzők megjelölhetők kapcsolódóként. Például a különféle nyelveken ugyanannak a feltételnek a teljesítésére utaló kitűzők megjelölhetők kapcsolódóként. A kapcsolódó kitűzők a kitűző oldalán jelennek meg.';
$string['nothingtoadd'] = 'Nincs hozzáadható feltétel.';
$string['notification'] = 'Kitűző létrehozójának értesítése';
$string['notification_help'] = 'A beállítás a kitűző létrehozójának a kitűző kiadásakor küldendő értesítéseket kezeli.

Lehetőségek:

* **SOHA** – Nem küld értesítést.
* **MINDIG** – A kitűző minden egyes adományozásakor értesítést küld.
* **NAPONTA** – Naponta egyszer küld értesítést.
* **HETENTE** – Hetente egyszer küld értesítést.
* **HAVONTA** – Havonta egyszer küld értesítést.';
$string['notifydaily'] = 'Naponta';
$string['notifyevery'] = 'Mindig';
$string['notifymonthly'] = 'Havonta';
$string['notifyweekly'] = 'Hetente';
$string['numawards'] = 'A(z) \'{$a->badgename}\' kitűzőt elnyert felhasználók: <a href="{$a->link}">{$a->count}</a>.';
$string['numawardstat'] = 'A(z) \'{$a->badgename}\' kitűzőt elnyert felhasználók: {$a->awards}.';
$string['oauth2issuer'] = 'OAuth 2 szolgáltatások';
$string['openbadgesv1'] = 'Open Badges v1.0';
$string['openbadgesv2'] = 'Open Badges v2.0';
$string['openbadgesv2p1'] = 'Open Badges v2.1';
$string['othernavigation'] = 'Egyéb böngészés...';
$string['overallcrit'] = 'teljesült a kiválasztott feltételek közül.';
$string['password_required'] = 'A jelszó nem lehet üres';
$string['potentialrecipients'] = 'Lehetséges kitűzőt kapók';
$string['preferences'] = 'Kitűző beállításai';
$string['privacy:metadata:backpack'] = 'Felhasználói hátizsákok rekordja';
$string['privacy:metadata:backpack:backpackuid'] = 'A hátizsák egyedi azonosítója';
$string['privacy:metadata:backpack:email'] = 'A hátizsákhoz kapcsolódó e-mail';
$string['privacy:metadata:backpack:externalbackpackid'] = 'A hátizsák azonosítója';
$string['privacy:metadata:backpack:userid'] = 'A hátizsák tulajdonosának azonosítója';
$string['privacy:metadata:backpackoauth2'] = 'OAuth 2 információ, ha a felhasználó külső hátizsákhoz kapcsolódik';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'OAuth 2 szolgáltatás azonosítója';
$string['privacy:metadata:backpackoauth2:scope'] = 'Hátizsák csatlakozási tartományának listája';
$string['privacy:metadata:backpackoauth2:token'] = 'A hátizsák-csatlakozás token';
$string['privacy:metadata:backpackoauth2:userid'] = 'A hátizsák-csatlakozás felhasználójának azonosítója';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'A módosított csatlakozás felhasználójának azonosítója';
$string['privacy:metadata:badge'] = 'Kitűzők gyűjteménye';
$string['privacy:metadata:badge:timecreated'] = 'A kitűző létrehozásának dátuma';
$string['privacy:metadata:badge:timemodified'] = 'A kitűző utolsó módosításának dátuma';
$string['privacy:metadata:badge:usercreated'] = 'A kitűzőt létrehozó felhasználó azonosítója';
$string['privacy:metadata:badge:usermodified'] = 'A kitűzőt módosító felhasználó azonosítója';
$string['privacy:metadata:criteriamet'] = 'Teljesített feltételek összessége';
$string['privacy:metadata:criteriamet:datemet'] = 'A feltételek teljesítésének dátuma';
$string['privacy:metadata:criteriamet:userid'] = 'Azon felhasználó azonosítója, aki a feltételeket teljesítette';
$string['privacy:metadata:external:backpacks'] = 'A felhasználók külső hátizsákba való kitűzőinek leadásakor megosztott információk';
$string['privacy:metadata:external:backpacks:badge'] = 'A kitűző neve';
$string['privacy:metadata:external:backpacks:description'] = 'A kitűző leírása';
$string['privacy:metadata:external:backpacks:image'] = 'A kitűző képe';
$string['privacy:metadata:external:backpacks:issuer'] = 'Adatok a kiadóra vonatkozóan';
$string['privacy:metadata:external:backpacks:url'] = 'A Moodle azon webcíme, ahol a kiadott kitűző adatai láthatók';
$string['privacy:metadata:issued'] = 'Odaítélt kitűzők rekordja';
$string['privacy:metadata:issued:dateexpire'] = 'A kitűző lejáratának dátuma';
$string['privacy:metadata:issued:dateissued'] = 'Az odaítélés dátuma';
$string['privacy:metadata:issued:userid'] = 'Azon felhasználó azonosítója, aki kitűzőt kapott';
$string['privacy:metadata:manualaward'] = 'Kézi odaítélések rekordja';
$string['privacy:metadata:manualaward:datemet'] = 'A kitűző felhasználónak ítélése dátuma';
$string['privacy:metadata:manualaward:issuerid'] = 'Azon felhasználó azonosítója, aki a kitűzőt adományozta';
$string['privacy:metadata:manualaward:issuerrole'] = 'Azon felhasználó szerepe, aki a kitűzőt adományozta';
$string['privacy:metadata:manualaward:recipientid'] = 'Azon felhasználó azonosítója, akinek a kitűzőt kézi úton ítélték oda';
$string['recipient'] = 'Kitűzőt kap';
$string['recipients'] = 'Kitűzőt kapók';
$string['recipientvalidationproblem'] = 'A felhasználó a kitűzővel megjutalmazott személyként nem igazolható .';
$string['relatedbages'] = 'Kapcsolódó kitűzők';
$string['relative'] = 'Relatív dátum: a kitűző egy adott időszak után elévül:';
$string['requiredbadge'] = 'Legalább egy kitűzőt hozzá kell adni a kitűző-követelményhez.';
$string['requiredcohort'] = 'A globális csoport követelményéhez legalább egy globális csoportot hozzá kell adni.';
$string['requiredcompetency'] = 'A készségfeltételhez legalább egy készséget hozzá kell adni.';
$string['requiredcourse'] = 'A kurzuskészlet feltételéhez legalább egy kurzust hozzá kell adni.';
$string['reviewbadge'] = 'Kitűzőhöz kapcsolódás változásai';
$string['reviewconfirm'] = '<p>Ez megjeleníti kitűzőjét a felhasználók számára, akik elkezdhetnek dolgozni annak megszerzéséért.</p>
<p>Előfordulhat, hogy egyes felhasználók máris teljesítik annak követelményeit, így azonnal meg is kapják.</p>
<p>A megszerzett kitűzőt a rendszer <strong>zárolja</strong>, így egyes beállításait (pl. a feltételeket és a lejáratot) már nem lehet módosítani.</p> <p>Biztosan hozzáférhető teszi a(z) \'{$a}\' kitűzőt?</p>';
$string['revoke'] = 'Kitűző visszavonása';
$string['save'] = 'Mentés';
$string['searchname'] = 'Keresés név szerint';
$string['selectaward'] = 'Válassza ki, melyik szerep adomámyozhatja ezt a kitűzőt:';
$string['selectgroup_end'] = 'Csak a nyilvános gyűjtemények jelennek meg, látogasson el <a href="{$a}">hátizsákjához</a>, ha további nyilvános gyűjteményeket kíván létrehozni.';
$string['selectgroup_start'] = 'Válasszon ki hátizsákjáról gyűjteményeket a portálon való megjelenítéshez:';
$string['selecting'] = 'A kiválasztott kitűzőkkel:';
$string['setup'] = 'Csatlakozás beállítása';
$string['sitebackpackdeleted'] = 'Portálhátizsák törölve';
$string['sitebackpacknotdeleted'] = 'Ezt a hátizsákot nem lehet törölni, mert jelenleg ez a portál alapértelmezett hátizsákja.';
$string['sitebackpackwarning'] = 'Nem sikerült a hátizsákhoz csatlakozni. <br/><br/>Ellenőrizze, hogy a "Kitűző adományozójának e-mail-címe" beállítás érvényes-e a hátizsák portálján lévő fiókhoz. <br/><br/>Ellenőrizze, hogy a "Kitűző adományozójának jelszava" beállítás érvényes-e a <a href="{$a->url}">hátizsák portálján lévő beállításhoz</a>, és megfelelő-e a fiókhoz a jelszó. <br/><br/>A hátizsák üzenete: "{$a->warning}"';
$string['sitebadges'] = 'A portál kitűzői';
$string['sitebadges_help'] = 'A portál kitűzőit csak portálhoz kapcsolódó tevékenységekkel lehet megszerezni. Ilyen pl. kurzusok elvégzése vagy felhasználói profilrészek kitöltése. A portál kitűzőit adományozhatja akár az egyik felhasználó is a másiknak.

Kurzustevékenységekhez kapcsolódó kitűzőket kurzusszinten kell létrehozni. A kurzuskitűzők a Kurzusadminisztráció > Kitűzők menüpontban találhatók.';
$string['sitebadgetitle'] = '{$a} portálkitűző';
$string['status'] = 'A kitűző állapota';
$string['status_help'] = 'A kitűző állapota határozza meg rendszerbeli viselkedését.';
$string['statusmessage_0'] = 'Ez a kitűző jelenleg nem szerezhető meg. A megszerezhetőség bekapcsolásához engedélyezze a hozzáférést.';
$string['statusmessage_1'] = 'Ez a kitűző jelenleg megszerezhető. Módosítások végrehajtásához kapcsolja ki a hozzáférést.';
$string['statusmessage_2'] = 'Ez a kitűző jelenleg nem szerezhető meg, feltételei pedig zárolva vannak. A megszerezhetőség bekapcsolásához engedélyezze a hozzáférést.';
$string['statusmessage_3'] = 'Ez a kitűző jelenleg megszerezhető, feltételei pedig zárolva vannak.';
$string['statusmessage_4'] = 'Ez a kitűző jelenleg irattárban van.';
$string['subject'] = 'Üzenet tárgya';
$string['tagarea_badge'] = 'Kitűzők';
$string['tags'] = 'Címkék';
$string['targetcode'] = 'Kód';
$string['targetcode_help'] = 'Egyedi szövegazonosító a keretében lévő külső jártasságra vagy szabványra hivatkozáshoz.';
$string['targetdescription'] = 'Leírás';
$string['targetdescription_help'] = 'A  külső jártasság vagy szabvány rövid leírása.';
$string['targetframework'] = 'Keret';
$string['targetframework_help'] = 'A  külső jártasság vagy szabvány keretének a neve.';
$string['targetname'] = 'Név';
$string['targetname_help'] = 'A kitűzőhöz tartozó külső jártasság vagy szabvány.';
$string['targeturl'] = 'Webcím';
$string['targeturl_help'] = 'A külső jártasságot vagy szabványt leíró oldalra mutató hivatkozás.  A webcímnek http:// vagy https:// előtaggal kell kezdődni.';
$string['testbackpack'] = '\'{$a}\' hátizsák ellenőrzése';
$string['testsettings'] = 'Ellenőrzés beállításai';
$string['type'] = 'Típus';
$string['userbadges'] = 'Felhasználói kitűzők';
$string['variablesubstitution'] = 'Változó behelyettesítése üzenetekben';
$string['variablesubstitution_help'] = 'A kitűzőhöz tartozó üzenet tárgymezőjébe és/vagy törzsrészébe változókat szúrhat be az alábbiak szerint. Használható változók:

%badgename% : a kitűző teljes neve.

%username% : a címzett teljes neve.


%badgelink% : az adományozott kitűző ismertetése a nyilvános webcímmel együtt.';
$string['verifyemail'] = 'email ellenőrzés';
$string['version'] = 'Változat';
$string['version_help'] = 'A kitűző történetét nyomon követheti a kitűzőváltozatok mezőjében. Megadása esetén változat a kitűző oldalán jelenik meg.';
$string['viewbadge'] = 'Az adományozott kitűző megtekintése';
$string['visible'] = 'Látható';
$string['warnexpired'] = '(A kitűző érvényessége lejárt.)';
$string['year'] = 'Év';
