<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_stash', language 'de', version '5.1'.
 *
 * @package     block_stash
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Akzeptieren';
$string['add'] = 'Hinzufügen';
$string['additem'] = 'Objekt hinzufügen';
$string['addnewdrop'] = 'Neuen Fundort hinzufügen';
$string['addnewtradeitem'] = 'Neues Objekt zu diesem Tausch hinzufügen';
$string['addtoinventory'] = 'Objekt zum Inventar hinzufügen';
$string['addtrade'] = 'Tauschangebot hinzufügen';
$string['addtradeitem'] = 'Tauschobjekt hinzufügen';
$string['advancedreset'] = 'Erweitertes Zurücksetzen';
$string['aftercreatinglocationhelp'] = 'Wenn Sie ein Objekt und den Fundort erstellt haben, müssen Sie einen Code-Schnipsel in Ihren Kurs einfügen, damit das Objekt angezeigt wird. Nachdem Sie festgelegt haben, wie das Objekt den Teilnehmer/innen angezeigt wird, kopieren Sie den folgenden Code-Schnipsel und fügen Sie ihn in Ihren Inhalt ein, z.B. in die Beschreibung einer Aufgabe.';
$string['appearance'] = 'Aussehen';
$string['backtostart'] = 'Zurück zur Startseite';
$string['buttontext'] = 'Button-Text';
$string['completed'] = 'Abgeschlossen';
$string['configdeleted'] = 'Konfiguration gelöscht';
$string['configupdated'] = 'Konfiguration aktualisiert';
$string['configurationtitle'] = 'Stash Titel';
$string['configureremoval'] = 'Entfernen konfigurieren';
$string['copypaste'] = 'Kopieren Sie dies und fügen Sie es in einen Editor in verschiedenen Aktivitäten Ihres Kurses ein.';
$string['copytoclipboard'] = 'In die Zwischenablage kopieren';
$string['cost'] = 'Kosten';
$string['createquizzes'] = 'Erstellen Sie einen Test in diesem Kurs, um eine Stash-Objekt-Entfernung dafür zu konfigurieren.';
$string['createtrade'] = 'Tauschangebot erstellen';
$string['decline'] = 'Ablehnen';
$string['delete'] = 'Löschen';
$string['deletedrop'] = '{$a} löschen';
$string['deleteitem'] = '{$a} löschen';
$string['deleteswap'] = 'Handel löschen';
$string['deleteuseritem'] = '{$a} für diese Person löschen';
$string['details'] = 'Details';
$string['dropa'] = 'Fundort \'{$a}\'';
$string['dropname'] = 'Fundort';
$string['dropname_help'] = 'Der Name des Fundortes dient nur dazu, Ihnen die Verwaltung zu erleichtern. Er wird Teilnehmer/innen nicht angezeigt.';
$string['drops'] = 'Fundorte';
$string['drops_help'] = '<p>Fundorte sind Stellen, an denen Ihre Objekte in der <em>virtuellen Welt</em> sind. Ohne einen <em>Fundort</em> kann ein Objekt nicht von Teilnehmer/innen aufgesammelt werden.</p>
<p>Fundorte verfügen über einige Einstellungen, unter anderem wie oft eine einzelne Person dort ein Objekt aufsammeln kann, und wie oft ein Objekt dort wieder erscheint, nachdem es aufgesammelt wurde.</p>
<p>Wenn die Teilnehmer/innen z.B. einen <em>Schlüssel</em> benötigen, um Zugang zu einer Aktivität zu erhalten, werden Sie es in der Regel so einstellen, dass der Schlüssel pro Person nur einmal am Fundort aufgesammelt werden kann.</p>
<p>Wenn jede Person aber <em>5 Münzen</em> für den Zugang zu einer anderen Aktivität braucht, lassen Sie diese Münze vielleicht täglich wieder erscheinen, um zu einem täglichen Besuch des Kurses zu motivieren.</p>
<p>Beachten Sie, dass Objekte nicht von Zauberhand in Ihrem Kurs erscheinen. Sie müssen einen speziellen Code in Ihren Kursinhalt einfügen, damit die Objekte angezeigt werden.</p>';
$string['dropslist'] = 'Liste der Fundorte';
$string['dropsnippet'] = 'Schnipsel für \'{$a}\'';
$string['dropsummary'] = 'Zusammenfassung Fundort';
$string['edit'] = 'Bearbeiten';
$string['editdrop'] = 'Fundort bearbeiten \'{$a}\'';
$string['edititem'] = 'Objekt bearbeiten \'{$a}\'';
$string['edittrade'] = 'Tauschangebot bearbeiten \'{$a}\'';
$string['edittradeitem'] = 'Tauschobjekt bearbeiten \'{$a}\'';
$string['eginthecastle'] = 'Z.B. in der Burg';
$string['enabled'] = 'Aktiviert';
$string['eventitemacquired'] = 'Ein Objekt wurde erworben.';
$string['eventswapaccepted'] = 'Ein nutzerdefinierter Tausch wurde akzeptiert.';
$string['eventswapcreated'] = 'Ein nutzerdefinierter Tausch wurde erstellt.';
$string['filtershortcodesnotactive'] = 'Der Filter Shortcodes ist installiert, aber nicht für diesen Kurs aktiviert. Gehen Sie zu <a href="{$a->activeurl}" target="_blank">dieser Seite</a>, um ShortCodes für diesen Kurs zu aktivieren.';
$string['filtershortcodesnotenabled'] = 'Der Filter Shortcodes ist installiert, aber noch nicht <a href="{$a->enableurl}" target="_blank">aktiviert</a>.';
$string['filtershortcodesnotinstalled'] = 'Wir empfehlen Ihnen, dass Sie den <a href="{$a->installurl}" target="_blank">Filter Shortcodes</a> installieren und aktivieren. Das macht die Verwendung der Code-Schnipsel einfacher und zuverlässiger. Dies ermöglicht außerdem das Tauschen.';
$string['filterstashdeprecated'] = 'Sie verwenden das veraltete Filter-Plugin Stash, das nicht mehr unterstützt wird. Wir empfehlen Ihnen, stattdessen das <a href="{$a->installurl}" target="_blank">Filter-Plugin Shortcodes</a> zu installieren und zu aktivieren.  Dies ermöglicht außerdem das Tauschen.';
$string['filterstashnotactive'] = 'Das Filter-Plugin ist installiert, aber noch nicht für diesen Kurs aktiviert. Gehen Sie zu <a href="{$a->activeurl}" target="_blank">dieser Seite</a>, um es für diesen Kurs zu aktivieren.';
$string['filterstashnotenabled'] = 'Das Filter-Plugin ist installiert aber noch nicht <a href="{$a->enableurl}" target="_blank">aktiviert</a>.';
$string['filterstashnotinstalled'] = 'Wir empfehlen Ihnen, das <a href="{$a->installurl}" target="_blank">Filter-Plugin für Stash</a> zu installieren und zu aktivieren. Es macht die Verwendung von Code-Schnipseln einfacher und zuverlässiger. Dies ermöglicht außerdem das Tauschen.';
$string['filterstashwrongversion'] = 'Das Filter-Plugin, das Sie installiert haben, ist eine alte Version und beherrscht noch nicht das Tauschen. Besuchen Sie bitte <a href="{$a}" target="_blank">diese Seite</a>, um die neueste Version zu bekommen.';
$string['from'] = 'Von';
$string['gain'] = 'Gewinn';
$string['gainloss'] = 'Gewinn oder Verlust';
$string['gaintitle'] = 'Titel "Gewinn"';
$string['gaintitle_help'] = 'Titel für die Spalte mit Objekten, die jemand bei diesem Tausch erhält.';
$string['generalsettings'] = 'Allgemeine Einstellungen';
$string['grouponly'] = 'Erlauben Sie nur Tauschgeschäfte zwischen Teilnehmer/innen in ihren jeweiligen Gruppen.';
$string['image'] = 'Bild';
$string['imageandbutton'] = 'Bild und Button';
$string['item'] = 'Objekt';
$string['itemamountlimit'] = 'Höchstmenge';
$string['itemamountlimit_help'] = 'Dies ist die maximale Menge dieses knappen Gegenstandes, das für alle Teilnehmer/innen in diesem Kurs verfügbar ist.';
$string['itemamountupdate'] = 'Die Anzahl für diesen Gegenstand wurde aktualisiert.';
$string['itemdeleted'] = 'Das Objekt wurde gelöscht.';
$string['itemdetail'] = 'Details';
$string['itemdetail_help'] = 'Details zum Objekt.';
$string['itemimage'] = 'Bild';
$string['itemimage_help'] = 'Mit diesem Bild wird das Objekt angezeigt. Die empfohlene Größe ist 100x100 Pixel.';
$string['itemname'] = 'Objektname';
$string['itemname_help'] = 'Der Name des Objekts, wie er den Teilnehmer/innen angezeigt werden soll.';
$string['itemremoval'] = 'Objekt entfernen';
$string['items'] = 'Objekte';
$string['itemslist'] = 'Liste der Objekte';
$string['itemsremoved'] = 'Objekte entfernt';
$string['leaderboard'] = 'Rangliste anzeigen';
$string['leaderboard_groups'] = 'Nur Teilnehmer/innen meiner Gruppen anzeigen';
$string['leaderboards'] = 'Ranglisten';
$string['locations'] = 'Fundorte';
$string['loss'] = 'Verlust';
$string['losstitle'] = 'Titel "Verlust"';
$string['losstitle_help'] = 'Titel für die Spalte mit Objekten, die jemand bei diesem Tausch abgeben muss.';
$string['maxnumber'] = 'Maximal sammelbar';
$string['maxpickup'] = 'Vorrat';
$string['maxpickup_help'] = 'Die Häufigkeit, mit der das Objekt von jeder Person an diesem Fundort abgeholt werden kann. Wenn Sie beispielsweise "1" festlegen, ist das Objekt nur einmal pro Person verfügbar. Wenn Sie es auf "5" setzen, kann jede Person das Objekt fünf Mal an diesem Fundort aufsammeln. Ein Wert ungleich "1" sollte in Kombination mit dem Sammlungsintervall verwendet werden.';
$string['mostitems'] = 'Meiste Objekte';
$string['mostsingularitem'] = 'Die meisten eines einzelnen Objekts';
$string['mostsingularitemname'] = 'Die meisten von \'{$a}\'';
$string['mostuniqueitems'] = 'Meiste einzelne Objekte';
$string['myitems'] = 'Meine Objekte';
$string['myrequests'] = 'Meine Anfragen an andere';
$string['navdrops'] = 'Fundorte';
$string['navinventory'] = 'Objekte im Inventar';
$string['navitems'] = 'Objekte';
$string['navleaderboadsettings'] = 'Ranglisteneinstellungen';
$string['navreport'] = 'Bericht';
$string['navtrade'] = 'Handel';
$string['new'] = 'Neu';
$string['next'] = 'Weiter';
$string['nofilterandnotiny'] = '📢 Wussten Sie, dass es ein neues Plugin für den TinyMCE Editor gibt, das die Erstellung von Objekten und deren Handel erleichtert. Laden Sie das <a href="https://moodle.org/plugins/filter_shortcodes"> Filter Plugin Shortcodes </a> und das <a href="https://moodle.org/plugins/tiny_stash"> Plugin Tiny Stash Plugin für TinyMCE </a> herunter, um die Erstellung von Stash-Objekten zu erleichtern. Ein Vorschau-Video ist über den Tiny Stash Link verfügbar.';
$string['noitems'] = 'Keine Objekte ausgewählt';
$string['noitemstotrade'] = 'Sie haben keine Objekte zum Tauschen.';
$string['nomorescarceitems'] = 'Die maximale Anzahl für diesen Gegenstand wurde erreicht. Überlegen Sie, die maximale Anzahl zu erhöhen.';
$string['none'] = 'Nichts';
$string['noquizzes'] = 'Sie haben keine Tests.';
$string['nosingularitem'] = 'Fügen Sie bitte mindestens ein Objekt hinzu, um diese Rangliste zu verwenden.';
$string['notiny'] = '📢 Wussten Sie, dass es ein neues Plugin für den TinyMCE Editor gibt, das die Erstellung von Objekten und deren Handel erleichtert. Laden Sie das <a href="https://moodle.org/plugins/tiny_stash"> Plugin Tiny Stash für den TinyMCE </a> herunter, um die Erstellung von Stash-Objekten zu erleichtern. Ein Vorschau-Video ist über den Tiny-Stash-Link verfügbar.';
$string['notrecorded'] = 'Nicht gespeichert';
$string['number'] = 'Nummer';
$string['offerdetail'] = 'Sie haben einen Tausch mit dieser Person für die folgenden Objekte beantragt.';
$string['offereditems'] = 'Angebotene Objekte';
$string['offers'] = 'Angebote';
$string['offers:zero'] = 'Keine Angebote';
$string['offersdetail:zero'] = 'Gehen Sie zum Handelszentrum, um einen Tauschhandel zu beginnen, oder warten Sie darauf, dass Ihnen jemand einen Tauschhandel anbietet.';
$string['participantswithitem'] = 'Teilnehmer/innen mit diesem Objekt';
$string['pickupa'] = '\'{$a}\' aufsammeln';
$string['pickupinterval'] = 'Sammlungsintervall';
$string['pickupinterval_help'] = 'Das Intervall definiert den Zeitraum, nach dem das Objekt für Personen, die es bereits aufgesammelt haben, wieder sichtbar wird. Wenn Sie z.B. ein Objekt "Kuchen" erstellt haben, können Sie das Erfassungsintervall auf 24 Stunden einstellen, um die Zeit zu simulieren, die der Bäcker für einen weiteren Kuchen benötigt. Wichtig zu beachten ist, dass Personen nicht von den Aktionen anderer betroffen sind. Diese Einstellung hat keine Auswirkungen, wenn \'Vorrat\' auf \'1\' gesetzt ist.';
$string['pluginname'] = 'Stash';
$string['previous'] = 'Zurück';
$string['privacy:metadata:pickup'] = 'Eine Übersicht der an einem bestimmten Ort aufgesammelten Objekte';
$string['privacy:metadata:pickup:dropid'] = 'Die ID des Fundortes';
$string['privacy:metadata:pickup:lastpickup'] = 'Der Zeitpunkt des letzten Aufsammelns';
$string['privacy:metadata:pickup:pickupcount'] = 'Die Objektanzahl, die an diesem Fundort aufgesammelt wurde.';
$string['privacy:metadata:pickup:timecreated'] = 'Der Zeitpunkt, zu dem die Übersicht erzeugt wurde.';
$string['privacy:metadata:pickup:timemodified'] = 'Der Zeitpunkt, zu dem die Übersicht zum letzten Mal geändert wurde.';
$string['privacy:metadata:pickup:userid'] = 'Die ID der Person, die ein Objekt aufgesammelt hat.';
$string['privacy:metadata:swap'] = 'Ein Protokoll über den Handel zwischen Personen';
$string['privacy:metadata:swap:initiator'] = 'Die Person, die ein Tauschangebot gemacht hat';
$string['privacy:metadata:swap:message'] = 'Eine Nachricht zum Handel';
$string['privacy:metadata:swap:messageformat'] = 'Ein Format, in dem die Nachricht vorliegt';
$string['privacy:metadata:swap:receiver'] = 'Die Person, die das Tauschangebot erhält';
$string['privacy:metadata:swap:stashid'] = 'Der Vorrat, der hier gehandelt wird, ist Teil von';
$string['privacy:metadata:swap:status'] = 'Status des Handels';
$string['privacy:metadata:swap:timecreated'] = 'Der Zeitpunkt, zu dem das Tauschangebot gemacht wurde';
$string['privacy:metadata:swap:timemodified'] = 'Jedes Mal, wenn das Tauschangebot aktualisiert wird';
$string['privacy:metadata:useritem'] = 'Eine Übersicht der Objekte, die jemand besitzt.';
$string['privacy:metadata:useritem:itemid'] = 'Die ID des Objekts.';
$string['privacy:metadata:useritem:quantity'] = 'Die Anzahl der im Besitz befindlichen Objekte.';
$string['privacy:metadata:useritem:timecreated'] = 'Der Zeitpunkt, zu dem der Datensatz erstellt wurde.';
$string['privacy:metadata:useritem:timemodified'] = 'Der Zeitpunkt, zu dem der Datensatz zuletzt geändert wurde.';
$string['privacy:metadata:useritem:userid'] = 'Die ID der Person, die  das Objekt besitzt.';
$string['quantity'] = 'Anzahl';
$string['quizitemsremoved'] = 'Folgende Objekte wurden entfernt:';
$string['quizname'] = 'Testname';
$string['quiznotenoughitems'] = 'Sie haben nicht genügend Objekte, um diesen Test zu starten. Sie benötigen folgende Objekte:';
$string['quizremovalconfigured'] = 'Dieser Test wurde <a href="{$a}">konfiguriert</a>, um Stash-Objekte zu entfernen.';
$string['reallydeletedrop'] = 'Möchten Sie diesen Fundort wirklich löschen?';
$string['reallydeleteitem'] = 'Möchten Sie dieses Objekt wirklich löschen?';
$string['reallyresetstashof'] = 'Möchten Sie das Inventar von {$a} wirklich zurücksetzen?';
$string['received'] = 'Erhalten';
$string['removalconfigurations'] = 'Konfigurationen für das Entfernen';
$string['removalexplanation'] = 'Entfernen ist derzeit auf einen Versuch in der Aktivität Test beschränkt. Zum Entfernen gelistete Objekte werden jedes Mal entfernt, wenn eine Person einen neuen Versuch startet. Der Zugriff zum Test wird verhindert, wenn die Person nicht genügend gelistete Objekte besitzt.';
$string['removals'] = 'Entfernungen';
$string['removeswapdetails'] = 'Möchten Sie die Handelsdetails entfernen?';
$string['report'] = 'Bericht';
$string['reportadditional'] = 'Erweiterte Gegenstandsverwaltung';
$string['requestdetail'] = 'Diese Person hat den folgenden Handel angefragt.';
$string['requesteditems'] = 'Angeforderte Objekte';
$string['requestsent'] = 'Die Anfrage wurde gesendet.';
$string['requestsforme'] = 'Anfragen an mich';
$string['requestswap'] = 'Ein Angebot machen';
$string['resetstashof'] = 'Das Inventar von {$a}  zurücksetzen';
$string['saveandnext'] = 'Speichern und weiter';
$string['savechanges'] = 'Änderungen speichern';
$string['savequantity'] = 'Speichern Sie die Menge für den Artikel {$a}';
$string['scarceitem'] = 'Mengenbegrenzung';
$string['scarceitem_help'] = 'Das Objekt steht nur begrenzt zur Verfügung. Wenn Sie hier 5 eingeben, kann es nur fünfmal eingesammelt werden.';
$string['searchitems'] = 'Objekte suchen';
$string['selectanitem'] = 'Objekt auswählen';
$string['selectauser'] = 'Nutzer/in wählen';
$string['selectquiz'] = 'Test';
$string['selectquizcheck'] = 'Wählen Sie bitte einen Test';
$string['sendtraderequest'] = 'Tauschanfrage senden';
$string['sent'] = 'Gesendet';
$string['settings'] = 'Einstellungen';
$string['settingupdated'] = 'Einstellungen aktualisiert';
$string['setup'] = 'Setup';
$string['shortcode:stashdrop'] = 'Ein Objekt zum Aufsammeln anzeigen';
$string['shortcode:stashtrade'] = 'Das Tauschangebot anzeigen';
$string['snippet'] = 'Schnipsel';
$string['stash'] = 'Stash - Versteck';
$string['stash:acquireitems'] = 'Nutzer/in kann Objekte sammeln';
$string['stash:addinstance'] = 'Block zu einer Seite hinzufügen';
$string['stash:view'] = 'Das Inventar ansehen';
$string['stashdisabled'] = '"Stash" ist nicht verfügbar. Wurde der Block zum Kurs hinzugefügt?';
$string['swapnolongerpossible'] = 'Dieses Angebot ist nicht mehr möglich, wahrscheinlich weil entweder Sie oder die andere Person diese Objekte nicht mehr besitzen.';
$string['text'] = 'Text';
$string['thedrophasbeendeleted'] = 'Der Fundort \'{$a}\' wurde gelöscht.';
$string['theiritems'] = 'Ihre Objekte';
$string['theitemhasbeendeleted'] = 'Das Objekt  \'{$a}\' wurde gelöscht.';
$string['thestashofhasbeenreset'] = 'Das Inventar von {$a} wurde zurückgesetzt.';
$string['thetradehasbeendeleted'] = 'Das Tauschangebot  \'{$a}\' wurde gelöscht.';
$string['thetradeitemhasbeendeleted'] = 'Das Tauschobjekt wurde gelöscht.';
$string['tidyswap'] = 'Alle Handelsanfragen entfernen, die abgeschlossen sind';
$string['title'] = 'Titel';
$string['to'] = 'an';
$string['trade'] = 'Handel';
$string['tradecenter'] = 'Handelszentrum';
$string['tradecenter:zero'] = 'Wählen Sie oben ein Objekt oder eine Person aus';
$string['tradecenterdetail:zero'] = 'Wenn Sie ein Objekt suchen, erhalten Sie eine Liste von Personen mit diesen Objekten, um einen Tauschhandel beginnen können. Wenn Sie eine Person auswählen, wird eine Liste mit den Objekten angezeigt, die Sie tauschen können.';
$string['tradecreated'] = 'Tausch angelegt \'{$a}\'';
$string['tradedetails'] = 'Handeldetails';
$string['tradeitem'] = 'Tauschobjekt';
$string['tradeitems'] = 'Tauschobjekte';
$string['tradelist'] = 'Liste der Tauschangebote';
$string['tradename'] = 'Name des Tauschangebots';
$string['tradename_help'] = 'Der Name des Tauschangebotes, der den Teilnehmer/innen angezeigt wird.';
$string['tradesnotenabled'] = 'Der Handel ist nicht aktiviert.';
$string['tradestatusapproved'] = 'Handel zugelassen';
$string['tradestatuscompleted'] = 'Handel abgeschlossen';
$string['tradestatusdeclined'] = 'Handel abgelehnt';
$string['tradestatusviewed'] = 'Handel gesehen';
$string['tradewidget'] = 'Einen Tausch anlegen';
$string['tradewidget_help'] = '<p>Bei diesem Tauschangebot gibt es die Objekte in der linken Spalte im Tausch gegen die Objekte der rechten Spalte.</p><p>Klicken Sie auf das + Symbol unter dem Kasten, um Objekte zur jeweiligen Spalte hinzuzufügen.</p><p>Die Anzahl der Objekte muss eine positive Zahl sein.</p>';
$string['unlimited'] = 'Unbegrenzt';
$string['useritemswap'] = 'Erlauben Sie den Teilnehmer/innen, untereinander Objekte zu tauschen.';
$string['view'] = 'ansehen';
$string['whataredrops'] = 'Was sind Fundorte?';
$string['whatisadrophelp'] = 'Ein Fundort ist die Stelle, an der Sie das Objekt anzeigen möchten.';
$string['whatisatradedrophelp'] = 'Ein Tauschort ist die Stelle, an der Sie das Tauschangebot anzeigen möchten.';
$string['whatisthisthing'] = 'Was ist das für ein Ding? Ich bin sicher, Sie finden eine Verwendung dafür!';
$string['whatsnext'] = 'Was kommt als nächstes?';
$string['whatsthis'] = 'Was ist das?';
$string['yourinventoryisempty'] = 'Ihr Inventar ist leer.';
