<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'de', version '5.1'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Sie haben anstehende BigBlueButton-Meetings.';
$string['bbbduetimeoverstartingtime'] = 'Die Endzeit muss später als die Startzeit sein.';
$string['bbbdurationwarning'] = 'Dieses Meeting dauert maximal %duration% Minuten.';
$string['bbbrecordallfromstartwarning'] = 'Dieses Meeting wird von Beginn an aufgezeichnet.';
$string['bbbrecordwarning'] = 'Dieses Meeting kann aufgezeichnet werden.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Neues Meeting erstellen';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Instanz für Live-Meeting erstellen';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Instanz mit Aufzeichnungen erstellen';
$string['bigbluebuttonbn:deleterecordings'] = 'Aufzeichnungen löschen';
$string['bigbluebuttonbn:importrecordings'] = 'Aufzeichnungen importieren';
$string['bigbluebuttonbn:join'] = 'An einem Meeting teilnehmen';
$string['bigbluebuttonbn:managerecordings'] = 'Aufzeichnungen verwalten';
$string['bigbluebuttonbn:protectrecordings'] = 'Aufzeichnungen schützen';
$string['bigbluebuttonbn:publishrecordings'] = 'Aufzeichnungen veröffentlichen';
$string['bigbluebuttonbn:seepresentation'] = 'Präsentationsdatei auf der Aktivitätsseite anzeigen';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Aufzeichnungen Schutz aufheben';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Aufzeichnungen Veröffentlichung zurückziehen';
$string['bigbluebuttonbn:view'] = 'Meeting anzeigen';
$string['bigbluebuttonbn:viewallrecordingformats'] = 'Alle Aufnahmeformate anzeigen';
$string['cachedef_currentfetch'] = 'Daten zum Auflisten aller kürzlich abgerufenen Aufzeichnungen.';
$string['cachedef_recordings'] = 'Metadaten zur Aufzeichnung';
$string['cachedef_serverinfo'] = 'Infos zum Remote-Server';
$string['cachedef_subplugins'] = 'Cache, der von Sub-Plugin-Routinen verwendet wird, um bei Bedarf den Plugin-Erkennungsprozess zu beschleunigen.';
$string['cachedef_validatedurls'] = 'Cache von validierten URL-Prüfungen';
$string['calendarstarts'] = '{$a} ist vorgesehen für';
$string['cannotperformaction'] = 'Aktion {$a} kann für diese Aufzeichnung nicht ausgeführt werden';
$string['closes'] = 'Schließt';
$string['completionattendance'] = 'Notwendige Anwesenheit (Minuten)';
$string['completionattendance_desc'] = 'Muss mindestens {$a} Minute(n) teilnehmen';
$string['completionattendance_event_desc'] = 'Teilnehmer/in hat das Meeting betreten und ist mindestens {$a} Minute(n) geblieben.';
$string['completionattendancegroup'] = 'Notwendige Anwesenheit (Minuten)';
$string['completionengagement_desc'] = 'Muss an Aktivitäten teilnehmen';
$string['completionengagementchats'] = 'Chats';
$string['completionengagementchats_desc'] = 'Muss an {$a} Chat(s) teilnehmen';
$string['completionengagementchats_event_desc'] = 'Teilnehmer/in hat {$a} Chat(s) ausgelöst.';
$string['completionengagementemojis'] = 'Emojis';
$string['completionengagementemojis_desc'] = 'Muss Emoji {$a}-mal ändern';
$string['completionengagementemojis_event_desc'] = 'Muss Emoji {$a}-mal geändert haben';
$string['completionengagementgroup'] = 'Teilnahme erforderlich';
$string['completionengagementpollvotes'] = 'Abstimmungen';
$string['completionengagementpollvotes_desc'] = 'Muss {$a}-mal in Umfragen abstimmen';
$string['completionengagementpollvotes_event_desc'] = 'Muss {$a}-mal Umfragen beantworten';
$string['completionengagementraisehand'] = 'Wortmeldungen notwendig';
$string['completionengagementraisehand_desc'] = 'Muss sich {$a}-mal zu Wort melden';
$string['completionengagementraisehand_event_desc'] = 'Teilnehmer/in hat sich {$a}-mal zu Wort gemeldet.';
$string['completionengagementtalks'] = 'Gespräche';
$string['completionengagementtalks_desc'] = 'Muss {$a}-mal sprechen';
$string['completionengagementtalks_event_desc'] = 'Teilnehmer/in hat {$a} Gespräch(e) begonnen.';
$string['completionupdatestate'] = 'Status der Abschlussüberprüfung';
$string['completionvalidatestate'] = 'Abschluss überprüfen';
$string['completionvalidatestatetriggered'] = 'Die Abschlussüberprüfung wurde angestoßen.';
$string['completionview_event_desc'] = 'Teilnehmer/in hat das Meeting angezeigt.';
$string['config_checksum_algorithm'] = 'BigBlueButton Prüfsummenalgorithmus';
$string['config_checksum_algorithm_description'] = 'SHA1 ist kompatibel mit älteren Servern. SHA256 und SHA512 sind sicherer. SHA512 entspricht dem FIPS 140-2 Sicherheitsstandard.';
$string['config_default_messages'] = 'Standardmitteilungen';
$string['config_default_messages_description'] = 'Standardmitteilung für Aktivität festlegen';
$string['config_disablecam_default'] = 'Webcams deaktivieren';
$string['config_disablecam_default_description'] = 'Die Option legt fest, dass die Webcams deaktiviert sind.';
$string['config_disablecam_editable'] = '"Webcams deaktivieren" bearbeitbar';
$string['config_disablecam_editable_description'] = 'Die Option "Webcams deaktivieren" kann bearbeitet werden, wenn die Aktivität angelegt oder aktualisiert wird.';
$string['config_disablemic_default'] = 'Mikrofone deaktivieren';
$string['config_disablemic_default_description'] = 'Die Option legt fest, dass die Mikrofone deaktiviert sind.';
$string['config_disablemic_editable'] = '"Mikrofone deaktivieren" bearbeitbar';
$string['config_disablemic_editable_description'] = 'Die Option "Mikrofone deaktivieren" kann bearbeitet werden, wenn die Aktivität angelegt oder aktualisiert wird.';
$string['config_disablenote_default'] = 'Geteilte Notizen deaktivieren';
$string['config_disablenote_default_description'] = 'Die Option legt fest, dass die geteilten Notizen deaktiviert sind.';
$string['config_disablenote_editable'] = '"Geteilte Notizen deaktivieren" bearbeitbar';
$string['config_disablenote_editable_description'] = 'Die Option "Geteilte Notizen deaktivieren" kann bearbeitet werden, wenn die Aktivität angelegt oder aktualisiert wird.';
$string['config_disableprivatechat_default'] = 'Private Chats deaktivieren';
$string['config_disableprivatechat_default_description'] = 'Die Option legt fest, dass die privaten Chats deaktiviert sind.';
$string['config_disableprivatechat_editable'] = '"Private Chats deaktivieren" bearbeitbar';
$string['config_disableprivatechat_editable_description'] = 'Die Option "Private Chats deaktivieren" kann bearbeitet werden, wenn die Aktivität angelegt oder aktualisiert wird.';
$string['config_disablepublicchat_default'] = 'Öffentlichen Chat deaktivieren';
$string['config_disablepublicchat_default_description'] = 'Die Option legt fest, dass der öffentlichen Chat deaktiviert ist.';
$string['config_disablepublicchat_editable'] = '"Öffentlichen Chat deaktivieren" bearbeitbar';
$string['config_disablepublicchat_editable_description'] = 'Die Option "Öffentlichen Chat deaktivieren" kann bearbeitet werden, wenn die Aktivität angelegt oder aktualisiert wird.';
$string['config_experimental_features'] = 'Experimentelle Optionen';
$string['config_experimental_features_description'] = 'Einstellungen für experimentelle Optionen';
$string['config_extended_capabilities'] = 'Erweiterte Funktionen';
$string['config_extended_capabilities_description'] = 'Erweiterungen konfigurieren, falls der BigBlueButton-Server diese bereit stellt.';
$string['config_general'] = 'Allgemeine Einstellungen';
$string['config_general_description'] = 'Um BigBlueButton einzurichten, können Sie entweder Ihren eigenen BigBlueButton-Server und Ihre eigenen Anmeldeinformationen verwenden oder Anmeldeinformationen über das <a href="https://registration-portal.blindsidenetworks.com/" target="_blank">Blindside Networks-Registrierungsportal (öffnet sich in einem neuen Fenster)</a>.';
$string['config_guestaccess_enabled'] = 'Externer Gastzugang';
$string['config_guestaccess_enabled_description'] = 'Diese Option erlaubt es Nutzer/innen ohne Nutzerkonto in Moodle, auf den Raum zuzugreifen.';
$string['config_hideuserlist_default'] = 'Teilnahmeliste verbergen';
$string['config_hideuserlist_default_description'] = 'Die Option legt fest, ob die Liste der Teilnehmer/innen verborgen ist.';
$string['config_hideuserlist_editable'] = '"Teilnahmeliste verbergen" bearbeitbar';
$string['config_hideuserlist_editable_description'] = 'Die Option "Teilnahmeliste verbergen" kann bearbeitet werden, wenn die Aktivität angelegt oder aktualisiert wird.';
$string['config_importrecordings'] = 'Aufzeichnungsimport';
$string['config_importrecordings_description'] = 'Diese Einstellungen sind funktionsabhängig.';
$string['config_importrecordings_enabled'] = 'Aufzeichnungsimport aktiviert';
$string['config_importrecordings_enabled_description'] = 'Wenn diese Option und die Aufzeichnungsfunktion eingeschaltet sind, können Sie Aufzeichnungen aus anderen Kursen importieren.';
$string['config_importrecordings_from_deleted_enabled'] = 'Aufzeichnungsimport von gelöschten Aktivitäten';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Wenn diese Option und die Aufzeichnungsimportfunktion eingeschaltet sind, können Sie Aufzeichnungen von gelöschten Aktivitäten importieren.';
$string['config_locksettings'] = 'Konfiguration für Sperreinstellungen';
$string['config_locksettings_description'] = 'Diese Einstellungen aktivieren oder deaktivieren verschiedene Optionen in der Nutzeroberfläche. Außerdem werden standardmäßige Werte für diese Optionen festgelegt.';
$string['config_meetingevents_enabled'] = 'Live-Meetings registrieren';
$string['config_meetingevents_enabled_description'] = 'Wenn diese Option aktiviert ist, werden Live-Meetings nach deren Ende weiter verarbeitet. Diese Funktion ist für den Aktivitätsabschluss notwendig und funktioniert nur, wenn der BigBlueButton-Server post_events-Skripte verarbeiten kann.';
$string['config_muteonstart'] = 'Beim Start stumm schalten';
$string['config_muteonstart_default'] = 'Beim Start stummschalten';
$string['config_muteonstart_default_description'] = 'Wenn diese Option aktiviert ist, beginnt das Meeting standardmäßig mit ausgeschalteten Mikrofonen.';
$string['config_muteonstart_description'] = 'Diese Einstellungen aktivieren bzw. deaktivieren Optionen in der Nutzeroberfläche. Außerdem definieren sie Standardwerte für einige Optionen.';
$string['config_muteonstart_editable'] = '"Beim Start stummschalten" bearbeitbar';
$string['config_muteonstart_editable_description'] = 'Die Option "Beim Start stummschalten" kann bearbeitet werden, wenn die Aktivität angelegt oder aktualisiert wird.';
$string['config_participant'] = 'Teilnehmer/innen';
$string['config_participant_description'] = 'Diese Einstellungen definieren die standardmäßige Rolle von Teilnehmer/innen im Meeting.';
$string['config_participant_moderator_default'] = 'Moderator/innen';
$string['config_participant_moderator_default_description'] = 'Diese Voreinstellungen werden für neu eingerichtete Räume verwendet.';
$string['config_poll_interval'] = 'Abfrageintervall für Raumstatus';
$string['config_poll_interval_description'] = 'Das Abfrageintervall für den Raumstatus muss mindestens 2 Sekunden betragen. Bei Bedarf können Sie die Last auf dem Remote-Server senken, indem Sie das Intervall erhöhen.';
$string['config_presentation_default'] = 'Standardmäßige Präsentationsdatei';
$string['config_presentation_default_description'] = 'Diese Datei wird standardmäßig in allen Meetings verwendet.';
$string['config_preuploadpresentation'] = 'Präsentationsdatei';
$string['config_preuploadpresentation_description'] = 'Diese Einstellungen aktivieren oder deaktivieren verschiedene Optionen in der Nutzeroberfläche. Außerdem werden standardmäßige Werte festgelegt. Diese Option funktioniert nur, wenn der Moodle-Server für BigBlueButton erreichbar ist.';
$string['config_preuploadpresentation_editable'] = 'Präsentationsdatei auf der Aktivitätsseite';
$string['config_preuploadpresentation_editable_description'] = 'Option in den Aktivitätseinstellungen, die das Hochladen einer Präsentationsdatei für die Aktivitätsseite erlaubt.';
$string['config_profile_picture_enabled'] = 'Profilbilder anzeigen';
$string['config_profile_picture_enabled_description'] = 'Sollen Profilbilder der Teilnehmer/innen in Bigbluebutton-Sitzungen gezeigt werden?';
$string['config_recording'] = 'Aufzeichnung';
$string['config_recording_all_from_start_default'] = 'Von Beginn an aufzeichnen';
$string['config_recording_all_from_start_default_description'] = 'Soll die Option "Von Beginn an aufzeichnen" standardmäßig aktiviert sein, wenn ein neues BigBlueButton-Meeting angelegt wird?';
$string['config_recording_all_from_start_editable'] = '"Von Beginn an aufzeichnen" bearbeitbar';
$string['config_recording_all_from_start_editable_description'] = 'Soll die Option "Von Beginn an aufzeichnen" in den Einstellungen bearbeitbar sein?';
$string['config_recording_default'] = 'Meeting kann aufgezeichnet werden';
$string['config_recording_default_description'] = 'Soll die Option "Meeting kann aufgezeichnet werden" standardmäßig aktiviert sein, wenn ein neues Meeting angelegt wird?';
$string['config_recording_description'] = 'Diese Einstellungen sind funktionsabhängig.';
$string['config_recording_editable'] = '"Meeting kann aufgezeichnet werden" bearbeitbar';
$string['config_recording_editable_description'] = 'Soll die Option "Meeting kann aufgezeichnet werden" in den Einstellungen bearbeitbar sein?';
$string['config_recording_hide_button_default'] = 'Aufzeichnungstaste verbergen';
$string['config_recording_hide_button_default_description'] = 'Wenn diese Option aktiviert ist, wird der Aufzeichnungstaste verborgen';
$string['config_recording_hide_button_editable'] = '"Aufzeichnungstaste verbergen" bearbeitbar';
$string['config_recording_hide_button_editable_description'] = 'Soll die Option "Aufzeichnungstaste verbergen" in den Einstellungen bearbeitbar sein?';
$string['config_recording_protect_editable'] = '"Aufzeichnung geschützt" bearbeitbar';
$string['config_recording_protect_editable_description'] = 'Wenn diese Option aktiviert ist, finden Sie eine Option zum Schützen/Aufheben des Schutzes von Aufnahmen.';
$string['config_recording_refresh_period'] = 'Aktualisierungsintervall für Aufzeichnung (in Sekunden)';
$string['config_recording_refresh_period_description'] = 'Wie häufig soll der BigBlueButton-Server kontaktiert werden, um Remote-Informationen für eine Aufzeichnung zu erneuern?';
$string['config_recording_safe_formats'] = 'Aufnahmeformate für alle sichtbar';
$string['config_recording_safe_formats_description'] = 'Wählen Sie die Formate aus, die für alle sichtbar sein sollen.
Alle anderen Formate können nur von Trainer/innen und Personen mit den Rechten mod/bigbluebuttonbn:viewallrecordingformats und mod/bigbluebuttonbn:managerecordings angezeigt werden.';
$string['config_recordingready_enabled'] = 'Systemnachricht, wenn Aufzeichnung verfügbar';
$string['config_recordingready_enabled_description'] = 'Wenn die Option aktiviert ist, wird eine Mitteilung gesendet, sobald die Aufzeichnung fertig ist. Dies funktioniert nur, wenn das Script post_publish_recording_ready_callback auf dem BigBlueButton-Server aktiviert ist.';
$string['config_recordings'] = 'Aufzeichnungen anzeigen';
$string['config_recordings_asc_sort'] = 'Aufzeichnungen in aufsteigender Reihenfolge';
$string['config_recordings_asc_sort_description'] = 'Aufzeichnungen sind nach Datum, entweder chronologisch aufsteigend (älteste zuerst) oder absteigend (neueste zuerst).';
$string['config_recordings_deleted_default'] = 'Aufzeichnungen von gelöschten Aktivitäten einbeziehen';
$string['config_recordings_deleted_default_description'] = 'Wenn diese Option aktiviert ist, enthält die Tabelle auch die Aufzeichnungen von gelöschten Aktivitäten.';
$string['config_recordings_deleted_editable'] = '"Aufzeichnungen von gelöschten Aktivitäten einbeziehen" bearbeitbar';
$string['config_recordings_deleted_editable_description'] = '"Aufzeichnungen von gelöschten Aktivitäten einbeziehen“ kann bearbeitet werden, wenn die Instanz hinzugefügt oder bearbeitet wird';
$string['config_recordings_description'] = 'Diese Einstellungen sind funktionsabhängig.';
$string['config_recordings_general'] = 'Aufzeichnungseinstellungen zeigen';
$string['config_recordings_general_description'] = 'Diese Einstellungen werden nur verwendet, wenn Aufzeichnungen angezeigt werden.';
$string['config_recordings_imported_default'] = 'Nur importierte Links anzeigen';
$string['config_recordings_imported_default_description'] = 'Wenn diese Option aktiviert ist, enthält die Tabelle nur die importierten Links zu Aufzeichnungen.';
$string['config_recordings_imported_editable'] = '"Nur importierte Links anzeigen" bearbeitbar';
$string['config_recordings_imported_editable_description'] = 'Die Option "Nur importierte Links anzeigen" kann bearbeitet werden, wenn eine Instanz angelegt oder aktualisiert wird.';
$string['config_recordings_preview_default'] = 'Vorschau anzeigen';
$string['config_recordings_preview_default_description'] = 'Wenn diese Option aktiviert ist, wird eine Vorschau der Präsentation einbezogen.';
$string['config_recordings_preview_editable'] = '"Vorschau anzeigen" bearbeitbar';
$string['config_recordings_preview_editable_description'] = 'Die Vorschau kann bearbeitet werden, wenn die Instanz angelegt oder aktualisiert wird.';
$string['config_scheduled'] = 'Terminierte Meetings';
$string['config_scheduled_description'] = 'Diese Einstellungen legen Standardwerte für \'Terminierte Meetings\' fest.';
$string['config_scheduled_pre_opening'] = 'Zugang vor der Startzeit';
$string['config_scheduled_pre_opening_description'] = 'Zeit (in Minuten), die das Meeting vor der geplanten Startzeit zugänglich ist.';
$string['config_server_url'] = 'BigBlueButton-Server-URL';
$string['config_server_url_description'] = 'URL zum BigBlueButton-Server';
$string['config_shared_secret'] = 'BigBlueButton Shared Secret';
$string['config_shared_secret_description'] = 'Security-Secret für den BigBlueButton-Server';
$string['config_showpresentation_default'] = 'Präsentationsdatei auf der Aktivitätsseite zeigen';
$string['config_showpresentation_default_description'] = 'Sollen Teilnehmer/innen bereits vor der Sitzung Zugriff auf die Präsentationsdatei haben? Diese Einstellung hat keine Auswirkung auf Nutzer/innen mit dem Recht "Präsentationsdatei immer auf der Aktivitätsseite sehen“.';
$string['config_showpresentation_editable'] = 'Option \'Präsentationsdatei auf der Aktivitätsseite zeigen\'';
$string['config_showpresentation_editable_description'] = 'Die Option erlaubt es Trainer/innen, für die Teilnehmer/innen eine Präsentationsdatei anzuzeigen.';
$string['config_uidelegation_enabled'] = 'Die Weitergabe der Werkzeuge ist aktiviert';
$string['config_uidelegation_enabled_description'] = 'Diese Einstellungen aktivieren oder deaktivieren die Weitergabe der Werkzeuge.';
$string['config_userlimit'] = 'Maximale Anzahl von Nutzer/innen';
$string['config_userlimit_default'] = 'Maximale Nutzerzahl standardmäßig';
$string['config_userlimit_default_description'] = 'Die Option legt die maximale Anzahl von Nutzer/innen fest, die standardmäßig in einem Meeting zugelassen sind, wenn ein neues Meeting angelegt wird. Falls der Wert auf 0 gesetzt wird, ist keine Obergrenze festgelegt.';
$string['config_userlimit_description'] = 'Diese Einstellungen aktivieren bzw. deaktivieren Optionen in der Nutzeroberfläche. Außerdem definieren sie Standardwerte für einige Optionen.';
$string['config_userlimit_editable'] = 'Maximale Nutzerzahl bearbeitbar';
$string['config_userlimit_editable_description'] = 'Die maximale Anzahl von Nutzer/innen im Meeting kann geändert werden, wenn das Meeting angelegt oder aktualisiert wird.';
$string['config_voicebridge'] = 'Voice Bridge';
$string['config_voicebridge_description'] = 'Diese Einstellungen aktivieren bzw. deaktivieren Optionen in der Nutzeroberfläche. Außerdem definieren sie Standardwerte für einige Optionen.';
$string['config_voicebridge_editable'] = 'Konferenz-Voice-Bridge bearbeitbar';
$string['config_voicebridge_editable_description'] = 'Die Konferenznummer kann dauerhaft einem Meeting zugeordnet werden. Eine zugewiesene Nummer kann aber nicht mehr für ein weiteres Meeting verwendet werden';
$string['config_waitformoderator'] = 'Warten auf Moderator/in';
$string['config_waitformoderator_cache_ttl'] = 'Maximale Cache-Zeit (Sekunden)';
$string['config_waitformoderator_cache_ttl_description'] = 'Um eine große Anzahl von Clients zu unterstützen, verwendet dieses Plugin einen Cache. Dieser Parameter definiert die Zeit, die der Cache aufbewahrt wird, bevor die nächste Anforderung an den BigBlueButton-Server gesendet wird.';
$string['config_waitformoderator_default'] = 'Warten auf Moderator/in';
$string['config_waitformoderator_default_description'] = 'Soll die Option "Warten auf Moderator/in" standardmäßig aktiviert sein, wenn ein neues Meeting angelegt wird?';
$string['config_waitformoderator_description'] = 'Diese Einstellungen sind funktionsabhängig.';
$string['config_waitformoderator_editable'] = '"Warten auf Moderator/in" bearbeitbar';
$string['config_waitformoderator_editable_description'] = 'Soll die Option "Warten auf Moderator/in" in den Einstellungen bearbeitbar sein?';
$string['config_waitformoderator_ping_interval'] = 'Ping für "Warten auf Moderator/in" (in Sekunden)';
$string['config_waitformoderator_ping_interval_description'] = 'Wie häufig soll der Server geprüft werden, ob Moderator/innen das Meeting betreten haben?';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButton verwendet config.php mit einer globalen Variable, die veraltet ist. Bearbeiten Sie bitte die Datei, da die Variable in künftigen Versionen nicht unterstützt wird.';
$string['config_warning_curl_not_installed'] = 'Die Funktion erfordert die PHP-Extension CURL, die installiert und aktiviert sein muss. Die Einstellungen stehen nur zur Verfügung, wenn diese Voraussetzung erfüllt ist.';
$string['config_welcome_default'] = 'Begrüßungstext';
$string['config_welcome_default_description'] = 'Der Begrüßungstext wird angezeigt, wenn Teilnehmer/innen das Meeting betreten. Wenn das Feld leer ist, wird der Text
\'mod_form_field_welcome_default\' verwendet..';
$string['config_welcome_editable'] = 'Begrüßungstext bearbeitbar';
$string['config_welcome_editable_description'] = 'Der standardmäßige Begrüßungstext kann geändert werden, wenn diese Aktivität angelegt oder bearbeitet wird.';
$string['credentials_warning'] = 'Die Verwendung der standardmäßigen Serveranmeldeinformationen läuft bald ab (siehe Hinweis oben, um neue Anmeldeinformationen zu erhalten).';
$string['end_session_confirm'] = 'Möchten Sie das Meeting wirklich beenden?';
$string['end_session_confirm_title'] = 'Meeting beenden?';
$string['end_session_notification'] = 'Das Meeting ist beendet.';
$string['ends_at'] = 'Endet';
$string['event_activity_created'] = 'Aktivität angelegt';
$string['event_activity_deleted'] = 'Aktivität gelöscht';
$string['event_activity_updated'] = 'BigBlueButton aktualisiert';
$string['event_live_session'] = 'Live-Session-Termin';
$string['event_meeting_created'] = 'Meeting angelegt';
$string['event_meeting_ended'] = 'Meeting beendet';
$string['event_meeting_joined'] = 'Meeting beigetreten';
$string['event_meeting_left'] = 'Meeting verlassen';
$string['event_recording_deleted'] = 'Aufzeichnung gelöscht';
$string['event_recording_edited'] = 'Aufzeichnung bearbeitet';
$string['event_recording_imported'] = 'Aufzeichnung importiert';
$string['event_recording_protected'] = 'Aufzeichnung geschützt';
$string['event_recording_published'] = 'Aufzeichnung veröffentlicht';
$string['event_recording_unprotected'] = 'Schutz der Aufzeichnung entfernt';
$string['event_recording_unpublished'] = 'Aufzeichnung zurückgezogen';
$string['event_recording_viewed'] = 'Aufzeichnung angezeigt';
$string['event_unknown'] = 'Unbekannter Termin';
$string['general_error_cannot_create_meeting'] = 'Das Meeting kann nicht angelegt werden.';
$string['general_error_cannot_get_recordings'] = 'Die Aufzeichnungen können nicht abgerufen werden.';
$string['general_error_no_answer'] = 'Leere Antwort. Überprüfen Sie bitte die URL des BigBlueButton-Servers UND stellen Sie sicher, dass der BigBlueButton-Server läuft.';
$string['general_error_not_allowed_to_create_instances'] = 'Nutzer/in darf kein Meeting erstellen.';
$string['general_error_not_found'] = 'BigBlueButton-Aktivität mit der ID {$a} nicht gefunden.';
$string['general_error_unable_connect'] = 'Das Verbinden ist nicht möglich. Prüfen Sie die URL des BigBlueButton-Servers. Stellen Sie zusätzlich sicher, dass der Server wirklich läuft.
Details: {$a}';
$string['guest_invitation_full_message'] = 'Guten Tag,
<p>Sie sind zur BigBluButton-Sitzung <strong>{$a->name}</strong> im Kurs {$a->course_fullname} eingeladen.</p>
<p>Link: {$a->guestjoinurl}
<br>Kennwort: {$a->guestpassword}</p>
<p>Falls Sie Hilfe benötigen, wenden Sie sich bitte an {$a->sender}.</p>';
$string['guest_invitation_small_message'] = 'Guten Tag,

Sie sind zur BigBluButton-Sitzung {$a->name} im Kurs {$a->course_fullname} eingeladen.

Link: {$a->guestjoinurl}
Kennwort: {$a->guestpassword}

Falls Sie Hilfe benötigen, wenden Sie sich bitte an {$a->sender}.';
$string['guest_invitation_subject'] = 'Einladung zum Meeting {$a->name} auf {$a->course_fullname}';
$string['guestaccess_activitynotfound'] = 'Aktivität nicht gefunden.';
$string['guestaccess_add'] = 'Gäste hinzufügen';
$string['guestaccess_add_no_id'] = 'Keine BigBlueButton-ID bereitgestellt.';
$string['guestaccess_copy_link'] = 'Link kopieren';
$string['guestaccess_copy_password'] = 'Kennwort kopieren';
$string['guestaccess_emails'] = 'E-Mail-Adressen von Gästen';
$string['guestaccess_emails_help'] = 'Liste von E-Mail-Adressen, getrennt durch Komma.';
$string['guestaccess_emails_invalidemail'] = 'Ungültige E-Mail-Adresse: {$a}';
$string['guestaccess_feature_disabled'] = 'Gastzugang deaktiviert.';
$string['guestaccess_invite_failure'] = 'Fehler {$a->errors} beim Einladen {$a->emails}.';
$string['guestaccess_invite_success'] = 'Eine Einladung wird versendet an: {$a->emails}.';
$string['guestaccess_join_meeting'] = 'Meeting beitreten';
$string['guestaccess_meeting_invalid_password'] = 'Falsches Kennwort';
$string['guestaccess_meeting_link'] = 'Link zum Meeting';
$string['guestaccess_meeting_not_started'] = 'Das Meeting hat noch nicht begonnen. Versuchen Sie es später nochmal.';
$string['guestaccess_meeting_password'] = 'Kennwort für Meeting';
$string['guestaccess_password'] = 'Kennwort';
$string['guestaccess_title'] = 'Gäste zum Meeting hinzufügen';
$string['guestaccess_username'] = 'Gast-Nutzername';
$string['index_confirm_end'] = 'Möchten Sie das Meeting wirklich beenden?';
$string['index_disabled'] = 'deaktiviert';
$string['index_enabled'] = 'aktiviert';
$string['index_ending'] = 'Das Meeting wird beendet ... warten Sie bitte.';
$string['index_error_bbtn'] = 'Die BigBlueButton-ID {$a} ist falsch.';
$string['index_error_checksum'] = 'Fehler: Prüfen Sie, ob der Wert \'Shared Secret\' richtig eingegeben ist.';
$string['index_error_forciblyended'] = 'Ein Beitreten zum Meeting ist nicht mehr möglich, weil es manuell beendet wurde.';
$string['index_error_noinstances'] = 'Es gibt keine BigBlueButton-Aktivitäten.';
$string['index_error_unable_display'] = 'Die Meetings können nicht angezeigt werden. Prüfen Sie die URL des BigBlueButton-Servers. Stellen Sie zusätzlich sicher, dass der Server wirklich läuft.';
$string['index_heading'] = 'BigBlueButton-Aktivitäten';
$string['index_heading_actions'] = 'Aktionen';
$string['index_heading_group'] = 'Gruppe';
$string['index_heading_moderator'] = 'Moderator/innen';
$string['index_heading_name'] = 'Raum';
$string['index_heading_recording'] = 'Aufzeichnung';
$string['index_heading_users'] = 'Nutzer/innen';
$string['index_heading_viewer'] = 'Zuschauer/innen';
$string['indicator:cognitivedepth'] = 'BigBlueButton kognitiv';
$string['indicator:cognitivedepth_help'] = 'Dieser Indikator basiert auf der kognitiven Tiefe, die Teilnehmer/innen in einer BigBlueButton-Aktivität erreicht haben.';
$string['indicator:socialbreadth'] = 'BigBlueButton sozial';
$string['indicator:socialbreadth_help'] = 'Dieser Indikator basiert auf der sozialen Breite, die Teilnehmer/innen in einer BigBlueButton-Aktivität erreicht haben.';
$string['instance_type_default'] = 'Meeting mit Aufzeichnungen';
$string['instance_type_recording_only'] = 'Nur Aufzeichnungen';
$string['instance_type_room_only'] = 'Nur Meeting';
$string['instanceprofilewithoutrecordings'] = 'Dieses Profil kann keine Aufzeichnungen anzeigen.';
$string['managebbbextplugins'] = 'Plugins zur BigBlueButton-Aktivitätserweiterung verwalten';
$string['messageprovider:instance_updated'] = 'BigBlueButton-Meeting aktualisiert';
$string['messageprovider:recording_ready'] = 'BigBlueButton-Aufzeichnung verfügbar';
$string['minute'] = 'Minute';
$string['minutes'] = 'Minuten';
$string['mod_form_block_general'] = 'Allgemein';
$string['mod_form_block_guestaccess'] = 'Gastzugang';
$string['mod_form_block_participants'] = 'Zugewiesene Rolle im Meeting';
$string['mod_form_block_presentation'] = 'Präsentationsinhalt';
$string['mod_form_block_presentation_default'] = 'Standardmäßiger Präsentationsinhalt';
$string['mod_form_block_record'] = 'Aufzeichnungseinstellungen';
$string['mod_form_block_recordings'] = 'Aufzeichnungsansicht';
$string['mod_form_block_room'] = 'Meeting-Einstellungen';
$string['mod_form_block_schedule'] = 'Zeitplan';
$string['mod_form_field_closingtime'] = 'Meeting schließt';
$string['mod_form_field_conference_name'] = 'Name des Meetings';
$string['mod_form_field_disablecam'] = 'Webcams deaktivieren';
$string['mod_form_field_disablemic'] = 'Mikrofone deaktivieren';
$string['mod_form_field_disablenote'] = 'Geteilte Notizen deaktivieren';
$string['mod_form_field_disableprivatechat'] = 'Private Chats deaktivieren';
$string['mod_form_field_disablepublicchat'] = 'Öffentlichen Chat deaktivieren';
$string['mod_form_field_duration'] = 'Dauer';
$string['mod_form_field_duration_help'] = 'Wenn die Dauer für ein Meeting festgelegt ist, wird die Aufzeichnung automatisch beendet, sobald die Zeit abgelaufen ist.';
$string['mod_form_field_guestallowed'] = 'Gastzugang erlauben';
$string['mod_form_field_hideuserlist'] = 'Teilnahmeliste verbergen';
$string['mod_form_field_instanceprofiles'] = 'Instanztyp';
$string['mod_form_field_instanceprofiles_help'] = 'Wenn eine Sitzung aufgezeichnet werden soll, wählen Sie "Meeting mit Aufzeichnung", andernfalls "Nur Meeting". Wenn nach der Aufzeichnung einer Sitzung keine weiteren Sitzungen mehr stattfinden sollen, wählen Sie "Nur Aufzeichnungen".';
$string['mod_form_field_intro'] = 'Beschreibung';
$string['mod_form_field_intro_help'] = 'Kurze Beschreibung des Meetings';
$string['mod_form_field_mustapproveuser'] = 'Gäste müssen von Moderator/in zugelassen werden.';
$string['mod_form_field_muteonstart'] = 'Beim Start stumm schalten';
$string['mod_form_field_name'] = 'Name des Meetings';
$string['mod_form_field_nosettings'] = 'Es können keine Einstellungen bearbeitet werden.';
$string['mod_form_field_openingtime'] = 'Meeting beginnt';
$string['mod_form_field_participant_add'] = 'Zuständigkeit hinzufügen';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderator/in';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Zuschauer/in';
$string['mod_form_field_participant_list'] = 'Zuständigkeit';
$string['mod_form_field_participant_list_action_add'] = 'Hinzufügen';
$string['mod_form_field_participant_list_action_remove'] = 'Entfernen';
$string['mod_form_field_participant_list_text_as'] = 'beitreten als';
$string['mod_form_field_participant_list_type_all'] = 'Alle eingeschriebenen Teilnehmer/innen';
$string['mod_form_field_participant_list_type_owner'] = 'Eigentümer/in';
$string['mod_form_field_participant_list_type_role'] = 'Rolle';
$string['mod_form_field_participant_list_type_user'] = 'Nutzer/in';
$string['mod_form_field_record'] = 'Das Meeting kann aufgezeichnet werden.';
$string['mod_form_field_recordallfromstart'] = 'Von Beginn an aufzeichnen';
$string['mod_form_field_recordhidebutton'] = 'Aufzeichnungstaste verbergen';
$string['mod_form_field_recordings_deleted'] = 'Aufzeichnungen von gelöschten Aktivitäten einbeziehen';
$string['mod_form_field_recordings_html'] = 'Tabelle in einfachem HTML anzeigen';
$string['mod_form_field_recordings_imported'] = 'Nur importierte Links anzeigen';
$string['mod_form_field_recordings_preview'] = 'Aufzeichnungsvorschau anzeigen';
$string['mod_form_field_room_name'] = 'Name des Meetings';
$string['mod_form_field_showpresentation'] = 'Präsentationsdatei auf der Aktivitätsseite zeigen';
$string['mod_form_field_userlimit'] = 'Maximale Nutzerzahl';
$string['mod_form_field_userlimit_help'] = 'Die maximale Anzahl von Nutzer/innen, die in einem Meeting erlaubt ist. Wenn der Wert auf 0 gesetzt wird, ist keine Obergrenze festgelegt.';
$string['mod_form_field_voicebridge'] = 'Voice Bridge [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Fehler: Sie müssen eine Zahl zwischen 1 und 9999 eingeben.';
$string['mod_form_field_voicebridge_help'] = 'Konferenznummer für Nutzer/innen, um per Telefon an der Konferenz teilzunehmen. Die Nummer muss zwischen 1 und 9999 liegen. Wenn der Wert 0 eingegeben wird, wird die statische Voice Bridge-Nummer ignoriert und eine zufällige Nummer generiert. Die Ziffer 7 wird der Nummer vorangestellt.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Fehler: Diese Nummer wird bereits in einem anderen Meeting benutzt.';
$string['mod_form_field_wait'] = 'Warten auf Moderator/in';
$string['mod_form_field_wait_help'] = 'Sollen Zuschauer/innen warten müssen, bis Moderator/innen dem Meeting beitreten?';
$string['mod_form_field_welcome'] = 'Begrüßungstext';
$string['mod_form_field_welcome_default'] = 'Willkommen bei %%CONFNAME%%.';
$string['mod_form_field_welcome_help'] = 'Der Begrüßungstext wird angezeigt, wenn Teilnehmer/innen dem Meeting beitreten. Wenn das Feld leer ist, wird ein Standardtext angezeigt, der von den Administrator/innen der Website festgelegt wurde.';
$string['mod_form_locksettings'] = 'Einstellungen sperren';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButton ist ein Open-Source-Webkonferenzsystem, das für Online-Lernen entwickelt wurde und das Teilen von Audio, Video, Chat, Folien und Bildschirmfreigabe ermöglicht. Ein Multiuser-Whiteboard, Breakout-Räume, Umfragen und Emojis werden unterstützt.

Mit BigBlueButton können Sie einen Raum für Meetings erstellen. Das sind z.B. Live-Online-Lernen, virtuelle Sprechstunden oder Gruppenarbeit mit Remote-Teilnehmer/innen. Eine Sitzung kann zur späteren Wiedergabe aufgezeichnet werden.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButton';
$string['new_bigblubuttonbn_activities'] = 'BigBlueButton-Aktivität';
$string['nosuchinstance'] = 'Keine Instanz {$a->entity} mit der ID {$a->id}';
$string['notification_instance_created_intro'] = 'Das BigBlueButton-Meeting <a href="{$a->link}">{$a->name}</a> wurde erstellt.';
$string['notification_instance_created_small'] = 'Neues BigBlueButton-Meeting {$a->name} wurde angelegt.';
$string['notification_instance_created_subject'] = 'Neues BigBlueButton-Meeting wurde angelegt.';
$string['notification_instance_description'] = 'Beschreibung';
$string['notification_instance_end_date'] = 'Endzeit';
$string['notification_instance_name'] = 'Name';
$string['notification_instance_start_date'] = 'Startzeit';
$string['notification_instance_updated_intro'] = 'Das BigBlueButton-Meeting <a href="{$a->link}">{$a->name}</a> wurde aktualisiert.';
$string['notification_instance_updated_small'] = 'Das BigBlueButton-Meeting {$a->name} wurde aktualisiert.';
$string['notification_instance_updated_subject'] = 'Das BigBlueButton-Meeting wurde aktualisiert.';
$string['notification_recording_ready_html'] = 'Die Aufzeichnung zum BigBlueButton-Meeting <a href="{$a->link}">{$a->name}</a> ist jetzt verfügbar.';
$string['notification_recording_ready_plain'] = 'Die Aufzeichnung zum BigBlueButton-Meeting {$a->name} ist jetzt verfügbar. Gehen Sie zu {$a->link}, um auf die Aufzeichnung zugreifen zu können.';
$string['notification_recording_ready_small'] = 'Die Aufzeichnung zum BigBlueButton-Meeting {$a->name} ist jetzt verfügbar.';
$string['notification_recording_ready_subject'] = 'Aufzeichnung verfügbar';
$string['opens'] = 'Öffnet';
$string['pluginadministration'] = 'BigBlueButton Administration';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'Um Meetings mit BigBlueButton anzulegen und daran teilzunehmen, müssen Nutzerdaten mit dem BigBlueButton-Server ausgetauscht werden.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'Vollständiger Name der Person, die auf den BigBlueButton-Server greift.';
$string['privacy:metadata:bigbluebutton:userid'] = 'Nutzer-ID der Person, die auf dem BigBlueButton-Server zugreift.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Konfiguration des BigBlueButton-Meetings';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Eine Liste von Regeln, die die Rolle definieren, die Personen im Live-Meeting übernehmen werden. Eine Nutzer-ID könnte gespeichert werden, da Berechtigungen pro Rolle oder pro Nutzer/in zugewiesen werden.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Angelegte Termine werden gespeichert, wenn das Plugin verwendet wird.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Art des Termins, der von der Person angelegt wurde.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'ID des Meetings, an dem die Person teilnehmen konnte';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Zusätzliche Informationen, die sich auf das Meeting oder die Aufzeichnung beziehen.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Zeit, zu der das Protokoll angelegt wurde';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'ID der Person, die den Termin eingerichtet hat';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'Metadaten zu den Aufzeichnungen werden gespeichert';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'Nutzer-ID der Person, die die Aufzeichnung zuletzt geändert hat';
$string['progress_createbigbluebuttonbn'] = 'Bigbluebutton-Aktivitäten wird erstellt ({$a})';
$string['recordingnotfound'] = 'Die Aufnahme wurde nicht gefunden.';
$string['recordings'] = 'Aufnahmen';
$string['recordings_from_deleted_activities'] = 'Aufzeichnungen von gelöschten Aktivitäten';
$string['recordingurlnotfound'] = 'Die Aufzeichnung-URL ist ungültig.';
$string['removedevents'] = 'Gelöschte Ereignisse';
$string['removedlogs'] = 'Nutzerdefinierte Protokolle gelöscht';
$string['removedrecordings'] = 'Gelöschte Aufzeichnungen';
$string['removedtags'] = 'Gelöschte Tags';
$string['report_join_info'] = 'Meetings: {$a}';
$string['report_play_recording_info'] = 'Aufzeichnungen abgespielt: {$a}';
$string['report_room_view'] = 'angezeigt';
$string['resetevents'] = 'Ereignisse löschen';
$string['resetlogs'] = 'Nutzerdefinierte Protokolle löschen';
$string['resetlogs_help'] = 'Das Löschen der Protokolle führt zum Verlust aller Verweise auf die Aufzeichnungen';
$string['resetrecordings'] = 'Aufzeichnungen löschen';
$string['resetrecordings_help'] = 'Das Löschen der Aufzeichnungen macht sie für alle unzugänglich. Diese Aktion kann nicht rückgängig gemacht werden.';
$string['resettags'] = 'Tags löschen';
$string['search:activity'] = 'BigBlueButton - Aktivitätsinformation';
$string['search:tags'] = 'BigBlueButton - Tagsinformation';
$string['sendnotification'] = 'Benachrichtigung senden';
$string['settings'] = 'BigBlueButton-Einstellungen';
$string['settings_credential_warning'] = 'Die Anmeldedaten für den BigBlueButton-Server laufen bald ab. Sehen Sie sich die <a href="{$a->settingslink}" target="_blank">BigBlueButton-Einstellungen (öffnet in neuem Fenster)</a> an.';
$string['settings_credential_warning_no_capability'] = 'Die Anmeldedaten für den BigBlueButton-Server laufen bald ab. Wenden Sie sich hierzu an die Administrator/innen Ihrer Website.';
$string['started_at'] = 'Gestartet';
$string['starts_at'] = 'Beginnt';
$string['subplugintype_bbbext'] = 'BigBlueButton-Erweiterung';
$string['subplugintype_bbbext_plural'] = 'BigBlueButton-Erweiterungen';
$string['taskname:check_dismissed_recordings'] = 'Nach Aufzeichnungen suchen, die bisher nicht gefunden wurden';
$string['taskname:check_pending_recordings'] = 'Ausstehende Aufzeichnungen abrufen';
$string['userlimitreached'] = 'Die maximale Anzahl der in einem Meeting zulässigen Nutzer/innen wurde erreicht.';
$string['view_conference_action_end'] = 'Meeting beenden';
$string['view_conference_action_join'] = 'Teilnehmen';
$string['view_error_action_not_completed'] = 'Aktion konnte nicht abgeschlossen werden';
$string['view_error_bigbluebutton'] = 'BigBlueButton zeigt Fehler an: {$a}';
$string['view_error_create'] = 'Der BigBlueButton-Server meldet einen Fehler. Das Meeting konnte nicht angelegt werden.';
$string['view_error_current_state_not_found'] = 'Der aktuelle Status wurde nicht gefunden. Die Aufzeichnung wurde möglicherweise gelöscht oder der BigBlueButton-Server ist nicht mit der ausgeführten Aktion kompatibel.';
$string['view_error_import_no_courses'] = 'Keine Kurse zum Suchen von Aufzeichnungen gefunden';
$string['view_error_import_no_recordings'] = 'In diesem Kurs gibt es keine Aufzeichnungen für den Import.';
$string['view_error_invalid_session'] = 'Die Sitzung ist abgelaufen. Gehen Sie zurück zur Aktivitätsseite.';
$string['view_error_max_concurrent'] = 'Die Anzahl der gleichzeitigen Meetings ist erreicht.';
$string['view_error_meeting_not_running'] = 'Fehler. Das Meeting läuft nicht.';
$string['view_error_no_group'] = 'Keine Gruppen verfügbar. Legen Sie Gruppen an, bevor Sie dem Meeting beitreten.';
$string['view_error_no_group_student'] = 'Sie sind in keiner Gruppe eingetragen. Wenden Sie sich an die Trainer/innen oder Administrator/innen.';
$string['view_error_no_group_teacher'] = 'Keine Gruppen verfügbar. Legen Sie Gruppen an oder wenden Sie sich an die Administrator/innen.';
$string['view_error_unable_join'] = 'Sie können auf das Meeting nicht zugreifen. Prüfen Sie die BigBlueButton-Server-URL. Stellen Sie außerdem sicher, dass der Server läuft.';
$string['view_error_unable_join_student'] = 'Die Verbindung zum BigBlueButton-Server ist nicht möglich.';
$string['view_error_unable_join_teacher'] = 'Die Verbindung zum BigBlueButton-Server ist nicht möglich. Wenden Sie sich an die Administrator/innen.';
$string['view_error_url_missing_parameters'] = 'Fehlende Parameter in der URL';
$string['view_error_userlimit_reached'] = 'Die maximale Teilnehmerzahl, die für ein Meeting erlaubt ist, wurde erreicht.';
$string['view_groups_nogroups_warning'] = 'Das Meeting wurde für die Verwendung von Gruppen konfiguriert, aber im Kurs sind keine Gruppen angelegt.';
$string['view_groups_notenrolled_warning'] = 'Der Raum wurde für die Verwendung von Gruppen konfiguriert, aber Sie sind keiner Gruppe zugewiesen.';
$string['view_groups_selection'] = 'Wählen Sie die Gruppe, der Sie beitreten möchten, und bestätigen Sie die Aktion.';
$string['view_groups_selection_join'] = 'Beitreten';
$string['view_groups_selection_warning'] = 'Für jede Gruppe gibt es einen Raum. Falls Sie Zugriff auf mehrere Räume haben, wählen Sie den richtigen Raum aus.';
$string['view_login_moderator'] = 'Als Moderator/in anmelden ...';
$string['view_login_viewer'] = 'Als Zuschauer/in anmelden...';
$string['view_message_and'] = 'und';
$string['view_message_conference_has_ended'] = 'Das Meeting ist beendet.';
$string['view_message_conference_in_progress'] = 'Das Meeting läuft gerade.';
$string['view_message_conference_not_started'] = 'Das Meeting hat noch nicht begonnen.';
$string['view_message_conference_room_ready'] = 'Der Raum ist fertig vorbereitet. Sie können jetzt am Meeting teilnehmen.';
$string['view_message_conference_user_limit_reached'] = 'Die maximale Teilnehmerzahl, die für ein Meeting erlaubt ist, wurde erreicht.';
$string['view_message_conference_wait_for_moderator'] = 'Sie können teilnehmen, wenn Moderator/innen beigetreten sind.';
$string['view_message_cron_disabled'] = 'Die Liste der Aufzeichnungen ist möglicherweise nicht auf dem neuesten Stand. Wenden Sie sich bitte mit den folgenden Informationen an Ihre Administrator/innen: {$a}';
$string['view_message_finished'] = 'Die Aktivität ist vorbei.';
$string['view_message_has_joined'] = 'hat teilgenommen';
$string['view_message_have_joined'] = 'nehmen teil';
$string['view_message_hour'] = 'Stunde';
$string['view_message_hours'] = 'Stunden';
$string['view_message_importrecordings_disabled'] = 'Der Import von Aufzeichnungslinks ist für diesen Server deaktiviert.';
$string['view_message_minute'] = 'Minute';
$string['view_message_minutes'] = 'Minuten';
$string['view_message_moderator'] = 'Moderator/in';
$string['view_message_moderators'] = 'Moderator/innen';
$string['view_message_norecordings'] = 'Für dieses Meeting gibt es keine Aufzeichnungen.';
$string['view_message_notavailableyet'] = 'Das Meeting ist noch nicht verfügbar.';
$string['view_message_recordings_disabled'] = 'Aufzeichnungen wurden für diesen Server deaktiviert. BigBlueButton-Instanzen vom Typ "Nur Aufzeichnungen" können nicht verwendet werden.';
$string['view_message_room_closed'] = 'Das Meeting ist geschlossen.';
$string['view_message_room_open'] = 'Das Meeting ist geöffnet.';
$string['view_message_room_ready'] = 'Der Raum ist fertig.';
$string['view_message_session_for'] = 'die Sitzung für';
$string['view_message_session_has_user'] = 'Es gibt';
$string['view_message_session_has_users'] = 'Es gibt';
$string['view_message_session_no_users'] = 'Niemand ist in diesem Meeting. :-(';
$string['view_message_session_running_for'] = 'Das Meeting lief';
$string['view_message_session_started_at'] = 'Das Meeting begann';
$string['view_message_tab_close'] = 'Dieses Fenster muss manuell geschlossen werden.';
$string['view_message_times'] = 'Mal';
$string['view_message_user'] = 'Nutzer/in';
$string['view_message_users'] = 'Nutzer/innen';
$string['view_message_viewer'] = 'Zuschauer/in';
$string['view_message_viewers'] = 'Zuschauer/innen';
$string['view_mobile_message_groups_not_supported'] = 'Diese Instanz ist für die Arbeit mit Gruppen aktiviert, aber die mobile App unterstützt dies noch nicht. Öffnen Sie bitte das Meeting im Browser.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Sie haben länger als 45 Sekunden auf dieser Seite gewartet. Laden Sie bitte die Seite neu, um dann an der Sitzung teilzunehmen.';
$string['view_noguests'] = 'Das BigBlueButton-Meeting ist nicht für Gäste geöffnet.';
$string['view_nojoin'] = 'Mit Ihrer Rolle dürfen Sie an diesem Meeting nicht teilnehmen.';
$string['view_recording'] = 'Aufzeichnung läuft ...';
$string['view_recording_actionbar'] = 'Werkzeuge';
$string['view_recording_activity'] = 'Aktivität';
$string['view_recording_button_import'] = 'Aufzeichnungslinks importieren';
$string['view_recording_button_return'] = 'Zurück';
$string['view_recording_course'] = 'Kurs';
$string['view_recording_date'] = 'Datum';
$string['view_recording_delete_confirmation'] = 'Möchten Sie die Aufzeichnung {$a} wirklich löschen?';
$string['view_recording_delete_confirmation_warning_p'] = 'Für diese Aufzeichnung wurden {$a} Links in unterschiedlichen Kursen und Aktivitäten angelegt. Wenn die Aufzeichnung gelöscht wird, werden diese Links ebenfalls entfernt.';
$string['view_recording_delete_confirmation_warning_s'] = 'Für diese Aufzeichnung wurde ein Link {$a} in einem anderen Kurs oder einer Aktivität angelegt. Wenn die Aufzeichnung gelöscht wird, wird dieser ebenfalls entfernt.';
$string['view_recording_description'] = 'Beschreibung';
$string['view_recording_description_edithint'] = 'Eine Beschreibung kann hinzugefügt werden, um die Aufzeichnung besser identifizieren zu können.';
$string['view_recording_description_editlabel'] = 'Beschreibung bearbeiten';
$string['view_recording_duration'] = 'Dauer';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'Die URL für dieses Aufzeichnungsformat ist nicht erreichbar.';
$string['view_recording_format_notes'] = 'Notizen';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'Präsentation';
$string['view_recording_format_screenshare'] = 'Bildschirmfreigabe';
$string['view_recording_format_statistics'] = 'Statistiken';
$string['view_recording_format_video'] = 'Video';
$string['view_recording_import_confirmation'] = 'Möchten Sie diese Aufzeichnung wirklich importieren?';
$string['view_recording_length'] = 'Länge';
$string['view_recording_link'] = 'Importierter Link';
$string['view_recording_link_warning'] = 'Dieser Link zeigt auf eine Aufzeichnung aus einem anderen Kurs oder einer anderen Aktivität.';
$string['view_recording_list_action_delete'] = 'Wird gelöscht';
$string['view_recording_list_action_edit'] = 'Wird aktualisiert';
$string['view_recording_list_action_play'] = 'Abspielen';
$string['view_recording_list_action_process'] = 'In Bearbeitung';
$string['view_recording_list_action_protect'] = 'Wird geschützt';
$string['view_recording_list_action_publish'] = 'Wird veröffentlicht';
$string['view_recording_list_action_unprotect'] = 'Wird ungeschützt';
$string['view_recording_list_action_unpublish'] = 'Wird unveröffentlicht';
$string['view_recording_list_action_update'] = 'Wird aktualisiert';
$string['view_recording_list_actionbar'] = 'Werkzeugleiste';
$string['view_recording_list_actionbar_delete'] = 'Löschen';
$string['view_recording_list_actionbar_edit'] = 'Bearbeiten';
$string['view_recording_list_actionbar_hide'] = 'Verbergen';
$string['view_recording_list_actionbar_import'] = 'Importieren';
$string['view_recording_list_actionbar_protect'] = 'Als "privat" kennzeichnen';
$string['view_recording_list_actionbar_publish'] = 'Veröffentlichen';
$string['view_recording_list_actionbar_show'] = 'Anzeigen';
$string['view_recording_list_actionbar_unprotect'] = 'Öffentlich machen';
$string['view_recording_list_actionbar_unpublish'] = 'Zurückziehen';
$string['view_recording_list_activity'] = 'Aktivität';
$string['view_recording_list_course'] = 'Kurs';
$string['view_recording_list_date'] = 'Datum';
$string['view_recording_list_description'] = 'Beschreibung';
$string['view_recording_list_duration'] = 'Dauer';
$string['view_recording_list_recording'] = 'Aufzeichnung';
$string['view_recording_meeting'] = 'Meeting';
$string['view_recording_modal_button'] = 'Zustimmen';
$string['view_recording_modal_title'] = 'Einstellungen für die Aufzeichnung festlegen';
$string['view_recording_name'] = 'Name';
$string['view_recording_name_edithint'] = 'Ein Name kann hinzugefügt werden, um die Aufzeichnung besser identifizieren zu können.';
$string['view_recording_name_editlabel'] = 'Name bearbeiten';
$string['view_recording_playback'] = 'Abspielen';
$string['view_recording_preview'] = 'Vorschau';
$string['view_recording_preview_help'] = 'Bewegen Sie die Maus über ein Bild, um es in voller Größe anzuzeigen';
$string['view_recording_protect_confirmation'] = 'Möchten Sie {$a} wirklich schützen?';
$string['view_recording_protect_confirmation_warning_p'] = 'Mit dieser Aufzeichnung sind {$a} Links verknüpft, die in unterschiedliche Kurse oder Aktivitäten importiert wurden. Wenn die Aufnahme geschützt ist, wirkt sich dies auch auf importierte Links aus.';
$string['view_recording_protect_confirmation_warning_s'] = 'Mit dieser Aufzeichnung ist ein Link {$a} verknüpft, der in einen anderen Kurs oder in eine Aktivität importiert wurde. Wenn die Aufnahme geschützt ist, wirkt sich dies auch auf importierte Links aus.';
$string['view_recording_publish_confirmation'] = 'Möchten Sie {$a} wirklich veröffentlichen?';
$string['view_recording_publish_confirmation_warning_p'] = 'Mit dieser Aufzeichnung sind Links {$a} verknüpft, die in unterschiedliche Kurse oder Aktivitäten importiert wurden. Wenn die Aufnahme veröffentlicht ist, werden diese Links ebenfalls veröffentlicht.';
$string['view_recording_publish_confirmation_warning_s'] = 'Mit dieser Aufzeichnung ist ein Link {$a} verknüpft, der in einen anderen Kurs oder in eine Aktivität importiert wurde. Wenn die Aufnahme veröffentlicht ist, werden diese Links ebenfalls veröffentlicht.';
$string['view_recording_publish_link_deleted'] = 'Dieser Link kann nicht neu veröffentlicht werden, da die Aufzeichnung im aktuellen BigBlueButton-Server nicht vorhanden ist. Der Link sollte entfernt werden.';
$string['view_recording_publish_link_not_published'] = 'Dieser Link kann nicht erneut veröffentlicht werden, da die Aufzeichnung zurückgezogen wurde.';
$string['view_recording_recording'] = 'Aufzeichnung';
$string['view_recording_select_course'] = 'Wählen Sie zuerst einen Kurs im Dropdown-Menü';
$string['view_recording_tags'] = 'Tags';
$string['view_recording_unprotect_confirmation'] = 'Möchten Sie den Schutz für {$a} wirklich aufheben?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'Mit dieser Aufzeichnung sind {$a} Links verknüpft, die in unterschiedliche Kurse oder Aktivitäten importiert wurden. Wenn der Schutz der Aufnahme aufgehoben wird, hat dies Auswirkungen auf die importierten Links.';
$string['view_recording_unprotect_confirmation_warning_s'] = 'Mit dieser Aufzeichnung ist ein Link {$a} verknüpft, der in einen anderen Kurs oder in eine Aktivität importiert wurde. Wenn der Schutz der Aufnahme aufgehoben wird, hat dies Auswirkungen auf die importierten Links.';
$string['view_recording_unprotect_link_deleted'] = 'Der Schutz dieses Links kann nicht aufgehoben werden, da die Aufzeichnung im aktuellen BigBlueButton-Server nicht vorhanden ist. Der Link sollte entfernt werden.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Der Schutz dieses Links kann nicht aufgehoben werden, da die Aufzeichnung geschützt ist.';
$string['view_recording_unpublish_confirmation'] = 'Möchten Sie die Veröffentlichung der Aufzeichnung {$a} wirklich zurückziehen?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Für diese Aufzeichnung wurden {$a} Links in unterschiedliche Kurse oder Aktivitäten importiert. Wenn die Aufzeichnung zurückgezogen wird, werden diese Links ebenfalls zurückgezogen.';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Für diese Aufzeichnung wurde ein Link {$a} in einem anderen Kurs oder in eine andere Aktivität importiert. Wenn die Aufzeichnung zurückgezogen wird, wird dieser Link ebenfalls zurückgezogen.';
$string['view_recording_yui_first'] = 'Erste';
$string['view_recording_yui_go'] = 'Los';
$string['view_recording_yui_last'] = 'Letzte';
$string['view_recording_yui_next'] = 'Nächste';
$string['view_recording_yui_page'] = 'Seite';
$string['view_recording_yui_prev'] = 'Vorherige';
$string['view_recording_yui_rows'] = 'Zeilen';
$string['view_recording_yui_show_all'] = 'Alle anzeigen';
$string['view_room'] = 'Meeting anzeigen';
$string['view_section_title_presentation'] = 'Präsentationsdatei';
$string['view_section_title_recordings'] = 'Aufzeichnungen';
$string['waitformoderator'] = 'Warten auf Moderator/in';
