<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_ollama', language 'de', version '5.1'.
 *
 * @package     aiprovider_ollama
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:explain_text:model'] = 'Texterklärungsmodell';
$string['action:explain_text:model_help'] = 'Das Modell wird verwendet, um bereitgestellten Text zu erklären.';
$string['action:explain_text:systeminstruction'] = 'Systemanweisung';
$string['action:explain_text:systeminstruction_help'] = 'Diese Anweisung wird zusammen mit der Nutzereingabe an das KI-Modell gesendet. Es wird nicht empfohlen, diese Anweisung zu bearbeiten, es sei denn, dies ist unbedingt erforderlich.';
$string['action:generate_text:model'] = 'Texterzeugungsmodell';
$string['action:generate_text:model_help'] = 'Das Modell wird verwendet, um die Textantwort zu generieren.';
$string['action:generate_text:systeminstruction'] = 'Systemanweisung';
$string['action:generate_text:systeminstruction_help'] = 'Diese Anweisung wird zusammen mit der Nutzereingabe an das KI-Modell gesendet. Es wird nicht empfohlen, diese Anweisung zu bearbeiten, es sei denn, dies ist unbedingt erforderlich.';
$string['action:summarise_text:model'] = 'Textzusammenfassungsmodell';
$string['action:summarise_text:model_help'] = 'Das Modell wird verwendet, um bereitgestellten Text zusammenzufassen.';
$string['action:summarise_text:systeminstruction'] = 'Systemanweisung';
$string['action:summarise_text:systeminstruction_help'] = 'Diese Anweisung wird zusammen mit der Nutzereingabe an das KI-Modell gesendet. Es wird nicht empfohlen, diese Anweisung zu bearbeiten, es sei denn, dies ist unbedingt erforderlich.';
$string['custom_model_name'] = 'Nutzerdefinierter Modellname';
$string['enablebasicauth'] = 'Basisauthentifizierung aktivieren';
$string['enablebasicauth_help'] = 'Basisauthentifizierung für die Ollama-API-Provider aktivieren';
$string['endpoint'] = 'API-Endpunkt';
$string['endpoint_help'] = 'Der API-Endpunkt für die Ollama-API-Server.';
$string['extraparams'] = 'Zusätzliche Parameter';
$string['extraparams_help'] = 'Es können zusätzliche Parameter konfiguriert werden. Wir unterstützen das JSON-Format. Hier ist ein Beispiel:
<pre>
{
"temperature": 0,5,
"max_tokens": 100
}
</pre>';
$string['invalidjson'] = 'Ungültiger JSON String';
$string['password'] = 'Kennwort';
$string['password_help'] = 'Das Kennwort wird für die Basisauthentifizierung verwendet.';
$string['pluginname'] = 'Ollama-API-Provider';
$string['privacy:metadata'] = 'Das Plugin "Ollama-API-Provider" speichert keine personenbezogenen Daten.';
$string['privacy:metadata:aiprovider_ollama:externalpurpose'] = 'Diese Informationen werden an die Ollama-API gesendet, um eine Antwort zu generieren. Ihre Ollama-Kontoeinstellungen können die Art und Weise ändern, wie Ollama diese Daten speichert und aufbewahrt. Dieses Plugin sendet explizit keine Nutzerdaten an Ollama oder speichert sie im Moodle LMS.';
$string['privacy:metadata:aiprovider_ollama:model'] = 'Das Modell wird verwendet, um die Antwort zu generieren.';
$string['privacy:metadata:aiprovider_ollama:prompttext'] = 'Die Nutzereingabe für den Promt, um die Antwort zu generieren.';
$string['settings'] = 'Einstellungen';
$string['settings_help'] = 'Passen Sie die folgenden Einstellungen an, um festzulegen, wie Anfragen an Ollama gesendet werden.';
$string['settings_mirostat'] = 'Mirostat';
$string['settings_mirostat_help'] = 'Mirostat ist ein neuronaler Textdekodierungsalgorithmus zur Kontrolle von Perplexität. 0 = deaktiviert, 1 = Mirostat, 2 = Mirostat 2.0. (Standard: 0)';
$string['settings_seed'] = 'seed';
$string['settings_seed_help'] = 'Zu verwendenden Zufallszahlen-Startwert für die Generierung festlegen. Wenn Sie diesen Wert auf einen bestimmten Wert setzen, generiert das Modell für dieselbe Eingabeaufforderung denselben Text. (Standard: 0)';
$string['settings_temperature'] = 'temperature';
$string['settings_temperature_help'] = 'Die Temperatur beeinflusst, ob die Ausgabe eher zufällig und kreativ oder eher vorhersehbar ist. Eine Erhöhung der Temperatur führt zu einer kreativeren Modellantwort. (Standard: 0,8)';
$string['settings_top_k'] = 'top_k';
$string['settings_top_k_help'] = 'Wahrscheinlichkeit reduzieren, Unsinn zu generieren. Ein höherer Wert (z.B. 100) führt zu vielfältigeren Antworten, während ein niedrigerer Wert (z.B. 10) konservativer ist. (Standard: 40)';
$string['settings_top_p'] = 'top_p';
$string['settings_top_p_help'] = 'Funktioniert mit top_k. Ein höherer Wert (z.B. 0,95) führt zu abwechslungsreicherem Text, während ein niedrigerer Wert (z.B. 0,5) fokussierteren und konservativeren Text erzeugt. (Standard: 0,9)';
$string['username'] = 'Anmeldename';
$string['username_help'] = 'Der Anmeldename wird für die Basisauthentifizierung verwendet.';
