<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'ru', version '5.1'.
 *
 * @package     lti
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Принимать';
$string['accept_grades'] = 'Принимать оценки от инструмента';
$string['accept_grades_admin'] = 'Принимать оценки от инструмента';
$string['accept_grades_admin_help'] = 'Определите, может ли провайдер инструмента добавлять, обновлять, читать и удалять оценки, связанные с экземплярами этого инструмента.

Некоторые провайдеры инструментов поддерживают передачу оценок обратно в Moodle, опираясь на действия, которые выполняются в инструменте, и создавая более тесную интеграцию.';
$string['accept_grades_from_tool'] = 'Разрешить элементу {$a} добавлять оценки в журнал оценок';
$string['accept_grades_help'] = 'Определите, может ли провайдер инструмента добавлять, обновлять, читать и удалять оценки, связанные только с этим экземпляром внешнего инструмента.

Некоторые провайдеры инструментов поддерживают передачу оценок обратно в Moodle, опираясь на действия, которые выполняются в инструменте, и создавая более тесную интеграцию.

Обратите внимание, что этот параметр может быть переопределен в настройках инструмента.';
$string['accepted'] = 'Принятые';
$string['action'] = 'Действие';
$string['activate'] = 'Активировать';
$string['activatetoadddescription'] = 'Вам необходимо активировать этот инструмент, после чего вы сможете добавить описание.';
$string['active'] = 'Активные';
$string['activity'] = 'Элемент курса';
$string['add_ltiadv'] = 'Добавить LTI Advantage';
$string['add_ltilegacy'] = 'Добавить устаревший LTI';
$string['addnewapp'] = 'Разрешить внешнее приложение';
$string['addserver'] = 'Добавить новый доверенный сервер';
$string['addtool'] = 'Добавить инструмент';
$string['addtype'] = 'Добавить предварительно настроенный инструмент';
$string['allow'] = 'Разрешить';
$string['allowsetting'] = 'Разрешить инструменту хранить в Moodle настройки - 8К';
$string['always'] = 'Всегда';
$string['autoaddtype'] = 'Добавить инструмент';
$string['automatic'] = 'Автоматически, на основе URL запуска';
$string['baseurl'] = 'Основной URL/имя регистрации инструмента';
$string['basiclti'] = 'LTI';
$string['basiclti_base_string'] = 'Основная строка аутентификации OAuth LTI';
$string['basiclti_endpoint'] = 'Конечная точка запуска LTI';
$string['basiclti_in_new_window'] = 'Элемент курса будет открыт в новом окне';
$string['basiclti_in_new_window_open'] = 'Открыть в новом окне';
$string['basiclti_parameters'] = 'Параметры запуска LTI';
$string['basicltiactivities'] = 'Элементы курса LTI';
$string['basicltifieldset'] = 'Пример пользовательского набора полей';
$string['basicltiintro'] = 'Описание элемента курса';
$string['basicltiname'] = 'Название элемента курса';
$string['basicltisettings'] = 'Основные настройки Взаимодействия инструментов обучения (LTI)';
$string['cachedef_keyset'] = 'Кэшировать информацию о наборе ключей инструментов';
$string['cancel'] = 'Отменить';
$string['cancelled'] = 'Отменено';
$string['capabilities'] = 'Возможности';
$string['capabilities_help'] = 'Выберите те возможности, которые Вы хотите предложить поставщику инструмента. Может быть выбрано несколько возможностей.';
$string['capabilitiesrequired'] = 'Для активации этого инструмента необходим доступ к следующим данным:';
$string['cleanaccesstokens'] = 'Удаление просроченных токенов доступа к внешнему инструменту';
$string['click_to_continue'] = '<a href="{$a->link}" target="_top">Нажмите для продолжения</a>';
$string['clientidadmin'] = 'ID клиента';
$string['clientidadmin_help'] = 'ID клиента - это уникальное значение, используемое для идентификации инструмента. Он создается автоматически для каждого инструмента, который использует профиль безопасности JWT, представленный в LTI 1.3, и должен быть частью деталей, передаваемых поставщику инструмента, чтобы они могли настроить соединение на своей стороне.';
$string['comment'] = 'Комментарий';
$string['configpassword'] = 'Пароль внешнего инструмента по умолчанию';
$string['configpreferheight'] = 'Предпочтительная высота по умолчанию';
$string['configpreferwidget'] = 'Установить как запуск по умолчанию';
$string['configpreferwidth'] = 'Предпочтительная ширина по умолчанию';
$string['configresourceurl'] = 'URL-адрес ресурса по умолчанию';
$string['configtoolurl'] = 'URL-адрес внешнего инструмента по умолчанию';
$string['configtypes'] = 'Разрешить приложения LTI';
$string['configured'] = 'Настроенные';
$string['confirmtoolactivation'] = 'Вы уверены, что хотите активировать этот инструмент?';
$string['contentitem_deeplinking'] = 'Поддерживает глубокие ссылки (сообщение элемента контента)';
$string['contentitem_deeplinking_help'] = 'Если отмечено, то при добавлении внешнего инструмента станет доступной опция «URL выбора контента» .';
$string['contentitem_multiple_description'] = 'К вашему курсу будут добавлены следующие элементы:';
$string['contentitem_multiple_graded'] = 'Оцениваемый элемент (максимальная оценка: {$a})';
$string['contentselected'] = 'Контент выбран';
$string['courseactivitiesorresources'] = 'Элементы курса или ресурсы';
$string['courseexternaltooladd'] = 'Добавить новый внешний инструмент LTI';
$string['courseexternaltooladdsuccess'] = '{$a}  добавлен.';
$string['courseexternaltooledit'] = '{$a}  изменен.';
$string['courseexternaltooleditsuccess'] = 'Изменения сохранены.';
$string['courseexternaltooliconalt'] = 'Значок для {$a}';
$string['courseexternaltools'] = 'Внешние инструменты LTI';
$string['courseexternaltoolsinfo'] = 'Внешние инструменты LTI — это дополнительные приложения, которые вы можете интегрировать в свой курс в виде интерактивного контента или оценок. Ваши студенты смогут получить к ним доступ и использовать их, не покидая ваш курс.';
$string['courseexternaltoolsnoeditpermissions'] = 'У вас недостаточно прав для редактирования этого инструмента';
$string['courseexternaltoolsnoviewpermissions'] = 'Просматривать внешние инструменты курса';
$string['courseid'] = 'ID курса';
$string['courseinformation'] = 'Информация о курсе';
$string['courselink'] = 'Перейти в курс';
$string['coursemisconf'] = 'Курс не настроен';
$string['coursetooldeleted'] = '{$a} удален';
$string['createdon'] = 'Создан';
$string['curllibrarymissing'] = 'Для использования LTI должна быть установлена библиотека PHP Curl';
$string['custom'] = 'Пользовательские параметры';
$string['custom_help'] = 'Пользовательские параметры настройки, используемые поставляемым инструментом. Например, пользовательский параметр может быть использован для отображения определенного поставляемого ресурса.  Каждый параметр должен быть введен на отдельной строке с использованием формата «name=value» («имя=значение»); например, «глава=3».

Можно безопасно оставить это поле без изменений, если нет указаний поставщика инструмента.';
$string['custominstr'] = 'Пользовательские параметры';
$string['debuglaunch'] = 'Параметры отладки';
$string['debuglaunchoff'] = 'Нормальный запуск';
$string['debuglaunchon'] = 'Запуск отладки';
$string['default'] = 'По умолчанию';
$string['default_launch_container'] = 'Контейнер для запуска инструмента по умолчанию';
$string['default_launch_container_help'] = 'Запуск инструмента влияет на его отображение при запуске из курса. Некоторые запуски обеспечивают более реальное отображение состояния инструмента, а другие обеспечивают большее объединение с интерфейсом Moodle.

* **По умолчанию** - используется вид запуска, указанный в настройках инструмента.

* **Встроить** - инструмент отображается в существующем окне Moodle, подобно большинству других элементов курса.

* **Встроить (без блоков)** - инструмент отображается в существующем окне Moodle с управлением навигацией в верхней части страницы.

* **В новом окне** - инструмент открывается в новом окне, занимая все свободное пространство. В зависимости от браузера, он откроется в новой вкладке или новом окне. Вполне возможно, что браузер будет препятствовать открытию нового окна.';
$string['delegate'] = 'Делегировать учителю';
$string['delegate_tool'] = 'Как указано в определении Глубокой ссылки или делегировать учителю';
$string['delete'] = 'Удалить';
$string['delete_confirmation'] = 'Вы действительно хотите удалить этот предварительно настроенный инструмент?';
$string['deletecoursetool'] = 'Удалить {$a}';
$string['deletecoursetoolconfirm'] = 'Это удалит {$a} из доступных инструментов LTI в вашем курсе.';
$string['deletecoursetoolwithusageconfirm'] = 'В настоящее время {$a} используется как минимум один раз в вашем курсе. При удалении этого инструмента, элементы, в которых он используется, перестанут работать.<br><br>Вы действительно хотите удалить {$a}?';
$string['display_description'] = 'Отображать описание элемента, когда студенты получают доступ к инструменту';
$string['display_description_help'] = 'Контент этого инструмента отображается встроенным в страницу курса. Этот параметр определяет, отображается ли описание элемента на этой странице.';
$string['display_name'] = 'Отображать название элемента, когда студенты получают доступ к инструменту';
$string['display_name_help'] = 'Контент этого инструмента отображается встроенным в страницу курса. Этот параметр определяет, отображается ли название элемента на этой странице.';
$string['donot'] = 'Не отправлено';
$string['donotaccept'] = 'Не принято';
$string['donotallow'] = 'Не разрешено';
$string['dontshowinactivitychooser'] = 'Не показывать в выборе элементов';
$string['duplicateregurl'] = 'Этот URL регистрации уже используется';
$string['dynreg_update_btn_new'] = 'Регистрировать как новый внешний инструмент';
$string['dynreg_update_btn_update'] = 'Обновить';
$string['dynreg_update_name'] = 'Название инструмента';
$string['dynreg_update_notools'] = 'Нет инструментов в этом контексте.';
$string['dynreg_update_text'] = 'За доменом регистрации закреплены существующие инструменты. Вы хотите обновить уже установленный внешний инструмент или создать новый?';
$string['dynreg_update_url'] = 'Базовый URL';
$string['dynreg_update_version'] = 'Версия LTI';
$string['dynreg_update_warn_dupdomain'] = 'Не рекомендуется иметь несколько внешних инструментов в одном домене.';
$string['editdescription'] = 'Щелкните здесь, что задать описание этому инструменту';
$string['editmanualinstancedeprecationwarning'] = 'Внешние инструменты, настроенные вручную, больше не поддерживаются. Не волнуйтесь, эти активные элементы по-прежнему будут работать, но вы больше не сможете вносить здесь изменения в конфигурацию инструмента.
<br><br>
Чтобы внести какие-либо изменения в инструмент или создать с его помощью новые активные элементы, инструмент необходимо добавить в курс в разделе «Курс» > «Дополнительно» > «Внешние инструменты LTI». После этого вы сможете создавать новые активные элементы, выбирая инструмент непосредственно в списке элементов.
<br><br>
Подробнее о добавлении внешних инструментов LTI можно прочитать в документации <a href="{$a}" target="_blank">Внешний инструмент</a>.';
$string['embed'] = 'Встроить';
$string['embed_no_blocks'] = 'Встроить (без блоков)';
$string['enableemailnotification'] = 'Отправлять уведомления по электронной почте';
$string['enableemailnotification_help'] = 'При включенном параметре студенты будут получать уведомление по электронной почте при оценивании их работ.';
$string['enterkeyandsecret'] = 'Введите свой ключ клиента и общий секретный ключ';
$string['enterkeyandsecret_help'] = 'Введите здесь полученный пользовательский ключ и/или общий ключ.';
$string['entitycourseexternaltools'] = 'Внешние инструменты LTI';
$string['errorbadurl'] = 'URL не является правильным URL инструмента или картриджа.';
$string['errorincorrectconsumerkey'] = 'Неправильный ключ пользователя';
$string['errorinvaliddata'] = 'Неверные данные: {$a}';
$string['errorinvalidmediatype'] = 'Недопустимый тип медиа данных: {$a}';
$string['errorinvalidresponseformat'] = 'Недопустимый формат ответа Content-Item.';
$string['errormisconfig'] = 'Инструмент не настроен. Обратитесь к администратору Moodle, чтобы исправить настройки инструмента.';
$string['errortooltypenotfound'] = 'Тип инструмента LTI не найден.';
$string['existing_window'] = 'Имеющееся окно';
$string['extensions'] = 'Сервисы расширения LTI';
$string['external_tool_type'] = 'Предварительно настроенный инструмент';
$string['external_tool_type_help'] = '* **Автоматически, на основе URL-адреса запуска** — этот параметр следует использовать почти во всех случаях. Moodle будет выбирать наиболее подходящие настройки инструмента на основе URL-адреса запуска. Будут использоваться инструменты, которые были настроены администратором или в этом курсе. Когда указан URL-адрес запуска, Moodle будет обеспечивать обратную связь независимо от того, распознает он этот адрес или нет. Если Moodle не распознает URL-адрес запуска, вам нужно вручную ввести настройки инструмента.

* **Конкретный предварительно настроенный инструмент** — Выбирая предварительно настроенный инструмент, вы можете заставить Moodle использовать эту настройку инструмента при связи с провайдером внешнего инструмента. Если URL-адрес запуска выглядит не принадлежащим провайдеру инструмента, то будет показано предупреждение. В некоторых случаях не обязательно вводить URL-адрес запуска при предоставлении конкретного предварительно настроенного инструмента (если не запускается конкретный ресурс у провайдера инструмента).

* **Пользовательские настройки** — Для задания  пользовательских настроек только для этого экземпляра инструмента, откройте расширенные параметры и введите  ключ клиента и общий секретный ключ. Если у вас нет ключа клиента и  общего секретного ключа, вы можете запросить их у провайдера инструмента. Не все инструменты требуют ключ клиента и общий секретный ключ, в таком случае эти поля можно оставить пустыми.

 ### Редактирование предварительно настроенного инструмента

Вам доступны три значка рядом с выпадающим списком «Предварительно настроенный инструмент»:

* **Добавить** — создать настройку инструмента на уровне курса. Все экземпляры внешнего инструмента в этом курсе могут использовать эту настройку инструмента.

* **Редактировать** — выберите инструмент на уровне курса из выпадающего списка, а затем щелкните этот значок. Параметры настроек инструмента могут быть отредактированы.

* **Удалить** — удалить выбранный инструмент на уровне курса.';
$string['external_tool_types'] = 'Предварительно настроенные инструменты';
$string['failedtoconnect'] = 'Moodle не может общаться с системой «{$a}»';
$string['failedtocreatetooltype'] = 'Не удалось создать новый инструмент. Пожалуйста, проверьте URL и попробуйте еще раз.';
$string['failedtodeletetoolproxy'] = 'Не удалось удалить регистрацию инструмента. Вам нужно будет зайти в «Управление регистрациями внешних инструментов» и удалить ее вручную.';
$string['filter_basiclti_configlink'] = 'Настройка предпочтительных сайтов и их паролей';
$string['filter_basiclti_password'] = 'Пароль обязателен';
$string['filterconfig'] = 'Управление LTI';
$string['filtername'] = 'LTI';
$string['fixexistingconf'] = 'Использовать существующие настройки для ненастроенного инструмента.';
$string['fixnew'] = 'Новая конфигурация';
$string['fixnewconf'] = 'Определить новые настройки для ненастроенного инструмента.';
$string['fixold'] = 'Использовать существующую';
$string['force_ssl'] = 'Принудительно использовать SSL';
$string['force_ssl_help'] = 'Выбор этого параметра принуждает использовать SSL при всех запусках поставляемого инструмента. Кроме того, все запросы веб-служб от поставщика инструмента будут использовать SSL. При использовании этого параметра убедитесь, что этот сайт Moodle и поставщик инструмента поддерживают SSL.';
$string['generaltool'] = 'Общий инструмент';
$string['grading'] = 'Передача оценок';
$string['icon_url'] = 'URL-адрес значка';
$string['icon_url_help'] = 'Этот параметр определяет значок, который используется для этого элемента курса в перечне элементов курса. Вместо используемого по умолчанию значка внешнего инструмента можно задать значок, который более точно определяет тип элемента курса.';
$string['id'] = 'ID';
$string['indicator:cognitivedepth'] = 'LTI: познавательный аспект';
$string['indicator:cognitivedepth_help'] = 'Этот показатель основан на глубине познания, достигнутой студентом при работе с элементом курса «LTI».';
$string['indicator:cognitivedepthdef'] = 'LTI: познавательный аспект';
$string['indicator:cognitivedepthdef_help'] = 'Участник достиг этого процента познавательного взаимодействия, предлагаемого элементом курса «Лекция» в течение этого интервала анализа (Уровни = Нет просмотра, Просмотр, Отправка, Просмотр отзыва)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'LTI: социальный аспект';
$string['indicator:socialbreadth_help'] = 'Этот показатель основан на широте общения, которая может быть достигнута студентом при работе с элементом  LTI.';
$string['indicator:socialbreadthdef'] = 'LTI: социальный аспект';
$string['indicator:socialbreadthdef_help'] = 'Участник достиг этого процента социальной активности, предлагаемой элементами LTI в течение этого интервала анализа (Уровни = нет участия, единственный участник, участник с другими)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['initiatelogin'] = 'URL-адрес инициирования входа';
$string['initiatelogin_help'] = 'URL-адрес инструмента, на который должны быть отправлены запросы на инициирование входа в систему. Этот URL-адрес требуется до того, как сообщение может быть отправлено в инструмент.';
$string['invalidid'] = 'Некорректный ID LTI';
$string['jwtsecurity'] = 'LTI 1.3';
$string['keytype'] = 'Тип открытого ключа';
$string['keytype_help'] = 'Метод аутентификации, используемый для проверки инструмента.';
$string['keytype_keyset'] = 'URL-адрес набора ключей';
$string['keytype_rsa'] = 'Ключ RSA';
$string['launch_in_moodle'] = 'Запускать инструмент в Moodle';
$string['launch_in_popup'] = 'Запускать инструмент в всплывающем окне';
$string['launch_url'] = 'URL-адрес инструмента';
$string['launch_url_help'] = 'URL запуска указывает веб-адрес внешнего инструмента и может содержать дополнительную информацию, например о том, как отображать этот ресурс.
Если вы не уверены в том, что нужно ввести в URL запуска, то свяжитесь с провайдером инструмента для получения дополнительной информации.
Вы также можете ввести URL картриджа, если он у вас есть, и остальные поля формы будут заполнены автоматически.

Если вы выбрали предварительно настроенный инструмент, вам может не потребоваться вводить URL запуска. Например в случае, если ссылка инструмента используется только для запуска в системе провайдера инструмента и не ведет к определенному ресурсу.';
$string['launchinpopup'] = 'Контейнер запуска';
$string['launchinpopup_help'] = 'Вид запуска влияет на отображение инструмента при запуске из курса. Некоторые виды запуска обеспечивают на экране более реальное состояние для инструмента, а другие обеспечивают более комплексную интеграцию с окружением Moodle.

* **По умолчанию** - используется вид запуска, указанный в настройках инструмента.

* **Встроить** - инструмент отображается в существующем окне Moodle, подобно большинству других типов элементов курса.
.
* **Встроить (без блоков)** - инструмент отображается в существующем окне Moodle с управлением навигацией в верхней части страницы.

* **В новом окне** - инструмент открывается в новом окне, занимая все свободное пространство.
В зависимости от используемого браузера, он откроется в новой вкладке или новом окне.
Вполне возможно, что браузер будет препятствовать открытию нового окна.';
$string['launchoptions'] = 'Параметры запуска';
$string['lti'] = 'LTI';
$string['lti:addcoursetool'] = 'Добавлять конфигурации инструмента конкретного курса';
$string['lti:addinstance'] = 'Добавлять новые внешние инструменты';
$string['lti:addmanualinstanceprohibitederror'] = 'Создание инструментов вручную без определения инструмента курса больше не поддерживается. Сначала создайте инструмент курса, а затем используйте его для создания экземпляров активных элементов.';
$string['lti:addpreconfiguredinstance'] = 'Добавлять предварительно настроенный инструмент';
$string['lti:admin'] = 'Быть администратором при запуске инструмента';
$string['lti:grade'] = 'Просматривать оценки, возвращенные внешним инструментом';
$string['lti:manage'] = 'Быть преподавателем запущенного инструмента';
$string['lti:requesttooladd'] = 'Запрашивать инструменты для конфигурации сайта';
$string['lti:view'] = 'Запускать внешний инструмент';
$string['lti_administration'] = 'Редактировать предварительно настроенный инструмент';
$string['lti_errormsg'] = 'Приложение вернуло следующее сообщение об ошибке: «{$a}»';
$string['lti_launch_error'] = 'При запуске внешнего инструмента произошла ошибка:';
$string['lti_launch_error_tool_request'] = '<p>Чтобы подать заявку администратору для завершения настройки инструмента, <a href="{$a->admin_request_url}" target="_top">щелкните здесь</a>. </p>';
$string['lti_launch_error_unsigned_help'] = '<p>Эта ошибка может быть следствием отсутствия абонентского ключа и общего ключа для поставляемого инструмента. </p> <p> Если у Вас есть абонентский ключ и общий секретный ключ, то Вы можете ввести его при редактировании внешнего инструмента (убедитесь, что дополнительные параметры отображаются). <br /> Кроме того, Вы можете <a href="{$a->course_tool_editor}">создать конфигурацию поставляемого инструмента на уровне курса</a>. </p>';
$string['lti_tool_request_added'] = 'Запрос на конфигурацию инструмента отправлен. Возможно, Вам придется обратиться к администратору для завершения конфигурации инструмента.';
$string['lti_tool_request_existing'] = 'Конфигурация инструмента для  домена уже представлена.';
$string['ltisettings'] = 'Настройки LTI';
$string['ltiunknownserviceapicall'] = 'Вызов API неизвестного сервиса LTI.';
$string['ltiversion'] = 'Версия LTI';
$string['ltiversion_help'] = 'Версия LTI, используемая для подписи сообщений и запросов на обслуживание: LTI 1.0/1.1 и LTI 2.0 используют профиль безопасности OAuth 1.0A; LTI 1.3.0 использует JWT.';
$string['main_admin'] = 'Общая справка';
$string['main_admin_help'] = 'Внешние инструменты позволяют пользователям Moodle легко взаимодействовать с  учебными ресурсами, расположенными на внешних серверах. Через специальный протокол запуска, внешний инструмент будет иметь доступ к некоторой общей информации о запускающем пользователе. Например, название учреждения, идентификатор курса, идентификатор пользователя и другая информация, такая как имя пользователя или адрес электронной почты.

Инструменты, перечисленные на этой странице, разделены на три категории:

* **Активные** — эти поставщики инструментов были одобрены и настроены администратором. Они могут быть использованы в любом курсе этого сайта Moodle. Если вводятся ключ клиента и общий секретный ключ, то между этим сайтом Moodle и внешним инструментом по защищенному каналу связи устанавливаются доверительные отношения.
* **Ожидаемые** — эти поставщики инструментов были  импортированы из пакета, но не были настроены администратором. Учителя все еще могут использовать этих поставщиков, если они знают ключ клиента и общий секретный ключ, или если эти ключи не требуются.
* **Отклоненные** — так помечаются те поставщики инструментов, которые администратор не намерен делать доступными для всего сайта Moodle. Учителя все еще могут использовать инструменты от этих поставщиков, если у них есть ключ клиента и общий секретный ключ, или если эти ключи не требуются.';
$string['manage_external_tools'] = 'Управление инструментами';
$string['manage_tool_proxies'] = 'Управление регистрациями внешних инструментов';
$string['manage_tools'] = 'Управление предварительно настроенными инструментами';
$string['manuallyaddtype'] = 'В качестве альтернативного варианта вы можете <a href="{$a}">настроить инструмент вручную</a>.';
$string['miscellaneous'] = 'Разное';
$string['misconfiguredtools'] = 'Обнаружены ненастроенные экземпляры инструмента';
$string['missingparameterserror'] = 'Страница не настроена: «{$a}»';
$string['module_class_type'] = 'Тип модуля Moodle';
$string['modulename'] = 'Внешний инструмент';
$string['modulename_help'] = 'Модуль элемента курса «Внешний инструмент» позволяет студентам взаимодействовать с обучающими ресурсами и элементами курса на других веб-сайтах. Например, внешний инструмент может обеспечить доступ к новому типу деятельности или учебным материалам.

Для создания элемента «Внешний инструмент» требуется инструмент поставщика, который поддерживает LTI (Learning Tools Interoperability - Совместимые средства обучения) . Преподаватель может создать элемент курса внешний инструмент или использовать инструмент, настроенный администратором сайта.

Элемент курса «Внешний инструмент» отличается от ресурсов «Гиперссылка» несколькими особенностями:

* Внешние инструменты контекстные, то есть им доступна информация о запустившем инструмент пользователе - такие как организация, курс, имя.
* Внешние инструменты поддерживают чтение, обновление и удаление оценок, связанных с экземпляром активного элемента.
* Конфигурация внешних инструментов создает доверительные отношения между вашим сайтом и поставщиком инструмента, что обеспечивает безопасную связь между ними.';
$string['modulename_link'] = 'mod/lti/view';
$string['modulenameplural'] = 'Внешние инструменты';
$string['modulenamepluralformatted'] = 'Внешние инструменты';
$string['name'] = 'Название';
$string['never'] = 'Никогда';
$string['new_window'] = 'Новое окно';
$string['no_lti_configured'] = 'Нет настроенных активных внешних инструментов.';
$string['no_lti_pending'] = 'Нет ожидаемых внешних инструментов.';
$string['no_lti_rejected'] = 'Нет отклоненных внешних инструментов.';
$string['no_lti_tools'] = 'Нет настроенных внешних инструментов.';
$string['no_tp_accepted'] = 'Нет принятых регистраций внешних инструментов.';
$string['no_tp_cancelled'] = 'Нет отклоненных регистраций внешних инструментов.';
$string['no_tp_configured'] = 'Нет настроенных незарегистрированных регистраций внешних инструментов.';
$string['no_tp_pending'] = 'Нет ожидающих регистраций внешних инструментов.';
$string['no_tp_rejected'] = 'Нет отклоненных регистраций внешних инструментов.';
$string['noattempts'] = 'Нет попыток с использованием этого инструмента';
$string['nocourseexternaltoolsnotice'] = 'Внешних инструментов LTI пока нет';
$string['noltis'] = 'Нет используемых внешних инструментов';
$string['noprofileservice'] = 'Служба профиля не найдена';
$string['noservers'] = 'Сервер не найден';
$string['notypes'] = 'В настоящее время в Moodle не установлены инструменты LTI. Чтобы добавить их, нажмите выше ссылку Установить.';
$string['noviewusers'] = 'Нет пользователей с правом использовать этот инструмент.';
$string['oauthsecurity'] = 'LTI 1.0/1.1';
$string['opensslconfiginvalid'] = 'LTI 1.3 требует, чтобы действующий openssl.cnf был настроен и доступен для вашего веб-сервера. Обратитесь к администратору сайта, чтобы он настроил и включил openssl для этого сайта.';
$string['optionalsettings'] = 'Дополнительные настройки';
$string['organization'] = 'Подробности организации';
$string['organizationdescr'] = 'Описание организации';
$string['organizationid_default'] = 'ID организации по умолчанию';
$string['organizationid_default_help'] = 'Значение по умолчанию для ID организации. ID сайта идентифицирует эту установку Moodle.';
$string['organizationidguid'] = 'ID организации';
$string['organizationidguid_help'] = 'Уникальный идентификатор этого экземпляра Moodle, переданный инструменту как GUID экземпляра платформы.

Если это поле оставить пустым, будет использоваться значение по умолчанию.';
$string['organizationurl'] = 'URL-адрес организации';
$string['organizationurl_help'] = 'Основной URL-адрес этого сайта Moodle. Если оставить это поле пустым, то по умолчанию будет использоваться значение конфигурации сайта.';
$string['pagesize'] = 'Представлений на странице';
$string['parameter'] = 'Параметры инструмента';
$string['parameter_help'] = 'Параметры инструмента — это настройки, которые требует передать поставщик инструмента в доверенности принятого инструмента.';
$string['password'] = 'Общий секретный ключ';
$string['password_admin'] = 'Общий секретный ключ';
$string['password_admin_help'] = 'Общий секретный ключ можно рассматривать как пароль для доступа к инструменту. Он должен быть предоставлен поставщиком инструмента вместе с абонентским ключом. Инструменты, которые не требуют безопасной связи с Moodle и не предоставляют дополнительные услуги (такие, как отчеты об оценках) могут не требовать общий ключ.';
$string['password_help'] = 'Для предварительно настроенных инструментов не стоит вводить здесь общий секретный ключ. Он будет задан в процессе настройки. Это поле должно быть заполнено, если создается ссылка на поставляемый инструмент, который еще не настроен. Если поставляемый инструмент будет использоваться более одного раза в этом курсе, то имеет смысл добавить в курс конфигурацию этого инструмента. Общий ключ можно рассматривать как пароль для доступа к инструменту. Он должен быть предоставлен поставщиком инструмента вместе с абонентским ключом. Инструменты, которые не требуют безопасной связи с Moodle и не предоставляют дополнительные услуги (такие, как отчеты об оценках) могут не требовать общий ключ.';
$string['pending'] = 'Ожидаемые';
$string['pluginadministration'] = 'Управление внешним инструментом';
$string['pluginname'] = 'Внешний инструмент';
$string['preferheight'] = 'Предпочтительная высота';
$string['preferwidget'] = 'Предпочтителен запуск в виде виджета';
$string['preferwidth'] = 'Предпочтительная ширина';
$string['press_to_submit'] = 'Нажмите, чтобы запустить этот элемент';
$string['privacy'] = 'Секретность';
$string['privacy:metadata:coursefullname'] = 'Полное название курса, из которого пользователь получает доступ к LTI.';
$string['privacy:metadata:courseid'] = 'ID курса, из которого пользователь получает доступ к LTI.';
$string['privacy:metadata:courseidnumber'] = 'ID номер курса, из которого пользователь получает доступ к LTI.';
$string['privacy:metadata:courseshortname'] = 'Краткое название курса, из которого пользователь получает доступ к LTI.';
$string['privacy:metadata:createdby'] = 'Пользователь, создавший запись';
$string['privacy:metadata:email'] = 'Адрес электронной почты пользователя, осуществляющего доступ к LTI.';
$string['privacy:metadata:externalpurpose'] = 'Потребитель LTI предоставляет информацию о пользователе и контексте поставщику инструментов LTI.';
$string['privacy:metadata:firstname'] = 'Имя пользователя, осуществляющего доступ к LTI.';
$string['privacy:metadata:fullname'] = 'Полное имя пользователя, осуществляющего доступ к потребителю LTI.';
$string['privacy:metadata:lastname'] = 'Фамилия пользователя, осуществляющего доступ к потребителю LTI.';
$string['privacy:metadata:lti_submission'] = 'Представление LTI';
$string['privacy:metadata:lti_submission:datesubmitted'] = 'Отметка времени, указывающая, когда был отправлен ответ.';
$string['privacy:metadata:lti_submission:dateupdated'] = 'Отметка времени, указывающая, когда был изменен ответ.';
$string['privacy:metadata:lti_submission:gradepercent'] = 'Оценка пользователя в процентах';
$string['privacy:metadata:lti_submission:originalgrade'] = 'Исходная оценка для пользователя';
$string['privacy:metadata:lti_submission:userid'] = 'ID пользователя, который отправил ответ на задание внешнего инструмента';
$string['privacy:metadata:lti_tool_proxies'] = 'Прокси LTI';
$string['privacy:metadata:lti_tool_proxies:name'] = 'Имя прокси LTI';
$string['privacy:metadata:lti_types'] = 'Типы LTI';
$string['privacy:metadata:lti_types:name'] = 'Название типа LTI';
$string['privacy:metadata:role'] = 'Роль в курсе для пользователя, получающего доступ к LTI';
$string['privacy:metadata:timecreated'] = 'Время создания записи';
$string['privacy:metadata:timemodified'] = 'Время изменения записи';
$string['privacy:metadata:userid'] = '';
$string['privacy:metadata:useridnumber'] = 'ID номер пользователя, осуществляющего доступ к LTI.';
$string['privacy:metadata:username'] = 'Логин пользователя, осуществляющего доступ к LTI.';
$string['publickey'] = 'Открытый ключ';
$string['publickey_help'] = 'Открытый ключ (в формате PEM), предоставляемый инструментом, позволяющий проверять подписи входящих сообщений и запросов на обслуживание.';
$string['publickeyset'] = 'Открытый набор ключей';
$string['publickeyset_help'] = 'Открытый набор ключей, из которого этот сайт будет извлекать открытый ключ инструмента, позволяющий проверять подписи входящих сообщений и запросов на обслуживание.';
$string['quickgrade'] = 'Разрешить быстрое оценивание';
$string['quickgrade_help'] = 'При включенном параметре несколько средств могут быть оценены на одной странице. Добавив оценки и комментарии, нажмите кнопку «Сохранить все мои отзывы» для сохранения всех изменений.';
$string['redirect'] = 'Вы будете перенаправлены через несколько секунд. Если этого не происходит, то нажмите кнопку..';
$string['redirectionuris'] = 'URI перенаправления';
$string['redirectionuris_help'] = 'Список URI (по одному в строке), которые инструмент использует при запросах авторизации. По крайней мере, один из них должен быть зарегистрирован, прежде чем сообщение может быть успешно отправлено в инструмент.';
$string['register'] = 'Зарегистрировать';
$string['register_warning'] = 'Для открытия страницы регистрации может понадобиться некоторое время. Если она не открывается, убедитесь, что в параметрах конфигурации введен правильный URL-адрес. Если Moodle использует https, убедитесь, что настраиваемый вами инструмент поддерживает https и вы используете https в URL.';
$string['registertype'] = 'Настроить регистрацию нового внешнего инструмента';
$string['registration_options'] = 'Параметры регистрации';
$string['registrationname'] = 'Имя поставщика инструмента';
$string['registrationname_help'] = 'Введите имя поставщика регистрируемого инструмента';
$string['registrationurl'] = 'URL-адрес регистрации';
$string['registrationurl_help'] = 'URL регистрации должен быть доступен у поставщика инструмента как адрес, на который должны отправляться запросы на регистрацию.';
$string['reject'] = 'Отклонить';
$string['rejected'] = 'Отклоненные';
$string['resource'] = 'Ресурс';
$string['resourcekey'] = 'Ключ клиента';
$string['resourcekey_admin'] = 'Ключ клиента';
$string['resourcekey_admin_help'] = 'Абонентский ключ можно рассматривать в качестве имени пользователя, использующегося для аутентификации доступа к инструменту.
Он может быть использован поставщиком инструмента для однозначной идентификации сайта Moodle, с которого пользователь запускает инструмент.

Абонентский ключ должен быть представлен поставщиком инструмента. Способ получения абонентского ключа зависит от поставщика инструмента. Это может быть автоматизированный процесс, или он может потребовать диалога с поставщиком инструмента.

Инструменты, которые не требуют безопасной связи с Moodle и не предоставляют дополнительные услуги (такие, как отчеты об оценках) могут не требовать ключ ресурса.';
$string['resourcekey_help'] = 'Для предварительно настроенного инструмента не стоит вводить здесь ключ ресурса. Он будет задан в процессе настройки как абонентский ключ.

Это поле должно быть заполнено, если создается ссылка на поставляемый инструмент, который еще не настроен. Если поставляемый инструмент будет использоваться более одного раза в этом курсе, то имеет смысл добавить в курс конфигурацию этого инструмента.
Абонентский ключ можно рассматривать как имя пользователя, использующееся для аутентификации доступа к инструменту.
Он может быть использован поставщиком инструмента для однозначной идентификации сайта Moodle, с которого пользователь запускает инструмент.

Абонентский ключ должен быть представлен поставщиком инструмента. Способ получения абонентского ключа зависит от поставщика инструмента. Это может быть автоматизированный процесс, или он может потребовать диалога с поставщиком инструмента.

Инструменты, которые не требуют безопасной связи с Moodle и не предоставляют дополнительные услуги (такие, как отчеты об оценках) могут не требовать ключ ресурса.';
$string['resourceurl'] = 'URL-адрес ресурса';
$string['restricttocategory'] = 'Ограничить категорией';
$string['restricttocategory_help'] = 'Чтобы ограничить использование этого инструмента курсами внутри категории, выберите категорию(и) из списка.';
$string['return_to_course'] = 'Щелкните<a href="{$a->link}" target="_top">здесь</a> для возвращения в курс.';
$string['saveallfeedback'] = 'Сохранить все мои отзывы';
$string['search:activity'] = 'Внешний инструмент — информация об элементе';
$string['secure_icon_url'] = 'URL-адрес значка защищенного запуска';
$string['secure_icon_url_help'] = 'Подобен URL-адресу значка, но используется в случае доступа пользователя к Moodle через защищенное соединение SSL. Это предотвратит появление предупреждения браузера при запросе показа незащищенного изображения.';
$string['secure_launch_url'] = 'Безопасный URL-адрес инструмента';
$string['secure_launch_url_help'] = 'Подобен URL-адресу инструмента, но используется вместо него при необходимости высокого уровня безопасности. Moodle будет использовать безопасный URL-адрес вместо URL-адреса, если сайт Moodle доступен через SSL или если в конфигурации инструмента задано - всегда запускать через SSL.

URL-адрес инструмента также может быть задан через адрес HTTPS для принудительного запуска через SSL, тогда это поле может быть пустым.';
$string['selectcontent'] = 'Выбрать содержимое';
$string['selectcontentvalidationerror'] = 'Вы должны выбрать контент для этого элемента.';
$string['send'] = 'Отправить';
$string['services'] = 'Службы';
$string['services_help'] = 'Выберите те службы, которые Вы хотите предъявить поставщику инструмента. Может быть выбрано несколько служб.';
$string['setupoptions'] = 'Параметры настройки';
$string['share_email'] = 'Определять адрес электронной почты пользователя, запускающего инструмент';
$string['share_email_admin'] = 'Определять адрес электронной почты пользователя, запускающего инструмента';
$string['share_email_admin_help'] = 'Определять ли адрес электронной почты пользователя, запускающего инструмент? Он будет использоваться поставщиком инструмента. Поставщику инструмента может понадобиться электронная почта запускающего адреса, чтобы различать пользователей с одинаковым именем, или чтобы по электронной почте отправить пользователю инструкцию по работе с этим инструментом.';
$string['share_email_help'] = 'Укажите, будет ли передаваться поставщику инструмента адрес электронной почты пользователя, запускающего инструмент.

Поставщику инструмента могут понадобиться адреса электронной почты запускающих, чтобы различать пользователей с одинаковым именем, или отправлять им письма по результатам их действий с этим инструментом.

Обратите внимание, что этот параметр может быть переопределен в конфигурации инструмента.';
$string['share_name'] = 'Определять полное имя пользователя, запускающего инструмент';
$string['share_name_admin'] = 'Определять полное имя пользователя, запускающего инструмент';
$string['share_name_admin_help'] = 'Определять ли полное имя пользователя, запускающего инструмент? Оно будет использоваться поставщиком инструмента. Поставщику могут потребоваться имена запускающих инструмент, чтобы отобразить в нём содержательную информацию.';
$string['share_name_help'] = 'Укажите, будет ли передаваться поставщику инструмента полное имя пользователя, запускающего инструмент.

Поставщику инструмента могут потребоваться имена запускающих, чтобы показать определенную информацию в этом инструменте.

Обратите внимание, что этот параметр может быть переопределен в конфигурации инструмента.';
$string['share_roster'] = 'Разрешить инструменту доступ к спискам участников курсов.';
$string['share_roster_admin'] = 'Приложение имеет доступ к спискам участников курсов.';
$string['share_roster_admin_help'] = 'Определите, будет ли этот инструмент иметь доступ к списку пользователей, записанных на курсы, из которых запускается этот инструмент.';
$string['share_roster_help'] = 'Укажите, будет ли этот инструмент иметь доступ к списку пользователей, записанных в данный курс.

Обратите внимание, что этот параметр может быть переопределен в конфигурации инструмента.';
$string['show_in_course_activity_chooser'] = 'Показать в выборе элемента и как предварительно настроенный инструмент';
$string['show_in_course_lti1'] = 'Показать при создании элементов';
$string['show_in_course_lti1_help'] = 'Этот инструмент может быть показан в выборе элементов для учителя, чтобы он мог выбрать и добавить в курс. Он также может быть показан в выпадающем списке предварительно настроенных инструментов при добавлении внешнего инструмента в курс.
Еще одним вариантом является использование конфигурации инструмента только в том случае, если при добавлении внешнего инструмента в курс вводится конкретный URL-адрес инструмента.';
$string['show_in_course_lti2'] = 'Показать при создании элементов';
$string['show_in_course_lti2_help'] = 'Этот инструмент может быть показан учителю в выборе элементов, чтобы его можно было выбрать и добавить в курс, или в выпадающем списке предварительно настроенных инструментов при добавлении внешнего инструмента в курс.';
$string['show_in_course_no'] = 'Не показывать; использовать только при вводе подходящего URL-адреса инструмента';
$string['show_in_course_preconfigured'] = 'Показывать как предварительно настроенный инструмент при добавлении внешнего инструмента';
$string['showinactivitychooser'] = 'Показывать в выборе элементов';
$string['sitehost'] = 'Имя хоста сайта';
$string['siteid'] = 'ID сайта';
$string['size'] = 'Параметры размера';
$string['submission'] = 'Представление';
$string['submissions'] = 'Представления';
$string['submissionsfor'] = 'Ответы для {$a}';
$string['subplugintype_ltiresource'] = 'Ресурс службы LTI';
$string['subplugintype_ltiresource_plural'] = 'Ресурсы служб LTI';
$string['subplugintype_ltiservice'] = 'Служба LTI';
$string['subplugintype_ltiservice_plural'] = 'Службы LTI';
$string['subplugintype_ltisource'] = 'Источник LTI';
$string['subplugintype_ltisource_plural'] = 'Источники LTI';
$string['successfullycreatedtooltype'] = 'Новый инструмент успешно создан!';
$string['successfullyfetchedtoolconfigurationfromcontent'] = 'Инструмент из выбранного содержимого сконфигурирован успешно.';
$string['toggle_debug_data'] = 'Переключить данные отладки';
$string['tool_settings'] = 'Настройки инструмента';
$string['tooldescription'] = 'Описание инструмента';
$string['tooldescription_help'] = 'Описание инструмента, которое будет отображаться учителям в списке элементов.

Оно должно описывать для чего предназначен этот инструмент, что он делает и содержать дополнительную информацию, которую учителю необходимо знать.';
$string['tooldetailsaccesstokenurl'] = 'URL токена доступа';
$string['tooldetailsauthrequesturl'] = 'URL запроса аутентификации';
$string['tooldetailsclientid'] = 'ID клиента';
$string['tooldetailsdeploymentid'] = 'ID размещения';
$string['tooldetailsmailtosubject'] = 'Настройка инструмента LTI';
$string['tooldetailsmodalemail'] = 'Эл. адрес';
$string['tooldetailsmodallink'] = 'Просмотр сведений о конфигурации';
$string['tooldetailsmodaltitle'] = 'Детали конфигурации инструмента';
$string['tooldetailsplatformid'] = 'ID платформы';
$string['tooldetailspublickeyseturl'] = 'URL открытого набора ключей';
$string['toolisbeingused'] = 'Этот инструмент был использован {$a} раз(а)';
$string['toolisnotbeingused'] = 'Этот инструмент еще не был использован';
$string['toolproxy'] = 'Регистрации внешних инструментов';
$string['toolproxy_help'] = 'Регистрации внешних инструментов позволяют администраторам сайта Moodle настроить внешние инструменты с доверенностью инструмента, полученной от поставщика инструмента, поддерживающего LTI 2.0.  Все, что требуется для начала процесса — URL-адрес регистрации, предоставленный поставщиком инструмента. Возможности и службы, предлагаемые поставщиком инструмента, выбираются при настройке новой регистрации.

Регистрации инструментов, перечисленные на этой странице, разделены на четыре категории:

* **Настроенные** — Эти регистрации инструментов были настроены, но процесс регистрации еще не был начат.
* **Ожидаемые** — Процесс регистрации для этих регистраций инструментов был начат, но еще не завершен. Откройте и сохраните настройки, чтобы переместить их обратно в категорию «Настроено».
* **Принятые** — Эти регистрации инструментов были одобрены; ресурсы, указанные в доверенности инструмента, будут появляться на странице «Предварительно настроенные инструменты» с начальным статусом «В ожидании».
* **Отклоненные** — Эти регистрации инструментов были отклонены в процессе регистрации. Откройте и сохраните настройки, чтобы переместить их обратно в категорию «Настроено» для перезапуска процесса регистрации.';
$string['toolproxyregistration'] = 'Регистрация Внешнего инструмента';
$string['toolregistration'] = 'Регистрация Внешнего инструмента';
$string['toolsetup'] = 'Конфигурация внешнего инструмента';
$string['tooltypenotfounderror'] = 'Инструмент LTI, используемый в этом элементе, удален. За помощью обратитесь к своему учителю или администратору сайта.';
$string['tooltypes'] = 'Инструменты';
$string['toolurl'] = 'Базовый URL-адрес инструмента';
$string['toolurl_contentitemselectionrequest'] = 'URL выбора контента';
$string['toolurl_contentitemselectionrequest_help'] = 'URL выбора контента будет использоваться для запуска страницы выбора контента от поставщика инструмента. Если он пуст, будет использован URL инструмента';
$string['toolurl_help'] = 'Базовый URL-адрес инструмента используется для сопоставления URL-адресов запуска инструмента с правильной конфигурацией инструмента. Задание URL  с префиксом http(s) не обязательно.

Кроме того, базовый URL-адрес используется как URL-адрес запуска, если URL-адрес запуска не указан в экземпляре внешнего инструмента.

Например, базовому URL-адресу *tool.com* будут соответствовать следующие:

* tool.com
* tool.com/quizzes
* tool.com/quizzes/quiz.php?id=10
* www.tool.com/quizzes

Базовому URL-адресу *www.tool.com/quizzes* будут соответствовать следующие:

* www.tool.com/quizzes
* tool.com/quizzes
* tool.com/quizzes/take.php?id=10

Базовому URL-адресу *quiz.tool.com* будут соответствовать следующие:

* quiz.tool.com
* quiz.tool.com/take.php?id=10

Если две различные конфигурации инструмента указаны для одного и того же домена, то будет использоваться самое точное соответствие.

Вы также можете вставить URL картриджа, если он у вас есть, и подробности об инструменте будут автоматически заполнены.';
$string['toolurlplaceholder'] = 'URL инструмента...';
$string['typename'] = 'Название инструмента';
$string['typename_help'] = 'Название инструмента используется для идентификации в Moodle поставляемого инструмента. Введенное название будет видно преподавателям при добавлении внешних инструментов в курсы.';
$string['types'] = 'Типы';
$string['unabletocreatetooltype'] = 'Не удается создать инструмент';
$string['unabletofindtooltype'] = 'Не удается найти инструмент для {$a->id}';
$string['unknownstate'] = 'Неизвестное состояние';
$string['update'] = 'Обновить';
$string['usage'] = 'Количество использований';
$string['useraccountinformation'] = 'Информация учетной записи пользователя';
$string['userpersonalinformation'] = 'Личная информация пользователя';
$string['validurl'] = 'Правильный адрес должен начинаться с http(s)://';
$string['viewsubmissions'] = 'Экран просмотра представлений и оценок';
